/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/automl/v1beta1/data_items.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.automl.v1beta1;

/**
 *
 *
 * <pre>
 * Example data used for training or prediction.
 * </pre>
 *
 * Protobuf type {@code google.cloud.automl.v1beta1.ExamplePayload}
 */
public final class ExamplePayload extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.automl.v1beta1.ExamplePayload)
    ExamplePayloadOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ExamplePayload.newBuilder() to construct.
  private ExamplePayload(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ExamplePayload() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ExamplePayload();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.automl.v1beta1.DataItems
        .internal_static_google_cloud_automl_v1beta1_ExamplePayload_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.automl.v1beta1.DataItems
        .internal_static_google_cloud_automl_v1beta1_ExamplePayload_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.automl.v1beta1.ExamplePayload.class,
            com.google.cloud.automl.v1beta1.ExamplePayload.Builder.class);
  }

  private int payloadCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object payload_;

  public enum PayloadCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    IMAGE(1),
    TEXT_SNIPPET(2),
    DOCUMENT(4),
    ROW(3),
    PAYLOAD_NOT_SET(0);
    private final int value;

    private PayloadCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PayloadCase valueOf(int value) {
      return forNumber(value);
    }

    public static PayloadCase forNumber(int value) {
      switch (value) {
        case 1:
          return IMAGE;
        case 2:
          return TEXT_SNIPPET;
        case 4:
          return DOCUMENT;
        case 3:
          return ROW;
        case 0:
          return PAYLOAD_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public PayloadCase getPayloadCase() {
    return PayloadCase.forNumber(payloadCase_);
  }

  public static final int IMAGE_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Example image.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.Image image = 1;</code>
   *
   * @return Whether the image field is set.
   */
  @java.lang.Override
  public boolean hasImage() {
    return payloadCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Example image.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.Image image = 1;</code>
   *
   * @return The image.
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.Image getImage() {
    if (payloadCase_ == 1) {
      return (com.google.cloud.automl.v1beta1.Image) payload_;
    }
    return com.google.cloud.automl.v1beta1.Image.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Example image.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.Image image = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.ImageOrBuilder getImageOrBuilder() {
    if (payloadCase_ == 1) {
      return (com.google.cloud.automl.v1beta1.Image) payload_;
    }
    return com.google.cloud.automl.v1beta1.Image.getDefaultInstance();
  }

  public static final int TEXT_SNIPPET_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Example text.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.TextSnippet text_snippet = 2;</code>
   *
   * @return Whether the textSnippet field is set.
   */
  @java.lang.Override
  public boolean hasTextSnippet() {
    return payloadCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Example text.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.TextSnippet text_snippet = 2;</code>
   *
   * @return The textSnippet.
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.TextSnippet getTextSnippet() {
    if (payloadCase_ == 2) {
      return (com.google.cloud.automl.v1beta1.TextSnippet) payload_;
    }
    return com.google.cloud.automl.v1beta1.TextSnippet.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Example text.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.TextSnippet text_snippet = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.TextSnippetOrBuilder getTextSnippetOrBuilder() {
    if (payloadCase_ == 2) {
      return (com.google.cloud.automl.v1beta1.TextSnippet) payload_;
    }
    return com.google.cloud.automl.v1beta1.TextSnippet.getDefaultInstance();
  }

  public static final int DOCUMENT_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Example document.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.Document document = 4;</code>
   *
   * @return Whether the document field is set.
   */
  @java.lang.Override
  public boolean hasDocument() {
    return payloadCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Example document.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.Document document = 4;</code>
   *
   * @return The document.
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.Document getDocument() {
    if (payloadCase_ == 4) {
      return (com.google.cloud.automl.v1beta1.Document) payload_;
    }
    return com.google.cloud.automl.v1beta1.Document.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Example document.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.Document document = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.DocumentOrBuilder getDocumentOrBuilder() {
    if (payloadCase_ == 4) {
      return (com.google.cloud.automl.v1beta1.Document) payload_;
    }
    return com.google.cloud.automl.v1beta1.Document.getDefaultInstance();
  }

  public static final int ROW_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Example relational table row.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.Row row = 3;</code>
   *
   * @return Whether the row field is set.
   */
  @java.lang.Override
  public boolean hasRow() {
    return payloadCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Example relational table row.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.Row row = 3;</code>
   *
   * @return The row.
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.Row getRow() {
    if (payloadCase_ == 3) {
      return (com.google.cloud.automl.v1beta1.Row) payload_;
    }
    return com.google.cloud.automl.v1beta1.Row.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Example relational table row.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.Row row = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.RowOrBuilder getRowOrBuilder() {
    if (payloadCase_ == 3) {
      return (com.google.cloud.automl.v1beta1.Row) payload_;
    }
    return com.google.cloud.automl.v1beta1.Row.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (payloadCase_ == 1) {
      output.writeMessage(1, (com.google.cloud.automl.v1beta1.Image) payload_);
    }
    if (payloadCase_ == 2) {
      output.writeMessage(2, (com.google.cloud.automl.v1beta1.TextSnippet) payload_);
    }
    if (payloadCase_ == 3) {
      output.writeMessage(3, (com.google.cloud.automl.v1beta1.Row) payload_);
    }
    if (payloadCase_ == 4) {
      output.writeMessage(4, (com.google.cloud.automl.v1beta1.Document) payload_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (payloadCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.cloud.automl.v1beta1.Image) payload_);
    }
    if (payloadCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.automl.v1beta1.TextSnippet) payload_);
    }
    if (payloadCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.automl.v1beta1.Row) payload_);
    }
    if (payloadCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.automl.v1beta1.Document) payload_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.automl.v1beta1.ExamplePayload)) {
      return super.equals(obj);
    }
    com.google.cloud.automl.v1beta1.ExamplePayload other =
        (com.google.cloud.automl.v1beta1.ExamplePayload) obj;

    if (!getPayloadCase().equals(other.getPayloadCase())) return false;
    switch (payloadCase_) {
      case 1:
        if (!getImage().equals(other.getImage())) return false;
        break;
      case 2:
        if (!getTextSnippet().equals(other.getTextSnippet())) return false;
        break;
      case 4:
        if (!getDocument().equals(other.getDocument())) return false;
        break;
      case 3:
        if (!getRow().equals(other.getRow())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (payloadCase_) {
      case 1:
        hash = (37 * hash) + IMAGE_FIELD_NUMBER;
        hash = (53 * hash) + getImage().hashCode();
        break;
      case 2:
        hash = (37 * hash) + TEXT_SNIPPET_FIELD_NUMBER;
        hash = (53 * hash) + getTextSnippet().hashCode();
        break;
      case 4:
        hash = (37 * hash) + DOCUMENT_FIELD_NUMBER;
        hash = (53 * hash) + getDocument().hashCode();
        break;
      case 3:
        hash = (37 * hash) + ROW_FIELD_NUMBER;
        hash = (53 * hash) + getRow().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.automl.v1beta1.ExamplePayload parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1beta1.ExamplePayload parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.ExamplePayload parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1beta1.ExamplePayload parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.ExamplePayload parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1beta1.ExamplePayload parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.ExamplePayload parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1beta1.ExamplePayload parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.ExamplePayload parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1beta1.ExamplePayload parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.ExamplePayload parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1beta1.ExamplePayload parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.automl.v1beta1.ExamplePayload prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Example data used for training or prediction.
   * </pre>
   *
   * Protobuf type {@code google.cloud.automl.v1beta1.ExamplePayload}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.automl.v1beta1.ExamplePayload)
      com.google.cloud.automl.v1beta1.ExamplePayloadOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.automl.v1beta1.DataItems
          .internal_static_google_cloud_automl_v1beta1_ExamplePayload_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.automl.v1beta1.DataItems
          .internal_static_google_cloud_automl_v1beta1_ExamplePayload_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.automl.v1beta1.ExamplePayload.class,
              com.google.cloud.automl.v1beta1.ExamplePayload.Builder.class);
    }

    // Construct using com.google.cloud.automl.v1beta1.ExamplePayload.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (imageBuilder_ != null) {
        imageBuilder_.clear();
      }
      if (textSnippetBuilder_ != null) {
        textSnippetBuilder_.clear();
      }
      if (documentBuilder_ != null) {
        documentBuilder_.clear();
      }
      if (rowBuilder_ != null) {
        rowBuilder_.clear();
      }
      payloadCase_ = 0;
      payload_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.automl.v1beta1.DataItems
          .internal_static_google_cloud_automl_v1beta1_ExamplePayload_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.ExamplePayload getDefaultInstanceForType() {
      return com.google.cloud.automl.v1beta1.ExamplePayload.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.ExamplePayload build() {
      com.google.cloud.automl.v1beta1.ExamplePayload result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.ExamplePayload buildPartial() {
      com.google.cloud.automl.v1beta1.ExamplePayload result =
          new com.google.cloud.automl.v1beta1.ExamplePayload(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.automl.v1beta1.ExamplePayload result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.automl.v1beta1.ExamplePayload result) {
      result.payloadCase_ = payloadCase_;
      result.payload_ = this.payload_;
      if (payloadCase_ == 1 && imageBuilder_ != null) {
        result.payload_ = imageBuilder_.build();
      }
      if (payloadCase_ == 2 && textSnippetBuilder_ != null) {
        result.payload_ = textSnippetBuilder_.build();
      }
      if (payloadCase_ == 4 && documentBuilder_ != null) {
        result.payload_ = documentBuilder_.build();
      }
      if (payloadCase_ == 3 && rowBuilder_ != null) {
        result.payload_ = rowBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.automl.v1beta1.ExamplePayload) {
        return mergeFrom((com.google.cloud.automl.v1beta1.ExamplePayload) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.automl.v1beta1.ExamplePayload other) {
      if (other == com.google.cloud.automl.v1beta1.ExamplePayload.getDefaultInstance()) return this;
      switch (other.getPayloadCase()) {
        case IMAGE:
          {
            mergeImage(other.getImage());
            break;
          }
        case TEXT_SNIPPET:
          {
            mergeTextSnippet(other.getTextSnippet());
            break;
          }
        case DOCUMENT:
          {
            mergeDocument(other.getDocument());
            break;
          }
        case ROW:
          {
            mergeRow(other.getRow());
            break;
          }
        case PAYLOAD_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getImageFieldBuilder().getBuilder(), extensionRegistry);
                payloadCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getTextSnippetFieldBuilder().getBuilder(), extensionRegistry);
                payloadCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getRowFieldBuilder().getBuilder(), extensionRegistry);
                payloadCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getDocumentFieldBuilder().getBuilder(), extensionRegistry);
                payloadCase_ = 4;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int payloadCase_ = 0;
    private java.lang.Object payload_;

    public PayloadCase getPayloadCase() {
      return PayloadCase.forNumber(payloadCase_);
    }

    public Builder clearPayload() {
      payloadCase_ = 0;
      payload_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.Image,
            com.google.cloud.automl.v1beta1.Image.Builder,
            com.google.cloud.automl.v1beta1.ImageOrBuilder>
        imageBuilder_;
    /**
     *
     *
     * <pre>
     * Example image.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.Image image = 1;</code>
     *
     * @return Whether the image field is set.
     */
    @java.lang.Override
    public boolean hasImage() {
      return payloadCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Example image.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.Image image = 1;</code>
     *
     * @return The image.
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.Image getImage() {
      if (imageBuilder_ == null) {
        if (payloadCase_ == 1) {
          return (com.google.cloud.automl.v1beta1.Image) payload_;
        }
        return com.google.cloud.automl.v1beta1.Image.getDefaultInstance();
      } else {
        if (payloadCase_ == 1) {
          return imageBuilder_.getMessage();
        }
        return com.google.cloud.automl.v1beta1.Image.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Example image.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.Image image = 1;</code>
     */
    public Builder setImage(com.google.cloud.automl.v1beta1.Image value) {
      if (imageBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        payload_ = value;
        onChanged();
      } else {
        imageBuilder_.setMessage(value);
      }
      payloadCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Example image.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.Image image = 1;</code>
     */
    public Builder setImage(com.google.cloud.automl.v1beta1.Image.Builder builderForValue) {
      if (imageBuilder_ == null) {
        payload_ = builderForValue.build();
        onChanged();
      } else {
        imageBuilder_.setMessage(builderForValue.build());
      }
      payloadCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Example image.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.Image image = 1;</code>
     */
    public Builder mergeImage(com.google.cloud.automl.v1beta1.Image value) {
      if (imageBuilder_ == null) {
        if (payloadCase_ == 1
            && payload_ != com.google.cloud.automl.v1beta1.Image.getDefaultInstance()) {
          payload_ =
              com.google.cloud.automl.v1beta1.Image.newBuilder(
                      (com.google.cloud.automl.v1beta1.Image) payload_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          payload_ = value;
        }
        onChanged();
      } else {
        if (payloadCase_ == 1) {
          imageBuilder_.mergeFrom(value);
        } else {
          imageBuilder_.setMessage(value);
        }
      }
      payloadCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Example image.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.Image image = 1;</code>
     */
    public Builder clearImage() {
      if (imageBuilder_ == null) {
        if (payloadCase_ == 1) {
          payloadCase_ = 0;
          payload_ = null;
          onChanged();
        }
      } else {
        if (payloadCase_ == 1) {
          payloadCase_ = 0;
          payload_ = null;
        }
        imageBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Example image.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.Image image = 1;</code>
     */
    public com.google.cloud.automl.v1beta1.Image.Builder getImageBuilder() {
      return getImageFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Example image.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.Image image = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.ImageOrBuilder getImageOrBuilder() {
      if ((payloadCase_ == 1) && (imageBuilder_ != null)) {
        return imageBuilder_.getMessageOrBuilder();
      } else {
        if (payloadCase_ == 1) {
          return (com.google.cloud.automl.v1beta1.Image) payload_;
        }
        return com.google.cloud.automl.v1beta1.Image.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Example image.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.Image image = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.Image,
            com.google.cloud.automl.v1beta1.Image.Builder,
            com.google.cloud.automl.v1beta1.ImageOrBuilder>
        getImageFieldBuilder() {
      if (imageBuilder_ == null) {
        if (!(payloadCase_ == 1)) {
          payload_ = com.google.cloud.automl.v1beta1.Image.getDefaultInstance();
        }
        imageBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.automl.v1beta1.Image,
                com.google.cloud.automl.v1beta1.Image.Builder,
                com.google.cloud.automl.v1beta1.ImageOrBuilder>(
                (com.google.cloud.automl.v1beta1.Image) payload_,
                getParentForChildren(),
                isClean());
        payload_ = null;
      }
      payloadCase_ = 1;
      onChanged();
      return imageBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.TextSnippet,
            com.google.cloud.automl.v1beta1.TextSnippet.Builder,
            com.google.cloud.automl.v1beta1.TextSnippetOrBuilder>
        textSnippetBuilder_;
    /**
     *
     *
     * <pre>
     * Example text.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.TextSnippet text_snippet = 2;</code>
     *
     * @return Whether the textSnippet field is set.
     */
    @java.lang.Override
    public boolean hasTextSnippet() {
      return payloadCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Example text.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.TextSnippet text_snippet = 2;</code>
     *
     * @return The textSnippet.
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.TextSnippet getTextSnippet() {
      if (textSnippetBuilder_ == null) {
        if (payloadCase_ == 2) {
          return (com.google.cloud.automl.v1beta1.TextSnippet) payload_;
        }
        return com.google.cloud.automl.v1beta1.TextSnippet.getDefaultInstance();
      } else {
        if (payloadCase_ == 2) {
          return textSnippetBuilder_.getMessage();
        }
        return com.google.cloud.automl.v1beta1.TextSnippet.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Example text.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.TextSnippet text_snippet = 2;</code>
     */
    public Builder setTextSnippet(com.google.cloud.automl.v1beta1.TextSnippet value) {
      if (textSnippetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        payload_ = value;
        onChanged();
      } else {
        textSnippetBuilder_.setMessage(value);
      }
      payloadCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Example text.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.TextSnippet text_snippet = 2;</code>
     */
    public Builder setTextSnippet(
        com.google.cloud.automl.v1beta1.TextSnippet.Builder builderForValue) {
      if (textSnippetBuilder_ == null) {
        payload_ = builderForValue.build();
        onChanged();
      } else {
        textSnippetBuilder_.setMessage(builderForValue.build());
      }
      payloadCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Example text.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.TextSnippet text_snippet = 2;</code>
     */
    public Builder mergeTextSnippet(com.google.cloud.automl.v1beta1.TextSnippet value) {
      if (textSnippetBuilder_ == null) {
        if (payloadCase_ == 2
            && payload_ != com.google.cloud.automl.v1beta1.TextSnippet.getDefaultInstance()) {
          payload_ =
              com.google.cloud.automl.v1beta1.TextSnippet.newBuilder(
                      (com.google.cloud.automl.v1beta1.TextSnippet) payload_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          payload_ = value;
        }
        onChanged();
      } else {
        if (payloadCase_ == 2) {
          textSnippetBuilder_.mergeFrom(value);
        } else {
          textSnippetBuilder_.setMessage(value);
        }
      }
      payloadCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Example text.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.TextSnippet text_snippet = 2;</code>
     */
    public Builder clearTextSnippet() {
      if (textSnippetBuilder_ == null) {
        if (payloadCase_ == 2) {
          payloadCase_ = 0;
          payload_ = null;
          onChanged();
        }
      } else {
        if (payloadCase_ == 2) {
          payloadCase_ = 0;
          payload_ = null;
        }
        textSnippetBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Example text.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.TextSnippet text_snippet = 2;</code>
     */
    public com.google.cloud.automl.v1beta1.TextSnippet.Builder getTextSnippetBuilder() {
      return getTextSnippetFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Example text.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.TextSnippet text_snippet = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.TextSnippetOrBuilder getTextSnippetOrBuilder() {
      if ((payloadCase_ == 2) && (textSnippetBuilder_ != null)) {
        return textSnippetBuilder_.getMessageOrBuilder();
      } else {
        if (payloadCase_ == 2) {
          return (com.google.cloud.automl.v1beta1.TextSnippet) payload_;
        }
        return com.google.cloud.automl.v1beta1.TextSnippet.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Example text.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.TextSnippet text_snippet = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.TextSnippet,
            com.google.cloud.automl.v1beta1.TextSnippet.Builder,
            com.google.cloud.automl.v1beta1.TextSnippetOrBuilder>
        getTextSnippetFieldBuilder() {
      if (textSnippetBuilder_ == null) {
        if (!(payloadCase_ == 2)) {
          payload_ = com.google.cloud.automl.v1beta1.TextSnippet.getDefaultInstance();
        }
        textSnippetBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.automl.v1beta1.TextSnippet,
                com.google.cloud.automl.v1beta1.TextSnippet.Builder,
                com.google.cloud.automl.v1beta1.TextSnippetOrBuilder>(
                (com.google.cloud.automl.v1beta1.TextSnippet) payload_,
                getParentForChildren(),
                isClean());
        payload_ = null;
      }
      payloadCase_ = 2;
      onChanged();
      return textSnippetBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.Document,
            com.google.cloud.automl.v1beta1.Document.Builder,
            com.google.cloud.automl.v1beta1.DocumentOrBuilder>
        documentBuilder_;
    /**
     *
     *
     * <pre>
     * Example document.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.Document document = 4;</code>
     *
     * @return Whether the document field is set.
     */
    @java.lang.Override
    public boolean hasDocument() {
      return payloadCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Example document.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.Document document = 4;</code>
     *
     * @return The document.
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.Document getDocument() {
      if (documentBuilder_ == null) {
        if (payloadCase_ == 4) {
          return (com.google.cloud.automl.v1beta1.Document) payload_;
        }
        return com.google.cloud.automl.v1beta1.Document.getDefaultInstance();
      } else {
        if (payloadCase_ == 4) {
          return documentBuilder_.getMessage();
        }
        return com.google.cloud.automl.v1beta1.Document.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Example document.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.Document document = 4;</code>
     */
    public Builder setDocument(com.google.cloud.automl.v1beta1.Document value) {
      if (documentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        payload_ = value;
        onChanged();
      } else {
        documentBuilder_.setMessage(value);
      }
      payloadCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Example document.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.Document document = 4;</code>
     */
    public Builder setDocument(com.google.cloud.automl.v1beta1.Document.Builder builderForValue) {
      if (documentBuilder_ == null) {
        payload_ = builderForValue.build();
        onChanged();
      } else {
        documentBuilder_.setMessage(builderForValue.build());
      }
      payloadCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Example document.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.Document document = 4;</code>
     */
    public Builder mergeDocument(com.google.cloud.automl.v1beta1.Document value) {
      if (documentBuilder_ == null) {
        if (payloadCase_ == 4
            && payload_ != com.google.cloud.automl.v1beta1.Document.getDefaultInstance()) {
          payload_ =
              com.google.cloud.automl.v1beta1.Document.newBuilder(
                      (com.google.cloud.automl.v1beta1.Document) payload_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          payload_ = value;
        }
        onChanged();
      } else {
        if (payloadCase_ == 4) {
          documentBuilder_.mergeFrom(value);
        } else {
          documentBuilder_.setMessage(value);
        }
      }
      payloadCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Example document.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.Document document = 4;</code>
     */
    public Builder clearDocument() {
      if (documentBuilder_ == null) {
        if (payloadCase_ == 4) {
          payloadCase_ = 0;
          payload_ = null;
          onChanged();
        }
      } else {
        if (payloadCase_ == 4) {
          payloadCase_ = 0;
          payload_ = null;
        }
        documentBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Example document.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.Document document = 4;</code>
     */
    public com.google.cloud.automl.v1beta1.Document.Builder getDocumentBuilder() {
      return getDocumentFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Example document.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.Document document = 4;</code>
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.DocumentOrBuilder getDocumentOrBuilder() {
      if ((payloadCase_ == 4) && (documentBuilder_ != null)) {
        return documentBuilder_.getMessageOrBuilder();
      } else {
        if (payloadCase_ == 4) {
          return (com.google.cloud.automl.v1beta1.Document) payload_;
        }
        return com.google.cloud.automl.v1beta1.Document.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Example document.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.Document document = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.Document,
            com.google.cloud.automl.v1beta1.Document.Builder,
            com.google.cloud.automl.v1beta1.DocumentOrBuilder>
        getDocumentFieldBuilder() {
      if (documentBuilder_ == null) {
        if (!(payloadCase_ == 4)) {
          payload_ = com.google.cloud.automl.v1beta1.Document.getDefaultInstance();
        }
        documentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.automl.v1beta1.Document,
                com.google.cloud.automl.v1beta1.Document.Builder,
                com.google.cloud.automl.v1beta1.DocumentOrBuilder>(
                (com.google.cloud.automl.v1beta1.Document) payload_,
                getParentForChildren(),
                isClean());
        payload_ = null;
      }
      payloadCase_ = 4;
      onChanged();
      return documentBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.Row,
            com.google.cloud.automl.v1beta1.Row.Builder,
            com.google.cloud.automl.v1beta1.RowOrBuilder>
        rowBuilder_;
    /**
     *
     *
     * <pre>
     * Example relational table row.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.Row row = 3;</code>
     *
     * @return Whether the row field is set.
     */
    @java.lang.Override
    public boolean hasRow() {
      return payloadCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Example relational table row.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.Row row = 3;</code>
     *
     * @return The row.
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.Row getRow() {
      if (rowBuilder_ == null) {
        if (payloadCase_ == 3) {
          return (com.google.cloud.automl.v1beta1.Row) payload_;
        }
        return com.google.cloud.automl.v1beta1.Row.getDefaultInstance();
      } else {
        if (payloadCase_ == 3) {
          return rowBuilder_.getMessage();
        }
        return com.google.cloud.automl.v1beta1.Row.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Example relational table row.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.Row row = 3;</code>
     */
    public Builder setRow(com.google.cloud.automl.v1beta1.Row value) {
      if (rowBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        payload_ = value;
        onChanged();
      } else {
        rowBuilder_.setMessage(value);
      }
      payloadCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Example relational table row.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.Row row = 3;</code>
     */
    public Builder setRow(com.google.cloud.automl.v1beta1.Row.Builder builderForValue) {
      if (rowBuilder_ == null) {
        payload_ = builderForValue.build();
        onChanged();
      } else {
        rowBuilder_.setMessage(builderForValue.build());
      }
      payloadCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Example relational table row.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.Row row = 3;</code>
     */
    public Builder mergeRow(com.google.cloud.automl.v1beta1.Row value) {
      if (rowBuilder_ == null) {
        if (payloadCase_ == 3
            && payload_ != com.google.cloud.automl.v1beta1.Row.getDefaultInstance()) {
          payload_ =
              com.google.cloud.automl.v1beta1.Row.newBuilder(
                      (com.google.cloud.automl.v1beta1.Row) payload_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          payload_ = value;
        }
        onChanged();
      } else {
        if (payloadCase_ == 3) {
          rowBuilder_.mergeFrom(value);
        } else {
          rowBuilder_.setMessage(value);
        }
      }
      payloadCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Example relational table row.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.Row row = 3;</code>
     */
    public Builder clearRow() {
      if (rowBuilder_ == null) {
        if (payloadCase_ == 3) {
          payloadCase_ = 0;
          payload_ = null;
          onChanged();
        }
      } else {
        if (payloadCase_ == 3) {
          payloadCase_ = 0;
          payload_ = null;
        }
        rowBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Example relational table row.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.Row row = 3;</code>
     */
    public com.google.cloud.automl.v1beta1.Row.Builder getRowBuilder() {
      return getRowFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Example relational table row.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.Row row = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.RowOrBuilder getRowOrBuilder() {
      if ((payloadCase_ == 3) && (rowBuilder_ != null)) {
        return rowBuilder_.getMessageOrBuilder();
      } else {
        if (payloadCase_ == 3) {
          return (com.google.cloud.automl.v1beta1.Row) payload_;
        }
        return com.google.cloud.automl.v1beta1.Row.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Example relational table row.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.Row row = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.Row,
            com.google.cloud.automl.v1beta1.Row.Builder,
            com.google.cloud.automl.v1beta1.RowOrBuilder>
        getRowFieldBuilder() {
      if (rowBuilder_ == null) {
        if (!(payloadCase_ == 3)) {
          payload_ = com.google.cloud.automl.v1beta1.Row.getDefaultInstance();
        }
        rowBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.automl.v1beta1.Row,
                com.google.cloud.automl.v1beta1.Row.Builder,
                com.google.cloud.automl.v1beta1.RowOrBuilder>(
                (com.google.cloud.automl.v1beta1.Row) payload_, getParentForChildren(), isClean());
        payload_ = null;
      }
      payloadCase_ = 3;
      onChanged();
      return rowBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.automl.v1beta1.ExamplePayload)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.automl.v1beta1.ExamplePayload)
  private static final com.google.cloud.automl.v1beta1.ExamplePayload DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.automl.v1beta1.ExamplePayload();
  }

  public static com.google.cloud.automl.v1beta1.ExamplePayload getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ExamplePayload> PARSER =
      new com.google.protobuf.AbstractParser<ExamplePayload>() {
        @java.lang.Override
        public ExamplePayload parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ExamplePayload> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ExamplePayload> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.automl.v1beta1.ExamplePayload getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
