/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/automl/v1beta1/operations.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.automl.v1beta1;

/**
 *
 *
 * <pre>
 * Metadata used across all long running operations returned by AutoML API.
 * </pre>
 *
 * Protobuf type {@code google.cloud.automl.v1beta1.OperationMetadata}
 */
public final class OperationMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.automl.v1beta1.OperationMetadata)
    OperationMetadataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use OperationMetadata.newBuilder() to construct.
  private OperationMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private OperationMetadata() {
    partialFailures_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new OperationMetadata();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.automl.v1beta1.Operations
        .internal_static_google_cloud_automl_v1beta1_OperationMetadata_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.automl.v1beta1.Operations
        .internal_static_google_cloud_automl_v1beta1_OperationMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.automl.v1beta1.OperationMetadata.class,
            com.google.cloud.automl.v1beta1.OperationMetadata.Builder.class);
  }

  private int bitField0_;
  private int detailsCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object details_;

  public enum DetailsCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    DELETE_DETAILS(8),
    DEPLOY_MODEL_DETAILS(24),
    UNDEPLOY_MODEL_DETAILS(25),
    CREATE_MODEL_DETAILS(10),
    IMPORT_DATA_DETAILS(15),
    BATCH_PREDICT_DETAILS(16),
    EXPORT_DATA_DETAILS(21),
    EXPORT_MODEL_DETAILS(22),
    EXPORT_EVALUATED_EXAMPLES_DETAILS(26),
    DETAILS_NOT_SET(0);
    private final int value;

    private DetailsCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DetailsCase valueOf(int value) {
      return forNumber(value);
    }

    public static DetailsCase forNumber(int value) {
      switch (value) {
        case 8:
          return DELETE_DETAILS;
        case 24:
          return DEPLOY_MODEL_DETAILS;
        case 25:
          return UNDEPLOY_MODEL_DETAILS;
        case 10:
          return CREATE_MODEL_DETAILS;
        case 15:
          return IMPORT_DATA_DETAILS;
        case 16:
          return BATCH_PREDICT_DETAILS;
        case 21:
          return EXPORT_DATA_DETAILS;
        case 22:
          return EXPORT_MODEL_DETAILS;
        case 26:
          return EXPORT_EVALUATED_EXAMPLES_DETAILS;
        case 0:
          return DETAILS_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public DetailsCase getDetailsCase() {
    return DetailsCase.forNumber(detailsCase_);
  }

  public static final int DELETE_DETAILS_FIELD_NUMBER = 8;
  /**
   *
   *
   * <pre>
   * Details of a Delete operation.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.DeleteOperationMetadata delete_details = 8;</code>
   *
   * @return Whether the deleteDetails field is set.
   */
  @java.lang.Override
  public boolean hasDeleteDetails() {
    return detailsCase_ == 8;
  }
  /**
   *
   *
   * <pre>
   * Details of a Delete operation.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.DeleteOperationMetadata delete_details = 8;</code>
   *
   * @return The deleteDetails.
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.DeleteOperationMetadata getDeleteDetails() {
    if (detailsCase_ == 8) {
      return (com.google.cloud.automl.v1beta1.DeleteOperationMetadata) details_;
    }
    return com.google.cloud.automl.v1beta1.DeleteOperationMetadata.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Details of a Delete operation.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.DeleteOperationMetadata delete_details = 8;</code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.DeleteOperationMetadataOrBuilder
      getDeleteDetailsOrBuilder() {
    if (detailsCase_ == 8) {
      return (com.google.cloud.automl.v1beta1.DeleteOperationMetadata) details_;
    }
    return com.google.cloud.automl.v1beta1.DeleteOperationMetadata.getDefaultInstance();
  }

  public static final int DEPLOY_MODEL_DETAILS_FIELD_NUMBER = 24;
  /**
   *
   *
   * <pre>
   * Details of a DeployModel operation.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.DeployModelOperationMetadata deploy_model_details = 24;
   * </code>
   *
   * @return Whether the deployModelDetails field is set.
   */
  @java.lang.Override
  public boolean hasDeployModelDetails() {
    return detailsCase_ == 24;
  }
  /**
   *
   *
   * <pre>
   * Details of a DeployModel operation.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.DeployModelOperationMetadata deploy_model_details = 24;
   * </code>
   *
   * @return The deployModelDetails.
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.DeployModelOperationMetadata getDeployModelDetails() {
    if (detailsCase_ == 24) {
      return (com.google.cloud.automl.v1beta1.DeployModelOperationMetadata) details_;
    }
    return com.google.cloud.automl.v1beta1.DeployModelOperationMetadata.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Details of a DeployModel operation.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.DeployModelOperationMetadata deploy_model_details = 24;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.DeployModelOperationMetadataOrBuilder
      getDeployModelDetailsOrBuilder() {
    if (detailsCase_ == 24) {
      return (com.google.cloud.automl.v1beta1.DeployModelOperationMetadata) details_;
    }
    return com.google.cloud.automl.v1beta1.DeployModelOperationMetadata.getDefaultInstance();
  }

  public static final int UNDEPLOY_MODEL_DETAILS_FIELD_NUMBER = 25;
  /**
   *
   *
   * <pre>
   * Details of an UndeployModel operation.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.UndeployModelOperationMetadata undeploy_model_details = 25;
   * </code>
   *
   * @return Whether the undeployModelDetails field is set.
   */
  @java.lang.Override
  public boolean hasUndeployModelDetails() {
    return detailsCase_ == 25;
  }
  /**
   *
   *
   * <pre>
   * Details of an UndeployModel operation.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.UndeployModelOperationMetadata undeploy_model_details = 25;
   * </code>
   *
   * @return The undeployModelDetails.
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.UndeployModelOperationMetadata getUndeployModelDetails() {
    if (detailsCase_ == 25) {
      return (com.google.cloud.automl.v1beta1.UndeployModelOperationMetadata) details_;
    }
    return com.google.cloud.automl.v1beta1.UndeployModelOperationMetadata.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Details of an UndeployModel operation.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.UndeployModelOperationMetadata undeploy_model_details = 25;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.UndeployModelOperationMetadataOrBuilder
      getUndeployModelDetailsOrBuilder() {
    if (detailsCase_ == 25) {
      return (com.google.cloud.automl.v1beta1.UndeployModelOperationMetadata) details_;
    }
    return com.google.cloud.automl.v1beta1.UndeployModelOperationMetadata.getDefaultInstance();
  }

  public static final int CREATE_MODEL_DETAILS_FIELD_NUMBER = 10;
  /**
   *
   *
   * <pre>
   * Details of CreateModel operation.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.CreateModelOperationMetadata create_model_details = 10;
   * </code>
   *
   * @return Whether the createModelDetails field is set.
   */
  @java.lang.Override
  public boolean hasCreateModelDetails() {
    return detailsCase_ == 10;
  }
  /**
   *
   *
   * <pre>
   * Details of CreateModel operation.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.CreateModelOperationMetadata create_model_details = 10;
   * </code>
   *
   * @return The createModelDetails.
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.CreateModelOperationMetadata getCreateModelDetails() {
    if (detailsCase_ == 10) {
      return (com.google.cloud.automl.v1beta1.CreateModelOperationMetadata) details_;
    }
    return com.google.cloud.automl.v1beta1.CreateModelOperationMetadata.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Details of CreateModel operation.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.CreateModelOperationMetadata create_model_details = 10;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.CreateModelOperationMetadataOrBuilder
      getCreateModelDetailsOrBuilder() {
    if (detailsCase_ == 10) {
      return (com.google.cloud.automl.v1beta1.CreateModelOperationMetadata) details_;
    }
    return com.google.cloud.automl.v1beta1.CreateModelOperationMetadata.getDefaultInstance();
  }

  public static final int IMPORT_DATA_DETAILS_FIELD_NUMBER = 15;
  /**
   *
   *
   * <pre>
   * Details of ImportData operation.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.ImportDataOperationMetadata import_data_details = 15;</code>
   *
   * @return Whether the importDataDetails field is set.
   */
  @java.lang.Override
  public boolean hasImportDataDetails() {
    return detailsCase_ == 15;
  }
  /**
   *
   *
   * <pre>
   * Details of ImportData operation.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.ImportDataOperationMetadata import_data_details = 15;</code>
   *
   * @return The importDataDetails.
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.ImportDataOperationMetadata getImportDataDetails() {
    if (detailsCase_ == 15) {
      return (com.google.cloud.automl.v1beta1.ImportDataOperationMetadata) details_;
    }
    return com.google.cloud.automl.v1beta1.ImportDataOperationMetadata.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Details of ImportData operation.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.ImportDataOperationMetadata import_data_details = 15;</code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.ImportDataOperationMetadataOrBuilder
      getImportDataDetailsOrBuilder() {
    if (detailsCase_ == 15) {
      return (com.google.cloud.automl.v1beta1.ImportDataOperationMetadata) details_;
    }
    return com.google.cloud.automl.v1beta1.ImportDataOperationMetadata.getDefaultInstance();
  }

  public static final int BATCH_PREDICT_DETAILS_FIELD_NUMBER = 16;
  /**
   *
   *
   * <pre>
   * Details of BatchPredict operation.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.BatchPredictOperationMetadata batch_predict_details = 16;
   * </code>
   *
   * @return Whether the batchPredictDetails field is set.
   */
  @java.lang.Override
  public boolean hasBatchPredictDetails() {
    return detailsCase_ == 16;
  }
  /**
   *
   *
   * <pre>
   * Details of BatchPredict operation.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.BatchPredictOperationMetadata batch_predict_details = 16;
   * </code>
   *
   * @return The batchPredictDetails.
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.BatchPredictOperationMetadata getBatchPredictDetails() {
    if (detailsCase_ == 16) {
      return (com.google.cloud.automl.v1beta1.BatchPredictOperationMetadata) details_;
    }
    return com.google.cloud.automl.v1beta1.BatchPredictOperationMetadata.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Details of BatchPredict operation.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.BatchPredictOperationMetadata batch_predict_details = 16;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.BatchPredictOperationMetadataOrBuilder
      getBatchPredictDetailsOrBuilder() {
    if (detailsCase_ == 16) {
      return (com.google.cloud.automl.v1beta1.BatchPredictOperationMetadata) details_;
    }
    return com.google.cloud.automl.v1beta1.BatchPredictOperationMetadata.getDefaultInstance();
  }

  public static final int EXPORT_DATA_DETAILS_FIELD_NUMBER = 21;
  /**
   *
   *
   * <pre>
   * Details of ExportData operation.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.ExportDataOperationMetadata export_data_details = 21;</code>
   *
   * @return Whether the exportDataDetails field is set.
   */
  @java.lang.Override
  public boolean hasExportDataDetails() {
    return detailsCase_ == 21;
  }
  /**
   *
   *
   * <pre>
   * Details of ExportData operation.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.ExportDataOperationMetadata export_data_details = 21;</code>
   *
   * @return The exportDataDetails.
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.ExportDataOperationMetadata getExportDataDetails() {
    if (detailsCase_ == 21) {
      return (com.google.cloud.automl.v1beta1.ExportDataOperationMetadata) details_;
    }
    return com.google.cloud.automl.v1beta1.ExportDataOperationMetadata.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Details of ExportData operation.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.ExportDataOperationMetadata export_data_details = 21;</code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.ExportDataOperationMetadataOrBuilder
      getExportDataDetailsOrBuilder() {
    if (detailsCase_ == 21) {
      return (com.google.cloud.automl.v1beta1.ExportDataOperationMetadata) details_;
    }
    return com.google.cloud.automl.v1beta1.ExportDataOperationMetadata.getDefaultInstance();
  }

  public static final int EXPORT_MODEL_DETAILS_FIELD_NUMBER = 22;
  /**
   *
   *
   * <pre>
   * Details of ExportModel operation.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.ExportModelOperationMetadata export_model_details = 22;
   * </code>
   *
   * @return Whether the exportModelDetails field is set.
   */
  @java.lang.Override
  public boolean hasExportModelDetails() {
    return detailsCase_ == 22;
  }
  /**
   *
   *
   * <pre>
   * Details of ExportModel operation.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.ExportModelOperationMetadata export_model_details = 22;
   * </code>
   *
   * @return The exportModelDetails.
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.ExportModelOperationMetadata getExportModelDetails() {
    if (detailsCase_ == 22) {
      return (com.google.cloud.automl.v1beta1.ExportModelOperationMetadata) details_;
    }
    return com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Details of ExportModel operation.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.ExportModelOperationMetadata export_model_details = 22;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.ExportModelOperationMetadataOrBuilder
      getExportModelDetailsOrBuilder() {
    if (detailsCase_ == 22) {
      return (com.google.cloud.automl.v1beta1.ExportModelOperationMetadata) details_;
    }
    return com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.getDefaultInstance();
  }

  public static final int EXPORT_EVALUATED_EXAMPLES_DETAILS_FIELD_NUMBER = 26;
  /**
   *
   *
   * <pre>
   * Details of ExportEvaluatedExamples operation.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.ExportEvaluatedExamplesOperationMetadata export_evaluated_examples_details = 26;
   * </code>
   *
   * @return Whether the exportEvaluatedExamplesDetails field is set.
   */
  @java.lang.Override
  public boolean hasExportEvaluatedExamplesDetails() {
    return detailsCase_ == 26;
  }
  /**
   *
   *
   * <pre>
   * Details of ExportEvaluatedExamples operation.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.ExportEvaluatedExamplesOperationMetadata export_evaluated_examples_details = 26;
   * </code>
   *
   * @return The exportEvaluatedExamplesDetails.
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.ExportEvaluatedExamplesOperationMetadata
      getExportEvaluatedExamplesDetails() {
    if (detailsCase_ == 26) {
      return (com.google.cloud.automl.v1beta1.ExportEvaluatedExamplesOperationMetadata) details_;
    }
    return com.google.cloud.automl.v1beta1.ExportEvaluatedExamplesOperationMetadata
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Details of ExportEvaluatedExamples operation.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.ExportEvaluatedExamplesOperationMetadata export_evaluated_examples_details = 26;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.ExportEvaluatedExamplesOperationMetadataOrBuilder
      getExportEvaluatedExamplesDetailsOrBuilder() {
    if (detailsCase_ == 26) {
      return (com.google.cloud.automl.v1beta1.ExportEvaluatedExamplesOperationMetadata) details_;
    }
    return com.google.cloud.automl.v1beta1.ExportEvaluatedExamplesOperationMetadata
        .getDefaultInstance();
  }

  public static final int PROGRESS_PERCENT_FIELD_NUMBER = 13;
  private int progressPercent_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. Progress of operation. Range: [0, 100].
   * Not used currently.
   * </pre>
   *
   * <code>int32 progress_percent = 13;</code>
   *
   * @return The progressPercent.
   */
  @java.lang.Override
  public int getProgressPercent() {
    return progressPercent_;
  }

  public static final int PARTIAL_FAILURES_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.rpc.Status> partialFailures_;
  /**
   *
   *
   * <pre>
   * Output only. Partial failures encountered.
   * E.g. single files that couldn't be read.
   * This field should never exceed 20 entries.
   * Status details field will contain standard GCP error details.
   * </pre>
   *
   * <code>repeated .google.rpc.Status partial_failures = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.rpc.Status> getPartialFailuresList() {
    return partialFailures_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Partial failures encountered.
   * E.g. single files that couldn't be read.
   * This field should never exceed 20 entries.
   * Status details field will contain standard GCP error details.
   * </pre>
   *
   * <code>repeated .google.rpc.Status partial_failures = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.rpc.StatusOrBuilder>
      getPartialFailuresOrBuilderList() {
    return partialFailures_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Partial failures encountered.
   * E.g. single files that couldn't be read.
   * This field should never exceed 20 entries.
   * Status details field will contain standard GCP error details.
   * </pre>
   *
   * <code>repeated .google.rpc.Status partial_failures = 2;</code>
   */
  @java.lang.Override
  public int getPartialFailuresCount() {
    return partialFailures_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Partial failures encountered.
   * E.g. single files that couldn't be read.
   * This field should never exceed 20 entries.
   * Status details field will contain standard GCP error details.
   * </pre>
   *
   * <code>repeated .google.rpc.Status partial_failures = 2;</code>
   */
  @java.lang.Override
  public com.google.rpc.Status getPartialFailures(int index) {
    return partialFailures_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. Partial failures encountered.
   * E.g. single files that couldn't be read.
   * This field should never exceed 20 entries.
   * Status details field will contain standard GCP error details.
   * </pre>
   *
   * <code>repeated .google.rpc.Status partial_failures = 2;</code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getPartialFailuresOrBuilder(int index) {
    return partialFailures_.get(index);
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time when the operation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3;</code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the operation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3;</code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the operation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time when the operation was updated for the last time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4;</code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the operation was updated for the last time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4;</code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the operation was updated for the last time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < partialFailures_.size(); i++) {
      output.writeMessage(2, partialFailures_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(4, getUpdateTime());
    }
    if (detailsCase_ == 8) {
      output.writeMessage(8, (com.google.cloud.automl.v1beta1.DeleteOperationMetadata) details_);
    }
    if (detailsCase_ == 10) {
      output.writeMessage(
          10, (com.google.cloud.automl.v1beta1.CreateModelOperationMetadata) details_);
    }
    if (progressPercent_ != 0) {
      output.writeInt32(13, progressPercent_);
    }
    if (detailsCase_ == 15) {
      output.writeMessage(
          15, (com.google.cloud.automl.v1beta1.ImportDataOperationMetadata) details_);
    }
    if (detailsCase_ == 16) {
      output.writeMessage(
          16, (com.google.cloud.automl.v1beta1.BatchPredictOperationMetadata) details_);
    }
    if (detailsCase_ == 21) {
      output.writeMessage(
          21, (com.google.cloud.automl.v1beta1.ExportDataOperationMetadata) details_);
    }
    if (detailsCase_ == 22) {
      output.writeMessage(
          22, (com.google.cloud.automl.v1beta1.ExportModelOperationMetadata) details_);
    }
    if (detailsCase_ == 24) {
      output.writeMessage(
          24, (com.google.cloud.automl.v1beta1.DeployModelOperationMetadata) details_);
    }
    if (detailsCase_ == 25) {
      output.writeMessage(
          25, (com.google.cloud.automl.v1beta1.UndeployModelOperationMetadata) details_);
    }
    if (detailsCase_ == 26) {
      output.writeMessage(
          26, (com.google.cloud.automl.v1beta1.ExportEvaluatedExamplesOperationMetadata) details_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < partialFailures_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, partialFailures_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getUpdateTime());
    }
    if (detailsCase_ == 8) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, (com.google.cloud.automl.v1beta1.DeleteOperationMetadata) details_);
    }
    if (detailsCase_ == 10) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              10, (com.google.cloud.automl.v1beta1.CreateModelOperationMetadata) details_);
    }
    if (progressPercent_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(13, progressPercent_);
    }
    if (detailsCase_ == 15) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              15, (com.google.cloud.automl.v1beta1.ImportDataOperationMetadata) details_);
    }
    if (detailsCase_ == 16) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              16, (com.google.cloud.automl.v1beta1.BatchPredictOperationMetadata) details_);
    }
    if (detailsCase_ == 21) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              21, (com.google.cloud.automl.v1beta1.ExportDataOperationMetadata) details_);
    }
    if (detailsCase_ == 22) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              22, (com.google.cloud.automl.v1beta1.ExportModelOperationMetadata) details_);
    }
    if (detailsCase_ == 24) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              24, (com.google.cloud.automl.v1beta1.DeployModelOperationMetadata) details_);
    }
    if (detailsCase_ == 25) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              25, (com.google.cloud.automl.v1beta1.UndeployModelOperationMetadata) details_);
    }
    if (detailsCase_ == 26) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              26,
              (com.google.cloud.automl.v1beta1.ExportEvaluatedExamplesOperationMetadata) details_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.automl.v1beta1.OperationMetadata)) {
      return super.equals(obj);
    }
    com.google.cloud.automl.v1beta1.OperationMetadata other =
        (com.google.cloud.automl.v1beta1.OperationMetadata) obj;

    if (getProgressPercent() != other.getProgressPercent()) return false;
    if (!getPartialFailuresList().equals(other.getPartialFailuresList())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getDetailsCase().equals(other.getDetailsCase())) return false;
    switch (detailsCase_) {
      case 8:
        if (!getDeleteDetails().equals(other.getDeleteDetails())) return false;
        break;
      case 24:
        if (!getDeployModelDetails().equals(other.getDeployModelDetails())) return false;
        break;
      case 25:
        if (!getUndeployModelDetails().equals(other.getUndeployModelDetails())) return false;
        break;
      case 10:
        if (!getCreateModelDetails().equals(other.getCreateModelDetails())) return false;
        break;
      case 15:
        if (!getImportDataDetails().equals(other.getImportDataDetails())) return false;
        break;
      case 16:
        if (!getBatchPredictDetails().equals(other.getBatchPredictDetails())) return false;
        break;
      case 21:
        if (!getExportDataDetails().equals(other.getExportDataDetails())) return false;
        break;
      case 22:
        if (!getExportModelDetails().equals(other.getExportModelDetails())) return false;
        break;
      case 26:
        if (!getExportEvaluatedExamplesDetails().equals(other.getExportEvaluatedExamplesDetails()))
          return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PROGRESS_PERCENT_FIELD_NUMBER;
    hash = (53 * hash) + getProgressPercent();
    if (getPartialFailuresCount() > 0) {
      hash = (37 * hash) + PARTIAL_FAILURES_FIELD_NUMBER;
      hash = (53 * hash) + getPartialFailuresList().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    switch (detailsCase_) {
      case 8:
        hash = (37 * hash) + DELETE_DETAILS_FIELD_NUMBER;
        hash = (53 * hash) + getDeleteDetails().hashCode();
        break;
      case 24:
        hash = (37 * hash) + DEPLOY_MODEL_DETAILS_FIELD_NUMBER;
        hash = (53 * hash) + getDeployModelDetails().hashCode();
        break;
      case 25:
        hash = (37 * hash) + UNDEPLOY_MODEL_DETAILS_FIELD_NUMBER;
        hash = (53 * hash) + getUndeployModelDetails().hashCode();
        break;
      case 10:
        hash = (37 * hash) + CREATE_MODEL_DETAILS_FIELD_NUMBER;
        hash = (53 * hash) + getCreateModelDetails().hashCode();
        break;
      case 15:
        hash = (37 * hash) + IMPORT_DATA_DETAILS_FIELD_NUMBER;
        hash = (53 * hash) + getImportDataDetails().hashCode();
        break;
      case 16:
        hash = (37 * hash) + BATCH_PREDICT_DETAILS_FIELD_NUMBER;
        hash = (53 * hash) + getBatchPredictDetails().hashCode();
        break;
      case 21:
        hash = (37 * hash) + EXPORT_DATA_DETAILS_FIELD_NUMBER;
        hash = (53 * hash) + getExportDataDetails().hashCode();
        break;
      case 22:
        hash = (37 * hash) + EXPORT_MODEL_DETAILS_FIELD_NUMBER;
        hash = (53 * hash) + getExportModelDetails().hashCode();
        break;
      case 26:
        hash = (37 * hash) + EXPORT_EVALUATED_EXAMPLES_DETAILS_FIELD_NUMBER;
        hash = (53 * hash) + getExportEvaluatedExamplesDetails().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.automl.v1beta1.OperationMetadata parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1beta1.OperationMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.OperationMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1beta1.OperationMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.OperationMetadata parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1beta1.OperationMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.OperationMetadata parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1beta1.OperationMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.OperationMetadata parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1beta1.OperationMetadata parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.OperationMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1beta1.OperationMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.automl.v1beta1.OperationMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Metadata used across all long running operations returned by AutoML API.
   * </pre>
   *
   * Protobuf type {@code google.cloud.automl.v1beta1.OperationMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.automl.v1beta1.OperationMetadata)
      com.google.cloud.automl.v1beta1.OperationMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.automl.v1beta1.Operations
          .internal_static_google_cloud_automl_v1beta1_OperationMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.automl.v1beta1.Operations
          .internal_static_google_cloud_automl_v1beta1_OperationMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.automl.v1beta1.OperationMetadata.class,
              com.google.cloud.automl.v1beta1.OperationMetadata.Builder.class);
    }

    // Construct using com.google.cloud.automl.v1beta1.OperationMetadata.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getPartialFailuresFieldBuilder();
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (deleteDetailsBuilder_ != null) {
        deleteDetailsBuilder_.clear();
      }
      if (deployModelDetailsBuilder_ != null) {
        deployModelDetailsBuilder_.clear();
      }
      if (undeployModelDetailsBuilder_ != null) {
        undeployModelDetailsBuilder_.clear();
      }
      if (createModelDetailsBuilder_ != null) {
        createModelDetailsBuilder_.clear();
      }
      if (importDataDetailsBuilder_ != null) {
        importDataDetailsBuilder_.clear();
      }
      if (batchPredictDetailsBuilder_ != null) {
        batchPredictDetailsBuilder_.clear();
      }
      if (exportDataDetailsBuilder_ != null) {
        exportDataDetailsBuilder_.clear();
      }
      if (exportModelDetailsBuilder_ != null) {
        exportModelDetailsBuilder_.clear();
      }
      if (exportEvaluatedExamplesDetailsBuilder_ != null) {
        exportEvaluatedExamplesDetailsBuilder_.clear();
      }
      progressPercent_ = 0;
      if (partialFailuresBuilder_ == null) {
        partialFailures_ = java.util.Collections.emptyList();
      } else {
        partialFailures_ = null;
        partialFailuresBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000400);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      detailsCase_ = 0;
      details_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.automl.v1beta1.Operations
          .internal_static_google_cloud_automl_v1beta1_OperationMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.OperationMetadata getDefaultInstanceForType() {
      return com.google.cloud.automl.v1beta1.OperationMetadata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.OperationMetadata build() {
      com.google.cloud.automl.v1beta1.OperationMetadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.OperationMetadata buildPartial() {
      com.google.cloud.automl.v1beta1.OperationMetadata result =
          new com.google.cloud.automl.v1beta1.OperationMetadata(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.automl.v1beta1.OperationMetadata result) {
      if (partialFailuresBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)) {
          partialFailures_ = java.util.Collections.unmodifiableList(partialFailures_);
          bitField0_ = (bitField0_ & ~0x00000400);
        }
        result.partialFailures_ = partialFailures_;
      } else {
        result.partialFailures_ = partialFailuresBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.automl.v1beta1.OperationMetadata result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.progressPercent_ = progressPercent_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.automl.v1beta1.OperationMetadata result) {
      result.detailsCase_ = detailsCase_;
      result.details_ = this.details_;
      if (detailsCase_ == 8 && deleteDetailsBuilder_ != null) {
        result.details_ = deleteDetailsBuilder_.build();
      }
      if (detailsCase_ == 24 && deployModelDetailsBuilder_ != null) {
        result.details_ = deployModelDetailsBuilder_.build();
      }
      if (detailsCase_ == 25 && undeployModelDetailsBuilder_ != null) {
        result.details_ = undeployModelDetailsBuilder_.build();
      }
      if (detailsCase_ == 10 && createModelDetailsBuilder_ != null) {
        result.details_ = createModelDetailsBuilder_.build();
      }
      if (detailsCase_ == 15 && importDataDetailsBuilder_ != null) {
        result.details_ = importDataDetailsBuilder_.build();
      }
      if (detailsCase_ == 16 && batchPredictDetailsBuilder_ != null) {
        result.details_ = batchPredictDetailsBuilder_.build();
      }
      if (detailsCase_ == 21 && exportDataDetailsBuilder_ != null) {
        result.details_ = exportDataDetailsBuilder_.build();
      }
      if (detailsCase_ == 22 && exportModelDetailsBuilder_ != null) {
        result.details_ = exportModelDetailsBuilder_.build();
      }
      if (detailsCase_ == 26 && exportEvaluatedExamplesDetailsBuilder_ != null) {
        result.details_ = exportEvaluatedExamplesDetailsBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.automl.v1beta1.OperationMetadata) {
        return mergeFrom((com.google.cloud.automl.v1beta1.OperationMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.automl.v1beta1.OperationMetadata other) {
      if (other == com.google.cloud.automl.v1beta1.OperationMetadata.getDefaultInstance())
        return this;
      if (other.getProgressPercent() != 0) {
        setProgressPercent(other.getProgressPercent());
      }
      if (partialFailuresBuilder_ == null) {
        if (!other.partialFailures_.isEmpty()) {
          if (partialFailures_.isEmpty()) {
            partialFailures_ = other.partialFailures_;
            bitField0_ = (bitField0_ & ~0x00000400);
          } else {
            ensurePartialFailuresIsMutable();
            partialFailures_.addAll(other.partialFailures_);
          }
          onChanged();
        }
      } else {
        if (!other.partialFailures_.isEmpty()) {
          if (partialFailuresBuilder_.isEmpty()) {
            partialFailuresBuilder_.dispose();
            partialFailuresBuilder_ = null;
            partialFailures_ = other.partialFailures_;
            bitField0_ = (bitField0_ & ~0x00000400);
            partialFailuresBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPartialFailuresFieldBuilder()
                    : null;
          } else {
            partialFailuresBuilder_.addAllMessages(other.partialFailures_);
          }
        }
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      switch (other.getDetailsCase()) {
        case DELETE_DETAILS:
          {
            mergeDeleteDetails(other.getDeleteDetails());
            break;
          }
        case DEPLOY_MODEL_DETAILS:
          {
            mergeDeployModelDetails(other.getDeployModelDetails());
            break;
          }
        case UNDEPLOY_MODEL_DETAILS:
          {
            mergeUndeployModelDetails(other.getUndeployModelDetails());
            break;
          }
        case CREATE_MODEL_DETAILS:
          {
            mergeCreateModelDetails(other.getCreateModelDetails());
            break;
          }
        case IMPORT_DATA_DETAILS:
          {
            mergeImportDataDetails(other.getImportDataDetails());
            break;
          }
        case BATCH_PREDICT_DETAILS:
          {
            mergeBatchPredictDetails(other.getBatchPredictDetails());
            break;
          }
        case EXPORT_DATA_DETAILS:
          {
            mergeExportDataDetails(other.getExportDataDetails());
            break;
          }
        case EXPORT_MODEL_DETAILS:
          {
            mergeExportModelDetails(other.getExportModelDetails());
            break;
          }
        case EXPORT_EVALUATED_EXAMPLES_DETAILS:
          {
            mergeExportEvaluatedExamplesDetails(other.getExportEvaluatedExamplesDetails());
            break;
          }
        case DETAILS_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 18:
              {
                com.google.rpc.Status m =
                    input.readMessage(com.google.rpc.Status.parser(), extensionRegistry);
                if (partialFailuresBuilder_ == null) {
                  ensurePartialFailuresIsMutable();
                  partialFailures_.add(m);
                } else {
                  partialFailuresBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00001000;
                break;
              } // case 34
            case 66:
              {
                input.readMessage(getDeleteDetailsFieldBuilder().getBuilder(), extensionRegistry);
                detailsCase_ = 8;
                break;
              } // case 66
            case 82:
              {
                input.readMessage(
                    getCreateModelDetailsFieldBuilder().getBuilder(), extensionRegistry);
                detailsCase_ = 10;
                break;
              } // case 82
            case 104:
              {
                progressPercent_ = input.readInt32();
                bitField0_ |= 0x00000200;
                break;
              } // case 104
            case 122:
              {
                input.readMessage(
                    getImportDataDetailsFieldBuilder().getBuilder(), extensionRegistry);
                detailsCase_ = 15;
                break;
              } // case 122
            case 130:
              {
                input.readMessage(
                    getBatchPredictDetailsFieldBuilder().getBuilder(), extensionRegistry);
                detailsCase_ = 16;
                break;
              } // case 130
            case 170:
              {
                input.readMessage(
                    getExportDataDetailsFieldBuilder().getBuilder(), extensionRegistry);
                detailsCase_ = 21;
                break;
              } // case 170
            case 178:
              {
                input.readMessage(
                    getExportModelDetailsFieldBuilder().getBuilder(), extensionRegistry);
                detailsCase_ = 22;
                break;
              } // case 178
            case 194:
              {
                input.readMessage(
                    getDeployModelDetailsFieldBuilder().getBuilder(), extensionRegistry);
                detailsCase_ = 24;
                break;
              } // case 194
            case 202:
              {
                input.readMessage(
                    getUndeployModelDetailsFieldBuilder().getBuilder(), extensionRegistry);
                detailsCase_ = 25;
                break;
              } // case 202
            case 210:
              {
                input.readMessage(
                    getExportEvaluatedExamplesDetailsFieldBuilder().getBuilder(),
                    extensionRegistry);
                detailsCase_ = 26;
                break;
              } // case 210
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int detailsCase_ = 0;
    private java.lang.Object details_;

    public DetailsCase getDetailsCase() {
      return DetailsCase.forNumber(detailsCase_);
    }

    public Builder clearDetails() {
      detailsCase_ = 0;
      details_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.DeleteOperationMetadata,
            com.google.cloud.automl.v1beta1.DeleteOperationMetadata.Builder,
            com.google.cloud.automl.v1beta1.DeleteOperationMetadataOrBuilder>
        deleteDetailsBuilder_;
    /**
     *
     *
     * <pre>
     * Details of a Delete operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DeleteOperationMetadata delete_details = 8;</code>
     *
     * @return Whether the deleteDetails field is set.
     */
    @java.lang.Override
    public boolean hasDeleteDetails() {
      return detailsCase_ == 8;
    }
    /**
     *
     *
     * <pre>
     * Details of a Delete operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DeleteOperationMetadata delete_details = 8;</code>
     *
     * @return The deleteDetails.
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.DeleteOperationMetadata getDeleteDetails() {
      if (deleteDetailsBuilder_ == null) {
        if (detailsCase_ == 8) {
          return (com.google.cloud.automl.v1beta1.DeleteOperationMetadata) details_;
        }
        return com.google.cloud.automl.v1beta1.DeleteOperationMetadata.getDefaultInstance();
      } else {
        if (detailsCase_ == 8) {
          return deleteDetailsBuilder_.getMessage();
        }
        return com.google.cloud.automl.v1beta1.DeleteOperationMetadata.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Details of a Delete operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DeleteOperationMetadata delete_details = 8;</code>
     */
    public Builder setDeleteDetails(com.google.cloud.automl.v1beta1.DeleteOperationMetadata value) {
      if (deleteDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        details_ = value;
        onChanged();
      } else {
        deleteDetailsBuilder_.setMessage(value);
      }
      detailsCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of a Delete operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DeleteOperationMetadata delete_details = 8;</code>
     */
    public Builder setDeleteDetails(
        com.google.cloud.automl.v1beta1.DeleteOperationMetadata.Builder builderForValue) {
      if (deleteDetailsBuilder_ == null) {
        details_ = builderForValue.build();
        onChanged();
      } else {
        deleteDetailsBuilder_.setMessage(builderForValue.build());
      }
      detailsCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of a Delete operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DeleteOperationMetadata delete_details = 8;</code>
     */
    public Builder mergeDeleteDetails(
        com.google.cloud.automl.v1beta1.DeleteOperationMetadata value) {
      if (deleteDetailsBuilder_ == null) {
        if (detailsCase_ == 8
            && details_
                != com.google.cloud.automl.v1beta1.DeleteOperationMetadata.getDefaultInstance()) {
          details_ =
              com.google.cloud.automl.v1beta1.DeleteOperationMetadata.newBuilder(
                      (com.google.cloud.automl.v1beta1.DeleteOperationMetadata) details_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          details_ = value;
        }
        onChanged();
      } else {
        if (detailsCase_ == 8) {
          deleteDetailsBuilder_.mergeFrom(value);
        } else {
          deleteDetailsBuilder_.setMessage(value);
        }
      }
      detailsCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of a Delete operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DeleteOperationMetadata delete_details = 8;</code>
     */
    public Builder clearDeleteDetails() {
      if (deleteDetailsBuilder_ == null) {
        if (detailsCase_ == 8) {
          detailsCase_ = 0;
          details_ = null;
          onChanged();
        }
      } else {
        if (detailsCase_ == 8) {
          detailsCase_ = 0;
          details_ = null;
        }
        deleteDetailsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of a Delete operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DeleteOperationMetadata delete_details = 8;</code>
     */
    public com.google.cloud.automl.v1beta1.DeleteOperationMetadata.Builder
        getDeleteDetailsBuilder() {
      return getDeleteDetailsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Details of a Delete operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DeleteOperationMetadata delete_details = 8;</code>
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.DeleteOperationMetadataOrBuilder
        getDeleteDetailsOrBuilder() {
      if ((detailsCase_ == 8) && (deleteDetailsBuilder_ != null)) {
        return deleteDetailsBuilder_.getMessageOrBuilder();
      } else {
        if (detailsCase_ == 8) {
          return (com.google.cloud.automl.v1beta1.DeleteOperationMetadata) details_;
        }
        return com.google.cloud.automl.v1beta1.DeleteOperationMetadata.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Details of a Delete operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DeleteOperationMetadata delete_details = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.DeleteOperationMetadata,
            com.google.cloud.automl.v1beta1.DeleteOperationMetadata.Builder,
            com.google.cloud.automl.v1beta1.DeleteOperationMetadataOrBuilder>
        getDeleteDetailsFieldBuilder() {
      if (deleteDetailsBuilder_ == null) {
        if (!(detailsCase_ == 8)) {
          details_ = com.google.cloud.automl.v1beta1.DeleteOperationMetadata.getDefaultInstance();
        }
        deleteDetailsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.automl.v1beta1.DeleteOperationMetadata,
                com.google.cloud.automl.v1beta1.DeleteOperationMetadata.Builder,
                com.google.cloud.automl.v1beta1.DeleteOperationMetadataOrBuilder>(
                (com.google.cloud.automl.v1beta1.DeleteOperationMetadata) details_,
                getParentForChildren(),
                isClean());
        details_ = null;
      }
      detailsCase_ = 8;
      onChanged();
      return deleteDetailsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.DeployModelOperationMetadata,
            com.google.cloud.automl.v1beta1.DeployModelOperationMetadata.Builder,
            com.google.cloud.automl.v1beta1.DeployModelOperationMetadataOrBuilder>
        deployModelDetailsBuilder_;
    /**
     *
     *
     * <pre>
     * Details of a DeployModel operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DeployModelOperationMetadata deploy_model_details = 24;
     * </code>
     *
     * @return Whether the deployModelDetails field is set.
     */
    @java.lang.Override
    public boolean hasDeployModelDetails() {
      return detailsCase_ == 24;
    }
    /**
     *
     *
     * <pre>
     * Details of a DeployModel operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DeployModelOperationMetadata deploy_model_details = 24;
     * </code>
     *
     * @return The deployModelDetails.
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.DeployModelOperationMetadata getDeployModelDetails() {
      if (deployModelDetailsBuilder_ == null) {
        if (detailsCase_ == 24) {
          return (com.google.cloud.automl.v1beta1.DeployModelOperationMetadata) details_;
        }
        return com.google.cloud.automl.v1beta1.DeployModelOperationMetadata.getDefaultInstance();
      } else {
        if (detailsCase_ == 24) {
          return deployModelDetailsBuilder_.getMessage();
        }
        return com.google.cloud.automl.v1beta1.DeployModelOperationMetadata.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Details of a DeployModel operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DeployModelOperationMetadata deploy_model_details = 24;
     * </code>
     */
    public Builder setDeployModelDetails(
        com.google.cloud.automl.v1beta1.DeployModelOperationMetadata value) {
      if (deployModelDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        details_ = value;
        onChanged();
      } else {
        deployModelDetailsBuilder_.setMessage(value);
      }
      detailsCase_ = 24;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of a DeployModel operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DeployModelOperationMetadata deploy_model_details = 24;
     * </code>
     */
    public Builder setDeployModelDetails(
        com.google.cloud.automl.v1beta1.DeployModelOperationMetadata.Builder builderForValue) {
      if (deployModelDetailsBuilder_ == null) {
        details_ = builderForValue.build();
        onChanged();
      } else {
        deployModelDetailsBuilder_.setMessage(builderForValue.build());
      }
      detailsCase_ = 24;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of a DeployModel operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DeployModelOperationMetadata deploy_model_details = 24;
     * </code>
     */
    public Builder mergeDeployModelDetails(
        com.google.cloud.automl.v1beta1.DeployModelOperationMetadata value) {
      if (deployModelDetailsBuilder_ == null) {
        if (detailsCase_ == 24
            && details_
                != com.google.cloud.automl.v1beta1.DeployModelOperationMetadata
                    .getDefaultInstance()) {
          details_ =
              com.google.cloud.automl.v1beta1.DeployModelOperationMetadata.newBuilder(
                      (com.google.cloud.automl.v1beta1.DeployModelOperationMetadata) details_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          details_ = value;
        }
        onChanged();
      } else {
        if (detailsCase_ == 24) {
          deployModelDetailsBuilder_.mergeFrom(value);
        } else {
          deployModelDetailsBuilder_.setMessage(value);
        }
      }
      detailsCase_ = 24;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of a DeployModel operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DeployModelOperationMetadata deploy_model_details = 24;
     * </code>
     */
    public Builder clearDeployModelDetails() {
      if (deployModelDetailsBuilder_ == null) {
        if (detailsCase_ == 24) {
          detailsCase_ = 0;
          details_ = null;
          onChanged();
        }
      } else {
        if (detailsCase_ == 24) {
          detailsCase_ = 0;
          details_ = null;
        }
        deployModelDetailsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of a DeployModel operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DeployModelOperationMetadata deploy_model_details = 24;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.DeployModelOperationMetadata.Builder
        getDeployModelDetailsBuilder() {
      return getDeployModelDetailsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Details of a DeployModel operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DeployModelOperationMetadata deploy_model_details = 24;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.DeployModelOperationMetadataOrBuilder
        getDeployModelDetailsOrBuilder() {
      if ((detailsCase_ == 24) && (deployModelDetailsBuilder_ != null)) {
        return deployModelDetailsBuilder_.getMessageOrBuilder();
      } else {
        if (detailsCase_ == 24) {
          return (com.google.cloud.automl.v1beta1.DeployModelOperationMetadata) details_;
        }
        return com.google.cloud.automl.v1beta1.DeployModelOperationMetadata.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Details of a DeployModel operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DeployModelOperationMetadata deploy_model_details = 24;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.DeployModelOperationMetadata,
            com.google.cloud.automl.v1beta1.DeployModelOperationMetadata.Builder,
            com.google.cloud.automl.v1beta1.DeployModelOperationMetadataOrBuilder>
        getDeployModelDetailsFieldBuilder() {
      if (deployModelDetailsBuilder_ == null) {
        if (!(detailsCase_ == 24)) {
          details_ =
              com.google.cloud.automl.v1beta1.DeployModelOperationMetadata.getDefaultInstance();
        }
        deployModelDetailsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.automl.v1beta1.DeployModelOperationMetadata,
                com.google.cloud.automl.v1beta1.DeployModelOperationMetadata.Builder,
                com.google.cloud.automl.v1beta1.DeployModelOperationMetadataOrBuilder>(
                (com.google.cloud.automl.v1beta1.DeployModelOperationMetadata) details_,
                getParentForChildren(),
                isClean());
        details_ = null;
      }
      detailsCase_ = 24;
      onChanged();
      return deployModelDetailsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.UndeployModelOperationMetadata,
            com.google.cloud.automl.v1beta1.UndeployModelOperationMetadata.Builder,
            com.google.cloud.automl.v1beta1.UndeployModelOperationMetadataOrBuilder>
        undeployModelDetailsBuilder_;
    /**
     *
     *
     * <pre>
     * Details of an UndeployModel operation.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.UndeployModelOperationMetadata undeploy_model_details = 25;
     * </code>
     *
     * @return Whether the undeployModelDetails field is set.
     */
    @java.lang.Override
    public boolean hasUndeployModelDetails() {
      return detailsCase_ == 25;
    }
    /**
     *
     *
     * <pre>
     * Details of an UndeployModel operation.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.UndeployModelOperationMetadata undeploy_model_details = 25;
     * </code>
     *
     * @return The undeployModelDetails.
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.UndeployModelOperationMetadata
        getUndeployModelDetails() {
      if (undeployModelDetailsBuilder_ == null) {
        if (detailsCase_ == 25) {
          return (com.google.cloud.automl.v1beta1.UndeployModelOperationMetadata) details_;
        }
        return com.google.cloud.automl.v1beta1.UndeployModelOperationMetadata.getDefaultInstance();
      } else {
        if (detailsCase_ == 25) {
          return undeployModelDetailsBuilder_.getMessage();
        }
        return com.google.cloud.automl.v1beta1.UndeployModelOperationMetadata.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Details of an UndeployModel operation.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.UndeployModelOperationMetadata undeploy_model_details = 25;
     * </code>
     */
    public Builder setUndeployModelDetails(
        com.google.cloud.automl.v1beta1.UndeployModelOperationMetadata value) {
      if (undeployModelDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        details_ = value;
        onChanged();
      } else {
        undeployModelDetailsBuilder_.setMessage(value);
      }
      detailsCase_ = 25;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of an UndeployModel operation.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.UndeployModelOperationMetadata undeploy_model_details = 25;
     * </code>
     */
    public Builder setUndeployModelDetails(
        com.google.cloud.automl.v1beta1.UndeployModelOperationMetadata.Builder builderForValue) {
      if (undeployModelDetailsBuilder_ == null) {
        details_ = builderForValue.build();
        onChanged();
      } else {
        undeployModelDetailsBuilder_.setMessage(builderForValue.build());
      }
      detailsCase_ = 25;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of an UndeployModel operation.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.UndeployModelOperationMetadata undeploy_model_details = 25;
     * </code>
     */
    public Builder mergeUndeployModelDetails(
        com.google.cloud.automl.v1beta1.UndeployModelOperationMetadata value) {
      if (undeployModelDetailsBuilder_ == null) {
        if (detailsCase_ == 25
            && details_
                != com.google.cloud.automl.v1beta1.UndeployModelOperationMetadata
                    .getDefaultInstance()) {
          details_ =
              com.google.cloud.automl.v1beta1.UndeployModelOperationMetadata.newBuilder(
                      (com.google.cloud.automl.v1beta1.UndeployModelOperationMetadata) details_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          details_ = value;
        }
        onChanged();
      } else {
        if (detailsCase_ == 25) {
          undeployModelDetailsBuilder_.mergeFrom(value);
        } else {
          undeployModelDetailsBuilder_.setMessage(value);
        }
      }
      detailsCase_ = 25;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of an UndeployModel operation.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.UndeployModelOperationMetadata undeploy_model_details = 25;
     * </code>
     */
    public Builder clearUndeployModelDetails() {
      if (undeployModelDetailsBuilder_ == null) {
        if (detailsCase_ == 25) {
          detailsCase_ = 0;
          details_ = null;
          onChanged();
        }
      } else {
        if (detailsCase_ == 25) {
          detailsCase_ = 0;
          details_ = null;
        }
        undeployModelDetailsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of an UndeployModel operation.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.UndeployModelOperationMetadata undeploy_model_details = 25;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.UndeployModelOperationMetadata.Builder
        getUndeployModelDetailsBuilder() {
      return getUndeployModelDetailsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Details of an UndeployModel operation.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.UndeployModelOperationMetadata undeploy_model_details = 25;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.UndeployModelOperationMetadataOrBuilder
        getUndeployModelDetailsOrBuilder() {
      if ((detailsCase_ == 25) && (undeployModelDetailsBuilder_ != null)) {
        return undeployModelDetailsBuilder_.getMessageOrBuilder();
      } else {
        if (detailsCase_ == 25) {
          return (com.google.cloud.automl.v1beta1.UndeployModelOperationMetadata) details_;
        }
        return com.google.cloud.automl.v1beta1.UndeployModelOperationMetadata.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Details of an UndeployModel operation.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.UndeployModelOperationMetadata undeploy_model_details = 25;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.UndeployModelOperationMetadata,
            com.google.cloud.automl.v1beta1.UndeployModelOperationMetadata.Builder,
            com.google.cloud.automl.v1beta1.UndeployModelOperationMetadataOrBuilder>
        getUndeployModelDetailsFieldBuilder() {
      if (undeployModelDetailsBuilder_ == null) {
        if (!(detailsCase_ == 25)) {
          details_ =
              com.google.cloud.automl.v1beta1.UndeployModelOperationMetadata.getDefaultInstance();
        }
        undeployModelDetailsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.automl.v1beta1.UndeployModelOperationMetadata,
                com.google.cloud.automl.v1beta1.UndeployModelOperationMetadata.Builder,
                com.google.cloud.automl.v1beta1.UndeployModelOperationMetadataOrBuilder>(
                (com.google.cloud.automl.v1beta1.UndeployModelOperationMetadata) details_,
                getParentForChildren(),
                isClean());
        details_ = null;
      }
      detailsCase_ = 25;
      onChanged();
      return undeployModelDetailsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.CreateModelOperationMetadata,
            com.google.cloud.automl.v1beta1.CreateModelOperationMetadata.Builder,
            com.google.cloud.automl.v1beta1.CreateModelOperationMetadataOrBuilder>
        createModelDetailsBuilder_;
    /**
     *
     *
     * <pre>
     * Details of CreateModel operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.CreateModelOperationMetadata create_model_details = 10;
     * </code>
     *
     * @return Whether the createModelDetails field is set.
     */
    @java.lang.Override
    public boolean hasCreateModelDetails() {
      return detailsCase_ == 10;
    }
    /**
     *
     *
     * <pre>
     * Details of CreateModel operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.CreateModelOperationMetadata create_model_details = 10;
     * </code>
     *
     * @return The createModelDetails.
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.CreateModelOperationMetadata getCreateModelDetails() {
      if (createModelDetailsBuilder_ == null) {
        if (detailsCase_ == 10) {
          return (com.google.cloud.automl.v1beta1.CreateModelOperationMetadata) details_;
        }
        return com.google.cloud.automl.v1beta1.CreateModelOperationMetadata.getDefaultInstance();
      } else {
        if (detailsCase_ == 10) {
          return createModelDetailsBuilder_.getMessage();
        }
        return com.google.cloud.automl.v1beta1.CreateModelOperationMetadata.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Details of CreateModel operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.CreateModelOperationMetadata create_model_details = 10;
     * </code>
     */
    public Builder setCreateModelDetails(
        com.google.cloud.automl.v1beta1.CreateModelOperationMetadata value) {
      if (createModelDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        details_ = value;
        onChanged();
      } else {
        createModelDetailsBuilder_.setMessage(value);
      }
      detailsCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of CreateModel operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.CreateModelOperationMetadata create_model_details = 10;
     * </code>
     */
    public Builder setCreateModelDetails(
        com.google.cloud.automl.v1beta1.CreateModelOperationMetadata.Builder builderForValue) {
      if (createModelDetailsBuilder_ == null) {
        details_ = builderForValue.build();
        onChanged();
      } else {
        createModelDetailsBuilder_.setMessage(builderForValue.build());
      }
      detailsCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of CreateModel operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.CreateModelOperationMetadata create_model_details = 10;
     * </code>
     */
    public Builder mergeCreateModelDetails(
        com.google.cloud.automl.v1beta1.CreateModelOperationMetadata value) {
      if (createModelDetailsBuilder_ == null) {
        if (detailsCase_ == 10
            && details_
                != com.google.cloud.automl.v1beta1.CreateModelOperationMetadata
                    .getDefaultInstance()) {
          details_ =
              com.google.cloud.automl.v1beta1.CreateModelOperationMetadata.newBuilder(
                      (com.google.cloud.automl.v1beta1.CreateModelOperationMetadata) details_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          details_ = value;
        }
        onChanged();
      } else {
        if (detailsCase_ == 10) {
          createModelDetailsBuilder_.mergeFrom(value);
        } else {
          createModelDetailsBuilder_.setMessage(value);
        }
      }
      detailsCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of CreateModel operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.CreateModelOperationMetadata create_model_details = 10;
     * </code>
     */
    public Builder clearCreateModelDetails() {
      if (createModelDetailsBuilder_ == null) {
        if (detailsCase_ == 10) {
          detailsCase_ = 0;
          details_ = null;
          onChanged();
        }
      } else {
        if (detailsCase_ == 10) {
          detailsCase_ = 0;
          details_ = null;
        }
        createModelDetailsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of CreateModel operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.CreateModelOperationMetadata create_model_details = 10;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.CreateModelOperationMetadata.Builder
        getCreateModelDetailsBuilder() {
      return getCreateModelDetailsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Details of CreateModel operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.CreateModelOperationMetadata create_model_details = 10;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.CreateModelOperationMetadataOrBuilder
        getCreateModelDetailsOrBuilder() {
      if ((detailsCase_ == 10) && (createModelDetailsBuilder_ != null)) {
        return createModelDetailsBuilder_.getMessageOrBuilder();
      } else {
        if (detailsCase_ == 10) {
          return (com.google.cloud.automl.v1beta1.CreateModelOperationMetadata) details_;
        }
        return com.google.cloud.automl.v1beta1.CreateModelOperationMetadata.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Details of CreateModel operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.CreateModelOperationMetadata create_model_details = 10;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.CreateModelOperationMetadata,
            com.google.cloud.automl.v1beta1.CreateModelOperationMetadata.Builder,
            com.google.cloud.automl.v1beta1.CreateModelOperationMetadataOrBuilder>
        getCreateModelDetailsFieldBuilder() {
      if (createModelDetailsBuilder_ == null) {
        if (!(detailsCase_ == 10)) {
          details_ =
              com.google.cloud.automl.v1beta1.CreateModelOperationMetadata.getDefaultInstance();
        }
        createModelDetailsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.automl.v1beta1.CreateModelOperationMetadata,
                com.google.cloud.automl.v1beta1.CreateModelOperationMetadata.Builder,
                com.google.cloud.automl.v1beta1.CreateModelOperationMetadataOrBuilder>(
                (com.google.cloud.automl.v1beta1.CreateModelOperationMetadata) details_,
                getParentForChildren(),
                isClean());
        details_ = null;
      }
      detailsCase_ = 10;
      onChanged();
      return createModelDetailsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.ImportDataOperationMetadata,
            com.google.cloud.automl.v1beta1.ImportDataOperationMetadata.Builder,
            com.google.cloud.automl.v1beta1.ImportDataOperationMetadataOrBuilder>
        importDataDetailsBuilder_;
    /**
     *
     *
     * <pre>
     * Details of ImportData operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.ImportDataOperationMetadata import_data_details = 15;
     * </code>
     *
     * @return Whether the importDataDetails field is set.
     */
    @java.lang.Override
    public boolean hasImportDataDetails() {
      return detailsCase_ == 15;
    }
    /**
     *
     *
     * <pre>
     * Details of ImportData operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.ImportDataOperationMetadata import_data_details = 15;
     * </code>
     *
     * @return The importDataDetails.
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.ImportDataOperationMetadata getImportDataDetails() {
      if (importDataDetailsBuilder_ == null) {
        if (detailsCase_ == 15) {
          return (com.google.cloud.automl.v1beta1.ImportDataOperationMetadata) details_;
        }
        return com.google.cloud.automl.v1beta1.ImportDataOperationMetadata.getDefaultInstance();
      } else {
        if (detailsCase_ == 15) {
          return importDataDetailsBuilder_.getMessage();
        }
        return com.google.cloud.automl.v1beta1.ImportDataOperationMetadata.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Details of ImportData operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.ImportDataOperationMetadata import_data_details = 15;
     * </code>
     */
    public Builder setImportDataDetails(
        com.google.cloud.automl.v1beta1.ImportDataOperationMetadata value) {
      if (importDataDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        details_ = value;
        onChanged();
      } else {
        importDataDetailsBuilder_.setMessage(value);
      }
      detailsCase_ = 15;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of ImportData operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.ImportDataOperationMetadata import_data_details = 15;
     * </code>
     */
    public Builder setImportDataDetails(
        com.google.cloud.automl.v1beta1.ImportDataOperationMetadata.Builder builderForValue) {
      if (importDataDetailsBuilder_ == null) {
        details_ = builderForValue.build();
        onChanged();
      } else {
        importDataDetailsBuilder_.setMessage(builderForValue.build());
      }
      detailsCase_ = 15;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of ImportData operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.ImportDataOperationMetadata import_data_details = 15;
     * </code>
     */
    public Builder mergeImportDataDetails(
        com.google.cloud.automl.v1beta1.ImportDataOperationMetadata value) {
      if (importDataDetailsBuilder_ == null) {
        if (detailsCase_ == 15
            && details_
                != com.google.cloud.automl.v1beta1.ImportDataOperationMetadata
                    .getDefaultInstance()) {
          details_ =
              com.google.cloud.automl.v1beta1.ImportDataOperationMetadata.newBuilder(
                      (com.google.cloud.automl.v1beta1.ImportDataOperationMetadata) details_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          details_ = value;
        }
        onChanged();
      } else {
        if (detailsCase_ == 15) {
          importDataDetailsBuilder_.mergeFrom(value);
        } else {
          importDataDetailsBuilder_.setMessage(value);
        }
      }
      detailsCase_ = 15;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of ImportData operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.ImportDataOperationMetadata import_data_details = 15;
     * </code>
     */
    public Builder clearImportDataDetails() {
      if (importDataDetailsBuilder_ == null) {
        if (detailsCase_ == 15) {
          detailsCase_ = 0;
          details_ = null;
          onChanged();
        }
      } else {
        if (detailsCase_ == 15) {
          detailsCase_ = 0;
          details_ = null;
        }
        importDataDetailsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of ImportData operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.ImportDataOperationMetadata import_data_details = 15;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.ImportDataOperationMetadata.Builder
        getImportDataDetailsBuilder() {
      return getImportDataDetailsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Details of ImportData operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.ImportDataOperationMetadata import_data_details = 15;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.ImportDataOperationMetadataOrBuilder
        getImportDataDetailsOrBuilder() {
      if ((detailsCase_ == 15) && (importDataDetailsBuilder_ != null)) {
        return importDataDetailsBuilder_.getMessageOrBuilder();
      } else {
        if (detailsCase_ == 15) {
          return (com.google.cloud.automl.v1beta1.ImportDataOperationMetadata) details_;
        }
        return com.google.cloud.automl.v1beta1.ImportDataOperationMetadata.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Details of ImportData operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.ImportDataOperationMetadata import_data_details = 15;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.ImportDataOperationMetadata,
            com.google.cloud.automl.v1beta1.ImportDataOperationMetadata.Builder,
            com.google.cloud.automl.v1beta1.ImportDataOperationMetadataOrBuilder>
        getImportDataDetailsFieldBuilder() {
      if (importDataDetailsBuilder_ == null) {
        if (!(detailsCase_ == 15)) {
          details_ =
              com.google.cloud.automl.v1beta1.ImportDataOperationMetadata.getDefaultInstance();
        }
        importDataDetailsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.automl.v1beta1.ImportDataOperationMetadata,
                com.google.cloud.automl.v1beta1.ImportDataOperationMetadata.Builder,
                com.google.cloud.automl.v1beta1.ImportDataOperationMetadataOrBuilder>(
                (com.google.cloud.automl.v1beta1.ImportDataOperationMetadata) details_,
                getParentForChildren(),
                isClean());
        details_ = null;
      }
      detailsCase_ = 15;
      onChanged();
      return importDataDetailsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.BatchPredictOperationMetadata,
            com.google.cloud.automl.v1beta1.BatchPredictOperationMetadata.Builder,
            com.google.cloud.automl.v1beta1.BatchPredictOperationMetadataOrBuilder>
        batchPredictDetailsBuilder_;
    /**
     *
     *
     * <pre>
     * Details of BatchPredict operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.BatchPredictOperationMetadata batch_predict_details = 16;
     * </code>
     *
     * @return Whether the batchPredictDetails field is set.
     */
    @java.lang.Override
    public boolean hasBatchPredictDetails() {
      return detailsCase_ == 16;
    }
    /**
     *
     *
     * <pre>
     * Details of BatchPredict operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.BatchPredictOperationMetadata batch_predict_details = 16;
     * </code>
     *
     * @return The batchPredictDetails.
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.BatchPredictOperationMetadata getBatchPredictDetails() {
      if (batchPredictDetailsBuilder_ == null) {
        if (detailsCase_ == 16) {
          return (com.google.cloud.automl.v1beta1.BatchPredictOperationMetadata) details_;
        }
        return com.google.cloud.automl.v1beta1.BatchPredictOperationMetadata.getDefaultInstance();
      } else {
        if (detailsCase_ == 16) {
          return batchPredictDetailsBuilder_.getMessage();
        }
        return com.google.cloud.automl.v1beta1.BatchPredictOperationMetadata.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Details of BatchPredict operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.BatchPredictOperationMetadata batch_predict_details = 16;
     * </code>
     */
    public Builder setBatchPredictDetails(
        com.google.cloud.automl.v1beta1.BatchPredictOperationMetadata value) {
      if (batchPredictDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        details_ = value;
        onChanged();
      } else {
        batchPredictDetailsBuilder_.setMessage(value);
      }
      detailsCase_ = 16;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of BatchPredict operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.BatchPredictOperationMetadata batch_predict_details = 16;
     * </code>
     */
    public Builder setBatchPredictDetails(
        com.google.cloud.automl.v1beta1.BatchPredictOperationMetadata.Builder builderForValue) {
      if (batchPredictDetailsBuilder_ == null) {
        details_ = builderForValue.build();
        onChanged();
      } else {
        batchPredictDetailsBuilder_.setMessage(builderForValue.build());
      }
      detailsCase_ = 16;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of BatchPredict operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.BatchPredictOperationMetadata batch_predict_details = 16;
     * </code>
     */
    public Builder mergeBatchPredictDetails(
        com.google.cloud.automl.v1beta1.BatchPredictOperationMetadata value) {
      if (batchPredictDetailsBuilder_ == null) {
        if (detailsCase_ == 16
            && details_
                != com.google.cloud.automl.v1beta1.BatchPredictOperationMetadata
                    .getDefaultInstance()) {
          details_ =
              com.google.cloud.automl.v1beta1.BatchPredictOperationMetadata.newBuilder(
                      (com.google.cloud.automl.v1beta1.BatchPredictOperationMetadata) details_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          details_ = value;
        }
        onChanged();
      } else {
        if (detailsCase_ == 16) {
          batchPredictDetailsBuilder_.mergeFrom(value);
        } else {
          batchPredictDetailsBuilder_.setMessage(value);
        }
      }
      detailsCase_ = 16;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of BatchPredict operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.BatchPredictOperationMetadata batch_predict_details = 16;
     * </code>
     */
    public Builder clearBatchPredictDetails() {
      if (batchPredictDetailsBuilder_ == null) {
        if (detailsCase_ == 16) {
          detailsCase_ = 0;
          details_ = null;
          onChanged();
        }
      } else {
        if (detailsCase_ == 16) {
          detailsCase_ = 0;
          details_ = null;
        }
        batchPredictDetailsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of BatchPredict operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.BatchPredictOperationMetadata batch_predict_details = 16;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.BatchPredictOperationMetadata.Builder
        getBatchPredictDetailsBuilder() {
      return getBatchPredictDetailsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Details of BatchPredict operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.BatchPredictOperationMetadata batch_predict_details = 16;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.BatchPredictOperationMetadataOrBuilder
        getBatchPredictDetailsOrBuilder() {
      if ((detailsCase_ == 16) && (batchPredictDetailsBuilder_ != null)) {
        return batchPredictDetailsBuilder_.getMessageOrBuilder();
      } else {
        if (detailsCase_ == 16) {
          return (com.google.cloud.automl.v1beta1.BatchPredictOperationMetadata) details_;
        }
        return com.google.cloud.automl.v1beta1.BatchPredictOperationMetadata.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Details of BatchPredict operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.BatchPredictOperationMetadata batch_predict_details = 16;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.BatchPredictOperationMetadata,
            com.google.cloud.automl.v1beta1.BatchPredictOperationMetadata.Builder,
            com.google.cloud.automl.v1beta1.BatchPredictOperationMetadataOrBuilder>
        getBatchPredictDetailsFieldBuilder() {
      if (batchPredictDetailsBuilder_ == null) {
        if (!(detailsCase_ == 16)) {
          details_ =
              com.google.cloud.automl.v1beta1.BatchPredictOperationMetadata.getDefaultInstance();
        }
        batchPredictDetailsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.automl.v1beta1.BatchPredictOperationMetadata,
                com.google.cloud.automl.v1beta1.BatchPredictOperationMetadata.Builder,
                com.google.cloud.automl.v1beta1.BatchPredictOperationMetadataOrBuilder>(
                (com.google.cloud.automl.v1beta1.BatchPredictOperationMetadata) details_,
                getParentForChildren(),
                isClean());
        details_ = null;
      }
      detailsCase_ = 16;
      onChanged();
      return batchPredictDetailsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.ExportDataOperationMetadata,
            com.google.cloud.automl.v1beta1.ExportDataOperationMetadata.Builder,
            com.google.cloud.automl.v1beta1.ExportDataOperationMetadataOrBuilder>
        exportDataDetailsBuilder_;
    /**
     *
     *
     * <pre>
     * Details of ExportData operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.ExportDataOperationMetadata export_data_details = 21;
     * </code>
     *
     * @return Whether the exportDataDetails field is set.
     */
    @java.lang.Override
    public boolean hasExportDataDetails() {
      return detailsCase_ == 21;
    }
    /**
     *
     *
     * <pre>
     * Details of ExportData operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.ExportDataOperationMetadata export_data_details = 21;
     * </code>
     *
     * @return The exportDataDetails.
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.ExportDataOperationMetadata getExportDataDetails() {
      if (exportDataDetailsBuilder_ == null) {
        if (detailsCase_ == 21) {
          return (com.google.cloud.automl.v1beta1.ExportDataOperationMetadata) details_;
        }
        return com.google.cloud.automl.v1beta1.ExportDataOperationMetadata.getDefaultInstance();
      } else {
        if (detailsCase_ == 21) {
          return exportDataDetailsBuilder_.getMessage();
        }
        return com.google.cloud.automl.v1beta1.ExportDataOperationMetadata.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Details of ExportData operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.ExportDataOperationMetadata export_data_details = 21;
     * </code>
     */
    public Builder setExportDataDetails(
        com.google.cloud.automl.v1beta1.ExportDataOperationMetadata value) {
      if (exportDataDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        details_ = value;
        onChanged();
      } else {
        exportDataDetailsBuilder_.setMessage(value);
      }
      detailsCase_ = 21;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of ExportData operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.ExportDataOperationMetadata export_data_details = 21;
     * </code>
     */
    public Builder setExportDataDetails(
        com.google.cloud.automl.v1beta1.ExportDataOperationMetadata.Builder builderForValue) {
      if (exportDataDetailsBuilder_ == null) {
        details_ = builderForValue.build();
        onChanged();
      } else {
        exportDataDetailsBuilder_.setMessage(builderForValue.build());
      }
      detailsCase_ = 21;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of ExportData operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.ExportDataOperationMetadata export_data_details = 21;
     * </code>
     */
    public Builder mergeExportDataDetails(
        com.google.cloud.automl.v1beta1.ExportDataOperationMetadata value) {
      if (exportDataDetailsBuilder_ == null) {
        if (detailsCase_ == 21
            && details_
                != com.google.cloud.automl.v1beta1.ExportDataOperationMetadata
                    .getDefaultInstance()) {
          details_ =
              com.google.cloud.automl.v1beta1.ExportDataOperationMetadata.newBuilder(
                      (com.google.cloud.automl.v1beta1.ExportDataOperationMetadata) details_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          details_ = value;
        }
        onChanged();
      } else {
        if (detailsCase_ == 21) {
          exportDataDetailsBuilder_.mergeFrom(value);
        } else {
          exportDataDetailsBuilder_.setMessage(value);
        }
      }
      detailsCase_ = 21;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of ExportData operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.ExportDataOperationMetadata export_data_details = 21;
     * </code>
     */
    public Builder clearExportDataDetails() {
      if (exportDataDetailsBuilder_ == null) {
        if (detailsCase_ == 21) {
          detailsCase_ = 0;
          details_ = null;
          onChanged();
        }
      } else {
        if (detailsCase_ == 21) {
          detailsCase_ = 0;
          details_ = null;
        }
        exportDataDetailsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of ExportData operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.ExportDataOperationMetadata export_data_details = 21;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.ExportDataOperationMetadata.Builder
        getExportDataDetailsBuilder() {
      return getExportDataDetailsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Details of ExportData operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.ExportDataOperationMetadata export_data_details = 21;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.ExportDataOperationMetadataOrBuilder
        getExportDataDetailsOrBuilder() {
      if ((detailsCase_ == 21) && (exportDataDetailsBuilder_ != null)) {
        return exportDataDetailsBuilder_.getMessageOrBuilder();
      } else {
        if (detailsCase_ == 21) {
          return (com.google.cloud.automl.v1beta1.ExportDataOperationMetadata) details_;
        }
        return com.google.cloud.automl.v1beta1.ExportDataOperationMetadata.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Details of ExportData operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.ExportDataOperationMetadata export_data_details = 21;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.ExportDataOperationMetadata,
            com.google.cloud.automl.v1beta1.ExportDataOperationMetadata.Builder,
            com.google.cloud.automl.v1beta1.ExportDataOperationMetadataOrBuilder>
        getExportDataDetailsFieldBuilder() {
      if (exportDataDetailsBuilder_ == null) {
        if (!(detailsCase_ == 21)) {
          details_ =
              com.google.cloud.automl.v1beta1.ExportDataOperationMetadata.getDefaultInstance();
        }
        exportDataDetailsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.automl.v1beta1.ExportDataOperationMetadata,
                com.google.cloud.automl.v1beta1.ExportDataOperationMetadata.Builder,
                com.google.cloud.automl.v1beta1.ExportDataOperationMetadataOrBuilder>(
                (com.google.cloud.automl.v1beta1.ExportDataOperationMetadata) details_,
                getParentForChildren(),
                isClean());
        details_ = null;
      }
      detailsCase_ = 21;
      onChanged();
      return exportDataDetailsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.ExportModelOperationMetadata,
            com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.Builder,
            com.google.cloud.automl.v1beta1.ExportModelOperationMetadataOrBuilder>
        exportModelDetailsBuilder_;
    /**
     *
     *
     * <pre>
     * Details of ExportModel operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.ExportModelOperationMetadata export_model_details = 22;
     * </code>
     *
     * @return Whether the exportModelDetails field is set.
     */
    @java.lang.Override
    public boolean hasExportModelDetails() {
      return detailsCase_ == 22;
    }
    /**
     *
     *
     * <pre>
     * Details of ExportModel operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.ExportModelOperationMetadata export_model_details = 22;
     * </code>
     *
     * @return The exportModelDetails.
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.ExportModelOperationMetadata getExportModelDetails() {
      if (exportModelDetailsBuilder_ == null) {
        if (detailsCase_ == 22) {
          return (com.google.cloud.automl.v1beta1.ExportModelOperationMetadata) details_;
        }
        return com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.getDefaultInstance();
      } else {
        if (detailsCase_ == 22) {
          return exportModelDetailsBuilder_.getMessage();
        }
        return com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Details of ExportModel operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.ExportModelOperationMetadata export_model_details = 22;
     * </code>
     */
    public Builder setExportModelDetails(
        com.google.cloud.automl.v1beta1.ExportModelOperationMetadata value) {
      if (exportModelDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        details_ = value;
        onChanged();
      } else {
        exportModelDetailsBuilder_.setMessage(value);
      }
      detailsCase_ = 22;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of ExportModel operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.ExportModelOperationMetadata export_model_details = 22;
     * </code>
     */
    public Builder setExportModelDetails(
        com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.Builder builderForValue) {
      if (exportModelDetailsBuilder_ == null) {
        details_ = builderForValue.build();
        onChanged();
      } else {
        exportModelDetailsBuilder_.setMessage(builderForValue.build());
      }
      detailsCase_ = 22;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of ExportModel operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.ExportModelOperationMetadata export_model_details = 22;
     * </code>
     */
    public Builder mergeExportModelDetails(
        com.google.cloud.automl.v1beta1.ExportModelOperationMetadata value) {
      if (exportModelDetailsBuilder_ == null) {
        if (detailsCase_ == 22
            && details_
                != com.google.cloud.automl.v1beta1.ExportModelOperationMetadata
                    .getDefaultInstance()) {
          details_ =
              com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.newBuilder(
                      (com.google.cloud.automl.v1beta1.ExportModelOperationMetadata) details_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          details_ = value;
        }
        onChanged();
      } else {
        if (detailsCase_ == 22) {
          exportModelDetailsBuilder_.mergeFrom(value);
        } else {
          exportModelDetailsBuilder_.setMessage(value);
        }
      }
      detailsCase_ = 22;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of ExportModel operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.ExportModelOperationMetadata export_model_details = 22;
     * </code>
     */
    public Builder clearExportModelDetails() {
      if (exportModelDetailsBuilder_ == null) {
        if (detailsCase_ == 22) {
          detailsCase_ = 0;
          details_ = null;
          onChanged();
        }
      } else {
        if (detailsCase_ == 22) {
          detailsCase_ = 0;
          details_ = null;
        }
        exportModelDetailsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of ExportModel operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.ExportModelOperationMetadata export_model_details = 22;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.Builder
        getExportModelDetailsBuilder() {
      return getExportModelDetailsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Details of ExportModel operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.ExportModelOperationMetadata export_model_details = 22;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.ExportModelOperationMetadataOrBuilder
        getExportModelDetailsOrBuilder() {
      if ((detailsCase_ == 22) && (exportModelDetailsBuilder_ != null)) {
        return exportModelDetailsBuilder_.getMessageOrBuilder();
      } else {
        if (detailsCase_ == 22) {
          return (com.google.cloud.automl.v1beta1.ExportModelOperationMetadata) details_;
        }
        return com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Details of ExportModel operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.ExportModelOperationMetadata export_model_details = 22;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.ExportModelOperationMetadata,
            com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.Builder,
            com.google.cloud.automl.v1beta1.ExportModelOperationMetadataOrBuilder>
        getExportModelDetailsFieldBuilder() {
      if (exportModelDetailsBuilder_ == null) {
        if (!(detailsCase_ == 22)) {
          details_ =
              com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.getDefaultInstance();
        }
        exportModelDetailsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.automl.v1beta1.ExportModelOperationMetadata,
                com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.Builder,
                com.google.cloud.automl.v1beta1.ExportModelOperationMetadataOrBuilder>(
                (com.google.cloud.automl.v1beta1.ExportModelOperationMetadata) details_,
                getParentForChildren(),
                isClean());
        details_ = null;
      }
      detailsCase_ = 22;
      onChanged();
      return exportModelDetailsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.ExportEvaluatedExamplesOperationMetadata,
            com.google.cloud.automl.v1beta1.ExportEvaluatedExamplesOperationMetadata.Builder,
            com.google.cloud.automl.v1beta1.ExportEvaluatedExamplesOperationMetadataOrBuilder>
        exportEvaluatedExamplesDetailsBuilder_;
    /**
     *
     *
     * <pre>
     * Details of ExportEvaluatedExamples operation.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ExportEvaluatedExamplesOperationMetadata export_evaluated_examples_details = 26;
     * </code>
     *
     * @return Whether the exportEvaluatedExamplesDetails field is set.
     */
    @java.lang.Override
    public boolean hasExportEvaluatedExamplesDetails() {
      return detailsCase_ == 26;
    }
    /**
     *
     *
     * <pre>
     * Details of ExportEvaluatedExamples operation.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ExportEvaluatedExamplesOperationMetadata export_evaluated_examples_details = 26;
     * </code>
     *
     * @return The exportEvaluatedExamplesDetails.
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.ExportEvaluatedExamplesOperationMetadata
        getExportEvaluatedExamplesDetails() {
      if (exportEvaluatedExamplesDetailsBuilder_ == null) {
        if (detailsCase_ == 26) {
          return (com.google.cloud.automl.v1beta1.ExportEvaluatedExamplesOperationMetadata)
              details_;
        }
        return com.google.cloud.automl.v1beta1.ExportEvaluatedExamplesOperationMetadata
            .getDefaultInstance();
      } else {
        if (detailsCase_ == 26) {
          return exportEvaluatedExamplesDetailsBuilder_.getMessage();
        }
        return com.google.cloud.automl.v1beta1.ExportEvaluatedExamplesOperationMetadata
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Details of ExportEvaluatedExamples operation.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ExportEvaluatedExamplesOperationMetadata export_evaluated_examples_details = 26;
     * </code>
     */
    public Builder setExportEvaluatedExamplesDetails(
        com.google.cloud.automl.v1beta1.ExportEvaluatedExamplesOperationMetadata value) {
      if (exportEvaluatedExamplesDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        details_ = value;
        onChanged();
      } else {
        exportEvaluatedExamplesDetailsBuilder_.setMessage(value);
      }
      detailsCase_ = 26;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of ExportEvaluatedExamples operation.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ExportEvaluatedExamplesOperationMetadata export_evaluated_examples_details = 26;
     * </code>
     */
    public Builder setExportEvaluatedExamplesDetails(
        com.google.cloud.automl.v1beta1.ExportEvaluatedExamplesOperationMetadata.Builder
            builderForValue) {
      if (exportEvaluatedExamplesDetailsBuilder_ == null) {
        details_ = builderForValue.build();
        onChanged();
      } else {
        exportEvaluatedExamplesDetailsBuilder_.setMessage(builderForValue.build());
      }
      detailsCase_ = 26;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of ExportEvaluatedExamples operation.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ExportEvaluatedExamplesOperationMetadata export_evaluated_examples_details = 26;
     * </code>
     */
    public Builder mergeExportEvaluatedExamplesDetails(
        com.google.cloud.automl.v1beta1.ExportEvaluatedExamplesOperationMetadata value) {
      if (exportEvaluatedExamplesDetailsBuilder_ == null) {
        if (detailsCase_ == 26
            && details_
                != com.google.cloud.automl.v1beta1.ExportEvaluatedExamplesOperationMetadata
                    .getDefaultInstance()) {
          details_ =
              com.google.cloud.automl.v1beta1.ExportEvaluatedExamplesOperationMetadata.newBuilder(
                      (com.google.cloud.automl.v1beta1.ExportEvaluatedExamplesOperationMetadata)
                          details_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          details_ = value;
        }
        onChanged();
      } else {
        if (detailsCase_ == 26) {
          exportEvaluatedExamplesDetailsBuilder_.mergeFrom(value);
        } else {
          exportEvaluatedExamplesDetailsBuilder_.setMessage(value);
        }
      }
      detailsCase_ = 26;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of ExportEvaluatedExamples operation.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ExportEvaluatedExamplesOperationMetadata export_evaluated_examples_details = 26;
     * </code>
     */
    public Builder clearExportEvaluatedExamplesDetails() {
      if (exportEvaluatedExamplesDetailsBuilder_ == null) {
        if (detailsCase_ == 26) {
          detailsCase_ = 0;
          details_ = null;
          onChanged();
        }
      } else {
        if (detailsCase_ == 26) {
          detailsCase_ = 0;
          details_ = null;
        }
        exportEvaluatedExamplesDetailsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of ExportEvaluatedExamples operation.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ExportEvaluatedExamplesOperationMetadata export_evaluated_examples_details = 26;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.ExportEvaluatedExamplesOperationMetadata.Builder
        getExportEvaluatedExamplesDetailsBuilder() {
      return getExportEvaluatedExamplesDetailsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Details of ExportEvaluatedExamples operation.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ExportEvaluatedExamplesOperationMetadata export_evaluated_examples_details = 26;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.ExportEvaluatedExamplesOperationMetadataOrBuilder
        getExportEvaluatedExamplesDetailsOrBuilder() {
      if ((detailsCase_ == 26) && (exportEvaluatedExamplesDetailsBuilder_ != null)) {
        return exportEvaluatedExamplesDetailsBuilder_.getMessageOrBuilder();
      } else {
        if (detailsCase_ == 26) {
          return (com.google.cloud.automl.v1beta1.ExportEvaluatedExamplesOperationMetadata)
              details_;
        }
        return com.google.cloud.automl.v1beta1.ExportEvaluatedExamplesOperationMetadata
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Details of ExportEvaluatedExamples operation.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ExportEvaluatedExamplesOperationMetadata export_evaluated_examples_details = 26;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.ExportEvaluatedExamplesOperationMetadata,
            com.google.cloud.automl.v1beta1.ExportEvaluatedExamplesOperationMetadata.Builder,
            com.google.cloud.automl.v1beta1.ExportEvaluatedExamplesOperationMetadataOrBuilder>
        getExportEvaluatedExamplesDetailsFieldBuilder() {
      if (exportEvaluatedExamplesDetailsBuilder_ == null) {
        if (!(detailsCase_ == 26)) {
          details_ =
              com.google.cloud.automl.v1beta1.ExportEvaluatedExamplesOperationMetadata
                  .getDefaultInstance();
        }
        exportEvaluatedExamplesDetailsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.automl.v1beta1.ExportEvaluatedExamplesOperationMetadata,
                com.google.cloud.automl.v1beta1.ExportEvaluatedExamplesOperationMetadata.Builder,
                com.google.cloud.automl.v1beta1.ExportEvaluatedExamplesOperationMetadataOrBuilder>(
                (com.google.cloud.automl.v1beta1.ExportEvaluatedExamplesOperationMetadata) details_,
                getParentForChildren(),
                isClean());
        details_ = null;
      }
      detailsCase_ = 26;
      onChanged();
      return exportEvaluatedExamplesDetailsBuilder_;
    }

    private int progressPercent_;
    /**
     *
     *
     * <pre>
     * Output only. Progress of operation. Range: [0, 100].
     * Not used currently.
     * </pre>
     *
     * <code>int32 progress_percent = 13;</code>
     *
     * @return The progressPercent.
     */
    @java.lang.Override
    public int getProgressPercent() {
      return progressPercent_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Progress of operation. Range: [0, 100].
     * Not used currently.
     * </pre>
     *
     * <code>int32 progress_percent = 13;</code>
     *
     * @param value The progressPercent to set.
     * @return This builder for chaining.
     */
    public Builder setProgressPercent(int value) {

      progressPercent_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Progress of operation. Range: [0, 100].
     * Not used currently.
     * </pre>
     *
     * <code>int32 progress_percent = 13;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProgressPercent() {
      bitField0_ = (bitField0_ & ~0x00000200);
      progressPercent_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.rpc.Status> partialFailures_ =
        java.util.Collections.emptyList();

    private void ensurePartialFailuresIsMutable() {
      if (!((bitField0_ & 0x00000400) != 0)) {
        partialFailures_ = new java.util.ArrayList<com.google.rpc.Status>(partialFailures_);
        bitField0_ |= 0x00000400;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        partialFailuresBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * E.g. single files that couldn't be read.
     * This field should never exceed 20 entries.
     * Status details field will contain standard GCP error details.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_failures = 2;</code>
     */
    public java.util.List<com.google.rpc.Status> getPartialFailuresList() {
      if (partialFailuresBuilder_ == null) {
        return java.util.Collections.unmodifiableList(partialFailures_);
      } else {
        return partialFailuresBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * E.g. single files that couldn't be read.
     * This field should never exceed 20 entries.
     * Status details field will contain standard GCP error details.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_failures = 2;</code>
     */
    public int getPartialFailuresCount() {
      if (partialFailuresBuilder_ == null) {
        return partialFailures_.size();
      } else {
        return partialFailuresBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * E.g. single files that couldn't be read.
     * This field should never exceed 20 entries.
     * Status details field will contain standard GCP error details.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_failures = 2;</code>
     */
    public com.google.rpc.Status getPartialFailures(int index) {
      if (partialFailuresBuilder_ == null) {
        return partialFailures_.get(index);
      } else {
        return partialFailuresBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * E.g. single files that couldn't be read.
     * This field should never exceed 20 entries.
     * Status details field will contain standard GCP error details.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_failures = 2;</code>
     */
    public Builder setPartialFailures(int index, com.google.rpc.Status value) {
      if (partialFailuresBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePartialFailuresIsMutable();
        partialFailures_.set(index, value);
        onChanged();
      } else {
        partialFailuresBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * E.g. single files that couldn't be read.
     * This field should never exceed 20 entries.
     * Status details field will contain standard GCP error details.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_failures = 2;</code>
     */
    public Builder setPartialFailures(int index, com.google.rpc.Status.Builder builderForValue) {
      if (partialFailuresBuilder_ == null) {
        ensurePartialFailuresIsMutable();
        partialFailures_.set(index, builderForValue.build());
        onChanged();
      } else {
        partialFailuresBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * E.g. single files that couldn't be read.
     * This field should never exceed 20 entries.
     * Status details field will contain standard GCP error details.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_failures = 2;</code>
     */
    public Builder addPartialFailures(com.google.rpc.Status value) {
      if (partialFailuresBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePartialFailuresIsMutable();
        partialFailures_.add(value);
        onChanged();
      } else {
        partialFailuresBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * E.g. single files that couldn't be read.
     * This field should never exceed 20 entries.
     * Status details field will contain standard GCP error details.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_failures = 2;</code>
     */
    public Builder addPartialFailures(int index, com.google.rpc.Status value) {
      if (partialFailuresBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePartialFailuresIsMutable();
        partialFailures_.add(index, value);
        onChanged();
      } else {
        partialFailuresBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * E.g. single files that couldn't be read.
     * This field should never exceed 20 entries.
     * Status details field will contain standard GCP error details.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_failures = 2;</code>
     */
    public Builder addPartialFailures(com.google.rpc.Status.Builder builderForValue) {
      if (partialFailuresBuilder_ == null) {
        ensurePartialFailuresIsMutable();
        partialFailures_.add(builderForValue.build());
        onChanged();
      } else {
        partialFailuresBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * E.g. single files that couldn't be read.
     * This field should never exceed 20 entries.
     * Status details field will contain standard GCP error details.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_failures = 2;</code>
     */
    public Builder addPartialFailures(int index, com.google.rpc.Status.Builder builderForValue) {
      if (partialFailuresBuilder_ == null) {
        ensurePartialFailuresIsMutable();
        partialFailures_.add(index, builderForValue.build());
        onChanged();
      } else {
        partialFailuresBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * E.g. single files that couldn't be read.
     * This field should never exceed 20 entries.
     * Status details field will contain standard GCP error details.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_failures = 2;</code>
     */
    public Builder addAllPartialFailures(
        java.lang.Iterable<? extends com.google.rpc.Status> values) {
      if (partialFailuresBuilder_ == null) {
        ensurePartialFailuresIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, partialFailures_);
        onChanged();
      } else {
        partialFailuresBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * E.g. single files that couldn't be read.
     * This field should never exceed 20 entries.
     * Status details field will contain standard GCP error details.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_failures = 2;</code>
     */
    public Builder clearPartialFailures() {
      if (partialFailuresBuilder_ == null) {
        partialFailures_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000400);
        onChanged();
      } else {
        partialFailuresBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * E.g. single files that couldn't be read.
     * This field should never exceed 20 entries.
     * Status details field will contain standard GCP error details.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_failures = 2;</code>
     */
    public Builder removePartialFailures(int index) {
      if (partialFailuresBuilder_ == null) {
        ensurePartialFailuresIsMutable();
        partialFailures_.remove(index);
        onChanged();
      } else {
        partialFailuresBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * E.g. single files that couldn't be read.
     * This field should never exceed 20 entries.
     * Status details field will contain standard GCP error details.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_failures = 2;</code>
     */
    public com.google.rpc.Status.Builder getPartialFailuresBuilder(int index) {
      return getPartialFailuresFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * E.g. single files that couldn't be read.
     * This field should never exceed 20 entries.
     * Status details field will contain standard GCP error details.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_failures = 2;</code>
     */
    public com.google.rpc.StatusOrBuilder getPartialFailuresOrBuilder(int index) {
      if (partialFailuresBuilder_ == null) {
        return partialFailures_.get(index);
      } else {
        return partialFailuresBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * E.g. single files that couldn't be read.
     * This field should never exceed 20 entries.
     * Status details field will contain standard GCP error details.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_failures = 2;</code>
     */
    public java.util.List<? extends com.google.rpc.StatusOrBuilder>
        getPartialFailuresOrBuilderList() {
      if (partialFailuresBuilder_ != null) {
        return partialFailuresBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(partialFailures_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * E.g. single files that couldn't be read.
     * This field should never exceed 20 entries.
     * Status details field will contain standard GCP error details.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_failures = 2;</code>
     */
    public com.google.rpc.Status.Builder addPartialFailuresBuilder() {
      return getPartialFailuresFieldBuilder()
          .addBuilder(com.google.rpc.Status.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * E.g. single files that couldn't be read.
     * This field should never exceed 20 entries.
     * Status details field will contain standard GCP error details.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_failures = 2;</code>
     */
    public com.google.rpc.Status.Builder addPartialFailuresBuilder(int index) {
      return getPartialFailuresFieldBuilder()
          .addBuilder(index, com.google.rpc.Status.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * E.g. single files that couldn't be read.
     * This field should never exceed 20 entries.
     * Status details field will contain standard GCP error details.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_failures = 2;</code>
     */
    public java.util.List<com.google.rpc.Status.Builder> getPartialFailuresBuilderList() {
      return getPartialFailuresFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getPartialFailuresFieldBuilder() {
      if (partialFailuresBuilder_ == null) {
        partialFailuresBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(
                partialFailures_,
                ((bitField0_ & 0x00000400) != 0),
                getParentForChildren(),
                isClean());
        partialFailures_ = null;
      }
      return partialFailuresBuilder_;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time when the operation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the operation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the operation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the operation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the operation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000800;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the operation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000800);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the operation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the operation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the operation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time when the operation was updated for the last time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 4;</code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the operation was updated for the last time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 4;</code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the operation was updated for the last time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 4;</code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the operation was updated for the last time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 4;</code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the operation was updated for the last time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 4;</code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00001000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the operation was updated for the last time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 4;</code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00001000);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the operation was updated for the last time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 4;</code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00001000;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the operation was updated for the last time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 4;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the operation was updated for the last time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.automl.v1beta1.OperationMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.automl.v1beta1.OperationMetadata)
  private static final com.google.cloud.automl.v1beta1.OperationMetadata DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.automl.v1beta1.OperationMetadata();
  }

  public static com.google.cloud.automl.v1beta1.OperationMetadata getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<OperationMetadata> PARSER =
      new com.google.protobuf.AbstractParser<OperationMetadata>() {
        @java.lang.Override
        public OperationMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<OperationMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<OperationMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.automl.v1beta1.OperationMetadata getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
