/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.automl.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ColumnSpecName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/datasets/{dataset}/tableSpecs/{table_spec}/columnSpecs/{column_spec}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String dataset;
    private final String tableSpec;
    private final String columnSpec;

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDataset() {
        return this.dataset;
    }

    public String getTableSpec() {
        return this.tableSpec;
    }

    public String getColumnSpec() {
        return this.columnSpec;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ColumnSpecName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.dataset = (String)Preconditions.checkNotNull((Object)builder.getDataset());
        this.tableSpec = (String)Preconditions.checkNotNull((Object)builder.getTableSpec());
        this.columnSpec = (String)Preconditions.checkNotNull((Object)builder.getColumnSpec());
    }

    public static ColumnSpecName of(String project, String location, String dataset, String tableSpec, String columnSpec) {
        return ColumnSpecName.newBuilder().setProject(project).setLocation(location).setDataset(dataset).setTableSpec(tableSpec).setColumnSpec(columnSpec).build();
    }

    public static String format(String project, String location, String dataset, String tableSpec, String columnSpec) {
        return ColumnSpecName.newBuilder().setProject(project).setLocation(location).setDataset(dataset).setTableSpec(tableSpec).setColumnSpec(columnSpec).build().toString();
    }

    public static ColumnSpecName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "ColumnSpecName.parse: formattedString not in valid format");
        return ColumnSpecName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("dataset"), (String)matchMap.get("table_spec"), (String)matchMap.get("column_spec"));
    }

    public static List<ColumnSpecName> parseList(List<String> formattedStrings) {
        ArrayList<ColumnSpecName> list = new ArrayList<ColumnSpecName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ColumnSpecName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ColumnSpecName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ColumnSpecName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ColumnSpecName columnSpecName = this;
            synchronized (columnSpecName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"location", (Object)this.location);
                    fieldMapBuilder.put((Object)"dataset", (Object)this.dataset);
                    fieldMapBuilder.put((Object)"tableSpec", (Object)this.tableSpec);
                    fieldMapBuilder.put((Object)"columnSpec", (Object)this.columnSpec);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "location", this.location, "dataset", this.dataset, "table_spec", this.tableSpec, "column_spec", this.columnSpec});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ColumnSpecName) {
            ColumnSpecName that = (ColumnSpecName)o;
            return this.project.equals(that.project) && this.location.equals(that.location) && this.dataset.equals(that.dataset) && this.tableSpec.equals(that.tableSpec) && this.columnSpec.equals(that.columnSpec);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.location.hashCode();
        h *= 1000003;
        h ^= this.dataset.hashCode();
        h *= 1000003;
        h ^= this.tableSpec.hashCode();
        h *= 1000003;
        return h ^= this.columnSpec.hashCode();
    }

    public static class Builder {
        private String project;
        private String location;
        private String dataset;
        private String tableSpec;
        private String columnSpec;

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDataset() {
            return this.dataset;
        }

        public String getTableSpec() {
            return this.tableSpec;
        }

        public String getColumnSpec() {
            return this.columnSpec;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setDataset(String dataset) {
            this.dataset = dataset;
            return this;
        }

        public Builder setTableSpec(String tableSpec) {
            this.tableSpec = tableSpec;
            return this;
        }

        public Builder setColumnSpec(String columnSpec) {
            this.columnSpec = columnSpec;
            return this;
        }

        private Builder() {
        }

        private Builder(ColumnSpecName columnSpecName) {
            this.project = columnSpecName.project;
            this.location = columnSpecName.location;
            this.dataset = columnSpecName.dataset;
            this.tableSpec = columnSpecName.tableSpec;
            this.columnSpec = columnSpecName.columnSpec;
        }

        public ColumnSpecName build() {
            return new ColumnSpecName(this);
        }
    }
}

