/*
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/automl/v1beta1/column_spec.proto

package com.google.cloud.automl.v1beta1;

/**
 *
 *
 * <pre>
 * A representation of a column in a relational table. When listing them, column specs are returned in the same order in which they were
 * given on import .
 * Used by:
 *   *   Tables
 * </pre>
 *
 * Protobuf type {@code google.cloud.automl.v1beta1.ColumnSpec}
 */
public final class ColumnSpec extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.automl.v1beta1.ColumnSpec)
    ColumnSpecOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ColumnSpec.newBuilder() to construct.
  private ColumnSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ColumnSpec() {
    name_ = "";
    displayName_ = "";
    topCorrelatedColumns_ = java.util.Collections.emptyList();
    etag_ = "";
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private ColumnSpec(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 18:
            {
              com.google.cloud.automl.v1beta1.DataType.Builder subBuilder = null;
              if (dataType_ != null) {
                subBuilder = dataType_.toBuilder();
              }
              dataType_ =
                  input.readMessage(
                      com.google.cloud.automl.v1beta1.DataType.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(dataType_);
                dataType_ = subBuilder.buildPartial();
              }

              break;
            }
          case 26:
            {
              java.lang.String s = input.readStringRequireUtf8();

              displayName_ = s;
              break;
            }
          case 34:
            {
              com.google.cloud.automl.v1beta1.DataStats.Builder subBuilder = null;
              if (dataStats_ != null) {
                subBuilder = dataStats_.toBuilder();
              }
              dataStats_ =
                  input.readMessage(
                      com.google.cloud.automl.v1beta1.DataStats.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(dataStats_);
                dataStats_ = subBuilder.buildPartial();
              }

              break;
            }
          case 42:
            {
              if (!((mutable_bitField0_ & 0x00000010) != 0)) {
                topCorrelatedColumns_ =
                    new java.util.ArrayList<
                        com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn>();
                mutable_bitField0_ |= 0x00000010;
              }
              topCorrelatedColumns_.add(
                  input.readMessage(
                      com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn.parser(),
                      extensionRegistry));
              break;
            }
          case 50:
            {
              java.lang.String s = input.readStringRequireUtf8();

              etag_ = s;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000010) != 0)) {
        topCorrelatedColumns_ = java.util.Collections.unmodifiableList(topCorrelatedColumns_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.automl.v1beta1.ColumnSpecOuterClass
        .internal_static_google_cloud_automl_v1beta1_ColumnSpec_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.automl.v1beta1.ColumnSpecOuterClass
        .internal_static_google_cloud_automl_v1beta1_ColumnSpec_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.automl.v1beta1.ColumnSpec.class,
            com.google.cloud.automl.v1beta1.ColumnSpec.Builder.class);
  }

  public interface CorrelatedColumnOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The column_spec_id of the correlated column, which belongs to the same
     * table as the in-context column.
     * </pre>
     *
     * <code>string column_spec_id = 1;</code>
     */
    java.lang.String getColumnSpecId();
    /**
     *
     *
     * <pre>
     * The column_spec_id of the correlated column, which belongs to the same
     * table as the in-context column.
     * </pre>
     *
     * <code>string column_spec_id = 1;</code>
     */
    com.google.protobuf.ByteString getColumnSpecIdBytes();

    /**
     *
     *
     * <pre>
     * Correlation between this and the in-context column.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.CorrelationStats correlation_stats = 2;</code>
     */
    boolean hasCorrelationStats();
    /**
     *
     *
     * <pre>
     * Correlation between this and the in-context column.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.CorrelationStats correlation_stats = 2;</code>
     */
    com.google.cloud.automl.v1beta1.CorrelationStats getCorrelationStats();
    /**
     *
     *
     * <pre>
     * Correlation between this and the in-context column.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.CorrelationStats correlation_stats = 2;</code>
     */
    com.google.cloud.automl.v1beta1.CorrelationStatsOrBuilder getCorrelationStatsOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Identifies the table's column, and its correlation with the column this
   * ColumnSpec describes.
   * </pre>
   *
   * Protobuf type {@code google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn}
   */
  public static final class CorrelatedColumn extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn)
      CorrelatedColumnOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use CorrelatedColumn.newBuilder() to construct.
    private CorrelatedColumn(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private CorrelatedColumn() {
      columnSpecId_ = "";
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private CorrelatedColumn(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                columnSpecId_ = s;
                break;
              }
            case 18:
              {
                com.google.cloud.automl.v1beta1.CorrelationStats.Builder subBuilder = null;
                if (correlationStats_ != null) {
                  subBuilder = correlationStats_.toBuilder();
                }
                correlationStats_ =
                    input.readMessage(
                        com.google.cloud.automl.v1beta1.CorrelationStats.parser(),
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(correlationStats_);
                  correlationStats_ = subBuilder.buildPartial();
                }

                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.automl.v1beta1.ColumnSpecOuterClass
          .internal_static_google_cloud_automl_v1beta1_ColumnSpec_CorrelatedColumn_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.automl.v1beta1.ColumnSpecOuterClass
          .internal_static_google_cloud_automl_v1beta1_ColumnSpec_CorrelatedColumn_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn.class,
              com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn.Builder.class);
    }

    public static final int COLUMN_SPEC_ID_FIELD_NUMBER = 1;
    private volatile java.lang.Object columnSpecId_;
    /**
     *
     *
     * <pre>
     * The column_spec_id of the correlated column, which belongs to the same
     * table as the in-context column.
     * </pre>
     *
     * <code>string column_spec_id = 1;</code>
     */
    public java.lang.String getColumnSpecId() {
      java.lang.Object ref = columnSpecId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        columnSpecId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The column_spec_id of the correlated column, which belongs to the same
     * table as the in-context column.
     * </pre>
     *
     * <code>string column_spec_id = 1;</code>
     */
    public com.google.protobuf.ByteString getColumnSpecIdBytes() {
      java.lang.Object ref = columnSpecId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        columnSpecId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CORRELATION_STATS_FIELD_NUMBER = 2;
    private com.google.cloud.automl.v1beta1.CorrelationStats correlationStats_;
    /**
     *
     *
     * <pre>
     * Correlation between this and the in-context column.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.CorrelationStats correlation_stats = 2;</code>
     */
    public boolean hasCorrelationStats() {
      return correlationStats_ != null;
    }
    /**
     *
     *
     * <pre>
     * Correlation between this and the in-context column.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.CorrelationStats correlation_stats = 2;</code>
     */
    public com.google.cloud.automl.v1beta1.CorrelationStats getCorrelationStats() {
      return correlationStats_ == null
          ? com.google.cloud.automl.v1beta1.CorrelationStats.getDefaultInstance()
          : correlationStats_;
    }
    /**
     *
     *
     * <pre>
     * Correlation between this and the in-context column.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.CorrelationStats correlation_stats = 2;</code>
     */
    public com.google.cloud.automl.v1beta1.CorrelationStatsOrBuilder
        getCorrelationStatsOrBuilder() {
      return getCorrelationStats();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!getColumnSpecIdBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, columnSpecId_);
      }
      if (correlationStats_ != null) {
        output.writeMessage(2, getCorrelationStats());
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getColumnSpecIdBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, columnSpecId_);
      }
      if (correlationStats_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCorrelationStats());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn)) {
        return super.equals(obj);
      }
      com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn other =
          (com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn) obj;

      if (!getColumnSpecId().equals(other.getColumnSpecId())) return false;
      if (hasCorrelationStats() != other.hasCorrelationStats()) return false;
      if (hasCorrelationStats()) {
        if (!getCorrelationStats().equals(other.getCorrelationStats())) return false;
      }
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + COLUMN_SPEC_ID_FIELD_NUMBER;
      hash = (53 * hash) + getColumnSpecId().hashCode();
      if (hasCorrelationStats()) {
        hash = (37 * hash) + CORRELATION_STATS_FIELD_NUMBER;
        hash = (53 * hash) + getCorrelationStats().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Identifies the table's column, and its correlation with the column this
     * ColumnSpec describes.
     * </pre>
     *
     * Protobuf type {@code google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn)
        com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumnOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.automl.v1beta1.ColumnSpecOuterClass
            .internal_static_google_cloud_automl_v1beta1_ColumnSpec_CorrelatedColumn_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.automl.v1beta1.ColumnSpecOuterClass
            .internal_static_google_cloud_automl_v1beta1_ColumnSpec_CorrelatedColumn_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn.class,
                com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn.Builder.class);
      }

      // Construct using com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        columnSpecId_ = "";

        if (correlationStatsBuilder_ == null) {
          correlationStats_ = null;
        } else {
          correlationStats_ = null;
          correlationStatsBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.automl.v1beta1.ColumnSpecOuterClass
            .internal_static_google_cloud_automl_v1beta1_ColumnSpec_CorrelatedColumn_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn
          getDefaultInstanceForType() {
        return com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn build() {
        com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn buildPartial() {
        com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn result =
            new com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn(this);
        result.columnSpecId_ = columnSpecId_;
        if (correlationStatsBuilder_ == null) {
          result.correlationStats_ = correlationStats_;
        } else {
          result.correlationStats_ = correlationStatsBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn) {
          return mergeFrom((com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn other) {
        if (other
            == com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn.getDefaultInstance())
          return this;
        if (!other.getColumnSpecId().isEmpty()) {
          columnSpecId_ = other.columnSpecId_;
          onChanged();
        }
        if (other.hasCorrelationStats()) {
          mergeCorrelationStats(other.getCorrelationStats());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object columnSpecId_ = "";
      /**
       *
       *
       * <pre>
       * The column_spec_id of the correlated column, which belongs to the same
       * table as the in-context column.
       * </pre>
       *
       * <code>string column_spec_id = 1;</code>
       */
      public java.lang.String getColumnSpecId() {
        java.lang.Object ref = columnSpecId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          columnSpecId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The column_spec_id of the correlated column, which belongs to the same
       * table as the in-context column.
       * </pre>
       *
       * <code>string column_spec_id = 1;</code>
       */
      public com.google.protobuf.ByteString getColumnSpecIdBytes() {
        java.lang.Object ref = columnSpecId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          columnSpecId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The column_spec_id of the correlated column, which belongs to the same
       * table as the in-context column.
       * </pre>
       *
       * <code>string column_spec_id = 1;</code>
       */
      public Builder setColumnSpecId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        columnSpecId_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The column_spec_id of the correlated column, which belongs to the same
       * table as the in-context column.
       * </pre>
       *
       * <code>string column_spec_id = 1;</code>
       */
      public Builder clearColumnSpecId() {

        columnSpecId_ = getDefaultInstance().getColumnSpecId();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The column_spec_id of the correlated column, which belongs to the same
       * table as the in-context column.
       * </pre>
       *
       * <code>string column_spec_id = 1;</code>
       */
      public Builder setColumnSpecIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        columnSpecId_ = value;
        onChanged();
        return this;
      }

      private com.google.cloud.automl.v1beta1.CorrelationStats correlationStats_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.automl.v1beta1.CorrelationStats,
              com.google.cloud.automl.v1beta1.CorrelationStats.Builder,
              com.google.cloud.automl.v1beta1.CorrelationStatsOrBuilder>
          correlationStatsBuilder_;
      /**
       *
       *
       * <pre>
       * Correlation between this and the in-context column.
       * </pre>
       *
       * <code>.google.cloud.automl.v1beta1.CorrelationStats correlation_stats = 2;</code>
       */
      public boolean hasCorrelationStats() {
        return correlationStatsBuilder_ != null || correlationStats_ != null;
      }
      /**
       *
       *
       * <pre>
       * Correlation between this and the in-context column.
       * </pre>
       *
       * <code>.google.cloud.automl.v1beta1.CorrelationStats correlation_stats = 2;</code>
       */
      public com.google.cloud.automl.v1beta1.CorrelationStats getCorrelationStats() {
        if (correlationStatsBuilder_ == null) {
          return correlationStats_ == null
              ? com.google.cloud.automl.v1beta1.CorrelationStats.getDefaultInstance()
              : correlationStats_;
        } else {
          return correlationStatsBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Correlation between this and the in-context column.
       * </pre>
       *
       * <code>.google.cloud.automl.v1beta1.CorrelationStats correlation_stats = 2;</code>
       */
      public Builder setCorrelationStats(com.google.cloud.automl.v1beta1.CorrelationStats value) {
        if (correlationStatsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          correlationStats_ = value;
          onChanged();
        } else {
          correlationStatsBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Correlation between this and the in-context column.
       * </pre>
       *
       * <code>.google.cloud.automl.v1beta1.CorrelationStats correlation_stats = 2;</code>
       */
      public Builder setCorrelationStats(
          com.google.cloud.automl.v1beta1.CorrelationStats.Builder builderForValue) {
        if (correlationStatsBuilder_ == null) {
          correlationStats_ = builderForValue.build();
          onChanged();
        } else {
          correlationStatsBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Correlation between this and the in-context column.
       * </pre>
       *
       * <code>.google.cloud.automl.v1beta1.CorrelationStats correlation_stats = 2;</code>
       */
      public Builder mergeCorrelationStats(com.google.cloud.automl.v1beta1.CorrelationStats value) {
        if (correlationStatsBuilder_ == null) {
          if (correlationStats_ != null) {
            correlationStats_ =
                com.google.cloud.automl.v1beta1.CorrelationStats.newBuilder(correlationStats_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            correlationStats_ = value;
          }
          onChanged();
        } else {
          correlationStatsBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Correlation between this and the in-context column.
       * </pre>
       *
       * <code>.google.cloud.automl.v1beta1.CorrelationStats correlation_stats = 2;</code>
       */
      public Builder clearCorrelationStats() {
        if (correlationStatsBuilder_ == null) {
          correlationStats_ = null;
          onChanged();
        } else {
          correlationStats_ = null;
          correlationStatsBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Correlation between this and the in-context column.
       * </pre>
       *
       * <code>.google.cloud.automl.v1beta1.CorrelationStats correlation_stats = 2;</code>
       */
      public com.google.cloud.automl.v1beta1.CorrelationStats.Builder getCorrelationStatsBuilder() {

        onChanged();
        return getCorrelationStatsFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Correlation between this and the in-context column.
       * </pre>
       *
       * <code>.google.cloud.automl.v1beta1.CorrelationStats correlation_stats = 2;</code>
       */
      public com.google.cloud.automl.v1beta1.CorrelationStatsOrBuilder
          getCorrelationStatsOrBuilder() {
        if (correlationStatsBuilder_ != null) {
          return correlationStatsBuilder_.getMessageOrBuilder();
        } else {
          return correlationStats_ == null
              ? com.google.cloud.automl.v1beta1.CorrelationStats.getDefaultInstance()
              : correlationStats_;
        }
      }
      /**
       *
       *
       * <pre>
       * Correlation between this and the in-context column.
       * </pre>
       *
       * <code>.google.cloud.automl.v1beta1.CorrelationStats correlation_stats = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.automl.v1beta1.CorrelationStats,
              com.google.cloud.automl.v1beta1.CorrelationStats.Builder,
              com.google.cloud.automl.v1beta1.CorrelationStatsOrBuilder>
          getCorrelationStatsFieldBuilder() {
        if (correlationStatsBuilder_ == null) {
          correlationStatsBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.automl.v1beta1.CorrelationStats,
                  com.google.cloud.automl.v1beta1.CorrelationStats.Builder,
                  com.google.cloud.automl.v1beta1.CorrelationStatsOrBuilder>(
                  getCorrelationStats(), getParentForChildren(), isClean());
          correlationStats_ = null;
        }
        return correlationStatsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn)
    private static final com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn();
    }

    public static com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CorrelatedColumn> PARSER =
        new com.google.protobuf.AbstractParser<CorrelatedColumn>() {
          @java.lang.Override
          public CorrelatedColumn parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new CorrelatedColumn(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<CorrelatedColumn> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CorrelatedColumn> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the column specs.
   * Form:
   * `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/tableSpecs/{table_spec_id}/columnSpecs/{column_spec_id}`
   * </pre>
   *
   * <code>string name = 1;</code>
   */
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the column specs.
   * Form:
   * `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/tableSpecs/{table_spec_id}/columnSpecs/{column_spec_id}`
   * </pre>
   *
   * <code>string name = 1;</code>
   */
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATA_TYPE_FIELD_NUMBER = 2;
  private com.google.cloud.automl.v1beta1.DataType dataType_;
  /**
   *
   *
   * <pre>
   * The data type of elements stored in the column.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.DataType data_type = 2;</code>
   */
  public boolean hasDataType() {
    return dataType_ != null;
  }
  /**
   *
   *
   * <pre>
   * The data type of elements stored in the column.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.DataType data_type = 2;</code>
   */
  public com.google.cloud.automl.v1beta1.DataType getDataType() {
    return dataType_ == null
        ? com.google.cloud.automl.v1beta1.DataType.getDefaultInstance()
        : dataType_;
  }
  /**
   *
   *
   * <pre>
   * The data type of elements stored in the column.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.DataType data_type = 2;</code>
   */
  public com.google.cloud.automl.v1beta1.DataTypeOrBuilder getDataTypeOrBuilder() {
    return getDataType();
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 3;
  private volatile java.lang.Object displayName_;
  /**
   *
   *
   * <pre>
   * Output only. The name of the column to show in the interface. The name can
   * be up to 100 characters long and can consist only of ASCII Latin letters
   * A-Z and a-z, ASCII digits 0-9, underscores(_), and forward slashes(/), and
   * must start with a letter or a digit.
   * </pre>
   *
   * <code>string display_name = 3;</code>
   */
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The name of the column to show in the interface. The name can
   * be up to 100 characters long and can consist only of ASCII Latin letters
   * A-Z and a-z, ASCII digits 0-9, underscores(_), and forward slashes(/), and
   * must start with a letter or a digit.
   * </pre>
   *
   * <code>string display_name = 3;</code>
   */
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATA_STATS_FIELD_NUMBER = 4;
  private com.google.cloud.automl.v1beta1.DataStats dataStats_;
  /**
   *
   *
   * <pre>
   * Output only. Stats of the series of values in the column.
   * This field may be stale, see the ancestor's
   * Dataset.tables_dataset_metadata.stats_update_time field
   * for the timestamp at which these stats were last updated.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.DataStats data_stats = 4;</code>
   */
  public boolean hasDataStats() {
    return dataStats_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Stats of the series of values in the column.
   * This field may be stale, see the ancestor's
   * Dataset.tables_dataset_metadata.stats_update_time field
   * for the timestamp at which these stats were last updated.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.DataStats data_stats = 4;</code>
   */
  public com.google.cloud.automl.v1beta1.DataStats getDataStats() {
    return dataStats_ == null
        ? com.google.cloud.automl.v1beta1.DataStats.getDefaultInstance()
        : dataStats_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Stats of the series of values in the column.
   * This field may be stale, see the ancestor's
   * Dataset.tables_dataset_metadata.stats_update_time field
   * for the timestamp at which these stats were last updated.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.DataStats data_stats = 4;</code>
   */
  public com.google.cloud.automl.v1beta1.DataStatsOrBuilder getDataStatsOrBuilder() {
    return getDataStats();
  }

  public static final int TOP_CORRELATED_COLUMNS_FIELD_NUMBER = 5;
  private java.util.List<com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn>
      topCorrelatedColumns_;
  /**
   *
   *
   * <pre>
   * Deprecated.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn top_correlated_columns = 5;
   * </code>
   */
  public java.util.List<com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn>
      getTopCorrelatedColumnsList() {
    return topCorrelatedColumns_;
  }
  /**
   *
   *
   * <pre>
   * Deprecated.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn top_correlated_columns = 5;
   * </code>
   */
  public java.util.List<
          ? extends com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumnOrBuilder>
      getTopCorrelatedColumnsOrBuilderList() {
    return topCorrelatedColumns_;
  }
  /**
   *
   *
   * <pre>
   * Deprecated.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn top_correlated_columns = 5;
   * </code>
   */
  public int getTopCorrelatedColumnsCount() {
    return topCorrelatedColumns_.size();
  }
  /**
   *
   *
   * <pre>
   * Deprecated.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn top_correlated_columns = 5;
   * </code>
   */
  public com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn getTopCorrelatedColumns(
      int index) {
    return topCorrelatedColumns_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Deprecated.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn top_correlated_columns = 5;
   * </code>
   */
  public com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumnOrBuilder
      getTopCorrelatedColumnsOrBuilder(int index) {
    return topCorrelatedColumns_.get(index);
  }

  public static final int ETAG_FIELD_NUMBER = 6;
  private volatile java.lang.Object etag_;
  /**
   *
   *
   * <pre>
   * Used to perform consistent read-modify-write updates. If not set, a blind
   * "overwrite" update happens.
   * </pre>
   *
   * <code>string etag = 6;</code>
   */
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Used to perform consistent read-modify-write updates. If not set, a blind
   * "overwrite" update happens.
   * </pre>
   *
   * <code>string etag = 6;</code>
   */
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (dataType_ != null) {
      output.writeMessage(2, getDataType());
    }
    if (!getDisplayNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, displayName_);
    }
    if (dataStats_ != null) {
      output.writeMessage(4, getDataStats());
    }
    for (int i = 0; i < topCorrelatedColumns_.size(); i++) {
      output.writeMessage(5, topCorrelatedColumns_.get(i));
    }
    if (!getEtagBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, etag_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (dataType_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getDataType());
    }
    if (!getDisplayNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, displayName_);
    }
    if (dataStats_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getDataStats());
    }
    for (int i = 0; i < topCorrelatedColumns_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(5, topCorrelatedColumns_.get(i));
    }
    if (!getEtagBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, etag_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.automl.v1beta1.ColumnSpec)) {
      return super.equals(obj);
    }
    com.google.cloud.automl.v1beta1.ColumnSpec other =
        (com.google.cloud.automl.v1beta1.ColumnSpec) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasDataType() != other.hasDataType()) return false;
    if (hasDataType()) {
      if (!getDataType().equals(other.getDataType())) return false;
    }
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (hasDataStats() != other.hasDataStats()) return false;
    if (hasDataStats()) {
      if (!getDataStats().equals(other.getDataStats())) return false;
    }
    if (!getTopCorrelatedColumnsList().equals(other.getTopCorrelatedColumnsList())) return false;
    if (!getEtag().equals(other.getEtag())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasDataType()) {
      hash = (37 * hash) + DATA_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getDataType().hashCode();
    }
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (hasDataStats()) {
      hash = (37 * hash) + DATA_STATS_FIELD_NUMBER;
      hash = (53 * hash) + getDataStats().hashCode();
    }
    if (getTopCorrelatedColumnsCount() > 0) {
      hash = (37 * hash) + TOP_CORRELATED_COLUMNS_FIELD_NUMBER;
      hash = (53 * hash) + getTopCorrelatedColumnsList().hashCode();
    }
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.automl.v1beta1.ColumnSpec parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1beta1.ColumnSpec parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.ColumnSpec parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1beta1.ColumnSpec parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.ColumnSpec parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1beta1.ColumnSpec parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.ColumnSpec parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1beta1.ColumnSpec parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.ColumnSpec parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1beta1.ColumnSpec parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.ColumnSpec parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1beta1.ColumnSpec parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.automl.v1beta1.ColumnSpec prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A representation of a column in a relational table. When listing them, column specs are returned in the same order in which they were
   * given on import .
   * Used by:
   *   *   Tables
   * </pre>
   *
   * Protobuf type {@code google.cloud.automl.v1beta1.ColumnSpec}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.automl.v1beta1.ColumnSpec)
      com.google.cloud.automl.v1beta1.ColumnSpecOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.automl.v1beta1.ColumnSpecOuterClass
          .internal_static_google_cloud_automl_v1beta1_ColumnSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.automl.v1beta1.ColumnSpecOuterClass
          .internal_static_google_cloud_automl_v1beta1_ColumnSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.automl.v1beta1.ColumnSpec.class,
              com.google.cloud.automl.v1beta1.ColumnSpec.Builder.class);
    }

    // Construct using com.google.cloud.automl.v1beta1.ColumnSpec.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getTopCorrelatedColumnsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      if (dataTypeBuilder_ == null) {
        dataType_ = null;
      } else {
        dataType_ = null;
        dataTypeBuilder_ = null;
      }
      displayName_ = "";

      if (dataStatsBuilder_ == null) {
        dataStats_ = null;
      } else {
        dataStats_ = null;
        dataStatsBuilder_ = null;
      }
      if (topCorrelatedColumnsBuilder_ == null) {
        topCorrelatedColumns_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
      } else {
        topCorrelatedColumnsBuilder_.clear();
      }
      etag_ = "";

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.automl.v1beta1.ColumnSpecOuterClass
          .internal_static_google_cloud_automl_v1beta1_ColumnSpec_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.ColumnSpec getDefaultInstanceForType() {
      return com.google.cloud.automl.v1beta1.ColumnSpec.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.ColumnSpec build() {
      com.google.cloud.automl.v1beta1.ColumnSpec result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.ColumnSpec buildPartial() {
      com.google.cloud.automl.v1beta1.ColumnSpec result =
          new com.google.cloud.automl.v1beta1.ColumnSpec(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      result.name_ = name_;
      if (dataTypeBuilder_ == null) {
        result.dataType_ = dataType_;
      } else {
        result.dataType_ = dataTypeBuilder_.build();
      }
      result.displayName_ = displayName_;
      if (dataStatsBuilder_ == null) {
        result.dataStats_ = dataStats_;
      } else {
        result.dataStats_ = dataStatsBuilder_.build();
      }
      if (topCorrelatedColumnsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          topCorrelatedColumns_ = java.util.Collections.unmodifiableList(topCorrelatedColumns_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.topCorrelatedColumns_ = topCorrelatedColumns_;
      } else {
        result.topCorrelatedColumns_ = topCorrelatedColumnsBuilder_.build();
      }
      result.etag_ = etag_;
      result.bitField0_ = to_bitField0_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.automl.v1beta1.ColumnSpec) {
        return mergeFrom((com.google.cloud.automl.v1beta1.ColumnSpec) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.automl.v1beta1.ColumnSpec other) {
      if (other == com.google.cloud.automl.v1beta1.ColumnSpec.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (other.hasDataType()) {
        mergeDataType(other.getDataType());
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        onChanged();
      }
      if (other.hasDataStats()) {
        mergeDataStats(other.getDataStats());
      }
      if (topCorrelatedColumnsBuilder_ == null) {
        if (!other.topCorrelatedColumns_.isEmpty()) {
          if (topCorrelatedColumns_.isEmpty()) {
            topCorrelatedColumns_ = other.topCorrelatedColumns_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureTopCorrelatedColumnsIsMutable();
            topCorrelatedColumns_.addAll(other.topCorrelatedColumns_);
          }
          onChanged();
        }
      } else {
        if (!other.topCorrelatedColumns_.isEmpty()) {
          if (topCorrelatedColumnsBuilder_.isEmpty()) {
            topCorrelatedColumnsBuilder_.dispose();
            topCorrelatedColumnsBuilder_ = null;
            topCorrelatedColumns_ = other.topCorrelatedColumns_;
            bitField0_ = (bitField0_ & ~0x00000010);
            topCorrelatedColumnsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getTopCorrelatedColumnsFieldBuilder()
                    : null;
          } else {
            topCorrelatedColumnsBuilder_.addAllMessages(other.topCorrelatedColumns_);
          }
        }
      }
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        onChanged();
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.automl.v1beta1.ColumnSpec parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloud.automl.v1beta1.ColumnSpec) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the column specs.
     * Form:
     * `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/tableSpecs/{table_spec_id}/columnSpecs/{column_spec_id}`
     * </pre>
     *
     * <code>string name = 1;</code>
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the column specs.
     * Form:
     * `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/tableSpecs/{table_spec_id}/columnSpecs/{column_spec_id}`
     * </pre>
     *
     * <code>string name = 1;</code>
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the column specs.
     * Form:
     * `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/tableSpecs/{table_spec_id}/columnSpecs/{column_spec_id}`
     * </pre>
     *
     * <code>string name = 1;</code>
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the column specs.
     * Form:
     * `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/tableSpecs/{table_spec_id}/columnSpecs/{column_spec_id}`
     * </pre>
     *
     * <code>string name = 1;</code>
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the column specs.
     * Form:
     * `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/tableSpecs/{table_spec_id}/columnSpecs/{column_spec_id}`
     * </pre>
     *
     * <code>string name = 1;</code>
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private com.google.cloud.automl.v1beta1.DataType dataType_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.DataType,
            com.google.cloud.automl.v1beta1.DataType.Builder,
            com.google.cloud.automl.v1beta1.DataTypeOrBuilder>
        dataTypeBuilder_;
    /**
     *
     *
     * <pre>
     * The data type of elements stored in the column.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DataType data_type = 2;</code>
     */
    public boolean hasDataType() {
      return dataTypeBuilder_ != null || dataType_ != null;
    }
    /**
     *
     *
     * <pre>
     * The data type of elements stored in the column.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DataType data_type = 2;</code>
     */
    public com.google.cloud.automl.v1beta1.DataType getDataType() {
      if (dataTypeBuilder_ == null) {
        return dataType_ == null
            ? com.google.cloud.automl.v1beta1.DataType.getDefaultInstance()
            : dataType_;
      } else {
        return dataTypeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The data type of elements stored in the column.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DataType data_type = 2;</code>
     */
    public Builder setDataType(com.google.cloud.automl.v1beta1.DataType value) {
      if (dataTypeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dataType_ = value;
        onChanged();
      } else {
        dataTypeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The data type of elements stored in the column.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DataType data_type = 2;</code>
     */
    public Builder setDataType(com.google.cloud.automl.v1beta1.DataType.Builder builderForValue) {
      if (dataTypeBuilder_ == null) {
        dataType_ = builderForValue.build();
        onChanged();
      } else {
        dataTypeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The data type of elements stored in the column.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DataType data_type = 2;</code>
     */
    public Builder mergeDataType(com.google.cloud.automl.v1beta1.DataType value) {
      if (dataTypeBuilder_ == null) {
        if (dataType_ != null) {
          dataType_ =
              com.google.cloud.automl.v1beta1.DataType.newBuilder(dataType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          dataType_ = value;
        }
        onChanged();
      } else {
        dataTypeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The data type of elements stored in the column.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DataType data_type = 2;</code>
     */
    public Builder clearDataType() {
      if (dataTypeBuilder_ == null) {
        dataType_ = null;
        onChanged();
      } else {
        dataType_ = null;
        dataTypeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The data type of elements stored in the column.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DataType data_type = 2;</code>
     */
    public com.google.cloud.automl.v1beta1.DataType.Builder getDataTypeBuilder() {

      onChanged();
      return getDataTypeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The data type of elements stored in the column.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DataType data_type = 2;</code>
     */
    public com.google.cloud.automl.v1beta1.DataTypeOrBuilder getDataTypeOrBuilder() {
      if (dataTypeBuilder_ != null) {
        return dataTypeBuilder_.getMessageOrBuilder();
      } else {
        return dataType_ == null
            ? com.google.cloud.automl.v1beta1.DataType.getDefaultInstance()
            : dataType_;
      }
    }
    /**
     *
     *
     * <pre>
     * The data type of elements stored in the column.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DataType data_type = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.DataType,
            com.google.cloud.automl.v1beta1.DataType.Builder,
            com.google.cloud.automl.v1beta1.DataTypeOrBuilder>
        getDataTypeFieldBuilder() {
      if (dataTypeBuilder_ == null) {
        dataTypeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.automl.v1beta1.DataType,
                com.google.cloud.automl.v1beta1.DataType.Builder,
                com.google.cloud.automl.v1beta1.DataTypeOrBuilder>(
                getDataType(), getParentForChildren(), isClean());
        dataType_ = null;
      }
      return dataTypeBuilder_;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The name of the column to show in the interface. The name can
     * be up to 100 characters long and can consist only of ASCII Latin letters
     * A-Z and a-z, ASCII digits 0-9, underscores(_), and forward slashes(/), and
     * must start with a letter or a digit.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the column to show in the interface. The name can
     * be up to 100 characters long and can consist only of ASCII Latin letters
     * A-Z and a-z, ASCII digits 0-9, underscores(_), and forward slashes(/), and
     * must start with a letter or a digit.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the column to show in the interface. The name can
     * be up to 100 characters long and can consist only of ASCII Latin letters
     * A-Z and a-z, ASCII digits 0-9, underscores(_), and forward slashes(/), and
     * must start with a letter or a digit.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      displayName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the column to show in the interface. The name can
     * be up to 100 characters long and can consist only of ASCII Latin letters
     * A-Z and a-z, ASCII digits 0-9, underscores(_), and forward slashes(/), and
     * must start with a letter or a digit.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     */
    public Builder clearDisplayName() {

      displayName_ = getDefaultInstance().getDisplayName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the column to show in the interface. The name can
     * be up to 100 characters long and can consist only of ASCII Latin letters
     * A-Z and a-z, ASCII digits 0-9, underscores(_), and forward slashes(/), and
     * must start with a letter or a digit.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      displayName_ = value;
      onChanged();
      return this;
    }

    private com.google.cloud.automl.v1beta1.DataStats dataStats_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.DataStats,
            com.google.cloud.automl.v1beta1.DataStats.Builder,
            com.google.cloud.automl.v1beta1.DataStatsOrBuilder>
        dataStatsBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Stats of the series of values in the column.
     * This field may be stale, see the ancestor's
     * Dataset.tables_dataset_metadata.stats_update_time field
     * for the timestamp at which these stats were last updated.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DataStats data_stats = 4;</code>
     */
    public boolean hasDataStats() {
      return dataStatsBuilder_ != null || dataStats_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Stats of the series of values in the column.
     * This field may be stale, see the ancestor's
     * Dataset.tables_dataset_metadata.stats_update_time field
     * for the timestamp at which these stats were last updated.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DataStats data_stats = 4;</code>
     */
    public com.google.cloud.automl.v1beta1.DataStats getDataStats() {
      if (dataStatsBuilder_ == null) {
        return dataStats_ == null
            ? com.google.cloud.automl.v1beta1.DataStats.getDefaultInstance()
            : dataStats_;
      } else {
        return dataStatsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Stats of the series of values in the column.
     * This field may be stale, see the ancestor's
     * Dataset.tables_dataset_metadata.stats_update_time field
     * for the timestamp at which these stats were last updated.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DataStats data_stats = 4;</code>
     */
    public Builder setDataStats(com.google.cloud.automl.v1beta1.DataStats value) {
      if (dataStatsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dataStats_ = value;
        onChanged();
      } else {
        dataStatsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Stats of the series of values in the column.
     * This field may be stale, see the ancestor's
     * Dataset.tables_dataset_metadata.stats_update_time field
     * for the timestamp at which these stats were last updated.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DataStats data_stats = 4;</code>
     */
    public Builder setDataStats(com.google.cloud.automl.v1beta1.DataStats.Builder builderForValue) {
      if (dataStatsBuilder_ == null) {
        dataStats_ = builderForValue.build();
        onChanged();
      } else {
        dataStatsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Stats of the series of values in the column.
     * This field may be stale, see the ancestor's
     * Dataset.tables_dataset_metadata.stats_update_time field
     * for the timestamp at which these stats were last updated.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DataStats data_stats = 4;</code>
     */
    public Builder mergeDataStats(com.google.cloud.automl.v1beta1.DataStats value) {
      if (dataStatsBuilder_ == null) {
        if (dataStats_ != null) {
          dataStats_ =
              com.google.cloud.automl.v1beta1.DataStats.newBuilder(dataStats_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          dataStats_ = value;
        }
        onChanged();
      } else {
        dataStatsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Stats of the series of values in the column.
     * This field may be stale, see the ancestor's
     * Dataset.tables_dataset_metadata.stats_update_time field
     * for the timestamp at which these stats were last updated.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DataStats data_stats = 4;</code>
     */
    public Builder clearDataStats() {
      if (dataStatsBuilder_ == null) {
        dataStats_ = null;
        onChanged();
      } else {
        dataStats_ = null;
        dataStatsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Stats of the series of values in the column.
     * This field may be stale, see the ancestor's
     * Dataset.tables_dataset_metadata.stats_update_time field
     * for the timestamp at which these stats were last updated.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DataStats data_stats = 4;</code>
     */
    public com.google.cloud.automl.v1beta1.DataStats.Builder getDataStatsBuilder() {

      onChanged();
      return getDataStatsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Stats of the series of values in the column.
     * This field may be stale, see the ancestor's
     * Dataset.tables_dataset_metadata.stats_update_time field
     * for the timestamp at which these stats were last updated.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DataStats data_stats = 4;</code>
     */
    public com.google.cloud.automl.v1beta1.DataStatsOrBuilder getDataStatsOrBuilder() {
      if (dataStatsBuilder_ != null) {
        return dataStatsBuilder_.getMessageOrBuilder();
      } else {
        return dataStats_ == null
            ? com.google.cloud.automl.v1beta1.DataStats.getDefaultInstance()
            : dataStats_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Stats of the series of values in the column.
     * This field may be stale, see the ancestor's
     * Dataset.tables_dataset_metadata.stats_update_time field
     * for the timestamp at which these stats were last updated.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DataStats data_stats = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.DataStats,
            com.google.cloud.automl.v1beta1.DataStats.Builder,
            com.google.cloud.automl.v1beta1.DataStatsOrBuilder>
        getDataStatsFieldBuilder() {
      if (dataStatsBuilder_ == null) {
        dataStatsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.automl.v1beta1.DataStats,
                com.google.cloud.automl.v1beta1.DataStats.Builder,
                com.google.cloud.automl.v1beta1.DataStatsOrBuilder>(
                getDataStats(), getParentForChildren(), isClean());
        dataStats_ = null;
      }
      return dataStatsBuilder_;
    }

    private java.util.List<com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn>
        topCorrelatedColumns_ = java.util.Collections.emptyList();

    private void ensureTopCorrelatedColumnsIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        topCorrelatedColumns_ =
            new java.util.ArrayList<com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn>(
                topCorrelatedColumns_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn,
            com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn.Builder,
            com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumnOrBuilder>
        topCorrelatedColumnsBuilder_;

    /**
     *
     *
     * <pre>
     * Deprecated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn top_correlated_columns = 5;
     * </code>
     */
    public java.util.List<com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn>
        getTopCorrelatedColumnsList() {
      if (topCorrelatedColumnsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(topCorrelatedColumns_);
      } else {
        return topCorrelatedColumnsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn top_correlated_columns = 5;
     * </code>
     */
    public int getTopCorrelatedColumnsCount() {
      if (topCorrelatedColumnsBuilder_ == null) {
        return topCorrelatedColumns_.size();
      } else {
        return topCorrelatedColumnsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn top_correlated_columns = 5;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn getTopCorrelatedColumns(
        int index) {
      if (topCorrelatedColumnsBuilder_ == null) {
        return topCorrelatedColumns_.get(index);
      } else {
        return topCorrelatedColumnsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn top_correlated_columns = 5;
     * </code>
     */
    public Builder setTopCorrelatedColumns(
        int index, com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn value) {
      if (topCorrelatedColumnsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTopCorrelatedColumnsIsMutable();
        topCorrelatedColumns_.set(index, value);
        onChanged();
      } else {
        topCorrelatedColumnsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn top_correlated_columns = 5;
     * </code>
     */
    public Builder setTopCorrelatedColumns(
        int index,
        com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn.Builder builderForValue) {
      if (topCorrelatedColumnsBuilder_ == null) {
        ensureTopCorrelatedColumnsIsMutable();
        topCorrelatedColumns_.set(index, builderForValue.build());
        onChanged();
      } else {
        topCorrelatedColumnsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn top_correlated_columns = 5;
     * </code>
     */
    public Builder addTopCorrelatedColumns(
        com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn value) {
      if (topCorrelatedColumnsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTopCorrelatedColumnsIsMutable();
        topCorrelatedColumns_.add(value);
        onChanged();
      } else {
        topCorrelatedColumnsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn top_correlated_columns = 5;
     * </code>
     */
    public Builder addTopCorrelatedColumns(
        int index, com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn value) {
      if (topCorrelatedColumnsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTopCorrelatedColumnsIsMutable();
        topCorrelatedColumns_.add(index, value);
        onChanged();
      } else {
        topCorrelatedColumnsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn top_correlated_columns = 5;
     * </code>
     */
    public Builder addTopCorrelatedColumns(
        com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn.Builder builderForValue) {
      if (topCorrelatedColumnsBuilder_ == null) {
        ensureTopCorrelatedColumnsIsMutable();
        topCorrelatedColumns_.add(builderForValue.build());
        onChanged();
      } else {
        topCorrelatedColumnsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn top_correlated_columns = 5;
     * </code>
     */
    public Builder addTopCorrelatedColumns(
        int index,
        com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn.Builder builderForValue) {
      if (topCorrelatedColumnsBuilder_ == null) {
        ensureTopCorrelatedColumnsIsMutable();
        topCorrelatedColumns_.add(index, builderForValue.build());
        onChanged();
      } else {
        topCorrelatedColumnsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn top_correlated_columns = 5;
     * </code>
     */
    public Builder addAllTopCorrelatedColumns(
        java.lang.Iterable<? extends com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn>
            values) {
      if (topCorrelatedColumnsBuilder_ == null) {
        ensureTopCorrelatedColumnsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, topCorrelatedColumns_);
        onChanged();
      } else {
        topCorrelatedColumnsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn top_correlated_columns = 5;
     * </code>
     */
    public Builder clearTopCorrelatedColumns() {
      if (topCorrelatedColumnsBuilder_ == null) {
        topCorrelatedColumns_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        topCorrelatedColumnsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn top_correlated_columns = 5;
     * </code>
     */
    public Builder removeTopCorrelatedColumns(int index) {
      if (topCorrelatedColumnsBuilder_ == null) {
        ensureTopCorrelatedColumnsIsMutable();
        topCorrelatedColumns_.remove(index);
        onChanged();
      } else {
        topCorrelatedColumnsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn top_correlated_columns = 5;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn.Builder
        getTopCorrelatedColumnsBuilder(int index) {
      return getTopCorrelatedColumnsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Deprecated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn top_correlated_columns = 5;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumnOrBuilder
        getTopCorrelatedColumnsOrBuilder(int index) {
      if (topCorrelatedColumnsBuilder_ == null) {
        return topCorrelatedColumns_.get(index);
      } else {
        return topCorrelatedColumnsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn top_correlated_columns = 5;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumnOrBuilder>
        getTopCorrelatedColumnsOrBuilderList() {
      if (topCorrelatedColumnsBuilder_ != null) {
        return topCorrelatedColumnsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(topCorrelatedColumns_);
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn top_correlated_columns = 5;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn.Builder
        addTopCorrelatedColumnsBuilder() {
      return getTopCorrelatedColumnsFieldBuilder()
          .addBuilder(
              com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Deprecated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn top_correlated_columns = 5;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn.Builder
        addTopCorrelatedColumnsBuilder(int index) {
      return getTopCorrelatedColumnsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Deprecated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn top_correlated_columns = 5;
     * </code>
     */
    public java.util.List<com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn.Builder>
        getTopCorrelatedColumnsBuilderList() {
      return getTopCorrelatedColumnsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn,
            com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn.Builder,
            com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumnOrBuilder>
        getTopCorrelatedColumnsFieldBuilder() {
      if (topCorrelatedColumnsBuilder_ == null) {
        topCorrelatedColumnsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn,
                com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumn.Builder,
                com.google.cloud.automl.v1beta1.ColumnSpec.CorrelatedColumnOrBuilder>(
                topCorrelatedColumns_,
                ((bitField0_ & 0x00000010) != 0),
                getParentForChildren(),
                isClean());
        topCorrelatedColumns_ = null;
      }
      return topCorrelatedColumnsBuilder_;
    }

    private java.lang.Object etag_ = "";
    /**
     *
     *
     * <pre>
     * Used to perform consistent read-modify-write updates. If not set, a blind
     * "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 6;</code>
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Used to perform consistent read-modify-write updates. If not set, a blind
     * "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 6;</code>
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Used to perform consistent read-modify-write updates. If not set, a blind
     * "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 6;</code>
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      etag_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Used to perform consistent read-modify-write updates. If not set, a blind
     * "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 6;</code>
     */
    public Builder clearEtag() {

      etag_ = getDefaultInstance().getEtag();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Used to perform consistent read-modify-write updates. If not set, a blind
     * "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 6;</code>
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      etag_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.automl.v1beta1.ColumnSpec)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.automl.v1beta1.ColumnSpec)
  private static final com.google.cloud.automl.v1beta1.ColumnSpec DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.automl.v1beta1.ColumnSpec();
  }

  public static com.google.cloud.automl.v1beta1.ColumnSpec getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ColumnSpec> PARSER =
      new com.google.protobuf.AbstractParser<ColumnSpec>() {
        @java.lang.Override
        public ColumnSpec parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new ColumnSpec(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<ColumnSpec> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ColumnSpec> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.automl.v1beta1.ColumnSpec getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
