/*
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/automl/v1beta1/io.proto

package com.google.cloud.automl.v1beta1;

/**
 *
 *
 * <pre>
 * Output configuration for ModelExport Action.
 * </pre>
 *
 * Protobuf type {@code google.cloud.automl.v1beta1.ModelExportOutputConfig}
 */
public final class ModelExportOutputConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.automl.v1beta1.ModelExportOutputConfig)
    ModelExportOutputConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ModelExportOutputConfig.newBuilder() to construct.
  private ModelExportOutputConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ModelExportOutputConfig() {
    modelFormat_ = "";
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private ModelExportOutputConfig(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              com.google.cloud.automl.v1beta1.GcsDestination.Builder subBuilder = null;
              if (destinationCase_ == 1) {
                subBuilder =
                    ((com.google.cloud.automl.v1beta1.GcsDestination) destination_).toBuilder();
              }
              destination_ =
                  input.readMessage(
                      com.google.cloud.automl.v1beta1.GcsDestination.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.cloud.automl.v1beta1.GcsDestination) destination_);
                destination_ = subBuilder.buildPartial();
              }
              destinationCase_ = 1;
              break;
            }
          case 18:
            {
              if (!((mutable_bitField0_ & 0x00000008) != 0)) {
                params_ =
                    com.google.protobuf.MapField.newMapField(ParamsDefaultEntryHolder.defaultEntry);
                mutable_bitField0_ |= 0x00000008;
              }
              com.google.protobuf.MapEntry<java.lang.String, java.lang.String> params__ =
                  input.readMessage(
                      ParamsDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
              params_.getMutableMap().put(params__.getKey(), params__.getValue());
              break;
            }
          case 26:
            {
              com.google.cloud.automl.v1beta1.GcrDestination.Builder subBuilder = null;
              if (destinationCase_ == 3) {
                subBuilder =
                    ((com.google.cloud.automl.v1beta1.GcrDestination) destination_).toBuilder();
              }
              destination_ =
                  input.readMessage(
                      com.google.cloud.automl.v1beta1.GcrDestination.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.cloud.automl.v1beta1.GcrDestination) destination_);
                destination_ = subBuilder.buildPartial();
              }
              destinationCase_ = 3;
              break;
            }
          case 34:
            {
              java.lang.String s = input.readStringRequireUtf8();

              modelFormat_ = s;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.automl.v1beta1.Io
        .internal_static_google_cloud_automl_v1beta1_ModelExportOutputConfig_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 2:
        return internalGetParams();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.automl.v1beta1.Io
        .internal_static_google_cloud_automl_v1beta1_ModelExportOutputConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.automl.v1beta1.ModelExportOutputConfig.class,
            com.google.cloud.automl.v1beta1.ModelExportOutputConfig.Builder.class);
  }

  private int bitField0_;
  private int destinationCase_ = 0;
  private java.lang.Object destination_;

  public enum DestinationCase implements com.google.protobuf.Internal.EnumLite {
    GCS_DESTINATION(1),
    GCR_DESTINATION(3),
    DESTINATION_NOT_SET(0);
    private final int value;

    private DestinationCase(int value) {
      this.value = value;
    }
    /** @deprecated Use {@link #forNumber(int)} instead. */
    @java.lang.Deprecated
    public static DestinationCase valueOf(int value) {
      return forNumber(value);
    }

    public static DestinationCase forNumber(int value) {
      switch (value) {
        case 1:
          return GCS_DESTINATION;
        case 3:
          return GCR_DESTINATION;
        case 0:
          return DESTINATION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public DestinationCase getDestinationCase() {
    return DestinationCase.forNumber(destinationCase_);
  }

  public static final int GCS_DESTINATION_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * The Google Cloud Storage location where the model is to be written to.
   * This location may only be set for the following model formats:
   *   "tflite", "edgetpu_tflite", "core_ml", "docker".
   *  Under the directory given as the destination a new one with name
   *  "model-export-&lt;model-display-name&gt;-&lt;timestamp-of-export-call&gt;",
   *  where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format,
   *  will be created. Inside the model and any of its supporting files
   *  will be written.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.GcsDestination gcs_destination = 1;</code>
   */
  public boolean hasGcsDestination() {
    return destinationCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * The Google Cloud Storage location where the model is to be written to.
   * This location may only be set for the following model formats:
   *   "tflite", "edgetpu_tflite", "core_ml", "docker".
   *  Under the directory given as the destination a new one with name
   *  "model-export-&lt;model-display-name&gt;-&lt;timestamp-of-export-call&gt;",
   *  where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format,
   *  will be created. Inside the model and any of its supporting files
   *  will be written.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.GcsDestination gcs_destination = 1;</code>
   */
  public com.google.cloud.automl.v1beta1.GcsDestination getGcsDestination() {
    if (destinationCase_ == 1) {
      return (com.google.cloud.automl.v1beta1.GcsDestination) destination_;
    }
    return com.google.cloud.automl.v1beta1.GcsDestination.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The Google Cloud Storage location where the model is to be written to.
   * This location may only be set for the following model formats:
   *   "tflite", "edgetpu_tflite", "core_ml", "docker".
   *  Under the directory given as the destination a new one with name
   *  "model-export-&lt;model-display-name&gt;-&lt;timestamp-of-export-call&gt;",
   *  where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format,
   *  will be created. Inside the model and any of its supporting files
   *  will be written.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.GcsDestination gcs_destination = 1;</code>
   */
  public com.google.cloud.automl.v1beta1.GcsDestinationOrBuilder getGcsDestinationOrBuilder() {
    if (destinationCase_ == 1) {
      return (com.google.cloud.automl.v1beta1.GcsDestination) destination_;
    }
    return com.google.cloud.automl.v1beta1.GcsDestination.getDefaultInstance();
  }

  public static final int GCR_DESTINATION_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * The GCR location where model image is to be pushed to. This location
   * may only be set for the following model formats:
   *   "docker".
   * The model image will be created under the given URI.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.GcrDestination gcr_destination = 3;</code>
   */
  public boolean hasGcrDestination() {
    return destinationCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * The GCR location where model image is to be pushed to. This location
   * may only be set for the following model formats:
   *   "docker".
   * The model image will be created under the given URI.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.GcrDestination gcr_destination = 3;</code>
   */
  public com.google.cloud.automl.v1beta1.GcrDestination getGcrDestination() {
    if (destinationCase_ == 3) {
      return (com.google.cloud.automl.v1beta1.GcrDestination) destination_;
    }
    return com.google.cloud.automl.v1beta1.GcrDestination.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The GCR location where model image is to be pushed to. This location
   * may only be set for the following model formats:
   *   "docker".
   * The model image will be created under the given URI.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.GcrDestination gcr_destination = 3;</code>
   */
  public com.google.cloud.automl.v1beta1.GcrDestinationOrBuilder getGcrDestinationOrBuilder() {
    if (destinationCase_ == 3) {
      return (com.google.cloud.automl.v1beta1.GcrDestination) destination_;
    }
    return com.google.cloud.automl.v1beta1.GcrDestination.getDefaultInstance();
  }

  public static final int MODEL_FORMAT_FIELD_NUMBER = 4;
  private volatile java.lang.Object modelFormat_;
  /**
   *
   *
   * <pre>
   * The format in which the model must be exported. The available, and default,
   * formats depend on the problem and model type (if given problem and type
   * combination doesn't have a format listed, it means its models are not
   * exportable):
   * *  For Image Classification mobile-low-latency-1, mobile-versatile-1,
   *        mobile-high-accuracy-1:
   *      "tflite" (default), "edgetpu_tflite", "tf_saved_model", "docker".
   * *  For Image Classification mobile-core-ml-low-latency-1,
   *        mobile-core-ml-versatile-1, mobile-core-ml-high-accuracy-1:
   *      "core_ml" (default).
   * Formats description:
   * * tflite - Used for Android mobile devices.
   * * edgetpu_tflite - Used for [Edge TPU](https://cloud.google.com/edge-tpu/)
   *                    devices.
   * * tf_saved_model - A tensorflow model in SavedModel format.
   * * docker - Used for Docker containers. Use the params field to customize
   *            the container. The container is verified to work correctly on
   *            ubuntu 16.04 operating system. See more at
   *            [containers
   * quickstart](https:
   * //cloud.google.com/vision/automl/docs/containers-gcs-quickstart)
   * * core_ml - Used for iOS mobile devices.
   * </pre>
   *
   * <code>string model_format = 4;</code>
   */
  public java.lang.String getModelFormat() {
    java.lang.Object ref = modelFormat_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      modelFormat_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The format in which the model must be exported. The available, and default,
   * formats depend on the problem and model type (if given problem and type
   * combination doesn't have a format listed, it means its models are not
   * exportable):
   * *  For Image Classification mobile-low-latency-1, mobile-versatile-1,
   *        mobile-high-accuracy-1:
   *      "tflite" (default), "edgetpu_tflite", "tf_saved_model", "docker".
   * *  For Image Classification mobile-core-ml-low-latency-1,
   *        mobile-core-ml-versatile-1, mobile-core-ml-high-accuracy-1:
   *      "core_ml" (default).
   * Formats description:
   * * tflite - Used for Android mobile devices.
   * * edgetpu_tflite - Used for [Edge TPU](https://cloud.google.com/edge-tpu/)
   *                    devices.
   * * tf_saved_model - A tensorflow model in SavedModel format.
   * * docker - Used for Docker containers. Use the params field to customize
   *            the container. The container is verified to work correctly on
   *            ubuntu 16.04 operating system. See more at
   *            [containers
   * quickstart](https:
   * //cloud.google.com/vision/automl/docs/containers-gcs-quickstart)
   * * core_ml - Used for iOS mobile devices.
   * </pre>
   *
   * <code>string model_format = 4;</code>
   */
  public com.google.protobuf.ByteString getModelFormatBytes() {
    java.lang.Object ref = modelFormat_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      modelFormat_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PARAMS_FIELD_NUMBER = 2;

  private static final class ParamsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.automl.v1beta1.Io
                .internal_static_google_cloud_automl_v1beta1_ModelExportOutputConfig_ParamsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> params_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetParams() {
    if (params_ == null) {
      return com.google.protobuf.MapField.emptyMapField(ParamsDefaultEntryHolder.defaultEntry);
    }
    return params_;
  }

  public int getParamsCount() {
    return internalGetParams().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Additional model-type and format specific parameters describing the
   * requirements for the to be exported model files, any string must be up to
   * 25000 characters long.
   *  * For `docker` format:
   *     `cpu_architecture` - (string) "x86_64" (default).
   *     `gpu_architecture` - (string) "none" (default), "nvidia".
   * </pre>
   *
   * <code>map&lt;string, string&gt; params = 2;</code>
   */
  public boolean containsParams(java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    return internalGetParams().getMap().containsKey(key);
  }
  /** Use {@link #getParamsMap()} instead. */
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getParams() {
    return getParamsMap();
  }
  /**
   *
   *
   * <pre>
   * Additional model-type and format specific parameters describing the
   * requirements for the to be exported model files, any string must be up to
   * 25000 characters long.
   *  * For `docker` format:
   *     `cpu_architecture` - (string) "x86_64" (default).
   *     `gpu_architecture` - (string) "none" (default), "nvidia".
   * </pre>
   *
   * <code>map&lt;string, string&gt; params = 2;</code>
   */
  public java.util.Map<java.lang.String, java.lang.String> getParamsMap() {
    return internalGetParams().getMap();
  }
  /**
   *
   *
   * <pre>
   * Additional model-type and format specific parameters describing the
   * requirements for the to be exported model files, any string must be up to
   * 25000 characters long.
   *  * For `docker` format:
   *     `cpu_architecture` - (string) "x86_64" (default).
   *     `gpu_architecture` - (string) "none" (default), "nvidia".
   * </pre>
   *
   * <code>map&lt;string, string&gt; params = 2;</code>
   */
  public java.lang.String getParamsOrDefault(java.lang.String key, java.lang.String defaultValue) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetParams().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Additional model-type and format specific parameters describing the
   * requirements for the to be exported model files, any string must be up to
   * 25000 characters long.
   *  * For `docker` format:
   *     `cpu_architecture` - (string) "x86_64" (default).
   *     `gpu_architecture` - (string) "none" (default), "nvidia".
   * </pre>
   *
   * <code>map&lt;string, string&gt; params = 2;</code>
   */
  public java.lang.String getParamsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetParams().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (destinationCase_ == 1) {
      output.writeMessage(1, (com.google.cloud.automl.v1beta1.GcsDestination) destination_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetParams(), ParamsDefaultEntryHolder.defaultEntry, 2);
    if (destinationCase_ == 3) {
      output.writeMessage(3, (com.google.cloud.automl.v1beta1.GcrDestination) destination_);
    }
    if (!getModelFormatBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, modelFormat_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (destinationCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.cloud.automl.v1beta1.GcsDestination) destination_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetParams().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> params__ =
          ParamsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, params__);
    }
    if (destinationCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.automl.v1beta1.GcrDestination) destination_);
    }
    if (!getModelFormatBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, modelFormat_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.automl.v1beta1.ModelExportOutputConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.automl.v1beta1.ModelExportOutputConfig other =
        (com.google.cloud.automl.v1beta1.ModelExportOutputConfig) obj;

    if (!getModelFormat().equals(other.getModelFormat())) return false;
    if (!internalGetParams().equals(other.internalGetParams())) return false;
    if (!getDestinationCase().equals(other.getDestinationCase())) return false;
    switch (destinationCase_) {
      case 1:
        if (!getGcsDestination().equals(other.getGcsDestination())) return false;
        break;
      case 3:
        if (!getGcrDestination().equals(other.getGcrDestination())) return false;
        break;
      case 0:
      default:
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + MODEL_FORMAT_FIELD_NUMBER;
    hash = (53 * hash) + getModelFormat().hashCode();
    if (!internalGetParams().getMap().isEmpty()) {
      hash = (37 * hash) + PARAMS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetParams().hashCode();
    }
    switch (destinationCase_) {
      case 1:
        hash = (37 * hash) + GCS_DESTINATION_FIELD_NUMBER;
        hash = (53 * hash) + getGcsDestination().hashCode();
        break;
      case 3:
        hash = (37 * hash) + GCR_DESTINATION_FIELD_NUMBER;
        hash = (53 * hash) + getGcrDestination().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.automl.v1beta1.ModelExportOutputConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1beta1.ModelExportOutputConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.ModelExportOutputConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1beta1.ModelExportOutputConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.ModelExportOutputConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1beta1.ModelExportOutputConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.ModelExportOutputConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1beta1.ModelExportOutputConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.ModelExportOutputConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1beta1.ModelExportOutputConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.ModelExportOutputConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1beta1.ModelExportOutputConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.automl.v1beta1.ModelExportOutputConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Output configuration for ModelExport Action.
   * </pre>
   *
   * Protobuf type {@code google.cloud.automl.v1beta1.ModelExportOutputConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.automl.v1beta1.ModelExportOutputConfig)
      com.google.cloud.automl.v1beta1.ModelExportOutputConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.automl.v1beta1.Io
          .internal_static_google_cloud_automl_v1beta1_ModelExportOutputConfig_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 2:
          return internalGetParams();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 2:
          return internalGetMutableParams();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.automl.v1beta1.Io
          .internal_static_google_cloud_automl_v1beta1_ModelExportOutputConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.automl.v1beta1.ModelExportOutputConfig.class,
              com.google.cloud.automl.v1beta1.ModelExportOutputConfig.Builder.class);
    }

    // Construct using com.google.cloud.automl.v1beta1.ModelExportOutputConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      modelFormat_ = "";

      internalGetMutableParams().clear();
      destinationCase_ = 0;
      destination_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.automl.v1beta1.Io
          .internal_static_google_cloud_automl_v1beta1_ModelExportOutputConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.ModelExportOutputConfig getDefaultInstanceForType() {
      return com.google.cloud.automl.v1beta1.ModelExportOutputConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.ModelExportOutputConfig build() {
      com.google.cloud.automl.v1beta1.ModelExportOutputConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.ModelExportOutputConfig buildPartial() {
      com.google.cloud.automl.v1beta1.ModelExportOutputConfig result =
          new com.google.cloud.automl.v1beta1.ModelExportOutputConfig(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (destinationCase_ == 1) {
        if (gcsDestinationBuilder_ == null) {
          result.destination_ = destination_;
        } else {
          result.destination_ = gcsDestinationBuilder_.build();
        }
      }
      if (destinationCase_ == 3) {
        if (gcrDestinationBuilder_ == null) {
          result.destination_ = destination_;
        } else {
          result.destination_ = gcrDestinationBuilder_.build();
        }
      }
      result.modelFormat_ = modelFormat_;
      result.params_ = internalGetParams();
      result.params_.makeImmutable();
      result.bitField0_ = to_bitField0_;
      result.destinationCase_ = destinationCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.automl.v1beta1.ModelExportOutputConfig) {
        return mergeFrom((com.google.cloud.automl.v1beta1.ModelExportOutputConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.automl.v1beta1.ModelExportOutputConfig other) {
      if (other == com.google.cloud.automl.v1beta1.ModelExportOutputConfig.getDefaultInstance())
        return this;
      if (!other.getModelFormat().isEmpty()) {
        modelFormat_ = other.modelFormat_;
        onChanged();
      }
      internalGetMutableParams().mergeFrom(other.internalGetParams());
      switch (other.getDestinationCase()) {
        case GCS_DESTINATION:
          {
            mergeGcsDestination(other.getGcsDestination());
            break;
          }
        case GCR_DESTINATION:
          {
            mergeGcrDestination(other.getGcrDestination());
            break;
          }
        case DESTINATION_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.automl.v1beta1.ModelExportOutputConfig parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.automl.v1beta1.ModelExportOutputConfig) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int destinationCase_ = 0;
    private java.lang.Object destination_;

    public DestinationCase getDestinationCase() {
      return DestinationCase.forNumber(destinationCase_);
    }

    public Builder clearDestination() {
      destinationCase_ = 0;
      destination_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.GcsDestination,
            com.google.cloud.automl.v1beta1.GcsDestination.Builder,
            com.google.cloud.automl.v1beta1.GcsDestinationOrBuilder>
        gcsDestinationBuilder_;
    /**
     *
     *
     * <pre>
     * The Google Cloud Storage location where the model is to be written to.
     * This location may only be set for the following model formats:
     *   "tflite", "edgetpu_tflite", "core_ml", "docker".
     *  Under the directory given as the destination a new one with name
     *  "model-export-&lt;model-display-name&gt;-&lt;timestamp-of-export-call&gt;",
     *  where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format,
     *  will be created. Inside the model and any of its supporting files
     *  will be written.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.GcsDestination gcs_destination = 1;</code>
     */
    public boolean hasGcsDestination() {
      return destinationCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Storage location where the model is to be written to.
     * This location may only be set for the following model formats:
     *   "tflite", "edgetpu_tflite", "core_ml", "docker".
     *  Under the directory given as the destination a new one with name
     *  "model-export-&lt;model-display-name&gt;-&lt;timestamp-of-export-call&gt;",
     *  where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format,
     *  will be created. Inside the model and any of its supporting files
     *  will be written.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.GcsDestination gcs_destination = 1;</code>
     */
    public com.google.cloud.automl.v1beta1.GcsDestination getGcsDestination() {
      if (gcsDestinationBuilder_ == null) {
        if (destinationCase_ == 1) {
          return (com.google.cloud.automl.v1beta1.GcsDestination) destination_;
        }
        return com.google.cloud.automl.v1beta1.GcsDestination.getDefaultInstance();
      } else {
        if (destinationCase_ == 1) {
          return gcsDestinationBuilder_.getMessage();
        }
        return com.google.cloud.automl.v1beta1.GcsDestination.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Storage location where the model is to be written to.
     * This location may only be set for the following model formats:
     *   "tflite", "edgetpu_tflite", "core_ml", "docker".
     *  Under the directory given as the destination a new one with name
     *  "model-export-&lt;model-display-name&gt;-&lt;timestamp-of-export-call&gt;",
     *  where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format,
     *  will be created. Inside the model and any of its supporting files
     *  will be written.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.GcsDestination gcs_destination = 1;</code>
     */
    public Builder setGcsDestination(com.google.cloud.automl.v1beta1.GcsDestination value) {
      if (gcsDestinationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        destination_ = value;
        onChanged();
      } else {
        gcsDestinationBuilder_.setMessage(value);
      }
      destinationCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Storage location where the model is to be written to.
     * This location may only be set for the following model formats:
     *   "tflite", "edgetpu_tflite", "core_ml", "docker".
     *  Under the directory given as the destination a new one with name
     *  "model-export-&lt;model-display-name&gt;-&lt;timestamp-of-export-call&gt;",
     *  where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format,
     *  will be created. Inside the model and any of its supporting files
     *  will be written.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.GcsDestination gcs_destination = 1;</code>
     */
    public Builder setGcsDestination(
        com.google.cloud.automl.v1beta1.GcsDestination.Builder builderForValue) {
      if (gcsDestinationBuilder_ == null) {
        destination_ = builderForValue.build();
        onChanged();
      } else {
        gcsDestinationBuilder_.setMessage(builderForValue.build());
      }
      destinationCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Storage location where the model is to be written to.
     * This location may only be set for the following model formats:
     *   "tflite", "edgetpu_tflite", "core_ml", "docker".
     *  Under the directory given as the destination a new one with name
     *  "model-export-&lt;model-display-name&gt;-&lt;timestamp-of-export-call&gt;",
     *  where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format,
     *  will be created. Inside the model and any of its supporting files
     *  will be written.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.GcsDestination gcs_destination = 1;</code>
     */
    public Builder mergeGcsDestination(com.google.cloud.automl.v1beta1.GcsDestination value) {
      if (gcsDestinationBuilder_ == null) {
        if (destinationCase_ == 1
            && destination_
                != com.google.cloud.automl.v1beta1.GcsDestination.getDefaultInstance()) {
          destination_ =
              com.google.cloud.automl.v1beta1.GcsDestination.newBuilder(
                      (com.google.cloud.automl.v1beta1.GcsDestination) destination_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          destination_ = value;
        }
        onChanged();
      } else {
        if (destinationCase_ == 1) {
          gcsDestinationBuilder_.mergeFrom(value);
        }
        gcsDestinationBuilder_.setMessage(value);
      }
      destinationCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Storage location where the model is to be written to.
     * This location may only be set for the following model formats:
     *   "tflite", "edgetpu_tflite", "core_ml", "docker".
     *  Under the directory given as the destination a new one with name
     *  "model-export-&lt;model-display-name&gt;-&lt;timestamp-of-export-call&gt;",
     *  where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format,
     *  will be created. Inside the model and any of its supporting files
     *  will be written.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.GcsDestination gcs_destination = 1;</code>
     */
    public Builder clearGcsDestination() {
      if (gcsDestinationBuilder_ == null) {
        if (destinationCase_ == 1) {
          destinationCase_ = 0;
          destination_ = null;
          onChanged();
        }
      } else {
        if (destinationCase_ == 1) {
          destinationCase_ = 0;
          destination_ = null;
        }
        gcsDestinationBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Storage location where the model is to be written to.
     * This location may only be set for the following model formats:
     *   "tflite", "edgetpu_tflite", "core_ml", "docker".
     *  Under the directory given as the destination a new one with name
     *  "model-export-&lt;model-display-name&gt;-&lt;timestamp-of-export-call&gt;",
     *  where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format,
     *  will be created. Inside the model and any of its supporting files
     *  will be written.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.GcsDestination gcs_destination = 1;</code>
     */
    public com.google.cloud.automl.v1beta1.GcsDestination.Builder getGcsDestinationBuilder() {
      return getGcsDestinationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Storage location where the model is to be written to.
     * This location may only be set for the following model formats:
     *   "tflite", "edgetpu_tflite", "core_ml", "docker".
     *  Under the directory given as the destination a new one with name
     *  "model-export-&lt;model-display-name&gt;-&lt;timestamp-of-export-call&gt;",
     *  where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format,
     *  will be created. Inside the model and any of its supporting files
     *  will be written.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.GcsDestination gcs_destination = 1;</code>
     */
    public com.google.cloud.automl.v1beta1.GcsDestinationOrBuilder getGcsDestinationOrBuilder() {
      if ((destinationCase_ == 1) && (gcsDestinationBuilder_ != null)) {
        return gcsDestinationBuilder_.getMessageOrBuilder();
      } else {
        if (destinationCase_ == 1) {
          return (com.google.cloud.automl.v1beta1.GcsDestination) destination_;
        }
        return com.google.cloud.automl.v1beta1.GcsDestination.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Storage location where the model is to be written to.
     * This location may only be set for the following model formats:
     *   "tflite", "edgetpu_tflite", "core_ml", "docker".
     *  Under the directory given as the destination a new one with name
     *  "model-export-&lt;model-display-name&gt;-&lt;timestamp-of-export-call&gt;",
     *  where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format,
     *  will be created. Inside the model and any of its supporting files
     *  will be written.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.GcsDestination gcs_destination = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.GcsDestination,
            com.google.cloud.automl.v1beta1.GcsDestination.Builder,
            com.google.cloud.automl.v1beta1.GcsDestinationOrBuilder>
        getGcsDestinationFieldBuilder() {
      if (gcsDestinationBuilder_ == null) {
        if (!(destinationCase_ == 1)) {
          destination_ = com.google.cloud.automl.v1beta1.GcsDestination.getDefaultInstance();
        }
        gcsDestinationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.automl.v1beta1.GcsDestination,
                com.google.cloud.automl.v1beta1.GcsDestination.Builder,
                com.google.cloud.automl.v1beta1.GcsDestinationOrBuilder>(
                (com.google.cloud.automl.v1beta1.GcsDestination) destination_,
                getParentForChildren(),
                isClean());
        destination_ = null;
      }
      destinationCase_ = 1;
      onChanged();
      ;
      return gcsDestinationBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.GcrDestination,
            com.google.cloud.automl.v1beta1.GcrDestination.Builder,
            com.google.cloud.automl.v1beta1.GcrDestinationOrBuilder>
        gcrDestinationBuilder_;
    /**
     *
     *
     * <pre>
     * The GCR location where model image is to be pushed to. This location
     * may only be set for the following model formats:
     *   "docker".
     * The model image will be created under the given URI.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.GcrDestination gcr_destination = 3;</code>
     */
    public boolean hasGcrDestination() {
      return destinationCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * The GCR location where model image is to be pushed to. This location
     * may only be set for the following model formats:
     *   "docker".
     * The model image will be created under the given URI.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.GcrDestination gcr_destination = 3;</code>
     */
    public com.google.cloud.automl.v1beta1.GcrDestination getGcrDestination() {
      if (gcrDestinationBuilder_ == null) {
        if (destinationCase_ == 3) {
          return (com.google.cloud.automl.v1beta1.GcrDestination) destination_;
        }
        return com.google.cloud.automl.v1beta1.GcrDestination.getDefaultInstance();
      } else {
        if (destinationCase_ == 3) {
          return gcrDestinationBuilder_.getMessage();
        }
        return com.google.cloud.automl.v1beta1.GcrDestination.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The GCR location where model image is to be pushed to. This location
     * may only be set for the following model formats:
     *   "docker".
     * The model image will be created under the given URI.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.GcrDestination gcr_destination = 3;</code>
     */
    public Builder setGcrDestination(com.google.cloud.automl.v1beta1.GcrDestination value) {
      if (gcrDestinationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        destination_ = value;
        onChanged();
      } else {
        gcrDestinationBuilder_.setMessage(value);
      }
      destinationCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The GCR location where model image is to be pushed to. This location
     * may only be set for the following model formats:
     *   "docker".
     * The model image will be created under the given URI.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.GcrDestination gcr_destination = 3;</code>
     */
    public Builder setGcrDestination(
        com.google.cloud.automl.v1beta1.GcrDestination.Builder builderForValue) {
      if (gcrDestinationBuilder_ == null) {
        destination_ = builderForValue.build();
        onChanged();
      } else {
        gcrDestinationBuilder_.setMessage(builderForValue.build());
      }
      destinationCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The GCR location where model image is to be pushed to. This location
     * may only be set for the following model formats:
     *   "docker".
     * The model image will be created under the given URI.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.GcrDestination gcr_destination = 3;</code>
     */
    public Builder mergeGcrDestination(com.google.cloud.automl.v1beta1.GcrDestination value) {
      if (gcrDestinationBuilder_ == null) {
        if (destinationCase_ == 3
            && destination_
                != com.google.cloud.automl.v1beta1.GcrDestination.getDefaultInstance()) {
          destination_ =
              com.google.cloud.automl.v1beta1.GcrDestination.newBuilder(
                      (com.google.cloud.automl.v1beta1.GcrDestination) destination_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          destination_ = value;
        }
        onChanged();
      } else {
        if (destinationCase_ == 3) {
          gcrDestinationBuilder_.mergeFrom(value);
        }
        gcrDestinationBuilder_.setMessage(value);
      }
      destinationCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The GCR location where model image is to be pushed to. This location
     * may only be set for the following model formats:
     *   "docker".
     * The model image will be created under the given URI.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.GcrDestination gcr_destination = 3;</code>
     */
    public Builder clearGcrDestination() {
      if (gcrDestinationBuilder_ == null) {
        if (destinationCase_ == 3) {
          destinationCase_ = 0;
          destination_ = null;
          onChanged();
        }
      } else {
        if (destinationCase_ == 3) {
          destinationCase_ = 0;
          destination_ = null;
        }
        gcrDestinationBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The GCR location where model image is to be pushed to. This location
     * may only be set for the following model formats:
     *   "docker".
     * The model image will be created under the given URI.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.GcrDestination gcr_destination = 3;</code>
     */
    public com.google.cloud.automl.v1beta1.GcrDestination.Builder getGcrDestinationBuilder() {
      return getGcrDestinationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The GCR location where model image is to be pushed to. This location
     * may only be set for the following model formats:
     *   "docker".
     * The model image will be created under the given URI.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.GcrDestination gcr_destination = 3;</code>
     */
    public com.google.cloud.automl.v1beta1.GcrDestinationOrBuilder getGcrDestinationOrBuilder() {
      if ((destinationCase_ == 3) && (gcrDestinationBuilder_ != null)) {
        return gcrDestinationBuilder_.getMessageOrBuilder();
      } else {
        if (destinationCase_ == 3) {
          return (com.google.cloud.automl.v1beta1.GcrDestination) destination_;
        }
        return com.google.cloud.automl.v1beta1.GcrDestination.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The GCR location where model image is to be pushed to. This location
     * may only be set for the following model formats:
     *   "docker".
     * The model image will be created under the given URI.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.GcrDestination gcr_destination = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.GcrDestination,
            com.google.cloud.automl.v1beta1.GcrDestination.Builder,
            com.google.cloud.automl.v1beta1.GcrDestinationOrBuilder>
        getGcrDestinationFieldBuilder() {
      if (gcrDestinationBuilder_ == null) {
        if (!(destinationCase_ == 3)) {
          destination_ = com.google.cloud.automl.v1beta1.GcrDestination.getDefaultInstance();
        }
        gcrDestinationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.automl.v1beta1.GcrDestination,
                com.google.cloud.automl.v1beta1.GcrDestination.Builder,
                com.google.cloud.automl.v1beta1.GcrDestinationOrBuilder>(
                (com.google.cloud.automl.v1beta1.GcrDestination) destination_,
                getParentForChildren(),
                isClean());
        destination_ = null;
      }
      destinationCase_ = 3;
      onChanged();
      ;
      return gcrDestinationBuilder_;
    }

    private java.lang.Object modelFormat_ = "";
    /**
     *
     *
     * <pre>
     * The format in which the model must be exported. The available, and default,
     * formats depend on the problem and model type (if given problem and type
     * combination doesn't have a format listed, it means its models are not
     * exportable):
     * *  For Image Classification mobile-low-latency-1, mobile-versatile-1,
     *        mobile-high-accuracy-1:
     *      "tflite" (default), "edgetpu_tflite", "tf_saved_model", "docker".
     * *  For Image Classification mobile-core-ml-low-latency-1,
     *        mobile-core-ml-versatile-1, mobile-core-ml-high-accuracy-1:
     *      "core_ml" (default).
     * Formats description:
     * * tflite - Used for Android mobile devices.
     * * edgetpu_tflite - Used for [Edge TPU](https://cloud.google.com/edge-tpu/)
     *                    devices.
     * * tf_saved_model - A tensorflow model in SavedModel format.
     * * docker - Used for Docker containers. Use the params field to customize
     *            the container. The container is verified to work correctly on
     *            ubuntu 16.04 operating system. See more at
     *            [containers
     * quickstart](https:
     * //cloud.google.com/vision/automl/docs/containers-gcs-quickstart)
     * * core_ml - Used for iOS mobile devices.
     * </pre>
     *
     * <code>string model_format = 4;</code>
     */
    public java.lang.String getModelFormat() {
      java.lang.Object ref = modelFormat_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        modelFormat_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The format in which the model must be exported. The available, and default,
     * formats depend on the problem and model type (if given problem and type
     * combination doesn't have a format listed, it means its models are not
     * exportable):
     * *  For Image Classification mobile-low-latency-1, mobile-versatile-1,
     *        mobile-high-accuracy-1:
     *      "tflite" (default), "edgetpu_tflite", "tf_saved_model", "docker".
     * *  For Image Classification mobile-core-ml-low-latency-1,
     *        mobile-core-ml-versatile-1, mobile-core-ml-high-accuracy-1:
     *      "core_ml" (default).
     * Formats description:
     * * tflite - Used for Android mobile devices.
     * * edgetpu_tflite - Used for [Edge TPU](https://cloud.google.com/edge-tpu/)
     *                    devices.
     * * tf_saved_model - A tensorflow model in SavedModel format.
     * * docker - Used for Docker containers. Use the params field to customize
     *            the container. The container is verified to work correctly on
     *            ubuntu 16.04 operating system. See more at
     *            [containers
     * quickstart](https:
     * //cloud.google.com/vision/automl/docs/containers-gcs-quickstart)
     * * core_ml - Used for iOS mobile devices.
     * </pre>
     *
     * <code>string model_format = 4;</code>
     */
    public com.google.protobuf.ByteString getModelFormatBytes() {
      java.lang.Object ref = modelFormat_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        modelFormat_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The format in which the model must be exported. The available, and default,
     * formats depend on the problem and model type (if given problem and type
     * combination doesn't have a format listed, it means its models are not
     * exportable):
     * *  For Image Classification mobile-low-latency-1, mobile-versatile-1,
     *        mobile-high-accuracy-1:
     *      "tflite" (default), "edgetpu_tflite", "tf_saved_model", "docker".
     * *  For Image Classification mobile-core-ml-low-latency-1,
     *        mobile-core-ml-versatile-1, mobile-core-ml-high-accuracy-1:
     *      "core_ml" (default).
     * Formats description:
     * * tflite - Used for Android mobile devices.
     * * edgetpu_tflite - Used for [Edge TPU](https://cloud.google.com/edge-tpu/)
     *                    devices.
     * * tf_saved_model - A tensorflow model in SavedModel format.
     * * docker - Used for Docker containers. Use the params field to customize
     *            the container. The container is verified to work correctly on
     *            ubuntu 16.04 operating system. See more at
     *            [containers
     * quickstart](https:
     * //cloud.google.com/vision/automl/docs/containers-gcs-quickstart)
     * * core_ml - Used for iOS mobile devices.
     * </pre>
     *
     * <code>string model_format = 4;</code>
     */
    public Builder setModelFormat(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      modelFormat_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The format in which the model must be exported. The available, and default,
     * formats depend on the problem and model type (if given problem and type
     * combination doesn't have a format listed, it means its models are not
     * exportable):
     * *  For Image Classification mobile-low-latency-1, mobile-versatile-1,
     *        mobile-high-accuracy-1:
     *      "tflite" (default), "edgetpu_tflite", "tf_saved_model", "docker".
     * *  For Image Classification mobile-core-ml-low-latency-1,
     *        mobile-core-ml-versatile-1, mobile-core-ml-high-accuracy-1:
     *      "core_ml" (default).
     * Formats description:
     * * tflite - Used for Android mobile devices.
     * * edgetpu_tflite - Used for [Edge TPU](https://cloud.google.com/edge-tpu/)
     *                    devices.
     * * tf_saved_model - A tensorflow model in SavedModel format.
     * * docker - Used for Docker containers. Use the params field to customize
     *            the container. The container is verified to work correctly on
     *            ubuntu 16.04 operating system. See more at
     *            [containers
     * quickstart](https:
     * //cloud.google.com/vision/automl/docs/containers-gcs-quickstart)
     * * core_ml - Used for iOS mobile devices.
     * </pre>
     *
     * <code>string model_format = 4;</code>
     */
    public Builder clearModelFormat() {

      modelFormat_ = getDefaultInstance().getModelFormat();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The format in which the model must be exported. The available, and default,
     * formats depend on the problem and model type (if given problem and type
     * combination doesn't have a format listed, it means its models are not
     * exportable):
     * *  For Image Classification mobile-low-latency-1, mobile-versatile-1,
     *        mobile-high-accuracy-1:
     *      "tflite" (default), "edgetpu_tflite", "tf_saved_model", "docker".
     * *  For Image Classification mobile-core-ml-low-latency-1,
     *        mobile-core-ml-versatile-1, mobile-core-ml-high-accuracy-1:
     *      "core_ml" (default).
     * Formats description:
     * * tflite - Used for Android mobile devices.
     * * edgetpu_tflite - Used for [Edge TPU](https://cloud.google.com/edge-tpu/)
     *                    devices.
     * * tf_saved_model - A tensorflow model in SavedModel format.
     * * docker - Used for Docker containers. Use the params field to customize
     *            the container. The container is verified to work correctly on
     *            ubuntu 16.04 operating system. See more at
     *            [containers
     * quickstart](https:
     * //cloud.google.com/vision/automl/docs/containers-gcs-quickstart)
     * * core_ml - Used for iOS mobile devices.
     * </pre>
     *
     * <code>string model_format = 4;</code>
     */
    public Builder setModelFormatBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      modelFormat_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> params_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetParams() {
      if (params_ == null) {
        return com.google.protobuf.MapField.emptyMapField(ParamsDefaultEntryHolder.defaultEntry);
      }
      return params_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableParams() {
      onChanged();
      ;
      if (params_ == null) {
        params_ = com.google.protobuf.MapField.newMapField(ParamsDefaultEntryHolder.defaultEntry);
      }
      if (!params_.isMutable()) {
        params_ = params_.copy();
      }
      return params_;
    }

    public int getParamsCount() {
      return internalGetParams().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Additional model-type and format specific parameters describing the
     * requirements for the to be exported model files, any string must be up to
     * 25000 characters long.
     *  * For `docker` format:
     *     `cpu_architecture` - (string) "x86_64" (default).
     *     `gpu_architecture` - (string) "none" (default), "nvidia".
     * </pre>
     *
     * <code>map&lt;string, string&gt; params = 2;</code>
     */
    public boolean containsParams(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      return internalGetParams().getMap().containsKey(key);
    }
    /** Use {@link #getParamsMap()} instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getParams() {
      return getParamsMap();
    }
    /**
     *
     *
     * <pre>
     * Additional model-type and format specific parameters describing the
     * requirements for the to be exported model files, any string must be up to
     * 25000 characters long.
     *  * For `docker` format:
     *     `cpu_architecture` - (string) "x86_64" (default).
     *     `gpu_architecture` - (string) "none" (default), "nvidia".
     * </pre>
     *
     * <code>map&lt;string, string&gt; params = 2;</code>
     */
    public java.util.Map<java.lang.String, java.lang.String> getParamsMap() {
      return internalGetParams().getMap();
    }
    /**
     *
     *
     * <pre>
     * Additional model-type and format specific parameters describing the
     * requirements for the to be exported model files, any string must be up to
     * 25000 characters long.
     *  * For `docker` format:
     *     `cpu_architecture` - (string) "x86_64" (default).
     *     `gpu_architecture` - (string) "none" (default), "nvidia".
     * </pre>
     *
     * <code>map&lt;string, string&gt; params = 2;</code>
     */
    public java.lang.String getParamsOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetParams().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Additional model-type and format specific parameters describing the
     * requirements for the to be exported model files, any string must be up to
     * 25000 characters long.
     *  * For `docker` format:
     *     `cpu_architecture` - (string) "x86_64" (default).
     *     `gpu_architecture` - (string) "none" (default), "nvidia".
     * </pre>
     *
     * <code>map&lt;string, string&gt; params = 2;</code>
     */
    public java.lang.String getParamsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetParams().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearParams() {
      internalGetMutableParams().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional model-type and format specific parameters describing the
     * requirements for the to be exported model files, any string must be up to
     * 25000 characters long.
     *  * For `docker` format:
     *     `cpu_architecture` - (string) "x86_64" (default).
     *     `gpu_architecture` - (string) "none" (default), "nvidia".
     * </pre>
     *
     * <code>map&lt;string, string&gt; params = 2;</code>
     */
    public Builder removeParams(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableParams().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableParams() {
      return internalGetMutableParams().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Additional model-type and format specific parameters describing the
     * requirements for the to be exported model files, any string must be up to
     * 25000 characters long.
     *  * For `docker` format:
     *     `cpu_architecture` - (string) "x86_64" (default).
     *     `gpu_architecture` - (string) "none" (default), "nvidia".
     * </pre>
     *
     * <code>map&lt;string, string&gt; params = 2;</code>
     */
    public Builder putParams(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      if (value == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableParams().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional model-type and format specific parameters describing the
     * requirements for the to be exported model files, any string must be up to
     * 25000 characters long.
     *  * For `docker` format:
     *     `cpu_architecture` - (string) "x86_64" (default).
     *     `gpu_architecture` - (string) "none" (default), "nvidia".
     * </pre>
     *
     * <code>map&lt;string, string&gt; params = 2;</code>
     */
    public Builder putAllParams(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableParams().getMutableMap().putAll(values);
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.automl.v1beta1.ModelExportOutputConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.automl.v1beta1.ModelExportOutputConfig)
  private static final com.google.cloud.automl.v1beta1.ModelExportOutputConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.automl.v1beta1.ModelExportOutputConfig();
  }

  public static com.google.cloud.automl.v1beta1.ModelExportOutputConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ModelExportOutputConfig> PARSER =
      new com.google.protobuf.AbstractParser<ModelExportOutputConfig>() {
        @java.lang.Override
        public ModelExportOutputConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new ModelExportOutputConfig(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<ModelExportOutputConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ModelExportOutputConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.automl.v1beta1.ModelExportOutputConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
