/*
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/automl/v1beta1/text_sentiment.proto

package com.google.cloud.automl.v1beta1;

public final class TextSentimentProto {
  private TextSentimentProto() {}

  public static void registerAllExtensions(com.google.protobuf.ExtensionRegistryLite registry) {}

  public static void registerAllExtensions(com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions((com.google.protobuf.ExtensionRegistryLite) registry);
  }

  public interface TextSentimentAnnotationOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.automl.v1beta1.TextSentimentAnnotation)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. The sentiment with the semantic, as given to the
     * [AutoMl.ImportData][google.cloud.automl.v1beta1.AutoMl.ImportData] when populating the dataset from which the model used
     * for the prediction had been trained.
     * The sentiment values are between 0 and
     * Dataset.text_sentiment_dataset_metadata.sentiment_max (inclusive),
     * with higher value meaning more positive sentiment. They are completely
     * relative, i.e. 0 means least positive sentiment and sentiment_max means
     * the most positive from the sentiments present in the train data. Therefore
     *  e.g. if train data had only negative sentiment, then sentiment_max, would
     * be still negative (although least negative).
     * The sentiment shouldn't be confused with "score" or "magnitude"
     * from the previous Natural Language Sentiment Analysis API.
     * </pre>
     *
     * <code>int32 sentiment = 1;</code>
     */
    int getSentiment();
  }
  /**
   *
   *
   * <pre>
   * Contains annotation details specific to text sentiment.
   * </pre>
   *
   * Protobuf type {@code google.cloud.automl.v1beta1.TextSentimentAnnotation}
   */
  public static final class TextSentimentAnnotation extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.automl.v1beta1.TextSentimentAnnotation)
      TextSentimentAnnotationOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use TextSentimentAnnotation.newBuilder() to construct.
    private TextSentimentAnnotation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private TextSentimentAnnotation() {}

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private TextSentimentAnnotation(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                sentiment_ = input.readInt32();
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.automl.v1beta1.TextSentimentProto
          .internal_static_google_cloud_automl_v1beta1_TextSentimentAnnotation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.automl.v1beta1.TextSentimentProto
          .internal_static_google_cloud_automl_v1beta1_TextSentimentAnnotation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentAnnotation.class,
              com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentAnnotation.Builder
                  .class);
    }

    public static final int SENTIMENT_FIELD_NUMBER = 1;
    private int sentiment_;
    /**
     *
     *
     * <pre>
     * Output only. The sentiment with the semantic, as given to the
     * [AutoMl.ImportData][google.cloud.automl.v1beta1.AutoMl.ImportData] when populating the dataset from which the model used
     * for the prediction had been trained.
     * The sentiment values are between 0 and
     * Dataset.text_sentiment_dataset_metadata.sentiment_max (inclusive),
     * with higher value meaning more positive sentiment. They are completely
     * relative, i.e. 0 means least positive sentiment and sentiment_max means
     * the most positive from the sentiments present in the train data. Therefore
     *  e.g. if train data had only negative sentiment, then sentiment_max, would
     * be still negative (although least negative).
     * The sentiment shouldn't be confused with "score" or "magnitude"
     * from the previous Natural Language Sentiment Analysis API.
     * </pre>
     *
     * <code>int32 sentiment = 1;</code>
     */
    public int getSentiment() {
      return sentiment_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (sentiment_ != 0) {
        output.writeInt32(1, sentiment_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (sentiment_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, sentiment_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentAnnotation)) {
        return super.equals(obj);
      }
      com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentAnnotation other =
          (com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentAnnotation) obj;

      if (getSentiment() != other.getSentiment()) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SENTIMENT_FIELD_NUMBER;
      hash = (53 * hash) + getSentiment();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentAnnotation
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentAnnotation
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentAnnotation
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentAnnotation
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentAnnotation
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentAnnotation
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentAnnotation
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentAnnotation
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentAnnotation
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentAnnotation
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentAnnotation
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentAnnotation
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentAnnotation prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Contains annotation details specific to text sentiment.
     * </pre>
     *
     * Protobuf type {@code google.cloud.automl.v1beta1.TextSentimentAnnotation}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.automl.v1beta1.TextSentimentAnnotation)
        com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentAnnotationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.automl.v1beta1.TextSentimentProto
            .internal_static_google_cloud_automl_v1beta1_TextSentimentAnnotation_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.automl.v1beta1.TextSentimentProto
            .internal_static_google_cloud_automl_v1beta1_TextSentimentAnnotation_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentAnnotation.class,
                com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentAnnotation.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentAnnotation.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        sentiment_ = 0;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.automl.v1beta1.TextSentimentProto
            .internal_static_google_cloud_automl_v1beta1_TextSentimentAnnotation_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentAnnotation
          getDefaultInstanceForType() {
        return com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentAnnotation
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentAnnotation build() {
        com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentAnnotation result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentAnnotation
          buildPartial() {
        com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentAnnotation result =
            new com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentAnnotation(this);
        result.sentiment_ = sentiment_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentAnnotation) {
          return mergeFrom(
              (com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentAnnotation) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentAnnotation other) {
        if (other
            == com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentAnnotation
                .getDefaultInstance()) return this;
        if (other.getSentiment() != 0) {
          setSentiment(other.getSentiment());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentAnnotation parsedMessage =
            null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentAnnotation)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int sentiment_;
      /**
       *
       *
       * <pre>
       * Output only. The sentiment with the semantic, as given to the
       * [AutoMl.ImportData][google.cloud.automl.v1beta1.AutoMl.ImportData] when populating the dataset from which the model used
       * for the prediction had been trained.
       * The sentiment values are between 0 and
       * Dataset.text_sentiment_dataset_metadata.sentiment_max (inclusive),
       * with higher value meaning more positive sentiment. They are completely
       * relative, i.e. 0 means least positive sentiment and sentiment_max means
       * the most positive from the sentiments present in the train data. Therefore
       *  e.g. if train data had only negative sentiment, then sentiment_max, would
       * be still negative (although least negative).
       * The sentiment shouldn't be confused with "score" or "magnitude"
       * from the previous Natural Language Sentiment Analysis API.
       * </pre>
       *
       * <code>int32 sentiment = 1;</code>
       */
      public int getSentiment() {
        return sentiment_;
      }
      /**
       *
       *
       * <pre>
       * Output only. The sentiment with the semantic, as given to the
       * [AutoMl.ImportData][google.cloud.automl.v1beta1.AutoMl.ImportData] when populating the dataset from which the model used
       * for the prediction had been trained.
       * The sentiment values are between 0 and
       * Dataset.text_sentiment_dataset_metadata.sentiment_max (inclusive),
       * with higher value meaning more positive sentiment. They are completely
       * relative, i.e. 0 means least positive sentiment and sentiment_max means
       * the most positive from the sentiments present in the train data. Therefore
       *  e.g. if train data had only negative sentiment, then sentiment_max, would
       * be still negative (although least negative).
       * The sentiment shouldn't be confused with "score" or "magnitude"
       * from the previous Natural Language Sentiment Analysis API.
       * </pre>
       *
       * <code>int32 sentiment = 1;</code>
       */
      public Builder setSentiment(int value) {

        sentiment_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The sentiment with the semantic, as given to the
       * [AutoMl.ImportData][google.cloud.automl.v1beta1.AutoMl.ImportData] when populating the dataset from which the model used
       * for the prediction had been trained.
       * The sentiment values are between 0 and
       * Dataset.text_sentiment_dataset_metadata.sentiment_max (inclusive),
       * with higher value meaning more positive sentiment. They are completely
       * relative, i.e. 0 means least positive sentiment and sentiment_max means
       * the most positive from the sentiments present in the train data. Therefore
       *  e.g. if train data had only negative sentiment, then sentiment_max, would
       * be still negative (although least negative).
       * The sentiment shouldn't be confused with "score" or "magnitude"
       * from the previous Natural Language Sentiment Analysis API.
       * </pre>
       *
       * <code>int32 sentiment = 1;</code>
       */
      public Builder clearSentiment() {

        sentiment_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.automl.v1beta1.TextSentimentAnnotation)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.automl.v1beta1.TextSentimentAnnotation)
    private static final com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentAnnotation
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentAnnotation();
    }

    public static com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentAnnotation
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TextSentimentAnnotation> PARSER =
        new com.google.protobuf.AbstractParser<TextSentimentAnnotation>() {
          @java.lang.Override
          public TextSentimentAnnotation parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new TextSentimentAnnotation(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<TextSentimentAnnotation> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TextSentimentAnnotation> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentAnnotation
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface TextSentimentEvaluationMetricsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.automl.v1beta1.TextSentimentEvaluationMetrics)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. Precision.
     * </pre>
     *
     * <code>float precision = 1;</code>
     */
    float getPrecision();

    /**
     *
     *
     * <pre>
     * Output only. Recall.
     * </pre>
     *
     * <code>float recall = 2;</code>
     */
    float getRecall();

    /**
     *
     *
     * <pre>
     * Output only. The harmonic mean of recall and precision.
     * </pre>
     *
     * <code>float f1_score = 3;</code>
     */
    float getF1Score();

    /**
     *
     *
     * <pre>
     * Output only. Mean absolute error. Only set for the overall model
     * evaluation, not for evaluation of a single annotation spec.
     * </pre>
     *
     * <code>float mean_absolute_error = 4;</code>
     */
    float getMeanAbsoluteError();

    /**
     *
     *
     * <pre>
     * Output only. Mean squared error. Only set for the overall model
     * evaluation, not for evaluation of a single annotation spec.
     * </pre>
     *
     * <code>float mean_squared_error = 5;</code>
     */
    float getMeanSquaredError();

    /**
     *
     *
     * <pre>
     * Output only. Linear weighted kappa. Only set for the overall model
     * evaluation, not for evaluation of a single annotation spec.
     * </pre>
     *
     * <code>float linear_kappa = 6;</code>
     */
    float getLinearKappa();

    /**
     *
     *
     * <pre>
     * Output only. Quadratic weighted kappa. Only set for the overall model
     * evaluation, not for evaluation of a single annotation spec.
     * </pre>
     *
     * <code>float quadratic_kappa = 7;</code>
     */
    float getQuadraticKappa();

    /**
     *
     *
     * <pre>
     * Output only. Confusion matrix of the evaluation.
     * Only set for the overall model evaluation, not for evaluation of a single
     * annotation spec.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix confusion_matrix = 8;
     * </code>
     */
    boolean hasConfusionMatrix();
    /**
     *
     *
     * <pre>
     * Output only. Confusion matrix of the evaluation.
     * Only set for the overall model evaluation, not for evaluation of a single
     * annotation spec.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix confusion_matrix = 8;
     * </code>
     */
    com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
            .ConfusionMatrix
        getConfusionMatrix();
    /**
     *
     *
     * <pre>
     * Output only. Confusion matrix of the evaluation.
     * Only set for the overall model evaluation, not for evaluation of a single
     * annotation spec.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix confusion_matrix = 8;
     * </code>
     */
    com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
            .ConfusionMatrixOrBuilder
        getConfusionMatrixOrBuilder();

    /**
     *
     *
     * <pre>
     * Output only. The annotation spec ids used for this evaluation.
     * Deprecated .
     * </pre>
     *
     * <code>repeated string annotation_spec_id = 9 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    java.util.List<java.lang.String> getAnnotationSpecIdList();
    /**
     *
     *
     * <pre>
     * Output only. The annotation spec ids used for this evaluation.
     * Deprecated .
     * </pre>
     *
     * <code>repeated string annotation_spec_id = 9 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    int getAnnotationSpecIdCount();
    /**
     *
     *
     * <pre>
     * Output only. The annotation spec ids used for this evaluation.
     * Deprecated .
     * </pre>
     *
     * <code>repeated string annotation_spec_id = 9 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    java.lang.String getAnnotationSpecId(int index);
    /**
     *
     *
     * <pre>
     * Output only. The annotation spec ids used for this evaluation.
     * Deprecated .
     * </pre>
     *
     * <code>repeated string annotation_spec_id = 9 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    com.google.protobuf.ByteString getAnnotationSpecIdBytes(int index);
  }
  /**
   *
   *
   * <pre>
   * Model evaluation metrics for text sentiment problems.
   * </pre>
   *
   * Protobuf type {@code google.cloud.automl.v1beta1.TextSentimentEvaluationMetrics}
   */
  public static final class TextSentimentEvaluationMetrics
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.automl.v1beta1.TextSentimentEvaluationMetrics)
      TextSentimentEvaluationMetricsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use TextSentimentEvaluationMetrics.newBuilder() to construct.
    private TextSentimentEvaluationMetrics(
        com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private TextSentimentEvaluationMetrics() {
      annotationSpecId_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private TextSentimentEvaluationMetrics(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 13:
              {
                precision_ = input.readFloat();
                break;
              }
            case 21:
              {
                recall_ = input.readFloat();
                break;
              }
            case 29:
              {
                f1Score_ = input.readFloat();
                break;
              }
            case 37:
              {
                meanAbsoluteError_ = input.readFloat();
                break;
              }
            case 45:
              {
                meanSquaredError_ = input.readFloat();
                break;
              }
            case 53:
              {
                linearKappa_ = input.readFloat();
                break;
              }
            case 61:
              {
                quadraticKappa_ = input.readFloat();
                break;
              }
            case 66:
              {
                com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                        .ConfusionMatrix.Builder
                    subBuilder = null;
                if (confusionMatrix_ != null) {
                  subBuilder = confusionMatrix_.toBuilder();
                }
                confusionMatrix_ =
                    input.readMessage(
                        com.google.cloud.automl.v1beta1.ClassificationProto
                            .ClassificationEvaluationMetrics.ConfusionMatrix.parser(),
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(confusionMatrix_);
                  confusionMatrix_ = subBuilder.buildPartial();
                }

                break;
              }
            case 74:
              {
                java.lang.String s = input.readStringRequireUtf8();
                if (!((mutable_bitField0_ & 0x00000100) != 0)) {
                  annotationSpecId_ = new com.google.protobuf.LazyStringArrayList();
                  mutable_bitField0_ |= 0x00000100;
                }
                annotationSpecId_.add(s);
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000100) != 0)) {
          annotationSpecId_ = annotationSpecId_.getUnmodifiableView();
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.automl.v1beta1.TextSentimentProto
          .internal_static_google_cloud_automl_v1beta1_TextSentimentEvaluationMetrics_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.automl.v1beta1.TextSentimentProto
          .internal_static_google_cloud_automl_v1beta1_TextSentimentEvaluationMetrics_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics
                  .class,
              com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics
                  .Builder.class);
    }

    private int bitField0_;
    public static final int PRECISION_FIELD_NUMBER = 1;
    private float precision_;
    /**
     *
     *
     * <pre>
     * Output only. Precision.
     * </pre>
     *
     * <code>float precision = 1;</code>
     */
    public float getPrecision() {
      return precision_;
    }

    public static final int RECALL_FIELD_NUMBER = 2;
    private float recall_;
    /**
     *
     *
     * <pre>
     * Output only. Recall.
     * </pre>
     *
     * <code>float recall = 2;</code>
     */
    public float getRecall() {
      return recall_;
    }

    public static final int F1_SCORE_FIELD_NUMBER = 3;
    private float f1Score_;
    /**
     *
     *
     * <pre>
     * Output only. The harmonic mean of recall and precision.
     * </pre>
     *
     * <code>float f1_score = 3;</code>
     */
    public float getF1Score() {
      return f1Score_;
    }

    public static final int MEAN_ABSOLUTE_ERROR_FIELD_NUMBER = 4;
    private float meanAbsoluteError_;
    /**
     *
     *
     * <pre>
     * Output only. Mean absolute error. Only set for the overall model
     * evaluation, not for evaluation of a single annotation spec.
     * </pre>
     *
     * <code>float mean_absolute_error = 4;</code>
     */
    public float getMeanAbsoluteError() {
      return meanAbsoluteError_;
    }

    public static final int MEAN_SQUARED_ERROR_FIELD_NUMBER = 5;
    private float meanSquaredError_;
    /**
     *
     *
     * <pre>
     * Output only. Mean squared error. Only set for the overall model
     * evaluation, not for evaluation of a single annotation spec.
     * </pre>
     *
     * <code>float mean_squared_error = 5;</code>
     */
    public float getMeanSquaredError() {
      return meanSquaredError_;
    }

    public static final int LINEAR_KAPPA_FIELD_NUMBER = 6;
    private float linearKappa_;
    /**
     *
     *
     * <pre>
     * Output only. Linear weighted kappa. Only set for the overall model
     * evaluation, not for evaluation of a single annotation spec.
     * </pre>
     *
     * <code>float linear_kappa = 6;</code>
     */
    public float getLinearKappa() {
      return linearKappa_;
    }

    public static final int QUADRATIC_KAPPA_FIELD_NUMBER = 7;
    private float quadraticKappa_;
    /**
     *
     *
     * <pre>
     * Output only. Quadratic weighted kappa. Only set for the overall model
     * evaluation, not for evaluation of a single annotation spec.
     * </pre>
     *
     * <code>float quadratic_kappa = 7;</code>
     */
    public float getQuadraticKappa() {
      return quadraticKappa_;
    }

    public static final int CONFUSION_MATRIX_FIELD_NUMBER = 8;
    private com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
            .ConfusionMatrix
        confusionMatrix_;
    /**
     *
     *
     * <pre>
     * Output only. Confusion matrix of the evaluation.
     * Only set for the overall model evaluation, not for evaluation of a single
     * annotation spec.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix confusion_matrix = 8;
     * </code>
     */
    public boolean hasConfusionMatrix() {
      return confusionMatrix_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Confusion matrix of the evaluation.
     * Only set for the overall model evaluation, not for evaluation of a single
     * annotation spec.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix confusion_matrix = 8;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
            .ConfusionMatrix
        getConfusionMatrix() {
      return confusionMatrix_ == null
          ? com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
              .ConfusionMatrix.getDefaultInstance()
          : confusionMatrix_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Confusion matrix of the evaluation.
     * Only set for the overall model evaluation, not for evaluation of a single
     * annotation spec.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix confusion_matrix = 8;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
            .ConfusionMatrixOrBuilder
        getConfusionMatrixOrBuilder() {
      return getConfusionMatrix();
    }

    public static final int ANNOTATION_SPEC_ID_FIELD_NUMBER = 9;
    private com.google.protobuf.LazyStringList annotationSpecId_;
    /**
     *
     *
     * <pre>
     * Output only. The annotation spec ids used for this evaluation.
     * Deprecated .
     * </pre>
     *
     * <code>repeated string annotation_spec_id = 9 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public com.google.protobuf.ProtocolStringList getAnnotationSpecIdList() {
      return annotationSpecId_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The annotation spec ids used for this evaluation.
     * Deprecated .
     * </pre>
     *
     * <code>repeated string annotation_spec_id = 9 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public int getAnnotationSpecIdCount() {
      return annotationSpecId_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. The annotation spec ids used for this evaluation.
     * Deprecated .
     * </pre>
     *
     * <code>repeated string annotation_spec_id = 9 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public java.lang.String getAnnotationSpecId(int index) {
      return annotationSpecId_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The annotation spec ids used for this evaluation.
     * Deprecated .
     * </pre>
     *
     * <code>repeated string annotation_spec_id = 9 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getAnnotationSpecIdBytes(int index) {
      return annotationSpecId_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (precision_ != 0F) {
        output.writeFloat(1, precision_);
      }
      if (recall_ != 0F) {
        output.writeFloat(2, recall_);
      }
      if (f1Score_ != 0F) {
        output.writeFloat(3, f1Score_);
      }
      if (meanAbsoluteError_ != 0F) {
        output.writeFloat(4, meanAbsoluteError_);
      }
      if (meanSquaredError_ != 0F) {
        output.writeFloat(5, meanSquaredError_);
      }
      if (linearKappa_ != 0F) {
        output.writeFloat(6, linearKappa_);
      }
      if (quadraticKappa_ != 0F) {
        output.writeFloat(7, quadraticKappa_);
      }
      if (confusionMatrix_ != null) {
        output.writeMessage(8, getConfusionMatrix());
      }
      for (int i = 0; i < annotationSpecId_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 9, annotationSpecId_.getRaw(i));
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (precision_ != 0F) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(1, precision_);
      }
      if (recall_ != 0F) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(2, recall_);
      }
      if (f1Score_ != 0F) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(3, f1Score_);
      }
      if (meanAbsoluteError_ != 0F) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(4, meanAbsoluteError_);
      }
      if (meanSquaredError_ != 0F) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(5, meanSquaredError_);
      }
      if (linearKappa_ != 0F) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(6, linearKappa_);
      }
      if (quadraticKappa_ != 0F) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(7, quadraticKappa_);
      }
      if (confusionMatrix_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getConfusionMatrix());
      }
      {
        int dataSize = 0;
        for (int i = 0; i < annotationSpecId_.size(); i++) {
          dataSize += computeStringSizeNoTag(annotationSpecId_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getAnnotationSpecIdList().size();
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics)) {
        return super.equals(obj);
      }
      com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics other =
          (com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics) obj;

      if (java.lang.Float.floatToIntBits(getPrecision())
          != java.lang.Float.floatToIntBits(other.getPrecision())) return false;
      if (java.lang.Float.floatToIntBits(getRecall())
          != java.lang.Float.floatToIntBits(other.getRecall())) return false;
      if (java.lang.Float.floatToIntBits(getF1Score())
          != java.lang.Float.floatToIntBits(other.getF1Score())) return false;
      if (java.lang.Float.floatToIntBits(getMeanAbsoluteError())
          != java.lang.Float.floatToIntBits(other.getMeanAbsoluteError())) return false;
      if (java.lang.Float.floatToIntBits(getMeanSquaredError())
          != java.lang.Float.floatToIntBits(other.getMeanSquaredError())) return false;
      if (java.lang.Float.floatToIntBits(getLinearKappa())
          != java.lang.Float.floatToIntBits(other.getLinearKappa())) return false;
      if (java.lang.Float.floatToIntBits(getQuadraticKappa())
          != java.lang.Float.floatToIntBits(other.getQuadraticKappa())) return false;
      if (hasConfusionMatrix() != other.hasConfusionMatrix()) return false;
      if (hasConfusionMatrix()) {
        if (!getConfusionMatrix().equals(other.getConfusionMatrix())) return false;
      }
      if (!getAnnotationSpecIdList().equals(other.getAnnotationSpecIdList())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PRECISION_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getPrecision());
      hash = (37 * hash) + RECALL_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getRecall());
      hash = (37 * hash) + F1_SCORE_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getF1Score());
      hash = (37 * hash) + MEAN_ABSOLUTE_ERROR_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getMeanAbsoluteError());
      hash = (37 * hash) + MEAN_SQUARED_ERROR_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getMeanSquaredError());
      hash = (37 * hash) + LINEAR_KAPPA_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getLinearKappa());
      hash = (37 * hash) + QUADRATIC_KAPPA_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getQuadraticKappa());
      if (hasConfusionMatrix()) {
        hash = (37 * hash) + CONFUSION_MATRIX_FIELD_NUMBER;
        hash = (53 * hash) + getConfusionMatrix().hashCode();
      }
      if (getAnnotationSpecIdCount() > 0) {
        hash = (37 * hash) + ANNOTATION_SPEC_ID_FIELD_NUMBER;
        hash = (53 * hash) + getAnnotationSpecIdList().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Model evaluation metrics for text sentiment problems.
     * </pre>
     *
     * Protobuf type {@code google.cloud.automl.v1beta1.TextSentimentEvaluationMetrics}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.automl.v1beta1.TextSentimentEvaluationMetrics)
        com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetricsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.automl.v1beta1.TextSentimentProto
            .internal_static_google_cloud_automl_v1beta1_TextSentimentEvaluationMetrics_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.automl.v1beta1.TextSentimentProto
            .internal_static_google_cloud_automl_v1beta1_TextSentimentEvaluationMetrics_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics
                    .class,
                com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        precision_ = 0F;

        recall_ = 0F;

        f1Score_ = 0F;

        meanAbsoluteError_ = 0F;

        meanSquaredError_ = 0F;

        linearKappa_ = 0F;

        quadraticKappa_ = 0F;

        if (confusionMatrixBuilder_ == null) {
          confusionMatrix_ = null;
        } else {
          confusionMatrix_ = null;
          confusionMatrixBuilder_ = null;
        }
        annotationSpecId_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000100);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.automl.v1beta1.TextSentimentProto
            .internal_static_google_cloud_automl_v1beta1_TextSentimentEvaluationMetrics_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics
          getDefaultInstanceForType() {
        return com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics
          build() {
        com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics
          buildPartial() {
        com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics result =
            new com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics(
                this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        result.precision_ = precision_;
        result.recall_ = recall_;
        result.f1Score_ = f1Score_;
        result.meanAbsoluteError_ = meanAbsoluteError_;
        result.meanSquaredError_ = meanSquaredError_;
        result.linearKappa_ = linearKappa_;
        result.quadraticKappa_ = quadraticKappa_;
        if (confusionMatrixBuilder_ == null) {
          result.confusionMatrix_ = confusionMatrix_;
        } else {
          result.confusionMatrix_ = confusionMatrixBuilder_.build();
        }
        if (((bitField0_ & 0x00000100) != 0)) {
          annotationSpecId_ = annotationSpecId_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000100);
        }
        result.annotationSpecId_ = annotationSpecId_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics) {
          return mergeFrom(
              (com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics other) {
        if (other
            == com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics
                .getDefaultInstance()) return this;
        if (other.getPrecision() != 0F) {
          setPrecision(other.getPrecision());
        }
        if (other.getRecall() != 0F) {
          setRecall(other.getRecall());
        }
        if (other.getF1Score() != 0F) {
          setF1Score(other.getF1Score());
        }
        if (other.getMeanAbsoluteError() != 0F) {
          setMeanAbsoluteError(other.getMeanAbsoluteError());
        }
        if (other.getMeanSquaredError() != 0F) {
          setMeanSquaredError(other.getMeanSquaredError());
        }
        if (other.getLinearKappa() != 0F) {
          setLinearKappa(other.getLinearKappa());
        }
        if (other.getQuadraticKappa() != 0F) {
          setQuadraticKappa(other.getQuadraticKappa());
        }
        if (other.hasConfusionMatrix()) {
          mergeConfusionMatrix(other.getConfusionMatrix());
        }
        if (!other.annotationSpecId_.isEmpty()) {
          if (annotationSpecId_.isEmpty()) {
            annotationSpecId_ = other.annotationSpecId_;
            bitField0_ = (bitField0_ & ~0x00000100);
          } else {
            ensureAnnotationSpecIdIsMutable();
            annotationSpecId_.addAll(other.annotationSpecId_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics
            parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private float precision_;
      /**
       *
       *
       * <pre>
       * Output only. Precision.
       * </pre>
       *
       * <code>float precision = 1;</code>
       */
      public float getPrecision() {
        return precision_;
      }
      /**
       *
       *
       * <pre>
       * Output only. Precision.
       * </pre>
       *
       * <code>float precision = 1;</code>
       */
      public Builder setPrecision(float value) {

        precision_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Precision.
       * </pre>
       *
       * <code>float precision = 1;</code>
       */
      public Builder clearPrecision() {

        precision_ = 0F;
        onChanged();
        return this;
      }

      private float recall_;
      /**
       *
       *
       * <pre>
       * Output only. Recall.
       * </pre>
       *
       * <code>float recall = 2;</code>
       */
      public float getRecall() {
        return recall_;
      }
      /**
       *
       *
       * <pre>
       * Output only. Recall.
       * </pre>
       *
       * <code>float recall = 2;</code>
       */
      public Builder setRecall(float value) {

        recall_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Recall.
       * </pre>
       *
       * <code>float recall = 2;</code>
       */
      public Builder clearRecall() {

        recall_ = 0F;
        onChanged();
        return this;
      }

      private float f1Score_;
      /**
       *
       *
       * <pre>
       * Output only. The harmonic mean of recall and precision.
       * </pre>
       *
       * <code>float f1_score = 3;</code>
       */
      public float getF1Score() {
        return f1Score_;
      }
      /**
       *
       *
       * <pre>
       * Output only. The harmonic mean of recall and precision.
       * </pre>
       *
       * <code>float f1_score = 3;</code>
       */
      public Builder setF1Score(float value) {

        f1Score_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The harmonic mean of recall and precision.
       * </pre>
       *
       * <code>float f1_score = 3;</code>
       */
      public Builder clearF1Score() {

        f1Score_ = 0F;
        onChanged();
        return this;
      }

      private float meanAbsoluteError_;
      /**
       *
       *
       * <pre>
       * Output only. Mean absolute error. Only set for the overall model
       * evaluation, not for evaluation of a single annotation spec.
       * </pre>
       *
       * <code>float mean_absolute_error = 4;</code>
       */
      public float getMeanAbsoluteError() {
        return meanAbsoluteError_;
      }
      /**
       *
       *
       * <pre>
       * Output only. Mean absolute error. Only set for the overall model
       * evaluation, not for evaluation of a single annotation spec.
       * </pre>
       *
       * <code>float mean_absolute_error = 4;</code>
       */
      public Builder setMeanAbsoluteError(float value) {

        meanAbsoluteError_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Mean absolute error. Only set for the overall model
       * evaluation, not for evaluation of a single annotation spec.
       * </pre>
       *
       * <code>float mean_absolute_error = 4;</code>
       */
      public Builder clearMeanAbsoluteError() {

        meanAbsoluteError_ = 0F;
        onChanged();
        return this;
      }

      private float meanSquaredError_;
      /**
       *
       *
       * <pre>
       * Output only. Mean squared error. Only set for the overall model
       * evaluation, not for evaluation of a single annotation spec.
       * </pre>
       *
       * <code>float mean_squared_error = 5;</code>
       */
      public float getMeanSquaredError() {
        return meanSquaredError_;
      }
      /**
       *
       *
       * <pre>
       * Output only. Mean squared error. Only set for the overall model
       * evaluation, not for evaluation of a single annotation spec.
       * </pre>
       *
       * <code>float mean_squared_error = 5;</code>
       */
      public Builder setMeanSquaredError(float value) {

        meanSquaredError_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Mean squared error. Only set for the overall model
       * evaluation, not for evaluation of a single annotation spec.
       * </pre>
       *
       * <code>float mean_squared_error = 5;</code>
       */
      public Builder clearMeanSquaredError() {

        meanSquaredError_ = 0F;
        onChanged();
        return this;
      }

      private float linearKappa_;
      /**
       *
       *
       * <pre>
       * Output only. Linear weighted kappa. Only set for the overall model
       * evaluation, not for evaluation of a single annotation spec.
       * </pre>
       *
       * <code>float linear_kappa = 6;</code>
       */
      public float getLinearKappa() {
        return linearKappa_;
      }
      /**
       *
       *
       * <pre>
       * Output only. Linear weighted kappa. Only set for the overall model
       * evaluation, not for evaluation of a single annotation spec.
       * </pre>
       *
       * <code>float linear_kappa = 6;</code>
       */
      public Builder setLinearKappa(float value) {

        linearKappa_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Linear weighted kappa. Only set for the overall model
       * evaluation, not for evaluation of a single annotation spec.
       * </pre>
       *
       * <code>float linear_kappa = 6;</code>
       */
      public Builder clearLinearKappa() {

        linearKappa_ = 0F;
        onChanged();
        return this;
      }

      private float quadraticKappa_;
      /**
       *
       *
       * <pre>
       * Output only. Quadratic weighted kappa. Only set for the overall model
       * evaluation, not for evaluation of a single annotation spec.
       * </pre>
       *
       * <code>float quadratic_kappa = 7;</code>
       */
      public float getQuadraticKappa() {
        return quadraticKappa_;
      }
      /**
       *
       *
       * <pre>
       * Output only. Quadratic weighted kappa. Only set for the overall model
       * evaluation, not for evaluation of a single annotation spec.
       * </pre>
       *
       * <code>float quadratic_kappa = 7;</code>
       */
      public Builder setQuadraticKappa(float value) {

        quadraticKappa_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Quadratic weighted kappa. Only set for the overall model
       * evaluation, not for evaluation of a single annotation spec.
       * </pre>
       *
       * <code>float quadratic_kappa = 7;</code>
       */
      public Builder clearQuadraticKappa() {

        quadraticKappa_ = 0F;
        onChanged();
        return this;
      }

      private com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
              .ConfusionMatrix
          confusionMatrix_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                  .ConfusionMatrix,
              com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                  .ConfusionMatrix.Builder,
              com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                  .ConfusionMatrixOrBuilder>
          confusionMatrixBuilder_;
      /**
       *
       *
       * <pre>
       * Output only. Confusion matrix of the evaluation.
       * Only set for the overall model evaluation, not for evaluation of a single
       * annotation spec.
       * </pre>
       *
       * <code>
       * .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix confusion_matrix = 8;
       * </code>
       */
      public boolean hasConfusionMatrix() {
        return confusionMatrixBuilder_ != null || confusionMatrix_ != null;
      }
      /**
       *
       *
       * <pre>
       * Output only. Confusion matrix of the evaluation.
       * Only set for the overall model evaluation, not for evaluation of a single
       * annotation spec.
       * </pre>
       *
       * <code>
       * .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix confusion_matrix = 8;
       * </code>
       */
      public com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
              .ConfusionMatrix
          getConfusionMatrix() {
        if (confusionMatrixBuilder_ == null) {
          return confusionMatrix_ == null
              ? com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                  .ConfusionMatrix.getDefaultInstance()
              : confusionMatrix_;
        } else {
          return confusionMatrixBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Confusion matrix of the evaluation.
       * Only set for the overall model evaluation, not for evaluation of a single
       * annotation spec.
       * </pre>
       *
       * <code>
       * .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix confusion_matrix = 8;
       * </code>
       */
      public Builder setConfusionMatrix(
          com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                  .ConfusionMatrix
              value) {
        if (confusionMatrixBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          confusionMatrix_ = value;
          onChanged();
        } else {
          confusionMatrixBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Confusion matrix of the evaluation.
       * Only set for the overall model evaluation, not for evaluation of a single
       * annotation spec.
       * </pre>
       *
       * <code>
       * .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix confusion_matrix = 8;
       * </code>
       */
      public Builder setConfusionMatrix(
          com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                  .ConfusionMatrix.Builder
              builderForValue) {
        if (confusionMatrixBuilder_ == null) {
          confusionMatrix_ = builderForValue.build();
          onChanged();
        } else {
          confusionMatrixBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Confusion matrix of the evaluation.
       * Only set for the overall model evaluation, not for evaluation of a single
       * annotation spec.
       * </pre>
       *
       * <code>
       * .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix confusion_matrix = 8;
       * </code>
       */
      public Builder mergeConfusionMatrix(
          com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                  .ConfusionMatrix
              value) {
        if (confusionMatrixBuilder_ == null) {
          if (confusionMatrix_ != null) {
            confusionMatrix_ =
                com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                    .ConfusionMatrix.newBuilder(confusionMatrix_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            confusionMatrix_ = value;
          }
          onChanged();
        } else {
          confusionMatrixBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Confusion matrix of the evaluation.
       * Only set for the overall model evaluation, not for evaluation of a single
       * annotation spec.
       * </pre>
       *
       * <code>
       * .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix confusion_matrix = 8;
       * </code>
       */
      public Builder clearConfusionMatrix() {
        if (confusionMatrixBuilder_ == null) {
          confusionMatrix_ = null;
          onChanged();
        } else {
          confusionMatrix_ = null;
          confusionMatrixBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Confusion matrix of the evaluation.
       * Only set for the overall model evaluation, not for evaluation of a single
       * annotation spec.
       * </pre>
       *
       * <code>
       * .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix confusion_matrix = 8;
       * </code>
       */
      public com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
              .ConfusionMatrix.Builder
          getConfusionMatrixBuilder() {

        onChanged();
        return getConfusionMatrixFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Output only. Confusion matrix of the evaluation.
       * Only set for the overall model evaluation, not for evaluation of a single
       * annotation spec.
       * </pre>
       *
       * <code>
       * .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix confusion_matrix = 8;
       * </code>
       */
      public com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
              .ConfusionMatrixOrBuilder
          getConfusionMatrixOrBuilder() {
        if (confusionMatrixBuilder_ != null) {
          return confusionMatrixBuilder_.getMessageOrBuilder();
        } else {
          return confusionMatrix_ == null
              ? com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                  .ConfusionMatrix.getDefaultInstance()
              : confusionMatrix_;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Confusion matrix of the evaluation.
       * Only set for the overall model evaluation, not for evaluation of a single
       * annotation spec.
       * </pre>
       *
       * <code>
       * .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix confusion_matrix = 8;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                  .ConfusionMatrix,
              com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                  .ConfusionMatrix.Builder,
              com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                  .ConfusionMatrixOrBuilder>
          getConfusionMatrixFieldBuilder() {
        if (confusionMatrixBuilder_ == null) {
          confusionMatrixBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.automl.v1beta1.ClassificationProto
                      .ClassificationEvaluationMetrics.ConfusionMatrix,
                  com.google.cloud.automl.v1beta1.ClassificationProto
                      .ClassificationEvaluationMetrics.ConfusionMatrix.Builder,
                  com.google.cloud.automl.v1beta1.ClassificationProto
                      .ClassificationEvaluationMetrics.ConfusionMatrixOrBuilder>(
                  getConfusionMatrix(), getParentForChildren(), isClean());
          confusionMatrix_ = null;
        }
        return confusionMatrixBuilder_;
      }

      private com.google.protobuf.LazyStringList annotationSpecId_ =
          com.google.protobuf.LazyStringArrayList.EMPTY;

      private void ensureAnnotationSpecIdIsMutable() {
        if (!((bitField0_ & 0x00000100) != 0)) {
          annotationSpecId_ = new com.google.protobuf.LazyStringArrayList(annotationSpecId_);
          bitField0_ |= 0x00000100;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The annotation spec ids used for this evaluation.
       * Deprecated .
       * </pre>
       *
       * <code>repeated string annotation_spec_id = 9 [deprecated = true];</code>
       */
      @java.lang.Deprecated
      public com.google.protobuf.ProtocolStringList getAnnotationSpecIdList() {
        return annotationSpecId_.getUnmodifiableView();
      }
      /**
       *
       *
       * <pre>
       * Output only. The annotation spec ids used for this evaluation.
       * Deprecated .
       * </pre>
       *
       * <code>repeated string annotation_spec_id = 9 [deprecated = true];</code>
       */
      @java.lang.Deprecated
      public int getAnnotationSpecIdCount() {
        return annotationSpecId_.size();
      }
      /**
       *
       *
       * <pre>
       * Output only. The annotation spec ids used for this evaluation.
       * Deprecated .
       * </pre>
       *
       * <code>repeated string annotation_spec_id = 9 [deprecated = true];</code>
       */
      @java.lang.Deprecated
      public java.lang.String getAnnotationSpecId(int index) {
        return annotationSpecId_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Output only. The annotation spec ids used for this evaluation.
       * Deprecated .
       * </pre>
       *
       * <code>repeated string annotation_spec_id = 9 [deprecated = true];</code>
       */
      @java.lang.Deprecated
      public com.google.protobuf.ByteString getAnnotationSpecIdBytes(int index) {
        return annotationSpecId_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Output only. The annotation spec ids used for this evaluation.
       * Deprecated .
       * </pre>
       *
       * <code>repeated string annotation_spec_id = 9 [deprecated = true];</code>
       */
      @java.lang.Deprecated
      public Builder setAnnotationSpecId(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAnnotationSpecIdIsMutable();
        annotationSpecId_.set(index, value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The annotation spec ids used for this evaluation.
       * Deprecated .
       * </pre>
       *
       * <code>repeated string annotation_spec_id = 9 [deprecated = true];</code>
       */
      @java.lang.Deprecated
      public Builder addAnnotationSpecId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAnnotationSpecIdIsMutable();
        annotationSpecId_.add(value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The annotation spec ids used for this evaluation.
       * Deprecated .
       * </pre>
       *
       * <code>repeated string annotation_spec_id = 9 [deprecated = true];</code>
       */
      @java.lang.Deprecated
      public Builder addAllAnnotationSpecId(java.lang.Iterable<java.lang.String> values) {
        ensureAnnotationSpecIdIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, annotationSpecId_);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The annotation spec ids used for this evaluation.
       * Deprecated .
       * </pre>
       *
       * <code>repeated string annotation_spec_id = 9 [deprecated = true];</code>
       */
      @java.lang.Deprecated
      public Builder clearAnnotationSpecId() {
        annotationSpecId_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000100);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The annotation spec ids used for this evaluation.
       * Deprecated .
       * </pre>
       *
       * <code>repeated string annotation_spec_id = 9 [deprecated = true];</code>
       */
      @java.lang.Deprecated
      public Builder addAnnotationSpecIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureAnnotationSpecIdIsMutable();
        annotationSpecId_.add(value);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.automl.v1beta1.TextSentimentEvaluationMetrics)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.automl.v1beta1.TextSentimentEvaluationMetrics)
    private static final com.google.cloud.automl.v1beta1.TextSentimentProto
            .TextSentimentEvaluationMetrics
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics();
    }

    public static com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TextSentimentEvaluationMetrics> PARSER =
        new com.google.protobuf.AbstractParser<TextSentimentEvaluationMetrics>() {
          @java.lang.Override
          public TextSentimentEvaluationMetrics parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new TextSentimentEvaluationMetrics(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<TextSentimentEvaluationMetrics> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TextSentimentEvaluationMetrics> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_automl_v1beta1_TextSentimentAnnotation_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_automl_v1beta1_TextSentimentAnnotation_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_automl_v1beta1_TextSentimentEvaluationMetrics_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_automl_v1beta1_TextSentimentEvaluationMetrics_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor getDescriptor() {
    return descriptor;
  }

  private static com.google.protobuf.Descriptors.FileDescriptor descriptor;

  static {
    java.lang.String[] descriptorData = {
      "\n0google/cloud/automl/v1beta1/text_senti"
          + "ment.proto\022\033google.cloud.automl.v1beta1\032"
          + "0google/cloud/automl/v1beta1/classificat"
          + "ion.proto\032\034google/api/annotations.proto\""
          + ",\n\027TextSentimentAnnotation\022\021\n\tsentiment\030"
          + "\001 \001(\005\"\305\002\n\036TextSentimentEvaluationMetrics"
          + "\022\021\n\tprecision\030\001 \001(\002\022\016\n\006recall\030\002 \001(\002\022\020\n\010f"
          + "1_score\030\003 \001(\002\022\033\n\023mean_absolute_error\030\004 \001"
          + "(\002\022\032\n\022mean_squared_error\030\005 \001(\002\022\024\n\014linear"
          + "_kappa\030\006 \001(\002\022\027\n\017quadratic_kappa\030\007 \001(\002\022f\n"
          + "\020confusion_matrix\030\010 \001(\0132L.google.cloud.a"
          + "utoml.v1beta1.ClassificationEvaluationMe"
          + "trics.ConfusionMatrix\022\036\n\022annotation_spec"
          + "_id\030\t \003(\tB\002\030\001B\267\001\n\037com.google.cloud.autom"
          + "l.v1beta1B\022TextSentimentProtoZAgoogle.go"
          + "lang.org/genproto/googleapis/cloud/autom"
          + "l/v1beta1;automl\312\002\033Google\\Cloud\\AutoMl\\V"
          + "1beta1\352\002\036Google::Cloud::AutoML::V1beta1b"
          + "\006proto3"
    };
    com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner assigner =
        new com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner() {
          public com.google.protobuf.ExtensionRegistry assignDescriptors(
              com.google.protobuf.Descriptors.FileDescriptor root) {
            descriptor = root;
            return null;
          }
        };
    com.google.protobuf.Descriptors.FileDescriptor.internalBuildGeneratedFileFrom(
        descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
          com.google.cloud.automl.v1beta1.ClassificationProto.getDescriptor(),
          com.google.api.AnnotationsProto.getDescriptor(),
        },
        assigner);
    internal_static_google_cloud_automl_v1beta1_TextSentimentAnnotation_descriptor =
        getDescriptor().getMessageTypes().get(0);
    internal_static_google_cloud_automl_v1beta1_TextSentimentAnnotation_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_automl_v1beta1_TextSentimentAnnotation_descriptor,
            new java.lang.String[] {
              "Sentiment",
            });
    internal_static_google_cloud_automl_v1beta1_TextSentimentEvaluationMetrics_descriptor =
        getDescriptor().getMessageTypes().get(1);
    internal_static_google_cloud_automl_v1beta1_TextSentimentEvaluationMetrics_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_automl_v1beta1_TextSentimentEvaluationMetrics_descriptor,
            new java.lang.String[] {
              "Precision",
              "Recall",
              "F1Score",
              "MeanAbsoluteError",
              "MeanSquaredError",
              "LinearKappa",
              "QuadraticKappa",
              "ConfusionMatrix",
              "AnnotationSpecId",
            });
    com.google.cloud.automl.v1beta1.ClassificationProto.getDescriptor();
    com.google.api.AnnotationsProto.getDescriptor();
  }

  // @@protoc_insertion_point(outer_class_scope)
}
