/*
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/automl/v1beta1/data_stats.proto

package com.google.cloud.automl.v1beta1;

/**
 *
 *
 * <pre>
 * The data statistics of a series of CATEGORY values.
 * </pre>
 *
 * Protobuf type {@code google.cloud.automl.v1beta1.CategoryStats}
 */
public final class CategoryStats extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.automl.v1beta1.CategoryStats)
    CategoryStatsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CategoryStats.newBuilder() to construct.
  private CategoryStats(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CategoryStats() {
    topCategoryStats_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CategoryStats();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private CategoryStats(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                topCategoryStats_ =
                    new java.util.ArrayList<
                        com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats>();
                mutable_bitField0_ |= 0x00000001;
              }
              topCategoryStats_.add(
                  input.readMessage(
                      com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats.parser(),
                      extensionRegistry));
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        topCategoryStats_ = java.util.Collections.unmodifiableList(topCategoryStats_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.automl.v1beta1.DataStatsOuterClass
        .internal_static_google_cloud_automl_v1beta1_CategoryStats_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.automl.v1beta1.DataStatsOuterClass
        .internal_static_google_cloud_automl_v1beta1_CategoryStats_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.automl.v1beta1.CategoryStats.class,
            com.google.cloud.automl.v1beta1.CategoryStats.Builder.class);
  }

  public interface SingleCategoryStatsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The CATEGORY value.
     * </pre>
     *
     * <code>string value = 1;</code>
     *
     * @return The value.
     */
    java.lang.String getValue();
    /**
     *
     *
     * <pre>
     * The CATEGORY value.
     * </pre>
     *
     * <code>string value = 1;</code>
     *
     * @return The bytes for value.
     */
    com.google.protobuf.ByteString getValueBytes();

    /**
     *
     *
     * <pre>
     * The number of occurrences of this value in the series.
     * </pre>
     *
     * <code>int64 count = 2;</code>
     *
     * @return The count.
     */
    long getCount();
  }
  /**
   *
   *
   * <pre>
   * The statistics of a single CATEGORY value.
   * </pre>
   *
   * Protobuf type {@code google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats}
   */
  public static final class SingleCategoryStats extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats)
      SingleCategoryStatsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use SingleCategoryStats.newBuilder() to construct.
    private SingleCategoryStats(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SingleCategoryStats() {
      value_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SingleCategoryStats();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private SingleCategoryStats(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                value_ = s;
                break;
              }
            case 16:
              {
                count_ = input.readInt64();
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.automl.v1beta1.DataStatsOuterClass
          .internal_static_google_cloud_automl_v1beta1_CategoryStats_SingleCategoryStats_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.automl.v1beta1.DataStatsOuterClass
          .internal_static_google_cloud_automl_v1beta1_CategoryStats_SingleCategoryStats_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats.class,
              com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats.Builder.class);
    }

    public static final int VALUE_FIELD_NUMBER = 1;
    private volatile java.lang.Object value_;
    /**
     *
     *
     * <pre>
     * The CATEGORY value.
     * </pre>
     *
     * <code>string value = 1;</code>
     *
     * @return The value.
     */
    public java.lang.String getValue() {
      java.lang.Object ref = value_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        value_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The CATEGORY value.
     * </pre>
     *
     * <code>string value = 1;</code>
     *
     * @return The bytes for value.
     */
    public com.google.protobuf.ByteString getValueBytes() {
      java.lang.Object ref = value_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        value_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int COUNT_FIELD_NUMBER = 2;
    private long count_;
    /**
     *
     *
     * <pre>
     * The number of occurrences of this value in the series.
     * </pre>
     *
     * <code>int64 count = 2;</code>
     *
     * @return The count.
     */
    public long getCount() {
      return count_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!getValueBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, value_);
      }
      if (count_ != 0L) {
        output.writeInt64(2, count_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getValueBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, value_);
      }
      if (count_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, count_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats)) {
        return super.equals(obj);
      }
      com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats other =
          (com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats) obj;

      if (!getValue().equals(other.getValue())) return false;
      if (getCount() != other.getCount()) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + VALUE_FIELD_NUMBER;
      hash = (53 * hash) + getValue().hashCode();
      hash = (37 * hash) + COUNT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getCount());
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The statistics of a single CATEGORY value.
     * </pre>
     *
     * Protobuf type {@code google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats)
        com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStatsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.automl.v1beta1.DataStatsOuterClass
            .internal_static_google_cloud_automl_v1beta1_CategoryStats_SingleCategoryStats_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.automl.v1beta1.DataStatsOuterClass
            .internal_static_google_cloud_automl_v1beta1_CategoryStats_SingleCategoryStats_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats.class,
                com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats.Builder.class);
      }

      // Construct using
      // com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        value_ = "";

        count_ = 0L;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.automl.v1beta1.DataStatsOuterClass
            .internal_static_google_cloud_automl_v1beta1_CategoryStats_SingleCategoryStats_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats
          getDefaultInstanceForType() {
        return com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats build() {
        com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats buildPartial() {
        com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats result =
            new com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats(this);
        result.value_ = value_;
        result.count_ = count_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats) {
          return mergeFrom(
              (com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats other) {
        if (other
            == com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats
                .getDefaultInstance()) return this;
        if (!other.getValue().isEmpty()) {
          value_ = other.value_;
          onChanged();
        }
        if (other.getCount() != 0L) {
          setCount(other.getCount());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object value_ = "";
      /**
       *
       *
       * <pre>
       * The CATEGORY value.
       * </pre>
       *
       * <code>string value = 1;</code>
       *
       * @return The value.
       */
      public java.lang.String getValue() {
        java.lang.Object ref = value_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          value_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The CATEGORY value.
       * </pre>
       *
       * <code>string value = 1;</code>
       *
       * @return The bytes for value.
       */
      public com.google.protobuf.ByteString getValueBytes() {
        java.lang.Object ref = value_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          value_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The CATEGORY value.
       * </pre>
       *
       * <code>string value = 1;</code>
       *
       * @param value The value to set.
       * @return This builder for chaining.
       */
      public Builder setValue(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        value_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The CATEGORY value.
       * </pre>
       *
       * <code>string value = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearValue() {

        value_ = getDefaultInstance().getValue();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The CATEGORY value.
       * </pre>
       *
       * <code>string value = 1;</code>
       *
       * @param value The bytes for value to set.
       * @return This builder for chaining.
       */
      public Builder setValueBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        value_ = value;
        onChanged();
        return this;
      }

      private long count_;
      /**
       *
       *
       * <pre>
       * The number of occurrences of this value in the series.
       * </pre>
       *
       * <code>int64 count = 2;</code>
       *
       * @return The count.
       */
      public long getCount() {
        return count_;
      }
      /**
       *
       *
       * <pre>
       * The number of occurrences of this value in the series.
       * </pre>
       *
       * <code>int64 count = 2;</code>
       *
       * @param value The count to set.
       * @return This builder for chaining.
       */
      public Builder setCount(long value) {

        count_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The number of occurrences of this value in the series.
       * </pre>
       *
       * <code>int64 count = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCount() {

        count_ = 0L;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats)
    private static final com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats();
    }

    public static com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SingleCategoryStats> PARSER =
        new com.google.protobuf.AbstractParser<SingleCategoryStats>() {
          @java.lang.Override
          public SingleCategoryStats parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new SingleCategoryStats(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<SingleCategoryStats> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SingleCategoryStats> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int TOP_CATEGORY_STATS_FIELD_NUMBER = 1;
  private java.util.List<com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats>
      topCategoryStats_;
  /**
   *
   *
   * <pre>
   * The statistics of the top 20 CATEGORY values, ordered by
   * [count][google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats.count].
   * </pre>
   *
   * <code>
   * repeated .google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats top_category_stats = 1;
   * </code>
   */
  public java.util.List<com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats>
      getTopCategoryStatsList() {
    return topCategoryStats_;
  }
  /**
   *
   *
   * <pre>
   * The statistics of the top 20 CATEGORY values, ordered by
   * [count][google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats.count].
   * </pre>
   *
   * <code>
   * repeated .google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats top_category_stats = 1;
   * </code>
   */
  public java.util.List<
          ? extends com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStatsOrBuilder>
      getTopCategoryStatsOrBuilderList() {
    return topCategoryStats_;
  }
  /**
   *
   *
   * <pre>
   * The statistics of the top 20 CATEGORY values, ordered by
   * [count][google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats.count].
   * </pre>
   *
   * <code>
   * repeated .google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats top_category_stats = 1;
   * </code>
   */
  public int getTopCategoryStatsCount() {
    return topCategoryStats_.size();
  }
  /**
   *
   *
   * <pre>
   * The statistics of the top 20 CATEGORY values, ordered by
   * [count][google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats.count].
   * </pre>
   *
   * <code>
   * repeated .google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats top_category_stats = 1;
   * </code>
   */
  public com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats getTopCategoryStats(
      int index) {
    return topCategoryStats_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The statistics of the top 20 CATEGORY values, ordered by
   * [count][google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats.count].
   * </pre>
   *
   * <code>
   * repeated .google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats top_category_stats = 1;
   * </code>
   */
  public com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStatsOrBuilder
      getTopCategoryStatsOrBuilder(int index) {
    return topCategoryStats_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < topCategoryStats_.size(); i++) {
      output.writeMessage(1, topCategoryStats_.get(i));
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < topCategoryStats_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, topCategoryStats_.get(i));
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.automl.v1beta1.CategoryStats)) {
      return super.equals(obj);
    }
    com.google.cloud.automl.v1beta1.CategoryStats other =
        (com.google.cloud.automl.v1beta1.CategoryStats) obj;

    if (!getTopCategoryStatsList().equals(other.getTopCategoryStatsList())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getTopCategoryStatsCount() > 0) {
      hash = (37 * hash) + TOP_CATEGORY_STATS_FIELD_NUMBER;
      hash = (53 * hash) + getTopCategoryStatsList().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.automl.v1beta1.CategoryStats parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1beta1.CategoryStats parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.CategoryStats parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1beta1.CategoryStats parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.CategoryStats parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1beta1.CategoryStats parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.CategoryStats parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1beta1.CategoryStats parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.CategoryStats parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1beta1.CategoryStats parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.CategoryStats parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1beta1.CategoryStats parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.automl.v1beta1.CategoryStats prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The data statistics of a series of CATEGORY values.
   * </pre>
   *
   * Protobuf type {@code google.cloud.automl.v1beta1.CategoryStats}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.automl.v1beta1.CategoryStats)
      com.google.cloud.automl.v1beta1.CategoryStatsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.automl.v1beta1.DataStatsOuterClass
          .internal_static_google_cloud_automl_v1beta1_CategoryStats_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.automl.v1beta1.DataStatsOuterClass
          .internal_static_google_cloud_automl_v1beta1_CategoryStats_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.automl.v1beta1.CategoryStats.class,
              com.google.cloud.automl.v1beta1.CategoryStats.Builder.class);
    }

    // Construct using com.google.cloud.automl.v1beta1.CategoryStats.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getTopCategoryStatsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (topCategoryStatsBuilder_ == null) {
        topCategoryStats_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        topCategoryStatsBuilder_.clear();
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.automl.v1beta1.DataStatsOuterClass
          .internal_static_google_cloud_automl_v1beta1_CategoryStats_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.CategoryStats getDefaultInstanceForType() {
      return com.google.cloud.automl.v1beta1.CategoryStats.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.CategoryStats build() {
      com.google.cloud.automl.v1beta1.CategoryStats result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.CategoryStats buildPartial() {
      com.google.cloud.automl.v1beta1.CategoryStats result =
          new com.google.cloud.automl.v1beta1.CategoryStats(this);
      int from_bitField0_ = bitField0_;
      if (topCategoryStatsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          topCategoryStats_ = java.util.Collections.unmodifiableList(topCategoryStats_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.topCategoryStats_ = topCategoryStats_;
      } else {
        result.topCategoryStats_ = topCategoryStatsBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.automl.v1beta1.CategoryStats) {
        return mergeFrom((com.google.cloud.automl.v1beta1.CategoryStats) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.automl.v1beta1.CategoryStats other) {
      if (other == com.google.cloud.automl.v1beta1.CategoryStats.getDefaultInstance()) return this;
      if (topCategoryStatsBuilder_ == null) {
        if (!other.topCategoryStats_.isEmpty()) {
          if (topCategoryStats_.isEmpty()) {
            topCategoryStats_ = other.topCategoryStats_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureTopCategoryStatsIsMutable();
            topCategoryStats_.addAll(other.topCategoryStats_);
          }
          onChanged();
        }
      } else {
        if (!other.topCategoryStats_.isEmpty()) {
          if (topCategoryStatsBuilder_.isEmpty()) {
            topCategoryStatsBuilder_.dispose();
            topCategoryStatsBuilder_ = null;
            topCategoryStats_ = other.topCategoryStats_;
            bitField0_ = (bitField0_ & ~0x00000001);
            topCategoryStatsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getTopCategoryStatsFieldBuilder()
                    : null;
          } else {
            topCategoryStatsBuilder_.addAllMessages(other.topCategoryStats_);
          }
        }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.automl.v1beta1.CategoryStats parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloud.automl.v1beta1.CategoryStats) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats>
        topCategoryStats_ = java.util.Collections.emptyList();

    private void ensureTopCategoryStatsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        topCategoryStats_ =
            new java.util.ArrayList<
                com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats>(
                topCategoryStats_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats,
            com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats.Builder,
            com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStatsOrBuilder>
        topCategoryStatsBuilder_;

    /**
     *
     *
     * <pre>
     * The statistics of the top 20 CATEGORY values, ordered by
     * [count][google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats.count].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats top_category_stats = 1;
     * </code>
     */
    public java.util.List<com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats>
        getTopCategoryStatsList() {
      if (topCategoryStatsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(topCategoryStats_);
      } else {
        return topCategoryStatsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The statistics of the top 20 CATEGORY values, ordered by
     * [count][google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats.count].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats top_category_stats = 1;
     * </code>
     */
    public int getTopCategoryStatsCount() {
      if (topCategoryStatsBuilder_ == null) {
        return topCategoryStats_.size();
      } else {
        return topCategoryStatsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The statistics of the top 20 CATEGORY values, ordered by
     * [count][google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats.count].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats top_category_stats = 1;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats getTopCategoryStats(
        int index) {
      if (topCategoryStatsBuilder_ == null) {
        return topCategoryStats_.get(index);
      } else {
        return topCategoryStatsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The statistics of the top 20 CATEGORY values, ordered by
     * [count][google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats.count].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats top_category_stats = 1;
     * </code>
     */
    public Builder setTopCategoryStats(
        int index, com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats value) {
      if (topCategoryStatsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTopCategoryStatsIsMutable();
        topCategoryStats_.set(index, value);
        onChanged();
      } else {
        topCategoryStatsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The statistics of the top 20 CATEGORY values, ordered by
     * [count][google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats.count].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats top_category_stats = 1;
     * </code>
     */
    public Builder setTopCategoryStats(
        int index,
        com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats.Builder builderForValue) {
      if (topCategoryStatsBuilder_ == null) {
        ensureTopCategoryStatsIsMutable();
        topCategoryStats_.set(index, builderForValue.build());
        onChanged();
      } else {
        topCategoryStatsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The statistics of the top 20 CATEGORY values, ordered by
     * [count][google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats.count].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats top_category_stats = 1;
     * </code>
     */
    public Builder addTopCategoryStats(
        com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats value) {
      if (topCategoryStatsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTopCategoryStatsIsMutable();
        topCategoryStats_.add(value);
        onChanged();
      } else {
        topCategoryStatsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The statistics of the top 20 CATEGORY values, ordered by
     * [count][google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats.count].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats top_category_stats = 1;
     * </code>
     */
    public Builder addTopCategoryStats(
        int index, com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats value) {
      if (topCategoryStatsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTopCategoryStatsIsMutable();
        topCategoryStats_.add(index, value);
        onChanged();
      } else {
        topCategoryStatsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The statistics of the top 20 CATEGORY values, ordered by
     * [count][google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats.count].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats top_category_stats = 1;
     * </code>
     */
    public Builder addTopCategoryStats(
        com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats.Builder builderForValue) {
      if (topCategoryStatsBuilder_ == null) {
        ensureTopCategoryStatsIsMutable();
        topCategoryStats_.add(builderForValue.build());
        onChanged();
      } else {
        topCategoryStatsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The statistics of the top 20 CATEGORY values, ordered by
     * [count][google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats.count].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats top_category_stats = 1;
     * </code>
     */
    public Builder addTopCategoryStats(
        int index,
        com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats.Builder builderForValue) {
      if (topCategoryStatsBuilder_ == null) {
        ensureTopCategoryStatsIsMutable();
        topCategoryStats_.add(index, builderForValue.build());
        onChanged();
      } else {
        topCategoryStatsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The statistics of the top 20 CATEGORY values, ordered by
     * [count][google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats.count].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats top_category_stats = 1;
     * </code>
     */
    public Builder addAllTopCategoryStats(
        java.lang.Iterable<
                ? extends com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats>
            values) {
      if (topCategoryStatsBuilder_ == null) {
        ensureTopCategoryStatsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, topCategoryStats_);
        onChanged();
      } else {
        topCategoryStatsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The statistics of the top 20 CATEGORY values, ordered by
     * [count][google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats.count].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats top_category_stats = 1;
     * </code>
     */
    public Builder clearTopCategoryStats() {
      if (topCategoryStatsBuilder_ == null) {
        topCategoryStats_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        topCategoryStatsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The statistics of the top 20 CATEGORY values, ordered by
     * [count][google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats.count].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats top_category_stats = 1;
     * </code>
     */
    public Builder removeTopCategoryStats(int index) {
      if (topCategoryStatsBuilder_ == null) {
        ensureTopCategoryStatsIsMutable();
        topCategoryStats_.remove(index);
        onChanged();
      } else {
        topCategoryStatsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The statistics of the top 20 CATEGORY values, ordered by
     * [count][google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats.count].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats top_category_stats = 1;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats.Builder
        getTopCategoryStatsBuilder(int index) {
      return getTopCategoryStatsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The statistics of the top 20 CATEGORY values, ordered by
     * [count][google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats.count].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats top_category_stats = 1;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStatsOrBuilder
        getTopCategoryStatsOrBuilder(int index) {
      if (topCategoryStatsBuilder_ == null) {
        return topCategoryStats_.get(index);
      } else {
        return topCategoryStatsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The statistics of the top 20 CATEGORY values, ordered by
     * [count][google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats.count].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats top_category_stats = 1;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStatsOrBuilder>
        getTopCategoryStatsOrBuilderList() {
      if (topCategoryStatsBuilder_ != null) {
        return topCategoryStatsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(topCategoryStats_);
      }
    }
    /**
     *
     *
     * <pre>
     * The statistics of the top 20 CATEGORY values, ordered by
     * [count][google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats.count].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats top_category_stats = 1;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats.Builder
        addTopCategoryStatsBuilder() {
      return getTopCategoryStatsFieldBuilder()
          .addBuilder(
              com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The statistics of the top 20 CATEGORY values, ordered by
     * [count][google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats.count].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats top_category_stats = 1;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats.Builder
        addTopCategoryStatsBuilder(int index) {
      return getTopCategoryStatsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The statistics of the top 20 CATEGORY values, ordered by
     * [count][google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats.count].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats top_category_stats = 1;
     * </code>
     */
    public java.util.List<com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats.Builder>
        getTopCategoryStatsBuilderList() {
      return getTopCategoryStatsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats,
            com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats.Builder,
            com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStatsOrBuilder>
        getTopCategoryStatsFieldBuilder() {
      if (topCategoryStatsBuilder_ == null) {
        topCategoryStatsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats,
                com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats.Builder,
                com.google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStatsOrBuilder>(
                topCategoryStats_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        topCategoryStats_ = null;
      }
      return topCategoryStatsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.automl.v1beta1.CategoryStats)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.automl.v1beta1.CategoryStats)
  private static final com.google.cloud.automl.v1beta1.CategoryStats DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.automl.v1beta1.CategoryStats();
  }

  public static com.google.cloud.automl.v1beta1.CategoryStats getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CategoryStats> PARSER =
      new com.google.protobuf.AbstractParser<CategoryStats>() {
        @java.lang.Override
        public CategoryStats parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new CategoryStats(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<CategoryStats> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CategoryStats> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.automl.v1beta1.CategoryStats getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
