/*
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/automl/v1beta1/classification.proto

package com.google.cloud.automl.v1beta1;

public final class ClassificationProto {
  private ClassificationProto() {}

  public static void registerAllExtensions(com.google.protobuf.ExtensionRegistryLite registry) {}

  public static void registerAllExtensions(com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions((com.google.protobuf.ExtensionRegistryLite) registry);
  }
  /**
   *
   *
   * <pre>
   * Type of the classification problem.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.automl.v1beta1.ClassificationType}
   */
  public enum ClassificationType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * An un-set value of this enum.
     * </pre>
     *
     * <code>CLASSIFICATION_TYPE_UNSPECIFIED = 0;</code>
     */
    CLASSIFICATION_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * At most one label is allowed per example.
     * </pre>
     *
     * <code>MULTICLASS = 1;</code>
     */
    MULTICLASS(1),
    /**
     *
     *
     * <pre>
     * Multiple labels are allowed for one example.
     * </pre>
     *
     * <code>MULTILABEL = 2;</code>
     */
    MULTILABEL(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * An un-set value of this enum.
     * </pre>
     *
     * <code>CLASSIFICATION_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int CLASSIFICATION_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * At most one label is allowed per example.
     * </pre>
     *
     * <code>MULTICLASS = 1;</code>
     */
    public static final int MULTICLASS_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Multiple labels are allowed for one example.
     * </pre>
     *
     * <code>MULTILABEL = 2;</code>
     */
    public static final int MULTILABEL_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ClassificationType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ClassificationType forNumber(int value) {
      switch (value) {
        case 0:
          return CLASSIFICATION_TYPE_UNSPECIFIED;
        case 1:
          return MULTICLASS;
        case 2:
          return MULTILABEL;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ClassificationType>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ClassificationType>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<ClassificationType>() {
              public ClassificationType findValueByNumber(int number) {
                return ClassificationType.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.automl.v1beta1.ClassificationProto.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final ClassificationType[] VALUES = values();

    public static ClassificationType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ClassificationType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.automl.v1beta1.ClassificationType)
  }

  public interface ClassificationAnnotationOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.automl.v1beta1.ClassificationAnnotation)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. A confidence estimate between 0.0 and 1.0. A higher value
     * means greater confidence that the annotation is positive. If a user
     * approves an annotation as negative or positive, the score value remains
     * unchanged. If a user creates an annotation, the score is 0 for negative or
     * 1 for positive.
     * </pre>
     *
     * <code>float score = 1;</code>
     *
     * @return The score.
     */
    float getScore();
  }
  /**
   *
   *
   * <pre>
   * Contains annotation details specific to classification.
   * </pre>
   *
   * Protobuf type {@code google.cloud.automl.v1beta1.ClassificationAnnotation}
   */
  public static final class ClassificationAnnotation extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.automl.v1beta1.ClassificationAnnotation)
      ClassificationAnnotationOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ClassificationAnnotation.newBuilder() to construct.
    private ClassificationAnnotation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ClassificationAnnotation() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ClassificationAnnotation();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private ClassificationAnnotation(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 13:
              {
                score_ = input.readFloat();
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.automl.v1beta1.ClassificationProto
          .internal_static_google_cloud_automl_v1beta1_ClassificationAnnotation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.automl.v1beta1.ClassificationProto
          .internal_static_google_cloud_automl_v1beta1_ClassificationAnnotation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotation.class,
              com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotation.Builder
                  .class);
    }

    public static final int SCORE_FIELD_NUMBER = 1;
    private float score_;
    /**
     *
     *
     * <pre>
     * Output only. A confidence estimate between 0.0 and 1.0. A higher value
     * means greater confidence that the annotation is positive. If a user
     * approves an annotation as negative or positive, the score value remains
     * unchanged. If a user creates an annotation, the score is 0 for negative or
     * 1 for positive.
     * </pre>
     *
     * <code>float score = 1;</code>
     *
     * @return The score.
     */
    public float getScore() {
      return score_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (score_ != 0F) {
        output.writeFloat(1, score_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (score_ != 0F) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(1, score_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotation)) {
        return super.equals(obj);
      }
      com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotation other =
          (com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotation) obj;

      if (java.lang.Float.floatToIntBits(getScore())
          != java.lang.Float.floatToIntBits(other.getScore())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SCORE_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getScore());
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotation
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotation
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotation
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotation
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotation
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotation
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotation
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotation
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotation
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotation
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotation
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotation
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotation prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Contains annotation details specific to classification.
     * </pre>
     *
     * Protobuf type {@code google.cloud.automl.v1beta1.ClassificationAnnotation}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.automl.v1beta1.ClassificationAnnotation)
        com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.automl.v1beta1.ClassificationProto
            .internal_static_google_cloud_automl_v1beta1_ClassificationAnnotation_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.automl.v1beta1.ClassificationProto
            .internal_static_google_cloud_automl_v1beta1_ClassificationAnnotation_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotation.class,
                com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotation.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotation.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        score_ = 0F;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.automl.v1beta1.ClassificationProto
            .internal_static_google_cloud_automl_v1beta1_ClassificationAnnotation_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotation
          getDefaultInstanceForType() {
        return com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotation
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotation build() {
        com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotation result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotation
          buildPartial() {
        com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotation result =
            new com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotation(this);
        result.score_ = score_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotation) {
          return mergeFrom(
              (com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotation) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotation other) {
        if (other
            == com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotation
                .getDefaultInstance()) return this;
        if (other.getScore() != 0F) {
          setScore(other.getScore());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotation parsedMessage =
            null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotation)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private float score_;
      /**
       *
       *
       * <pre>
       * Output only. A confidence estimate between 0.0 and 1.0. A higher value
       * means greater confidence that the annotation is positive. If a user
       * approves an annotation as negative or positive, the score value remains
       * unchanged. If a user creates an annotation, the score is 0 for negative or
       * 1 for positive.
       * </pre>
       *
       * <code>float score = 1;</code>
       *
       * @return The score.
       */
      public float getScore() {
        return score_;
      }
      /**
       *
       *
       * <pre>
       * Output only. A confidence estimate between 0.0 and 1.0. A higher value
       * means greater confidence that the annotation is positive. If a user
       * approves an annotation as negative or positive, the score value remains
       * unchanged. If a user creates an annotation, the score is 0 for negative or
       * 1 for positive.
       * </pre>
       *
       * <code>float score = 1;</code>
       *
       * @param value The score to set.
       * @return This builder for chaining.
       */
      public Builder setScore(float value) {

        score_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. A confidence estimate between 0.0 and 1.0. A higher value
       * means greater confidence that the annotation is positive. If a user
       * approves an annotation as negative or positive, the score value remains
       * unchanged. If a user creates an annotation, the score is 0 for negative or
       * 1 for positive.
       * </pre>
       *
       * <code>float score = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearScore() {

        score_ = 0F;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.automl.v1beta1.ClassificationAnnotation)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.automl.v1beta1.ClassificationAnnotation)
    private static final com.google.cloud.automl.v1beta1.ClassificationProto
            .ClassificationAnnotation
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotation();
    }

    public static com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotation
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ClassificationAnnotation> PARSER =
        new com.google.protobuf.AbstractParser<ClassificationAnnotation>() {
          @java.lang.Override
          public ClassificationAnnotation parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new ClassificationAnnotation(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<ClassificationAnnotation> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ClassificationAnnotation> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotation
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface VideoClassificationAnnotationOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.automl.v1beta1.VideoClassificationAnnotation)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. Expresses the type of video classification. Possible values:
     * *  `segment` - Classification done on a specified by user
     *        time segment of a video. AnnotationSpec is answered to be present
     *        in that time segment, if it is present in any part of it. The video
     *        ML model evaluations are done only for this type of classification.
     * *  `shot`- Shot-level classification.
     *        AutoML Video Intelligence determines the boundaries
     *        for each camera shot in the entire segment of the video that user
     *        specified in the request configuration. AutoML Video Intelligence
     *        then returns labels and their confidence scores for each detected
     *        shot, along with the start and end time of the shot.
     *        WARNING: Model evaluation is not done for this classification type,
     *        the quality of it depends on training data, but there are no
     *        metrics provided to describe that quality.
     * *  `1s_interval` - AutoML Video Intelligence returns labels and their
     *        confidence scores for each second of the entire segment of the video
     *        that user specified in the request configuration.
     *        WARNING: Model evaluation is not done for this classification type,
     *        the quality of it depends on training data, but there are no
     *        metrics provided to describe that quality.
     * </pre>
     *
     * <code>string type = 1;</code>
     *
     * @return The type.
     */
    java.lang.String getType();
    /**
     *
     *
     * <pre>
     * Output only. Expresses the type of video classification. Possible values:
     * *  `segment` - Classification done on a specified by user
     *        time segment of a video. AnnotationSpec is answered to be present
     *        in that time segment, if it is present in any part of it. The video
     *        ML model evaluations are done only for this type of classification.
     * *  `shot`- Shot-level classification.
     *        AutoML Video Intelligence determines the boundaries
     *        for each camera shot in the entire segment of the video that user
     *        specified in the request configuration. AutoML Video Intelligence
     *        then returns labels and their confidence scores for each detected
     *        shot, along with the start and end time of the shot.
     *        WARNING: Model evaluation is not done for this classification type,
     *        the quality of it depends on training data, but there are no
     *        metrics provided to describe that quality.
     * *  `1s_interval` - AutoML Video Intelligence returns labels and their
     *        confidence scores for each second of the entire segment of the video
     *        that user specified in the request configuration.
     *        WARNING: Model evaluation is not done for this classification type,
     *        the quality of it depends on training data, but there are no
     *        metrics provided to describe that quality.
     * </pre>
     *
     * <code>string type = 1;</code>
     *
     * @return The bytes for type.
     */
    com.google.protobuf.ByteString getTypeBytes();

    /**
     *
     *
     * <pre>
     * Output only . The classification details of this annotation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.ClassificationAnnotation classification_annotation = 2;
     * </code>
     *
     * @return Whether the classificationAnnotation field is set.
     */
    boolean hasClassificationAnnotation();
    /**
     *
     *
     * <pre>
     * Output only . The classification details of this annotation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.ClassificationAnnotation classification_annotation = 2;
     * </code>
     *
     * @return The classificationAnnotation.
     */
    com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotation
        getClassificationAnnotation();
    /**
     *
     *
     * <pre>
     * Output only . The classification details of this annotation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.ClassificationAnnotation classification_annotation = 2;
     * </code>
     */
    com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotationOrBuilder
        getClassificationAnnotationOrBuilder();

    /**
     *
     *
     * <pre>
     * Output only . The time segment of the video to which the
     * annotation applies.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.TimeSegment time_segment = 3;</code>
     *
     * @return Whether the timeSegment field is set.
     */
    boolean hasTimeSegment();
    /**
     *
     *
     * <pre>
     * Output only . The time segment of the video to which the
     * annotation applies.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.TimeSegment time_segment = 3;</code>
     *
     * @return The timeSegment.
     */
    com.google.cloud.automl.v1beta1.TimeSegment getTimeSegment();
    /**
     *
     *
     * <pre>
     * Output only . The time segment of the video to which the
     * annotation applies.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.TimeSegment time_segment = 3;</code>
     */
    com.google.cloud.automl.v1beta1.TimeSegmentOrBuilder getTimeSegmentOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Contains annotation details specific to video classification.
   * </pre>
   *
   * Protobuf type {@code google.cloud.automl.v1beta1.VideoClassificationAnnotation}
   */
  public static final class VideoClassificationAnnotation
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.automl.v1beta1.VideoClassificationAnnotation)
      VideoClassificationAnnotationOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use VideoClassificationAnnotation.newBuilder() to construct.
    private VideoClassificationAnnotation(
        com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private VideoClassificationAnnotation() {
      type_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new VideoClassificationAnnotation();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private VideoClassificationAnnotation(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                type_ = s;
                break;
              }
            case 18:
              {
                com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotation.Builder
                    subBuilder = null;
                if (classificationAnnotation_ != null) {
                  subBuilder = classificationAnnotation_.toBuilder();
                }
                classificationAnnotation_ =
                    input.readMessage(
                        com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotation
                            .parser(),
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(classificationAnnotation_);
                  classificationAnnotation_ = subBuilder.buildPartial();
                }

                break;
              }
            case 26:
              {
                com.google.cloud.automl.v1beta1.TimeSegment.Builder subBuilder = null;
                if (timeSegment_ != null) {
                  subBuilder = timeSegment_.toBuilder();
                }
                timeSegment_ =
                    input.readMessage(
                        com.google.cloud.automl.v1beta1.TimeSegment.parser(), extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(timeSegment_);
                  timeSegment_ = subBuilder.buildPartial();
                }

                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.automl.v1beta1.ClassificationProto
          .internal_static_google_cloud_automl_v1beta1_VideoClassificationAnnotation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.automl.v1beta1.ClassificationProto
          .internal_static_google_cloud_automl_v1beta1_VideoClassificationAnnotation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.automl.v1beta1.ClassificationProto.VideoClassificationAnnotation
                  .class,
              com.google.cloud.automl.v1beta1.ClassificationProto.VideoClassificationAnnotation
                  .Builder.class);
    }

    public static final int TYPE_FIELD_NUMBER = 1;
    private volatile java.lang.Object type_;
    /**
     *
     *
     * <pre>
     * Output only. Expresses the type of video classification. Possible values:
     * *  `segment` - Classification done on a specified by user
     *        time segment of a video. AnnotationSpec is answered to be present
     *        in that time segment, if it is present in any part of it. The video
     *        ML model evaluations are done only for this type of classification.
     * *  `shot`- Shot-level classification.
     *        AutoML Video Intelligence determines the boundaries
     *        for each camera shot in the entire segment of the video that user
     *        specified in the request configuration. AutoML Video Intelligence
     *        then returns labels and their confidence scores for each detected
     *        shot, along with the start and end time of the shot.
     *        WARNING: Model evaluation is not done for this classification type,
     *        the quality of it depends on training data, but there are no
     *        metrics provided to describe that quality.
     * *  `1s_interval` - AutoML Video Intelligence returns labels and their
     *        confidence scores for each second of the entire segment of the video
     *        that user specified in the request configuration.
     *        WARNING: Model evaluation is not done for this classification type,
     *        the quality of it depends on training data, but there are no
     *        metrics provided to describe that quality.
     * </pre>
     *
     * <code>string type = 1;</code>
     *
     * @return The type.
     */
    public java.lang.String getType() {
      java.lang.Object ref = type_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        type_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Expresses the type of video classification. Possible values:
     * *  `segment` - Classification done on a specified by user
     *        time segment of a video. AnnotationSpec is answered to be present
     *        in that time segment, if it is present in any part of it. The video
     *        ML model evaluations are done only for this type of classification.
     * *  `shot`- Shot-level classification.
     *        AutoML Video Intelligence determines the boundaries
     *        for each camera shot in the entire segment of the video that user
     *        specified in the request configuration. AutoML Video Intelligence
     *        then returns labels and their confidence scores for each detected
     *        shot, along with the start and end time of the shot.
     *        WARNING: Model evaluation is not done for this classification type,
     *        the quality of it depends on training data, but there are no
     *        metrics provided to describe that quality.
     * *  `1s_interval` - AutoML Video Intelligence returns labels and their
     *        confidence scores for each second of the entire segment of the video
     *        that user specified in the request configuration.
     *        WARNING: Model evaluation is not done for this classification type,
     *        the quality of it depends on training data, but there are no
     *        metrics provided to describe that quality.
     * </pre>
     *
     * <code>string type = 1;</code>
     *
     * @return The bytes for type.
     */
    public com.google.protobuf.ByteString getTypeBytes() {
      java.lang.Object ref = type_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        type_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CLASSIFICATION_ANNOTATION_FIELD_NUMBER = 2;
    private com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotation
        classificationAnnotation_;
    /**
     *
     *
     * <pre>
     * Output only . The classification details of this annotation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.ClassificationAnnotation classification_annotation = 2;
     * </code>
     *
     * @return Whether the classificationAnnotation field is set.
     */
    public boolean hasClassificationAnnotation() {
      return classificationAnnotation_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only . The classification details of this annotation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.ClassificationAnnotation classification_annotation = 2;
     * </code>
     *
     * @return The classificationAnnotation.
     */
    public com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotation
        getClassificationAnnotation() {
      return classificationAnnotation_ == null
          ? com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotation
              .getDefaultInstance()
          : classificationAnnotation_;
    }
    /**
     *
     *
     * <pre>
     * Output only . The classification details of this annotation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.ClassificationAnnotation classification_annotation = 2;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotationOrBuilder
        getClassificationAnnotationOrBuilder() {
      return getClassificationAnnotation();
    }

    public static final int TIME_SEGMENT_FIELD_NUMBER = 3;
    private com.google.cloud.automl.v1beta1.TimeSegment timeSegment_;
    /**
     *
     *
     * <pre>
     * Output only . The time segment of the video to which the
     * annotation applies.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.TimeSegment time_segment = 3;</code>
     *
     * @return Whether the timeSegment field is set.
     */
    public boolean hasTimeSegment() {
      return timeSegment_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only . The time segment of the video to which the
     * annotation applies.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.TimeSegment time_segment = 3;</code>
     *
     * @return The timeSegment.
     */
    public com.google.cloud.automl.v1beta1.TimeSegment getTimeSegment() {
      return timeSegment_ == null
          ? com.google.cloud.automl.v1beta1.TimeSegment.getDefaultInstance()
          : timeSegment_;
    }
    /**
     *
     *
     * <pre>
     * Output only . The time segment of the video to which the
     * annotation applies.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.TimeSegment time_segment = 3;</code>
     */
    public com.google.cloud.automl.v1beta1.TimeSegmentOrBuilder getTimeSegmentOrBuilder() {
      return getTimeSegment();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!getTypeBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, type_);
      }
      if (classificationAnnotation_ != null) {
        output.writeMessage(2, getClassificationAnnotation());
      }
      if (timeSegment_ != null) {
        output.writeMessage(3, getTimeSegment());
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getTypeBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, type_);
      }
      if (classificationAnnotation_ != null) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                2, getClassificationAnnotation());
      }
      if (timeSegment_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getTimeSegment());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.automl.v1beta1.ClassificationProto.VideoClassificationAnnotation)) {
        return super.equals(obj);
      }
      com.google.cloud.automl.v1beta1.ClassificationProto.VideoClassificationAnnotation other =
          (com.google.cloud.automl.v1beta1.ClassificationProto.VideoClassificationAnnotation) obj;

      if (!getType().equals(other.getType())) return false;
      if (hasClassificationAnnotation() != other.hasClassificationAnnotation()) return false;
      if (hasClassificationAnnotation()) {
        if (!getClassificationAnnotation().equals(other.getClassificationAnnotation()))
          return false;
      }
      if (hasTimeSegment() != other.hasTimeSegment()) return false;
      if (hasTimeSegment()) {
        if (!getTimeSegment().equals(other.getTimeSegment())) return false;
      }
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getType().hashCode();
      if (hasClassificationAnnotation()) {
        hash = (37 * hash) + CLASSIFICATION_ANNOTATION_FIELD_NUMBER;
        hash = (53 * hash) + getClassificationAnnotation().hashCode();
      }
      if (hasTimeSegment()) {
        hash = (37 * hash) + TIME_SEGMENT_FIELD_NUMBER;
        hash = (53 * hash) + getTimeSegment().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.automl.v1beta1.ClassificationProto.VideoClassificationAnnotation
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.automl.v1beta1.ClassificationProto.VideoClassificationAnnotation
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.automl.v1beta1.ClassificationProto.VideoClassificationAnnotation
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.automl.v1beta1.ClassificationProto.VideoClassificationAnnotation
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.automl.v1beta1.ClassificationProto.VideoClassificationAnnotation
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.automl.v1beta1.ClassificationProto.VideoClassificationAnnotation
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.automl.v1beta1.ClassificationProto.VideoClassificationAnnotation
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.automl.v1beta1.ClassificationProto.VideoClassificationAnnotation
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.automl.v1beta1.ClassificationProto.VideoClassificationAnnotation
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.automl.v1beta1.ClassificationProto.VideoClassificationAnnotation
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.automl.v1beta1.ClassificationProto.VideoClassificationAnnotation
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.automl.v1beta1.ClassificationProto.VideoClassificationAnnotation
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.automl.v1beta1.ClassificationProto.VideoClassificationAnnotation
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Contains annotation details specific to video classification.
     * </pre>
     *
     * Protobuf type {@code google.cloud.automl.v1beta1.VideoClassificationAnnotation}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.automl.v1beta1.VideoClassificationAnnotation)
        com.google.cloud.automl.v1beta1.ClassificationProto.VideoClassificationAnnotationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.automl.v1beta1.ClassificationProto
            .internal_static_google_cloud_automl_v1beta1_VideoClassificationAnnotation_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.automl.v1beta1.ClassificationProto
            .internal_static_google_cloud_automl_v1beta1_VideoClassificationAnnotation_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.automl.v1beta1.ClassificationProto.VideoClassificationAnnotation
                    .class,
                com.google.cloud.automl.v1beta1.ClassificationProto.VideoClassificationAnnotation
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.automl.v1beta1.ClassificationProto.VideoClassificationAnnotation.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        type_ = "";

        if (classificationAnnotationBuilder_ == null) {
          classificationAnnotation_ = null;
        } else {
          classificationAnnotation_ = null;
          classificationAnnotationBuilder_ = null;
        }
        if (timeSegmentBuilder_ == null) {
          timeSegment_ = null;
        } else {
          timeSegment_ = null;
          timeSegmentBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.automl.v1beta1.ClassificationProto
            .internal_static_google_cloud_automl_v1beta1_VideoClassificationAnnotation_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.automl.v1beta1.ClassificationProto.VideoClassificationAnnotation
          getDefaultInstanceForType() {
        return com.google.cloud.automl.v1beta1.ClassificationProto.VideoClassificationAnnotation
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.automl.v1beta1.ClassificationProto.VideoClassificationAnnotation
          build() {
        com.google.cloud.automl.v1beta1.ClassificationProto.VideoClassificationAnnotation result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.automl.v1beta1.ClassificationProto.VideoClassificationAnnotation
          buildPartial() {
        com.google.cloud.automl.v1beta1.ClassificationProto.VideoClassificationAnnotation result =
            new com.google.cloud.automl.v1beta1.ClassificationProto.VideoClassificationAnnotation(
                this);
        result.type_ = type_;
        if (classificationAnnotationBuilder_ == null) {
          result.classificationAnnotation_ = classificationAnnotation_;
        } else {
          result.classificationAnnotation_ = classificationAnnotationBuilder_.build();
        }
        if (timeSegmentBuilder_ == null) {
          result.timeSegment_ = timeSegment_;
        } else {
          result.timeSegment_ = timeSegmentBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.automl.v1beta1.ClassificationProto.VideoClassificationAnnotation) {
          return mergeFrom(
              (com.google.cloud.automl.v1beta1.ClassificationProto.VideoClassificationAnnotation)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.automl.v1beta1.ClassificationProto.VideoClassificationAnnotation other) {
        if (other
            == com.google.cloud.automl.v1beta1.ClassificationProto.VideoClassificationAnnotation
                .getDefaultInstance()) return this;
        if (!other.getType().isEmpty()) {
          type_ = other.type_;
          onChanged();
        }
        if (other.hasClassificationAnnotation()) {
          mergeClassificationAnnotation(other.getClassificationAnnotation());
        }
        if (other.hasTimeSegment()) {
          mergeTimeSegment(other.getTimeSegment());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.automl.v1beta1.ClassificationProto.VideoClassificationAnnotation
            parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.automl.v1beta1.ClassificationProto.VideoClassificationAnnotation)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object type_ = "";
      /**
       *
       *
       * <pre>
       * Output only. Expresses the type of video classification. Possible values:
       * *  `segment` - Classification done on a specified by user
       *        time segment of a video. AnnotationSpec is answered to be present
       *        in that time segment, if it is present in any part of it. The video
       *        ML model evaluations are done only for this type of classification.
       * *  `shot`- Shot-level classification.
       *        AutoML Video Intelligence determines the boundaries
       *        for each camera shot in the entire segment of the video that user
       *        specified in the request configuration. AutoML Video Intelligence
       *        then returns labels and their confidence scores for each detected
       *        shot, along with the start and end time of the shot.
       *        WARNING: Model evaluation is not done for this classification type,
       *        the quality of it depends on training data, but there are no
       *        metrics provided to describe that quality.
       * *  `1s_interval` - AutoML Video Intelligence returns labels and their
       *        confidence scores for each second of the entire segment of the video
       *        that user specified in the request configuration.
       *        WARNING: Model evaluation is not done for this classification type,
       *        the quality of it depends on training data, but there are no
       *        metrics provided to describe that quality.
       * </pre>
       *
       * <code>string type = 1;</code>
       *
       * @return The type.
       */
      public java.lang.String getType() {
        java.lang.Object ref = type_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          type_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Expresses the type of video classification. Possible values:
       * *  `segment` - Classification done on a specified by user
       *        time segment of a video. AnnotationSpec is answered to be present
       *        in that time segment, if it is present in any part of it. The video
       *        ML model evaluations are done only for this type of classification.
       * *  `shot`- Shot-level classification.
       *        AutoML Video Intelligence determines the boundaries
       *        for each camera shot in the entire segment of the video that user
       *        specified in the request configuration. AutoML Video Intelligence
       *        then returns labels and their confidence scores for each detected
       *        shot, along with the start and end time of the shot.
       *        WARNING: Model evaluation is not done for this classification type,
       *        the quality of it depends on training data, but there are no
       *        metrics provided to describe that quality.
       * *  `1s_interval` - AutoML Video Intelligence returns labels and their
       *        confidence scores for each second of the entire segment of the video
       *        that user specified in the request configuration.
       *        WARNING: Model evaluation is not done for this classification type,
       *        the quality of it depends on training data, but there are no
       *        metrics provided to describe that quality.
       * </pre>
       *
       * <code>string type = 1;</code>
       *
       * @return The bytes for type.
       */
      public com.google.protobuf.ByteString getTypeBytes() {
        java.lang.Object ref = type_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          type_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Expresses the type of video classification. Possible values:
       * *  `segment` - Classification done on a specified by user
       *        time segment of a video. AnnotationSpec is answered to be present
       *        in that time segment, if it is present in any part of it. The video
       *        ML model evaluations are done only for this type of classification.
       * *  `shot`- Shot-level classification.
       *        AutoML Video Intelligence determines the boundaries
       *        for each camera shot in the entire segment of the video that user
       *        specified in the request configuration. AutoML Video Intelligence
       *        then returns labels and their confidence scores for each detected
       *        shot, along with the start and end time of the shot.
       *        WARNING: Model evaluation is not done for this classification type,
       *        the quality of it depends on training data, but there are no
       *        metrics provided to describe that quality.
       * *  `1s_interval` - AutoML Video Intelligence returns labels and their
       *        confidence scores for each second of the entire segment of the video
       *        that user specified in the request configuration.
       *        WARNING: Model evaluation is not done for this classification type,
       *        the quality of it depends on training data, but there are no
       *        metrics provided to describe that quality.
       * </pre>
       *
       * <code>string type = 1;</code>
       *
       * @param value The type to set.
       * @return This builder for chaining.
       */
      public Builder setType(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        type_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Expresses the type of video classification. Possible values:
       * *  `segment` - Classification done on a specified by user
       *        time segment of a video. AnnotationSpec is answered to be present
       *        in that time segment, if it is present in any part of it. The video
       *        ML model evaluations are done only for this type of classification.
       * *  `shot`- Shot-level classification.
       *        AutoML Video Intelligence determines the boundaries
       *        for each camera shot in the entire segment of the video that user
       *        specified in the request configuration. AutoML Video Intelligence
       *        then returns labels and their confidence scores for each detected
       *        shot, along with the start and end time of the shot.
       *        WARNING: Model evaluation is not done for this classification type,
       *        the quality of it depends on training data, but there are no
       *        metrics provided to describe that quality.
       * *  `1s_interval` - AutoML Video Intelligence returns labels and their
       *        confidence scores for each second of the entire segment of the video
       *        that user specified in the request configuration.
       *        WARNING: Model evaluation is not done for this classification type,
       *        the quality of it depends on training data, but there are no
       *        metrics provided to describe that quality.
       * </pre>
       *
       * <code>string type = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearType() {

        type_ = getDefaultInstance().getType();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Expresses the type of video classification. Possible values:
       * *  `segment` - Classification done on a specified by user
       *        time segment of a video. AnnotationSpec is answered to be present
       *        in that time segment, if it is present in any part of it. The video
       *        ML model evaluations are done only for this type of classification.
       * *  `shot`- Shot-level classification.
       *        AutoML Video Intelligence determines the boundaries
       *        for each camera shot in the entire segment of the video that user
       *        specified in the request configuration. AutoML Video Intelligence
       *        then returns labels and their confidence scores for each detected
       *        shot, along with the start and end time of the shot.
       *        WARNING: Model evaluation is not done for this classification type,
       *        the quality of it depends on training data, but there are no
       *        metrics provided to describe that quality.
       * *  `1s_interval` - AutoML Video Intelligence returns labels and their
       *        confidence scores for each second of the entire segment of the video
       *        that user specified in the request configuration.
       *        WARNING: Model evaluation is not done for this classification type,
       *        the quality of it depends on training data, but there are no
       *        metrics provided to describe that quality.
       * </pre>
       *
       * <code>string type = 1;</code>
       *
       * @param value The bytes for type to set.
       * @return This builder for chaining.
       */
      public Builder setTypeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        type_ = value;
        onChanged();
        return this;
      }

      private com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotation
          classificationAnnotation_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotation,
              com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotation.Builder,
              com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotationOrBuilder>
          classificationAnnotationBuilder_;
      /**
       *
       *
       * <pre>
       * Output only . The classification details of this annotation.
       * </pre>
       *
       * <code>.google.cloud.automl.v1beta1.ClassificationAnnotation classification_annotation = 2;
       * </code>
       *
       * @return Whether the classificationAnnotation field is set.
       */
      public boolean hasClassificationAnnotation() {
        return classificationAnnotationBuilder_ != null || classificationAnnotation_ != null;
      }
      /**
       *
       *
       * <pre>
       * Output only . The classification details of this annotation.
       * </pre>
       *
       * <code>.google.cloud.automl.v1beta1.ClassificationAnnotation classification_annotation = 2;
       * </code>
       *
       * @return The classificationAnnotation.
       */
      public com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotation
          getClassificationAnnotation() {
        if (classificationAnnotationBuilder_ == null) {
          return classificationAnnotation_ == null
              ? com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotation
                  .getDefaultInstance()
              : classificationAnnotation_;
        } else {
          return classificationAnnotationBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Output only . The classification details of this annotation.
       * </pre>
       *
       * <code>.google.cloud.automl.v1beta1.ClassificationAnnotation classification_annotation = 2;
       * </code>
       */
      public Builder setClassificationAnnotation(
          com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotation value) {
        if (classificationAnnotationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          classificationAnnotation_ = value;
          onChanged();
        } else {
          classificationAnnotationBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only . The classification details of this annotation.
       * </pre>
       *
       * <code>.google.cloud.automl.v1beta1.ClassificationAnnotation classification_annotation = 2;
       * </code>
       */
      public Builder setClassificationAnnotation(
          com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotation.Builder
              builderForValue) {
        if (classificationAnnotationBuilder_ == null) {
          classificationAnnotation_ = builderForValue.build();
          onChanged();
        } else {
          classificationAnnotationBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only . The classification details of this annotation.
       * </pre>
       *
       * <code>.google.cloud.automl.v1beta1.ClassificationAnnotation classification_annotation = 2;
       * </code>
       */
      public Builder mergeClassificationAnnotation(
          com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotation value) {
        if (classificationAnnotationBuilder_ == null) {
          if (classificationAnnotation_ != null) {
            classificationAnnotation_ =
                com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotation
                    .newBuilder(classificationAnnotation_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            classificationAnnotation_ = value;
          }
          onChanged();
        } else {
          classificationAnnotationBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only . The classification details of this annotation.
       * </pre>
       *
       * <code>.google.cloud.automl.v1beta1.ClassificationAnnotation classification_annotation = 2;
       * </code>
       */
      public Builder clearClassificationAnnotation() {
        if (classificationAnnotationBuilder_ == null) {
          classificationAnnotation_ = null;
          onChanged();
        } else {
          classificationAnnotation_ = null;
          classificationAnnotationBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only . The classification details of this annotation.
       * </pre>
       *
       * <code>.google.cloud.automl.v1beta1.ClassificationAnnotation classification_annotation = 2;
       * </code>
       */
      public com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotation.Builder
          getClassificationAnnotationBuilder() {

        onChanged();
        return getClassificationAnnotationFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Output only . The classification details of this annotation.
       * </pre>
       *
       * <code>.google.cloud.automl.v1beta1.ClassificationAnnotation classification_annotation = 2;
       * </code>
       */
      public com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotationOrBuilder
          getClassificationAnnotationOrBuilder() {
        if (classificationAnnotationBuilder_ != null) {
          return classificationAnnotationBuilder_.getMessageOrBuilder();
        } else {
          return classificationAnnotation_ == null
              ? com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotation
                  .getDefaultInstance()
              : classificationAnnotation_;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only . The classification details of this annotation.
       * </pre>
       *
       * <code>.google.cloud.automl.v1beta1.ClassificationAnnotation classification_annotation = 2;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotation,
              com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotation.Builder,
              com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotationOrBuilder>
          getClassificationAnnotationFieldBuilder() {
        if (classificationAnnotationBuilder_ == null) {
          classificationAnnotationBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotation,
                  com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationAnnotation
                      .Builder,
                  com.google.cloud.automl.v1beta1.ClassificationProto
                      .ClassificationAnnotationOrBuilder>(
                  getClassificationAnnotation(), getParentForChildren(), isClean());
          classificationAnnotation_ = null;
        }
        return classificationAnnotationBuilder_;
      }

      private com.google.cloud.automl.v1beta1.TimeSegment timeSegment_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.automl.v1beta1.TimeSegment,
              com.google.cloud.automl.v1beta1.TimeSegment.Builder,
              com.google.cloud.automl.v1beta1.TimeSegmentOrBuilder>
          timeSegmentBuilder_;
      /**
       *
       *
       * <pre>
       * Output only . The time segment of the video to which the
       * annotation applies.
       * </pre>
       *
       * <code>.google.cloud.automl.v1beta1.TimeSegment time_segment = 3;</code>
       *
       * @return Whether the timeSegment field is set.
       */
      public boolean hasTimeSegment() {
        return timeSegmentBuilder_ != null || timeSegment_ != null;
      }
      /**
       *
       *
       * <pre>
       * Output only . The time segment of the video to which the
       * annotation applies.
       * </pre>
       *
       * <code>.google.cloud.automl.v1beta1.TimeSegment time_segment = 3;</code>
       *
       * @return The timeSegment.
       */
      public com.google.cloud.automl.v1beta1.TimeSegment getTimeSegment() {
        if (timeSegmentBuilder_ == null) {
          return timeSegment_ == null
              ? com.google.cloud.automl.v1beta1.TimeSegment.getDefaultInstance()
              : timeSegment_;
        } else {
          return timeSegmentBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Output only . The time segment of the video to which the
       * annotation applies.
       * </pre>
       *
       * <code>.google.cloud.automl.v1beta1.TimeSegment time_segment = 3;</code>
       */
      public Builder setTimeSegment(com.google.cloud.automl.v1beta1.TimeSegment value) {
        if (timeSegmentBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          timeSegment_ = value;
          onChanged();
        } else {
          timeSegmentBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only . The time segment of the video to which the
       * annotation applies.
       * </pre>
       *
       * <code>.google.cloud.automl.v1beta1.TimeSegment time_segment = 3;</code>
       */
      public Builder setTimeSegment(
          com.google.cloud.automl.v1beta1.TimeSegment.Builder builderForValue) {
        if (timeSegmentBuilder_ == null) {
          timeSegment_ = builderForValue.build();
          onChanged();
        } else {
          timeSegmentBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only . The time segment of the video to which the
       * annotation applies.
       * </pre>
       *
       * <code>.google.cloud.automl.v1beta1.TimeSegment time_segment = 3;</code>
       */
      public Builder mergeTimeSegment(com.google.cloud.automl.v1beta1.TimeSegment value) {
        if (timeSegmentBuilder_ == null) {
          if (timeSegment_ != null) {
            timeSegment_ =
                com.google.cloud.automl.v1beta1.TimeSegment.newBuilder(timeSegment_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            timeSegment_ = value;
          }
          onChanged();
        } else {
          timeSegmentBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only . The time segment of the video to which the
       * annotation applies.
       * </pre>
       *
       * <code>.google.cloud.automl.v1beta1.TimeSegment time_segment = 3;</code>
       */
      public Builder clearTimeSegment() {
        if (timeSegmentBuilder_ == null) {
          timeSegment_ = null;
          onChanged();
        } else {
          timeSegment_ = null;
          timeSegmentBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only . The time segment of the video to which the
       * annotation applies.
       * </pre>
       *
       * <code>.google.cloud.automl.v1beta1.TimeSegment time_segment = 3;</code>
       */
      public com.google.cloud.automl.v1beta1.TimeSegment.Builder getTimeSegmentBuilder() {

        onChanged();
        return getTimeSegmentFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Output only . The time segment of the video to which the
       * annotation applies.
       * </pre>
       *
       * <code>.google.cloud.automl.v1beta1.TimeSegment time_segment = 3;</code>
       */
      public com.google.cloud.automl.v1beta1.TimeSegmentOrBuilder getTimeSegmentOrBuilder() {
        if (timeSegmentBuilder_ != null) {
          return timeSegmentBuilder_.getMessageOrBuilder();
        } else {
          return timeSegment_ == null
              ? com.google.cloud.automl.v1beta1.TimeSegment.getDefaultInstance()
              : timeSegment_;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only . The time segment of the video to which the
       * annotation applies.
       * </pre>
       *
       * <code>.google.cloud.automl.v1beta1.TimeSegment time_segment = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.automl.v1beta1.TimeSegment,
              com.google.cloud.automl.v1beta1.TimeSegment.Builder,
              com.google.cloud.automl.v1beta1.TimeSegmentOrBuilder>
          getTimeSegmentFieldBuilder() {
        if (timeSegmentBuilder_ == null) {
          timeSegmentBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.automl.v1beta1.TimeSegment,
                  com.google.cloud.automl.v1beta1.TimeSegment.Builder,
                  com.google.cloud.automl.v1beta1.TimeSegmentOrBuilder>(
                  getTimeSegment(), getParentForChildren(), isClean());
          timeSegment_ = null;
        }
        return timeSegmentBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.automl.v1beta1.VideoClassificationAnnotation)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.automl.v1beta1.VideoClassificationAnnotation)
    private static final com.google.cloud.automl.v1beta1.ClassificationProto
            .VideoClassificationAnnotation
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.automl.v1beta1.ClassificationProto.VideoClassificationAnnotation();
    }

    public static com.google.cloud.automl.v1beta1.ClassificationProto.VideoClassificationAnnotation
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<VideoClassificationAnnotation> PARSER =
        new com.google.protobuf.AbstractParser<VideoClassificationAnnotation>() {
          @java.lang.Override
          public VideoClassificationAnnotation parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new VideoClassificationAnnotation(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<VideoClassificationAnnotation> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<VideoClassificationAnnotation> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.ClassificationProto.VideoClassificationAnnotation
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ClassificationEvaluationMetricsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.automl.v1beta1.ClassificationEvaluationMetrics)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. The Area Under Precision-Recall Curve metric. Micro-averaged
     * for the overall evaluation.
     * </pre>
     *
     * <code>float au_prc = 1;</code>
     *
     * @return The auPrc.
     */
    float getAuPrc();

    /**
     *
     *
     * <pre>
     * Output only. The Area Under Precision-Recall Curve metric based on priors.
     * Micro-averaged for the overall evaluation.
     * Deprecated.
     * </pre>
     *
     * <code>float base_au_prc = 2 [deprecated = true];</code>
     *
     * @return The baseAuPrc.
     */
    @java.lang.Deprecated
    float getBaseAuPrc();

    /**
     *
     *
     * <pre>
     * Output only. The Area Under Receiver Operating Characteristic curve metric.
     * Micro-averaged for the overall evaluation.
     * </pre>
     *
     * <code>float au_roc = 6;</code>
     *
     * @return The auRoc.
     */
    float getAuRoc();

    /**
     *
     *
     * <pre>
     * Output only. The Log Loss metric.
     * </pre>
     *
     * <code>float log_loss = 7;</code>
     *
     * @return The logLoss.
     */
    float getLogLoss();

    /**
     *
     *
     * <pre>
     * Output only. Metrics for each confidence_threshold in
     * 0.00,0.05,0.10,...,0.95,0.96,0.97,0.98,0.99 and
     * position_threshold = INT32_MAX_VALUE.
     * ROC and precision-recall curves, and other aggregated metrics are derived
     * from them. The confidence metrics entries may also be supplied for
     * additional values of position_threshold, but from these no aggregated
     * metrics are computed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfidenceMetricsEntry confidence_metrics_entry = 3;
     * </code>
     */
    java.util.List<
            com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                .ConfidenceMetricsEntry>
        getConfidenceMetricsEntryList();
    /**
     *
     *
     * <pre>
     * Output only. Metrics for each confidence_threshold in
     * 0.00,0.05,0.10,...,0.95,0.96,0.97,0.98,0.99 and
     * position_threshold = INT32_MAX_VALUE.
     * ROC and precision-recall curves, and other aggregated metrics are derived
     * from them. The confidence metrics entries may also be supplied for
     * additional values of position_threshold, but from these no aggregated
     * metrics are computed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfidenceMetricsEntry confidence_metrics_entry = 3;
     * </code>
     */
    com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
            .ConfidenceMetricsEntry
        getConfidenceMetricsEntry(int index);
    /**
     *
     *
     * <pre>
     * Output only. Metrics for each confidence_threshold in
     * 0.00,0.05,0.10,...,0.95,0.96,0.97,0.98,0.99 and
     * position_threshold = INT32_MAX_VALUE.
     * ROC and precision-recall curves, and other aggregated metrics are derived
     * from them. The confidence metrics entries may also be supplied for
     * additional values of position_threshold, but from these no aggregated
     * metrics are computed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfidenceMetricsEntry confidence_metrics_entry = 3;
     * </code>
     */
    int getConfidenceMetricsEntryCount();
    /**
     *
     *
     * <pre>
     * Output only. Metrics for each confidence_threshold in
     * 0.00,0.05,0.10,...,0.95,0.96,0.97,0.98,0.99 and
     * position_threshold = INT32_MAX_VALUE.
     * ROC and precision-recall curves, and other aggregated metrics are derived
     * from them. The confidence metrics entries may also be supplied for
     * additional values of position_threshold, but from these no aggregated
     * metrics are computed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfidenceMetricsEntry confidence_metrics_entry = 3;
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                    .ConfidenceMetricsEntryOrBuilder>
        getConfidenceMetricsEntryOrBuilderList();
    /**
     *
     *
     * <pre>
     * Output only. Metrics for each confidence_threshold in
     * 0.00,0.05,0.10,...,0.95,0.96,0.97,0.98,0.99 and
     * position_threshold = INT32_MAX_VALUE.
     * ROC and precision-recall curves, and other aggregated metrics are derived
     * from them. The confidence metrics entries may also be supplied for
     * additional values of position_threshold, but from these no aggregated
     * metrics are computed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfidenceMetricsEntry confidence_metrics_entry = 3;
     * </code>
     */
    com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
            .ConfidenceMetricsEntryOrBuilder
        getConfidenceMetricsEntryOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * Output only. Confusion matrix of the evaluation.
     * Only set for MULTICLASS classification problems where number
     * of labels is no more than 10.
     * Only set for model level evaluation, not for evaluation per label.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix confusion_matrix = 4;
     * </code>
     *
     * @return Whether the confusionMatrix field is set.
     */
    boolean hasConfusionMatrix();
    /**
     *
     *
     * <pre>
     * Output only. Confusion matrix of the evaluation.
     * Only set for MULTICLASS classification problems where number
     * of labels is no more than 10.
     * Only set for model level evaluation, not for evaluation per label.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix confusion_matrix = 4;
     * </code>
     *
     * @return The confusionMatrix.
     */
    com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
            .ConfusionMatrix
        getConfusionMatrix();
    /**
     *
     *
     * <pre>
     * Output only. Confusion matrix of the evaluation.
     * Only set for MULTICLASS classification problems where number
     * of labels is no more than 10.
     * Only set for model level evaluation, not for evaluation per label.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix confusion_matrix = 4;
     * </code>
     */
    com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
            .ConfusionMatrixOrBuilder
        getConfusionMatrixOrBuilder();

    /**
     *
     *
     * <pre>
     * Output only. The annotation spec ids used for this evaluation.
     * </pre>
     *
     * <code>repeated string annotation_spec_id = 5;</code>
     *
     * @return A list containing the annotationSpecId.
     */
    java.util.List<java.lang.String> getAnnotationSpecIdList();
    /**
     *
     *
     * <pre>
     * Output only. The annotation spec ids used for this evaluation.
     * </pre>
     *
     * <code>repeated string annotation_spec_id = 5;</code>
     *
     * @return The count of annotationSpecId.
     */
    int getAnnotationSpecIdCount();
    /**
     *
     *
     * <pre>
     * Output only. The annotation spec ids used for this evaluation.
     * </pre>
     *
     * <code>repeated string annotation_spec_id = 5;</code>
     *
     * @param index The index of the element to return.
     * @return The annotationSpecId at the given index.
     */
    java.lang.String getAnnotationSpecId(int index);
    /**
     *
     *
     * <pre>
     * Output only. The annotation spec ids used for this evaluation.
     * </pre>
     *
     * <code>repeated string annotation_spec_id = 5;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the annotationSpecId at the given index.
     */
    com.google.protobuf.ByteString getAnnotationSpecIdBytes(int index);
  }
  /**
   *
   *
   * <pre>
   * Model evaluation metrics for classification problems.
   * Note: For Video Classification this metrics only describe quality of the
   * Video Classification predictions of "segment_classification" type.
   * </pre>
   *
   * Protobuf type {@code google.cloud.automl.v1beta1.ClassificationEvaluationMetrics}
   */
  public static final class ClassificationEvaluationMetrics
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.automl.v1beta1.ClassificationEvaluationMetrics)
      ClassificationEvaluationMetricsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ClassificationEvaluationMetrics.newBuilder() to construct.
    private ClassificationEvaluationMetrics(
        com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ClassificationEvaluationMetrics() {
      confidenceMetricsEntry_ = java.util.Collections.emptyList();
      annotationSpecId_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ClassificationEvaluationMetrics();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private ClassificationEvaluationMetrics(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 13:
              {
                auPrc_ = input.readFloat();
                break;
              }
            case 21:
              {
                baseAuPrc_ = input.readFloat();
                break;
              }
            case 26:
              {
                if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                  confidenceMetricsEntry_ =
                      new java.util.ArrayList<
                          com.google.cloud.automl.v1beta1.ClassificationProto
                              .ClassificationEvaluationMetrics.ConfidenceMetricsEntry>();
                  mutable_bitField0_ |= 0x00000001;
                }
                confidenceMetricsEntry_.add(
                    input.readMessage(
                        com.google.cloud.automl.v1beta1.ClassificationProto
                            .ClassificationEvaluationMetrics.ConfidenceMetricsEntry.parser(),
                        extensionRegistry));
                break;
              }
            case 34:
              {
                com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                        .ConfusionMatrix.Builder
                    subBuilder = null;
                if (confusionMatrix_ != null) {
                  subBuilder = confusionMatrix_.toBuilder();
                }
                confusionMatrix_ =
                    input.readMessage(
                        com.google.cloud.automl.v1beta1.ClassificationProto
                            .ClassificationEvaluationMetrics.ConfusionMatrix.parser(),
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(confusionMatrix_);
                  confusionMatrix_ = subBuilder.buildPartial();
                }

                break;
              }
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();
                if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                  annotationSpecId_ = new com.google.protobuf.LazyStringArrayList();
                  mutable_bitField0_ |= 0x00000002;
                }
                annotationSpecId_.add(s);
                break;
              }
            case 53:
              {
                auRoc_ = input.readFloat();
                break;
              }
            case 61:
              {
                logLoss_ = input.readFloat();
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) != 0)) {
          confidenceMetricsEntry_ = java.util.Collections.unmodifiableList(confidenceMetricsEntry_);
        }
        if (((mutable_bitField0_ & 0x00000002) != 0)) {
          annotationSpecId_ = annotationSpecId_.getUnmodifiableView();
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.automl.v1beta1.ClassificationProto
          .internal_static_google_cloud_automl_v1beta1_ClassificationEvaluationMetrics_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.automl.v1beta1.ClassificationProto
          .internal_static_google_cloud_automl_v1beta1_ClassificationEvaluationMetrics_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                  .class,
              com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                  .Builder.class);
    }

    public interface ConfidenceMetricsEntryOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfidenceMetricsEntry)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Output only. Metrics are computed with an assumption that the model
       * never returns predictions with score lower than this value.
       * </pre>
       *
       * <code>float confidence_threshold = 1;</code>
       *
       * @return The confidenceThreshold.
       */
      float getConfidenceThreshold();

      /**
       *
       *
       * <pre>
       * Output only. Metrics are computed with an assumption that the model
       * always returns at most this many predictions (ordered by their score,
       * descendingly), but they all still need to meet the confidence_threshold.
       * </pre>
       *
       * <code>int32 position_threshold = 14;</code>
       *
       * @return The positionThreshold.
       */
      int getPositionThreshold();

      /**
       *
       *
       * <pre>
       * Output only. Recall (True Positive Rate) for the given confidence
       * threshold.
       * </pre>
       *
       * <code>float recall = 2;</code>
       *
       * @return The recall.
       */
      float getRecall();

      /**
       *
       *
       * <pre>
       * Output only. Precision for the given confidence threshold.
       * </pre>
       *
       * <code>float precision = 3;</code>
       *
       * @return The precision.
       */
      float getPrecision();

      /**
       *
       *
       * <pre>
       * Output only. False Positive Rate for the given confidence threshold.
       * </pre>
       *
       * <code>float false_positive_rate = 8;</code>
       *
       * @return The falsePositiveRate.
       */
      float getFalsePositiveRate();

      /**
       *
       *
       * <pre>
       * Output only. The harmonic mean of recall and precision.
       * </pre>
       *
       * <code>float f1_score = 4;</code>
       *
       * @return The f1Score.
       */
      float getF1Score();

      /**
       *
       *
       * <pre>
       * Output only. The Recall (True Positive Rate) when only considering the
       * label that has the highest prediction score and not below the confidence
       * threshold for each example.
       * </pre>
       *
       * <code>float recall_at1 = 5;</code>
       *
       * @return The recallAt1.
       */
      float getRecallAt1();

      /**
       *
       *
       * <pre>
       * Output only. The precision when only considering the label that has the
       * highest prediction score and not below the confidence threshold for each
       * example.
       * </pre>
       *
       * <code>float precision_at1 = 6;</code>
       *
       * @return The precisionAt1.
       */
      float getPrecisionAt1();

      /**
       *
       *
       * <pre>
       * Output only. The False Positive Rate when only considering the label that
       * has the highest prediction score and not below the confidence threshold
       * for each example.
       * </pre>
       *
       * <code>float false_positive_rate_at1 = 9;</code>
       *
       * @return The falsePositiveRateAt1.
       */
      float getFalsePositiveRateAt1();

      /**
       *
       *
       * <pre>
       * Output only. The harmonic mean of
       * [recall_at1][google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfidenceMetricsEntry.recall_at1]
       * and
       * [precision_at1][google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfidenceMetricsEntry.precision_at1].
       * </pre>
       *
       * <code>float f1_score_at1 = 7;</code>
       *
       * @return The f1ScoreAt1.
       */
      float getF1ScoreAt1();

      /**
       *
       *
       * <pre>
       * Output only. The number of model created labels that match a ground truth
       * label.
       * </pre>
       *
       * <code>int64 true_positive_count = 10;</code>
       *
       * @return The truePositiveCount.
       */
      long getTruePositiveCount();

      /**
       *
       *
       * <pre>
       * Output only. The number of model created labels that do not match a
       * ground truth label.
       * </pre>
       *
       * <code>int64 false_positive_count = 11;</code>
       *
       * @return The falsePositiveCount.
       */
      long getFalsePositiveCount();

      /**
       *
       *
       * <pre>
       * Output only. The number of ground truth labels that are not matched
       * by a model created label.
       * </pre>
       *
       * <code>int64 false_negative_count = 12;</code>
       *
       * @return The falseNegativeCount.
       */
      long getFalseNegativeCount();

      /**
       *
       *
       * <pre>
       * Output only. The number of labels that were not created by the model,
       * but if they would, they would not match a ground truth label.
       * </pre>
       *
       * <code>int64 true_negative_count = 13;</code>
       *
       * @return The trueNegativeCount.
       */
      long getTrueNegativeCount();
    }
    /**
     *
     *
     * <pre>
     * Metrics for a single confidence threshold.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfidenceMetricsEntry}
     */
    public static final class ConfidenceMetricsEntry extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfidenceMetricsEntry)
        ConfidenceMetricsEntryOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use ConfidenceMetricsEntry.newBuilder() to construct.
      private ConfidenceMetricsEntry(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private ConfidenceMetricsEntry() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new ConfidenceMetricsEntry();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
      }

      private ConfidenceMetricsEntry(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 13:
                {
                  confidenceThreshold_ = input.readFloat();
                  break;
                }
              case 21:
                {
                  recall_ = input.readFloat();
                  break;
                }
              case 29:
                {
                  precision_ = input.readFloat();
                  break;
                }
              case 37:
                {
                  f1Score_ = input.readFloat();
                  break;
                }
              case 45:
                {
                  recallAt1_ = input.readFloat();
                  break;
                }
              case 53:
                {
                  precisionAt1_ = input.readFloat();
                  break;
                }
              case 61:
                {
                  f1ScoreAt1_ = input.readFloat();
                  break;
                }
              case 69:
                {
                  falsePositiveRate_ = input.readFloat();
                  break;
                }
              case 77:
                {
                  falsePositiveRateAt1_ = input.readFloat();
                  break;
                }
              case 80:
                {
                  truePositiveCount_ = input.readInt64();
                  break;
                }
              case 88:
                {
                  falsePositiveCount_ = input.readInt64();
                  break;
                }
              case 96:
                {
                  falseNegativeCount_ = input.readInt64();
                  break;
                }
              case 104:
                {
                  trueNegativeCount_ = input.readInt64();
                  break;
                }
              case 112:
                {
                  positionThreshold_ = input.readInt32();
                  break;
                }
              default:
                {
                  if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                    done = true;
                  }
                  break;
                }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(this);
        } finally {
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.automl.v1beta1.ClassificationProto
            .internal_static_google_cloud_automl_v1beta1_ClassificationEvaluationMetrics_ConfidenceMetricsEntry_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.automl.v1beta1.ClassificationProto
            .internal_static_google_cloud_automl_v1beta1_ClassificationEvaluationMetrics_ConfidenceMetricsEntry_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                    .ConfidenceMetricsEntry.class,
                com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                    .ConfidenceMetricsEntry.Builder.class);
      }

      public static final int CONFIDENCE_THRESHOLD_FIELD_NUMBER = 1;
      private float confidenceThreshold_;
      /**
       *
       *
       * <pre>
       * Output only. Metrics are computed with an assumption that the model
       * never returns predictions with score lower than this value.
       * </pre>
       *
       * <code>float confidence_threshold = 1;</code>
       *
       * @return The confidenceThreshold.
       */
      public float getConfidenceThreshold() {
        return confidenceThreshold_;
      }

      public static final int POSITION_THRESHOLD_FIELD_NUMBER = 14;
      private int positionThreshold_;
      /**
       *
       *
       * <pre>
       * Output only. Metrics are computed with an assumption that the model
       * always returns at most this many predictions (ordered by their score,
       * descendingly), but they all still need to meet the confidence_threshold.
       * </pre>
       *
       * <code>int32 position_threshold = 14;</code>
       *
       * @return The positionThreshold.
       */
      public int getPositionThreshold() {
        return positionThreshold_;
      }

      public static final int RECALL_FIELD_NUMBER = 2;
      private float recall_;
      /**
       *
       *
       * <pre>
       * Output only. Recall (True Positive Rate) for the given confidence
       * threshold.
       * </pre>
       *
       * <code>float recall = 2;</code>
       *
       * @return The recall.
       */
      public float getRecall() {
        return recall_;
      }

      public static final int PRECISION_FIELD_NUMBER = 3;
      private float precision_;
      /**
       *
       *
       * <pre>
       * Output only. Precision for the given confidence threshold.
       * </pre>
       *
       * <code>float precision = 3;</code>
       *
       * @return The precision.
       */
      public float getPrecision() {
        return precision_;
      }

      public static final int FALSE_POSITIVE_RATE_FIELD_NUMBER = 8;
      private float falsePositiveRate_;
      /**
       *
       *
       * <pre>
       * Output only. False Positive Rate for the given confidence threshold.
       * </pre>
       *
       * <code>float false_positive_rate = 8;</code>
       *
       * @return The falsePositiveRate.
       */
      public float getFalsePositiveRate() {
        return falsePositiveRate_;
      }

      public static final int F1_SCORE_FIELD_NUMBER = 4;
      private float f1Score_;
      /**
       *
       *
       * <pre>
       * Output only. The harmonic mean of recall and precision.
       * </pre>
       *
       * <code>float f1_score = 4;</code>
       *
       * @return The f1Score.
       */
      public float getF1Score() {
        return f1Score_;
      }

      public static final int RECALL_AT1_FIELD_NUMBER = 5;
      private float recallAt1_;
      /**
       *
       *
       * <pre>
       * Output only. The Recall (True Positive Rate) when only considering the
       * label that has the highest prediction score and not below the confidence
       * threshold for each example.
       * </pre>
       *
       * <code>float recall_at1 = 5;</code>
       *
       * @return The recallAt1.
       */
      public float getRecallAt1() {
        return recallAt1_;
      }

      public static final int PRECISION_AT1_FIELD_NUMBER = 6;
      private float precisionAt1_;
      /**
       *
       *
       * <pre>
       * Output only. The precision when only considering the label that has the
       * highest prediction score and not below the confidence threshold for each
       * example.
       * </pre>
       *
       * <code>float precision_at1 = 6;</code>
       *
       * @return The precisionAt1.
       */
      public float getPrecisionAt1() {
        return precisionAt1_;
      }

      public static final int FALSE_POSITIVE_RATE_AT1_FIELD_NUMBER = 9;
      private float falsePositiveRateAt1_;
      /**
       *
       *
       * <pre>
       * Output only. The False Positive Rate when only considering the label that
       * has the highest prediction score and not below the confidence threshold
       * for each example.
       * </pre>
       *
       * <code>float false_positive_rate_at1 = 9;</code>
       *
       * @return The falsePositiveRateAt1.
       */
      public float getFalsePositiveRateAt1() {
        return falsePositiveRateAt1_;
      }

      public static final int F1_SCORE_AT1_FIELD_NUMBER = 7;
      private float f1ScoreAt1_;
      /**
       *
       *
       * <pre>
       * Output only. The harmonic mean of
       * [recall_at1][google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfidenceMetricsEntry.recall_at1]
       * and
       * [precision_at1][google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfidenceMetricsEntry.precision_at1].
       * </pre>
       *
       * <code>float f1_score_at1 = 7;</code>
       *
       * @return The f1ScoreAt1.
       */
      public float getF1ScoreAt1() {
        return f1ScoreAt1_;
      }

      public static final int TRUE_POSITIVE_COUNT_FIELD_NUMBER = 10;
      private long truePositiveCount_;
      /**
       *
       *
       * <pre>
       * Output only. The number of model created labels that match a ground truth
       * label.
       * </pre>
       *
       * <code>int64 true_positive_count = 10;</code>
       *
       * @return The truePositiveCount.
       */
      public long getTruePositiveCount() {
        return truePositiveCount_;
      }

      public static final int FALSE_POSITIVE_COUNT_FIELD_NUMBER = 11;
      private long falsePositiveCount_;
      /**
       *
       *
       * <pre>
       * Output only. The number of model created labels that do not match a
       * ground truth label.
       * </pre>
       *
       * <code>int64 false_positive_count = 11;</code>
       *
       * @return The falsePositiveCount.
       */
      public long getFalsePositiveCount() {
        return falsePositiveCount_;
      }

      public static final int FALSE_NEGATIVE_COUNT_FIELD_NUMBER = 12;
      private long falseNegativeCount_;
      /**
       *
       *
       * <pre>
       * Output only. The number of ground truth labels that are not matched
       * by a model created label.
       * </pre>
       *
       * <code>int64 false_negative_count = 12;</code>
       *
       * @return The falseNegativeCount.
       */
      public long getFalseNegativeCount() {
        return falseNegativeCount_;
      }

      public static final int TRUE_NEGATIVE_COUNT_FIELD_NUMBER = 13;
      private long trueNegativeCount_;
      /**
       *
       *
       * <pre>
       * Output only. The number of labels that were not created by the model,
       * but if they would, they would not match a ground truth label.
       * </pre>
       *
       * <code>int64 true_negative_count = 13;</code>
       *
       * @return The trueNegativeCount.
       */
      public long getTrueNegativeCount() {
        return trueNegativeCount_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (confidenceThreshold_ != 0F) {
          output.writeFloat(1, confidenceThreshold_);
        }
        if (recall_ != 0F) {
          output.writeFloat(2, recall_);
        }
        if (precision_ != 0F) {
          output.writeFloat(3, precision_);
        }
        if (f1Score_ != 0F) {
          output.writeFloat(4, f1Score_);
        }
        if (recallAt1_ != 0F) {
          output.writeFloat(5, recallAt1_);
        }
        if (precisionAt1_ != 0F) {
          output.writeFloat(6, precisionAt1_);
        }
        if (f1ScoreAt1_ != 0F) {
          output.writeFloat(7, f1ScoreAt1_);
        }
        if (falsePositiveRate_ != 0F) {
          output.writeFloat(8, falsePositiveRate_);
        }
        if (falsePositiveRateAt1_ != 0F) {
          output.writeFloat(9, falsePositiveRateAt1_);
        }
        if (truePositiveCount_ != 0L) {
          output.writeInt64(10, truePositiveCount_);
        }
        if (falsePositiveCount_ != 0L) {
          output.writeInt64(11, falsePositiveCount_);
        }
        if (falseNegativeCount_ != 0L) {
          output.writeInt64(12, falseNegativeCount_);
        }
        if (trueNegativeCount_ != 0L) {
          output.writeInt64(13, trueNegativeCount_);
        }
        if (positionThreshold_ != 0) {
          output.writeInt32(14, positionThreshold_);
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (confidenceThreshold_ != 0F) {
          size += com.google.protobuf.CodedOutputStream.computeFloatSize(1, confidenceThreshold_);
        }
        if (recall_ != 0F) {
          size += com.google.protobuf.CodedOutputStream.computeFloatSize(2, recall_);
        }
        if (precision_ != 0F) {
          size += com.google.protobuf.CodedOutputStream.computeFloatSize(3, precision_);
        }
        if (f1Score_ != 0F) {
          size += com.google.protobuf.CodedOutputStream.computeFloatSize(4, f1Score_);
        }
        if (recallAt1_ != 0F) {
          size += com.google.protobuf.CodedOutputStream.computeFloatSize(5, recallAt1_);
        }
        if (precisionAt1_ != 0F) {
          size += com.google.protobuf.CodedOutputStream.computeFloatSize(6, precisionAt1_);
        }
        if (f1ScoreAt1_ != 0F) {
          size += com.google.protobuf.CodedOutputStream.computeFloatSize(7, f1ScoreAt1_);
        }
        if (falsePositiveRate_ != 0F) {
          size += com.google.protobuf.CodedOutputStream.computeFloatSize(8, falsePositiveRate_);
        }
        if (falsePositiveRateAt1_ != 0F) {
          size += com.google.protobuf.CodedOutputStream.computeFloatSize(9, falsePositiveRateAt1_);
        }
        if (truePositiveCount_ != 0L) {
          size += com.google.protobuf.CodedOutputStream.computeInt64Size(10, truePositiveCount_);
        }
        if (falsePositiveCount_ != 0L) {
          size += com.google.protobuf.CodedOutputStream.computeInt64Size(11, falsePositiveCount_);
        }
        if (falseNegativeCount_ != 0L) {
          size += com.google.protobuf.CodedOutputStream.computeInt64Size(12, falseNegativeCount_);
        }
        if (trueNegativeCount_ != 0L) {
          size += com.google.protobuf.CodedOutputStream.computeInt64Size(13, trueNegativeCount_);
        }
        if (positionThreshold_ != 0) {
          size += com.google.protobuf.CodedOutputStream.computeInt32Size(14, positionThreshold_);
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                .ConfidenceMetricsEntry)) {
          return super.equals(obj);
        }
        com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                .ConfidenceMetricsEntry
            other =
                (com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                        .ConfidenceMetricsEntry)
                    obj;

        if (java.lang.Float.floatToIntBits(getConfidenceThreshold())
            != java.lang.Float.floatToIntBits(other.getConfidenceThreshold())) return false;
        if (getPositionThreshold() != other.getPositionThreshold()) return false;
        if (java.lang.Float.floatToIntBits(getRecall())
            != java.lang.Float.floatToIntBits(other.getRecall())) return false;
        if (java.lang.Float.floatToIntBits(getPrecision())
            != java.lang.Float.floatToIntBits(other.getPrecision())) return false;
        if (java.lang.Float.floatToIntBits(getFalsePositiveRate())
            != java.lang.Float.floatToIntBits(other.getFalsePositiveRate())) return false;
        if (java.lang.Float.floatToIntBits(getF1Score())
            != java.lang.Float.floatToIntBits(other.getF1Score())) return false;
        if (java.lang.Float.floatToIntBits(getRecallAt1())
            != java.lang.Float.floatToIntBits(other.getRecallAt1())) return false;
        if (java.lang.Float.floatToIntBits(getPrecisionAt1())
            != java.lang.Float.floatToIntBits(other.getPrecisionAt1())) return false;
        if (java.lang.Float.floatToIntBits(getFalsePositiveRateAt1())
            != java.lang.Float.floatToIntBits(other.getFalsePositiveRateAt1())) return false;
        if (java.lang.Float.floatToIntBits(getF1ScoreAt1())
            != java.lang.Float.floatToIntBits(other.getF1ScoreAt1())) return false;
        if (getTruePositiveCount() != other.getTruePositiveCount()) return false;
        if (getFalsePositiveCount() != other.getFalsePositiveCount()) return false;
        if (getFalseNegativeCount() != other.getFalseNegativeCount()) return false;
        if (getTrueNegativeCount() != other.getTrueNegativeCount()) return false;
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + CONFIDENCE_THRESHOLD_FIELD_NUMBER;
        hash = (53 * hash) + java.lang.Float.floatToIntBits(getConfidenceThreshold());
        hash = (37 * hash) + POSITION_THRESHOLD_FIELD_NUMBER;
        hash = (53 * hash) + getPositionThreshold();
        hash = (37 * hash) + RECALL_FIELD_NUMBER;
        hash = (53 * hash) + java.lang.Float.floatToIntBits(getRecall());
        hash = (37 * hash) + PRECISION_FIELD_NUMBER;
        hash = (53 * hash) + java.lang.Float.floatToIntBits(getPrecision());
        hash = (37 * hash) + FALSE_POSITIVE_RATE_FIELD_NUMBER;
        hash = (53 * hash) + java.lang.Float.floatToIntBits(getFalsePositiveRate());
        hash = (37 * hash) + F1_SCORE_FIELD_NUMBER;
        hash = (53 * hash) + java.lang.Float.floatToIntBits(getF1Score());
        hash = (37 * hash) + RECALL_AT1_FIELD_NUMBER;
        hash = (53 * hash) + java.lang.Float.floatToIntBits(getRecallAt1());
        hash = (37 * hash) + PRECISION_AT1_FIELD_NUMBER;
        hash = (53 * hash) + java.lang.Float.floatToIntBits(getPrecisionAt1());
        hash = (37 * hash) + FALSE_POSITIVE_RATE_AT1_FIELD_NUMBER;
        hash = (53 * hash) + java.lang.Float.floatToIntBits(getFalsePositiveRateAt1());
        hash = (37 * hash) + F1_SCORE_AT1_FIELD_NUMBER;
        hash = (53 * hash) + java.lang.Float.floatToIntBits(getF1ScoreAt1());
        hash = (37 * hash) + TRUE_POSITIVE_COUNT_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getTruePositiveCount());
        hash = (37 * hash) + FALSE_POSITIVE_COUNT_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getFalsePositiveCount());
        hash = (37 * hash) + FALSE_NEGATIVE_COUNT_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getFalseNegativeCount());
        hash = (37 * hash) + TRUE_NEGATIVE_COUNT_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getTrueNegativeCount());
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.automl.v1beta1.ClassificationProto
              .ClassificationEvaluationMetrics.ConfidenceMetricsEntry
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.automl.v1beta1.ClassificationProto
              .ClassificationEvaluationMetrics.ConfidenceMetricsEntry
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.automl.v1beta1.ClassificationProto
              .ClassificationEvaluationMetrics.ConfidenceMetricsEntry
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.automl.v1beta1.ClassificationProto
              .ClassificationEvaluationMetrics.ConfidenceMetricsEntry
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.automl.v1beta1.ClassificationProto
              .ClassificationEvaluationMetrics.ConfidenceMetricsEntry
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.automl.v1beta1.ClassificationProto
              .ClassificationEvaluationMetrics.ConfidenceMetricsEntry
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.automl.v1beta1.ClassificationProto
              .ClassificationEvaluationMetrics.ConfidenceMetricsEntry
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.automl.v1beta1.ClassificationProto
              .ClassificationEvaluationMetrics.ConfidenceMetricsEntry
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.automl.v1beta1.ClassificationProto
              .ClassificationEvaluationMetrics.ConfidenceMetricsEntry
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.automl.v1beta1.ClassificationProto
              .ClassificationEvaluationMetrics.ConfidenceMetricsEntry
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.automl.v1beta1.ClassificationProto
              .ClassificationEvaluationMetrics.ConfidenceMetricsEntry
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.automl.v1beta1.ClassificationProto
              .ClassificationEvaluationMetrics.ConfidenceMetricsEntry
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                  .ConfidenceMetricsEntry
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Metrics for a single confidence threshold.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfidenceMetricsEntry}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfidenceMetricsEntry)
          com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
              .ConfidenceMetricsEntryOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.automl.v1beta1.ClassificationProto
              .internal_static_google_cloud_automl_v1beta1_ClassificationEvaluationMetrics_ConfidenceMetricsEntry_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.automl.v1beta1.ClassificationProto
              .internal_static_google_cloud_automl_v1beta1_ClassificationEvaluationMetrics_ConfidenceMetricsEntry_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.automl.v1beta1.ClassificationProto
                      .ClassificationEvaluationMetrics.ConfidenceMetricsEntry.class,
                  com.google.cloud.automl.v1beta1.ClassificationProto
                      .ClassificationEvaluationMetrics.ConfidenceMetricsEntry.Builder.class);
        }

        // Construct using
        // com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics.ConfidenceMetricsEntry.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          confidenceThreshold_ = 0F;

          positionThreshold_ = 0;

          recall_ = 0F;

          precision_ = 0F;

          falsePositiveRate_ = 0F;

          f1Score_ = 0F;

          recallAt1_ = 0F;

          precisionAt1_ = 0F;

          falsePositiveRateAt1_ = 0F;

          f1ScoreAt1_ = 0F;

          truePositiveCount_ = 0L;

          falsePositiveCount_ = 0L;

          falseNegativeCount_ = 0L;

          trueNegativeCount_ = 0L;

          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.automl.v1beta1.ClassificationProto
              .internal_static_google_cloud_automl_v1beta1_ClassificationEvaluationMetrics_ConfidenceMetricsEntry_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                .ConfidenceMetricsEntry
            getDefaultInstanceForType() {
          return com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
              .ConfidenceMetricsEntry.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                .ConfidenceMetricsEntry
            build() {
          com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                  .ConfidenceMetricsEntry
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                .ConfidenceMetricsEntry
            buildPartial() {
          com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                  .ConfidenceMetricsEntry
              result =
                  new com.google.cloud.automl.v1beta1.ClassificationProto
                      .ClassificationEvaluationMetrics.ConfidenceMetricsEntry(this);
          result.confidenceThreshold_ = confidenceThreshold_;
          result.positionThreshold_ = positionThreshold_;
          result.recall_ = recall_;
          result.precision_ = precision_;
          result.falsePositiveRate_ = falsePositiveRate_;
          result.f1Score_ = f1Score_;
          result.recallAt1_ = recallAt1_;
          result.precisionAt1_ = precisionAt1_;
          result.falsePositiveRateAt1_ = falsePositiveRateAt1_;
          result.f1ScoreAt1_ = f1ScoreAt1_;
          result.truePositiveCount_ = truePositiveCount_;
          result.falsePositiveCount_ = falsePositiveCount_;
          result.falseNegativeCount_ = falseNegativeCount_;
          result.trueNegativeCount_ = trueNegativeCount_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                  .ConfidenceMetricsEntry) {
            return mergeFrom(
                (com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                        .ConfidenceMetricsEntry)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                    .ConfidenceMetricsEntry
                other) {
          if (other
              == com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                  .ConfidenceMetricsEntry.getDefaultInstance()) return this;
          if (other.getConfidenceThreshold() != 0F) {
            setConfidenceThreshold(other.getConfidenceThreshold());
          }
          if (other.getPositionThreshold() != 0) {
            setPositionThreshold(other.getPositionThreshold());
          }
          if (other.getRecall() != 0F) {
            setRecall(other.getRecall());
          }
          if (other.getPrecision() != 0F) {
            setPrecision(other.getPrecision());
          }
          if (other.getFalsePositiveRate() != 0F) {
            setFalsePositiveRate(other.getFalsePositiveRate());
          }
          if (other.getF1Score() != 0F) {
            setF1Score(other.getF1Score());
          }
          if (other.getRecallAt1() != 0F) {
            setRecallAt1(other.getRecallAt1());
          }
          if (other.getPrecisionAt1() != 0F) {
            setPrecisionAt1(other.getPrecisionAt1());
          }
          if (other.getFalsePositiveRateAt1() != 0F) {
            setFalsePositiveRateAt1(other.getFalsePositiveRateAt1());
          }
          if (other.getF1ScoreAt1() != 0F) {
            setF1ScoreAt1(other.getF1ScoreAt1());
          }
          if (other.getTruePositiveCount() != 0L) {
            setTruePositiveCount(other.getTruePositiveCount());
          }
          if (other.getFalsePositiveCount() != 0L) {
            setFalsePositiveCount(other.getFalsePositiveCount());
          }
          if (other.getFalseNegativeCount() != 0L) {
            setFalseNegativeCount(other.getFalseNegativeCount());
          }
          if (other.getTrueNegativeCount() != 0L) {
            setTrueNegativeCount(other.getTrueNegativeCount());
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                  .ConfidenceMetricsEntry
              parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage =
                (com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                        .ConfidenceMetricsEntry)
                    e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }

        private float confidenceThreshold_;
        /**
         *
         *
         * <pre>
         * Output only. Metrics are computed with an assumption that the model
         * never returns predictions with score lower than this value.
         * </pre>
         *
         * <code>float confidence_threshold = 1;</code>
         *
         * @return The confidenceThreshold.
         */
        public float getConfidenceThreshold() {
          return confidenceThreshold_;
        }
        /**
         *
         *
         * <pre>
         * Output only. Metrics are computed with an assumption that the model
         * never returns predictions with score lower than this value.
         * </pre>
         *
         * <code>float confidence_threshold = 1;</code>
         *
         * @param value The confidenceThreshold to set.
         * @return This builder for chaining.
         */
        public Builder setConfidenceThreshold(float value) {

          confidenceThreshold_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Output only. Metrics are computed with an assumption that the model
         * never returns predictions with score lower than this value.
         * </pre>
         *
         * <code>float confidence_threshold = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearConfidenceThreshold() {

          confidenceThreshold_ = 0F;
          onChanged();
          return this;
        }

        private int positionThreshold_;
        /**
         *
         *
         * <pre>
         * Output only. Metrics are computed with an assumption that the model
         * always returns at most this many predictions (ordered by their score,
         * descendingly), but they all still need to meet the confidence_threshold.
         * </pre>
         *
         * <code>int32 position_threshold = 14;</code>
         *
         * @return The positionThreshold.
         */
        public int getPositionThreshold() {
          return positionThreshold_;
        }
        /**
         *
         *
         * <pre>
         * Output only. Metrics are computed with an assumption that the model
         * always returns at most this many predictions (ordered by their score,
         * descendingly), but they all still need to meet the confidence_threshold.
         * </pre>
         *
         * <code>int32 position_threshold = 14;</code>
         *
         * @param value The positionThreshold to set.
         * @return This builder for chaining.
         */
        public Builder setPositionThreshold(int value) {

          positionThreshold_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Output only. Metrics are computed with an assumption that the model
         * always returns at most this many predictions (ordered by their score,
         * descendingly), but they all still need to meet the confidence_threshold.
         * </pre>
         *
         * <code>int32 position_threshold = 14;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearPositionThreshold() {

          positionThreshold_ = 0;
          onChanged();
          return this;
        }

        private float recall_;
        /**
         *
         *
         * <pre>
         * Output only. Recall (True Positive Rate) for the given confidence
         * threshold.
         * </pre>
         *
         * <code>float recall = 2;</code>
         *
         * @return The recall.
         */
        public float getRecall() {
          return recall_;
        }
        /**
         *
         *
         * <pre>
         * Output only. Recall (True Positive Rate) for the given confidence
         * threshold.
         * </pre>
         *
         * <code>float recall = 2;</code>
         *
         * @param value The recall to set.
         * @return This builder for chaining.
         */
        public Builder setRecall(float value) {

          recall_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Output only. Recall (True Positive Rate) for the given confidence
         * threshold.
         * </pre>
         *
         * <code>float recall = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearRecall() {

          recall_ = 0F;
          onChanged();
          return this;
        }

        private float precision_;
        /**
         *
         *
         * <pre>
         * Output only. Precision for the given confidence threshold.
         * </pre>
         *
         * <code>float precision = 3;</code>
         *
         * @return The precision.
         */
        public float getPrecision() {
          return precision_;
        }
        /**
         *
         *
         * <pre>
         * Output only. Precision for the given confidence threshold.
         * </pre>
         *
         * <code>float precision = 3;</code>
         *
         * @param value The precision to set.
         * @return This builder for chaining.
         */
        public Builder setPrecision(float value) {

          precision_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Output only. Precision for the given confidence threshold.
         * </pre>
         *
         * <code>float precision = 3;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearPrecision() {

          precision_ = 0F;
          onChanged();
          return this;
        }

        private float falsePositiveRate_;
        /**
         *
         *
         * <pre>
         * Output only. False Positive Rate for the given confidence threshold.
         * </pre>
         *
         * <code>float false_positive_rate = 8;</code>
         *
         * @return The falsePositiveRate.
         */
        public float getFalsePositiveRate() {
          return falsePositiveRate_;
        }
        /**
         *
         *
         * <pre>
         * Output only. False Positive Rate for the given confidence threshold.
         * </pre>
         *
         * <code>float false_positive_rate = 8;</code>
         *
         * @param value The falsePositiveRate to set.
         * @return This builder for chaining.
         */
        public Builder setFalsePositiveRate(float value) {

          falsePositiveRate_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Output only. False Positive Rate for the given confidence threshold.
         * </pre>
         *
         * <code>float false_positive_rate = 8;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearFalsePositiveRate() {

          falsePositiveRate_ = 0F;
          onChanged();
          return this;
        }

        private float f1Score_;
        /**
         *
         *
         * <pre>
         * Output only. The harmonic mean of recall and precision.
         * </pre>
         *
         * <code>float f1_score = 4;</code>
         *
         * @return The f1Score.
         */
        public float getF1Score() {
          return f1Score_;
        }
        /**
         *
         *
         * <pre>
         * Output only. The harmonic mean of recall and precision.
         * </pre>
         *
         * <code>float f1_score = 4;</code>
         *
         * @param value The f1Score to set.
         * @return This builder for chaining.
         */
        public Builder setF1Score(float value) {

          f1Score_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Output only. The harmonic mean of recall and precision.
         * </pre>
         *
         * <code>float f1_score = 4;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearF1Score() {

          f1Score_ = 0F;
          onChanged();
          return this;
        }

        private float recallAt1_;
        /**
         *
         *
         * <pre>
         * Output only. The Recall (True Positive Rate) when only considering the
         * label that has the highest prediction score and not below the confidence
         * threshold for each example.
         * </pre>
         *
         * <code>float recall_at1 = 5;</code>
         *
         * @return The recallAt1.
         */
        public float getRecallAt1() {
          return recallAt1_;
        }
        /**
         *
         *
         * <pre>
         * Output only. The Recall (True Positive Rate) when only considering the
         * label that has the highest prediction score and not below the confidence
         * threshold for each example.
         * </pre>
         *
         * <code>float recall_at1 = 5;</code>
         *
         * @param value The recallAt1 to set.
         * @return This builder for chaining.
         */
        public Builder setRecallAt1(float value) {

          recallAt1_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Output only. The Recall (True Positive Rate) when only considering the
         * label that has the highest prediction score and not below the confidence
         * threshold for each example.
         * </pre>
         *
         * <code>float recall_at1 = 5;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearRecallAt1() {

          recallAt1_ = 0F;
          onChanged();
          return this;
        }

        private float precisionAt1_;
        /**
         *
         *
         * <pre>
         * Output only. The precision when only considering the label that has the
         * highest prediction score and not below the confidence threshold for each
         * example.
         * </pre>
         *
         * <code>float precision_at1 = 6;</code>
         *
         * @return The precisionAt1.
         */
        public float getPrecisionAt1() {
          return precisionAt1_;
        }
        /**
         *
         *
         * <pre>
         * Output only. The precision when only considering the label that has the
         * highest prediction score and not below the confidence threshold for each
         * example.
         * </pre>
         *
         * <code>float precision_at1 = 6;</code>
         *
         * @param value The precisionAt1 to set.
         * @return This builder for chaining.
         */
        public Builder setPrecisionAt1(float value) {

          precisionAt1_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Output only. The precision when only considering the label that has the
         * highest prediction score and not below the confidence threshold for each
         * example.
         * </pre>
         *
         * <code>float precision_at1 = 6;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearPrecisionAt1() {

          precisionAt1_ = 0F;
          onChanged();
          return this;
        }

        private float falsePositiveRateAt1_;
        /**
         *
         *
         * <pre>
         * Output only. The False Positive Rate when only considering the label that
         * has the highest prediction score and not below the confidence threshold
         * for each example.
         * </pre>
         *
         * <code>float false_positive_rate_at1 = 9;</code>
         *
         * @return The falsePositiveRateAt1.
         */
        public float getFalsePositiveRateAt1() {
          return falsePositiveRateAt1_;
        }
        /**
         *
         *
         * <pre>
         * Output only. The False Positive Rate when only considering the label that
         * has the highest prediction score and not below the confidence threshold
         * for each example.
         * </pre>
         *
         * <code>float false_positive_rate_at1 = 9;</code>
         *
         * @param value The falsePositiveRateAt1 to set.
         * @return This builder for chaining.
         */
        public Builder setFalsePositiveRateAt1(float value) {

          falsePositiveRateAt1_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Output only. The False Positive Rate when only considering the label that
         * has the highest prediction score and not below the confidence threshold
         * for each example.
         * </pre>
         *
         * <code>float false_positive_rate_at1 = 9;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearFalsePositiveRateAt1() {

          falsePositiveRateAt1_ = 0F;
          onChanged();
          return this;
        }

        private float f1ScoreAt1_;
        /**
         *
         *
         * <pre>
         * Output only. The harmonic mean of
         * [recall_at1][google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfidenceMetricsEntry.recall_at1]
         * and
         * [precision_at1][google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfidenceMetricsEntry.precision_at1].
         * </pre>
         *
         * <code>float f1_score_at1 = 7;</code>
         *
         * @return The f1ScoreAt1.
         */
        public float getF1ScoreAt1() {
          return f1ScoreAt1_;
        }
        /**
         *
         *
         * <pre>
         * Output only. The harmonic mean of
         * [recall_at1][google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfidenceMetricsEntry.recall_at1]
         * and
         * [precision_at1][google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfidenceMetricsEntry.precision_at1].
         * </pre>
         *
         * <code>float f1_score_at1 = 7;</code>
         *
         * @param value The f1ScoreAt1 to set.
         * @return This builder for chaining.
         */
        public Builder setF1ScoreAt1(float value) {

          f1ScoreAt1_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Output only. The harmonic mean of
         * [recall_at1][google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfidenceMetricsEntry.recall_at1]
         * and
         * [precision_at1][google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfidenceMetricsEntry.precision_at1].
         * </pre>
         *
         * <code>float f1_score_at1 = 7;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearF1ScoreAt1() {

          f1ScoreAt1_ = 0F;
          onChanged();
          return this;
        }

        private long truePositiveCount_;
        /**
         *
         *
         * <pre>
         * Output only. The number of model created labels that match a ground truth
         * label.
         * </pre>
         *
         * <code>int64 true_positive_count = 10;</code>
         *
         * @return The truePositiveCount.
         */
        public long getTruePositiveCount() {
          return truePositiveCount_;
        }
        /**
         *
         *
         * <pre>
         * Output only. The number of model created labels that match a ground truth
         * label.
         * </pre>
         *
         * <code>int64 true_positive_count = 10;</code>
         *
         * @param value The truePositiveCount to set.
         * @return This builder for chaining.
         */
        public Builder setTruePositiveCount(long value) {

          truePositiveCount_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Output only. The number of model created labels that match a ground truth
         * label.
         * </pre>
         *
         * <code>int64 true_positive_count = 10;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearTruePositiveCount() {

          truePositiveCount_ = 0L;
          onChanged();
          return this;
        }

        private long falsePositiveCount_;
        /**
         *
         *
         * <pre>
         * Output only. The number of model created labels that do not match a
         * ground truth label.
         * </pre>
         *
         * <code>int64 false_positive_count = 11;</code>
         *
         * @return The falsePositiveCount.
         */
        public long getFalsePositiveCount() {
          return falsePositiveCount_;
        }
        /**
         *
         *
         * <pre>
         * Output only. The number of model created labels that do not match a
         * ground truth label.
         * </pre>
         *
         * <code>int64 false_positive_count = 11;</code>
         *
         * @param value The falsePositiveCount to set.
         * @return This builder for chaining.
         */
        public Builder setFalsePositiveCount(long value) {

          falsePositiveCount_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Output only. The number of model created labels that do not match a
         * ground truth label.
         * </pre>
         *
         * <code>int64 false_positive_count = 11;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearFalsePositiveCount() {

          falsePositiveCount_ = 0L;
          onChanged();
          return this;
        }

        private long falseNegativeCount_;
        /**
         *
         *
         * <pre>
         * Output only. The number of ground truth labels that are not matched
         * by a model created label.
         * </pre>
         *
         * <code>int64 false_negative_count = 12;</code>
         *
         * @return The falseNegativeCount.
         */
        public long getFalseNegativeCount() {
          return falseNegativeCount_;
        }
        /**
         *
         *
         * <pre>
         * Output only. The number of ground truth labels that are not matched
         * by a model created label.
         * </pre>
         *
         * <code>int64 false_negative_count = 12;</code>
         *
         * @param value The falseNegativeCount to set.
         * @return This builder for chaining.
         */
        public Builder setFalseNegativeCount(long value) {

          falseNegativeCount_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Output only. The number of ground truth labels that are not matched
         * by a model created label.
         * </pre>
         *
         * <code>int64 false_negative_count = 12;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearFalseNegativeCount() {

          falseNegativeCount_ = 0L;
          onChanged();
          return this;
        }

        private long trueNegativeCount_;
        /**
         *
         *
         * <pre>
         * Output only. The number of labels that were not created by the model,
         * but if they would, they would not match a ground truth label.
         * </pre>
         *
         * <code>int64 true_negative_count = 13;</code>
         *
         * @return The trueNegativeCount.
         */
        public long getTrueNegativeCount() {
          return trueNegativeCount_;
        }
        /**
         *
         *
         * <pre>
         * Output only. The number of labels that were not created by the model,
         * but if they would, they would not match a ground truth label.
         * </pre>
         *
         * <code>int64 true_negative_count = 13;</code>
         *
         * @param value The trueNegativeCount to set.
         * @return This builder for chaining.
         */
        public Builder setTrueNegativeCount(long value) {

          trueNegativeCount_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Output only. The number of labels that were not created by the model,
         * but if they would, they would not match a ground truth label.
         * </pre>
         *
         * <code>int64 true_negative_count = 13;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearTrueNegativeCount() {

          trueNegativeCount_ = 0L;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfidenceMetricsEntry)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfidenceMetricsEntry)
      private static final com.google.cloud.automl.v1beta1.ClassificationProto
              .ClassificationEvaluationMetrics.ConfidenceMetricsEntry
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                .ConfidenceMetricsEntry();
      }

      public static com.google.cloud.automl.v1beta1.ClassificationProto
              .ClassificationEvaluationMetrics.ConfidenceMetricsEntry
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<ConfidenceMetricsEntry> PARSER =
          new com.google.protobuf.AbstractParser<ConfidenceMetricsEntry>() {
            @java.lang.Override
            public ConfidenceMetricsEntry parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              return new ConfidenceMetricsEntry(input, extensionRegistry);
            }
          };

      public static com.google.protobuf.Parser<ConfidenceMetricsEntry> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<ConfidenceMetricsEntry> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
              .ConfidenceMetricsEntry
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface ConfusionMatrixOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Output only. IDs of the annotation specs used in the confusion matrix.
       * For Tables CLASSIFICATION
       * [prediction_type][google.cloud.automl.v1beta1.TablesModelMetadata.prediction_type]
       * only list of [annotation_spec_display_name-s][] is populated.
       * </pre>
       *
       * <code>repeated string annotation_spec_id = 1;</code>
       *
       * @return A list containing the annotationSpecId.
       */
      java.util.List<java.lang.String> getAnnotationSpecIdList();
      /**
       *
       *
       * <pre>
       * Output only. IDs of the annotation specs used in the confusion matrix.
       * For Tables CLASSIFICATION
       * [prediction_type][google.cloud.automl.v1beta1.TablesModelMetadata.prediction_type]
       * only list of [annotation_spec_display_name-s][] is populated.
       * </pre>
       *
       * <code>repeated string annotation_spec_id = 1;</code>
       *
       * @return The count of annotationSpecId.
       */
      int getAnnotationSpecIdCount();
      /**
       *
       *
       * <pre>
       * Output only. IDs of the annotation specs used in the confusion matrix.
       * For Tables CLASSIFICATION
       * [prediction_type][google.cloud.automl.v1beta1.TablesModelMetadata.prediction_type]
       * only list of [annotation_spec_display_name-s][] is populated.
       * </pre>
       *
       * <code>repeated string annotation_spec_id = 1;</code>
       *
       * @param index The index of the element to return.
       * @return The annotationSpecId at the given index.
       */
      java.lang.String getAnnotationSpecId(int index);
      /**
       *
       *
       * <pre>
       * Output only. IDs of the annotation specs used in the confusion matrix.
       * For Tables CLASSIFICATION
       * [prediction_type][google.cloud.automl.v1beta1.TablesModelMetadata.prediction_type]
       * only list of [annotation_spec_display_name-s][] is populated.
       * </pre>
       *
       * <code>repeated string annotation_spec_id = 1;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the annotationSpecId at the given index.
       */
      com.google.protobuf.ByteString getAnnotationSpecIdBytes(int index);

      /**
       *
       *
       * <pre>
       * Output only. Display name of the annotation specs used in the confusion
       * matrix, as they were at the moment of the evaluation. For Tables
       * CLASSIFICATION
       * [prediction_type-s][google.cloud.automl.v1beta1.TablesModelMetadata.prediction_type],
       * distinct values of the target column at the moment of the model
       * evaluation are populated here.
       * </pre>
       *
       * <code>repeated string display_name = 3;</code>
       *
       * @return A list containing the displayName.
       */
      java.util.List<java.lang.String> getDisplayNameList();
      /**
       *
       *
       * <pre>
       * Output only. Display name of the annotation specs used in the confusion
       * matrix, as they were at the moment of the evaluation. For Tables
       * CLASSIFICATION
       * [prediction_type-s][google.cloud.automl.v1beta1.TablesModelMetadata.prediction_type],
       * distinct values of the target column at the moment of the model
       * evaluation are populated here.
       * </pre>
       *
       * <code>repeated string display_name = 3;</code>
       *
       * @return The count of displayName.
       */
      int getDisplayNameCount();
      /**
       *
       *
       * <pre>
       * Output only. Display name of the annotation specs used in the confusion
       * matrix, as they were at the moment of the evaluation. For Tables
       * CLASSIFICATION
       * [prediction_type-s][google.cloud.automl.v1beta1.TablesModelMetadata.prediction_type],
       * distinct values of the target column at the moment of the model
       * evaluation are populated here.
       * </pre>
       *
       * <code>repeated string display_name = 3;</code>
       *
       * @param index The index of the element to return.
       * @return The displayName at the given index.
       */
      java.lang.String getDisplayName(int index);
      /**
       *
       *
       * <pre>
       * Output only. Display name of the annotation specs used in the confusion
       * matrix, as they were at the moment of the evaluation. For Tables
       * CLASSIFICATION
       * [prediction_type-s][google.cloud.automl.v1beta1.TablesModelMetadata.prediction_type],
       * distinct values of the target column at the moment of the model
       * evaluation are populated here.
       * </pre>
       *
       * <code>repeated string display_name = 3;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the displayName at the given index.
       */
      com.google.protobuf.ByteString getDisplayNameBytes(int index);

      /**
       *
       *
       * <pre>
       * Output only. Rows in the confusion matrix. The number of rows is equal to
       * the size of `annotation_spec_id`.
       * `row[i].example_count[j]` is the number of examples that have ground
       * truth of the `annotation_spec_id[i]` and are predicted as
       * `annotation_spec_id[j]` by the model being evaluated.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix.Row row = 2;
       * </code>
       */
      java.util.List<
              com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                  .ConfusionMatrix.Row>
          getRowList();
      /**
       *
       *
       * <pre>
       * Output only. Rows in the confusion matrix. The number of rows is equal to
       * the size of `annotation_spec_id`.
       * `row[i].example_count[j]` is the number of examples that have ground
       * truth of the `annotation_spec_id[i]` and are predicted as
       * `annotation_spec_id[j]` by the model being evaluated.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix.Row row = 2;
       * </code>
       */
      com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
              .ConfusionMatrix.Row
          getRow(int index);
      /**
       *
       *
       * <pre>
       * Output only. Rows in the confusion matrix. The number of rows is equal to
       * the size of `annotation_spec_id`.
       * `row[i].example_count[j]` is the number of examples that have ground
       * truth of the `annotation_spec_id[i]` and are predicted as
       * `annotation_spec_id[j]` by the model being evaluated.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix.Row row = 2;
       * </code>
       */
      int getRowCount();
      /**
       *
       *
       * <pre>
       * Output only. Rows in the confusion matrix. The number of rows is equal to
       * the size of `annotation_spec_id`.
       * `row[i].example_count[j]` is the number of examples that have ground
       * truth of the `annotation_spec_id[i]` and are predicted as
       * `annotation_spec_id[j]` by the model being evaluated.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix.Row row = 2;
       * </code>
       */
      java.util.List<
              ? extends
                  com.google.cloud.automl.v1beta1.ClassificationProto
                      .ClassificationEvaluationMetrics.ConfusionMatrix.RowOrBuilder>
          getRowOrBuilderList();
      /**
       *
       *
       * <pre>
       * Output only. Rows in the confusion matrix. The number of rows is equal to
       * the size of `annotation_spec_id`.
       * `row[i].example_count[j]` is the number of examples that have ground
       * truth of the `annotation_spec_id[i]` and are predicted as
       * `annotation_spec_id[j]` by the model being evaluated.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix.Row row = 2;
       * </code>
       */
      com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
              .ConfusionMatrix.RowOrBuilder
          getRowOrBuilder(int index);
    }
    /**
     *
     *
     * <pre>
     * Confusion matrix of the model running the classification.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix}
     */
    public static final class ConfusionMatrix extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix)
        ConfusionMatrixOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use ConfusionMatrix.newBuilder() to construct.
      private ConfusionMatrix(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private ConfusionMatrix() {
        annotationSpecId_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        displayName_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        row_ = java.util.Collections.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new ConfusionMatrix();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
      }

      private ConfusionMatrix(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        int mutable_bitField0_ = 0;
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                    annotationSpecId_ = new com.google.protobuf.LazyStringArrayList();
                    mutable_bitField0_ |= 0x00000001;
                  }
                  annotationSpecId_.add(s);
                  break;
                }
              case 18:
                {
                  if (!((mutable_bitField0_ & 0x00000004) != 0)) {
                    row_ =
                        new java.util.ArrayList<
                            com.google.cloud.automl.v1beta1.ClassificationProto
                                .ClassificationEvaluationMetrics.ConfusionMatrix.Row>();
                    mutable_bitField0_ |= 0x00000004;
                  }
                  row_.add(
                      input.readMessage(
                          com.google.cloud.automl.v1beta1.ClassificationProto
                              .ClassificationEvaluationMetrics.ConfusionMatrix.Row.parser(),
                          extensionRegistry));
                  break;
                }
              case 26:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                    displayName_ = new com.google.protobuf.LazyStringArrayList();
                    mutable_bitField0_ |= 0x00000002;
                  }
                  displayName_.add(s);
                  break;
                }
              default:
                {
                  if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                    done = true;
                  }
                  break;
                }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(this);
        } finally {
          if (((mutable_bitField0_ & 0x00000001) != 0)) {
            annotationSpecId_ = annotationSpecId_.getUnmodifiableView();
          }
          if (((mutable_bitField0_ & 0x00000004) != 0)) {
            row_ = java.util.Collections.unmodifiableList(row_);
          }
          if (((mutable_bitField0_ & 0x00000002) != 0)) {
            displayName_ = displayName_.getUnmodifiableView();
          }
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.automl.v1beta1.ClassificationProto
            .internal_static_google_cloud_automl_v1beta1_ClassificationEvaluationMetrics_ConfusionMatrix_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.automl.v1beta1.ClassificationProto
            .internal_static_google_cloud_automl_v1beta1_ClassificationEvaluationMetrics_ConfusionMatrix_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                    .ConfusionMatrix.class,
                com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                    .ConfusionMatrix.Builder.class);
      }

      public interface RowOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix.Row)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Output only. Value of the specific cell in the confusion matrix.
         * The number of values each row has (i.e. the length of the row) is equal
         * to the length of the `annotation_spec_id` field or, if that one is not
         * populated, length of the
         * [display_name][google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix.display_name]
         * field.
         * </pre>
         *
         * <code>repeated int32 example_count = 1;</code>
         *
         * @return A list containing the exampleCount.
         */
        java.util.List<java.lang.Integer> getExampleCountList();
        /**
         *
         *
         * <pre>
         * Output only. Value of the specific cell in the confusion matrix.
         * The number of values each row has (i.e. the length of the row) is equal
         * to the length of the `annotation_spec_id` field or, if that one is not
         * populated, length of the
         * [display_name][google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix.display_name]
         * field.
         * </pre>
         *
         * <code>repeated int32 example_count = 1;</code>
         *
         * @return The count of exampleCount.
         */
        int getExampleCountCount();
        /**
         *
         *
         * <pre>
         * Output only. Value of the specific cell in the confusion matrix.
         * The number of values each row has (i.e. the length of the row) is equal
         * to the length of the `annotation_spec_id` field or, if that one is not
         * populated, length of the
         * [display_name][google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix.display_name]
         * field.
         * </pre>
         *
         * <code>repeated int32 example_count = 1;</code>
         *
         * @param index The index of the element to return.
         * @return The exampleCount at the given index.
         */
        int getExampleCount(int index);
      }
      /**
       *
       *
       * <pre>
       * Output only. A row in the confusion matrix.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix.Row}
       */
      public static final class Row extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix.Row)
          RowOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use Row.newBuilder() to construct.
        private Row(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private Row() {
          exampleCount_ = emptyIntList();
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new Row();
        }

        @java.lang.Override
        public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
          return this.unknownFields;
        }

        private Row(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          this();
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          int mutable_bitField0_ = 0;
          com.google.protobuf.UnknownFieldSet.Builder unknownFields =
              com.google.protobuf.UnknownFieldSet.newBuilder();
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8:
                  {
                    if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                      exampleCount_ = newIntList();
                      mutable_bitField0_ |= 0x00000001;
                    }
                    exampleCount_.addInt(input.readInt32());
                    break;
                  }
                case 10:
                  {
                    int length = input.readRawVarint32();
                    int limit = input.pushLimit(length);
                    if (!((mutable_bitField0_ & 0x00000001) != 0)
                        && input.getBytesUntilLimit() > 0) {
                      exampleCount_ = newIntList();
                      mutable_bitField0_ |= 0x00000001;
                    }
                    while (input.getBytesUntilLimit() > 0) {
                      exampleCount_.addInt(input.readInt32());
                    }
                    input.popLimit(limit);
                    break;
                  }
                default:
                  {
                    if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                      done = true;
                    }
                    break;
                  }
              }
            }
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(this);
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(this);
          } finally {
            if (((mutable_bitField0_ & 0x00000001) != 0)) {
              exampleCount_.makeImmutable(); // C
            }
            this.unknownFields = unknownFields.build();
            makeExtensionsImmutable();
          }
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.automl.v1beta1.ClassificationProto
              .internal_static_google_cloud_automl_v1beta1_ClassificationEvaluationMetrics_ConfusionMatrix_Row_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.automl.v1beta1.ClassificationProto
              .internal_static_google_cloud_automl_v1beta1_ClassificationEvaluationMetrics_ConfusionMatrix_Row_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.automl.v1beta1.ClassificationProto
                      .ClassificationEvaluationMetrics.ConfusionMatrix.Row.class,
                  com.google.cloud.automl.v1beta1.ClassificationProto
                      .ClassificationEvaluationMetrics.ConfusionMatrix.Row.Builder.class);
        }

        public static final int EXAMPLE_COUNT_FIELD_NUMBER = 1;
        private com.google.protobuf.Internal.IntList exampleCount_;
        /**
         *
         *
         * <pre>
         * Output only. Value of the specific cell in the confusion matrix.
         * The number of values each row has (i.e. the length of the row) is equal
         * to the length of the `annotation_spec_id` field or, if that one is not
         * populated, length of the
         * [display_name][google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix.display_name]
         * field.
         * </pre>
         *
         * <code>repeated int32 example_count = 1;</code>
         *
         * @return A list containing the exampleCount.
         */
        public java.util.List<java.lang.Integer> getExampleCountList() {
          return exampleCount_;
        }
        /**
         *
         *
         * <pre>
         * Output only. Value of the specific cell in the confusion matrix.
         * The number of values each row has (i.e. the length of the row) is equal
         * to the length of the `annotation_spec_id` field or, if that one is not
         * populated, length of the
         * [display_name][google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix.display_name]
         * field.
         * </pre>
         *
         * <code>repeated int32 example_count = 1;</code>
         *
         * @return The count of exampleCount.
         */
        public int getExampleCountCount() {
          return exampleCount_.size();
        }
        /**
         *
         *
         * <pre>
         * Output only. Value of the specific cell in the confusion matrix.
         * The number of values each row has (i.e. the length of the row) is equal
         * to the length of the `annotation_spec_id` field or, if that one is not
         * populated, length of the
         * [display_name][google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix.display_name]
         * field.
         * </pre>
         *
         * <code>repeated int32 example_count = 1;</code>
         *
         * @param index The index of the element to return.
         * @return The exampleCount at the given index.
         */
        public int getExampleCount(int index) {
          return exampleCount_.getInt(index);
        }

        private int exampleCountMemoizedSerializedSize = -1;

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          getSerializedSize();
          if (getExampleCountList().size() > 0) {
            output.writeUInt32NoTag(10);
            output.writeUInt32NoTag(exampleCountMemoizedSerializedSize);
          }
          for (int i = 0; i < exampleCount_.size(); i++) {
            output.writeInt32NoTag(exampleCount_.getInt(i));
          }
          unknownFields.writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          {
            int dataSize = 0;
            for (int i = 0; i < exampleCount_.size(); i++) {
              dataSize +=
                  com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(
                      exampleCount_.getInt(i));
            }
            size += dataSize;
            if (!getExampleCountList().isEmpty()) {
              size += 1;
              size += com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(dataSize);
            }
            exampleCountMemoizedSerializedSize = dataSize;
          }
          size += unknownFields.getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof
              com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                  .ConfusionMatrix.Row)) {
            return super.equals(obj);
          }
          com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                  .ConfusionMatrix.Row
              other =
                  (com.google.cloud.automl.v1beta1.ClassificationProto
                          .ClassificationEvaluationMetrics.ConfusionMatrix.Row)
                      obj;

          if (!getExampleCountList().equals(other.getExampleCountList())) return false;
          if (!unknownFields.equals(other.unknownFields)) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          if (getExampleCountCount() > 0) {
            hash = (37 * hash) + EXAMPLE_COUNT_FIELD_NUMBER;
            hash = (53 * hash) + getExampleCountList().hashCode();
          }
          hash = (29 * hash) + unknownFields.hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.automl.v1beta1.ClassificationProto
                .ClassificationEvaluationMetrics.ConfusionMatrix.Row
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.automl.v1beta1.ClassificationProto
                .ClassificationEvaluationMetrics.ConfusionMatrix.Row
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.automl.v1beta1.ClassificationProto
                .ClassificationEvaluationMetrics.ConfusionMatrix.Row
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.automl.v1beta1.ClassificationProto
                .ClassificationEvaluationMetrics.ConfusionMatrix.Row
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.automl.v1beta1.ClassificationProto
                .ClassificationEvaluationMetrics.ConfusionMatrix.Row
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.automl.v1beta1.ClassificationProto
                .ClassificationEvaluationMetrics.ConfusionMatrix.Row
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.automl.v1beta1.ClassificationProto
                .ClassificationEvaluationMetrics.ConfusionMatrix.Row
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.automl.v1beta1.ClassificationProto
                .ClassificationEvaluationMetrics.ConfusionMatrix.Row
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.automl.v1beta1.ClassificationProto
                .ClassificationEvaluationMetrics.ConfusionMatrix.Row
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.automl.v1beta1.ClassificationProto
                .ClassificationEvaluationMetrics.ConfusionMatrix.Row
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.automl.v1beta1.ClassificationProto
                .ClassificationEvaluationMetrics.ConfusionMatrix.Row
            parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.automl.v1beta1.ClassificationProto
                .ClassificationEvaluationMetrics.ConfusionMatrix.Row
            parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                    .ConfusionMatrix.Row
                prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * Output only. A row in the confusion matrix.
         * </pre>
         *
         * Protobuf type {@code
         * google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix.Row}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix.Row)
            com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                .ConfusionMatrix.RowOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.automl.v1beta1.ClassificationProto
                .internal_static_google_cloud_automl_v1beta1_ClassificationEvaluationMetrics_ConfusionMatrix_Row_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.automl.v1beta1.ClassificationProto
                .internal_static_google_cloud_automl_v1beta1_ClassificationEvaluationMetrics_ConfusionMatrix_Row_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.automl.v1beta1.ClassificationProto
                        .ClassificationEvaluationMetrics.ConfusionMatrix.Row.class,
                    com.google.cloud.automl.v1beta1.ClassificationProto
                        .ClassificationEvaluationMetrics.ConfusionMatrix.Row.Builder.class);
          }

          // Construct using
          // com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics.ConfusionMatrix.Row.newBuilder()
          private Builder() {
            maybeForceBuilderInitialization();
          }

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            maybeForceBuilderInitialization();
          }

          private void maybeForceBuilderInitialization() {
            if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            exampleCount_ = emptyIntList();
            bitField0_ = (bitField0_ & ~0x00000001);
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.automl.v1beta1.ClassificationProto
                .internal_static_google_cloud_automl_v1beta1_ClassificationEvaluationMetrics_ConfusionMatrix_Row_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                  .ConfusionMatrix.Row
              getDefaultInstanceForType() {
            return com.google.cloud.automl.v1beta1.ClassificationProto
                .ClassificationEvaluationMetrics.ConfusionMatrix.Row.getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                  .ConfusionMatrix.Row
              build() {
            com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                    .ConfusionMatrix.Row
                result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                  .ConfusionMatrix.Row
              buildPartial() {
            com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                    .ConfusionMatrix.Row
                result =
                    new com.google.cloud.automl.v1beta1.ClassificationProto
                        .ClassificationEvaluationMetrics.ConfusionMatrix.Row(this);
            int from_bitField0_ = bitField0_;
            if (((bitField0_ & 0x00000001) != 0)) {
              exampleCount_.makeImmutable();
              bitField0_ = (bitField0_ & ~0x00000001);
            }
            result.exampleCount_ = exampleCount_;
            onBuilt();
            return result;
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof
                com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                    .ConfusionMatrix.Row) {
              return mergeFrom(
                  (com.google.cloud.automl.v1beta1.ClassificationProto
                          .ClassificationEvaluationMetrics.ConfusionMatrix.Row)
                      other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                      .ConfusionMatrix.Row
                  other) {
            if (other
                == com.google.cloud.automl.v1beta1.ClassificationProto
                    .ClassificationEvaluationMetrics.ConfusionMatrix.Row.getDefaultInstance())
              return this;
            if (!other.exampleCount_.isEmpty()) {
              if (exampleCount_.isEmpty()) {
                exampleCount_ = other.exampleCount_;
                bitField0_ = (bitField0_ & ~0x00000001);
              } else {
                ensureExampleCountIsMutable();
                exampleCount_.addAll(other.exampleCount_);
              }
              onChanged();
            }
            this.mergeUnknownFields(other.unknownFields);
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                    .ConfusionMatrix.Row
                parsedMessage = null;
            try {
              parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              parsedMessage =
                  (com.google.cloud.automl.v1beta1.ClassificationProto
                          .ClassificationEvaluationMetrics.ConfusionMatrix.Row)
                      e.getUnfinishedMessage();
              throw e.unwrapIOException();
            } finally {
              if (parsedMessage != null) {
                mergeFrom(parsedMessage);
              }
            }
            return this;
          }

          private int bitField0_;

          private com.google.protobuf.Internal.IntList exampleCount_ = emptyIntList();

          private void ensureExampleCountIsMutable() {
            if (!((bitField0_ & 0x00000001) != 0)) {
              exampleCount_ = mutableCopy(exampleCount_);
              bitField0_ |= 0x00000001;
            }
          }
          /**
           *
           *
           * <pre>
           * Output only. Value of the specific cell in the confusion matrix.
           * The number of values each row has (i.e. the length of the row) is equal
           * to the length of the `annotation_spec_id` field or, if that one is not
           * populated, length of the
           * [display_name][google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix.display_name]
           * field.
           * </pre>
           *
           * <code>repeated int32 example_count = 1;</code>
           *
           * @return A list containing the exampleCount.
           */
          public java.util.List<java.lang.Integer> getExampleCountList() {
            return ((bitField0_ & 0x00000001) != 0)
                ? java.util.Collections.unmodifiableList(exampleCount_)
                : exampleCount_;
          }
          /**
           *
           *
           * <pre>
           * Output only. Value of the specific cell in the confusion matrix.
           * The number of values each row has (i.e. the length of the row) is equal
           * to the length of the `annotation_spec_id` field or, if that one is not
           * populated, length of the
           * [display_name][google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix.display_name]
           * field.
           * </pre>
           *
           * <code>repeated int32 example_count = 1;</code>
           *
           * @return The count of exampleCount.
           */
          public int getExampleCountCount() {
            return exampleCount_.size();
          }
          /**
           *
           *
           * <pre>
           * Output only. Value of the specific cell in the confusion matrix.
           * The number of values each row has (i.e. the length of the row) is equal
           * to the length of the `annotation_spec_id` field or, if that one is not
           * populated, length of the
           * [display_name][google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix.display_name]
           * field.
           * </pre>
           *
           * <code>repeated int32 example_count = 1;</code>
           *
           * @param index The index of the element to return.
           * @return The exampleCount at the given index.
           */
          public int getExampleCount(int index) {
            return exampleCount_.getInt(index);
          }
          /**
           *
           *
           * <pre>
           * Output only. Value of the specific cell in the confusion matrix.
           * The number of values each row has (i.e. the length of the row) is equal
           * to the length of the `annotation_spec_id` field or, if that one is not
           * populated, length of the
           * [display_name][google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix.display_name]
           * field.
           * </pre>
           *
           * <code>repeated int32 example_count = 1;</code>
           *
           * @param index The index to set the value at.
           * @param value The exampleCount to set.
           * @return This builder for chaining.
           */
          public Builder setExampleCount(int index, int value) {
            ensureExampleCountIsMutable();
            exampleCount_.setInt(index, value);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Output only. Value of the specific cell in the confusion matrix.
           * The number of values each row has (i.e. the length of the row) is equal
           * to the length of the `annotation_spec_id` field or, if that one is not
           * populated, length of the
           * [display_name][google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix.display_name]
           * field.
           * </pre>
           *
           * <code>repeated int32 example_count = 1;</code>
           *
           * @param value The exampleCount to add.
           * @return This builder for chaining.
           */
          public Builder addExampleCount(int value) {
            ensureExampleCountIsMutable();
            exampleCount_.addInt(value);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Output only. Value of the specific cell in the confusion matrix.
           * The number of values each row has (i.e. the length of the row) is equal
           * to the length of the `annotation_spec_id` field or, if that one is not
           * populated, length of the
           * [display_name][google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix.display_name]
           * field.
           * </pre>
           *
           * <code>repeated int32 example_count = 1;</code>
           *
           * @param values The exampleCount to add.
           * @return This builder for chaining.
           */
          public Builder addAllExampleCount(
              java.lang.Iterable<? extends java.lang.Integer> values) {
            ensureExampleCountIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, exampleCount_);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Output only. Value of the specific cell in the confusion matrix.
           * The number of values each row has (i.e. the length of the row) is equal
           * to the length of the `annotation_spec_id` field or, if that one is not
           * populated, length of the
           * [display_name][google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix.display_name]
           * field.
           * </pre>
           *
           * <code>repeated int32 example_count = 1;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearExampleCount() {
            exampleCount_ = emptyIntList();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix.Row)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix.Row)
        private static final com.google.cloud.automl.v1beta1.ClassificationProto
                .ClassificationEvaluationMetrics.ConfusionMatrix.Row
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.automl.v1beta1.ClassificationProto
                  .ClassificationEvaluationMetrics.ConfusionMatrix.Row();
        }

        public static com.google.cloud.automl.v1beta1.ClassificationProto
                .ClassificationEvaluationMetrics.ConfusionMatrix.Row
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<Row> PARSER =
            new com.google.protobuf.AbstractParser<Row>() {
              @java.lang.Override
              public Row parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                return new Row(input, extensionRegistry);
              }
            };

        public static com.google.protobuf.Parser<Row> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<Row> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                .ConfusionMatrix.Row
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public static final int ANNOTATION_SPEC_ID_FIELD_NUMBER = 1;
      private com.google.protobuf.LazyStringList annotationSpecId_;
      /**
       *
       *
       * <pre>
       * Output only. IDs of the annotation specs used in the confusion matrix.
       * For Tables CLASSIFICATION
       * [prediction_type][google.cloud.automl.v1beta1.TablesModelMetadata.prediction_type]
       * only list of [annotation_spec_display_name-s][] is populated.
       * </pre>
       *
       * <code>repeated string annotation_spec_id = 1;</code>
       *
       * @return A list containing the annotationSpecId.
       */
      public com.google.protobuf.ProtocolStringList getAnnotationSpecIdList() {
        return annotationSpecId_;
      }
      /**
       *
       *
       * <pre>
       * Output only. IDs of the annotation specs used in the confusion matrix.
       * For Tables CLASSIFICATION
       * [prediction_type][google.cloud.automl.v1beta1.TablesModelMetadata.prediction_type]
       * only list of [annotation_spec_display_name-s][] is populated.
       * </pre>
       *
       * <code>repeated string annotation_spec_id = 1;</code>
       *
       * @return The count of annotationSpecId.
       */
      public int getAnnotationSpecIdCount() {
        return annotationSpecId_.size();
      }
      /**
       *
       *
       * <pre>
       * Output only. IDs of the annotation specs used in the confusion matrix.
       * For Tables CLASSIFICATION
       * [prediction_type][google.cloud.automl.v1beta1.TablesModelMetadata.prediction_type]
       * only list of [annotation_spec_display_name-s][] is populated.
       * </pre>
       *
       * <code>repeated string annotation_spec_id = 1;</code>
       *
       * @param index The index of the element to return.
       * @return The annotationSpecId at the given index.
       */
      public java.lang.String getAnnotationSpecId(int index) {
        return annotationSpecId_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Output only. IDs of the annotation specs used in the confusion matrix.
       * For Tables CLASSIFICATION
       * [prediction_type][google.cloud.automl.v1beta1.TablesModelMetadata.prediction_type]
       * only list of [annotation_spec_display_name-s][] is populated.
       * </pre>
       *
       * <code>repeated string annotation_spec_id = 1;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the annotationSpecId at the given index.
       */
      public com.google.protobuf.ByteString getAnnotationSpecIdBytes(int index) {
        return annotationSpecId_.getByteString(index);
      }

      public static final int DISPLAY_NAME_FIELD_NUMBER = 3;
      private com.google.protobuf.LazyStringList displayName_;
      /**
       *
       *
       * <pre>
       * Output only. Display name of the annotation specs used in the confusion
       * matrix, as they were at the moment of the evaluation. For Tables
       * CLASSIFICATION
       * [prediction_type-s][google.cloud.automl.v1beta1.TablesModelMetadata.prediction_type],
       * distinct values of the target column at the moment of the model
       * evaluation are populated here.
       * </pre>
       *
       * <code>repeated string display_name = 3;</code>
       *
       * @return A list containing the displayName.
       */
      public com.google.protobuf.ProtocolStringList getDisplayNameList() {
        return displayName_;
      }
      /**
       *
       *
       * <pre>
       * Output only. Display name of the annotation specs used in the confusion
       * matrix, as they were at the moment of the evaluation. For Tables
       * CLASSIFICATION
       * [prediction_type-s][google.cloud.automl.v1beta1.TablesModelMetadata.prediction_type],
       * distinct values of the target column at the moment of the model
       * evaluation are populated here.
       * </pre>
       *
       * <code>repeated string display_name = 3;</code>
       *
       * @return The count of displayName.
       */
      public int getDisplayNameCount() {
        return displayName_.size();
      }
      /**
       *
       *
       * <pre>
       * Output only. Display name of the annotation specs used in the confusion
       * matrix, as they were at the moment of the evaluation. For Tables
       * CLASSIFICATION
       * [prediction_type-s][google.cloud.automl.v1beta1.TablesModelMetadata.prediction_type],
       * distinct values of the target column at the moment of the model
       * evaluation are populated here.
       * </pre>
       *
       * <code>repeated string display_name = 3;</code>
       *
       * @param index The index of the element to return.
       * @return The displayName at the given index.
       */
      public java.lang.String getDisplayName(int index) {
        return displayName_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Output only. Display name of the annotation specs used in the confusion
       * matrix, as they were at the moment of the evaluation. For Tables
       * CLASSIFICATION
       * [prediction_type-s][google.cloud.automl.v1beta1.TablesModelMetadata.prediction_type],
       * distinct values of the target column at the moment of the model
       * evaluation are populated here.
       * </pre>
       *
       * <code>repeated string display_name = 3;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the displayName at the given index.
       */
      public com.google.protobuf.ByteString getDisplayNameBytes(int index) {
        return displayName_.getByteString(index);
      }

      public static final int ROW_FIELD_NUMBER = 2;
      private java.util.List<
              com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                  .ConfusionMatrix.Row>
          row_;
      /**
       *
       *
       * <pre>
       * Output only. Rows in the confusion matrix. The number of rows is equal to
       * the size of `annotation_spec_id`.
       * `row[i].example_count[j]` is the number of examples that have ground
       * truth of the `annotation_spec_id[i]` and are predicted as
       * `annotation_spec_id[j]` by the model being evaluated.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix.Row row = 2;
       * </code>
       */
      public java.util.List<
              com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                  .ConfusionMatrix.Row>
          getRowList() {
        return row_;
      }
      /**
       *
       *
       * <pre>
       * Output only. Rows in the confusion matrix. The number of rows is equal to
       * the size of `annotation_spec_id`.
       * `row[i].example_count[j]` is the number of examples that have ground
       * truth of the `annotation_spec_id[i]` and are predicted as
       * `annotation_spec_id[j]` by the model being evaluated.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix.Row row = 2;
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.automl.v1beta1.ClassificationProto
                      .ClassificationEvaluationMetrics.ConfusionMatrix.RowOrBuilder>
          getRowOrBuilderList() {
        return row_;
      }
      /**
       *
       *
       * <pre>
       * Output only. Rows in the confusion matrix. The number of rows is equal to
       * the size of `annotation_spec_id`.
       * `row[i].example_count[j]` is the number of examples that have ground
       * truth of the `annotation_spec_id[i]` and are predicted as
       * `annotation_spec_id[j]` by the model being evaluated.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix.Row row = 2;
       * </code>
       */
      public int getRowCount() {
        return row_.size();
      }
      /**
       *
       *
       * <pre>
       * Output only. Rows in the confusion matrix. The number of rows is equal to
       * the size of `annotation_spec_id`.
       * `row[i].example_count[j]` is the number of examples that have ground
       * truth of the `annotation_spec_id[i]` and are predicted as
       * `annotation_spec_id[j]` by the model being evaluated.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix.Row row = 2;
       * </code>
       */
      public com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
              .ConfusionMatrix.Row
          getRow(int index) {
        return row_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Output only. Rows in the confusion matrix. The number of rows is equal to
       * the size of `annotation_spec_id`.
       * `row[i].example_count[j]` is the number of examples that have ground
       * truth of the `annotation_spec_id[i]` and are predicted as
       * `annotation_spec_id[j]` by the model being evaluated.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix.Row row = 2;
       * </code>
       */
      public com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
              .ConfusionMatrix.RowOrBuilder
          getRowOrBuilder(int index) {
        return row_.get(index);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        for (int i = 0; i < annotationSpecId_.size(); i++) {
          com.google.protobuf.GeneratedMessageV3.writeString(
              output, 1, annotationSpecId_.getRaw(i));
        }
        for (int i = 0; i < row_.size(); i++) {
          output.writeMessage(2, row_.get(i));
        }
        for (int i = 0; i < displayName_.size(); i++) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 3, displayName_.getRaw(i));
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        {
          int dataSize = 0;
          for (int i = 0; i < annotationSpecId_.size(); i++) {
            dataSize += computeStringSizeNoTag(annotationSpecId_.getRaw(i));
          }
          size += dataSize;
          size += 1 * getAnnotationSpecIdList().size();
        }
        for (int i = 0; i < row_.size(); i++) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, row_.get(i));
        }
        {
          int dataSize = 0;
          for (int i = 0; i < displayName_.size(); i++) {
            dataSize += computeStringSizeNoTag(displayName_.getRaw(i));
          }
          size += dataSize;
          size += 1 * getDisplayNameList().size();
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                .ConfusionMatrix)) {
          return super.equals(obj);
        }
        com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                .ConfusionMatrix
            other =
                (com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                        .ConfusionMatrix)
                    obj;

        if (!getAnnotationSpecIdList().equals(other.getAnnotationSpecIdList())) return false;
        if (!getDisplayNameList().equals(other.getDisplayNameList())) return false;
        if (!getRowList().equals(other.getRowList())) return false;
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (getAnnotationSpecIdCount() > 0) {
          hash = (37 * hash) + ANNOTATION_SPEC_ID_FIELD_NUMBER;
          hash = (53 * hash) + getAnnotationSpecIdList().hashCode();
        }
        if (getDisplayNameCount() > 0) {
          hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
          hash = (53 * hash) + getDisplayNameList().hashCode();
        }
        if (getRowCount() > 0) {
          hash = (37 * hash) + ROW_FIELD_NUMBER;
          hash = (53 * hash) + getRowList().hashCode();
        }
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.automl.v1beta1.ClassificationProto
              .ClassificationEvaluationMetrics.ConfusionMatrix
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.automl.v1beta1.ClassificationProto
              .ClassificationEvaluationMetrics.ConfusionMatrix
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.automl.v1beta1.ClassificationProto
              .ClassificationEvaluationMetrics.ConfusionMatrix
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.automl.v1beta1.ClassificationProto
              .ClassificationEvaluationMetrics.ConfusionMatrix
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.automl.v1beta1.ClassificationProto
              .ClassificationEvaluationMetrics.ConfusionMatrix
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.automl.v1beta1.ClassificationProto
              .ClassificationEvaluationMetrics.ConfusionMatrix
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.automl.v1beta1.ClassificationProto
              .ClassificationEvaluationMetrics.ConfusionMatrix
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.automl.v1beta1.ClassificationProto
              .ClassificationEvaluationMetrics.ConfusionMatrix
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.automl.v1beta1.ClassificationProto
              .ClassificationEvaluationMetrics.ConfusionMatrix
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.automl.v1beta1.ClassificationProto
              .ClassificationEvaluationMetrics.ConfusionMatrix
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.automl.v1beta1.ClassificationProto
              .ClassificationEvaluationMetrics.ConfusionMatrix
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.automl.v1beta1.ClassificationProto
              .ClassificationEvaluationMetrics.ConfusionMatrix
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                  .ConfusionMatrix
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Confusion matrix of the model running the classification.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix)
          com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
              .ConfusionMatrixOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.automl.v1beta1.ClassificationProto
              .internal_static_google_cloud_automl_v1beta1_ClassificationEvaluationMetrics_ConfusionMatrix_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.automl.v1beta1.ClassificationProto
              .internal_static_google_cloud_automl_v1beta1_ClassificationEvaluationMetrics_ConfusionMatrix_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.automl.v1beta1.ClassificationProto
                      .ClassificationEvaluationMetrics.ConfusionMatrix.class,
                  com.google.cloud.automl.v1beta1.ClassificationProto
                      .ClassificationEvaluationMetrics.ConfusionMatrix.Builder.class);
        }

        // Construct using
        // com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics.ConfusionMatrix.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getRowFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          annotationSpecId_ = com.google.protobuf.LazyStringArrayList.EMPTY;
          bitField0_ = (bitField0_ & ~0x00000001);
          displayName_ = com.google.protobuf.LazyStringArrayList.EMPTY;
          bitField0_ = (bitField0_ & ~0x00000002);
          if (rowBuilder_ == null) {
            row_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            rowBuilder_.clear();
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.automl.v1beta1.ClassificationProto
              .internal_static_google_cloud_automl_v1beta1_ClassificationEvaluationMetrics_ConfusionMatrix_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                .ConfusionMatrix
            getDefaultInstanceForType() {
          return com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
              .ConfusionMatrix.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                .ConfusionMatrix
            build() {
          com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                  .ConfusionMatrix
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                .ConfusionMatrix
            buildPartial() {
          com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                  .ConfusionMatrix
              result =
                  new com.google.cloud.automl.v1beta1.ClassificationProto
                      .ClassificationEvaluationMetrics.ConfusionMatrix(this);
          int from_bitField0_ = bitField0_;
          if (((bitField0_ & 0x00000001) != 0)) {
            annotationSpecId_ = annotationSpecId_.getUnmodifiableView();
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.annotationSpecId_ = annotationSpecId_;
          if (((bitField0_ & 0x00000002) != 0)) {
            displayName_ = displayName_.getUnmodifiableView();
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.displayName_ = displayName_;
          if (rowBuilder_ == null) {
            if (((bitField0_ & 0x00000004) != 0)) {
              row_ = java.util.Collections.unmodifiableList(row_);
              bitField0_ = (bitField0_ & ~0x00000004);
            }
            result.row_ = row_;
          } else {
            result.row_ = rowBuilder_.build();
          }
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                  .ConfusionMatrix) {
            return mergeFrom(
                (com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                        .ConfusionMatrix)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                    .ConfusionMatrix
                other) {
          if (other
              == com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                  .ConfusionMatrix.getDefaultInstance()) return this;
          if (!other.annotationSpecId_.isEmpty()) {
            if (annotationSpecId_.isEmpty()) {
              annotationSpecId_ = other.annotationSpecId_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureAnnotationSpecIdIsMutable();
              annotationSpecId_.addAll(other.annotationSpecId_);
            }
            onChanged();
          }
          if (!other.displayName_.isEmpty()) {
            if (displayName_.isEmpty()) {
              displayName_ = other.displayName_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureDisplayNameIsMutable();
              displayName_.addAll(other.displayName_);
            }
            onChanged();
          }
          if (rowBuilder_ == null) {
            if (!other.row_.isEmpty()) {
              if (row_.isEmpty()) {
                row_ = other.row_;
                bitField0_ = (bitField0_ & ~0x00000004);
              } else {
                ensureRowIsMutable();
                row_.addAll(other.row_);
              }
              onChanged();
            }
          } else {
            if (!other.row_.isEmpty()) {
              if (rowBuilder_.isEmpty()) {
                rowBuilder_.dispose();
                rowBuilder_ = null;
                row_ = other.row_;
                bitField0_ = (bitField0_ & ~0x00000004);
                rowBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getRowFieldBuilder()
                        : null;
              } else {
                rowBuilder_.addAllMessages(other.row_);
              }
            }
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                  .ConfusionMatrix
              parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage =
                (com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                        .ConfusionMatrix)
                    e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }

        private int bitField0_;

        private com.google.protobuf.LazyStringList annotationSpecId_ =
            com.google.protobuf.LazyStringArrayList.EMPTY;

        private void ensureAnnotationSpecIdIsMutable() {
          if (!((bitField0_ & 0x00000001) != 0)) {
            annotationSpecId_ = new com.google.protobuf.LazyStringArrayList(annotationSpecId_);
            bitField0_ |= 0x00000001;
          }
        }
        /**
         *
         *
         * <pre>
         * Output only. IDs of the annotation specs used in the confusion matrix.
         * For Tables CLASSIFICATION
         * [prediction_type][google.cloud.automl.v1beta1.TablesModelMetadata.prediction_type]
         * only list of [annotation_spec_display_name-s][] is populated.
         * </pre>
         *
         * <code>repeated string annotation_spec_id = 1;</code>
         *
         * @return A list containing the annotationSpecId.
         */
        public com.google.protobuf.ProtocolStringList getAnnotationSpecIdList() {
          return annotationSpecId_.getUnmodifiableView();
        }
        /**
         *
         *
         * <pre>
         * Output only. IDs of the annotation specs used in the confusion matrix.
         * For Tables CLASSIFICATION
         * [prediction_type][google.cloud.automl.v1beta1.TablesModelMetadata.prediction_type]
         * only list of [annotation_spec_display_name-s][] is populated.
         * </pre>
         *
         * <code>repeated string annotation_spec_id = 1;</code>
         *
         * @return The count of annotationSpecId.
         */
        public int getAnnotationSpecIdCount() {
          return annotationSpecId_.size();
        }
        /**
         *
         *
         * <pre>
         * Output only. IDs of the annotation specs used in the confusion matrix.
         * For Tables CLASSIFICATION
         * [prediction_type][google.cloud.automl.v1beta1.TablesModelMetadata.prediction_type]
         * only list of [annotation_spec_display_name-s][] is populated.
         * </pre>
         *
         * <code>repeated string annotation_spec_id = 1;</code>
         *
         * @param index The index of the element to return.
         * @return The annotationSpecId at the given index.
         */
        public java.lang.String getAnnotationSpecId(int index) {
          return annotationSpecId_.get(index);
        }
        /**
         *
         *
         * <pre>
         * Output only. IDs of the annotation specs used in the confusion matrix.
         * For Tables CLASSIFICATION
         * [prediction_type][google.cloud.automl.v1beta1.TablesModelMetadata.prediction_type]
         * only list of [annotation_spec_display_name-s][] is populated.
         * </pre>
         *
         * <code>repeated string annotation_spec_id = 1;</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the annotationSpecId at the given index.
         */
        public com.google.protobuf.ByteString getAnnotationSpecIdBytes(int index) {
          return annotationSpecId_.getByteString(index);
        }
        /**
         *
         *
         * <pre>
         * Output only. IDs of the annotation specs used in the confusion matrix.
         * For Tables CLASSIFICATION
         * [prediction_type][google.cloud.automl.v1beta1.TablesModelMetadata.prediction_type]
         * only list of [annotation_spec_display_name-s][] is populated.
         * </pre>
         *
         * <code>repeated string annotation_spec_id = 1;</code>
         *
         * @param index The index to set the value at.
         * @param value The annotationSpecId to set.
         * @return This builder for chaining.
         */
        public Builder setAnnotationSpecId(int index, java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureAnnotationSpecIdIsMutable();
          annotationSpecId_.set(index, value);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Output only. IDs of the annotation specs used in the confusion matrix.
         * For Tables CLASSIFICATION
         * [prediction_type][google.cloud.automl.v1beta1.TablesModelMetadata.prediction_type]
         * only list of [annotation_spec_display_name-s][] is populated.
         * </pre>
         *
         * <code>repeated string annotation_spec_id = 1;</code>
         *
         * @param value The annotationSpecId to add.
         * @return This builder for chaining.
         */
        public Builder addAnnotationSpecId(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureAnnotationSpecIdIsMutable();
          annotationSpecId_.add(value);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Output only. IDs of the annotation specs used in the confusion matrix.
         * For Tables CLASSIFICATION
         * [prediction_type][google.cloud.automl.v1beta1.TablesModelMetadata.prediction_type]
         * only list of [annotation_spec_display_name-s][] is populated.
         * </pre>
         *
         * <code>repeated string annotation_spec_id = 1;</code>
         *
         * @param values The annotationSpecId to add.
         * @return This builder for chaining.
         */
        public Builder addAllAnnotationSpecId(java.lang.Iterable<java.lang.String> values) {
          ensureAnnotationSpecIdIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, annotationSpecId_);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Output only. IDs of the annotation specs used in the confusion matrix.
         * For Tables CLASSIFICATION
         * [prediction_type][google.cloud.automl.v1beta1.TablesModelMetadata.prediction_type]
         * only list of [annotation_spec_display_name-s][] is populated.
         * </pre>
         *
         * <code>repeated string annotation_spec_id = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearAnnotationSpecId() {
          annotationSpecId_ = com.google.protobuf.LazyStringArrayList.EMPTY;
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Output only. IDs of the annotation specs used in the confusion matrix.
         * For Tables CLASSIFICATION
         * [prediction_type][google.cloud.automl.v1beta1.TablesModelMetadata.prediction_type]
         * only list of [annotation_spec_display_name-s][] is populated.
         * </pre>
         *
         * <code>repeated string annotation_spec_id = 1;</code>
         *
         * @param value The bytes of the annotationSpecId to add.
         * @return This builder for chaining.
         */
        public Builder addAnnotationSpecIdBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          ensureAnnotationSpecIdIsMutable();
          annotationSpecId_.add(value);
          onChanged();
          return this;
        }

        private com.google.protobuf.LazyStringList displayName_ =
            com.google.protobuf.LazyStringArrayList.EMPTY;

        private void ensureDisplayNameIsMutable() {
          if (!((bitField0_ & 0x00000002) != 0)) {
            displayName_ = new com.google.protobuf.LazyStringArrayList(displayName_);
            bitField0_ |= 0x00000002;
          }
        }
        /**
         *
         *
         * <pre>
         * Output only. Display name of the annotation specs used in the confusion
         * matrix, as they were at the moment of the evaluation. For Tables
         * CLASSIFICATION
         * [prediction_type-s][google.cloud.automl.v1beta1.TablesModelMetadata.prediction_type],
         * distinct values of the target column at the moment of the model
         * evaluation are populated here.
         * </pre>
         *
         * <code>repeated string display_name = 3;</code>
         *
         * @return A list containing the displayName.
         */
        public com.google.protobuf.ProtocolStringList getDisplayNameList() {
          return displayName_.getUnmodifiableView();
        }
        /**
         *
         *
         * <pre>
         * Output only. Display name of the annotation specs used in the confusion
         * matrix, as they were at the moment of the evaluation. For Tables
         * CLASSIFICATION
         * [prediction_type-s][google.cloud.automl.v1beta1.TablesModelMetadata.prediction_type],
         * distinct values of the target column at the moment of the model
         * evaluation are populated here.
         * </pre>
         *
         * <code>repeated string display_name = 3;</code>
         *
         * @return The count of displayName.
         */
        public int getDisplayNameCount() {
          return displayName_.size();
        }
        /**
         *
         *
         * <pre>
         * Output only. Display name of the annotation specs used in the confusion
         * matrix, as they were at the moment of the evaluation. For Tables
         * CLASSIFICATION
         * [prediction_type-s][google.cloud.automl.v1beta1.TablesModelMetadata.prediction_type],
         * distinct values of the target column at the moment of the model
         * evaluation are populated here.
         * </pre>
         *
         * <code>repeated string display_name = 3;</code>
         *
         * @param index The index of the element to return.
         * @return The displayName at the given index.
         */
        public java.lang.String getDisplayName(int index) {
          return displayName_.get(index);
        }
        /**
         *
         *
         * <pre>
         * Output only. Display name of the annotation specs used in the confusion
         * matrix, as they were at the moment of the evaluation. For Tables
         * CLASSIFICATION
         * [prediction_type-s][google.cloud.automl.v1beta1.TablesModelMetadata.prediction_type],
         * distinct values of the target column at the moment of the model
         * evaluation are populated here.
         * </pre>
         *
         * <code>repeated string display_name = 3;</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the displayName at the given index.
         */
        public com.google.protobuf.ByteString getDisplayNameBytes(int index) {
          return displayName_.getByteString(index);
        }
        /**
         *
         *
         * <pre>
         * Output only. Display name of the annotation specs used in the confusion
         * matrix, as they were at the moment of the evaluation. For Tables
         * CLASSIFICATION
         * [prediction_type-s][google.cloud.automl.v1beta1.TablesModelMetadata.prediction_type],
         * distinct values of the target column at the moment of the model
         * evaluation are populated here.
         * </pre>
         *
         * <code>repeated string display_name = 3;</code>
         *
         * @param index The index to set the value at.
         * @param value The displayName to set.
         * @return This builder for chaining.
         */
        public Builder setDisplayName(int index, java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDisplayNameIsMutable();
          displayName_.set(index, value);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Output only. Display name of the annotation specs used in the confusion
         * matrix, as they were at the moment of the evaluation. For Tables
         * CLASSIFICATION
         * [prediction_type-s][google.cloud.automl.v1beta1.TablesModelMetadata.prediction_type],
         * distinct values of the target column at the moment of the model
         * evaluation are populated here.
         * </pre>
         *
         * <code>repeated string display_name = 3;</code>
         *
         * @param value The displayName to add.
         * @return This builder for chaining.
         */
        public Builder addDisplayName(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDisplayNameIsMutable();
          displayName_.add(value);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Output only. Display name of the annotation specs used in the confusion
         * matrix, as they were at the moment of the evaluation. For Tables
         * CLASSIFICATION
         * [prediction_type-s][google.cloud.automl.v1beta1.TablesModelMetadata.prediction_type],
         * distinct values of the target column at the moment of the model
         * evaluation are populated here.
         * </pre>
         *
         * <code>repeated string display_name = 3;</code>
         *
         * @param values The displayName to add.
         * @return This builder for chaining.
         */
        public Builder addAllDisplayName(java.lang.Iterable<java.lang.String> values) {
          ensureDisplayNameIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, displayName_);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Output only. Display name of the annotation specs used in the confusion
         * matrix, as they were at the moment of the evaluation. For Tables
         * CLASSIFICATION
         * [prediction_type-s][google.cloud.automl.v1beta1.TablesModelMetadata.prediction_type],
         * distinct values of the target column at the moment of the model
         * evaluation are populated here.
         * </pre>
         *
         * <code>repeated string display_name = 3;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearDisplayName() {
          displayName_ = com.google.protobuf.LazyStringArrayList.EMPTY;
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Output only. Display name of the annotation specs used in the confusion
         * matrix, as they were at the moment of the evaluation. For Tables
         * CLASSIFICATION
         * [prediction_type-s][google.cloud.automl.v1beta1.TablesModelMetadata.prediction_type],
         * distinct values of the target column at the moment of the model
         * evaluation are populated here.
         * </pre>
         *
         * <code>repeated string display_name = 3;</code>
         *
         * @param value The bytes of the displayName to add.
         * @return This builder for chaining.
         */
        public Builder addDisplayNameBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          ensureDisplayNameIsMutable();
          displayName_.add(value);
          onChanged();
          return this;
        }

        private java.util.List<
                com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                    .ConfusionMatrix.Row>
            row_ = java.util.Collections.emptyList();

        private void ensureRowIsMutable() {
          if (!((bitField0_ & 0x00000004) != 0)) {
            row_ =
                new java.util.ArrayList<
                    com.google.cloud.automl.v1beta1.ClassificationProto
                        .ClassificationEvaluationMetrics.ConfusionMatrix.Row>(row_);
            bitField0_ |= 0x00000004;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                    .ConfusionMatrix.Row,
                com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                    .ConfusionMatrix.Row.Builder,
                com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                    .ConfusionMatrix.RowOrBuilder>
            rowBuilder_;

        /**
         *
         *
         * <pre>
         * Output only. Rows in the confusion matrix. The number of rows is equal to
         * the size of `annotation_spec_id`.
         * `row[i].example_count[j]` is the number of examples that have ground
         * truth of the `annotation_spec_id[i]` and are predicted as
         * `annotation_spec_id[j]` by the model being evaluated.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix.Row row = 2;
         * </code>
         */
        public java.util.List<
                com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                    .ConfusionMatrix.Row>
            getRowList() {
          if (rowBuilder_ == null) {
            return java.util.Collections.unmodifiableList(row_);
          } else {
            return rowBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * Output only. Rows in the confusion matrix. The number of rows is equal to
         * the size of `annotation_spec_id`.
         * `row[i].example_count[j]` is the number of examples that have ground
         * truth of the `annotation_spec_id[i]` and are predicted as
         * `annotation_spec_id[j]` by the model being evaluated.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix.Row row = 2;
         * </code>
         */
        public int getRowCount() {
          if (rowBuilder_ == null) {
            return row_.size();
          } else {
            return rowBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * Output only. Rows in the confusion matrix. The number of rows is equal to
         * the size of `annotation_spec_id`.
         * `row[i].example_count[j]` is the number of examples that have ground
         * truth of the `annotation_spec_id[i]` and are predicted as
         * `annotation_spec_id[j]` by the model being evaluated.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix.Row row = 2;
         * </code>
         */
        public com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                .ConfusionMatrix.Row
            getRow(int index) {
          if (rowBuilder_ == null) {
            return row_.get(index);
          } else {
            return rowBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Output only. Rows in the confusion matrix. The number of rows is equal to
         * the size of `annotation_spec_id`.
         * `row[i].example_count[j]` is the number of examples that have ground
         * truth of the `annotation_spec_id[i]` and are predicted as
         * `annotation_spec_id[j]` by the model being evaluated.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix.Row row = 2;
         * </code>
         */
        public Builder setRow(
            int index,
            com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                    .ConfusionMatrix.Row
                value) {
          if (rowBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureRowIsMutable();
            row_.set(index, value);
            onChanged();
          } else {
            rowBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Output only. Rows in the confusion matrix. The number of rows is equal to
         * the size of `annotation_spec_id`.
         * `row[i].example_count[j]` is the number of examples that have ground
         * truth of the `annotation_spec_id[i]` and are predicted as
         * `annotation_spec_id[j]` by the model being evaluated.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix.Row row = 2;
         * </code>
         */
        public Builder setRow(
            int index,
            com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                    .ConfusionMatrix.Row.Builder
                builderForValue) {
          if (rowBuilder_ == null) {
            ensureRowIsMutable();
            row_.set(index, builderForValue.build());
            onChanged();
          } else {
            rowBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Output only. Rows in the confusion matrix. The number of rows is equal to
         * the size of `annotation_spec_id`.
         * `row[i].example_count[j]` is the number of examples that have ground
         * truth of the `annotation_spec_id[i]` and are predicted as
         * `annotation_spec_id[j]` by the model being evaluated.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix.Row row = 2;
         * </code>
         */
        public Builder addRow(
            com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                    .ConfusionMatrix.Row
                value) {
          if (rowBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureRowIsMutable();
            row_.add(value);
            onChanged();
          } else {
            rowBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Output only. Rows in the confusion matrix. The number of rows is equal to
         * the size of `annotation_spec_id`.
         * `row[i].example_count[j]` is the number of examples that have ground
         * truth of the `annotation_spec_id[i]` and are predicted as
         * `annotation_spec_id[j]` by the model being evaluated.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix.Row row = 2;
         * </code>
         */
        public Builder addRow(
            int index,
            com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                    .ConfusionMatrix.Row
                value) {
          if (rowBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureRowIsMutable();
            row_.add(index, value);
            onChanged();
          } else {
            rowBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Output only. Rows in the confusion matrix. The number of rows is equal to
         * the size of `annotation_spec_id`.
         * `row[i].example_count[j]` is the number of examples that have ground
         * truth of the `annotation_spec_id[i]` and are predicted as
         * `annotation_spec_id[j]` by the model being evaluated.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix.Row row = 2;
         * </code>
         */
        public Builder addRow(
            com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                    .ConfusionMatrix.Row.Builder
                builderForValue) {
          if (rowBuilder_ == null) {
            ensureRowIsMutable();
            row_.add(builderForValue.build());
            onChanged();
          } else {
            rowBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Output only. Rows in the confusion matrix. The number of rows is equal to
         * the size of `annotation_spec_id`.
         * `row[i].example_count[j]` is the number of examples that have ground
         * truth of the `annotation_spec_id[i]` and are predicted as
         * `annotation_spec_id[j]` by the model being evaluated.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix.Row row = 2;
         * </code>
         */
        public Builder addRow(
            int index,
            com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                    .ConfusionMatrix.Row.Builder
                builderForValue) {
          if (rowBuilder_ == null) {
            ensureRowIsMutable();
            row_.add(index, builderForValue.build());
            onChanged();
          } else {
            rowBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Output only. Rows in the confusion matrix. The number of rows is equal to
         * the size of `annotation_spec_id`.
         * `row[i].example_count[j]` is the number of examples that have ground
         * truth of the `annotation_spec_id[i]` and are predicted as
         * `annotation_spec_id[j]` by the model being evaluated.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix.Row row = 2;
         * </code>
         */
        public Builder addAllRow(
            java.lang.Iterable<
                    ? extends
                        com.google.cloud.automl.v1beta1.ClassificationProto
                            .ClassificationEvaluationMetrics.ConfusionMatrix.Row>
                values) {
          if (rowBuilder_ == null) {
            ensureRowIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, row_);
            onChanged();
          } else {
            rowBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Output only. Rows in the confusion matrix. The number of rows is equal to
         * the size of `annotation_spec_id`.
         * `row[i].example_count[j]` is the number of examples that have ground
         * truth of the `annotation_spec_id[i]` and are predicted as
         * `annotation_spec_id[j]` by the model being evaluated.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix.Row row = 2;
         * </code>
         */
        public Builder clearRow() {
          if (rowBuilder_ == null) {
            row_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000004);
            onChanged();
          } else {
            rowBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Output only. Rows in the confusion matrix. The number of rows is equal to
         * the size of `annotation_spec_id`.
         * `row[i].example_count[j]` is the number of examples that have ground
         * truth of the `annotation_spec_id[i]` and are predicted as
         * `annotation_spec_id[j]` by the model being evaluated.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix.Row row = 2;
         * </code>
         */
        public Builder removeRow(int index) {
          if (rowBuilder_ == null) {
            ensureRowIsMutable();
            row_.remove(index);
            onChanged();
          } else {
            rowBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Output only. Rows in the confusion matrix. The number of rows is equal to
         * the size of `annotation_spec_id`.
         * `row[i].example_count[j]` is the number of examples that have ground
         * truth of the `annotation_spec_id[i]` and are predicted as
         * `annotation_spec_id[j]` by the model being evaluated.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix.Row row = 2;
         * </code>
         */
        public com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                .ConfusionMatrix.Row.Builder
            getRowBuilder(int index) {
          return getRowFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * Output only. Rows in the confusion matrix. The number of rows is equal to
         * the size of `annotation_spec_id`.
         * `row[i].example_count[j]` is the number of examples that have ground
         * truth of the `annotation_spec_id[i]` and are predicted as
         * `annotation_spec_id[j]` by the model being evaluated.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix.Row row = 2;
         * </code>
         */
        public com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                .ConfusionMatrix.RowOrBuilder
            getRowOrBuilder(int index) {
          if (rowBuilder_ == null) {
            return row_.get(index);
          } else {
            return rowBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Output only. Rows in the confusion matrix. The number of rows is equal to
         * the size of `annotation_spec_id`.
         * `row[i].example_count[j]` is the number of examples that have ground
         * truth of the `annotation_spec_id[i]` and are predicted as
         * `annotation_spec_id[j]` by the model being evaluated.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix.Row row = 2;
         * </code>
         */
        public java.util.List<
                ? extends
                    com.google.cloud.automl.v1beta1.ClassificationProto
                        .ClassificationEvaluationMetrics.ConfusionMatrix.RowOrBuilder>
            getRowOrBuilderList() {
          if (rowBuilder_ != null) {
            return rowBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(row_);
          }
        }
        /**
         *
         *
         * <pre>
         * Output only. Rows in the confusion matrix. The number of rows is equal to
         * the size of `annotation_spec_id`.
         * `row[i].example_count[j]` is the number of examples that have ground
         * truth of the `annotation_spec_id[i]` and are predicted as
         * `annotation_spec_id[j]` by the model being evaluated.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix.Row row = 2;
         * </code>
         */
        public com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                .ConfusionMatrix.Row.Builder
            addRowBuilder() {
          return getRowFieldBuilder()
              .addBuilder(
                  com.google.cloud.automl.v1beta1.ClassificationProto
                      .ClassificationEvaluationMetrics.ConfusionMatrix.Row.getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Output only. Rows in the confusion matrix. The number of rows is equal to
         * the size of `annotation_spec_id`.
         * `row[i].example_count[j]` is the number of examples that have ground
         * truth of the `annotation_spec_id[i]` and are predicted as
         * `annotation_spec_id[j]` by the model being evaluated.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix.Row row = 2;
         * </code>
         */
        public com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                .ConfusionMatrix.Row.Builder
            addRowBuilder(int index) {
          return getRowFieldBuilder()
              .addBuilder(
                  index,
                  com.google.cloud.automl.v1beta1.ClassificationProto
                      .ClassificationEvaluationMetrics.ConfusionMatrix.Row.getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Output only. Rows in the confusion matrix. The number of rows is equal to
         * the size of `annotation_spec_id`.
         * `row[i].example_count[j]` is the number of examples that have ground
         * truth of the `annotation_spec_id[i]` and are predicted as
         * `annotation_spec_id[j]` by the model being evaluated.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix.Row row = 2;
         * </code>
         */
        public java.util.List<
                com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                    .ConfusionMatrix.Row.Builder>
            getRowBuilderList() {
          return getRowFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                    .ConfusionMatrix.Row,
                com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                    .ConfusionMatrix.Row.Builder,
                com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                    .ConfusionMatrix.RowOrBuilder>
            getRowFieldBuilder() {
          if (rowBuilder_ == null) {
            rowBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.automl.v1beta1.ClassificationProto
                        .ClassificationEvaluationMetrics.ConfusionMatrix.Row,
                    com.google.cloud.automl.v1beta1.ClassificationProto
                        .ClassificationEvaluationMetrics.ConfusionMatrix.Row.Builder,
                    com.google.cloud.automl.v1beta1.ClassificationProto
                        .ClassificationEvaluationMetrics.ConfusionMatrix.RowOrBuilder>(
                    row_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
            row_ = null;
          }
          return rowBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix)
      private static final com.google.cloud.automl.v1beta1.ClassificationProto
              .ClassificationEvaluationMetrics.ConfusionMatrix
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                .ConfusionMatrix();
      }

      public static com.google.cloud.automl.v1beta1.ClassificationProto
              .ClassificationEvaluationMetrics.ConfusionMatrix
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<ConfusionMatrix> PARSER =
          new com.google.protobuf.AbstractParser<ConfusionMatrix>() {
            @java.lang.Override
            public ConfusionMatrix parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              return new ConfusionMatrix(input, extensionRegistry);
            }
          };

      public static com.google.protobuf.Parser<ConfusionMatrix> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<ConfusionMatrix> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
              .ConfusionMatrix
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int AU_PRC_FIELD_NUMBER = 1;
    private float auPrc_;
    /**
     *
     *
     * <pre>
     * Output only. The Area Under Precision-Recall Curve metric. Micro-averaged
     * for the overall evaluation.
     * </pre>
     *
     * <code>float au_prc = 1;</code>
     *
     * @return The auPrc.
     */
    public float getAuPrc() {
      return auPrc_;
    }

    public static final int BASE_AU_PRC_FIELD_NUMBER = 2;
    private float baseAuPrc_;
    /**
     *
     *
     * <pre>
     * Output only. The Area Under Precision-Recall Curve metric based on priors.
     * Micro-averaged for the overall evaluation.
     * Deprecated.
     * </pre>
     *
     * <code>float base_au_prc = 2 [deprecated = true];</code>
     *
     * @return The baseAuPrc.
     */
    @java.lang.Deprecated
    public float getBaseAuPrc() {
      return baseAuPrc_;
    }

    public static final int AU_ROC_FIELD_NUMBER = 6;
    private float auRoc_;
    /**
     *
     *
     * <pre>
     * Output only. The Area Under Receiver Operating Characteristic curve metric.
     * Micro-averaged for the overall evaluation.
     * </pre>
     *
     * <code>float au_roc = 6;</code>
     *
     * @return The auRoc.
     */
    public float getAuRoc() {
      return auRoc_;
    }

    public static final int LOG_LOSS_FIELD_NUMBER = 7;
    private float logLoss_;
    /**
     *
     *
     * <pre>
     * Output only. The Log Loss metric.
     * </pre>
     *
     * <code>float log_loss = 7;</code>
     *
     * @return The logLoss.
     */
    public float getLogLoss() {
      return logLoss_;
    }

    public static final int CONFIDENCE_METRICS_ENTRY_FIELD_NUMBER = 3;
    private java.util.List<
            com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                .ConfidenceMetricsEntry>
        confidenceMetricsEntry_;
    /**
     *
     *
     * <pre>
     * Output only. Metrics for each confidence_threshold in
     * 0.00,0.05,0.10,...,0.95,0.96,0.97,0.98,0.99 and
     * position_threshold = INT32_MAX_VALUE.
     * ROC and precision-recall curves, and other aggregated metrics are derived
     * from them. The confidence metrics entries may also be supplied for
     * additional values of position_threshold, but from these no aggregated
     * metrics are computed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfidenceMetricsEntry confidence_metrics_entry = 3;
     * </code>
     */
    public java.util.List<
            com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                .ConfidenceMetricsEntry>
        getConfidenceMetricsEntryList() {
      return confidenceMetricsEntry_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Metrics for each confidence_threshold in
     * 0.00,0.05,0.10,...,0.95,0.96,0.97,0.98,0.99 and
     * position_threshold = INT32_MAX_VALUE.
     * ROC and precision-recall curves, and other aggregated metrics are derived
     * from them. The confidence metrics entries may also be supplied for
     * additional values of position_threshold, but from these no aggregated
     * metrics are computed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfidenceMetricsEntry confidence_metrics_entry = 3;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                    .ConfidenceMetricsEntryOrBuilder>
        getConfidenceMetricsEntryOrBuilderList() {
      return confidenceMetricsEntry_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Metrics for each confidence_threshold in
     * 0.00,0.05,0.10,...,0.95,0.96,0.97,0.98,0.99 and
     * position_threshold = INT32_MAX_VALUE.
     * ROC and precision-recall curves, and other aggregated metrics are derived
     * from them. The confidence metrics entries may also be supplied for
     * additional values of position_threshold, but from these no aggregated
     * metrics are computed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfidenceMetricsEntry confidence_metrics_entry = 3;
     * </code>
     */
    public int getConfidenceMetricsEntryCount() {
      return confidenceMetricsEntry_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. Metrics for each confidence_threshold in
     * 0.00,0.05,0.10,...,0.95,0.96,0.97,0.98,0.99 and
     * position_threshold = INT32_MAX_VALUE.
     * ROC and precision-recall curves, and other aggregated metrics are derived
     * from them. The confidence metrics entries may also be supplied for
     * additional values of position_threshold, but from these no aggregated
     * metrics are computed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfidenceMetricsEntry confidence_metrics_entry = 3;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
            .ConfidenceMetricsEntry
        getConfidenceMetricsEntry(int index) {
      return confidenceMetricsEntry_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Metrics for each confidence_threshold in
     * 0.00,0.05,0.10,...,0.95,0.96,0.97,0.98,0.99 and
     * position_threshold = INT32_MAX_VALUE.
     * ROC and precision-recall curves, and other aggregated metrics are derived
     * from them. The confidence metrics entries may also be supplied for
     * additional values of position_threshold, but from these no aggregated
     * metrics are computed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfidenceMetricsEntry confidence_metrics_entry = 3;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
            .ConfidenceMetricsEntryOrBuilder
        getConfidenceMetricsEntryOrBuilder(int index) {
      return confidenceMetricsEntry_.get(index);
    }

    public static final int CONFUSION_MATRIX_FIELD_NUMBER = 4;
    private com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
            .ConfusionMatrix
        confusionMatrix_;
    /**
     *
     *
     * <pre>
     * Output only. Confusion matrix of the evaluation.
     * Only set for MULTICLASS classification problems where number
     * of labels is no more than 10.
     * Only set for model level evaluation, not for evaluation per label.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix confusion_matrix = 4;
     * </code>
     *
     * @return Whether the confusionMatrix field is set.
     */
    public boolean hasConfusionMatrix() {
      return confusionMatrix_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Confusion matrix of the evaluation.
     * Only set for MULTICLASS classification problems where number
     * of labels is no more than 10.
     * Only set for model level evaluation, not for evaluation per label.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix confusion_matrix = 4;
     * </code>
     *
     * @return The confusionMatrix.
     */
    public com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
            .ConfusionMatrix
        getConfusionMatrix() {
      return confusionMatrix_ == null
          ? com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
              .ConfusionMatrix.getDefaultInstance()
          : confusionMatrix_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Confusion matrix of the evaluation.
     * Only set for MULTICLASS classification problems where number
     * of labels is no more than 10.
     * Only set for model level evaluation, not for evaluation per label.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix confusion_matrix = 4;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
            .ConfusionMatrixOrBuilder
        getConfusionMatrixOrBuilder() {
      return getConfusionMatrix();
    }

    public static final int ANNOTATION_SPEC_ID_FIELD_NUMBER = 5;
    private com.google.protobuf.LazyStringList annotationSpecId_;
    /**
     *
     *
     * <pre>
     * Output only. The annotation spec ids used for this evaluation.
     * </pre>
     *
     * <code>repeated string annotation_spec_id = 5;</code>
     *
     * @return A list containing the annotationSpecId.
     */
    public com.google.protobuf.ProtocolStringList getAnnotationSpecIdList() {
      return annotationSpecId_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The annotation spec ids used for this evaluation.
     * </pre>
     *
     * <code>repeated string annotation_spec_id = 5;</code>
     *
     * @return The count of annotationSpecId.
     */
    public int getAnnotationSpecIdCount() {
      return annotationSpecId_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. The annotation spec ids used for this evaluation.
     * </pre>
     *
     * <code>repeated string annotation_spec_id = 5;</code>
     *
     * @param index The index of the element to return.
     * @return The annotationSpecId at the given index.
     */
    public java.lang.String getAnnotationSpecId(int index) {
      return annotationSpecId_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The annotation spec ids used for this evaluation.
     * </pre>
     *
     * <code>repeated string annotation_spec_id = 5;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the annotationSpecId at the given index.
     */
    public com.google.protobuf.ByteString getAnnotationSpecIdBytes(int index) {
      return annotationSpecId_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (auPrc_ != 0F) {
        output.writeFloat(1, auPrc_);
      }
      if (baseAuPrc_ != 0F) {
        output.writeFloat(2, baseAuPrc_);
      }
      for (int i = 0; i < confidenceMetricsEntry_.size(); i++) {
        output.writeMessage(3, confidenceMetricsEntry_.get(i));
      }
      if (confusionMatrix_ != null) {
        output.writeMessage(4, getConfusionMatrix());
      }
      for (int i = 0; i < annotationSpecId_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, annotationSpecId_.getRaw(i));
      }
      if (auRoc_ != 0F) {
        output.writeFloat(6, auRoc_);
      }
      if (logLoss_ != 0F) {
        output.writeFloat(7, logLoss_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (auPrc_ != 0F) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(1, auPrc_);
      }
      if (baseAuPrc_ != 0F) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(2, baseAuPrc_);
      }
      for (int i = 0; i < confidenceMetricsEntry_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                3, confidenceMetricsEntry_.get(i));
      }
      if (confusionMatrix_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getConfusionMatrix());
      }
      {
        int dataSize = 0;
        for (int i = 0; i < annotationSpecId_.size(); i++) {
          dataSize += computeStringSizeNoTag(annotationSpecId_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getAnnotationSpecIdList().size();
      }
      if (auRoc_ != 0F) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(6, auRoc_);
      }
      if (logLoss_ != 0F) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(7, logLoss_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics)) {
        return super.equals(obj);
      }
      com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics other =
          (com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics) obj;

      if (java.lang.Float.floatToIntBits(getAuPrc())
          != java.lang.Float.floatToIntBits(other.getAuPrc())) return false;
      if (java.lang.Float.floatToIntBits(getBaseAuPrc())
          != java.lang.Float.floatToIntBits(other.getBaseAuPrc())) return false;
      if (java.lang.Float.floatToIntBits(getAuRoc())
          != java.lang.Float.floatToIntBits(other.getAuRoc())) return false;
      if (java.lang.Float.floatToIntBits(getLogLoss())
          != java.lang.Float.floatToIntBits(other.getLogLoss())) return false;
      if (!getConfidenceMetricsEntryList().equals(other.getConfidenceMetricsEntryList()))
        return false;
      if (hasConfusionMatrix() != other.hasConfusionMatrix()) return false;
      if (hasConfusionMatrix()) {
        if (!getConfusionMatrix().equals(other.getConfusionMatrix())) return false;
      }
      if (!getAnnotationSpecIdList().equals(other.getAnnotationSpecIdList())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + AU_PRC_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getAuPrc());
      hash = (37 * hash) + BASE_AU_PRC_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getBaseAuPrc());
      hash = (37 * hash) + AU_ROC_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getAuRoc());
      hash = (37 * hash) + LOG_LOSS_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getLogLoss());
      if (getConfidenceMetricsEntryCount() > 0) {
        hash = (37 * hash) + CONFIDENCE_METRICS_ENTRY_FIELD_NUMBER;
        hash = (53 * hash) + getConfidenceMetricsEntryList().hashCode();
      }
      if (hasConfusionMatrix()) {
        hash = (37 * hash) + CONFUSION_MATRIX_FIELD_NUMBER;
        hash = (53 * hash) + getConfusionMatrix().hashCode();
      }
      if (getAnnotationSpecIdCount() > 0) {
        hash = (37 * hash) + ANNOTATION_SPEC_ID_FIELD_NUMBER;
        hash = (53 * hash) + getAnnotationSpecIdList().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.automl.v1beta1.ClassificationProto
            .ClassificationEvaluationMetrics
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.automl.v1beta1.ClassificationProto
            .ClassificationEvaluationMetrics
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.automl.v1beta1.ClassificationProto
            .ClassificationEvaluationMetrics
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.automl.v1beta1.ClassificationProto
            .ClassificationEvaluationMetrics
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.automl.v1beta1.ClassificationProto
            .ClassificationEvaluationMetrics
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.automl.v1beta1.ClassificationProto
            .ClassificationEvaluationMetrics
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.automl.v1beta1.ClassificationProto
            .ClassificationEvaluationMetrics
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.automl.v1beta1.ClassificationProto
            .ClassificationEvaluationMetrics
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.automl.v1beta1.ClassificationProto
            .ClassificationEvaluationMetrics
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.automl.v1beta1.ClassificationProto
            .ClassificationEvaluationMetrics
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.automl.v1beta1.ClassificationProto
            .ClassificationEvaluationMetrics
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.automl.v1beta1.ClassificationProto
            .ClassificationEvaluationMetrics
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Model evaluation metrics for classification problems.
     * Note: For Video Classification this metrics only describe quality of the
     * Video Classification predictions of "segment_classification" type.
     * </pre>
     *
     * Protobuf type {@code google.cloud.automl.v1beta1.ClassificationEvaluationMetrics}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.automl.v1beta1.ClassificationEvaluationMetrics)
        com.google.cloud.automl.v1beta1.ClassificationProto
            .ClassificationEvaluationMetricsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.automl.v1beta1.ClassificationProto
            .internal_static_google_cloud_automl_v1beta1_ClassificationEvaluationMetrics_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.automl.v1beta1.ClassificationProto
            .internal_static_google_cloud_automl_v1beta1_ClassificationEvaluationMetrics_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                    .class,
                com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getConfidenceMetricsEntryFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        auPrc_ = 0F;

        baseAuPrc_ = 0F;

        auRoc_ = 0F;

        logLoss_ = 0F;

        if (confidenceMetricsEntryBuilder_ == null) {
          confidenceMetricsEntry_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          confidenceMetricsEntryBuilder_.clear();
        }
        if (confusionMatrixBuilder_ == null) {
          confusionMatrix_ = null;
        } else {
          confusionMatrix_ = null;
          confusionMatrixBuilder_ = null;
        }
        annotationSpecId_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.automl.v1beta1.ClassificationProto
            .internal_static_google_cloud_automl_v1beta1_ClassificationEvaluationMetrics_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
          getDefaultInstanceForType() {
        return com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
          build() {
        com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
          buildPartial() {
        com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics result =
            new com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics(
                this);
        int from_bitField0_ = bitField0_;
        result.auPrc_ = auPrc_;
        result.baseAuPrc_ = baseAuPrc_;
        result.auRoc_ = auRoc_;
        result.logLoss_ = logLoss_;
        if (confidenceMetricsEntryBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            confidenceMetricsEntry_ =
                java.util.Collections.unmodifiableList(confidenceMetricsEntry_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.confidenceMetricsEntry_ = confidenceMetricsEntry_;
        } else {
          result.confidenceMetricsEntry_ = confidenceMetricsEntryBuilder_.build();
        }
        if (confusionMatrixBuilder_ == null) {
          result.confusionMatrix_ = confusionMatrix_;
        } else {
          result.confusionMatrix_ = confusionMatrixBuilder_.build();
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          annotationSpecId_ = annotationSpecId_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.annotationSpecId_ = annotationSpecId_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics) {
          return mergeFrom(
              (com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
              other) {
        if (other
            == com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                .getDefaultInstance()) return this;
        if (other.getAuPrc() != 0F) {
          setAuPrc(other.getAuPrc());
        }
        if (other.getBaseAuPrc() != 0F) {
          setBaseAuPrc(other.getBaseAuPrc());
        }
        if (other.getAuRoc() != 0F) {
          setAuRoc(other.getAuRoc());
        }
        if (other.getLogLoss() != 0F) {
          setLogLoss(other.getLogLoss());
        }
        if (confidenceMetricsEntryBuilder_ == null) {
          if (!other.confidenceMetricsEntry_.isEmpty()) {
            if (confidenceMetricsEntry_.isEmpty()) {
              confidenceMetricsEntry_ = other.confidenceMetricsEntry_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureConfidenceMetricsEntryIsMutable();
              confidenceMetricsEntry_.addAll(other.confidenceMetricsEntry_);
            }
            onChanged();
          }
        } else {
          if (!other.confidenceMetricsEntry_.isEmpty()) {
            if (confidenceMetricsEntryBuilder_.isEmpty()) {
              confidenceMetricsEntryBuilder_.dispose();
              confidenceMetricsEntryBuilder_ = null;
              confidenceMetricsEntry_ = other.confidenceMetricsEntry_;
              bitField0_ = (bitField0_ & ~0x00000001);
              confidenceMetricsEntryBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getConfidenceMetricsEntryFieldBuilder()
                      : null;
            } else {
              confidenceMetricsEntryBuilder_.addAllMessages(other.confidenceMetricsEntry_);
            }
          }
        }
        if (other.hasConfusionMatrix()) {
          mergeConfusionMatrix(other.getConfusionMatrix());
        }
        if (!other.annotationSpecId_.isEmpty()) {
          if (annotationSpecId_.isEmpty()) {
            annotationSpecId_ = other.annotationSpecId_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureAnnotationSpecIdIsMutable();
            annotationSpecId_.addAll(other.annotationSpecId_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
            parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private float auPrc_;
      /**
       *
       *
       * <pre>
       * Output only. The Area Under Precision-Recall Curve metric. Micro-averaged
       * for the overall evaluation.
       * </pre>
       *
       * <code>float au_prc = 1;</code>
       *
       * @return The auPrc.
       */
      public float getAuPrc() {
        return auPrc_;
      }
      /**
       *
       *
       * <pre>
       * Output only. The Area Under Precision-Recall Curve metric. Micro-averaged
       * for the overall evaluation.
       * </pre>
       *
       * <code>float au_prc = 1;</code>
       *
       * @param value The auPrc to set.
       * @return This builder for chaining.
       */
      public Builder setAuPrc(float value) {

        auPrc_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The Area Under Precision-Recall Curve metric. Micro-averaged
       * for the overall evaluation.
       * </pre>
       *
       * <code>float au_prc = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAuPrc() {

        auPrc_ = 0F;
        onChanged();
        return this;
      }

      private float baseAuPrc_;
      /**
       *
       *
       * <pre>
       * Output only. The Area Under Precision-Recall Curve metric based on priors.
       * Micro-averaged for the overall evaluation.
       * Deprecated.
       * </pre>
       *
       * <code>float base_au_prc = 2 [deprecated = true];</code>
       *
       * @return The baseAuPrc.
       */
      @java.lang.Deprecated
      public float getBaseAuPrc() {
        return baseAuPrc_;
      }
      /**
       *
       *
       * <pre>
       * Output only. The Area Under Precision-Recall Curve metric based on priors.
       * Micro-averaged for the overall evaluation.
       * Deprecated.
       * </pre>
       *
       * <code>float base_au_prc = 2 [deprecated = true];</code>
       *
       * @param value The baseAuPrc to set.
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder setBaseAuPrc(float value) {

        baseAuPrc_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The Area Under Precision-Recall Curve metric based on priors.
       * Micro-averaged for the overall evaluation.
       * Deprecated.
       * </pre>
       *
       * <code>float base_au_prc = 2 [deprecated = true];</code>
       *
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder clearBaseAuPrc() {

        baseAuPrc_ = 0F;
        onChanged();
        return this;
      }

      private float auRoc_;
      /**
       *
       *
       * <pre>
       * Output only. The Area Under Receiver Operating Characteristic curve metric.
       * Micro-averaged for the overall evaluation.
       * </pre>
       *
       * <code>float au_roc = 6;</code>
       *
       * @return The auRoc.
       */
      public float getAuRoc() {
        return auRoc_;
      }
      /**
       *
       *
       * <pre>
       * Output only. The Area Under Receiver Operating Characteristic curve metric.
       * Micro-averaged for the overall evaluation.
       * </pre>
       *
       * <code>float au_roc = 6;</code>
       *
       * @param value The auRoc to set.
       * @return This builder for chaining.
       */
      public Builder setAuRoc(float value) {

        auRoc_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The Area Under Receiver Operating Characteristic curve metric.
       * Micro-averaged for the overall evaluation.
       * </pre>
       *
       * <code>float au_roc = 6;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAuRoc() {

        auRoc_ = 0F;
        onChanged();
        return this;
      }

      private float logLoss_;
      /**
       *
       *
       * <pre>
       * Output only. The Log Loss metric.
       * </pre>
       *
       * <code>float log_loss = 7;</code>
       *
       * @return The logLoss.
       */
      public float getLogLoss() {
        return logLoss_;
      }
      /**
       *
       *
       * <pre>
       * Output only. The Log Loss metric.
       * </pre>
       *
       * <code>float log_loss = 7;</code>
       *
       * @param value The logLoss to set.
       * @return This builder for chaining.
       */
      public Builder setLogLoss(float value) {

        logLoss_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The Log Loss metric.
       * </pre>
       *
       * <code>float log_loss = 7;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLogLoss() {

        logLoss_ = 0F;
        onChanged();
        return this;
      }

      private java.util.List<
              com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                  .ConfidenceMetricsEntry>
          confidenceMetricsEntry_ = java.util.Collections.emptyList();

      private void ensureConfidenceMetricsEntryIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          confidenceMetricsEntry_ =
              new java.util.ArrayList<
                  com.google.cloud.automl.v1beta1.ClassificationProto
                      .ClassificationEvaluationMetrics.ConfidenceMetricsEntry>(
                  confidenceMetricsEntry_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                  .ConfidenceMetricsEntry,
              com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                  .ConfidenceMetricsEntry.Builder,
              com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                  .ConfidenceMetricsEntryOrBuilder>
          confidenceMetricsEntryBuilder_;

      /**
       *
       *
       * <pre>
       * Output only. Metrics for each confidence_threshold in
       * 0.00,0.05,0.10,...,0.95,0.96,0.97,0.98,0.99 and
       * position_threshold = INT32_MAX_VALUE.
       * ROC and precision-recall curves, and other aggregated metrics are derived
       * from them. The confidence metrics entries may also be supplied for
       * additional values of position_threshold, but from these no aggregated
       * metrics are computed.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfidenceMetricsEntry confidence_metrics_entry = 3;
       * </code>
       */
      public java.util.List<
              com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                  .ConfidenceMetricsEntry>
          getConfidenceMetricsEntryList() {
        if (confidenceMetricsEntryBuilder_ == null) {
          return java.util.Collections.unmodifiableList(confidenceMetricsEntry_);
        } else {
          return confidenceMetricsEntryBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Metrics for each confidence_threshold in
       * 0.00,0.05,0.10,...,0.95,0.96,0.97,0.98,0.99 and
       * position_threshold = INT32_MAX_VALUE.
       * ROC and precision-recall curves, and other aggregated metrics are derived
       * from them. The confidence metrics entries may also be supplied for
       * additional values of position_threshold, but from these no aggregated
       * metrics are computed.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfidenceMetricsEntry confidence_metrics_entry = 3;
       * </code>
       */
      public int getConfidenceMetricsEntryCount() {
        if (confidenceMetricsEntryBuilder_ == null) {
          return confidenceMetricsEntry_.size();
        } else {
          return confidenceMetricsEntryBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Metrics for each confidence_threshold in
       * 0.00,0.05,0.10,...,0.95,0.96,0.97,0.98,0.99 and
       * position_threshold = INT32_MAX_VALUE.
       * ROC and precision-recall curves, and other aggregated metrics are derived
       * from them. The confidence metrics entries may also be supplied for
       * additional values of position_threshold, but from these no aggregated
       * metrics are computed.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfidenceMetricsEntry confidence_metrics_entry = 3;
       * </code>
       */
      public com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
              .ConfidenceMetricsEntry
          getConfidenceMetricsEntry(int index) {
        if (confidenceMetricsEntryBuilder_ == null) {
          return confidenceMetricsEntry_.get(index);
        } else {
          return confidenceMetricsEntryBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Metrics for each confidence_threshold in
       * 0.00,0.05,0.10,...,0.95,0.96,0.97,0.98,0.99 and
       * position_threshold = INT32_MAX_VALUE.
       * ROC and precision-recall curves, and other aggregated metrics are derived
       * from them. The confidence metrics entries may also be supplied for
       * additional values of position_threshold, but from these no aggregated
       * metrics are computed.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfidenceMetricsEntry confidence_metrics_entry = 3;
       * </code>
       */
      public Builder setConfidenceMetricsEntry(
          int index,
          com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                  .ConfidenceMetricsEntry
              value) {
        if (confidenceMetricsEntryBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureConfidenceMetricsEntryIsMutable();
          confidenceMetricsEntry_.set(index, value);
          onChanged();
        } else {
          confidenceMetricsEntryBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Metrics for each confidence_threshold in
       * 0.00,0.05,0.10,...,0.95,0.96,0.97,0.98,0.99 and
       * position_threshold = INT32_MAX_VALUE.
       * ROC and precision-recall curves, and other aggregated metrics are derived
       * from them. The confidence metrics entries may also be supplied for
       * additional values of position_threshold, but from these no aggregated
       * metrics are computed.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfidenceMetricsEntry confidence_metrics_entry = 3;
       * </code>
       */
      public Builder setConfidenceMetricsEntry(
          int index,
          com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                  .ConfidenceMetricsEntry.Builder
              builderForValue) {
        if (confidenceMetricsEntryBuilder_ == null) {
          ensureConfidenceMetricsEntryIsMutable();
          confidenceMetricsEntry_.set(index, builderForValue.build());
          onChanged();
        } else {
          confidenceMetricsEntryBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Metrics for each confidence_threshold in
       * 0.00,0.05,0.10,...,0.95,0.96,0.97,0.98,0.99 and
       * position_threshold = INT32_MAX_VALUE.
       * ROC and precision-recall curves, and other aggregated metrics are derived
       * from them. The confidence metrics entries may also be supplied for
       * additional values of position_threshold, but from these no aggregated
       * metrics are computed.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfidenceMetricsEntry confidence_metrics_entry = 3;
       * </code>
       */
      public Builder addConfidenceMetricsEntry(
          com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                  .ConfidenceMetricsEntry
              value) {
        if (confidenceMetricsEntryBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureConfidenceMetricsEntryIsMutable();
          confidenceMetricsEntry_.add(value);
          onChanged();
        } else {
          confidenceMetricsEntryBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Metrics for each confidence_threshold in
       * 0.00,0.05,0.10,...,0.95,0.96,0.97,0.98,0.99 and
       * position_threshold = INT32_MAX_VALUE.
       * ROC and precision-recall curves, and other aggregated metrics are derived
       * from them. The confidence metrics entries may also be supplied for
       * additional values of position_threshold, but from these no aggregated
       * metrics are computed.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfidenceMetricsEntry confidence_metrics_entry = 3;
       * </code>
       */
      public Builder addConfidenceMetricsEntry(
          int index,
          com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                  .ConfidenceMetricsEntry
              value) {
        if (confidenceMetricsEntryBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureConfidenceMetricsEntryIsMutable();
          confidenceMetricsEntry_.add(index, value);
          onChanged();
        } else {
          confidenceMetricsEntryBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Metrics for each confidence_threshold in
       * 0.00,0.05,0.10,...,0.95,0.96,0.97,0.98,0.99 and
       * position_threshold = INT32_MAX_VALUE.
       * ROC and precision-recall curves, and other aggregated metrics are derived
       * from them. The confidence metrics entries may also be supplied for
       * additional values of position_threshold, but from these no aggregated
       * metrics are computed.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfidenceMetricsEntry confidence_metrics_entry = 3;
       * </code>
       */
      public Builder addConfidenceMetricsEntry(
          com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                  .ConfidenceMetricsEntry.Builder
              builderForValue) {
        if (confidenceMetricsEntryBuilder_ == null) {
          ensureConfidenceMetricsEntryIsMutable();
          confidenceMetricsEntry_.add(builderForValue.build());
          onChanged();
        } else {
          confidenceMetricsEntryBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Metrics for each confidence_threshold in
       * 0.00,0.05,0.10,...,0.95,0.96,0.97,0.98,0.99 and
       * position_threshold = INT32_MAX_VALUE.
       * ROC and precision-recall curves, and other aggregated metrics are derived
       * from them. The confidence metrics entries may also be supplied for
       * additional values of position_threshold, but from these no aggregated
       * metrics are computed.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfidenceMetricsEntry confidence_metrics_entry = 3;
       * </code>
       */
      public Builder addConfidenceMetricsEntry(
          int index,
          com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                  .ConfidenceMetricsEntry.Builder
              builderForValue) {
        if (confidenceMetricsEntryBuilder_ == null) {
          ensureConfidenceMetricsEntryIsMutable();
          confidenceMetricsEntry_.add(index, builderForValue.build());
          onChanged();
        } else {
          confidenceMetricsEntryBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Metrics for each confidence_threshold in
       * 0.00,0.05,0.10,...,0.95,0.96,0.97,0.98,0.99 and
       * position_threshold = INT32_MAX_VALUE.
       * ROC and precision-recall curves, and other aggregated metrics are derived
       * from them. The confidence metrics entries may also be supplied for
       * additional values of position_threshold, but from these no aggregated
       * metrics are computed.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfidenceMetricsEntry confidence_metrics_entry = 3;
       * </code>
       */
      public Builder addAllConfidenceMetricsEntry(
          java.lang.Iterable<
                  ? extends
                      com.google.cloud.automl.v1beta1.ClassificationProto
                          .ClassificationEvaluationMetrics.ConfidenceMetricsEntry>
              values) {
        if (confidenceMetricsEntryBuilder_ == null) {
          ensureConfidenceMetricsEntryIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, confidenceMetricsEntry_);
          onChanged();
        } else {
          confidenceMetricsEntryBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Metrics for each confidence_threshold in
       * 0.00,0.05,0.10,...,0.95,0.96,0.97,0.98,0.99 and
       * position_threshold = INT32_MAX_VALUE.
       * ROC and precision-recall curves, and other aggregated metrics are derived
       * from them. The confidence metrics entries may also be supplied for
       * additional values of position_threshold, but from these no aggregated
       * metrics are computed.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfidenceMetricsEntry confidence_metrics_entry = 3;
       * </code>
       */
      public Builder clearConfidenceMetricsEntry() {
        if (confidenceMetricsEntryBuilder_ == null) {
          confidenceMetricsEntry_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          confidenceMetricsEntryBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Metrics for each confidence_threshold in
       * 0.00,0.05,0.10,...,0.95,0.96,0.97,0.98,0.99 and
       * position_threshold = INT32_MAX_VALUE.
       * ROC and precision-recall curves, and other aggregated metrics are derived
       * from them. The confidence metrics entries may also be supplied for
       * additional values of position_threshold, but from these no aggregated
       * metrics are computed.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfidenceMetricsEntry confidence_metrics_entry = 3;
       * </code>
       */
      public Builder removeConfidenceMetricsEntry(int index) {
        if (confidenceMetricsEntryBuilder_ == null) {
          ensureConfidenceMetricsEntryIsMutable();
          confidenceMetricsEntry_.remove(index);
          onChanged();
        } else {
          confidenceMetricsEntryBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Metrics for each confidence_threshold in
       * 0.00,0.05,0.10,...,0.95,0.96,0.97,0.98,0.99 and
       * position_threshold = INT32_MAX_VALUE.
       * ROC and precision-recall curves, and other aggregated metrics are derived
       * from them. The confidence metrics entries may also be supplied for
       * additional values of position_threshold, but from these no aggregated
       * metrics are computed.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfidenceMetricsEntry confidence_metrics_entry = 3;
       * </code>
       */
      public com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
              .ConfidenceMetricsEntry.Builder
          getConfidenceMetricsEntryBuilder(int index) {
        return getConfidenceMetricsEntryFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Output only. Metrics for each confidence_threshold in
       * 0.00,0.05,0.10,...,0.95,0.96,0.97,0.98,0.99 and
       * position_threshold = INT32_MAX_VALUE.
       * ROC and precision-recall curves, and other aggregated metrics are derived
       * from them. The confidence metrics entries may also be supplied for
       * additional values of position_threshold, but from these no aggregated
       * metrics are computed.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfidenceMetricsEntry confidence_metrics_entry = 3;
       * </code>
       */
      public com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
              .ConfidenceMetricsEntryOrBuilder
          getConfidenceMetricsEntryOrBuilder(int index) {
        if (confidenceMetricsEntryBuilder_ == null) {
          return confidenceMetricsEntry_.get(index);
        } else {
          return confidenceMetricsEntryBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Metrics for each confidence_threshold in
       * 0.00,0.05,0.10,...,0.95,0.96,0.97,0.98,0.99 and
       * position_threshold = INT32_MAX_VALUE.
       * ROC and precision-recall curves, and other aggregated metrics are derived
       * from them. The confidence metrics entries may also be supplied for
       * additional values of position_threshold, but from these no aggregated
       * metrics are computed.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfidenceMetricsEntry confidence_metrics_entry = 3;
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.automl.v1beta1.ClassificationProto
                      .ClassificationEvaluationMetrics.ConfidenceMetricsEntryOrBuilder>
          getConfidenceMetricsEntryOrBuilderList() {
        if (confidenceMetricsEntryBuilder_ != null) {
          return confidenceMetricsEntryBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(confidenceMetricsEntry_);
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Metrics for each confidence_threshold in
       * 0.00,0.05,0.10,...,0.95,0.96,0.97,0.98,0.99 and
       * position_threshold = INT32_MAX_VALUE.
       * ROC and precision-recall curves, and other aggregated metrics are derived
       * from them. The confidence metrics entries may also be supplied for
       * additional values of position_threshold, but from these no aggregated
       * metrics are computed.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfidenceMetricsEntry confidence_metrics_entry = 3;
       * </code>
       */
      public com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
              .ConfidenceMetricsEntry.Builder
          addConfidenceMetricsEntryBuilder() {
        return getConfidenceMetricsEntryFieldBuilder()
            .addBuilder(
                com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                    .ConfidenceMetricsEntry.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Output only. Metrics for each confidence_threshold in
       * 0.00,0.05,0.10,...,0.95,0.96,0.97,0.98,0.99 and
       * position_threshold = INT32_MAX_VALUE.
       * ROC and precision-recall curves, and other aggregated metrics are derived
       * from them. The confidence metrics entries may also be supplied for
       * additional values of position_threshold, but from these no aggregated
       * metrics are computed.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfidenceMetricsEntry confidence_metrics_entry = 3;
       * </code>
       */
      public com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
              .ConfidenceMetricsEntry.Builder
          addConfidenceMetricsEntryBuilder(int index) {
        return getConfidenceMetricsEntryFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                    .ConfidenceMetricsEntry.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Output only. Metrics for each confidence_threshold in
       * 0.00,0.05,0.10,...,0.95,0.96,0.97,0.98,0.99 and
       * position_threshold = INT32_MAX_VALUE.
       * ROC and precision-recall curves, and other aggregated metrics are derived
       * from them. The confidence metrics entries may also be supplied for
       * additional values of position_threshold, but from these no aggregated
       * metrics are computed.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfidenceMetricsEntry confidence_metrics_entry = 3;
       * </code>
       */
      public java.util.List<
              com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                  .ConfidenceMetricsEntry.Builder>
          getConfidenceMetricsEntryBuilderList() {
        return getConfidenceMetricsEntryFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                  .ConfidenceMetricsEntry,
              com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                  .ConfidenceMetricsEntry.Builder,
              com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                  .ConfidenceMetricsEntryOrBuilder>
          getConfidenceMetricsEntryFieldBuilder() {
        if (confidenceMetricsEntryBuilder_ == null) {
          confidenceMetricsEntryBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.automl.v1beta1.ClassificationProto
                      .ClassificationEvaluationMetrics.ConfidenceMetricsEntry,
                  com.google.cloud.automl.v1beta1.ClassificationProto
                      .ClassificationEvaluationMetrics.ConfidenceMetricsEntry.Builder,
                  com.google.cloud.automl.v1beta1.ClassificationProto
                      .ClassificationEvaluationMetrics.ConfidenceMetricsEntryOrBuilder>(
                  confidenceMetricsEntry_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          confidenceMetricsEntry_ = null;
        }
        return confidenceMetricsEntryBuilder_;
      }

      private com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
              .ConfusionMatrix
          confusionMatrix_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                  .ConfusionMatrix,
              com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                  .ConfusionMatrix.Builder,
              com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                  .ConfusionMatrixOrBuilder>
          confusionMatrixBuilder_;
      /**
       *
       *
       * <pre>
       * Output only. Confusion matrix of the evaluation.
       * Only set for MULTICLASS classification problems where number
       * of labels is no more than 10.
       * Only set for model level evaluation, not for evaluation per label.
       * </pre>
       *
       * <code>
       * .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix confusion_matrix = 4;
       * </code>
       *
       * @return Whether the confusionMatrix field is set.
       */
      public boolean hasConfusionMatrix() {
        return confusionMatrixBuilder_ != null || confusionMatrix_ != null;
      }
      /**
       *
       *
       * <pre>
       * Output only. Confusion matrix of the evaluation.
       * Only set for MULTICLASS classification problems where number
       * of labels is no more than 10.
       * Only set for model level evaluation, not for evaluation per label.
       * </pre>
       *
       * <code>
       * .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix confusion_matrix = 4;
       * </code>
       *
       * @return The confusionMatrix.
       */
      public com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
              .ConfusionMatrix
          getConfusionMatrix() {
        if (confusionMatrixBuilder_ == null) {
          return confusionMatrix_ == null
              ? com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                  .ConfusionMatrix.getDefaultInstance()
              : confusionMatrix_;
        } else {
          return confusionMatrixBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Confusion matrix of the evaluation.
       * Only set for MULTICLASS classification problems where number
       * of labels is no more than 10.
       * Only set for model level evaluation, not for evaluation per label.
       * </pre>
       *
       * <code>
       * .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix confusion_matrix = 4;
       * </code>
       */
      public Builder setConfusionMatrix(
          com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                  .ConfusionMatrix
              value) {
        if (confusionMatrixBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          confusionMatrix_ = value;
          onChanged();
        } else {
          confusionMatrixBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Confusion matrix of the evaluation.
       * Only set for MULTICLASS classification problems where number
       * of labels is no more than 10.
       * Only set for model level evaluation, not for evaluation per label.
       * </pre>
       *
       * <code>
       * .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix confusion_matrix = 4;
       * </code>
       */
      public Builder setConfusionMatrix(
          com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                  .ConfusionMatrix.Builder
              builderForValue) {
        if (confusionMatrixBuilder_ == null) {
          confusionMatrix_ = builderForValue.build();
          onChanged();
        } else {
          confusionMatrixBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Confusion matrix of the evaluation.
       * Only set for MULTICLASS classification problems where number
       * of labels is no more than 10.
       * Only set for model level evaluation, not for evaluation per label.
       * </pre>
       *
       * <code>
       * .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix confusion_matrix = 4;
       * </code>
       */
      public Builder mergeConfusionMatrix(
          com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                  .ConfusionMatrix
              value) {
        if (confusionMatrixBuilder_ == null) {
          if (confusionMatrix_ != null) {
            confusionMatrix_ =
                com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                    .ConfusionMatrix.newBuilder(confusionMatrix_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            confusionMatrix_ = value;
          }
          onChanged();
        } else {
          confusionMatrixBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Confusion matrix of the evaluation.
       * Only set for MULTICLASS classification problems where number
       * of labels is no more than 10.
       * Only set for model level evaluation, not for evaluation per label.
       * </pre>
       *
       * <code>
       * .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix confusion_matrix = 4;
       * </code>
       */
      public Builder clearConfusionMatrix() {
        if (confusionMatrixBuilder_ == null) {
          confusionMatrix_ = null;
          onChanged();
        } else {
          confusionMatrix_ = null;
          confusionMatrixBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Confusion matrix of the evaluation.
       * Only set for MULTICLASS classification problems where number
       * of labels is no more than 10.
       * Only set for model level evaluation, not for evaluation per label.
       * </pre>
       *
       * <code>
       * .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix confusion_matrix = 4;
       * </code>
       */
      public com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
              .ConfusionMatrix.Builder
          getConfusionMatrixBuilder() {

        onChanged();
        return getConfusionMatrixFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Output only. Confusion matrix of the evaluation.
       * Only set for MULTICLASS classification problems where number
       * of labels is no more than 10.
       * Only set for model level evaluation, not for evaluation per label.
       * </pre>
       *
       * <code>
       * .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix confusion_matrix = 4;
       * </code>
       */
      public com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
              .ConfusionMatrixOrBuilder
          getConfusionMatrixOrBuilder() {
        if (confusionMatrixBuilder_ != null) {
          return confusionMatrixBuilder_.getMessageOrBuilder();
        } else {
          return confusionMatrix_ == null
              ? com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                  .ConfusionMatrix.getDefaultInstance()
              : confusionMatrix_;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Confusion matrix of the evaluation.
       * Only set for MULTICLASS classification problems where number
       * of labels is no more than 10.
       * Only set for model level evaluation, not for evaluation per label.
       * </pre>
       *
       * <code>
       * .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics.ConfusionMatrix confusion_matrix = 4;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                  .ConfusionMatrix,
              com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                  .ConfusionMatrix.Builder,
              com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                  .ConfusionMatrixOrBuilder>
          getConfusionMatrixFieldBuilder() {
        if (confusionMatrixBuilder_ == null) {
          confusionMatrixBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.automl.v1beta1.ClassificationProto
                      .ClassificationEvaluationMetrics.ConfusionMatrix,
                  com.google.cloud.automl.v1beta1.ClassificationProto
                      .ClassificationEvaluationMetrics.ConfusionMatrix.Builder,
                  com.google.cloud.automl.v1beta1.ClassificationProto
                      .ClassificationEvaluationMetrics.ConfusionMatrixOrBuilder>(
                  getConfusionMatrix(), getParentForChildren(), isClean());
          confusionMatrix_ = null;
        }
        return confusionMatrixBuilder_;
      }

      private com.google.protobuf.LazyStringList annotationSpecId_ =
          com.google.protobuf.LazyStringArrayList.EMPTY;

      private void ensureAnnotationSpecIdIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          annotationSpecId_ = new com.google.protobuf.LazyStringArrayList(annotationSpecId_);
          bitField0_ |= 0x00000002;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The annotation spec ids used for this evaluation.
       * </pre>
       *
       * <code>repeated string annotation_spec_id = 5;</code>
       *
       * @return A list containing the annotationSpecId.
       */
      public com.google.protobuf.ProtocolStringList getAnnotationSpecIdList() {
        return annotationSpecId_.getUnmodifiableView();
      }
      /**
       *
       *
       * <pre>
       * Output only. The annotation spec ids used for this evaluation.
       * </pre>
       *
       * <code>repeated string annotation_spec_id = 5;</code>
       *
       * @return The count of annotationSpecId.
       */
      public int getAnnotationSpecIdCount() {
        return annotationSpecId_.size();
      }
      /**
       *
       *
       * <pre>
       * Output only. The annotation spec ids used for this evaluation.
       * </pre>
       *
       * <code>repeated string annotation_spec_id = 5;</code>
       *
       * @param index The index of the element to return.
       * @return The annotationSpecId at the given index.
       */
      public java.lang.String getAnnotationSpecId(int index) {
        return annotationSpecId_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Output only. The annotation spec ids used for this evaluation.
       * </pre>
       *
       * <code>repeated string annotation_spec_id = 5;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the annotationSpecId at the given index.
       */
      public com.google.protobuf.ByteString getAnnotationSpecIdBytes(int index) {
        return annotationSpecId_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Output only. The annotation spec ids used for this evaluation.
       * </pre>
       *
       * <code>repeated string annotation_spec_id = 5;</code>
       *
       * @param index The index to set the value at.
       * @param value The annotationSpecId to set.
       * @return This builder for chaining.
       */
      public Builder setAnnotationSpecId(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAnnotationSpecIdIsMutable();
        annotationSpecId_.set(index, value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The annotation spec ids used for this evaluation.
       * </pre>
       *
       * <code>repeated string annotation_spec_id = 5;</code>
       *
       * @param value The annotationSpecId to add.
       * @return This builder for chaining.
       */
      public Builder addAnnotationSpecId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAnnotationSpecIdIsMutable();
        annotationSpecId_.add(value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The annotation spec ids used for this evaluation.
       * </pre>
       *
       * <code>repeated string annotation_spec_id = 5;</code>
       *
       * @param values The annotationSpecId to add.
       * @return This builder for chaining.
       */
      public Builder addAllAnnotationSpecId(java.lang.Iterable<java.lang.String> values) {
        ensureAnnotationSpecIdIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, annotationSpecId_);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The annotation spec ids used for this evaluation.
       * </pre>
       *
       * <code>repeated string annotation_spec_id = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAnnotationSpecId() {
        annotationSpecId_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The annotation spec ids used for this evaluation.
       * </pre>
       *
       * <code>repeated string annotation_spec_id = 5;</code>
       *
       * @param value The bytes of the annotationSpecId to add.
       * @return This builder for chaining.
       */
      public Builder addAnnotationSpecIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureAnnotationSpecIdIsMutable();
        annotationSpecId_.add(value);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.automl.v1beta1.ClassificationEvaluationMetrics)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.automl.v1beta1.ClassificationEvaluationMetrics)
    private static final com.google.cloud.automl.v1beta1.ClassificationProto
            .ClassificationEvaluationMetrics
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics();
    }

    public static com.google.cloud.automl.v1beta1.ClassificationProto
            .ClassificationEvaluationMetrics
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ClassificationEvaluationMetrics> PARSER =
        new com.google.protobuf.AbstractParser<ClassificationEvaluationMetrics>() {
          @java.lang.Override
          public ClassificationEvaluationMetrics parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new ClassificationEvaluationMetrics(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<ClassificationEvaluationMetrics> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ClassificationEvaluationMetrics> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_automl_v1beta1_ClassificationAnnotation_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_automl_v1beta1_ClassificationAnnotation_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_automl_v1beta1_VideoClassificationAnnotation_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_automl_v1beta1_VideoClassificationAnnotation_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_automl_v1beta1_ClassificationEvaluationMetrics_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_automl_v1beta1_ClassificationEvaluationMetrics_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_automl_v1beta1_ClassificationEvaluationMetrics_ConfidenceMetricsEntry_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_automl_v1beta1_ClassificationEvaluationMetrics_ConfidenceMetricsEntry_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_automl_v1beta1_ClassificationEvaluationMetrics_ConfusionMatrix_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_automl_v1beta1_ClassificationEvaluationMetrics_ConfusionMatrix_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_automl_v1beta1_ClassificationEvaluationMetrics_ConfusionMatrix_Row_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_automl_v1beta1_ClassificationEvaluationMetrics_ConfusionMatrix_Row_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor getDescriptor() {
    return descriptor;
  }

  private static com.google.protobuf.Descriptors.FileDescriptor descriptor;

  static {
    java.lang.String[] descriptorData = {
      "\n0google/cloud/automl/v1beta1/classifica"
          + "tion.proto\022\033google.cloud.automl.v1beta1\032"
          + "\034google/api/annotations.proto\032*google/cl"
          + "oud/automl/v1beta1/temporal.proto\")\n\030Cla"
          + "ssificationAnnotation\022\r\n\005score\030\001 \001(\002\"\307\001\n"
          + "\035VideoClassificationAnnotation\022\014\n\004type\030\001"
          + " \001(\t\022X\n\031classification_annotation\030\002 \001(\0132"
          + "5.google.cloud.automl.v1beta1.Classifica"
          + "tionAnnotation\022>\n\014time_segment\030\003 \001(\0132(.g"
          + "oogle.cloud.automl.v1beta1.TimeSegment\"\251"
          + "\007\n\037ClassificationEvaluationMetrics\022\016\n\006au"
          + "_prc\030\001 \001(\002\022\027\n\013base_au_prc\030\002 \001(\002B\002\030\001\022\016\n\006a"
          + "u_roc\030\006 \001(\002\022\020\n\010log_loss\030\007 \001(\002\022u\n\030confide"
          + "nce_metrics_entry\030\003 \003(\0132S.google.cloud.a"
          + "utoml.v1beta1.ClassificationEvaluationMe"
          + "trics.ConfidenceMetricsEntry\022f\n\020confusio"
          + "n_matrix\030\004 \001(\0132L.google.cloud.automl.v1b"
          + "eta1.ClassificationEvaluationMetrics.Con"
          + "fusionMatrix\022\032\n\022annotation_spec_id\030\005 \003(\t"
          + "\032\374\002\n\026ConfidenceMetricsEntry\022\034\n\024confidenc"
          + "e_threshold\030\001 \001(\002\022\032\n\022position_threshold\030"
          + "\016 \001(\005\022\016\n\006recall\030\002 \001(\002\022\021\n\tprecision\030\003 \001(\002"
          + "\022\033\n\023false_positive_rate\030\010 \001(\002\022\020\n\010f1_scor"
          + "e\030\004 \001(\002\022\022\n\nrecall_at1\030\005 \001(\002\022\025\n\rprecision"
          + "_at1\030\006 \001(\002\022\037\n\027false_positive_rate_at1\030\t "
          + "\001(\002\022\024\n\014f1_score_at1\030\007 \001(\002\022\033\n\023true_positi"
          + "ve_count\030\n \001(\003\022\034\n\024false_positive_count\030\013"
          + " \001(\003\022\034\n\024false_negative_count\030\014 \001(\003\022\033\n\023tr"
          + "ue_negative_count\030\r \001(\003\032\300\001\n\017ConfusionMat"
          + "rix\022\032\n\022annotation_spec_id\030\001 \003(\t\022\024\n\014displ"
          + "ay_name\030\003 \003(\t\022]\n\003row\030\002 \003(\0132P.google.clou"
          + "d.automl.v1beta1.ClassificationEvaluatio"
          + "nMetrics.ConfusionMatrix.Row\032\034\n\003Row\022\025\n\re"
          + "xample_count\030\001 \003(\005*Y\n\022ClassificationType"
          + "\022#\n\037CLASSIFICATION_TYPE_UNSPECIFIED\020\000\022\016\n"
          + "\nMULTICLASS\020\001\022\016\n\nMULTILABEL\020\002B\270\001\n\037com.go"
          + "ogle.cloud.automl.v1beta1B\023Classificatio"
          + "nProtoZAgoogle.golang.org/genproto/googl"
          + "eapis/cloud/automl/v1beta1;automl\312\002\033Goog"
          + "le\\Cloud\\AutoMl\\V1beta1\352\002\036Google::Cloud:"
          + ":AutoML::V1beta1b\006proto3"
    };
    descriptor =
        com.google.protobuf.Descriptors.FileDescriptor.internalBuildGeneratedFileFrom(
            descriptorData,
            new com.google.protobuf.Descriptors.FileDescriptor[] {
              com.google.api.AnnotationsProto.getDescriptor(),
              com.google.cloud.automl.v1beta1.Temporal.getDescriptor(),
            });
    internal_static_google_cloud_automl_v1beta1_ClassificationAnnotation_descriptor =
        getDescriptor().getMessageTypes().get(0);
    internal_static_google_cloud_automl_v1beta1_ClassificationAnnotation_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_automl_v1beta1_ClassificationAnnotation_descriptor,
            new java.lang.String[] {
              "Score",
            });
    internal_static_google_cloud_automl_v1beta1_VideoClassificationAnnotation_descriptor =
        getDescriptor().getMessageTypes().get(1);
    internal_static_google_cloud_automl_v1beta1_VideoClassificationAnnotation_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_automl_v1beta1_VideoClassificationAnnotation_descriptor,
            new java.lang.String[] {
              "Type", "ClassificationAnnotation", "TimeSegment",
            });
    internal_static_google_cloud_automl_v1beta1_ClassificationEvaluationMetrics_descriptor =
        getDescriptor().getMessageTypes().get(2);
    internal_static_google_cloud_automl_v1beta1_ClassificationEvaluationMetrics_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_automl_v1beta1_ClassificationEvaluationMetrics_descriptor,
            new java.lang.String[] {
              "AuPrc",
              "BaseAuPrc",
              "AuRoc",
              "LogLoss",
              "ConfidenceMetricsEntry",
              "ConfusionMatrix",
              "AnnotationSpecId",
            });
    internal_static_google_cloud_automl_v1beta1_ClassificationEvaluationMetrics_ConfidenceMetricsEntry_descriptor =
        internal_static_google_cloud_automl_v1beta1_ClassificationEvaluationMetrics_descriptor
            .getNestedTypes()
            .get(0);
    internal_static_google_cloud_automl_v1beta1_ClassificationEvaluationMetrics_ConfidenceMetricsEntry_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_automl_v1beta1_ClassificationEvaluationMetrics_ConfidenceMetricsEntry_descriptor,
            new java.lang.String[] {
              "ConfidenceThreshold",
              "PositionThreshold",
              "Recall",
              "Precision",
              "FalsePositiveRate",
              "F1Score",
              "RecallAt1",
              "PrecisionAt1",
              "FalsePositiveRateAt1",
              "F1ScoreAt1",
              "TruePositiveCount",
              "FalsePositiveCount",
              "FalseNegativeCount",
              "TrueNegativeCount",
            });
    internal_static_google_cloud_automl_v1beta1_ClassificationEvaluationMetrics_ConfusionMatrix_descriptor =
        internal_static_google_cloud_automl_v1beta1_ClassificationEvaluationMetrics_descriptor
            .getNestedTypes()
            .get(1);
    internal_static_google_cloud_automl_v1beta1_ClassificationEvaluationMetrics_ConfusionMatrix_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_automl_v1beta1_ClassificationEvaluationMetrics_ConfusionMatrix_descriptor,
            new java.lang.String[] {
              "AnnotationSpecId", "DisplayName", "Row",
            });
    internal_static_google_cloud_automl_v1beta1_ClassificationEvaluationMetrics_ConfusionMatrix_Row_descriptor =
        internal_static_google_cloud_automl_v1beta1_ClassificationEvaluationMetrics_ConfusionMatrix_descriptor
            .getNestedTypes()
            .get(0);
    internal_static_google_cloud_automl_v1beta1_ClassificationEvaluationMetrics_ConfusionMatrix_Row_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_automl_v1beta1_ClassificationEvaluationMetrics_ConfusionMatrix_Row_descriptor,
            new java.lang.String[] {
              "ExampleCount",
            });
    com.google.api.AnnotationsProto.getDescriptor();
    com.google.cloud.automl.v1beta1.Temporal.getDescriptor();
  }

  // @@protoc_insertion_point(outer_class_scope)
}
