/*
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/automl/v1beta1/operations.proto

package com.google.cloud.automl.v1beta1;

/**
 *
 *
 * <pre>
 * Details of ExportModel operation.
 * </pre>
 *
 * Protobuf type {@code google.cloud.automl.v1beta1.ExportModelOperationMetadata}
 */
public final class ExportModelOperationMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.automl.v1beta1.ExportModelOperationMetadata)
    ExportModelOperationMetadataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ExportModelOperationMetadata.newBuilder() to construct.
  private ExportModelOperationMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ExportModelOperationMetadata() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ExportModelOperationMetadata();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private ExportModelOperationMetadata(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 18:
            {
              com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo
                      .Builder
                  subBuilder = null;
              if (outputInfo_ != null) {
                subBuilder = outputInfo_.toBuilder();
              }
              outputInfo_ =
                  input.readMessage(
                      com.google.cloud.automl.v1beta1.ExportModelOperationMetadata
                          .ExportModelOutputInfo.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(outputInfo_);
                outputInfo_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.automl.v1beta1.Operations
        .internal_static_google_cloud_automl_v1beta1_ExportModelOperationMetadata_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.automl.v1beta1.Operations
        .internal_static_google_cloud_automl_v1beta1_ExportModelOperationMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.class,
            com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.Builder.class);
  }

  public interface ExportModelOutputInfoOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The full path of the Google Cloud Storage directory created, into which
     * the model will be exported.
     * </pre>
     *
     * <code>string gcs_output_directory = 1;</code>
     *
     * @return The gcsOutputDirectory.
     */
    java.lang.String getGcsOutputDirectory();
    /**
     *
     *
     * <pre>
     * The full path of the Google Cloud Storage directory created, into which
     * the model will be exported.
     * </pre>
     *
     * <code>string gcs_output_directory = 1;</code>
     *
     * @return The bytes for gcsOutputDirectory.
     */
    com.google.protobuf.ByteString getGcsOutputDirectoryBytes();
  }
  /**
   *
   *
   * <pre>
   * Further describes the output of model export.
   * Supplements
   * [ModelExportOutputConfig][google.cloud.automl.v1beta1.ModelExportOutputConfig].
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo}
   */
  public static final class ExportModelOutputInfo extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo)
      ExportModelOutputInfoOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ExportModelOutputInfo.newBuilder() to construct.
    private ExportModelOutputInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ExportModelOutputInfo() {
      gcsOutputDirectory_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ExportModelOutputInfo();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private ExportModelOutputInfo(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                gcsOutputDirectory_ = s;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.automl.v1beta1.Operations
          .internal_static_google_cloud_automl_v1beta1_ExportModelOperationMetadata_ExportModelOutputInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.automl.v1beta1.Operations
          .internal_static_google_cloud_automl_v1beta1_ExportModelOperationMetadata_ExportModelOutputInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo
                  .class,
              com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo
                  .Builder.class);
    }

    public static final int GCS_OUTPUT_DIRECTORY_FIELD_NUMBER = 1;
    private volatile java.lang.Object gcsOutputDirectory_;
    /**
     *
     *
     * <pre>
     * The full path of the Google Cloud Storage directory created, into which
     * the model will be exported.
     * </pre>
     *
     * <code>string gcs_output_directory = 1;</code>
     *
     * @return The gcsOutputDirectory.
     */
    public java.lang.String getGcsOutputDirectory() {
      java.lang.Object ref = gcsOutputDirectory_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        gcsOutputDirectory_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The full path of the Google Cloud Storage directory created, into which
     * the model will be exported.
     * </pre>
     *
     * <code>string gcs_output_directory = 1;</code>
     *
     * @return The bytes for gcsOutputDirectory.
     */
    public com.google.protobuf.ByteString getGcsOutputDirectoryBytes() {
      java.lang.Object ref = gcsOutputDirectory_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        gcsOutputDirectory_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!getGcsOutputDirectoryBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, gcsOutputDirectory_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getGcsOutputDirectoryBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, gcsOutputDirectory_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo)) {
        return super.equals(obj);
      }
      com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo other =
          (com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo) obj;

      if (!getGcsOutputDirectory().equals(other.getGcsOutputDirectory())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + GCS_OUTPUT_DIRECTORY_FIELD_NUMBER;
      hash = (53 * hash) + getGcsOutputDirectory().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Further describes the output of model export.
     * Supplements
     * [ModelExportOutputConfig][google.cloud.automl.v1beta1.ModelExportOutputConfig].
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo)
        com.google.cloud.automl.v1beta1.ExportModelOperationMetadata
            .ExportModelOutputInfoOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.automl.v1beta1.Operations
            .internal_static_google_cloud_automl_v1beta1_ExportModelOperationMetadata_ExportModelOutputInfo_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.automl.v1beta1.Operations
            .internal_static_google_cloud_automl_v1beta1_ExportModelOperationMetadata_ExportModelOutputInfo_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo
                    .class,
                com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        gcsOutputDirectory_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.automl.v1beta1.Operations
            .internal_static_google_cloud_automl_v1beta1_ExportModelOperationMetadata_ExportModelOutputInfo_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo
          getDefaultInstanceForType() {
        return com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo
          build() {
        com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo
          buildPartial() {
        com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo result =
            new com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo(
                this);
        result.gcsOutputDirectory_ = gcsOutputDirectory_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo) {
          return mergeFrom(
              (com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo
              other) {
        if (other
            == com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo
                .getDefaultInstance()) return this;
        if (!other.getGcsOutputDirectory().isEmpty()) {
          gcsOutputDirectory_ = other.gcsOutputDirectory_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo
            parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object gcsOutputDirectory_ = "";
      /**
       *
       *
       * <pre>
       * The full path of the Google Cloud Storage directory created, into which
       * the model will be exported.
       * </pre>
       *
       * <code>string gcs_output_directory = 1;</code>
       *
       * @return The gcsOutputDirectory.
       */
      public java.lang.String getGcsOutputDirectory() {
        java.lang.Object ref = gcsOutputDirectory_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          gcsOutputDirectory_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The full path of the Google Cloud Storage directory created, into which
       * the model will be exported.
       * </pre>
       *
       * <code>string gcs_output_directory = 1;</code>
       *
       * @return The bytes for gcsOutputDirectory.
       */
      public com.google.protobuf.ByteString getGcsOutputDirectoryBytes() {
        java.lang.Object ref = gcsOutputDirectory_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          gcsOutputDirectory_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The full path of the Google Cloud Storage directory created, into which
       * the model will be exported.
       * </pre>
       *
       * <code>string gcs_output_directory = 1;</code>
       *
       * @param value The gcsOutputDirectory to set.
       * @return This builder for chaining.
       */
      public Builder setGcsOutputDirectory(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        gcsOutputDirectory_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The full path of the Google Cloud Storage directory created, into which
       * the model will be exported.
       * </pre>
       *
       * <code>string gcs_output_directory = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGcsOutputDirectory() {

        gcsOutputDirectory_ = getDefaultInstance().getGcsOutputDirectory();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The full path of the Google Cloud Storage directory created, into which
       * the model will be exported.
       * </pre>
       *
       * <code>string gcs_output_directory = 1;</code>
       *
       * @param value The bytes for gcsOutputDirectory to set.
       * @return This builder for chaining.
       */
      public Builder setGcsOutputDirectoryBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        gcsOutputDirectory_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo)
    private static final com.google.cloud.automl.v1beta1.ExportModelOperationMetadata
            .ExportModelOutputInfo
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo();
    }

    public static com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ExportModelOutputInfo> PARSER =
        new com.google.protobuf.AbstractParser<ExportModelOutputInfo>() {
          @java.lang.Override
          public ExportModelOutputInfo parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new ExportModelOutputInfo(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<ExportModelOutputInfo> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ExportModelOutputInfo> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int OUTPUT_INFO_FIELD_NUMBER = 2;
  private com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo
      outputInfo_;
  /**
   *
   *
   * <pre>
   * Output only. Information further describing the output of this model
   * export.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo output_info = 2;
   * </code>
   *
   * @return Whether the outputInfo field is set.
   */
  public boolean hasOutputInfo() {
    return outputInfo_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Information further describing the output of this model
   * export.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo output_info = 2;
   * </code>
   *
   * @return The outputInfo.
   */
  public com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo
      getOutputInfo() {
    return outputInfo_ == null
        ? com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo
            .getDefaultInstance()
        : outputInfo_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Information further describing the output of this model
   * export.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo output_info = 2;
   * </code>
   */
  public com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfoOrBuilder
      getOutputInfoOrBuilder() {
    return getOutputInfo();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (outputInfo_ != null) {
      output.writeMessage(2, getOutputInfo());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (outputInfo_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getOutputInfo());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.automl.v1beta1.ExportModelOperationMetadata)) {
      return super.equals(obj);
    }
    com.google.cloud.automl.v1beta1.ExportModelOperationMetadata other =
        (com.google.cloud.automl.v1beta1.ExportModelOperationMetadata) obj;

    if (hasOutputInfo() != other.hasOutputInfo()) return false;
    if (hasOutputInfo()) {
      if (!getOutputInfo().equals(other.getOutputInfo())) return false;
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasOutputInfo()) {
      hash = (37 * hash) + OUTPUT_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getOutputInfo().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.automl.v1beta1.ExportModelOperationMetadata parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1beta1.ExportModelOperationMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.ExportModelOperationMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1beta1.ExportModelOperationMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.ExportModelOperationMetadata parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1beta1.ExportModelOperationMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.ExportModelOperationMetadata parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1beta1.ExportModelOperationMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.ExportModelOperationMetadata parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1beta1.ExportModelOperationMetadata parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.ExportModelOperationMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1beta1.ExportModelOperationMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.automl.v1beta1.ExportModelOperationMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Details of ExportModel operation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.automl.v1beta1.ExportModelOperationMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.automl.v1beta1.ExportModelOperationMetadata)
      com.google.cloud.automl.v1beta1.ExportModelOperationMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.automl.v1beta1.Operations
          .internal_static_google_cloud_automl_v1beta1_ExportModelOperationMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.automl.v1beta1.Operations
          .internal_static_google_cloud_automl_v1beta1_ExportModelOperationMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.class,
              com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.Builder.class);
    }

    // Construct using com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (outputInfoBuilder_ == null) {
        outputInfo_ = null;
      } else {
        outputInfo_ = null;
        outputInfoBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.automl.v1beta1.Operations
          .internal_static_google_cloud_automl_v1beta1_ExportModelOperationMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.ExportModelOperationMetadata
        getDefaultInstanceForType() {
      return com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.ExportModelOperationMetadata build() {
      com.google.cloud.automl.v1beta1.ExportModelOperationMetadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.ExportModelOperationMetadata buildPartial() {
      com.google.cloud.automl.v1beta1.ExportModelOperationMetadata result =
          new com.google.cloud.automl.v1beta1.ExportModelOperationMetadata(this);
      if (outputInfoBuilder_ == null) {
        result.outputInfo_ = outputInfo_;
      } else {
        result.outputInfo_ = outputInfoBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.automl.v1beta1.ExportModelOperationMetadata) {
        return mergeFrom((com.google.cloud.automl.v1beta1.ExportModelOperationMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.automl.v1beta1.ExportModelOperationMetadata other) {
      if (other
          == com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.getDefaultInstance())
        return this;
      if (other.hasOutputInfo()) {
        mergeOutputInfo(other.getOutputInfo());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.automl.v1beta1.ExportModelOperationMetadata parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.automl.v1beta1.ExportModelOperationMetadata) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo
        outputInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo,
            com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo
                .Builder,
            com.google.cloud.automl.v1beta1.ExportModelOperationMetadata
                .ExportModelOutputInfoOrBuilder>
        outputInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Information further describing the output of this model
     * export.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo output_info = 2;
     * </code>
     *
     * @return Whether the outputInfo field is set.
     */
    public boolean hasOutputInfo() {
      return outputInfoBuilder_ != null || outputInfo_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information further describing the output of this model
     * export.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo output_info = 2;
     * </code>
     *
     * @return The outputInfo.
     */
    public com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo
        getOutputInfo() {
      if (outputInfoBuilder_ == null) {
        return outputInfo_ == null
            ? com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo
                .getDefaultInstance()
            : outputInfo_;
      } else {
        return outputInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Information further describing the output of this model
     * export.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo output_info = 2;
     * </code>
     */
    public Builder setOutputInfo(
        com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo value) {
      if (outputInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        outputInfo_ = value;
        onChanged();
      } else {
        outputInfoBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information further describing the output of this model
     * export.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo output_info = 2;
     * </code>
     */
    public Builder setOutputInfo(
        com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo.Builder
            builderForValue) {
      if (outputInfoBuilder_ == null) {
        outputInfo_ = builderForValue.build();
        onChanged();
      } else {
        outputInfoBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information further describing the output of this model
     * export.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo output_info = 2;
     * </code>
     */
    public Builder mergeOutputInfo(
        com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo value) {
      if (outputInfoBuilder_ == null) {
        if (outputInfo_ != null) {
          outputInfo_ =
              com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo
                  .newBuilder(outputInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          outputInfo_ = value;
        }
        onChanged();
      } else {
        outputInfoBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information further describing the output of this model
     * export.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo output_info = 2;
     * </code>
     */
    public Builder clearOutputInfo() {
      if (outputInfoBuilder_ == null) {
        outputInfo_ = null;
        onChanged();
      } else {
        outputInfo_ = null;
        outputInfoBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information further describing the output of this model
     * export.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo output_info = 2;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo
            .Builder
        getOutputInfoBuilder() {

      onChanged();
      return getOutputInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Information further describing the output of this model
     * export.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo output_info = 2;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.ExportModelOperationMetadata
            .ExportModelOutputInfoOrBuilder
        getOutputInfoOrBuilder() {
      if (outputInfoBuilder_ != null) {
        return outputInfoBuilder_.getMessageOrBuilder();
      } else {
        return outputInfo_ == null
            ? com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo
                .getDefaultInstance()
            : outputInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Information further describing the output of this model
     * export.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo output_info = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo,
            com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo
                .Builder,
            com.google.cloud.automl.v1beta1.ExportModelOperationMetadata
                .ExportModelOutputInfoOrBuilder>
        getOutputInfoFieldBuilder() {
      if (outputInfoBuilder_ == null) {
        outputInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo,
                com.google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo
                    .Builder,
                com.google.cloud.automl.v1beta1.ExportModelOperationMetadata
                    .ExportModelOutputInfoOrBuilder>(
                getOutputInfo(), getParentForChildren(), isClean());
        outputInfo_ = null;
      }
      return outputInfoBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.automl.v1beta1.ExportModelOperationMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.automl.v1beta1.ExportModelOperationMetadata)
  private static final com.google.cloud.automl.v1beta1.ExportModelOperationMetadata
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.automl.v1beta1.ExportModelOperationMetadata();
  }

  public static com.google.cloud.automl.v1beta1.ExportModelOperationMetadata getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ExportModelOperationMetadata> PARSER =
      new com.google.protobuf.AbstractParser<ExportModelOperationMetadata>() {
        @java.lang.Override
        public ExportModelOperationMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new ExportModelOperationMetadata(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<ExportModelOperationMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ExportModelOperationMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.automl.v1beta1.ExportModelOperationMetadata getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
