/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/automl/v1beta1/prediction_service.proto

package com.google.cloud.automl.v1beta1;

/**
 *
 *
 * <pre>
 * Request message for [PredictionService.BatchPredict][google.cloud.automl.v1beta1.PredictionService.BatchPredict].
 * </pre>
 *
 * Protobuf type {@code google.cloud.automl.v1beta1.BatchPredictRequest}
 */
public final class BatchPredictRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.automl.v1beta1.BatchPredictRequest)
    BatchPredictRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BatchPredictRequest.newBuilder() to construct.
  private BatchPredictRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BatchPredictRequest() {
    name_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BatchPredictRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private BatchPredictRequest(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 26:
            {
              com.google.cloud.automl.v1beta1.BatchPredictInputConfig.Builder subBuilder = null;
              if (inputConfig_ != null) {
                subBuilder = inputConfig_.toBuilder();
              }
              inputConfig_ =
                  input.readMessage(
                      com.google.cloud.automl.v1beta1.BatchPredictInputConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(inputConfig_);
                inputConfig_ = subBuilder.buildPartial();
              }

              break;
            }
          case 34:
            {
              com.google.cloud.automl.v1beta1.BatchPredictOutputConfig.Builder subBuilder = null;
              if (outputConfig_ != null) {
                subBuilder = outputConfig_.toBuilder();
              }
              outputConfig_ =
                  input.readMessage(
                      com.google.cloud.automl.v1beta1.BatchPredictOutputConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(outputConfig_);
                outputConfig_ = subBuilder.buildPartial();
              }

              break;
            }
          case 42:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                params_ =
                    com.google.protobuf.MapField.newMapField(ParamsDefaultEntryHolder.defaultEntry);
                mutable_bitField0_ |= 0x00000001;
              }
              com.google.protobuf.MapEntry<java.lang.String, java.lang.String> params__ =
                  input.readMessage(
                      ParamsDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
              params_.getMutableMap().put(params__.getKey(), params__.getValue());
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.automl.v1beta1.PredictionServiceProto
        .internal_static_google_cloud_automl_v1beta1_BatchPredictRequest_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 5:
        return internalGetParams();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.automl.v1beta1.PredictionServiceProto
        .internal_static_google_cloud_automl_v1beta1_BatchPredictRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.automl.v1beta1.BatchPredictRequest.class,
            com.google.cloud.automl.v1beta1.BatchPredictRequest.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Required. Name of the model requested to serve the batch prediction.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The name.
   */
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Name of the model requested to serve the batch prediction.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for name.
   */
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INPUT_CONFIG_FIELD_NUMBER = 3;
  private com.google.cloud.automl.v1beta1.BatchPredictInputConfig inputConfig_;
  /**
   *
   *
   * <pre>
   * Required. The input configuration for batch prediction.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.BatchPredictInputConfig input_config = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the inputConfig field is set.
   */
  public boolean hasInputConfig() {
    return inputConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. The input configuration for batch prediction.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.BatchPredictInputConfig input_config = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The inputConfig.
   */
  public com.google.cloud.automl.v1beta1.BatchPredictInputConfig getInputConfig() {
    return inputConfig_ == null
        ? com.google.cloud.automl.v1beta1.BatchPredictInputConfig.getDefaultInstance()
        : inputConfig_;
  }
  /**
   *
   *
   * <pre>
   * Required. The input configuration for batch prediction.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.BatchPredictInputConfig input_config = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  public com.google.cloud.automl.v1beta1.BatchPredictInputConfigOrBuilder
      getInputConfigOrBuilder() {
    return getInputConfig();
  }

  public static final int OUTPUT_CONFIG_FIELD_NUMBER = 4;
  private com.google.cloud.automl.v1beta1.BatchPredictOutputConfig outputConfig_;
  /**
   *
   *
   * <pre>
   * Required. The Configuration specifying where output predictions should
   * be written.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.BatchPredictOutputConfig output_config = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the outputConfig field is set.
   */
  public boolean hasOutputConfig() {
    return outputConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. The Configuration specifying where output predictions should
   * be written.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.BatchPredictOutputConfig output_config = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The outputConfig.
   */
  public com.google.cloud.automl.v1beta1.BatchPredictOutputConfig getOutputConfig() {
    return outputConfig_ == null
        ? com.google.cloud.automl.v1beta1.BatchPredictOutputConfig.getDefaultInstance()
        : outputConfig_;
  }
  /**
   *
   *
   * <pre>
   * Required. The Configuration specifying where output predictions should
   * be written.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.BatchPredictOutputConfig output_config = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  public com.google.cloud.automl.v1beta1.BatchPredictOutputConfigOrBuilder
      getOutputConfigOrBuilder() {
    return getOutputConfig();
  }

  public static final int PARAMS_FIELD_NUMBER = 5;

  private static final class ParamsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.automl.v1beta1.PredictionServiceProto
                .internal_static_google_cloud_automl_v1beta1_BatchPredictRequest_ParamsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> params_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetParams() {
    if (params_ == null) {
      return com.google.protobuf.MapField.emptyMapField(ParamsDefaultEntryHolder.defaultEntry);
    }
    return params_;
  }

  public int getParamsCount() {
    return internalGetParams().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Required. Additional domain-specific parameters for the predictions, any string must
   * be up to 25000 characters long.
   * *  For Text Classification:
   *    `score_threshold` - (float) A value from 0.0 to 1.0. When the model
   *         makes predictions for a text snippet, it will only produce results
   *         that have at least this confidence score. The default is 0.5.
   * *  For Image Classification:
   *    `score_threshold` - (float) A value from 0.0 to 1.0. When the model
   *         makes predictions for an image, it will only produce results that
   *         have at least this confidence score. The default is 0.5.
   * *  For Image Object Detection:
   *    `score_threshold` - (float) When Model detects objects on the image,
   *        it will only produce bounding boxes which have at least this
   *        confidence score. Value in 0 to 1 range, default is 0.5.
   *    `max_bounding_box_count` - (int64) No more than this number of bounding
   *        boxes will be produced per image. Default is 100, the
   *        requested value may be limited by server.
   * *  For Video Classification :
   *    `score_threshold` - (float) A value from 0.0 to 1.0. When the model
   *        makes predictions for a video, it will only produce results that
   *        have at least this confidence score. The default is 0.5.
   *    `segment_classification` - (boolean) Set to true to request
   *        segment-level classification. AutoML Video Intelligence returns
   *        labels and their confidence scores for the entire segment of the
   *        video that user specified in the request configuration.
   *        The default is "true".
   *    `shot_classification` - (boolean) Set to true to request shot-level
   *        classification. AutoML Video Intelligence determines the boundaries
   *        for each camera shot in the entire segment of the video that user
   *        specified in the request configuration. AutoML Video Intelligence
   *        then returns labels and their confidence scores for each detected
   *        shot, along with the start and end time of the shot.
   *        WARNING: Model evaluation is not done for this classification type,
   *        the quality of it depends on training data, but there are no metrics
   *        provided to describe that quality. The default is "false".
   *    `1s_interval_classification` - (boolean) Set to true to request
   *        classification for a video at one-second intervals. AutoML Video
   *        Intelligence returns labels and their confidence scores for each
   *        second of the entire segment of the video that user specified in the
   *        request configuration.
   *        WARNING: Model evaluation is not done for this classification
   *        type, the quality of it depends on training data, but there are no
   *        metrics provided to describe that quality. The default is
   *        "false".
   * *  For Tables:
   *    feature_imp&lt;span&gt;ortan&lt;/span&gt;ce - (boolean) Whether feature importance
   *        should be populated in the returned TablesAnnotations. The
   *        default is false.
   * *  For Video Object Tracking:
   *    `score_threshold` - (float) When Model detects objects on video frames,
   *        it will only produce bounding boxes which have at least this
   *        confidence score. Value in 0 to 1 range, default is 0.5.
   *    `max_bounding_box_count` - (int64) No more than this number of bounding
   *        boxes will be returned per frame. Default is 100, the requested
   *        value may be limited by server.
   *    `min_bounding_box_size` - (float) Only bounding boxes with shortest edge
   *      at least that long as a relative value of video frame size will be
   *      returned. Value in 0 to 1 range. Default is 0.
   * </pre>
   *
   * <code>map&lt;string, string&gt; params = 5 [(.google.api.field_behavior) = REQUIRED];</code>
   */
  public boolean containsParams(java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    return internalGetParams().getMap().containsKey(key);
  }
  /** Use {@link #getParamsMap()} instead. */
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getParams() {
    return getParamsMap();
  }
  /**
   *
   *
   * <pre>
   * Required. Additional domain-specific parameters for the predictions, any string must
   * be up to 25000 characters long.
   * *  For Text Classification:
   *    `score_threshold` - (float) A value from 0.0 to 1.0. When the model
   *         makes predictions for a text snippet, it will only produce results
   *         that have at least this confidence score. The default is 0.5.
   * *  For Image Classification:
   *    `score_threshold` - (float) A value from 0.0 to 1.0. When the model
   *         makes predictions for an image, it will only produce results that
   *         have at least this confidence score. The default is 0.5.
   * *  For Image Object Detection:
   *    `score_threshold` - (float) When Model detects objects on the image,
   *        it will only produce bounding boxes which have at least this
   *        confidence score. Value in 0 to 1 range, default is 0.5.
   *    `max_bounding_box_count` - (int64) No more than this number of bounding
   *        boxes will be produced per image. Default is 100, the
   *        requested value may be limited by server.
   * *  For Video Classification :
   *    `score_threshold` - (float) A value from 0.0 to 1.0. When the model
   *        makes predictions for a video, it will only produce results that
   *        have at least this confidence score. The default is 0.5.
   *    `segment_classification` - (boolean) Set to true to request
   *        segment-level classification. AutoML Video Intelligence returns
   *        labels and their confidence scores for the entire segment of the
   *        video that user specified in the request configuration.
   *        The default is "true".
   *    `shot_classification` - (boolean) Set to true to request shot-level
   *        classification. AutoML Video Intelligence determines the boundaries
   *        for each camera shot in the entire segment of the video that user
   *        specified in the request configuration. AutoML Video Intelligence
   *        then returns labels and their confidence scores for each detected
   *        shot, along with the start and end time of the shot.
   *        WARNING: Model evaluation is not done for this classification type,
   *        the quality of it depends on training data, but there are no metrics
   *        provided to describe that quality. The default is "false".
   *    `1s_interval_classification` - (boolean) Set to true to request
   *        classification for a video at one-second intervals. AutoML Video
   *        Intelligence returns labels and their confidence scores for each
   *        second of the entire segment of the video that user specified in the
   *        request configuration.
   *        WARNING: Model evaluation is not done for this classification
   *        type, the quality of it depends on training data, but there are no
   *        metrics provided to describe that quality. The default is
   *        "false".
   * *  For Tables:
   *    feature_imp&lt;span&gt;ortan&lt;/span&gt;ce - (boolean) Whether feature importance
   *        should be populated in the returned TablesAnnotations. The
   *        default is false.
   * *  For Video Object Tracking:
   *    `score_threshold` - (float) When Model detects objects on video frames,
   *        it will only produce bounding boxes which have at least this
   *        confidence score. Value in 0 to 1 range, default is 0.5.
   *    `max_bounding_box_count` - (int64) No more than this number of bounding
   *        boxes will be returned per frame. Default is 100, the requested
   *        value may be limited by server.
   *    `min_bounding_box_size` - (float) Only bounding boxes with shortest edge
   *      at least that long as a relative value of video frame size will be
   *      returned. Value in 0 to 1 range. Default is 0.
   * </pre>
   *
   * <code>map&lt;string, string&gt; params = 5 [(.google.api.field_behavior) = REQUIRED];</code>
   */
  public java.util.Map<java.lang.String, java.lang.String> getParamsMap() {
    return internalGetParams().getMap();
  }
  /**
   *
   *
   * <pre>
   * Required. Additional domain-specific parameters for the predictions, any string must
   * be up to 25000 characters long.
   * *  For Text Classification:
   *    `score_threshold` - (float) A value from 0.0 to 1.0. When the model
   *         makes predictions for a text snippet, it will only produce results
   *         that have at least this confidence score. The default is 0.5.
   * *  For Image Classification:
   *    `score_threshold` - (float) A value from 0.0 to 1.0. When the model
   *         makes predictions for an image, it will only produce results that
   *         have at least this confidence score. The default is 0.5.
   * *  For Image Object Detection:
   *    `score_threshold` - (float) When Model detects objects on the image,
   *        it will only produce bounding boxes which have at least this
   *        confidence score. Value in 0 to 1 range, default is 0.5.
   *    `max_bounding_box_count` - (int64) No more than this number of bounding
   *        boxes will be produced per image. Default is 100, the
   *        requested value may be limited by server.
   * *  For Video Classification :
   *    `score_threshold` - (float) A value from 0.0 to 1.0. When the model
   *        makes predictions for a video, it will only produce results that
   *        have at least this confidence score. The default is 0.5.
   *    `segment_classification` - (boolean) Set to true to request
   *        segment-level classification. AutoML Video Intelligence returns
   *        labels and their confidence scores for the entire segment of the
   *        video that user specified in the request configuration.
   *        The default is "true".
   *    `shot_classification` - (boolean) Set to true to request shot-level
   *        classification. AutoML Video Intelligence determines the boundaries
   *        for each camera shot in the entire segment of the video that user
   *        specified in the request configuration. AutoML Video Intelligence
   *        then returns labels and their confidence scores for each detected
   *        shot, along with the start and end time of the shot.
   *        WARNING: Model evaluation is not done for this classification type,
   *        the quality of it depends on training data, but there are no metrics
   *        provided to describe that quality. The default is "false".
   *    `1s_interval_classification` - (boolean) Set to true to request
   *        classification for a video at one-second intervals. AutoML Video
   *        Intelligence returns labels and their confidence scores for each
   *        second of the entire segment of the video that user specified in the
   *        request configuration.
   *        WARNING: Model evaluation is not done for this classification
   *        type, the quality of it depends on training data, but there are no
   *        metrics provided to describe that quality. The default is
   *        "false".
   * *  For Tables:
   *    feature_imp&lt;span&gt;ortan&lt;/span&gt;ce - (boolean) Whether feature importance
   *        should be populated in the returned TablesAnnotations. The
   *        default is false.
   * *  For Video Object Tracking:
   *    `score_threshold` - (float) When Model detects objects on video frames,
   *        it will only produce bounding boxes which have at least this
   *        confidence score. Value in 0 to 1 range, default is 0.5.
   *    `max_bounding_box_count` - (int64) No more than this number of bounding
   *        boxes will be returned per frame. Default is 100, the requested
   *        value may be limited by server.
   *    `min_bounding_box_size` - (float) Only bounding boxes with shortest edge
   *      at least that long as a relative value of video frame size will be
   *      returned. Value in 0 to 1 range. Default is 0.
   * </pre>
   *
   * <code>map&lt;string, string&gt; params = 5 [(.google.api.field_behavior) = REQUIRED];</code>
   */
  public java.lang.String getParamsOrDefault(java.lang.String key, java.lang.String defaultValue) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetParams().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Required. Additional domain-specific parameters for the predictions, any string must
   * be up to 25000 characters long.
   * *  For Text Classification:
   *    `score_threshold` - (float) A value from 0.0 to 1.0. When the model
   *         makes predictions for a text snippet, it will only produce results
   *         that have at least this confidence score. The default is 0.5.
   * *  For Image Classification:
   *    `score_threshold` - (float) A value from 0.0 to 1.0. When the model
   *         makes predictions for an image, it will only produce results that
   *         have at least this confidence score. The default is 0.5.
   * *  For Image Object Detection:
   *    `score_threshold` - (float) When Model detects objects on the image,
   *        it will only produce bounding boxes which have at least this
   *        confidence score. Value in 0 to 1 range, default is 0.5.
   *    `max_bounding_box_count` - (int64) No more than this number of bounding
   *        boxes will be produced per image. Default is 100, the
   *        requested value may be limited by server.
   * *  For Video Classification :
   *    `score_threshold` - (float) A value from 0.0 to 1.0. When the model
   *        makes predictions for a video, it will only produce results that
   *        have at least this confidence score. The default is 0.5.
   *    `segment_classification` - (boolean) Set to true to request
   *        segment-level classification. AutoML Video Intelligence returns
   *        labels and their confidence scores for the entire segment of the
   *        video that user specified in the request configuration.
   *        The default is "true".
   *    `shot_classification` - (boolean) Set to true to request shot-level
   *        classification. AutoML Video Intelligence determines the boundaries
   *        for each camera shot in the entire segment of the video that user
   *        specified in the request configuration. AutoML Video Intelligence
   *        then returns labels and their confidence scores for each detected
   *        shot, along with the start and end time of the shot.
   *        WARNING: Model evaluation is not done for this classification type,
   *        the quality of it depends on training data, but there are no metrics
   *        provided to describe that quality. The default is "false".
   *    `1s_interval_classification` - (boolean) Set to true to request
   *        classification for a video at one-second intervals. AutoML Video
   *        Intelligence returns labels and their confidence scores for each
   *        second of the entire segment of the video that user specified in the
   *        request configuration.
   *        WARNING: Model evaluation is not done for this classification
   *        type, the quality of it depends on training data, but there are no
   *        metrics provided to describe that quality. The default is
   *        "false".
   * *  For Tables:
   *    feature_imp&lt;span&gt;ortan&lt;/span&gt;ce - (boolean) Whether feature importance
   *        should be populated in the returned TablesAnnotations. The
   *        default is false.
   * *  For Video Object Tracking:
   *    `score_threshold` - (float) When Model detects objects on video frames,
   *        it will only produce bounding boxes which have at least this
   *        confidence score. Value in 0 to 1 range, default is 0.5.
   *    `max_bounding_box_count` - (int64) No more than this number of bounding
   *        boxes will be returned per frame. Default is 100, the requested
   *        value may be limited by server.
   *    `min_bounding_box_size` - (float) Only bounding boxes with shortest edge
   *      at least that long as a relative value of video frame size will be
   *      returned. Value in 0 to 1 range. Default is 0.
   * </pre>
   *
   * <code>map&lt;string, string&gt; params = 5 [(.google.api.field_behavior) = REQUIRED];</code>
   */
  public java.lang.String getParamsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetParams().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (inputConfig_ != null) {
      output.writeMessage(3, getInputConfig());
    }
    if (outputConfig_ != null) {
      output.writeMessage(4, getOutputConfig());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetParams(), ParamsDefaultEntryHolder.defaultEntry, 5);
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (inputConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getInputConfig());
    }
    if (outputConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getOutputConfig());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetParams().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> params__ =
          ParamsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, params__);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.automl.v1beta1.BatchPredictRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.automl.v1beta1.BatchPredictRequest other =
        (com.google.cloud.automl.v1beta1.BatchPredictRequest) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasInputConfig() != other.hasInputConfig()) return false;
    if (hasInputConfig()) {
      if (!getInputConfig().equals(other.getInputConfig())) return false;
    }
    if (hasOutputConfig() != other.hasOutputConfig()) return false;
    if (hasOutputConfig()) {
      if (!getOutputConfig().equals(other.getOutputConfig())) return false;
    }
    if (!internalGetParams().equals(other.internalGetParams())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasInputConfig()) {
      hash = (37 * hash) + INPUT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getInputConfig().hashCode();
    }
    if (hasOutputConfig()) {
      hash = (37 * hash) + OUTPUT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getOutputConfig().hashCode();
    }
    if (!internalGetParams().getMap().isEmpty()) {
      hash = (37 * hash) + PARAMS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetParams().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.automl.v1beta1.BatchPredictRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1beta1.BatchPredictRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.BatchPredictRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1beta1.BatchPredictRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.BatchPredictRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1beta1.BatchPredictRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.BatchPredictRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1beta1.BatchPredictRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.BatchPredictRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1beta1.BatchPredictRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.BatchPredictRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1beta1.BatchPredictRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.automl.v1beta1.BatchPredictRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for [PredictionService.BatchPredict][google.cloud.automl.v1beta1.PredictionService.BatchPredict].
   * </pre>
   *
   * Protobuf type {@code google.cloud.automl.v1beta1.BatchPredictRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.automl.v1beta1.BatchPredictRequest)
      com.google.cloud.automl.v1beta1.BatchPredictRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.automl.v1beta1.PredictionServiceProto
          .internal_static_google_cloud_automl_v1beta1_BatchPredictRequest_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 5:
          return internalGetParams();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 5:
          return internalGetMutableParams();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.automl.v1beta1.PredictionServiceProto
          .internal_static_google_cloud_automl_v1beta1_BatchPredictRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.automl.v1beta1.BatchPredictRequest.class,
              com.google.cloud.automl.v1beta1.BatchPredictRequest.Builder.class);
    }

    // Construct using com.google.cloud.automl.v1beta1.BatchPredictRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      if (inputConfigBuilder_ == null) {
        inputConfig_ = null;
      } else {
        inputConfig_ = null;
        inputConfigBuilder_ = null;
      }
      if (outputConfigBuilder_ == null) {
        outputConfig_ = null;
      } else {
        outputConfig_ = null;
        outputConfigBuilder_ = null;
      }
      internalGetMutableParams().clear();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.automl.v1beta1.PredictionServiceProto
          .internal_static_google_cloud_automl_v1beta1_BatchPredictRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.BatchPredictRequest getDefaultInstanceForType() {
      return com.google.cloud.automl.v1beta1.BatchPredictRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.BatchPredictRequest build() {
      com.google.cloud.automl.v1beta1.BatchPredictRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.BatchPredictRequest buildPartial() {
      com.google.cloud.automl.v1beta1.BatchPredictRequest result =
          new com.google.cloud.automl.v1beta1.BatchPredictRequest(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      if (inputConfigBuilder_ == null) {
        result.inputConfig_ = inputConfig_;
      } else {
        result.inputConfig_ = inputConfigBuilder_.build();
      }
      if (outputConfigBuilder_ == null) {
        result.outputConfig_ = outputConfig_;
      } else {
        result.outputConfig_ = outputConfigBuilder_.build();
      }
      result.params_ = internalGetParams();
      result.params_.makeImmutable();
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.automl.v1beta1.BatchPredictRequest) {
        return mergeFrom((com.google.cloud.automl.v1beta1.BatchPredictRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.automl.v1beta1.BatchPredictRequest other) {
      if (other == com.google.cloud.automl.v1beta1.BatchPredictRequest.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (other.hasInputConfig()) {
        mergeInputConfig(other.getInputConfig());
      }
      if (other.hasOutputConfig()) {
        mergeOutputConfig(other.getOutputConfig());
      }
      internalGetMutableParams().mergeFrom(other.internalGetParams());
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.automl.v1beta1.BatchPredictRequest parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.automl.v1beta1.BatchPredictRequest) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. Name of the model requested to serve the batch prediction.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the model requested to serve the batch prediction.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the model requested to serve the batch prediction.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the model requested to serve the batch prediction.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the model requested to serve the batch prediction.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private com.google.cloud.automl.v1beta1.BatchPredictInputConfig inputConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.BatchPredictInputConfig,
            com.google.cloud.automl.v1beta1.BatchPredictInputConfig.Builder,
            com.google.cloud.automl.v1beta1.BatchPredictInputConfigOrBuilder>
        inputConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The input configuration for batch prediction.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.BatchPredictInputConfig input_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the inputConfig field is set.
     */
    public boolean hasInputConfig() {
      return inputConfigBuilder_ != null || inputConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. The input configuration for batch prediction.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.BatchPredictInputConfig input_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The inputConfig.
     */
    public com.google.cloud.automl.v1beta1.BatchPredictInputConfig getInputConfig() {
      if (inputConfigBuilder_ == null) {
        return inputConfig_ == null
            ? com.google.cloud.automl.v1beta1.BatchPredictInputConfig.getDefaultInstance()
            : inputConfig_;
      } else {
        return inputConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The input configuration for batch prediction.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.BatchPredictInputConfig input_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setInputConfig(com.google.cloud.automl.v1beta1.BatchPredictInputConfig value) {
      if (inputConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        inputConfig_ = value;
        onChanged();
      } else {
        inputConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The input configuration for batch prediction.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.BatchPredictInputConfig input_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setInputConfig(
        com.google.cloud.automl.v1beta1.BatchPredictInputConfig.Builder builderForValue) {
      if (inputConfigBuilder_ == null) {
        inputConfig_ = builderForValue.build();
        onChanged();
      } else {
        inputConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The input configuration for batch prediction.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.BatchPredictInputConfig input_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeInputConfig(com.google.cloud.automl.v1beta1.BatchPredictInputConfig value) {
      if (inputConfigBuilder_ == null) {
        if (inputConfig_ != null) {
          inputConfig_ =
              com.google.cloud.automl.v1beta1.BatchPredictInputConfig.newBuilder(inputConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          inputConfig_ = value;
        }
        onChanged();
      } else {
        inputConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The input configuration for batch prediction.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.BatchPredictInputConfig input_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearInputConfig() {
      if (inputConfigBuilder_ == null) {
        inputConfig_ = null;
        onChanged();
      } else {
        inputConfig_ = null;
        inputConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The input configuration for batch prediction.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.BatchPredictInputConfig input_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.automl.v1beta1.BatchPredictInputConfig.Builder getInputConfigBuilder() {

      onChanged();
      return getInputConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The input configuration for batch prediction.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.BatchPredictInputConfig input_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.automl.v1beta1.BatchPredictInputConfigOrBuilder
        getInputConfigOrBuilder() {
      if (inputConfigBuilder_ != null) {
        return inputConfigBuilder_.getMessageOrBuilder();
      } else {
        return inputConfig_ == null
            ? com.google.cloud.automl.v1beta1.BatchPredictInputConfig.getDefaultInstance()
            : inputConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The input configuration for batch prediction.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.BatchPredictInputConfig input_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.BatchPredictInputConfig,
            com.google.cloud.automl.v1beta1.BatchPredictInputConfig.Builder,
            com.google.cloud.automl.v1beta1.BatchPredictInputConfigOrBuilder>
        getInputConfigFieldBuilder() {
      if (inputConfigBuilder_ == null) {
        inputConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.automl.v1beta1.BatchPredictInputConfig,
                com.google.cloud.automl.v1beta1.BatchPredictInputConfig.Builder,
                com.google.cloud.automl.v1beta1.BatchPredictInputConfigOrBuilder>(
                getInputConfig(), getParentForChildren(), isClean());
        inputConfig_ = null;
      }
      return inputConfigBuilder_;
    }

    private com.google.cloud.automl.v1beta1.BatchPredictOutputConfig outputConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.BatchPredictOutputConfig,
            com.google.cloud.automl.v1beta1.BatchPredictOutputConfig.Builder,
            com.google.cloud.automl.v1beta1.BatchPredictOutputConfigOrBuilder>
        outputConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The Configuration specifying where output predictions should
     * be written.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.BatchPredictOutputConfig output_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the outputConfig field is set.
     */
    public boolean hasOutputConfig() {
      return outputConfigBuilder_ != null || outputConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. The Configuration specifying where output predictions should
     * be written.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.BatchPredictOutputConfig output_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The outputConfig.
     */
    public com.google.cloud.automl.v1beta1.BatchPredictOutputConfig getOutputConfig() {
      if (outputConfigBuilder_ == null) {
        return outputConfig_ == null
            ? com.google.cloud.automl.v1beta1.BatchPredictOutputConfig.getDefaultInstance()
            : outputConfig_;
      } else {
        return outputConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Configuration specifying where output predictions should
     * be written.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.BatchPredictOutputConfig output_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setOutputConfig(com.google.cloud.automl.v1beta1.BatchPredictOutputConfig value) {
      if (outputConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        outputConfig_ = value;
        onChanged();
      } else {
        outputConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Configuration specifying where output predictions should
     * be written.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.BatchPredictOutputConfig output_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setOutputConfig(
        com.google.cloud.automl.v1beta1.BatchPredictOutputConfig.Builder builderForValue) {
      if (outputConfigBuilder_ == null) {
        outputConfig_ = builderForValue.build();
        onChanged();
      } else {
        outputConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Configuration specifying where output predictions should
     * be written.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.BatchPredictOutputConfig output_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeOutputConfig(
        com.google.cloud.automl.v1beta1.BatchPredictOutputConfig value) {
      if (outputConfigBuilder_ == null) {
        if (outputConfig_ != null) {
          outputConfig_ =
              com.google.cloud.automl.v1beta1.BatchPredictOutputConfig.newBuilder(outputConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          outputConfig_ = value;
        }
        onChanged();
      } else {
        outputConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Configuration specifying where output predictions should
     * be written.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.BatchPredictOutputConfig output_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearOutputConfig() {
      if (outputConfigBuilder_ == null) {
        outputConfig_ = null;
        onChanged();
      } else {
        outputConfig_ = null;
        outputConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Configuration specifying where output predictions should
     * be written.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.BatchPredictOutputConfig output_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.automl.v1beta1.BatchPredictOutputConfig.Builder
        getOutputConfigBuilder() {

      onChanged();
      return getOutputConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The Configuration specifying where output predictions should
     * be written.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.BatchPredictOutputConfig output_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.automl.v1beta1.BatchPredictOutputConfigOrBuilder
        getOutputConfigOrBuilder() {
      if (outputConfigBuilder_ != null) {
        return outputConfigBuilder_.getMessageOrBuilder();
      } else {
        return outputConfig_ == null
            ? com.google.cloud.automl.v1beta1.BatchPredictOutputConfig.getDefaultInstance()
            : outputConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Configuration specifying where output predictions should
     * be written.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.BatchPredictOutputConfig output_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.BatchPredictOutputConfig,
            com.google.cloud.automl.v1beta1.BatchPredictOutputConfig.Builder,
            com.google.cloud.automl.v1beta1.BatchPredictOutputConfigOrBuilder>
        getOutputConfigFieldBuilder() {
      if (outputConfigBuilder_ == null) {
        outputConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.automl.v1beta1.BatchPredictOutputConfig,
                com.google.cloud.automl.v1beta1.BatchPredictOutputConfig.Builder,
                com.google.cloud.automl.v1beta1.BatchPredictOutputConfigOrBuilder>(
                getOutputConfig(), getParentForChildren(), isClean());
        outputConfig_ = null;
      }
      return outputConfigBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> params_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetParams() {
      if (params_ == null) {
        return com.google.protobuf.MapField.emptyMapField(ParamsDefaultEntryHolder.defaultEntry);
      }
      return params_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableParams() {
      onChanged();
      ;
      if (params_ == null) {
        params_ = com.google.protobuf.MapField.newMapField(ParamsDefaultEntryHolder.defaultEntry);
      }
      if (!params_.isMutable()) {
        params_ = params_.copy();
      }
      return params_;
    }

    public int getParamsCount() {
      return internalGetParams().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Required. Additional domain-specific parameters for the predictions, any string must
     * be up to 25000 characters long.
     * *  For Text Classification:
     *    `score_threshold` - (float) A value from 0.0 to 1.0. When the model
     *         makes predictions for a text snippet, it will only produce results
     *         that have at least this confidence score. The default is 0.5.
     * *  For Image Classification:
     *    `score_threshold` - (float) A value from 0.0 to 1.0. When the model
     *         makes predictions for an image, it will only produce results that
     *         have at least this confidence score. The default is 0.5.
     * *  For Image Object Detection:
     *    `score_threshold` - (float) When Model detects objects on the image,
     *        it will only produce bounding boxes which have at least this
     *        confidence score. Value in 0 to 1 range, default is 0.5.
     *    `max_bounding_box_count` - (int64) No more than this number of bounding
     *        boxes will be produced per image. Default is 100, the
     *        requested value may be limited by server.
     * *  For Video Classification :
     *    `score_threshold` - (float) A value from 0.0 to 1.0. When the model
     *        makes predictions for a video, it will only produce results that
     *        have at least this confidence score. The default is 0.5.
     *    `segment_classification` - (boolean) Set to true to request
     *        segment-level classification. AutoML Video Intelligence returns
     *        labels and their confidence scores for the entire segment of the
     *        video that user specified in the request configuration.
     *        The default is "true".
     *    `shot_classification` - (boolean) Set to true to request shot-level
     *        classification. AutoML Video Intelligence determines the boundaries
     *        for each camera shot in the entire segment of the video that user
     *        specified in the request configuration. AutoML Video Intelligence
     *        then returns labels and their confidence scores for each detected
     *        shot, along with the start and end time of the shot.
     *        WARNING: Model evaluation is not done for this classification type,
     *        the quality of it depends on training data, but there are no metrics
     *        provided to describe that quality. The default is "false".
     *    `1s_interval_classification` - (boolean) Set to true to request
     *        classification for a video at one-second intervals. AutoML Video
     *        Intelligence returns labels and their confidence scores for each
     *        second of the entire segment of the video that user specified in the
     *        request configuration.
     *        WARNING: Model evaluation is not done for this classification
     *        type, the quality of it depends on training data, but there are no
     *        metrics provided to describe that quality. The default is
     *        "false".
     * *  For Tables:
     *    feature_imp&lt;span&gt;ortan&lt;/span&gt;ce - (boolean) Whether feature importance
     *        should be populated in the returned TablesAnnotations. The
     *        default is false.
     * *  For Video Object Tracking:
     *    `score_threshold` - (float) When Model detects objects on video frames,
     *        it will only produce bounding boxes which have at least this
     *        confidence score. Value in 0 to 1 range, default is 0.5.
     *    `max_bounding_box_count` - (int64) No more than this number of bounding
     *        boxes will be returned per frame. Default is 100, the requested
     *        value may be limited by server.
     *    `min_bounding_box_size` - (float) Only bounding boxes with shortest edge
     *      at least that long as a relative value of video frame size will be
     *      returned. Value in 0 to 1 range. Default is 0.
     * </pre>
     *
     * <code>map&lt;string, string&gt; params = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public boolean containsParams(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      return internalGetParams().getMap().containsKey(key);
    }
    /** Use {@link #getParamsMap()} instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getParams() {
      return getParamsMap();
    }
    /**
     *
     *
     * <pre>
     * Required. Additional domain-specific parameters for the predictions, any string must
     * be up to 25000 characters long.
     * *  For Text Classification:
     *    `score_threshold` - (float) A value from 0.0 to 1.0. When the model
     *         makes predictions for a text snippet, it will only produce results
     *         that have at least this confidence score. The default is 0.5.
     * *  For Image Classification:
     *    `score_threshold` - (float) A value from 0.0 to 1.0. When the model
     *         makes predictions for an image, it will only produce results that
     *         have at least this confidence score. The default is 0.5.
     * *  For Image Object Detection:
     *    `score_threshold` - (float) When Model detects objects on the image,
     *        it will only produce bounding boxes which have at least this
     *        confidence score. Value in 0 to 1 range, default is 0.5.
     *    `max_bounding_box_count` - (int64) No more than this number of bounding
     *        boxes will be produced per image. Default is 100, the
     *        requested value may be limited by server.
     * *  For Video Classification :
     *    `score_threshold` - (float) A value from 0.0 to 1.0. When the model
     *        makes predictions for a video, it will only produce results that
     *        have at least this confidence score. The default is 0.5.
     *    `segment_classification` - (boolean) Set to true to request
     *        segment-level classification. AutoML Video Intelligence returns
     *        labels and their confidence scores for the entire segment of the
     *        video that user specified in the request configuration.
     *        The default is "true".
     *    `shot_classification` - (boolean) Set to true to request shot-level
     *        classification. AutoML Video Intelligence determines the boundaries
     *        for each camera shot in the entire segment of the video that user
     *        specified in the request configuration. AutoML Video Intelligence
     *        then returns labels and their confidence scores for each detected
     *        shot, along with the start and end time of the shot.
     *        WARNING: Model evaluation is not done for this classification type,
     *        the quality of it depends on training data, but there are no metrics
     *        provided to describe that quality. The default is "false".
     *    `1s_interval_classification` - (boolean) Set to true to request
     *        classification for a video at one-second intervals. AutoML Video
     *        Intelligence returns labels and their confidence scores for each
     *        second of the entire segment of the video that user specified in the
     *        request configuration.
     *        WARNING: Model evaluation is not done for this classification
     *        type, the quality of it depends on training data, but there are no
     *        metrics provided to describe that quality. The default is
     *        "false".
     * *  For Tables:
     *    feature_imp&lt;span&gt;ortan&lt;/span&gt;ce - (boolean) Whether feature importance
     *        should be populated in the returned TablesAnnotations. The
     *        default is false.
     * *  For Video Object Tracking:
     *    `score_threshold` - (float) When Model detects objects on video frames,
     *        it will only produce bounding boxes which have at least this
     *        confidence score. Value in 0 to 1 range, default is 0.5.
     *    `max_bounding_box_count` - (int64) No more than this number of bounding
     *        boxes will be returned per frame. Default is 100, the requested
     *        value may be limited by server.
     *    `min_bounding_box_size` - (float) Only bounding boxes with shortest edge
     *      at least that long as a relative value of video frame size will be
     *      returned. Value in 0 to 1 range. Default is 0.
     * </pre>
     *
     * <code>map&lt;string, string&gt; params = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public java.util.Map<java.lang.String, java.lang.String> getParamsMap() {
      return internalGetParams().getMap();
    }
    /**
     *
     *
     * <pre>
     * Required. Additional domain-specific parameters for the predictions, any string must
     * be up to 25000 characters long.
     * *  For Text Classification:
     *    `score_threshold` - (float) A value from 0.0 to 1.0. When the model
     *         makes predictions for a text snippet, it will only produce results
     *         that have at least this confidence score. The default is 0.5.
     * *  For Image Classification:
     *    `score_threshold` - (float) A value from 0.0 to 1.0. When the model
     *         makes predictions for an image, it will only produce results that
     *         have at least this confidence score. The default is 0.5.
     * *  For Image Object Detection:
     *    `score_threshold` - (float) When Model detects objects on the image,
     *        it will only produce bounding boxes which have at least this
     *        confidence score. Value in 0 to 1 range, default is 0.5.
     *    `max_bounding_box_count` - (int64) No more than this number of bounding
     *        boxes will be produced per image. Default is 100, the
     *        requested value may be limited by server.
     * *  For Video Classification :
     *    `score_threshold` - (float) A value from 0.0 to 1.0. When the model
     *        makes predictions for a video, it will only produce results that
     *        have at least this confidence score. The default is 0.5.
     *    `segment_classification` - (boolean) Set to true to request
     *        segment-level classification. AutoML Video Intelligence returns
     *        labels and their confidence scores for the entire segment of the
     *        video that user specified in the request configuration.
     *        The default is "true".
     *    `shot_classification` - (boolean) Set to true to request shot-level
     *        classification. AutoML Video Intelligence determines the boundaries
     *        for each camera shot in the entire segment of the video that user
     *        specified in the request configuration. AutoML Video Intelligence
     *        then returns labels and their confidence scores for each detected
     *        shot, along with the start and end time of the shot.
     *        WARNING: Model evaluation is not done for this classification type,
     *        the quality of it depends on training data, but there are no metrics
     *        provided to describe that quality. The default is "false".
     *    `1s_interval_classification` - (boolean) Set to true to request
     *        classification for a video at one-second intervals. AutoML Video
     *        Intelligence returns labels and their confidence scores for each
     *        second of the entire segment of the video that user specified in the
     *        request configuration.
     *        WARNING: Model evaluation is not done for this classification
     *        type, the quality of it depends on training data, but there are no
     *        metrics provided to describe that quality. The default is
     *        "false".
     * *  For Tables:
     *    feature_imp&lt;span&gt;ortan&lt;/span&gt;ce - (boolean) Whether feature importance
     *        should be populated in the returned TablesAnnotations. The
     *        default is false.
     * *  For Video Object Tracking:
     *    `score_threshold` - (float) When Model detects objects on video frames,
     *        it will only produce bounding boxes which have at least this
     *        confidence score. Value in 0 to 1 range, default is 0.5.
     *    `max_bounding_box_count` - (int64) No more than this number of bounding
     *        boxes will be returned per frame. Default is 100, the requested
     *        value may be limited by server.
     *    `min_bounding_box_size` - (float) Only bounding boxes with shortest edge
     *      at least that long as a relative value of video frame size will be
     *      returned. Value in 0 to 1 range. Default is 0.
     * </pre>
     *
     * <code>map&lt;string, string&gt; params = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public java.lang.String getParamsOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetParams().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Required. Additional domain-specific parameters for the predictions, any string must
     * be up to 25000 characters long.
     * *  For Text Classification:
     *    `score_threshold` - (float) A value from 0.0 to 1.0. When the model
     *         makes predictions for a text snippet, it will only produce results
     *         that have at least this confidence score. The default is 0.5.
     * *  For Image Classification:
     *    `score_threshold` - (float) A value from 0.0 to 1.0. When the model
     *         makes predictions for an image, it will only produce results that
     *         have at least this confidence score. The default is 0.5.
     * *  For Image Object Detection:
     *    `score_threshold` - (float) When Model detects objects on the image,
     *        it will only produce bounding boxes which have at least this
     *        confidence score. Value in 0 to 1 range, default is 0.5.
     *    `max_bounding_box_count` - (int64) No more than this number of bounding
     *        boxes will be produced per image. Default is 100, the
     *        requested value may be limited by server.
     * *  For Video Classification :
     *    `score_threshold` - (float) A value from 0.0 to 1.0. When the model
     *        makes predictions for a video, it will only produce results that
     *        have at least this confidence score. The default is 0.5.
     *    `segment_classification` - (boolean) Set to true to request
     *        segment-level classification. AutoML Video Intelligence returns
     *        labels and their confidence scores for the entire segment of the
     *        video that user specified in the request configuration.
     *        The default is "true".
     *    `shot_classification` - (boolean) Set to true to request shot-level
     *        classification. AutoML Video Intelligence determines the boundaries
     *        for each camera shot in the entire segment of the video that user
     *        specified in the request configuration. AutoML Video Intelligence
     *        then returns labels and their confidence scores for each detected
     *        shot, along with the start and end time of the shot.
     *        WARNING: Model evaluation is not done for this classification type,
     *        the quality of it depends on training data, but there are no metrics
     *        provided to describe that quality. The default is "false".
     *    `1s_interval_classification` - (boolean) Set to true to request
     *        classification for a video at one-second intervals. AutoML Video
     *        Intelligence returns labels and their confidence scores for each
     *        second of the entire segment of the video that user specified in the
     *        request configuration.
     *        WARNING: Model evaluation is not done for this classification
     *        type, the quality of it depends on training data, but there are no
     *        metrics provided to describe that quality. The default is
     *        "false".
     * *  For Tables:
     *    feature_imp&lt;span&gt;ortan&lt;/span&gt;ce - (boolean) Whether feature importance
     *        should be populated in the returned TablesAnnotations. The
     *        default is false.
     * *  For Video Object Tracking:
     *    `score_threshold` - (float) When Model detects objects on video frames,
     *        it will only produce bounding boxes which have at least this
     *        confidence score. Value in 0 to 1 range, default is 0.5.
     *    `max_bounding_box_count` - (int64) No more than this number of bounding
     *        boxes will be returned per frame. Default is 100, the requested
     *        value may be limited by server.
     *    `min_bounding_box_size` - (float) Only bounding boxes with shortest edge
     *      at least that long as a relative value of video frame size will be
     *      returned. Value in 0 to 1 range. Default is 0.
     * </pre>
     *
     * <code>map&lt;string, string&gt; params = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public java.lang.String getParamsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetParams().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearParams() {
      internalGetMutableParams().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Additional domain-specific parameters for the predictions, any string must
     * be up to 25000 characters long.
     * *  For Text Classification:
     *    `score_threshold` - (float) A value from 0.0 to 1.0. When the model
     *         makes predictions for a text snippet, it will only produce results
     *         that have at least this confidence score. The default is 0.5.
     * *  For Image Classification:
     *    `score_threshold` - (float) A value from 0.0 to 1.0. When the model
     *         makes predictions for an image, it will only produce results that
     *         have at least this confidence score. The default is 0.5.
     * *  For Image Object Detection:
     *    `score_threshold` - (float) When Model detects objects on the image,
     *        it will only produce bounding boxes which have at least this
     *        confidence score. Value in 0 to 1 range, default is 0.5.
     *    `max_bounding_box_count` - (int64) No more than this number of bounding
     *        boxes will be produced per image. Default is 100, the
     *        requested value may be limited by server.
     * *  For Video Classification :
     *    `score_threshold` - (float) A value from 0.0 to 1.0. When the model
     *        makes predictions for a video, it will only produce results that
     *        have at least this confidence score. The default is 0.5.
     *    `segment_classification` - (boolean) Set to true to request
     *        segment-level classification. AutoML Video Intelligence returns
     *        labels and their confidence scores for the entire segment of the
     *        video that user specified in the request configuration.
     *        The default is "true".
     *    `shot_classification` - (boolean) Set to true to request shot-level
     *        classification. AutoML Video Intelligence determines the boundaries
     *        for each camera shot in the entire segment of the video that user
     *        specified in the request configuration. AutoML Video Intelligence
     *        then returns labels and their confidence scores for each detected
     *        shot, along with the start and end time of the shot.
     *        WARNING: Model evaluation is not done for this classification type,
     *        the quality of it depends on training data, but there are no metrics
     *        provided to describe that quality. The default is "false".
     *    `1s_interval_classification` - (boolean) Set to true to request
     *        classification for a video at one-second intervals. AutoML Video
     *        Intelligence returns labels and their confidence scores for each
     *        second of the entire segment of the video that user specified in the
     *        request configuration.
     *        WARNING: Model evaluation is not done for this classification
     *        type, the quality of it depends on training data, but there are no
     *        metrics provided to describe that quality. The default is
     *        "false".
     * *  For Tables:
     *    feature_imp&lt;span&gt;ortan&lt;/span&gt;ce - (boolean) Whether feature importance
     *        should be populated in the returned TablesAnnotations. The
     *        default is false.
     * *  For Video Object Tracking:
     *    `score_threshold` - (float) When Model detects objects on video frames,
     *        it will only produce bounding boxes which have at least this
     *        confidence score. Value in 0 to 1 range, default is 0.5.
     *    `max_bounding_box_count` - (int64) No more than this number of bounding
     *        boxes will be returned per frame. Default is 100, the requested
     *        value may be limited by server.
     *    `min_bounding_box_size` - (float) Only bounding boxes with shortest edge
     *      at least that long as a relative value of video frame size will be
     *      returned. Value in 0 to 1 range. Default is 0.
     * </pre>
     *
     * <code>map&lt;string, string&gt; params = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder removeParams(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableParams().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableParams() {
      return internalGetMutableParams().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Required. Additional domain-specific parameters for the predictions, any string must
     * be up to 25000 characters long.
     * *  For Text Classification:
     *    `score_threshold` - (float) A value from 0.0 to 1.0. When the model
     *         makes predictions for a text snippet, it will only produce results
     *         that have at least this confidence score. The default is 0.5.
     * *  For Image Classification:
     *    `score_threshold` - (float) A value from 0.0 to 1.0. When the model
     *         makes predictions for an image, it will only produce results that
     *         have at least this confidence score. The default is 0.5.
     * *  For Image Object Detection:
     *    `score_threshold` - (float) When Model detects objects on the image,
     *        it will only produce bounding boxes which have at least this
     *        confidence score. Value in 0 to 1 range, default is 0.5.
     *    `max_bounding_box_count` - (int64) No more than this number of bounding
     *        boxes will be produced per image. Default is 100, the
     *        requested value may be limited by server.
     * *  For Video Classification :
     *    `score_threshold` - (float) A value from 0.0 to 1.0. When the model
     *        makes predictions for a video, it will only produce results that
     *        have at least this confidence score. The default is 0.5.
     *    `segment_classification` - (boolean) Set to true to request
     *        segment-level classification. AutoML Video Intelligence returns
     *        labels and their confidence scores for the entire segment of the
     *        video that user specified in the request configuration.
     *        The default is "true".
     *    `shot_classification` - (boolean) Set to true to request shot-level
     *        classification. AutoML Video Intelligence determines the boundaries
     *        for each camera shot in the entire segment of the video that user
     *        specified in the request configuration. AutoML Video Intelligence
     *        then returns labels and their confidence scores for each detected
     *        shot, along with the start and end time of the shot.
     *        WARNING: Model evaluation is not done for this classification type,
     *        the quality of it depends on training data, but there are no metrics
     *        provided to describe that quality. The default is "false".
     *    `1s_interval_classification` - (boolean) Set to true to request
     *        classification for a video at one-second intervals. AutoML Video
     *        Intelligence returns labels and their confidence scores for each
     *        second of the entire segment of the video that user specified in the
     *        request configuration.
     *        WARNING: Model evaluation is not done for this classification
     *        type, the quality of it depends on training data, but there are no
     *        metrics provided to describe that quality. The default is
     *        "false".
     * *  For Tables:
     *    feature_imp&lt;span&gt;ortan&lt;/span&gt;ce - (boolean) Whether feature importance
     *        should be populated in the returned TablesAnnotations. The
     *        default is false.
     * *  For Video Object Tracking:
     *    `score_threshold` - (float) When Model detects objects on video frames,
     *        it will only produce bounding boxes which have at least this
     *        confidence score. Value in 0 to 1 range, default is 0.5.
     *    `max_bounding_box_count` - (int64) No more than this number of bounding
     *        boxes will be returned per frame. Default is 100, the requested
     *        value may be limited by server.
     *    `min_bounding_box_size` - (float) Only bounding boxes with shortest edge
     *      at least that long as a relative value of video frame size will be
     *      returned. Value in 0 to 1 range. Default is 0.
     * </pre>
     *
     * <code>map&lt;string, string&gt; params = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder putParams(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      if (value == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableParams().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Additional domain-specific parameters for the predictions, any string must
     * be up to 25000 characters long.
     * *  For Text Classification:
     *    `score_threshold` - (float) A value from 0.0 to 1.0. When the model
     *         makes predictions for a text snippet, it will only produce results
     *         that have at least this confidence score. The default is 0.5.
     * *  For Image Classification:
     *    `score_threshold` - (float) A value from 0.0 to 1.0. When the model
     *         makes predictions for an image, it will only produce results that
     *         have at least this confidence score. The default is 0.5.
     * *  For Image Object Detection:
     *    `score_threshold` - (float) When Model detects objects on the image,
     *        it will only produce bounding boxes which have at least this
     *        confidence score. Value in 0 to 1 range, default is 0.5.
     *    `max_bounding_box_count` - (int64) No more than this number of bounding
     *        boxes will be produced per image. Default is 100, the
     *        requested value may be limited by server.
     * *  For Video Classification :
     *    `score_threshold` - (float) A value from 0.0 to 1.0. When the model
     *        makes predictions for a video, it will only produce results that
     *        have at least this confidence score. The default is 0.5.
     *    `segment_classification` - (boolean) Set to true to request
     *        segment-level classification. AutoML Video Intelligence returns
     *        labels and their confidence scores for the entire segment of the
     *        video that user specified in the request configuration.
     *        The default is "true".
     *    `shot_classification` - (boolean) Set to true to request shot-level
     *        classification. AutoML Video Intelligence determines the boundaries
     *        for each camera shot in the entire segment of the video that user
     *        specified in the request configuration. AutoML Video Intelligence
     *        then returns labels and their confidence scores for each detected
     *        shot, along with the start and end time of the shot.
     *        WARNING: Model evaluation is not done for this classification type,
     *        the quality of it depends on training data, but there are no metrics
     *        provided to describe that quality. The default is "false".
     *    `1s_interval_classification` - (boolean) Set to true to request
     *        classification for a video at one-second intervals. AutoML Video
     *        Intelligence returns labels and their confidence scores for each
     *        second of the entire segment of the video that user specified in the
     *        request configuration.
     *        WARNING: Model evaluation is not done for this classification
     *        type, the quality of it depends on training data, but there are no
     *        metrics provided to describe that quality. The default is
     *        "false".
     * *  For Tables:
     *    feature_imp&lt;span&gt;ortan&lt;/span&gt;ce - (boolean) Whether feature importance
     *        should be populated in the returned TablesAnnotations. The
     *        default is false.
     * *  For Video Object Tracking:
     *    `score_threshold` - (float) When Model detects objects on video frames,
     *        it will only produce bounding boxes which have at least this
     *        confidence score. Value in 0 to 1 range, default is 0.5.
     *    `max_bounding_box_count` - (int64) No more than this number of bounding
     *        boxes will be returned per frame. Default is 100, the requested
     *        value may be limited by server.
     *    `min_bounding_box_size` - (float) Only bounding boxes with shortest edge
     *      at least that long as a relative value of video frame size will be
     *      returned. Value in 0 to 1 range. Default is 0.
     * </pre>
     *
     * <code>map&lt;string, string&gt; params = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder putAllParams(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableParams().getMutableMap().putAll(values);
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.automl.v1beta1.BatchPredictRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.automl.v1beta1.BatchPredictRequest)
  private static final com.google.cloud.automl.v1beta1.BatchPredictRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.automl.v1beta1.BatchPredictRequest();
  }

  public static com.google.cloud.automl.v1beta1.BatchPredictRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BatchPredictRequest> PARSER =
      new com.google.protobuf.AbstractParser<BatchPredictRequest>() {
        @java.lang.Override
        public BatchPredictRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new BatchPredictRequest(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<BatchPredictRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BatchPredictRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.automl.v1beta1.BatchPredictRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
