/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/automl/v1beta1/tables.proto

package com.google.cloud.automl.v1beta1;

/**
 *
 *
 * <pre>
 * Contains annotation details specific to Tables.
 * </pre>
 *
 * Protobuf type {@code google.cloud.automl.v1beta1.TablesAnnotation}
 */
public final class TablesAnnotation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.automl.v1beta1.TablesAnnotation)
    TablesAnnotationOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TablesAnnotation.newBuilder() to construct.
  private TablesAnnotation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TablesAnnotation() {
    tablesModelColumnInfo_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TablesAnnotation();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private TablesAnnotation(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 13:
            {
              score_ = input.readFloat();
              break;
            }
          case 18:
            {
              com.google.protobuf.Value.Builder subBuilder = null;
              if (value_ != null) {
                subBuilder = value_.toBuilder();
              }
              value_ = input.readMessage(com.google.protobuf.Value.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(value_);
                value_ = subBuilder.buildPartial();
              }

              break;
            }
          case 26:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                tablesModelColumnInfo_ =
                    new java.util.ArrayList<
                        com.google.cloud.automl.v1beta1.TablesModelColumnInfo>();
                mutable_bitField0_ |= 0x00000001;
              }
              tablesModelColumnInfo_.add(
                  input.readMessage(
                      com.google.cloud.automl.v1beta1.TablesModelColumnInfo.parser(),
                      extensionRegistry));
              break;
            }
          case 34:
            {
              com.google.cloud.automl.v1beta1.DoubleRange.Builder subBuilder = null;
              if (predictionInterval_ != null) {
                subBuilder = predictionInterval_.toBuilder();
              }
              predictionInterval_ =
                  input.readMessage(
                      com.google.cloud.automl.v1beta1.DoubleRange.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(predictionInterval_);
                predictionInterval_ = subBuilder.buildPartial();
              }

              break;
            }
          case 45:
            {
              baselineScore_ = input.readFloat();
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        tablesModelColumnInfo_ = java.util.Collections.unmodifiableList(tablesModelColumnInfo_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.automl.v1beta1.Tables
        .internal_static_google_cloud_automl_v1beta1_TablesAnnotation_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.automl.v1beta1.Tables
        .internal_static_google_cloud_automl_v1beta1_TablesAnnotation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.automl.v1beta1.TablesAnnotation.class,
            com.google.cloud.automl.v1beta1.TablesAnnotation.Builder.class);
  }

  public static final int SCORE_FIELD_NUMBER = 1;
  private float score_;
  /**
   *
   *
   * <pre>
   * Output only. A confidence estimate between 0.0 and 1.0, inclusive. A higher
   * value means greater confidence in the returned value.
   * For
   * [target_column_spec][google.cloud.automl.v1beta1.TablesModelMetadata.target_column_spec]
   * of FLOAT64 data type the score is not populated.
   * </pre>
   *
   * <code>float score = 1;</code>
   *
   * @return The score.
   */
  public float getScore() {
    return score_;
  }

  public static final int PREDICTION_INTERVAL_FIELD_NUMBER = 4;
  private com.google.cloud.automl.v1beta1.DoubleRange predictionInterval_;
  /**
   *
   *
   * <pre>
   * Output only. Only populated when
   * [target_column_spec][google.cloud.automl.v1beta1.TablesModelMetadata.target_column_spec]
   * has FLOAT64 data type. An interval in which the exactly correct target
   * value has 95% chance to be in.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.DoubleRange prediction_interval = 4;</code>
   *
   * @return Whether the predictionInterval field is set.
   */
  public boolean hasPredictionInterval() {
    return predictionInterval_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Only populated when
   * [target_column_spec][google.cloud.automl.v1beta1.TablesModelMetadata.target_column_spec]
   * has FLOAT64 data type. An interval in which the exactly correct target
   * value has 95% chance to be in.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.DoubleRange prediction_interval = 4;</code>
   *
   * @return The predictionInterval.
   */
  public com.google.cloud.automl.v1beta1.DoubleRange getPredictionInterval() {
    return predictionInterval_ == null
        ? com.google.cloud.automl.v1beta1.DoubleRange.getDefaultInstance()
        : predictionInterval_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Only populated when
   * [target_column_spec][google.cloud.automl.v1beta1.TablesModelMetadata.target_column_spec]
   * has FLOAT64 data type. An interval in which the exactly correct target
   * value has 95% chance to be in.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.DoubleRange prediction_interval = 4;</code>
   */
  public com.google.cloud.automl.v1beta1.DoubleRangeOrBuilder getPredictionIntervalOrBuilder() {
    return getPredictionInterval();
  }

  public static final int VALUE_FIELD_NUMBER = 2;
  private com.google.protobuf.Value value_;
  /**
   *
   *
   * <pre>
   * The predicted value of the row's
   * [target_column][google.cloud.automl.v1beta1.TablesModelMetadata.target_column_spec].
   * The value depends on the column's DataType:
   * * CATEGORY - the predicted (with the above confidence `score`) CATEGORY
   *   value.
   * * FLOAT64 - the predicted (with above `prediction_interval`) FLOAT64 value.
   * </pre>
   *
   * <code>.google.protobuf.Value value = 2;</code>
   *
   * @return Whether the value field is set.
   */
  public boolean hasValue() {
    return value_ != null;
  }
  /**
   *
   *
   * <pre>
   * The predicted value of the row's
   * [target_column][google.cloud.automl.v1beta1.TablesModelMetadata.target_column_spec].
   * The value depends on the column's DataType:
   * * CATEGORY - the predicted (with the above confidence `score`) CATEGORY
   *   value.
   * * FLOAT64 - the predicted (with above `prediction_interval`) FLOAT64 value.
   * </pre>
   *
   * <code>.google.protobuf.Value value = 2;</code>
   *
   * @return The value.
   */
  public com.google.protobuf.Value getValue() {
    return value_ == null ? com.google.protobuf.Value.getDefaultInstance() : value_;
  }
  /**
   *
   *
   * <pre>
   * The predicted value of the row's
   * [target_column][google.cloud.automl.v1beta1.TablesModelMetadata.target_column_spec].
   * The value depends on the column's DataType:
   * * CATEGORY - the predicted (with the above confidence `score`) CATEGORY
   *   value.
   * * FLOAT64 - the predicted (with above `prediction_interval`) FLOAT64 value.
   * </pre>
   *
   * <code>.google.protobuf.Value value = 2;</code>
   */
  public com.google.protobuf.ValueOrBuilder getValueOrBuilder() {
    return getValue();
  }

  public static final int TABLES_MODEL_COLUMN_INFO_FIELD_NUMBER = 3;
  private java.util.List<com.google.cloud.automl.v1beta1.TablesModelColumnInfo>
      tablesModelColumnInfo_;
  /**
   *
   *
   * <pre>
   * Output only. Auxiliary information for each of the model's
   * [input_feature_column_specs][google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs]
   * with respect to this particular prediction.
   * If no other fields than
   * [column_spec_name][google.cloud.automl.v1beta1.TablesModelColumnInfo.column_spec_name]
   * and
   * [column_display_name][google.cloud.automl.v1beta1.TablesModelColumnInfo.column_display_name]
   * would be populated, then this whole field is not.
   * </pre>
   *
   * <code>repeated .google.cloud.automl.v1beta1.TablesModelColumnInfo tables_model_column_info = 3;
   * </code>
   */
  public java.util.List<com.google.cloud.automl.v1beta1.TablesModelColumnInfo>
      getTablesModelColumnInfoList() {
    return tablesModelColumnInfo_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Auxiliary information for each of the model's
   * [input_feature_column_specs][google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs]
   * with respect to this particular prediction.
   * If no other fields than
   * [column_spec_name][google.cloud.automl.v1beta1.TablesModelColumnInfo.column_spec_name]
   * and
   * [column_display_name][google.cloud.automl.v1beta1.TablesModelColumnInfo.column_display_name]
   * would be populated, then this whole field is not.
   * </pre>
   *
   * <code>repeated .google.cloud.automl.v1beta1.TablesModelColumnInfo tables_model_column_info = 3;
   * </code>
   */
  public java.util.List<? extends com.google.cloud.automl.v1beta1.TablesModelColumnInfoOrBuilder>
      getTablesModelColumnInfoOrBuilderList() {
    return tablesModelColumnInfo_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Auxiliary information for each of the model's
   * [input_feature_column_specs][google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs]
   * with respect to this particular prediction.
   * If no other fields than
   * [column_spec_name][google.cloud.automl.v1beta1.TablesModelColumnInfo.column_spec_name]
   * and
   * [column_display_name][google.cloud.automl.v1beta1.TablesModelColumnInfo.column_display_name]
   * would be populated, then this whole field is not.
   * </pre>
   *
   * <code>repeated .google.cloud.automl.v1beta1.TablesModelColumnInfo tables_model_column_info = 3;
   * </code>
   */
  public int getTablesModelColumnInfoCount() {
    return tablesModelColumnInfo_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Auxiliary information for each of the model's
   * [input_feature_column_specs][google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs]
   * with respect to this particular prediction.
   * If no other fields than
   * [column_spec_name][google.cloud.automl.v1beta1.TablesModelColumnInfo.column_spec_name]
   * and
   * [column_display_name][google.cloud.automl.v1beta1.TablesModelColumnInfo.column_display_name]
   * would be populated, then this whole field is not.
   * </pre>
   *
   * <code>repeated .google.cloud.automl.v1beta1.TablesModelColumnInfo tables_model_column_info = 3;
   * </code>
   */
  public com.google.cloud.automl.v1beta1.TablesModelColumnInfo getTablesModelColumnInfo(int index) {
    return tablesModelColumnInfo_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. Auxiliary information for each of the model's
   * [input_feature_column_specs][google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs]
   * with respect to this particular prediction.
   * If no other fields than
   * [column_spec_name][google.cloud.automl.v1beta1.TablesModelColumnInfo.column_spec_name]
   * and
   * [column_display_name][google.cloud.automl.v1beta1.TablesModelColumnInfo.column_display_name]
   * would be populated, then this whole field is not.
   * </pre>
   *
   * <code>repeated .google.cloud.automl.v1beta1.TablesModelColumnInfo tables_model_column_info = 3;
   * </code>
   */
  public com.google.cloud.automl.v1beta1.TablesModelColumnInfoOrBuilder
      getTablesModelColumnInfoOrBuilder(int index) {
    return tablesModelColumnInfo_.get(index);
  }

  public static final int BASELINE_SCORE_FIELD_NUMBER = 5;
  private float baselineScore_;
  /**
   *
   *
   * <pre>
   * Output only. Stores the prediction score for the baseline example, which
   * is defined as the example with all values set to their baseline values.
   * This is used as part of the Sampled Shapley explanation of the model's
   * prediction. This field is populated only when feature importance is
   * requested. For regression models, this holds the baseline prediction for
   * the baseline example. For classification models, this holds the baseline
   * prediction for the baseline example for the argmax class.
   * </pre>
   *
   * <code>float baseline_score = 5;</code>
   *
   * @return The baselineScore.
   */
  public float getBaselineScore() {
    return baselineScore_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (score_ != 0F) {
      output.writeFloat(1, score_);
    }
    if (value_ != null) {
      output.writeMessage(2, getValue());
    }
    for (int i = 0; i < tablesModelColumnInfo_.size(); i++) {
      output.writeMessage(3, tablesModelColumnInfo_.get(i));
    }
    if (predictionInterval_ != null) {
      output.writeMessage(4, getPredictionInterval());
    }
    if (baselineScore_ != 0F) {
      output.writeFloat(5, baselineScore_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (score_ != 0F) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(1, score_);
    }
    if (value_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getValue());
    }
    for (int i = 0; i < tablesModelColumnInfo_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, tablesModelColumnInfo_.get(i));
    }
    if (predictionInterval_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getPredictionInterval());
    }
    if (baselineScore_ != 0F) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(5, baselineScore_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.automl.v1beta1.TablesAnnotation)) {
      return super.equals(obj);
    }
    com.google.cloud.automl.v1beta1.TablesAnnotation other =
        (com.google.cloud.automl.v1beta1.TablesAnnotation) obj;

    if (java.lang.Float.floatToIntBits(getScore())
        != java.lang.Float.floatToIntBits(other.getScore())) return false;
    if (hasPredictionInterval() != other.hasPredictionInterval()) return false;
    if (hasPredictionInterval()) {
      if (!getPredictionInterval().equals(other.getPredictionInterval())) return false;
    }
    if (hasValue() != other.hasValue()) return false;
    if (hasValue()) {
      if (!getValue().equals(other.getValue())) return false;
    }
    if (!getTablesModelColumnInfoList().equals(other.getTablesModelColumnInfoList())) return false;
    if (java.lang.Float.floatToIntBits(getBaselineScore())
        != java.lang.Float.floatToIntBits(other.getBaselineScore())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SCORE_FIELD_NUMBER;
    hash = (53 * hash) + java.lang.Float.floatToIntBits(getScore());
    if (hasPredictionInterval()) {
      hash = (37 * hash) + PREDICTION_INTERVAL_FIELD_NUMBER;
      hash = (53 * hash) + getPredictionInterval().hashCode();
    }
    if (hasValue()) {
      hash = (37 * hash) + VALUE_FIELD_NUMBER;
      hash = (53 * hash) + getValue().hashCode();
    }
    if (getTablesModelColumnInfoCount() > 0) {
      hash = (37 * hash) + TABLES_MODEL_COLUMN_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getTablesModelColumnInfoList().hashCode();
    }
    hash = (37 * hash) + BASELINE_SCORE_FIELD_NUMBER;
    hash = (53 * hash) + java.lang.Float.floatToIntBits(getBaselineScore());
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.automl.v1beta1.TablesAnnotation parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1beta1.TablesAnnotation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.TablesAnnotation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1beta1.TablesAnnotation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.TablesAnnotation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1beta1.TablesAnnotation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.TablesAnnotation parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1beta1.TablesAnnotation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.TablesAnnotation parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1beta1.TablesAnnotation parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.TablesAnnotation parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1beta1.TablesAnnotation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.automl.v1beta1.TablesAnnotation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Contains annotation details specific to Tables.
   * </pre>
   *
   * Protobuf type {@code google.cloud.automl.v1beta1.TablesAnnotation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.automl.v1beta1.TablesAnnotation)
      com.google.cloud.automl.v1beta1.TablesAnnotationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.automl.v1beta1.Tables
          .internal_static_google_cloud_automl_v1beta1_TablesAnnotation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.automl.v1beta1.Tables
          .internal_static_google_cloud_automl_v1beta1_TablesAnnotation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.automl.v1beta1.TablesAnnotation.class,
              com.google.cloud.automl.v1beta1.TablesAnnotation.Builder.class);
    }

    // Construct using com.google.cloud.automl.v1beta1.TablesAnnotation.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getTablesModelColumnInfoFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      score_ = 0F;

      if (predictionIntervalBuilder_ == null) {
        predictionInterval_ = null;
      } else {
        predictionInterval_ = null;
        predictionIntervalBuilder_ = null;
      }
      if (valueBuilder_ == null) {
        value_ = null;
      } else {
        value_ = null;
        valueBuilder_ = null;
      }
      if (tablesModelColumnInfoBuilder_ == null) {
        tablesModelColumnInfo_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        tablesModelColumnInfoBuilder_.clear();
      }
      baselineScore_ = 0F;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.automl.v1beta1.Tables
          .internal_static_google_cloud_automl_v1beta1_TablesAnnotation_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.TablesAnnotation getDefaultInstanceForType() {
      return com.google.cloud.automl.v1beta1.TablesAnnotation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.TablesAnnotation build() {
      com.google.cloud.automl.v1beta1.TablesAnnotation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.TablesAnnotation buildPartial() {
      com.google.cloud.automl.v1beta1.TablesAnnotation result =
          new com.google.cloud.automl.v1beta1.TablesAnnotation(this);
      int from_bitField0_ = bitField0_;
      result.score_ = score_;
      if (predictionIntervalBuilder_ == null) {
        result.predictionInterval_ = predictionInterval_;
      } else {
        result.predictionInterval_ = predictionIntervalBuilder_.build();
      }
      if (valueBuilder_ == null) {
        result.value_ = value_;
      } else {
        result.value_ = valueBuilder_.build();
      }
      if (tablesModelColumnInfoBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          tablesModelColumnInfo_ = java.util.Collections.unmodifiableList(tablesModelColumnInfo_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.tablesModelColumnInfo_ = tablesModelColumnInfo_;
      } else {
        result.tablesModelColumnInfo_ = tablesModelColumnInfoBuilder_.build();
      }
      result.baselineScore_ = baselineScore_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.automl.v1beta1.TablesAnnotation) {
        return mergeFrom((com.google.cloud.automl.v1beta1.TablesAnnotation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.automl.v1beta1.TablesAnnotation other) {
      if (other == com.google.cloud.automl.v1beta1.TablesAnnotation.getDefaultInstance())
        return this;
      if (other.getScore() != 0F) {
        setScore(other.getScore());
      }
      if (other.hasPredictionInterval()) {
        mergePredictionInterval(other.getPredictionInterval());
      }
      if (other.hasValue()) {
        mergeValue(other.getValue());
      }
      if (tablesModelColumnInfoBuilder_ == null) {
        if (!other.tablesModelColumnInfo_.isEmpty()) {
          if (tablesModelColumnInfo_.isEmpty()) {
            tablesModelColumnInfo_ = other.tablesModelColumnInfo_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureTablesModelColumnInfoIsMutable();
            tablesModelColumnInfo_.addAll(other.tablesModelColumnInfo_);
          }
          onChanged();
        }
      } else {
        if (!other.tablesModelColumnInfo_.isEmpty()) {
          if (tablesModelColumnInfoBuilder_.isEmpty()) {
            tablesModelColumnInfoBuilder_.dispose();
            tablesModelColumnInfoBuilder_ = null;
            tablesModelColumnInfo_ = other.tablesModelColumnInfo_;
            bitField0_ = (bitField0_ & ~0x00000001);
            tablesModelColumnInfoBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getTablesModelColumnInfoFieldBuilder()
                    : null;
          } else {
            tablesModelColumnInfoBuilder_.addAllMessages(other.tablesModelColumnInfo_);
          }
        }
      }
      if (other.getBaselineScore() != 0F) {
        setBaselineScore(other.getBaselineScore());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.automl.v1beta1.TablesAnnotation parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloud.automl.v1beta1.TablesAnnotation) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private float score_;
    /**
     *
     *
     * <pre>
     * Output only. A confidence estimate between 0.0 and 1.0, inclusive. A higher
     * value means greater confidence in the returned value.
     * For
     * [target_column_spec][google.cloud.automl.v1beta1.TablesModelMetadata.target_column_spec]
     * of FLOAT64 data type the score is not populated.
     * </pre>
     *
     * <code>float score = 1;</code>
     *
     * @return The score.
     */
    public float getScore() {
      return score_;
    }
    /**
     *
     *
     * <pre>
     * Output only. A confidence estimate between 0.0 and 1.0, inclusive. A higher
     * value means greater confidence in the returned value.
     * For
     * [target_column_spec][google.cloud.automl.v1beta1.TablesModelMetadata.target_column_spec]
     * of FLOAT64 data type the score is not populated.
     * </pre>
     *
     * <code>float score = 1;</code>
     *
     * @param value The score to set.
     * @return This builder for chaining.
     */
    public Builder setScore(float value) {

      score_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A confidence estimate between 0.0 and 1.0, inclusive. A higher
     * value means greater confidence in the returned value.
     * For
     * [target_column_spec][google.cloud.automl.v1beta1.TablesModelMetadata.target_column_spec]
     * of FLOAT64 data type the score is not populated.
     * </pre>
     *
     * <code>float score = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearScore() {

      score_ = 0F;
      onChanged();
      return this;
    }

    private com.google.cloud.automl.v1beta1.DoubleRange predictionInterval_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.DoubleRange,
            com.google.cloud.automl.v1beta1.DoubleRange.Builder,
            com.google.cloud.automl.v1beta1.DoubleRangeOrBuilder>
        predictionIntervalBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Only populated when
     * [target_column_spec][google.cloud.automl.v1beta1.TablesModelMetadata.target_column_spec]
     * has FLOAT64 data type. An interval in which the exactly correct target
     * value has 95% chance to be in.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DoubleRange prediction_interval = 4;</code>
     *
     * @return Whether the predictionInterval field is set.
     */
    public boolean hasPredictionInterval() {
      return predictionIntervalBuilder_ != null || predictionInterval_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Only populated when
     * [target_column_spec][google.cloud.automl.v1beta1.TablesModelMetadata.target_column_spec]
     * has FLOAT64 data type. An interval in which the exactly correct target
     * value has 95% chance to be in.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DoubleRange prediction_interval = 4;</code>
     *
     * @return The predictionInterval.
     */
    public com.google.cloud.automl.v1beta1.DoubleRange getPredictionInterval() {
      if (predictionIntervalBuilder_ == null) {
        return predictionInterval_ == null
            ? com.google.cloud.automl.v1beta1.DoubleRange.getDefaultInstance()
            : predictionInterval_;
      } else {
        return predictionIntervalBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Only populated when
     * [target_column_spec][google.cloud.automl.v1beta1.TablesModelMetadata.target_column_spec]
     * has FLOAT64 data type. An interval in which the exactly correct target
     * value has 95% chance to be in.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DoubleRange prediction_interval = 4;</code>
     */
    public Builder setPredictionInterval(com.google.cloud.automl.v1beta1.DoubleRange value) {
      if (predictionIntervalBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        predictionInterval_ = value;
        onChanged();
      } else {
        predictionIntervalBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Only populated when
     * [target_column_spec][google.cloud.automl.v1beta1.TablesModelMetadata.target_column_spec]
     * has FLOAT64 data type. An interval in which the exactly correct target
     * value has 95% chance to be in.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DoubleRange prediction_interval = 4;</code>
     */
    public Builder setPredictionInterval(
        com.google.cloud.automl.v1beta1.DoubleRange.Builder builderForValue) {
      if (predictionIntervalBuilder_ == null) {
        predictionInterval_ = builderForValue.build();
        onChanged();
      } else {
        predictionIntervalBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Only populated when
     * [target_column_spec][google.cloud.automl.v1beta1.TablesModelMetadata.target_column_spec]
     * has FLOAT64 data type. An interval in which the exactly correct target
     * value has 95% chance to be in.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DoubleRange prediction_interval = 4;</code>
     */
    public Builder mergePredictionInterval(com.google.cloud.automl.v1beta1.DoubleRange value) {
      if (predictionIntervalBuilder_ == null) {
        if (predictionInterval_ != null) {
          predictionInterval_ =
              com.google.cloud.automl.v1beta1.DoubleRange.newBuilder(predictionInterval_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          predictionInterval_ = value;
        }
        onChanged();
      } else {
        predictionIntervalBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Only populated when
     * [target_column_spec][google.cloud.automl.v1beta1.TablesModelMetadata.target_column_spec]
     * has FLOAT64 data type. An interval in which the exactly correct target
     * value has 95% chance to be in.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DoubleRange prediction_interval = 4;</code>
     */
    public Builder clearPredictionInterval() {
      if (predictionIntervalBuilder_ == null) {
        predictionInterval_ = null;
        onChanged();
      } else {
        predictionInterval_ = null;
        predictionIntervalBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Only populated when
     * [target_column_spec][google.cloud.automl.v1beta1.TablesModelMetadata.target_column_spec]
     * has FLOAT64 data type. An interval in which the exactly correct target
     * value has 95% chance to be in.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DoubleRange prediction_interval = 4;</code>
     */
    public com.google.cloud.automl.v1beta1.DoubleRange.Builder getPredictionIntervalBuilder() {

      onChanged();
      return getPredictionIntervalFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Only populated when
     * [target_column_spec][google.cloud.automl.v1beta1.TablesModelMetadata.target_column_spec]
     * has FLOAT64 data type. An interval in which the exactly correct target
     * value has 95% chance to be in.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DoubleRange prediction_interval = 4;</code>
     */
    public com.google.cloud.automl.v1beta1.DoubleRangeOrBuilder getPredictionIntervalOrBuilder() {
      if (predictionIntervalBuilder_ != null) {
        return predictionIntervalBuilder_.getMessageOrBuilder();
      } else {
        return predictionInterval_ == null
            ? com.google.cloud.automl.v1beta1.DoubleRange.getDefaultInstance()
            : predictionInterval_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Only populated when
     * [target_column_spec][google.cloud.automl.v1beta1.TablesModelMetadata.target_column_spec]
     * has FLOAT64 data type. An interval in which the exactly correct target
     * value has 95% chance to be in.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DoubleRange prediction_interval = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.DoubleRange,
            com.google.cloud.automl.v1beta1.DoubleRange.Builder,
            com.google.cloud.automl.v1beta1.DoubleRangeOrBuilder>
        getPredictionIntervalFieldBuilder() {
      if (predictionIntervalBuilder_ == null) {
        predictionIntervalBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.automl.v1beta1.DoubleRange,
                com.google.cloud.automl.v1beta1.DoubleRange.Builder,
                com.google.cloud.automl.v1beta1.DoubleRangeOrBuilder>(
                getPredictionInterval(), getParentForChildren(), isClean());
        predictionInterval_ = null;
      }
      return predictionIntervalBuilder_;
    }

    private com.google.protobuf.Value value_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        valueBuilder_;
    /**
     *
     *
     * <pre>
     * The predicted value of the row's
     * [target_column][google.cloud.automl.v1beta1.TablesModelMetadata.target_column_spec].
     * The value depends on the column's DataType:
     * * CATEGORY - the predicted (with the above confidence `score`) CATEGORY
     *   value.
     * * FLOAT64 - the predicted (with above `prediction_interval`) FLOAT64 value.
     * </pre>
     *
     * <code>.google.protobuf.Value value = 2;</code>
     *
     * @return Whether the value field is set.
     */
    public boolean hasValue() {
      return valueBuilder_ != null || value_ != null;
    }
    /**
     *
     *
     * <pre>
     * The predicted value of the row's
     * [target_column][google.cloud.automl.v1beta1.TablesModelMetadata.target_column_spec].
     * The value depends on the column's DataType:
     * * CATEGORY - the predicted (with the above confidence `score`) CATEGORY
     *   value.
     * * FLOAT64 - the predicted (with above `prediction_interval`) FLOAT64 value.
     * </pre>
     *
     * <code>.google.protobuf.Value value = 2;</code>
     *
     * @return The value.
     */
    public com.google.protobuf.Value getValue() {
      if (valueBuilder_ == null) {
        return value_ == null ? com.google.protobuf.Value.getDefaultInstance() : value_;
      } else {
        return valueBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The predicted value of the row's
     * [target_column][google.cloud.automl.v1beta1.TablesModelMetadata.target_column_spec].
     * The value depends on the column's DataType:
     * * CATEGORY - the predicted (with the above confidence `score`) CATEGORY
     *   value.
     * * FLOAT64 - the predicted (with above `prediction_interval`) FLOAT64 value.
     * </pre>
     *
     * <code>.google.protobuf.Value value = 2;</code>
     */
    public Builder setValue(com.google.protobuf.Value value) {
      if (valueBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        value_ = value;
        onChanged();
      } else {
        valueBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The predicted value of the row's
     * [target_column][google.cloud.automl.v1beta1.TablesModelMetadata.target_column_spec].
     * The value depends on the column's DataType:
     * * CATEGORY - the predicted (with the above confidence `score`) CATEGORY
     *   value.
     * * FLOAT64 - the predicted (with above `prediction_interval`) FLOAT64 value.
     * </pre>
     *
     * <code>.google.protobuf.Value value = 2;</code>
     */
    public Builder setValue(com.google.protobuf.Value.Builder builderForValue) {
      if (valueBuilder_ == null) {
        value_ = builderForValue.build();
        onChanged();
      } else {
        valueBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The predicted value of the row's
     * [target_column][google.cloud.automl.v1beta1.TablesModelMetadata.target_column_spec].
     * The value depends on the column's DataType:
     * * CATEGORY - the predicted (with the above confidence `score`) CATEGORY
     *   value.
     * * FLOAT64 - the predicted (with above `prediction_interval`) FLOAT64 value.
     * </pre>
     *
     * <code>.google.protobuf.Value value = 2;</code>
     */
    public Builder mergeValue(com.google.protobuf.Value value) {
      if (valueBuilder_ == null) {
        if (value_ != null) {
          value_ = com.google.protobuf.Value.newBuilder(value_).mergeFrom(value).buildPartial();
        } else {
          value_ = value;
        }
        onChanged();
      } else {
        valueBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The predicted value of the row's
     * [target_column][google.cloud.automl.v1beta1.TablesModelMetadata.target_column_spec].
     * The value depends on the column's DataType:
     * * CATEGORY - the predicted (with the above confidence `score`) CATEGORY
     *   value.
     * * FLOAT64 - the predicted (with above `prediction_interval`) FLOAT64 value.
     * </pre>
     *
     * <code>.google.protobuf.Value value = 2;</code>
     */
    public Builder clearValue() {
      if (valueBuilder_ == null) {
        value_ = null;
        onChanged();
      } else {
        value_ = null;
        valueBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The predicted value of the row's
     * [target_column][google.cloud.automl.v1beta1.TablesModelMetadata.target_column_spec].
     * The value depends on the column's DataType:
     * * CATEGORY - the predicted (with the above confidence `score`) CATEGORY
     *   value.
     * * FLOAT64 - the predicted (with above `prediction_interval`) FLOAT64 value.
     * </pre>
     *
     * <code>.google.protobuf.Value value = 2;</code>
     */
    public com.google.protobuf.Value.Builder getValueBuilder() {

      onChanged();
      return getValueFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The predicted value of the row's
     * [target_column][google.cloud.automl.v1beta1.TablesModelMetadata.target_column_spec].
     * The value depends on the column's DataType:
     * * CATEGORY - the predicted (with the above confidence `score`) CATEGORY
     *   value.
     * * FLOAT64 - the predicted (with above `prediction_interval`) FLOAT64 value.
     * </pre>
     *
     * <code>.google.protobuf.Value value = 2;</code>
     */
    public com.google.protobuf.ValueOrBuilder getValueOrBuilder() {
      if (valueBuilder_ != null) {
        return valueBuilder_.getMessageOrBuilder();
      } else {
        return value_ == null ? com.google.protobuf.Value.getDefaultInstance() : value_;
      }
    }
    /**
     *
     *
     * <pre>
     * The predicted value of the row's
     * [target_column][google.cloud.automl.v1beta1.TablesModelMetadata.target_column_spec].
     * The value depends on the column's DataType:
     * * CATEGORY - the predicted (with the above confidence `score`) CATEGORY
     *   value.
     * * FLOAT64 - the predicted (with above `prediction_interval`) FLOAT64 value.
     * </pre>
     *
     * <code>.google.protobuf.Value value = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        getValueFieldBuilder() {
      if (valueBuilder_ == null) {
        valueBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Value,
                com.google.protobuf.Value.Builder,
                com.google.protobuf.ValueOrBuilder>(getValue(), getParentForChildren(), isClean());
        value_ = null;
      }
      return valueBuilder_;
    }

    private java.util.List<com.google.cloud.automl.v1beta1.TablesModelColumnInfo>
        tablesModelColumnInfo_ = java.util.Collections.emptyList();

    private void ensureTablesModelColumnInfoIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        tablesModelColumnInfo_ =
            new java.util.ArrayList<com.google.cloud.automl.v1beta1.TablesModelColumnInfo>(
                tablesModelColumnInfo_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.automl.v1beta1.TablesModelColumnInfo,
            com.google.cloud.automl.v1beta1.TablesModelColumnInfo.Builder,
            com.google.cloud.automl.v1beta1.TablesModelColumnInfoOrBuilder>
        tablesModelColumnInfoBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Auxiliary information for each of the model's
     * [input_feature_column_specs][google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs]
     * with respect to this particular prediction.
     * If no other fields than
     * [column_spec_name][google.cloud.automl.v1beta1.TablesModelColumnInfo.column_spec_name]
     * and
     * [column_display_name][google.cloud.automl.v1beta1.TablesModelColumnInfo.column_display_name]
     * would be populated, then this whole field is not.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.TablesModelColumnInfo tables_model_column_info = 3;
     * </code>
     */
    public java.util.List<com.google.cloud.automl.v1beta1.TablesModelColumnInfo>
        getTablesModelColumnInfoList() {
      if (tablesModelColumnInfoBuilder_ == null) {
        return java.util.Collections.unmodifiableList(tablesModelColumnInfo_);
      } else {
        return tablesModelColumnInfoBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Auxiliary information for each of the model's
     * [input_feature_column_specs][google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs]
     * with respect to this particular prediction.
     * If no other fields than
     * [column_spec_name][google.cloud.automl.v1beta1.TablesModelColumnInfo.column_spec_name]
     * and
     * [column_display_name][google.cloud.automl.v1beta1.TablesModelColumnInfo.column_display_name]
     * would be populated, then this whole field is not.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.TablesModelColumnInfo tables_model_column_info = 3;
     * </code>
     */
    public int getTablesModelColumnInfoCount() {
      if (tablesModelColumnInfoBuilder_ == null) {
        return tablesModelColumnInfo_.size();
      } else {
        return tablesModelColumnInfoBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Auxiliary information for each of the model's
     * [input_feature_column_specs][google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs]
     * with respect to this particular prediction.
     * If no other fields than
     * [column_spec_name][google.cloud.automl.v1beta1.TablesModelColumnInfo.column_spec_name]
     * and
     * [column_display_name][google.cloud.automl.v1beta1.TablesModelColumnInfo.column_display_name]
     * would be populated, then this whole field is not.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.TablesModelColumnInfo tables_model_column_info = 3;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.TablesModelColumnInfo getTablesModelColumnInfo(
        int index) {
      if (tablesModelColumnInfoBuilder_ == null) {
        return tablesModelColumnInfo_.get(index);
      } else {
        return tablesModelColumnInfoBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Auxiliary information for each of the model's
     * [input_feature_column_specs][google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs]
     * with respect to this particular prediction.
     * If no other fields than
     * [column_spec_name][google.cloud.automl.v1beta1.TablesModelColumnInfo.column_spec_name]
     * and
     * [column_display_name][google.cloud.automl.v1beta1.TablesModelColumnInfo.column_display_name]
     * would be populated, then this whole field is not.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.TablesModelColumnInfo tables_model_column_info = 3;
     * </code>
     */
    public Builder setTablesModelColumnInfo(
        int index, com.google.cloud.automl.v1beta1.TablesModelColumnInfo value) {
      if (tablesModelColumnInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTablesModelColumnInfoIsMutable();
        tablesModelColumnInfo_.set(index, value);
        onChanged();
      } else {
        tablesModelColumnInfoBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Auxiliary information for each of the model's
     * [input_feature_column_specs][google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs]
     * with respect to this particular prediction.
     * If no other fields than
     * [column_spec_name][google.cloud.automl.v1beta1.TablesModelColumnInfo.column_spec_name]
     * and
     * [column_display_name][google.cloud.automl.v1beta1.TablesModelColumnInfo.column_display_name]
     * would be populated, then this whole field is not.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.TablesModelColumnInfo tables_model_column_info = 3;
     * </code>
     */
    public Builder setTablesModelColumnInfo(
        int index, com.google.cloud.automl.v1beta1.TablesModelColumnInfo.Builder builderForValue) {
      if (tablesModelColumnInfoBuilder_ == null) {
        ensureTablesModelColumnInfoIsMutable();
        tablesModelColumnInfo_.set(index, builderForValue.build());
        onChanged();
      } else {
        tablesModelColumnInfoBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Auxiliary information for each of the model's
     * [input_feature_column_specs][google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs]
     * with respect to this particular prediction.
     * If no other fields than
     * [column_spec_name][google.cloud.automl.v1beta1.TablesModelColumnInfo.column_spec_name]
     * and
     * [column_display_name][google.cloud.automl.v1beta1.TablesModelColumnInfo.column_display_name]
     * would be populated, then this whole field is not.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.TablesModelColumnInfo tables_model_column_info = 3;
     * </code>
     */
    public Builder addTablesModelColumnInfo(
        com.google.cloud.automl.v1beta1.TablesModelColumnInfo value) {
      if (tablesModelColumnInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTablesModelColumnInfoIsMutable();
        tablesModelColumnInfo_.add(value);
        onChanged();
      } else {
        tablesModelColumnInfoBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Auxiliary information for each of the model's
     * [input_feature_column_specs][google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs]
     * with respect to this particular prediction.
     * If no other fields than
     * [column_spec_name][google.cloud.automl.v1beta1.TablesModelColumnInfo.column_spec_name]
     * and
     * [column_display_name][google.cloud.automl.v1beta1.TablesModelColumnInfo.column_display_name]
     * would be populated, then this whole field is not.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.TablesModelColumnInfo tables_model_column_info = 3;
     * </code>
     */
    public Builder addTablesModelColumnInfo(
        int index, com.google.cloud.automl.v1beta1.TablesModelColumnInfo value) {
      if (tablesModelColumnInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTablesModelColumnInfoIsMutable();
        tablesModelColumnInfo_.add(index, value);
        onChanged();
      } else {
        tablesModelColumnInfoBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Auxiliary information for each of the model's
     * [input_feature_column_specs][google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs]
     * with respect to this particular prediction.
     * If no other fields than
     * [column_spec_name][google.cloud.automl.v1beta1.TablesModelColumnInfo.column_spec_name]
     * and
     * [column_display_name][google.cloud.automl.v1beta1.TablesModelColumnInfo.column_display_name]
     * would be populated, then this whole field is not.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.TablesModelColumnInfo tables_model_column_info = 3;
     * </code>
     */
    public Builder addTablesModelColumnInfo(
        com.google.cloud.automl.v1beta1.TablesModelColumnInfo.Builder builderForValue) {
      if (tablesModelColumnInfoBuilder_ == null) {
        ensureTablesModelColumnInfoIsMutable();
        tablesModelColumnInfo_.add(builderForValue.build());
        onChanged();
      } else {
        tablesModelColumnInfoBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Auxiliary information for each of the model's
     * [input_feature_column_specs][google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs]
     * with respect to this particular prediction.
     * If no other fields than
     * [column_spec_name][google.cloud.automl.v1beta1.TablesModelColumnInfo.column_spec_name]
     * and
     * [column_display_name][google.cloud.automl.v1beta1.TablesModelColumnInfo.column_display_name]
     * would be populated, then this whole field is not.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.TablesModelColumnInfo tables_model_column_info = 3;
     * </code>
     */
    public Builder addTablesModelColumnInfo(
        int index, com.google.cloud.automl.v1beta1.TablesModelColumnInfo.Builder builderForValue) {
      if (tablesModelColumnInfoBuilder_ == null) {
        ensureTablesModelColumnInfoIsMutable();
        tablesModelColumnInfo_.add(index, builderForValue.build());
        onChanged();
      } else {
        tablesModelColumnInfoBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Auxiliary information for each of the model's
     * [input_feature_column_specs][google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs]
     * with respect to this particular prediction.
     * If no other fields than
     * [column_spec_name][google.cloud.automl.v1beta1.TablesModelColumnInfo.column_spec_name]
     * and
     * [column_display_name][google.cloud.automl.v1beta1.TablesModelColumnInfo.column_display_name]
     * would be populated, then this whole field is not.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.TablesModelColumnInfo tables_model_column_info = 3;
     * </code>
     */
    public Builder addAllTablesModelColumnInfo(
        java.lang.Iterable<? extends com.google.cloud.automl.v1beta1.TablesModelColumnInfo>
            values) {
      if (tablesModelColumnInfoBuilder_ == null) {
        ensureTablesModelColumnInfoIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, tablesModelColumnInfo_);
        onChanged();
      } else {
        tablesModelColumnInfoBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Auxiliary information for each of the model's
     * [input_feature_column_specs][google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs]
     * with respect to this particular prediction.
     * If no other fields than
     * [column_spec_name][google.cloud.automl.v1beta1.TablesModelColumnInfo.column_spec_name]
     * and
     * [column_display_name][google.cloud.automl.v1beta1.TablesModelColumnInfo.column_display_name]
     * would be populated, then this whole field is not.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.TablesModelColumnInfo tables_model_column_info = 3;
     * </code>
     */
    public Builder clearTablesModelColumnInfo() {
      if (tablesModelColumnInfoBuilder_ == null) {
        tablesModelColumnInfo_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        tablesModelColumnInfoBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Auxiliary information for each of the model's
     * [input_feature_column_specs][google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs]
     * with respect to this particular prediction.
     * If no other fields than
     * [column_spec_name][google.cloud.automl.v1beta1.TablesModelColumnInfo.column_spec_name]
     * and
     * [column_display_name][google.cloud.automl.v1beta1.TablesModelColumnInfo.column_display_name]
     * would be populated, then this whole field is not.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.TablesModelColumnInfo tables_model_column_info = 3;
     * </code>
     */
    public Builder removeTablesModelColumnInfo(int index) {
      if (tablesModelColumnInfoBuilder_ == null) {
        ensureTablesModelColumnInfoIsMutable();
        tablesModelColumnInfo_.remove(index);
        onChanged();
      } else {
        tablesModelColumnInfoBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Auxiliary information for each of the model's
     * [input_feature_column_specs][google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs]
     * with respect to this particular prediction.
     * If no other fields than
     * [column_spec_name][google.cloud.automl.v1beta1.TablesModelColumnInfo.column_spec_name]
     * and
     * [column_display_name][google.cloud.automl.v1beta1.TablesModelColumnInfo.column_display_name]
     * would be populated, then this whole field is not.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.TablesModelColumnInfo tables_model_column_info = 3;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.TablesModelColumnInfo.Builder
        getTablesModelColumnInfoBuilder(int index) {
      return getTablesModelColumnInfoFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Auxiliary information for each of the model's
     * [input_feature_column_specs][google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs]
     * with respect to this particular prediction.
     * If no other fields than
     * [column_spec_name][google.cloud.automl.v1beta1.TablesModelColumnInfo.column_spec_name]
     * and
     * [column_display_name][google.cloud.automl.v1beta1.TablesModelColumnInfo.column_display_name]
     * would be populated, then this whole field is not.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.TablesModelColumnInfo tables_model_column_info = 3;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.TablesModelColumnInfoOrBuilder
        getTablesModelColumnInfoOrBuilder(int index) {
      if (tablesModelColumnInfoBuilder_ == null) {
        return tablesModelColumnInfo_.get(index);
      } else {
        return tablesModelColumnInfoBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Auxiliary information for each of the model's
     * [input_feature_column_specs][google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs]
     * with respect to this particular prediction.
     * If no other fields than
     * [column_spec_name][google.cloud.automl.v1beta1.TablesModelColumnInfo.column_spec_name]
     * and
     * [column_display_name][google.cloud.automl.v1beta1.TablesModelColumnInfo.column_display_name]
     * would be populated, then this whole field is not.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.TablesModelColumnInfo tables_model_column_info = 3;
     * </code>
     */
    public java.util.List<? extends com.google.cloud.automl.v1beta1.TablesModelColumnInfoOrBuilder>
        getTablesModelColumnInfoOrBuilderList() {
      if (tablesModelColumnInfoBuilder_ != null) {
        return tablesModelColumnInfoBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(tablesModelColumnInfo_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Auxiliary information for each of the model's
     * [input_feature_column_specs][google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs]
     * with respect to this particular prediction.
     * If no other fields than
     * [column_spec_name][google.cloud.automl.v1beta1.TablesModelColumnInfo.column_spec_name]
     * and
     * [column_display_name][google.cloud.automl.v1beta1.TablesModelColumnInfo.column_display_name]
     * would be populated, then this whole field is not.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.TablesModelColumnInfo tables_model_column_info = 3;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.TablesModelColumnInfo.Builder
        addTablesModelColumnInfoBuilder() {
      return getTablesModelColumnInfoFieldBuilder()
          .addBuilder(com.google.cloud.automl.v1beta1.TablesModelColumnInfo.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Auxiliary information for each of the model's
     * [input_feature_column_specs][google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs]
     * with respect to this particular prediction.
     * If no other fields than
     * [column_spec_name][google.cloud.automl.v1beta1.TablesModelColumnInfo.column_spec_name]
     * and
     * [column_display_name][google.cloud.automl.v1beta1.TablesModelColumnInfo.column_display_name]
     * would be populated, then this whole field is not.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.TablesModelColumnInfo tables_model_column_info = 3;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.TablesModelColumnInfo.Builder
        addTablesModelColumnInfoBuilder(int index) {
      return getTablesModelColumnInfoFieldBuilder()
          .addBuilder(
              index, com.google.cloud.automl.v1beta1.TablesModelColumnInfo.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Auxiliary information for each of the model's
     * [input_feature_column_specs][google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs]
     * with respect to this particular prediction.
     * If no other fields than
     * [column_spec_name][google.cloud.automl.v1beta1.TablesModelColumnInfo.column_spec_name]
     * and
     * [column_display_name][google.cloud.automl.v1beta1.TablesModelColumnInfo.column_display_name]
     * would be populated, then this whole field is not.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.TablesModelColumnInfo tables_model_column_info = 3;
     * </code>
     */
    public java.util.List<com.google.cloud.automl.v1beta1.TablesModelColumnInfo.Builder>
        getTablesModelColumnInfoBuilderList() {
      return getTablesModelColumnInfoFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.automl.v1beta1.TablesModelColumnInfo,
            com.google.cloud.automl.v1beta1.TablesModelColumnInfo.Builder,
            com.google.cloud.automl.v1beta1.TablesModelColumnInfoOrBuilder>
        getTablesModelColumnInfoFieldBuilder() {
      if (tablesModelColumnInfoBuilder_ == null) {
        tablesModelColumnInfoBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.automl.v1beta1.TablesModelColumnInfo,
                com.google.cloud.automl.v1beta1.TablesModelColumnInfo.Builder,
                com.google.cloud.automl.v1beta1.TablesModelColumnInfoOrBuilder>(
                tablesModelColumnInfo_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        tablesModelColumnInfo_ = null;
      }
      return tablesModelColumnInfoBuilder_;
    }

    private float baselineScore_;
    /**
     *
     *
     * <pre>
     * Output only. Stores the prediction score for the baseline example, which
     * is defined as the example with all values set to their baseline values.
     * This is used as part of the Sampled Shapley explanation of the model's
     * prediction. This field is populated only when feature importance is
     * requested. For regression models, this holds the baseline prediction for
     * the baseline example. For classification models, this holds the baseline
     * prediction for the baseline example for the argmax class.
     * </pre>
     *
     * <code>float baseline_score = 5;</code>
     *
     * @return The baselineScore.
     */
    public float getBaselineScore() {
      return baselineScore_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Stores the prediction score for the baseline example, which
     * is defined as the example with all values set to their baseline values.
     * This is used as part of the Sampled Shapley explanation of the model's
     * prediction. This field is populated only when feature importance is
     * requested. For regression models, this holds the baseline prediction for
     * the baseline example. For classification models, this holds the baseline
     * prediction for the baseline example for the argmax class.
     * </pre>
     *
     * <code>float baseline_score = 5;</code>
     *
     * @param value The baselineScore to set.
     * @return This builder for chaining.
     */
    public Builder setBaselineScore(float value) {

      baselineScore_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Stores the prediction score for the baseline example, which
     * is defined as the example with all values set to their baseline values.
     * This is used as part of the Sampled Shapley explanation of the model's
     * prediction. This field is populated only when feature importance is
     * requested. For regression models, this holds the baseline prediction for
     * the baseline example. For classification models, this holds the baseline
     * prediction for the baseline example for the argmax class.
     * </pre>
     *
     * <code>float baseline_score = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBaselineScore() {

      baselineScore_ = 0F;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.automl.v1beta1.TablesAnnotation)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.automl.v1beta1.TablesAnnotation)
  private static final com.google.cloud.automl.v1beta1.TablesAnnotation DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.automl.v1beta1.TablesAnnotation();
  }

  public static com.google.cloud.automl.v1beta1.TablesAnnotation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TablesAnnotation> PARSER =
      new com.google.protobuf.AbstractParser<TablesAnnotation>() {
        @java.lang.Override
        public TablesAnnotation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new TablesAnnotation(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<TablesAnnotation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TablesAnnotation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.automl.v1beta1.TablesAnnotation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
