/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/automl/v1beta1/data_stats.proto

package com.google.cloud.automl.v1beta1;

/**
 *
 *
 * <pre>
 * The data statistics of a series of TIMESTAMP values.
 * </pre>
 *
 * Protobuf type {@code google.cloud.automl.v1beta1.TimestampStats}
 */
public final class TimestampStats extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.automl.v1beta1.TimestampStats)
    TimestampStatsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TimestampStats.newBuilder() to construct.
  private TimestampStats(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TimestampStats() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TimestampStats();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private TimestampStats(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                granularStats_ =
                    com.google.protobuf.MapField.newMapField(
                        GranularStatsDefaultEntryHolder.defaultEntry);
                mutable_bitField0_ |= 0x00000001;
              }
              com.google.protobuf.MapEntry<
                      java.lang.String,
                      com.google.cloud.automl.v1beta1.TimestampStats.GranularStats>
                  granularStats__ =
                      input.readMessage(
                          GranularStatsDefaultEntryHolder.defaultEntry.getParserForType(),
                          extensionRegistry);
              granularStats_
                  .getMutableMap()
                  .put(granularStats__.getKey(), granularStats__.getValue());
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.automl.v1beta1.DataStatsOuterClass
        .internal_static_google_cloud_automl_v1beta1_TimestampStats_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 1:
        return internalGetGranularStats();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.automl.v1beta1.DataStatsOuterClass
        .internal_static_google_cloud_automl_v1beta1_TimestampStats_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.automl.v1beta1.TimestampStats.class,
            com.google.cloud.automl.v1beta1.TimestampStats.Builder.class);
  }

  public interface GranularStatsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.automl.v1beta1.TimestampStats.GranularStats)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * A map from granularity key to example count for that key.
     * E.g. for hour_of_day `13` means 1pm, or for month_of_year `5` means May).
     * </pre>
     *
     * <code>map&lt;int32, int64&gt; buckets = 1;</code>
     */
    int getBucketsCount();
    /**
     *
     *
     * <pre>
     * A map from granularity key to example count for that key.
     * E.g. for hour_of_day `13` means 1pm, or for month_of_year `5` means May).
     * </pre>
     *
     * <code>map&lt;int32, int64&gt; buckets = 1;</code>
     */
    boolean containsBuckets(int key);
    /** Use {@link #getBucketsMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<java.lang.Integer, java.lang.Long> getBuckets();
    /**
     *
     *
     * <pre>
     * A map from granularity key to example count for that key.
     * E.g. for hour_of_day `13` means 1pm, or for month_of_year `5` means May).
     * </pre>
     *
     * <code>map&lt;int32, int64&gt; buckets = 1;</code>
     */
    java.util.Map<java.lang.Integer, java.lang.Long> getBucketsMap();
    /**
     *
     *
     * <pre>
     * A map from granularity key to example count for that key.
     * E.g. for hour_of_day `13` means 1pm, or for month_of_year `5` means May).
     * </pre>
     *
     * <code>map&lt;int32, int64&gt; buckets = 1;</code>
     */
    long getBucketsOrDefault(int key, long defaultValue);
    /**
     *
     *
     * <pre>
     * A map from granularity key to example count for that key.
     * E.g. for hour_of_day `13` means 1pm, or for month_of_year `5` means May).
     * </pre>
     *
     * <code>map&lt;int32, int64&gt; buckets = 1;</code>
     */
    long getBucketsOrThrow(int key);
  }
  /**
   *
   *
   * <pre>
   * Stats split by a defined in context granularity.
   * </pre>
   *
   * Protobuf type {@code google.cloud.automl.v1beta1.TimestampStats.GranularStats}
   */
  public static final class GranularStats extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.automl.v1beta1.TimestampStats.GranularStats)
      GranularStatsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use GranularStats.newBuilder() to construct.
    private GranularStats(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private GranularStats() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new GranularStats();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private GranularStats(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                  buckets_ =
                      com.google.protobuf.MapField.newMapField(
                          BucketsDefaultEntryHolder.defaultEntry);
                  mutable_bitField0_ |= 0x00000001;
                }
                com.google.protobuf.MapEntry<java.lang.Integer, java.lang.Long> buckets__ =
                    input.readMessage(
                        BucketsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                buckets_.getMutableMap().put(buckets__.getKey(), buckets__.getValue());
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.automl.v1beta1.DataStatsOuterClass
          .internal_static_google_cloud_automl_v1beta1_TimestampStats_GranularStats_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    @java.lang.Override
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 1:
          return internalGetBuckets();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.automl.v1beta1.DataStatsOuterClass
          .internal_static_google_cloud_automl_v1beta1_TimestampStats_GranularStats_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.automl.v1beta1.TimestampStats.GranularStats.class,
              com.google.cloud.automl.v1beta1.TimestampStats.GranularStats.Builder.class);
    }

    public static final int BUCKETS_FIELD_NUMBER = 1;

    private static final class BucketsDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<java.lang.Integer, java.lang.Long> defaultEntry =
          com.google.protobuf.MapEntry.<java.lang.Integer, java.lang.Long>newDefaultInstance(
              com.google.cloud.automl.v1beta1.DataStatsOuterClass
                  .internal_static_google_cloud_automl_v1beta1_TimestampStats_GranularStats_BucketsEntry_descriptor,
              com.google.protobuf.WireFormat.FieldType.INT32,
              0,
              com.google.protobuf.WireFormat.FieldType.INT64,
              0L);
    }

    private com.google.protobuf.MapField<java.lang.Integer, java.lang.Long> buckets_;

    private com.google.protobuf.MapField<java.lang.Integer, java.lang.Long> internalGetBuckets() {
      if (buckets_ == null) {
        return com.google.protobuf.MapField.emptyMapField(BucketsDefaultEntryHolder.defaultEntry);
      }
      return buckets_;
    }

    public int getBucketsCount() {
      return internalGetBuckets().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * A map from granularity key to example count for that key.
     * E.g. for hour_of_day `13` means 1pm, or for month_of_year `5` means May).
     * </pre>
     *
     * <code>map&lt;int32, int64&gt; buckets = 1;</code>
     */
    @java.lang.Override
    public boolean containsBuckets(int key) {

      return internalGetBuckets().getMap().containsKey(key);
    }
    /** Use {@link #getBucketsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.Integer, java.lang.Long> getBuckets() {
      return getBucketsMap();
    }
    /**
     *
     *
     * <pre>
     * A map from granularity key to example count for that key.
     * E.g. for hour_of_day `13` means 1pm, or for month_of_year `5` means May).
     * </pre>
     *
     * <code>map&lt;int32, int64&gt; buckets = 1;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.Integer, java.lang.Long> getBucketsMap() {
      return internalGetBuckets().getMap();
    }
    /**
     *
     *
     * <pre>
     * A map from granularity key to example count for that key.
     * E.g. for hour_of_day `13` means 1pm, or for month_of_year `5` means May).
     * </pre>
     *
     * <code>map&lt;int32, int64&gt; buckets = 1;</code>
     */
    @java.lang.Override
    public long getBucketsOrDefault(int key, long defaultValue) {

      java.util.Map<java.lang.Integer, java.lang.Long> map = internalGetBuckets().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * A map from granularity key to example count for that key.
     * E.g. for hour_of_day `13` means 1pm, or for month_of_year `5` means May).
     * </pre>
     *
     * <code>map&lt;int32, int64&gt; buckets = 1;</code>
     */
    @java.lang.Override
    public long getBucketsOrThrow(int key) {

      java.util.Map<java.lang.Integer, java.lang.Long> map = internalGetBuckets().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      com.google.protobuf.GeneratedMessageV3.serializeIntegerMapTo(
          output, internalGetBuckets(), BucketsDefaultEntryHolder.defaultEntry, 1);
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (java.util.Map.Entry<java.lang.Integer, java.lang.Long> entry :
          internalGetBuckets().getMap().entrySet()) {
        com.google.protobuf.MapEntry<java.lang.Integer, java.lang.Long> buckets__ =
            BucketsDefaultEntryHolder.defaultEntry
                .newBuilderForType()
                .setKey(entry.getKey())
                .setValue(entry.getValue())
                .build();
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, buckets__);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.automl.v1beta1.TimestampStats.GranularStats)) {
        return super.equals(obj);
      }
      com.google.cloud.automl.v1beta1.TimestampStats.GranularStats other =
          (com.google.cloud.automl.v1beta1.TimestampStats.GranularStats) obj;

      if (!internalGetBuckets().equals(other.internalGetBuckets())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (!internalGetBuckets().getMap().isEmpty()) {
        hash = (37 * hash) + BUCKETS_FIELD_NUMBER;
        hash = (53 * hash) + internalGetBuckets().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.automl.v1beta1.TimestampStats.GranularStats parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.automl.v1beta1.TimestampStats.GranularStats parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.automl.v1beta1.TimestampStats.GranularStats parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.automl.v1beta1.TimestampStats.GranularStats parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.automl.v1beta1.TimestampStats.GranularStats parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.automl.v1beta1.TimestampStats.GranularStats parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.automl.v1beta1.TimestampStats.GranularStats parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.automl.v1beta1.TimestampStats.GranularStats parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.automl.v1beta1.TimestampStats.GranularStats parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.automl.v1beta1.TimestampStats.GranularStats parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.automl.v1beta1.TimestampStats.GranularStats parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.automl.v1beta1.TimestampStats.GranularStats parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.automl.v1beta1.TimestampStats.GranularStats prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Stats split by a defined in context granularity.
     * </pre>
     *
     * Protobuf type {@code google.cloud.automl.v1beta1.TimestampStats.GranularStats}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.automl.v1beta1.TimestampStats.GranularStats)
        com.google.cloud.automl.v1beta1.TimestampStats.GranularStatsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.automl.v1beta1.DataStatsOuterClass
            .internal_static_google_cloud_automl_v1beta1_TimestampStats_GranularStats_descriptor;
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapField internalGetMapField(int number) {
        switch (number) {
          case 1:
            return internalGetBuckets();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
        switch (number) {
          case 1:
            return internalGetMutableBuckets();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.automl.v1beta1.DataStatsOuterClass
            .internal_static_google_cloud_automl_v1beta1_TimestampStats_GranularStats_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.automl.v1beta1.TimestampStats.GranularStats.class,
                com.google.cloud.automl.v1beta1.TimestampStats.GranularStats.Builder.class);
      }

      // Construct using com.google.cloud.automl.v1beta1.TimestampStats.GranularStats.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        internalGetMutableBuckets().clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.automl.v1beta1.DataStatsOuterClass
            .internal_static_google_cloud_automl_v1beta1_TimestampStats_GranularStats_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.automl.v1beta1.TimestampStats.GranularStats
          getDefaultInstanceForType() {
        return com.google.cloud.automl.v1beta1.TimestampStats.GranularStats.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.automl.v1beta1.TimestampStats.GranularStats build() {
        com.google.cloud.automl.v1beta1.TimestampStats.GranularStats result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.automl.v1beta1.TimestampStats.GranularStats buildPartial() {
        com.google.cloud.automl.v1beta1.TimestampStats.GranularStats result =
            new com.google.cloud.automl.v1beta1.TimestampStats.GranularStats(this);
        int from_bitField0_ = bitField0_;
        result.buckets_ = internalGetBuckets();
        result.buckets_.makeImmutable();
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.automl.v1beta1.TimestampStats.GranularStats) {
          return mergeFrom((com.google.cloud.automl.v1beta1.TimestampStats.GranularStats) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.automl.v1beta1.TimestampStats.GranularStats other) {
        if (other
            == com.google.cloud.automl.v1beta1.TimestampStats.GranularStats.getDefaultInstance())
          return this;
        internalGetMutableBuckets().mergeFrom(other.internalGetBuckets());
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.automl.v1beta1.TimestampStats.GranularStats parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.automl.v1beta1.TimestampStats.GranularStats)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.MapField<java.lang.Integer, java.lang.Long> buckets_;

      private com.google.protobuf.MapField<java.lang.Integer, java.lang.Long> internalGetBuckets() {
        if (buckets_ == null) {
          return com.google.protobuf.MapField.emptyMapField(BucketsDefaultEntryHolder.defaultEntry);
        }
        return buckets_;
      }

      private com.google.protobuf.MapField<java.lang.Integer, java.lang.Long>
          internalGetMutableBuckets() {
        onChanged();
        ;
        if (buckets_ == null) {
          buckets_ =
              com.google.protobuf.MapField.newMapField(BucketsDefaultEntryHolder.defaultEntry);
        }
        if (!buckets_.isMutable()) {
          buckets_ = buckets_.copy();
        }
        return buckets_;
      }

      public int getBucketsCount() {
        return internalGetBuckets().getMap().size();
      }
      /**
       *
       *
       * <pre>
       * A map from granularity key to example count for that key.
       * E.g. for hour_of_day `13` means 1pm, or for month_of_year `5` means May).
       * </pre>
       *
       * <code>map&lt;int32, int64&gt; buckets = 1;</code>
       */
      @java.lang.Override
      public boolean containsBuckets(int key) {

        return internalGetBuckets().getMap().containsKey(key);
      }
      /** Use {@link #getBucketsMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.Integer, java.lang.Long> getBuckets() {
        return getBucketsMap();
      }
      /**
       *
       *
       * <pre>
       * A map from granularity key to example count for that key.
       * E.g. for hour_of_day `13` means 1pm, or for month_of_year `5` means May).
       * </pre>
       *
       * <code>map&lt;int32, int64&gt; buckets = 1;</code>
       */
      @java.lang.Override
      public java.util.Map<java.lang.Integer, java.lang.Long> getBucketsMap() {
        return internalGetBuckets().getMap();
      }
      /**
       *
       *
       * <pre>
       * A map from granularity key to example count for that key.
       * E.g. for hour_of_day `13` means 1pm, or for month_of_year `5` means May).
       * </pre>
       *
       * <code>map&lt;int32, int64&gt; buckets = 1;</code>
       */
      @java.lang.Override
      public long getBucketsOrDefault(int key, long defaultValue) {

        java.util.Map<java.lang.Integer, java.lang.Long> map = internalGetBuckets().getMap();
        return map.containsKey(key) ? map.get(key) : defaultValue;
      }
      /**
       *
       *
       * <pre>
       * A map from granularity key to example count for that key.
       * E.g. for hour_of_day `13` means 1pm, or for month_of_year `5` means May).
       * </pre>
       *
       * <code>map&lt;int32, int64&gt; buckets = 1;</code>
       */
      @java.lang.Override
      public long getBucketsOrThrow(int key) {

        java.util.Map<java.lang.Integer, java.lang.Long> map = internalGetBuckets().getMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return map.get(key);
      }

      public Builder clearBuckets() {
        internalGetMutableBuckets().getMutableMap().clear();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A map from granularity key to example count for that key.
       * E.g. for hour_of_day `13` means 1pm, or for month_of_year `5` means May).
       * </pre>
       *
       * <code>map&lt;int32, int64&gt; buckets = 1;</code>
       */
      public Builder removeBuckets(int key) {

        internalGetMutableBuckets().getMutableMap().remove(key);
        return this;
      }
      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<java.lang.Integer, java.lang.Long> getMutableBuckets() {
        return internalGetMutableBuckets().getMutableMap();
      }
      /**
       *
       *
       * <pre>
       * A map from granularity key to example count for that key.
       * E.g. for hour_of_day `13` means 1pm, or for month_of_year `5` means May).
       * </pre>
       *
       * <code>map&lt;int32, int64&gt; buckets = 1;</code>
       */
      public Builder putBuckets(int key, long value) {

        internalGetMutableBuckets().getMutableMap().put(key, value);
        return this;
      }
      /**
       *
       *
       * <pre>
       * A map from granularity key to example count for that key.
       * E.g. for hour_of_day `13` means 1pm, or for month_of_year `5` means May).
       * </pre>
       *
       * <code>map&lt;int32, int64&gt; buckets = 1;</code>
       */
      public Builder putAllBuckets(java.util.Map<java.lang.Integer, java.lang.Long> values) {
        internalGetMutableBuckets().getMutableMap().putAll(values);
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.automl.v1beta1.TimestampStats.GranularStats)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.automl.v1beta1.TimestampStats.GranularStats)
    private static final com.google.cloud.automl.v1beta1.TimestampStats.GranularStats
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.automl.v1beta1.TimestampStats.GranularStats();
    }

    public static com.google.cloud.automl.v1beta1.TimestampStats.GranularStats
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<GranularStats> PARSER =
        new com.google.protobuf.AbstractParser<GranularStats>() {
          @java.lang.Override
          public GranularStats parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new GranularStats(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<GranularStats> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GranularStats> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.TimestampStats.GranularStats
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int GRANULAR_STATS_FIELD_NUMBER = 1;

  private static final class GranularStatsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String, com.google.cloud.automl.v1beta1.TimestampStats.GranularStats>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.cloud.automl.v1beta1.TimestampStats.GranularStats>
                    newDefaultInstance(
                        com.google.cloud.automl.v1beta1.DataStatsOuterClass
                            .internal_static_google_cloud_automl_v1beta1_TimestampStats_GranularStatsEntry_descriptor,
                        com.google.protobuf.WireFormat.FieldType.STRING,
                        "",
                        com.google.protobuf.WireFormat.FieldType.MESSAGE,
                        com.google.cloud.automl.v1beta1.TimestampStats.GranularStats
                            .getDefaultInstance());
  }

  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.automl.v1beta1.TimestampStats.GranularStats>
      granularStats_;

  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.automl.v1beta1.TimestampStats.GranularStats>
      internalGetGranularStats() {
    if (granularStats_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          GranularStatsDefaultEntryHolder.defaultEntry);
    }
    return granularStats_;
  }

  public int getGranularStatsCount() {
    return internalGetGranularStats().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * The string key is the pre-defined granularity. Currently supported:
   * hour_of_day, day_of_week, month_of_year.
   * Granularities finer that the granularity of timestamp data are not
   * populated (e.g. if timestamps are at day granularity, then hour_of_day
   * is not populated).
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.automl.v1beta1.TimestampStats.GranularStats&gt; granular_stats = 1;
   * </code>
   */
  @java.lang.Override
  public boolean containsGranularStats(java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    return internalGetGranularStats().getMap().containsKey(key);
  }
  /** Use {@link #getGranularStatsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<
          java.lang.String, com.google.cloud.automl.v1beta1.TimestampStats.GranularStats>
      getGranularStats() {
    return getGranularStatsMap();
  }
  /**
   *
   *
   * <pre>
   * The string key is the pre-defined granularity. Currently supported:
   * hour_of_day, day_of_week, month_of_year.
   * Granularities finer that the granularity of timestamp data are not
   * populated (e.g. if timestamps are at day granularity, then hour_of_day
   * is not populated).
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.automl.v1beta1.TimestampStats.GranularStats&gt; granular_stats = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.Map<
          java.lang.String, com.google.cloud.automl.v1beta1.TimestampStats.GranularStats>
      getGranularStatsMap() {
    return internalGetGranularStats().getMap();
  }
  /**
   *
   *
   * <pre>
   * The string key is the pre-defined granularity. Currently supported:
   * hour_of_day, day_of_week, month_of_year.
   * Granularities finer that the granularity of timestamp data are not
   * populated (e.g. if timestamps are at day granularity, then hour_of_day
   * is not populated).
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.automl.v1beta1.TimestampStats.GranularStats&gt; granular_stats = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.TimestampStats.GranularStats getGranularStatsOrDefault(
      java.lang.String key,
      com.google.cloud.automl.v1beta1.TimestampStats.GranularStats defaultValue) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, com.google.cloud.automl.v1beta1.TimestampStats.GranularStats>
        map = internalGetGranularStats().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * The string key is the pre-defined granularity. Currently supported:
   * hour_of_day, day_of_week, month_of_year.
   * Granularities finer that the granularity of timestamp data are not
   * populated (e.g. if timestamps are at day granularity, then hour_of_day
   * is not populated).
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.automl.v1beta1.TimestampStats.GranularStats&gt; granular_stats = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.TimestampStats.GranularStats getGranularStatsOrThrow(
      java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, com.google.cloud.automl.v1beta1.TimestampStats.GranularStats>
        map = internalGetGranularStats().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetGranularStats(), GranularStatsDefaultEntryHolder.defaultEntry, 1);
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (java.util.Map.Entry<
            java.lang.String, com.google.cloud.automl.v1beta1.TimestampStats.GranularStats>
        entry : internalGetGranularStats().getMap().entrySet()) {
      com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.automl.v1beta1.TimestampStats.GranularStats>
          granularStats__ =
              GranularStatsDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, granularStats__);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.automl.v1beta1.TimestampStats)) {
      return super.equals(obj);
    }
    com.google.cloud.automl.v1beta1.TimestampStats other =
        (com.google.cloud.automl.v1beta1.TimestampStats) obj;

    if (!internalGetGranularStats().equals(other.internalGetGranularStats())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (!internalGetGranularStats().getMap().isEmpty()) {
      hash = (37 * hash) + GRANULAR_STATS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetGranularStats().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.automl.v1beta1.TimestampStats parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1beta1.TimestampStats parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.TimestampStats parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1beta1.TimestampStats parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.TimestampStats parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1beta1.TimestampStats parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.TimestampStats parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1beta1.TimestampStats parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.TimestampStats parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1beta1.TimestampStats parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.TimestampStats parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1beta1.TimestampStats parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.automl.v1beta1.TimestampStats prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The data statistics of a series of TIMESTAMP values.
   * </pre>
   *
   * Protobuf type {@code google.cloud.automl.v1beta1.TimestampStats}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.automl.v1beta1.TimestampStats)
      com.google.cloud.automl.v1beta1.TimestampStatsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.automl.v1beta1.DataStatsOuterClass
          .internal_static_google_cloud_automl_v1beta1_TimestampStats_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 1:
          return internalGetGranularStats();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 1:
          return internalGetMutableGranularStats();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.automl.v1beta1.DataStatsOuterClass
          .internal_static_google_cloud_automl_v1beta1_TimestampStats_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.automl.v1beta1.TimestampStats.class,
              com.google.cloud.automl.v1beta1.TimestampStats.Builder.class);
    }

    // Construct using com.google.cloud.automl.v1beta1.TimestampStats.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      internalGetMutableGranularStats().clear();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.automl.v1beta1.DataStatsOuterClass
          .internal_static_google_cloud_automl_v1beta1_TimestampStats_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.TimestampStats getDefaultInstanceForType() {
      return com.google.cloud.automl.v1beta1.TimestampStats.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.TimestampStats build() {
      com.google.cloud.automl.v1beta1.TimestampStats result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.TimestampStats buildPartial() {
      com.google.cloud.automl.v1beta1.TimestampStats result =
          new com.google.cloud.automl.v1beta1.TimestampStats(this);
      int from_bitField0_ = bitField0_;
      result.granularStats_ = internalGetGranularStats();
      result.granularStats_.makeImmutable();
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.automl.v1beta1.TimestampStats) {
        return mergeFrom((com.google.cloud.automl.v1beta1.TimestampStats) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.automl.v1beta1.TimestampStats other) {
      if (other == com.google.cloud.automl.v1beta1.TimestampStats.getDefaultInstance()) return this;
      internalGetMutableGranularStats().mergeFrom(other.internalGetGranularStats());
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.automl.v1beta1.TimestampStats parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloud.automl.v1beta1.TimestampStats) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.automl.v1beta1.TimestampStats.GranularStats>
        granularStats_;

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.automl.v1beta1.TimestampStats.GranularStats>
        internalGetGranularStats() {
      if (granularStats_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            GranularStatsDefaultEntryHolder.defaultEntry);
      }
      return granularStats_;
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.automl.v1beta1.TimestampStats.GranularStats>
        internalGetMutableGranularStats() {
      onChanged();
      ;
      if (granularStats_ == null) {
        granularStats_ =
            com.google.protobuf.MapField.newMapField(GranularStatsDefaultEntryHolder.defaultEntry);
      }
      if (!granularStats_.isMutable()) {
        granularStats_ = granularStats_.copy();
      }
      return granularStats_;
    }

    public int getGranularStatsCount() {
      return internalGetGranularStats().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * The string key is the pre-defined granularity. Currently supported:
     * hour_of_day, day_of_week, month_of_year.
     * Granularities finer that the granularity of timestamp data are not
     * populated (e.g. if timestamps are at day granularity, then hour_of_day
     * is not populated).
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.automl.v1beta1.TimestampStats.GranularStats&gt; granular_stats = 1;
     * </code>
     */
    @java.lang.Override
    public boolean containsGranularStats(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      return internalGetGranularStats().getMap().containsKey(key);
    }
    /** Use {@link #getGranularStatsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String, com.google.cloud.automl.v1beta1.TimestampStats.GranularStats>
        getGranularStats() {
      return getGranularStatsMap();
    }
    /**
     *
     *
     * <pre>
     * The string key is the pre-defined granularity. Currently supported:
     * hour_of_day, day_of_week, month_of_year.
     * Granularities finer that the granularity of timestamp data are not
     * populated (e.g. if timestamps are at day granularity, then hour_of_day
     * is not populated).
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.automl.v1beta1.TimestampStats.GranularStats&gt; granular_stats = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.Map<
            java.lang.String, com.google.cloud.automl.v1beta1.TimestampStats.GranularStats>
        getGranularStatsMap() {
      return internalGetGranularStats().getMap();
    }
    /**
     *
     *
     * <pre>
     * The string key is the pre-defined granularity. Currently supported:
     * hour_of_day, day_of_week, month_of_year.
     * Granularities finer that the granularity of timestamp data are not
     * populated (e.g. if timestamps are at day granularity, then hour_of_day
     * is not populated).
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.automl.v1beta1.TimestampStats.GranularStats&gt; granular_stats = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.TimestampStats.GranularStats getGranularStatsOrDefault(
        java.lang.String key,
        com.google.cloud.automl.v1beta1.TimestampStats.GranularStats defaultValue) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, com.google.cloud.automl.v1beta1.TimestampStats.GranularStats>
          map = internalGetGranularStats().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * The string key is the pre-defined granularity. Currently supported:
     * hour_of_day, day_of_week, month_of_year.
     * Granularities finer that the granularity of timestamp data are not
     * populated (e.g. if timestamps are at day granularity, then hour_of_day
     * is not populated).
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.automl.v1beta1.TimestampStats.GranularStats&gt; granular_stats = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.TimestampStats.GranularStats getGranularStatsOrThrow(
        java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, com.google.cloud.automl.v1beta1.TimestampStats.GranularStats>
          map = internalGetGranularStats().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearGranularStats() {
      internalGetMutableGranularStats().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The string key is the pre-defined granularity. Currently supported:
     * hour_of_day, day_of_week, month_of_year.
     * Granularities finer that the granularity of timestamp data are not
     * populated (e.g. if timestamps are at day granularity, then hour_of_day
     * is not populated).
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.automl.v1beta1.TimestampStats.GranularStats&gt; granular_stats = 1;
     * </code>
     */
    public Builder removeGranularStats(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableGranularStats().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String, com.google.cloud.automl.v1beta1.TimestampStats.GranularStats>
        getMutableGranularStats() {
      return internalGetMutableGranularStats().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * The string key is the pre-defined granularity. Currently supported:
     * hour_of_day, day_of_week, month_of_year.
     * Granularities finer that the granularity of timestamp data are not
     * populated (e.g. if timestamps are at day granularity, then hour_of_day
     * is not populated).
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.automl.v1beta1.TimestampStats.GranularStats&gt; granular_stats = 1;
     * </code>
     */
    public Builder putGranularStats(
        java.lang.String key, com.google.cloud.automl.v1beta1.TimestampStats.GranularStats value) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      if (value == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableGranularStats().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * The string key is the pre-defined granularity. Currently supported:
     * hour_of_day, day_of_week, month_of_year.
     * Granularities finer that the granularity of timestamp data are not
     * populated (e.g. if timestamps are at day granularity, then hour_of_day
     * is not populated).
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.automl.v1beta1.TimestampStats.GranularStats&gt; granular_stats = 1;
     * </code>
     */
    public Builder putAllGranularStats(
        java.util.Map<
                java.lang.String, com.google.cloud.automl.v1beta1.TimestampStats.GranularStats>
            values) {
      internalGetMutableGranularStats().getMutableMap().putAll(values);
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.automl.v1beta1.TimestampStats)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.automl.v1beta1.TimestampStats)
  private static final com.google.cloud.automl.v1beta1.TimestampStats DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.automl.v1beta1.TimestampStats();
  }

  public static com.google.cloud.automl.v1beta1.TimestampStats getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TimestampStats> PARSER =
      new com.google.protobuf.AbstractParser<TimestampStats>() {
        @java.lang.Override
        public TimestampStats parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new TimestampStats(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<TimestampStats> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TimestampStats> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.automl.v1beta1.TimestampStats getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
