/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/automl/v1beta1/detection.proto

package com.google.cloud.automl.v1beta1;

/**
 *
 *
 * <pre>
 * Annotation details for video object tracking.
 * </pre>
 *
 * Protobuf type {@code google.cloud.automl.v1beta1.VideoObjectTrackingAnnotation}
 */
public final class VideoObjectTrackingAnnotation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.automl.v1beta1.VideoObjectTrackingAnnotation)
    VideoObjectTrackingAnnotationOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use VideoObjectTrackingAnnotation.newBuilder() to construct.
  private VideoObjectTrackingAnnotation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private VideoObjectTrackingAnnotation() {
    instanceId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new VideoObjectTrackingAnnotation();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private VideoObjectTrackingAnnotation(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              instanceId_ = s;
              break;
            }
          case 18:
            {
              com.google.protobuf.Duration.Builder subBuilder = null;
              if (timeOffset_ != null) {
                subBuilder = timeOffset_.toBuilder();
              }
              timeOffset_ =
                  input.readMessage(com.google.protobuf.Duration.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(timeOffset_);
                timeOffset_ = subBuilder.buildPartial();
              }

              break;
            }
          case 26:
            {
              com.google.cloud.automl.v1beta1.BoundingPoly.Builder subBuilder = null;
              if (boundingBox_ != null) {
                subBuilder = boundingBox_.toBuilder();
              }
              boundingBox_ =
                  input.readMessage(
                      com.google.cloud.automl.v1beta1.BoundingPoly.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(boundingBox_);
                boundingBox_ = subBuilder.buildPartial();
              }

              break;
            }
          case 37:
            {
              score_ = input.readFloat();
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.automl.v1beta1.Detection
        .internal_static_google_cloud_automl_v1beta1_VideoObjectTrackingAnnotation_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.automl.v1beta1.Detection
        .internal_static_google_cloud_automl_v1beta1_VideoObjectTrackingAnnotation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.automl.v1beta1.VideoObjectTrackingAnnotation.class,
            com.google.cloud.automl.v1beta1.VideoObjectTrackingAnnotation.Builder.class);
  }

  public static final int INSTANCE_ID_FIELD_NUMBER = 1;
  private volatile java.lang.Object instanceId_;
  /**
   *
   *
   * <pre>
   * Optional. The instance of the object, expressed as a positive integer. Used to tell
   * apart objects of the same type (i.e. AnnotationSpec) when multiple are
   * present on a single example.
   * NOTE: Instance ID prediction quality is not a part of model evaluation and
   * is done as best effort. Especially in cases when an entity goes
   * off-screen for a longer time (minutes), when it comes back it may be given
   * a new instance ID.
   * </pre>
   *
   * <code>string instance_id = 1;</code>
   *
   * @return The instanceId.
   */
  @java.lang.Override
  public java.lang.String getInstanceId() {
    java.lang.Object ref = instanceId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      instanceId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The instance of the object, expressed as a positive integer. Used to tell
   * apart objects of the same type (i.e. AnnotationSpec) when multiple are
   * present on a single example.
   * NOTE: Instance ID prediction quality is not a part of model evaluation and
   * is done as best effort. Especially in cases when an entity goes
   * off-screen for a longer time (minutes), when it comes back it may be given
   * a new instance ID.
   * </pre>
   *
   * <code>string instance_id = 1;</code>
   *
   * @return The bytes for instanceId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInstanceIdBytes() {
    java.lang.Object ref = instanceId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      instanceId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TIME_OFFSET_FIELD_NUMBER = 2;
  private com.google.protobuf.Duration timeOffset_;
  /**
   *
   *
   * <pre>
   * Required. A time (frame) of a video to which this annotation pertains.
   * Represented as the duration since the video's start.
   * </pre>
   *
   * <code>.google.protobuf.Duration time_offset = 2;</code>
   *
   * @return Whether the timeOffset field is set.
   */
  @java.lang.Override
  public boolean hasTimeOffset() {
    return timeOffset_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. A time (frame) of a video to which this annotation pertains.
   * Represented as the duration since the video's start.
   * </pre>
   *
   * <code>.google.protobuf.Duration time_offset = 2;</code>
   *
   * @return The timeOffset.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getTimeOffset() {
    return timeOffset_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeOffset_;
  }
  /**
   *
   *
   * <pre>
   * Required. A time (frame) of a video to which this annotation pertains.
   * Represented as the duration since the video's start.
   * </pre>
   *
   * <code>.google.protobuf.Duration time_offset = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getTimeOffsetOrBuilder() {
    return getTimeOffset();
  }

  public static final int BOUNDING_BOX_FIELD_NUMBER = 3;
  private com.google.cloud.automl.v1beta1.BoundingPoly boundingBox_;
  /**
   *
   *
   * <pre>
   * Required. The rectangle representing the object location on the frame (i.e.
   * at the time_offset of the video).
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.BoundingPoly bounding_box = 3;</code>
   *
   * @return Whether the boundingBox field is set.
   */
  @java.lang.Override
  public boolean hasBoundingBox() {
    return boundingBox_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. The rectangle representing the object location on the frame (i.e.
   * at the time_offset of the video).
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.BoundingPoly bounding_box = 3;</code>
   *
   * @return The boundingBox.
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.BoundingPoly getBoundingBox() {
    return boundingBox_ == null
        ? com.google.cloud.automl.v1beta1.BoundingPoly.getDefaultInstance()
        : boundingBox_;
  }
  /**
   *
   *
   * <pre>
   * Required. The rectangle representing the object location on the frame (i.e.
   * at the time_offset of the video).
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.BoundingPoly bounding_box = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.BoundingPolyOrBuilder getBoundingBoxOrBuilder() {
    return getBoundingBox();
  }

  public static final int SCORE_FIELD_NUMBER = 4;
  private float score_;
  /**
   *
   *
   * <pre>
   * Output only. The confidence that this annotation is positive for the video at
   * the time_offset, value in [0, 1], higher means higher positivity
   * confidence. For annotations created by the user the score is 1. When
   * user approves an annotation, the original float score is kept (and not
   * changed to 1).
   * </pre>
   *
   * <code>float score = 4;</code>
   *
   * @return The score.
   */
  @java.lang.Override
  public float getScore() {
    return score_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(instanceId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, instanceId_);
    }
    if (timeOffset_ != null) {
      output.writeMessage(2, getTimeOffset());
    }
    if (boundingBox_ != null) {
      output.writeMessage(3, getBoundingBox());
    }
    if (score_ != 0F) {
      output.writeFloat(4, score_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(instanceId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, instanceId_);
    }
    if (timeOffset_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getTimeOffset());
    }
    if (boundingBox_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getBoundingBox());
    }
    if (score_ != 0F) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(4, score_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.automl.v1beta1.VideoObjectTrackingAnnotation)) {
      return super.equals(obj);
    }
    com.google.cloud.automl.v1beta1.VideoObjectTrackingAnnotation other =
        (com.google.cloud.automl.v1beta1.VideoObjectTrackingAnnotation) obj;

    if (!getInstanceId().equals(other.getInstanceId())) return false;
    if (hasTimeOffset() != other.hasTimeOffset()) return false;
    if (hasTimeOffset()) {
      if (!getTimeOffset().equals(other.getTimeOffset())) return false;
    }
    if (hasBoundingBox() != other.hasBoundingBox()) return false;
    if (hasBoundingBox()) {
      if (!getBoundingBox().equals(other.getBoundingBox())) return false;
    }
    if (java.lang.Float.floatToIntBits(getScore())
        != java.lang.Float.floatToIntBits(other.getScore())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + INSTANCE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getInstanceId().hashCode();
    if (hasTimeOffset()) {
      hash = (37 * hash) + TIME_OFFSET_FIELD_NUMBER;
      hash = (53 * hash) + getTimeOffset().hashCode();
    }
    if (hasBoundingBox()) {
      hash = (37 * hash) + BOUNDING_BOX_FIELD_NUMBER;
      hash = (53 * hash) + getBoundingBox().hashCode();
    }
    hash = (37 * hash) + SCORE_FIELD_NUMBER;
    hash = (53 * hash) + java.lang.Float.floatToIntBits(getScore());
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.automl.v1beta1.VideoObjectTrackingAnnotation parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1beta1.VideoObjectTrackingAnnotation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.VideoObjectTrackingAnnotation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1beta1.VideoObjectTrackingAnnotation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.VideoObjectTrackingAnnotation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1beta1.VideoObjectTrackingAnnotation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.VideoObjectTrackingAnnotation parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1beta1.VideoObjectTrackingAnnotation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.VideoObjectTrackingAnnotation parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1beta1.VideoObjectTrackingAnnotation parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.VideoObjectTrackingAnnotation parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1beta1.VideoObjectTrackingAnnotation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.automl.v1beta1.VideoObjectTrackingAnnotation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Annotation details for video object tracking.
   * </pre>
   *
   * Protobuf type {@code google.cloud.automl.v1beta1.VideoObjectTrackingAnnotation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.automl.v1beta1.VideoObjectTrackingAnnotation)
      com.google.cloud.automl.v1beta1.VideoObjectTrackingAnnotationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.automl.v1beta1.Detection
          .internal_static_google_cloud_automl_v1beta1_VideoObjectTrackingAnnotation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.automl.v1beta1.Detection
          .internal_static_google_cloud_automl_v1beta1_VideoObjectTrackingAnnotation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.automl.v1beta1.VideoObjectTrackingAnnotation.class,
              com.google.cloud.automl.v1beta1.VideoObjectTrackingAnnotation.Builder.class);
    }

    // Construct using com.google.cloud.automl.v1beta1.VideoObjectTrackingAnnotation.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      instanceId_ = "";

      if (timeOffsetBuilder_ == null) {
        timeOffset_ = null;
      } else {
        timeOffset_ = null;
        timeOffsetBuilder_ = null;
      }
      if (boundingBoxBuilder_ == null) {
        boundingBox_ = null;
      } else {
        boundingBox_ = null;
        boundingBoxBuilder_ = null;
      }
      score_ = 0F;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.automl.v1beta1.Detection
          .internal_static_google_cloud_automl_v1beta1_VideoObjectTrackingAnnotation_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.VideoObjectTrackingAnnotation
        getDefaultInstanceForType() {
      return com.google.cloud.automl.v1beta1.VideoObjectTrackingAnnotation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.VideoObjectTrackingAnnotation build() {
      com.google.cloud.automl.v1beta1.VideoObjectTrackingAnnotation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.VideoObjectTrackingAnnotation buildPartial() {
      com.google.cloud.automl.v1beta1.VideoObjectTrackingAnnotation result =
          new com.google.cloud.automl.v1beta1.VideoObjectTrackingAnnotation(this);
      result.instanceId_ = instanceId_;
      if (timeOffsetBuilder_ == null) {
        result.timeOffset_ = timeOffset_;
      } else {
        result.timeOffset_ = timeOffsetBuilder_.build();
      }
      if (boundingBoxBuilder_ == null) {
        result.boundingBox_ = boundingBox_;
      } else {
        result.boundingBox_ = boundingBoxBuilder_.build();
      }
      result.score_ = score_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.automl.v1beta1.VideoObjectTrackingAnnotation) {
        return mergeFrom((com.google.cloud.automl.v1beta1.VideoObjectTrackingAnnotation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.automl.v1beta1.VideoObjectTrackingAnnotation other) {
      if (other
          == com.google.cloud.automl.v1beta1.VideoObjectTrackingAnnotation.getDefaultInstance())
        return this;
      if (!other.getInstanceId().isEmpty()) {
        instanceId_ = other.instanceId_;
        onChanged();
      }
      if (other.hasTimeOffset()) {
        mergeTimeOffset(other.getTimeOffset());
      }
      if (other.hasBoundingBox()) {
        mergeBoundingBox(other.getBoundingBox());
      }
      if (other.getScore() != 0F) {
        setScore(other.getScore());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.automl.v1beta1.VideoObjectTrackingAnnotation parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.automl.v1beta1.VideoObjectTrackingAnnotation)
                e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private java.lang.Object instanceId_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The instance of the object, expressed as a positive integer. Used to tell
     * apart objects of the same type (i.e. AnnotationSpec) when multiple are
     * present on a single example.
     * NOTE: Instance ID prediction quality is not a part of model evaluation and
     * is done as best effort. Especially in cases when an entity goes
     * off-screen for a longer time (minutes), when it comes back it may be given
     * a new instance ID.
     * </pre>
     *
     * <code>string instance_id = 1;</code>
     *
     * @return The instanceId.
     */
    public java.lang.String getInstanceId() {
      java.lang.Object ref = instanceId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        instanceId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The instance of the object, expressed as a positive integer. Used to tell
     * apart objects of the same type (i.e. AnnotationSpec) when multiple are
     * present on a single example.
     * NOTE: Instance ID prediction quality is not a part of model evaluation and
     * is done as best effort. Especially in cases when an entity goes
     * off-screen for a longer time (minutes), when it comes back it may be given
     * a new instance ID.
     * </pre>
     *
     * <code>string instance_id = 1;</code>
     *
     * @return The bytes for instanceId.
     */
    public com.google.protobuf.ByteString getInstanceIdBytes() {
      java.lang.Object ref = instanceId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        instanceId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The instance of the object, expressed as a positive integer. Used to tell
     * apart objects of the same type (i.e. AnnotationSpec) when multiple are
     * present on a single example.
     * NOTE: Instance ID prediction quality is not a part of model evaluation and
     * is done as best effort. Especially in cases when an entity goes
     * off-screen for a longer time (minutes), when it comes back it may be given
     * a new instance ID.
     * </pre>
     *
     * <code>string instance_id = 1;</code>
     *
     * @param value The instanceId to set.
     * @return This builder for chaining.
     */
    public Builder setInstanceId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      instanceId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The instance of the object, expressed as a positive integer. Used to tell
     * apart objects of the same type (i.e. AnnotationSpec) when multiple are
     * present on a single example.
     * NOTE: Instance ID prediction quality is not a part of model evaluation and
     * is done as best effort. Especially in cases when an entity goes
     * off-screen for a longer time (minutes), when it comes back it may be given
     * a new instance ID.
     * </pre>
     *
     * <code>string instance_id = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInstanceId() {

      instanceId_ = getDefaultInstance().getInstanceId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The instance of the object, expressed as a positive integer. Used to tell
     * apart objects of the same type (i.e. AnnotationSpec) when multiple are
     * present on a single example.
     * NOTE: Instance ID prediction quality is not a part of model evaluation and
     * is done as best effort. Especially in cases when an entity goes
     * off-screen for a longer time (minutes), when it comes back it may be given
     * a new instance ID.
     * </pre>
     *
     * <code>string instance_id = 1;</code>
     *
     * @param value The bytes for instanceId to set.
     * @return This builder for chaining.
     */
    public Builder setInstanceIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      instanceId_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.Duration timeOffset_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        timeOffsetBuilder_;
    /**
     *
     *
     * <pre>
     * Required. A time (frame) of a video to which this annotation pertains.
     * Represented as the duration since the video's start.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_offset = 2;</code>
     *
     * @return Whether the timeOffset field is set.
     */
    public boolean hasTimeOffset() {
      return timeOffsetBuilder_ != null || timeOffset_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. A time (frame) of a video to which this annotation pertains.
     * Represented as the duration since the video's start.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_offset = 2;</code>
     *
     * @return The timeOffset.
     */
    public com.google.protobuf.Duration getTimeOffset() {
      if (timeOffsetBuilder_ == null) {
        return timeOffset_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : timeOffset_;
      } else {
        return timeOffsetBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. A time (frame) of a video to which this annotation pertains.
     * Represented as the duration since the video's start.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_offset = 2;</code>
     */
    public Builder setTimeOffset(com.google.protobuf.Duration value) {
      if (timeOffsetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        timeOffset_ = value;
        onChanged();
      } else {
        timeOffsetBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A time (frame) of a video to which this annotation pertains.
     * Represented as the duration since the video's start.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_offset = 2;</code>
     */
    public Builder setTimeOffset(com.google.protobuf.Duration.Builder builderForValue) {
      if (timeOffsetBuilder_ == null) {
        timeOffset_ = builderForValue.build();
        onChanged();
      } else {
        timeOffsetBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A time (frame) of a video to which this annotation pertains.
     * Represented as the duration since the video's start.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_offset = 2;</code>
     */
    public Builder mergeTimeOffset(com.google.protobuf.Duration value) {
      if (timeOffsetBuilder_ == null) {
        if (timeOffset_ != null) {
          timeOffset_ =
              com.google.protobuf.Duration.newBuilder(timeOffset_).mergeFrom(value).buildPartial();
        } else {
          timeOffset_ = value;
        }
        onChanged();
      } else {
        timeOffsetBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A time (frame) of a video to which this annotation pertains.
     * Represented as the duration since the video's start.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_offset = 2;</code>
     */
    public Builder clearTimeOffset() {
      if (timeOffsetBuilder_ == null) {
        timeOffset_ = null;
        onChanged();
      } else {
        timeOffset_ = null;
        timeOffsetBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A time (frame) of a video to which this annotation pertains.
     * Represented as the duration since the video's start.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_offset = 2;</code>
     */
    public com.google.protobuf.Duration.Builder getTimeOffsetBuilder() {

      onChanged();
      return getTimeOffsetFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. A time (frame) of a video to which this annotation pertains.
     * Represented as the duration since the video's start.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_offset = 2;</code>
     */
    public com.google.protobuf.DurationOrBuilder getTimeOffsetOrBuilder() {
      if (timeOffsetBuilder_ != null) {
        return timeOffsetBuilder_.getMessageOrBuilder();
      } else {
        return timeOffset_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : timeOffset_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. A time (frame) of a video to which this annotation pertains.
     * Represented as the duration since the video's start.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_offset = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getTimeOffsetFieldBuilder() {
      if (timeOffsetBuilder_ == null) {
        timeOffsetBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getTimeOffset(), getParentForChildren(), isClean());
        timeOffset_ = null;
      }
      return timeOffsetBuilder_;
    }

    private com.google.cloud.automl.v1beta1.BoundingPoly boundingBox_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.BoundingPoly,
            com.google.cloud.automl.v1beta1.BoundingPoly.Builder,
            com.google.cloud.automl.v1beta1.BoundingPolyOrBuilder>
        boundingBoxBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The rectangle representing the object location on the frame (i.e.
     * at the time_offset of the video).
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.BoundingPoly bounding_box = 3;</code>
     *
     * @return Whether the boundingBox field is set.
     */
    public boolean hasBoundingBox() {
      return boundingBoxBuilder_ != null || boundingBox_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. The rectangle representing the object location on the frame (i.e.
     * at the time_offset of the video).
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.BoundingPoly bounding_box = 3;</code>
     *
     * @return The boundingBox.
     */
    public com.google.cloud.automl.v1beta1.BoundingPoly getBoundingBox() {
      if (boundingBoxBuilder_ == null) {
        return boundingBox_ == null
            ? com.google.cloud.automl.v1beta1.BoundingPoly.getDefaultInstance()
            : boundingBox_;
      } else {
        return boundingBoxBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The rectangle representing the object location on the frame (i.e.
     * at the time_offset of the video).
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.BoundingPoly bounding_box = 3;</code>
     */
    public Builder setBoundingBox(com.google.cloud.automl.v1beta1.BoundingPoly value) {
      if (boundingBoxBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        boundingBox_ = value;
        onChanged();
      } else {
        boundingBoxBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The rectangle representing the object location on the frame (i.e.
     * at the time_offset of the video).
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.BoundingPoly bounding_box = 3;</code>
     */
    public Builder setBoundingBox(
        com.google.cloud.automl.v1beta1.BoundingPoly.Builder builderForValue) {
      if (boundingBoxBuilder_ == null) {
        boundingBox_ = builderForValue.build();
        onChanged();
      } else {
        boundingBoxBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The rectangle representing the object location on the frame (i.e.
     * at the time_offset of the video).
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.BoundingPoly bounding_box = 3;</code>
     */
    public Builder mergeBoundingBox(com.google.cloud.automl.v1beta1.BoundingPoly value) {
      if (boundingBoxBuilder_ == null) {
        if (boundingBox_ != null) {
          boundingBox_ =
              com.google.cloud.automl.v1beta1.BoundingPoly.newBuilder(boundingBox_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          boundingBox_ = value;
        }
        onChanged();
      } else {
        boundingBoxBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The rectangle representing the object location on the frame (i.e.
     * at the time_offset of the video).
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.BoundingPoly bounding_box = 3;</code>
     */
    public Builder clearBoundingBox() {
      if (boundingBoxBuilder_ == null) {
        boundingBox_ = null;
        onChanged();
      } else {
        boundingBox_ = null;
        boundingBoxBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The rectangle representing the object location on the frame (i.e.
     * at the time_offset of the video).
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.BoundingPoly bounding_box = 3;</code>
     */
    public com.google.cloud.automl.v1beta1.BoundingPoly.Builder getBoundingBoxBuilder() {

      onChanged();
      return getBoundingBoxFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The rectangle representing the object location on the frame (i.e.
     * at the time_offset of the video).
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.BoundingPoly bounding_box = 3;</code>
     */
    public com.google.cloud.automl.v1beta1.BoundingPolyOrBuilder getBoundingBoxOrBuilder() {
      if (boundingBoxBuilder_ != null) {
        return boundingBoxBuilder_.getMessageOrBuilder();
      } else {
        return boundingBox_ == null
            ? com.google.cloud.automl.v1beta1.BoundingPoly.getDefaultInstance()
            : boundingBox_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The rectangle representing the object location on the frame (i.e.
     * at the time_offset of the video).
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.BoundingPoly bounding_box = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.BoundingPoly,
            com.google.cloud.automl.v1beta1.BoundingPoly.Builder,
            com.google.cloud.automl.v1beta1.BoundingPolyOrBuilder>
        getBoundingBoxFieldBuilder() {
      if (boundingBoxBuilder_ == null) {
        boundingBoxBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.automl.v1beta1.BoundingPoly,
                com.google.cloud.automl.v1beta1.BoundingPoly.Builder,
                com.google.cloud.automl.v1beta1.BoundingPolyOrBuilder>(
                getBoundingBox(), getParentForChildren(), isClean());
        boundingBox_ = null;
      }
      return boundingBoxBuilder_;
    }

    private float score_;
    /**
     *
     *
     * <pre>
     * Output only. The confidence that this annotation is positive for the video at
     * the time_offset, value in [0, 1], higher means higher positivity
     * confidence. For annotations created by the user the score is 1. When
     * user approves an annotation, the original float score is kept (and not
     * changed to 1).
     * </pre>
     *
     * <code>float score = 4;</code>
     *
     * @return The score.
     */
    @java.lang.Override
    public float getScore() {
      return score_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The confidence that this annotation is positive for the video at
     * the time_offset, value in [0, 1], higher means higher positivity
     * confidence. For annotations created by the user the score is 1. When
     * user approves an annotation, the original float score is kept (and not
     * changed to 1).
     * </pre>
     *
     * <code>float score = 4;</code>
     *
     * @param value The score to set.
     * @return This builder for chaining.
     */
    public Builder setScore(float value) {

      score_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The confidence that this annotation is positive for the video at
     * the time_offset, value in [0, 1], higher means higher positivity
     * confidence. For annotations created by the user the score is 1. When
     * user approves an annotation, the original float score is kept (and not
     * changed to 1).
     * </pre>
     *
     * <code>float score = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearScore() {

      score_ = 0F;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.automl.v1beta1.VideoObjectTrackingAnnotation)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.automl.v1beta1.VideoObjectTrackingAnnotation)
  private static final com.google.cloud.automl.v1beta1.VideoObjectTrackingAnnotation
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.automl.v1beta1.VideoObjectTrackingAnnotation();
  }

  public static com.google.cloud.automl.v1beta1.VideoObjectTrackingAnnotation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<VideoObjectTrackingAnnotation> PARSER =
      new com.google.protobuf.AbstractParser<VideoObjectTrackingAnnotation>() {
        @java.lang.Override
        public VideoObjectTrackingAnnotation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new VideoObjectTrackingAnnotation(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<VideoObjectTrackingAnnotation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<VideoObjectTrackingAnnotation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.automl.v1beta1.VideoObjectTrackingAnnotation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
