/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/automl/v1beta1/data_items.proto

package com.google.cloud.automl.v1beta1;

/**
 *
 *
 * <pre>
 * A structured text document e.g. a PDF.
 * </pre>
 *
 * Protobuf type {@code google.cloud.automl.v1beta1.Document}
 */
public final class Document extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.automl.v1beta1.Document)
    DocumentOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Document.newBuilder() to construct.
  private Document(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Document() {
    layout_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Document();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private Document(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              com.google.cloud.automl.v1beta1.DocumentInputConfig.Builder subBuilder = null;
              if (inputConfig_ != null) {
                subBuilder = inputConfig_.toBuilder();
              }
              inputConfig_ =
                  input.readMessage(
                      com.google.cloud.automl.v1beta1.DocumentInputConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(inputConfig_);
                inputConfig_ = subBuilder.buildPartial();
              }

              break;
            }
          case 18:
            {
              com.google.cloud.automl.v1beta1.TextSnippet.Builder subBuilder = null;
              if (documentText_ != null) {
                subBuilder = documentText_.toBuilder();
              }
              documentText_ =
                  input.readMessage(
                      com.google.cloud.automl.v1beta1.TextSnippet.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(documentText_);
                documentText_ = subBuilder.buildPartial();
              }

              break;
            }
          case 26:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                layout_ =
                    new java.util.ArrayList<com.google.cloud.automl.v1beta1.Document.Layout>();
                mutable_bitField0_ |= 0x00000001;
              }
              layout_.add(
                  input.readMessage(
                      com.google.cloud.automl.v1beta1.Document.Layout.parser(), extensionRegistry));
              break;
            }
          case 34:
            {
              com.google.cloud.automl.v1beta1.DocumentDimensions.Builder subBuilder = null;
              if (documentDimensions_ != null) {
                subBuilder = documentDimensions_.toBuilder();
              }
              documentDimensions_ =
                  input.readMessage(
                      com.google.cloud.automl.v1beta1.DocumentDimensions.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(documentDimensions_);
                documentDimensions_ = subBuilder.buildPartial();
              }

              break;
            }
          case 40:
            {
              pageCount_ = input.readInt32();
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        layout_ = java.util.Collections.unmodifiableList(layout_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.automl.v1beta1.DataItems
        .internal_static_google_cloud_automl_v1beta1_Document_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.automl.v1beta1.DataItems
        .internal_static_google_cloud_automl_v1beta1_Document_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.automl.v1beta1.Document.class,
            com.google.cloud.automl.v1beta1.Document.Builder.class);
  }

  public interface LayoutOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.automl.v1beta1.Document.Layout)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Text Segment that represents a segment in
     * [document_text][google.cloud.automl.v1beta1.Document.document_text].
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.TextSegment text_segment = 1;</code>
     *
     * @return Whether the textSegment field is set.
     */
    boolean hasTextSegment();
    /**
     *
     *
     * <pre>
     * Text Segment that represents a segment in
     * [document_text][google.cloud.automl.v1beta1.Document.document_text].
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.TextSegment text_segment = 1;</code>
     *
     * @return The textSegment.
     */
    com.google.cloud.automl.v1beta1.TextSegment getTextSegment();
    /**
     *
     *
     * <pre>
     * Text Segment that represents a segment in
     * [document_text][google.cloud.automl.v1beta1.Document.document_text].
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.TextSegment text_segment = 1;</code>
     */
    com.google.cloud.automl.v1beta1.TextSegmentOrBuilder getTextSegmentOrBuilder();

    /**
     *
     *
     * <pre>
     * Page number of the [text_segment][google.cloud.automl.v1beta1.Document.Layout.text_segment] in the original document, starts
     * from 1.
     * </pre>
     *
     * <code>int32 page_number = 2;</code>
     *
     * @return The pageNumber.
     */
    int getPageNumber();

    /**
     *
     *
     * <pre>
     * The position of the [text_segment][google.cloud.automl.v1beta1.Document.Layout.text_segment] in the page.
     * Contains exactly 4
     * [normalized_vertices][google.cloud.automl.v1beta1.BoundingPoly.normalized_vertices]
     * and they are connected by edges in the order provided, which will
     * represent a rectangle parallel to the frame. The
     * [NormalizedVertex-s][google.cloud.automl.v1beta1.NormalizedVertex] are
     * relative to the page.
     * Coordinates are based on top-left as point (0,0).
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.BoundingPoly bounding_poly = 3;</code>
     *
     * @return Whether the boundingPoly field is set.
     */
    boolean hasBoundingPoly();
    /**
     *
     *
     * <pre>
     * The position of the [text_segment][google.cloud.automl.v1beta1.Document.Layout.text_segment] in the page.
     * Contains exactly 4
     * [normalized_vertices][google.cloud.automl.v1beta1.BoundingPoly.normalized_vertices]
     * and they are connected by edges in the order provided, which will
     * represent a rectangle parallel to the frame. The
     * [NormalizedVertex-s][google.cloud.automl.v1beta1.NormalizedVertex] are
     * relative to the page.
     * Coordinates are based on top-left as point (0,0).
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.BoundingPoly bounding_poly = 3;</code>
     *
     * @return The boundingPoly.
     */
    com.google.cloud.automl.v1beta1.BoundingPoly getBoundingPoly();
    /**
     *
     *
     * <pre>
     * The position of the [text_segment][google.cloud.automl.v1beta1.Document.Layout.text_segment] in the page.
     * Contains exactly 4
     * [normalized_vertices][google.cloud.automl.v1beta1.BoundingPoly.normalized_vertices]
     * and they are connected by edges in the order provided, which will
     * represent a rectangle parallel to the frame. The
     * [NormalizedVertex-s][google.cloud.automl.v1beta1.NormalizedVertex] are
     * relative to the page.
     * Coordinates are based on top-left as point (0,0).
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.BoundingPoly bounding_poly = 3;</code>
     */
    com.google.cloud.automl.v1beta1.BoundingPolyOrBuilder getBoundingPolyOrBuilder();

    /**
     *
     *
     * <pre>
     * The type of the [text_segment][google.cloud.automl.v1beta1.Document.Layout.text_segment] in document.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.Document.Layout.TextSegmentType text_segment_type = 4;
     * </code>
     *
     * @return The enum numeric value on the wire for textSegmentType.
     */
    int getTextSegmentTypeValue();
    /**
     *
     *
     * <pre>
     * The type of the [text_segment][google.cloud.automl.v1beta1.Document.Layout.text_segment] in document.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.Document.Layout.TextSegmentType text_segment_type = 4;
     * </code>
     *
     * @return The textSegmentType.
     */
    com.google.cloud.automl.v1beta1.Document.Layout.TextSegmentType getTextSegmentType();
  }
  /**
   *
   *
   * <pre>
   * Describes the layout information of a [text_segment][google.cloud.automl.v1beta1.Document.Layout.text_segment] in the document.
   * </pre>
   *
   * Protobuf type {@code google.cloud.automl.v1beta1.Document.Layout}
   */
  public static final class Layout extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.automl.v1beta1.Document.Layout)
      LayoutOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Layout.newBuilder() to construct.
    private Layout(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Layout() {
      textSegmentType_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Layout();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private Layout(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.automl.v1beta1.TextSegment.Builder subBuilder = null;
                if (textSegment_ != null) {
                  subBuilder = textSegment_.toBuilder();
                }
                textSegment_ =
                    input.readMessage(
                        com.google.cloud.automl.v1beta1.TextSegment.parser(), extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(textSegment_);
                  textSegment_ = subBuilder.buildPartial();
                }

                break;
              }
            case 16:
              {
                pageNumber_ = input.readInt32();
                break;
              }
            case 26:
              {
                com.google.cloud.automl.v1beta1.BoundingPoly.Builder subBuilder = null;
                if (boundingPoly_ != null) {
                  subBuilder = boundingPoly_.toBuilder();
                }
                boundingPoly_ =
                    input.readMessage(
                        com.google.cloud.automl.v1beta1.BoundingPoly.parser(), extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(boundingPoly_);
                  boundingPoly_ = subBuilder.buildPartial();
                }

                break;
              }
            case 32:
              {
                int rawValue = input.readEnum();

                textSegmentType_ = rawValue;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.automl.v1beta1.DataItems
          .internal_static_google_cloud_automl_v1beta1_Document_Layout_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.automl.v1beta1.DataItems
          .internal_static_google_cloud_automl_v1beta1_Document_Layout_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.automl.v1beta1.Document.Layout.class,
              com.google.cloud.automl.v1beta1.Document.Layout.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * The type of TextSegment in the context of the original document.
     * </pre>
     *
     * Protobuf enum {@code google.cloud.automl.v1beta1.Document.Layout.TextSegmentType}
     */
    public enum TextSegmentType implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Should not be used.
       * </pre>
       *
       * <code>TEXT_SEGMENT_TYPE_UNSPECIFIED = 0;</code>
       */
      TEXT_SEGMENT_TYPE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * The text segment is a token. e.g. word.
       * </pre>
       *
       * <code>TOKEN = 1;</code>
       */
      TOKEN(1),
      /**
       *
       *
       * <pre>
       * The text segment is a paragraph.
       * </pre>
       *
       * <code>PARAGRAPH = 2;</code>
       */
      PARAGRAPH(2),
      /**
       *
       *
       * <pre>
       * The text segment is a form field.
       * </pre>
       *
       * <code>FORM_FIELD = 3;</code>
       */
      FORM_FIELD(3),
      /**
       *
       *
       * <pre>
       * The text segment is the name part of a form field. It will be treated
       * as child of another FORM_FIELD TextSegment if its span is subspan of
       * another TextSegment with type FORM_FIELD.
       * </pre>
       *
       * <code>FORM_FIELD_NAME = 4;</code>
       */
      FORM_FIELD_NAME(4),
      /**
       *
       *
       * <pre>
       * The text segment is the text content part of a form field. It will be
       * treated as child of another FORM_FIELD TextSegment if its span is
       * subspan of another TextSegment with type FORM_FIELD.
       * </pre>
       *
       * <code>FORM_FIELD_CONTENTS = 5;</code>
       */
      FORM_FIELD_CONTENTS(5),
      /**
       *
       *
       * <pre>
       * The text segment is a whole table, including headers, and all rows.
       * </pre>
       *
       * <code>TABLE = 6;</code>
       */
      TABLE(6),
      /**
       *
       *
       * <pre>
       * The text segment is a table's headers. It will be treated as child of
       * another TABLE TextSegment if its span is subspan of another TextSegment
       * with type TABLE.
       * </pre>
       *
       * <code>TABLE_HEADER = 7;</code>
       */
      TABLE_HEADER(7),
      /**
       *
       *
       * <pre>
       * The text segment is a row in table. It will be treated as child of
       * another TABLE TextSegment if its span is subspan of another TextSegment
       * with type TABLE.
       * </pre>
       *
       * <code>TABLE_ROW = 8;</code>
       */
      TABLE_ROW(8),
      /**
       *
       *
       * <pre>
       * The text segment is a cell in table. It will be treated as child of
       * another TABLE_ROW TextSegment if its span is subspan of another
       * TextSegment with type TABLE_ROW.
       * </pre>
       *
       * <code>TABLE_CELL = 9;</code>
       */
      TABLE_CELL(9),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Should not be used.
       * </pre>
       *
       * <code>TEXT_SEGMENT_TYPE_UNSPECIFIED = 0;</code>
       */
      public static final int TEXT_SEGMENT_TYPE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * The text segment is a token. e.g. word.
       * </pre>
       *
       * <code>TOKEN = 1;</code>
       */
      public static final int TOKEN_VALUE = 1;
      /**
       *
       *
       * <pre>
       * The text segment is a paragraph.
       * </pre>
       *
       * <code>PARAGRAPH = 2;</code>
       */
      public static final int PARAGRAPH_VALUE = 2;
      /**
       *
       *
       * <pre>
       * The text segment is a form field.
       * </pre>
       *
       * <code>FORM_FIELD = 3;</code>
       */
      public static final int FORM_FIELD_VALUE = 3;
      /**
       *
       *
       * <pre>
       * The text segment is the name part of a form field. It will be treated
       * as child of another FORM_FIELD TextSegment if its span is subspan of
       * another TextSegment with type FORM_FIELD.
       * </pre>
       *
       * <code>FORM_FIELD_NAME = 4;</code>
       */
      public static final int FORM_FIELD_NAME_VALUE = 4;
      /**
       *
       *
       * <pre>
       * The text segment is the text content part of a form field. It will be
       * treated as child of another FORM_FIELD TextSegment if its span is
       * subspan of another TextSegment with type FORM_FIELD.
       * </pre>
       *
       * <code>FORM_FIELD_CONTENTS = 5;</code>
       */
      public static final int FORM_FIELD_CONTENTS_VALUE = 5;
      /**
       *
       *
       * <pre>
       * The text segment is a whole table, including headers, and all rows.
       * </pre>
       *
       * <code>TABLE = 6;</code>
       */
      public static final int TABLE_VALUE = 6;
      /**
       *
       *
       * <pre>
       * The text segment is a table's headers. It will be treated as child of
       * another TABLE TextSegment if its span is subspan of another TextSegment
       * with type TABLE.
       * </pre>
       *
       * <code>TABLE_HEADER = 7;</code>
       */
      public static final int TABLE_HEADER_VALUE = 7;
      /**
       *
       *
       * <pre>
       * The text segment is a row in table. It will be treated as child of
       * another TABLE TextSegment if its span is subspan of another TextSegment
       * with type TABLE.
       * </pre>
       *
       * <code>TABLE_ROW = 8;</code>
       */
      public static final int TABLE_ROW_VALUE = 8;
      /**
       *
       *
       * <pre>
       * The text segment is a cell in table. It will be treated as child of
       * another TABLE_ROW TextSegment if its span is subspan of another
       * TextSegment with type TABLE_ROW.
       * </pre>
       *
       * <code>TABLE_CELL = 9;</code>
       */
      public static final int TABLE_CELL_VALUE = 9;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static TextSegmentType valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static TextSegmentType forNumber(int value) {
        switch (value) {
          case 0:
            return TEXT_SEGMENT_TYPE_UNSPECIFIED;
          case 1:
            return TOKEN;
          case 2:
            return PARAGRAPH;
          case 3:
            return FORM_FIELD;
          case 4:
            return FORM_FIELD_NAME;
          case 5:
            return FORM_FIELD_CONTENTS;
          case 6:
            return TABLE;
          case 7:
            return TABLE_HEADER;
          case 8:
            return TABLE_ROW;
          case 9:
            return TABLE_CELL;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<TextSegmentType>
          internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<TextSegmentType>
          internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<TextSegmentType>() {
                public TextSegmentType findValueByNumber(int number) {
                  return TextSegmentType.forNumber(number);
                }
              };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.automl.v1beta1.Document.Layout.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final TextSegmentType[] VALUES = values();

      public static TextSegmentType valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private TextSegmentType(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.automl.v1beta1.Document.Layout.TextSegmentType)
    }

    public static final int TEXT_SEGMENT_FIELD_NUMBER = 1;
    private com.google.cloud.automl.v1beta1.TextSegment textSegment_;
    /**
     *
     *
     * <pre>
     * Text Segment that represents a segment in
     * [document_text][google.cloud.automl.v1beta1.Document.document_text].
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.TextSegment text_segment = 1;</code>
     *
     * @return Whether the textSegment field is set.
     */
    @java.lang.Override
    public boolean hasTextSegment() {
      return textSegment_ != null;
    }
    /**
     *
     *
     * <pre>
     * Text Segment that represents a segment in
     * [document_text][google.cloud.automl.v1beta1.Document.document_text].
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.TextSegment text_segment = 1;</code>
     *
     * @return The textSegment.
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.TextSegment getTextSegment() {
      return textSegment_ == null
          ? com.google.cloud.automl.v1beta1.TextSegment.getDefaultInstance()
          : textSegment_;
    }
    /**
     *
     *
     * <pre>
     * Text Segment that represents a segment in
     * [document_text][google.cloud.automl.v1beta1.Document.document_text].
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.TextSegment text_segment = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.TextSegmentOrBuilder getTextSegmentOrBuilder() {
      return getTextSegment();
    }

    public static final int PAGE_NUMBER_FIELD_NUMBER = 2;
    private int pageNumber_;
    /**
     *
     *
     * <pre>
     * Page number of the [text_segment][google.cloud.automl.v1beta1.Document.Layout.text_segment] in the original document, starts
     * from 1.
     * </pre>
     *
     * <code>int32 page_number = 2;</code>
     *
     * @return The pageNumber.
     */
    @java.lang.Override
    public int getPageNumber() {
      return pageNumber_;
    }

    public static final int BOUNDING_POLY_FIELD_NUMBER = 3;
    private com.google.cloud.automl.v1beta1.BoundingPoly boundingPoly_;
    /**
     *
     *
     * <pre>
     * The position of the [text_segment][google.cloud.automl.v1beta1.Document.Layout.text_segment] in the page.
     * Contains exactly 4
     * [normalized_vertices][google.cloud.automl.v1beta1.BoundingPoly.normalized_vertices]
     * and they are connected by edges in the order provided, which will
     * represent a rectangle parallel to the frame. The
     * [NormalizedVertex-s][google.cloud.automl.v1beta1.NormalizedVertex] are
     * relative to the page.
     * Coordinates are based on top-left as point (0,0).
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.BoundingPoly bounding_poly = 3;</code>
     *
     * @return Whether the boundingPoly field is set.
     */
    @java.lang.Override
    public boolean hasBoundingPoly() {
      return boundingPoly_ != null;
    }
    /**
     *
     *
     * <pre>
     * The position of the [text_segment][google.cloud.automl.v1beta1.Document.Layout.text_segment] in the page.
     * Contains exactly 4
     * [normalized_vertices][google.cloud.automl.v1beta1.BoundingPoly.normalized_vertices]
     * and they are connected by edges in the order provided, which will
     * represent a rectangle parallel to the frame. The
     * [NormalizedVertex-s][google.cloud.automl.v1beta1.NormalizedVertex] are
     * relative to the page.
     * Coordinates are based on top-left as point (0,0).
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.BoundingPoly bounding_poly = 3;</code>
     *
     * @return The boundingPoly.
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.BoundingPoly getBoundingPoly() {
      return boundingPoly_ == null
          ? com.google.cloud.automl.v1beta1.BoundingPoly.getDefaultInstance()
          : boundingPoly_;
    }
    /**
     *
     *
     * <pre>
     * The position of the [text_segment][google.cloud.automl.v1beta1.Document.Layout.text_segment] in the page.
     * Contains exactly 4
     * [normalized_vertices][google.cloud.automl.v1beta1.BoundingPoly.normalized_vertices]
     * and they are connected by edges in the order provided, which will
     * represent a rectangle parallel to the frame. The
     * [NormalizedVertex-s][google.cloud.automl.v1beta1.NormalizedVertex] are
     * relative to the page.
     * Coordinates are based on top-left as point (0,0).
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.BoundingPoly bounding_poly = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.BoundingPolyOrBuilder getBoundingPolyOrBuilder() {
      return getBoundingPoly();
    }

    public static final int TEXT_SEGMENT_TYPE_FIELD_NUMBER = 4;
    private int textSegmentType_;
    /**
     *
     *
     * <pre>
     * The type of the [text_segment][google.cloud.automl.v1beta1.Document.Layout.text_segment] in document.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.Document.Layout.TextSegmentType text_segment_type = 4;
     * </code>
     *
     * @return The enum numeric value on the wire for textSegmentType.
     */
    @java.lang.Override
    public int getTextSegmentTypeValue() {
      return textSegmentType_;
    }
    /**
     *
     *
     * <pre>
     * The type of the [text_segment][google.cloud.automl.v1beta1.Document.Layout.text_segment] in document.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.Document.Layout.TextSegmentType text_segment_type = 4;
     * </code>
     *
     * @return The textSegmentType.
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.Document.Layout.TextSegmentType getTextSegmentType() {
      @SuppressWarnings("deprecation")
      com.google.cloud.automl.v1beta1.Document.Layout.TextSegmentType result =
          com.google.cloud.automl.v1beta1.Document.Layout.TextSegmentType.valueOf(textSegmentType_);
      return result == null
          ? com.google.cloud.automl.v1beta1.Document.Layout.TextSegmentType.UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (textSegment_ != null) {
        output.writeMessage(1, getTextSegment());
      }
      if (pageNumber_ != 0) {
        output.writeInt32(2, pageNumber_);
      }
      if (boundingPoly_ != null) {
        output.writeMessage(3, getBoundingPoly());
      }
      if (textSegmentType_
          != com.google.cloud.automl.v1beta1.Document.Layout.TextSegmentType
              .TEXT_SEGMENT_TYPE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(4, textSegmentType_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (textSegment_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getTextSegment());
      }
      if (pageNumber_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, pageNumber_);
      }
      if (boundingPoly_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getBoundingPoly());
      }
      if (textSegmentType_
          != com.google.cloud.automl.v1beta1.Document.Layout.TextSegmentType
              .TEXT_SEGMENT_TYPE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, textSegmentType_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.automl.v1beta1.Document.Layout)) {
        return super.equals(obj);
      }
      com.google.cloud.automl.v1beta1.Document.Layout other =
          (com.google.cloud.automl.v1beta1.Document.Layout) obj;

      if (hasTextSegment() != other.hasTextSegment()) return false;
      if (hasTextSegment()) {
        if (!getTextSegment().equals(other.getTextSegment())) return false;
      }
      if (getPageNumber() != other.getPageNumber()) return false;
      if (hasBoundingPoly() != other.hasBoundingPoly()) return false;
      if (hasBoundingPoly()) {
        if (!getBoundingPoly().equals(other.getBoundingPoly())) return false;
      }
      if (textSegmentType_ != other.textSegmentType_) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasTextSegment()) {
        hash = (37 * hash) + TEXT_SEGMENT_FIELD_NUMBER;
        hash = (53 * hash) + getTextSegment().hashCode();
      }
      hash = (37 * hash) + PAGE_NUMBER_FIELD_NUMBER;
      hash = (53 * hash) + getPageNumber();
      if (hasBoundingPoly()) {
        hash = (37 * hash) + BOUNDING_POLY_FIELD_NUMBER;
        hash = (53 * hash) + getBoundingPoly().hashCode();
      }
      hash = (37 * hash) + TEXT_SEGMENT_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + textSegmentType_;
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.automl.v1beta1.Document.Layout parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.automl.v1beta1.Document.Layout parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.automl.v1beta1.Document.Layout parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.automl.v1beta1.Document.Layout parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.automl.v1beta1.Document.Layout parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.automl.v1beta1.Document.Layout parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.automl.v1beta1.Document.Layout parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.automl.v1beta1.Document.Layout parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.automl.v1beta1.Document.Layout parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.automl.v1beta1.Document.Layout parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.automl.v1beta1.Document.Layout parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.automl.v1beta1.Document.Layout parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloud.automl.v1beta1.Document.Layout prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Describes the layout information of a [text_segment][google.cloud.automl.v1beta1.Document.Layout.text_segment] in the document.
     * </pre>
     *
     * Protobuf type {@code google.cloud.automl.v1beta1.Document.Layout}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.automl.v1beta1.Document.Layout)
        com.google.cloud.automl.v1beta1.Document.LayoutOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.automl.v1beta1.DataItems
            .internal_static_google_cloud_automl_v1beta1_Document_Layout_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.automl.v1beta1.DataItems
            .internal_static_google_cloud_automl_v1beta1_Document_Layout_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.automl.v1beta1.Document.Layout.class,
                com.google.cloud.automl.v1beta1.Document.Layout.Builder.class);
      }

      // Construct using com.google.cloud.automl.v1beta1.Document.Layout.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (textSegmentBuilder_ == null) {
          textSegment_ = null;
        } else {
          textSegment_ = null;
          textSegmentBuilder_ = null;
        }
        pageNumber_ = 0;

        if (boundingPolyBuilder_ == null) {
          boundingPoly_ = null;
        } else {
          boundingPoly_ = null;
          boundingPolyBuilder_ = null;
        }
        textSegmentType_ = 0;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.automl.v1beta1.DataItems
            .internal_static_google_cloud_automl_v1beta1_Document_Layout_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.automl.v1beta1.Document.Layout getDefaultInstanceForType() {
        return com.google.cloud.automl.v1beta1.Document.Layout.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.automl.v1beta1.Document.Layout build() {
        com.google.cloud.automl.v1beta1.Document.Layout result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.automl.v1beta1.Document.Layout buildPartial() {
        com.google.cloud.automl.v1beta1.Document.Layout result =
            new com.google.cloud.automl.v1beta1.Document.Layout(this);
        if (textSegmentBuilder_ == null) {
          result.textSegment_ = textSegment_;
        } else {
          result.textSegment_ = textSegmentBuilder_.build();
        }
        result.pageNumber_ = pageNumber_;
        if (boundingPolyBuilder_ == null) {
          result.boundingPoly_ = boundingPoly_;
        } else {
          result.boundingPoly_ = boundingPolyBuilder_.build();
        }
        result.textSegmentType_ = textSegmentType_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.automl.v1beta1.Document.Layout) {
          return mergeFrom((com.google.cloud.automl.v1beta1.Document.Layout) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.automl.v1beta1.Document.Layout other) {
        if (other == com.google.cloud.automl.v1beta1.Document.Layout.getDefaultInstance())
          return this;
        if (other.hasTextSegment()) {
          mergeTextSegment(other.getTextSegment());
        }
        if (other.getPageNumber() != 0) {
          setPageNumber(other.getPageNumber());
        }
        if (other.hasBoundingPoly()) {
          mergeBoundingPoly(other.getBoundingPoly());
        }
        if (other.textSegmentType_ != 0) {
          setTextSegmentTypeValue(other.getTextSegmentTypeValue());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.automl.v1beta1.Document.Layout parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.automl.v1beta1.Document.Layout) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private com.google.cloud.automl.v1beta1.TextSegment textSegment_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.automl.v1beta1.TextSegment,
              com.google.cloud.automl.v1beta1.TextSegment.Builder,
              com.google.cloud.automl.v1beta1.TextSegmentOrBuilder>
          textSegmentBuilder_;
      /**
       *
       *
       * <pre>
       * Text Segment that represents a segment in
       * [document_text][google.cloud.automl.v1beta1.Document.document_text].
       * </pre>
       *
       * <code>.google.cloud.automl.v1beta1.TextSegment text_segment = 1;</code>
       *
       * @return Whether the textSegment field is set.
       */
      public boolean hasTextSegment() {
        return textSegmentBuilder_ != null || textSegment_ != null;
      }
      /**
       *
       *
       * <pre>
       * Text Segment that represents a segment in
       * [document_text][google.cloud.automl.v1beta1.Document.document_text].
       * </pre>
       *
       * <code>.google.cloud.automl.v1beta1.TextSegment text_segment = 1;</code>
       *
       * @return The textSegment.
       */
      public com.google.cloud.automl.v1beta1.TextSegment getTextSegment() {
        if (textSegmentBuilder_ == null) {
          return textSegment_ == null
              ? com.google.cloud.automl.v1beta1.TextSegment.getDefaultInstance()
              : textSegment_;
        } else {
          return textSegmentBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Text Segment that represents a segment in
       * [document_text][google.cloud.automl.v1beta1.Document.document_text].
       * </pre>
       *
       * <code>.google.cloud.automl.v1beta1.TextSegment text_segment = 1;</code>
       */
      public Builder setTextSegment(com.google.cloud.automl.v1beta1.TextSegment value) {
        if (textSegmentBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          textSegment_ = value;
          onChanged();
        } else {
          textSegmentBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Text Segment that represents a segment in
       * [document_text][google.cloud.automl.v1beta1.Document.document_text].
       * </pre>
       *
       * <code>.google.cloud.automl.v1beta1.TextSegment text_segment = 1;</code>
       */
      public Builder setTextSegment(
          com.google.cloud.automl.v1beta1.TextSegment.Builder builderForValue) {
        if (textSegmentBuilder_ == null) {
          textSegment_ = builderForValue.build();
          onChanged();
        } else {
          textSegmentBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Text Segment that represents a segment in
       * [document_text][google.cloud.automl.v1beta1.Document.document_text].
       * </pre>
       *
       * <code>.google.cloud.automl.v1beta1.TextSegment text_segment = 1;</code>
       */
      public Builder mergeTextSegment(com.google.cloud.automl.v1beta1.TextSegment value) {
        if (textSegmentBuilder_ == null) {
          if (textSegment_ != null) {
            textSegment_ =
                com.google.cloud.automl.v1beta1.TextSegment.newBuilder(textSegment_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            textSegment_ = value;
          }
          onChanged();
        } else {
          textSegmentBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Text Segment that represents a segment in
       * [document_text][google.cloud.automl.v1beta1.Document.document_text].
       * </pre>
       *
       * <code>.google.cloud.automl.v1beta1.TextSegment text_segment = 1;</code>
       */
      public Builder clearTextSegment() {
        if (textSegmentBuilder_ == null) {
          textSegment_ = null;
          onChanged();
        } else {
          textSegment_ = null;
          textSegmentBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Text Segment that represents a segment in
       * [document_text][google.cloud.automl.v1beta1.Document.document_text].
       * </pre>
       *
       * <code>.google.cloud.automl.v1beta1.TextSegment text_segment = 1;</code>
       */
      public com.google.cloud.automl.v1beta1.TextSegment.Builder getTextSegmentBuilder() {

        onChanged();
        return getTextSegmentFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Text Segment that represents a segment in
       * [document_text][google.cloud.automl.v1beta1.Document.document_text].
       * </pre>
       *
       * <code>.google.cloud.automl.v1beta1.TextSegment text_segment = 1;</code>
       */
      public com.google.cloud.automl.v1beta1.TextSegmentOrBuilder getTextSegmentOrBuilder() {
        if (textSegmentBuilder_ != null) {
          return textSegmentBuilder_.getMessageOrBuilder();
        } else {
          return textSegment_ == null
              ? com.google.cloud.automl.v1beta1.TextSegment.getDefaultInstance()
              : textSegment_;
        }
      }
      /**
       *
       *
       * <pre>
       * Text Segment that represents a segment in
       * [document_text][google.cloud.automl.v1beta1.Document.document_text].
       * </pre>
       *
       * <code>.google.cloud.automl.v1beta1.TextSegment text_segment = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.automl.v1beta1.TextSegment,
              com.google.cloud.automl.v1beta1.TextSegment.Builder,
              com.google.cloud.automl.v1beta1.TextSegmentOrBuilder>
          getTextSegmentFieldBuilder() {
        if (textSegmentBuilder_ == null) {
          textSegmentBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.automl.v1beta1.TextSegment,
                  com.google.cloud.automl.v1beta1.TextSegment.Builder,
                  com.google.cloud.automl.v1beta1.TextSegmentOrBuilder>(
                  getTextSegment(), getParentForChildren(), isClean());
          textSegment_ = null;
        }
        return textSegmentBuilder_;
      }

      private int pageNumber_;
      /**
       *
       *
       * <pre>
       * Page number of the [text_segment][google.cloud.automl.v1beta1.Document.Layout.text_segment] in the original document, starts
       * from 1.
       * </pre>
       *
       * <code>int32 page_number = 2;</code>
       *
       * @return The pageNumber.
       */
      @java.lang.Override
      public int getPageNumber() {
        return pageNumber_;
      }
      /**
       *
       *
       * <pre>
       * Page number of the [text_segment][google.cloud.automl.v1beta1.Document.Layout.text_segment] in the original document, starts
       * from 1.
       * </pre>
       *
       * <code>int32 page_number = 2;</code>
       *
       * @param value The pageNumber to set.
       * @return This builder for chaining.
       */
      public Builder setPageNumber(int value) {

        pageNumber_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Page number of the [text_segment][google.cloud.automl.v1beta1.Document.Layout.text_segment] in the original document, starts
       * from 1.
       * </pre>
       *
       * <code>int32 page_number = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPageNumber() {

        pageNumber_ = 0;
        onChanged();
        return this;
      }

      private com.google.cloud.automl.v1beta1.BoundingPoly boundingPoly_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.automl.v1beta1.BoundingPoly,
              com.google.cloud.automl.v1beta1.BoundingPoly.Builder,
              com.google.cloud.automl.v1beta1.BoundingPolyOrBuilder>
          boundingPolyBuilder_;
      /**
       *
       *
       * <pre>
       * The position of the [text_segment][google.cloud.automl.v1beta1.Document.Layout.text_segment] in the page.
       * Contains exactly 4
       * [normalized_vertices][google.cloud.automl.v1beta1.BoundingPoly.normalized_vertices]
       * and they are connected by edges in the order provided, which will
       * represent a rectangle parallel to the frame. The
       * [NormalizedVertex-s][google.cloud.automl.v1beta1.NormalizedVertex] are
       * relative to the page.
       * Coordinates are based on top-left as point (0,0).
       * </pre>
       *
       * <code>.google.cloud.automl.v1beta1.BoundingPoly bounding_poly = 3;</code>
       *
       * @return Whether the boundingPoly field is set.
       */
      public boolean hasBoundingPoly() {
        return boundingPolyBuilder_ != null || boundingPoly_ != null;
      }
      /**
       *
       *
       * <pre>
       * The position of the [text_segment][google.cloud.automl.v1beta1.Document.Layout.text_segment] in the page.
       * Contains exactly 4
       * [normalized_vertices][google.cloud.automl.v1beta1.BoundingPoly.normalized_vertices]
       * and they are connected by edges in the order provided, which will
       * represent a rectangle parallel to the frame. The
       * [NormalizedVertex-s][google.cloud.automl.v1beta1.NormalizedVertex] are
       * relative to the page.
       * Coordinates are based on top-left as point (0,0).
       * </pre>
       *
       * <code>.google.cloud.automl.v1beta1.BoundingPoly bounding_poly = 3;</code>
       *
       * @return The boundingPoly.
       */
      public com.google.cloud.automl.v1beta1.BoundingPoly getBoundingPoly() {
        if (boundingPolyBuilder_ == null) {
          return boundingPoly_ == null
              ? com.google.cloud.automl.v1beta1.BoundingPoly.getDefaultInstance()
              : boundingPoly_;
        } else {
          return boundingPolyBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The position of the [text_segment][google.cloud.automl.v1beta1.Document.Layout.text_segment] in the page.
       * Contains exactly 4
       * [normalized_vertices][google.cloud.automl.v1beta1.BoundingPoly.normalized_vertices]
       * and they are connected by edges in the order provided, which will
       * represent a rectangle parallel to the frame. The
       * [NormalizedVertex-s][google.cloud.automl.v1beta1.NormalizedVertex] are
       * relative to the page.
       * Coordinates are based on top-left as point (0,0).
       * </pre>
       *
       * <code>.google.cloud.automl.v1beta1.BoundingPoly bounding_poly = 3;</code>
       */
      public Builder setBoundingPoly(com.google.cloud.automl.v1beta1.BoundingPoly value) {
        if (boundingPolyBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          boundingPoly_ = value;
          onChanged();
        } else {
          boundingPolyBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The position of the [text_segment][google.cloud.automl.v1beta1.Document.Layout.text_segment] in the page.
       * Contains exactly 4
       * [normalized_vertices][google.cloud.automl.v1beta1.BoundingPoly.normalized_vertices]
       * and they are connected by edges in the order provided, which will
       * represent a rectangle parallel to the frame. The
       * [NormalizedVertex-s][google.cloud.automl.v1beta1.NormalizedVertex] are
       * relative to the page.
       * Coordinates are based on top-left as point (0,0).
       * </pre>
       *
       * <code>.google.cloud.automl.v1beta1.BoundingPoly bounding_poly = 3;</code>
       */
      public Builder setBoundingPoly(
          com.google.cloud.automl.v1beta1.BoundingPoly.Builder builderForValue) {
        if (boundingPolyBuilder_ == null) {
          boundingPoly_ = builderForValue.build();
          onChanged();
        } else {
          boundingPolyBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The position of the [text_segment][google.cloud.automl.v1beta1.Document.Layout.text_segment] in the page.
       * Contains exactly 4
       * [normalized_vertices][google.cloud.automl.v1beta1.BoundingPoly.normalized_vertices]
       * and they are connected by edges in the order provided, which will
       * represent a rectangle parallel to the frame. The
       * [NormalizedVertex-s][google.cloud.automl.v1beta1.NormalizedVertex] are
       * relative to the page.
       * Coordinates are based on top-left as point (0,0).
       * </pre>
       *
       * <code>.google.cloud.automl.v1beta1.BoundingPoly bounding_poly = 3;</code>
       */
      public Builder mergeBoundingPoly(com.google.cloud.automl.v1beta1.BoundingPoly value) {
        if (boundingPolyBuilder_ == null) {
          if (boundingPoly_ != null) {
            boundingPoly_ =
                com.google.cloud.automl.v1beta1.BoundingPoly.newBuilder(boundingPoly_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            boundingPoly_ = value;
          }
          onChanged();
        } else {
          boundingPolyBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The position of the [text_segment][google.cloud.automl.v1beta1.Document.Layout.text_segment] in the page.
       * Contains exactly 4
       * [normalized_vertices][google.cloud.automl.v1beta1.BoundingPoly.normalized_vertices]
       * and they are connected by edges in the order provided, which will
       * represent a rectangle parallel to the frame. The
       * [NormalizedVertex-s][google.cloud.automl.v1beta1.NormalizedVertex] are
       * relative to the page.
       * Coordinates are based on top-left as point (0,0).
       * </pre>
       *
       * <code>.google.cloud.automl.v1beta1.BoundingPoly bounding_poly = 3;</code>
       */
      public Builder clearBoundingPoly() {
        if (boundingPolyBuilder_ == null) {
          boundingPoly_ = null;
          onChanged();
        } else {
          boundingPoly_ = null;
          boundingPolyBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The position of the [text_segment][google.cloud.automl.v1beta1.Document.Layout.text_segment] in the page.
       * Contains exactly 4
       * [normalized_vertices][google.cloud.automl.v1beta1.BoundingPoly.normalized_vertices]
       * and they are connected by edges in the order provided, which will
       * represent a rectangle parallel to the frame. The
       * [NormalizedVertex-s][google.cloud.automl.v1beta1.NormalizedVertex] are
       * relative to the page.
       * Coordinates are based on top-left as point (0,0).
       * </pre>
       *
       * <code>.google.cloud.automl.v1beta1.BoundingPoly bounding_poly = 3;</code>
       */
      public com.google.cloud.automl.v1beta1.BoundingPoly.Builder getBoundingPolyBuilder() {

        onChanged();
        return getBoundingPolyFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The position of the [text_segment][google.cloud.automl.v1beta1.Document.Layout.text_segment] in the page.
       * Contains exactly 4
       * [normalized_vertices][google.cloud.automl.v1beta1.BoundingPoly.normalized_vertices]
       * and they are connected by edges in the order provided, which will
       * represent a rectangle parallel to the frame. The
       * [NormalizedVertex-s][google.cloud.automl.v1beta1.NormalizedVertex] are
       * relative to the page.
       * Coordinates are based on top-left as point (0,0).
       * </pre>
       *
       * <code>.google.cloud.automl.v1beta1.BoundingPoly bounding_poly = 3;</code>
       */
      public com.google.cloud.automl.v1beta1.BoundingPolyOrBuilder getBoundingPolyOrBuilder() {
        if (boundingPolyBuilder_ != null) {
          return boundingPolyBuilder_.getMessageOrBuilder();
        } else {
          return boundingPoly_ == null
              ? com.google.cloud.automl.v1beta1.BoundingPoly.getDefaultInstance()
              : boundingPoly_;
        }
      }
      /**
       *
       *
       * <pre>
       * The position of the [text_segment][google.cloud.automl.v1beta1.Document.Layout.text_segment] in the page.
       * Contains exactly 4
       * [normalized_vertices][google.cloud.automl.v1beta1.BoundingPoly.normalized_vertices]
       * and they are connected by edges in the order provided, which will
       * represent a rectangle parallel to the frame. The
       * [NormalizedVertex-s][google.cloud.automl.v1beta1.NormalizedVertex] are
       * relative to the page.
       * Coordinates are based on top-left as point (0,0).
       * </pre>
       *
       * <code>.google.cloud.automl.v1beta1.BoundingPoly bounding_poly = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.automl.v1beta1.BoundingPoly,
              com.google.cloud.automl.v1beta1.BoundingPoly.Builder,
              com.google.cloud.automl.v1beta1.BoundingPolyOrBuilder>
          getBoundingPolyFieldBuilder() {
        if (boundingPolyBuilder_ == null) {
          boundingPolyBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.automl.v1beta1.BoundingPoly,
                  com.google.cloud.automl.v1beta1.BoundingPoly.Builder,
                  com.google.cloud.automl.v1beta1.BoundingPolyOrBuilder>(
                  getBoundingPoly(), getParentForChildren(), isClean());
          boundingPoly_ = null;
        }
        return boundingPolyBuilder_;
      }

      private int textSegmentType_ = 0;
      /**
       *
       *
       * <pre>
       * The type of the [text_segment][google.cloud.automl.v1beta1.Document.Layout.text_segment] in document.
       * </pre>
       *
       * <code>.google.cloud.automl.v1beta1.Document.Layout.TextSegmentType text_segment_type = 4;
       * </code>
       *
       * @return The enum numeric value on the wire for textSegmentType.
       */
      @java.lang.Override
      public int getTextSegmentTypeValue() {
        return textSegmentType_;
      }
      /**
       *
       *
       * <pre>
       * The type of the [text_segment][google.cloud.automl.v1beta1.Document.Layout.text_segment] in document.
       * </pre>
       *
       * <code>.google.cloud.automl.v1beta1.Document.Layout.TextSegmentType text_segment_type = 4;
       * </code>
       *
       * @param value The enum numeric value on the wire for textSegmentType to set.
       * @return This builder for chaining.
       */
      public Builder setTextSegmentTypeValue(int value) {

        textSegmentType_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The type of the [text_segment][google.cloud.automl.v1beta1.Document.Layout.text_segment] in document.
       * </pre>
       *
       * <code>.google.cloud.automl.v1beta1.Document.Layout.TextSegmentType text_segment_type = 4;
       * </code>
       *
       * @return The textSegmentType.
       */
      @java.lang.Override
      public com.google.cloud.automl.v1beta1.Document.Layout.TextSegmentType getTextSegmentType() {
        @SuppressWarnings("deprecation")
        com.google.cloud.automl.v1beta1.Document.Layout.TextSegmentType result =
            com.google.cloud.automl.v1beta1.Document.Layout.TextSegmentType.valueOf(
                textSegmentType_);
        return result == null
            ? com.google.cloud.automl.v1beta1.Document.Layout.TextSegmentType.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * The type of the [text_segment][google.cloud.automl.v1beta1.Document.Layout.text_segment] in document.
       * </pre>
       *
       * <code>.google.cloud.automl.v1beta1.Document.Layout.TextSegmentType text_segment_type = 4;
       * </code>
       *
       * @param value The textSegmentType to set.
       * @return This builder for chaining.
       */
      public Builder setTextSegmentType(
          com.google.cloud.automl.v1beta1.Document.Layout.TextSegmentType value) {
        if (value == null) {
          throw new NullPointerException();
        }

        textSegmentType_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The type of the [text_segment][google.cloud.automl.v1beta1.Document.Layout.text_segment] in document.
       * </pre>
       *
       * <code>.google.cloud.automl.v1beta1.Document.Layout.TextSegmentType text_segment_type = 4;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTextSegmentType() {

        textSegmentType_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.automl.v1beta1.Document.Layout)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.automl.v1beta1.Document.Layout)
    private static final com.google.cloud.automl.v1beta1.Document.Layout DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.automl.v1beta1.Document.Layout();
    }

    public static com.google.cloud.automl.v1beta1.Document.Layout getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Layout> PARSER =
        new com.google.protobuf.AbstractParser<Layout>() {
          @java.lang.Override
          public Layout parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new Layout(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<Layout> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Layout> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.Document.Layout getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int INPUT_CONFIG_FIELD_NUMBER = 1;
  private com.google.cloud.automl.v1beta1.DocumentInputConfig inputConfig_;
  /**
   *
   *
   * <pre>
   * An input config specifying the content of the document.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.DocumentInputConfig input_config = 1;</code>
   *
   * @return Whether the inputConfig field is set.
   */
  @java.lang.Override
  public boolean hasInputConfig() {
    return inputConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * An input config specifying the content of the document.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.DocumentInputConfig input_config = 1;</code>
   *
   * @return The inputConfig.
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.DocumentInputConfig getInputConfig() {
    return inputConfig_ == null
        ? com.google.cloud.automl.v1beta1.DocumentInputConfig.getDefaultInstance()
        : inputConfig_;
  }
  /**
   *
   *
   * <pre>
   * An input config specifying the content of the document.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.DocumentInputConfig input_config = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.DocumentInputConfigOrBuilder getInputConfigOrBuilder() {
    return getInputConfig();
  }

  public static final int DOCUMENT_TEXT_FIELD_NUMBER = 2;
  private com.google.cloud.automl.v1beta1.TextSnippet documentText_;
  /**
   *
   *
   * <pre>
   * The plain text version of this document.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.TextSnippet document_text = 2;</code>
   *
   * @return Whether the documentText field is set.
   */
  @java.lang.Override
  public boolean hasDocumentText() {
    return documentText_ != null;
  }
  /**
   *
   *
   * <pre>
   * The plain text version of this document.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.TextSnippet document_text = 2;</code>
   *
   * @return The documentText.
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.TextSnippet getDocumentText() {
    return documentText_ == null
        ? com.google.cloud.automl.v1beta1.TextSnippet.getDefaultInstance()
        : documentText_;
  }
  /**
   *
   *
   * <pre>
   * The plain text version of this document.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.TextSnippet document_text = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.TextSnippetOrBuilder getDocumentTextOrBuilder() {
    return getDocumentText();
  }

  public static final int LAYOUT_FIELD_NUMBER = 3;
  private java.util.List<com.google.cloud.automl.v1beta1.Document.Layout> layout_;
  /**
   *
   *
   * <pre>
   * Describes the layout of the document.
   * Sorted by [page_number][].
   * </pre>
   *
   * <code>repeated .google.cloud.automl.v1beta1.Document.Layout layout = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.automl.v1beta1.Document.Layout> getLayoutList() {
    return layout_;
  }
  /**
   *
   *
   * <pre>
   * Describes the layout of the document.
   * Sorted by [page_number][].
   * </pre>
   *
   * <code>repeated .google.cloud.automl.v1beta1.Document.Layout layout = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.automl.v1beta1.Document.LayoutOrBuilder>
      getLayoutOrBuilderList() {
    return layout_;
  }
  /**
   *
   *
   * <pre>
   * Describes the layout of the document.
   * Sorted by [page_number][].
   * </pre>
   *
   * <code>repeated .google.cloud.automl.v1beta1.Document.Layout layout = 3;</code>
   */
  @java.lang.Override
  public int getLayoutCount() {
    return layout_.size();
  }
  /**
   *
   *
   * <pre>
   * Describes the layout of the document.
   * Sorted by [page_number][].
   * </pre>
   *
   * <code>repeated .google.cloud.automl.v1beta1.Document.Layout layout = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.Document.Layout getLayout(int index) {
    return layout_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Describes the layout of the document.
   * Sorted by [page_number][].
   * </pre>
   *
   * <code>repeated .google.cloud.automl.v1beta1.Document.Layout layout = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.Document.LayoutOrBuilder getLayoutOrBuilder(int index) {
    return layout_.get(index);
  }

  public static final int DOCUMENT_DIMENSIONS_FIELD_NUMBER = 4;
  private com.google.cloud.automl.v1beta1.DocumentDimensions documentDimensions_;
  /**
   *
   *
   * <pre>
   * The dimensions of the page in the document.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.DocumentDimensions document_dimensions = 4;</code>
   *
   * @return Whether the documentDimensions field is set.
   */
  @java.lang.Override
  public boolean hasDocumentDimensions() {
    return documentDimensions_ != null;
  }
  /**
   *
   *
   * <pre>
   * The dimensions of the page in the document.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.DocumentDimensions document_dimensions = 4;</code>
   *
   * @return The documentDimensions.
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.DocumentDimensions getDocumentDimensions() {
    return documentDimensions_ == null
        ? com.google.cloud.automl.v1beta1.DocumentDimensions.getDefaultInstance()
        : documentDimensions_;
  }
  /**
   *
   *
   * <pre>
   * The dimensions of the page in the document.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.DocumentDimensions document_dimensions = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.DocumentDimensionsOrBuilder
      getDocumentDimensionsOrBuilder() {
    return getDocumentDimensions();
  }

  public static final int PAGE_COUNT_FIELD_NUMBER = 5;
  private int pageCount_;
  /**
   *
   *
   * <pre>
   * Number of pages in the document.
   * </pre>
   *
   * <code>int32 page_count = 5;</code>
   *
   * @return The pageCount.
   */
  @java.lang.Override
  public int getPageCount() {
    return pageCount_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (inputConfig_ != null) {
      output.writeMessage(1, getInputConfig());
    }
    if (documentText_ != null) {
      output.writeMessage(2, getDocumentText());
    }
    for (int i = 0; i < layout_.size(); i++) {
      output.writeMessage(3, layout_.get(i));
    }
    if (documentDimensions_ != null) {
      output.writeMessage(4, getDocumentDimensions());
    }
    if (pageCount_ != 0) {
      output.writeInt32(5, pageCount_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (inputConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getInputConfig());
    }
    if (documentText_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getDocumentText());
    }
    for (int i = 0; i < layout_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, layout_.get(i));
    }
    if (documentDimensions_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getDocumentDimensions());
    }
    if (pageCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(5, pageCount_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.automl.v1beta1.Document)) {
      return super.equals(obj);
    }
    com.google.cloud.automl.v1beta1.Document other = (com.google.cloud.automl.v1beta1.Document) obj;

    if (hasInputConfig() != other.hasInputConfig()) return false;
    if (hasInputConfig()) {
      if (!getInputConfig().equals(other.getInputConfig())) return false;
    }
    if (hasDocumentText() != other.hasDocumentText()) return false;
    if (hasDocumentText()) {
      if (!getDocumentText().equals(other.getDocumentText())) return false;
    }
    if (!getLayoutList().equals(other.getLayoutList())) return false;
    if (hasDocumentDimensions() != other.hasDocumentDimensions()) return false;
    if (hasDocumentDimensions()) {
      if (!getDocumentDimensions().equals(other.getDocumentDimensions())) return false;
    }
    if (getPageCount() != other.getPageCount()) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasInputConfig()) {
      hash = (37 * hash) + INPUT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getInputConfig().hashCode();
    }
    if (hasDocumentText()) {
      hash = (37 * hash) + DOCUMENT_TEXT_FIELD_NUMBER;
      hash = (53 * hash) + getDocumentText().hashCode();
    }
    if (getLayoutCount() > 0) {
      hash = (37 * hash) + LAYOUT_FIELD_NUMBER;
      hash = (53 * hash) + getLayoutList().hashCode();
    }
    if (hasDocumentDimensions()) {
      hash = (37 * hash) + DOCUMENT_DIMENSIONS_FIELD_NUMBER;
      hash = (53 * hash) + getDocumentDimensions().hashCode();
    }
    hash = (37 * hash) + PAGE_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getPageCount();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.automl.v1beta1.Document parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1beta1.Document parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.Document parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1beta1.Document parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.Document parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1beta1.Document parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.Document parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1beta1.Document parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.Document parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1beta1.Document parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.Document parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1beta1.Document parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.automl.v1beta1.Document prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A structured text document e.g. a PDF.
   * </pre>
   *
   * Protobuf type {@code google.cloud.automl.v1beta1.Document}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.automl.v1beta1.Document)
      com.google.cloud.automl.v1beta1.DocumentOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.automl.v1beta1.DataItems
          .internal_static_google_cloud_automl_v1beta1_Document_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.automl.v1beta1.DataItems
          .internal_static_google_cloud_automl_v1beta1_Document_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.automl.v1beta1.Document.class,
              com.google.cloud.automl.v1beta1.Document.Builder.class);
    }

    // Construct using com.google.cloud.automl.v1beta1.Document.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getLayoutFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (inputConfigBuilder_ == null) {
        inputConfig_ = null;
      } else {
        inputConfig_ = null;
        inputConfigBuilder_ = null;
      }
      if (documentTextBuilder_ == null) {
        documentText_ = null;
      } else {
        documentText_ = null;
        documentTextBuilder_ = null;
      }
      if (layoutBuilder_ == null) {
        layout_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        layoutBuilder_.clear();
      }
      if (documentDimensionsBuilder_ == null) {
        documentDimensions_ = null;
      } else {
        documentDimensions_ = null;
        documentDimensionsBuilder_ = null;
      }
      pageCount_ = 0;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.automl.v1beta1.DataItems
          .internal_static_google_cloud_automl_v1beta1_Document_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.Document getDefaultInstanceForType() {
      return com.google.cloud.automl.v1beta1.Document.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.Document build() {
      com.google.cloud.automl.v1beta1.Document result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.Document buildPartial() {
      com.google.cloud.automl.v1beta1.Document result =
          new com.google.cloud.automl.v1beta1.Document(this);
      int from_bitField0_ = bitField0_;
      if (inputConfigBuilder_ == null) {
        result.inputConfig_ = inputConfig_;
      } else {
        result.inputConfig_ = inputConfigBuilder_.build();
      }
      if (documentTextBuilder_ == null) {
        result.documentText_ = documentText_;
      } else {
        result.documentText_ = documentTextBuilder_.build();
      }
      if (layoutBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          layout_ = java.util.Collections.unmodifiableList(layout_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.layout_ = layout_;
      } else {
        result.layout_ = layoutBuilder_.build();
      }
      if (documentDimensionsBuilder_ == null) {
        result.documentDimensions_ = documentDimensions_;
      } else {
        result.documentDimensions_ = documentDimensionsBuilder_.build();
      }
      result.pageCount_ = pageCount_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.automl.v1beta1.Document) {
        return mergeFrom((com.google.cloud.automl.v1beta1.Document) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.automl.v1beta1.Document other) {
      if (other == com.google.cloud.automl.v1beta1.Document.getDefaultInstance()) return this;
      if (other.hasInputConfig()) {
        mergeInputConfig(other.getInputConfig());
      }
      if (other.hasDocumentText()) {
        mergeDocumentText(other.getDocumentText());
      }
      if (layoutBuilder_ == null) {
        if (!other.layout_.isEmpty()) {
          if (layout_.isEmpty()) {
            layout_ = other.layout_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureLayoutIsMutable();
            layout_.addAll(other.layout_);
          }
          onChanged();
        }
      } else {
        if (!other.layout_.isEmpty()) {
          if (layoutBuilder_.isEmpty()) {
            layoutBuilder_.dispose();
            layoutBuilder_ = null;
            layout_ = other.layout_;
            bitField0_ = (bitField0_ & ~0x00000001);
            layoutBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getLayoutFieldBuilder()
                    : null;
          } else {
            layoutBuilder_.addAllMessages(other.layout_);
          }
        }
      }
      if (other.hasDocumentDimensions()) {
        mergeDocumentDimensions(other.getDocumentDimensions());
      }
      if (other.getPageCount() != 0) {
        setPageCount(other.getPageCount());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.automl.v1beta1.Document parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloud.automl.v1beta1.Document) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private com.google.cloud.automl.v1beta1.DocumentInputConfig inputConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.DocumentInputConfig,
            com.google.cloud.automl.v1beta1.DocumentInputConfig.Builder,
            com.google.cloud.automl.v1beta1.DocumentInputConfigOrBuilder>
        inputConfigBuilder_;
    /**
     *
     *
     * <pre>
     * An input config specifying the content of the document.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DocumentInputConfig input_config = 1;</code>
     *
     * @return Whether the inputConfig field is set.
     */
    public boolean hasInputConfig() {
      return inputConfigBuilder_ != null || inputConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * An input config specifying the content of the document.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DocumentInputConfig input_config = 1;</code>
     *
     * @return The inputConfig.
     */
    public com.google.cloud.automl.v1beta1.DocumentInputConfig getInputConfig() {
      if (inputConfigBuilder_ == null) {
        return inputConfig_ == null
            ? com.google.cloud.automl.v1beta1.DocumentInputConfig.getDefaultInstance()
            : inputConfig_;
      } else {
        return inputConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * An input config specifying the content of the document.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DocumentInputConfig input_config = 1;</code>
     */
    public Builder setInputConfig(com.google.cloud.automl.v1beta1.DocumentInputConfig value) {
      if (inputConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        inputConfig_ = value;
        onChanged();
      } else {
        inputConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * An input config specifying the content of the document.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DocumentInputConfig input_config = 1;</code>
     */
    public Builder setInputConfig(
        com.google.cloud.automl.v1beta1.DocumentInputConfig.Builder builderForValue) {
      if (inputConfigBuilder_ == null) {
        inputConfig_ = builderForValue.build();
        onChanged();
      } else {
        inputConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * An input config specifying the content of the document.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DocumentInputConfig input_config = 1;</code>
     */
    public Builder mergeInputConfig(com.google.cloud.automl.v1beta1.DocumentInputConfig value) {
      if (inputConfigBuilder_ == null) {
        if (inputConfig_ != null) {
          inputConfig_ =
              com.google.cloud.automl.v1beta1.DocumentInputConfig.newBuilder(inputConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          inputConfig_ = value;
        }
        onChanged();
      } else {
        inputConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * An input config specifying the content of the document.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DocumentInputConfig input_config = 1;</code>
     */
    public Builder clearInputConfig() {
      if (inputConfigBuilder_ == null) {
        inputConfig_ = null;
        onChanged();
      } else {
        inputConfig_ = null;
        inputConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * An input config specifying the content of the document.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DocumentInputConfig input_config = 1;</code>
     */
    public com.google.cloud.automl.v1beta1.DocumentInputConfig.Builder getInputConfigBuilder() {

      onChanged();
      return getInputConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * An input config specifying the content of the document.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DocumentInputConfig input_config = 1;</code>
     */
    public com.google.cloud.automl.v1beta1.DocumentInputConfigOrBuilder getInputConfigOrBuilder() {
      if (inputConfigBuilder_ != null) {
        return inputConfigBuilder_.getMessageOrBuilder();
      } else {
        return inputConfig_ == null
            ? com.google.cloud.automl.v1beta1.DocumentInputConfig.getDefaultInstance()
            : inputConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * An input config specifying the content of the document.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DocumentInputConfig input_config = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.DocumentInputConfig,
            com.google.cloud.automl.v1beta1.DocumentInputConfig.Builder,
            com.google.cloud.automl.v1beta1.DocumentInputConfigOrBuilder>
        getInputConfigFieldBuilder() {
      if (inputConfigBuilder_ == null) {
        inputConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.automl.v1beta1.DocumentInputConfig,
                com.google.cloud.automl.v1beta1.DocumentInputConfig.Builder,
                com.google.cloud.automl.v1beta1.DocumentInputConfigOrBuilder>(
                getInputConfig(), getParentForChildren(), isClean());
        inputConfig_ = null;
      }
      return inputConfigBuilder_;
    }

    private com.google.cloud.automl.v1beta1.TextSnippet documentText_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.TextSnippet,
            com.google.cloud.automl.v1beta1.TextSnippet.Builder,
            com.google.cloud.automl.v1beta1.TextSnippetOrBuilder>
        documentTextBuilder_;
    /**
     *
     *
     * <pre>
     * The plain text version of this document.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.TextSnippet document_text = 2;</code>
     *
     * @return Whether the documentText field is set.
     */
    public boolean hasDocumentText() {
      return documentTextBuilder_ != null || documentText_ != null;
    }
    /**
     *
     *
     * <pre>
     * The plain text version of this document.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.TextSnippet document_text = 2;</code>
     *
     * @return The documentText.
     */
    public com.google.cloud.automl.v1beta1.TextSnippet getDocumentText() {
      if (documentTextBuilder_ == null) {
        return documentText_ == null
            ? com.google.cloud.automl.v1beta1.TextSnippet.getDefaultInstance()
            : documentText_;
      } else {
        return documentTextBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The plain text version of this document.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.TextSnippet document_text = 2;</code>
     */
    public Builder setDocumentText(com.google.cloud.automl.v1beta1.TextSnippet value) {
      if (documentTextBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        documentText_ = value;
        onChanged();
      } else {
        documentTextBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The plain text version of this document.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.TextSnippet document_text = 2;</code>
     */
    public Builder setDocumentText(
        com.google.cloud.automl.v1beta1.TextSnippet.Builder builderForValue) {
      if (documentTextBuilder_ == null) {
        documentText_ = builderForValue.build();
        onChanged();
      } else {
        documentTextBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The plain text version of this document.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.TextSnippet document_text = 2;</code>
     */
    public Builder mergeDocumentText(com.google.cloud.automl.v1beta1.TextSnippet value) {
      if (documentTextBuilder_ == null) {
        if (documentText_ != null) {
          documentText_ =
              com.google.cloud.automl.v1beta1.TextSnippet.newBuilder(documentText_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          documentText_ = value;
        }
        onChanged();
      } else {
        documentTextBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The plain text version of this document.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.TextSnippet document_text = 2;</code>
     */
    public Builder clearDocumentText() {
      if (documentTextBuilder_ == null) {
        documentText_ = null;
        onChanged();
      } else {
        documentText_ = null;
        documentTextBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The plain text version of this document.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.TextSnippet document_text = 2;</code>
     */
    public com.google.cloud.automl.v1beta1.TextSnippet.Builder getDocumentTextBuilder() {

      onChanged();
      return getDocumentTextFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The plain text version of this document.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.TextSnippet document_text = 2;</code>
     */
    public com.google.cloud.automl.v1beta1.TextSnippetOrBuilder getDocumentTextOrBuilder() {
      if (documentTextBuilder_ != null) {
        return documentTextBuilder_.getMessageOrBuilder();
      } else {
        return documentText_ == null
            ? com.google.cloud.automl.v1beta1.TextSnippet.getDefaultInstance()
            : documentText_;
      }
    }
    /**
     *
     *
     * <pre>
     * The plain text version of this document.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.TextSnippet document_text = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.TextSnippet,
            com.google.cloud.automl.v1beta1.TextSnippet.Builder,
            com.google.cloud.automl.v1beta1.TextSnippetOrBuilder>
        getDocumentTextFieldBuilder() {
      if (documentTextBuilder_ == null) {
        documentTextBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.automl.v1beta1.TextSnippet,
                com.google.cloud.automl.v1beta1.TextSnippet.Builder,
                com.google.cloud.automl.v1beta1.TextSnippetOrBuilder>(
                getDocumentText(), getParentForChildren(), isClean());
        documentText_ = null;
      }
      return documentTextBuilder_;
    }

    private java.util.List<com.google.cloud.automl.v1beta1.Document.Layout> layout_ =
        java.util.Collections.emptyList();

    private void ensureLayoutIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        layout_ = new java.util.ArrayList<com.google.cloud.automl.v1beta1.Document.Layout>(layout_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.automl.v1beta1.Document.Layout,
            com.google.cloud.automl.v1beta1.Document.Layout.Builder,
            com.google.cloud.automl.v1beta1.Document.LayoutOrBuilder>
        layoutBuilder_;

    /**
     *
     *
     * <pre>
     * Describes the layout of the document.
     * Sorted by [page_number][].
     * </pre>
     *
     * <code>repeated .google.cloud.automl.v1beta1.Document.Layout layout = 3;</code>
     */
    public java.util.List<com.google.cloud.automl.v1beta1.Document.Layout> getLayoutList() {
      if (layoutBuilder_ == null) {
        return java.util.Collections.unmodifiableList(layout_);
      } else {
        return layoutBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Describes the layout of the document.
     * Sorted by [page_number][].
     * </pre>
     *
     * <code>repeated .google.cloud.automl.v1beta1.Document.Layout layout = 3;</code>
     */
    public int getLayoutCount() {
      if (layoutBuilder_ == null) {
        return layout_.size();
      } else {
        return layoutBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Describes the layout of the document.
     * Sorted by [page_number][].
     * </pre>
     *
     * <code>repeated .google.cloud.automl.v1beta1.Document.Layout layout = 3;</code>
     */
    public com.google.cloud.automl.v1beta1.Document.Layout getLayout(int index) {
      if (layoutBuilder_ == null) {
        return layout_.get(index);
      } else {
        return layoutBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Describes the layout of the document.
     * Sorted by [page_number][].
     * </pre>
     *
     * <code>repeated .google.cloud.automl.v1beta1.Document.Layout layout = 3;</code>
     */
    public Builder setLayout(int index, com.google.cloud.automl.v1beta1.Document.Layout value) {
      if (layoutBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLayoutIsMutable();
        layout_.set(index, value);
        onChanged();
      } else {
        layoutBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the layout of the document.
     * Sorted by [page_number][].
     * </pre>
     *
     * <code>repeated .google.cloud.automl.v1beta1.Document.Layout layout = 3;</code>
     */
    public Builder setLayout(
        int index, com.google.cloud.automl.v1beta1.Document.Layout.Builder builderForValue) {
      if (layoutBuilder_ == null) {
        ensureLayoutIsMutable();
        layout_.set(index, builderForValue.build());
        onChanged();
      } else {
        layoutBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the layout of the document.
     * Sorted by [page_number][].
     * </pre>
     *
     * <code>repeated .google.cloud.automl.v1beta1.Document.Layout layout = 3;</code>
     */
    public Builder addLayout(com.google.cloud.automl.v1beta1.Document.Layout value) {
      if (layoutBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLayoutIsMutable();
        layout_.add(value);
        onChanged();
      } else {
        layoutBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the layout of the document.
     * Sorted by [page_number][].
     * </pre>
     *
     * <code>repeated .google.cloud.automl.v1beta1.Document.Layout layout = 3;</code>
     */
    public Builder addLayout(int index, com.google.cloud.automl.v1beta1.Document.Layout value) {
      if (layoutBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLayoutIsMutable();
        layout_.add(index, value);
        onChanged();
      } else {
        layoutBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the layout of the document.
     * Sorted by [page_number][].
     * </pre>
     *
     * <code>repeated .google.cloud.automl.v1beta1.Document.Layout layout = 3;</code>
     */
    public Builder addLayout(
        com.google.cloud.automl.v1beta1.Document.Layout.Builder builderForValue) {
      if (layoutBuilder_ == null) {
        ensureLayoutIsMutable();
        layout_.add(builderForValue.build());
        onChanged();
      } else {
        layoutBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the layout of the document.
     * Sorted by [page_number][].
     * </pre>
     *
     * <code>repeated .google.cloud.automl.v1beta1.Document.Layout layout = 3;</code>
     */
    public Builder addLayout(
        int index, com.google.cloud.automl.v1beta1.Document.Layout.Builder builderForValue) {
      if (layoutBuilder_ == null) {
        ensureLayoutIsMutable();
        layout_.add(index, builderForValue.build());
        onChanged();
      } else {
        layoutBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the layout of the document.
     * Sorted by [page_number][].
     * </pre>
     *
     * <code>repeated .google.cloud.automl.v1beta1.Document.Layout layout = 3;</code>
     */
    public Builder addAllLayout(
        java.lang.Iterable<? extends com.google.cloud.automl.v1beta1.Document.Layout> values) {
      if (layoutBuilder_ == null) {
        ensureLayoutIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, layout_);
        onChanged();
      } else {
        layoutBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the layout of the document.
     * Sorted by [page_number][].
     * </pre>
     *
     * <code>repeated .google.cloud.automl.v1beta1.Document.Layout layout = 3;</code>
     */
    public Builder clearLayout() {
      if (layoutBuilder_ == null) {
        layout_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        layoutBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the layout of the document.
     * Sorted by [page_number][].
     * </pre>
     *
     * <code>repeated .google.cloud.automl.v1beta1.Document.Layout layout = 3;</code>
     */
    public Builder removeLayout(int index) {
      if (layoutBuilder_ == null) {
        ensureLayoutIsMutable();
        layout_.remove(index);
        onChanged();
      } else {
        layoutBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the layout of the document.
     * Sorted by [page_number][].
     * </pre>
     *
     * <code>repeated .google.cloud.automl.v1beta1.Document.Layout layout = 3;</code>
     */
    public com.google.cloud.automl.v1beta1.Document.Layout.Builder getLayoutBuilder(int index) {
      return getLayoutFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Describes the layout of the document.
     * Sorted by [page_number][].
     * </pre>
     *
     * <code>repeated .google.cloud.automl.v1beta1.Document.Layout layout = 3;</code>
     */
    public com.google.cloud.automl.v1beta1.Document.LayoutOrBuilder getLayoutOrBuilder(int index) {
      if (layoutBuilder_ == null) {
        return layout_.get(index);
      } else {
        return layoutBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Describes the layout of the document.
     * Sorted by [page_number][].
     * </pre>
     *
     * <code>repeated .google.cloud.automl.v1beta1.Document.Layout layout = 3;</code>
     */
    public java.util.List<? extends com.google.cloud.automl.v1beta1.Document.LayoutOrBuilder>
        getLayoutOrBuilderList() {
      if (layoutBuilder_ != null) {
        return layoutBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(layout_);
      }
    }
    /**
     *
     *
     * <pre>
     * Describes the layout of the document.
     * Sorted by [page_number][].
     * </pre>
     *
     * <code>repeated .google.cloud.automl.v1beta1.Document.Layout layout = 3;</code>
     */
    public com.google.cloud.automl.v1beta1.Document.Layout.Builder addLayoutBuilder() {
      return getLayoutFieldBuilder()
          .addBuilder(com.google.cloud.automl.v1beta1.Document.Layout.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Describes the layout of the document.
     * Sorted by [page_number][].
     * </pre>
     *
     * <code>repeated .google.cloud.automl.v1beta1.Document.Layout layout = 3;</code>
     */
    public com.google.cloud.automl.v1beta1.Document.Layout.Builder addLayoutBuilder(int index) {
      return getLayoutFieldBuilder()
          .addBuilder(index, com.google.cloud.automl.v1beta1.Document.Layout.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Describes the layout of the document.
     * Sorted by [page_number][].
     * </pre>
     *
     * <code>repeated .google.cloud.automl.v1beta1.Document.Layout layout = 3;</code>
     */
    public java.util.List<com.google.cloud.automl.v1beta1.Document.Layout.Builder>
        getLayoutBuilderList() {
      return getLayoutFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.automl.v1beta1.Document.Layout,
            com.google.cloud.automl.v1beta1.Document.Layout.Builder,
            com.google.cloud.automl.v1beta1.Document.LayoutOrBuilder>
        getLayoutFieldBuilder() {
      if (layoutBuilder_ == null) {
        layoutBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.automl.v1beta1.Document.Layout,
                com.google.cloud.automl.v1beta1.Document.Layout.Builder,
                com.google.cloud.automl.v1beta1.Document.LayoutOrBuilder>(
                layout_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        layout_ = null;
      }
      return layoutBuilder_;
    }

    private com.google.cloud.automl.v1beta1.DocumentDimensions documentDimensions_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.DocumentDimensions,
            com.google.cloud.automl.v1beta1.DocumentDimensions.Builder,
            com.google.cloud.automl.v1beta1.DocumentDimensionsOrBuilder>
        documentDimensionsBuilder_;
    /**
     *
     *
     * <pre>
     * The dimensions of the page in the document.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DocumentDimensions document_dimensions = 4;</code>
     *
     * @return Whether the documentDimensions field is set.
     */
    public boolean hasDocumentDimensions() {
      return documentDimensionsBuilder_ != null || documentDimensions_ != null;
    }
    /**
     *
     *
     * <pre>
     * The dimensions of the page in the document.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DocumentDimensions document_dimensions = 4;</code>
     *
     * @return The documentDimensions.
     */
    public com.google.cloud.automl.v1beta1.DocumentDimensions getDocumentDimensions() {
      if (documentDimensionsBuilder_ == null) {
        return documentDimensions_ == null
            ? com.google.cloud.automl.v1beta1.DocumentDimensions.getDefaultInstance()
            : documentDimensions_;
      } else {
        return documentDimensionsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The dimensions of the page in the document.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DocumentDimensions document_dimensions = 4;</code>
     */
    public Builder setDocumentDimensions(com.google.cloud.automl.v1beta1.DocumentDimensions value) {
      if (documentDimensionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        documentDimensions_ = value;
        onChanged();
      } else {
        documentDimensionsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The dimensions of the page in the document.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DocumentDimensions document_dimensions = 4;</code>
     */
    public Builder setDocumentDimensions(
        com.google.cloud.automl.v1beta1.DocumentDimensions.Builder builderForValue) {
      if (documentDimensionsBuilder_ == null) {
        documentDimensions_ = builderForValue.build();
        onChanged();
      } else {
        documentDimensionsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The dimensions of the page in the document.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DocumentDimensions document_dimensions = 4;</code>
     */
    public Builder mergeDocumentDimensions(
        com.google.cloud.automl.v1beta1.DocumentDimensions value) {
      if (documentDimensionsBuilder_ == null) {
        if (documentDimensions_ != null) {
          documentDimensions_ =
              com.google.cloud.automl.v1beta1.DocumentDimensions.newBuilder(documentDimensions_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          documentDimensions_ = value;
        }
        onChanged();
      } else {
        documentDimensionsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The dimensions of the page in the document.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DocumentDimensions document_dimensions = 4;</code>
     */
    public Builder clearDocumentDimensions() {
      if (documentDimensionsBuilder_ == null) {
        documentDimensions_ = null;
        onChanged();
      } else {
        documentDimensions_ = null;
        documentDimensionsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The dimensions of the page in the document.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DocumentDimensions document_dimensions = 4;</code>
     */
    public com.google.cloud.automl.v1beta1.DocumentDimensions.Builder
        getDocumentDimensionsBuilder() {

      onChanged();
      return getDocumentDimensionsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The dimensions of the page in the document.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DocumentDimensions document_dimensions = 4;</code>
     */
    public com.google.cloud.automl.v1beta1.DocumentDimensionsOrBuilder
        getDocumentDimensionsOrBuilder() {
      if (documentDimensionsBuilder_ != null) {
        return documentDimensionsBuilder_.getMessageOrBuilder();
      } else {
        return documentDimensions_ == null
            ? com.google.cloud.automl.v1beta1.DocumentDimensions.getDefaultInstance()
            : documentDimensions_;
      }
    }
    /**
     *
     *
     * <pre>
     * The dimensions of the page in the document.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DocumentDimensions document_dimensions = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.DocumentDimensions,
            com.google.cloud.automl.v1beta1.DocumentDimensions.Builder,
            com.google.cloud.automl.v1beta1.DocumentDimensionsOrBuilder>
        getDocumentDimensionsFieldBuilder() {
      if (documentDimensionsBuilder_ == null) {
        documentDimensionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.automl.v1beta1.DocumentDimensions,
                com.google.cloud.automl.v1beta1.DocumentDimensions.Builder,
                com.google.cloud.automl.v1beta1.DocumentDimensionsOrBuilder>(
                getDocumentDimensions(), getParentForChildren(), isClean());
        documentDimensions_ = null;
      }
      return documentDimensionsBuilder_;
    }

    private int pageCount_;
    /**
     *
     *
     * <pre>
     * Number of pages in the document.
     * </pre>
     *
     * <code>int32 page_count = 5;</code>
     *
     * @return The pageCount.
     */
    @java.lang.Override
    public int getPageCount() {
      return pageCount_;
    }
    /**
     *
     *
     * <pre>
     * Number of pages in the document.
     * </pre>
     *
     * <code>int32 page_count = 5;</code>
     *
     * @param value The pageCount to set.
     * @return This builder for chaining.
     */
    public Builder setPageCount(int value) {

      pageCount_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Number of pages in the document.
     * </pre>
     *
     * <code>int32 page_count = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageCount() {

      pageCount_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.automl.v1beta1.Document)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.automl.v1beta1.Document)
  private static final com.google.cloud.automl.v1beta1.Document DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.automl.v1beta1.Document();
  }

  public static com.google.cloud.automl.v1beta1.Document getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Document> PARSER =
      new com.google.protobuf.AbstractParser<Document>() {
        @java.lang.Override
        public Document parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new Document(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<Document> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Document> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.automl.v1beta1.Document getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
