/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/automl/v1beta1/data_items.proto

package com.google.cloud.automl.v1beta1;

/**
 *
 *
 * <pre>
 * A representation of a row in a relational table.
 * </pre>
 *
 * Protobuf type {@code google.cloud.automl.v1beta1.Row}
 */
public final class Row extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.automl.v1beta1.Row)
    RowOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Row.newBuilder() to construct.
  private Row(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Row() {
    columnSpecIds_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    values_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Row();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private Row(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                columnSpecIds_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000001;
              }
              columnSpecIds_.add(s);
              break;
            }
          case 26:
            {
              if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                values_ = new java.util.ArrayList<com.google.protobuf.Value>();
                mutable_bitField0_ |= 0x00000002;
              }
              values_.add(input.readMessage(com.google.protobuf.Value.parser(), extensionRegistry));
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        columnSpecIds_ = columnSpecIds_.getUnmodifiableView();
      }
      if (((mutable_bitField0_ & 0x00000002) != 0)) {
        values_ = java.util.Collections.unmodifiableList(values_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.automl.v1beta1.DataItems
        .internal_static_google_cloud_automl_v1beta1_Row_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.automl.v1beta1.DataItems
        .internal_static_google_cloud_automl_v1beta1_Row_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.automl.v1beta1.Row.class,
            com.google.cloud.automl.v1beta1.Row.Builder.class);
  }

  public static final int COLUMN_SPEC_IDS_FIELD_NUMBER = 2;
  private com.google.protobuf.LazyStringList columnSpecIds_;
  /**
   *
   *
   * <pre>
   * The resource IDs of the column specs describing the columns of the row.
   * If set must contain, but possibly in a different order, all input
   * feature
   * [column_spec_ids][google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs]
   * of the Model this row is being passed to.
   * Note: The below `values` field must match order of this field, if this
   * field is set.
   * </pre>
   *
   * <code>repeated string column_spec_ids = 2;</code>
   *
   * @return A list containing the columnSpecIds.
   */
  public com.google.protobuf.ProtocolStringList getColumnSpecIdsList() {
    return columnSpecIds_;
  }
  /**
   *
   *
   * <pre>
   * The resource IDs of the column specs describing the columns of the row.
   * If set must contain, but possibly in a different order, all input
   * feature
   * [column_spec_ids][google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs]
   * of the Model this row is being passed to.
   * Note: The below `values` field must match order of this field, if this
   * field is set.
   * </pre>
   *
   * <code>repeated string column_spec_ids = 2;</code>
   *
   * @return The count of columnSpecIds.
   */
  public int getColumnSpecIdsCount() {
    return columnSpecIds_.size();
  }
  /**
   *
   *
   * <pre>
   * The resource IDs of the column specs describing the columns of the row.
   * If set must contain, but possibly in a different order, all input
   * feature
   * [column_spec_ids][google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs]
   * of the Model this row is being passed to.
   * Note: The below `values` field must match order of this field, if this
   * field is set.
   * </pre>
   *
   * <code>repeated string column_spec_ids = 2;</code>
   *
   * @param index The index of the element to return.
   * @return The columnSpecIds at the given index.
   */
  public java.lang.String getColumnSpecIds(int index) {
    return columnSpecIds_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The resource IDs of the column specs describing the columns of the row.
   * If set must contain, but possibly in a different order, all input
   * feature
   * [column_spec_ids][google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs]
   * of the Model this row is being passed to.
   * Note: The below `values` field must match order of this field, if this
   * field is set.
   * </pre>
   *
   * <code>repeated string column_spec_ids = 2;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the columnSpecIds at the given index.
   */
  public com.google.protobuf.ByteString getColumnSpecIdsBytes(int index) {
    return columnSpecIds_.getByteString(index);
  }

  public static final int VALUES_FIELD_NUMBER = 3;
  private java.util.List<com.google.protobuf.Value> values_;
  /**
   *
   *
   * <pre>
   * Required. The values of the row cells, given in the same order as the
   * column_spec_ids, or, if not set, then in the same order as input
   * feature
   * [column_specs][google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs]
   * of the Model this row is being passed to.
   * </pre>
   *
   * <code>repeated .google.protobuf.Value values = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.protobuf.Value> getValuesList() {
    return values_;
  }
  /**
   *
   *
   * <pre>
   * Required. The values of the row cells, given in the same order as the
   * column_spec_ids, or, if not set, then in the same order as input
   * feature
   * [column_specs][google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs]
   * of the Model this row is being passed to.
   * </pre>
   *
   * <code>repeated .google.protobuf.Value values = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.protobuf.ValueOrBuilder> getValuesOrBuilderList() {
    return values_;
  }
  /**
   *
   *
   * <pre>
   * Required. The values of the row cells, given in the same order as the
   * column_spec_ids, or, if not set, then in the same order as input
   * feature
   * [column_specs][google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs]
   * of the Model this row is being passed to.
   * </pre>
   *
   * <code>repeated .google.protobuf.Value values = 3;</code>
   */
  @java.lang.Override
  public int getValuesCount() {
    return values_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. The values of the row cells, given in the same order as the
   * column_spec_ids, or, if not set, then in the same order as input
   * feature
   * [column_specs][google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs]
   * of the Model this row is being passed to.
   * </pre>
   *
   * <code>repeated .google.protobuf.Value values = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.Value getValues(int index) {
    return values_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. The values of the row cells, given in the same order as the
   * column_spec_ids, or, if not set, then in the same order as input
   * feature
   * [column_specs][google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs]
   * of the Model this row is being passed to.
   * </pre>
   *
   * <code>repeated .google.protobuf.Value values = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.ValueOrBuilder getValuesOrBuilder(int index) {
    return values_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < columnSpecIds_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, columnSpecIds_.getRaw(i));
    }
    for (int i = 0; i < values_.size(); i++) {
      output.writeMessage(3, values_.get(i));
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    {
      int dataSize = 0;
      for (int i = 0; i < columnSpecIds_.size(); i++) {
        dataSize += computeStringSizeNoTag(columnSpecIds_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getColumnSpecIdsList().size();
    }
    for (int i = 0; i < values_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, values_.get(i));
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.automl.v1beta1.Row)) {
      return super.equals(obj);
    }
    com.google.cloud.automl.v1beta1.Row other = (com.google.cloud.automl.v1beta1.Row) obj;

    if (!getColumnSpecIdsList().equals(other.getColumnSpecIdsList())) return false;
    if (!getValuesList().equals(other.getValuesList())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getColumnSpecIdsCount() > 0) {
      hash = (37 * hash) + COLUMN_SPEC_IDS_FIELD_NUMBER;
      hash = (53 * hash) + getColumnSpecIdsList().hashCode();
    }
    if (getValuesCount() > 0) {
      hash = (37 * hash) + VALUES_FIELD_NUMBER;
      hash = (53 * hash) + getValuesList().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.automl.v1beta1.Row parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1beta1.Row parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.Row parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1beta1.Row parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.Row parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1beta1.Row parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.Row parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1beta1.Row parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.Row parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1beta1.Row parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.Row parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1beta1.Row parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.automl.v1beta1.Row prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A representation of a row in a relational table.
   * </pre>
   *
   * Protobuf type {@code google.cloud.automl.v1beta1.Row}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.automl.v1beta1.Row)
      com.google.cloud.automl.v1beta1.RowOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.automl.v1beta1.DataItems
          .internal_static_google_cloud_automl_v1beta1_Row_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.automl.v1beta1.DataItems
          .internal_static_google_cloud_automl_v1beta1_Row_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.automl.v1beta1.Row.class,
              com.google.cloud.automl.v1beta1.Row.Builder.class);
    }

    // Construct using com.google.cloud.automl.v1beta1.Row.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getValuesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      columnSpecIds_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      if (valuesBuilder_ == null) {
        values_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
      } else {
        valuesBuilder_.clear();
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.automl.v1beta1.DataItems
          .internal_static_google_cloud_automl_v1beta1_Row_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.Row getDefaultInstanceForType() {
      return com.google.cloud.automl.v1beta1.Row.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.Row build() {
      com.google.cloud.automl.v1beta1.Row result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.Row buildPartial() {
      com.google.cloud.automl.v1beta1.Row result = new com.google.cloud.automl.v1beta1.Row(this);
      int from_bitField0_ = bitField0_;
      if (((bitField0_ & 0x00000001) != 0)) {
        columnSpecIds_ = columnSpecIds_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.columnSpecIds_ = columnSpecIds_;
      if (valuesBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          values_ = java.util.Collections.unmodifiableList(values_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.values_ = values_;
      } else {
        result.values_ = valuesBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.automl.v1beta1.Row) {
        return mergeFrom((com.google.cloud.automl.v1beta1.Row) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.automl.v1beta1.Row other) {
      if (other == com.google.cloud.automl.v1beta1.Row.getDefaultInstance()) return this;
      if (!other.columnSpecIds_.isEmpty()) {
        if (columnSpecIds_.isEmpty()) {
          columnSpecIds_ = other.columnSpecIds_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureColumnSpecIdsIsMutable();
          columnSpecIds_.addAll(other.columnSpecIds_);
        }
        onChanged();
      }
      if (valuesBuilder_ == null) {
        if (!other.values_.isEmpty()) {
          if (values_.isEmpty()) {
            values_ = other.values_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureValuesIsMutable();
            values_.addAll(other.values_);
          }
          onChanged();
        }
      } else {
        if (!other.values_.isEmpty()) {
          if (valuesBuilder_.isEmpty()) {
            valuesBuilder_.dispose();
            valuesBuilder_ = null;
            values_ = other.values_;
            bitField0_ = (bitField0_ & ~0x00000002);
            valuesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getValuesFieldBuilder()
                    : null;
          } else {
            valuesBuilder_.addAllMessages(other.values_);
          }
        }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.automl.v1beta1.Row parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloud.automl.v1beta1.Row) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.LazyStringList columnSpecIds_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureColumnSpecIdsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        columnSpecIds_ = new com.google.protobuf.LazyStringArrayList(columnSpecIds_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource IDs of the column specs describing the columns of the row.
     * If set must contain, but possibly in a different order, all input
     * feature
     * [column_spec_ids][google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs]
     * of the Model this row is being passed to.
     * Note: The below `values` field must match order of this field, if this
     * field is set.
     * </pre>
     *
     * <code>repeated string column_spec_ids = 2;</code>
     *
     * @return A list containing the columnSpecIds.
     */
    public com.google.protobuf.ProtocolStringList getColumnSpecIdsList() {
      return columnSpecIds_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * The resource IDs of the column specs describing the columns of the row.
     * If set must contain, but possibly in a different order, all input
     * feature
     * [column_spec_ids][google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs]
     * of the Model this row is being passed to.
     * Note: The below `values` field must match order of this field, if this
     * field is set.
     * </pre>
     *
     * <code>repeated string column_spec_ids = 2;</code>
     *
     * @return The count of columnSpecIds.
     */
    public int getColumnSpecIdsCount() {
      return columnSpecIds_.size();
    }
    /**
     *
     *
     * <pre>
     * The resource IDs of the column specs describing the columns of the row.
     * If set must contain, but possibly in a different order, all input
     * feature
     * [column_spec_ids][google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs]
     * of the Model this row is being passed to.
     * Note: The below `values` field must match order of this field, if this
     * field is set.
     * </pre>
     *
     * <code>repeated string column_spec_ids = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The columnSpecIds at the given index.
     */
    public java.lang.String getColumnSpecIds(int index) {
      return columnSpecIds_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The resource IDs of the column specs describing the columns of the row.
     * If set must contain, but possibly in a different order, all input
     * feature
     * [column_spec_ids][google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs]
     * of the Model this row is being passed to.
     * Note: The below `values` field must match order of this field, if this
     * field is set.
     * </pre>
     *
     * <code>repeated string column_spec_ids = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the columnSpecIds at the given index.
     */
    public com.google.protobuf.ByteString getColumnSpecIdsBytes(int index) {
      return columnSpecIds_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The resource IDs of the column specs describing the columns of the row.
     * If set must contain, but possibly in a different order, all input
     * feature
     * [column_spec_ids][google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs]
     * of the Model this row is being passed to.
     * Note: The below `values` field must match order of this field, if this
     * field is set.
     * </pre>
     *
     * <code>repeated string column_spec_ids = 2;</code>
     *
     * @param index The index to set the value at.
     * @param value The columnSpecIds to set.
     * @return This builder for chaining.
     */
    public Builder setColumnSpecIds(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureColumnSpecIdsIsMutable();
      columnSpecIds_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource IDs of the column specs describing the columns of the row.
     * If set must contain, but possibly in a different order, all input
     * feature
     * [column_spec_ids][google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs]
     * of the Model this row is being passed to.
     * Note: The below `values` field must match order of this field, if this
     * field is set.
     * </pre>
     *
     * <code>repeated string column_spec_ids = 2;</code>
     *
     * @param value The columnSpecIds to add.
     * @return This builder for chaining.
     */
    public Builder addColumnSpecIds(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureColumnSpecIdsIsMutable();
      columnSpecIds_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource IDs of the column specs describing the columns of the row.
     * If set must contain, but possibly in a different order, all input
     * feature
     * [column_spec_ids][google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs]
     * of the Model this row is being passed to.
     * Note: The below `values` field must match order of this field, if this
     * field is set.
     * </pre>
     *
     * <code>repeated string column_spec_ids = 2;</code>
     *
     * @param values The columnSpecIds to add.
     * @return This builder for chaining.
     */
    public Builder addAllColumnSpecIds(java.lang.Iterable<java.lang.String> values) {
      ensureColumnSpecIdsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, columnSpecIds_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource IDs of the column specs describing the columns of the row.
     * If set must contain, but possibly in a different order, all input
     * feature
     * [column_spec_ids][google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs]
     * of the Model this row is being passed to.
     * Note: The below `values` field must match order of this field, if this
     * field is set.
     * </pre>
     *
     * <code>repeated string column_spec_ids = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearColumnSpecIds() {
      columnSpecIds_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource IDs of the column specs describing the columns of the row.
     * If set must contain, but possibly in a different order, all input
     * feature
     * [column_spec_ids][google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs]
     * of the Model this row is being passed to.
     * Note: The below `values` field must match order of this field, if this
     * field is set.
     * </pre>
     *
     * <code>repeated string column_spec_ids = 2;</code>
     *
     * @param value The bytes of the columnSpecIds to add.
     * @return This builder for chaining.
     */
    public Builder addColumnSpecIdsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureColumnSpecIdsIsMutable();
      columnSpecIds_.add(value);
      onChanged();
      return this;
    }

    private java.util.List<com.google.protobuf.Value> values_ = java.util.Collections.emptyList();

    private void ensureValuesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        values_ = new java.util.ArrayList<com.google.protobuf.Value>(values_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        valuesBuilder_;

    /**
     *
     *
     * <pre>
     * Required. The values of the row cells, given in the same order as the
     * column_spec_ids, or, if not set, then in the same order as input
     * feature
     * [column_specs][google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs]
     * of the Model this row is being passed to.
     * </pre>
     *
     * <code>repeated .google.protobuf.Value values = 3;</code>
     */
    public java.util.List<com.google.protobuf.Value> getValuesList() {
      if (valuesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(values_);
      } else {
        return valuesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The values of the row cells, given in the same order as the
     * column_spec_ids, or, if not set, then in the same order as input
     * feature
     * [column_specs][google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs]
     * of the Model this row is being passed to.
     * </pre>
     *
     * <code>repeated .google.protobuf.Value values = 3;</code>
     */
    public int getValuesCount() {
      if (valuesBuilder_ == null) {
        return values_.size();
      } else {
        return valuesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The values of the row cells, given in the same order as the
     * column_spec_ids, or, if not set, then in the same order as input
     * feature
     * [column_specs][google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs]
     * of the Model this row is being passed to.
     * </pre>
     *
     * <code>repeated .google.protobuf.Value values = 3;</code>
     */
    public com.google.protobuf.Value getValues(int index) {
      if (valuesBuilder_ == null) {
        return values_.get(index);
      } else {
        return valuesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The values of the row cells, given in the same order as the
     * column_spec_ids, or, if not set, then in the same order as input
     * feature
     * [column_specs][google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs]
     * of the Model this row is being passed to.
     * </pre>
     *
     * <code>repeated .google.protobuf.Value values = 3;</code>
     */
    public Builder setValues(int index, com.google.protobuf.Value value) {
      if (valuesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureValuesIsMutable();
        values_.set(index, value);
        onChanged();
      } else {
        valuesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The values of the row cells, given in the same order as the
     * column_spec_ids, or, if not set, then in the same order as input
     * feature
     * [column_specs][google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs]
     * of the Model this row is being passed to.
     * </pre>
     *
     * <code>repeated .google.protobuf.Value values = 3;</code>
     */
    public Builder setValues(int index, com.google.protobuf.Value.Builder builderForValue) {
      if (valuesBuilder_ == null) {
        ensureValuesIsMutable();
        values_.set(index, builderForValue.build());
        onChanged();
      } else {
        valuesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The values of the row cells, given in the same order as the
     * column_spec_ids, or, if not set, then in the same order as input
     * feature
     * [column_specs][google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs]
     * of the Model this row is being passed to.
     * </pre>
     *
     * <code>repeated .google.protobuf.Value values = 3;</code>
     */
    public Builder addValues(com.google.protobuf.Value value) {
      if (valuesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureValuesIsMutable();
        values_.add(value);
        onChanged();
      } else {
        valuesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The values of the row cells, given in the same order as the
     * column_spec_ids, or, if not set, then in the same order as input
     * feature
     * [column_specs][google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs]
     * of the Model this row is being passed to.
     * </pre>
     *
     * <code>repeated .google.protobuf.Value values = 3;</code>
     */
    public Builder addValues(int index, com.google.protobuf.Value value) {
      if (valuesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureValuesIsMutable();
        values_.add(index, value);
        onChanged();
      } else {
        valuesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The values of the row cells, given in the same order as the
     * column_spec_ids, or, if not set, then in the same order as input
     * feature
     * [column_specs][google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs]
     * of the Model this row is being passed to.
     * </pre>
     *
     * <code>repeated .google.protobuf.Value values = 3;</code>
     */
    public Builder addValues(com.google.protobuf.Value.Builder builderForValue) {
      if (valuesBuilder_ == null) {
        ensureValuesIsMutable();
        values_.add(builderForValue.build());
        onChanged();
      } else {
        valuesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The values of the row cells, given in the same order as the
     * column_spec_ids, or, if not set, then in the same order as input
     * feature
     * [column_specs][google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs]
     * of the Model this row is being passed to.
     * </pre>
     *
     * <code>repeated .google.protobuf.Value values = 3;</code>
     */
    public Builder addValues(int index, com.google.protobuf.Value.Builder builderForValue) {
      if (valuesBuilder_ == null) {
        ensureValuesIsMutable();
        values_.add(index, builderForValue.build());
        onChanged();
      } else {
        valuesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The values of the row cells, given in the same order as the
     * column_spec_ids, or, if not set, then in the same order as input
     * feature
     * [column_specs][google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs]
     * of the Model this row is being passed to.
     * </pre>
     *
     * <code>repeated .google.protobuf.Value values = 3;</code>
     */
    public Builder addAllValues(java.lang.Iterable<? extends com.google.protobuf.Value> values) {
      if (valuesBuilder_ == null) {
        ensureValuesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, values_);
        onChanged();
      } else {
        valuesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The values of the row cells, given in the same order as the
     * column_spec_ids, or, if not set, then in the same order as input
     * feature
     * [column_specs][google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs]
     * of the Model this row is being passed to.
     * </pre>
     *
     * <code>repeated .google.protobuf.Value values = 3;</code>
     */
    public Builder clearValues() {
      if (valuesBuilder_ == null) {
        values_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        valuesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The values of the row cells, given in the same order as the
     * column_spec_ids, or, if not set, then in the same order as input
     * feature
     * [column_specs][google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs]
     * of the Model this row is being passed to.
     * </pre>
     *
     * <code>repeated .google.protobuf.Value values = 3;</code>
     */
    public Builder removeValues(int index) {
      if (valuesBuilder_ == null) {
        ensureValuesIsMutable();
        values_.remove(index);
        onChanged();
      } else {
        valuesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The values of the row cells, given in the same order as the
     * column_spec_ids, or, if not set, then in the same order as input
     * feature
     * [column_specs][google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs]
     * of the Model this row is being passed to.
     * </pre>
     *
     * <code>repeated .google.protobuf.Value values = 3;</code>
     */
    public com.google.protobuf.Value.Builder getValuesBuilder(int index) {
      return getValuesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Required. The values of the row cells, given in the same order as the
     * column_spec_ids, or, if not set, then in the same order as input
     * feature
     * [column_specs][google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs]
     * of the Model this row is being passed to.
     * </pre>
     *
     * <code>repeated .google.protobuf.Value values = 3;</code>
     */
    public com.google.protobuf.ValueOrBuilder getValuesOrBuilder(int index) {
      if (valuesBuilder_ == null) {
        return values_.get(index);
      } else {
        return valuesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The values of the row cells, given in the same order as the
     * column_spec_ids, or, if not set, then in the same order as input
     * feature
     * [column_specs][google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs]
     * of the Model this row is being passed to.
     * </pre>
     *
     * <code>repeated .google.protobuf.Value values = 3;</code>
     */
    public java.util.List<? extends com.google.protobuf.ValueOrBuilder> getValuesOrBuilderList() {
      if (valuesBuilder_ != null) {
        return valuesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(values_);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The values of the row cells, given in the same order as the
     * column_spec_ids, or, if not set, then in the same order as input
     * feature
     * [column_specs][google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs]
     * of the Model this row is being passed to.
     * </pre>
     *
     * <code>repeated .google.protobuf.Value values = 3;</code>
     */
    public com.google.protobuf.Value.Builder addValuesBuilder() {
      return getValuesFieldBuilder().addBuilder(com.google.protobuf.Value.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. The values of the row cells, given in the same order as the
     * column_spec_ids, or, if not set, then in the same order as input
     * feature
     * [column_specs][google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs]
     * of the Model this row is being passed to.
     * </pre>
     *
     * <code>repeated .google.protobuf.Value values = 3;</code>
     */
    public com.google.protobuf.Value.Builder addValuesBuilder(int index) {
      return getValuesFieldBuilder()
          .addBuilder(index, com.google.protobuf.Value.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. The values of the row cells, given in the same order as the
     * column_spec_ids, or, if not set, then in the same order as input
     * feature
     * [column_specs][google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs]
     * of the Model this row is being passed to.
     * </pre>
     *
     * <code>repeated .google.protobuf.Value values = 3;</code>
     */
    public java.util.List<com.google.protobuf.Value.Builder> getValuesBuilderList() {
      return getValuesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        getValuesFieldBuilder() {
      if (valuesBuilder_ == null) {
        valuesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.protobuf.Value,
                com.google.protobuf.Value.Builder,
                com.google.protobuf.ValueOrBuilder>(
                values_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        values_ = null;
      }
      return valuesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.automl.v1beta1.Row)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.automl.v1beta1.Row)
  private static final com.google.cloud.automl.v1beta1.Row DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.automl.v1beta1.Row();
  }

  public static com.google.cloud.automl.v1beta1.Row getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Row> PARSER =
      new com.google.protobuf.AbstractParser<Row>() {
        @java.lang.Override
        public Row parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new Row(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<Row> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Row> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.automl.v1beta1.Row getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
