/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/automl/v1beta1/dataset.proto

package com.google.cloud.automl.v1beta1;

/**
 *
 *
 * <pre>
 * A workspace for solving a single, particular machine learning (ML) problem.
 * A workspace contains examples that may be annotated.
 * </pre>
 *
 * Protobuf type {@code google.cloud.automl.v1beta1.Dataset}
 */
public final class Dataset extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.automl.v1beta1.Dataset)
    DatasetOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Dataset.newBuilder() to construct.
  private Dataset(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Dataset() {
    name_ = "";
    displayName_ = "";
    description_ = "";
    etag_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Dataset();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private Dataset(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();

              displayName_ = s;
              break;
            }
          case 26:
            {
              java.lang.String s = input.readStringRequireUtf8();

              description_ = s;
              break;
            }
          case 114:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (createTime_ != null) {
                subBuilder = createTime_.toBuilder();
              }
              createTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(createTime_);
                createTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 138:
            {
              java.lang.String s = input.readStringRequireUtf8();

              etag_ = s;
              break;
            }
          case 168:
            {
              exampleCount_ = input.readInt32();
              break;
            }
          case 186:
            {
              com.google.cloud.automl.v1beta1.TranslationDatasetMetadata.Builder subBuilder = null;
              if (datasetMetadataCase_ == 23) {
                subBuilder =
                    ((com.google.cloud.automl.v1beta1.TranslationDatasetMetadata) datasetMetadata_)
                        .toBuilder();
              }
              datasetMetadata_ =
                  input.readMessage(
                      com.google.cloud.automl.v1beta1.TranslationDatasetMetadata.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.automl.v1beta1.TranslationDatasetMetadata) datasetMetadata_);
                datasetMetadata_ = subBuilder.buildPartial();
              }
              datasetMetadataCase_ = 23;
              break;
            }
          case 194:
            {
              com.google.cloud.automl.v1beta1.ImageClassificationDatasetMetadata.Builder
                  subBuilder = null;
              if (datasetMetadataCase_ == 24) {
                subBuilder =
                    ((com.google.cloud.automl.v1beta1.ImageClassificationDatasetMetadata)
                            datasetMetadata_)
                        .toBuilder();
              }
              datasetMetadata_ =
                  input.readMessage(
                      com.google.cloud.automl.v1beta1.ImageClassificationDatasetMetadata.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.automl.v1beta1.ImageClassificationDatasetMetadata)
                        datasetMetadata_);
                datasetMetadata_ = subBuilder.buildPartial();
              }
              datasetMetadataCase_ = 24;
              break;
            }
          case 202:
            {
              com.google.cloud.automl.v1beta1.TextClassificationDatasetMetadata.Builder subBuilder =
                  null;
              if (datasetMetadataCase_ == 25) {
                subBuilder =
                    ((com.google.cloud.automl.v1beta1.TextClassificationDatasetMetadata)
                            datasetMetadata_)
                        .toBuilder();
              }
              datasetMetadata_ =
                  input.readMessage(
                      com.google.cloud.automl.v1beta1.TextClassificationDatasetMetadata.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.automl.v1beta1.TextClassificationDatasetMetadata)
                        datasetMetadata_);
                datasetMetadata_ = subBuilder.buildPartial();
              }
              datasetMetadataCase_ = 25;
              break;
            }
          case 210:
            {
              com.google.cloud.automl.v1beta1.ImageObjectDetectionDatasetMetadata.Builder
                  subBuilder = null;
              if (datasetMetadataCase_ == 26) {
                subBuilder =
                    ((com.google.cloud.automl.v1beta1.ImageObjectDetectionDatasetMetadata)
                            datasetMetadata_)
                        .toBuilder();
              }
              datasetMetadata_ =
                  input.readMessage(
                      com.google.cloud.automl.v1beta1.ImageObjectDetectionDatasetMetadata.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.automl.v1beta1.ImageObjectDetectionDatasetMetadata)
                        datasetMetadata_);
                datasetMetadata_ = subBuilder.buildPartial();
              }
              datasetMetadataCase_ = 26;
              break;
            }
          case 226:
            {
              com.google.cloud.automl.v1beta1.TextExtractionDatasetMetadata.Builder subBuilder =
                  null;
              if (datasetMetadataCase_ == 28) {
                subBuilder =
                    ((com.google.cloud.automl.v1beta1.TextExtractionDatasetMetadata)
                            datasetMetadata_)
                        .toBuilder();
              }
              datasetMetadata_ =
                  input.readMessage(
                      com.google.cloud.automl.v1beta1.TextExtractionDatasetMetadata.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.automl.v1beta1.TextExtractionDatasetMetadata)
                        datasetMetadata_);
                datasetMetadata_ = subBuilder.buildPartial();
              }
              datasetMetadataCase_ = 28;
              break;
            }
          case 234:
            {
              com.google.cloud.automl.v1beta1.VideoObjectTrackingDatasetMetadata.Builder
                  subBuilder = null;
              if (datasetMetadataCase_ == 29) {
                subBuilder =
                    ((com.google.cloud.automl.v1beta1.VideoObjectTrackingDatasetMetadata)
                            datasetMetadata_)
                        .toBuilder();
              }
              datasetMetadata_ =
                  input.readMessage(
                      com.google.cloud.automl.v1beta1.VideoObjectTrackingDatasetMetadata.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.automl.v1beta1.VideoObjectTrackingDatasetMetadata)
                        datasetMetadata_);
                datasetMetadata_ = subBuilder.buildPartial();
              }
              datasetMetadataCase_ = 29;
              break;
            }
          case 242:
            {
              com.google.cloud.automl.v1beta1.TextSentimentDatasetMetadata.Builder subBuilder =
                  null;
              if (datasetMetadataCase_ == 30) {
                subBuilder =
                    ((com.google.cloud.automl.v1beta1.TextSentimentDatasetMetadata)
                            datasetMetadata_)
                        .toBuilder();
              }
              datasetMetadata_ =
                  input.readMessage(
                      com.google.cloud.automl.v1beta1.TextSentimentDatasetMetadata.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.automl.v1beta1.TextSentimentDatasetMetadata)
                        datasetMetadata_);
                datasetMetadata_ = subBuilder.buildPartial();
              }
              datasetMetadataCase_ = 30;
              break;
            }
          case 250:
            {
              com.google.cloud.automl.v1beta1.VideoClassificationDatasetMetadata.Builder
                  subBuilder = null;
              if (datasetMetadataCase_ == 31) {
                subBuilder =
                    ((com.google.cloud.automl.v1beta1.VideoClassificationDatasetMetadata)
                            datasetMetadata_)
                        .toBuilder();
              }
              datasetMetadata_ =
                  input.readMessage(
                      com.google.cloud.automl.v1beta1.VideoClassificationDatasetMetadata.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.automl.v1beta1.VideoClassificationDatasetMetadata)
                        datasetMetadata_);
                datasetMetadata_ = subBuilder.buildPartial();
              }
              datasetMetadataCase_ = 31;
              break;
            }
          case 266:
            {
              com.google.cloud.automl.v1beta1.TablesDatasetMetadata.Builder subBuilder = null;
              if (datasetMetadataCase_ == 33) {
                subBuilder =
                    ((com.google.cloud.automl.v1beta1.TablesDatasetMetadata) datasetMetadata_)
                        .toBuilder();
              }
              datasetMetadata_ =
                  input.readMessage(
                      com.google.cloud.automl.v1beta1.TablesDatasetMetadata.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.automl.v1beta1.TablesDatasetMetadata) datasetMetadata_);
                datasetMetadata_ = subBuilder.buildPartial();
              }
              datasetMetadataCase_ = 33;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.automl.v1beta1.DatasetOuterClass
        .internal_static_google_cloud_automl_v1beta1_Dataset_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.automl.v1beta1.DatasetOuterClass
        .internal_static_google_cloud_automl_v1beta1_Dataset_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.automl.v1beta1.Dataset.class,
            com.google.cloud.automl.v1beta1.Dataset.Builder.class);
  }

  private int datasetMetadataCase_ = 0;
  private java.lang.Object datasetMetadata_;

  public enum DatasetMetadataCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    TRANSLATION_DATASET_METADATA(23),
    IMAGE_CLASSIFICATION_DATASET_METADATA(24),
    TEXT_CLASSIFICATION_DATASET_METADATA(25),
    IMAGE_OBJECT_DETECTION_DATASET_METADATA(26),
    VIDEO_CLASSIFICATION_DATASET_METADATA(31),
    VIDEO_OBJECT_TRACKING_DATASET_METADATA(29),
    TEXT_EXTRACTION_DATASET_METADATA(28),
    TEXT_SENTIMENT_DATASET_METADATA(30),
    TABLES_DATASET_METADATA(33),
    DATASETMETADATA_NOT_SET(0);
    private final int value;

    private DatasetMetadataCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DatasetMetadataCase valueOf(int value) {
      return forNumber(value);
    }

    public static DatasetMetadataCase forNumber(int value) {
      switch (value) {
        case 23:
          return TRANSLATION_DATASET_METADATA;
        case 24:
          return IMAGE_CLASSIFICATION_DATASET_METADATA;
        case 25:
          return TEXT_CLASSIFICATION_DATASET_METADATA;
        case 26:
          return IMAGE_OBJECT_DETECTION_DATASET_METADATA;
        case 31:
          return VIDEO_CLASSIFICATION_DATASET_METADATA;
        case 29:
          return VIDEO_OBJECT_TRACKING_DATASET_METADATA;
        case 28:
          return TEXT_EXTRACTION_DATASET_METADATA;
        case 30:
          return TEXT_SENTIMENT_DATASET_METADATA;
        case 33:
          return TABLES_DATASET_METADATA;
        case 0:
          return DATASETMETADATA_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public DatasetMetadataCase getDatasetMetadataCase() {
    return DatasetMetadataCase.forNumber(datasetMetadataCase_);
  }

  public static final int TRANSLATION_DATASET_METADATA_FIELD_NUMBER = 23;
  /**
   *
   *
   * <pre>
   * Metadata for a dataset used for translation.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.TranslationDatasetMetadata translation_dataset_metadata = 23;
   * </code>
   *
   * @return Whether the translationDatasetMetadata field is set.
   */
  @java.lang.Override
  public boolean hasTranslationDatasetMetadata() {
    return datasetMetadataCase_ == 23;
  }
  /**
   *
   *
   * <pre>
   * Metadata for a dataset used for translation.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.TranslationDatasetMetadata translation_dataset_metadata = 23;
   * </code>
   *
   * @return The translationDatasetMetadata.
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.TranslationDatasetMetadata
      getTranslationDatasetMetadata() {
    if (datasetMetadataCase_ == 23) {
      return (com.google.cloud.automl.v1beta1.TranslationDatasetMetadata) datasetMetadata_;
    }
    return com.google.cloud.automl.v1beta1.TranslationDatasetMetadata.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Metadata for a dataset used for translation.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.TranslationDatasetMetadata translation_dataset_metadata = 23;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.TranslationDatasetMetadataOrBuilder
      getTranslationDatasetMetadataOrBuilder() {
    if (datasetMetadataCase_ == 23) {
      return (com.google.cloud.automl.v1beta1.TranslationDatasetMetadata) datasetMetadata_;
    }
    return com.google.cloud.automl.v1beta1.TranslationDatasetMetadata.getDefaultInstance();
  }

  public static final int IMAGE_CLASSIFICATION_DATASET_METADATA_FIELD_NUMBER = 24;
  /**
   *
   *
   * <pre>
   * Metadata for a dataset used for image classification.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.ImageClassificationDatasetMetadata image_classification_dataset_metadata = 24;
   * </code>
   *
   * @return Whether the imageClassificationDatasetMetadata field is set.
   */
  @java.lang.Override
  public boolean hasImageClassificationDatasetMetadata() {
    return datasetMetadataCase_ == 24;
  }
  /**
   *
   *
   * <pre>
   * Metadata for a dataset used for image classification.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.ImageClassificationDatasetMetadata image_classification_dataset_metadata = 24;
   * </code>
   *
   * @return The imageClassificationDatasetMetadata.
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.ImageClassificationDatasetMetadata
      getImageClassificationDatasetMetadata() {
    if (datasetMetadataCase_ == 24) {
      return (com.google.cloud.automl.v1beta1.ImageClassificationDatasetMetadata) datasetMetadata_;
    }
    return com.google.cloud.automl.v1beta1.ImageClassificationDatasetMetadata.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Metadata for a dataset used for image classification.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.ImageClassificationDatasetMetadata image_classification_dataset_metadata = 24;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.ImageClassificationDatasetMetadataOrBuilder
      getImageClassificationDatasetMetadataOrBuilder() {
    if (datasetMetadataCase_ == 24) {
      return (com.google.cloud.automl.v1beta1.ImageClassificationDatasetMetadata) datasetMetadata_;
    }
    return com.google.cloud.automl.v1beta1.ImageClassificationDatasetMetadata.getDefaultInstance();
  }

  public static final int TEXT_CLASSIFICATION_DATASET_METADATA_FIELD_NUMBER = 25;
  /**
   *
   *
   * <pre>
   * Metadata for a dataset used for text classification.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.TextClassificationDatasetMetadata text_classification_dataset_metadata = 25;
   * </code>
   *
   * @return Whether the textClassificationDatasetMetadata field is set.
   */
  @java.lang.Override
  public boolean hasTextClassificationDatasetMetadata() {
    return datasetMetadataCase_ == 25;
  }
  /**
   *
   *
   * <pre>
   * Metadata for a dataset used for text classification.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.TextClassificationDatasetMetadata text_classification_dataset_metadata = 25;
   * </code>
   *
   * @return The textClassificationDatasetMetadata.
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.TextClassificationDatasetMetadata
      getTextClassificationDatasetMetadata() {
    if (datasetMetadataCase_ == 25) {
      return (com.google.cloud.automl.v1beta1.TextClassificationDatasetMetadata) datasetMetadata_;
    }
    return com.google.cloud.automl.v1beta1.TextClassificationDatasetMetadata.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Metadata for a dataset used for text classification.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.TextClassificationDatasetMetadata text_classification_dataset_metadata = 25;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.TextClassificationDatasetMetadataOrBuilder
      getTextClassificationDatasetMetadataOrBuilder() {
    if (datasetMetadataCase_ == 25) {
      return (com.google.cloud.automl.v1beta1.TextClassificationDatasetMetadata) datasetMetadata_;
    }
    return com.google.cloud.automl.v1beta1.TextClassificationDatasetMetadata.getDefaultInstance();
  }

  public static final int IMAGE_OBJECT_DETECTION_DATASET_METADATA_FIELD_NUMBER = 26;
  /**
   *
   *
   * <pre>
   * Metadata for a dataset used for image object detection.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.ImageObjectDetectionDatasetMetadata image_object_detection_dataset_metadata = 26;
   * </code>
   *
   * @return Whether the imageObjectDetectionDatasetMetadata field is set.
   */
  @java.lang.Override
  public boolean hasImageObjectDetectionDatasetMetadata() {
    return datasetMetadataCase_ == 26;
  }
  /**
   *
   *
   * <pre>
   * Metadata for a dataset used for image object detection.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.ImageObjectDetectionDatasetMetadata image_object_detection_dataset_metadata = 26;
   * </code>
   *
   * @return The imageObjectDetectionDatasetMetadata.
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.ImageObjectDetectionDatasetMetadata
      getImageObjectDetectionDatasetMetadata() {
    if (datasetMetadataCase_ == 26) {
      return (com.google.cloud.automl.v1beta1.ImageObjectDetectionDatasetMetadata) datasetMetadata_;
    }
    return com.google.cloud.automl.v1beta1.ImageObjectDetectionDatasetMetadata.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Metadata for a dataset used for image object detection.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.ImageObjectDetectionDatasetMetadata image_object_detection_dataset_metadata = 26;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.ImageObjectDetectionDatasetMetadataOrBuilder
      getImageObjectDetectionDatasetMetadataOrBuilder() {
    if (datasetMetadataCase_ == 26) {
      return (com.google.cloud.automl.v1beta1.ImageObjectDetectionDatasetMetadata) datasetMetadata_;
    }
    return com.google.cloud.automl.v1beta1.ImageObjectDetectionDatasetMetadata.getDefaultInstance();
  }

  public static final int VIDEO_CLASSIFICATION_DATASET_METADATA_FIELD_NUMBER = 31;
  /**
   *
   *
   * <pre>
   * Metadata for a dataset used for video classification.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.VideoClassificationDatasetMetadata video_classification_dataset_metadata = 31;
   * </code>
   *
   * @return Whether the videoClassificationDatasetMetadata field is set.
   */
  @java.lang.Override
  public boolean hasVideoClassificationDatasetMetadata() {
    return datasetMetadataCase_ == 31;
  }
  /**
   *
   *
   * <pre>
   * Metadata for a dataset used for video classification.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.VideoClassificationDatasetMetadata video_classification_dataset_metadata = 31;
   * </code>
   *
   * @return The videoClassificationDatasetMetadata.
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.VideoClassificationDatasetMetadata
      getVideoClassificationDatasetMetadata() {
    if (datasetMetadataCase_ == 31) {
      return (com.google.cloud.automl.v1beta1.VideoClassificationDatasetMetadata) datasetMetadata_;
    }
    return com.google.cloud.automl.v1beta1.VideoClassificationDatasetMetadata.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Metadata for a dataset used for video classification.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.VideoClassificationDatasetMetadata video_classification_dataset_metadata = 31;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.VideoClassificationDatasetMetadataOrBuilder
      getVideoClassificationDatasetMetadataOrBuilder() {
    if (datasetMetadataCase_ == 31) {
      return (com.google.cloud.automl.v1beta1.VideoClassificationDatasetMetadata) datasetMetadata_;
    }
    return com.google.cloud.automl.v1beta1.VideoClassificationDatasetMetadata.getDefaultInstance();
  }

  public static final int VIDEO_OBJECT_TRACKING_DATASET_METADATA_FIELD_NUMBER = 29;
  /**
   *
   *
   * <pre>
   * Metadata for a dataset used for video object tracking.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.VideoObjectTrackingDatasetMetadata video_object_tracking_dataset_metadata = 29;
   * </code>
   *
   * @return Whether the videoObjectTrackingDatasetMetadata field is set.
   */
  @java.lang.Override
  public boolean hasVideoObjectTrackingDatasetMetadata() {
    return datasetMetadataCase_ == 29;
  }
  /**
   *
   *
   * <pre>
   * Metadata for a dataset used for video object tracking.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.VideoObjectTrackingDatasetMetadata video_object_tracking_dataset_metadata = 29;
   * </code>
   *
   * @return The videoObjectTrackingDatasetMetadata.
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.VideoObjectTrackingDatasetMetadata
      getVideoObjectTrackingDatasetMetadata() {
    if (datasetMetadataCase_ == 29) {
      return (com.google.cloud.automl.v1beta1.VideoObjectTrackingDatasetMetadata) datasetMetadata_;
    }
    return com.google.cloud.automl.v1beta1.VideoObjectTrackingDatasetMetadata.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Metadata for a dataset used for video object tracking.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.VideoObjectTrackingDatasetMetadata video_object_tracking_dataset_metadata = 29;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.VideoObjectTrackingDatasetMetadataOrBuilder
      getVideoObjectTrackingDatasetMetadataOrBuilder() {
    if (datasetMetadataCase_ == 29) {
      return (com.google.cloud.automl.v1beta1.VideoObjectTrackingDatasetMetadata) datasetMetadata_;
    }
    return com.google.cloud.automl.v1beta1.VideoObjectTrackingDatasetMetadata.getDefaultInstance();
  }

  public static final int TEXT_EXTRACTION_DATASET_METADATA_FIELD_NUMBER = 28;
  /**
   *
   *
   * <pre>
   * Metadata for a dataset used for text extraction.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.TextExtractionDatasetMetadata text_extraction_dataset_metadata = 28;
   * </code>
   *
   * @return Whether the textExtractionDatasetMetadata field is set.
   */
  @java.lang.Override
  public boolean hasTextExtractionDatasetMetadata() {
    return datasetMetadataCase_ == 28;
  }
  /**
   *
   *
   * <pre>
   * Metadata for a dataset used for text extraction.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.TextExtractionDatasetMetadata text_extraction_dataset_metadata = 28;
   * </code>
   *
   * @return The textExtractionDatasetMetadata.
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.TextExtractionDatasetMetadata
      getTextExtractionDatasetMetadata() {
    if (datasetMetadataCase_ == 28) {
      return (com.google.cloud.automl.v1beta1.TextExtractionDatasetMetadata) datasetMetadata_;
    }
    return com.google.cloud.automl.v1beta1.TextExtractionDatasetMetadata.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Metadata for a dataset used for text extraction.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.TextExtractionDatasetMetadata text_extraction_dataset_metadata = 28;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.TextExtractionDatasetMetadataOrBuilder
      getTextExtractionDatasetMetadataOrBuilder() {
    if (datasetMetadataCase_ == 28) {
      return (com.google.cloud.automl.v1beta1.TextExtractionDatasetMetadata) datasetMetadata_;
    }
    return com.google.cloud.automl.v1beta1.TextExtractionDatasetMetadata.getDefaultInstance();
  }

  public static final int TEXT_SENTIMENT_DATASET_METADATA_FIELD_NUMBER = 30;
  /**
   *
   *
   * <pre>
   * Metadata for a dataset used for text sentiment.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.TextSentimentDatasetMetadata text_sentiment_dataset_metadata = 30;
   * </code>
   *
   * @return Whether the textSentimentDatasetMetadata field is set.
   */
  @java.lang.Override
  public boolean hasTextSentimentDatasetMetadata() {
    return datasetMetadataCase_ == 30;
  }
  /**
   *
   *
   * <pre>
   * Metadata for a dataset used for text sentiment.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.TextSentimentDatasetMetadata text_sentiment_dataset_metadata = 30;
   * </code>
   *
   * @return The textSentimentDatasetMetadata.
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.TextSentimentDatasetMetadata
      getTextSentimentDatasetMetadata() {
    if (datasetMetadataCase_ == 30) {
      return (com.google.cloud.automl.v1beta1.TextSentimentDatasetMetadata) datasetMetadata_;
    }
    return com.google.cloud.automl.v1beta1.TextSentimentDatasetMetadata.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Metadata for a dataset used for text sentiment.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.TextSentimentDatasetMetadata text_sentiment_dataset_metadata = 30;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.TextSentimentDatasetMetadataOrBuilder
      getTextSentimentDatasetMetadataOrBuilder() {
    if (datasetMetadataCase_ == 30) {
      return (com.google.cloud.automl.v1beta1.TextSentimentDatasetMetadata) datasetMetadata_;
    }
    return com.google.cloud.automl.v1beta1.TextSentimentDatasetMetadata.getDefaultInstance();
  }

  public static final int TABLES_DATASET_METADATA_FIELD_NUMBER = 33;
  /**
   *
   *
   * <pre>
   * Metadata for a dataset used for Tables.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.TablesDatasetMetadata tables_dataset_metadata = 33;</code>
   *
   * @return Whether the tablesDatasetMetadata field is set.
   */
  @java.lang.Override
  public boolean hasTablesDatasetMetadata() {
    return datasetMetadataCase_ == 33;
  }
  /**
   *
   *
   * <pre>
   * Metadata for a dataset used for Tables.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.TablesDatasetMetadata tables_dataset_metadata = 33;</code>
   *
   * @return The tablesDatasetMetadata.
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.TablesDatasetMetadata getTablesDatasetMetadata() {
    if (datasetMetadataCase_ == 33) {
      return (com.google.cloud.automl.v1beta1.TablesDatasetMetadata) datasetMetadata_;
    }
    return com.google.cloud.automl.v1beta1.TablesDatasetMetadata.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Metadata for a dataset used for Tables.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.TablesDatasetMetadata tables_dataset_metadata = 33;</code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.TablesDatasetMetadataOrBuilder
      getTablesDatasetMetadataOrBuilder() {
    if (datasetMetadataCase_ == 33) {
      return (com.google.cloud.automl.v1beta1.TablesDatasetMetadata) datasetMetadata_;
    }
    return com.google.cloud.automl.v1beta1.TablesDatasetMetadata.getDefaultInstance();
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the dataset.
   * Form: `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the dataset.
   * Form: `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;
  private volatile java.lang.Object displayName_;
  /**
   *
   *
   * <pre>
   * Required. The name of the dataset to show in the interface. The name can be
   * up to 32 characters long and can consist only of ASCII Latin letters A-Z
   * and a-z, underscores
   * (_), and ASCII digits 0-9.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The name of the dataset to show in the interface. The name can be
   * up to 32 characters long and can consist only of ASCII Latin letters A-Z
   * and a-z, underscores
   * (_), and ASCII digits 0-9.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 3;
  private volatile java.lang.Object description_;
  /**
   *
   *
   * <pre>
   * User-provided description of the dataset. The description can be up to
   * 25000 characters long.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * User-provided description of the dataset. The description can be up to
   * 25000 characters long.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EXAMPLE_COUNT_FIELD_NUMBER = 21;
  private int exampleCount_;
  /**
   *
   *
   * <pre>
   * Output only. The number of examples in the dataset.
   * </pre>
   *
   * <code>int32 example_count = 21;</code>
   *
   * @return The exampleCount.
   */
  @java.lang.Override
  public int getExampleCount() {
    return exampleCount_;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 14;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this dataset was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 14;</code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this dataset was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 14;</code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this dataset was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 14;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return getCreateTime();
  }

  public static final int ETAG_FIELD_NUMBER = 17;
  private volatile java.lang.Object etag_;
  /**
   *
   *
   * <pre>
   * Used to perform consistent read-modify-write updates. If not set, a blind
   * "overwrite" update happens.
   * </pre>
   *
   * <code>string etag = 17;</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Used to perform consistent read-modify-write updates. If not set, a blind
   * "overwrite" update happens.
   * </pre>
   *
   * <code>string etag = 17;</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, description_);
    }
    if (createTime_ != null) {
      output.writeMessage(14, getCreateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 17, etag_);
    }
    if (exampleCount_ != 0) {
      output.writeInt32(21, exampleCount_);
    }
    if (datasetMetadataCase_ == 23) {
      output.writeMessage(
          23, (com.google.cloud.automl.v1beta1.TranslationDatasetMetadata) datasetMetadata_);
    }
    if (datasetMetadataCase_ == 24) {
      output.writeMessage(
          24,
          (com.google.cloud.automl.v1beta1.ImageClassificationDatasetMetadata) datasetMetadata_);
    }
    if (datasetMetadataCase_ == 25) {
      output.writeMessage(
          25, (com.google.cloud.automl.v1beta1.TextClassificationDatasetMetadata) datasetMetadata_);
    }
    if (datasetMetadataCase_ == 26) {
      output.writeMessage(
          26,
          (com.google.cloud.automl.v1beta1.ImageObjectDetectionDatasetMetadata) datasetMetadata_);
    }
    if (datasetMetadataCase_ == 28) {
      output.writeMessage(
          28, (com.google.cloud.automl.v1beta1.TextExtractionDatasetMetadata) datasetMetadata_);
    }
    if (datasetMetadataCase_ == 29) {
      output.writeMessage(
          29,
          (com.google.cloud.automl.v1beta1.VideoObjectTrackingDatasetMetadata) datasetMetadata_);
    }
    if (datasetMetadataCase_ == 30) {
      output.writeMessage(
          30, (com.google.cloud.automl.v1beta1.TextSentimentDatasetMetadata) datasetMetadata_);
    }
    if (datasetMetadataCase_ == 31) {
      output.writeMessage(
          31,
          (com.google.cloud.automl.v1beta1.VideoClassificationDatasetMetadata) datasetMetadata_);
    }
    if (datasetMetadataCase_ == 33) {
      output.writeMessage(
          33, (com.google.cloud.automl.v1beta1.TablesDatasetMetadata) datasetMetadata_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, description_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, getCreateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(17, etag_);
    }
    if (exampleCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(21, exampleCount_);
    }
    if (datasetMetadataCase_ == 23) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              23, (com.google.cloud.automl.v1beta1.TranslationDatasetMetadata) datasetMetadata_);
    }
    if (datasetMetadataCase_ == 24) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              24,
              (com.google.cloud.automl.v1beta1.ImageClassificationDatasetMetadata)
                  datasetMetadata_);
    }
    if (datasetMetadataCase_ == 25) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              25,
              (com.google.cloud.automl.v1beta1.TextClassificationDatasetMetadata) datasetMetadata_);
    }
    if (datasetMetadataCase_ == 26) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              26,
              (com.google.cloud.automl.v1beta1.ImageObjectDetectionDatasetMetadata)
                  datasetMetadata_);
    }
    if (datasetMetadataCase_ == 28) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              28, (com.google.cloud.automl.v1beta1.TextExtractionDatasetMetadata) datasetMetadata_);
    }
    if (datasetMetadataCase_ == 29) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              29,
              (com.google.cloud.automl.v1beta1.VideoObjectTrackingDatasetMetadata)
                  datasetMetadata_);
    }
    if (datasetMetadataCase_ == 30) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              30, (com.google.cloud.automl.v1beta1.TextSentimentDatasetMetadata) datasetMetadata_);
    }
    if (datasetMetadataCase_ == 31) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              31,
              (com.google.cloud.automl.v1beta1.VideoClassificationDatasetMetadata)
                  datasetMetadata_);
    }
    if (datasetMetadataCase_ == 33) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              33, (com.google.cloud.automl.v1beta1.TablesDatasetMetadata) datasetMetadata_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.automl.v1beta1.Dataset)) {
      return super.equals(obj);
    }
    com.google.cloud.automl.v1beta1.Dataset other = (com.google.cloud.automl.v1beta1.Dataset) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (getExampleCount() != other.getExampleCount()) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (!getEtag().equals(other.getEtag())) return false;
    if (!getDatasetMetadataCase().equals(other.getDatasetMetadataCase())) return false;
    switch (datasetMetadataCase_) {
      case 23:
        if (!getTranslationDatasetMetadata().equals(other.getTranslationDatasetMetadata()))
          return false;
        break;
      case 24:
        if (!getImageClassificationDatasetMetadata()
            .equals(other.getImageClassificationDatasetMetadata())) return false;
        break;
      case 25:
        if (!getTextClassificationDatasetMetadata()
            .equals(other.getTextClassificationDatasetMetadata())) return false;
        break;
      case 26:
        if (!getImageObjectDetectionDatasetMetadata()
            .equals(other.getImageObjectDetectionDatasetMetadata())) return false;
        break;
      case 31:
        if (!getVideoClassificationDatasetMetadata()
            .equals(other.getVideoClassificationDatasetMetadata())) return false;
        break;
      case 29:
        if (!getVideoObjectTrackingDatasetMetadata()
            .equals(other.getVideoObjectTrackingDatasetMetadata())) return false;
        break;
      case 28:
        if (!getTextExtractionDatasetMetadata().equals(other.getTextExtractionDatasetMetadata()))
          return false;
        break;
      case 30:
        if (!getTextSentimentDatasetMetadata().equals(other.getTextSentimentDatasetMetadata()))
          return false;
        break;
      case 33:
        if (!getTablesDatasetMetadata().equals(other.getTablesDatasetMetadata())) return false;
        break;
      case 0:
      default:
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + EXAMPLE_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getExampleCount();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    switch (datasetMetadataCase_) {
      case 23:
        hash = (37 * hash) + TRANSLATION_DATASET_METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getTranslationDatasetMetadata().hashCode();
        break;
      case 24:
        hash = (37 * hash) + IMAGE_CLASSIFICATION_DATASET_METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getImageClassificationDatasetMetadata().hashCode();
        break;
      case 25:
        hash = (37 * hash) + TEXT_CLASSIFICATION_DATASET_METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getTextClassificationDatasetMetadata().hashCode();
        break;
      case 26:
        hash = (37 * hash) + IMAGE_OBJECT_DETECTION_DATASET_METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getImageObjectDetectionDatasetMetadata().hashCode();
        break;
      case 31:
        hash = (37 * hash) + VIDEO_CLASSIFICATION_DATASET_METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getVideoClassificationDatasetMetadata().hashCode();
        break;
      case 29:
        hash = (37 * hash) + VIDEO_OBJECT_TRACKING_DATASET_METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getVideoObjectTrackingDatasetMetadata().hashCode();
        break;
      case 28:
        hash = (37 * hash) + TEXT_EXTRACTION_DATASET_METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getTextExtractionDatasetMetadata().hashCode();
        break;
      case 30:
        hash = (37 * hash) + TEXT_SENTIMENT_DATASET_METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getTextSentimentDatasetMetadata().hashCode();
        break;
      case 33:
        hash = (37 * hash) + TABLES_DATASET_METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getTablesDatasetMetadata().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.automl.v1beta1.Dataset parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1beta1.Dataset parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.Dataset parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1beta1.Dataset parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.Dataset parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1beta1.Dataset parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.Dataset parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1beta1.Dataset parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.Dataset parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1beta1.Dataset parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.Dataset parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1beta1.Dataset parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.automl.v1beta1.Dataset prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A workspace for solving a single, particular machine learning (ML) problem.
   * A workspace contains examples that may be annotated.
   * </pre>
   *
   * Protobuf type {@code google.cloud.automl.v1beta1.Dataset}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.automl.v1beta1.Dataset)
      com.google.cloud.automl.v1beta1.DatasetOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.automl.v1beta1.DatasetOuterClass
          .internal_static_google_cloud_automl_v1beta1_Dataset_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.automl.v1beta1.DatasetOuterClass
          .internal_static_google_cloud_automl_v1beta1_Dataset_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.automl.v1beta1.Dataset.class,
              com.google.cloud.automl.v1beta1.Dataset.Builder.class);
    }

    // Construct using com.google.cloud.automl.v1beta1.Dataset.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      displayName_ = "";

      description_ = "";

      exampleCount_ = 0;

      if (createTimeBuilder_ == null) {
        createTime_ = null;
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }
      etag_ = "";

      datasetMetadataCase_ = 0;
      datasetMetadata_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.automl.v1beta1.DatasetOuterClass
          .internal_static_google_cloud_automl_v1beta1_Dataset_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.Dataset getDefaultInstanceForType() {
      return com.google.cloud.automl.v1beta1.Dataset.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.Dataset build() {
      com.google.cloud.automl.v1beta1.Dataset result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.Dataset buildPartial() {
      com.google.cloud.automl.v1beta1.Dataset result =
          new com.google.cloud.automl.v1beta1.Dataset(this);
      if (datasetMetadataCase_ == 23) {
        if (translationDatasetMetadataBuilder_ == null) {
          result.datasetMetadata_ = datasetMetadata_;
        } else {
          result.datasetMetadata_ = translationDatasetMetadataBuilder_.build();
        }
      }
      if (datasetMetadataCase_ == 24) {
        if (imageClassificationDatasetMetadataBuilder_ == null) {
          result.datasetMetadata_ = datasetMetadata_;
        } else {
          result.datasetMetadata_ = imageClassificationDatasetMetadataBuilder_.build();
        }
      }
      if (datasetMetadataCase_ == 25) {
        if (textClassificationDatasetMetadataBuilder_ == null) {
          result.datasetMetadata_ = datasetMetadata_;
        } else {
          result.datasetMetadata_ = textClassificationDatasetMetadataBuilder_.build();
        }
      }
      if (datasetMetadataCase_ == 26) {
        if (imageObjectDetectionDatasetMetadataBuilder_ == null) {
          result.datasetMetadata_ = datasetMetadata_;
        } else {
          result.datasetMetadata_ = imageObjectDetectionDatasetMetadataBuilder_.build();
        }
      }
      if (datasetMetadataCase_ == 31) {
        if (videoClassificationDatasetMetadataBuilder_ == null) {
          result.datasetMetadata_ = datasetMetadata_;
        } else {
          result.datasetMetadata_ = videoClassificationDatasetMetadataBuilder_.build();
        }
      }
      if (datasetMetadataCase_ == 29) {
        if (videoObjectTrackingDatasetMetadataBuilder_ == null) {
          result.datasetMetadata_ = datasetMetadata_;
        } else {
          result.datasetMetadata_ = videoObjectTrackingDatasetMetadataBuilder_.build();
        }
      }
      if (datasetMetadataCase_ == 28) {
        if (textExtractionDatasetMetadataBuilder_ == null) {
          result.datasetMetadata_ = datasetMetadata_;
        } else {
          result.datasetMetadata_ = textExtractionDatasetMetadataBuilder_.build();
        }
      }
      if (datasetMetadataCase_ == 30) {
        if (textSentimentDatasetMetadataBuilder_ == null) {
          result.datasetMetadata_ = datasetMetadata_;
        } else {
          result.datasetMetadata_ = textSentimentDatasetMetadataBuilder_.build();
        }
      }
      if (datasetMetadataCase_ == 33) {
        if (tablesDatasetMetadataBuilder_ == null) {
          result.datasetMetadata_ = datasetMetadata_;
        } else {
          result.datasetMetadata_ = tablesDatasetMetadataBuilder_.build();
        }
      }
      result.name_ = name_;
      result.displayName_ = displayName_;
      result.description_ = description_;
      result.exampleCount_ = exampleCount_;
      if (createTimeBuilder_ == null) {
        result.createTime_ = createTime_;
      } else {
        result.createTime_ = createTimeBuilder_.build();
      }
      result.etag_ = etag_;
      result.datasetMetadataCase_ = datasetMetadataCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.automl.v1beta1.Dataset) {
        return mergeFrom((com.google.cloud.automl.v1beta1.Dataset) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.automl.v1beta1.Dataset other) {
      if (other == com.google.cloud.automl.v1beta1.Dataset.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        onChanged();
      }
      if (other.getExampleCount() != 0) {
        setExampleCount(other.getExampleCount());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        onChanged();
      }
      switch (other.getDatasetMetadataCase()) {
        case TRANSLATION_DATASET_METADATA:
          {
            mergeTranslationDatasetMetadata(other.getTranslationDatasetMetadata());
            break;
          }
        case IMAGE_CLASSIFICATION_DATASET_METADATA:
          {
            mergeImageClassificationDatasetMetadata(other.getImageClassificationDatasetMetadata());
            break;
          }
        case TEXT_CLASSIFICATION_DATASET_METADATA:
          {
            mergeTextClassificationDatasetMetadata(other.getTextClassificationDatasetMetadata());
            break;
          }
        case IMAGE_OBJECT_DETECTION_DATASET_METADATA:
          {
            mergeImageObjectDetectionDatasetMetadata(
                other.getImageObjectDetectionDatasetMetadata());
            break;
          }
        case VIDEO_CLASSIFICATION_DATASET_METADATA:
          {
            mergeVideoClassificationDatasetMetadata(other.getVideoClassificationDatasetMetadata());
            break;
          }
        case VIDEO_OBJECT_TRACKING_DATASET_METADATA:
          {
            mergeVideoObjectTrackingDatasetMetadata(other.getVideoObjectTrackingDatasetMetadata());
            break;
          }
        case TEXT_EXTRACTION_DATASET_METADATA:
          {
            mergeTextExtractionDatasetMetadata(other.getTextExtractionDatasetMetadata());
            break;
          }
        case TEXT_SENTIMENT_DATASET_METADATA:
          {
            mergeTextSentimentDatasetMetadata(other.getTextSentimentDatasetMetadata());
            break;
          }
        case TABLES_DATASET_METADATA:
          {
            mergeTablesDatasetMetadata(other.getTablesDatasetMetadata());
            break;
          }
        case DATASETMETADATA_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.automl.v1beta1.Dataset parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloud.automl.v1beta1.Dataset) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int datasetMetadataCase_ = 0;
    private java.lang.Object datasetMetadata_;

    public DatasetMetadataCase getDatasetMetadataCase() {
      return DatasetMetadataCase.forNumber(datasetMetadataCase_);
    }

    public Builder clearDatasetMetadata() {
      datasetMetadataCase_ = 0;
      datasetMetadata_ = null;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.TranslationDatasetMetadata,
            com.google.cloud.automl.v1beta1.TranslationDatasetMetadata.Builder,
            com.google.cloud.automl.v1beta1.TranslationDatasetMetadataOrBuilder>
        translationDatasetMetadataBuilder_;
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for translation.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TranslationDatasetMetadata translation_dataset_metadata = 23;
     * </code>
     *
     * @return Whether the translationDatasetMetadata field is set.
     */
    @java.lang.Override
    public boolean hasTranslationDatasetMetadata() {
      return datasetMetadataCase_ == 23;
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for translation.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TranslationDatasetMetadata translation_dataset_metadata = 23;
     * </code>
     *
     * @return The translationDatasetMetadata.
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.TranslationDatasetMetadata
        getTranslationDatasetMetadata() {
      if (translationDatasetMetadataBuilder_ == null) {
        if (datasetMetadataCase_ == 23) {
          return (com.google.cloud.automl.v1beta1.TranslationDatasetMetadata) datasetMetadata_;
        }
        return com.google.cloud.automl.v1beta1.TranslationDatasetMetadata.getDefaultInstance();
      } else {
        if (datasetMetadataCase_ == 23) {
          return translationDatasetMetadataBuilder_.getMessage();
        }
        return com.google.cloud.automl.v1beta1.TranslationDatasetMetadata.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for translation.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TranslationDatasetMetadata translation_dataset_metadata = 23;
     * </code>
     */
    public Builder setTranslationDatasetMetadata(
        com.google.cloud.automl.v1beta1.TranslationDatasetMetadata value) {
      if (translationDatasetMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        datasetMetadata_ = value;
        onChanged();
      } else {
        translationDatasetMetadataBuilder_.setMessage(value);
      }
      datasetMetadataCase_ = 23;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for translation.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TranslationDatasetMetadata translation_dataset_metadata = 23;
     * </code>
     */
    public Builder setTranslationDatasetMetadata(
        com.google.cloud.automl.v1beta1.TranslationDatasetMetadata.Builder builderForValue) {
      if (translationDatasetMetadataBuilder_ == null) {
        datasetMetadata_ = builderForValue.build();
        onChanged();
      } else {
        translationDatasetMetadataBuilder_.setMessage(builderForValue.build());
      }
      datasetMetadataCase_ = 23;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for translation.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TranslationDatasetMetadata translation_dataset_metadata = 23;
     * </code>
     */
    public Builder mergeTranslationDatasetMetadata(
        com.google.cloud.automl.v1beta1.TranslationDatasetMetadata value) {
      if (translationDatasetMetadataBuilder_ == null) {
        if (datasetMetadataCase_ == 23
            && datasetMetadata_
                != com.google.cloud.automl.v1beta1.TranslationDatasetMetadata
                    .getDefaultInstance()) {
          datasetMetadata_ =
              com.google.cloud.automl.v1beta1.TranslationDatasetMetadata.newBuilder(
                      (com.google.cloud.automl.v1beta1.TranslationDatasetMetadata) datasetMetadata_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          datasetMetadata_ = value;
        }
        onChanged();
      } else {
        if (datasetMetadataCase_ == 23) {
          translationDatasetMetadataBuilder_.mergeFrom(value);
        } else {
          translationDatasetMetadataBuilder_.setMessage(value);
        }
      }
      datasetMetadataCase_ = 23;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for translation.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TranslationDatasetMetadata translation_dataset_metadata = 23;
     * </code>
     */
    public Builder clearTranslationDatasetMetadata() {
      if (translationDatasetMetadataBuilder_ == null) {
        if (datasetMetadataCase_ == 23) {
          datasetMetadataCase_ = 0;
          datasetMetadata_ = null;
          onChanged();
        }
      } else {
        if (datasetMetadataCase_ == 23) {
          datasetMetadataCase_ = 0;
          datasetMetadata_ = null;
        }
        translationDatasetMetadataBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for translation.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TranslationDatasetMetadata translation_dataset_metadata = 23;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.TranslationDatasetMetadata.Builder
        getTranslationDatasetMetadataBuilder() {
      return getTranslationDatasetMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for translation.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TranslationDatasetMetadata translation_dataset_metadata = 23;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.TranslationDatasetMetadataOrBuilder
        getTranslationDatasetMetadataOrBuilder() {
      if ((datasetMetadataCase_ == 23) && (translationDatasetMetadataBuilder_ != null)) {
        return translationDatasetMetadataBuilder_.getMessageOrBuilder();
      } else {
        if (datasetMetadataCase_ == 23) {
          return (com.google.cloud.automl.v1beta1.TranslationDatasetMetadata) datasetMetadata_;
        }
        return com.google.cloud.automl.v1beta1.TranslationDatasetMetadata.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for translation.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TranslationDatasetMetadata translation_dataset_metadata = 23;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.TranslationDatasetMetadata,
            com.google.cloud.automl.v1beta1.TranslationDatasetMetadata.Builder,
            com.google.cloud.automl.v1beta1.TranslationDatasetMetadataOrBuilder>
        getTranslationDatasetMetadataFieldBuilder() {
      if (translationDatasetMetadataBuilder_ == null) {
        if (!(datasetMetadataCase_ == 23)) {
          datasetMetadata_ =
              com.google.cloud.automl.v1beta1.TranslationDatasetMetadata.getDefaultInstance();
        }
        translationDatasetMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.automl.v1beta1.TranslationDatasetMetadata,
                com.google.cloud.automl.v1beta1.TranslationDatasetMetadata.Builder,
                com.google.cloud.automl.v1beta1.TranslationDatasetMetadataOrBuilder>(
                (com.google.cloud.automl.v1beta1.TranslationDatasetMetadata) datasetMetadata_,
                getParentForChildren(),
                isClean());
        datasetMetadata_ = null;
      }
      datasetMetadataCase_ = 23;
      onChanged();
      ;
      return translationDatasetMetadataBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.ImageClassificationDatasetMetadata,
            com.google.cloud.automl.v1beta1.ImageClassificationDatasetMetadata.Builder,
            com.google.cloud.automl.v1beta1.ImageClassificationDatasetMetadataOrBuilder>
        imageClassificationDatasetMetadataBuilder_;
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for image classification.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ImageClassificationDatasetMetadata image_classification_dataset_metadata = 24;
     * </code>
     *
     * @return Whether the imageClassificationDatasetMetadata field is set.
     */
    @java.lang.Override
    public boolean hasImageClassificationDatasetMetadata() {
      return datasetMetadataCase_ == 24;
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for image classification.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ImageClassificationDatasetMetadata image_classification_dataset_metadata = 24;
     * </code>
     *
     * @return The imageClassificationDatasetMetadata.
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.ImageClassificationDatasetMetadata
        getImageClassificationDatasetMetadata() {
      if (imageClassificationDatasetMetadataBuilder_ == null) {
        if (datasetMetadataCase_ == 24) {
          return (com.google.cloud.automl.v1beta1.ImageClassificationDatasetMetadata)
              datasetMetadata_;
        }
        return com.google.cloud.automl.v1beta1.ImageClassificationDatasetMetadata
            .getDefaultInstance();
      } else {
        if (datasetMetadataCase_ == 24) {
          return imageClassificationDatasetMetadataBuilder_.getMessage();
        }
        return com.google.cloud.automl.v1beta1.ImageClassificationDatasetMetadata
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for image classification.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ImageClassificationDatasetMetadata image_classification_dataset_metadata = 24;
     * </code>
     */
    public Builder setImageClassificationDatasetMetadata(
        com.google.cloud.automl.v1beta1.ImageClassificationDatasetMetadata value) {
      if (imageClassificationDatasetMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        datasetMetadata_ = value;
        onChanged();
      } else {
        imageClassificationDatasetMetadataBuilder_.setMessage(value);
      }
      datasetMetadataCase_ = 24;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for image classification.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ImageClassificationDatasetMetadata image_classification_dataset_metadata = 24;
     * </code>
     */
    public Builder setImageClassificationDatasetMetadata(
        com.google.cloud.automl.v1beta1.ImageClassificationDatasetMetadata.Builder
            builderForValue) {
      if (imageClassificationDatasetMetadataBuilder_ == null) {
        datasetMetadata_ = builderForValue.build();
        onChanged();
      } else {
        imageClassificationDatasetMetadataBuilder_.setMessage(builderForValue.build());
      }
      datasetMetadataCase_ = 24;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for image classification.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ImageClassificationDatasetMetadata image_classification_dataset_metadata = 24;
     * </code>
     */
    public Builder mergeImageClassificationDatasetMetadata(
        com.google.cloud.automl.v1beta1.ImageClassificationDatasetMetadata value) {
      if (imageClassificationDatasetMetadataBuilder_ == null) {
        if (datasetMetadataCase_ == 24
            && datasetMetadata_
                != com.google.cloud.automl.v1beta1.ImageClassificationDatasetMetadata
                    .getDefaultInstance()) {
          datasetMetadata_ =
              com.google.cloud.automl.v1beta1.ImageClassificationDatasetMetadata.newBuilder(
                      (com.google.cloud.automl.v1beta1.ImageClassificationDatasetMetadata)
                          datasetMetadata_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          datasetMetadata_ = value;
        }
        onChanged();
      } else {
        if (datasetMetadataCase_ == 24) {
          imageClassificationDatasetMetadataBuilder_.mergeFrom(value);
        } else {
          imageClassificationDatasetMetadataBuilder_.setMessage(value);
        }
      }
      datasetMetadataCase_ = 24;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for image classification.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ImageClassificationDatasetMetadata image_classification_dataset_metadata = 24;
     * </code>
     */
    public Builder clearImageClassificationDatasetMetadata() {
      if (imageClassificationDatasetMetadataBuilder_ == null) {
        if (datasetMetadataCase_ == 24) {
          datasetMetadataCase_ = 0;
          datasetMetadata_ = null;
          onChanged();
        }
      } else {
        if (datasetMetadataCase_ == 24) {
          datasetMetadataCase_ = 0;
          datasetMetadata_ = null;
        }
        imageClassificationDatasetMetadataBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for image classification.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ImageClassificationDatasetMetadata image_classification_dataset_metadata = 24;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.ImageClassificationDatasetMetadata.Builder
        getImageClassificationDatasetMetadataBuilder() {
      return getImageClassificationDatasetMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for image classification.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ImageClassificationDatasetMetadata image_classification_dataset_metadata = 24;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.ImageClassificationDatasetMetadataOrBuilder
        getImageClassificationDatasetMetadataOrBuilder() {
      if ((datasetMetadataCase_ == 24) && (imageClassificationDatasetMetadataBuilder_ != null)) {
        return imageClassificationDatasetMetadataBuilder_.getMessageOrBuilder();
      } else {
        if (datasetMetadataCase_ == 24) {
          return (com.google.cloud.automl.v1beta1.ImageClassificationDatasetMetadata)
              datasetMetadata_;
        }
        return com.google.cloud.automl.v1beta1.ImageClassificationDatasetMetadata
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for image classification.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ImageClassificationDatasetMetadata image_classification_dataset_metadata = 24;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.ImageClassificationDatasetMetadata,
            com.google.cloud.automl.v1beta1.ImageClassificationDatasetMetadata.Builder,
            com.google.cloud.automl.v1beta1.ImageClassificationDatasetMetadataOrBuilder>
        getImageClassificationDatasetMetadataFieldBuilder() {
      if (imageClassificationDatasetMetadataBuilder_ == null) {
        if (!(datasetMetadataCase_ == 24)) {
          datasetMetadata_ =
              com.google.cloud.automl.v1beta1.ImageClassificationDatasetMetadata
                  .getDefaultInstance();
        }
        imageClassificationDatasetMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.automl.v1beta1.ImageClassificationDatasetMetadata,
                com.google.cloud.automl.v1beta1.ImageClassificationDatasetMetadata.Builder,
                com.google.cloud.automl.v1beta1.ImageClassificationDatasetMetadataOrBuilder>(
                (com.google.cloud.automl.v1beta1.ImageClassificationDatasetMetadata)
                    datasetMetadata_,
                getParentForChildren(),
                isClean());
        datasetMetadata_ = null;
      }
      datasetMetadataCase_ = 24;
      onChanged();
      ;
      return imageClassificationDatasetMetadataBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.TextClassificationDatasetMetadata,
            com.google.cloud.automl.v1beta1.TextClassificationDatasetMetadata.Builder,
            com.google.cloud.automl.v1beta1.TextClassificationDatasetMetadataOrBuilder>
        textClassificationDatasetMetadataBuilder_;
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for text classification.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextClassificationDatasetMetadata text_classification_dataset_metadata = 25;
     * </code>
     *
     * @return Whether the textClassificationDatasetMetadata field is set.
     */
    @java.lang.Override
    public boolean hasTextClassificationDatasetMetadata() {
      return datasetMetadataCase_ == 25;
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for text classification.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextClassificationDatasetMetadata text_classification_dataset_metadata = 25;
     * </code>
     *
     * @return The textClassificationDatasetMetadata.
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.TextClassificationDatasetMetadata
        getTextClassificationDatasetMetadata() {
      if (textClassificationDatasetMetadataBuilder_ == null) {
        if (datasetMetadataCase_ == 25) {
          return (com.google.cloud.automl.v1beta1.TextClassificationDatasetMetadata)
              datasetMetadata_;
        }
        return com.google.cloud.automl.v1beta1.TextClassificationDatasetMetadata
            .getDefaultInstance();
      } else {
        if (datasetMetadataCase_ == 25) {
          return textClassificationDatasetMetadataBuilder_.getMessage();
        }
        return com.google.cloud.automl.v1beta1.TextClassificationDatasetMetadata
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for text classification.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextClassificationDatasetMetadata text_classification_dataset_metadata = 25;
     * </code>
     */
    public Builder setTextClassificationDatasetMetadata(
        com.google.cloud.automl.v1beta1.TextClassificationDatasetMetadata value) {
      if (textClassificationDatasetMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        datasetMetadata_ = value;
        onChanged();
      } else {
        textClassificationDatasetMetadataBuilder_.setMessage(value);
      }
      datasetMetadataCase_ = 25;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for text classification.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextClassificationDatasetMetadata text_classification_dataset_metadata = 25;
     * </code>
     */
    public Builder setTextClassificationDatasetMetadata(
        com.google.cloud.automl.v1beta1.TextClassificationDatasetMetadata.Builder builderForValue) {
      if (textClassificationDatasetMetadataBuilder_ == null) {
        datasetMetadata_ = builderForValue.build();
        onChanged();
      } else {
        textClassificationDatasetMetadataBuilder_.setMessage(builderForValue.build());
      }
      datasetMetadataCase_ = 25;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for text classification.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextClassificationDatasetMetadata text_classification_dataset_metadata = 25;
     * </code>
     */
    public Builder mergeTextClassificationDatasetMetadata(
        com.google.cloud.automl.v1beta1.TextClassificationDatasetMetadata value) {
      if (textClassificationDatasetMetadataBuilder_ == null) {
        if (datasetMetadataCase_ == 25
            && datasetMetadata_
                != com.google.cloud.automl.v1beta1.TextClassificationDatasetMetadata
                    .getDefaultInstance()) {
          datasetMetadata_ =
              com.google.cloud.automl.v1beta1.TextClassificationDatasetMetadata.newBuilder(
                      (com.google.cloud.automl.v1beta1.TextClassificationDatasetMetadata)
                          datasetMetadata_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          datasetMetadata_ = value;
        }
        onChanged();
      } else {
        if (datasetMetadataCase_ == 25) {
          textClassificationDatasetMetadataBuilder_.mergeFrom(value);
        } else {
          textClassificationDatasetMetadataBuilder_.setMessage(value);
        }
      }
      datasetMetadataCase_ = 25;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for text classification.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextClassificationDatasetMetadata text_classification_dataset_metadata = 25;
     * </code>
     */
    public Builder clearTextClassificationDatasetMetadata() {
      if (textClassificationDatasetMetadataBuilder_ == null) {
        if (datasetMetadataCase_ == 25) {
          datasetMetadataCase_ = 0;
          datasetMetadata_ = null;
          onChanged();
        }
      } else {
        if (datasetMetadataCase_ == 25) {
          datasetMetadataCase_ = 0;
          datasetMetadata_ = null;
        }
        textClassificationDatasetMetadataBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for text classification.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextClassificationDatasetMetadata text_classification_dataset_metadata = 25;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.TextClassificationDatasetMetadata.Builder
        getTextClassificationDatasetMetadataBuilder() {
      return getTextClassificationDatasetMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for text classification.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextClassificationDatasetMetadata text_classification_dataset_metadata = 25;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.TextClassificationDatasetMetadataOrBuilder
        getTextClassificationDatasetMetadataOrBuilder() {
      if ((datasetMetadataCase_ == 25) && (textClassificationDatasetMetadataBuilder_ != null)) {
        return textClassificationDatasetMetadataBuilder_.getMessageOrBuilder();
      } else {
        if (datasetMetadataCase_ == 25) {
          return (com.google.cloud.automl.v1beta1.TextClassificationDatasetMetadata)
              datasetMetadata_;
        }
        return com.google.cloud.automl.v1beta1.TextClassificationDatasetMetadata
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for text classification.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextClassificationDatasetMetadata text_classification_dataset_metadata = 25;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.TextClassificationDatasetMetadata,
            com.google.cloud.automl.v1beta1.TextClassificationDatasetMetadata.Builder,
            com.google.cloud.automl.v1beta1.TextClassificationDatasetMetadataOrBuilder>
        getTextClassificationDatasetMetadataFieldBuilder() {
      if (textClassificationDatasetMetadataBuilder_ == null) {
        if (!(datasetMetadataCase_ == 25)) {
          datasetMetadata_ =
              com.google.cloud.automl.v1beta1.TextClassificationDatasetMetadata
                  .getDefaultInstance();
        }
        textClassificationDatasetMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.automl.v1beta1.TextClassificationDatasetMetadata,
                com.google.cloud.automl.v1beta1.TextClassificationDatasetMetadata.Builder,
                com.google.cloud.automl.v1beta1.TextClassificationDatasetMetadataOrBuilder>(
                (com.google.cloud.automl.v1beta1.TextClassificationDatasetMetadata)
                    datasetMetadata_,
                getParentForChildren(),
                isClean());
        datasetMetadata_ = null;
      }
      datasetMetadataCase_ = 25;
      onChanged();
      ;
      return textClassificationDatasetMetadataBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.ImageObjectDetectionDatasetMetadata,
            com.google.cloud.automl.v1beta1.ImageObjectDetectionDatasetMetadata.Builder,
            com.google.cloud.automl.v1beta1.ImageObjectDetectionDatasetMetadataOrBuilder>
        imageObjectDetectionDatasetMetadataBuilder_;
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for image object detection.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ImageObjectDetectionDatasetMetadata image_object_detection_dataset_metadata = 26;
     * </code>
     *
     * @return Whether the imageObjectDetectionDatasetMetadata field is set.
     */
    @java.lang.Override
    public boolean hasImageObjectDetectionDatasetMetadata() {
      return datasetMetadataCase_ == 26;
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for image object detection.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ImageObjectDetectionDatasetMetadata image_object_detection_dataset_metadata = 26;
     * </code>
     *
     * @return The imageObjectDetectionDatasetMetadata.
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.ImageObjectDetectionDatasetMetadata
        getImageObjectDetectionDatasetMetadata() {
      if (imageObjectDetectionDatasetMetadataBuilder_ == null) {
        if (datasetMetadataCase_ == 26) {
          return (com.google.cloud.automl.v1beta1.ImageObjectDetectionDatasetMetadata)
              datasetMetadata_;
        }
        return com.google.cloud.automl.v1beta1.ImageObjectDetectionDatasetMetadata
            .getDefaultInstance();
      } else {
        if (datasetMetadataCase_ == 26) {
          return imageObjectDetectionDatasetMetadataBuilder_.getMessage();
        }
        return com.google.cloud.automl.v1beta1.ImageObjectDetectionDatasetMetadata
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for image object detection.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ImageObjectDetectionDatasetMetadata image_object_detection_dataset_metadata = 26;
     * </code>
     */
    public Builder setImageObjectDetectionDatasetMetadata(
        com.google.cloud.automl.v1beta1.ImageObjectDetectionDatasetMetadata value) {
      if (imageObjectDetectionDatasetMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        datasetMetadata_ = value;
        onChanged();
      } else {
        imageObjectDetectionDatasetMetadataBuilder_.setMessage(value);
      }
      datasetMetadataCase_ = 26;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for image object detection.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ImageObjectDetectionDatasetMetadata image_object_detection_dataset_metadata = 26;
     * </code>
     */
    public Builder setImageObjectDetectionDatasetMetadata(
        com.google.cloud.automl.v1beta1.ImageObjectDetectionDatasetMetadata.Builder
            builderForValue) {
      if (imageObjectDetectionDatasetMetadataBuilder_ == null) {
        datasetMetadata_ = builderForValue.build();
        onChanged();
      } else {
        imageObjectDetectionDatasetMetadataBuilder_.setMessage(builderForValue.build());
      }
      datasetMetadataCase_ = 26;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for image object detection.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ImageObjectDetectionDatasetMetadata image_object_detection_dataset_metadata = 26;
     * </code>
     */
    public Builder mergeImageObjectDetectionDatasetMetadata(
        com.google.cloud.automl.v1beta1.ImageObjectDetectionDatasetMetadata value) {
      if (imageObjectDetectionDatasetMetadataBuilder_ == null) {
        if (datasetMetadataCase_ == 26
            && datasetMetadata_
                != com.google.cloud.automl.v1beta1.ImageObjectDetectionDatasetMetadata
                    .getDefaultInstance()) {
          datasetMetadata_ =
              com.google.cloud.automl.v1beta1.ImageObjectDetectionDatasetMetadata.newBuilder(
                      (com.google.cloud.automl.v1beta1.ImageObjectDetectionDatasetMetadata)
                          datasetMetadata_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          datasetMetadata_ = value;
        }
        onChanged();
      } else {
        if (datasetMetadataCase_ == 26) {
          imageObjectDetectionDatasetMetadataBuilder_.mergeFrom(value);
        } else {
          imageObjectDetectionDatasetMetadataBuilder_.setMessage(value);
        }
      }
      datasetMetadataCase_ = 26;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for image object detection.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ImageObjectDetectionDatasetMetadata image_object_detection_dataset_metadata = 26;
     * </code>
     */
    public Builder clearImageObjectDetectionDatasetMetadata() {
      if (imageObjectDetectionDatasetMetadataBuilder_ == null) {
        if (datasetMetadataCase_ == 26) {
          datasetMetadataCase_ = 0;
          datasetMetadata_ = null;
          onChanged();
        }
      } else {
        if (datasetMetadataCase_ == 26) {
          datasetMetadataCase_ = 0;
          datasetMetadata_ = null;
        }
        imageObjectDetectionDatasetMetadataBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for image object detection.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ImageObjectDetectionDatasetMetadata image_object_detection_dataset_metadata = 26;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.ImageObjectDetectionDatasetMetadata.Builder
        getImageObjectDetectionDatasetMetadataBuilder() {
      return getImageObjectDetectionDatasetMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for image object detection.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ImageObjectDetectionDatasetMetadata image_object_detection_dataset_metadata = 26;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.ImageObjectDetectionDatasetMetadataOrBuilder
        getImageObjectDetectionDatasetMetadataOrBuilder() {
      if ((datasetMetadataCase_ == 26) && (imageObjectDetectionDatasetMetadataBuilder_ != null)) {
        return imageObjectDetectionDatasetMetadataBuilder_.getMessageOrBuilder();
      } else {
        if (datasetMetadataCase_ == 26) {
          return (com.google.cloud.automl.v1beta1.ImageObjectDetectionDatasetMetadata)
              datasetMetadata_;
        }
        return com.google.cloud.automl.v1beta1.ImageObjectDetectionDatasetMetadata
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for image object detection.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ImageObjectDetectionDatasetMetadata image_object_detection_dataset_metadata = 26;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.ImageObjectDetectionDatasetMetadata,
            com.google.cloud.automl.v1beta1.ImageObjectDetectionDatasetMetadata.Builder,
            com.google.cloud.automl.v1beta1.ImageObjectDetectionDatasetMetadataOrBuilder>
        getImageObjectDetectionDatasetMetadataFieldBuilder() {
      if (imageObjectDetectionDatasetMetadataBuilder_ == null) {
        if (!(datasetMetadataCase_ == 26)) {
          datasetMetadata_ =
              com.google.cloud.automl.v1beta1.ImageObjectDetectionDatasetMetadata
                  .getDefaultInstance();
        }
        imageObjectDetectionDatasetMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.automl.v1beta1.ImageObjectDetectionDatasetMetadata,
                com.google.cloud.automl.v1beta1.ImageObjectDetectionDatasetMetadata.Builder,
                com.google.cloud.automl.v1beta1.ImageObjectDetectionDatasetMetadataOrBuilder>(
                (com.google.cloud.automl.v1beta1.ImageObjectDetectionDatasetMetadata)
                    datasetMetadata_,
                getParentForChildren(),
                isClean());
        datasetMetadata_ = null;
      }
      datasetMetadataCase_ = 26;
      onChanged();
      ;
      return imageObjectDetectionDatasetMetadataBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.VideoClassificationDatasetMetadata,
            com.google.cloud.automl.v1beta1.VideoClassificationDatasetMetadata.Builder,
            com.google.cloud.automl.v1beta1.VideoClassificationDatasetMetadataOrBuilder>
        videoClassificationDatasetMetadataBuilder_;
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for video classification.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.VideoClassificationDatasetMetadata video_classification_dataset_metadata = 31;
     * </code>
     *
     * @return Whether the videoClassificationDatasetMetadata field is set.
     */
    @java.lang.Override
    public boolean hasVideoClassificationDatasetMetadata() {
      return datasetMetadataCase_ == 31;
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for video classification.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.VideoClassificationDatasetMetadata video_classification_dataset_metadata = 31;
     * </code>
     *
     * @return The videoClassificationDatasetMetadata.
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.VideoClassificationDatasetMetadata
        getVideoClassificationDatasetMetadata() {
      if (videoClassificationDatasetMetadataBuilder_ == null) {
        if (datasetMetadataCase_ == 31) {
          return (com.google.cloud.automl.v1beta1.VideoClassificationDatasetMetadata)
              datasetMetadata_;
        }
        return com.google.cloud.automl.v1beta1.VideoClassificationDatasetMetadata
            .getDefaultInstance();
      } else {
        if (datasetMetadataCase_ == 31) {
          return videoClassificationDatasetMetadataBuilder_.getMessage();
        }
        return com.google.cloud.automl.v1beta1.VideoClassificationDatasetMetadata
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for video classification.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.VideoClassificationDatasetMetadata video_classification_dataset_metadata = 31;
     * </code>
     */
    public Builder setVideoClassificationDatasetMetadata(
        com.google.cloud.automl.v1beta1.VideoClassificationDatasetMetadata value) {
      if (videoClassificationDatasetMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        datasetMetadata_ = value;
        onChanged();
      } else {
        videoClassificationDatasetMetadataBuilder_.setMessage(value);
      }
      datasetMetadataCase_ = 31;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for video classification.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.VideoClassificationDatasetMetadata video_classification_dataset_metadata = 31;
     * </code>
     */
    public Builder setVideoClassificationDatasetMetadata(
        com.google.cloud.automl.v1beta1.VideoClassificationDatasetMetadata.Builder
            builderForValue) {
      if (videoClassificationDatasetMetadataBuilder_ == null) {
        datasetMetadata_ = builderForValue.build();
        onChanged();
      } else {
        videoClassificationDatasetMetadataBuilder_.setMessage(builderForValue.build());
      }
      datasetMetadataCase_ = 31;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for video classification.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.VideoClassificationDatasetMetadata video_classification_dataset_metadata = 31;
     * </code>
     */
    public Builder mergeVideoClassificationDatasetMetadata(
        com.google.cloud.automl.v1beta1.VideoClassificationDatasetMetadata value) {
      if (videoClassificationDatasetMetadataBuilder_ == null) {
        if (datasetMetadataCase_ == 31
            && datasetMetadata_
                != com.google.cloud.automl.v1beta1.VideoClassificationDatasetMetadata
                    .getDefaultInstance()) {
          datasetMetadata_ =
              com.google.cloud.automl.v1beta1.VideoClassificationDatasetMetadata.newBuilder(
                      (com.google.cloud.automl.v1beta1.VideoClassificationDatasetMetadata)
                          datasetMetadata_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          datasetMetadata_ = value;
        }
        onChanged();
      } else {
        if (datasetMetadataCase_ == 31) {
          videoClassificationDatasetMetadataBuilder_.mergeFrom(value);
        } else {
          videoClassificationDatasetMetadataBuilder_.setMessage(value);
        }
      }
      datasetMetadataCase_ = 31;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for video classification.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.VideoClassificationDatasetMetadata video_classification_dataset_metadata = 31;
     * </code>
     */
    public Builder clearVideoClassificationDatasetMetadata() {
      if (videoClassificationDatasetMetadataBuilder_ == null) {
        if (datasetMetadataCase_ == 31) {
          datasetMetadataCase_ = 0;
          datasetMetadata_ = null;
          onChanged();
        }
      } else {
        if (datasetMetadataCase_ == 31) {
          datasetMetadataCase_ = 0;
          datasetMetadata_ = null;
        }
        videoClassificationDatasetMetadataBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for video classification.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.VideoClassificationDatasetMetadata video_classification_dataset_metadata = 31;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.VideoClassificationDatasetMetadata.Builder
        getVideoClassificationDatasetMetadataBuilder() {
      return getVideoClassificationDatasetMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for video classification.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.VideoClassificationDatasetMetadata video_classification_dataset_metadata = 31;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.VideoClassificationDatasetMetadataOrBuilder
        getVideoClassificationDatasetMetadataOrBuilder() {
      if ((datasetMetadataCase_ == 31) && (videoClassificationDatasetMetadataBuilder_ != null)) {
        return videoClassificationDatasetMetadataBuilder_.getMessageOrBuilder();
      } else {
        if (datasetMetadataCase_ == 31) {
          return (com.google.cloud.automl.v1beta1.VideoClassificationDatasetMetadata)
              datasetMetadata_;
        }
        return com.google.cloud.automl.v1beta1.VideoClassificationDatasetMetadata
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for video classification.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.VideoClassificationDatasetMetadata video_classification_dataset_metadata = 31;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.VideoClassificationDatasetMetadata,
            com.google.cloud.automl.v1beta1.VideoClassificationDatasetMetadata.Builder,
            com.google.cloud.automl.v1beta1.VideoClassificationDatasetMetadataOrBuilder>
        getVideoClassificationDatasetMetadataFieldBuilder() {
      if (videoClassificationDatasetMetadataBuilder_ == null) {
        if (!(datasetMetadataCase_ == 31)) {
          datasetMetadata_ =
              com.google.cloud.automl.v1beta1.VideoClassificationDatasetMetadata
                  .getDefaultInstance();
        }
        videoClassificationDatasetMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.automl.v1beta1.VideoClassificationDatasetMetadata,
                com.google.cloud.automl.v1beta1.VideoClassificationDatasetMetadata.Builder,
                com.google.cloud.automl.v1beta1.VideoClassificationDatasetMetadataOrBuilder>(
                (com.google.cloud.automl.v1beta1.VideoClassificationDatasetMetadata)
                    datasetMetadata_,
                getParentForChildren(),
                isClean());
        datasetMetadata_ = null;
      }
      datasetMetadataCase_ = 31;
      onChanged();
      ;
      return videoClassificationDatasetMetadataBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.VideoObjectTrackingDatasetMetadata,
            com.google.cloud.automl.v1beta1.VideoObjectTrackingDatasetMetadata.Builder,
            com.google.cloud.automl.v1beta1.VideoObjectTrackingDatasetMetadataOrBuilder>
        videoObjectTrackingDatasetMetadataBuilder_;
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for video object tracking.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.VideoObjectTrackingDatasetMetadata video_object_tracking_dataset_metadata = 29;
     * </code>
     *
     * @return Whether the videoObjectTrackingDatasetMetadata field is set.
     */
    @java.lang.Override
    public boolean hasVideoObjectTrackingDatasetMetadata() {
      return datasetMetadataCase_ == 29;
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for video object tracking.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.VideoObjectTrackingDatasetMetadata video_object_tracking_dataset_metadata = 29;
     * </code>
     *
     * @return The videoObjectTrackingDatasetMetadata.
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.VideoObjectTrackingDatasetMetadata
        getVideoObjectTrackingDatasetMetadata() {
      if (videoObjectTrackingDatasetMetadataBuilder_ == null) {
        if (datasetMetadataCase_ == 29) {
          return (com.google.cloud.automl.v1beta1.VideoObjectTrackingDatasetMetadata)
              datasetMetadata_;
        }
        return com.google.cloud.automl.v1beta1.VideoObjectTrackingDatasetMetadata
            .getDefaultInstance();
      } else {
        if (datasetMetadataCase_ == 29) {
          return videoObjectTrackingDatasetMetadataBuilder_.getMessage();
        }
        return com.google.cloud.automl.v1beta1.VideoObjectTrackingDatasetMetadata
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for video object tracking.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.VideoObjectTrackingDatasetMetadata video_object_tracking_dataset_metadata = 29;
     * </code>
     */
    public Builder setVideoObjectTrackingDatasetMetadata(
        com.google.cloud.automl.v1beta1.VideoObjectTrackingDatasetMetadata value) {
      if (videoObjectTrackingDatasetMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        datasetMetadata_ = value;
        onChanged();
      } else {
        videoObjectTrackingDatasetMetadataBuilder_.setMessage(value);
      }
      datasetMetadataCase_ = 29;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for video object tracking.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.VideoObjectTrackingDatasetMetadata video_object_tracking_dataset_metadata = 29;
     * </code>
     */
    public Builder setVideoObjectTrackingDatasetMetadata(
        com.google.cloud.automl.v1beta1.VideoObjectTrackingDatasetMetadata.Builder
            builderForValue) {
      if (videoObjectTrackingDatasetMetadataBuilder_ == null) {
        datasetMetadata_ = builderForValue.build();
        onChanged();
      } else {
        videoObjectTrackingDatasetMetadataBuilder_.setMessage(builderForValue.build());
      }
      datasetMetadataCase_ = 29;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for video object tracking.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.VideoObjectTrackingDatasetMetadata video_object_tracking_dataset_metadata = 29;
     * </code>
     */
    public Builder mergeVideoObjectTrackingDatasetMetadata(
        com.google.cloud.automl.v1beta1.VideoObjectTrackingDatasetMetadata value) {
      if (videoObjectTrackingDatasetMetadataBuilder_ == null) {
        if (datasetMetadataCase_ == 29
            && datasetMetadata_
                != com.google.cloud.automl.v1beta1.VideoObjectTrackingDatasetMetadata
                    .getDefaultInstance()) {
          datasetMetadata_ =
              com.google.cloud.automl.v1beta1.VideoObjectTrackingDatasetMetadata.newBuilder(
                      (com.google.cloud.automl.v1beta1.VideoObjectTrackingDatasetMetadata)
                          datasetMetadata_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          datasetMetadata_ = value;
        }
        onChanged();
      } else {
        if (datasetMetadataCase_ == 29) {
          videoObjectTrackingDatasetMetadataBuilder_.mergeFrom(value);
        } else {
          videoObjectTrackingDatasetMetadataBuilder_.setMessage(value);
        }
      }
      datasetMetadataCase_ = 29;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for video object tracking.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.VideoObjectTrackingDatasetMetadata video_object_tracking_dataset_metadata = 29;
     * </code>
     */
    public Builder clearVideoObjectTrackingDatasetMetadata() {
      if (videoObjectTrackingDatasetMetadataBuilder_ == null) {
        if (datasetMetadataCase_ == 29) {
          datasetMetadataCase_ = 0;
          datasetMetadata_ = null;
          onChanged();
        }
      } else {
        if (datasetMetadataCase_ == 29) {
          datasetMetadataCase_ = 0;
          datasetMetadata_ = null;
        }
        videoObjectTrackingDatasetMetadataBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for video object tracking.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.VideoObjectTrackingDatasetMetadata video_object_tracking_dataset_metadata = 29;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.VideoObjectTrackingDatasetMetadata.Builder
        getVideoObjectTrackingDatasetMetadataBuilder() {
      return getVideoObjectTrackingDatasetMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for video object tracking.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.VideoObjectTrackingDatasetMetadata video_object_tracking_dataset_metadata = 29;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.VideoObjectTrackingDatasetMetadataOrBuilder
        getVideoObjectTrackingDatasetMetadataOrBuilder() {
      if ((datasetMetadataCase_ == 29) && (videoObjectTrackingDatasetMetadataBuilder_ != null)) {
        return videoObjectTrackingDatasetMetadataBuilder_.getMessageOrBuilder();
      } else {
        if (datasetMetadataCase_ == 29) {
          return (com.google.cloud.automl.v1beta1.VideoObjectTrackingDatasetMetadata)
              datasetMetadata_;
        }
        return com.google.cloud.automl.v1beta1.VideoObjectTrackingDatasetMetadata
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for video object tracking.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.VideoObjectTrackingDatasetMetadata video_object_tracking_dataset_metadata = 29;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.VideoObjectTrackingDatasetMetadata,
            com.google.cloud.automl.v1beta1.VideoObjectTrackingDatasetMetadata.Builder,
            com.google.cloud.automl.v1beta1.VideoObjectTrackingDatasetMetadataOrBuilder>
        getVideoObjectTrackingDatasetMetadataFieldBuilder() {
      if (videoObjectTrackingDatasetMetadataBuilder_ == null) {
        if (!(datasetMetadataCase_ == 29)) {
          datasetMetadata_ =
              com.google.cloud.automl.v1beta1.VideoObjectTrackingDatasetMetadata
                  .getDefaultInstance();
        }
        videoObjectTrackingDatasetMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.automl.v1beta1.VideoObjectTrackingDatasetMetadata,
                com.google.cloud.automl.v1beta1.VideoObjectTrackingDatasetMetadata.Builder,
                com.google.cloud.automl.v1beta1.VideoObjectTrackingDatasetMetadataOrBuilder>(
                (com.google.cloud.automl.v1beta1.VideoObjectTrackingDatasetMetadata)
                    datasetMetadata_,
                getParentForChildren(),
                isClean());
        datasetMetadata_ = null;
      }
      datasetMetadataCase_ = 29;
      onChanged();
      ;
      return videoObjectTrackingDatasetMetadataBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.TextExtractionDatasetMetadata,
            com.google.cloud.automl.v1beta1.TextExtractionDatasetMetadata.Builder,
            com.google.cloud.automl.v1beta1.TextExtractionDatasetMetadataOrBuilder>
        textExtractionDatasetMetadataBuilder_;
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for text extraction.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextExtractionDatasetMetadata text_extraction_dataset_metadata = 28;
     * </code>
     *
     * @return Whether the textExtractionDatasetMetadata field is set.
     */
    @java.lang.Override
    public boolean hasTextExtractionDatasetMetadata() {
      return datasetMetadataCase_ == 28;
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for text extraction.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextExtractionDatasetMetadata text_extraction_dataset_metadata = 28;
     * </code>
     *
     * @return The textExtractionDatasetMetadata.
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.TextExtractionDatasetMetadata
        getTextExtractionDatasetMetadata() {
      if (textExtractionDatasetMetadataBuilder_ == null) {
        if (datasetMetadataCase_ == 28) {
          return (com.google.cloud.automl.v1beta1.TextExtractionDatasetMetadata) datasetMetadata_;
        }
        return com.google.cloud.automl.v1beta1.TextExtractionDatasetMetadata.getDefaultInstance();
      } else {
        if (datasetMetadataCase_ == 28) {
          return textExtractionDatasetMetadataBuilder_.getMessage();
        }
        return com.google.cloud.automl.v1beta1.TextExtractionDatasetMetadata.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for text extraction.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextExtractionDatasetMetadata text_extraction_dataset_metadata = 28;
     * </code>
     */
    public Builder setTextExtractionDatasetMetadata(
        com.google.cloud.automl.v1beta1.TextExtractionDatasetMetadata value) {
      if (textExtractionDatasetMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        datasetMetadata_ = value;
        onChanged();
      } else {
        textExtractionDatasetMetadataBuilder_.setMessage(value);
      }
      datasetMetadataCase_ = 28;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for text extraction.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextExtractionDatasetMetadata text_extraction_dataset_metadata = 28;
     * </code>
     */
    public Builder setTextExtractionDatasetMetadata(
        com.google.cloud.automl.v1beta1.TextExtractionDatasetMetadata.Builder builderForValue) {
      if (textExtractionDatasetMetadataBuilder_ == null) {
        datasetMetadata_ = builderForValue.build();
        onChanged();
      } else {
        textExtractionDatasetMetadataBuilder_.setMessage(builderForValue.build());
      }
      datasetMetadataCase_ = 28;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for text extraction.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextExtractionDatasetMetadata text_extraction_dataset_metadata = 28;
     * </code>
     */
    public Builder mergeTextExtractionDatasetMetadata(
        com.google.cloud.automl.v1beta1.TextExtractionDatasetMetadata value) {
      if (textExtractionDatasetMetadataBuilder_ == null) {
        if (datasetMetadataCase_ == 28
            && datasetMetadata_
                != com.google.cloud.automl.v1beta1.TextExtractionDatasetMetadata
                    .getDefaultInstance()) {
          datasetMetadata_ =
              com.google.cloud.automl.v1beta1.TextExtractionDatasetMetadata.newBuilder(
                      (com.google.cloud.automl.v1beta1.TextExtractionDatasetMetadata)
                          datasetMetadata_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          datasetMetadata_ = value;
        }
        onChanged();
      } else {
        if (datasetMetadataCase_ == 28) {
          textExtractionDatasetMetadataBuilder_.mergeFrom(value);
        } else {
          textExtractionDatasetMetadataBuilder_.setMessage(value);
        }
      }
      datasetMetadataCase_ = 28;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for text extraction.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextExtractionDatasetMetadata text_extraction_dataset_metadata = 28;
     * </code>
     */
    public Builder clearTextExtractionDatasetMetadata() {
      if (textExtractionDatasetMetadataBuilder_ == null) {
        if (datasetMetadataCase_ == 28) {
          datasetMetadataCase_ = 0;
          datasetMetadata_ = null;
          onChanged();
        }
      } else {
        if (datasetMetadataCase_ == 28) {
          datasetMetadataCase_ = 0;
          datasetMetadata_ = null;
        }
        textExtractionDatasetMetadataBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for text extraction.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextExtractionDatasetMetadata text_extraction_dataset_metadata = 28;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.TextExtractionDatasetMetadata.Builder
        getTextExtractionDatasetMetadataBuilder() {
      return getTextExtractionDatasetMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for text extraction.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextExtractionDatasetMetadata text_extraction_dataset_metadata = 28;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.TextExtractionDatasetMetadataOrBuilder
        getTextExtractionDatasetMetadataOrBuilder() {
      if ((datasetMetadataCase_ == 28) && (textExtractionDatasetMetadataBuilder_ != null)) {
        return textExtractionDatasetMetadataBuilder_.getMessageOrBuilder();
      } else {
        if (datasetMetadataCase_ == 28) {
          return (com.google.cloud.automl.v1beta1.TextExtractionDatasetMetadata) datasetMetadata_;
        }
        return com.google.cloud.automl.v1beta1.TextExtractionDatasetMetadata.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for text extraction.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextExtractionDatasetMetadata text_extraction_dataset_metadata = 28;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.TextExtractionDatasetMetadata,
            com.google.cloud.automl.v1beta1.TextExtractionDatasetMetadata.Builder,
            com.google.cloud.automl.v1beta1.TextExtractionDatasetMetadataOrBuilder>
        getTextExtractionDatasetMetadataFieldBuilder() {
      if (textExtractionDatasetMetadataBuilder_ == null) {
        if (!(datasetMetadataCase_ == 28)) {
          datasetMetadata_ =
              com.google.cloud.automl.v1beta1.TextExtractionDatasetMetadata.getDefaultInstance();
        }
        textExtractionDatasetMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.automl.v1beta1.TextExtractionDatasetMetadata,
                com.google.cloud.automl.v1beta1.TextExtractionDatasetMetadata.Builder,
                com.google.cloud.automl.v1beta1.TextExtractionDatasetMetadataOrBuilder>(
                (com.google.cloud.automl.v1beta1.TextExtractionDatasetMetadata) datasetMetadata_,
                getParentForChildren(),
                isClean());
        datasetMetadata_ = null;
      }
      datasetMetadataCase_ = 28;
      onChanged();
      ;
      return textExtractionDatasetMetadataBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.TextSentimentDatasetMetadata,
            com.google.cloud.automl.v1beta1.TextSentimentDatasetMetadata.Builder,
            com.google.cloud.automl.v1beta1.TextSentimentDatasetMetadataOrBuilder>
        textSentimentDatasetMetadataBuilder_;
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for text sentiment.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextSentimentDatasetMetadata text_sentiment_dataset_metadata = 30;
     * </code>
     *
     * @return Whether the textSentimentDatasetMetadata field is set.
     */
    @java.lang.Override
    public boolean hasTextSentimentDatasetMetadata() {
      return datasetMetadataCase_ == 30;
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for text sentiment.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextSentimentDatasetMetadata text_sentiment_dataset_metadata = 30;
     * </code>
     *
     * @return The textSentimentDatasetMetadata.
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.TextSentimentDatasetMetadata
        getTextSentimentDatasetMetadata() {
      if (textSentimentDatasetMetadataBuilder_ == null) {
        if (datasetMetadataCase_ == 30) {
          return (com.google.cloud.automl.v1beta1.TextSentimentDatasetMetadata) datasetMetadata_;
        }
        return com.google.cloud.automl.v1beta1.TextSentimentDatasetMetadata.getDefaultInstance();
      } else {
        if (datasetMetadataCase_ == 30) {
          return textSentimentDatasetMetadataBuilder_.getMessage();
        }
        return com.google.cloud.automl.v1beta1.TextSentimentDatasetMetadata.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for text sentiment.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextSentimentDatasetMetadata text_sentiment_dataset_metadata = 30;
     * </code>
     */
    public Builder setTextSentimentDatasetMetadata(
        com.google.cloud.automl.v1beta1.TextSentimentDatasetMetadata value) {
      if (textSentimentDatasetMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        datasetMetadata_ = value;
        onChanged();
      } else {
        textSentimentDatasetMetadataBuilder_.setMessage(value);
      }
      datasetMetadataCase_ = 30;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for text sentiment.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextSentimentDatasetMetadata text_sentiment_dataset_metadata = 30;
     * </code>
     */
    public Builder setTextSentimentDatasetMetadata(
        com.google.cloud.automl.v1beta1.TextSentimentDatasetMetadata.Builder builderForValue) {
      if (textSentimentDatasetMetadataBuilder_ == null) {
        datasetMetadata_ = builderForValue.build();
        onChanged();
      } else {
        textSentimentDatasetMetadataBuilder_.setMessage(builderForValue.build());
      }
      datasetMetadataCase_ = 30;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for text sentiment.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextSentimentDatasetMetadata text_sentiment_dataset_metadata = 30;
     * </code>
     */
    public Builder mergeTextSentimentDatasetMetadata(
        com.google.cloud.automl.v1beta1.TextSentimentDatasetMetadata value) {
      if (textSentimentDatasetMetadataBuilder_ == null) {
        if (datasetMetadataCase_ == 30
            && datasetMetadata_
                != com.google.cloud.automl.v1beta1.TextSentimentDatasetMetadata
                    .getDefaultInstance()) {
          datasetMetadata_ =
              com.google.cloud.automl.v1beta1.TextSentimentDatasetMetadata.newBuilder(
                      (com.google.cloud.automl.v1beta1.TextSentimentDatasetMetadata)
                          datasetMetadata_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          datasetMetadata_ = value;
        }
        onChanged();
      } else {
        if (datasetMetadataCase_ == 30) {
          textSentimentDatasetMetadataBuilder_.mergeFrom(value);
        } else {
          textSentimentDatasetMetadataBuilder_.setMessage(value);
        }
      }
      datasetMetadataCase_ = 30;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for text sentiment.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextSentimentDatasetMetadata text_sentiment_dataset_metadata = 30;
     * </code>
     */
    public Builder clearTextSentimentDatasetMetadata() {
      if (textSentimentDatasetMetadataBuilder_ == null) {
        if (datasetMetadataCase_ == 30) {
          datasetMetadataCase_ = 0;
          datasetMetadata_ = null;
          onChanged();
        }
      } else {
        if (datasetMetadataCase_ == 30) {
          datasetMetadataCase_ = 0;
          datasetMetadata_ = null;
        }
        textSentimentDatasetMetadataBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for text sentiment.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextSentimentDatasetMetadata text_sentiment_dataset_metadata = 30;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.TextSentimentDatasetMetadata.Builder
        getTextSentimentDatasetMetadataBuilder() {
      return getTextSentimentDatasetMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for text sentiment.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextSentimentDatasetMetadata text_sentiment_dataset_metadata = 30;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.TextSentimentDatasetMetadataOrBuilder
        getTextSentimentDatasetMetadataOrBuilder() {
      if ((datasetMetadataCase_ == 30) && (textSentimentDatasetMetadataBuilder_ != null)) {
        return textSentimentDatasetMetadataBuilder_.getMessageOrBuilder();
      } else {
        if (datasetMetadataCase_ == 30) {
          return (com.google.cloud.automl.v1beta1.TextSentimentDatasetMetadata) datasetMetadata_;
        }
        return com.google.cloud.automl.v1beta1.TextSentimentDatasetMetadata.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for text sentiment.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextSentimentDatasetMetadata text_sentiment_dataset_metadata = 30;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.TextSentimentDatasetMetadata,
            com.google.cloud.automl.v1beta1.TextSentimentDatasetMetadata.Builder,
            com.google.cloud.automl.v1beta1.TextSentimentDatasetMetadataOrBuilder>
        getTextSentimentDatasetMetadataFieldBuilder() {
      if (textSentimentDatasetMetadataBuilder_ == null) {
        if (!(datasetMetadataCase_ == 30)) {
          datasetMetadata_ =
              com.google.cloud.automl.v1beta1.TextSentimentDatasetMetadata.getDefaultInstance();
        }
        textSentimentDatasetMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.automl.v1beta1.TextSentimentDatasetMetadata,
                com.google.cloud.automl.v1beta1.TextSentimentDatasetMetadata.Builder,
                com.google.cloud.automl.v1beta1.TextSentimentDatasetMetadataOrBuilder>(
                (com.google.cloud.automl.v1beta1.TextSentimentDatasetMetadata) datasetMetadata_,
                getParentForChildren(),
                isClean());
        datasetMetadata_ = null;
      }
      datasetMetadataCase_ = 30;
      onChanged();
      ;
      return textSentimentDatasetMetadataBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.TablesDatasetMetadata,
            com.google.cloud.automl.v1beta1.TablesDatasetMetadata.Builder,
            com.google.cloud.automl.v1beta1.TablesDatasetMetadataOrBuilder>
        tablesDatasetMetadataBuilder_;
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for Tables.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.TablesDatasetMetadata tables_dataset_metadata = 33;</code>
     *
     * @return Whether the tablesDatasetMetadata field is set.
     */
    @java.lang.Override
    public boolean hasTablesDatasetMetadata() {
      return datasetMetadataCase_ == 33;
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for Tables.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.TablesDatasetMetadata tables_dataset_metadata = 33;</code>
     *
     * @return The tablesDatasetMetadata.
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.TablesDatasetMetadata getTablesDatasetMetadata() {
      if (tablesDatasetMetadataBuilder_ == null) {
        if (datasetMetadataCase_ == 33) {
          return (com.google.cloud.automl.v1beta1.TablesDatasetMetadata) datasetMetadata_;
        }
        return com.google.cloud.automl.v1beta1.TablesDatasetMetadata.getDefaultInstance();
      } else {
        if (datasetMetadataCase_ == 33) {
          return tablesDatasetMetadataBuilder_.getMessage();
        }
        return com.google.cloud.automl.v1beta1.TablesDatasetMetadata.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for Tables.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.TablesDatasetMetadata tables_dataset_metadata = 33;</code>
     */
    public Builder setTablesDatasetMetadata(
        com.google.cloud.automl.v1beta1.TablesDatasetMetadata value) {
      if (tablesDatasetMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        datasetMetadata_ = value;
        onChanged();
      } else {
        tablesDatasetMetadataBuilder_.setMessage(value);
      }
      datasetMetadataCase_ = 33;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for Tables.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.TablesDatasetMetadata tables_dataset_metadata = 33;</code>
     */
    public Builder setTablesDatasetMetadata(
        com.google.cloud.automl.v1beta1.TablesDatasetMetadata.Builder builderForValue) {
      if (tablesDatasetMetadataBuilder_ == null) {
        datasetMetadata_ = builderForValue.build();
        onChanged();
      } else {
        tablesDatasetMetadataBuilder_.setMessage(builderForValue.build());
      }
      datasetMetadataCase_ = 33;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for Tables.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.TablesDatasetMetadata tables_dataset_metadata = 33;</code>
     */
    public Builder mergeTablesDatasetMetadata(
        com.google.cloud.automl.v1beta1.TablesDatasetMetadata value) {
      if (tablesDatasetMetadataBuilder_ == null) {
        if (datasetMetadataCase_ == 33
            && datasetMetadata_
                != com.google.cloud.automl.v1beta1.TablesDatasetMetadata.getDefaultInstance()) {
          datasetMetadata_ =
              com.google.cloud.automl.v1beta1.TablesDatasetMetadata.newBuilder(
                      (com.google.cloud.automl.v1beta1.TablesDatasetMetadata) datasetMetadata_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          datasetMetadata_ = value;
        }
        onChanged();
      } else {
        if (datasetMetadataCase_ == 33) {
          tablesDatasetMetadataBuilder_.mergeFrom(value);
        } else {
          tablesDatasetMetadataBuilder_.setMessage(value);
        }
      }
      datasetMetadataCase_ = 33;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for Tables.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.TablesDatasetMetadata tables_dataset_metadata = 33;</code>
     */
    public Builder clearTablesDatasetMetadata() {
      if (tablesDatasetMetadataBuilder_ == null) {
        if (datasetMetadataCase_ == 33) {
          datasetMetadataCase_ = 0;
          datasetMetadata_ = null;
          onChanged();
        }
      } else {
        if (datasetMetadataCase_ == 33) {
          datasetMetadataCase_ = 0;
          datasetMetadata_ = null;
        }
        tablesDatasetMetadataBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for Tables.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.TablesDatasetMetadata tables_dataset_metadata = 33;</code>
     */
    public com.google.cloud.automl.v1beta1.TablesDatasetMetadata.Builder
        getTablesDatasetMetadataBuilder() {
      return getTablesDatasetMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for Tables.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.TablesDatasetMetadata tables_dataset_metadata = 33;</code>
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.TablesDatasetMetadataOrBuilder
        getTablesDatasetMetadataOrBuilder() {
      if ((datasetMetadataCase_ == 33) && (tablesDatasetMetadataBuilder_ != null)) {
        return tablesDatasetMetadataBuilder_.getMessageOrBuilder();
      } else {
        if (datasetMetadataCase_ == 33) {
          return (com.google.cloud.automl.v1beta1.TablesDatasetMetadata) datasetMetadata_;
        }
        return com.google.cloud.automl.v1beta1.TablesDatasetMetadata.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata for a dataset used for Tables.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.TablesDatasetMetadata tables_dataset_metadata = 33;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.TablesDatasetMetadata,
            com.google.cloud.automl.v1beta1.TablesDatasetMetadata.Builder,
            com.google.cloud.automl.v1beta1.TablesDatasetMetadataOrBuilder>
        getTablesDatasetMetadataFieldBuilder() {
      if (tablesDatasetMetadataBuilder_ == null) {
        if (!(datasetMetadataCase_ == 33)) {
          datasetMetadata_ =
              com.google.cloud.automl.v1beta1.TablesDatasetMetadata.getDefaultInstance();
        }
        tablesDatasetMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.automl.v1beta1.TablesDatasetMetadata,
                com.google.cloud.automl.v1beta1.TablesDatasetMetadata.Builder,
                com.google.cloud.automl.v1beta1.TablesDatasetMetadataOrBuilder>(
                (com.google.cloud.automl.v1beta1.TablesDatasetMetadata) datasetMetadata_,
                getParentForChildren(),
                isClean());
        datasetMetadata_ = null;
      }
      datasetMetadataCase_ = 33;
      onChanged();
      ;
      return tablesDatasetMetadataBuilder_;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the dataset.
     * Form: `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the dataset.
     * Form: `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the dataset.
     * Form: `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the dataset.
     * Form: `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the dataset.
     * Form: `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the dataset to show in the interface. The name can be
     * up to 32 characters long and can consist only of ASCII Latin letters A-Z
     * and a-z, underscores
     * (_), and ASCII digits 0-9.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the dataset to show in the interface. The name can be
     * up to 32 characters long and can consist only of ASCII Latin letters A-Z
     * and a-z, underscores
     * (_), and ASCII digits 0-9.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the dataset to show in the interface. The name can be
     * up to 32 characters long and can consist only of ASCII Latin letters A-Z
     * and a-z, underscores
     * (_), and ASCII digits 0-9.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      displayName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the dataset to show in the interface. The name can be
     * up to 32 characters long and can consist only of ASCII Latin letters A-Z
     * and a-z, underscores
     * (_), and ASCII digits 0-9.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {

      displayName_ = getDefaultInstance().getDisplayName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the dataset to show in the interface. The name can be
     * up to 32 characters long and can consist only of ASCII Latin letters A-Z
     * and a-z, underscores
     * (_), and ASCII digits 0-9.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      displayName_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * User-provided description of the dataset. The description can be up to
     * 25000 characters long.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * User-provided description of the dataset. The description can be up to
     * 25000 characters long.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * User-provided description of the dataset. The description can be up to
     * 25000 characters long.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      description_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-provided description of the dataset. The description can be up to
     * 25000 characters long.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {

      description_ = getDefaultInstance().getDescription();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-provided description of the dataset. The description can be up to
     * 25000 characters long.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      description_ = value;
      onChanged();
      return this;
    }

    private int exampleCount_;
    /**
     *
     *
     * <pre>
     * Output only. The number of examples in the dataset.
     * </pre>
     *
     * <code>int32 example_count = 21;</code>
     *
     * @return The exampleCount.
     */
    @java.lang.Override
    public int getExampleCount() {
      return exampleCount_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The number of examples in the dataset.
     * </pre>
     *
     * <code>int32 example_count = 21;</code>
     *
     * @param value The exampleCount to set.
     * @return This builder for chaining.
     */
    public Builder setExampleCount(int value) {

      exampleCount_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The number of examples in the dataset.
     * </pre>
     *
     * <code>int32 example_count = 21;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExampleCount() {

      exampleCount_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this dataset was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 14;</code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return createTimeBuilder_ != null || createTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this dataset was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 14;</code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this dataset was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 14;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
        onChanged();
      } else {
        createTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this dataset was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 14;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
        onChanged();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this dataset was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 14;</code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (createTime_ != null) {
          createTime_ =
              com.google.protobuf.Timestamp.newBuilder(createTime_).mergeFrom(value).buildPartial();
        } else {
          createTime_ = value;
        }
        onChanged();
      } else {
        createTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this dataset was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 14;</code>
     */
    public Builder clearCreateTime() {
      if (createTimeBuilder_ == null) {
        createTime_ = null;
        onChanged();
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this dataset was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 14;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {

      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this dataset was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 14;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this dataset was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 14;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private java.lang.Object etag_ = "";
    /**
     *
     *
     * <pre>
     * Used to perform consistent read-modify-write updates. If not set, a blind
     * "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 17;</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Used to perform consistent read-modify-write updates. If not set, a blind
     * "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 17;</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Used to perform consistent read-modify-write updates. If not set, a blind
     * "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 17;</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      etag_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Used to perform consistent read-modify-write updates. If not set, a blind
     * "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 17;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {

      etag_ = getDefaultInstance().getEtag();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Used to perform consistent read-modify-write updates. If not set, a blind
     * "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 17;</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      etag_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.automl.v1beta1.Dataset)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.automl.v1beta1.Dataset)
  private static final com.google.cloud.automl.v1beta1.Dataset DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.automl.v1beta1.Dataset();
  }

  public static com.google.cloud.automl.v1beta1.Dataset getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Dataset> PARSER =
      new com.google.protobuf.AbstractParser<Dataset>() {
        @java.lang.Override
        public Dataset parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new Dataset(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<Dataset> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Dataset> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.automl.v1beta1.Dataset getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
