/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.backupdr.v1;

import com.google.cloud.backupdr.v1.BackupvaultDiskProto;
import com.google.cloud.backupdr.v1.DiskBackupPropertiesOrBuilder;
import com.google.cloud.backupdr.v1.GuestOsFeature;
import com.google.cloud.backupdr.v1.GuestOsFeatureOrBuilder;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LazyStringArrayList;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class DiskBackupProperties
extends GeneratedMessageV3
implements DiskBackupPropertiesOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int DESCRIPTION_FIELD_NUMBER = 1;
    private volatile Object description_ = "";
    public static final int LICENSES_FIELD_NUMBER = 2;
    private LazyStringArrayList licenses_ = LazyStringArrayList.emptyList();
    public static final int GUEST_OS_FEATURE_FIELD_NUMBER = 3;
    private List<GuestOsFeature> guestOsFeature_;
    public static final int ARCHITECTURE_FIELD_NUMBER = 4;
    private int architecture_ = 0;
    public static final int TYPE_FIELD_NUMBER = 5;
    private volatile Object type_ = "";
    public static final int SIZE_GB_FIELD_NUMBER = 6;
    private long sizeGb_ = 0L;
    public static final int REGION_FIELD_NUMBER = 7;
    private volatile Object region_ = "";
    public static final int ZONE_FIELD_NUMBER = 8;
    private volatile Object zone_ = "";
    public static final int REPLICA_ZONES_FIELD_NUMBER = 9;
    private LazyStringArrayList replicaZones_ = LazyStringArrayList.emptyList();
    public static final int SOURCE_DISK_FIELD_NUMBER = 10;
    private volatile Object sourceDisk_ = "";
    private byte memoizedIsInitialized = (byte)-1;
    private static final DiskBackupProperties DEFAULT_INSTANCE = new DiskBackupProperties();
    private static final Parser<DiskBackupProperties> PARSER = new AbstractParser<DiskBackupProperties>(){

        public DiskBackupProperties parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = DiskBackupProperties.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private DiskBackupProperties(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private DiskBackupProperties() {
        this.description_ = "";
        this.licenses_ = LazyStringArrayList.emptyList();
        this.guestOsFeature_ = Collections.emptyList();
        this.architecture_ = 0;
        this.type_ = "";
        this.region_ = "";
        this.zone_ = "";
        this.replicaZones_ = LazyStringArrayList.emptyList();
        this.sourceDisk_ = "";
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new DiskBackupProperties();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return BackupvaultDiskProto.internal_static_google_cloud_backupdr_v1_DiskBackupProperties_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return BackupvaultDiskProto.internal_static_google_cloud_backupdr_v1_DiskBackupProperties_fieldAccessorTable.ensureFieldAccessorsInitialized(DiskBackupProperties.class, Builder.class);
    }

    @Override
    public boolean hasDescription() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public String getDescription() {
        Object ref = this.description_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.description_ = s;
        return s;
    }

    @Override
    public ByteString getDescriptionBytes() {
        Object ref = this.description_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.description_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    public ProtocolStringList getLicensesList() {
        return this.licenses_;
    }

    @Override
    public int getLicensesCount() {
        return this.licenses_.size();
    }

    @Override
    public String getLicenses(int index) {
        return this.licenses_.get(index);
    }

    @Override
    public ByteString getLicensesBytes(int index) {
        return this.licenses_.getByteString(index);
    }

    @Override
    public List<GuestOsFeature> getGuestOsFeatureList() {
        return this.guestOsFeature_;
    }

    @Override
    public List<? extends GuestOsFeatureOrBuilder> getGuestOsFeatureOrBuilderList() {
        return this.guestOsFeature_;
    }

    @Override
    public int getGuestOsFeatureCount() {
        return this.guestOsFeature_.size();
    }

    @Override
    public GuestOsFeature getGuestOsFeature(int index) {
        return this.guestOsFeature_.get(index);
    }

    @Override
    public GuestOsFeatureOrBuilder getGuestOsFeatureOrBuilder(int index) {
        return this.guestOsFeature_.get(index);
    }

    @Override
    public boolean hasArchitecture() {
        return (this.bitField0_ & 2) != 0;
    }

    @Override
    public int getArchitectureValue() {
        return this.architecture_;
    }

    @Override
    public Architecture getArchitecture() {
        Architecture result = Architecture.forNumber(this.architecture_);
        return result == null ? Architecture.UNRECOGNIZED : result;
    }

    @Override
    public boolean hasType() {
        return (this.bitField0_ & 4) != 0;
    }

    @Override
    public String getType() {
        Object ref = this.type_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.type_ = s;
        return s;
    }

    @Override
    public ByteString getTypeBytes() {
        Object ref = this.type_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.type_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasSizeGb() {
        return (this.bitField0_ & 8) != 0;
    }

    @Override
    public long getSizeGb() {
        return this.sizeGb_;
    }

    @Override
    public boolean hasRegion() {
        return (this.bitField0_ & 0x10) != 0;
    }

    @Override
    public String getRegion() {
        Object ref = this.region_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.region_ = s;
        return s;
    }

    @Override
    public ByteString getRegionBytes() {
        Object ref = this.region_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.region_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasZone() {
        return (this.bitField0_ & 0x20) != 0;
    }

    @Override
    public String getZone() {
        Object ref = this.zone_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.zone_ = s;
        return s;
    }

    @Override
    public ByteString getZoneBytes() {
        Object ref = this.zone_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.zone_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    public ProtocolStringList getReplicaZonesList() {
        return this.replicaZones_;
    }

    @Override
    public int getReplicaZonesCount() {
        return this.replicaZones_.size();
    }

    @Override
    public String getReplicaZones(int index) {
        return this.replicaZones_.get(index);
    }

    @Override
    public ByteString getReplicaZonesBytes(int index) {
        return this.replicaZones_.getByteString(index);
    }

    @Override
    public boolean hasSourceDisk() {
        return (this.bitField0_ & 0x40) != 0;
    }

    @Override
    public String getSourceDisk() {
        Object ref = this.sourceDisk_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.sourceDisk_ = s;
        return s;
    }

    @Override
    public ByteString getSourceDiskBytes() {
        Object ref = this.sourceDisk_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.sourceDisk_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        if ((this.bitField0_ & 1) != 0) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.description_);
        }
        for (i = 0; i < this.licenses_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)2, (Object)this.licenses_.getRaw(i));
        }
        for (i = 0; i < this.guestOsFeature_.size(); ++i) {
            output.writeMessage(3, (MessageLite)this.guestOsFeature_.get(i));
        }
        if ((this.bitField0_ & 2) != 0) {
            output.writeEnum(4, this.architecture_);
        }
        if ((this.bitField0_ & 4) != 0) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)5, (Object)this.type_);
        }
        if ((this.bitField0_ & 8) != 0) {
            output.writeInt64(6, this.sizeGb_);
        }
        if ((this.bitField0_ & 0x10) != 0) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)7, (Object)this.region_);
        }
        if ((this.bitField0_ & 0x20) != 0) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)8, (Object)this.zone_);
        }
        for (i = 0; i < this.replicaZones_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)9, (Object)this.replicaZones_.getRaw(i));
        }
        if ((this.bitField0_ & 0x40) != 0) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)10, (Object)this.sourceDisk_);
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if ((this.bitField0_ & 1) != 0) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.description_);
        }
        int dataSize = 0;
        for (i = 0; i < this.licenses_.size(); ++i) {
            dataSize += DiskBackupProperties.computeStringSizeNoTag((Object)this.licenses_.getRaw(i));
        }
        size += dataSize;
        size += 1 * this.getLicensesList().size();
        for (int i2 = 0; i2 < this.guestOsFeature_.size(); ++i2) {
            size += CodedOutputStream.computeMessageSize((int)3, (MessageLite)((MessageLite)this.guestOsFeature_.get(i2)));
        }
        if ((this.bitField0_ & 2) != 0) {
            size += CodedOutputStream.computeEnumSize((int)4, (int)this.architecture_);
        }
        if ((this.bitField0_ & 4) != 0) {
            size += GeneratedMessageV3.computeStringSize((int)5, (Object)this.type_);
        }
        if ((this.bitField0_ & 8) != 0) {
            size += CodedOutputStream.computeInt64Size((int)6, (long)this.sizeGb_);
        }
        if ((this.bitField0_ & 0x10) != 0) {
            size += GeneratedMessageV3.computeStringSize((int)7, (Object)this.region_);
        }
        if ((this.bitField0_ & 0x20) != 0) {
            size += GeneratedMessageV3.computeStringSize((int)8, (Object)this.zone_);
        }
        dataSize = 0;
        for (i = 0; i < this.replicaZones_.size(); ++i) {
            dataSize += DiskBackupProperties.computeStringSizeNoTag((Object)this.replicaZones_.getRaw(i));
        }
        size += dataSize;
        size += 1 * this.getReplicaZonesList().size();
        if ((this.bitField0_ & 0x40) != 0) {
            size += GeneratedMessageV3.computeStringSize((int)10, (Object)this.sourceDisk_);
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DiskBackupProperties)) {
            return super.equals(obj);
        }
        DiskBackupProperties other = (DiskBackupProperties)obj;
        if (this.hasDescription() != other.hasDescription()) {
            return false;
        }
        if (this.hasDescription() && !this.getDescription().equals(other.getDescription())) {
            return false;
        }
        if (!this.getLicensesList().equals(other.getLicensesList())) {
            return false;
        }
        if (!this.getGuestOsFeatureList().equals(other.getGuestOsFeatureList())) {
            return false;
        }
        if (this.hasArchitecture() != other.hasArchitecture()) {
            return false;
        }
        if (this.hasArchitecture() && this.architecture_ != other.architecture_) {
            return false;
        }
        if (this.hasType() != other.hasType()) {
            return false;
        }
        if (this.hasType() && !this.getType().equals(other.getType())) {
            return false;
        }
        if (this.hasSizeGb() != other.hasSizeGb()) {
            return false;
        }
        if (this.hasSizeGb() && this.getSizeGb() != other.getSizeGb()) {
            return false;
        }
        if (this.hasRegion() != other.hasRegion()) {
            return false;
        }
        if (this.hasRegion() && !this.getRegion().equals(other.getRegion())) {
            return false;
        }
        if (this.hasZone() != other.hasZone()) {
            return false;
        }
        if (this.hasZone() && !this.getZone().equals(other.getZone())) {
            return false;
        }
        if (!this.getReplicaZonesList().equals(other.getReplicaZonesList())) {
            return false;
        }
        if (this.hasSourceDisk() != other.hasSourceDisk()) {
            return false;
        }
        if (this.hasSourceDisk() && !this.getSourceDisk().equals(other.getSourceDisk())) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + DiskBackupProperties.getDescriptor().hashCode();
        if (this.hasDescription()) {
            hash = 37 * hash + 1;
            hash = 53 * hash + this.getDescription().hashCode();
        }
        if (this.getLicensesCount() > 0) {
            hash = 37 * hash + 2;
            hash = 53 * hash + this.getLicensesList().hashCode();
        }
        if (this.getGuestOsFeatureCount() > 0) {
            hash = 37 * hash + 3;
            hash = 53 * hash + this.getGuestOsFeatureList().hashCode();
        }
        if (this.hasArchitecture()) {
            hash = 37 * hash + 4;
            hash = 53 * hash + this.architecture_;
        }
        if (this.hasType()) {
            hash = 37 * hash + 5;
            hash = 53 * hash + this.getType().hashCode();
        }
        if (this.hasSizeGb()) {
            hash = 37 * hash + 6;
            hash = 53 * hash + Internal.hashLong((long)this.getSizeGb());
        }
        if (this.hasRegion()) {
            hash = 37 * hash + 7;
            hash = 53 * hash + this.getRegion().hashCode();
        }
        if (this.hasZone()) {
            hash = 37 * hash + 8;
            hash = 53 * hash + this.getZone().hashCode();
        }
        if (this.getReplicaZonesCount() > 0) {
            hash = 37 * hash + 9;
            hash = 53 * hash + this.getReplicaZonesList().hashCode();
        }
        if (this.hasSourceDisk()) {
            hash = 37 * hash + 10;
            hash = 53 * hash + this.getSourceDisk().hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static DiskBackupProperties parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (DiskBackupProperties)PARSER.parseFrom(data);
    }

    public static DiskBackupProperties parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (DiskBackupProperties)PARSER.parseFrom(data, extensionRegistry);
    }

    public static DiskBackupProperties parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (DiskBackupProperties)PARSER.parseFrom(data);
    }

    public static DiskBackupProperties parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (DiskBackupProperties)PARSER.parseFrom(data, extensionRegistry);
    }

    public static DiskBackupProperties parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (DiskBackupProperties)PARSER.parseFrom(data);
    }

    public static DiskBackupProperties parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (DiskBackupProperties)PARSER.parseFrom(data, extensionRegistry);
    }

    public static DiskBackupProperties parseFrom(InputStream input) throws IOException {
        return (DiskBackupProperties)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static DiskBackupProperties parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (DiskBackupProperties)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static DiskBackupProperties parseDelimitedFrom(InputStream input) throws IOException {
        return (DiskBackupProperties)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static DiskBackupProperties parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (DiskBackupProperties)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static DiskBackupProperties parseFrom(CodedInputStream input) throws IOException {
        return (DiskBackupProperties)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static DiskBackupProperties parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (DiskBackupProperties)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return DiskBackupProperties.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(DiskBackupProperties prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static DiskBackupProperties getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<DiskBackupProperties> parser() {
        return PARSER;
    }

    public Parser<DiskBackupProperties> getParserForType() {
        return PARSER;
    }

    public DiskBackupProperties getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements DiskBackupPropertiesOrBuilder {
        private int bitField0_;
        private Object description_ = "";
        private LazyStringArrayList licenses_ = LazyStringArrayList.emptyList();
        private List<GuestOsFeature> guestOsFeature_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<GuestOsFeature, GuestOsFeature.Builder, GuestOsFeatureOrBuilder> guestOsFeatureBuilder_;
        private int architecture_ = 0;
        private Object type_ = "";
        private long sizeGb_;
        private Object region_ = "";
        private Object zone_ = "";
        private LazyStringArrayList replicaZones_ = LazyStringArrayList.emptyList();
        private Object sourceDisk_ = "";

        public static final Descriptors.Descriptor getDescriptor() {
            return BackupvaultDiskProto.internal_static_google_cloud_backupdr_v1_DiskBackupProperties_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return BackupvaultDiskProto.internal_static_google_cloud_backupdr_v1_DiskBackupProperties_fieldAccessorTable.ensureFieldAccessorsInitialized(DiskBackupProperties.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.description_ = "";
            this.licenses_ = LazyStringArrayList.emptyList();
            if (this.guestOsFeatureBuilder_ == null) {
                this.guestOsFeature_ = Collections.emptyList();
            } else {
                this.guestOsFeature_ = null;
                this.guestOsFeatureBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFFB;
            this.architecture_ = 0;
            this.type_ = "";
            this.sizeGb_ = 0L;
            this.region_ = "";
            this.zone_ = "";
            this.replicaZones_ = LazyStringArrayList.emptyList();
            this.sourceDisk_ = "";
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return BackupvaultDiskProto.internal_static_google_cloud_backupdr_v1_DiskBackupProperties_descriptor;
        }

        public DiskBackupProperties getDefaultInstanceForType() {
            return DiskBackupProperties.getDefaultInstance();
        }

        public DiskBackupProperties build() {
            DiskBackupProperties result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public DiskBackupProperties buildPartial() {
            DiskBackupProperties result = new DiskBackupProperties(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(DiskBackupProperties result) {
            if (this.guestOsFeatureBuilder_ == null) {
                if ((this.bitField0_ & 4) != 0) {
                    this.guestOsFeature_ = Collections.unmodifiableList(this.guestOsFeature_);
                    this.bitField0_ &= 0xFFFFFFFB;
                }
                result.guestOsFeature_ = this.guestOsFeature_;
            } else {
                result.guestOsFeature_ = this.guestOsFeatureBuilder_.build();
            }
        }

        private void buildPartial0(DiskBackupProperties result) {
            int from_bitField0_ = this.bitField0_;
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 1) != 0) {
                result.description_ = this.description_;
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 2) != 0) {
                this.licenses_.makeImmutable();
                result.licenses_ = this.licenses_;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.architecture_ = this.architecture_;
                to_bitField0_ |= 2;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.type_ = this.type_;
                to_bitField0_ |= 4;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.sizeGb_ = this.sizeGb_;
                to_bitField0_ |= 8;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.region_ = this.region_;
                to_bitField0_ |= 0x10;
            }
            if ((from_bitField0_ & 0x80) != 0) {
                result.zone_ = this.zone_;
                to_bitField0_ |= 0x20;
            }
            if ((from_bitField0_ & 0x100) != 0) {
                this.replicaZones_.makeImmutable();
                result.replicaZones_ = this.replicaZones_;
            }
            if ((from_bitField0_ & 0x200) != 0) {
                result.sourceDisk_ = this.sourceDisk_;
                to_bitField0_ |= 0x40;
            }
            DiskBackupProperties diskBackupProperties = result;
            diskBackupProperties.bitField0_ = diskBackupProperties.bitField0_ | to_bitField0_;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof DiskBackupProperties) {
                return this.mergeFrom((DiskBackupProperties)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(DiskBackupProperties other) {
            if (other == DiskBackupProperties.getDefaultInstance()) {
                return this;
            }
            if (other.hasDescription()) {
                this.description_ = other.description_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (!other.licenses_.isEmpty()) {
                if (this.licenses_.isEmpty()) {
                    this.licenses_ = other.licenses_;
                    this.bitField0_ |= 2;
                } else {
                    this.ensureLicensesIsMutable();
                    this.licenses_.addAll((Collection)other.licenses_);
                }
                this.onChanged();
            }
            if (this.guestOsFeatureBuilder_ == null) {
                if (!other.guestOsFeature_.isEmpty()) {
                    if (this.guestOsFeature_.isEmpty()) {
                        this.guestOsFeature_ = other.guestOsFeature_;
                        this.bitField0_ &= 0xFFFFFFFB;
                    } else {
                        this.ensureGuestOsFeatureIsMutable();
                        this.guestOsFeature_.addAll(other.guestOsFeature_);
                    }
                    this.onChanged();
                }
            } else if (!other.guestOsFeature_.isEmpty()) {
                if (this.guestOsFeatureBuilder_.isEmpty()) {
                    this.guestOsFeatureBuilder_.dispose();
                    this.guestOsFeatureBuilder_ = null;
                    this.guestOsFeature_ = other.guestOsFeature_;
                    this.bitField0_ &= 0xFFFFFFFB;
                    this.guestOsFeatureBuilder_ = alwaysUseFieldBuilders ? this.getGuestOsFeatureFieldBuilder() : null;
                } else {
                    this.guestOsFeatureBuilder_.addAllMessages((Iterable)other.guestOsFeature_);
                }
            }
            if (other.hasArchitecture()) {
                this.setArchitecture(other.getArchitecture());
            }
            if (other.hasType()) {
                this.type_ = other.type_;
                this.bitField0_ |= 0x10;
                this.onChanged();
            }
            if (other.hasSizeGb()) {
                this.setSizeGb(other.getSizeGb());
            }
            if (other.hasRegion()) {
                this.region_ = other.region_;
                this.bitField0_ |= 0x40;
                this.onChanged();
            }
            if (other.hasZone()) {
                this.zone_ = other.zone_;
                this.bitField0_ |= 0x80;
                this.onChanged();
            }
            if (!other.replicaZones_.isEmpty()) {
                if (this.replicaZones_.isEmpty()) {
                    this.replicaZones_ = other.replicaZones_;
                    this.bitField0_ |= 0x100;
                } else {
                    this.ensureReplicaZonesIsMutable();
                    this.replicaZones_.addAll((Collection)other.replicaZones_);
                }
                this.onChanged();
            }
            if (other.hasSourceDisk()) {
                this.sourceDisk_ = other.sourceDisk_;
                this.bitField0_ |= 0x200;
                this.onChanged();
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block18: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block18;
                        }
                        case 10: {
                            this.description_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block18;
                        }
                        case 18: {
                            String s = input.readStringRequireUtf8();
                            this.ensureLicensesIsMutable();
                            this.licenses_.add((Object)s);
                            continue block18;
                        }
                        case 26: {
                            GuestOsFeature m = (GuestOsFeature)input.readMessage(GuestOsFeature.parser(), extensionRegistry);
                            if (this.guestOsFeatureBuilder_ == null) {
                                this.ensureGuestOsFeatureIsMutable();
                                this.guestOsFeature_.add(m);
                                continue block18;
                            }
                            this.guestOsFeatureBuilder_.addMessage((AbstractMessage)m);
                            continue block18;
                        }
                        case 32: {
                            this.architecture_ = input.readEnum();
                            this.bitField0_ |= 8;
                            continue block18;
                        }
                        case 42: {
                            this.type_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x10;
                            continue block18;
                        }
                        case 48: {
                            this.sizeGb_ = input.readInt64();
                            this.bitField0_ |= 0x20;
                            continue block18;
                        }
                        case 58: {
                            this.region_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x40;
                            continue block18;
                        }
                        case 66: {
                            this.zone_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x80;
                            continue block18;
                        }
                        case 74: {
                            String s = input.readStringRequireUtf8();
                            this.ensureReplicaZonesIsMutable();
                            this.replicaZones_.add((Object)s);
                            continue block18;
                        }
                        case 82: {
                            this.sourceDisk_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x200;
                            continue block18;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public boolean hasDescription() {
            return (this.bitField0_ & 1) != 0;
        }

        @Override
        public String getDescription() {
            Object ref = this.description_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.description_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getDescriptionBytes() {
            Object ref = this.description_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.description_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setDescription(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.description_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearDescription() {
            this.description_ = DiskBackupProperties.getDefaultInstance().getDescription();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setDescriptionBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            DiskBackupProperties.checkByteStringIsUtf8((ByteString)value);
            this.description_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        private void ensureLicensesIsMutable() {
            if (!this.licenses_.isModifiable()) {
                this.licenses_ = new LazyStringArrayList((LazyStringList)this.licenses_);
            }
            this.bitField0_ |= 2;
        }

        public ProtocolStringList getLicensesList() {
            this.licenses_.makeImmutable();
            return this.licenses_;
        }

        @Override
        public int getLicensesCount() {
            return this.licenses_.size();
        }

        @Override
        public String getLicenses(int index) {
            return this.licenses_.get(index);
        }

        @Override
        public ByteString getLicensesBytes(int index) {
            return this.licenses_.getByteString(index);
        }

        public Builder setLicenses(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureLicensesIsMutable();
            this.licenses_.set(index, value);
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder addLicenses(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureLicensesIsMutable();
            this.licenses_.add((Object)value);
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder addAllLicenses(Iterable<String> values) {
            this.ensureLicensesIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.licenses_);
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearLicenses() {
            this.licenses_ = LazyStringArrayList.emptyList();
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        public Builder addLicensesBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            DiskBackupProperties.checkByteStringIsUtf8((ByteString)value);
            this.ensureLicensesIsMutable();
            this.licenses_.add(value);
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        private void ensureGuestOsFeatureIsMutable() {
            if ((this.bitField0_ & 4) == 0) {
                this.guestOsFeature_ = new ArrayList<GuestOsFeature>(this.guestOsFeature_);
                this.bitField0_ |= 4;
            }
        }

        @Override
        public List<GuestOsFeature> getGuestOsFeatureList() {
            if (this.guestOsFeatureBuilder_ == null) {
                return Collections.unmodifiableList(this.guestOsFeature_);
            }
            return this.guestOsFeatureBuilder_.getMessageList();
        }

        @Override
        public int getGuestOsFeatureCount() {
            if (this.guestOsFeatureBuilder_ == null) {
                return this.guestOsFeature_.size();
            }
            return this.guestOsFeatureBuilder_.getCount();
        }

        @Override
        public GuestOsFeature getGuestOsFeature(int index) {
            if (this.guestOsFeatureBuilder_ == null) {
                return this.guestOsFeature_.get(index);
            }
            return (GuestOsFeature)this.guestOsFeatureBuilder_.getMessage(index);
        }

        public Builder setGuestOsFeature(int index, GuestOsFeature value) {
            if (this.guestOsFeatureBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureGuestOsFeatureIsMutable();
                this.guestOsFeature_.set(index, value);
                this.onChanged();
            } else {
                this.guestOsFeatureBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setGuestOsFeature(int index, GuestOsFeature.Builder builderForValue) {
            if (this.guestOsFeatureBuilder_ == null) {
                this.ensureGuestOsFeatureIsMutable();
                this.guestOsFeature_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.guestOsFeatureBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addGuestOsFeature(GuestOsFeature value) {
            if (this.guestOsFeatureBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureGuestOsFeatureIsMutable();
                this.guestOsFeature_.add(value);
                this.onChanged();
            } else {
                this.guestOsFeatureBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addGuestOsFeature(int index, GuestOsFeature value) {
            if (this.guestOsFeatureBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureGuestOsFeatureIsMutable();
                this.guestOsFeature_.add(index, value);
                this.onChanged();
            } else {
                this.guestOsFeatureBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addGuestOsFeature(GuestOsFeature.Builder builderForValue) {
            if (this.guestOsFeatureBuilder_ == null) {
                this.ensureGuestOsFeatureIsMutable();
                this.guestOsFeature_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.guestOsFeatureBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addGuestOsFeature(int index, GuestOsFeature.Builder builderForValue) {
            if (this.guestOsFeatureBuilder_ == null) {
                this.ensureGuestOsFeatureIsMutable();
                this.guestOsFeature_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.guestOsFeatureBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllGuestOsFeature(Iterable<? extends GuestOsFeature> values) {
            if (this.guestOsFeatureBuilder_ == null) {
                this.ensureGuestOsFeatureIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.guestOsFeature_);
                this.onChanged();
            } else {
                this.guestOsFeatureBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearGuestOsFeature() {
            if (this.guestOsFeatureBuilder_ == null) {
                this.guestOsFeature_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFB;
                this.onChanged();
            } else {
                this.guestOsFeatureBuilder_.clear();
            }
            return this;
        }

        public Builder removeGuestOsFeature(int index) {
            if (this.guestOsFeatureBuilder_ == null) {
                this.ensureGuestOsFeatureIsMutable();
                this.guestOsFeature_.remove(index);
                this.onChanged();
            } else {
                this.guestOsFeatureBuilder_.remove(index);
            }
            return this;
        }

        public GuestOsFeature.Builder getGuestOsFeatureBuilder(int index) {
            return (GuestOsFeature.Builder)this.getGuestOsFeatureFieldBuilder().getBuilder(index);
        }

        @Override
        public GuestOsFeatureOrBuilder getGuestOsFeatureOrBuilder(int index) {
            if (this.guestOsFeatureBuilder_ == null) {
                return this.guestOsFeature_.get(index);
            }
            return (GuestOsFeatureOrBuilder)this.guestOsFeatureBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends GuestOsFeatureOrBuilder> getGuestOsFeatureOrBuilderList() {
            if (this.guestOsFeatureBuilder_ != null) {
                return this.guestOsFeatureBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.guestOsFeature_);
        }

        public GuestOsFeature.Builder addGuestOsFeatureBuilder() {
            return (GuestOsFeature.Builder)this.getGuestOsFeatureFieldBuilder().addBuilder((AbstractMessage)GuestOsFeature.getDefaultInstance());
        }

        public GuestOsFeature.Builder addGuestOsFeatureBuilder(int index) {
            return (GuestOsFeature.Builder)this.getGuestOsFeatureFieldBuilder().addBuilder(index, (AbstractMessage)GuestOsFeature.getDefaultInstance());
        }

        public List<GuestOsFeature.Builder> getGuestOsFeatureBuilderList() {
            return this.getGuestOsFeatureFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<GuestOsFeature, GuestOsFeature.Builder, GuestOsFeatureOrBuilder> getGuestOsFeatureFieldBuilder() {
            if (this.guestOsFeatureBuilder_ == null) {
                this.guestOsFeatureBuilder_ = new RepeatedFieldBuilderV3(this.guestOsFeature_, (this.bitField0_ & 4) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.guestOsFeature_ = null;
            }
            return this.guestOsFeatureBuilder_;
        }

        @Override
        public boolean hasArchitecture() {
            return (this.bitField0_ & 8) != 0;
        }

        @Override
        public int getArchitectureValue() {
            return this.architecture_;
        }

        public Builder setArchitectureValue(int value) {
            this.architecture_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        @Override
        public Architecture getArchitecture() {
            Architecture result = Architecture.forNumber(this.architecture_);
            return result == null ? Architecture.UNRECOGNIZED : result;
        }

        public Builder setArchitecture(Architecture value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 8;
            this.architecture_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearArchitecture() {
            this.bitField0_ &= 0xFFFFFFF7;
            this.architecture_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasType() {
            return (this.bitField0_ & 0x10) != 0;
        }

        @Override
        public String getType() {
            Object ref = this.type_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.type_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getTypeBytes() {
            Object ref = this.type_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.type_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setType(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.type_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder clearType() {
            this.type_ = DiskBackupProperties.getDefaultInstance().getType();
            this.bitField0_ &= 0xFFFFFFEF;
            this.onChanged();
            return this;
        }

        public Builder setTypeBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            DiskBackupProperties.checkByteStringIsUtf8((ByteString)value);
            this.type_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasSizeGb() {
            return (this.bitField0_ & 0x20) != 0;
        }

        @Override
        public long getSizeGb() {
            return this.sizeGb_;
        }

        public Builder setSizeGb(long value) {
            this.sizeGb_ = value;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder clearSizeGb() {
            this.bitField0_ &= 0xFFFFFFDF;
            this.sizeGb_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasRegion() {
            return (this.bitField0_ & 0x40) != 0;
        }

        @Override
        public String getRegion() {
            Object ref = this.region_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.region_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getRegionBytes() {
            Object ref = this.region_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.region_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setRegion(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.region_ = value;
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder clearRegion() {
            this.region_ = DiskBackupProperties.getDefaultInstance().getRegion();
            this.bitField0_ &= 0xFFFFFFBF;
            this.onChanged();
            return this;
        }

        public Builder setRegionBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            DiskBackupProperties.checkByteStringIsUtf8((ByteString)value);
            this.region_ = value;
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasZone() {
            return (this.bitField0_ & 0x80) != 0;
        }

        @Override
        public String getZone() {
            Object ref = this.zone_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.zone_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getZoneBytes() {
            Object ref = this.zone_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.zone_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setZone(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.zone_ = value;
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder clearZone() {
            this.zone_ = DiskBackupProperties.getDefaultInstance().getZone();
            this.bitField0_ &= 0xFFFFFF7F;
            this.onChanged();
            return this;
        }

        public Builder setZoneBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            DiskBackupProperties.checkByteStringIsUtf8((ByteString)value);
            this.zone_ = value;
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        private void ensureReplicaZonesIsMutable() {
            if (!this.replicaZones_.isModifiable()) {
                this.replicaZones_ = new LazyStringArrayList((LazyStringList)this.replicaZones_);
            }
            this.bitField0_ |= 0x100;
        }

        public ProtocolStringList getReplicaZonesList() {
            this.replicaZones_.makeImmutable();
            return this.replicaZones_;
        }

        @Override
        public int getReplicaZonesCount() {
            return this.replicaZones_.size();
        }

        @Override
        public String getReplicaZones(int index) {
            return this.replicaZones_.get(index);
        }

        @Override
        public ByteString getReplicaZonesBytes(int index) {
            return this.replicaZones_.getByteString(index);
        }

        public Builder setReplicaZones(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureReplicaZonesIsMutable();
            this.replicaZones_.set(index, value);
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder addReplicaZones(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureReplicaZonesIsMutable();
            this.replicaZones_.add((Object)value);
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder addAllReplicaZones(Iterable<String> values) {
            this.ensureReplicaZonesIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.replicaZones_);
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder clearReplicaZones() {
            this.replicaZones_ = LazyStringArrayList.emptyList();
            this.bitField0_ &= 0xFFFFFEFF;
            this.onChanged();
            return this;
        }

        public Builder addReplicaZonesBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            DiskBackupProperties.checkByteStringIsUtf8((ByteString)value);
            this.ensureReplicaZonesIsMutable();
            this.replicaZones_.add(value);
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasSourceDisk() {
            return (this.bitField0_ & 0x200) != 0;
        }

        @Override
        public String getSourceDisk() {
            Object ref = this.sourceDisk_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.sourceDisk_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getSourceDiskBytes() {
            Object ref = this.sourceDisk_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.sourceDisk_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setSourceDisk(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.sourceDisk_ = value;
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        public Builder clearSourceDisk() {
            this.sourceDisk_ = DiskBackupProperties.getDefaultInstance().getSourceDisk();
            this.bitField0_ &= 0xFFFFFDFF;
            this.onChanged();
            return this;
        }

        public Builder setSourceDiskBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            DiskBackupProperties.checkByteStringIsUtf8((ByteString)value);
            this.sourceDisk_ = value;
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    public static enum Architecture implements ProtocolMessageEnum
    {
        ARCHITECTURE_UNSPECIFIED(0),
        X86_64(1),
        ARM64(2),
        UNRECOGNIZED(-1);

        public static final int ARCHITECTURE_UNSPECIFIED_VALUE = 0;
        public static final int X86_64_VALUE = 1;
        public static final int ARM64_VALUE = 2;
        private static final Internal.EnumLiteMap<Architecture> internalValueMap;
        private static final Architecture[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static Architecture valueOf(int value) {
            return Architecture.forNumber(value);
        }

        public static Architecture forNumber(int value) {
            switch (value) {
                case 0: {
                    return ARCHITECTURE_UNSPECIFIED;
                }
                case 1: {
                    return X86_64;
                }
                case 2: {
                    return ARM64;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<Architecture> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)Architecture.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return Architecture.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)DiskBackupProperties.getDescriptor().getEnumTypes().get(0);
        }

        public static Architecture valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != Architecture.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private Architecture(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<Architecture>(){

                public Architecture findValueByNumber(int number) {
                    return Architecture.forNumber(number);
                }
            };
            VALUES = Architecture.values();
        }
    }
}

