/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.backupdr.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BackupPlanRevisionName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_BACKUP_PLAN_REVISION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/backupPlans/{backup_plan}/revisions/{revision}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String backupPlan;
    private final String revision;

    @Deprecated
    protected BackupPlanRevisionName() {
        this.project = null;
        this.location = null;
        this.backupPlan = null;
        this.revision = null;
    }

    private BackupPlanRevisionName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.backupPlan = (String)Preconditions.checkNotNull((Object)builder.getBackupPlan());
        this.revision = (String)Preconditions.checkNotNull((Object)builder.getRevision());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getBackupPlan() {
        return this.backupPlan;
    }

    public String getRevision() {
        return this.revision;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static BackupPlanRevisionName of(String project, String location, String backupPlan, String revision) {
        return BackupPlanRevisionName.newBuilder().setProject(project).setLocation(location).setBackupPlan(backupPlan).setRevision(revision).build();
    }

    public static String format(String project, String location, String backupPlan, String revision) {
        return BackupPlanRevisionName.newBuilder().setProject(project).setLocation(location).setBackupPlan(backupPlan).setRevision(revision).build().toString();
    }

    public static BackupPlanRevisionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_BACKUP_PLAN_REVISION.validatedMatch(formattedString, "BackupPlanRevisionName.parse: formattedString not in valid format");
        return BackupPlanRevisionName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("backup_plan"), (String)matchMap.get("revision"));
    }

    public static List<BackupPlanRevisionName> parseList(List<String> formattedStrings) {
        ArrayList<BackupPlanRevisionName> list = new ArrayList<BackupPlanRevisionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(BackupPlanRevisionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<BackupPlanRevisionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (BackupPlanRevisionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_BACKUP_PLAN_REVISION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            BackupPlanRevisionName backupPlanRevisionName = this;
            synchronized (backupPlanRevisionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.backupPlan != null) {
                        fieldMapBuilder.put((Object)"backup_plan", (Object)this.backupPlan);
                    }
                    if (this.revision != null) {
                        fieldMapBuilder.put((Object)"revision", (Object)this.revision);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_BACKUP_PLAN_REVISION.instantiate(new String[]{"project", this.project, "location", this.location, "backup_plan", this.backupPlan, "revision", this.revision});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            BackupPlanRevisionName that = (BackupPlanRevisionName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.backupPlan, that.backupPlan) && Objects.equals(this.revision, that.revision);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.backupPlan);
        h *= 1000003;
        return h ^= Objects.hashCode(this.revision);
    }

    public static class Builder {
        private String project;
        private String location;
        private String backupPlan;
        private String revision;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getBackupPlan() {
            return this.backupPlan;
        }

        public String getRevision() {
            return this.revision;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setBackupPlan(String backupPlan) {
            this.backupPlan = backupPlan;
            return this;
        }

        public Builder setRevision(String revision) {
            this.revision = revision;
            return this;
        }

        private Builder(BackupPlanRevisionName backupPlanRevisionName) {
            this.project = backupPlanRevisionName.project;
            this.location = backupPlanRevisionName.location;
            this.backupPlan = backupPlanRevisionName.backupPlan;
            this.revision = backupPlanRevisionName.revision;
        }

        public BackupPlanRevisionName build() {
            return new BackupPlanRevisionName(this);
        }
    }
}

