/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.backupdr.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DataSourceReferenceName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_DATA_SOURCE_REFERENCE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/dataSourceReferences/{data_source_reference}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String dataSourceReference;

    @Deprecated
    protected DataSourceReferenceName() {
        this.project = null;
        this.location = null;
        this.dataSourceReference = null;
    }

    private DataSourceReferenceName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.dataSourceReference = (String)Preconditions.checkNotNull((Object)builder.getDataSourceReference());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDataSourceReference() {
        return this.dataSourceReference;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DataSourceReferenceName of(String project, String location, String dataSourceReference) {
        return DataSourceReferenceName.newBuilder().setProject(project).setLocation(location).setDataSourceReference(dataSourceReference).build();
    }

    public static String format(String project, String location, String dataSourceReference) {
        return DataSourceReferenceName.newBuilder().setProject(project).setLocation(location).setDataSourceReference(dataSourceReference).build().toString();
    }

    public static DataSourceReferenceName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_DATA_SOURCE_REFERENCE.validatedMatch(formattedString, "DataSourceReferenceName.parse: formattedString not in valid format");
        return DataSourceReferenceName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("data_source_reference"));
    }

    public static List<DataSourceReferenceName> parseList(List<String> formattedStrings) {
        ArrayList<DataSourceReferenceName> list = new ArrayList<DataSourceReferenceName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DataSourceReferenceName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DataSourceReferenceName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DataSourceReferenceName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_DATA_SOURCE_REFERENCE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DataSourceReferenceName dataSourceReferenceName = this;
            synchronized (dataSourceReferenceName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.dataSourceReference != null) {
                        fieldMapBuilder.put((Object)"data_source_reference", (Object)this.dataSourceReference);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_DATA_SOURCE_REFERENCE.instantiate(new String[]{"project", this.project, "location", this.location, "data_source_reference", this.dataSourceReference});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            DataSourceReferenceName that = (DataSourceReferenceName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.dataSourceReference, that.dataSourceReference);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.dataSourceReference);
    }

    public static class Builder {
        private String project;
        private String location;
        private String dataSourceReference;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDataSourceReference() {
            return this.dataSourceReference;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setDataSourceReference(String dataSourceReference) {
            this.dataSourceReference = dataSourceReference;
            return this;
        }

        private Builder(DataSourceReferenceName dataSourceReferenceName) {
            this.project = dataSourceReferenceName.project;
            this.location = dataSourceReferenceName.location;
            this.dataSourceReference = dataSourceReferenceName.dataSourceReference;
        }

        public DataSourceReferenceName build() {
            return new DataSourceReferenceName(this);
        }
    }
}

