/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/connection/v1beta1/connection.proto

package com.google.cloud.bigquery.connection.v1beta1;

public final class ConnectionProto {
  private ConnectionProto() {}

  public static void registerAllExtensions(com.google.protobuf.ExtensionRegistryLite registry) {}

  public static void registerAllExtensions(com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions((com.google.protobuf.ExtensionRegistryLite) registry);
  }

  public interface CreateConnectionRequestOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.connection.v1beta1.CreateConnectionRequest)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Parent resource name.
     * Must be in the format `projects/{project_id}/locations/{location_id}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    java.lang.String getParent();
    /**
     *
     *
     * <pre>
     * Required. Parent resource name.
     * Must be in the format `projects/{project_id}/locations/{location_id}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    com.google.protobuf.ByteString getParentBytes();

    /**
     *
     *
     * <pre>
     * Optional. Connection id that should be assigned to the created connection.
     * </pre>
     *
     * <code>string connection_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The connectionId.
     */
    java.lang.String getConnectionId();
    /**
     *
     *
     * <pre>
     * Optional. Connection id that should be assigned to the created connection.
     * </pre>
     *
     * <code>string connection_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for connectionId.
     */
    com.google.protobuf.ByteString getConnectionIdBytes();

    /**
     *
     *
     * <pre>
     * Required. Connection to create.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.connection.v1beta1.Connection connection = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the connection field is set.
     */
    boolean hasConnection();
    /**
     *
     *
     * <pre>
     * Required. Connection to create.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.connection.v1beta1.Connection connection = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The connection.
     */
    com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection getConnection();
    /**
     *
     *
     * <pre>
     * Required. Connection to create.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.connection.v1beta1.Connection connection = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionOrBuilder
        getConnectionOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * The request for
   * [ConnectionService.CreateConnection][google.cloud.bigquery.connection.v1beta1.ConnectionService.CreateConnection].
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.connection.v1beta1.CreateConnectionRequest}
   */
  public static final class CreateConnectionRequest extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.bigquery.connection.v1beta1.CreateConnectionRequest)
      CreateConnectionRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use CreateConnectionRequest.newBuilder() to construct.
    private CreateConnectionRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private CreateConnectionRequest() {
      parent_ = "";
      connectionId_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new CreateConnectionRequest();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
          .internal_static_google_cloud_bigquery_connection_v1beta1_CreateConnectionRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
          .internal_static_google_cloud_bigquery_connection_v1beta1_CreateConnectionRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CreateConnectionRequest
                  .class,
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CreateConnectionRequest
                  .Builder.class);
    }

    public static final int PARENT_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. Parent resource name.
     * Must be in the format `projects/{project_id}/locations/{location_id}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    @java.lang.Override
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Parent resource name.
     * Must be in the format `projects/{project_id}/locations/{location_id}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CONNECTION_ID_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object connectionId_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Connection id that should be assigned to the created connection.
     * </pre>
     *
     * <code>string connection_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The connectionId.
     */
    @java.lang.Override
    public java.lang.String getConnectionId() {
      java.lang.Object ref = connectionId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        connectionId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Connection id that should be assigned to the created connection.
     * </pre>
     *
     * <code>string connection_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for connectionId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getConnectionIdBytes() {
      java.lang.Object ref = connectionId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        connectionId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CONNECTION_FIELD_NUMBER = 3;
    private com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection connection_;
    /**
     *
     *
     * <pre>
     * Required. Connection to create.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.connection.v1beta1.Connection connection = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the connection field is set.
     */
    @java.lang.Override
    public boolean hasConnection() {
      return connection_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. Connection to create.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.connection.v1beta1.Connection connection = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The connection.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection getConnection() {
      return connection_ == null
          ? com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection
              .getDefaultInstance()
          : connection_;
    }
    /**
     *
     *
     * <pre>
     * Required. Connection to create.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.connection.v1beta1.Connection connection = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionOrBuilder
        getConnectionOrBuilder() {
      return connection_ == null
          ? com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection
              .getDefaultInstance()
          : connection_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(connectionId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, connectionId_);
      }
      if (connection_ != null) {
        output.writeMessage(3, getConnection());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(connectionId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, connectionId_);
      }
      if (connection_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getConnection());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CreateConnectionRequest)) {
        return super.equals(obj);
      }
      com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CreateConnectionRequest other =
          (com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CreateConnectionRequest)
              obj;

      if (!getParent().equals(other.getParent())) return false;
      if (!getConnectionId().equals(other.getConnectionId())) return false;
      if (hasConnection() != other.hasConnection()) return false;
      if (hasConnection()) {
        if (!getConnection().equals(other.getConnection())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PARENT_FIELD_NUMBER;
      hash = (53 * hash) + getParent().hashCode();
      hash = (37 * hash) + CONNECTION_ID_FIELD_NUMBER;
      hash = (53 * hash) + getConnectionId().hashCode();
      if (hasConnection()) {
        hash = (37 * hash) + CONNECTION_FIELD_NUMBER;
        hash = (53 * hash) + getConnection().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .CreateConnectionRequest
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .CreateConnectionRequest
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .CreateConnectionRequest
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .CreateConnectionRequest
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .CreateConnectionRequest
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .CreateConnectionRequest
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .CreateConnectionRequest
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .CreateConnectionRequest
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .CreateConnectionRequest
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .CreateConnectionRequest
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .CreateConnectionRequest
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .CreateConnectionRequest
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CreateConnectionRequest
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The request for
     * [ConnectionService.CreateConnection][google.cloud.bigquery.connection.v1beta1.ConnectionService.CreateConnection].
     * </pre>
     *
     * Protobuf type {@code google.cloud.bigquery.connection.v1beta1.CreateConnectionRequest}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.connection.v1beta1.CreateConnectionRequest)
        com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .CreateConnectionRequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .internal_static_google_cloud_bigquery_connection_v1beta1_CreateConnectionRequest_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .internal_static_google_cloud_bigquery_connection_v1beta1_CreateConnectionRequest_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CreateConnectionRequest
                    .class,
                com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CreateConnectionRequest
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CreateConnectionRequest.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        parent_ = "";
        connectionId_ = "";
        connection_ = null;
        if (connectionBuilder_ != null) {
          connectionBuilder_.dispose();
          connectionBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .internal_static_google_cloud_bigquery_connection_v1beta1_CreateConnectionRequest_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CreateConnectionRequest
          getDefaultInstanceForType() {
        return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CreateConnectionRequest
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CreateConnectionRequest
          build() {
        com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CreateConnectionRequest
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CreateConnectionRequest
          buildPartial() {
        com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CreateConnectionRequest
            result =
                new com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
                    .CreateConnectionRequest(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CreateConnectionRequest
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.parent_ = parent_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.connectionId_ = connectionId_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.connection_ =
              connectionBuilder_ == null ? connection_ : connectionBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CreateConnectionRequest) {
          return mergeFrom(
              (com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CreateConnectionRequest)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CreateConnectionRequest
              other) {
        if (other
            == com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CreateConnectionRequest
                .getDefaultInstance()) return this;
        if (!other.getParent().isEmpty()) {
          parent_ = other.parent_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getConnectionId().isEmpty()) {
          connectionId_ = other.connectionId_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (other.hasConnection()) {
          mergeConnection(other.getConnection());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  parent_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  connectionId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(getConnectionFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object parent_ = "";
      /**
       *
       *
       * <pre>
       * Required. Parent resource name.
       * Must be in the format `projects/{project_id}/locations/{location_id}`
       * </pre>
       *
       * <code>
       * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The parent.
       */
      public java.lang.String getParent() {
        java.lang.Object ref = parent_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          parent_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Parent resource name.
       * Must be in the format `projects/{project_id}/locations/{location_id}`
       * </pre>
       *
       * <code>
       * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for parent.
       */
      public com.google.protobuf.ByteString getParentBytes() {
        java.lang.Object ref = parent_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          parent_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Parent resource name.
       * Must be in the format `projects/{project_id}/locations/{location_id}`
       * </pre>
       *
       * <code>
       * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The parent to set.
       * @return This builder for chaining.
       */
      public Builder setParent(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        parent_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Parent resource name.
       * Must be in the format `projects/{project_id}/locations/{location_id}`
       * </pre>
       *
       * <code>
       * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearParent() {
        parent_ = getDefaultInstance().getParent();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Parent resource name.
       * Must be in the format `projects/{project_id}/locations/{location_id}`
       * </pre>
       *
       * <code>
       * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for parent to set.
       * @return This builder for chaining.
       */
      public Builder setParentBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        parent_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object connectionId_ = "";
      /**
       *
       *
       * <pre>
       * Optional. Connection id that should be assigned to the created connection.
       * </pre>
       *
       * <code>string connection_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The connectionId.
       */
      public java.lang.String getConnectionId() {
        java.lang.Object ref = connectionId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          connectionId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Connection id that should be assigned to the created connection.
       * </pre>
       *
       * <code>string connection_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for connectionId.
       */
      public com.google.protobuf.ByteString getConnectionIdBytes() {
        java.lang.Object ref = connectionId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          connectionId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Connection id that should be assigned to the created connection.
       * </pre>
       *
       * <code>string connection_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The connectionId to set.
       * @return This builder for chaining.
       */
      public Builder setConnectionId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        connectionId_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Connection id that should be assigned to the created connection.
       * </pre>
       *
       * <code>string connection_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearConnectionId() {
        connectionId_ = getDefaultInstance().getConnectionId();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Connection id that should be assigned to the created connection.
       * </pre>
       *
       * <code>string connection_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for connectionId to set.
       * @return This builder for chaining.
       */
      public Builder setConnectionIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        connectionId_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection connection_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection,
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection.Builder,
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionOrBuilder>
          connectionBuilder_;
      /**
       *
       *
       * <pre>
       * Required. Connection to create.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.connection.v1beta1.Connection connection = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the connection field is set.
       */
      public boolean hasConnection() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * Required. Connection to create.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.connection.v1beta1.Connection connection = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The connection.
       */
      public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection
          getConnection() {
        if (connectionBuilder_ == null) {
          return connection_ == null
              ? com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection
                  .getDefaultInstance()
              : connection_;
        } else {
          return connectionBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Connection to create.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.connection.v1beta1.Connection connection = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setConnection(
          com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection value) {
        if (connectionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          connection_ = value;
        } else {
          connectionBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Connection to create.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.connection.v1beta1.Connection connection = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setConnection(
          com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection.Builder
              builderForValue) {
        if (connectionBuilder_ == null) {
          connection_ = builderForValue.build();
        } else {
          connectionBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Connection to create.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.connection.v1beta1.Connection connection = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergeConnection(
          com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection value) {
        if (connectionBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && connection_ != null
              && connection_
                  != com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection
                      .getDefaultInstance()) {
            getConnectionBuilder().mergeFrom(value);
          } else {
            connection_ = value;
          }
        } else {
          connectionBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Connection to create.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.connection.v1beta1.Connection connection = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearConnection() {
        bitField0_ = (bitField0_ & ~0x00000004);
        connection_ = null;
        if (connectionBuilder_ != null) {
          connectionBuilder_.dispose();
          connectionBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Connection to create.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.connection.v1beta1.Connection connection = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection.Builder
          getConnectionBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getConnectionFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Required. Connection to create.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.connection.v1beta1.Connection connection = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionOrBuilder
          getConnectionOrBuilder() {
        if (connectionBuilder_ != null) {
          return connectionBuilder_.getMessageOrBuilder();
        } else {
          return connection_ == null
              ? com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection
                  .getDefaultInstance()
              : connection_;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Connection to create.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.connection.v1beta1.Connection connection = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection,
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection.Builder,
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionOrBuilder>
          getConnectionFieldBuilder() {
        if (connectionBuilder_ == null) {
          connectionBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection,
                  com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection.Builder,
                  com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionOrBuilder>(
                  getConnection(), getParentForChildren(), isClean());
          connection_ = null;
        }
        return connectionBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.connection.v1beta1.CreateConnectionRequest)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.bigquery.connection.v1beta1.CreateConnectionRequest)
    private static final com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .CreateConnectionRequest
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
              .CreateConnectionRequest();
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .CreateConnectionRequest
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CreateConnectionRequest> PARSER =
        new com.google.protobuf.AbstractParser<CreateConnectionRequest>() {
          @java.lang.Override
          public CreateConnectionRequest parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<CreateConnectionRequest> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CreateConnectionRequest> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CreateConnectionRequest
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface GetConnectionRequestOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.connection.v1beta1.GetConnectionRequest)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Name of the requested connection, for example:
     * `projects/{project_id}/locations/{location_id}/connections/{connection_id}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    java.lang.String getName();
    /**
     *
     *
     * <pre>
     * Required. Name of the requested connection, for example:
     * `projects/{project_id}/locations/{location_id}/connections/{connection_id}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();
  }
  /**
   *
   *
   * <pre>
   * The request for
   * [ConnectionService.GetConnection][google.cloud.bigquery.connection.v1beta1.ConnectionService.GetConnection].
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.connection.v1beta1.GetConnectionRequest}
   */
  public static final class GetConnectionRequest extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.bigquery.connection.v1beta1.GetConnectionRequest)
      GetConnectionRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use GetConnectionRequest.newBuilder() to construct.
    private GetConnectionRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private GetConnectionRequest() {
      name_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new GetConnectionRequest();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
          .internal_static_google_cloud_bigquery_connection_v1beta1_GetConnectionRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
          .internal_static_google_cloud_bigquery_connection_v1beta1_GetConnectionRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.GetConnectionRequest
                  .class,
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.GetConnectionRequest
                  .Builder.class);
    }

    public static final int NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. Name of the requested connection, for example:
     * `projects/{project_id}/locations/{location_id}/connections/{connection_id}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the requested connection, for example:
     * `projects/{project_id}/locations/{location_id}/connections/{connection_id}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.GetConnectionRequest)) {
        return super.equals(obj);
      }
      com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.GetConnectionRequest other =
          (com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.GetConnectionRequest) obj;

      if (!getName().equals(other.getName())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.GetConnectionRequest
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.GetConnectionRequest
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.GetConnectionRequest
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.GetConnectionRequest
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.GetConnectionRequest
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.GetConnectionRequest
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.GetConnectionRequest
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.GetConnectionRequest
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.GetConnectionRequest
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.GetConnectionRequest
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.GetConnectionRequest
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.GetConnectionRequest
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.GetConnectionRequest
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The request for
     * [ConnectionService.GetConnection][google.cloud.bigquery.connection.v1beta1.ConnectionService.GetConnection].
     * </pre>
     *
     * Protobuf type {@code google.cloud.bigquery.connection.v1beta1.GetConnectionRequest}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.connection.v1beta1.GetConnectionRequest)
        com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.GetConnectionRequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .internal_static_google_cloud_bigquery_connection_v1beta1_GetConnectionRequest_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .internal_static_google_cloud_bigquery_connection_v1beta1_GetConnectionRequest_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.GetConnectionRequest
                    .class,
                com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.GetConnectionRequest
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.GetConnectionRequest.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        name_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .internal_static_google_cloud_bigquery_connection_v1beta1_GetConnectionRequest_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.GetConnectionRequest
          getDefaultInstanceForType() {
        return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.GetConnectionRequest
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.GetConnectionRequest
          build() {
        com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.GetConnectionRequest result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.GetConnectionRequest
          buildPartial() {
        com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.GetConnectionRequest result =
            new com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.GetConnectionRequest(
                this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.GetConnectionRequest
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.name_ = name_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.GetConnectionRequest) {
          return mergeFrom(
              (com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.GetConnectionRequest)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.GetConnectionRequest other) {
        if (other
            == com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.GetConnectionRequest
                .getDefaultInstance()) return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  name_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * Required. Name of the requested connection, for example:
       * `projects/{project_id}/locations/{location_id}/connections/{connection_id}`
       * </pre>
       *
       * <code>
       * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Name of the requested connection, for example:
       * `projects/{project_id}/locations/{location_id}/connections/{connection_id}`
       * </pre>
       *
       * <code>
       * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Name of the requested connection, for example:
       * `projects/{project_id}/locations/{location_id}/connections/{connection_id}`
       * </pre>
       *
       * <code>
       * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Name of the requested connection, for example:
       * `projects/{project_id}/locations/{location_id}/connections/{connection_id}`
       * </pre>
       *
       * <code>
       * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {
        name_ = getDefaultInstance().getName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Name of the requested connection, for example:
       * `projects/{project_id}/locations/{location_id}/connections/{connection_id}`
       * </pre>
       *
       * <code>
       * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.connection.v1beta1.GetConnectionRequest)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.bigquery.connection.v1beta1.GetConnectionRequest)
    private static final com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .GetConnectionRequest
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.GetConnectionRequest();
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.GetConnectionRequest
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<GetConnectionRequest> PARSER =
        new com.google.protobuf.AbstractParser<GetConnectionRequest>() {
          @java.lang.Override
          public GetConnectionRequest parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<GetConnectionRequest> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GetConnectionRequest> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.GetConnectionRequest
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ListConnectionsRequestOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.connection.v1beta1.ListConnectionsRequest)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Parent resource name.
     * Must be in the form: `projects/{project_id}/locations/{location_id}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    java.lang.String getParent();
    /**
     *
     *
     * <pre>
     * Required. Parent resource name.
     * Must be in the form: `projects/{project_id}/locations/{location_id}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    com.google.protobuf.ByteString getParentBytes();

    /**
     *
     *
     * <pre>
     * Required. Maximum number of results per page.
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value max_results = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the maxResults field is set.
     */
    boolean hasMaxResults();
    /**
     *
     *
     * <pre>
     * Required. Maximum number of results per page.
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value max_results = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The maxResults.
     */
    com.google.protobuf.UInt32Value getMaxResults();
    /**
     *
     *
     * <pre>
     * Required. Maximum number of results per page.
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value max_results = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.protobuf.UInt32ValueOrBuilder getMaxResultsOrBuilder();

    /**
     *
     *
     * <pre>
     * Page token.
     * </pre>
     *
     * <code>string page_token = 3;</code>
     *
     * @return The pageToken.
     */
    java.lang.String getPageToken();
    /**
     *
     *
     * <pre>
     * Page token.
     * </pre>
     *
     * <code>string page_token = 3;</code>
     *
     * @return The bytes for pageToken.
     */
    com.google.protobuf.ByteString getPageTokenBytes();
  }
  /**
   *
   *
   * <pre>
   * The request for
   * [ConnectionService.ListConnections][google.cloud.bigquery.connection.v1beta1.ConnectionService.ListConnections].
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.connection.v1beta1.ListConnectionsRequest}
   */
  public static final class ListConnectionsRequest extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.bigquery.connection.v1beta1.ListConnectionsRequest)
      ListConnectionsRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ListConnectionsRequest.newBuilder() to construct.
    private ListConnectionsRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ListConnectionsRequest() {
      parent_ = "";
      pageToken_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ListConnectionsRequest();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
          .internal_static_google_cloud_bigquery_connection_v1beta1_ListConnectionsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
          .internal_static_google_cloud_bigquery_connection_v1beta1_ListConnectionsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ListConnectionsRequest
                  .class,
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ListConnectionsRequest
                  .Builder.class);
    }

    public static final int PARENT_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. Parent resource name.
     * Must be in the form: `projects/{project_id}/locations/{location_id}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    @java.lang.Override
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Parent resource name.
     * Must be in the form: `projects/{project_id}/locations/{location_id}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int MAX_RESULTS_FIELD_NUMBER = 2;
    private com.google.protobuf.UInt32Value maxResults_;
    /**
     *
     *
     * <pre>
     * Required. Maximum number of results per page.
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value max_results = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the maxResults field is set.
     */
    @java.lang.Override
    public boolean hasMaxResults() {
      return maxResults_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. Maximum number of results per page.
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value max_results = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The maxResults.
     */
    @java.lang.Override
    public com.google.protobuf.UInt32Value getMaxResults() {
      return maxResults_ == null
          ? com.google.protobuf.UInt32Value.getDefaultInstance()
          : maxResults_;
    }
    /**
     *
     *
     * <pre>
     * Required. Maximum number of results per page.
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value max_results = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.protobuf.UInt32ValueOrBuilder getMaxResultsOrBuilder() {
      return maxResults_ == null
          ? com.google.protobuf.UInt32Value.getDefaultInstance()
          : maxResults_;
    }

    public static final int PAGE_TOKEN_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object pageToken_ = "";
    /**
     *
     *
     * <pre>
     * Page token.
     * </pre>
     *
     * <code>string page_token = 3;</code>
     *
     * @return The pageToken.
     */
    @java.lang.Override
    public java.lang.String getPageToken() {
      java.lang.Object ref = pageToken_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pageToken_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Page token.
     * </pre>
     *
     * <code>string page_token = 3;</code>
     *
     * @return The bytes for pageToken.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPageTokenBytes() {
      java.lang.Object ref = pageToken_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
      }
      if (maxResults_ != null) {
        output.writeMessage(2, getMaxResults());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, pageToken_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
      }
      if (maxResults_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getMaxResults());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, pageToken_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ListConnectionsRequest)) {
        return super.equals(obj);
      }
      com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ListConnectionsRequest other =
          (com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ListConnectionsRequest) obj;

      if (!getParent().equals(other.getParent())) return false;
      if (hasMaxResults() != other.hasMaxResults()) return false;
      if (hasMaxResults()) {
        if (!getMaxResults().equals(other.getMaxResults())) return false;
      }
      if (!getPageToken().equals(other.getPageToken())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PARENT_FIELD_NUMBER;
      hash = (53 * hash) + getParent().hashCode();
      if (hasMaxResults()) {
        hash = (37 * hash) + MAX_RESULTS_FIELD_NUMBER;
        hash = (53 * hash) + getMaxResults().hashCode();
      }
      hash = (37 * hash) + PAGE_TOKEN_FIELD_NUMBER;
      hash = (53 * hash) + getPageToken().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .ListConnectionsRequest
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .ListConnectionsRequest
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .ListConnectionsRequest
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .ListConnectionsRequest
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .ListConnectionsRequest
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .ListConnectionsRequest
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .ListConnectionsRequest
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .ListConnectionsRequest
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .ListConnectionsRequest
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .ListConnectionsRequest
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .ListConnectionsRequest
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .ListConnectionsRequest
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ListConnectionsRequest
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The request for
     * [ConnectionService.ListConnections][google.cloud.bigquery.connection.v1beta1.ConnectionService.ListConnections].
     * </pre>
     *
     * Protobuf type {@code google.cloud.bigquery.connection.v1beta1.ListConnectionsRequest}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.connection.v1beta1.ListConnectionsRequest)
        com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .ListConnectionsRequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .internal_static_google_cloud_bigquery_connection_v1beta1_ListConnectionsRequest_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .internal_static_google_cloud_bigquery_connection_v1beta1_ListConnectionsRequest_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ListConnectionsRequest
                    .class,
                com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ListConnectionsRequest
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ListConnectionsRequest.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        parent_ = "";
        maxResults_ = null;
        if (maxResultsBuilder_ != null) {
          maxResultsBuilder_.dispose();
          maxResultsBuilder_ = null;
        }
        pageToken_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .internal_static_google_cloud_bigquery_connection_v1beta1_ListConnectionsRequest_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ListConnectionsRequest
          getDefaultInstanceForType() {
        return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ListConnectionsRequest
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ListConnectionsRequest
          build() {
        com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ListConnectionsRequest result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ListConnectionsRequest
          buildPartial() {
        com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ListConnectionsRequest result =
            new com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ListConnectionsRequest(
                this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ListConnectionsRequest
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.parent_ = parent_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.maxResults_ =
              maxResultsBuilder_ == null ? maxResults_ : maxResultsBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.pageToken_ = pageToken_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ListConnectionsRequest) {
          return mergeFrom(
              (com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ListConnectionsRequest)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ListConnectionsRequest
              other) {
        if (other
            == com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ListConnectionsRequest
                .getDefaultInstance()) return this;
        if (!other.getParent().isEmpty()) {
          parent_ = other.parent_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.hasMaxResults()) {
          mergeMaxResults(other.getMaxResults());
        }
        if (!other.getPageToken().isEmpty()) {
          pageToken_ = other.pageToken_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  parent_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getMaxResultsFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  pageToken_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object parent_ = "";
      /**
       *
       *
       * <pre>
       * Required. Parent resource name.
       * Must be in the form: `projects/{project_id}/locations/{location_id}`
       * </pre>
       *
       * <code>
       * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The parent.
       */
      public java.lang.String getParent() {
        java.lang.Object ref = parent_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          parent_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Parent resource name.
       * Must be in the form: `projects/{project_id}/locations/{location_id}`
       * </pre>
       *
       * <code>
       * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for parent.
       */
      public com.google.protobuf.ByteString getParentBytes() {
        java.lang.Object ref = parent_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          parent_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Parent resource name.
       * Must be in the form: `projects/{project_id}/locations/{location_id}`
       * </pre>
       *
       * <code>
       * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The parent to set.
       * @return This builder for chaining.
       */
      public Builder setParent(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        parent_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Parent resource name.
       * Must be in the form: `projects/{project_id}/locations/{location_id}`
       * </pre>
       *
       * <code>
       * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearParent() {
        parent_ = getDefaultInstance().getParent();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Parent resource name.
       * Must be in the form: `projects/{project_id}/locations/{location_id}`
       * </pre>
       *
       * <code>
       * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for parent to set.
       * @return This builder for chaining.
       */
      public Builder setParentBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        parent_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.protobuf.UInt32Value maxResults_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.UInt32Value,
              com.google.protobuf.UInt32Value.Builder,
              com.google.protobuf.UInt32ValueOrBuilder>
          maxResultsBuilder_;
      /**
       *
       *
       * <pre>
       * Required. Maximum number of results per page.
       * </pre>
       *
       * <code>
       * .google.protobuf.UInt32Value max_results = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the maxResults field is set.
       */
      public boolean hasMaxResults() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Required. Maximum number of results per page.
       * </pre>
       *
       * <code>
       * .google.protobuf.UInt32Value max_results = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The maxResults.
       */
      public com.google.protobuf.UInt32Value getMaxResults() {
        if (maxResultsBuilder_ == null) {
          return maxResults_ == null
              ? com.google.protobuf.UInt32Value.getDefaultInstance()
              : maxResults_;
        } else {
          return maxResultsBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Maximum number of results per page.
       * </pre>
       *
       * <code>
       * .google.protobuf.UInt32Value max_results = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setMaxResults(com.google.protobuf.UInt32Value value) {
        if (maxResultsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          maxResults_ = value;
        } else {
          maxResultsBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Maximum number of results per page.
       * </pre>
       *
       * <code>
       * .google.protobuf.UInt32Value max_results = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setMaxResults(com.google.protobuf.UInt32Value.Builder builderForValue) {
        if (maxResultsBuilder_ == null) {
          maxResults_ = builderForValue.build();
        } else {
          maxResultsBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Maximum number of results per page.
       * </pre>
       *
       * <code>
       * .google.protobuf.UInt32Value max_results = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergeMaxResults(com.google.protobuf.UInt32Value value) {
        if (maxResultsBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && maxResults_ != null
              && maxResults_ != com.google.protobuf.UInt32Value.getDefaultInstance()) {
            getMaxResultsBuilder().mergeFrom(value);
          } else {
            maxResults_ = value;
          }
        } else {
          maxResultsBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Maximum number of results per page.
       * </pre>
       *
       * <code>
       * .google.protobuf.UInt32Value max_results = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearMaxResults() {
        bitField0_ = (bitField0_ & ~0x00000002);
        maxResults_ = null;
        if (maxResultsBuilder_ != null) {
          maxResultsBuilder_.dispose();
          maxResultsBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Maximum number of results per page.
       * </pre>
       *
       * <code>
       * .google.protobuf.UInt32Value max_results = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.protobuf.UInt32Value.Builder getMaxResultsBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getMaxResultsFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Required. Maximum number of results per page.
       * </pre>
       *
       * <code>
       * .google.protobuf.UInt32Value max_results = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.protobuf.UInt32ValueOrBuilder getMaxResultsOrBuilder() {
        if (maxResultsBuilder_ != null) {
          return maxResultsBuilder_.getMessageOrBuilder();
        } else {
          return maxResults_ == null
              ? com.google.protobuf.UInt32Value.getDefaultInstance()
              : maxResults_;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Maximum number of results per page.
       * </pre>
       *
       * <code>
       * .google.protobuf.UInt32Value max_results = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.UInt32Value,
              com.google.protobuf.UInt32Value.Builder,
              com.google.protobuf.UInt32ValueOrBuilder>
          getMaxResultsFieldBuilder() {
        if (maxResultsBuilder_ == null) {
          maxResultsBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.UInt32Value,
                  com.google.protobuf.UInt32Value.Builder,
                  com.google.protobuf.UInt32ValueOrBuilder>(
                  getMaxResults(), getParentForChildren(), isClean());
          maxResults_ = null;
        }
        return maxResultsBuilder_;
      }

      private java.lang.Object pageToken_ = "";
      /**
       *
       *
       * <pre>
       * Page token.
       * </pre>
       *
       * <code>string page_token = 3;</code>
       *
       * @return The pageToken.
       */
      public java.lang.String getPageToken() {
        java.lang.Object ref = pageToken_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          pageToken_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Page token.
       * </pre>
       *
       * <code>string page_token = 3;</code>
       *
       * @return The bytes for pageToken.
       */
      public com.google.protobuf.ByteString getPageTokenBytes() {
        java.lang.Object ref = pageToken_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          pageToken_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Page token.
       * </pre>
       *
       * <code>string page_token = 3;</code>
       *
       * @param value The pageToken to set.
       * @return This builder for chaining.
       */
      public Builder setPageToken(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        pageToken_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Page token.
       * </pre>
       *
       * <code>string page_token = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPageToken() {
        pageToken_ = getDefaultInstance().getPageToken();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Page token.
       * </pre>
       *
       * <code>string page_token = 3;</code>
       *
       * @param value The bytes for pageToken to set.
       * @return This builder for chaining.
       */
      public Builder setPageTokenBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        pageToken_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.connection.v1beta1.ListConnectionsRequest)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.bigquery.connection.v1beta1.ListConnectionsRequest)
    private static final com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .ListConnectionsRequest
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ListConnectionsRequest();
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .ListConnectionsRequest
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ListConnectionsRequest> PARSER =
        new com.google.protobuf.AbstractParser<ListConnectionsRequest>() {
          @java.lang.Override
          public ListConnectionsRequest parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ListConnectionsRequest> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ListConnectionsRequest> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ListConnectionsRequest
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ListConnectionsResponseOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.connection.v1beta1.ListConnectionsResponse)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Next page token.
     * </pre>
     *
     * <code>string next_page_token = 1;</code>
     *
     * @return The nextPageToken.
     */
    java.lang.String getNextPageToken();
    /**
     *
     *
     * <pre>
     * Next page token.
     * </pre>
     *
     * <code>string next_page_token = 1;</code>
     *
     * @return The bytes for nextPageToken.
     */
    com.google.protobuf.ByteString getNextPageTokenBytes();

    /**
     *
     *
     * <pre>
     * List of connections.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.connection.v1beta1.Connection connections = 2;</code>
     */
    java.util.List<com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection>
        getConnectionsList();
    /**
     *
     *
     * <pre>
     * List of connections.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.connection.v1beta1.Connection connections = 2;</code>
     */
    com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection getConnections(
        int index);
    /**
     *
     *
     * <pre>
     * List of connections.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.connection.v1beta1.Connection connections = 2;</code>
     */
    int getConnectionsCount();
    /**
     *
     *
     * <pre>
     * List of connections.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.connection.v1beta1.Connection connections = 2;</code>
     */
    java.util.List<
            ? extends
                com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionOrBuilder>
        getConnectionsOrBuilderList();
    /**
     *
     *
     * <pre>
     * List of connections.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.connection.v1beta1.Connection connections = 2;</code>
     */
    com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionOrBuilder
        getConnectionsOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * The response for
   * [ConnectionService.ListConnections][google.cloud.bigquery.connection.v1beta1.ConnectionService.ListConnections].
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.connection.v1beta1.ListConnectionsResponse}
   */
  public static final class ListConnectionsResponse extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.bigquery.connection.v1beta1.ListConnectionsResponse)
      ListConnectionsResponseOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ListConnectionsResponse.newBuilder() to construct.
    private ListConnectionsResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ListConnectionsResponse() {
      nextPageToken_ = "";
      connections_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ListConnectionsResponse();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
          .internal_static_google_cloud_bigquery_connection_v1beta1_ListConnectionsResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
          .internal_static_google_cloud_bigquery_connection_v1beta1_ListConnectionsResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ListConnectionsResponse
                  .class,
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ListConnectionsResponse
                  .Builder.class);
    }

    public static final int NEXT_PAGE_TOKEN_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object nextPageToken_ = "";
    /**
     *
     *
     * <pre>
     * Next page token.
     * </pre>
     *
     * <code>string next_page_token = 1;</code>
     *
     * @return The nextPageToken.
     */
    @java.lang.Override
    public java.lang.String getNextPageToken() {
      java.lang.Object ref = nextPageToken_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nextPageToken_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Next page token.
     * </pre>
     *
     * <code>string next_page_token = 1;</code>
     *
     * @return The bytes for nextPageToken.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNextPageTokenBytes() {
      java.lang.Object ref = nextPageToken_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nextPageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CONNECTIONS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection>
        connections_;
    /**
     *
     *
     * <pre>
     * List of connections.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.connection.v1beta1.Connection connections = 2;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection>
        getConnectionsList() {
      return connections_;
    }
    /**
     *
     *
     * <pre>
     * List of connections.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.connection.v1beta1.Connection connections = 2;</code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionOrBuilder>
        getConnectionsOrBuilderList() {
      return connections_;
    }
    /**
     *
     *
     * <pre>
     * List of connections.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.connection.v1beta1.Connection connections = 2;</code>
     */
    @java.lang.Override
    public int getConnectionsCount() {
      return connections_.size();
    }
    /**
     *
     *
     * <pre>
     * List of connections.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.connection.v1beta1.Connection connections = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection getConnections(
        int index) {
      return connections_.get(index);
    }
    /**
     *
     *
     * <pre>
     * List of connections.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.connection.v1beta1.Connection connections = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionOrBuilder
        getConnectionsOrBuilder(int index) {
      return connections_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, nextPageToken_);
      }
      for (int i = 0; i < connections_.size(); i++) {
        output.writeMessage(2, connections_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, nextPageToken_);
      }
      for (int i = 0; i < connections_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, connections_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ListConnectionsResponse)) {
        return super.equals(obj);
      }
      com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ListConnectionsResponse other =
          (com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ListConnectionsResponse)
              obj;

      if (!getNextPageToken().equals(other.getNextPageToken())) return false;
      if (!getConnectionsList().equals(other.getConnectionsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NEXT_PAGE_TOKEN_FIELD_NUMBER;
      hash = (53 * hash) + getNextPageToken().hashCode();
      if (getConnectionsCount() > 0) {
        hash = (37 * hash) + CONNECTIONS_FIELD_NUMBER;
        hash = (53 * hash) + getConnectionsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .ListConnectionsResponse
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .ListConnectionsResponse
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .ListConnectionsResponse
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .ListConnectionsResponse
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .ListConnectionsResponse
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .ListConnectionsResponse
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .ListConnectionsResponse
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .ListConnectionsResponse
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .ListConnectionsResponse
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .ListConnectionsResponse
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .ListConnectionsResponse
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .ListConnectionsResponse
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ListConnectionsResponse
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The response for
     * [ConnectionService.ListConnections][google.cloud.bigquery.connection.v1beta1.ConnectionService.ListConnections].
     * </pre>
     *
     * Protobuf type {@code google.cloud.bigquery.connection.v1beta1.ListConnectionsResponse}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.connection.v1beta1.ListConnectionsResponse)
        com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .ListConnectionsResponseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .internal_static_google_cloud_bigquery_connection_v1beta1_ListConnectionsResponse_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .internal_static_google_cloud_bigquery_connection_v1beta1_ListConnectionsResponse_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ListConnectionsResponse
                    .class,
                com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ListConnectionsResponse
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ListConnectionsResponse.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        nextPageToken_ = "";
        if (connectionsBuilder_ == null) {
          connections_ = java.util.Collections.emptyList();
        } else {
          connections_ = null;
          connectionsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .internal_static_google_cloud_bigquery_connection_v1beta1_ListConnectionsResponse_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ListConnectionsResponse
          getDefaultInstanceForType() {
        return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ListConnectionsResponse
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ListConnectionsResponse
          build() {
        com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ListConnectionsResponse
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ListConnectionsResponse
          buildPartial() {
        com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ListConnectionsResponse
            result =
                new com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
                    .ListConnectionsResponse(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ListConnectionsResponse
              result) {
        if (connectionsBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            connections_ = java.util.Collections.unmodifiableList(connections_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.connections_ = connections_;
        } else {
          result.connections_ = connectionsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ListConnectionsResponse
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.nextPageToken_ = nextPageToken_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ListConnectionsResponse) {
          return mergeFrom(
              (com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ListConnectionsResponse)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ListConnectionsResponse
              other) {
        if (other
            == com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ListConnectionsResponse
                .getDefaultInstance()) return this;
        if (!other.getNextPageToken().isEmpty()) {
          nextPageToken_ = other.nextPageToken_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (connectionsBuilder_ == null) {
          if (!other.connections_.isEmpty()) {
            if (connections_.isEmpty()) {
              connections_ = other.connections_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureConnectionsIsMutable();
              connections_.addAll(other.connections_);
            }
            onChanged();
          }
        } else {
          if (!other.connections_.isEmpty()) {
            if (connectionsBuilder_.isEmpty()) {
              connectionsBuilder_.dispose();
              connectionsBuilder_ = null;
              connections_ = other.connections_;
              bitField0_ = (bitField0_ & ~0x00000002);
              connectionsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getConnectionsFieldBuilder()
                      : null;
            } else {
              connectionsBuilder_.addAllMessages(other.connections_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  nextPageToken_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection m =
                      input.readMessage(
                          com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection
                              .parser(),
                          extensionRegistry);
                  if (connectionsBuilder_ == null) {
                    ensureConnectionsIsMutable();
                    connections_.add(m);
                  } else {
                    connectionsBuilder_.addMessage(m);
                  }
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object nextPageToken_ = "";
      /**
       *
       *
       * <pre>
       * Next page token.
       * </pre>
       *
       * <code>string next_page_token = 1;</code>
       *
       * @return The nextPageToken.
       */
      public java.lang.String getNextPageToken() {
        java.lang.Object ref = nextPageToken_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          nextPageToken_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Next page token.
       * </pre>
       *
       * <code>string next_page_token = 1;</code>
       *
       * @return The bytes for nextPageToken.
       */
      public com.google.protobuf.ByteString getNextPageTokenBytes() {
        java.lang.Object ref = nextPageToken_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          nextPageToken_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Next page token.
       * </pre>
       *
       * <code>string next_page_token = 1;</code>
       *
       * @param value The nextPageToken to set.
       * @return This builder for chaining.
       */
      public Builder setNextPageToken(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        nextPageToken_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Next page token.
       * </pre>
       *
       * <code>string next_page_token = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearNextPageToken() {
        nextPageToken_ = getDefaultInstance().getNextPageToken();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Next page token.
       * </pre>
       *
       * <code>string next_page_token = 1;</code>
       *
       * @param value The bytes for nextPageToken to set.
       * @return This builder for chaining.
       */
      public Builder setNextPageTokenBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        nextPageToken_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.util.List<
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection>
          connections_ = java.util.Collections.emptyList();

      private void ensureConnectionsIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          connections_ =
              new java.util.ArrayList<
                  com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection>(
                  connections_);
          bitField0_ |= 0x00000002;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection,
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection.Builder,
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionOrBuilder>
          connectionsBuilder_;

      /**
       *
       *
       * <pre>
       * List of connections.
       * </pre>
       *
       * <code>repeated .google.cloud.bigquery.connection.v1beta1.Connection connections = 2;</code>
       */
      public java.util.List<com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection>
          getConnectionsList() {
        if (connectionsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(connections_);
        } else {
          return connectionsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * List of connections.
       * </pre>
       *
       * <code>repeated .google.cloud.bigquery.connection.v1beta1.Connection connections = 2;</code>
       */
      public int getConnectionsCount() {
        if (connectionsBuilder_ == null) {
          return connections_.size();
        } else {
          return connectionsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * List of connections.
       * </pre>
       *
       * <code>repeated .google.cloud.bigquery.connection.v1beta1.Connection connections = 2;</code>
       */
      public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection getConnections(
          int index) {
        if (connectionsBuilder_ == null) {
          return connections_.get(index);
        } else {
          return connectionsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * List of connections.
       * </pre>
       *
       * <code>repeated .google.cloud.bigquery.connection.v1beta1.Connection connections = 2;</code>
       */
      public Builder setConnections(
          int index,
          com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection value) {
        if (connectionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureConnectionsIsMutable();
          connections_.set(index, value);
          onChanged();
        } else {
          connectionsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of connections.
       * </pre>
       *
       * <code>repeated .google.cloud.bigquery.connection.v1beta1.Connection connections = 2;</code>
       */
      public Builder setConnections(
          int index,
          com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection.Builder
              builderForValue) {
        if (connectionsBuilder_ == null) {
          ensureConnectionsIsMutable();
          connections_.set(index, builderForValue.build());
          onChanged();
        } else {
          connectionsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of connections.
       * </pre>
       *
       * <code>repeated .google.cloud.bigquery.connection.v1beta1.Connection connections = 2;</code>
       */
      public Builder addConnections(
          com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection value) {
        if (connectionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureConnectionsIsMutable();
          connections_.add(value);
          onChanged();
        } else {
          connectionsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of connections.
       * </pre>
       *
       * <code>repeated .google.cloud.bigquery.connection.v1beta1.Connection connections = 2;</code>
       */
      public Builder addConnections(
          int index,
          com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection value) {
        if (connectionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureConnectionsIsMutable();
          connections_.add(index, value);
          onChanged();
        } else {
          connectionsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of connections.
       * </pre>
       *
       * <code>repeated .google.cloud.bigquery.connection.v1beta1.Connection connections = 2;</code>
       */
      public Builder addConnections(
          com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection.Builder
              builderForValue) {
        if (connectionsBuilder_ == null) {
          ensureConnectionsIsMutable();
          connections_.add(builderForValue.build());
          onChanged();
        } else {
          connectionsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of connections.
       * </pre>
       *
       * <code>repeated .google.cloud.bigquery.connection.v1beta1.Connection connections = 2;</code>
       */
      public Builder addConnections(
          int index,
          com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection.Builder
              builderForValue) {
        if (connectionsBuilder_ == null) {
          ensureConnectionsIsMutable();
          connections_.add(index, builderForValue.build());
          onChanged();
        } else {
          connectionsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of connections.
       * </pre>
       *
       * <code>repeated .google.cloud.bigquery.connection.v1beta1.Connection connections = 2;</code>
       */
      public Builder addAllConnections(
          java.lang.Iterable<
                  ? extends com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection>
              values) {
        if (connectionsBuilder_ == null) {
          ensureConnectionsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, connections_);
          onChanged();
        } else {
          connectionsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of connections.
       * </pre>
       *
       * <code>repeated .google.cloud.bigquery.connection.v1beta1.Connection connections = 2;</code>
       */
      public Builder clearConnections() {
        if (connectionsBuilder_ == null) {
          connections_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          connectionsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of connections.
       * </pre>
       *
       * <code>repeated .google.cloud.bigquery.connection.v1beta1.Connection connections = 2;</code>
       */
      public Builder removeConnections(int index) {
        if (connectionsBuilder_ == null) {
          ensureConnectionsIsMutable();
          connections_.remove(index);
          onChanged();
        } else {
          connectionsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of connections.
       * </pre>
       *
       * <code>repeated .google.cloud.bigquery.connection.v1beta1.Connection connections = 2;</code>
       */
      public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection.Builder
          getConnectionsBuilder(int index) {
        return getConnectionsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * List of connections.
       * </pre>
       *
       * <code>repeated .google.cloud.bigquery.connection.v1beta1.Connection connections = 2;</code>
       */
      public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionOrBuilder
          getConnectionsOrBuilder(int index) {
        if (connectionsBuilder_ == null) {
          return connections_.get(index);
        } else {
          return connectionsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * List of connections.
       * </pre>
       *
       * <code>repeated .google.cloud.bigquery.connection.v1beta1.Connection connections = 2;</code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionOrBuilder>
          getConnectionsOrBuilderList() {
        if (connectionsBuilder_ != null) {
          return connectionsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(connections_);
        }
      }
      /**
       *
       *
       * <pre>
       * List of connections.
       * </pre>
       *
       * <code>repeated .google.cloud.bigquery.connection.v1beta1.Connection connections = 2;</code>
       */
      public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection.Builder
          addConnectionsBuilder() {
        return getConnectionsFieldBuilder()
            .addBuilder(
                com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * List of connections.
       * </pre>
       *
       * <code>repeated .google.cloud.bigquery.connection.v1beta1.Connection connections = 2;</code>
       */
      public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection.Builder
          addConnectionsBuilder(int index) {
        return getConnectionsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * List of connections.
       * </pre>
       *
       * <code>repeated .google.cloud.bigquery.connection.v1beta1.Connection connections = 2;</code>
       */
      public java.util.List<
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection.Builder>
          getConnectionsBuilderList() {
        return getConnectionsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection,
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection.Builder,
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionOrBuilder>
          getConnectionsFieldBuilder() {
        if (connectionsBuilder_ == null) {
          connectionsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection,
                  com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection.Builder,
                  com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionOrBuilder>(
                  connections_,
                  ((bitField0_ & 0x00000002) != 0),
                  getParentForChildren(),
                  isClean());
          connections_ = null;
        }
        return connectionsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.connection.v1beta1.ListConnectionsResponse)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.bigquery.connection.v1beta1.ListConnectionsResponse)
    private static final com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .ListConnectionsResponse
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
              .ListConnectionsResponse();
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .ListConnectionsResponse
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ListConnectionsResponse> PARSER =
        new com.google.protobuf.AbstractParser<ListConnectionsResponse>() {
          @java.lang.Override
          public ListConnectionsResponse parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ListConnectionsResponse> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ListConnectionsResponse> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ListConnectionsResponse
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface UpdateConnectionRequestOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.connection.v1beta1.UpdateConnectionRequest)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Name of the connection to update, for example:
     * `projects/{project_id}/locations/{location_id}/connections/{connection_id}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    java.lang.String getName();
    /**
     *
     *
     * <pre>
     * Required. Name of the connection to update, for example:
     * `projects/{project_id}/locations/{location_id}/connections/{connection_id}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();

    /**
     *
     *
     * <pre>
     * Required. Connection containing the updated fields.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.connection.v1beta1.Connection connection = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the connection field is set.
     */
    boolean hasConnection();
    /**
     *
     *
     * <pre>
     * Required. Connection containing the updated fields.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.connection.v1beta1.Connection connection = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The connection.
     */
    com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection getConnection();
    /**
     *
     *
     * <pre>
     * Required. Connection containing the updated fields.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.connection.v1beta1.Connection connection = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionOrBuilder
        getConnectionOrBuilder();

    /**
     *
     *
     * <pre>
     * Required. Update mask for the connection fields to be updated.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the updateMask field is set.
     */
    boolean hasUpdateMask();
    /**
     *
     *
     * <pre>
     * Required. Update mask for the connection fields to be updated.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The updateMask.
     */
    com.google.protobuf.FieldMask getUpdateMask();
    /**
     *
     *
     * <pre>
     * Required. Update mask for the connection fields to be updated.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.protobuf.FieldMaskOrBuilder getUpdateMaskOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * The request for
   * [ConnectionService.UpdateConnection][google.cloud.bigquery.connection.v1beta1.ConnectionService.UpdateConnection].
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.connection.v1beta1.UpdateConnectionRequest}
   */
  public static final class UpdateConnectionRequest extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.bigquery.connection.v1beta1.UpdateConnectionRequest)
      UpdateConnectionRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use UpdateConnectionRequest.newBuilder() to construct.
    private UpdateConnectionRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private UpdateConnectionRequest() {
      name_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new UpdateConnectionRequest();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
          .internal_static_google_cloud_bigquery_connection_v1beta1_UpdateConnectionRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
          .internal_static_google_cloud_bigquery_connection_v1beta1_UpdateConnectionRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.UpdateConnectionRequest
                  .class,
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.UpdateConnectionRequest
                  .Builder.class);
    }

    public static final int NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. Name of the connection to update, for example:
     * `projects/{project_id}/locations/{location_id}/connections/{connection_id}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the connection to update, for example:
     * `projects/{project_id}/locations/{location_id}/connections/{connection_id}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CONNECTION_FIELD_NUMBER = 2;
    private com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection connection_;
    /**
     *
     *
     * <pre>
     * Required. Connection containing the updated fields.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.connection.v1beta1.Connection connection = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the connection field is set.
     */
    @java.lang.Override
    public boolean hasConnection() {
      return connection_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. Connection containing the updated fields.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.connection.v1beta1.Connection connection = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The connection.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection getConnection() {
      return connection_ == null
          ? com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection
              .getDefaultInstance()
          : connection_;
    }
    /**
     *
     *
     * <pre>
     * Required. Connection containing the updated fields.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.connection.v1beta1.Connection connection = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionOrBuilder
        getConnectionOrBuilder() {
      return connection_ == null
          ? com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection
              .getDefaultInstance()
          : connection_;
    }

    public static final int UPDATE_MASK_FIELD_NUMBER = 3;
    private com.google.protobuf.FieldMask updateMask_;
    /**
     *
     *
     * <pre>
     * Required. Update mask for the connection fields to be updated.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the updateMask field is set.
     */
    @java.lang.Override
    public boolean hasUpdateMask() {
      return updateMask_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. Update mask for the connection fields to be updated.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The updateMask.
     */
    @java.lang.Override
    public com.google.protobuf.FieldMask getUpdateMask() {
      return updateMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : updateMask_;
    }
    /**
     *
     *
     * <pre>
     * Required. Update mask for the connection fields to be updated.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.protobuf.FieldMaskOrBuilder getUpdateMaskOrBuilder() {
      return updateMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : updateMask_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
      }
      if (connection_ != null) {
        output.writeMessage(2, getConnection());
      }
      if (updateMask_ != null) {
        output.writeMessage(3, getUpdateMask());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
      }
      if (connection_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getConnection());
      }
      if (updateMask_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getUpdateMask());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.UpdateConnectionRequest)) {
        return super.equals(obj);
      }
      com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.UpdateConnectionRequest other =
          (com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.UpdateConnectionRequest)
              obj;

      if (!getName().equals(other.getName())) return false;
      if (hasConnection() != other.hasConnection()) return false;
      if (hasConnection()) {
        if (!getConnection().equals(other.getConnection())) return false;
      }
      if (hasUpdateMask() != other.hasUpdateMask()) return false;
      if (hasUpdateMask()) {
        if (!getUpdateMask().equals(other.getUpdateMask())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      if (hasConnection()) {
        hash = (37 * hash) + CONNECTION_FIELD_NUMBER;
        hash = (53 * hash) + getConnection().hashCode();
      }
      if (hasUpdateMask()) {
        hash = (37 * hash) + UPDATE_MASK_FIELD_NUMBER;
        hash = (53 * hash) + getUpdateMask().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .UpdateConnectionRequest
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .UpdateConnectionRequest
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .UpdateConnectionRequest
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .UpdateConnectionRequest
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .UpdateConnectionRequest
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .UpdateConnectionRequest
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .UpdateConnectionRequest
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .UpdateConnectionRequest
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .UpdateConnectionRequest
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .UpdateConnectionRequest
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .UpdateConnectionRequest
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .UpdateConnectionRequest
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.UpdateConnectionRequest
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The request for
     * [ConnectionService.UpdateConnection][google.cloud.bigquery.connection.v1beta1.ConnectionService.UpdateConnection].
     * </pre>
     *
     * Protobuf type {@code google.cloud.bigquery.connection.v1beta1.UpdateConnectionRequest}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.connection.v1beta1.UpdateConnectionRequest)
        com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .UpdateConnectionRequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .internal_static_google_cloud_bigquery_connection_v1beta1_UpdateConnectionRequest_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .internal_static_google_cloud_bigquery_connection_v1beta1_UpdateConnectionRequest_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.UpdateConnectionRequest
                    .class,
                com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.UpdateConnectionRequest
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.UpdateConnectionRequest.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        name_ = "";
        connection_ = null;
        if (connectionBuilder_ != null) {
          connectionBuilder_.dispose();
          connectionBuilder_ = null;
        }
        updateMask_ = null;
        if (updateMaskBuilder_ != null) {
          updateMaskBuilder_.dispose();
          updateMaskBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .internal_static_google_cloud_bigquery_connection_v1beta1_UpdateConnectionRequest_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.UpdateConnectionRequest
          getDefaultInstanceForType() {
        return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.UpdateConnectionRequest
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.UpdateConnectionRequest
          build() {
        com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.UpdateConnectionRequest
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.UpdateConnectionRequest
          buildPartial() {
        com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.UpdateConnectionRequest
            result =
                new com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
                    .UpdateConnectionRequest(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.UpdateConnectionRequest
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.name_ = name_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.connection_ =
              connectionBuilder_ == null ? connection_ : connectionBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.updateMask_ =
              updateMaskBuilder_ == null ? updateMask_ : updateMaskBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.UpdateConnectionRequest) {
          return mergeFrom(
              (com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.UpdateConnectionRequest)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.UpdateConnectionRequest
              other) {
        if (other
            == com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.UpdateConnectionRequest
                .getDefaultInstance()) return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.hasConnection()) {
          mergeConnection(other.getConnection());
        }
        if (other.hasUpdateMask()) {
          mergeUpdateMask(other.getUpdateMask());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  name_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getConnectionFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(getUpdateMaskFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * Required. Name of the connection to update, for example:
       * `projects/{project_id}/locations/{location_id}/connections/{connection_id}`
       * </pre>
       *
       * <code>
       * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Name of the connection to update, for example:
       * `projects/{project_id}/locations/{location_id}/connections/{connection_id}`
       * </pre>
       *
       * <code>
       * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Name of the connection to update, for example:
       * `projects/{project_id}/locations/{location_id}/connections/{connection_id}`
       * </pre>
       *
       * <code>
       * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Name of the connection to update, for example:
       * `projects/{project_id}/locations/{location_id}/connections/{connection_id}`
       * </pre>
       *
       * <code>
       * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {
        name_ = getDefaultInstance().getName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Name of the connection to update, for example:
       * `projects/{project_id}/locations/{location_id}/connections/{connection_id}`
       * </pre>
       *
       * <code>
       * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection connection_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection,
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection.Builder,
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionOrBuilder>
          connectionBuilder_;
      /**
       *
       *
       * <pre>
       * Required. Connection containing the updated fields.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.connection.v1beta1.Connection connection = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the connection field is set.
       */
      public boolean hasConnection() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Required. Connection containing the updated fields.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.connection.v1beta1.Connection connection = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The connection.
       */
      public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection
          getConnection() {
        if (connectionBuilder_ == null) {
          return connection_ == null
              ? com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection
                  .getDefaultInstance()
              : connection_;
        } else {
          return connectionBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Connection containing the updated fields.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.connection.v1beta1.Connection connection = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setConnection(
          com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection value) {
        if (connectionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          connection_ = value;
        } else {
          connectionBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Connection containing the updated fields.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.connection.v1beta1.Connection connection = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setConnection(
          com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection.Builder
              builderForValue) {
        if (connectionBuilder_ == null) {
          connection_ = builderForValue.build();
        } else {
          connectionBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Connection containing the updated fields.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.connection.v1beta1.Connection connection = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergeConnection(
          com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection value) {
        if (connectionBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && connection_ != null
              && connection_
                  != com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection
                      .getDefaultInstance()) {
            getConnectionBuilder().mergeFrom(value);
          } else {
            connection_ = value;
          }
        } else {
          connectionBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Connection containing the updated fields.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.connection.v1beta1.Connection connection = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearConnection() {
        bitField0_ = (bitField0_ & ~0x00000002);
        connection_ = null;
        if (connectionBuilder_ != null) {
          connectionBuilder_.dispose();
          connectionBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Connection containing the updated fields.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.connection.v1beta1.Connection connection = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection.Builder
          getConnectionBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getConnectionFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Required. Connection containing the updated fields.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.connection.v1beta1.Connection connection = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionOrBuilder
          getConnectionOrBuilder() {
        if (connectionBuilder_ != null) {
          return connectionBuilder_.getMessageOrBuilder();
        } else {
          return connection_ == null
              ? com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection
                  .getDefaultInstance()
              : connection_;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Connection containing the updated fields.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.connection.v1beta1.Connection connection = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection,
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection.Builder,
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionOrBuilder>
          getConnectionFieldBuilder() {
        if (connectionBuilder_ == null) {
          connectionBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection,
                  com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection.Builder,
                  com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionOrBuilder>(
                  getConnection(), getParentForChildren(), isClean());
          connection_ = null;
        }
        return connectionBuilder_;
      }

      private com.google.protobuf.FieldMask updateMask_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.FieldMask,
              com.google.protobuf.FieldMask.Builder,
              com.google.protobuf.FieldMaskOrBuilder>
          updateMaskBuilder_;
      /**
       *
       *
       * <pre>
       * Required. Update mask for the connection fields to be updated.
       * </pre>
       *
       * <code>.google.protobuf.FieldMask update_mask = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the updateMask field is set.
       */
      public boolean hasUpdateMask() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * Required. Update mask for the connection fields to be updated.
       * </pre>
       *
       * <code>.google.protobuf.FieldMask update_mask = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The updateMask.
       */
      public com.google.protobuf.FieldMask getUpdateMask() {
        if (updateMaskBuilder_ == null) {
          return updateMask_ == null
              ? com.google.protobuf.FieldMask.getDefaultInstance()
              : updateMask_;
        } else {
          return updateMaskBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Update mask for the connection fields to be updated.
       * </pre>
       *
       * <code>.google.protobuf.FieldMask update_mask = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setUpdateMask(com.google.protobuf.FieldMask value) {
        if (updateMaskBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          updateMask_ = value;
        } else {
          updateMaskBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Update mask for the connection fields to be updated.
       * </pre>
       *
       * <code>.google.protobuf.FieldMask update_mask = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setUpdateMask(com.google.protobuf.FieldMask.Builder builderForValue) {
        if (updateMaskBuilder_ == null) {
          updateMask_ = builderForValue.build();
        } else {
          updateMaskBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Update mask for the connection fields to be updated.
       * </pre>
       *
       * <code>.google.protobuf.FieldMask update_mask = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergeUpdateMask(com.google.protobuf.FieldMask value) {
        if (updateMaskBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && updateMask_ != null
              && updateMask_ != com.google.protobuf.FieldMask.getDefaultInstance()) {
            getUpdateMaskBuilder().mergeFrom(value);
          } else {
            updateMask_ = value;
          }
        } else {
          updateMaskBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Update mask for the connection fields to be updated.
       * </pre>
       *
       * <code>.google.protobuf.FieldMask update_mask = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearUpdateMask() {
        bitField0_ = (bitField0_ & ~0x00000004);
        updateMask_ = null;
        if (updateMaskBuilder_ != null) {
          updateMaskBuilder_.dispose();
          updateMaskBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Update mask for the connection fields to be updated.
       * </pre>
       *
       * <code>.google.protobuf.FieldMask update_mask = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.protobuf.FieldMask.Builder getUpdateMaskBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getUpdateMaskFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Required. Update mask for the connection fields to be updated.
       * </pre>
       *
       * <code>.google.protobuf.FieldMask update_mask = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.protobuf.FieldMaskOrBuilder getUpdateMaskOrBuilder() {
        if (updateMaskBuilder_ != null) {
          return updateMaskBuilder_.getMessageOrBuilder();
        } else {
          return updateMask_ == null
              ? com.google.protobuf.FieldMask.getDefaultInstance()
              : updateMask_;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Update mask for the connection fields to be updated.
       * </pre>
       *
       * <code>.google.protobuf.FieldMask update_mask = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.FieldMask,
              com.google.protobuf.FieldMask.Builder,
              com.google.protobuf.FieldMaskOrBuilder>
          getUpdateMaskFieldBuilder() {
        if (updateMaskBuilder_ == null) {
          updateMaskBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.FieldMask,
                  com.google.protobuf.FieldMask.Builder,
                  com.google.protobuf.FieldMaskOrBuilder>(
                  getUpdateMask(), getParentForChildren(), isClean());
          updateMask_ = null;
        }
        return updateMaskBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.connection.v1beta1.UpdateConnectionRequest)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.bigquery.connection.v1beta1.UpdateConnectionRequest)
    private static final com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .UpdateConnectionRequest
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
              .UpdateConnectionRequest();
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .UpdateConnectionRequest
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<UpdateConnectionRequest> PARSER =
        new com.google.protobuf.AbstractParser<UpdateConnectionRequest>() {
          @java.lang.Override
          public UpdateConnectionRequest parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<UpdateConnectionRequest> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<UpdateConnectionRequest> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.UpdateConnectionRequest
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface UpdateConnectionCredentialRequestOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.connection.v1beta1.UpdateConnectionCredentialRequest)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Name of the connection, for example:
     * `projects/{project_id}/locations/{location_id}/connections/{connection_id}/credential`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    java.lang.String getName();
    /**
     *
     *
     * <pre>
     * Required. Name of the connection, for example:
     * `projects/{project_id}/locations/{location_id}/connections/{connection_id}/credential`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();

    /**
     *
     *
     * <pre>
     * Required. Credential to use with the connection.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.connection.v1beta1.ConnectionCredential credential = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the credential field is set.
     */
    boolean hasCredential();
    /**
     *
     *
     * <pre>
     * Required. Credential to use with the connection.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.connection.v1beta1.ConnectionCredential credential = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The credential.
     */
    com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionCredential
        getCredential();
    /**
     *
     *
     * <pre>
     * Required. Credential to use with the connection.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.connection.v1beta1.ConnectionCredential credential = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionCredentialOrBuilder
        getCredentialOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * The request for
   * [ConnectionService.UpdateConnectionCredential][google.cloud.bigquery.connection.v1beta1.ConnectionService.UpdateConnectionCredential].
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.bigquery.connection.v1beta1.UpdateConnectionCredentialRequest}
   */
  public static final class UpdateConnectionCredentialRequest
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.bigquery.connection.v1beta1.UpdateConnectionCredentialRequest)
      UpdateConnectionCredentialRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use UpdateConnectionCredentialRequest.newBuilder() to construct.
    private UpdateConnectionCredentialRequest(
        com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private UpdateConnectionCredentialRequest() {
      name_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new UpdateConnectionCredentialRequest();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
          .internal_static_google_cloud_bigquery_connection_v1beta1_UpdateConnectionCredentialRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
          .internal_static_google_cloud_bigquery_connection_v1beta1_UpdateConnectionCredentialRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
                  .UpdateConnectionCredentialRequest.class,
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
                  .UpdateConnectionCredentialRequest.Builder.class);
    }

    public static final int NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. Name of the connection, for example:
     * `projects/{project_id}/locations/{location_id}/connections/{connection_id}/credential`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the connection, for example:
     * `projects/{project_id}/locations/{location_id}/connections/{connection_id}/credential`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CREDENTIAL_FIELD_NUMBER = 2;
    private com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionCredential
        credential_;
    /**
     *
     *
     * <pre>
     * Required. Credential to use with the connection.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.connection.v1beta1.ConnectionCredential credential = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the credential field is set.
     */
    @java.lang.Override
    public boolean hasCredential() {
      return credential_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. Credential to use with the connection.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.connection.v1beta1.ConnectionCredential credential = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The credential.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionCredential
        getCredential() {
      return credential_ == null
          ? com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionCredential
              .getDefaultInstance()
          : credential_;
    }
    /**
     *
     *
     * <pre>
     * Required. Credential to use with the connection.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.connection.v1beta1.ConnectionCredential credential = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .ConnectionCredentialOrBuilder
        getCredentialOrBuilder() {
      return credential_ == null
          ? com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionCredential
              .getDefaultInstance()
          : credential_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
      }
      if (credential_ != null) {
        output.writeMessage(2, getCredential());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
      }
      if (credential_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCredential());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
              .UpdateConnectionCredentialRequest)) {
        return super.equals(obj);
      }
      com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.UpdateConnectionCredentialRequest
          other =
              (com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
                      .UpdateConnectionCredentialRequest)
                  obj;

      if (!getName().equals(other.getName())) return false;
      if (hasCredential() != other.hasCredential()) return false;
      if (hasCredential()) {
        if (!getCredential().equals(other.getCredential())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      if (hasCredential()) {
        hash = (37 * hash) + CREDENTIAL_FIELD_NUMBER;
        hash = (53 * hash) + getCredential().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .UpdateConnectionCredentialRequest
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .UpdateConnectionCredentialRequest
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .UpdateConnectionCredentialRequest
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .UpdateConnectionCredentialRequest
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .UpdateConnectionCredentialRequest
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .UpdateConnectionCredentialRequest
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .UpdateConnectionCredentialRequest
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .UpdateConnectionCredentialRequest
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .UpdateConnectionCredentialRequest
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .UpdateConnectionCredentialRequest
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .UpdateConnectionCredentialRequest
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .UpdateConnectionCredentialRequest
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
                .UpdateConnectionCredentialRequest
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The request for
     * [ConnectionService.UpdateConnectionCredential][google.cloud.bigquery.connection.v1beta1.ConnectionService.UpdateConnectionCredential].
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.bigquery.connection.v1beta1.UpdateConnectionCredentialRequest}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.connection.v1beta1.UpdateConnectionCredentialRequest)
        com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .UpdateConnectionCredentialRequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .internal_static_google_cloud_bigquery_connection_v1beta1_UpdateConnectionCredentialRequest_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .internal_static_google_cloud_bigquery_connection_v1beta1_UpdateConnectionCredentialRequest_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
                    .UpdateConnectionCredentialRequest.class,
                com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
                    .UpdateConnectionCredentialRequest.Builder.class);
      }

      // Construct using
      // com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.UpdateConnectionCredentialRequest.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        name_ = "";
        credential_ = null;
        if (credentialBuilder_ != null) {
          credentialBuilder_.dispose();
          credentialBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .internal_static_google_cloud_bigquery_connection_v1beta1_UpdateConnectionCredentialRequest_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
              .UpdateConnectionCredentialRequest
          getDefaultInstanceForType() {
        return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .UpdateConnectionCredentialRequest.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
              .UpdateConnectionCredentialRequest
          build() {
        com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
                .UpdateConnectionCredentialRequest
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
              .UpdateConnectionCredentialRequest
          buildPartial() {
        com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
                .UpdateConnectionCredentialRequest
            result =
                new com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
                    .UpdateConnectionCredentialRequest(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
                  .UpdateConnectionCredentialRequest
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.name_ = name_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.credential_ =
              credentialBuilder_ == null ? credential_ : credentialBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
                .UpdateConnectionCredentialRequest) {
          return mergeFrom(
              (com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
                      .UpdateConnectionCredentialRequest)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
                  .UpdateConnectionCredentialRequest
              other) {
        if (other
            == com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
                .UpdateConnectionCredentialRequest.getDefaultInstance()) return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.hasCredential()) {
          mergeCredential(other.getCredential());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  name_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getCredentialFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * Required. Name of the connection, for example:
       * `projects/{project_id}/locations/{location_id}/connections/{connection_id}/credential`
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Name of the connection, for example:
       * `projects/{project_id}/locations/{location_id}/connections/{connection_id}/credential`
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Name of the connection, for example:
       * `projects/{project_id}/locations/{location_id}/connections/{connection_id}/credential`
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Name of the connection, for example:
       * `projects/{project_id}/locations/{location_id}/connections/{connection_id}/credential`
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {
        name_ = getDefaultInstance().getName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Name of the connection, for example:
       * `projects/{project_id}/locations/{location_id}/connections/{connection_id}/credential`
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionCredential
          credential_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionCredential,
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionCredential
                  .Builder,
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
                  .ConnectionCredentialOrBuilder>
          credentialBuilder_;
      /**
       *
       *
       * <pre>
       * Required. Credential to use with the connection.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.connection.v1beta1.ConnectionCredential credential = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the credential field is set.
       */
      public boolean hasCredential() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Required. Credential to use with the connection.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.connection.v1beta1.ConnectionCredential credential = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The credential.
       */
      public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionCredential
          getCredential() {
        if (credentialBuilder_ == null) {
          return credential_ == null
              ? com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionCredential
                  .getDefaultInstance()
              : credential_;
        } else {
          return credentialBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Credential to use with the connection.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.connection.v1beta1.ConnectionCredential credential = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setCredential(
          com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionCredential value) {
        if (credentialBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          credential_ = value;
        } else {
          credentialBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Credential to use with the connection.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.connection.v1beta1.ConnectionCredential credential = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setCredential(
          com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionCredential.Builder
              builderForValue) {
        if (credentialBuilder_ == null) {
          credential_ = builderForValue.build();
        } else {
          credentialBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Credential to use with the connection.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.connection.v1beta1.ConnectionCredential credential = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergeCredential(
          com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionCredential value) {
        if (credentialBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && credential_ != null
              && credential_
                  != com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
                      .ConnectionCredential.getDefaultInstance()) {
            getCredentialBuilder().mergeFrom(value);
          } else {
            credential_ = value;
          }
        } else {
          credentialBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Credential to use with the connection.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.connection.v1beta1.ConnectionCredential credential = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearCredential() {
        bitField0_ = (bitField0_ & ~0x00000002);
        credential_ = null;
        if (credentialBuilder_ != null) {
          credentialBuilder_.dispose();
          credentialBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Credential to use with the connection.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.connection.v1beta1.ConnectionCredential credential = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionCredential
              .Builder
          getCredentialBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getCredentialFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Required. Credential to use with the connection.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.connection.v1beta1.ConnectionCredential credential = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
              .ConnectionCredentialOrBuilder
          getCredentialOrBuilder() {
        if (credentialBuilder_ != null) {
          return credentialBuilder_.getMessageOrBuilder();
        } else {
          return credential_ == null
              ? com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionCredential
                  .getDefaultInstance()
              : credential_;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Credential to use with the connection.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.connection.v1beta1.ConnectionCredential credential = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionCredential,
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionCredential
                  .Builder,
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
                  .ConnectionCredentialOrBuilder>
          getCredentialFieldBuilder() {
        if (credentialBuilder_ == null) {
          credentialBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionCredential,
                  com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionCredential
                      .Builder,
                  com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
                      .ConnectionCredentialOrBuilder>(
                  getCredential(), getParentForChildren(), isClean());
          credential_ = null;
        }
        return credentialBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.connection.v1beta1.UpdateConnectionCredentialRequest)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.bigquery.connection.v1beta1.UpdateConnectionCredentialRequest)
    private static final com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .UpdateConnectionCredentialRequest
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
              .UpdateConnectionCredentialRequest();
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .UpdateConnectionCredentialRequest
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<UpdateConnectionCredentialRequest> PARSER =
        new com.google.protobuf.AbstractParser<UpdateConnectionCredentialRequest>() {
          @java.lang.Override
          public UpdateConnectionCredentialRequest parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<UpdateConnectionCredentialRequest> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<UpdateConnectionCredentialRequest> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .UpdateConnectionCredentialRequest
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DeleteConnectionRequestOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.connection.v1beta1.DeleteConnectionRequest)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Name of the deleted connection, for example:
     * `projects/{project_id}/locations/{location_id}/connections/{connection_id}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    java.lang.String getName();
    /**
     *
     *
     * <pre>
     * Required. Name of the deleted connection, for example:
     * `projects/{project_id}/locations/{location_id}/connections/{connection_id}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();
  }
  /**
   *
   *
   * <pre>
   * The request for [ConnectionService.DeleteConnectionRequest][].
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.connection.v1beta1.DeleteConnectionRequest}
   */
  public static final class DeleteConnectionRequest extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.bigquery.connection.v1beta1.DeleteConnectionRequest)
      DeleteConnectionRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use DeleteConnectionRequest.newBuilder() to construct.
    private DeleteConnectionRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DeleteConnectionRequest() {
      name_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new DeleteConnectionRequest();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
          .internal_static_google_cloud_bigquery_connection_v1beta1_DeleteConnectionRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
          .internal_static_google_cloud_bigquery_connection_v1beta1_DeleteConnectionRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.DeleteConnectionRequest
                  .class,
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.DeleteConnectionRequest
                  .Builder.class);
    }

    public static final int NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. Name of the deleted connection, for example:
     * `projects/{project_id}/locations/{location_id}/connections/{connection_id}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the deleted connection, for example:
     * `projects/{project_id}/locations/{location_id}/connections/{connection_id}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.DeleteConnectionRequest)) {
        return super.equals(obj);
      }
      com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.DeleteConnectionRequest other =
          (com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.DeleteConnectionRequest)
              obj;

      if (!getName().equals(other.getName())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .DeleteConnectionRequest
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .DeleteConnectionRequest
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .DeleteConnectionRequest
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .DeleteConnectionRequest
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .DeleteConnectionRequest
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .DeleteConnectionRequest
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .DeleteConnectionRequest
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .DeleteConnectionRequest
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .DeleteConnectionRequest
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .DeleteConnectionRequest
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .DeleteConnectionRequest
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .DeleteConnectionRequest
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.DeleteConnectionRequest
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The request for [ConnectionService.DeleteConnectionRequest][].
     * </pre>
     *
     * Protobuf type {@code google.cloud.bigquery.connection.v1beta1.DeleteConnectionRequest}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.connection.v1beta1.DeleteConnectionRequest)
        com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .DeleteConnectionRequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .internal_static_google_cloud_bigquery_connection_v1beta1_DeleteConnectionRequest_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .internal_static_google_cloud_bigquery_connection_v1beta1_DeleteConnectionRequest_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.DeleteConnectionRequest
                    .class,
                com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.DeleteConnectionRequest
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.DeleteConnectionRequest.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        name_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .internal_static_google_cloud_bigquery_connection_v1beta1_DeleteConnectionRequest_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.DeleteConnectionRequest
          getDefaultInstanceForType() {
        return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.DeleteConnectionRequest
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.DeleteConnectionRequest
          build() {
        com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.DeleteConnectionRequest
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.DeleteConnectionRequest
          buildPartial() {
        com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.DeleteConnectionRequest
            result =
                new com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
                    .DeleteConnectionRequest(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.DeleteConnectionRequest
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.name_ = name_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.DeleteConnectionRequest) {
          return mergeFrom(
              (com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.DeleteConnectionRequest)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.DeleteConnectionRequest
              other) {
        if (other
            == com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.DeleteConnectionRequest
                .getDefaultInstance()) return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  name_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * Required. Name of the deleted connection, for example:
       * `projects/{project_id}/locations/{location_id}/connections/{connection_id}`
       * </pre>
       *
       * <code>
       * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Name of the deleted connection, for example:
       * `projects/{project_id}/locations/{location_id}/connections/{connection_id}`
       * </pre>
       *
       * <code>
       * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Name of the deleted connection, for example:
       * `projects/{project_id}/locations/{location_id}/connections/{connection_id}`
       * </pre>
       *
       * <code>
       * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Name of the deleted connection, for example:
       * `projects/{project_id}/locations/{location_id}/connections/{connection_id}`
       * </pre>
       *
       * <code>
       * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {
        name_ = getDefaultInstance().getName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Name of the deleted connection, for example:
       * `projects/{project_id}/locations/{location_id}/connections/{connection_id}`
       * </pre>
       *
       * <code>
       * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.connection.v1beta1.DeleteConnectionRequest)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.bigquery.connection.v1beta1.DeleteConnectionRequest)
    private static final com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .DeleteConnectionRequest
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
              .DeleteConnectionRequest();
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .DeleteConnectionRequest
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DeleteConnectionRequest> PARSER =
        new com.google.protobuf.AbstractParser<DeleteConnectionRequest>() {
          @java.lang.Override
          public DeleteConnectionRequest parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<DeleteConnectionRequest> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DeleteConnectionRequest> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.DeleteConnectionRequest
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ConnectionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.connection.v1beta1.Connection)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The resource name of the connection in the form of:
     * `projects/{project_id}/locations/{location_id}/connections/{connection_id}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    java.lang.String getName();
    /**
     *
     *
     * <pre>
     * The resource name of the connection in the form of:
     * `projects/{project_id}/locations/{location_id}/connections/{connection_id}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();

    /**
     *
     *
     * <pre>
     * User provided display name for the connection.
     * </pre>
     *
     * <code>string friendly_name = 2;</code>
     *
     * @return The friendlyName.
     */
    java.lang.String getFriendlyName();
    /**
     *
     *
     * <pre>
     * User provided display name for the connection.
     * </pre>
     *
     * <code>string friendly_name = 2;</code>
     *
     * @return The bytes for friendlyName.
     */
    com.google.protobuf.ByteString getFriendlyNameBytes();

    /**
     *
     *
     * <pre>
     * User provided description.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The description.
     */
    java.lang.String getDescription();
    /**
     *
     *
     * <pre>
     * User provided description.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The bytes for description.
     */
    com.google.protobuf.ByteString getDescriptionBytes();

    /**
     *
     *
     * <pre>
     * Cloud SQL properties.
     * </pre>
     *
     * <code>.google.cloud.bigquery.connection.v1beta1.CloudSqlProperties cloud_sql = 4;</code>
     *
     * @return Whether the cloudSql field is set.
     */
    boolean hasCloudSql();
    /**
     *
     *
     * <pre>
     * Cloud SQL properties.
     * </pre>
     *
     * <code>.google.cloud.bigquery.connection.v1beta1.CloudSqlProperties cloud_sql = 4;</code>
     *
     * @return The cloudSql.
     */
    com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties getCloudSql();
    /**
     *
     *
     * <pre>
     * Cloud SQL properties.
     * </pre>
     *
     * <code>.google.cloud.bigquery.connection.v1beta1.CloudSqlProperties cloud_sql = 4;</code>
     */
    com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlPropertiesOrBuilder
        getCloudSqlOrBuilder();

    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of the connection.
     * </pre>
     *
     * <code>int64 creation_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The creationTime.
     */
    long getCreationTime();

    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of the connection.
     * </pre>
     *
     * <code>int64 last_modified_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The lastModifiedTime.
     */
    long getLastModifiedTime();

    /**
     *
     *
     * <pre>
     * Output only. True, if credential is configured for this connection.
     * </pre>
     *
     * <code>bool has_credential = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The hasCredential.
     */
    boolean getHasCredential();

    com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection.PropertiesCase
        getPropertiesCase();
  }
  /**
   *
   *
   * <pre>
   * Configuration parameters to establish connection with an external data
   * source, except the credential attributes.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.connection.v1beta1.Connection}
   */
  public static final class Connection extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.bigquery.connection.v1beta1.Connection)
      ConnectionOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Connection.newBuilder() to construct.
    private Connection(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Connection() {
      name_ = "";
      friendlyName_ = "";
      description_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Connection();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
          .internal_static_google_cloud_bigquery_connection_v1beta1_Connection_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
          .internal_static_google_cloud_bigquery_connection_v1beta1_Connection_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection.class,
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection.Builder
                  .class);
    }

    private int propertiesCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object properties_;

    public enum PropertiesCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      CLOUD_SQL(4),
      PROPERTIES_NOT_SET(0);
      private final int value;

      private PropertiesCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static PropertiesCase valueOf(int value) {
        return forNumber(value);
      }

      public static PropertiesCase forNumber(int value) {
        switch (value) {
          case 4:
            return CLOUD_SQL;
          case 0:
            return PROPERTIES_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public PropertiesCase getPropertiesCase() {
      return PropertiesCase.forNumber(propertiesCase_);
    }

    public static final int NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The resource name of the connection in the form of:
     * `projects/{project_id}/locations/{location_id}/connections/{connection_id}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the connection in the form of:
     * `projects/{project_id}/locations/{location_id}/connections/{connection_id}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int FRIENDLY_NAME_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object friendlyName_ = "";
    /**
     *
     *
     * <pre>
     * User provided display name for the connection.
     * </pre>
     *
     * <code>string friendly_name = 2;</code>
     *
     * @return The friendlyName.
     */
    @java.lang.Override
    public java.lang.String getFriendlyName() {
      java.lang.Object ref = friendlyName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        friendlyName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * User provided display name for the connection.
     * </pre>
     *
     * <code>string friendly_name = 2;</code>
     *
     * @return The bytes for friendlyName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getFriendlyNameBytes() {
      java.lang.Object ref = friendlyName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        friendlyName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DESCRIPTION_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * User provided description.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The description.
     */
    @java.lang.Override
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * User provided description.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The bytes for description.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CLOUD_SQL_FIELD_NUMBER = 4;
    /**
     *
     *
     * <pre>
     * Cloud SQL properties.
     * </pre>
     *
     * <code>.google.cloud.bigquery.connection.v1beta1.CloudSqlProperties cloud_sql = 4;</code>
     *
     * @return Whether the cloudSql field is set.
     */
    @java.lang.Override
    public boolean hasCloudSql() {
      return propertiesCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Cloud SQL properties.
     * </pre>
     *
     * <code>.google.cloud.bigquery.connection.v1beta1.CloudSqlProperties cloud_sql = 4;</code>
     *
     * @return The cloudSql.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties
        getCloudSql() {
      if (propertiesCase_ == 4) {
        return (com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties)
            properties_;
      }
      return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties
          .getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Cloud SQL properties.
     * </pre>
     *
     * <code>.google.cloud.bigquery.connection.v1beta1.CloudSqlProperties cloud_sql = 4;</code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlPropertiesOrBuilder
        getCloudSqlOrBuilder() {
      if (propertiesCase_ == 4) {
        return (com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties)
            properties_;
      }
      return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties
          .getDefaultInstance();
    }

    public static final int CREATION_TIME_FIELD_NUMBER = 5;
    private long creationTime_ = 0L;
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of the connection.
     * </pre>
     *
     * <code>int64 creation_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The creationTime.
     */
    @java.lang.Override
    public long getCreationTime() {
      return creationTime_;
    }

    public static final int LAST_MODIFIED_TIME_FIELD_NUMBER = 6;
    private long lastModifiedTime_ = 0L;
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of the connection.
     * </pre>
     *
     * <code>int64 last_modified_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The lastModifiedTime.
     */
    @java.lang.Override
    public long getLastModifiedTime() {
      return lastModifiedTime_;
    }

    public static final int HAS_CREDENTIAL_FIELD_NUMBER = 7;
    private boolean hasCredential_ = false;
    /**
     *
     *
     * <pre>
     * Output only. True, if credential is configured for this connection.
     * </pre>
     *
     * <code>bool has_credential = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The hasCredential.
     */
    @java.lang.Override
    public boolean getHasCredential() {
      return hasCredential_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(friendlyName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, friendlyName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, description_);
      }
      if (propertiesCase_ == 4) {
        output.writeMessage(
            4,
            (com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties)
                properties_);
      }
      if (creationTime_ != 0L) {
        output.writeInt64(5, creationTime_);
      }
      if (lastModifiedTime_ != 0L) {
        output.writeInt64(6, lastModifiedTime_);
      }
      if (hasCredential_ != false) {
        output.writeBool(7, hasCredential_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(friendlyName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, friendlyName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, description_);
      }
      if (propertiesCase_ == 4) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                4,
                (com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties)
                    properties_);
      }
      if (creationTime_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(5, creationTime_);
      }
      if (lastModifiedTime_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(6, lastModifiedTime_);
      }
      if (hasCredential_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(7, hasCredential_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection)) {
        return super.equals(obj);
      }
      com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection other =
          (com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection) obj;

      if (!getName().equals(other.getName())) return false;
      if (!getFriendlyName().equals(other.getFriendlyName())) return false;
      if (!getDescription().equals(other.getDescription())) return false;
      if (getCreationTime() != other.getCreationTime()) return false;
      if (getLastModifiedTime() != other.getLastModifiedTime()) return false;
      if (getHasCredential() != other.getHasCredential()) return false;
      if (!getPropertiesCase().equals(other.getPropertiesCase())) return false;
      switch (propertiesCase_) {
        case 4:
          if (!getCloudSql().equals(other.getCloudSql())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      hash = (37 * hash) + FRIENDLY_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getFriendlyName().hashCode();
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
      hash = (37 * hash) + CREATION_TIME_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getCreationTime());
      hash = (37 * hash) + LAST_MODIFIED_TIME_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getLastModifiedTime());
      hash = (37 * hash) + HAS_CREDENTIAL_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getHasCredential());
      switch (propertiesCase_) {
        case 4:
          hash = (37 * hash) + CLOUD_SQL_FIELD_NUMBER;
          hash = (53 * hash) + getCloudSql().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Configuration parameters to establish connection with an external data
     * source, except the credential attributes.
     * </pre>
     *
     * Protobuf type {@code google.cloud.bigquery.connection.v1beta1.Connection}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.connection.v1beta1.Connection)
        com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .internal_static_google_cloud_bigquery_connection_v1beta1_Connection_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .internal_static_google_cloud_bigquery_connection_v1beta1_Connection_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection.class,
                com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        name_ = "";
        friendlyName_ = "";
        description_ = "";
        if (cloudSqlBuilder_ != null) {
          cloudSqlBuilder_.clear();
        }
        creationTime_ = 0L;
        lastModifiedTime_ = 0L;
        hasCredential_ = false;
        propertiesCase_ = 0;
        properties_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .internal_static_google_cloud_bigquery_connection_v1beta1_Connection_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection
          getDefaultInstanceForType() {
        return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection build() {
        com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection
          buildPartial() {
        com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection result =
            new com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.name_ = name_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.friendlyName_ = friendlyName_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.description_ = description_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.creationTime_ = creationTime_;
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.lastModifiedTime_ = lastModifiedTime_;
        }
        if (((from_bitField0_ & 0x00000040) != 0)) {
          result.hasCredential_ = hasCredential_;
        }
      }

      private void buildPartialOneofs(
          com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection result) {
        result.propertiesCase_ = propertiesCase_;
        result.properties_ = this.properties_;
        if (propertiesCase_ == 4 && cloudSqlBuilder_ != null) {
          result.properties_ = cloudSqlBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection) {
          return mergeFrom(
              (com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection other) {
        if (other
            == com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection
                .getDefaultInstance()) return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getFriendlyName().isEmpty()) {
          friendlyName_ = other.friendlyName_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getDescription().isEmpty()) {
          description_ = other.description_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (other.getCreationTime() != 0L) {
          setCreationTime(other.getCreationTime());
        }
        if (other.getLastModifiedTime() != 0L) {
          setLastModifiedTime(other.getLastModifiedTime());
        }
        if (other.getHasCredential() != false) {
          setHasCredential(other.getHasCredential());
        }
        switch (other.getPropertiesCase()) {
          case CLOUD_SQL:
            {
              mergeCloudSql(other.getCloudSql());
              break;
            }
          case PROPERTIES_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  name_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  friendlyName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  description_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  input.readMessage(getCloudSqlFieldBuilder().getBuilder(), extensionRegistry);
                  propertiesCase_ = 4;
                  break;
                } // case 34
              case 40:
                {
                  creationTime_ = input.readInt64();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 40
              case 48:
                {
                  lastModifiedTime_ = input.readInt64();
                  bitField0_ |= 0x00000020;
                  break;
                } // case 48
              case 56:
                {
                  hasCredential_ = input.readBool();
                  bitField0_ |= 0x00000040;
                  break;
                } // case 56
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int propertiesCase_ = 0;
      private java.lang.Object properties_;

      public PropertiesCase getPropertiesCase() {
        return PropertiesCase.forNumber(propertiesCase_);
      }

      public Builder clearProperties() {
        propertiesCase_ = 0;
        properties_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * The resource name of the connection in the form of:
       * `projects/{project_id}/locations/{location_id}/connections/{connection_id}`
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The resource name of the connection in the form of:
       * `projects/{project_id}/locations/{location_id}/connections/{connection_id}`
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The resource name of the connection in the form of:
       * `projects/{project_id}/locations/{location_id}/connections/{connection_id}`
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The resource name of the connection in the form of:
       * `projects/{project_id}/locations/{location_id}/connections/{connection_id}`
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {
        name_ = getDefaultInstance().getName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The resource name of the connection in the form of:
       * `projects/{project_id}/locations/{location_id}/connections/{connection_id}`
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object friendlyName_ = "";
      /**
       *
       *
       * <pre>
       * User provided display name for the connection.
       * </pre>
       *
       * <code>string friendly_name = 2;</code>
       *
       * @return The friendlyName.
       */
      public java.lang.String getFriendlyName() {
        java.lang.Object ref = friendlyName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          friendlyName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * User provided display name for the connection.
       * </pre>
       *
       * <code>string friendly_name = 2;</code>
       *
       * @return The bytes for friendlyName.
       */
      public com.google.protobuf.ByteString getFriendlyNameBytes() {
        java.lang.Object ref = friendlyName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          friendlyName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * User provided display name for the connection.
       * </pre>
       *
       * <code>string friendly_name = 2;</code>
       *
       * @param value The friendlyName to set.
       * @return This builder for chaining.
       */
      public Builder setFriendlyName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        friendlyName_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * User provided display name for the connection.
       * </pre>
       *
       * <code>string friendly_name = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFriendlyName() {
        friendlyName_ = getDefaultInstance().getFriendlyName();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * User provided display name for the connection.
       * </pre>
       *
       * <code>string friendly_name = 2;</code>
       *
       * @param value The bytes for friendlyName to set.
       * @return This builder for chaining.
       */
      public Builder setFriendlyNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        friendlyName_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object description_ = "";
      /**
       *
       *
       * <pre>
       * User provided description.
       * </pre>
       *
       * <code>string description = 3;</code>
       *
       * @return The description.
       */
      public java.lang.String getDescription() {
        java.lang.Object ref = description_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          description_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * User provided description.
       * </pre>
       *
       * <code>string description = 3;</code>
       *
       * @return The bytes for description.
       */
      public com.google.protobuf.ByteString getDescriptionBytes() {
        java.lang.Object ref = description_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          description_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * User provided description.
       * </pre>
       *
       * <code>string description = 3;</code>
       *
       * @param value The description to set.
       * @return This builder for chaining.
       */
      public Builder setDescription(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        description_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * User provided description.
       * </pre>
       *
       * <code>string description = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDescription() {
        description_ = getDefaultInstance().getDescription();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * User provided description.
       * </pre>
       *
       * <code>string description = 3;</code>
       *
       * @param value The bytes for description to set.
       * @return This builder for chaining.
       */
      public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        description_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties,
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties
                  .Builder,
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
                  .CloudSqlPropertiesOrBuilder>
          cloudSqlBuilder_;
      /**
       *
       *
       * <pre>
       * Cloud SQL properties.
       * </pre>
       *
       * <code>.google.cloud.bigquery.connection.v1beta1.CloudSqlProperties cloud_sql = 4;</code>
       *
       * @return Whether the cloudSql field is set.
       */
      @java.lang.Override
      public boolean hasCloudSql() {
        return propertiesCase_ == 4;
      }
      /**
       *
       *
       * <pre>
       * Cloud SQL properties.
       * </pre>
       *
       * <code>.google.cloud.bigquery.connection.v1beta1.CloudSqlProperties cloud_sql = 4;</code>
       *
       * @return The cloudSql.
       */
      @java.lang.Override
      public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties
          getCloudSql() {
        if (cloudSqlBuilder_ == null) {
          if (propertiesCase_ == 4) {
            return (com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties)
                properties_;
          }
          return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties
              .getDefaultInstance();
        } else {
          if (propertiesCase_ == 4) {
            return cloudSqlBuilder_.getMessage();
          }
          return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Cloud SQL properties.
       * </pre>
       *
       * <code>.google.cloud.bigquery.connection.v1beta1.CloudSqlProperties cloud_sql = 4;</code>
       */
      public Builder setCloudSql(
          com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties value) {
        if (cloudSqlBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          properties_ = value;
          onChanged();
        } else {
          cloudSqlBuilder_.setMessage(value);
        }
        propertiesCase_ = 4;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Cloud SQL properties.
       * </pre>
       *
       * <code>.google.cloud.bigquery.connection.v1beta1.CloudSqlProperties cloud_sql = 4;</code>
       */
      public Builder setCloudSql(
          com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties.Builder
              builderForValue) {
        if (cloudSqlBuilder_ == null) {
          properties_ = builderForValue.build();
          onChanged();
        } else {
          cloudSqlBuilder_.setMessage(builderForValue.build());
        }
        propertiesCase_ = 4;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Cloud SQL properties.
       * </pre>
       *
       * <code>.google.cloud.bigquery.connection.v1beta1.CloudSqlProperties cloud_sql = 4;</code>
       */
      public Builder mergeCloudSql(
          com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties value) {
        if (cloudSqlBuilder_ == null) {
          if (propertiesCase_ == 4
              && properties_
                  != com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties
                      .getDefaultInstance()) {
            properties_ =
                com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties
                    .newBuilder(
                        (com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
                                .CloudSqlProperties)
                            properties_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            properties_ = value;
          }
          onChanged();
        } else {
          if (propertiesCase_ == 4) {
            cloudSqlBuilder_.mergeFrom(value);
          } else {
            cloudSqlBuilder_.setMessage(value);
          }
        }
        propertiesCase_ = 4;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Cloud SQL properties.
       * </pre>
       *
       * <code>.google.cloud.bigquery.connection.v1beta1.CloudSqlProperties cloud_sql = 4;</code>
       */
      public Builder clearCloudSql() {
        if (cloudSqlBuilder_ == null) {
          if (propertiesCase_ == 4) {
            propertiesCase_ = 0;
            properties_ = null;
            onChanged();
          }
        } else {
          if (propertiesCase_ == 4) {
            propertiesCase_ = 0;
            properties_ = null;
          }
          cloudSqlBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Cloud SQL properties.
       * </pre>
       *
       * <code>.google.cloud.bigquery.connection.v1beta1.CloudSqlProperties cloud_sql = 4;</code>
       */
      public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties.Builder
          getCloudSqlBuilder() {
        return getCloudSqlFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Cloud SQL properties.
       * </pre>
       *
       * <code>.google.cloud.bigquery.connection.v1beta1.CloudSqlProperties cloud_sql = 4;</code>
       */
      @java.lang.Override
      public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
              .CloudSqlPropertiesOrBuilder
          getCloudSqlOrBuilder() {
        if ((propertiesCase_ == 4) && (cloudSqlBuilder_ != null)) {
          return cloudSqlBuilder_.getMessageOrBuilder();
        } else {
          if (propertiesCase_ == 4) {
            return (com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties)
                properties_;
          }
          return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Cloud SQL properties.
       * </pre>
       *
       * <code>.google.cloud.bigquery.connection.v1beta1.CloudSqlProperties cloud_sql = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties,
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties
                  .Builder,
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
                  .CloudSqlPropertiesOrBuilder>
          getCloudSqlFieldBuilder() {
        if (cloudSqlBuilder_ == null) {
          if (!(propertiesCase_ == 4)) {
            properties_ =
                com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties
                    .getDefaultInstance();
          }
          cloudSqlBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties,
                  com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties
                      .Builder,
                  com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
                      .CloudSqlPropertiesOrBuilder>(
                  (com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties)
                      properties_,
                  getParentForChildren(),
                  isClean());
          properties_ = null;
        }
        propertiesCase_ = 4;
        onChanged();
        return cloudSqlBuilder_;
      }

      private long creationTime_;
      /**
       *
       *
       * <pre>
       * Output only. The creation timestamp of the connection.
       * </pre>
       *
       * <code>int64 creation_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The creationTime.
       */
      @java.lang.Override
      public long getCreationTime() {
        return creationTime_;
      }
      /**
       *
       *
       * <pre>
       * Output only. The creation timestamp of the connection.
       * </pre>
       *
       * <code>int64 creation_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The creationTime to set.
       * @return This builder for chaining.
       */
      public Builder setCreationTime(long value) {

        creationTime_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The creation timestamp of the connection.
       * </pre>
       *
       * <code>int64 creation_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCreationTime() {
        bitField0_ = (bitField0_ & ~0x00000010);
        creationTime_ = 0L;
        onChanged();
        return this;
      }

      private long lastModifiedTime_;
      /**
       *
       *
       * <pre>
       * Output only. The last update timestamp of the connection.
       * </pre>
       *
       * <code>int64 last_modified_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The lastModifiedTime.
       */
      @java.lang.Override
      public long getLastModifiedTime() {
        return lastModifiedTime_;
      }
      /**
       *
       *
       * <pre>
       * Output only. The last update timestamp of the connection.
       * </pre>
       *
       * <code>int64 last_modified_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The lastModifiedTime to set.
       * @return This builder for chaining.
       */
      public Builder setLastModifiedTime(long value) {

        lastModifiedTime_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The last update timestamp of the connection.
       * </pre>
       *
       * <code>int64 last_modified_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLastModifiedTime() {
        bitField0_ = (bitField0_ & ~0x00000020);
        lastModifiedTime_ = 0L;
        onChanged();
        return this;
      }

      private boolean hasCredential_;
      /**
       *
       *
       * <pre>
       * Output only. True, if credential is configured for this connection.
       * </pre>
       *
       * <code>bool has_credential = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The hasCredential.
       */
      @java.lang.Override
      public boolean getHasCredential() {
        return hasCredential_;
      }
      /**
       *
       *
       * <pre>
       * Output only. True, if credential is configured for this connection.
       * </pre>
       *
       * <code>bool has_credential = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The hasCredential to set.
       * @return This builder for chaining.
       */
      public Builder setHasCredential(boolean value) {

        hasCredential_ = value;
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. True, if credential is configured for this connection.
       * </pre>
       *
       * <code>bool has_credential = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearHasCredential() {
        bitField0_ = (bitField0_ & ~0x00000040);
        hasCredential_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.connection.v1beta1.Connection)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.bigquery.connection.v1beta1.Connection)
    private static final com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection();
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Connection> PARSER =
        new com.google.protobuf.AbstractParser<Connection>() {
          @java.lang.Override
          public Connection parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Connection> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Connection> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.Connection
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ConnectionCredentialOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.connection.v1beta1.ConnectionCredential)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Credential for Cloud SQL database.
     * </pre>
     *
     * <code>.google.cloud.bigquery.connection.v1beta1.CloudSqlCredential cloud_sql = 1;</code>
     *
     * @return Whether the cloudSql field is set.
     */
    boolean hasCloudSql();
    /**
     *
     *
     * <pre>
     * Credential for Cloud SQL database.
     * </pre>
     *
     * <code>.google.cloud.bigquery.connection.v1beta1.CloudSqlCredential cloud_sql = 1;</code>
     *
     * @return The cloudSql.
     */
    com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential getCloudSql();
    /**
     *
     *
     * <pre>
     * Credential for Cloud SQL database.
     * </pre>
     *
     * <code>.google.cloud.bigquery.connection.v1beta1.CloudSqlCredential cloud_sql = 1;</code>
     */
    com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredentialOrBuilder
        getCloudSqlOrBuilder();

    com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionCredential.CredentialCase
        getCredentialCase();
  }
  /**
   *
   *
   * <pre>
   * Credential to use with a connection.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.connection.v1beta1.ConnectionCredential}
   */
  public static final class ConnectionCredential extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.bigquery.connection.v1beta1.ConnectionCredential)
      ConnectionCredentialOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ConnectionCredential.newBuilder() to construct.
    private ConnectionCredential(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ConnectionCredential() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ConnectionCredential();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
          .internal_static_google_cloud_bigquery_connection_v1beta1_ConnectionCredential_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
          .internal_static_google_cloud_bigquery_connection_v1beta1_ConnectionCredential_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionCredential
                  .class,
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionCredential
                  .Builder.class);
    }

    private int credentialCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object credential_;

    public enum CredentialCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      CLOUD_SQL(1),
      CREDENTIAL_NOT_SET(0);
      private final int value;

      private CredentialCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static CredentialCase valueOf(int value) {
        return forNumber(value);
      }

      public static CredentialCase forNumber(int value) {
        switch (value) {
          case 1:
            return CLOUD_SQL;
          case 0:
            return CREDENTIAL_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public CredentialCase getCredentialCase() {
      return CredentialCase.forNumber(credentialCase_);
    }

    public static final int CLOUD_SQL_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * Credential for Cloud SQL database.
     * </pre>
     *
     * <code>.google.cloud.bigquery.connection.v1beta1.CloudSqlCredential cloud_sql = 1;</code>
     *
     * @return Whether the cloudSql field is set.
     */
    @java.lang.Override
    public boolean hasCloudSql() {
      return credentialCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Credential for Cloud SQL database.
     * </pre>
     *
     * <code>.google.cloud.bigquery.connection.v1beta1.CloudSqlCredential cloud_sql = 1;</code>
     *
     * @return The cloudSql.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential
        getCloudSql() {
      if (credentialCase_ == 1) {
        return (com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential)
            credential_;
      }
      return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential
          .getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Credential for Cloud SQL database.
     * </pre>
     *
     * <code>.google.cloud.bigquery.connection.v1beta1.CloudSqlCredential cloud_sql = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredentialOrBuilder
        getCloudSqlOrBuilder() {
      if (credentialCase_ == 1) {
        return (com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential)
            credential_;
      }
      return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential
          .getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (credentialCase_ == 1) {
        output.writeMessage(
            1,
            (com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential)
                credential_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (credentialCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1,
                (com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential)
                    credential_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionCredential)) {
        return super.equals(obj);
      }
      com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionCredential other =
          (com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionCredential) obj;

      if (!getCredentialCase().equals(other.getCredentialCase())) return false;
      switch (credentialCase_) {
        case 1:
          if (!getCloudSql().equals(other.getCloudSql())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (credentialCase_) {
        case 1:
          hash = (37 * hash) + CLOUD_SQL_FIELD_NUMBER;
          hash = (53 * hash) + getCloudSql().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionCredential
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionCredential
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionCredential
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionCredential
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionCredential
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionCredential
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionCredential
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionCredential
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionCredential
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionCredential
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionCredential
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionCredential
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionCredential
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Credential to use with a connection.
     * </pre>
     *
     * Protobuf type {@code google.cloud.bigquery.connection.v1beta1.ConnectionCredential}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.connection.v1beta1.ConnectionCredential)
        com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionCredentialOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .internal_static_google_cloud_bigquery_connection_v1beta1_ConnectionCredential_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .internal_static_google_cloud_bigquery_connection_v1beta1_ConnectionCredential_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionCredential
                    .class,
                com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionCredential
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionCredential.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (cloudSqlBuilder_ != null) {
          cloudSqlBuilder_.clear();
        }
        credentialCase_ = 0;
        credential_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .internal_static_google_cloud_bigquery_connection_v1beta1_ConnectionCredential_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionCredential
          getDefaultInstanceForType() {
        return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionCredential
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionCredential
          build() {
        com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionCredential result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionCredential
          buildPartial() {
        com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionCredential result =
            new com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionCredential(
                this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionCredential
              result) {
        int from_bitField0_ = bitField0_;
      }

      private void buildPartialOneofs(
          com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionCredential
              result) {
        result.credentialCase_ = credentialCase_;
        result.credential_ = this.credential_;
        if (credentialCase_ == 1 && cloudSqlBuilder_ != null) {
          result.credential_ = cloudSqlBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionCredential) {
          return mergeFrom(
              (com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionCredential)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionCredential other) {
        if (other
            == com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionCredential
                .getDefaultInstance()) return this;
        switch (other.getCredentialCase()) {
          case CLOUD_SQL:
            {
              mergeCloudSql(other.getCloudSql());
              break;
            }
          case CREDENTIAL_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getCloudSqlFieldBuilder().getBuilder(), extensionRegistry);
                  credentialCase_ = 1;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int credentialCase_ = 0;
      private java.lang.Object credential_;

      public CredentialCase getCredentialCase() {
        return CredentialCase.forNumber(credentialCase_);
      }

      public Builder clearCredential() {
        credentialCase_ = 0;
        credential_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential,
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential
                  .Builder,
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
                  .CloudSqlCredentialOrBuilder>
          cloudSqlBuilder_;
      /**
       *
       *
       * <pre>
       * Credential for Cloud SQL database.
       * </pre>
       *
       * <code>.google.cloud.bigquery.connection.v1beta1.CloudSqlCredential cloud_sql = 1;</code>
       *
       * @return Whether the cloudSql field is set.
       */
      @java.lang.Override
      public boolean hasCloudSql() {
        return credentialCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * Credential for Cloud SQL database.
       * </pre>
       *
       * <code>.google.cloud.bigquery.connection.v1beta1.CloudSqlCredential cloud_sql = 1;</code>
       *
       * @return The cloudSql.
       */
      @java.lang.Override
      public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential
          getCloudSql() {
        if (cloudSqlBuilder_ == null) {
          if (credentialCase_ == 1) {
            return (com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential)
                credential_;
          }
          return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential
              .getDefaultInstance();
        } else {
          if (credentialCase_ == 1) {
            return cloudSqlBuilder_.getMessage();
          }
          return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Credential for Cloud SQL database.
       * </pre>
       *
       * <code>.google.cloud.bigquery.connection.v1beta1.CloudSqlCredential cloud_sql = 1;</code>
       */
      public Builder setCloudSql(
          com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential value) {
        if (cloudSqlBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          credential_ = value;
          onChanged();
        } else {
          cloudSqlBuilder_.setMessage(value);
        }
        credentialCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Credential for Cloud SQL database.
       * </pre>
       *
       * <code>.google.cloud.bigquery.connection.v1beta1.CloudSqlCredential cloud_sql = 1;</code>
       */
      public Builder setCloudSql(
          com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential.Builder
              builderForValue) {
        if (cloudSqlBuilder_ == null) {
          credential_ = builderForValue.build();
          onChanged();
        } else {
          cloudSqlBuilder_.setMessage(builderForValue.build());
        }
        credentialCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Credential for Cloud SQL database.
       * </pre>
       *
       * <code>.google.cloud.bigquery.connection.v1beta1.CloudSqlCredential cloud_sql = 1;</code>
       */
      public Builder mergeCloudSql(
          com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential value) {
        if (cloudSqlBuilder_ == null) {
          if (credentialCase_ == 1
              && credential_
                  != com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential
                      .getDefaultInstance()) {
            credential_ =
                com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential
                    .newBuilder(
                        (com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
                                .CloudSqlCredential)
                            credential_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            credential_ = value;
          }
          onChanged();
        } else {
          if (credentialCase_ == 1) {
            cloudSqlBuilder_.mergeFrom(value);
          } else {
            cloudSqlBuilder_.setMessage(value);
          }
        }
        credentialCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Credential for Cloud SQL database.
       * </pre>
       *
       * <code>.google.cloud.bigquery.connection.v1beta1.CloudSqlCredential cloud_sql = 1;</code>
       */
      public Builder clearCloudSql() {
        if (cloudSqlBuilder_ == null) {
          if (credentialCase_ == 1) {
            credentialCase_ = 0;
            credential_ = null;
            onChanged();
          }
        } else {
          if (credentialCase_ == 1) {
            credentialCase_ = 0;
            credential_ = null;
          }
          cloudSqlBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Credential for Cloud SQL database.
       * </pre>
       *
       * <code>.google.cloud.bigquery.connection.v1beta1.CloudSqlCredential cloud_sql = 1;</code>
       */
      public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential.Builder
          getCloudSqlBuilder() {
        return getCloudSqlFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Credential for Cloud SQL database.
       * </pre>
       *
       * <code>.google.cloud.bigquery.connection.v1beta1.CloudSqlCredential cloud_sql = 1;</code>
       */
      @java.lang.Override
      public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
              .CloudSqlCredentialOrBuilder
          getCloudSqlOrBuilder() {
        if ((credentialCase_ == 1) && (cloudSqlBuilder_ != null)) {
          return cloudSqlBuilder_.getMessageOrBuilder();
        } else {
          if (credentialCase_ == 1) {
            return (com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential)
                credential_;
          }
          return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Credential for Cloud SQL database.
       * </pre>
       *
       * <code>.google.cloud.bigquery.connection.v1beta1.CloudSqlCredential cloud_sql = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential,
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential
                  .Builder,
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
                  .CloudSqlCredentialOrBuilder>
          getCloudSqlFieldBuilder() {
        if (cloudSqlBuilder_ == null) {
          if (!(credentialCase_ == 1)) {
            credential_ =
                com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential
                    .getDefaultInstance();
          }
          cloudSqlBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential,
                  com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential
                      .Builder,
                  com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
                      .CloudSqlCredentialOrBuilder>(
                  (com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential)
                      credential_,
                  getParentForChildren(),
                  isClean());
          credential_ = null;
        }
        credentialCase_ = 1;
        onChanged();
        return cloudSqlBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.connection.v1beta1.ConnectionCredential)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.bigquery.connection.v1beta1.ConnectionCredential)
    private static final com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .ConnectionCredential
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionCredential();
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionCredential
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ConnectionCredential> PARSER =
        new com.google.protobuf.AbstractParser<ConnectionCredential>() {
          @java.lang.Override
          public ConnectionCredential parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ConnectionCredential> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ConnectionCredential> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.ConnectionCredential
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface CloudSqlPropertiesOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.connection.v1beta1.CloudSqlProperties)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Cloud SQL instance ID in the form `project:location:instance`.
     * </pre>
     *
     * <code>string instance_id = 1;</code>
     *
     * @return The instanceId.
     */
    java.lang.String getInstanceId();
    /**
     *
     *
     * <pre>
     * Cloud SQL instance ID in the form `project:location:instance`.
     * </pre>
     *
     * <code>string instance_id = 1;</code>
     *
     * @return The bytes for instanceId.
     */
    com.google.protobuf.ByteString getInstanceIdBytes();

    /**
     *
     *
     * <pre>
     * Database name.
     * </pre>
     *
     * <code>string database = 2;</code>
     *
     * @return The database.
     */
    java.lang.String getDatabase();
    /**
     *
     *
     * <pre>
     * Database name.
     * </pre>
     *
     * <code>string database = 2;</code>
     *
     * @return The bytes for database.
     */
    com.google.protobuf.ByteString getDatabaseBytes();

    /**
     *
     *
     * <pre>
     * Type of the Cloud SQL database.
     * </pre>
     *
     * <code>.google.cloud.bigquery.connection.v1beta1.CloudSqlProperties.DatabaseType type = 3;
     * </code>
     *
     * @return The enum numeric value on the wire for type.
     */
    int getTypeValue();
    /**
     *
     *
     * <pre>
     * Type of the Cloud SQL database.
     * </pre>
     *
     * <code>.google.cloud.bigquery.connection.v1beta1.CloudSqlProperties.DatabaseType type = 3;
     * </code>
     *
     * @return The type.
     */
    com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties.DatabaseType
        getType();

    /**
     *
     *
     * <pre>
     * Input only. Cloud SQL credential.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.connection.v1beta1.CloudSqlCredential credential = 4 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @return Whether the credential field is set.
     */
    boolean hasCredential();
    /**
     *
     *
     * <pre>
     * Input only. Cloud SQL credential.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.connection.v1beta1.CloudSqlCredential credential = 4 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @return The credential.
     */
    com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential getCredential();
    /**
     *
     *
     * <pre>
     * Input only. Cloud SQL credential.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.connection.v1beta1.CloudSqlCredential credential = 4 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredentialOrBuilder
        getCredentialOrBuilder();

    /**
     *
     *
     * <pre>
     * Output only. The account ID of the service used for the purpose of this
     * connection.
     *
     * When the connection is used in the context of an operation in
     * BigQuery, this service account will serve as the identity being used for
     * connecting to the CloudSQL instance specified in this connection.
     * </pre>
     *
     * <code>string service_account_id = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The serviceAccountId.
     */
    java.lang.String getServiceAccountId();
    /**
     *
     *
     * <pre>
     * Output only. The account ID of the service used for the purpose of this
     * connection.
     *
     * When the connection is used in the context of an operation in
     * BigQuery, this service account will serve as the identity being used for
     * connecting to the CloudSQL instance specified in this connection.
     * </pre>
     *
     * <code>string service_account_id = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for serviceAccountId.
     */
    com.google.protobuf.ByteString getServiceAccountIdBytes();
  }
  /**
   *
   *
   * <pre>
   * Connection properties specific to the Cloud SQL.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.connection.v1beta1.CloudSqlProperties}
   */
  public static final class CloudSqlProperties extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.bigquery.connection.v1beta1.CloudSqlProperties)
      CloudSqlPropertiesOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use CloudSqlProperties.newBuilder() to construct.
    private CloudSqlProperties(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private CloudSqlProperties() {
      instanceId_ = "";
      database_ = "";
      type_ = 0;
      serviceAccountId_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new CloudSqlProperties();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
          .internal_static_google_cloud_bigquery_connection_v1beta1_CloudSqlProperties_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
          .internal_static_google_cloud_bigquery_connection_v1beta1_CloudSqlProperties_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties.class,
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties
                  .Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Supported Cloud SQL database types.
     * </pre>
     *
     * Protobuf enum {@code
     * google.cloud.bigquery.connection.v1beta1.CloudSqlProperties.DatabaseType}
     */
    public enum DatabaseType implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Unspecified database type.
       * </pre>
       *
       * <code>DATABASE_TYPE_UNSPECIFIED = 0;</code>
       */
      DATABASE_TYPE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Cloud SQL for PostgreSQL.
       * </pre>
       *
       * <code>POSTGRES = 1;</code>
       */
      POSTGRES(1),
      /**
       *
       *
       * <pre>
       * Cloud SQL for MySQL.
       * </pre>
       *
       * <code>MYSQL = 2;</code>
       */
      MYSQL(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Unspecified database type.
       * </pre>
       *
       * <code>DATABASE_TYPE_UNSPECIFIED = 0;</code>
       */
      public static final int DATABASE_TYPE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Cloud SQL for PostgreSQL.
       * </pre>
       *
       * <code>POSTGRES = 1;</code>
       */
      public static final int POSTGRES_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Cloud SQL for MySQL.
       * </pre>
       *
       * <code>MYSQL = 2;</code>
       */
      public static final int MYSQL_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static DatabaseType valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static DatabaseType forNumber(int value) {
        switch (value) {
          case 0:
            return DATABASE_TYPE_UNSPECIFIED;
          case 1:
            return POSTGRES;
          case 2:
            return MYSQL;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<DatabaseType> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<DatabaseType> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<DatabaseType>() {
            public DatabaseType findValueByNumber(int number) {
              return DatabaseType.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties
            .getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final DatabaseType[] VALUES = values();

      public static DatabaseType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private DatabaseType(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.bigquery.connection.v1beta1.CloudSqlProperties.DatabaseType)
    }

    public static final int INSTANCE_ID_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object instanceId_ = "";
    /**
     *
     *
     * <pre>
     * Cloud SQL instance ID in the form `project:location:instance`.
     * </pre>
     *
     * <code>string instance_id = 1;</code>
     *
     * @return The instanceId.
     */
    @java.lang.Override
    public java.lang.String getInstanceId() {
      java.lang.Object ref = instanceId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        instanceId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud SQL instance ID in the form `project:location:instance`.
     * </pre>
     *
     * <code>string instance_id = 1;</code>
     *
     * @return The bytes for instanceId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getInstanceIdBytes() {
      java.lang.Object ref = instanceId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        instanceId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DATABASE_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object database_ = "";
    /**
     *
     *
     * <pre>
     * Database name.
     * </pre>
     *
     * <code>string database = 2;</code>
     *
     * @return The database.
     */
    @java.lang.Override
    public java.lang.String getDatabase() {
      java.lang.Object ref = database_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        database_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Database name.
     * </pre>
     *
     * <code>string database = 2;</code>
     *
     * @return The bytes for database.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDatabaseBytes() {
      java.lang.Object ref = database_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        database_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TYPE_FIELD_NUMBER = 3;
    private int type_ = 0;
    /**
     *
     *
     * <pre>
     * Type of the Cloud SQL database.
     * </pre>
     *
     * <code>.google.cloud.bigquery.connection.v1beta1.CloudSqlProperties.DatabaseType type = 3;
     * </code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }
    /**
     *
     *
     * <pre>
     * Type of the Cloud SQL database.
     * </pre>
     *
     * <code>.google.cloud.bigquery.connection.v1beta1.CloudSqlProperties.DatabaseType type = 3;
     * </code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties
            .DatabaseType
        getType() {
      com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties.DatabaseType
          result =
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties
                  .DatabaseType.forNumber(type_);
      return result == null
          ? com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties
              .DatabaseType.UNRECOGNIZED
          : result;
    }

    public static final int CREDENTIAL_FIELD_NUMBER = 4;
    private com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential
        credential_;
    /**
     *
     *
     * <pre>
     * Input only. Cloud SQL credential.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.connection.v1beta1.CloudSqlCredential credential = 4 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @return Whether the credential field is set.
     */
    @java.lang.Override
    public boolean hasCredential() {
      return credential_ != null;
    }
    /**
     *
     *
     * <pre>
     * Input only. Cloud SQL credential.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.connection.v1beta1.CloudSqlCredential credential = 4 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @return The credential.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential
        getCredential() {
      return credential_ == null
          ? com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential
              .getDefaultInstance()
          : credential_;
    }
    /**
     *
     *
     * <pre>
     * Input only. Cloud SQL credential.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.connection.v1beta1.CloudSqlCredential credential = 4 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredentialOrBuilder
        getCredentialOrBuilder() {
      return credential_ == null
          ? com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential
              .getDefaultInstance()
          : credential_;
    }

    public static final int SERVICE_ACCOUNT_ID_FIELD_NUMBER = 5;

    @SuppressWarnings("serial")
    private volatile java.lang.Object serviceAccountId_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The account ID of the service used for the purpose of this
     * connection.
     *
     * When the connection is used in the context of an operation in
     * BigQuery, this service account will serve as the identity being used for
     * connecting to the CloudSQL instance specified in this connection.
     * </pre>
     *
     * <code>string service_account_id = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The serviceAccountId.
     */
    @java.lang.Override
    public java.lang.String getServiceAccountId() {
      java.lang.Object ref = serviceAccountId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceAccountId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The account ID of the service used for the purpose of this
     * connection.
     *
     * When the connection is used in the context of an operation in
     * BigQuery, this service account will serve as the identity being used for
     * connecting to the CloudSQL instance specified in this connection.
     * </pre>
     *
     * <code>string service_account_id = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for serviceAccountId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getServiceAccountIdBytes() {
      java.lang.Object ref = serviceAccountId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceAccountId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(instanceId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, instanceId_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(database_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, database_);
      }
      if (type_
          != com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties
              .DatabaseType.DATABASE_TYPE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(3, type_);
      }
      if (credential_ != null) {
        output.writeMessage(4, getCredential());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccountId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, serviceAccountId_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(instanceId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, instanceId_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(database_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, database_);
      }
      if (type_
          != com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties
              .DatabaseType.DATABASE_TYPE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, type_);
      }
      if (credential_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getCredential());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccountId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, serviceAccountId_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties)) {
        return super.equals(obj);
      }
      com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties other =
          (com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties) obj;

      if (!getInstanceId().equals(other.getInstanceId())) return false;
      if (!getDatabase().equals(other.getDatabase())) return false;
      if (type_ != other.type_) return false;
      if (hasCredential() != other.hasCredential()) return false;
      if (hasCredential()) {
        if (!getCredential().equals(other.getCredential())) return false;
      }
      if (!getServiceAccountId().equals(other.getServiceAccountId())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + INSTANCE_ID_FIELD_NUMBER;
      hash = (53 * hash) + getInstanceId().hashCode();
      hash = (37 * hash) + DATABASE_FIELD_NUMBER;
      hash = (53 * hash) + getDatabase().hashCode();
      hash = (37 * hash) + TYPE_FIELD_NUMBER;
      hash = (53 * hash) + type_;
      if (hasCredential()) {
        hash = (37 * hash) + CREDENTIAL_FIELD_NUMBER;
        hash = (53 * hash) + getCredential().hashCode();
      }
      hash = (37 * hash) + SERVICE_ACCOUNT_ID_FIELD_NUMBER;
      hash = (53 * hash) + getServiceAccountId().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Connection properties specific to the Cloud SQL.
     * </pre>
     *
     * Protobuf type {@code google.cloud.bigquery.connection.v1beta1.CloudSqlProperties}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.connection.v1beta1.CloudSqlProperties)
        com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlPropertiesOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .internal_static_google_cloud_bigquery_connection_v1beta1_CloudSqlProperties_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .internal_static_google_cloud_bigquery_connection_v1beta1_CloudSqlProperties_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties
                    .class,
                com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        instanceId_ = "";
        database_ = "";
        type_ = 0;
        credential_ = null;
        if (credentialBuilder_ != null) {
          credentialBuilder_.dispose();
          credentialBuilder_ = null;
        }
        serviceAccountId_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .internal_static_google_cloud_bigquery_connection_v1beta1_CloudSqlProperties_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties
          getDefaultInstanceForType() {
        return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties
          build() {
        com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties
          buildPartial() {
        com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties result =
            new com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties(
                this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.instanceId_ = instanceId_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.database_ = database_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.type_ = type_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.credential_ =
              credentialBuilder_ == null ? credential_ : credentialBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.serviceAccountId_ = serviceAccountId_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties) {
          return mergeFrom(
              (com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties other) {
        if (other
            == com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties
                .getDefaultInstance()) return this;
        if (!other.getInstanceId().isEmpty()) {
          instanceId_ = other.instanceId_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getDatabase().isEmpty()) {
          database_ = other.database_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (other.type_ != 0) {
          setTypeValue(other.getTypeValue());
        }
        if (other.hasCredential()) {
          mergeCredential(other.getCredential());
        }
        if (!other.getServiceAccountId().isEmpty()) {
          serviceAccountId_ = other.serviceAccountId_;
          bitField0_ |= 0x00000010;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  instanceId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  database_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 24:
                {
                  type_ = input.readEnum();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              case 34:
                {
                  input.readMessage(getCredentialFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              case 42:
                {
                  serviceAccountId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 42
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object instanceId_ = "";
      /**
       *
       *
       * <pre>
       * Cloud SQL instance ID in the form `project:location:instance`.
       * </pre>
       *
       * <code>string instance_id = 1;</code>
       *
       * @return The instanceId.
       */
      public java.lang.String getInstanceId() {
        java.lang.Object ref = instanceId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          instanceId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Cloud SQL instance ID in the form `project:location:instance`.
       * </pre>
       *
       * <code>string instance_id = 1;</code>
       *
       * @return The bytes for instanceId.
       */
      public com.google.protobuf.ByteString getInstanceIdBytes() {
        java.lang.Object ref = instanceId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          instanceId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Cloud SQL instance ID in the form `project:location:instance`.
       * </pre>
       *
       * <code>string instance_id = 1;</code>
       *
       * @param value The instanceId to set.
       * @return This builder for chaining.
       */
      public Builder setInstanceId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        instanceId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Cloud SQL instance ID in the form `project:location:instance`.
       * </pre>
       *
       * <code>string instance_id = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearInstanceId() {
        instanceId_ = getDefaultInstance().getInstanceId();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Cloud SQL instance ID in the form `project:location:instance`.
       * </pre>
       *
       * <code>string instance_id = 1;</code>
       *
       * @param value The bytes for instanceId to set.
       * @return This builder for chaining.
       */
      public Builder setInstanceIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        instanceId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object database_ = "";
      /**
       *
       *
       * <pre>
       * Database name.
       * </pre>
       *
       * <code>string database = 2;</code>
       *
       * @return The database.
       */
      public java.lang.String getDatabase() {
        java.lang.Object ref = database_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          database_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Database name.
       * </pre>
       *
       * <code>string database = 2;</code>
       *
       * @return The bytes for database.
       */
      public com.google.protobuf.ByteString getDatabaseBytes() {
        java.lang.Object ref = database_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          database_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Database name.
       * </pre>
       *
       * <code>string database = 2;</code>
       *
       * @param value The database to set.
       * @return This builder for chaining.
       */
      public Builder setDatabase(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        database_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Database name.
       * </pre>
       *
       * <code>string database = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDatabase() {
        database_ = getDefaultInstance().getDatabase();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Database name.
       * </pre>
       *
       * <code>string database = 2;</code>
       *
       * @param value The bytes for database to set.
       * @return This builder for chaining.
       */
      public Builder setDatabaseBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        database_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private int type_ = 0;
      /**
       *
       *
       * <pre>
       * Type of the Cloud SQL database.
       * </pre>
       *
       * <code>.google.cloud.bigquery.connection.v1beta1.CloudSqlProperties.DatabaseType type = 3;
       * </code>
       *
       * @return The enum numeric value on the wire for type.
       */
      @java.lang.Override
      public int getTypeValue() {
        return type_;
      }
      /**
       *
       *
       * <pre>
       * Type of the Cloud SQL database.
       * </pre>
       *
       * <code>.google.cloud.bigquery.connection.v1beta1.CloudSqlProperties.DatabaseType type = 3;
       * </code>
       *
       * @param value The enum numeric value on the wire for type to set.
       * @return This builder for chaining.
       */
      public Builder setTypeValue(int value) {
        type_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Type of the Cloud SQL database.
       * </pre>
       *
       * <code>.google.cloud.bigquery.connection.v1beta1.CloudSqlProperties.DatabaseType type = 3;
       * </code>
       *
       * @return The type.
       */
      @java.lang.Override
      public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties
              .DatabaseType
          getType() {
        com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties.DatabaseType
            result =
                com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties
                    .DatabaseType.forNumber(type_);
        return result == null
            ? com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties
                .DatabaseType.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Type of the Cloud SQL database.
       * </pre>
       *
       * <code>.google.cloud.bigquery.connection.v1beta1.CloudSqlProperties.DatabaseType type = 3;
       * </code>
       *
       * @param value The type to set.
       * @return This builder for chaining.
       */
      public Builder setType(
          com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties
                  .DatabaseType
              value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000004;
        type_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Type of the Cloud SQL database.
       * </pre>
       *
       * <code>.google.cloud.bigquery.connection.v1beta1.CloudSqlProperties.DatabaseType type = 3;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearType() {
        bitField0_ = (bitField0_ & ~0x00000004);
        type_ = 0;
        onChanged();
        return this;
      }

      private com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential
          credential_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential,
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential
                  .Builder,
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
                  .CloudSqlCredentialOrBuilder>
          credentialBuilder_;
      /**
       *
       *
       * <pre>
       * Input only. Cloud SQL credential.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.connection.v1beta1.CloudSqlCredential credential = 4 [(.google.api.field_behavior) = INPUT_ONLY];
       * </code>
       *
       * @return Whether the credential field is set.
       */
      public boolean hasCredential() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       *
       *
       * <pre>
       * Input only. Cloud SQL credential.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.connection.v1beta1.CloudSqlCredential credential = 4 [(.google.api.field_behavior) = INPUT_ONLY];
       * </code>
       *
       * @return The credential.
       */
      public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential
          getCredential() {
        if (credentialBuilder_ == null) {
          return credential_ == null
              ? com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential
                  .getDefaultInstance()
              : credential_;
        } else {
          return credentialBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Input only. Cloud SQL credential.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.connection.v1beta1.CloudSqlCredential credential = 4 [(.google.api.field_behavior) = INPUT_ONLY];
       * </code>
       */
      public Builder setCredential(
          com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential value) {
        if (credentialBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          credential_ = value;
        } else {
          credentialBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Input only. Cloud SQL credential.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.connection.v1beta1.CloudSqlCredential credential = 4 [(.google.api.field_behavior) = INPUT_ONLY];
       * </code>
       */
      public Builder setCredential(
          com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential.Builder
              builderForValue) {
        if (credentialBuilder_ == null) {
          credential_ = builderForValue.build();
        } else {
          credentialBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Input only. Cloud SQL credential.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.connection.v1beta1.CloudSqlCredential credential = 4 [(.google.api.field_behavior) = INPUT_ONLY];
       * </code>
       */
      public Builder mergeCredential(
          com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential value) {
        if (credentialBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)
              && credential_ != null
              && credential_
                  != com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential
                      .getDefaultInstance()) {
            getCredentialBuilder().mergeFrom(value);
          } else {
            credential_ = value;
          }
        } else {
          credentialBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Input only. Cloud SQL credential.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.connection.v1beta1.CloudSqlCredential credential = 4 [(.google.api.field_behavior) = INPUT_ONLY];
       * </code>
       */
      public Builder clearCredential() {
        bitField0_ = (bitField0_ & ~0x00000008);
        credential_ = null;
        if (credentialBuilder_ != null) {
          credentialBuilder_.dispose();
          credentialBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Input only. Cloud SQL credential.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.connection.v1beta1.CloudSqlCredential credential = 4 [(.google.api.field_behavior) = INPUT_ONLY];
       * </code>
       */
      public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential.Builder
          getCredentialBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getCredentialFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Input only. Cloud SQL credential.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.connection.v1beta1.CloudSqlCredential credential = 4 [(.google.api.field_behavior) = INPUT_ONLY];
       * </code>
       */
      public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
              .CloudSqlCredentialOrBuilder
          getCredentialOrBuilder() {
        if (credentialBuilder_ != null) {
          return credentialBuilder_.getMessageOrBuilder();
        } else {
          return credential_ == null
              ? com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential
                  .getDefaultInstance()
              : credential_;
        }
      }
      /**
       *
       *
       * <pre>
       * Input only. Cloud SQL credential.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.connection.v1beta1.CloudSqlCredential credential = 4 [(.google.api.field_behavior) = INPUT_ONLY];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential,
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential
                  .Builder,
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
                  .CloudSqlCredentialOrBuilder>
          getCredentialFieldBuilder() {
        if (credentialBuilder_ == null) {
          credentialBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential,
                  com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential
                      .Builder,
                  com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
                      .CloudSqlCredentialOrBuilder>(
                  getCredential(), getParentForChildren(), isClean());
          credential_ = null;
        }
        return credentialBuilder_;
      }

      private java.lang.Object serviceAccountId_ = "";
      /**
       *
       *
       * <pre>
       * Output only. The account ID of the service used for the purpose of this
       * connection.
       *
       * When the connection is used in the context of an operation in
       * BigQuery, this service account will serve as the identity being used for
       * connecting to the CloudSQL instance specified in this connection.
       * </pre>
       *
       * <code>string service_account_id = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The serviceAccountId.
       */
      public java.lang.String getServiceAccountId() {
        java.lang.Object ref = serviceAccountId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          serviceAccountId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The account ID of the service used for the purpose of this
       * connection.
       *
       * When the connection is used in the context of an operation in
       * BigQuery, this service account will serve as the identity being used for
       * connecting to the CloudSQL instance specified in this connection.
       * </pre>
       *
       * <code>string service_account_id = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for serviceAccountId.
       */
      public com.google.protobuf.ByteString getServiceAccountIdBytes() {
        java.lang.Object ref = serviceAccountId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          serviceAccountId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The account ID of the service used for the purpose of this
       * connection.
       *
       * When the connection is used in the context of an operation in
       * BigQuery, this service account will serve as the identity being used for
       * connecting to the CloudSQL instance specified in this connection.
       * </pre>
       *
       * <code>string service_account_id = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The serviceAccountId to set.
       * @return This builder for chaining.
       */
      public Builder setServiceAccountId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        serviceAccountId_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The account ID of the service used for the purpose of this
       * connection.
       *
       * When the connection is used in the context of an operation in
       * BigQuery, this service account will serve as the identity being used for
       * connecting to the CloudSQL instance specified in this connection.
       * </pre>
       *
       * <code>string service_account_id = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearServiceAccountId() {
        serviceAccountId_ = getDefaultInstance().getServiceAccountId();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The account ID of the service used for the purpose of this
       * connection.
       *
       * When the connection is used in the context of an operation in
       * BigQuery, this service account will serve as the identity being used for
       * connecting to the CloudSQL instance specified in this connection.
       * </pre>
       *
       * <code>string service_account_id = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for serviceAccountId to set.
       * @return This builder for chaining.
       */
      public Builder setServiceAccountIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        serviceAccountId_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.connection.v1beta1.CloudSqlProperties)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.bigquery.connection.v1beta1.CloudSqlProperties)
    private static final com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .CloudSqlProperties
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties();
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CloudSqlProperties> PARSER =
        new com.google.protobuf.AbstractParser<CloudSqlProperties>() {
          @java.lang.Override
          public CloudSqlProperties parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<CloudSqlProperties> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CloudSqlProperties> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlProperties
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface CloudSqlCredentialOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.connection.v1beta1.CloudSqlCredential)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The username for the credential.
     * </pre>
     *
     * <code>string username = 1;</code>
     *
     * @return The username.
     */
    java.lang.String getUsername();
    /**
     *
     *
     * <pre>
     * The username for the credential.
     * </pre>
     *
     * <code>string username = 1;</code>
     *
     * @return The bytes for username.
     */
    com.google.protobuf.ByteString getUsernameBytes();

    /**
     *
     *
     * <pre>
     * The password for the credential.
     * </pre>
     *
     * <code>string password = 2;</code>
     *
     * @return The password.
     */
    java.lang.String getPassword();
    /**
     *
     *
     * <pre>
     * The password for the credential.
     * </pre>
     *
     * <code>string password = 2;</code>
     *
     * @return The bytes for password.
     */
    com.google.protobuf.ByteString getPasswordBytes();
  }
  /**
   *
   *
   * <pre>
   * Credential info for the Cloud SQL.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.connection.v1beta1.CloudSqlCredential}
   */
  public static final class CloudSqlCredential extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.bigquery.connection.v1beta1.CloudSqlCredential)
      CloudSqlCredentialOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use CloudSqlCredential.newBuilder() to construct.
    private CloudSqlCredential(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private CloudSqlCredential() {
      username_ = "";
      password_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new CloudSqlCredential();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
          .internal_static_google_cloud_bigquery_connection_v1beta1_CloudSqlCredential_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
          .internal_static_google_cloud_bigquery_connection_v1beta1_CloudSqlCredential_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential.class,
              com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential
                  .Builder.class);
    }

    public static final int USERNAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object username_ = "";
    /**
     *
     *
     * <pre>
     * The username for the credential.
     * </pre>
     *
     * <code>string username = 1;</code>
     *
     * @return The username.
     */
    @java.lang.Override
    public java.lang.String getUsername() {
      java.lang.Object ref = username_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        username_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The username for the credential.
     * </pre>
     *
     * <code>string username = 1;</code>
     *
     * @return The bytes for username.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getUsernameBytes() {
      java.lang.Object ref = username_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        username_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PASSWORD_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object password_ = "";
    /**
     *
     *
     * <pre>
     * The password for the credential.
     * </pre>
     *
     * <code>string password = 2;</code>
     *
     * @return The password.
     */
    @java.lang.Override
    public java.lang.String getPassword() {
      java.lang.Object ref = password_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        password_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The password for the credential.
     * </pre>
     *
     * <code>string password = 2;</code>
     *
     * @return The bytes for password.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPasswordBytes() {
      java.lang.Object ref = password_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        password_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(username_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, username_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(password_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, password_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(username_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, username_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(password_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, password_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential)) {
        return super.equals(obj);
      }
      com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential other =
          (com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential) obj;

      if (!getUsername().equals(other.getUsername())) return false;
      if (!getPassword().equals(other.getPassword())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + USERNAME_FIELD_NUMBER;
      hash = (53 * hash) + getUsername().hashCode();
      hash = (37 * hash) + PASSWORD_FIELD_NUMBER;
      hash = (53 * hash) + getPassword().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Credential info for the Cloud SQL.
     * </pre>
     *
     * Protobuf type {@code google.cloud.bigquery.connection.v1beta1.CloudSqlCredential}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.connection.v1beta1.CloudSqlCredential)
        com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredentialOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .internal_static_google_cloud_bigquery_connection_v1beta1_CloudSqlCredential_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .internal_static_google_cloud_bigquery_connection_v1beta1_CloudSqlCredential_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential
                    .class,
                com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        username_ = "";
        password_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .internal_static_google_cloud_bigquery_connection_v1beta1_CloudSqlCredential_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential
          getDefaultInstanceForType() {
        return com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential
          build() {
        com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential
          buildPartial() {
        com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential result =
            new com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential(
                this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.username_ = username_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.password_ = password_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential) {
          return mergeFrom(
              (com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential other) {
        if (other
            == com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential
                .getDefaultInstance()) return this;
        if (!other.getUsername().isEmpty()) {
          username_ = other.username_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getPassword().isEmpty()) {
          password_ = other.password_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  username_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  password_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object username_ = "";
      /**
       *
       *
       * <pre>
       * The username for the credential.
       * </pre>
       *
       * <code>string username = 1;</code>
       *
       * @return The username.
       */
      public java.lang.String getUsername() {
        java.lang.Object ref = username_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          username_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The username for the credential.
       * </pre>
       *
       * <code>string username = 1;</code>
       *
       * @return The bytes for username.
       */
      public com.google.protobuf.ByteString getUsernameBytes() {
        java.lang.Object ref = username_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          username_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The username for the credential.
       * </pre>
       *
       * <code>string username = 1;</code>
       *
       * @param value The username to set.
       * @return This builder for chaining.
       */
      public Builder setUsername(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        username_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The username for the credential.
       * </pre>
       *
       * <code>string username = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearUsername() {
        username_ = getDefaultInstance().getUsername();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The username for the credential.
       * </pre>
       *
       * <code>string username = 1;</code>
       *
       * @param value The bytes for username to set.
       * @return This builder for chaining.
       */
      public Builder setUsernameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        username_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object password_ = "";
      /**
       *
       *
       * <pre>
       * The password for the credential.
       * </pre>
       *
       * <code>string password = 2;</code>
       *
       * @return The password.
       */
      public java.lang.String getPassword() {
        java.lang.Object ref = password_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          password_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The password for the credential.
       * </pre>
       *
       * <code>string password = 2;</code>
       *
       * @return The bytes for password.
       */
      public com.google.protobuf.ByteString getPasswordBytes() {
        java.lang.Object ref = password_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          password_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The password for the credential.
       * </pre>
       *
       * <code>string password = 2;</code>
       *
       * @param value The password to set.
       * @return This builder for chaining.
       */
      public Builder setPassword(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        password_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The password for the credential.
       * </pre>
       *
       * <code>string password = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPassword() {
        password_ = getDefaultInstance().getPassword();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The password for the credential.
       * </pre>
       *
       * <code>string password = 2;</code>
       *
       * @param value The bytes for password to set.
       * @return This builder for chaining.
       */
      public Builder setPasswordBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        password_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.connection.v1beta1.CloudSqlCredential)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.bigquery.connection.v1beta1.CloudSqlCredential)
    private static final com.google.cloud.bigquery.connection.v1beta1.ConnectionProto
            .CloudSqlCredential
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential();
    }

    public static com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CloudSqlCredential> PARSER =
        new com.google.protobuf.AbstractParser<CloudSqlCredential>() {
          @java.lang.Override
          public CloudSqlCredential parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<CloudSqlCredential> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CloudSqlCredential> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.connection.v1beta1.ConnectionProto.CloudSqlCredential
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_bigquery_connection_v1beta1_CreateConnectionRequest_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_bigquery_connection_v1beta1_CreateConnectionRequest_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_bigquery_connection_v1beta1_GetConnectionRequest_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_bigquery_connection_v1beta1_GetConnectionRequest_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_bigquery_connection_v1beta1_ListConnectionsRequest_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_bigquery_connection_v1beta1_ListConnectionsRequest_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_bigquery_connection_v1beta1_ListConnectionsResponse_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_bigquery_connection_v1beta1_ListConnectionsResponse_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_bigquery_connection_v1beta1_UpdateConnectionRequest_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_bigquery_connection_v1beta1_UpdateConnectionRequest_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_bigquery_connection_v1beta1_UpdateConnectionCredentialRequest_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_bigquery_connection_v1beta1_UpdateConnectionCredentialRequest_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_bigquery_connection_v1beta1_DeleteConnectionRequest_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_bigquery_connection_v1beta1_DeleteConnectionRequest_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_bigquery_connection_v1beta1_Connection_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_bigquery_connection_v1beta1_Connection_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_bigquery_connection_v1beta1_ConnectionCredential_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_bigquery_connection_v1beta1_ConnectionCredential_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_bigquery_connection_v1beta1_CloudSqlProperties_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_bigquery_connection_v1beta1_CloudSqlProperties_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_bigquery_connection_v1beta1_CloudSqlCredential_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_bigquery_connection_v1beta1_CloudSqlCredential_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor getDescriptor() {
    return descriptor;
  }

  private static com.google.protobuf.Descriptors.FileDescriptor descriptor;

  static {
    java.lang.String[] descriptorData = {
      "\n9google/cloud/bigquery/connection/v1bet"
          + "a1/connection.proto\022(google.cloud.bigque"
          + "ry.connection.v1beta1\032\034google/api/annota"
          + "tions.proto\032\027google/api/client.proto\032\037go"
          + "ogle/api/field_behavior.proto\032\031google/ap"
          + "i/resource.proto\032\036google/iam/v1/iam_poli"
          + "cy.proto\032\032google/iam/v1/policy.proto\032\033go"
          + "ogle/protobuf/empty.proto\032 google/protob"
          + "uf/field_mask.proto\032\036google/protobuf/wra"
          + "ppers.proto\"\302\001\n\027CreateConnectionRequest\022"
          + ":\n\006parent\030\001 \001(\tB*\342A\001\002\372A#\n!locations.goog"
          + "leapis.com/Location\022\033\n\rconnection_id\030\002 \001"
          + "(\tB\004\342A\001\001\022N\n\nconnection\030\003 \001(\01324.google.cl"
          + "oud.bigquery.connection.v1beta1.Connecti"
          + "onB\004\342A\001\002\"[\n\024GetConnectionRequest\022C\n\004name"
          + "\030\001 \001(\tB5\342A\001\002\372A.\n,bigqueryconnection.goog"
          + "leapis.com/Connection\"\241\001\n\026ListConnection"
          + "sRequest\022:\n\006parent\030\001 \001(\tB*\342A\001\002\372A#\n!locat"
          + "ions.googleapis.com/Location\0227\n\013max_resu"
          + "lts\030\002 \001(\0132\034.google.protobuf.UInt32ValueB"
          + "\004\342A\001\002\022\022\n\npage_token\030\003 \001(\t\"}\n\027ListConnect"
          + "ionsResponse\022\027\n\017next_page_token\030\001 \001(\t\022I\n"
          + "\013connections\030\002 \003(\01324.google.cloud.bigque"
          + "ry.connection.v1beta1.Connection\"\345\001\n\027Upd"
          + "ateConnectionRequest\022C\n\004name\030\001 \001(\tB5\342A\001\002"
          + "\372A.\n,bigqueryconnection.googleapis.com/C"
          + "onnection\022N\n\nconnection\030\002 \001(\01324.google.c"
          + "loud.bigquery.connection.v1beta1.Connect"
          + "ionB\004\342A\001\002\0225\n\013update_mask\030\003 \001(\0132\032.google."
          + "protobuf.FieldMaskB\004\342A\001\002\"\221\001\n!UpdateConne"
          + "ctionCredentialRequest\022\022\n\004name\030\001 \001(\tB\004\342A"
          + "\001\002\022X\n\ncredential\030\002 \001(\0132>.google.cloud.bi"
          + "gquery.connection.v1beta1.ConnectionCred"
          + "entialB\004\342A\001\002\"^\n\027DeleteConnectionRequest\022"
          + "C\n\004name\030\001 \001(\tB5\342A\001\002\372A.\n,bigqueryconnecti"
          + "on.googleapis.com/Connection\"\371\002\n\nConnect"
          + "ion\022\014\n\004name\030\001 \001(\t\022\025\n\rfriendly_name\030\002 \001(\t"
          + "\022\023\n\013description\030\003 \001(\t\022Q\n\tcloud_sql\030\004 \001(\013"
          + "2<.google.cloud.bigquery.connection.v1be"
          + "ta1.CloudSqlPropertiesH\000\022\033\n\rcreation_tim"
          + "e\030\005 \001(\003B\004\342A\001\003\022 \n\022last_modified_time\030\006 \001("
          + "\003B\004\342A\001\003\022\034\n\016has_credential\030\007 \001(\010B\004\342A\001\003:s\352"
          + "Ap\n,bigqueryconnection.googleapis.com/Co"
          + "nnection\022@projects/{project}/locations/{"
          + "location}/connections/{connection}B\014\n\npr"
          + "operties\"w\n\024ConnectionCredential\022Q\n\tclou"
          + "d_sql\030\001 \001(\0132<.google.cloud.bigquery.conn"
          + "ection.v1beta1.CloudSqlCredentialH\000B\014\n\nc"
          + "redential\"\326\002\n\022CloudSqlProperties\022\023\n\013inst"
          + "ance_id\030\001 \001(\t\022\020\n\010database\030\002 \001(\t\022W\n\004type\030"
          + "\003 \001(\0162I.google.cloud.bigquery.connection"
          + ".v1beta1.CloudSqlProperties.DatabaseType"
          + "\022V\n\ncredential\030\004 \001(\0132<.google.cloud.bigq"
          + "uery.connection.v1beta1.CloudSqlCredenti"
          + "alB\004\342A\001\004\022 \n\022service_account_id\030\005 \001(\tB\004\342A"
          + "\001\003\"F\n\014DatabaseType\022\035\n\031DATABASE_TYPE_UNSP"
          + "ECIFIED\020\000\022\014\n\010POSTGRES\020\001\022\t\n\005MYSQL\020\002\"8\n\022Cl"
          + "oudSqlCredential\022\020\n\010username\030\001 \001(\t\022\020\n\010pa"
          + "ssword\030\002 \001(\t2\230\020\n\021ConnectionService\022\367\001\n\020C"
          + "reateConnection\022A.google.cloud.bigquery."
          + "connection.v1beta1.CreateConnectionReque"
          + "st\0324.google.cloud.bigquery.connection.v1"
          + "beta1.Connection\"j\332A\037parent,connection,c"
          + "onnection_id\202\323\344\223\002B\"4/v1beta1/{parent=pro"
          + "jects/*/locations/*}/connections:\nconnec"
          + "tion\022\312\001\n\rGetConnection\022>.google.cloud.bi"
          + "gquery.connection.v1beta1.GetConnectionR"
          + "equest\0324.google.cloud.bigquery.connectio"
          + "n.v1beta1.Connection\"C\332A\004name\202\323\344\223\0026\0224/v1"
          + "beta1/{name=projects/*/locations/*/conne"
          + "ctions/*}\022\351\001\n\017ListConnections\022@.google.c"
          + "loud.bigquery.connection.v1beta1.ListCon"
          + "nectionsRequest\032A.google.cloud.bigquery."
          + "connection.v1beta1.ListConnectionsRespon"
          + "se\"Q\332A\022parent,max_results\202\323\344\223\0026\0224/v1beta"
          + "1/{parent=projects/*/locations/*}/connec"
          + "tions\022\363\001\n\020UpdateConnection\022A.google.clou"
          + "d.bigquery.connection.v1beta1.UpdateConn"
          + "ectionRequest\0324.google.cloud.bigquery.co"
          + "nnection.v1beta1.Connection\"f\332A\033name,con"
          + "nection,update_mask\202\323\344\223\002B24/v1beta1/{nam"
          + "e=projects/*/locations/*/connections/*}:"
          + "\nconnection\022\350\001\n\032UpdateConnectionCredenti"
          + "al\022K.google.cloud.bigquery.connection.v1"
          + "beta1.UpdateConnectionCredentialRequest\032"
          + "\026.google.protobuf.Empty\"e\332A\017name,credent"
          + "ial\202\323\344\223\002M2?/v1beta1/{name=projects/*/loc"
          + "ations/*/connections/*/credential}:\ncred"
          + "ential\022\262\001\n\020DeleteConnection\022A.google.clo"
          + "ud.bigquery.connection.v1beta1.DeleteCon"
          + "nectionRequest\032\026.google.protobuf.Empty\"C"
          + "\332A\004name\202\323\344\223\0026*4/v1beta1/{name=projects/*"
          + "/locations/*/connections/*}\022\256\001\n\014GetIamPo"
          + "licy\022\".google.iam.v1.GetIamPolicyRequest"
          + "\032\025.google.iam.v1.Policy\"c\332A\020resource,opt"
          + "ions\202\323\344\223\002J\"E/v1beta1/{resource=projects/"
          + "*/locations/*/connections/*}:getIamPolic"
          + "y:\001*\022\255\001\n\014SetIamPolicy\022\".google.iam.v1.Se"
          + "tIamPolicyRequest\032\025.google.iam.v1.Policy"
          + "\"b\332A\017resource,policy\202\323\344\223\002J\"E/v1beta1/{re"
          + "source=projects/*/locations/*/connection"
          + "s/*}:setIamPolicy:\001*\022\330\001\n\022TestIamPermissi"
          + "ons\022(.google.iam.v1.TestIamPermissionsRe"
          + "quest\032).google.iam.v1.TestIamPermissions"
          + "Response\"m\332A\024resource,permissions\202\323\344\223\002P\""
          + "K/v1beta1/{resource=projects/*/locations"
          + "/*/connections/*}:testIamPermissions:\001*\032"
          + "~\312A!bigqueryconnection.googleapis.com\322AW"
          + "https://www.googleapis.com/auth/bigquery"
          + ",https://www.googleapis.com/auth/cloud-p"
          + "latformB\343\001\n,com.google.cloud.bigquery.co"
          + "nnection.v1beta1B\017ConnectionProtoZLcloud"
          + ".google.com/go/bigquery/connection/apiv1"
          + "beta1/connectionpb;connectionpb\252\002(Google"
          + ".Cloud.BigQuery.Connection.V1Beta1\312\002(Goo"
          + "gle\\Cloud\\BigQuery\\Connection\\V1beta1b\006p"
          + "roto3"
    };
    descriptor =
        com.google.protobuf.Descriptors.FileDescriptor.internalBuildGeneratedFileFrom(
            descriptorData,
            new com.google.protobuf.Descriptors.FileDescriptor[] {
              com.google.api.AnnotationsProto.getDescriptor(),
              com.google.api.ClientProto.getDescriptor(),
              com.google.api.FieldBehaviorProto.getDescriptor(),
              com.google.api.ResourceProto.getDescriptor(),
              com.google.iam.v1.IamPolicyProto.getDescriptor(),
              com.google.iam.v1.PolicyProto.getDescriptor(),
              com.google.protobuf.EmptyProto.getDescriptor(),
              com.google.protobuf.FieldMaskProto.getDescriptor(),
              com.google.protobuf.WrappersProto.getDescriptor(),
            });
    internal_static_google_cloud_bigquery_connection_v1beta1_CreateConnectionRequest_descriptor =
        getDescriptor().getMessageTypes().get(0);
    internal_static_google_cloud_bigquery_connection_v1beta1_CreateConnectionRequest_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_bigquery_connection_v1beta1_CreateConnectionRequest_descriptor,
            new java.lang.String[] {
              "Parent", "ConnectionId", "Connection",
            });
    internal_static_google_cloud_bigquery_connection_v1beta1_GetConnectionRequest_descriptor =
        getDescriptor().getMessageTypes().get(1);
    internal_static_google_cloud_bigquery_connection_v1beta1_GetConnectionRequest_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_bigquery_connection_v1beta1_GetConnectionRequest_descriptor,
            new java.lang.String[] {
              "Name",
            });
    internal_static_google_cloud_bigquery_connection_v1beta1_ListConnectionsRequest_descriptor =
        getDescriptor().getMessageTypes().get(2);
    internal_static_google_cloud_bigquery_connection_v1beta1_ListConnectionsRequest_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_bigquery_connection_v1beta1_ListConnectionsRequest_descriptor,
            new java.lang.String[] {
              "Parent", "MaxResults", "PageToken",
            });
    internal_static_google_cloud_bigquery_connection_v1beta1_ListConnectionsResponse_descriptor =
        getDescriptor().getMessageTypes().get(3);
    internal_static_google_cloud_bigquery_connection_v1beta1_ListConnectionsResponse_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_bigquery_connection_v1beta1_ListConnectionsResponse_descriptor,
            new java.lang.String[] {
              "NextPageToken", "Connections",
            });
    internal_static_google_cloud_bigquery_connection_v1beta1_UpdateConnectionRequest_descriptor =
        getDescriptor().getMessageTypes().get(4);
    internal_static_google_cloud_bigquery_connection_v1beta1_UpdateConnectionRequest_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_bigquery_connection_v1beta1_UpdateConnectionRequest_descriptor,
            new java.lang.String[] {
              "Name", "Connection", "UpdateMask",
            });
    internal_static_google_cloud_bigquery_connection_v1beta1_UpdateConnectionCredentialRequest_descriptor =
        getDescriptor().getMessageTypes().get(5);
    internal_static_google_cloud_bigquery_connection_v1beta1_UpdateConnectionCredentialRequest_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_bigquery_connection_v1beta1_UpdateConnectionCredentialRequest_descriptor,
            new java.lang.String[] {
              "Name", "Credential",
            });
    internal_static_google_cloud_bigquery_connection_v1beta1_DeleteConnectionRequest_descriptor =
        getDescriptor().getMessageTypes().get(6);
    internal_static_google_cloud_bigquery_connection_v1beta1_DeleteConnectionRequest_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_bigquery_connection_v1beta1_DeleteConnectionRequest_descriptor,
            new java.lang.String[] {
              "Name",
            });
    internal_static_google_cloud_bigquery_connection_v1beta1_Connection_descriptor =
        getDescriptor().getMessageTypes().get(7);
    internal_static_google_cloud_bigquery_connection_v1beta1_Connection_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_bigquery_connection_v1beta1_Connection_descriptor,
            new java.lang.String[] {
              "Name",
              "FriendlyName",
              "Description",
              "CloudSql",
              "CreationTime",
              "LastModifiedTime",
              "HasCredential",
              "Properties",
            });
    internal_static_google_cloud_bigquery_connection_v1beta1_ConnectionCredential_descriptor =
        getDescriptor().getMessageTypes().get(8);
    internal_static_google_cloud_bigquery_connection_v1beta1_ConnectionCredential_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_bigquery_connection_v1beta1_ConnectionCredential_descriptor,
            new java.lang.String[] {
              "CloudSql", "Credential",
            });
    internal_static_google_cloud_bigquery_connection_v1beta1_CloudSqlProperties_descriptor =
        getDescriptor().getMessageTypes().get(9);
    internal_static_google_cloud_bigquery_connection_v1beta1_CloudSqlProperties_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_bigquery_connection_v1beta1_CloudSqlProperties_descriptor,
            new java.lang.String[] {
              "InstanceId", "Database", "Type", "Credential", "ServiceAccountId",
            });
    internal_static_google_cloud_bigquery_connection_v1beta1_CloudSqlCredential_descriptor =
        getDescriptor().getMessageTypes().get(10);
    internal_static_google_cloud_bigquery_connection_v1beta1_CloudSqlCredential_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_bigquery_connection_v1beta1_CloudSqlCredential_descriptor,
            new java.lang.String[] {
              "Username", "Password",
            });
    com.google.protobuf.ExtensionRegistry registry =
        com.google.protobuf.ExtensionRegistry.newInstance();
    registry.add(com.google.api.ClientProto.defaultHost);
    registry.add(com.google.api.FieldBehaviorProto.fieldBehavior);
    registry.add(com.google.api.AnnotationsProto.http);
    registry.add(com.google.api.ClientProto.methodSignature);
    registry.add(com.google.api.ClientProto.oauthScopes);
    registry.add(com.google.api.ResourceProto.resource);
    registry.add(com.google.api.ResourceProto.resourceReference);
    com.google.protobuf.Descriptors.FileDescriptor.internalUpdateFileDescriptor(
        descriptor, registry);
    com.google.api.AnnotationsProto.getDescriptor();
    com.google.api.ClientProto.getDescriptor();
    com.google.api.FieldBehaviorProto.getDescriptor();
    com.google.api.ResourceProto.getDescriptor();
    com.google.iam.v1.IamPolicyProto.getDescriptor();
    com.google.iam.v1.PolicyProto.getDescriptor();
    com.google.protobuf.EmptyProto.getDescriptor();
    com.google.protobuf.FieldMaskProto.getDescriptor();
    com.google.protobuf.WrappersProto.getDescriptor();
  }

  // @@protoc_insertion_point(outer_class_scope)
}
