/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/datapolicies/v1beta1/datapolicy.proto

package com.google.cloud.bigquery.datapolicies.v1beta1;

/**
 *
 *
 * <pre>
 * Represents the label-policy binding.
 * </pre>
 *
 * Protobuf type {@code google.cloud.bigquery.datapolicies.v1beta1.DataPolicy}
 */
public final class DataPolicy extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.bigquery.datapolicies.v1beta1.DataPolicy)
    DataPolicyOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DataPolicy.newBuilder() to construct.
  private DataPolicy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DataPolicy() {
    name_ = "";
    dataPolicyType_ = 0;
    dataPolicyId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DataPolicy();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.bigquery.datapolicies.v1beta1.DataPolicyProto
        .internal_static_google_cloud_bigquery_datapolicies_v1beta1_DataPolicy_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.bigquery.datapolicies.v1beta1.DataPolicyProto
        .internal_static_google_cloud_bigquery_datapolicies_v1beta1_DataPolicy_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.bigquery.datapolicies.v1beta1.DataPolicy.class,
            com.google.cloud.bigquery.datapolicies.v1beta1.DataPolicy.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * A list of supported data policy types.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.bigquery.datapolicies.v1beta1.DataPolicy.DataPolicyType}
   */
  public enum DataPolicyType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value for the data policy type. This should not be used.
     * </pre>
     *
     * <code>DATA_POLICY_TYPE_UNSPECIFIED = 0;</code>
     */
    DATA_POLICY_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Used to create a data policy for column-level security, without data
     * masking.
     * </pre>
     *
     * <code>COLUMN_LEVEL_SECURITY_POLICY = 3;</code>
     */
    COLUMN_LEVEL_SECURITY_POLICY(3),
    /**
     *
     *
     * <pre>
     * Used to create a data policy for data masking.
     * </pre>
     *
     * <code>DATA_MASKING_POLICY = 2;</code>
     */
    DATA_MASKING_POLICY(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value for the data policy type. This should not be used.
     * </pre>
     *
     * <code>DATA_POLICY_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int DATA_POLICY_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Used to create a data policy for column-level security, without data
     * masking.
     * </pre>
     *
     * <code>COLUMN_LEVEL_SECURITY_POLICY = 3;</code>
     */
    public static final int COLUMN_LEVEL_SECURITY_POLICY_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Used to create a data policy for data masking.
     * </pre>
     *
     * <code>DATA_MASKING_POLICY = 2;</code>
     */
    public static final int DATA_MASKING_POLICY_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DataPolicyType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static DataPolicyType forNumber(int value) {
      switch (value) {
        case 0:
          return DATA_POLICY_TYPE_UNSPECIFIED;
        case 3:
          return COLUMN_LEVEL_SECURITY_POLICY;
        case 2:
          return DATA_MASKING_POLICY;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<DataPolicyType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<DataPolicyType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<DataPolicyType>() {
          public DataPolicyType findValueByNumber(int number) {
            return DataPolicyType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.bigquery.datapolicies.v1beta1.DataPolicy.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final DataPolicyType[] VALUES = values();

    public static DataPolicyType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private DataPolicyType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.bigquery.datapolicies.v1beta1.DataPolicy.DataPolicyType)
  }

  private int matchingLabelCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object matchingLabel_;

  public enum MatchingLabelCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    POLICY_TAG(4),
    MATCHINGLABEL_NOT_SET(0);
    private final int value;

    private MatchingLabelCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static MatchingLabelCase valueOf(int value) {
      return forNumber(value);
    }

    public static MatchingLabelCase forNumber(int value) {
      switch (value) {
        case 4:
          return POLICY_TAG;
        case 0:
          return MATCHINGLABEL_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public MatchingLabelCase getMatchingLabelCase() {
    return MatchingLabelCase.forNumber(matchingLabelCase_);
  }

  private int policyCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object policy_;

  public enum PolicyCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    DATA_MASKING_POLICY(5),
    POLICY_NOT_SET(0);
    private final int value;

    private PolicyCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PolicyCase valueOf(int value) {
      return forNumber(value);
    }

    public static PolicyCase forNumber(int value) {
      switch (value) {
        case 5:
          return DATA_MASKING_POLICY;
        case 0:
          return POLICY_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public PolicyCase getPolicyCase() {
    return PolicyCase.forNumber(policyCase_);
  }

  public static final int POLICY_TAG_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Policy tag resource name, in the format of
   * `projects/{project_number}/locations/{location_id}/taxonomies/{taxonomy_id}/policyTags/{policyTag_id}`.
   * </pre>
   *
   * <code>string policy_tag = 4;</code>
   *
   * @return Whether the policyTag field is set.
   */
  public boolean hasPolicyTag() {
    return matchingLabelCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Policy tag resource name, in the format of
   * `projects/{project_number}/locations/{location_id}/taxonomies/{taxonomy_id}/policyTags/{policyTag_id}`.
   * </pre>
   *
   * <code>string policy_tag = 4;</code>
   *
   * @return The policyTag.
   */
  public java.lang.String getPolicyTag() {
    java.lang.Object ref = "";
    if (matchingLabelCase_ == 4) {
      ref = matchingLabel_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (matchingLabelCase_ == 4) {
        matchingLabel_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Policy tag resource name, in the format of
   * `projects/{project_number}/locations/{location_id}/taxonomies/{taxonomy_id}/policyTags/{policyTag_id}`.
   * </pre>
   *
   * <code>string policy_tag = 4;</code>
   *
   * @return The bytes for policyTag.
   */
  public com.google.protobuf.ByteString getPolicyTagBytes() {
    java.lang.Object ref = "";
    if (matchingLabelCase_ == 4) {
      ref = matchingLabel_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (matchingLabelCase_ == 4) {
        matchingLabel_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATA_MASKING_POLICY_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * The data masking policy that specifies the data masking rule to use.
   * </pre>
   *
   * <code>.google.cloud.bigquery.datapolicies.v1beta1.DataMaskingPolicy data_masking_policy = 5;
   * </code>
   *
   * @return Whether the dataMaskingPolicy field is set.
   */
  @java.lang.Override
  public boolean hasDataMaskingPolicy() {
    return policyCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * The data masking policy that specifies the data masking rule to use.
   * </pre>
   *
   * <code>.google.cloud.bigquery.datapolicies.v1beta1.DataMaskingPolicy data_masking_policy = 5;
   * </code>
   *
   * @return The dataMaskingPolicy.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.datapolicies.v1beta1.DataMaskingPolicy getDataMaskingPolicy() {
    if (policyCase_ == 5) {
      return (com.google.cloud.bigquery.datapolicies.v1beta1.DataMaskingPolicy) policy_;
    }
    return com.google.cloud.bigquery.datapolicies.v1beta1.DataMaskingPolicy.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The data masking policy that specifies the data masking rule to use.
   * </pre>
   *
   * <code>.google.cloud.bigquery.datapolicies.v1beta1.DataMaskingPolicy data_masking_policy = 5;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.datapolicies.v1beta1.DataMaskingPolicyOrBuilder
      getDataMaskingPolicyOrBuilder() {
    if (policyCase_ == 5) {
      return (com.google.cloud.bigquery.datapolicies.v1beta1.DataMaskingPolicy) policy_;
    }
    return com.google.cloud.bigquery.datapolicies.v1beta1.DataMaskingPolicy.getDefaultInstance();
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Resource name of this data policy, in the format of
   * `projects/{project_number}/locations/{location_id}/dataPolicies/{data_policy_id}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Resource name of this data policy, in the format of
   * `projects/{project_number}/locations/{location_id}/dataPolicies/{data_policy_id}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATA_POLICY_TYPE_FIELD_NUMBER = 2;
  private int dataPolicyType_ = 0;
  /**
   *
   *
   * <pre>
   * Type of data policy.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.datapolicies.v1beta1.DataPolicy.DataPolicyType data_policy_type = 2;
   * </code>
   *
   * @return The enum numeric value on the wire for dataPolicyType.
   */
  @java.lang.Override
  public int getDataPolicyTypeValue() {
    return dataPolicyType_;
  }
  /**
   *
   *
   * <pre>
   * Type of data policy.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.datapolicies.v1beta1.DataPolicy.DataPolicyType data_policy_type = 2;
   * </code>
   *
   * @return The dataPolicyType.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.datapolicies.v1beta1.DataPolicy.DataPolicyType
      getDataPolicyType() {
    com.google.cloud.bigquery.datapolicies.v1beta1.DataPolicy.DataPolicyType result =
        com.google.cloud.bigquery.datapolicies.v1beta1.DataPolicy.DataPolicyType.forNumber(
            dataPolicyType_);
    return result == null
        ? com.google.cloud.bigquery.datapolicies.v1beta1.DataPolicy.DataPolicyType.UNRECOGNIZED
        : result;
  }

  public static final int DATA_POLICY_ID_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object dataPolicyId_ = "";
  /**
   *
   *
   * <pre>
   * User-assigned (human readable) ID of the data policy that needs to be
   * unique within a project. Used as {data_policy_id} in part of the resource
   * name.
   * </pre>
   *
   * <code>string data_policy_id = 3;</code>
   *
   * @return The dataPolicyId.
   */
  @java.lang.Override
  public java.lang.String getDataPolicyId() {
    java.lang.Object ref = dataPolicyId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      dataPolicyId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * User-assigned (human readable) ID of the data policy that needs to be
   * unique within a project. Used as {data_policy_id} in part of the resource
   * name.
   * </pre>
   *
   * <code>string data_policy_id = 3;</code>
   *
   * @return The bytes for dataPolicyId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDataPolicyIdBytes() {
    java.lang.Object ref = dataPolicyId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      dataPolicyId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (dataPolicyType_
        != com.google.cloud.bigquery.datapolicies.v1beta1.DataPolicy.DataPolicyType
            .DATA_POLICY_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, dataPolicyType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataPolicyId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, dataPolicyId_);
    }
    if (matchingLabelCase_ == 4) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, matchingLabel_);
    }
    if (policyCase_ == 5) {
      output.writeMessage(
          5, (com.google.cloud.bigquery.datapolicies.v1beta1.DataMaskingPolicy) policy_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (dataPolicyType_
        != com.google.cloud.bigquery.datapolicies.v1beta1.DataPolicy.DataPolicyType
            .DATA_POLICY_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, dataPolicyType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataPolicyId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, dataPolicyId_);
    }
    if (matchingLabelCase_ == 4) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, matchingLabel_);
    }
    if (policyCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.cloud.bigquery.datapolicies.v1beta1.DataMaskingPolicy) policy_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.bigquery.datapolicies.v1beta1.DataPolicy)) {
      return super.equals(obj);
    }
    com.google.cloud.bigquery.datapolicies.v1beta1.DataPolicy other =
        (com.google.cloud.bigquery.datapolicies.v1beta1.DataPolicy) obj;

    if (!getName().equals(other.getName())) return false;
    if (dataPolicyType_ != other.dataPolicyType_) return false;
    if (!getDataPolicyId().equals(other.getDataPolicyId())) return false;
    if (!getMatchingLabelCase().equals(other.getMatchingLabelCase())) return false;
    switch (matchingLabelCase_) {
      case 4:
        if (!getPolicyTag().equals(other.getPolicyTag())) return false;
        break;
      case 0:
      default:
    }
    if (!getPolicyCase().equals(other.getPolicyCase())) return false;
    switch (policyCase_) {
      case 5:
        if (!getDataMaskingPolicy().equals(other.getDataMaskingPolicy())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DATA_POLICY_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + dataPolicyType_;
    hash = (37 * hash) + DATA_POLICY_ID_FIELD_NUMBER;
    hash = (53 * hash) + getDataPolicyId().hashCode();
    switch (matchingLabelCase_) {
      case 4:
        hash = (37 * hash) + POLICY_TAG_FIELD_NUMBER;
        hash = (53 * hash) + getPolicyTag().hashCode();
        break;
      case 0:
      default:
    }
    switch (policyCase_) {
      case 5:
        hash = (37 * hash) + DATA_MASKING_POLICY_FIELD_NUMBER;
        hash = (53 * hash) + getDataMaskingPolicy().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.bigquery.datapolicies.v1beta1.DataPolicy parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.datapolicies.v1beta1.DataPolicy parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datapolicies.v1beta1.DataPolicy parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.datapolicies.v1beta1.DataPolicy parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datapolicies.v1beta1.DataPolicy parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.datapolicies.v1beta1.DataPolicy parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datapolicies.v1beta1.DataPolicy parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.datapolicies.v1beta1.DataPolicy parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datapolicies.v1beta1.DataPolicy parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.datapolicies.v1beta1.DataPolicy parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datapolicies.v1beta1.DataPolicy parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.datapolicies.v1beta1.DataPolicy parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.bigquery.datapolicies.v1beta1.DataPolicy prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents the label-policy binding.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.datapolicies.v1beta1.DataPolicy}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.datapolicies.v1beta1.DataPolicy)
      com.google.cloud.bigquery.datapolicies.v1beta1.DataPolicyOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.datapolicies.v1beta1.DataPolicyProto
          .internal_static_google_cloud_bigquery_datapolicies_v1beta1_DataPolicy_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.datapolicies.v1beta1.DataPolicyProto
          .internal_static_google_cloud_bigquery_datapolicies_v1beta1_DataPolicy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.datapolicies.v1beta1.DataPolicy.class,
              com.google.cloud.bigquery.datapolicies.v1beta1.DataPolicy.Builder.class);
    }

    // Construct using com.google.cloud.bigquery.datapolicies.v1beta1.DataPolicy.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (dataMaskingPolicyBuilder_ != null) {
        dataMaskingPolicyBuilder_.clear();
      }
      name_ = "";
      dataPolicyType_ = 0;
      dataPolicyId_ = "";
      matchingLabelCase_ = 0;
      matchingLabel_ = null;
      policyCase_ = 0;
      policy_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.bigquery.datapolicies.v1beta1.DataPolicyProto
          .internal_static_google_cloud_bigquery_datapolicies_v1beta1_DataPolicy_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.datapolicies.v1beta1.DataPolicy getDefaultInstanceForType() {
      return com.google.cloud.bigquery.datapolicies.v1beta1.DataPolicy.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.bigquery.datapolicies.v1beta1.DataPolicy build() {
      com.google.cloud.bigquery.datapolicies.v1beta1.DataPolicy result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.datapolicies.v1beta1.DataPolicy buildPartial() {
      com.google.cloud.bigquery.datapolicies.v1beta1.DataPolicy result =
          new com.google.cloud.bigquery.datapolicies.v1beta1.DataPolicy(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.bigquery.datapolicies.v1beta1.DataPolicy result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.dataPolicyType_ = dataPolicyType_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.dataPolicyId_ = dataPolicyId_;
      }
    }

    private void buildPartialOneofs(
        com.google.cloud.bigquery.datapolicies.v1beta1.DataPolicy result) {
      result.matchingLabelCase_ = matchingLabelCase_;
      result.matchingLabel_ = this.matchingLabel_;
      result.policyCase_ = policyCase_;
      result.policy_ = this.policy_;
      if (policyCase_ == 5 && dataMaskingPolicyBuilder_ != null) {
        result.policy_ = dataMaskingPolicyBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.bigquery.datapolicies.v1beta1.DataPolicy) {
        return mergeFrom((com.google.cloud.bigquery.datapolicies.v1beta1.DataPolicy) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.bigquery.datapolicies.v1beta1.DataPolicy other) {
      if (other == com.google.cloud.bigquery.datapolicies.v1beta1.DataPolicy.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.dataPolicyType_ != 0) {
        setDataPolicyTypeValue(other.getDataPolicyTypeValue());
      }
      if (!other.getDataPolicyId().isEmpty()) {
        dataPolicyId_ = other.dataPolicyId_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      switch (other.getMatchingLabelCase()) {
        case POLICY_TAG:
          {
            matchingLabelCase_ = 4;
            matchingLabel_ = other.matchingLabel_;
            onChanged();
            break;
          }
        case MATCHINGLABEL_NOT_SET:
          {
            break;
          }
      }
      switch (other.getPolicyCase()) {
        case DATA_MASKING_POLICY:
          {
            mergeDataMaskingPolicy(other.getDataMaskingPolicy());
            break;
          }
        case POLICY_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 10
            case 16:
              {
                dataPolicyType_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 16
            case 26:
              {
                dataPolicyId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 26
            case 34:
              {
                java.lang.String s = input.readStringRequireUtf8();
                matchingLabelCase_ = 4;
                matchingLabel_ = s;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(
                    getDataMaskingPolicyFieldBuilder().getBuilder(), extensionRegistry);
                policyCase_ = 5;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int matchingLabelCase_ = 0;
    private java.lang.Object matchingLabel_;

    public MatchingLabelCase getMatchingLabelCase() {
      return MatchingLabelCase.forNumber(matchingLabelCase_);
    }

    public Builder clearMatchingLabel() {
      matchingLabelCase_ = 0;
      matchingLabel_ = null;
      onChanged();
      return this;
    }

    private int policyCase_ = 0;
    private java.lang.Object policy_;

    public PolicyCase getPolicyCase() {
      return PolicyCase.forNumber(policyCase_);
    }

    public Builder clearPolicy() {
      policyCase_ = 0;
      policy_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    /**
     *
     *
     * <pre>
     * Policy tag resource name, in the format of
     * `projects/{project_number}/locations/{location_id}/taxonomies/{taxonomy_id}/policyTags/{policyTag_id}`.
     * </pre>
     *
     * <code>string policy_tag = 4;</code>
     *
     * @return Whether the policyTag field is set.
     */
    @java.lang.Override
    public boolean hasPolicyTag() {
      return matchingLabelCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Policy tag resource name, in the format of
     * `projects/{project_number}/locations/{location_id}/taxonomies/{taxonomy_id}/policyTags/{policyTag_id}`.
     * </pre>
     *
     * <code>string policy_tag = 4;</code>
     *
     * @return The policyTag.
     */
    @java.lang.Override
    public java.lang.String getPolicyTag() {
      java.lang.Object ref = "";
      if (matchingLabelCase_ == 4) {
        ref = matchingLabel_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (matchingLabelCase_ == 4) {
          matchingLabel_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Policy tag resource name, in the format of
     * `projects/{project_number}/locations/{location_id}/taxonomies/{taxonomy_id}/policyTags/{policyTag_id}`.
     * </pre>
     *
     * <code>string policy_tag = 4;</code>
     *
     * @return The bytes for policyTag.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPolicyTagBytes() {
      java.lang.Object ref = "";
      if (matchingLabelCase_ == 4) {
        ref = matchingLabel_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (matchingLabelCase_ == 4) {
          matchingLabel_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Policy tag resource name, in the format of
     * `projects/{project_number}/locations/{location_id}/taxonomies/{taxonomy_id}/policyTags/{policyTag_id}`.
     * </pre>
     *
     * <code>string policy_tag = 4;</code>
     *
     * @param value The policyTag to set.
     * @return This builder for chaining.
     */
    public Builder setPolicyTag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      matchingLabelCase_ = 4;
      matchingLabel_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Policy tag resource name, in the format of
     * `projects/{project_number}/locations/{location_id}/taxonomies/{taxonomy_id}/policyTags/{policyTag_id}`.
     * </pre>
     *
     * <code>string policy_tag = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPolicyTag() {
      if (matchingLabelCase_ == 4) {
        matchingLabelCase_ = 0;
        matchingLabel_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Policy tag resource name, in the format of
     * `projects/{project_number}/locations/{location_id}/taxonomies/{taxonomy_id}/policyTags/{policyTag_id}`.
     * </pre>
     *
     * <code>string policy_tag = 4;</code>
     *
     * @param value The bytes for policyTag to set.
     * @return This builder for chaining.
     */
    public Builder setPolicyTagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      matchingLabelCase_ = 4;
      matchingLabel_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.datapolicies.v1beta1.DataMaskingPolicy,
            com.google.cloud.bigquery.datapolicies.v1beta1.DataMaskingPolicy.Builder,
            com.google.cloud.bigquery.datapolicies.v1beta1.DataMaskingPolicyOrBuilder>
        dataMaskingPolicyBuilder_;
    /**
     *
     *
     * <pre>
     * The data masking policy that specifies the data masking rule to use.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datapolicies.v1beta1.DataMaskingPolicy data_masking_policy = 5;
     * </code>
     *
     * @return Whether the dataMaskingPolicy field is set.
     */
    @java.lang.Override
    public boolean hasDataMaskingPolicy() {
      return policyCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * The data masking policy that specifies the data masking rule to use.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datapolicies.v1beta1.DataMaskingPolicy data_masking_policy = 5;
     * </code>
     *
     * @return The dataMaskingPolicy.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.datapolicies.v1beta1.DataMaskingPolicy getDataMaskingPolicy() {
      if (dataMaskingPolicyBuilder_ == null) {
        if (policyCase_ == 5) {
          return (com.google.cloud.bigquery.datapolicies.v1beta1.DataMaskingPolicy) policy_;
        }
        return com.google.cloud.bigquery.datapolicies.v1beta1.DataMaskingPolicy
            .getDefaultInstance();
      } else {
        if (policyCase_ == 5) {
          return dataMaskingPolicyBuilder_.getMessage();
        }
        return com.google.cloud.bigquery.datapolicies.v1beta1.DataMaskingPolicy
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The data masking policy that specifies the data masking rule to use.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datapolicies.v1beta1.DataMaskingPolicy data_masking_policy = 5;
     * </code>
     */
    public Builder setDataMaskingPolicy(
        com.google.cloud.bigquery.datapolicies.v1beta1.DataMaskingPolicy value) {
      if (dataMaskingPolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        policy_ = value;
        onChanged();
      } else {
        dataMaskingPolicyBuilder_.setMessage(value);
      }
      policyCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The data masking policy that specifies the data masking rule to use.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datapolicies.v1beta1.DataMaskingPolicy data_masking_policy = 5;
     * </code>
     */
    public Builder setDataMaskingPolicy(
        com.google.cloud.bigquery.datapolicies.v1beta1.DataMaskingPolicy.Builder builderForValue) {
      if (dataMaskingPolicyBuilder_ == null) {
        policy_ = builderForValue.build();
        onChanged();
      } else {
        dataMaskingPolicyBuilder_.setMessage(builderForValue.build());
      }
      policyCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The data masking policy that specifies the data masking rule to use.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datapolicies.v1beta1.DataMaskingPolicy data_masking_policy = 5;
     * </code>
     */
    public Builder mergeDataMaskingPolicy(
        com.google.cloud.bigquery.datapolicies.v1beta1.DataMaskingPolicy value) {
      if (dataMaskingPolicyBuilder_ == null) {
        if (policyCase_ == 5
            && policy_
                != com.google.cloud.bigquery.datapolicies.v1beta1.DataMaskingPolicy
                    .getDefaultInstance()) {
          policy_ =
              com.google.cloud.bigquery.datapolicies.v1beta1.DataMaskingPolicy.newBuilder(
                      (com.google.cloud.bigquery.datapolicies.v1beta1.DataMaskingPolicy) policy_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          policy_ = value;
        }
        onChanged();
      } else {
        if (policyCase_ == 5) {
          dataMaskingPolicyBuilder_.mergeFrom(value);
        } else {
          dataMaskingPolicyBuilder_.setMessage(value);
        }
      }
      policyCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The data masking policy that specifies the data masking rule to use.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datapolicies.v1beta1.DataMaskingPolicy data_masking_policy = 5;
     * </code>
     */
    public Builder clearDataMaskingPolicy() {
      if (dataMaskingPolicyBuilder_ == null) {
        if (policyCase_ == 5) {
          policyCase_ = 0;
          policy_ = null;
          onChanged();
        }
      } else {
        if (policyCase_ == 5) {
          policyCase_ = 0;
          policy_ = null;
        }
        dataMaskingPolicyBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The data masking policy that specifies the data masking rule to use.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datapolicies.v1beta1.DataMaskingPolicy data_masking_policy = 5;
     * </code>
     */
    public com.google.cloud.bigquery.datapolicies.v1beta1.DataMaskingPolicy.Builder
        getDataMaskingPolicyBuilder() {
      return getDataMaskingPolicyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The data masking policy that specifies the data masking rule to use.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datapolicies.v1beta1.DataMaskingPolicy data_masking_policy = 5;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.datapolicies.v1beta1.DataMaskingPolicyOrBuilder
        getDataMaskingPolicyOrBuilder() {
      if ((policyCase_ == 5) && (dataMaskingPolicyBuilder_ != null)) {
        return dataMaskingPolicyBuilder_.getMessageOrBuilder();
      } else {
        if (policyCase_ == 5) {
          return (com.google.cloud.bigquery.datapolicies.v1beta1.DataMaskingPolicy) policy_;
        }
        return com.google.cloud.bigquery.datapolicies.v1beta1.DataMaskingPolicy
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The data masking policy that specifies the data masking rule to use.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datapolicies.v1beta1.DataMaskingPolicy data_masking_policy = 5;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.datapolicies.v1beta1.DataMaskingPolicy,
            com.google.cloud.bigquery.datapolicies.v1beta1.DataMaskingPolicy.Builder,
            com.google.cloud.bigquery.datapolicies.v1beta1.DataMaskingPolicyOrBuilder>
        getDataMaskingPolicyFieldBuilder() {
      if (dataMaskingPolicyBuilder_ == null) {
        if (!(policyCase_ == 5)) {
          policy_ =
              com.google.cloud.bigquery.datapolicies.v1beta1.DataMaskingPolicy.getDefaultInstance();
        }
        dataMaskingPolicyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.datapolicies.v1beta1.DataMaskingPolicy,
                com.google.cloud.bigquery.datapolicies.v1beta1.DataMaskingPolicy.Builder,
                com.google.cloud.bigquery.datapolicies.v1beta1.DataMaskingPolicyOrBuilder>(
                (com.google.cloud.bigquery.datapolicies.v1beta1.DataMaskingPolicy) policy_,
                getParentForChildren(),
                isClean());
        policy_ = null;
      }
      policyCase_ = 5;
      onChanged();
      return dataMaskingPolicyBuilder_;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Resource name of this data policy, in the format of
     * `projects/{project_number}/locations/{location_id}/dataPolicies/{data_policy_id}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of this data policy, in the format of
     * `projects/{project_number}/locations/{location_id}/dataPolicies/{data_policy_id}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of this data policy, in the format of
     * `projects/{project_number}/locations/{location_id}/dataPolicies/{data_policy_id}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of this data policy, in the format of
     * `projects/{project_number}/locations/{location_id}/dataPolicies/{data_policy_id}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of this data policy, in the format of
     * `projects/{project_number}/locations/{location_id}/dataPolicies/{data_policy_id}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private int dataPolicyType_ = 0;
    /**
     *
     *
     * <pre>
     * Type of data policy.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datapolicies.v1beta1.DataPolicy.DataPolicyType data_policy_type = 2;
     * </code>
     *
     * @return The enum numeric value on the wire for dataPolicyType.
     */
    @java.lang.Override
    public int getDataPolicyTypeValue() {
      return dataPolicyType_;
    }
    /**
     *
     *
     * <pre>
     * Type of data policy.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datapolicies.v1beta1.DataPolicy.DataPolicyType data_policy_type = 2;
     * </code>
     *
     * @param value The enum numeric value on the wire for dataPolicyType to set.
     * @return This builder for chaining.
     */
    public Builder setDataPolicyTypeValue(int value) {
      dataPolicyType_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of data policy.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datapolicies.v1beta1.DataPolicy.DataPolicyType data_policy_type = 2;
     * </code>
     *
     * @return The dataPolicyType.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.datapolicies.v1beta1.DataPolicy.DataPolicyType
        getDataPolicyType() {
      com.google.cloud.bigquery.datapolicies.v1beta1.DataPolicy.DataPolicyType result =
          com.google.cloud.bigquery.datapolicies.v1beta1.DataPolicy.DataPolicyType.forNumber(
              dataPolicyType_);
      return result == null
          ? com.google.cloud.bigquery.datapolicies.v1beta1.DataPolicy.DataPolicyType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Type of data policy.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datapolicies.v1beta1.DataPolicy.DataPolicyType data_policy_type = 2;
     * </code>
     *
     * @param value The dataPolicyType to set.
     * @return This builder for chaining.
     */
    public Builder setDataPolicyType(
        com.google.cloud.bigquery.datapolicies.v1beta1.DataPolicy.DataPolicyType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      dataPolicyType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of data policy.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datapolicies.v1beta1.DataPolicy.DataPolicyType data_policy_type = 2;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDataPolicyType() {
      bitField0_ = (bitField0_ & ~0x00000008);
      dataPolicyType_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object dataPolicyId_ = "";
    /**
     *
     *
     * <pre>
     * User-assigned (human readable) ID of the data policy that needs to be
     * unique within a project. Used as {data_policy_id} in part of the resource
     * name.
     * </pre>
     *
     * <code>string data_policy_id = 3;</code>
     *
     * @return The dataPolicyId.
     */
    public java.lang.String getDataPolicyId() {
      java.lang.Object ref = dataPolicyId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dataPolicyId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * User-assigned (human readable) ID of the data policy that needs to be
     * unique within a project. Used as {data_policy_id} in part of the resource
     * name.
     * </pre>
     *
     * <code>string data_policy_id = 3;</code>
     *
     * @return The bytes for dataPolicyId.
     */
    public com.google.protobuf.ByteString getDataPolicyIdBytes() {
      java.lang.Object ref = dataPolicyId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dataPolicyId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * User-assigned (human readable) ID of the data policy that needs to be
     * unique within a project. Used as {data_policy_id} in part of the resource
     * name.
     * </pre>
     *
     * <code>string data_policy_id = 3;</code>
     *
     * @param value The dataPolicyId to set.
     * @return This builder for chaining.
     */
    public Builder setDataPolicyId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      dataPolicyId_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-assigned (human readable) ID of the data policy that needs to be
     * unique within a project. Used as {data_policy_id} in part of the resource
     * name.
     * </pre>
     *
     * <code>string data_policy_id = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDataPolicyId() {
      dataPolicyId_ = getDefaultInstance().getDataPolicyId();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-assigned (human readable) ID of the data policy that needs to be
     * unique within a project. Used as {data_policy_id} in part of the resource
     * name.
     * </pre>
     *
     * <code>string data_policy_id = 3;</code>
     *
     * @param value The bytes for dataPolicyId to set.
     * @return This builder for chaining.
     */
    public Builder setDataPolicyIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      dataPolicyId_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.datapolicies.v1beta1.DataPolicy)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.bigquery.datapolicies.v1beta1.DataPolicy)
  private static final com.google.cloud.bigquery.datapolicies.v1beta1.DataPolicy DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.bigquery.datapolicies.v1beta1.DataPolicy();
  }

  public static com.google.cloud.bigquery.datapolicies.v1beta1.DataPolicy getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DataPolicy> PARSER =
      new com.google.protobuf.AbstractParser<DataPolicy>() {
        @java.lang.Override
        public DataPolicy parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DataPolicy> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DataPolicy> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.bigquery.datapolicies.v1beta1.DataPolicy getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
