/*
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/datatransfer/v1/datasource.proto

package com.google.cloud.bigquery.datatransfer.v1;

/**
 *
 *
 * <pre>
 * Represents the data source definition.
 * </pre>
 *
 * Protobuf type {@code google.cloud.bigquery.datatransfer.v1.DataSourceDefinition}
 */
public final class DataSourceDefinition extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.bigquery.datatransfer.v1.DataSourceDefinition)
    DataSourceDefinitionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DataSourceDefinition.newBuilder() to construct.
  private DataSourceDefinition(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DataSourceDefinition() {
    name_ = "";
    transferRunPubsubTopic_ = "";
    supportEmail_ = "";
    serviceAccount_ = "";
    transferConfigPubsubTopic_ = "";
    supportedLocationIds_ = com.google.protobuf.LazyStringArrayList.EMPTY;
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private DataSourceDefinition(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              com.google.cloud.bigquery.datatransfer.v1.DataSource.Builder subBuilder = null;
              if (dataSource_ != null) {
                subBuilder = dataSource_.toBuilder();
              }
              dataSource_ =
                  input.readMessage(
                      com.google.cloud.bigquery.datatransfer.v1.DataSource.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(dataSource_);
                dataSource_ = subBuilder.buildPartial();
              }

              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();

              serviceAccount_ = s;
              break;
            }
          case 40:
            {
              disabled_ = input.readBool();
              break;
            }
          case 98:
            {
              java.lang.String s = input.readStringRequireUtf8();

              transferConfigPubsubTopic_ = s;
              break;
            }
          case 106:
            {
              java.lang.String s = input.readStringRequireUtf8();

              transferRunPubsubTopic_ = s;
              break;
            }
          case 130:
            {
              com.google.protobuf.Duration.Builder subBuilder = null;
              if (runTimeOffset_ != null) {
                subBuilder = runTimeOffset_.toBuilder();
              }
              runTimeOffset_ =
                  input.readMessage(com.google.protobuf.Duration.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(runTimeOffset_);
                runTimeOffset_ = subBuilder.buildPartial();
              }

              break;
            }
          case 170:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 178:
            {
              java.lang.String s = input.readStringRequireUtf8();

              supportEmail_ = s;
              break;
            }
          case 186:
            {
              java.lang.String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000100) != 0)) {
                supportedLocationIds_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000100;
              }
              supportedLocationIds_.add(s);
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000100) != 0)) {
        supportedLocationIds_ = supportedLocationIds_.getUnmodifiableView();
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.bigquery.datatransfer.v1.DataSourceProto
        .internal_static_google_cloud_bigquery_datatransfer_v1_DataSourceDefinition_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.bigquery.datatransfer.v1.DataSourceProto
        .internal_static_google_cloud_bigquery_datatransfer_v1_DataSourceDefinition_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition.class,
            com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 21;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * The resource name of the data source definition.
   * Data source definition names have the form
   * `projects/{project_id}/locations/{location}/dataSourceDefinitions/{data_source_id}`.
   * </pre>
   *
   * <code>string name = 21;</code>
   */
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name of the data source definition.
   * Data source definition names have the form
   * `projects/{project_id}/locations/{location}/dataSourceDefinitions/{data_source_id}`.
   * </pre>
   *
   * <code>string name = 21;</code>
   */
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATA_SOURCE_FIELD_NUMBER = 1;
  private com.google.cloud.bigquery.datatransfer.v1.DataSource dataSource_;
  /**
   *
   *
   * <pre>
   * Data source metadata.
   * </pre>
   *
   * <code>.google.cloud.bigquery.datatransfer.v1.DataSource data_source = 1;</code>
   */
  public boolean hasDataSource() {
    return dataSource_ != null;
  }
  /**
   *
   *
   * <pre>
   * Data source metadata.
   * </pre>
   *
   * <code>.google.cloud.bigquery.datatransfer.v1.DataSource data_source = 1;</code>
   */
  public com.google.cloud.bigquery.datatransfer.v1.DataSource getDataSource() {
    return dataSource_ == null
        ? com.google.cloud.bigquery.datatransfer.v1.DataSource.getDefaultInstance()
        : dataSource_;
  }
  /**
   *
   *
   * <pre>
   * Data source metadata.
   * </pre>
   *
   * <code>.google.cloud.bigquery.datatransfer.v1.DataSource data_source = 1;</code>
   */
  public com.google.cloud.bigquery.datatransfer.v1.DataSourceOrBuilder getDataSourceOrBuilder() {
    return getDataSource();
  }

  public static final int TRANSFER_RUN_PUBSUB_TOPIC_FIELD_NUMBER = 13;
  private volatile java.lang.Object transferRunPubsubTopic_;
  /**
   *
   *
   * <pre>
   * The Pub/Sub topic to be used for broadcasting a message when a transfer run
   * is created. Both this topic and transfer_config_pubsub_topic can be
   * set to a custom topic. By default, both topics are auto-generated if none
   * of them is provided when creating the definition. However, if one topic is
   * manually set, the other topic has to be manually set as well. The only
   * difference is that transfer_run_pubsub_topic must be a non-empty Pub/Sub
   * topic, but transfer_config_pubsub_topic can be set to empty. The comments
   * about "{location}" for transfer_config_pubsub_topic apply here too.
   * </pre>
   *
   * <code>string transfer_run_pubsub_topic = 13;</code>
   */
  public java.lang.String getTransferRunPubsubTopic() {
    java.lang.Object ref = transferRunPubsubTopic_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      transferRunPubsubTopic_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The Pub/Sub topic to be used for broadcasting a message when a transfer run
   * is created. Both this topic and transfer_config_pubsub_topic can be
   * set to a custom topic. By default, both topics are auto-generated if none
   * of them is provided when creating the definition. However, if one topic is
   * manually set, the other topic has to be manually set as well. The only
   * difference is that transfer_run_pubsub_topic must be a non-empty Pub/Sub
   * topic, but transfer_config_pubsub_topic can be set to empty. The comments
   * about "{location}" for transfer_config_pubsub_topic apply here too.
   * </pre>
   *
   * <code>string transfer_run_pubsub_topic = 13;</code>
   */
  public com.google.protobuf.ByteString getTransferRunPubsubTopicBytes() {
    java.lang.Object ref = transferRunPubsubTopic_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      transferRunPubsubTopic_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RUN_TIME_OFFSET_FIELD_NUMBER = 16;
  private com.google.protobuf.Duration runTimeOffset_;
  /**
   *
   *
   * <pre>
   * Duration which should be added to schedule_time to calculate
   * run_time when job is scheduled. Only applicable for automatically
   * scheduled transfer runs. Used to start a run early on a data source that
   * supports continuous data refresh to compensate for unknown timezone
   * offsets. Use a negative number to start a run late for data sources not
   * supporting continuous data refresh.
   * </pre>
   *
   * <code>.google.protobuf.Duration run_time_offset = 16;</code>
   */
  public boolean hasRunTimeOffset() {
    return runTimeOffset_ != null;
  }
  /**
   *
   *
   * <pre>
   * Duration which should be added to schedule_time to calculate
   * run_time when job is scheduled. Only applicable for automatically
   * scheduled transfer runs. Used to start a run early on a data source that
   * supports continuous data refresh to compensate for unknown timezone
   * offsets. Use a negative number to start a run late for data sources not
   * supporting continuous data refresh.
   * </pre>
   *
   * <code>.google.protobuf.Duration run_time_offset = 16;</code>
   */
  public com.google.protobuf.Duration getRunTimeOffset() {
    return runTimeOffset_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : runTimeOffset_;
  }
  /**
   *
   *
   * <pre>
   * Duration which should be added to schedule_time to calculate
   * run_time when job is scheduled. Only applicable for automatically
   * scheduled transfer runs. Used to start a run early on a data source that
   * supports continuous data refresh to compensate for unknown timezone
   * offsets. Use a negative number to start a run late for data sources not
   * supporting continuous data refresh.
   * </pre>
   *
   * <code>.google.protobuf.Duration run_time_offset = 16;</code>
   */
  public com.google.protobuf.DurationOrBuilder getRunTimeOffsetOrBuilder() {
    return getRunTimeOffset();
  }

  public static final int SUPPORT_EMAIL_FIELD_NUMBER = 22;
  private volatile java.lang.Object supportEmail_;
  /**
   *
   *
   * <pre>
   * Support e-mail address of the OAuth client's Brand, which contains the
   * consent screen data.
   * </pre>
   *
   * <code>string support_email = 22;</code>
   */
  public java.lang.String getSupportEmail() {
    java.lang.Object ref = supportEmail_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      supportEmail_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Support e-mail address of the OAuth client's Brand, which contains the
   * consent screen data.
   * </pre>
   *
   * <code>string support_email = 22;</code>
   */
  public com.google.protobuf.ByteString getSupportEmailBytes() {
    java.lang.Object ref = supportEmail_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      supportEmail_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SERVICE_ACCOUNT_FIELD_NUMBER = 2;
  private volatile java.lang.Object serviceAccount_;
  /**
   *
   *
   * <pre>
   * When service account is specified, BigQuery will share created dataset
   * with the given service account. Also, this service account will be
   * eligible to perform status updates and message logging for data transfer
   * runs for the corresponding data_source_id.
   * </pre>
   *
   * <code>string service_account = 2;</code>
   */
  public java.lang.String getServiceAccount() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceAccount_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * When service account is specified, BigQuery will share created dataset
   * with the given service account. Also, this service account will be
   * eligible to perform status updates and message logging for data transfer
   * runs for the corresponding data_source_id.
   * </pre>
   *
   * <code>string service_account = 2;</code>
   */
  public com.google.protobuf.ByteString getServiceAccountBytes() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceAccount_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISABLED_FIELD_NUMBER = 5;
  private boolean disabled_;
  /**
   *
   *
   * <pre>
   * Is data source disabled? If true, data_source is not visible.
   * API will also stop returning any data transfer configs and/or runs
   * associated with the data source. This setting has higher priority
   * than whitelisted_project_ids.
   * </pre>
   *
   * <code>bool disabled = 5;</code>
   */
  public boolean getDisabled() {
    return disabled_;
  }

  public static final int TRANSFER_CONFIG_PUBSUB_TOPIC_FIELD_NUMBER = 12;
  private volatile java.lang.Object transferConfigPubsubTopic_;
  /**
   *
   *
   * <pre>
   * The Pub/Sub topic to use for broadcasting a message for transfer config. If
   * empty, a message will not be broadcasted. Both this topic and
   * transfer_run_pubsub_topic are auto-generated if none of them is provided
   * when creating the definition. It is recommended to provide
   * transfer_config_pubsub_topic if a user-owned transfer_run_pubsub_topic is
   * provided. Otherwise, it will be set to empty. If "{location}" is found in
   * the value, then that means, data source wants to handle message separately
   * for datasets in different regions. We will replace {location} with the
   * actual dataset location, as the actual topic name. For example,
   * projects/connector/topics/scheduler-{location} could become
   * projects/connector/topics/scheduler-us. If "{location}" is not found, then
   * we will use the input value as topic name.
   * </pre>
   *
   * <code>string transfer_config_pubsub_topic = 12;</code>
   */
  public java.lang.String getTransferConfigPubsubTopic() {
    java.lang.Object ref = transferConfigPubsubTopic_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      transferConfigPubsubTopic_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The Pub/Sub topic to use for broadcasting a message for transfer config. If
   * empty, a message will not be broadcasted. Both this topic and
   * transfer_run_pubsub_topic are auto-generated if none of them is provided
   * when creating the definition. It is recommended to provide
   * transfer_config_pubsub_topic if a user-owned transfer_run_pubsub_topic is
   * provided. Otherwise, it will be set to empty. If "{location}" is found in
   * the value, then that means, data source wants to handle message separately
   * for datasets in different regions. We will replace {location} with the
   * actual dataset location, as the actual topic name. For example,
   * projects/connector/topics/scheduler-{location} could become
   * projects/connector/topics/scheduler-us. If "{location}" is not found, then
   * we will use the input value as topic name.
   * </pre>
   *
   * <code>string transfer_config_pubsub_topic = 12;</code>
   */
  public com.google.protobuf.ByteString getTransferConfigPubsubTopicBytes() {
    java.lang.Object ref = transferConfigPubsubTopic_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      transferConfigPubsubTopic_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SUPPORTED_LOCATION_IDS_FIELD_NUMBER = 23;
  private com.google.protobuf.LazyStringList supportedLocationIds_;
  /**
   *
   *
   * <pre>
   * Supported location_ids used for deciding in which locations Pub/Sub topics
   * need to be created. If custom Pub/Sub topics are used and they contains
   * '{location}', the location_ids will be used for validating the topics by
   * replacing the '{location}' with the individual location in the list. The
   * valid values are the "location_id" field of the response of `GET
   * https://bigquerydatatransfer.googleapis.com/v1/{name=projects/&#42;}/locations`
   * In addition, if the data source needs to support all available regions,
   * supported_location_ids can be set to "global" (a single string element).
   * When "global" is specified:
   * 1) the data source implementation is supposed to stage the data in proper
   * region of the destination dataset;
   * 2) Data source developer should be aware of the implications (e.g., network
   * traffic latency, potential charge associated with cross-region traffic,
   * etc.) of supporting the "global" region;
   * </pre>
   *
   * <code>repeated string supported_location_ids = 23;</code>
   */
  public com.google.protobuf.ProtocolStringList getSupportedLocationIdsList() {
    return supportedLocationIds_;
  }
  /**
   *
   *
   * <pre>
   * Supported location_ids used for deciding in which locations Pub/Sub topics
   * need to be created. If custom Pub/Sub topics are used and they contains
   * '{location}', the location_ids will be used for validating the topics by
   * replacing the '{location}' with the individual location in the list. The
   * valid values are the "location_id" field of the response of `GET
   * https://bigquerydatatransfer.googleapis.com/v1/{name=projects/&#42;}/locations`
   * In addition, if the data source needs to support all available regions,
   * supported_location_ids can be set to "global" (a single string element).
   * When "global" is specified:
   * 1) the data source implementation is supposed to stage the data in proper
   * region of the destination dataset;
   * 2) Data source developer should be aware of the implications (e.g., network
   * traffic latency, potential charge associated with cross-region traffic,
   * etc.) of supporting the "global" region;
   * </pre>
   *
   * <code>repeated string supported_location_ids = 23;</code>
   */
  public int getSupportedLocationIdsCount() {
    return supportedLocationIds_.size();
  }
  /**
   *
   *
   * <pre>
   * Supported location_ids used for deciding in which locations Pub/Sub topics
   * need to be created. If custom Pub/Sub topics are used and they contains
   * '{location}', the location_ids will be used for validating the topics by
   * replacing the '{location}' with the individual location in the list. The
   * valid values are the "location_id" field of the response of `GET
   * https://bigquerydatatransfer.googleapis.com/v1/{name=projects/&#42;}/locations`
   * In addition, if the data source needs to support all available regions,
   * supported_location_ids can be set to "global" (a single string element).
   * When "global" is specified:
   * 1) the data source implementation is supposed to stage the data in proper
   * region of the destination dataset;
   * 2) Data source developer should be aware of the implications (e.g., network
   * traffic latency, potential charge associated with cross-region traffic,
   * etc.) of supporting the "global" region;
   * </pre>
   *
   * <code>repeated string supported_location_ids = 23;</code>
   */
  public java.lang.String getSupportedLocationIds(int index) {
    return supportedLocationIds_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Supported location_ids used for deciding in which locations Pub/Sub topics
   * need to be created. If custom Pub/Sub topics are used and they contains
   * '{location}', the location_ids will be used for validating the topics by
   * replacing the '{location}' with the individual location in the list. The
   * valid values are the "location_id" field of the response of `GET
   * https://bigquerydatatransfer.googleapis.com/v1/{name=projects/&#42;}/locations`
   * In addition, if the data source needs to support all available regions,
   * supported_location_ids can be set to "global" (a single string element).
   * When "global" is specified:
   * 1) the data source implementation is supposed to stage the data in proper
   * region of the destination dataset;
   * 2) Data source developer should be aware of the implications (e.g., network
   * traffic latency, potential charge associated with cross-region traffic,
   * etc.) of supporting the "global" region;
   * </pre>
   *
   * <code>repeated string supported_location_ids = 23;</code>
   */
  public com.google.protobuf.ByteString getSupportedLocationIdsBytes(int index) {
    return supportedLocationIds_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (dataSource_ != null) {
      output.writeMessage(1, getDataSource());
    }
    if (!getServiceAccountBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, serviceAccount_);
    }
    if (disabled_ != false) {
      output.writeBool(5, disabled_);
    }
    if (!getTransferConfigPubsubTopicBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, transferConfigPubsubTopic_);
    }
    if (!getTransferRunPubsubTopicBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 13, transferRunPubsubTopic_);
    }
    if (runTimeOffset_ != null) {
      output.writeMessage(16, getRunTimeOffset());
    }
    if (!getNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 21, name_);
    }
    if (!getSupportEmailBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 22, supportEmail_);
    }
    for (int i = 0; i < supportedLocationIds_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 23, supportedLocationIds_.getRaw(i));
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (dataSource_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getDataSource());
    }
    if (!getServiceAccountBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, serviceAccount_);
    }
    if (disabled_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, disabled_);
    }
    if (!getTransferConfigPubsubTopicBytes().isEmpty()) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(12, transferConfigPubsubTopic_);
    }
    if (!getTransferRunPubsubTopicBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(13, transferRunPubsubTopic_);
    }
    if (runTimeOffset_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(16, getRunTimeOffset());
    }
    if (!getNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(21, name_);
    }
    if (!getSupportEmailBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(22, supportEmail_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < supportedLocationIds_.size(); i++) {
        dataSize += computeStringSizeNoTag(supportedLocationIds_.getRaw(i));
      }
      size += dataSize;
      size += 2 * getSupportedLocationIdsList().size();
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition)) {
      return super.equals(obj);
    }
    com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition other =
        (com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasDataSource() != other.hasDataSource()) return false;
    if (hasDataSource()) {
      if (!getDataSource().equals(other.getDataSource())) return false;
    }
    if (!getTransferRunPubsubTopic().equals(other.getTransferRunPubsubTopic())) return false;
    if (hasRunTimeOffset() != other.hasRunTimeOffset()) return false;
    if (hasRunTimeOffset()) {
      if (!getRunTimeOffset().equals(other.getRunTimeOffset())) return false;
    }
    if (!getSupportEmail().equals(other.getSupportEmail())) return false;
    if (!getServiceAccount().equals(other.getServiceAccount())) return false;
    if (getDisabled() != other.getDisabled()) return false;
    if (!getTransferConfigPubsubTopic().equals(other.getTransferConfigPubsubTopic())) return false;
    if (!getSupportedLocationIdsList().equals(other.getSupportedLocationIdsList())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasDataSource()) {
      hash = (37 * hash) + DATA_SOURCE_FIELD_NUMBER;
      hash = (53 * hash) + getDataSource().hashCode();
    }
    hash = (37 * hash) + TRANSFER_RUN_PUBSUB_TOPIC_FIELD_NUMBER;
    hash = (53 * hash) + getTransferRunPubsubTopic().hashCode();
    if (hasRunTimeOffset()) {
      hash = (37 * hash) + RUN_TIME_OFFSET_FIELD_NUMBER;
      hash = (53 * hash) + getRunTimeOffset().hashCode();
    }
    hash = (37 * hash) + SUPPORT_EMAIL_FIELD_NUMBER;
    hash = (53 * hash) + getSupportEmail().hashCode();
    hash = (37 * hash) + SERVICE_ACCOUNT_FIELD_NUMBER;
    hash = (53 * hash) + getServiceAccount().hashCode();
    hash = (37 * hash) + DISABLED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDisabled());
    hash = (37 * hash) + TRANSFER_CONFIG_PUBSUB_TOPIC_FIELD_NUMBER;
    hash = (53 * hash) + getTransferConfigPubsubTopic().hashCode();
    if (getSupportedLocationIdsCount() > 0) {
      hash = (37 * hash) + SUPPORTED_LOCATION_IDS_FIELD_NUMBER;
      hash = (53 * hash) + getSupportedLocationIdsList().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents the data source definition.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.datatransfer.v1.DataSourceDefinition}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.datatransfer.v1.DataSourceDefinition)
      com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinitionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.datatransfer.v1.DataSourceProto
          .internal_static_google_cloud_bigquery_datatransfer_v1_DataSourceDefinition_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.datatransfer.v1.DataSourceProto
          .internal_static_google_cloud_bigquery_datatransfer_v1_DataSourceDefinition_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition.class,
              com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition.Builder.class);
    }

    // Construct using com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      if (dataSourceBuilder_ == null) {
        dataSource_ = null;
      } else {
        dataSource_ = null;
        dataSourceBuilder_ = null;
      }
      transferRunPubsubTopic_ = "";

      if (runTimeOffsetBuilder_ == null) {
        runTimeOffset_ = null;
      } else {
        runTimeOffset_ = null;
        runTimeOffsetBuilder_ = null;
      }
      supportEmail_ = "";

      serviceAccount_ = "";

      disabled_ = false;

      transferConfigPubsubTopic_ = "";

      supportedLocationIds_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000100);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.bigquery.datatransfer.v1.DataSourceProto
          .internal_static_google_cloud_bigquery_datatransfer_v1_DataSourceDefinition_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition
        getDefaultInstanceForType() {
      return com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition build() {
      com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition buildPartial() {
      com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition result =
          new com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      result.name_ = name_;
      if (dataSourceBuilder_ == null) {
        result.dataSource_ = dataSource_;
      } else {
        result.dataSource_ = dataSourceBuilder_.build();
      }
      result.transferRunPubsubTopic_ = transferRunPubsubTopic_;
      if (runTimeOffsetBuilder_ == null) {
        result.runTimeOffset_ = runTimeOffset_;
      } else {
        result.runTimeOffset_ = runTimeOffsetBuilder_.build();
      }
      result.supportEmail_ = supportEmail_;
      result.serviceAccount_ = serviceAccount_;
      result.disabled_ = disabled_;
      result.transferConfigPubsubTopic_ = transferConfigPubsubTopic_;
      if (((bitField0_ & 0x00000100) != 0)) {
        supportedLocationIds_ = supportedLocationIds_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000100);
      }
      result.supportedLocationIds_ = supportedLocationIds_;
      result.bitField0_ = to_bitField0_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition) {
        return mergeFrom((com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition other) {
      if (other
          == com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (other.hasDataSource()) {
        mergeDataSource(other.getDataSource());
      }
      if (!other.getTransferRunPubsubTopic().isEmpty()) {
        transferRunPubsubTopic_ = other.transferRunPubsubTopic_;
        onChanged();
      }
      if (other.hasRunTimeOffset()) {
        mergeRunTimeOffset(other.getRunTimeOffset());
      }
      if (!other.getSupportEmail().isEmpty()) {
        supportEmail_ = other.supportEmail_;
        onChanged();
      }
      if (!other.getServiceAccount().isEmpty()) {
        serviceAccount_ = other.serviceAccount_;
        onChanged();
      }
      if (other.getDisabled() != false) {
        setDisabled(other.getDisabled());
      }
      if (!other.getTransferConfigPubsubTopic().isEmpty()) {
        transferConfigPubsubTopic_ = other.transferConfigPubsubTopic_;
        onChanged();
      }
      if (!other.supportedLocationIds_.isEmpty()) {
        if (supportedLocationIds_.isEmpty()) {
          supportedLocationIds_ = other.supportedLocationIds_;
          bitField0_ = (bitField0_ & ~0x00000100);
        } else {
          ensureSupportedLocationIdsIsMutable();
          supportedLocationIds_.addAll(other.supportedLocationIds_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition)
                e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The resource name of the data source definition.
     * Data source definition names have the form
     * `projects/{project_id}/locations/{location}/dataSourceDefinitions/{data_source_id}`.
     * </pre>
     *
     * <code>string name = 21;</code>
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the data source definition.
     * Data source definition names have the form
     * `projects/{project_id}/locations/{location}/dataSourceDefinitions/{data_source_id}`.
     * </pre>
     *
     * <code>string name = 21;</code>
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the data source definition.
     * Data source definition names have the form
     * `projects/{project_id}/locations/{location}/dataSourceDefinitions/{data_source_id}`.
     * </pre>
     *
     * <code>string name = 21;</code>
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the data source definition.
     * Data source definition names have the form
     * `projects/{project_id}/locations/{location}/dataSourceDefinitions/{data_source_id}`.
     * </pre>
     *
     * <code>string name = 21;</code>
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the data source definition.
     * Data source definition names have the form
     * `projects/{project_id}/locations/{location}/dataSourceDefinitions/{data_source_id}`.
     * </pre>
     *
     * <code>string name = 21;</code>
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private com.google.cloud.bigquery.datatransfer.v1.DataSource dataSource_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.datatransfer.v1.DataSource,
            com.google.cloud.bigquery.datatransfer.v1.DataSource.Builder,
            com.google.cloud.bigquery.datatransfer.v1.DataSourceOrBuilder>
        dataSourceBuilder_;
    /**
     *
     *
     * <pre>
     * Data source metadata.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.DataSource data_source = 1;</code>
     */
    public boolean hasDataSource() {
      return dataSourceBuilder_ != null || dataSource_ != null;
    }
    /**
     *
     *
     * <pre>
     * Data source metadata.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.DataSource data_source = 1;</code>
     */
    public com.google.cloud.bigquery.datatransfer.v1.DataSource getDataSource() {
      if (dataSourceBuilder_ == null) {
        return dataSource_ == null
            ? com.google.cloud.bigquery.datatransfer.v1.DataSource.getDefaultInstance()
            : dataSource_;
      } else {
        return dataSourceBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Data source metadata.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.DataSource data_source = 1;</code>
     */
    public Builder setDataSource(com.google.cloud.bigquery.datatransfer.v1.DataSource value) {
      if (dataSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dataSource_ = value;
        onChanged();
      } else {
        dataSourceBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Data source metadata.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.DataSource data_source = 1;</code>
     */
    public Builder setDataSource(
        com.google.cloud.bigquery.datatransfer.v1.DataSource.Builder builderForValue) {
      if (dataSourceBuilder_ == null) {
        dataSource_ = builderForValue.build();
        onChanged();
      } else {
        dataSourceBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Data source metadata.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.DataSource data_source = 1;</code>
     */
    public Builder mergeDataSource(com.google.cloud.bigquery.datatransfer.v1.DataSource value) {
      if (dataSourceBuilder_ == null) {
        if (dataSource_ != null) {
          dataSource_ =
              com.google.cloud.bigquery.datatransfer.v1.DataSource.newBuilder(dataSource_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          dataSource_ = value;
        }
        onChanged();
      } else {
        dataSourceBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Data source metadata.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.DataSource data_source = 1;</code>
     */
    public Builder clearDataSource() {
      if (dataSourceBuilder_ == null) {
        dataSource_ = null;
        onChanged();
      } else {
        dataSource_ = null;
        dataSourceBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Data source metadata.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.DataSource data_source = 1;</code>
     */
    public com.google.cloud.bigquery.datatransfer.v1.DataSource.Builder getDataSourceBuilder() {

      onChanged();
      return getDataSourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Data source metadata.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.DataSource data_source = 1;</code>
     */
    public com.google.cloud.bigquery.datatransfer.v1.DataSourceOrBuilder getDataSourceOrBuilder() {
      if (dataSourceBuilder_ != null) {
        return dataSourceBuilder_.getMessageOrBuilder();
      } else {
        return dataSource_ == null
            ? com.google.cloud.bigquery.datatransfer.v1.DataSource.getDefaultInstance()
            : dataSource_;
      }
    }
    /**
     *
     *
     * <pre>
     * Data source metadata.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.DataSource data_source = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.datatransfer.v1.DataSource,
            com.google.cloud.bigquery.datatransfer.v1.DataSource.Builder,
            com.google.cloud.bigquery.datatransfer.v1.DataSourceOrBuilder>
        getDataSourceFieldBuilder() {
      if (dataSourceBuilder_ == null) {
        dataSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.datatransfer.v1.DataSource,
                com.google.cloud.bigquery.datatransfer.v1.DataSource.Builder,
                com.google.cloud.bigquery.datatransfer.v1.DataSourceOrBuilder>(
                getDataSource(), getParentForChildren(), isClean());
        dataSource_ = null;
      }
      return dataSourceBuilder_;
    }

    private java.lang.Object transferRunPubsubTopic_ = "";
    /**
     *
     *
     * <pre>
     * The Pub/Sub topic to be used for broadcasting a message when a transfer run
     * is created. Both this topic and transfer_config_pubsub_topic can be
     * set to a custom topic. By default, both topics are auto-generated if none
     * of them is provided when creating the definition. However, if one topic is
     * manually set, the other topic has to be manually set as well. The only
     * difference is that transfer_run_pubsub_topic must be a non-empty Pub/Sub
     * topic, but transfer_config_pubsub_topic can be set to empty. The comments
     * about "{location}" for transfer_config_pubsub_topic apply here too.
     * </pre>
     *
     * <code>string transfer_run_pubsub_topic = 13;</code>
     */
    public java.lang.String getTransferRunPubsubTopic() {
      java.lang.Object ref = transferRunPubsubTopic_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        transferRunPubsubTopic_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Pub/Sub topic to be used for broadcasting a message when a transfer run
     * is created. Both this topic and transfer_config_pubsub_topic can be
     * set to a custom topic. By default, both topics are auto-generated if none
     * of them is provided when creating the definition. However, if one topic is
     * manually set, the other topic has to be manually set as well. The only
     * difference is that transfer_run_pubsub_topic must be a non-empty Pub/Sub
     * topic, but transfer_config_pubsub_topic can be set to empty. The comments
     * about "{location}" for transfer_config_pubsub_topic apply here too.
     * </pre>
     *
     * <code>string transfer_run_pubsub_topic = 13;</code>
     */
    public com.google.protobuf.ByteString getTransferRunPubsubTopicBytes() {
      java.lang.Object ref = transferRunPubsubTopic_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        transferRunPubsubTopic_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Pub/Sub topic to be used for broadcasting a message when a transfer run
     * is created. Both this topic and transfer_config_pubsub_topic can be
     * set to a custom topic. By default, both topics are auto-generated if none
     * of them is provided when creating the definition. However, if one topic is
     * manually set, the other topic has to be manually set as well. The only
     * difference is that transfer_run_pubsub_topic must be a non-empty Pub/Sub
     * topic, but transfer_config_pubsub_topic can be set to empty. The comments
     * about "{location}" for transfer_config_pubsub_topic apply here too.
     * </pre>
     *
     * <code>string transfer_run_pubsub_topic = 13;</code>
     */
    public Builder setTransferRunPubsubTopic(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      transferRunPubsubTopic_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Pub/Sub topic to be used for broadcasting a message when a transfer run
     * is created. Both this topic and transfer_config_pubsub_topic can be
     * set to a custom topic. By default, both topics are auto-generated if none
     * of them is provided when creating the definition. However, if one topic is
     * manually set, the other topic has to be manually set as well. The only
     * difference is that transfer_run_pubsub_topic must be a non-empty Pub/Sub
     * topic, but transfer_config_pubsub_topic can be set to empty. The comments
     * about "{location}" for transfer_config_pubsub_topic apply here too.
     * </pre>
     *
     * <code>string transfer_run_pubsub_topic = 13;</code>
     */
    public Builder clearTransferRunPubsubTopic() {

      transferRunPubsubTopic_ = getDefaultInstance().getTransferRunPubsubTopic();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Pub/Sub topic to be used for broadcasting a message when a transfer run
     * is created. Both this topic and transfer_config_pubsub_topic can be
     * set to a custom topic. By default, both topics are auto-generated if none
     * of them is provided when creating the definition. However, if one topic is
     * manually set, the other topic has to be manually set as well. The only
     * difference is that transfer_run_pubsub_topic must be a non-empty Pub/Sub
     * topic, but transfer_config_pubsub_topic can be set to empty. The comments
     * about "{location}" for transfer_config_pubsub_topic apply here too.
     * </pre>
     *
     * <code>string transfer_run_pubsub_topic = 13;</code>
     */
    public Builder setTransferRunPubsubTopicBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      transferRunPubsubTopic_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.Duration runTimeOffset_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        runTimeOffsetBuilder_;
    /**
     *
     *
     * <pre>
     * Duration which should be added to schedule_time to calculate
     * run_time when job is scheduled. Only applicable for automatically
     * scheduled transfer runs. Used to start a run early on a data source that
     * supports continuous data refresh to compensate for unknown timezone
     * offsets. Use a negative number to start a run late for data sources not
     * supporting continuous data refresh.
     * </pre>
     *
     * <code>.google.protobuf.Duration run_time_offset = 16;</code>
     */
    public boolean hasRunTimeOffset() {
      return runTimeOffsetBuilder_ != null || runTimeOffset_ != null;
    }
    /**
     *
     *
     * <pre>
     * Duration which should be added to schedule_time to calculate
     * run_time when job is scheduled. Only applicable for automatically
     * scheduled transfer runs. Used to start a run early on a data source that
     * supports continuous data refresh to compensate for unknown timezone
     * offsets. Use a negative number to start a run late for data sources not
     * supporting continuous data refresh.
     * </pre>
     *
     * <code>.google.protobuf.Duration run_time_offset = 16;</code>
     */
    public com.google.protobuf.Duration getRunTimeOffset() {
      if (runTimeOffsetBuilder_ == null) {
        return runTimeOffset_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : runTimeOffset_;
      } else {
        return runTimeOffsetBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Duration which should be added to schedule_time to calculate
     * run_time when job is scheduled. Only applicable for automatically
     * scheduled transfer runs. Used to start a run early on a data source that
     * supports continuous data refresh to compensate for unknown timezone
     * offsets. Use a negative number to start a run late for data sources not
     * supporting continuous data refresh.
     * </pre>
     *
     * <code>.google.protobuf.Duration run_time_offset = 16;</code>
     */
    public Builder setRunTimeOffset(com.google.protobuf.Duration value) {
      if (runTimeOffsetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        runTimeOffset_ = value;
        onChanged();
      } else {
        runTimeOffsetBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Duration which should be added to schedule_time to calculate
     * run_time when job is scheduled. Only applicable for automatically
     * scheduled transfer runs. Used to start a run early on a data source that
     * supports continuous data refresh to compensate for unknown timezone
     * offsets. Use a negative number to start a run late for data sources not
     * supporting continuous data refresh.
     * </pre>
     *
     * <code>.google.protobuf.Duration run_time_offset = 16;</code>
     */
    public Builder setRunTimeOffset(com.google.protobuf.Duration.Builder builderForValue) {
      if (runTimeOffsetBuilder_ == null) {
        runTimeOffset_ = builderForValue.build();
        onChanged();
      } else {
        runTimeOffsetBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Duration which should be added to schedule_time to calculate
     * run_time when job is scheduled. Only applicable for automatically
     * scheduled transfer runs. Used to start a run early on a data source that
     * supports continuous data refresh to compensate for unknown timezone
     * offsets. Use a negative number to start a run late for data sources not
     * supporting continuous data refresh.
     * </pre>
     *
     * <code>.google.protobuf.Duration run_time_offset = 16;</code>
     */
    public Builder mergeRunTimeOffset(com.google.protobuf.Duration value) {
      if (runTimeOffsetBuilder_ == null) {
        if (runTimeOffset_ != null) {
          runTimeOffset_ =
              com.google.protobuf.Duration.newBuilder(runTimeOffset_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          runTimeOffset_ = value;
        }
        onChanged();
      } else {
        runTimeOffsetBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Duration which should be added to schedule_time to calculate
     * run_time when job is scheduled. Only applicable for automatically
     * scheduled transfer runs. Used to start a run early on a data source that
     * supports continuous data refresh to compensate for unknown timezone
     * offsets. Use a negative number to start a run late for data sources not
     * supporting continuous data refresh.
     * </pre>
     *
     * <code>.google.protobuf.Duration run_time_offset = 16;</code>
     */
    public Builder clearRunTimeOffset() {
      if (runTimeOffsetBuilder_ == null) {
        runTimeOffset_ = null;
        onChanged();
      } else {
        runTimeOffset_ = null;
        runTimeOffsetBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Duration which should be added to schedule_time to calculate
     * run_time when job is scheduled. Only applicable for automatically
     * scheduled transfer runs. Used to start a run early on a data source that
     * supports continuous data refresh to compensate for unknown timezone
     * offsets. Use a negative number to start a run late for data sources not
     * supporting continuous data refresh.
     * </pre>
     *
     * <code>.google.protobuf.Duration run_time_offset = 16;</code>
     */
    public com.google.protobuf.Duration.Builder getRunTimeOffsetBuilder() {

      onChanged();
      return getRunTimeOffsetFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Duration which should be added to schedule_time to calculate
     * run_time when job is scheduled. Only applicable for automatically
     * scheduled transfer runs. Used to start a run early on a data source that
     * supports continuous data refresh to compensate for unknown timezone
     * offsets. Use a negative number to start a run late for data sources not
     * supporting continuous data refresh.
     * </pre>
     *
     * <code>.google.protobuf.Duration run_time_offset = 16;</code>
     */
    public com.google.protobuf.DurationOrBuilder getRunTimeOffsetOrBuilder() {
      if (runTimeOffsetBuilder_ != null) {
        return runTimeOffsetBuilder_.getMessageOrBuilder();
      } else {
        return runTimeOffset_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : runTimeOffset_;
      }
    }
    /**
     *
     *
     * <pre>
     * Duration which should be added to schedule_time to calculate
     * run_time when job is scheduled. Only applicable for automatically
     * scheduled transfer runs. Used to start a run early on a data source that
     * supports continuous data refresh to compensate for unknown timezone
     * offsets. Use a negative number to start a run late for data sources not
     * supporting continuous data refresh.
     * </pre>
     *
     * <code>.google.protobuf.Duration run_time_offset = 16;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getRunTimeOffsetFieldBuilder() {
      if (runTimeOffsetBuilder_ == null) {
        runTimeOffsetBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getRunTimeOffset(), getParentForChildren(), isClean());
        runTimeOffset_ = null;
      }
      return runTimeOffsetBuilder_;
    }

    private java.lang.Object supportEmail_ = "";
    /**
     *
     *
     * <pre>
     * Support e-mail address of the OAuth client's Brand, which contains the
     * consent screen data.
     * </pre>
     *
     * <code>string support_email = 22;</code>
     */
    public java.lang.String getSupportEmail() {
      java.lang.Object ref = supportEmail_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        supportEmail_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Support e-mail address of the OAuth client's Brand, which contains the
     * consent screen data.
     * </pre>
     *
     * <code>string support_email = 22;</code>
     */
    public com.google.protobuf.ByteString getSupportEmailBytes() {
      java.lang.Object ref = supportEmail_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        supportEmail_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Support e-mail address of the OAuth client's Brand, which contains the
     * consent screen data.
     * </pre>
     *
     * <code>string support_email = 22;</code>
     */
    public Builder setSupportEmail(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      supportEmail_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Support e-mail address of the OAuth client's Brand, which contains the
     * consent screen data.
     * </pre>
     *
     * <code>string support_email = 22;</code>
     */
    public Builder clearSupportEmail() {

      supportEmail_ = getDefaultInstance().getSupportEmail();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Support e-mail address of the OAuth client's Brand, which contains the
     * consent screen data.
     * </pre>
     *
     * <code>string support_email = 22;</code>
     */
    public Builder setSupportEmailBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      supportEmail_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object serviceAccount_ = "";
    /**
     *
     *
     * <pre>
     * When service account is specified, BigQuery will share created dataset
     * with the given service account. Also, this service account will be
     * eligible to perform status updates and message logging for data transfer
     * runs for the corresponding data_source_id.
     * </pre>
     *
     * <code>string service_account = 2;</code>
     */
    public java.lang.String getServiceAccount() {
      java.lang.Object ref = serviceAccount_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceAccount_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * When service account is specified, BigQuery will share created dataset
     * with the given service account. Also, this service account will be
     * eligible to perform status updates and message logging for data transfer
     * runs for the corresponding data_source_id.
     * </pre>
     *
     * <code>string service_account = 2;</code>
     */
    public com.google.protobuf.ByteString getServiceAccountBytes() {
      java.lang.Object ref = serviceAccount_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceAccount_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * When service account is specified, BigQuery will share created dataset
     * with the given service account. Also, this service account will be
     * eligible to perform status updates and message logging for data transfer
     * runs for the corresponding data_source_id.
     * </pre>
     *
     * <code>string service_account = 2;</code>
     */
    public Builder setServiceAccount(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      serviceAccount_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * When service account is specified, BigQuery will share created dataset
     * with the given service account. Also, this service account will be
     * eligible to perform status updates and message logging for data transfer
     * runs for the corresponding data_source_id.
     * </pre>
     *
     * <code>string service_account = 2;</code>
     */
    public Builder clearServiceAccount() {

      serviceAccount_ = getDefaultInstance().getServiceAccount();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * When service account is specified, BigQuery will share created dataset
     * with the given service account. Also, this service account will be
     * eligible to perform status updates and message logging for data transfer
     * runs for the corresponding data_source_id.
     * </pre>
     *
     * <code>string service_account = 2;</code>
     */
    public Builder setServiceAccountBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      serviceAccount_ = value;
      onChanged();
      return this;
    }

    private boolean disabled_;
    /**
     *
     *
     * <pre>
     * Is data source disabled? If true, data_source is not visible.
     * API will also stop returning any data transfer configs and/or runs
     * associated with the data source. This setting has higher priority
     * than whitelisted_project_ids.
     * </pre>
     *
     * <code>bool disabled = 5;</code>
     */
    public boolean getDisabled() {
      return disabled_;
    }
    /**
     *
     *
     * <pre>
     * Is data source disabled? If true, data_source is not visible.
     * API will also stop returning any data transfer configs and/or runs
     * associated with the data source. This setting has higher priority
     * than whitelisted_project_ids.
     * </pre>
     *
     * <code>bool disabled = 5;</code>
     */
    public Builder setDisabled(boolean value) {

      disabled_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Is data source disabled? If true, data_source is not visible.
     * API will also stop returning any data transfer configs and/or runs
     * associated with the data source. This setting has higher priority
     * than whitelisted_project_ids.
     * </pre>
     *
     * <code>bool disabled = 5;</code>
     */
    public Builder clearDisabled() {

      disabled_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object transferConfigPubsubTopic_ = "";
    /**
     *
     *
     * <pre>
     * The Pub/Sub topic to use for broadcasting a message for transfer config. If
     * empty, a message will not be broadcasted. Both this topic and
     * transfer_run_pubsub_topic are auto-generated if none of them is provided
     * when creating the definition. It is recommended to provide
     * transfer_config_pubsub_topic if a user-owned transfer_run_pubsub_topic is
     * provided. Otherwise, it will be set to empty. If "{location}" is found in
     * the value, then that means, data source wants to handle message separately
     * for datasets in different regions. We will replace {location} with the
     * actual dataset location, as the actual topic name. For example,
     * projects/connector/topics/scheduler-{location} could become
     * projects/connector/topics/scheduler-us. If "{location}" is not found, then
     * we will use the input value as topic name.
     * </pre>
     *
     * <code>string transfer_config_pubsub_topic = 12;</code>
     */
    public java.lang.String getTransferConfigPubsubTopic() {
      java.lang.Object ref = transferConfigPubsubTopic_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        transferConfigPubsubTopic_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Pub/Sub topic to use for broadcasting a message for transfer config. If
     * empty, a message will not be broadcasted. Both this topic and
     * transfer_run_pubsub_topic are auto-generated if none of them is provided
     * when creating the definition. It is recommended to provide
     * transfer_config_pubsub_topic if a user-owned transfer_run_pubsub_topic is
     * provided. Otherwise, it will be set to empty. If "{location}" is found in
     * the value, then that means, data source wants to handle message separately
     * for datasets in different regions. We will replace {location} with the
     * actual dataset location, as the actual topic name. For example,
     * projects/connector/topics/scheduler-{location} could become
     * projects/connector/topics/scheduler-us. If "{location}" is not found, then
     * we will use the input value as topic name.
     * </pre>
     *
     * <code>string transfer_config_pubsub_topic = 12;</code>
     */
    public com.google.protobuf.ByteString getTransferConfigPubsubTopicBytes() {
      java.lang.Object ref = transferConfigPubsubTopic_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        transferConfigPubsubTopic_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Pub/Sub topic to use for broadcasting a message for transfer config. If
     * empty, a message will not be broadcasted. Both this topic and
     * transfer_run_pubsub_topic are auto-generated if none of them is provided
     * when creating the definition. It is recommended to provide
     * transfer_config_pubsub_topic if a user-owned transfer_run_pubsub_topic is
     * provided. Otherwise, it will be set to empty. If "{location}" is found in
     * the value, then that means, data source wants to handle message separately
     * for datasets in different regions. We will replace {location} with the
     * actual dataset location, as the actual topic name. For example,
     * projects/connector/topics/scheduler-{location} could become
     * projects/connector/topics/scheduler-us. If "{location}" is not found, then
     * we will use the input value as topic name.
     * </pre>
     *
     * <code>string transfer_config_pubsub_topic = 12;</code>
     */
    public Builder setTransferConfigPubsubTopic(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      transferConfigPubsubTopic_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Pub/Sub topic to use for broadcasting a message for transfer config. If
     * empty, a message will not be broadcasted. Both this topic and
     * transfer_run_pubsub_topic are auto-generated if none of them is provided
     * when creating the definition. It is recommended to provide
     * transfer_config_pubsub_topic if a user-owned transfer_run_pubsub_topic is
     * provided. Otherwise, it will be set to empty. If "{location}" is found in
     * the value, then that means, data source wants to handle message separately
     * for datasets in different regions. We will replace {location} with the
     * actual dataset location, as the actual topic name. For example,
     * projects/connector/topics/scheduler-{location} could become
     * projects/connector/topics/scheduler-us. If "{location}" is not found, then
     * we will use the input value as topic name.
     * </pre>
     *
     * <code>string transfer_config_pubsub_topic = 12;</code>
     */
    public Builder clearTransferConfigPubsubTopic() {

      transferConfigPubsubTopic_ = getDefaultInstance().getTransferConfigPubsubTopic();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Pub/Sub topic to use for broadcasting a message for transfer config. If
     * empty, a message will not be broadcasted. Both this topic and
     * transfer_run_pubsub_topic are auto-generated if none of them is provided
     * when creating the definition. It is recommended to provide
     * transfer_config_pubsub_topic if a user-owned transfer_run_pubsub_topic is
     * provided. Otherwise, it will be set to empty. If "{location}" is found in
     * the value, then that means, data source wants to handle message separately
     * for datasets in different regions. We will replace {location} with the
     * actual dataset location, as the actual topic name. For example,
     * projects/connector/topics/scheduler-{location} could become
     * projects/connector/topics/scheduler-us. If "{location}" is not found, then
     * we will use the input value as topic name.
     * </pre>
     *
     * <code>string transfer_config_pubsub_topic = 12;</code>
     */
    public Builder setTransferConfigPubsubTopicBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      transferConfigPubsubTopic_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList supportedLocationIds_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureSupportedLocationIdsIsMutable() {
      if (!((bitField0_ & 0x00000100) != 0)) {
        supportedLocationIds_ = new com.google.protobuf.LazyStringArrayList(supportedLocationIds_);
        bitField0_ |= 0x00000100;
      }
    }
    /**
     *
     *
     * <pre>
     * Supported location_ids used for deciding in which locations Pub/Sub topics
     * need to be created. If custom Pub/Sub topics are used and they contains
     * '{location}', the location_ids will be used for validating the topics by
     * replacing the '{location}' with the individual location in the list. The
     * valid values are the "location_id" field of the response of `GET
     * https://bigquerydatatransfer.googleapis.com/v1/{name=projects/&#42;}/locations`
     * In addition, if the data source needs to support all available regions,
     * supported_location_ids can be set to "global" (a single string element).
     * When "global" is specified:
     * 1) the data source implementation is supposed to stage the data in proper
     * region of the destination dataset;
     * 2) Data source developer should be aware of the implications (e.g., network
     * traffic latency, potential charge associated with cross-region traffic,
     * etc.) of supporting the "global" region;
     * </pre>
     *
     * <code>repeated string supported_location_ids = 23;</code>
     */
    public com.google.protobuf.ProtocolStringList getSupportedLocationIdsList() {
      return supportedLocationIds_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * Supported location_ids used for deciding in which locations Pub/Sub topics
     * need to be created. If custom Pub/Sub topics are used and they contains
     * '{location}', the location_ids will be used for validating the topics by
     * replacing the '{location}' with the individual location in the list. The
     * valid values are the "location_id" field of the response of `GET
     * https://bigquerydatatransfer.googleapis.com/v1/{name=projects/&#42;}/locations`
     * In addition, if the data source needs to support all available regions,
     * supported_location_ids can be set to "global" (a single string element).
     * When "global" is specified:
     * 1) the data source implementation is supposed to stage the data in proper
     * region of the destination dataset;
     * 2) Data source developer should be aware of the implications (e.g., network
     * traffic latency, potential charge associated with cross-region traffic,
     * etc.) of supporting the "global" region;
     * </pre>
     *
     * <code>repeated string supported_location_ids = 23;</code>
     */
    public int getSupportedLocationIdsCount() {
      return supportedLocationIds_.size();
    }
    /**
     *
     *
     * <pre>
     * Supported location_ids used for deciding in which locations Pub/Sub topics
     * need to be created. If custom Pub/Sub topics are used and they contains
     * '{location}', the location_ids will be used for validating the topics by
     * replacing the '{location}' with the individual location in the list. The
     * valid values are the "location_id" field of the response of `GET
     * https://bigquerydatatransfer.googleapis.com/v1/{name=projects/&#42;}/locations`
     * In addition, if the data source needs to support all available regions,
     * supported_location_ids can be set to "global" (a single string element).
     * When "global" is specified:
     * 1) the data source implementation is supposed to stage the data in proper
     * region of the destination dataset;
     * 2) Data source developer should be aware of the implications (e.g., network
     * traffic latency, potential charge associated with cross-region traffic,
     * etc.) of supporting the "global" region;
     * </pre>
     *
     * <code>repeated string supported_location_ids = 23;</code>
     */
    public java.lang.String getSupportedLocationIds(int index) {
      return supportedLocationIds_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Supported location_ids used for deciding in which locations Pub/Sub topics
     * need to be created. If custom Pub/Sub topics are used and they contains
     * '{location}', the location_ids will be used for validating the topics by
     * replacing the '{location}' with the individual location in the list. The
     * valid values are the "location_id" field of the response of `GET
     * https://bigquerydatatransfer.googleapis.com/v1/{name=projects/&#42;}/locations`
     * In addition, if the data source needs to support all available regions,
     * supported_location_ids can be set to "global" (a single string element).
     * When "global" is specified:
     * 1) the data source implementation is supposed to stage the data in proper
     * region of the destination dataset;
     * 2) Data source developer should be aware of the implications (e.g., network
     * traffic latency, potential charge associated with cross-region traffic,
     * etc.) of supporting the "global" region;
     * </pre>
     *
     * <code>repeated string supported_location_ids = 23;</code>
     */
    public com.google.protobuf.ByteString getSupportedLocationIdsBytes(int index) {
      return supportedLocationIds_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Supported location_ids used for deciding in which locations Pub/Sub topics
     * need to be created. If custom Pub/Sub topics are used and they contains
     * '{location}', the location_ids will be used for validating the topics by
     * replacing the '{location}' with the individual location in the list. The
     * valid values are the "location_id" field of the response of `GET
     * https://bigquerydatatransfer.googleapis.com/v1/{name=projects/&#42;}/locations`
     * In addition, if the data source needs to support all available regions,
     * supported_location_ids can be set to "global" (a single string element).
     * When "global" is specified:
     * 1) the data source implementation is supposed to stage the data in proper
     * region of the destination dataset;
     * 2) Data source developer should be aware of the implications (e.g., network
     * traffic latency, potential charge associated with cross-region traffic,
     * etc.) of supporting the "global" region;
     * </pre>
     *
     * <code>repeated string supported_location_ids = 23;</code>
     */
    public Builder setSupportedLocationIds(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSupportedLocationIdsIsMutable();
      supportedLocationIds_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Supported location_ids used for deciding in which locations Pub/Sub topics
     * need to be created. If custom Pub/Sub topics are used and they contains
     * '{location}', the location_ids will be used for validating the topics by
     * replacing the '{location}' with the individual location in the list. The
     * valid values are the "location_id" field of the response of `GET
     * https://bigquerydatatransfer.googleapis.com/v1/{name=projects/&#42;}/locations`
     * In addition, if the data source needs to support all available regions,
     * supported_location_ids can be set to "global" (a single string element).
     * When "global" is specified:
     * 1) the data source implementation is supposed to stage the data in proper
     * region of the destination dataset;
     * 2) Data source developer should be aware of the implications (e.g., network
     * traffic latency, potential charge associated with cross-region traffic,
     * etc.) of supporting the "global" region;
     * </pre>
     *
     * <code>repeated string supported_location_ids = 23;</code>
     */
    public Builder addSupportedLocationIds(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSupportedLocationIdsIsMutable();
      supportedLocationIds_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Supported location_ids used for deciding in which locations Pub/Sub topics
     * need to be created. If custom Pub/Sub topics are used and they contains
     * '{location}', the location_ids will be used for validating the topics by
     * replacing the '{location}' with the individual location in the list. The
     * valid values are the "location_id" field of the response of `GET
     * https://bigquerydatatransfer.googleapis.com/v1/{name=projects/&#42;}/locations`
     * In addition, if the data source needs to support all available regions,
     * supported_location_ids can be set to "global" (a single string element).
     * When "global" is specified:
     * 1) the data source implementation is supposed to stage the data in proper
     * region of the destination dataset;
     * 2) Data source developer should be aware of the implications (e.g., network
     * traffic latency, potential charge associated with cross-region traffic,
     * etc.) of supporting the "global" region;
     * </pre>
     *
     * <code>repeated string supported_location_ids = 23;</code>
     */
    public Builder addAllSupportedLocationIds(java.lang.Iterable<java.lang.String> values) {
      ensureSupportedLocationIdsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, supportedLocationIds_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Supported location_ids used for deciding in which locations Pub/Sub topics
     * need to be created. If custom Pub/Sub topics are used and they contains
     * '{location}', the location_ids will be used for validating the topics by
     * replacing the '{location}' with the individual location in the list. The
     * valid values are the "location_id" field of the response of `GET
     * https://bigquerydatatransfer.googleapis.com/v1/{name=projects/&#42;}/locations`
     * In addition, if the data source needs to support all available regions,
     * supported_location_ids can be set to "global" (a single string element).
     * When "global" is specified:
     * 1) the data source implementation is supposed to stage the data in proper
     * region of the destination dataset;
     * 2) Data source developer should be aware of the implications (e.g., network
     * traffic latency, potential charge associated with cross-region traffic,
     * etc.) of supporting the "global" region;
     * </pre>
     *
     * <code>repeated string supported_location_ids = 23;</code>
     */
    public Builder clearSupportedLocationIds() {
      supportedLocationIds_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Supported location_ids used for deciding in which locations Pub/Sub topics
     * need to be created. If custom Pub/Sub topics are used and they contains
     * '{location}', the location_ids will be used for validating the topics by
     * replacing the '{location}' with the individual location in the list. The
     * valid values are the "location_id" field of the response of `GET
     * https://bigquerydatatransfer.googleapis.com/v1/{name=projects/&#42;}/locations`
     * In addition, if the data source needs to support all available regions,
     * supported_location_ids can be set to "global" (a single string element).
     * When "global" is specified:
     * 1) the data source implementation is supposed to stage the data in proper
     * region of the destination dataset;
     * 2) Data source developer should be aware of the implications (e.g., network
     * traffic latency, potential charge associated with cross-region traffic,
     * etc.) of supporting the "global" region;
     * </pre>
     *
     * <code>repeated string supported_location_ids = 23;</code>
     */
    public Builder addSupportedLocationIdsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureSupportedLocationIdsIsMutable();
      supportedLocationIds_.add(value);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.datatransfer.v1.DataSourceDefinition)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.bigquery.datatransfer.v1.DataSourceDefinition)
  private static final com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition();
  }

  public static com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DataSourceDefinition> PARSER =
      new com.google.protobuf.AbstractParser<DataSourceDefinition>() {
        @java.lang.Override
        public DataSourceDefinition parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new DataSourceDefinition(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<DataSourceDefinition> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DataSourceDefinition> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
