/*
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/datatransfer/v1/datasource.proto

package com.google.cloud.bigquery.datatransfer.v1;

public interface DataSourceDefinitionOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.datatransfer.v1.DataSourceDefinition)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * The resource name of the data source definition.
   * Data source definition names have the form
   * `projects/{project_id}/locations/{location}/dataSourceDefinitions/{data_source_id}`.
   * </pre>
   *
   * <code>string name = 21;</code>
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * The resource name of the data source definition.
   * Data source definition names have the form
   * `projects/{project_id}/locations/{location}/dataSourceDefinitions/{data_source_id}`.
   * </pre>
   *
   * <code>string name = 21;</code>
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Data source metadata.
   * </pre>
   *
   * <code>.google.cloud.bigquery.datatransfer.v1.DataSource data_source = 1;</code>
   */
  boolean hasDataSource();
  /**
   *
   *
   * <pre>
   * Data source metadata.
   * </pre>
   *
   * <code>.google.cloud.bigquery.datatransfer.v1.DataSource data_source = 1;</code>
   */
  com.google.cloud.bigquery.datatransfer.v1.DataSource getDataSource();
  /**
   *
   *
   * <pre>
   * Data source metadata.
   * </pre>
   *
   * <code>.google.cloud.bigquery.datatransfer.v1.DataSource data_source = 1;</code>
   */
  com.google.cloud.bigquery.datatransfer.v1.DataSourceOrBuilder getDataSourceOrBuilder();

  /**
   *
   *
   * <pre>
   * The Pub/Sub topic to be used for broadcasting a message when a transfer run
   * is created. Both this topic and transfer_config_pubsub_topic can be
   * set to a custom topic. By default, both topics are auto-generated if none
   * of them is provided when creating the definition. However, if one topic is
   * manually set, the other topic has to be manually set as well. The only
   * difference is that transfer_run_pubsub_topic must be a non-empty Pub/Sub
   * topic, but transfer_config_pubsub_topic can be set to empty. The comments
   * about "{location}" for transfer_config_pubsub_topic apply here too.
   * </pre>
   *
   * <code>string transfer_run_pubsub_topic = 13;</code>
   */
  java.lang.String getTransferRunPubsubTopic();
  /**
   *
   *
   * <pre>
   * The Pub/Sub topic to be used for broadcasting a message when a transfer run
   * is created. Both this topic and transfer_config_pubsub_topic can be
   * set to a custom topic. By default, both topics are auto-generated if none
   * of them is provided when creating the definition. However, if one topic is
   * manually set, the other topic has to be manually set as well. The only
   * difference is that transfer_run_pubsub_topic must be a non-empty Pub/Sub
   * topic, but transfer_config_pubsub_topic can be set to empty. The comments
   * about "{location}" for transfer_config_pubsub_topic apply here too.
   * </pre>
   *
   * <code>string transfer_run_pubsub_topic = 13;</code>
   */
  com.google.protobuf.ByteString getTransferRunPubsubTopicBytes();

  /**
   *
   *
   * <pre>
   * Duration which should be added to schedule_time to calculate
   * run_time when job is scheduled. Only applicable for automatically
   * scheduled transfer runs. Used to start a run early on a data source that
   * supports continuous data refresh to compensate for unknown timezone
   * offsets. Use a negative number to start a run late for data sources not
   * supporting continuous data refresh.
   * </pre>
   *
   * <code>.google.protobuf.Duration run_time_offset = 16;</code>
   */
  boolean hasRunTimeOffset();
  /**
   *
   *
   * <pre>
   * Duration which should be added to schedule_time to calculate
   * run_time when job is scheduled. Only applicable for automatically
   * scheduled transfer runs. Used to start a run early on a data source that
   * supports continuous data refresh to compensate for unknown timezone
   * offsets. Use a negative number to start a run late for data sources not
   * supporting continuous data refresh.
   * </pre>
   *
   * <code>.google.protobuf.Duration run_time_offset = 16;</code>
   */
  com.google.protobuf.Duration getRunTimeOffset();
  /**
   *
   *
   * <pre>
   * Duration which should be added to schedule_time to calculate
   * run_time when job is scheduled. Only applicable for automatically
   * scheduled transfer runs. Used to start a run early on a data source that
   * supports continuous data refresh to compensate for unknown timezone
   * offsets. Use a negative number to start a run late for data sources not
   * supporting continuous data refresh.
   * </pre>
   *
   * <code>.google.protobuf.Duration run_time_offset = 16;</code>
   */
  com.google.protobuf.DurationOrBuilder getRunTimeOffsetOrBuilder();

  /**
   *
   *
   * <pre>
   * Support e-mail address of the OAuth client's Brand, which contains the
   * consent screen data.
   * </pre>
   *
   * <code>string support_email = 22;</code>
   */
  java.lang.String getSupportEmail();
  /**
   *
   *
   * <pre>
   * Support e-mail address of the OAuth client's Brand, which contains the
   * consent screen data.
   * </pre>
   *
   * <code>string support_email = 22;</code>
   */
  com.google.protobuf.ByteString getSupportEmailBytes();

  /**
   *
   *
   * <pre>
   * When service account is specified, BigQuery will share created dataset
   * with the given service account. Also, this service account will be
   * eligible to perform status updates and message logging for data transfer
   * runs for the corresponding data_source_id.
   * </pre>
   *
   * <code>string service_account = 2;</code>
   */
  java.lang.String getServiceAccount();
  /**
   *
   *
   * <pre>
   * When service account is specified, BigQuery will share created dataset
   * with the given service account. Also, this service account will be
   * eligible to perform status updates and message logging for data transfer
   * runs for the corresponding data_source_id.
   * </pre>
   *
   * <code>string service_account = 2;</code>
   */
  com.google.protobuf.ByteString getServiceAccountBytes();

  /**
   *
   *
   * <pre>
   * Is data source disabled? If true, data_source is not visible.
   * API will also stop returning any data transfer configs and/or runs
   * associated with the data source. This setting has higher priority
   * than whitelisted_project_ids.
   * </pre>
   *
   * <code>bool disabled = 5;</code>
   */
  boolean getDisabled();

  /**
   *
   *
   * <pre>
   * The Pub/Sub topic to use for broadcasting a message for transfer config. If
   * empty, a message will not be broadcasted. Both this topic and
   * transfer_run_pubsub_topic are auto-generated if none of them is provided
   * when creating the definition. It is recommended to provide
   * transfer_config_pubsub_topic if a user-owned transfer_run_pubsub_topic is
   * provided. Otherwise, it will be set to empty. If "{location}" is found in
   * the value, then that means, data source wants to handle message separately
   * for datasets in different regions. We will replace {location} with the
   * actual dataset location, as the actual topic name. For example,
   * projects/connector/topics/scheduler-{location} could become
   * projects/connector/topics/scheduler-us. If "{location}" is not found, then
   * we will use the input value as topic name.
   * </pre>
   *
   * <code>string transfer_config_pubsub_topic = 12;</code>
   */
  java.lang.String getTransferConfigPubsubTopic();
  /**
   *
   *
   * <pre>
   * The Pub/Sub topic to use for broadcasting a message for transfer config. If
   * empty, a message will not be broadcasted. Both this topic and
   * transfer_run_pubsub_topic are auto-generated if none of them is provided
   * when creating the definition. It is recommended to provide
   * transfer_config_pubsub_topic if a user-owned transfer_run_pubsub_topic is
   * provided. Otherwise, it will be set to empty. If "{location}" is found in
   * the value, then that means, data source wants to handle message separately
   * for datasets in different regions. We will replace {location} with the
   * actual dataset location, as the actual topic name. For example,
   * projects/connector/topics/scheduler-{location} could become
   * projects/connector/topics/scheduler-us. If "{location}" is not found, then
   * we will use the input value as topic name.
   * </pre>
   *
   * <code>string transfer_config_pubsub_topic = 12;</code>
   */
  com.google.protobuf.ByteString getTransferConfigPubsubTopicBytes();

  /**
   *
   *
   * <pre>
   * Supported location_ids used for deciding in which locations Pub/Sub topics
   * need to be created. If custom Pub/Sub topics are used and they contains
   * '{location}', the location_ids will be used for validating the topics by
   * replacing the '{location}' with the individual location in the list. The
   * valid values are the "location_id" field of the response of `GET
   * https://bigquerydatatransfer.googleapis.com/v1/{name=projects/&#42;}/locations`
   * In addition, if the data source needs to support all available regions,
   * supported_location_ids can be set to "global" (a single string element).
   * When "global" is specified:
   * 1) the data source implementation is supposed to stage the data in proper
   * region of the destination dataset;
   * 2) Data source developer should be aware of the implications (e.g., network
   * traffic latency, potential charge associated with cross-region traffic,
   * etc.) of supporting the "global" region;
   * </pre>
   *
   * <code>repeated string supported_location_ids = 23;</code>
   */
  java.util.List<java.lang.String> getSupportedLocationIdsList();
  /**
   *
   *
   * <pre>
   * Supported location_ids used for deciding in which locations Pub/Sub topics
   * need to be created. If custom Pub/Sub topics are used and they contains
   * '{location}', the location_ids will be used for validating the topics by
   * replacing the '{location}' with the individual location in the list. The
   * valid values are the "location_id" field of the response of `GET
   * https://bigquerydatatransfer.googleapis.com/v1/{name=projects/&#42;}/locations`
   * In addition, if the data source needs to support all available regions,
   * supported_location_ids can be set to "global" (a single string element).
   * When "global" is specified:
   * 1) the data source implementation is supposed to stage the data in proper
   * region of the destination dataset;
   * 2) Data source developer should be aware of the implications (e.g., network
   * traffic latency, potential charge associated with cross-region traffic,
   * etc.) of supporting the "global" region;
   * </pre>
   *
   * <code>repeated string supported_location_ids = 23;</code>
   */
  int getSupportedLocationIdsCount();
  /**
   *
   *
   * <pre>
   * Supported location_ids used for deciding in which locations Pub/Sub topics
   * need to be created. If custom Pub/Sub topics are used and they contains
   * '{location}', the location_ids will be used for validating the topics by
   * replacing the '{location}' with the individual location in the list. The
   * valid values are the "location_id" field of the response of `GET
   * https://bigquerydatatransfer.googleapis.com/v1/{name=projects/&#42;}/locations`
   * In addition, if the data source needs to support all available regions,
   * supported_location_ids can be set to "global" (a single string element).
   * When "global" is specified:
   * 1) the data source implementation is supposed to stage the data in proper
   * region of the destination dataset;
   * 2) Data source developer should be aware of the implications (e.g., network
   * traffic latency, potential charge associated with cross-region traffic,
   * etc.) of supporting the "global" region;
   * </pre>
   *
   * <code>repeated string supported_location_ids = 23;</code>
   */
  java.lang.String getSupportedLocationIds(int index);
  /**
   *
   *
   * <pre>
   * Supported location_ids used for deciding in which locations Pub/Sub topics
   * need to be created. If custom Pub/Sub topics are used and they contains
   * '{location}', the location_ids will be used for validating the topics by
   * replacing the '{location}' with the individual location in the list. The
   * valid values are the "location_id" field of the response of `GET
   * https://bigquerydatatransfer.googleapis.com/v1/{name=projects/&#42;}/locations`
   * In addition, if the data source needs to support all available regions,
   * supported_location_ids can be set to "global" (a single string element).
   * When "global" is specified:
   * 1) the data source implementation is supposed to stage the data in proper
   * region of the destination dataset;
   * 2) Data source developer should be aware of the implications (e.g., network
   * traffic latency, potential charge associated with cross-region traffic,
   * etc.) of supporting the "global" region;
   * </pre>
   *
   * <code>repeated string supported_location_ids = 23;</code>
   */
  com.google.protobuf.ByteString getSupportedLocationIdsBytes(int index);
}
