/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/datatransfer/v1/datatransfer.proto

package com.google.cloud.bigquery.datatransfer.v1;

/**
 *
 *
 * <pre>
 * Defines the properties and custom parameters for a data source.
 * </pre>
 *
 * Protobuf type {@code google.cloud.bigquery.datatransfer.v1.DataSource}
 */
public final class DataSource extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.bigquery.datatransfer.v1.DataSource)
    DataSourceOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DataSource.newBuilder() to construct.
  private DataSource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DataSource() {
    name_ = "";
    dataSourceId_ = "";
    displayName_ = "";
    description_ = "";
    clientId_ = "";
    scopes_ = com.google.protobuf.LazyStringArrayList.emptyList();
    transferType_ = 0;
    defaultSchedule_ = "";
    parameters_ = java.util.Collections.emptyList();
    helpUrl_ = "";
    authorizationType_ = 0;
    dataRefreshType_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DataSource();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.bigquery.datatransfer.v1.DataTransferProto
        .internal_static_google_cloud_bigquery_datatransfer_v1_DataSource_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.bigquery.datatransfer.v1.DataTransferProto
        .internal_static_google_cloud_bigquery_datatransfer_v1_DataSource_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.bigquery.datatransfer.v1.DataSource.class,
            com.google.cloud.bigquery.datatransfer.v1.DataSource.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The type of authorization needed for this data source.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.bigquery.datatransfer.v1.DataSource.AuthorizationType}
   */
  public enum AuthorizationType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Type unspecified.
     * </pre>
     *
     * <code>AUTHORIZATION_TYPE_UNSPECIFIED = 0;</code>
     */
    AUTHORIZATION_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Use OAuth 2 authorization codes that can be exchanged
     * for a refresh token on the backend.
     * </pre>
     *
     * <code>AUTHORIZATION_CODE = 1;</code>
     */
    AUTHORIZATION_CODE(1),
    /**
     *
     *
     * <pre>
     * Return an authorization code for a given Google+ page that can then be
     * exchanged for a refresh token on the backend.
     * </pre>
     *
     * <code>GOOGLE_PLUS_AUTHORIZATION_CODE = 2;</code>
     */
    GOOGLE_PLUS_AUTHORIZATION_CODE(2),
    /**
     *
     *
     * <pre>
     * Use First Party OAuth.
     * </pre>
     *
     * <code>FIRST_PARTY_OAUTH = 3;</code>
     */
    FIRST_PARTY_OAUTH(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Type unspecified.
     * </pre>
     *
     * <code>AUTHORIZATION_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int AUTHORIZATION_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Use OAuth 2 authorization codes that can be exchanged
     * for a refresh token on the backend.
     * </pre>
     *
     * <code>AUTHORIZATION_CODE = 1;</code>
     */
    public static final int AUTHORIZATION_CODE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Return an authorization code for a given Google+ page that can then be
     * exchanged for a refresh token on the backend.
     * </pre>
     *
     * <code>GOOGLE_PLUS_AUTHORIZATION_CODE = 2;</code>
     */
    public static final int GOOGLE_PLUS_AUTHORIZATION_CODE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Use First Party OAuth.
     * </pre>
     *
     * <code>FIRST_PARTY_OAUTH = 3;</code>
     */
    public static final int FIRST_PARTY_OAUTH_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static AuthorizationType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static AuthorizationType forNumber(int value) {
      switch (value) {
        case 0:
          return AUTHORIZATION_TYPE_UNSPECIFIED;
        case 1:
          return AUTHORIZATION_CODE;
        case 2:
          return GOOGLE_PLUS_AUTHORIZATION_CODE;
        case 3:
          return FIRST_PARTY_OAUTH;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<AuthorizationType>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<AuthorizationType>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<AuthorizationType>() {
              public AuthorizationType findValueByNumber(int number) {
                return AuthorizationType.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.bigquery.datatransfer.v1.DataSource.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final AuthorizationType[] VALUES = values();

    public static AuthorizationType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private AuthorizationType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.bigquery.datatransfer.v1.DataSource.AuthorizationType)
  }

  /**
   *
   *
   * <pre>
   * Represents how the data source supports data auto refresh.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.bigquery.datatransfer.v1.DataSource.DataRefreshType}
   */
  public enum DataRefreshType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The data source won't support data auto refresh, which is default value.
     * </pre>
     *
     * <code>DATA_REFRESH_TYPE_UNSPECIFIED = 0;</code>
     */
    DATA_REFRESH_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The data source supports data auto refresh, and runs will be scheduled
     * for the past few days. Does not allow custom values to be set for each
     * transfer config.
     * </pre>
     *
     * <code>SLIDING_WINDOW = 1;</code>
     */
    SLIDING_WINDOW(1),
    /**
     *
     *
     * <pre>
     * The data source supports data auto refresh, and runs will be scheduled
     * for the past few days. Allows custom values to be set for each transfer
     * config.
     * </pre>
     *
     * <code>CUSTOM_SLIDING_WINDOW = 2;</code>
     */
    CUSTOM_SLIDING_WINDOW(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The data source won't support data auto refresh, which is default value.
     * </pre>
     *
     * <code>DATA_REFRESH_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int DATA_REFRESH_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The data source supports data auto refresh, and runs will be scheduled
     * for the past few days. Does not allow custom values to be set for each
     * transfer config.
     * </pre>
     *
     * <code>SLIDING_WINDOW = 1;</code>
     */
    public static final int SLIDING_WINDOW_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The data source supports data auto refresh, and runs will be scheduled
     * for the past few days. Allows custom values to be set for each transfer
     * config.
     * </pre>
     *
     * <code>CUSTOM_SLIDING_WINDOW = 2;</code>
     */
    public static final int CUSTOM_SLIDING_WINDOW_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DataRefreshType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static DataRefreshType forNumber(int value) {
      switch (value) {
        case 0:
          return DATA_REFRESH_TYPE_UNSPECIFIED;
        case 1:
          return SLIDING_WINDOW;
        case 2:
          return CUSTOM_SLIDING_WINDOW;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<DataRefreshType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<DataRefreshType>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<DataRefreshType>() {
              public DataRefreshType findValueByNumber(int number) {
                return DataRefreshType.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.bigquery.datatransfer.v1.DataSource.getDescriptor()
          .getEnumTypes()
          .get(1);
    }

    private static final DataRefreshType[] VALUES = values();

    public static DataRefreshType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private DataRefreshType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.bigquery.datatransfer.v1.DataSource.DataRefreshType)
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Data source resource name.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Data source resource name.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATA_SOURCE_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object dataSourceId_ = "";
  /**
   *
   *
   * <pre>
   * Data source id.
   * </pre>
   *
   * <code>string data_source_id = 2;</code>
   *
   * @return The dataSourceId.
   */
  @java.lang.Override
  public java.lang.String getDataSourceId() {
    java.lang.Object ref = dataSourceId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      dataSourceId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Data source id.
   * </pre>
   *
   * <code>string data_source_id = 2;</code>
   *
   * @return The bytes for dataSourceId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDataSourceIdBytes() {
    java.lang.Object ref = dataSourceId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      dataSourceId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * User friendly data source name.
   * </pre>
   *
   * <code>string display_name = 3;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * User friendly data source name.
   * </pre>
   *
   * <code>string display_name = 3;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * User friendly data source description string.
   * </pre>
   *
   * <code>string description = 4;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * User friendly data source description string.
   * </pre>
   *
   * <code>string description = 4;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CLIENT_ID_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object clientId_ = "";
  /**
   *
   *
   * <pre>
   * Data source client id which should be used to receive refresh token.
   * </pre>
   *
   * <code>string client_id = 5;</code>
   *
   * @return The clientId.
   */
  @java.lang.Override
  public java.lang.String getClientId() {
    java.lang.Object ref = clientId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      clientId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Data source client id which should be used to receive refresh token.
   * </pre>
   *
   * <code>string client_id = 5;</code>
   *
   * @return The bytes for clientId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getClientIdBytes() {
    java.lang.Object ref = clientId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      clientId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SCOPES_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList scopes_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Api auth scopes for which refresh token needs to be obtained. These are
   * scopes needed by a data source to prepare data and ingest them into
   * BigQuery, e.g., https://www.googleapis.com/auth/bigquery
   * </pre>
   *
   * <code>repeated string scopes = 6;</code>
   *
   * @return A list containing the scopes.
   */
  public com.google.protobuf.ProtocolStringList getScopesList() {
    return scopes_;
  }
  /**
   *
   *
   * <pre>
   * Api auth scopes for which refresh token needs to be obtained. These are
   * scopes needed by a data source to prepare data and ingest them into
   * BigQuery, e.g., https://www.googleapis.com/auth/bigquery
   * </pre>
   *
   * <code>repeated string scopes = 6;</code>
   *
   * @return The count of scopes.
   */
  public int getScopesCount() {
    return scopes_.size();
  }
  /**
   *
   *
   * <pre>
   * Api auth scopes for which refresh token needs to be obtained. These are
   * scopes needed by a data source to prepare data and ingest them into
   * BigQuery, e.g., https://www.googleapis.com/auth/bigquery
   * </pre>
   *
   * <code>repeated string scopes = 6;</code>
   *
   * @param index The index of the element to return.
   * @return The scopes at the given index.
   */
  public java.lang.String getScopes(int index) {
    return scopes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Api auth scopes for which refresh token needs to be obtained. These are
   * scopes needed by a data source to prepare data and ingest them into
   * BigQuery, e.g., https://www.googleapis.com/auth/bigquery
   * </pre>
   *
   * <code>repeated string scopes = 6;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the scopes at the given index.
   */
  public com.google.protobuf.ByteString getScopesBytes(int index) {
    return scopes_.getByteString(index);
  }

  public static final int TRANSFER_TYPE_FIELD_NUMBER = 7;
  private int transferType_ = 0;
  /**
   *
   *
   * <pre>
   * Deprecated. This field has no effect.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.datatransfer.v1.TransferType transfer_type = 7 [deprecated = true];
   * </code>
   *
   * @deprecated google.cloud.bigquery.datatransfer.v1.DataSource.transfer_type is deprecated. See
   *     google/cloud/bigquery/datatransfer/v1/datatransfer.proto;l=383
   * @return The enum numeric value on the wire for transferType.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public int getTransferTypeValue() {
    return transferType_;
  }
  /**
   *
   *
   * <pre>
   * Deprecated. This field has no effect.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.datatransfer.v1.TransferType transfer_type = 7 [deprecated = true];
   * </code>
   *
   * @deprecated google.cloud.bigquery.datatransfer.v1.DataSource.transfer_type is deprecated. See
   *     google/cloud/bigquery/datatransfer/v1/datatransfer.proto;l=383
   * @return The transferType.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.bigquery.datatransfer.v1.TransferType getTransferType() {
    com.google.cloud.bigquery.datatransfer.v1.TransferType result =
        com.google.cloud.bigquery.datatransfer.v1.TransferType.forNumber(transferType_);
    return result == null
        ? com.google.cloud.bigquery.datatransfer.v1.TransferType.UNRECOGNIZED
        : result;
  }

  public static final int SUPPORTS_MULTIPLE_TRANSFERS_FIELD_NUMBER = 8;
  private boolean supportsMultipleTransfers_ = false;
  /**
   *
   *
   * <pre>
   * Deprecated. This field has no effect.
   * </pre>
   *
   * <code>bool supports_multiple_transfers = 8 [deprecated = true];</code>
   *
   * @deprecated google.cloud.bigquery.datatransfer.v1.DataSource.supports_multiple_transfers is
   *     deprecated. See google/cloud/bigquery/datatransfer/v1/datatransfer.proto;l=386
   * @return The supportsMultipleTransfers.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public boolean getSupportsMultipleTransfers() {
    return supportsMultipleTransfers_;
  }

  public static final int UPDATE_DEADLINE_SECONDS_FIELD_NUMBER = 9;
  private int updateDeadlineSeconds_ = 0;
  /**
   *
   *
   * <pre>
   * The number of seconds to wait for an update from the data source
   * before the Data Transfer Service marks the transfer as FAILED.
   * </pre>
   *
   * <code>int32 update_deadline_seconds = 9;</code>
   *
   * @return The updateDeadlineSeconds.
   */
  @java.lang.Override
  public int getUpdateDeadlineSeconds() {
    return updateDeadlineSeconds_;
  }

  public static final int DEFAULT_SCHEDULE_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private volatile java.lang.Object defaultSchedule_ = "";
  /**
   *
   *
   * <pre>
   * Default data transfer schedule.
   * Examples of valid schedules include:
   * `1st,3rd monday of month 15:30`,
   * `every wed,fri of jan,jun 13:15`, and
   * `first sunday of quarter 00:00`.
   * </pre>
   *
   * <code>string default_schedule = 10;</code>
   *
   * @return The defaultSchedule.
   */
  @java.lang.Override
  public java.lang.String getDefaultSchedule() {
    java.lang.Object ref = defaultSchedule_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      defaultSchedule_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Default data transfer schedule.
   * Examples of valid schedules include:
   * `1st,3rd monday of month 15:30`,
   * `every wed,fri of jan,jun 13:15`, and
   * `first sunday of quarter 00:00`.
   * </pre>
   *
   * <code>string default_schedule = 10;</code>
   *
   * @return The bytes for defaultSchedule.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDefaultScheduleBytes() {
    java.lang.Object ref = defaultSchedule_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      defaultSchedule_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SUPPORTS_CUSTOM_SCHEDULE_FIELD_NUMBER = 11;
  private boolean supportsCustomSchedule_ = false;
  /**
   *
   *
   * <pre>
   * Specifies whether the data source supports a user defined schedule, or
   * operates on the default schedule.
   * When set to `true`, user can override default schedule.
   * </pre>
   *
   * <code>bool supports_custom_schedule = 11;</code>
   *
   * @return The supportsCustomSchedule.
   */
  @java.lang.Override
  public boolean getSupportsCustomSchedule() {
    return supportsCustomSchedule_;
  }

  public static final int PARAMETERS_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter> parameters_;
  /**
   *
   *
   * <pre>
   * Data source parameters.
   * </pre>
   *
   * <code>repeated .google.cloud.bigquery.datatransfer.v1.DataSourceParameter parameters = 12;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter>
      getParametersList() {
    return parameters_;
  }
  /**
   *
   *
   * <pre>
   * Data source parameters.
   * </pre>
   *
   * <code>repeated .google.cloud.bigquery.datatransfer.v1.DataSourceParameter parameters = 12;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.bigquery.datatransfer.v1.DataSourceParameterOrBuilder>
      getParametersOrBuilderList() {
    return parameters_;
  }
  /**
   *
   *
   * <pre>
   * Data source parameters.
   * </pre>
   *
   * <code>repeated .google.cloud.bigquery.datatransfer.v1.DataSourceParameter parameters = 12;
   * </code>
   */
  @java.lang.Override
  public int getParametersCount() {
    return parameters_.size();
  }
  /**
   *
   *
   * <pre>
   * Data source parameters.
   * </pre>
   *
   * <code>repeated .google.cloud.bigquery.datatransfer.v1.DataSourceParameter parameters = 12;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter getParameters(int index) {
    return parameters_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Data source parameters.
   * </pre>
   *
   * <code>repeated .google.cloud.bigquery.datatransfer.v1.DataSourceParameter parameters = 12;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.datatransfer.v1.DataSourceParameterOrBuilder
      getParametersOrBuilder(int index) {
    return parameters_.get(index);
  }

  public static final int HELP_URL_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private volatile java.lang.Object helpUrl_ = "";
  /**
   *
   *
   * <pre>
   * Url for the help document for this data source.
   * </pre>
   *
   * <code>string help_url = 13;</code>
   *
   * @return The helpUrl.
   */
  @java.lang.Override
  public java.lang.String getHelpUrl() {
    java.lang.Object ref = helpUrl_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      helpUrl_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Url for the help document for this data source.
   * </pre>
   *
   * <code>string help_url = 13;</code>
   *
   * @return The bytes for helpUrl.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getHelpUrlBytes() {
    java.lang.Object ref = helpUrl_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      helpUrl_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int AUTHORIZATION_TYPE_FIELD_NUMBER = 14;
  private int authorizationType_ = 0;
  /**
   *
   *
   * <pre>
   * Indicates the type of authorization.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.datatransfer.v1.DataSource.AuthorizationType authorization_type = 14;
   * </code>
   *
   * @return The enum numeric value on the wire for authorizationType.
   */
  @java.lang.Override
  public int getAuthorizationTypeValue() {
    return authorizationType_;
  }
  /**
   *
   *
   * <pre>
   * Indicates the type of authorization.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.datatransfer.v1.DataSource.AuthorizationType authorization_type = 14;
   * </code>
   *
   * @return The authorizationType.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.datatransfer.v1.DataSource.AuthorizationType
      getAuthorizationType() {
    com.google.cloud.bigquery.datatransfer.v1.DataSource.AuthorizationType result =
        com.google.cloud.bigquery.datatransfer.v1.DataSource.AuthorizationType.forNumber(
            authorizationType_);
    return result == null
        ? com.google.cloud.bigquery.datatransfer.v1.DataSource.AuthorizationType.UNRECOGNIZED
        : result;
  }

  public static final int DATA_REFRESH_TYPE_FIELD_NUMBER = 15;
  private int dataRefreshType_ = 0;
  /**
   *
   *
   * <pre>
   * Specifies whether the data source supports automatic data refresh for the
   * past few days, and how it's supported.
   * For some data sources, data might not be complete until a few days later,
   * so it's useful to refresh data automatically.
   * </pre>
   *
   * <code>.google.cloud.bigquery.datatransfer.v1.DataSource.DataRefreshType data_refresh_type = 15;
   * </code>
   *
   * @return The enum numeric value on the wire for dataRefreshType.
   */
  @java.lang.Override
  public int getDataRefreshTypeValue() {
    return dataRefreshType_;
  }
  /**
   *
   *
   * <pre>
   * Specifies whether the data source supports automatic data refresh for the
   * past few days, and how it's supported.
   * For some data sources, data might not be complete until a few days later,
   * so it's useful to refresh data automatically.
   * </pre>
   *
   * <code>.google.cloud.bigquery.datatransfer.v1.DataSource.DataRefreshType data_refresh_type = 15;
   * </code>
   *
   * @return The dataRefreshType.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.datatransfer.v1.DataSource.DataRefreshType getDataRefreshType() {
    com.google.cloud.bigquery.datatransfer.v1.DataSource.DataRefreshType result =
        com.google.cloud.bigquery.datatransfer.v1.DataSource.DataRefreshType.forNumber(
            dataRefreshType_);
    return result == null
        ? com.google.cloud.bigquery.datatransfer.v1.DataSource.DataRefreshType.UNRECOGNIZED
        : result;
  }

  public static final int DEFAULT_DATA_REFRESH_WINDOW_DAYS_FIELD_NUMBER = 16;
  private int defaultDataRefreshWindowDays_ = 0;
  /**
   *
   *
   * <pre>
   * Default data refresh window on days.
   * Only meaningful when `data_refresh_type` = `SLIDING_WINDOW`.
   * </pre>
   *
   * <code>int32 default_data_refresh_window_days = 16;</code>
   *
   * @return The defaultDataRefreshWindowDays.
   */
  @java.lang.Override
  public int getDefaultDataRefreshWindowDays() {
    return defaultDataRefreshWindowDays_;
  }

  public static final int MANUAL_RUNS_DISABLED_FIELD_NUMBER = 17;
  private boolean manualRunsDisabled_ = false;
  /**
   *
   *
   * <pre>
   * Disables backfilling and manual run scheduling
   * for the data source.
   * </pre>
   *
   * <code>bool manual_runs_disabled = 17;</code>
   *
   * @return The manualRunsDisabled.
   */
  @java.lang.Override
  public boolean getManualRunsDisabled() {
    return manualRunsDisabled_;
  }

  public static final int MINIMUM_SCHEDULE_INTERVAL_FIELD_NUMBER = 18;
  private com.google.protobuf.Duration minimumScheduleInterval_;
  /**
   *
   *
   * <pre>
   * The minimum interval for scheduler to schedule runs.
   * </pre>
   *
   * <code>.google.protobuf.Duration minimum_schedule_interval = 18;</code>
   *
   * @return Whether the minimumScheduleInterval field is set.
   */
  @java.lang.Override
  public boolean hasMinimumScheduleInterval() {
    return minimumScheduleInterval_ != null;
  }
  /**
   *
   *
   * <pre>
   * The minimum interval for scheduler to schedule runs.
   * </pre>
   *
   * <code>.google.protobuf.Duration minimum_schedule_interval = 18;</code>
   *
   * @return The minimumScheduleInterval.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getMinimumScheduleInterval() {
    return minimumScheduleInterval_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : minimumScheduleInterval_;
  }
  /**
   *
   *
   * <pre>
   * The minimum interval for scheduler to schedule runs.
   * </pre>
   *
   * <code>.google.protobuf.Duration minimum_schedule_interval = 18;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getMinimumScheduleIntervalOrBuilder() {
    return minimumScheduleInterval_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : minimumScheduleInterval_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataSourceId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, dataSourceId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clientId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, clientId_);
    }
    for (int i = 0; i < scopes_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, scopes_.getRaw(i));
    }
    if (transferType_
        != com.google.cloud.bigquery.datatransfer.v1.TransferType.TRANSFER_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(7, transferType_);
    }
    if (supportsMultipleTransfers_ != false) {
      output.writeBool(8, supportsMultipleTransfers_);
    }
    if (updateDeadlineSeconds_ != 0) {
      output.writeInt32(9, updateDeadlineSeconds_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(defaultSchedule_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, defaultSchedule_);
    }
    if (supportsCustomSchedule_ != false) {
      output.writeBool(11, supportsCustomSchedule_);
    }
    for (int i = 0; i < parameters_.size(); i++) {
      output.writeMessage(12, parameters_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(helpUrl_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 13, helpUrl_);
    }
    if (authorizationType_
        != com.google.cloud.bigquery.datatransfer.v1.DataSource.AuthorizationType
            .AUTHORIZATION_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(14, authorizationType_);
    }
    if (dataRefreshType_
        != com.google.cloud.bigquery.datatransfer.v1.DataSource.DataRefreshType
            .DATA_REFRESH_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(15, dataRefreshType_);
    }
    if (defaultDataRefreshWindowDays_ != 0) {
      output.writeInt32(16, defaultDataRefreshWindowDays_);
    }
    if (manualRunsDisabled_ != false) {
      output.writeBool(17, manualRunsDisabled_);
    }
    if (minimumScheduleInterval_ != null) {
      output.writeMessage(18, getMinimumScheduleInterval());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataSourceId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, dataSourceId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clientId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, clientId_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < scopes_.size(); i++) {
        dataSize += computeStringSizeNoTag(scopes_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getScopesList().size();
    }
    if (transferType_
        != com.google.cloud.bigquery.datatransfer.v1.TransferType.TRANSFER_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(7, transferType_);
    }
    if (supportsMultipleTransfers_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(8, supportsMultipleTransfers_);
    }
    if (updateDeadlineSeconds_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(9, updateDeadlineSeconds_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(defaultSchedule_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, defaultSchedule_);
    }
    if (supportsCustomSchedule_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(11, supportsCustomSchedule_);
    }
    for (int i = 0; i < parameters_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, parameters_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(helpUrl_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(13, helpUrl_);
    }
    if (authorizationType_
        != com.google.cloud.bigquery.datatransfer.v1.DataSource.AuthorizationType
            .AUTHORIZATION_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(14, authorizationType_);
    }
    if (dataRefreshType_
        != com.google.cloud.bigquery.datatransfer.v1.DataSource.DataRefreshType
            .DATA_REFRESH_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(15, dataRefreshType_);
    }
    if (defaultDataRefreshWindowDays_ != 0) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(16, defaultDataRefreshWindowDays_);
    }
    if (manualRunsDisabled_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(17, manualRunsDisabled_);
    }
    if (minimumScheduleInterval_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              18, getMinimumScheduleInterval());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.bigquery.datatransfer.v1.DataSource)) {
      return super.equals(obj);
    }
    com.google.cloud.bigquery.datatransfer.v1.DataSource other =
        (com.google.cloud.bigquery.datatransfer.v1.DataSource) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDataSourceId().equals(other.getDataSourceId())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getClientId().equals(other.getClientId())) return false;
    if (!getScopesList().equals(other.getScopesList())) return false;
    if (transferType_ != other.transferType_) return false;
    if (getSupportsMultipleTransfers() != other.getSupportsMultipleTransfers()) return false;
    if (getUpdateDeadlineSeconds() != other.getUpdateDeadlineSeconds()) return false;
    if (!getDefaultSchedule().equals(other.getDefaultSchedule())) return false;
    if (getSupportsCustomSchedule() != other.getSupportsCustomSchedule()) return false;
    if (!getParametersList().equals(other.getParametersList())) return false;
    if (!getHelpUrl().equals(other.getHelpUrl())) return false;
    if (authorizationType_ != other.authorizationType_) return false;
    if (dataRefreshType_ != other.dataRefreshType_) return false;
    if (getDefaultDataRefreshWindowDays() != other.getDefaultDataRefreshWindowDays()) return false;
    if (getManualRunsDisabled() != other.getManualRunsDisabled()) return false;
    if (hasMinimumScheduleInterval() != other.hasMinimumScheduleInterval()) return false;
    if (hasMinimumScheduleInterval()) {
      if (!getMinimumScheduleInterval().equals(other.getMinimumScheduleInterval())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DATA_SOURCE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getDataSourceId().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + CLIENT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getClientId().hashCode();
    if (getScopesCount() > 0) {
      hash = (37 * hash) + SCOPES_FIELD_NUMBER;
      hash = (53 * hash) + getScopesList().hashCode();
    }
    hash = (37 * hash) + TRANSFER_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + transferType_;
    hash = (37 * hash) + SUPPORTS_MULTIPLE_TRANSFERS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSupportsMultipleTransfers());
    hash = (37 * hash) + UPDATE_DEADLINE_SECONDS_FIELD_NUMBER;
    hash = (53 * hash) + getUpdateDeadlineSeconds();
    hash = (37 * hash) + DEFAULT_SCHEDULE_FIELD_NUMBER;
    hash = (53 * hash) + getDefaultSchedule().hashCode();
    hash = (37 * hash) + SUPPORTS_CUSTOM_SCHEDULE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSupportsCustomSchedule());
    if (getParametersCount() > 0) {
      hash = (37 * hash) + PARAMETERS_FIELD_NUMBER;
      hash = (53 * hash) + getParametersList().hashCode();
    }
    hash = (37 * hash) + HELP_URL_FIELD_NUMBER;
    hash = (53 * hash) + getHelpUrl().hashCode();
    hash = (37 * hash) + AUTHORIZATION_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + authorizationType_;
    hash = (37 * hash) + DATA_REFRESH_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + dataRefreshType_;
    hash = (37 * hash) + DEFAULT_DATA_REFRESH_WINDOW_DAYS_FIELD_NUMBER;
    hash = (53 * hash) + getDefaultDataRefreshWindowDays();
    hash = (37 * hash) + MANUAL_RUNS_DISABLED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getManualRunsDisabled());
    if (hasMinimumScheduleInterval()) {
      hash = (37 * hash) + MINIMUM_SCHEDULE_INTERVAL_FIELD_NUMBER;
      hash = (53 * hash) + getMinimumScheduleInterval().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.bigquery.datatransfer.v1.DataSource parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.DataSource parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.DataSource parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.DataSource parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.DataSource parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.DataSource parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.DataSource parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.DataSource parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.DataSource parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.DataSource parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.DataSource parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.DataSource parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.bigquery.datatransfer.v1.DataSource prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Defines the properties and custom parameters for a data source.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.datatransfer.v1.DataSource}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.datatransfer.v1.DataSource)
      com.google.cloud.bigquery.datatransfer.v1.DataSourceOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.datatransfer.v1.DataTransferProto
          .internal_static_google_cloud_bigquery_datatransfer_v1_DataSource_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.datatransfer.v1.DataTransferProto
          .internal_static_google_cloud_bigquery_datatransfer_v1_DataSource_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.datatransfer.v1.DataSource.class,
              com.google.cloud.bigquery.datatransfer.v1.DataSource.Builder.class);
    }

    // Construct using com.google.cloud.bigquery.datatransfer.v1.DataSource.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      dataSourceId_ = "";
      displayName_ = "";
      description_ = "";
      clientId_ = "";
      scopes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      transferType_ = 0;
      supportsMultipleTransfers_ = false;
      updateDeadlineSeconds_ = 0;
      defaultSchedule_ = "";
      supportsCustomSchedule_ = false;
      if (parametersBuilder_ == null) {
        parameters_ = java.util.Collections.emptyList();
      } else {
        parameters_ = null;
        parametersBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000800);
      helpUrl_ = "";
      authorizationType_ = 0;
      dataRefreshType_ = 0;
      defaultDataRefreshWindowDays_ = 0;
      manualRunsDisabled_ = false;
      minimumScheduleInterval_ = null;
      if (minimumScheduleIntervalBuilder_ != null) {
        minimumScheduleIntervalBuilder_.dispose();
        minimumScheduleIntervalBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.bigquery.datatransfer.v1.DataTransferProto
          .internal_static_google_cloud_bigquery_datatransfer_v1_DataSource_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.datatransfer.v1.DataSource getDefaultInstanceForType() {
      return com.google.cloud.bigquery.datatransfer.v1.DataSource.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.bigquery.datatransfer.v1.DataSource build() {
      com.google.cloud.bigquery.datatransfer.v1.DataSource result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.datatransfer.v1.DataSource buildPartial() {
      com.google.cloud.bigquery.datatransfer.v1.DataSource result =
          new com.google.cloud.bigquery.datatransfer.v1.DataSource(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.bigquery.datatransfer.v1.DataSource result) {
      if (parametersBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)) {
          parameters_ = java.util.Collections.unmodifiableList(parameters_);
          bitField0_ = (bitField0_ & ~0x00000800);
        }
        result.parameters_ = parameters_;
      } else {
        result.parameters_ = parametersBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.bigquery.datatransfer.v1.DataSource result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.dataSourceId_ = dataSourceId_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.clientId_ = clientId_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        scopes_.makeImmutable();
        result.scopes_ = scopes_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.transferType_ = transferType_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.supportsMultipleTransfers_ = supportsMultipleTransfers_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.updateDeadlineSeconds_ = updateDeadlineSeconds_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.defaultSchedule_ = defaultSchedule_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.supportsCustomSchedule_ = supportsCustomSchedule_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.helpUrl_ = helpUrl_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.authorizationType_ = authorizationType_;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.dataRefreshType_ = dataRefreshType_;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.defaultDataRefreshWindowDays_ = defaultDataRefreshWindowDays_;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.manualRunsDisabled_ = manualRunsDisabled_;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.minimumScheduleInterval_ =
            minimumScheduleIntervalBuilder_ == null
                ? minimumScheduleInterval_
                : minimumScheduleIntervalBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.bigquery.datatransfer.v1.DataSource) {
        return mergeFrom((com.google.cloud.bigquery.datatransfer.v1.DataSource) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.bigquery.datatransfer.v1.DataSource other) {
      if (other == com.google.cloud.bigquery.datatransfer.v1.DataSource.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDataSourceId().isEmpty()) {
        dataSourceId_ = other.dataSourceId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getClientId().isEmpty()) {
        clientId_ = other.clientId_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.scopes_.isEmpty()) {
        if (scopes_.isEmpty()) {
          scopes_ = other.scopes_;
          bitField0_ |= 0x00000020;
        } else {
          ensureScopesIsMutable();
          scopes_.addAll(other.scopes_);
        }
        onChanged();
      }
      if (other.transferType_ != 0) {
        setTransferTypeValue(other.getTransferTypeValue());
      }
      if (other.getSupportsMultipleTransfers() != false) {
        setSupportsMultipleTransfers(other.getSupportsMultipleTransfers());
      }
      if (other.getUpdateDeadlineSeconds() != 0) {
        setUpdateDeadlineSeconds(other.getUpdateDeadlineSeconds());
      }
      if (!other.getDefaultSchedule().isEmpty()) {
        defaultSchedule_ = other.defaultSchedule_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (other.getSupportsCustomSchedule() != false) {
        setSupportsCustomSchedule(other.getSupportsCustomSchedule());
      }
      if (parametersBuilder_ == null) {
        if (!other.parameters_.isEmpty()) {
          if (parameters_.isEmpty()) {
            parameters_ = other.parameters_;
            bitField0_ = (bitField0_ & ~0x00000800);
          } else {
            ensureParametersIsMutable();
            parameters_.addAll(other.parameters_);
          }
          onChanged();
        }
      } else {
        if (!other.parameters_.isEmpty()) {
          if (parametersBuilder_.isEmpty()) {
            parametersBuilder_.dispose();
            parametersBuilder_ = null;
            parameters_ = other.parameters_;
            bitField0_ = (bitField0_ & ~0x00000800);
            parametersBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getParametersFieldBuilder()
                    : null;
          } else {
            parametersBuilder_.addAllMessages(other.parameters_);
          }
        }
      }
      if (!other.getHelpUrl().isEmpty()) {
        helpUrl_ = other.helpUrl_;
        bitField0_ |= 0x00001000;
        onChanged();
      }
      if (other.authorizationType_ != 0) {
        setAuthorizationTypeValue(other.getAuthorizationTypeValue());
      }
      if (other.dataRefreshType_ != 0) {
        setDataRefreshTypeValue(other.getDataRefreshTypeValue());
      }
      if (other.getDefaultDataRefreshWindowDays() != 0) {
        setDefaultDataRefreshWindowDays(other.getDefaultDataRefreshWindowDays());
      }
      if (other.getManualRunsDisabled() != false) {
        setManualRunsDisabled(other.getManualRunsDisabled());
      }
      if (other.hasMinimumScheduleInterval()) {
        mergeMinimumScheduleInterval(other.getMinimumScheduleInterval());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                dataSourceId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                clientId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureScopesIsMutable();
                scopes_.add(s);
                break;
              } // case 50
            case 56:
              {
                transferType_ = input.readEnum();
                bitField0_ |= 0x00000040;
                break;
              } // case 56
            case 64:
              {
                supportsMultipleTransfers_ = input.readBool();
                bitField0_ |= 0x00000080;
                break;
              } // case 64
            case 72:
              {
                updateDeadlineSeconds_ = input.readInt32();
                bitField0_ |= 0x00000100;
                break;
              } // case 72
            case 82:
              {
                defaultSchedule_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 82
            case 88:
              {
                supportsCustomSchedule_ = input.readBool();
                bitField0_ |= 0x00000400;
                break;
              } // case 88
            case 98:
              {
                com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter m =
                    input.readMessage(
                        com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter.parser(),
                        extensionRegistry);
                if (parametersBuilder_ == null) {
                  ensureParametersIsMutable();
                  parameters_.add(m);
                } else {
                  parametersBuilder_.addMessage(m);
                }
                break;
              } // case 98
            case 106:
              {
                helpUrl_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00001000;
                break;
              } // case 106
            case 112:
              {
                authorizationType_ = input.readEnum();
                bitField0_ |= 0x00002000;
                break;
              } // case 112
            case 120:
              {
                dataRefreshType_ = input.readEnum();
                bitField0_ |= 0x00004000;
                break;
              } // case 120
            case 128:
              {
                defaultDataRefreshWindowDays_ = input.readInt32();
                bitField0_ |= 0x00008000;
                break;
              } // case 128
            case 136:
              {
                manualRunsDisabled_ = input.readBool();
                bitField0_ |= 0x00010000;
                break;
              } // case 136
            case 146:
              {
                input.readMessage(
                    getMinimumScheduleIntervalFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00020000;
                break;
              } // case 146
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Data source resource name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Data source resource name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Data source resource name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Data source resource name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Data source resource name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object dataSourceId_ = "";
    /**
     *
     *
     * <pre>
     * Data source id.
     * </pre>
     *
     * <code>string data_source_id = 2;</code>
     *
     * @return The dataSourceId.
     */
    public java.lang.String getDataSourceId() {
      java.lang.Object ref = dataSourceId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dataSourceId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Data source id.
     * </pre>
     *
     * <code>string data_source_id = 2;</code>
     *
     * @return The bytes for dataSourceId.
     */
    public com.google.protobuf.ByteString getDataSourceIdBytes() {
      java.lang.Object ref = dataSourceId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dataSourceId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Data source id.
     * </pre>
     *
     * <code>string data_source_id = 2;</code>
     *
     * @param value The dataSourceId to set.
     * @return This builder for chaining.
     */
    public Builder setDataSourceId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      dataSourceId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data source id.
     * </pre>
     *
     * <code>string data_source_id = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDataSourceId() {
      dataSourceId_ = getDefaultInstance().getDataSourceId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data source id.
     * </pre>
     *
     * <code>string data_source_id = 2;</code>
     *
     * @param value The bytes for dataSourceId to set.
     * @return This builder for chaining.
     */
    public Builder setDataSourceIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      dataSourceId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * User friendly data source name.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * User friendly data source name.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * User friendly data source name.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User friendly data source name.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User friendly data source name.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * User friendly data source description string.
     * </pre>
     *
     * <code>string description = 4;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * User friendly data source description string.
     * </pre>
     *
     * <code>string description = 4;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * User friendly data source description string.
     * </pre>
     *
     * <code>string description = 4;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User friendly data source description string.
     * </pre>
     *
     * <code>string description = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User friendly data source description string.
     * </pre>
     *
     * <code>string description = 4;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object clientId_ = "";
    /**
     *
     *
     * <pre>
     * Data source client id which should be used to receive refresh token.
     * </pre>
     *
     * <code>string client_id = 5;</code>
     *
     * @return The clientId.
     */
    public java.lang.String getClientId() {
      java.lang.Object ref = clientId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        clientId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Data source client id which should be used to receive refresh token.
     * </pre>
     *
     * <code>string client_id = 5;</code>
     *
     * @return The bytes for clientId.
     */
    public com.google.protobuf.ByteString getClientIdBytes() {
      java.lang.Object ref = clientId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        clientId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Data source client id which should be used to receive refresh token.
     * </pre>
     *
     * <code>string client_id = 5;</code>
     *
     * @param value The clientId to set.
     * @return This builder for chaining.
     */
    public Builder setClientId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      clientId_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data source client id which should be used to receive refresh token.
     * </pre>
     *
     * <code>string client_id = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearClientId() {
      clientId_ = getDefaultInstance().getClientId();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data source client id which should be used to receive refresh token.
     * </pre>
     *
     * <code>string client_id = 5;</code>
     *
     * @param value The bytes for clientId to set.
     * @return This builder for chaining.
     */
    public Builder setClientIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      clientId_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList scopes_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureScopesIsMutable() {
      if (!scopes_.isModifiable()) {
        scopes_ = new com.google.protobuf.LazyStringArrayList(scopes_);
      }
      bitField0_ |= 0x00000020;
    }
    /**
     *
     *
     * <pre>
     * Api auth scopes for which refresh token needs to be obtained. These are
     * scopes needed by a data source to prepare data and ingest them into
     * BigQuery, e.g., https://www.googleapis.com/auth/bigquery
     * </pre>
     *
     * <code>repeated string scopes = 6;</code>
     *
     * @return A list containing the scopes.
     */
    public com.google.protobuf.ProtocolStringList getScopesList() {
      scopes_.makeImmutable();
      return scopes_;
    }
    /**
     *
     *
     * <pre>
     * Api auth scopes for which refresh token needs to be obtained. These are
     * scopes needed by a data source to prepare data and ingest them into
     * BigQuery, e.g., https://www.googleapis.com/auth/bigquery
     * </pre>
     *
     * <code>repeated string scopes = 6;</code>
     *
     * @return The count of scopes.
     */
    public int getScopesCount() {
      return scopes_.size();
    }
    /**
     *
     *
     * <pre>
     * Api auth scopes for which refresh token needs to be obtained. These are
     * scopes needed by a data source to prepare data and ingest them into
     * BigQuery, e.g., https://www.googleapis.com/auth/bigquery
     * </pre>
     *
     * <code>repeated string scopes = 6;</code>
     *
     * @param index The index of the element to return.
     * @return The scopes at the given index.
     */
    public java.lang.String getScopes(int index) {
      return scopes_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Api auth scopes for which refresh token needs to be obtained. These are
     * scopes needed by a data source to prepare data and ingest them into
     * BigQuery, e.g., https://www.googleapis.com/auth/bigquery
     * </pre>
     *
     * <code>repeated string scopes = 6;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the scopes at the given index.
     */
    public com.google.protobuf.ByteString getScopesBytes(int index) {
      return scopes_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Api auth scopes for which refresh token needs to be obtained. These are
     * scopes needed by a data source to prepare data and ingest them into
     * BigQuery, e.g., https://www.googleapis.com/auth/bigquery
     * </pre>
     *
     * <code>repeated string scopes = 6;</code>
     *
     * @param index The index to set the value at.
     * @param value The scopes to set.
     * @return This builder for chaining.
     */
    public Builder setScopes(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureScopesIsMutable();
      scopes_.set(index, value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Api auth scopes for which refresh token needs to be obtained. These are
     * scopes needed by a data source to prepare data and ingest them into
     * BigQuery, e.g., https://www.googleapis.com/auth/bigquery
     * </pre>
     *
     * <code>repeated string scopes = 6;</code>
     *
     * @param value The scopes to add.
     * @return This builder for chaining.
     */
    public Builder addScopes(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureScopesIsMutable();
      scopes_.add(value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Api auth scopes for which refresh token needs to be obtained. These are
     * scopes needed by a data source to prepare data and ingest them into
     * BigQuery, e.g., https://www.googleapis.com/auth/bigquery
     * </pre>
     *
     * <code>repeated string scopes = 6;</code>
     *
     * @param values The scopes to add.
     * @return This builder for chaining.
     */
    public Builder addAllScopes(java.lang.Iterable<java.lang.String> values) {
      ensureScopesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, scopes_);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Api auth scopes for which refresh token needs to be obtained. These are
     * scopes needed by a data source to prepare data and ingest them into
     * BigQuery, e.g., https://www.googleapis.com/auth/bigquery
     * </pre>
     *
     * <code>repeated string scopes = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearScopes() {
      scopes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000020);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Api auth scopes for which refresh token needs to be obtained. These are
     * scopes needed by a data source to prepare data and ingest them into
     * BigQuery, e.g., https://www.googleapis.com/auth/bigquery
     * </pre>
     *
     * <code>repeated string scopes = 6;</code>
     *
     * @param value The bytes of the scopes to add.
     * @return This builder for chaining.
     */
    public Builder addScopesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureScopesIsMutable();
      scopes_.add(value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private int transferType_ = 0;
    /**
     *
     *
     * <pre>
     * Deprecated. This field has no effect.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.TransferType transfer_type = 7 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.bigquery.datatransfer.v1.DataSource.transfer_type is deprecated. See
     *     google/cloud/bigquery/datatransfer/v1/datatransfer.proto;l=383
     * @return The enum numeric value on the wire for transferType.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public int getTransferTypeValue() {
      return transferType_;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. This field has no effect.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.TransferType transfer_type = 7 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.bigquery.datatransfer.v1.DataSource.transfer_type is deprecated. See
     *     google/cloud/bigquery/datatransfer/v1/datatransfer.proto;l=383
     * @param value The enum numeric value on the wire for transferType to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setTransferTypeValue(int value) {
      transferType_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. This field has no effect.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.TransferType transfer_type = 7 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.bigquery.datatransfer.v1.DataSource.transfer_type is deprecated. See
     *     google/cloud/bigquery/datatransfer/v1/datatransfer.proto;l=383
     * @return The transferType.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public com.google.cloud.bigquery.datatransfer.v1.TransferType getTransferType() {
      com.google.cloud.bigquery.datatransfer.v1.TransferType result =
          com.google.cloud.bigquery.datatransfer.v1.TransferType.forNumber(transferType_);
      return result == null
          ? com.google.cloud.bigquery.datatransfer.v1.TransferType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. This field has no effect.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.TransferType transfer_type = 7 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.bigquery.datatransfer.v1.DataSource.transfer_type is deprecated. See
     *     google/cloud/bigquery/datatransfer/v1/datatransfer.proto;l=383
     * @param value The transferType to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setTransferType(com.google.cloud.bigquery.datatransfer.v1.TransferType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000040;
      transferType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. This field has no effect.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.TransferType transfer_type = 7 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.bigquery.datatransfer.v1.DataSource.transfer_type is deprecated. See
     *     google/cloud/bigquery/datatransfer/v1/datatransfer.proto;l=383
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearTransferType() {
      bitField0_ = (bitField0_ & ~0x00000040);
      transferType_ = 0;
      onChanged();
      return this;
    }

    private boolean supportsMultipleTransfers_;
    /**
     *
     *
     * <pre>
     * Deprecated. This field has no effect.
     * </pre>
     *
     * <code>bool supports_multiple_transfers = 8 [deprecated = true];</code>
     *
     * @deprecated google.cloud.bigquery.datatransfer.v1.DataSource.supports_multiple_transfers is
     *     deprecated. See google/cloud/bigquery/datatransfer/v1/datatransfer.proto;l=386
     * @return The supportsMultipleTransfers.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public boolean getSupportsMultipleTransfers() {
      return supportsMultipleTransfers_;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. This field has no effect.
     * </pre>
     *
     * <code>bool supports_multiple_transfers = 8 [deprecated = true];</code>
     *
     * @deprecated google.cloud.bigquery.datatransfer.v1.DataSource.supports_multiple_transfers is
     *     deprecated. See google/cloud/bigquery/datatransfer/v1/datatransfer.proto;l=386
     * @param value The supportsMultipleTransfers to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setSupportsMultipleTransfers(boolean value) {

      supportsMultipleTransfers_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. This field has no effect.
     * </pre>
     *
     * <code>bool supports_multiple_transfers = 8 [deprecated = true];</code>
     *
     * @deprecated google.cloud.bigquery.datatransfer.v1.DataSource.supports_multiple_transfers is
     *     deprecated. See google/cloud/bigquery/datatransfer/v1/datatransfer.proto;l=386
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearSupportsMultipleTransfers() {
      bitField0_ = (bitField0_ & ~0x00000080);
      supportsMultipleTransfers_ = false;
      onChanged();
      return this;
    }

    private int updateDeadlineSeconds_;
    /**
     *
     *
     * <pre>
     * The number of seconds to wait for an update from the data source
     * before the Data Transfer Service marks the transfer as FAILED.
     * </pre>
     *
     * <code>int32 update_deadline_seconds = 9;</code>
     *
     * @return The updateDeadlineSeconds.
     */
    @java.lang.Override
    public int getUpdateDeadlineSeconds() {
      return updateDeadlineSeconds_;
    }
    /**
     *
     *
     * <pre>
     * The number of seconds to wait for an update from the data source
     * before the Data Transfer Service marks the transfer as FAILED.
     * </pre>
     *
     * <code>int32 update_deadline_seconds = 9;</code>
     *
     * @param value The updateDeadlineSeconds to set.
     * @return This builder for chaining.
     */
    public Builder setUpdateDeadlineSeconds(int value) {

      updateDeadlineSeconds_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number of seconds to wait for an update from the data source
     * before the Data Transfer Service marks the transfer as FAILED.
     * </pre>
     *
     * <code>int32 update_deadline_seconds = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUpdateDeadlineSeconds() {
      bitField0_ = (bitField0_ & ~0x00000100);
      updateDeadlineSeconds_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object defaultSchedule_ = "";
    /**
     *
     *
     * <pre>
     * Default data transfer schedule.
     * Examples of valid schedules include:
     * `1st,3rd monday of month 15:30`,
     * `every wed,fri of jan,jun 13:15`, and
     * `first sunday of quarter 00:00`.
     * </pre>
     *
     * <code>string default_schedule = 10;</code>
     *
     * @return The defaultSchedule.
     */
    public java.lang.String getDefaultSchedule() {
      java.lang.Object ref = defaultSchedule_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        defaultSchedule_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Default data transfer schedule.
     * Examples of valid schedules include:
     * `1st,3rd monday of month 15:30`,
     * `every wed,fri of jan,jun 13:15`, and
     * `first sunday of quarter 00:00`.
     * </pre>
     *
     * <code>string default_schedule = 10;</code>
     *
     * @return The bytes for defaultSchedule.
     */
    public com.google.protobuf.ByteString getDefaultScheduleBytes() {
      java.lang.Object ref = defaultSchedule_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        defaultSchedule_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Default data transfer schedule.
     * Examples of valid schedules include:
     * `1st,3rd monday of month 15:30`,
     * `every wed,fri of jan,jun 13:15`, and
     * `first sunday of quarter 00:00`.
     * </pre>
     *
     * <code>string default_schedule = 10;</code>
     *
     * @param value The defaultSchedule to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultSchedule(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      defaultSchedule_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Default data transfer schedule.
     * Examples of valid schedules include:
     * `1st,3rd monday of month 15:30`,
     * `every wed,fri of jan,jun 13:15`, and
     * `first sunday of quarter 00:00`.
     * </pre>
     *
     * <code>string default_schedule = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDefaultSchedule() {
      defaultSchedule_ = getDefaultInstance().getDefaultSchedule();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Default data transfer schedule.
     * Examples of valid schedules include:
     * `1st,3rd monday of month 15:30`,
     * `every wed,fri of jan,jun 13:15`, and
     * `first sunday of quarter 00:00`.
     * </pre>
     *
     * <code>string default_schedule = 10;</code>
     *
     * @param value The bytes for defaultSchedule to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultScheduleBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      defaultSchedule_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private boolean supportsCustomSchedule_;
    /**
     *
     *
     * <pre>
     * Specifies whether the data source supports a user defined schedule, or
     * operates on the default schedule.
     * When set to `true`, user can override default schedule.
     * </pre>
     *
     * <code>bool supports_custom_schedule = 11;</code>
     *
     * @return The supportsCustomSchedule.
     */
    @java.lang.Override
    public boolean getSupportsCustomSchedule() {
      return supportsCustomSchedule_;
    }
    /**
     *
     *
     * <pre>
     * Specifies whether the data source supports a user defined schedule, or
     * operates on the default schedule.
     * When set to `true`, user can override default schedule.
     * </pre>
     *
     * <code>bool supports_custom_schedule = 11;</code>
     *
     * @param value The supportsCustomSchedule to set.
     * @return This builder for chaining.
     */
    public Builder setSupportsCustomSchedule(boolean value) {

      supportsCustomSchedule_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies whether the data source supports a user defined schedule, or
     * operates on the default schedule.
     * When set to `true`, user can override default schedule.
     * </pre>
     *
     * <code>bool supports_custom_schedule = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSupportsCustomSchedule() {
      bitField0_ = (bitField0_ & ~0x00000400);
      supportsCustomSchedule_ = false;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter>
        parameters_ = java.util.Collections.emptyList();

    private void ensureParametersIsMutable() {
      if (!((bitField0_ & 0x00000800) != 0)) {
        parameters_ =
            new java.util.ArrayList<com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter>(
                parameters_);
        bitField0_ |= 0x00000800;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter,
            com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter.Builder,
            com.google.cloud.bigquery.datatransfer.v1.DataSourceParameterOrBuilder>
        parametersBuilder_;

    /**
     *
     *
     * <pre>
     * Data source parameters.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.DataSourceParameter parameters = 12;
     * </code>
     */
    public java.util.List<com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter>
        getParametersList() {
      if (parametersBuilder_ == null) {
        return java.util.Collections.unmodifiableList(parameters_);
      } else {
        return parametersBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Data source parameters.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.DataSourceParameter parameters = 12;
     * </code>
     */
    public int getParametersCount() {
      if (parametersBuilder_ == null) {
        return parameters_.size();
      } else {
        return parametersBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Data source parameters.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.DataSourceParameter parameters = 12;
     * </code>
     */
    public com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter getParameters(int index) {
      if (parametersBuilder_ == null) {
        return parameters_.get(index);
      } else {
        return parametersBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Data source parameters.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.DataSourceParameter parameters = 12;
     * </code>
     */
    public Builder setParameters(
        int index, com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter value) {
      if (parametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureParametersIsMutable();
        parameters_.set(index, value);
        onChanged();
      } else {
        parametersBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data source parameters.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.DataSourceParameter parameters = 12;
     * </code>
     */
    public Builder setParameters(
        int index,
        com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter.Builder builderForValue) {
      if (parametersBuilder_ == null) {
        ensureParametersIsMutable();
        parameters_.set(index, builderForValue.build());
        onChanged();
      } else {
        parametersBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data source parameters.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.DataSourceParameter parameters = 12;
     * </code>
     */
    public Builder addParameters(
        com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter value) {
      if (parametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureParametersIsMutable();
        parameters_.add(value);
        onChanged();
      } else {
        parametersBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data source parameters.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.DataSourceParameter parameters = 12;
     * </code>
     */
    public Builder addParameters(
        int index, com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter value) {
      if (parametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureParametersIsMutable();
        parameters_.add(index, value);
        onChanged();
      } else {
        parametersBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data source parameters.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.DataSourceParameter parameters = 12;
     * </code>
     */
    public Builder addParameters(
        com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter.Builder builderForValue) {
      if (parametersBuilder_ == null) {
        ensureParametersIsMutable();
        parameters_.add(builderForValue.build());
        onChanged();
      } else {
        parametersBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data source parameters.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.DataSourceParameter parameters = 12;
     * </code>
     */
    public Builder addParameters(
        int index,
        com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter.Builder builderForValue) {
      if (parametersBuilder_ == null) {
        ensureParametersIsMutable();
        parameters_.add(index, builderForValue.build());
        onChanged();
      } else {
        parametersBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data source parameters.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.DataSourceParameter parameters = 12;
     * </code>
     */
    public Builder addAllParameters(
        java.lang.Iterable<? extends com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter>
            values) {
      if (parametersBuilder_ == null) {
        ensureParametersIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, parameters_);
        onChanged();
      } else {
        parametersBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data source parameters.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.DataSourceParameter parameters = 12;
     * </code>
     */
    public Builder clearParameters() {
      if (parametersBuilder_ == null) {
        parameters_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000800);
        onChanged();
      } else {
        parametersBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data source parameters.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.DataSourceParameter parameters = 12;
     * </code>
     */
    public Builder removeParameters(int index) {
      if (parametersBuilder_ == null) {
        ensureParametersIsMutable();
        parameters_.remove(index);
        onChanged();
      } else {
        parametersBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data source parameters.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.DataSourceParameter parameters = 12;
     * </code>
     */
    public com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter.Builder
        getParametersBuilder(int index) {
      return getParametersFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Data source parameters.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.DataSourceParameter parameters = 12;
     * </code>
     */
    public com.google.cloud.bigquery.datatransfer.v1.DataSourceParameterOrBuilder
        getParametersOrBuilder(int index) {
      if (parametersBuilder_ == null) {
        return parameters_.get(index);
      } else {
        return parametersBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Data source parameters.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.DataSourceParameter parameters = 12;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.bigquery.datatransfer.v1.DataSourceParameterOrBuilder>
        getParametersOrBuilderList() {
      if (parametersBuilder_ != null) {
        return parametersBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(parameters_);
      }
    }
    /**
     *
     *
     * <pre>
     * Data source parameters.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.DataSourceParameter parameters = 12;
     * </code>
     */
    public com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter.Builder
        addParametersBuilder() {
      return getParametersFieldBuilder()
          .addBuilder(
              com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Data source parameters.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.DataSourceParameter parameters = 12;
     * </code>
     */
    public com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter.Builder
        addParametersBuilder(int index) {
      return getParametersFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Data source parameters.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.DataSourceParameter parameters = 12;
     * </code>
     */
    public java.util.List<com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter.Builder>
        getParametersBuilderList() {
      return getParametersFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter,
            com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter.Builder,
            com.google.cloud.bigquery.datatransfer.v1.DataSourceParameterOrBuilder>
        getParametersFieldBuilder() {
      if (parametersBuilder_ == null) {
        parametersBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter,
                com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter.Builder,
                com.google.cloud.bigquery.datatransfer.v1.DataSourceParameterOrBuilder>(
                parameters_, ((bitField0_ & 0x00000800) != 0), getParentForChildren(), isClean());
        parameters_ = null;
      }
      return parametersBuilder_;
    }

    private java.lang.Object helpUrl_ = "";
    /**
     *
     *
     * <pre>
     * Url for the help document for this data source.
     * </pre>
     *
     * <code>string help_url = 13;</code>
     *
     * @return The helpUrl.
     */
    public java.lang.String getHelpUrl() {
      java.lang.Object ref = helpUrl_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        helpUrl_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Url for the help document for this data source.
     * </pre>
     *
     * <code>string help_url = 13;</code>
     *
     * @return The bytes for helpUrl.
     */
    public com.google.protobuf.ByteString getHelpUrlBytes() {
      java.lang.Object ref = helpUrl_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        helpUrl_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Url for the help document for this data source.
     * </pre>
     *
     * <code>string help_url = 13;</code>
     *
     * @param value The helpUrl to set.
     * @return This builder for chaining.
     */
    public Builder setHelpUrl(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      helpUrl_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Url for the help document for this data source.
     * </pre>
     *
     * <code>string help_url = 13;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHelpUrl() {
      helpUrl_ = getDefaultInstance().getHelpUrl();
      bitField0_ = (bitField0_ & ~0x00001000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Url for the help document for this data source.
     * </pre>
     *
     * <code>string help_url = 13;</code>
     *
     * @param value The bytes for helpUrl to set.
     * @return This builder for chaining.
     */
    public Builder setHelpUrlBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      helpUrl_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    private int authorizationType_ = 0;
    /**
     *
     *
     * <pre>
     * Indicates the type of authorization.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.DataSource.AuthorizationType authorization_type = 14;
     * </code>
     *
     * @return The enum numeric value on the wire for authorizationType.
     */
    @java.lang.Override
    public int getAuthorizationTypeValue() {
      return authorizationType_;
    }
    /**
     *
     *
     * <pre>
     * Indicates the type of authorization.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.DataSource.AuthorizationType authorization_type = 14;
     * </code>
     *
     * @param value The enum numeric value on the wire for authorizationType to set.
     * @return This builder for chaining.
     */
    public Builder setAuthorizationTypeValue(int value) {
      authorizationType_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates the type of authorization.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.DataSource.AuthorizationType authorization_type = 14;
     * </code>
     *
     * @return The authorizationType.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.datatransfer.v1.DataSource.AuthorizationType
        getAuthorizationType() {
      com.google.cloud.bigquery.datatransfer.v1.DataSource.AuthorizationType result =
          com.google.cloud.bigquery.datatransfer.v1.DataSource.AuthorizationType.forNumber(
              authorizationType_);
      return result == null
          ? com.google.cloud.bigquery.datatransfer.v1.DataSource.AuthorizationType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Indicates the type of authorization.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.DataSource.AuthorizationType authorization_type = 14;
     * </code>
     *
     * @param value The authorizationType to set.
     * @return This builder for chaining.
     */
    public Builder setAuthorizationType(
        com.google.cloud.bigquery.datatransfer.v1.DataSource.AuthorizationType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00002000;
      authorizationType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates the type of authorization.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.DataSource.AuthorizationType authorization_type = 14;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAuthorizationType() {
      bitField0_ = (bitField0_ & ~0x00002000);
      authorizationType_ = 0;
      onChanged();
      return this;
    }

    private int dataRefreshType_ = 0;
    /**
     *
     *
     * <pre>
     * Specifies whether the data source supports automatic data refresh for the
     * past few days, and how it's supported.
     * For some data sources, data might not be complete until a few days later,
     * so it's useful to refresh data automatically.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.DataSource.DataRefreshType data_refresh_type = 15;
     * </code>
     *
     * @return The enum numeric value on the wire for dataRefreshType.
     */
    @java.lang.Override
    public int getDataRefreshTypeValue() {
      return dataRefreshType_;
    }
    /**
     *
     *
     * <pre>
     * Specifies whether the data source supports automatic data refresh for the
     * past few days, and how it's supported.
     * For some data sources, data might not be complete until a few days later,
     * so it's useful to refresh data automatically.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.DataSource.DataRefreshType data_refresh_type = 15;
     * </code>
     *
     * @param value The enum numeric value on the wire for dataRefreshType to set.
     * @return This builder for chaining.
     */
    public Builder setDataRefreshTypeValue(int value) {
      dataRefreshType_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies whether the data source supports automatic data refresh for the
     * past few days, and how it's supported.
     * For some data sources, data might not be complete until a few days later,
     * so it's useful to refresh data automatically.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.DataSource.DataRefreshType data_refresh_type = 15;
     * </code>
     *
     * @return The dataRefreshType.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.datatransfer.v1.DataSource.DataRefreshType
        getDataRefreshType() {
      com.google.cloud.bigquery.datatransfer.v1.DataSource.DataRefreshType result =
          com.google.cloud.bigquery.datatransfer.v1.DataSource.DataRefreshType.forNumber(
              dataRefreshType_);
      return result == null
          ? com.google.cloud.bigquery.datatransfer.v1.DataSource.DataRefreshType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Specifies whether the data source supports automatic data refresh for the
     * past few days, and how it's supported.
     * For some data sources, data might not be complete until a few days later,
     * so it's useful to refresh data automatically.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.DataSource.DataRefreshType data_refresh_type = 15;
     * </code>
     *
     * @param value The dataRefreshType to set.
     * @return This builder for chaining.
     */
    public Builder setDataRefreshType(
        com.google.cloud.bigquery.datatransfer.v1.DataSource.DataRefreshType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00004000;
      dataRefreshType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies whether the data source supports automatic data refresh for the
     * past few days, and how it's supported.
     * For some data sources, data might not be complete until a few days later,
     * so it's useful to refresh data automatically.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.DataSource.DataRefreshType data_refresh_type = 15;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDataRefreshType() {
      bitField0_ = (bitField0_ & ~0x00004000);
      dataRefreshType_ = 0;
      onChanged();
      return this;
    }

    private int defaultDataRefreshWindowDays_;
    /**
     *
     *
     * <pre>
     * Default data refresh window on days.
     * Only meaningful when `data_refresh_type` = `SLIDING_WINDOW`.
     * </pre>
     *
     * <code>int32 default_data_refresh_window_days = 16;</code>
     *
     * @return The defaultDataRefreshWindowDays.
     */
    @java.lang.Override
    public int getDefaultDataRefreshWindowDays() {
      return defaultDataRefreshWindowDays_;
    }
    /**
     *
     *
     * <pre>
     * Default data refresh window on days.
     * Only meaningful when `data_refresh_type` = `SLIDING_WINDOW`.
     * </pre>
     *
     * <code>int32 default_data_refresh_window_days = 16;</code>
     *
     * @param value The defaultDataRefreshWindowDays to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultDataRefreshWindowDays(int value) {

      defaultDataRefreshWindowDays_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Default data refresh window on days.
     * Only meaningful when `data_refresh_type` = `SLIDING_WINDOW`.
     * </pre>
     *
     * <code>int32 default_data_refresh_window_days = 16;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDefaultDataRefreshWindowDays() {
      bitField0_ = (bitField0_ & ~0x00008000);
      defaultDataRefreshWindowDays_ = 0;
      onChanged();
      return this;
    }

    private boolean manualRunsDisabled_;
    /**
     *
     *
     * <pre>
     * Disables backfilling and manual run scheduling
     * for the data source.
     * </pre>
     *
     * <code>bool manual_runs_disabled = 17;</code>
     *
     * @return The manualRunsDisabled.
     */
    @java.lang.Override
    public boolean getManualRunsDisabled() {
      return manualRunsDisabled_;
    }
    /**
     *
     *
     * <pre>
     * Disables backfilling and manual run scheduling
     * for the data source.
     * </pre>
     *
     * <code>bool manual_runs_disabled = 17;</code>
     *
     * @param value The manualRunsDisabled to set.
     * @return This builder for chaining.
     */
    public Builder setManualRunsDisabled(boolean value) {

      manualRunsDisabled_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Disables backfilling and manual run scheduling
     * for the data source.
     * </pre>
     *
     * <code>bool manual_runs_disabled = 17;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearManualRunsDisabled() {
      bitField0_ = (bitField0_ & ~0x00010000);
      manualRunsDisabled_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.Duration minimumScheduleInterval_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        minimumScheduleIntervalBuilder_;
    /**
     *
     *
     * <pre>
     * The minimum interval for scheduler to schedule runs.
     * </pre>
     *
     * <code>.google.protobuf.Duration minimum_schedule_interval = 18;</code>
     *
     * @return Whether the minimumScheduleInterval field is set.
     */
    public boolean hasMinimumScheduleInterval() {
      return ((bitField0_ & 0x00020000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The minimum interval for scheduler to schedule runs.
     * </pre>
     *
     * <code>.google.protobuf.Duration minimum_schedule_interval = 18;</code>
     *
     * @return The minimumScheduleInterval.
     */
    public com.google.protobuf.Duration getMinimumScheduleInterval() {
      if (minimumScheduleIntervalBuilder_ == null) {
        return minimumScheduleInterval_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : minimumScheduleInterval_;
      } else {
        return minimumScheduleIntervalBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The minimum interval for scheduler to schedule runs.
     * </pre>
     *
     * <code>.google.protobuf.Duration minimum_schedule_interval = 18;</code>
     */
    public Builder setMinimumScheduleInterval(com.google.protobuf.Duration value) {
      if (minimumScheduleIntervalBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        minimumScheduleInterval_ = value;
      } else {
        minimumScheduleIntervalBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The minimum interval for scheduler to schedule runs.
     * </pre>
     *
     * <code>.google.protobuf.Duration minimum_schedule_interval = 18;</code>
     */
    public Builder setMinimumScheduleInterval(
        com.google.protobuf.Duration.Builder builderForValue) {
      if (minimumScheduleIntervalBuilder_ == null) {
        minimumScheduleInterval_ = builderForValue.build();
      } else {
        minimumScheduleIntervalBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The minimum interval for scheduler to schedule runs.
     * </pre>
     *
     * <code>.google.protobuf.Duration minimum_schedule_interval = 18;</code>
     */
    public Builder mergeMinimumScheduleInterval(com.google.protobuf.Duration value) {
      if (minimumScheduleIntervalBuilder_ == null) {
        if (((bitField0_ & 0x00020000) != 0)
            && minimumScheduleInterval_ != null
            && minimumScheduleInterval_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getMinimumScheduleIntervalBuilder().mergeFrom(value);
        } else {
          minimumScheduleInterval_ = value;
        }
      } else {
        minimumScheduleIntervalBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The minimum interval for scheduler to schedule runs.
     * </pre>
     *
     * <code>.google.protobuf.Duration minimum_schedule_interval = 18;</code>
     */
    public Builder clearMinimumScheduleInterval() {
      bitField0_ = (bitField0_ & ~0x00020000);
      minimumScheduleInterval_ = null;
      if (minimumScheduleIntervalBuilder_ != null) {
        minimumScheduleIntervalBuilder_.dispose();
        minimumScheduleIntervalBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The minimum interval for scheduler to schedule runs.
     * </pre>
     *
     * <code>.google.protobuf.Duration minimum_schedule_interval = 18;</code>
     */
    public com.google.protobuf.Duration.Builder getMinimumScheduleIntervalBuilder() {
      bitField0_ |= 0x00020000;
      onChanged();
      return getMinimumScheduleIntervalFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The minimum interval for scheduler to schedule runs.
     * </pre>
     *
     * <code>.google.protobuf.Duration minimum_schedule_interval = 18;</code>
     */
    public com.google.protobuf.DurationOrBuilder getMinimumScheduleIntervalOrBuilder() {
      if (minimumScheduleIntervalBuilder_ != null) {
        return minimumScheduleIntervalBuilder_.getMessageOrBuilder();
      } else {
        return minimumScheduleInterval_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : minimumScheduleInterval_;
      }
    }
    /**
     *
     *
     * <pre>
     * The minimum interval for scheduler to schedule runs.
     * </pre>
     *
     * <code>.google.protobuf.Duration minimum_schedule_interval = 18;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getMinimumScheduleIntervalFieldBuilder() {
      if (minimumScheduleIntervalBuilder_ == null) {
        minimumScheduleIntervalBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getMinimumScheduleInterval(), getParentForChildren(), isClean());
        minimumScheduleInterval_ = null;
      }
      return minimumScheduleIntervalBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.datatransfer.v1.DataSource)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.bigquery.datatransfer.v1.DataSource)
  private static final com.google.cloud.bigquery.datatransfer.v1.DataSource DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.bigquery.datatransfer.v1.DataSource();
  }

  public static com.google.cloud.bigquery.datatransfer.v1.DataSource getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DataSource> PARSER =
      new com.google.protobuf.AbstractParser<DataSource>() {
        @java.lang.Override
        public DataSource parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DataSource> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DataSource> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.bigquery.datatransfer.v1.DataSource getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
