/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/datatransfer/v1/datatransfer.proto

package com.google.cloud.bigquery.datatransfer.v1;

/**
 *
 *
 * <pre>
 * A request to update a transfer configuration. To update the user id of the
 * transfer configuration, authorization info needs to be provided.
 * </pre>
 *
 * Protobuf type {@code google.cloud.bigquery.datatransfer.v1.UpdateTransferConfigRequest}
 */
public final class UpdateTransferConfigRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.bigquery.datatransfer.v1.UpdateTransferConfigRequest)
    UpdateTransferConfigRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use UpdateTransferConfigRequest.newBuilder() to construct.
  private UpdateTransferConfigRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private UpdateTransferConfigRequest() {
    authorizationCode_ = "";
    versionInfo_ = "";
    serviceAccountName_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new UpdateTransferConfigRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.bigquery.datatransfer.v1.DataTransferProto
        .internal_static_google_cloud_bigquery_datatransfer_v1_UpdateTransferConfigRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.bigquery.datatransfer.v1.DataTransferProto
        .internal_static_google_cloud_bigquery_datatransfer_v1_UpdateTransferConfigRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.bigquery.datatransfer.v1.UpdateTransferConfigRequest.class,
            com.google.cloud.bigquery.datatransfer.v1.UpdateTransferConfigRequest.Builder.class);
  }

  public static final int TRANSFER_CONFIG_FIELD_NUMBER = 1;
  private com.google.cloud.bigquery.datatransfer.v1.TransferConfig transferConfig_;
  /**
   *
   *
   * <pre>
   * Required. Data transfer configuration to create.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.datatransfer.v1.TransferConfig transfer_config = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the transferConfig field is set.
   */
  @java.lang.Override
  public boolean hasTransferConfig() {
    return transferConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. Data transfer configuration to create.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.datatransfer.v1.TransferConfig transfer_config = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The transferConfig.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.datatransfer.v1.TransferConfig getTransferConfig() {
    return transferConfig_ == null
        ? com.google.cloud.bigquery.datatransfer.v1.TransferConfig.getDefaultInstance()
        : transferConfig_;
  }
  /**
   *
   *
   * <pre>
   * Required. Data transfer configuration to create.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.datatransfer.v1.TransferConfig transfer_config = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.datatransfer.v1.TransferConfigOrBuilder
      getTransferConfigOrBuilder() {
    return transferConfig_ == null
        ? com.google.cloud.bigquery.datatransfer.v1.TransferConfig.getDefaultInstance()
        : transferConfig_;
  }

  public static final int AUTHORIZATION_CODE_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object authorizationCode_ = "";
  /**
   *
   *
   * <pre>
   * Optional OAuth2 authorization code to use with this transfer configuration.
   * This is required only if `transferConfig.dataSourceId` is 'youtube_channel'
   * and new credentials are needed, as indicated by `CheckValidCreds`. In order
   * to obtain authorization_code, make a request to the following URL:
   * &lt;pre class="prettyprint" suppresswarning="true"&gt;
   * https://www.gstatic.com/bigquerydatatransfer/oauthz/auth?redirect_uri=urn:ietf:wg:oauth:2.0:oob&amp;response_type=authorization_code&amp;client_id=&lt;var&gt;client_id&lt;/var&gt;&amp;scope=&lt;var&gt;data_source_scopes&lt;/var&gt;
   * &lt;/pre&gt;
   * * The &lt;var&gt;client_id&lt;/var&gt; is the OAuth client_id of the a data source as
   * returned by ListDataSources method.
   * * &lt;var&gt;data_source_scopes&lt;/var&gt; are the scopes returned by ListDataSources
   * method.
   *
   * Note that this should not be set when `service_account_name` is used to
   * update the transfer config.
   * </pre>
   *
   * <code>string authorization_code = 3;</code>
   *
   * @return The authorizationCode.
   */
  @java.lang.Override
  public java.lang.String getAuthorizationCode() {
    java.lang.Object ref = authorizationCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      authorizationCode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional OAuth2 authorization code to use with this transfer configuration.
   * This is required only if `transferConfig.dataSourceId` is 'youtube_channel'
   * and new credentials are needed, as indicated by `CheckValidCreds`. In order
   * to obtain authorization_code, make a request to the following URL:
   * &lt;pre class="prettyprint" suppresswarning="true"&gt;
   * https://www.gstatic.com/bigquerydatatransfer/oauthz/auth?redirect_uri=urn:ietf:wg:oauth:2.0:oob&amp;response_type=authorization_code&amp;client_id=&lt;var&gt;client_id&lt;/var&gt;&amp;scope=&lt;var&gt;data_source_scopes&lt;/var&gt;
   * &lt;/pre&gt;
   * * The &lt;var&gt;client_id&lt;/var&gt; is the OAuth client_id of the a data source as
   * returned by ListDataSources method.
   * * &lt;var&gt;data_source_scopes&lt;/var&gt; are the scopes returned by ListDataSources
   * method.
   *
   * Note that this should not be set when `service_account_name` is used to
   * update the transfer config.
   * </pre>
   *
   * <code>string authorization_code = 3;</code>
   *
   * @return The bytes for authorizationCode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAuthorizationCodeBytes() {
    java.lang.Object ref = authorizationCode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      authorizationCode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UPDATE_MASK_FIELD_NUMBER = 4;
  private com.google.protobuf.FieldMask updateMask_;
  /**
   *
   *
   * <pre>
   * Required. Required list of fields to be updated in this request.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask update_mask = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the updateMask field is set.
   */
  @java.lang.Override
  public boolean hasUpdateMask() {
    return updateMask_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. Required list of fields to be updated in this request.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask update_mask = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The updateMask.
   */
  @java.lang.Override
  public com.google.protobuf.FieldMask getUpdateMask() {
    return updateMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : updateMask_;
  }
  /**
   *
   *
   * <pre>
   * Required. Required list of fields to be updated in this request.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask update_mask = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.FieldMaskOrBuilder getUpdateMaskOrBuilder() {
    return updateMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : updateMask_;
  }

  public static final int VERSION_INFO_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object versionInfo_ = "";
  /**
   *
   *
   * <pre>
   * Optional version info. This is required only if
   * `transferConfig.dataSourceId` is not 'youtube_channel' and new credentials
   * are needed, as indicated by `CheckValidCreds`. In order to obtain version
   * info, make a request to the following URL:
   * &lt;pre class="prettyprint" suppresswarning="true"&gt;
   * https://www.gstatic.com/bigquerydatatransfer/oauthz/auth?redirect_uri=urn:ietf:wg:oauth:2.0:oob&amp;response_type=version_info&amp;client_id=&lt;var&gt;client_id&lt;/var&gt;&amp;scope=&lt;var&gt;data_source_scopes&lt;/var&gt;
   * &lt;/pre&gt;
   * * The &lt;var&gt;client_id&lt;/var&gt; is the OAuth client_id of the a data source as
   * returned by ListDataSources method.
   * * &lt;var&gt;data_source_scopes&lt;/var&gt; are the scopes returned by ListDataSources
   * method.
   *
   * Note that this should not be set when `service_account_name` is used to
   * update the transfer config.
   * </pre>
   *
   * <code>string version_info = 5;</code>
   *
   * @return The versionInfo.
   */
  @java.lang.Override
  public java.lang.String getVersionInfo() {
    java.lang.Object ref = versionInfo_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      versionInfo_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional version info. This is required only if
   * `transferConfig.dataSourceId` is not 'youtube_channel' and new credentials
   * are needed, as indicated by `CheckValidCreds`. In order to obtain version
   * info, make a request to the following URL:
   * &lt;pre class="prettyprint" suppresswarning="true"&gt;
   * https://www.gstatic.com/bigquerydatatransfer/oauthz/auth?redirect_uri=urn:ietf:wg:oauth:2.0:oob&amp;response_type=version_info&amp;client_id=&lt;var&gt;client_id&lt;/var&gt;&amp;scope=&lt;var&gt;data_source_scopes&lt;/var&gt;
   * &lt;/pre&gt;
   * * The &lt;var&gt;client_id&lt;/var&gt; is the OAuth client_id of the a data source as
   * returned by ListDataSources method.
   * * &lt;var&gt;data_source_scopes&lt;/var&gt; are the scopes returned by ListDataSources
   * method.
   *
   * Note that this should not be set when `service_account_name` is used to
   * update the transfer config.
   * </pre>
   *
   * <code>string version_info = 5;</code>
   *
   * @return The bytes for versionInfo.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getVersionInfoBytes() {
    java.lang.Object ref = versionInfo_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      versionInfo_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SERVICE_ACCOUNT_NAME_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serviceAccountName_ = "";
  /**
   *
   *
   * <pre>
   * Optional service account email. If this field is set, the transfer config
   * will be created with this service account's credentials. It requires that
   * the requesting user calling this API has permissions to act as this service
   * account.
   *
   * Note that not all data sources support service account credentials when
   * creating a transfer config. For the latest list of data sources, read about
   * [using service
   * accounts](https://cloud.google.com/bigquery-transfer/docs/use-service-accounts).
   * </pre>
   *
   * <code>string service_account_name = 6;</code>
   *
   * @return The serviceAccountName.
   */
  @java.lang.Override
  public java.lang.String getServiceAccountName() {
    java.lang.Object ref = serviceAccountName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceAccountName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional service account email. If this field is set, the transfer config
   * will be created with this service account's credentials. It requires that
   * the requesting user calling this API has permissions to act as this service
   * account.
   *
   * Note that not all data sources support service account credentials when
   * creating a transfer config. For the latest list of data sources, read about
   * [using service
   * accounts](https://cloud.google.com/bigquery-transfer/docs/use-service-accounts).
   * </pre>
   *
   * <code>string service_account_name = 6;</code>
   *
   * @return The bytes for serviceAccountName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceAccountNameBytes() {
    java.lang.Object ref = serviceAccountName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceAccountName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (transferConfig_ != null) {
      output.writeMessage(1, getTransferConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(authorizationCode_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, authorizationCode_);
    }
    if (updateMask_ != null) {
      output.writeMessage(4, getUpdateMask());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(versionInfo_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, versionInfo_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccountName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, serviceAccountName_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (transferConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getTransferConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(authorizationCode_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, authorizationCode_);
    }
    if (updateMask_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getUpdateMask());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(versionInfo_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, versionInfo_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccountName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, serviceAccountName_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.bigquery.datatransfer.v1.UpdateTransferConfigRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.bigquery.datatransfer.v1.UpdateTransferConfigRequest other =
        (com.google.cloud.bigquery.datatransfer.v1.UpdateTransferConfigRequest) obj;

    if (hasTransferConfig() != other.hasTransferConfig()) return false;
    if (hasTransferConfig()) {
      if (!getTransferConfig().equals(other.getTransferConfig())) return false;
    }
    if (!getAuthorizationCode().equals(other.getAuthorizationCode())) return false;
    if (hasUpdateMask() != other.hasUpdateMask()) return false;
    if (hasUpdateMask()) {
      if (!getUpdateMask().equals(other.getUpdateMask())) return false;
    }
    if (!getVersionInfo().equals(other.getVersionInfo())) return false;
    if (!getServiceAccountName().equals(other.getServiceAccountName())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasTransferConfig()) {
      hash = (37 * hash) + TRANSFER_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getTransferConfig().hashCode();
    }
    hash = (37 * hash) + AUTHORIZATION_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getAuthorizationCode().hashCode();
    if (hasUpdateMask()) {
      hash = (37 * hash) + UPDATE_MASK_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateMask().hashCode();
    }
    hash = (37 * hash) + VERSION_INFO_FIELD_NUMBER;
    hash = (53 * hash) + getVersionInfo().hashCode();
    hash = (37 * hash) + SERVICE_ACCOUNT_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getServiceAccountName().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.bigquery.datatransfer.v1.UpdateTransferConfigRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.UpdateTransferConfigRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.UpdateTransferConfigRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.UpdateTransferConfigRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.UpdateTransferConfigRequest parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.UpdateTransferConfigRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.UpdateTransferConfigRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.UpdateTransferConfigRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.UpdateTransferConfigRequest
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.UpdateTransferConfigRequest
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.UpdateTransferConfigRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.UpdateTransferConfigRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.bigquery.datatransfer.v1.UpdateTransferConfigRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A request to update a transfer configuration. To update the user id of the
   * transfer configuration, authorization info needs to be provided.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.datatransfer.v1.UpdateTransferConfigRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.datatransfer.v1.UpdateTransferConfigRequest)
      com.google.cloud.bigquery.datatransfer.v1.UpdateTransferConfigRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.datatransfer.v1.DataTransferProto
          .internal_static_google_cloud_bigquery_datatransfer_v1_UpdateTransferConfigRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.datatransfer.v1.DataTransferProto
          .internal_static_google_cloud_bigquery_datatransfer_v1_UpdateTransferConfigRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.datatransfer.v1.UpdateTransferConfigRequest.class,
              com.google.cloud.bigquery.datatransfer.v1.UpdateTransferConfigRequest.Builder.class);
    }

    // Construct using
    // com.google.cloud.bigquery.datatransfer.v1.UpdateTransferConfigRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      transferConfig_ = null;
      if (transferConfigBuilder_ != null) {
        transferConfigBuilder_.dispose();
        transferConfigBuilder_ = null;
      }
      authorizationCode_ = "";
      updateMask_ = null;
      if (updateMaskBuilder_ != null) {
        updateMaskBuilder_.dispose();
        updateMaskBuilder_ = null;
      }
      versionInfo_ = "";
      serviceAccountName_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.bigquery.datatransfer.v1.DataTransferProto
          .internal_static_google_cloud_bigquery_datatransfer_v1_UpdateTransferConfigRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.datatransfer.v1.UpdateTransferConfigRequest
        getDefaultInstanceForType() {
      return com.google.cloud.bigquery.datatransfer.v1.UpdateTransferConfigRequest
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.bigquery.datatransfer.v1.UpdateTransferConfigRequest build() {
      com.google.cloud.bigquery.datatransfer.v1.UpdateTransferConfigRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.datatransfer.v1.UpdateTransferConfigRequest buildPartial() {
      com.google.cloud.bigquery.datatransfer.v1.UpdateTransferConfigRequest result =
          new com.google.cloud.bigquery.datatransfer.v1.UpdateTransferConfigRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.bigquery.datatransfer.v1.UpdateTransferConfigRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.transferConfig_ =
            transferConfigBuilder_ == null ? transferConfig_ : transferConfigBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.authorizationCode_ = authorizationCode_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.updateMask_ = updateMaskBuilder_ == null ? updateMask_ : updateMaskBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.versionInfo_ = versionInfo_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.serviceAccountName_ = serviceAccountName_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.bigquery.datatransfer.v1.UpdateTransferConfigRequest) {
        return mergeFrom(
            (com.google.cloud.bigquery.datatransfer.v1.UpdateTransferConfigRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.bigquery.datatransfer.v1.UpdateTransferConfigRequest other) {
      if (other
          == com.google.cloud.bigquery.datatransfer.v1.UpdateTransferConfigRequest
              .getDefaultInstance()) return this;
      if (other.hasTransferConfig()) {
        mergeTransferConfig(other.getTransferConfig());
      }
      if (!other.getAuthorizationCode().isEmpty()) {
        authorizationCode_ = other.authorizationCode_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasUpdateMask()) {
        mergeUpdateMask(other.getUpdateMask());
      }
      if (!other.getVersionInfo().isEmpty()) {
        versionInfo_ = other.versionInfo_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getServiceAccountName().isEmpty()) {
        serviceAccountName_ = other.serviceAccountName_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getTransferConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 26:
              {
                authorizationCode_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getUpdateMaskFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 34
            case 42:
              {
                versionInfo_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 42
            case 50:
              {
                serviceAccountName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.bigquery.datatransfer.v1.TransferConfig transferConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.datatransfer.v1.TransferConfig,
            com.google.cloud.bigquery.datatransfer.v1.TransferConfig.Builder,
            com.google.cloud.bigquery.datatransfer.v1.TransferConfigOrBuilder>
        transferConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Data transfer configuration to create.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.TransferConfig transfer_config = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the transferConfig field is set.
     */
    public boolean hasTransferConfig() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. Data transfer configuration to create.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.TransferConfig transfer_config = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The transferConfig.
     */
    public com.google.cloud.bigquery.datatransfer.v1.TransferConfig getTransferConfig() {
      if (transferConfigBuilder_ == null) {
        return transferConfig_ == null
            ? com.google.cloud.bigquery.datatransfer.v1.TransferConfig.getDefaultInstance()
            : transferConfig_;
      } else {
        return transferConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Data transfer configuration to create.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.TransferConfig transfer_config = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setTransferConfig(
        com.google.cloud.bigquery.datatransfer.v1.TransferConfig value) {
      if (transferConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        transferConfig_ = value;
      } else {
        transferConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Data transfer configuration to create.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.TransferConfig transfer_config = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setTransferConfig(
        com.google.cloud.bigquery.datatransfer.v1.TransferConfig.Builder builderForValue) {
      if (transferConfigBuilder_ == null) {
        transferConfig_ = builderForValue.build();
      } else {
        transferConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Data transfer configuration to create.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.TransferConfig transfer_config = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeTransferConfig(
        com.google.cloud.bigquery.datatransfer.v1.TransferConfig value) {
      if (transferConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && transferConfig_ != null
            && transferConfig_
                != com.google.cloud.bigquery.datatransfer.v1.TransferConfig.getDefaultInstance()) {
          getTransferConfigBuilder().mergeFrom(value);
        } else {
          transferConfig_ = value;
        }
      } else {
        transferConfigBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Data transfer configuration to create.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.TransferConfig transfer_config = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearTransferConfig() {
      bitField0_ = (bitField0_ & ~0x00000001);
      transferConfig_ = null;
      if (transferConfigBuilder_ != null) {
        transferConfigBuilder_.dispose();
        transferConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Data transfer configuration to create.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.TransferConfig transfer_config = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.bigquery.datatransfer.v1.TransferConfig.Builder
        getTransferConfigBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getTransferConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Data transfer configuration to create.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.TransferConfig transfer_config = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.bigquery.datatransfer.v1.TransferConfigOrBuilder
        getTransferConfigOrBuilder() {
      if (transferConfigBuilder_ != null) {
        return transferConfigBuilder_.getMessageOrBuilder();
      } else {
        return transferConfig_ == null
            ? com.google.cloud.bigquery.datatransfer.v1.TransferConfig.getDefaultInstance()
            : transferConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Data transfer configuration to create.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.TransferConfig transfer_config = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.datatransfer.v1.TransferConfig,
            com.google.cloud.bigquery.datatransfer.v1.TransferConfig.Builder,
            com.google.cloud.bigquery.datatransfer.v1.TransferConfigOrBuilder>
        getTransferConfigFieldBuilder() {
      if (transferConfigBuilder_ == null) {
        transferConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.datatransfer.v1.TransferConfig,
                com.google.cloud.bigquery.datatransfer.v1.TransferConfig.Builder,
                com.google.cloud.bigquery.datatransfer.v1.TransferConfigOrBuilder>(
                getTransferConfig(), getParentForChildren(), isClean());
        transferConfig_ = null;
      }
      return transferConfigBuilder_;
    }

    private java.lang.Object authorizationCode_ = "";
    /**
     *
     *
     * <pre>
     * Optional OAuth2 authorization code to use with this transfer configuration.
     * This is required only if `transferConfig.dataSourceId` is 'youtube_channel'
     * and new credentials are needed, as indicated by `CheckValidCreds`. In order
     * to obtain authorization_code, make a request to the following URL:
     * &lt;pre class="prettyprint" suppresswarning="true"&gt;
     * https://www.gstatic.com/bigquerydatatransfer/oauthz/auth?redirect_uri=urn:ietf:wg:oauth:2.0:oob&amp;response_type=authorization_code&amp;client_id=&lt;var&gt;client_id&lt;/var&gt;&amp;scope=&lt;var&gt;data_source_scopes&lt;/var&gt;
     * &lt;/pre&gt;
     * * The &lt;var&gt;client_id&lt;/var&gt; is the OAuth client_id of the a data source as
     * returned by ListDataSources method.
     * * &lt;var&gt;data_source_scopes&lt;/var&gt; are the scopes returned by ListDataSources
     * method.
     *
     * Note that this should not be set when `service_account_name` is used to
     * update the transfer config.
     * </pre>
     *
     * <code>string authorization_code = 3;</code>
     *
     * @return The authorizationCode.
     */
    public java.lang.String getAuthorizationCode() {
      java.lang.Object ref = authorizationCode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        authorizationCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional OAuth2 authorization code to use with this transfer configuration.
     * This is required only if `transferConfig.dataSourceId` is 'youtube_channel'
     * and new credentials are needed, as indicated by `CheckValidCreds`. In order
     * to obtain authorization_code, make a request to the following URL:
     * &lt;pre class="prettyprint" suppresswarning="true"&gt;
     * https://www.gstatic.com/bigquerydatatransfer/oauthz/auth?redirect_uri=urn:ietf:wg:oauth:2.0:oob&amp;response_type=authorization_code&amp;client_id=&lt;var&gt;client_id&lt;/var&gt;&amp;scope=&lt;var&gt;data_source_scopes&lt;/var&gt;
     * &lt;/pre&gt;
     * * The &lt;var&gt;client_id&lt;/var&gt; is the OAuth client_id of the a data source as
     * returned by ListDataSources method.
     * * &lt;var&gt;data_source_scopes&lt;/var&gt; are the scopes returned by ListDataSources
     * method.
     *
     * Note that this should not be set when `service_account_name` is used to
     * update the transfer config.
     * </pre>
     *
     * <code>string authorization_code = 3;</code>
     *
     * @return The bytes for authorizationCode.
     */
    public com.google.protobuf.ByteString getAuthorizationCodeBytes() {
      java.lang.Object ref = authorizationCode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        authorizationCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional OAuth2 authorization code to use with this transfer configuration.
     * This is required only if `transferConfig.dataSourceId` is 'youtube_channel'
     * and new credentials are needed, as indicated by `CheckValidCreds`. In order
     * to obtain authorization_code, make a request to the following URL:
     * &lt;pre class="prettyprint" suppresswarning="true"&gt;
     * https://www.gstatic.com/bigquerydatatransfer/oauthz/auth?redirect_uri=urn:ietf:wg:oauth:2.0:oob&amp;response_type=authorization_code&amp;client_id=&lt;var&gt;client_id&lt;/var&gt;&amp;scope=&lt;var&gt;data_source_scopes&lt;/var&gt;
     * &lt;/pre&gt;
     * * The &lt;var&gt;client_id&lt;/var&gt; is the OAuth client_id of the a data source as
     * returned by ListDataSources method.
     * * &lt;var&gt;data_source_scopes&lt;/var&gt; are the scopes returned by ListDataSources
     * method.
     *
     * Note that this should not be set when `service_account_name` is used to
     * update the transfer config.
     * </pre>
     *
     * <code>string authorization_code = 3;</code>
     *
     * @param value The authorizationCode to set.
     * @return This builder for chaining.
     */
    public Builder setAuthorizationCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      authorizationCode_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional OAuth2 authorization code to use with this transfer configuration.
     * This is required only if `transferConfig.dataSourceId` is 'youtube_channel'
     * and new credentials are needed, as indicated by `CheckValidCreds`. In order
     * to obtain authorization_code, make a request to the following URL:
     * &lt;pre class="prettyprint" suppresswarning="true"&gt;
     * https://www.gstatic.com/bigquerydatatransfer/oauthz/auth?redirect_uri=urn:ietf:wg:oauth:2.0:oob&amp;response_type=authorization_code&amp;client_id=&lt;var&gt;client_id&lt;/var&gt;&amp;scope=&lt;var&gt;data_source_scopes&lt;/var&gt;
     * &lt;/pre&gt;
     * * The &lt;var&gt;client_id&lt;/var&gt; is the OAuth client_id of the a data source as
     * returned by ListDataSources method.
     * * &lt;var&gt;data_source_scopes&lt;/var&gt; are the scopes returned by ListDataSources
     * method.
     *
     * Note that this should not be set when `service_account_name` is used to
     * update the transfer config.
     * </pre>
     *
     * <code>string authorization_code = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAuthorizationCode() {
      authorizationCode_ = getDefaultInstance().getAuthorizationCode();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional OAuth2 authorization code to use with this transfer configuration.
     * This is required only if `transferConfig.dataSourceId` is 'youtube_channel'
     * and new credentials are needed, as indicated by `CheckValidCreds`. In order
     * to obtain authorization_code, make a request to the following URL:
     * &lt;pre class="prettyprint" suppresswarning="true"&gt;
     * https://www.gstatic.com/bigquerydatatransfer/oauthz/auth?redirect_uri=urn:ietf:wg:oauth:2.0:oob&amp;response_type=authorization_code&amp;client_id=&lt;var&gt;client_id&lt;/var&gt;&amp;scope=&lt;var&gt;data_source_scopes&lt;/var&gt;
     * &lt;/pre&gt;
     * * The &lt;var&gt;client_id&lt;/var&gt; is the OAuth client_id of the a data source as
     * returned by ListDataSources method.
     * * &lt;var&gt;data_source_scopes&lt;/var&gt; are the scopes returned by ListDataSources
     * method.
     *
     * Note that this should not be set when `service_account_name` is used to
     * update the transfer config.
     * </pre>
     *
     * <code>string authorization_code = 3;</code>
     *
     * @param value The bytes for authorizationCode to set.
     * @return This builder for chaining.
     */
    public Builder setAuthorizationCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      authorizationCode_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.FieldMask updateMask_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        updateMaskBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Required list of fields to be updated in this request.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the updateMask field is set.
     */
    public boolean hasUpdateMask() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. Required list of fields to be updated in this request.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The updateMask.
     */
    public com.google.protobuf.FieldMask getUpdateMask() {
      if (updateMaskBuilder_ == null) {
        return updateMask_ == null
            ? com.google.protobuf.FieldMask.getDefaultInstance()
            : updateMask_;
      } else {
        return updateMaskBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Required list of fields to be updated in this request.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setUpdateMask(com.google.protobuf.FieldMask value) {
      if (updateMaskBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateMask_ = value;
      } else {
        updateMaskBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Required list of fields to be updated in this request.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setUpdateMask(com.google.protobuf.FieldMask.Builder builderForValue) {
      if (updateMaskBuilder_ == null) {
        updateMask_ = builderForValue.build();
      } else {
        updateMaskBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Required list of fields to be updated in this request.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeUpdateMask(com.google.protobuf.FieldMask value) {
      if (updateMaskBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && updateMask_ != null
            && updateMask_ != com.google.protobuf.FieldMask.getDefaultInstance()) {
          getUpdateMaskBuilder().mergeFrom(value);
        } else {
          updateMask_ = value;
        }
      } else {
        updateMaskBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Required list of fields to be updated in this request.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearUpdateMask() {
      bitField0_ = (bitField0_ & ~0x00000004);
      updateMask_ = null;
      if (updateMaskBuilder_ != null) {
        updateMaskBuilder_.dispose();
        updateMaskBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Required list of fields to be updated in this request.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.protobuf.FieldMask.Builder getUpdateMaskBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getUpdateMaskFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Required list of fields to be updated in this request.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.protobuf.FieldMaskOrBuilder getUpdateMaskOrBuilder() {
      if (updateMaskBuilder_ != null) {
        return updateMaskBuilder_.getMessageOrBuilder();
      } else {
        return updateMask_ == null
            ? com.google.protobuf.FieldMask.getDefaultInstance()
            : updateMask_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Required list of fields to be updated in this request.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        getUpdateMaskFieldBuilder() {
      if (updateMaskBuilder_ == null) {
        updateMaskBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.FieldMask,
                com.google.protobuf.FieldMask.Builder,
                com.google.protobuf.FieldMaskOrBuilder>(
                getUpdateMask(), getParentForChildren(), isClean());
        updateMask_ = null;
      }
      return updateMaskBuilder_;
    }

    private java.lang.Object versionInfo_ = "";
    /**
     *
     *
     * <pre>
     * Optional version info. This is required only if
     * `transferConfig.dataSourceId` is not 'youtube_channel' and new credentials
     * are needed, as indicated by `CheckValidCreds`. In order to obtain version
     * info, make a request to the following URL:
     * &lt;pre class="prettyprint" suppresswarning="true"&gt;
     * https://www.gstatic.com/bigquerydatatransfer/oauthz/auth?redirect_uri=urn:ietf:wg:oauth:2.0:oob&amp;response_type=version_info&amp;client_id=&lt;var&gt;client_id&lt;/var&gt;&amp;scope=&lt;var&gt;data_source_scopes&lt;/var&gt;
     * &lt;/pre&gt;
     * * The &lt;var&gt;client_id&lt;/var&gt; is the OAuth client_id of the a data source as
     * returned by ListDataSources method.
     * * &lt;var&gt;data_source_scopes&lt;/var&gt; are the scopes returned by ListDataSources
     * method.
     *
     * Note that this should not be set when `service_account_name` is used to
     * update the transfer config.
     * </pre>
     *
     * <code>string version_info = 5;</code>
     *
     * @return The versionInfo.
     */
    public java.lang.String getVersionInfo() {
      java.lang.Object ref = versionInfo_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        versionInfo_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional version info. This is required only if
     * `transferConfig.dataSourceId` is not 'youtube_channel' and new credentials
     * are needed, as indicated by `CheckValidCreds`. In order to obtain version
     * info, make a request to the following URL:
     * &lt;pre class="prettyprint" suppresswarning="true"&gt;
     * https://www.gstatic.com/bigquerydatatransfer/oauthz/auth?redirect_uri=urn:ietf:wg:oauth:2.0:oob&amp;response_type=version_info&amp;client_id=&lt;var&gt;client_id&lt;/var&gt;&amp;scope=&lt;var&gt;data_source_scopes&lt;/var&gt;
     * &lt;/pre&gt;
     * * The &lt;var&gt;client_id&lt;/var&gt; is the OAuth client_id of the a data source as
     * returned by ListDataSources method.
     * * &lt;var&gt;data_source_scopes&lt;/var&gt; are the scopes returned by ListDataSources
     * method.
     *
     * Note that this should not be set when `service_account_name` is used to
     * update the transfer config.
     * </pre>
     *
     * <code>string version_info = 5;</code>
     *
     * @return The bytes for versionInfo.
     */
    public com.google.protobuf.ByteString getVersionInfoBytes() {
      java.lang.Object ref = versionInfo_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        versionInfo_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional version info. This is required only if
     * `transferConfig.dataSourceId` is not 'youtube_channel' and new credentials
     * are needed, as indicated by `CheckValidCreds`. In order to obtain version
     * info, make a request to the following URL:
     * &lt;pre class="prettyprint" suppresswarning="true"&gt;
     * https://www.gstatic.com/bigquerydatatransfer/oauthz/auth?redirect_uri=urn:ietf:wg:oauth:2.0:oob&amp;response_type=version_info&amp;client_id=&lt;var&gt;client_id&lt;/var&gt;&amp;scope=&lt;var&gt;data_source_scopes&lt;/var&gt;
     * &lt;/pre&gt;
     * * The &lt;var&gt;client_id&lt;/var&gt; is the OAuth client_id of the a data source as
     * returned by ListDataSources method.
     * * &lt;var&gt;data_source_scopes&lt;/var&gt; are the scopes returned by ListDataSources
     * method.
     *
     * Note that this should not be set when `service_account_name` is used to
     * update the transfer config.
     * </pre>
     *
     * <code>string version_info = 5;</code>
     *
     * @param value The versionInfo to set.
     * @return This builder for chaining.
     */
    public Builder setVersionInfo(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      versionInfo_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional version info. This is required only if
     * `transferConfig.dataSourceId` is not 'youtube_channel' and new credentials
     * are needed, as indicated by `CheckValidCreds`. In order to obtain version
     * info, make a request to the following URL:
     * &lt;pre class="prettyprint" suppresswarning="true"&gt;
     * https://www.gstatic.com/bigquerydatatransfer/oauthz/auth?redirect_uri=urn:ietf:wg:oauth:2.0:oob&amp;response_type=version_info&amp;client_id=&lt;var&gt;client_id&lt;/var&gt;&amp;scope=&lt;var&gt;data_source_scopes&lt;/var&gt;
     * &lt;/pre&gt;
     * * The &lt;var&gt;client_id&lt;/var&gt; is the OAuth client_id of the a data source as
     * returned by ListDataSources method.
     * * &lt;var&gt;data_source_scopes&lt;/var&gt; are the scopes returned by ListDataSources
     * method.
     *
     * Note that this should not be set when `service_account_name` is used to
     * update the transfer config.
     * </pre>
     *
     * <code>string version_info = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVersionInfo() {
      versionInfo_ = getDefaultInstance().getVersionInfo();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional version info. This is required only if
     * `transferConfig.dataSourceId` is not 'youtube_channel' and new credentials
     * are needed, as indicated by `CheckValidCreds`. In order to obtain version
     * info, make a request to the following URL:
     * &lt;pre class="prettyprint" suppresswarning="true"&gt;
     * https://www.gstatic.com/bigquerydatatransfer/oauthz/auth?redirect_uri=urn:ietf:wg:oauth:2.0:oob&amp;response_type=version_info&amp;client_id=&lt;var&gt;client_id&lt;/var&gt;&amp;scope=&lt;var&gt;data_source_scopes&lt;/var&gt;
     * &lt;/pre&gt;
     * * The &lt;var&gt;client_id&lt;/var&gt; is the OAuth client_id of the a data source as
     * returned by ListDataSources method.
     * * &lt;var&gt;data_source_scopes&lt;/var&gt; are the scopes returned by ListDataSources
     * method.
     *
     * Note that this should not be set when `service_account_name` is used to
     * update the transfer config.
     * </pre>
     *
     * <code>string version_info = 5;</code>
     *
     * @param value The bytes for versionInfo to set.
     * @return This builder for chaining.
     */
    public Builder setVersionInfoBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      versionInfo_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object serviceAccountName_ = "";
    /**
     *
     *
     * <pre>
     * Optional service account email. If this field is set, the transfer config
     * will be created with this service account's credentials. It requires that
     * the requesting user calling this API has permissions to act as this service
     * account.
     *
     * Note that not all data sources support service account credentials when
     * creating a transfer config. For the latest list of data sources, read about
     * [using service
     * accounts](https://cloud.google.com/bigquery-transfer/docs/use-service-accounts).
     * </pre>
     *
     * <code>string service_account_name = 6;</code>
     *
     * @return The serviceAccountName.
     */
    public java.lang.String getServiceAccountName() {
      java.lang.Object ref = serviceAccountName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceAccountName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional service account email. If this field is set, the transfer config
     * will be created with this service account's credentials. It requires that
     * the requesting user calling this API has permissions to act as this service
     * account.
     *
     * Note that not all data sources support service account credentials when
     * creating a transfer config. For the latest list of data sources, read about
     * [using service
     * accounts](https://cloud.google.com/bigquery-transfer/docs/use-service-accounts).
     * </pre>
     *
     * <code>string service_account_name = 6;</code>
     *
     * @return The bytes for serviceAccountName.
     */
    public com.google.protobuf.ByteString getServiceAccountNameBytes() {
      java.lang.Object ref = serviceAccountName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceAccountName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional service account email. If this field is set, the transfer config
     * will be created with this service account's credentials. It requires that
     * the requesting user calling this API has permissions to act as this service
     * account.
     *
     * Note that not all data sources support service account credentials when
     * creating a transfer config. For the latest list of data sources, read about
     * [using service
     * accounts](https://cloud.google.com/bigquery-transfer/docs/use-service-accounts).
     * </pre>
     *
     * <code>string service_account_name = 6;</code>
     *
     * @param value The serviceAccountName to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccountName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serviceAccountName_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional service account email. If this field is set, the transfer config
     * will be created with this service account's credentials. It requires that
     * the requesting user calling this API has permissions to act as this service
     * account.
     *
     * Note that not all data sources support service account credentials when
     * creating a transfer config. For the latest list of data sources, read about
     * [using service
     * accounts](https://cloud.google.com/bigquery-transfer/docs/use-service-accounts).
     * </pre>
     *
     * <code>string service_account_name = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceAccountName() {
      serviceAccountName_ = getDefaultInstance().getServiceAccountName();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional service account email. If this field is set, the transfer config
     * will be created with this service account's credentials. It requires that
     * the requesting user calling this API has permissions to act as this service
     * account.
     *
     * Note that not all data sources support service account credentials when
     * creating a transfer config. For the latest list of data sources, read about
     * [using service
     * accounts](https://cloud.google.com/bigquery-transfer/docs/use-service-accounts).
     * </pre>
     *
     * <code>string service_account_name = 6;</code>
     *
     * @param value The bytes for serviceAccountName to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccountNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serviceAccountName_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.datatransfer.v1.UpdateTransferConfigRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.bigquery.datatransfer.v1.UpdateTransferConfigRequest)
  private static final com.google.cloud.bigquery.datatransfer.v1.UpdateTransferConfigRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.bigquery.datatransfer.v1.UpdateTransferConfigRequest();
  }

  public static com.google.cloud.bigquery.datatransfer.v1.UpdateTransferConfigRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<UpdateTransferConfigRequest> PARSER =
      new com.google.protobuf.AbstractParser<UpdateTransferConfigRequest>() {
        @java.lang.Override
        public UpdateTransferConfigRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<UpdateTransferConfigRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<UpdateTransferConfigRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.bigquery.datatransfer.v1.UpdateTransferConfigRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
