/*
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/datatransfer/v1/datasource.proto

package com.google.cloud.bigquery.datatransfer.v1;

/**
 *
 *
 * <pre>
 * Returns a list of supported data source definitions.
 * </pre>
 *
 * Protobuf type {@code google.cloud.bigquery.datatransfer.v1.ListDataSourceDefinitionsResponse}
 */
public final class ListDataSourceDefinitionsResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.bigquery.datatransfer.v1.ListDataSourceDefinitionsResponse)
    ListDataSourceDefinitionsResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ListDataSourceDefinitionsResponse.newBuilder() to construct.
  private ListDataSourceDefinitionsResponse(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ListDataSourceDefinitionsResponse() {
    dataSourceDefinitions_ = java.util.Collections.emptyList();
    nextPageToken_ = "";
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private ListDataSourceDefinitionsResponse(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                dataSourceDefinitions_ =
                    new java.util.ArrayList<
                        com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition>();
                mutable_bitField0_ |= 0x00000001;
              }
              dataSourceDefinitions_.add(
                  input.readMessage(
                      com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition.parser(),
                      extensionRegistry));
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();

              nextPageToken_ = s;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        dataSourceDefinitions_ = java.util.Collections.unmodifiableList(dataSourceDefinitions_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.bigquery.datatransfer.v1.DataSourceProto
        .internal_static_google_cloud_bigquery_datatransfer_v1_ListDataSourceDefinitionsResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.bigquery.datatransfer.v1.DataSourceProto
        .internal_static_google_cloud_bigquery_datatransfer_v1_ListDataSourceDefinitionsResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.bigquery.datatransfer.v1.ListDataSourceDefinitionsResponse.class,
            com.google.cloud.bigquery.datatransfer.v1.ListDataSourceDefinitionsResponse.Builder
                .class);
  }

  private int bitField0_;
  public static final int DATA_SOURCE_DEFINITIONS_FIELD_NUMBER = 1;
  private java.util.List<com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition>
      dataSourceDefinitions_;
  /**
   *
   *
   * <pre>
   * List of supported data source definitions.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.datatransfer.v1.DataSourceDefinition data_source_definitions = 1;
   * </code>
   */
  public java.util.List<com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition>
      getDataSourceDefinitionsList() {
    return dataSourceDefinitions_;
  }
  /**
   *
   *
   * <pre>
   * List of supported data source definitions.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.datatransfer.v1.DataSourceDefinition data_source_definitions = 1;
   * </code>
   */
  public java.util.List<
          ? extends com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinitionOrBuilder>
      getDataSourceDefinitionsOrBuilderList() {
    return dataSourceDefinitions_;
  }
  /**
   *
   *
   * <pre>
   * List of supported data source definitions.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.datatransfer.v1.DataSourceDefinition data_source_definitions = 1;
   * </code>
   */
  public int getDataSourceDefinitionsCount() {
    return dataSourceDefinitions_.size();
  }
  /**
   *
   *
   * <pre>
   * List of supported data source definitions.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.datatransfer.v1.DataSourceDefinition data_source_definitions = 1;
   * </code>
   */
  public com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition getDataSourceDefinitions(
      int index) {
    return dataSourceDefinitions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of supported data source definitions.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.datatransfer.v1.DataSourceDefinition data_source_definitions = 1;
   * </code>
   */
  public com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinitionOrBuilder
      getDataSourceDefinitionsOrBuilder(int index) {
    return dataSourceDefinitions_.get(index);
  }

  public static final int NEXT_PAGE_TOKEN_FIELD_NUMBER = 2;
  private volatile java.lang.Object nextPageToken_;
  /**
   *
   *
   * <pre>
   * Output only. The next-pagination token. For multiple-page list results,
   * this token can be used as the
   * `ListDataSourceDefinitionsRequest.page_token`
   * to request the next page of the list results.
   * </pre>
   *
   * <code>string next_page_token = 2;</code>
   */
  public java.lang.String getNextPageToken() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nextPageToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The next-pagination token. For multiple-page list results,
   * this token can be used as the
   * `ListDataSourceDefinitionsRequest.page_token`
   * to request the next page of the list results.
   * </pre>
   *
   * <code>string next_page_token = 2;</code>
   */
  public com.google.protobuf.ByteString getNextPageTokenBytes() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nextPageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < dataSourceDefinitions_.size(); i++) {
      output.writeMessage(1, dataSourceDefinitions_.get(i));
    }
    if (!getNextPageTokenBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, nextPageToken_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < dataSourceDefinitions_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, dataSourceDefinitions_.get(i));
    }
    if (!getNextPageTokenBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, nextPageToken_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj
        instanceof com.google.cloud.bigquery.datatransfer.v1.ListDataSourceDefinitionsResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.bigquery.datatransfer.v1.ListDataSourceDefinitionsResponse other =
        (com.google.cloud.bigquery.datatransfer.v1.ListDataSourceDefinitionsResponse) obj;

    if (!getDataSourceDefinitionsList().equals(other.getDataSourceDefinitionsList())) return false;
    if (!getNextPageToken().equals(other.getNextPageToken())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getDataSourceDefinitionsCount() > 0) {
      hash = (37 * hash) + DATA_SOURCE_DEFINITIONS_FIELD_NUMBER;
      hash = (53 * hash) + getDataSourceDefinitionsList().hashCode();
    }
    hash = (37 * hash) + NEXT_PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getNextPageToken().hashCode();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ListDataSourceDefinitionsResponse
      parseFrom(java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ListDataSourceDefinitionsResponse
      parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ListDataSourceDefinitionsResponse
      parseFrom(com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ListDataSourceDefinitionsResponse
      parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ListDataSourceDefinitionsResponse
      parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ListDataSourceDefinitionsResponse
      parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ListDataSourceDefinitionsResponse
      parseFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ListDataSourceDefinitionsResponse
      parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ListDataSourceDefinitionsResponse
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ListDataSourceDefinitionsResponse
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ListDataSourceDefinitionsResponse
      parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ListDataSourceDefinitionsResponse
      parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.bigquery.datatransfer.v1.ListDataSourceDefinitionsResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Returns a list of supported data source definitions.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.datatransfer.v1.ListDataSourceDefinitionsResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.datatransfer.v1.ListDataSourceDefinitionsResponse)
      com.google.cloud.bigquery.datatransfer.v1.ListDataSourceDefinitionsResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.datatransfer.v1.DataSourceProto
          .internal_static_google_cloud_bigquery_datatransfer_v1_ListDataSourceDefinitionsResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.datatransfer.v1.DataSourceProto
          .internal_static_google_cloud_bigquery_datatransfer_v1_ListDataSourceDefinitionsResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.datatransfer.v1.ListDataSourceDefinitionsResponse.class,
              com.google.cloud.bigquery.datatransfer.v1.ListDataSourceDefinitionsResponse.Builder
                  .class);
    }

    // Construct using
    // com.google.cloud.bigquery.datatransfer.v1.ListDataSourceDefinitionsResponse.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getDataSourceDefinitionsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (dataSourceDefinitionsBuilder_ == null) {
        dataSourceDefinitions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        dataSourceDefinitionsBuilder_.clear();
      }
      nextPageToken_ = "";

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.bigquery.datatransfer.v1.DataSourceProto
          .internal_static_google_cloud_bigquery_datatransfer_v1_ListDataSourceDefinitionsResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.datatransfer.v1.ListDataSourceDefinitionsResponse
        getDefaultInstanceForType() {
      return com.google.cloud.bigquery.datatransfer.v1.ListDataSourceDefinitionsResponse
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.bigquery.datatransfer.v1.ListDataSourceDefinitionsResponse build() {
      com.google.cloud.bigquery.datatransfer.v1.ListDataSourceDefinitionsResponse result =
          buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.datatransfer.v1.ListDataSourceDefinitionsResponse
        buildPartial() {
      com.google.cloud.bigquery.datatransfer.v1.ListDataSourceDefinitionsResponse result =
          new com.google.cloud.bigquery.datatransfer.v1.ListDataSourceDefinitionsResponse(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (dataSourceDefinitionsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          dataSourceDefinitions_ = java.util.Collections.unmodifiableList(dataSourceDefinitions_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.dataSourceDefinitions_ = dataSourceDefinitions_;
      } else {
        result.dataSourceDefinitions_ = dataSourceDefinitionsBuilder_.build();
      }
      result.nextPageToken_ = nextPageToken_;
      result.bitField0_ = to_bitField0_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other
          instanceof com.google.cloud.bigquery.datatransfer.v1.ListDataSourceDefinitionsResponse) {
        return mergeFrom(
            (com.google.cloud.bigquery.datatransfer.v1.ListDataSourceDefinitionsResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.bigquery.datatransfer.v1.ListDataSourceDefinitionsResponse other) {
      if (other
          == com.google.cloud.bigquery.datatransfer.v1.ListDataSourceDefinitionsResponse
              .getDefaultInstance()) return this;
      if (dataSourceDefinitionsBuilder_ == null) {
        if (!other.dataSourceDefinitions_.isEmpty()) {
          if (dataSourceDefinitions_.isEmpty()) {
            dataSourceDefinitions_ = other.dataSourceDefinitions_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureDataSourceDefinitionsIsMutable();
            dataSourceDefinitions_.addAll(other.dataSourceDefinitions_);
          }
          onChanged();
        }
      } else {
        if (!other.dataSourceDefinitions_.isEmpty()) {
          if (dataSourceDefinitionsBuilder_.isEmpty()) {
            dataSourceDefinitionsBuilder_.dispose();
            dataSourceDefinitionsBuilder_ = null;
            dataSourceDefinitions_ = other.dataSourceDefinitions_;
            bitField0_ = (bitField0_ & ~0x00000001);
            dataSourceDefinitionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getDataSourceDefinitionsFieldBuilder()
                    : null;
          } else {
            dataSourceDefinitionsBuilder_.addAllMessages(other.dataSourceDefinitions_);
          }
        }
      }
      if (!other.getNextPageToken().isEmpty()) {
        nextPageToken_ = other.nextPageToken_;
        onChanged();
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.bigquery.datatransfer.v1.ListDataSourceDefinitionsResponse parsedMessage =
          null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.bigquery.datatransfer.v1.ListDataSourceDefinitionsResponse)
                e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition>
        dataSourceDefinitions_ = java.util.Collections.emptyList();

    private void ensureDataSourceDefinitionsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        dataSourceDefinitions_ =
            new java.util.ArrayList<com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition>(
                dataSourceDefinitions_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition,
            com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition.Builder,
            com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinitionOrBuilder>
        dataSourceDefinitionsBuilder_;

    /**
     *
     *
     * <pre>
     * List of supported data source definitions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.datatransfer.v1.DataSourceDefinition data_source_definitions = 1;
     * </code>
     */
    public java.util.List<com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition>
        getDataSourceDefinitionsList() {
      if (dataSourceDefinitionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(dataSourceDefinitions_);
      } else {
        return dataSourceDefinitionsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * List of supported data source definitions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.datatransfer.v1.DataSourceDefinition data_source_definitions = 1;
     * </code>
     */
    public int getDataSourceDefinitionsCount() {
      if (dataSourceDefinitionsBuilder_ == null) {
        return dataSourceDefinitions_.size();
      } else {
        return dataSourceDefinitionsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * List of supported data source definitions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.datatransfer.v1.DataSourceDefinition data_source_definitions = 1;
     * </code>
     */
    public com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition getDataSourceDefinitions(
        int index) {
      if (dataSourceDefinitionsBuilder_ == null) {
        return dataSourceDefinitions_.get(index);
      } else {
        return dataSourceDefinitionsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of supported data source definitions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.datatransfer.v1.DataSourceDefinition data_source_definitions = 1;
     * </code>
     */
    public Builder setDataSourceDefinitions(
        int index, com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition value) {
      if (dataSourceDefinitionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDataSourceDefinitionsIsMutable();
        dataSourceDefinitions_.set(index, value);
        onChanged();
      } else {
        dataSourceDefinitionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of supported data source definitions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.datatransfer.v1.DataSourceDefinition data_source_definitions = 1;
     * </code>
     */
    public Builder setDataSourceDefinitions(
        int index,
        com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition.Builder builderForValue) {
      if (dataSourceDefinitionsBuilder_ == null) {
        ensureDataSourceDefinitionsIsMutable();
        dataSourceDefinitions_.set(index, builderForValue.build());
        onChanged();
      } else {
        dataSourceDefinitionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of supported data source definitions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.datatransfer.v1.DataSourceDefinition data_source_definitions = 1;
     * </code>
     */
    public Builder addDataSourceDefinitions(
        com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition value) {
      if (dataSourceDefinitionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDataSourceDefinitionsIsMutable();
        dataSourceDefinitions_.add(value);
        onChanged();
      } else {
        dataSourceDefinitionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of supported data source definitions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.datatransfer.v1.DataSourceDefinition data_source_definitions = 1;
     * </code>
     */
    public Builder addDataSourceDefinitions(
        int index, com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition value) {
      if (dataSourceDefinitionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDataSourceDefinitionsIsMutable();
        dataSourceDefinitions_.add(index, value);
        onChanged();
      } else {
        dataSourceDefinitionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of supported data source definitions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.datatransfer.v1.DataSourceDefinition data_source_definitions = 1;
     * </code>
     */
    public Builder addDataSourceDefinitions(
        com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition.Builder builderForValue) {
      if (dataSourceDefinitionsBuilder_ == null) {
        ensureDataSourceDefinitionsIsMutable();
        dataSourceDefinitions_.add(builderForValue.build());
        onChanged();
      } else {
        dataSourceDefinitionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of supported data source definitions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.datatransfer.v1.DataSourceDefinition data_source_definitions = 1;
     * </code>
     */
    public Builder addDataSourceDefinitions(
        int index,
        com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition.Builder builderForValue) {
      if (dataSourceDefinitionsBuilder_ == null) {
        ensureDataSourceDefinitionsIsMutable();
        dataSourceDefinitions_.add(index, builderForValue.build());
        onChanged();
      } else {
        dataSourceDefinitionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of supported data source definitions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.datatransfer.v1.DataSourceDefinition data_source_definitions = 1;
     * </code>
     */
    public Builder addAllDataSourceDefinitions(
        java.lang.Iterable<? extends com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition>
            values) {
      if (dataSourceDefinitionsBuilder_ == null) {
        ensureDataSourceDefinitionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, dataSourceDefinitions_);
        onChanged();
      } else {
        dataSourceDefinitionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of supported data source definitions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.datatransfer.v1.DataSourceDefinition data_source_definitions = 1;
     * </code>
     */
    public Builder clearDataSourceDefinitions() {
      if (dataSourceDefinitionsBuilder_ == null) {
        dataSourceDefinitions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        dataSourceDefinitionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of supported data source definitions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.datatransfer.v1.DataSourceDefinition data_source_definitions = 1;
     * </code>
     */
    public Builder removeDataSourceDefinitions(int index) {
      if (dataSourceDefinitionsBuilder_ == null) {
        ensureDataSourceDefinitionsIsMutable();
        dataSourceDefinitions_.remove(index);
        onChanged();
      } else {
        dataSourceDefinitionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of supported data source definitions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.datatransfer.v1.DataSourceDefinition data_source_definitions = 1;
     * </code>
     */
    public com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition.Builder
        getDataSourceDefinitionsBuilder(int index) {
      return getDataSourceDefinitionsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * List of supported data source definitions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.datatransfer.v1.DataSourceDefinition data_source_definitions = 1;
     * </code>
     */
    public com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinitionOrBuilder
        getDataSourceDefinitionsOrBuilder(int index) {
      if (dataSourceDefinitionsBuilder_ == null) {
        return dataSourceDefinitions_.get(index);
      } else {
        return dataSourceDefinitionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of supported data source definitions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.datatransfer.v1.DataSourceDefinition data_source_definitions = 1;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinitionOrBuilder>
        getDataSourceDefinitionsOrBuilderList() {
      if (dataSourceDefinitionsBuilder_ != null) {
        return dataSourceDefinitionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(dataSourceDefinitions_);
      }
    }
    /**
     *
     *
     * <pre>
     * List of supported data source definitions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.datatransfer.v1.DataSourceDefinition data_source_definitions = 1;
     * </code>
     */
    public com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition.Builder
        addDataSourceDefinitionsBuilder() {
      return getDataSourceDefinitionsFieldBuilder()
          .addBuilder(
              com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of supported data source definitions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.datatransfer.v1.DataSourceDefinition data_source_definitions = 1;
     * </code>
     */
    public com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition.Builder
        addDataSourceDefinitionsBuilder(int index) {
      return getDataSourceDefinitionsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of supported data source definitions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.datatransfer.v1.DataSourceDefinition data_source_definitions = 1;
     * </code>
     */
    public java.util.List<com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition.Builder>
        getDataSourceDefinitionsBuilderList() {
      return getDataSourceDefinitionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition,
            com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition.Builder,
            com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinitionOrBuilder>
        getDataSourceDefinitionsFieldBuilder() {
      if (dataSourceDefinitionsBuilder_ == null) {
        dataSourceDefinitionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition,
                com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinition.Builder,
                com.google.cloud.bigquery.datatransfer.v1.DataSourceDefinitionOrBuilder>(
                dataSourceDefinitions_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        dataSourceDefinitions_ = null;
      }
      return dataSourceDefinitionsBuilder_;
    }

    private java.lang.Object nextPageToken_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The next-pagination token. For multiple-page list results,
     * this token can be used as the
     * `ListDataSourceDefinitionsRequest.page_token`
     * to request the next page of the list results.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     */
    public java.lang.String getNextPageToken() {
      java.lang.Object ref = nextPageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nextPageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The next-pagination token. For multiple-page list results,
     * this token can be used as the
     * `ListDataSourceDefinitionsRequest.page_token`
     * to request the next page of the list results.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     */
    public com.google.protobuf.ByteString getNextPageTokenBytes() {
      java.lang.Object ref = nextPageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nextPageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The next-pagination token. For multiple-page list results,
     * this token can be used as the
     * `ListDataSourceDefinitionsRequest.page_token`
     * to request the next page of the list results.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     */
    public Builder setNextPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      nextPageToken_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The next-pagination token. For multiple-page list results,
     * this token can be used as the
     * `ListDataSourceDefinitionsRequest.page_token`
     * to request the next page of the list results.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     */
    public Builder clearNextPageToken() {

      nextPageToken_ = getDefaultInstance().getNextPageToken();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The next-pagination token. For multiple-page list results,
     * this token can be used as the
     * `ListDataSourceDefinitionsRequest.page_token`
     * to request the next page of the list results.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     */
    public Builder setNextPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      nextPageToken_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.datatransfer.v1.ListDataSourceDefinitionsResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.bigquery.datatransfer.v1.ListDataSourceDefinitionsResponse)
  private static final com.google.cloud.bigquery.datatransfer.v1.ListDataSourceDefinitionsResponse
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE =
        new com.google.cloud.bigquery.datatransfer.v1.ListDataSourceDefinitionsResponse();
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ListDataSourceDefinitionsResponse
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ListDataSourceDefinitionsResponse> PARSER =
      new com.google.protobuf.AbstractParser<ListDataSourceDefinitionsResponse>() {
        @java.lang.Override
        public ListDataSourceDefinitionsResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new ListDataSourceDefinitionsResponse(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<ListDataSourceDefinitionsResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ListDataSourceDefinitionsResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.bigquery.datatransfer.v1.ListDataSourceDefinitionsResponse
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
