/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/datatransfer/v1/datatransfer.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.bigquery.datatransfer.v1;

/**
 *
 *
 * <pre>
 * A request to list data transfer runs.
 * </pre>
 *
 * Protobuf type {@code google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest}
 */
public final class ListTransferRunsRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest)
    ListTransferRunsRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ListTransferRunsRequest.newBuilder() to construct.
  private ListTransferRunsRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ListTransferRunsRequest() {
    parent_ = "";
    states_ = java.util.Collections.emptyList();
    pageToken_ = "";
    runAttempt_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ListTransferRunsRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.bigquery.datatransfer.v1.DataTransferProto
        .internal_static_google_cloud_bigquery_datatransfer_v1_ListTransferRunsRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.bigquery.datatransfer.v1.DataTransferProto
        .internal_static_google_cloud_bigquery_datatransfer_v1_ListTransferRunsRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest.class,
            com.google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Represents which runs should be pulled.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest.RunAttempt}
   */
  public enum RunAttempt implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * All runs should be returned.
     * </pre>
     *
     * <code>RUN_ATTEMPT_UNSPECIFIED = 0;</code>
     */
    RUN_ATTEMPT_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Only latest run per day should be returned.
     * </pre>
     *
     * <code>LATEST = 1;</code>
     */
    LATEST(1),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * All runs should be returned.
     * </pre>
     *
     * <code>RUN_ATTEMPT_UNSPECIFIED = 0;</code>
     */
    public static final int RUN_ATTEMPT_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Only latest run per day should be returned.
     * </pre>
     *
     * <code>LATEST = 1;</code>
     */
    public static final int LATEST_VALUE = 1;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RunAttempt valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static RunAttempt forNumber(int value) {
      switch (value) {
        case 0:
          return RUN_ATTEMPT_UNSPECIFIED;
        case 1:
          return LATEST;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<RunAttempt> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<RunAttempt> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<RunAttempt>() {
          public RunAttempt findValueByNumber(int number) {
            return RunAttempt.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final RunAttempt[] VALUES = values();

    public static RunAttempt valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private RunAttempt(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest.RunAttempt)
  }

  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Required. Name of transfer configuration for which transfer runs should be
   * retrieved. Format of transfer configuration resource name is:
   * `projects/{project_id}/transferConfigs/{config_id}` or
   * `projects/{project_id}/locations/{location_id}/transferConfigs/{config_id}`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Name of transfer configuration for which transfer runs should be
   * retrieved. Format of transfer configuration resource name is:
   * `projects/{project_id}/transferConfigs/{config_id}` or
   * `projects/{project_id}/locations/{location_id}/transferConfigs/{config_id}`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATES_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> states_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.cloud.bigquery.datatransfer.v1.TransferState>
      states_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.cloud.bigquery.datatransfer.v1.TransferState>() {
            public com.google.cloud.bigquery.datatransfer.v1.TransferState convert(
                java.lang.Integer from) {
              com.google.cloud.bigquery.datatransfer.v1.TransferState result =
                  com.google.cloud.bigquery.datatransfer.v1.TransferState.forNumber(from);
              return result == null
                  ? com.google.cloud.bigquery.datatransfer.v1.TransferState.UNRECOGNIZED
                  : result;
            }
          };
  /**
   *
   *
   * <pre>
   * When specified, only transfer runs with requested states are returned.
   * </pre>
   *
   * <code>repeated .google.cloud.bigquery.datatransfer.v1.TransferState states = 2;</code>
   *
   * @return A list containing the states.
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.bigquery.datatransfer.v1.TransferState> getStatesList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.cloud.bigquery.datatransfer.v1.TransferState>(
        states_, states_converter_);
  }
  /**
   *
   *
   * <pre>
   * When specified, only transfer runs with requested states are returned.
   * </pre>
   *
   * <code>repeated .google.cloud.bigquery.datatransfer.v1.TransferState states = 2;</code>
   *
   * @return The count of states.
   */
  @java.lang.Override
  public int getStatesCount() {
    return states_.size();
  }
  /**
   *
   *
   * <pre>
   * When specified, only transfer runs with requested states are returned.
   * </pre>
   *
   * <code>repeated .google.cloud.bigquery.datatransfer.v1.TransferState states = 2;</code>
   *
   * @param index The index of the element to return.
   * @return The states at the given index.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.datatransfer.v1.TransferState getStates(int index) {
    return states_converter_.convert(states_.get(index));
  }
  /**
   *
   *
   * <pre>
   * When specified, only transfer runs with requested states are returned.
   * </pre>
   *
   * <code>repeated .google.cloud.bigquery.datatransfer.v1.TransferState states = 2;</code>
   *
   * @return A list containing the enum numeric values on the wire for states.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getStatesValueList() {
    return states_;
  }
  /**
   *
   *
   * <pre>
   * When specified, only transfer runs with requested states are returned.
   * </pre>
   *
   * <code>repeated .google.cloud.bigquery.datatransfer.v1.TransferState states = 2;</code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of states at the given index.
   */
  @java.lang.Override
  public int getStatesValue(int index) {
    return states_.get(index);
  }

  private int statesMemoizedSerializedSize;

  public static final int PAGE_TOKEN_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object pageToken_ = "";
  /**
   *
   *
   * <pre>
   * Pagination token, which can be used to request a specific page
   * of `ListTransferRunsRequest` list results. For multiple-page
   * results, `ListTransferRunsResponse` outputs
   * a `next_page` token, which can be used as the
   * `page_token` value to request the next page of list results.
   * </pre>
   *
   * <code>string page_token = 3;</code>
   *
   * @return The pageToken.
   */
  @java.lang.Override
  public java.lang.String getPageToken() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pageToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Pagination token, which can be used to request a specific page
   * of `ListTransferRunsRequest` list results. For multiple-page
   * results, `ListTransferRunsResponse` outputs
   * a `next_page` token, which can be used as the
   * `page_token` value to request the next page of list results.
   * </pre>
   *
   * <code>string page_token = 3;</code>
   *
   * @return The bytes for pageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPageTokenBytes() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PAGE_SIZE_FIELD_NUMBER = 4;
  private int pageSize_ = 0;
  /**
   *
   *
   * <pre>
   * Page size. The default page size is the maximum value of 1000 results.
   * </pre>
   *
   * <code>int32 page_size = 4;</code>
   *
   * @return The pageSize.
   */
  @java.lang.Override
  public int getPageSize() {
    return pageSize_;
  }

  public static final int RUN_ATTEMPT_FIELD_NUMBER = 5;
  private int runAttempt_ = 0;
  /**
   *
   *
   * <pre>
   * Indicates how run attempts are to be pulled.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest.RunAttempt run_attempt = 5;
   * </code>
   *
   * @return The enum numeric value on the wire for runAttempt.
   */
  @java.lang.Override
  public int getRunAttemptValue() {
    return runAttempt_;
  }
  /**
   *
   *
   * <pre>
   * Indicates how run attempts are to be pulled.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest.RunAttempt run_attempt = 5;
   * </code>
   *
   * @return The runAttempt.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest.RunAttempt
      getRunAttempt() {
    com.google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest.RunAttempt result =
        com.google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest.RunAttempt.forNumber(
            runAttempt_);
    return result == null
        ? com.google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest.RunAttempt.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (getStatesList().size() > 0) {
      output.writeUInt32NoTag(18);
      output.writeUInt32NoTag(statesMemoizedSerializedSize);
    }
    for (int i = 0; i < states_.size(); i++) {
      output.writeEnumNoTag(states_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, pageToken_);
    }
    if (pageSize_ != 0) {
      output.writeInt32(4, pageSize_);
    }
    if (runAttempt_
        != com.google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest.RunAttempt
            .RUN_ATTEMPT_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(5, runAttempt_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < states_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(states_.get(i));
      }
      size += dataSize;
      if (!getStatesList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      statesMemoizedSerializedSize = dataSize;
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, pageToken_);
    }
    if (pageSize_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, pageSize_);
    }
    if (runAttempt_
        != com.google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest.RunAttempt
            .RUN_ATTEMPT_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, runAttempt_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest other =
        (com.google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (!states_.equals(other.states_)) return false;
    if (!getPageToken().equals(other.getPageToken())) return false;
    if (getPageSize() != other.getPageSize()) return false;
    if (runAttempt_ != other.runAttempt_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    if (getStatesCount() > 0) {
      hash = (37 * hash) + STATES_FIELD_NUMBER;
      hash = (53 * hash) + states_.hashCode();
    }
    hash = (37 * hash) + PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getPageToken().hashCode();
    hash = (37 * hash) + PAGE_SIZE_FIELD_NUMBER;
    hash = (53 * hash) + getPageSize();
    hash = (37 * hash) + RUN_ATTEMPT_FIELD_NUMBER;
    hash = (53 * hash) + runAttempt_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A request to list data transfer runs.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest)
      com.google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.datatransfer.v1.DataTransferProto
          .internal_static_google_cloud_bigquery_datatransfer_v1_ListTransferRunsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.datatransfer.v1.DataTransferProto
          .internal_static_google_cloud_bigquery_datatransfer_v1_ListTransferRunsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest.class,
              com.google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest.Builder.class);
    }

    // Construct using
    // com.google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      states_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      pageToken_ = "";
      pageSize_ = 0;
      runAttempt_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.bigquery.datatransfer.v1.DataTransferProto
          .internal_static_google_cloud_bigquery_datatransfer_v1_ListTransferRunsRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest
        getDefaultInstanceForType() {
      return com.google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest build() {
      com.google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest buildPartial() {
      com.google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest result =
          new com.google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest result) {
      if (((bitField0_ & 0x00000002) != 0)) {
        states_ = java.util.Collections.unmodifiableList(states_);
        bitField0_ = (bitField0_ & ~0x00000002);
      }
      result.states_ = states_;
    }

    private void buildPartial0(
        com.google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.pageToken_ = pageToken_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.pageSize_ = pageSize_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.runAttempt_ = runAttempt_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest) {
        return mergeFrom((com.google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest other) {
      if (other
          == com.google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.states_.isEmpty()) {
        if (states_.isEmpty()) {
          states_ = other.states_;
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          ensureStatesIsMutable();
          states_.addAll(other.states_);
        }
        onChanged();
      }
      if (!other.getPageToken().isEmpty()) {
        pageToken_ = other.pageToken_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.getPageSize() != 0) {
        setPageSize(other.getPageSize());
      }
      if (other.runAttempt_ != 0) {
        setRunAttemptValue(other.getRunAttemptValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                int tmpRaw = input.readEnum();
                ensureStatesIsMutable();
                states_.add(tmpRaw);
                break;
              } // case 16
            case 18:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureStatesIsMutable();
                  states_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 18
            case 26:
              {
                pageToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                pageSize_ = input.readInt32();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 40:
              {
                runAttempt_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. Name of transfer configuration for which transfer runs should be
     * retrieved. Format of transfer configuration resource name is:
     * `projects/{project_id}/transferConfigs/{config_id}` or
     * `projects/{project_id}/locations/{location_id}/transferConfigs/{config_id}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name of transfer configuration for which transfer runs should be
     * retrieved. Format of transfer configuration resource name is:
     * `projects/{project_id}/transferConfigs/{config_id}` or
     * `projects/{project_id}/locations/{location_id}/transferConfigs/{config_id}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name of transfer configuration for which transfer runs should be
     * retrieved. Format of transfer configuration resource name is:
     * `projects/{project_id}/transferConfigs/{config_id}` or
     * `projects/{project_id}/locations/{location_id}/transferConfigs/{config_id}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Name of transfer configuration for which transfer runs should be
     * retrieved. Format of transfer configuration resource name is:
     * `projects/{project_id}/transferConfigs/{config_id}` or
     * `projects/{project_id}/locations/{location_id}/transferConfigs/{config_id}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Name of transfer configuration for which transfer runs should be
     * retrieved. Format of transfer configuration resource name is:
     * `projects/{project_id}/transferConfigs/{config_id}` or
     * `projects/{project_id}/locations/{location_id}/transferConfigs/{config_id}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.util.List<java.lang.Integer> states_ = java.util.Collections.emptyList();

    private void ensureStatesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        states_ = new java.util.ArrayList<java.lang.Integer>(states_);
        bitField0_ |= 0x00000002;
      }
    }
    /**
     *
     *
     * <pre>
     * When specified, only transfer runs with requested states are returned.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.TransferState states = 2;</code>
     *
     * @return A list containing the states.
     */
    public java.util.List<com.google.cloud.bigquery.datatransfer.v1.TransferState> getStatesList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.cloud.bigquery.datatransfer.v1.TransferState>(
          states_, states_converter_);
    }
    /**
     *
     *
     * <pre>
     * When specified, only transfer runs with requested states are returned.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.TransferState states = 2;</code>
     *
     * @return The count of states.
     */
    public int getStatesCount() {
      return states_.size();
    }
    /**
     *
     *
     * <pre>
     * When specified, only transfer runs with requested states are returned.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.TransferState states = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The states at the given index.
     */
    public com.google.cloud.bigquery.datatransfer.v1.TransferState getStates(int index) {
      return states_converter_.convert(states_.get(index));
    }
    /**
     *
     *
     * <pre>
     * When specified, only transfer runs with requested states are returned.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.TransferState states = 2;</code>
     *
     * @param index The index to set the value at.
     * @param value The states to set.
     * @return This builder for chaining.
     */
    public Builder setStates(
        int index, com.google.cloud.bigquery.datatransfer.v1.TransferState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureStatesIsMutable();
      states_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * When specified, only transfer runs with requested states are returned.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.TransferState states = 2;</code>
     *
     * @param value The states to add.
     * @return This builder for chaining.
     */
    public Builder addStates(com.google.cloud.bigquery.datatransfer.v1.TransferState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureStatesIsMutable();
      states_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * When specified, only transfer runs with requested states are returned.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.TransferState states = 2;</code>
     *
     * @param values The states to add.
     * @return This builder for chaining.
     */
    public Builder addAllStates(
        java.lang.Iterable<? extends com.google.cloud.bigquery.datatransfer.v1.TransferState>
            values) {
      ensureStatesIsMutable();
      for (com.google.cloud.bigquery.datatransfer.v1.TransferState value : values) {
        states_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * When specified, only transfer runs with requested states are returned.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.TransferState states = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStates() {
      states_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * When specified, only transfer runs with requested states are returned.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.TransferState states = 2;</code>
     *
     * @return A list containing the enum numeric values on the wire for states.
     */
    public java.util.List<java.lang.Integer> getStatesValueList() {
      return java.util.Collections.unmodifiableList(states_);
    }
    /**
     *
     *
     * <pre>
     * When specified, only transfer runs with requested states are returned.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.TransferState states = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of states at the given index.
     */
    public int getStatesValue(int index) {
      return states_.get(index);
    }
    /**
     *
     *
     * <pre>
     * When specified, only transfer runs with requested states are returned.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.TransferState states = 2;</code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for states to set.
     * @return This builder for chaining.
     */
    public Builder setStatesValue(int index, int value) {
      ensureStatesIsMutable();
      states_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * When specified, only transfer runs with requested states are returned.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.TransferState states = 2;</code>
     *
     * @param value The enum numeric value on the wire for states to add.
     * @return This builder for chaining.
     */
    public Builder addStatesValue(int value) {
      ensureStatesIsMutable();
      states_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * When specified, only transfer runs with requested states are returned.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.TransferState states = 2;</code>
     *
     * @param values The enum numeric values on the wire for states to add.
     * @return This builder for chaining.
     */
    public Builder addAllStatesValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureStatesIsMutable();
      for (int value : values) {
        states_.add(value);
      }
      onChanged();
      return this;
    }

    private java.lang.Object pageToken_ = "";
    /**
     *
     *
     * <pre>
     * Pagination token, which can be used to request a specific page
     * of `ListTransferRunsRequest` list results. For multiple-page
     * results, `ListTransferRunsResponse` outputs
     * a `next_page` token, which can be used as the
     * `page_token` value to request the next page of list results.
     * </pre>
     *
     * <code>string page_token = 3;</code>
     *
     * @return The pageToken.
     */
    public java.lang.String getPageToken() {
      java.lang.Object ref = pageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Pagination token, which can be used to request a specific page
     * of `ListTransferRunsRequest` list results. For multiple-page
     * results, `ListTransferRunsResponse` outputs
     * a `next_page` token, which can be used as the
     * `page_token` value to request the next page of list results.
     * </pre>
     *
     * <code>string page_token = 3;</code>
     *
     * @return The bytes for pageToken.
     */
    public com.google.protobuf.ByteString getPageTokenBytes() {
      java.lang.Object ref = pageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Pagination token, which can be used to request a specific page
     * of `ListTransferRunsRequest` list results. For multiple-page
     * results, `ListTransferRunsResponse` outputs
     * a `next_page` token, which can be used as the
     * `page_token` value to request the next page of list results.
     * </pre>
     *
     * <code>string page_token = 3;</code>
     *
     * @param value The pageToken to set.
     * @return This builder for chaining.
     */
    public Builder setPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      pageToken_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Pagination token, which can be used to request a specific page
     * of `ListTransferRunsRequest` list results. For multiple-page
     * results, `ListTransferRunsResponse` outputs
     * a `next_page` token, which can be used as the
     * `page_token` value to request the next page of list results.
     * </pre>
     *
     * <code>string page_token = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageToken() {
      pageToken_ = getDefaultInstance().getPageToken();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Pagination token, which can be used to request a specific page
     * of `ListTransferRunsRequest` list results. For multiple-page
     * results, `ListTransferRunsResponse` outputs
     * a `next_page` token, which can be used as the
     * `page_token` value to request the next page of list results.
     * </pre>
     *
     * <code>string page_token = 3;</code>
     *
     * @param value The bytes for pageToken to set.
     * @return This builder for chaining.
     */
    public Builder setPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      pageToken_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private int pageSize_;
    /**
     *
     *
     * <pre>
     * Page size. The default page size is the maximum value of 1000 results.
     * </pre>
     *
     * <code>int32 page_size = 4;</code>
     *
     * @return The pageSize.
     */
    @java.lang.Override
    public int getPageSize() {
      return pageSize_;
    }
    /**
     *
     *
     * <pre>
     * Page size. The default page size is the maximum value of 1000 results.
     * </pre>
     *
     * <code>int32 page_size = 4;</code>
     *
     * @param value The pageSize to set.
     * @return This builder for chaining.
     */
    public Builder setPageSize(int value) {

      pageSize_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Page size. The default page size is the maximum value of 1000 results.
     * </pre>
     *
     * <code>int32 page_size = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageSize() {
      bitField0_ = (bitField0_ & ~0x00000008);
      pageSize_ = 0;
      onChanged();
      return this;
    }

    private int runAttempt_ = 0;
    /**
     *
     *
     * <pre>
     * Indicates how run attempts are to be pulled.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest.RunAttempt run_attempt = 5;
     * </code>
     *
     * @return The enum numeric value on the wire for runAttempt.
     */
    @java.lang.Override
    public int getRunAttemptValue() {
      return runAttempt_;
    }
    /**
     *
     *
     * <pre>
     * Indicates how run attempts are to be pulled.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest.RunAttempt run_attempt = 5;
     * </code>
     *
     * @param value The enum numeric value on the wire for runAttempt to set.
     * @return This builder for chaining.
     */
    public Builder setRunAttemptValue(int value) {
      runAttempt_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates how run attempts are to be pulled.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest.RunAttempt run_attempt = 5;
     * </code>
     *
     * @return The runAttempt.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest.RunAttempt
        getRunAttempt() {
      com.google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest.RunAttempt result =
          com.google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest.RunAttempt.forNumber(
              runAttempt_);
      return result == null
          ? com.google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest.RunAttempt
              .UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Indicates how run attempts are to be pulled.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest.RunAttempt run_attempt = 5;
     * </code>
     *
     * @param value The runAttempt to set.
     * @return This builder for chaining.
     */
    public Builder setRunAttempt(
        com.google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest.RunAttempt value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      runAttempt_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates how run attempts are to be pulled.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest.RunAttempt run_attempt = 5;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRunAttempt() {
      bitField0_ = (bitField0_ & ~0x00000010);
      runAttempt_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest)
  private static final com.google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest();
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ListTransferRunsRequest> PARSER =
      new com.google.protobuf.AbstractParser<ListTransferRunsRequest>() {
        @java.lang.Override
        public ListTransferRunsRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ListTransferRunsRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ListTransferRunsRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
