/*
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/datatransfer/v1/datasource.proto

package com.google.cloud.bigquery.datatransfer.v1;

/**
 *
 *
 * <pre>
 * A request to start and monitor a BigQuery load job.
 * </pre>
 *
 * Protobuf type {@code google.cloud.bigquery.datatransfer.v1.StartBigQueryJobsRequest}
 */
public final class StartBigQueryJobsRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.bigquery.datatransfer.v1.StartBigQueryJobsRequest)
    StartBigQueryJobsRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use StartBigQueryJobsRequest.newBuilder() to construct.
  private StartBigQueryJobsRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private StartBigQueryJobsRequest() {
    name_ = "";
    importedData_ = java.util.Collections.emptyList();
    userCredentials_ = com.google.protobuf.ByteString.EMPTY;
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private StartBigQueryJobsRequest(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 18:
            {
              if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                importedData_ =
                    new java.util.ArrayList<
                        com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo>();
                mutable_bitField0_ |= 0x00000002;
              }
              importedData_.add(
                  input.readMessage(
                      com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.parser(),
                      extensionRegistry));
              break;
            }
          case 26:
            {
              userCredentials_ = input.readBytes();
              break;
            }
          case 64:
            {
              maxParallelism_ = input.readInt32();
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000002) != 0)) {
        importedData_ = java.util.Collections.unmodifiableList(importedData_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.bigquery.datatransfer.v1.DataSourceProto
        .internal_static_google_cloud_bigquery_datatransfer_v1_StartBigQueryJobsRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.bigquery.datatransfer.v1.DataSourceProto
        .internal_static_google_cloud_bigquery_datatransfer_v1_StartBigQueryJobsRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.bigquery.datatransfer.v1.StartBigQueryJobsRequest.class,
            com.google.cloud.bigquery.datatransfer.v1.StartBigQueryJobsRequest.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Name of the resource in the form:
   * "projects/{project_id}/locations/{location_id}/transferConfigs/{config_id}/runs/{run_id}"
   * </pre>
   *
   * <code>string name = 1;</code>
   */
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name of the resource in the form:
   * "projects/{project_id}/locations/{location_id}/transferConfigs/{config_id}/runs/{run_id}"
   * </pre>
   *
   * <code>string name = 1;</code>
   */
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IMPORTED_DATA_FIELD_NUMBER = 2;
  private java.util.List<com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo> importedData_;
  /**
   *
   *
   * <pre>
   * Import jobs which should be started and monitored.
   * </pre>
   *
   * <code>repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo imported_data = 2;
   * </code>
   */
  public java.util.List<com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo>
      getImportedDataList() {
    return importedData_;
  }
  /**
   *
   *
   * <pre>
   * Import jobs which should be started and monitored.
   * </pre>
   *
   * <code>repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo imported_data = 2;
   * </code>
   */
  public java.util.List<
          ? extends com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfoOrBuilder>
      getImportedDataOrBuilderList() {
    return importedData_;
  }
  /**
   *
   *
   * <pre>
   * Import jobs which should be started and monitored.
   * </pre>
   *
   * <code>repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo imported_data = 2;
   * </code>
   */
  public int getImportedDataCount() {
    return importedData_.size();
  }
  /**
   *
   *
   * <pre>
   * Import jobs which should be started and monitored.
   * </pre>
   *
   * <code>repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo imported_data = 2;
   * </code>
   */
  public com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo getImportedData(int index) {
    return importedData_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Import jobs which should be started and monitored.
   * </pre>
   *
   * <code>repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo imported_data = 2;
   * </code>
   */
  public com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfoOrBuilder
      getImportedDataOrBuilder(int index) {
    return importedData_.get(index);
  }

  public static final int USER_CREDENTIALS_FIELD_NUMBER = 3;
  private com.google.protobuf.ByteString userCredentials_;
  /**
   *
   *
   * <pre>
   * User credentials which should be used to start/monitor
   * BigQuery jobs. If not specified, then jobs
   * are started using data source service account credentials.
   * This may be OAuth token or JWT token.
   * </pre>
   *
   * <code>bytes user_credentials = 3;</code>
   */
  public com.google.protobuf.ByteString getUserCredentials() {
    return userCredentials_;
  }

  public static final int MAX_PARALLELISM_FIELD_NUMBER = 8;
  private int maxParallelism_;
  /**
   *
   *
   * <pre>
   * The number of BQ Jobs that can run in parallel.
   * </pre>
   *
   * <code>int32 max_parallelism = 8;</code>
   */
  public int getMaxParallelism() {
    return maxParallelism_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    for (int i = 0; i < importedData_.size(); i++) {
      output.writeMessage(2, importedData_.get(i));
    }
    if (!userCredentials_.isEmpty()) {
      output.writeBytes(3, userCredentials_);
    }
    if (maxParallelism_ != 0) {
      output.writeInt32(8, maxParallelism_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    for (int i = 0; i < importedData_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, importedData_.get(i));
    }
    if (!userCredentials_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(3, userCredentials_);
    }
    if (maxParallelism_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(8, maxParallelism_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.bigquery.datatransfer.v1.StartBigQueryJobsRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.bigquery.datatransfer.v1.StartBigQueryJobsRequest other =
        (com.google.cloud.bigquery.datatransfer.v1.StartBigQueryJobsRequest) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getImportedDataList().equals(other.getImportedDataList())) return false;
    if (!getUserCredentials().equals(other.getUserCredentials())) return false;
    if (getMaxParallelism() != other.getMaxParallelism()) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (getImportedDataCount() > 0) {
      hash = (37 * hash) + IMPORTED_DATA_FIELD_NUMBER;
      hash = (53 * hash) + getImportedDataList().hashCode();
    }
    hash = (37 * hash) + USER_CREDENTIALS_FIELD_NUMBER;
    hash = (53 * hash) + getUserCredentials().hashCode();
    hash = (37 * hash) + MAX_PARALLELISM_FIELD_NUMBER;
    hash = (53 * hash) + getMaxParallelism();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.bigquery.datatransfer.v1.StartBigQueryJobsRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.StartBigQueryJobsRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.StartBigQueryJobsRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.StartBigQueryJobsRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.StartBigQueryJobsRequest parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.StartBigQueryJobsRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.StartBigQueryJobsRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.StartBigQueryJobsRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.StartBigQueryJobsRequest
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.StartBigQueryJobsRequest
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.StartBigQueryJobsRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.StartBigQueryJobsRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.bigquery.datatransfer.v1.StartBigQueryJobsRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A request to start and monitor a BigQuery load job.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.datatransfer.v1.StartBigQueryJobsRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.datatransfer.v1.StartBigQueryJobsRequest)
      com.google.cloud.bigquery.datatransfer.v1.StartBigQueryJobsRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.datatransfer.v1.DataSourceProto
          .internal_static_google_cloud_bigquery_datatransfer_v1_StartBigQueryJobsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.datatransfer.v1.DataSourceProto
          .internal_static_google_cloud_bigquery_datatransfer_v1_StartBigQueryJobsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.datatransfer.v1.StartBigQueryJobsRequest.class,
              com.google.cloud.bigquery.datatransfer.v1.StartBigQueryJobsRequest.Builder.class);
    }

    // Construct using
    // com.google.cloud.bigquery.datatransfer.v1.StartBigQueryJobsRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getImportedDataFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      if (importedDataBuilder_ == null) {
        importedData_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
      } else {
        importedDataBuilder_.clear();
      }
      userCredentials_ = com.google.protobuf.ByteString.EMPTY;

      maxParallelism_ = 0;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.bigquery.datatransfer.v1.DataSourceProto
          .internal_static_google_cloud_bigquery_datatransfer_v1_StartBigQueryJobsRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.datatransfer.v1.StartBigQueryJobsRequest
        getDefaultInstanceForType() {
      return com.google.cloud.bigquery.datatransfer.v1.StartBigQueryJobsRequest
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.bigquery.datatransfer.v1.StartBigQueryJobsRequest build() {
      com.google.cloud.bigquery.datatransfer.v1.StartBigQueryJobsRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.datatransfer.v1.StartBigQueryJobsRequest buildPartial() {
      com.google.cloud.bigquery.datatransfer.v1.StartBigQueryJobsRequest result =
          new com.google.cloud.bigquery.datatransfer.v1.StartBigQueryJobsRequest(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      result.name_ = name_;
      if (importedDataBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          importedData_ = java.util.Collections.unmodifiableList(importedData_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.importedData_ = importedData_;
      } else {
        result.importedData_ = importedDataBuilder_.build();
      }
      result.userCredentials_ = userCredentials_;
      result.maxParallelism_ = maxParallelism_;
      result.bitField0_ = to_bitField0_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.bigquery.datatransfer.v1.StartBigQueryJobsRequest) {
        return mergeFrom(
            (com.google.cloud.bigquery.datatransfer.v1.StartBigQueryJobsRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.bigquery.datatransfer.v1.StartBigQueryJobsRequest other) {
      if (other
          == com.google.cloud.bigquery.datatransfer.v1.StartBigQueryJobsRequest
              .getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (importedDataBuilder_ == null) {
        if (!other.importedData_.isEmpty()) {
          if (importedData_.isEmpty()) {
            importedData_ = other.importedData_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureImportedDataIsMutable();
            importedData_.addAll(other.importedData_);
          }
          onChanged();
        }
      } else {
        if (!other.importedData_.isEmpty()) {
          if (importedDataBuilder_.isEmpty()) {
            importedDataBuilder_.dispose();
            importedDataBuilder_ = null;
            importedData_ = other.importedData_;
            bitField0_ = (bitField0_ & ~0x00000002);
            importedDataBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getImportedDataFieldBuilder()
                    : null;
          } else {
            importedDataBuilder_.addAllMessages(other.importedData_);
          }
        }
      }
      if (other.getUserCredentials() != com.google.protobuf.ByteString.EMPTY) {
        setUserCredentials(other.getUserCredentials());
      }
      if (other.getMaxParallelism() != 0) {
        setMaxParallelism(other.getMaxParallelism());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.bigquery.datatransfer.v1.StartBigQueryJobsRequest parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.bigquery.datatransfer.v1.StartBigQueryJobsRequest)
                e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Name of the resource in the form:
     * "projects/{project_id}/locations/{location_id}/transferConfigs/{config_id}/runs/{run_id}"
     * </pre>
     *
     * <code>string name = 1;</code>
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the resource in the form:
     * "projects/{project_id}/locations/{location_id}/transferConfigs/{config_id}/runs/{run_id}"
     * </pre>
     *
     * <code>string name = 1;</code>
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the resource in the form:
     * "projects/{project_id}/locations/{location_id}/transferConfigs/{config_id}/runs/{run_id}"
     * </pre>
     *
     * <code>string name = 1;</code>
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the resource in the form:
     * "projects/{project_id}/locations/{location_id}/transferConfigs/{config_id}/runs/{run_id}"
     * </pre>
     *
     * <code>string name = 1;</code>
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the resource in the form:
     * "projects/{project_id}/locations/{location_id}/transferConfigs/{config_id}/runs/{run_id}"
     * </pre>
     *
     * <code>string name = 1;</code>
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo>
        importedData_ = java.util.Collections.emptyList();

    private void ensureImportedDataIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        importedData_ =
            new java.util.ArrayList<com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo>(
                importedData_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo,
            com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.Builder,
            com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfoOrBuilder>
        importedDataBuilder_;

    /**
     *
     *
     * <pre>
     * Import jobs which should be started and monitored.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo imported_data = 2;
     * </code>
     */
    public java.util.List<com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo>
        getImportedDataList() {
      if (importedDataBuilder_ == null) {
        return java.util.Collections.unmodifiableList(importedData_);
      } else {
        return importedDataBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Import jobs which should be started and monitored.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo imported_data = 2;
     * </code>
     */
    public int getImportedDataCount() {
      if (importedDataBuilder_ == null) {
        return importedData_.size();
      } else {
        return importedDataBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Import jobs which should be started and monitored.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo imported_data = 2;
     * </code>
     */
    public com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo getImportedData(int index) {
      if (importedDataBuilder_ == null) {
        return importedData_.get(index);
      } else {
        return importedDataBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Import jobs which should be started and monitored.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo imported_data = 2;
     * </code>
     */
    public Builder setImportedData(
        int index, com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo value) {
      if (importedDataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureImportedDataIsMutable();
        importedData_.set(index, value);
        onChanged();
      } else {
        importedDataBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Import jobs which should be started and monitored.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo imported_data = 2;
     * </code>
     */
    public Builder setImportedData(
        int index,
        com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.Builder builderForValue) {
      if (importedDataBuilder_ == null) {
        ensureImportedDataIsMutable();
        importedData_.set(index, builderForValue.build());
        onChanged();
      } else {
        importedDataBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Import jobs which should be started and monitored.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo imported_data = 2;
     * </code>
     */
    public Builder addImportedData(
        com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo value) {
      if (importedDataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureImportedDataIsMutable();
        importedData_.add(value);
        onChanged();
      } else {
        importedDataBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Import jobs which should be started and monitored.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo imported_data = 2;
     * </code>
     */
    public Builder addImportedData(
        int index, com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo value) {
      if (importedDataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureImportedDataIsMutable();
        importedData_.add(index, value);
        onChanged();
      } else {
        importedDataBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Import jobs which should be started and monitored.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo imported_data = 2;
     * </code>
     */
    public Builder addImportedData(
        com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.Builder builderForValue) {
      if (importedDataBuilder_ == null) {
        ensureImportedDataIsMutable();
        importedData_.add(builderForValue.build());
        onChanged();
      } else {
        importedDataBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Import jobs which should be started and monitored.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo imported_data = 2;
     * </code>
     */
    public Builder addImportedData(
        int index,
        com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.Builder builderForValue) {
      if (importedDataBuilder_ == null) {
        ensureImportedDataIsMutable();
        importedData_.add(index, builderForValue.build());
        onChanged();
      } else {
        importedDataBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Import jobs which should be started and monitored.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo imported_data = 2;
     * </code>
     */
    public Builder addAllImportedData(
        java.lang.Iterable<? extends com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo>
            values) {
      if (importedDataBuilder_ == null) {
        ensureImportedDataIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, importedData_);
        onChanged();
      } else {
        importedDataBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Import jobs which should be started and monitored.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo imported_data = 2;
     * </code>
     */
    public Builder clearImportedData() {
      if (importedDataBuilder_ == null) {
        importedData_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        importedDataBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Import jobs which should be started and monitored.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo imported_data = 2;
     * </code>
     */
    public Builder removeImportedData(int index) {
      if (importedDataBuilder_ == null) {
        ensureImportedDataIsMutable();
        importedData_.remove(index);
        onChanged();
      } else {
        importedDataBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Import jobs which should be started and monitored.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo imported_data = 2;
     * </code>
     */
    public com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.Builder
        getImportedDataBuilder(int index) {
      return getImportedDataFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Import jobs which should be started and monitored.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo imported_data = 2;
     * </code>
     */
    public com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfoOrBuilder
        getImportedDataOrBuilder(int index) {
      if (importedDataBuilder_ == null) {
        return importedData_.get(index);
      } else {
        return importedDataBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Import jobs which should be started and monitored.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo imported_data = 2;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfoOrBuilder>
        getImportedDataOrBuilderList() {
      if (importedDataBuilder_ != null) {
        return importedDataBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(importedData_);
      }
    }
    /**
     *
     *
     * <pre>
     * Import jobs which should be started and monitored.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo imported_data = 2;
     * </code>
     */
    public com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.Builder
        addImportedDataBuilder() {
      return getImportedDataFieldBuilder()
          .addBuilder(
              com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Import jobs which should be started and monitored.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo imported_data = 2;
     * </code>
     */
    public com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.Builder
        addImportedDataBuilder(int index) {
      return getImportedDataFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Import jobs which should be started and monitored.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo imported_data = 2;
     * </code>
     */
    public java.util.List<com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.Builder>
        getImportedDataBuilderList() {
      return getImportedDataFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo,
            com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.Builder,
            com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfoOrBuilder>
        getImportedDataFieldBuilder() {
      if (importedDataBuilder_ == null) {
        importedDataBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo,
                com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.Builder,
                com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfoOrBuilder>(
                importedData_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        importedData_ = null;
      }
      return importedDataBuilder_;
    }

    private com.google.protobuf.ByteString userCredentials_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * User credentials which should be used to start/monitor
     * BigQuery jobs. If not specified, then jobs
     * are started using data source service account credentials.
     * This may be OAuth token or JWT token.
     * </pre>
     *
     * <code>bytes user_credentials = 3;</code>
     */
    public com.google.protobuf.ByteString getUserCredentials() {
      return userCredentials_;
    }
    /**
     *
     *
     * <pre>
     * User credentials which should be used to start/monitor
     * BigQuery jobs. If not specified, then jobs
     * are started using data source service account credentials.
     * This may be OAuth token or JWT token.
     * </pre>
     *
     * <code>bytes user_credentials = 3;</code>
     */
    public Builder setUserCredentials(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }

      userCredentials_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User credentials which should be used to start/monitor
     * BigQuery jobs. If not specified, then jobs
     * are started using data source service account credentials.
     * This may be OAuth token or JWT token.
     * </pre>
     *
     * <code>bytes user_credentials = 3;</code>
     */
    public Builder clearUserCredentials() {

      userCredentials_ = getDefaultInstance().getUserCredentials();
      onChanged();
      return this;
    }

    private int maxParallelism_;
    /**
     *
     *
     * <pre>
     * The number of BQ Jobs that can run in parallel.
     * </pre>
     *
     * <code>int32 max_parallelism = 8;</code>
     */
    public int getMaxParallelism() {
      return maxParallelism_;
    }
    /**
     *
     *
     * <pre>
     * The number of BQ Jobs that can run in parallel.
     * </pre>
     *
     * <code>int32 max_parallelism = 8;</code>
     */
    public Builder setMaxParallelism(int value) {

      maxParallelism_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number of BQ Jobs that can run in parallel.
     * </pre>
     *
     * <code>int32 max_parallelism = 8;</code>
     */
    public Builder clearMaxParallelism() {

      maxParallelism_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.datatransfer.v1.StartBigQueryJobsRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.bigquery.datatransfer.v1.StartBigQueryJobsRequest)
  private static final com.google.cloud.bigquery.datatransfer.v1.StartBigQueryJobsRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.bigquery.datatransfer.v1.StartBigQueryJobsRequest();
  }

  public static com.google.cloud.bigquery.datatransfer.v1.StartBigQueryJobsRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<StartBigQueryJobsRequest> PARSER =
      new com.google.protobuf.AbstractParser<StartBigQueryJobsRequest>() {
        @java.lang.Override
        public StartBigQueryJobsRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new StartBigQueryJobsRequest(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<StartBigQueryJobsRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<StartBigQueryJobsRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.bigquery.datatransfer.v1.StartBigQueryJobsRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
