/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/datatransfer/v1/transfer.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.bigquery.datatransfer.v1;

/**
 *
 *
 * <pre>
 * Represents a data transfer run.
 * </pre>
 *
 * Protobuf type {@code google.cloud.bigquery.datatransfer.v1.TransferRun}
 */
public final class TransferRun extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.bigquery.datatransfer.v1.TransferRun)
    TransferRunOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TransferRun.newBuilder() to construct.
  private TransferRun(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TransferRun() {
    name_ = "";
    dataSourceId_ = "";
    state_ = 0;
    schedule_ = "";
    notificationPubsubTopic_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TransferRun();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.bigquery.datatransfer.v1.TransferProto
        .internal_static_google_cloud_bigquery_datatransfer_v1_TransferRun_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.bigquery.datatransfer.v1.TransferProto
        .internal_static_google_cloud_bigquery_datatransfer_v1_TransferRun_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.bigquery.datatransfer.v1.TransferRun.class,
            com.google.cloud.bigquery.datatransfer.v1.TransferRun.Builder.class);
  }

  private int bitField0_;
  private int destinationCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object destination_;

  public enum DestinationCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    DESTINATION_DATASET_ID(2),
    DESTINATION_NOT_SET(0);
    private final int value;

    private DestinationCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DestinationCase valueOf(int value) {
      return forNumber(value);
    }

    public static DestinationCase forNumber(int value) {
      switch (value) {
        case 2:
          return DESTINATION_DATASET_ID;
        case 0:
          return DESTINATION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public DestinationCase getDestinationCase() {
    return DestinationCase.forNumber(destinationCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The resource name of the transfer run.
   * Transfer run names have the form
   * `projects/{project_id}/locations/{location}/transferConfigs/{config_id}/runs/{run_id}`.
   * The name is ignored when creating a transfer run.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name of the transfer run.
   * Transfer run names have the form
   * `projects/{project_id}/locations/{location}/transferConfigs/{config_id}/runs/{run_id}`.
   * The name is ignored when creating a transfer run.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SCHEDULE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp scheduleTime_;
  /**
   *
   *
   * <pre>
   * Minimum time after which a transfer run can be started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp schedule_time = 3;</code>
   *
   * @return Whether the scheduleTime field is set.
   */
  @java.lang.Override
  public boolean hasScheduleTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Minimum time after which a transfer run can be started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp schedule_time = 3;</code>
   *
   * @return The scheduleTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getScheduleTime() {
    return scheduleTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : scheduleTime_;
  }
  /**
   *
   *
   * <pre>
   * Minimum time after which a transfer run can be started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp schedule_time = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getScheduleTimeOrBuilder() {
    return scheduleTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : scheduleTime_;
  }

  public static final int RUN_TIME_FIELD_NUMBER = 10;
  private com.google.protobuf.Timestamp runTime_;
  /**
   *
   *
   * <pre>
   * For batch transfer runs, specifies the date and time of the data should be
   * ingested.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp run_time = 10;</code>
   *
   * @return Whether the runTime field is set.
   */
  @java.lang.Override
  public boolean hasRunTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * For batch transfer runs, specifies the date and time of the data should be
   * ingested.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp run_time = 10;</code>
   *
   * @return The runTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getRunTime() {
    return runTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : runTime_;
  }
  /**
   *
   *
   * <pre>
   * For batch transfer runs, specifies the date and time of the data should be
   * ingested.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp run_time = 10;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getRunTimeOrBuilder() {
    return runTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : runTime_;
  }

  public static final int ERROR_STATUS_FIELD_NUMBER = 21;
  private com.google.rpc.Status errorStatus_;
  /**
   *
   *
   * <pre>
   * Status of the transfer run.
   * </pre>
   *
   * <code>.google.rpc.Status error_status = 21;</code>
   *
   * @return Whether the errorStatus field is set.
   */
  @java.lang.Override
  public boolean hasErrorStatus() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Status of the transfer run.
   * </pre>
   *
   * <code>.google.rpc.Status error_status = 21;</code>
   *
   * @return The errorStatus.
   */
  @java.lang.Override
  public com.google.rpc.Status getErrorStatus() {
    return errorStatus_ == null ? com.google.rpc.Status.getDefaultInstance() : errorStatus_;
  }
  /**
   *
   *
   * <pre>
   * Status of the transfer run.
   * </pre>
   *
   * <code>.google.rpc.Status error_status = 21;</code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getErrorStatusOrBuilder() {
    return errorStatus_ == null ? com.google.rpc.Status.getDefaultInstance() : errorStatus_;
  }

  public static final int START_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp startTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time when transfer run was started.
   * Parameter ignored by server for input requests.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the startTime field is set.
   */
  @java.lang.Override
  public boolean hasStartTime() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when transfer run was started.
   * Parameter ignored by server for input requests.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The startTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getStartTime() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when transfer run was started.
   * Parameter ignored by server for input requests.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }

  public static final int END_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp endTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time when transfer run ended.
   * Parameter ignored by server for input requests.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the endTime field is set.
   */
  @java.lang.Override
  public boolean hasEndTime() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when transfer run ended.
   * Parameter ignored by server for input requests.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The endTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEndTime() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when transfer run ended.
   * Parameter ignored by server for input requests.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Last time the data transfer run state was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Last time the data transfer run state was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Last time the data transfer run state was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int PARAMS_FIELD_NUMBER = 9;
  private com.google.protobuf.Struct params_;
  /**
   *
   *
   * <pre>
   * Output only. Parameters specific to each data source. For more information
   * see the bq tab in the 'Setting up a data transfer' section for each data
   * source. For example the parameters for Cloud Storage transfers are listed
   * here:
   * https://cloud.google.com/bigquery-transfer/docs/cloud-storage-transfer#bq
   * </pre>
   *
   * <code>.google.protobuf.Struct params = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return Whether the params field is set.
   */
  @java.lang.Override
  public boolean hasParams() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Parameters specific to each data source. For more information
   * see the bq tab in the 'Setting up a data transfer' section for each data
   * source. For example the parameters for Cloud Storage transfers are listed
   * here:
   * https://cloud.google.com/bigquery-transfer/docs/cloud-storage-transfer#bq
   * </pre>
   *
   * <code>.google.protobuf.Struct params = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The params.
   */
  @java.lang.Override
  public com.google.protobuf.Struct getParams() {
    return params_ == null ? com.google.protobuf.Struct.getDefaultInstance() : params_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Parameters specific to each data source. For more information
   * see the bq tab in the 'Setting up a data transfer' section for each data
   * source. For example the parameters for Cloud Storage transfers are listed
   * here:
   * https://cloud.google.com/bigquery-transfer/docs/cloud-storage-transfer#bq
   * </pre>
   *
   * <code>.google.protobuf.Struct params = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.protobuf.StructOrBuilder getParamsOrBuilder() {
    return params_ == null ? com.google.protobuf.Struct.getDefaultInstance() : params_;
  }

  public static final int DESTINATION_DATASET_ID_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Output only. The BigQuery target dataset id.
   * </pre>
   *
   * <code>string destination_dataset_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return Whether the destinationDatasetId field is set.
   */
  public boolean hasDestinationDatasetId() {
    return destinationCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Output only. The BigQuery target dataset id.
   * </pre>
   *
   * <code>string destination_dataset_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The destinationDatasetId.
   */
  public java.lang.String getDestinationDatasetId() {
    java.lang.Object ref = "";
    if (destinationCase_ == 2) {
      ref = destination_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (destinationCase_ == 2) {
        destination_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The BigQuery target dataset id.
   * </pre>
   *
   * <code>string destination_dataset_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for destinationDatasetId.
   */
  public com.google.protobuf.ByteString getDestinationDatasetIdBytes() {
    java.lang.Object ref = "";
    if (destinationCase_ == 2) {
      ref = destination_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (destinationCase_ == 2) {
        destination_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATA_SOURCE_ID_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object dataSourceId_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Data source id.
   * </pre>
   *
   * <code>string data_source_id = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The dataSourceId.
   */
  @java.lang.Override
  public java.lang.String getDataSourceId() {
    java.lang.Object ref = dataSourceId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      dataSourceId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Data source id.
   * </pre>
   *
   * <code>string data_source_id = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for dataSourceId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDataSourceIdBytes() {
    java.lang.Object ref = dataSourceId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      dataSourceId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 8;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Data transfer run state. Ignored for input requests.
   * </pre>
   *
   * <code>.google.cloud.bigquery.datatransfer.v1.TransferState state = 8;</code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Data transfer run state. Ignored for input requests.
   * </pre>
   *
   * <code>.google.cloud.bigquery.datatransfer.v1.TransferState state = 8;</code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.datatransfer.v1.TransferState getState() {
    com.google.cloud.bigquery.datatransfer.v1.TransferState result =
        com.google.cloud.bigquery.datatransfer.v1.TransferState.forNumber(state_);
    return result == null
        ? com.google.cloud.bigquery.datatransfer.v1.TransferState.UNRECOGNIZED
        : result;
  }

  public static final int USER_ID_FIELD_NUMBER = 11;
  private long userId_ = 0L;
  /**
   *
   *
   * <pre>
   * Deprecated. Unique ID of the user on whose behalf transfer is done.
   * </pre>
   *
   * <code>int64 user_id = 11;</code>
   *
   * @return The userId.
   */
  @java.lang.Override
  public long getUserId() {
    return userId_;
  }

  public static final int SCHEDULE_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private volatile java.lang.Object schedule_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Describes the schedule of this transfer run if it was
   * created as part of a regular schedule. For batch transfer runs that are
   * scheduled manually, this is empty.
   * NOTE: the system might choose to delay the schedule depending on the
   * current load, so `schedule_time` doesn't always match this.
   * </pre>
   *
   * <code>string schedule = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The schedule.
   */
  @java.lang.Override
  public java.lang.String getSchedule() {
    java.lang.Object ref = schedule_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      schedule_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Describes the schedule of this transfer run if it was
   * created as part of a regular schedule. For batch transfer runs that are
   * scheduled manually, this is empty.
   * NOTE: the system might choose to delay the schedule depending on the
   * current load, so `schedule_time` doesn't always match this.
   * </pre>
   *
   * <code>string schedule = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for schedule.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getScheduleBytes() {
    java.lang.Object ref = schedule_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      schedule_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NOTIFICATION_PUBSUB_TOPIC_FIELD_NUMBER = 23;

  @SuppressWarnings("serial")
  private volatile java.lang.Object notificationPubsubTopic_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Pub/Sub topic where a notification will be sent after this
   * transfer run finishes.
   *
   * The format for specifying a pubsub topic is:
   * `projects/{project_id}/topics/{topic_id}`
   * </pre>
   *
   * <code>string notification_pubsub_topic = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The notificationPubsubTopic.
   */
  @java.lang.Override
  public java.lang.String getNotificationPubsubTopic() {
    java.lang.Object ref = notificationPubsubTopic_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      notificationPubsubTopic_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Pub/Sub topic where a notification will be sent after this
   * transfer run finishes.
   *
   * The format for specifying a pubsub topic is:
   * `projects/{project_id}/topics/{topic_id}`
   * </pre>
   *
   * <code>string notification_pubsub_topic = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The bytes for notificationPubsubTopic.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNotificationPubsubTopicBytes() {
    java.lang.Object ref = notificationPubsubTopic_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      notificationPubsubTopic_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EMAIL_PREFERENCES_FIELD_NUMBER = 25;
  private com.google.cloud.bigquery.datatransfer.v1.EmailPreferences emailPreferences_;
  /**
   *
   *
   * <pre>
   * Output only. Email notifications will be sent according to these
   * preferences to the email address of the user who owns the transfer config
   * this run was derived from.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.datatransfer.v1.EmailPreferences email_preferences = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the emailPreferences field is set.
   */
  @java.lang.Override
  public boolean hasEmailPreferences() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Email notifications will be sent according to these
   * preferences to the email address of the user who owns the transfer config
   * this run was derived from.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.datatransfer.v1.EmailPreferences email_preferences = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The emailPreferences.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.datatransfer.v1.EmailPreferences getEmailPreferences() {
    return emailPreferences_ == null
        ? com.google.cloud.bigquery.datatransfer.v1.EmailPreferences.getDefaultInstance()
        : emailPreferences_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Email notifications will be sent according to these
   * preferences to the email address of the user who owns the transfer config
   * this run was derived from.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.datatransfer.v1.EmailPreferences email_preferences = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.datatransfer.v1.EmailPreferencesOrBuilder
      getEmailPreferencesOrBuilder() {
    return emailPreferences_ == null
        ? com.google.cloud.bigquery.datatransfer.v1.EmailPreferences.getDefaultInstance()
        : emailPreferences_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (destinationCase_ == 2) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, destination_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getScheduleTime());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(4, getStartTime());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(5, getEndTime());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(6, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataSourceId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, dataSourceId_);
    }
    if (state_
        != com.google.cloud.bigquery.datatransfer.v1.TransferState.TRANSFER_STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(8, state_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeMessage(9, getParams());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(10, getRunTime());
    }
    if (userId_ != 0L) {
      output.writeInt64(11, userId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(schedule_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, schedule_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(21, getErrorStatus());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(notificationPubsubTopic_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 23, notificationPubsubTopic_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeMessage(25, getEmailPreferences());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (destinationCase_ == 2) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, destination_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getScheduleTime());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getStartTime());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getEndTime());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataSourceId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, dataSourceId_);
    }
    if (state_
        != com.google.cloud.bigquery.datatransfer.v1.TransferState.TRANSFER_STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(8, state_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getParams());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getRunTime());
    }
    if (userId_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(11, userId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(schedule_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, schedule_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(21, getErrorStatus());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(notificationPubsubTopic_)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(23, notificationPubsubTopic_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(25, getEmailPreferences());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.bigquery.datatransfer.v1.TransferRun)) {
      return super.equals(obj);
    }
    com.google.cloud.bigquery.datatransfer.v1.TransferRun other =
        (com.google.cloud.bigquery.datatransfer.v1.TransferRun) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasScheduleTime() != other.hasScheduleTime()) return false;
    if (hasScheduleTime()) {
      if (!getScheduleTime().equals(other.getScheduleTime())) return false;
    }
    if (hasRunTime() != other.hasRunTime()) return false;
    if (hasRunTime()) {
      if (!getRunTime().equals(other.getRunTime())) return false;
    }
    if (hasErrorStatus() != other.hasErrorStatus()) return false;
    if (hasErrorStatus()) {
      if (!getErrorStatus().equals(other.getErrorStatus())) return false;
    }
    if (hasStartTime() != other.hasStartTime()) return false;
    if (hasStartTime()) {
      if (!getStartTime().equals(other.getStartTime())) return false;
    }
    if (hasEndTime() != other.hasEndTime()) return false;
    if (hasEndTime()) {
      if (!getEndTime().equals(other.getEndTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (hasParams() != other.hasParams()) return false;
    if (hasParams()) {
      if (!getParams().equals(other.getParams())) return false;
    }
    if (!getDataSourceId().equals(other.getDataSourceId())) return false;
    if (state_ != other.state_) return false;
    if (getUserId() != other.getUserId()) return false;
    if (!getSchedule().equals(other.getSchedule())) return false;
    if (!getNotificationPubsubTopic().equals(other.getNotificationPubsubTopic())) return false;
    if (hasEmailPreferences() != other.hasEmailPreferences()) return false;
    if (hasEmailPreferences()) {
      if (!getEmailPreferences().equals(other.getEmailPreferences())) return false;
    }
    if (!getDestinationCase().equals(other.getDestinationCase())) return false;
    switch (destinationCase_) {
      case 2:
        if (!getDestinationDatasetId().equals(other.getDestinationDatasetId())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasScheduleTime()) {
      hash = (37 * hash) + SCHEDULE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getScheduleTime().hashCode();
    }
    if (hasRunTime()) {
      hash = (37 * hash) + RUN_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getRunTime().hashCode();
    }
    if (hasErrorStatus()) {
      hash = (37 * hash) + ERROR_STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getErrorStatus().hashCode();
    }
    if (hasStartTime()) {
      hash = (37 * hash) + START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getStartTime().hashCode();
    }
    if (hasEndTime()) {
      hash = (37 * hash) + END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEndTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (hasParams()) {
      hash = (37 * hash) + PARAMS_FIELD_NUMBER;
      hash = (53 * hash) + getParams().hashCode();
    }
    hash = (37 * hash) + DATA_SOURCE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getDataSourceId().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + USER_ID_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getUserId());
    hash = (37 * hash) + SCHEDULE_FIELD_NUMBER;
    hash = (53 * hash) + getSchedule().hashCode();
    hash = (37 * hash) + NOTIFICATION_PUBSUB_TOPIC_FIELD_NUMBER;
    hash = (53 * hash) + getNotificationPubsubTopic().hashCode();
    if (hasEmailPreferences()) {
      hash = (37 * hash) + EMAIL_PREFERENCES_FIELD_NUMBER;
      hash = (53 * hash) + getEmailPreferences().hashCode();
    }
    switch (destinationCase_) {
      case 2:
        hash = (37 * hash) + DESTINATION_DATASET_ID_FIELD_NUMBER;
        hash = (53 * hash) + getDestinationDatasetId().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.bigquery.datatransfer.v1.TransferRun parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.TransferRun parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.TransferRun parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.TransferRun parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.TransferRun parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.TransferRun parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.TransferRun parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.TransferRun parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.TransferRun parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.TransferRun parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.TransferRun parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.TransferRun parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.bigquery.datatransfer.v1.TransferRun prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents a data transfer run.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.datatransfer.v1.TransferRun}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.datatransfer.v1.TransferRun)
      com.google.cloud.bigquery.datatransfer.v1.TransferRunOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.datatransfer.v1.TransferProto
          .internal_static_google_cloud_bigquery_datatransfer_v1_TransferRun_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.datatransfer.v1.TransferProto
          .internal_static_google_cloud_bigquery_datatransfer_v1_TransferRun_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.datatransfer.v1.TransferRun.class,
              com.google.cloud.bigquery.datatransfer.v1.TransferRun.Builder.class);
    }

    // Construct using com.google.cloud.bigquery.datatransfer.v1.TransferRun.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getScheduleTimeFieldBuilder();
        getRunTimeFieldBuilder();
        getErrorStatusFieldBuilder();
        getStartTimeFieldBuilder();
        getEndTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
        getParamsFieldBuilder();
        getEmailPreferencesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      scheduleTime_ = null;
      if (scheduleTimeBuilder_ != null) {
        scheduleTimeBuilder_.dispose();
        scheduleTimeBuilder_ = null;
      }
      runTime_ = null;
      if (runTimeBuilder_ != null) {
        runTimeBuilder_.dispose();
        runTimeBuilder_ = null;
      }
      errorStatus_ = null;
      if (errorStatusBuilder_ != null) {
        errorStatusBuilder_.dispose();
        errorStatusBuilder_ = null;
      }
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      params_ = null;
      if (paramsBuilder_ != null) {
        paramsBuilder_.dispose();
        paramsBuilder_ = null;
      }
      dataSourceId_ = "";
      state_ = 0;
      userId_ = 0L;
      schedule_ = "";
      notificationPubsubTopic_ = "";
      emailPreferences_ = null;
      if (emailPreferencesBuilder_ != null) {
        emailPreferencesBuilder_.dispose();
        emailPreferencesBuilder_ = null;
      }
      destinationCase_ = 0;
      destination_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.bigquery.datatransfer.v1.TransferProto
          .internal_static_google_cloud_bigquery_datatransfer_v1_TransferRun_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.datatransfer.v1.TransferRun getDefaultInstanceForType() {
      return com.google.cloud.bigquery.datatransfer.v1.TransferRun.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.bigquery.datatransfer.v1.TransferRun build() {
      com.google.cloud.bigquery.datatransfer.v1.TransferRun result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.datatransfer.v1.TransferRun buildPartial() {
      com.google.cloud.bigquery.datatransfer.v1.TransferRun result =
          new com.google.cloud.bigquery.datatransfer.v1.TransferRun(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.bigquery.datatransfer.v1.TransferRun result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.scheduleTime_ =
            scheduleTimeBuilder_ == null ? scheduleTime_ : scheduleTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.runTime_ = runTimeBuilder_ == null ? runTime_ : runTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.errorStatus_ =
            errorStatusBuilder_ == null ? errorStatus_ : errorStatusBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.startTime_ = startTimeBuilder_ == null ? startTime_ : startTimeBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.endTime_ = endTimeBuilder_ == null ? endTime_ : endTimeBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.params_ = paramsBuilder_ == null ? params_ : paramsBuilder_.build();
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.dataSourceId_ = dataSourceId_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.userId_ = userId_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.schedule_ = schedule_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.notificationPubsubTopic_ = notificationPubsubTopic_;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.emailPreferences_ =
            emailPreferencesBuilder_ == null ? emailPreferences_ : emailPreferencesBuilder_.build();
        to_bitField0_ |= 0x00000080;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.bigquery.datatransfer.v1.TransferRun result) {
      result.destinationCase_ = destinationCase_;
      result.destination_ = this.destination_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.bigquery.datatransfer.v1.TransferRun) {
        return mergeFrom((com.google.cloud.bigquery.datatransfer.v1.TransferRun) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.bigquery.datatransfer.v1.TransferRun other) {
      if (other == com.google.cloud.bigquery.datatransfer.v1.TransferRun.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasScheduleTime()) {
        mergeScheduleTime(other.getScheduleTime());
      }
      if (other.hasRunTime()) {
        mergeRunTime(other.getRunTime());
      }
      if (other.hasErrorStatus()) {
        mergeErrorStatus(other.getErrorStatus());
      }
      if (other.hasStartTime()) {
        mergeStartTime(other.getStartTime());
      }
      if (other.hasEndTime()) {
        mergeEndTime(other.getEndTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.hasParams()) {
        mergeParams(other.getParams());
      }
      if (!other.getDataSourceId().isEmpty()) {
        dataSourceId_ = other.dataSourceId_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.getUserId() != 0L) {
        setUserId(other.getUserId());
      }
      if (!other.getSchedule().isEmpty()) {
        schedule_ = other.schedule_;
        bitField0_ |= 0x00001000;
        onChanged();
      }
      if (!other.getNotificationPubsubTopic().isEmpty()) {
        notificationPubsubTopic_ = other.notificationPubsubTopic_;
        bitField0_ |= 0x00002000;
        onChanged();
      }
      if (other.hasEmailPreferences()) {
        mergeEmailPreferences(other.getEmailPreferences());
      }
      switch (other.getDestinationCase()) {
        case DESTINATION_DATASET_ID:
          {
            destinationCase_ = 2;
            destination_ = other.destination_;
            onChanged();
            break;
          }
        case DESTINATION_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                destinationCase_ = 2;
                destination_ = s;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getScheduleTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getEndTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 50
            case 58:
              {
                dataSourceId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 58
            case 64:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000400;
                break;
              } // case 64
            case 74:
              {
                input.readMessage(getParamsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(getRunTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 82
            case 88:
              {
                userId_ = input.readInt64();
                bitField0_ |= 0x00000800;
                break;
              } // case 88
            case 98:
              {
                schedule_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00001000;
                break;
              } // case 98
            case 170:
              {
                input.readMessage(getErrorStatusFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 170
            case 186:
              {
                notificationPubsubTopic_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00002000;
                break;
              } // case 186
            case 202:
              {
                input.readMessage(
                    getEmailPreferencesFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00004000;
                break;
              } // case 202
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int destinationCase_ = 0;
    private java.lang.Object destination_;

    public DestinationCase getDestinationCase() {
      return DestinationCase.forNumber(destinationCase_);
    }

    public Builder clearDestination() {
      destinationCase_ = 0;
      destination_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The resource name of the transfer run.
     * Transfer run names have the form
     * `projects/{project_id}/locations/{location}/transferConfigs/{config_id}/runs/{run_id}`.
     * The name is ignored when creating a transfer run.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the transfer run.
     * Transfer run names have the form
     * `projects/{project_id}/locations/{location}/transferConfigs/{config_id}/runs/{run_id}`.
     * The name is ignored when creating a transfer run.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the transfer run.
     * Transfer run names have the form
     * `projects/{project_id}/locations/{location}/transferConfigs/{config_id}/runs/{run_id}`.
     * The name is ignored when creating a transfer run.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the transfer run.
     * Transfer run names have the form
     * `projects/{project_id}/locations/{location}/transferConfigs/{config_id}/runs/{run_id}`.
     * The name is ignored when creating a transfer run.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the transfer run.
     * Transfer run names have the form
     * `projects/{project_id}/locations/{location}/transferConfigs/{config_id}/runs/{run_id}`.
     * The name is ignored when creating a transfer run.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp scheduleTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        scheduleTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Minimum time after which a transfer run can be started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp schedule_time = 3;</code>
     *
     * @return Whether the scheduleTime field is set.
     */
    public boolean hasScheduleTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Minimum time after which a transfer run can be started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp schedule_time = 3;</code>
     *
     * @return The scheduleTime.
     */
    public com.google.protobuf.Timestamp getScheduleTime() {
      if (scheduleTimeBuilder_ == null) {
        return scheduleTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : scheduleTime_;
      } else {
        return scheduleTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Minimum time after which a transfer run can be started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp schedule_time = 3;</code>
     */
    public Builder setScheduleTime(com.google.protobuf.Timestamp value) {
      if (scheduleTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        scheduleTime_ = value;
      } else {
        scheduleTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Minimum time after which a transfer run can be started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp schedule_time = 3;</code>
     */
    public Builder setScheduleTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (scheduleTimeBuilder_ == null) {
        scheduleTime_ = builderForValue.build();
      } else {
        scheduleTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Minimum time after which a transfer run can be started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp schedule_time = 3;</code>
     */
    public Builder mergeScheduleTime(com.google.protobuf.Timestamp value) {
      if (scheduleTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && scheduleTime_ != null
            && scheduleTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getScheduleTimeBuilder().mergeFrom(value);
        } else {
          scheduleTime_ = value;
        }
      } else {
        scheduleTimeBuilder_.mergeFrom(value);
      }
      if (scheduleTime_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Minimum time after which a transfer run can be started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp schedule_time = 3;</code>
     */
    public Builder clearScheduleTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      scheduleTime_ = null;
      if (scheduleTimeBuilder_ != null) {
        scheduleTimeBuilder_.dispose();
        scheduleTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Minimum time after which a transfer run can be started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp schedule_time = 3;</code>
     */
    public com.google.protobuf.Timestamp.Builder getScheduleTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getScheduleTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Minimum time after which a transfer run can be started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp schedule_time = 3;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getScheduleTimeOrBuilder() {
      if (scheduleTimeBuilder_ != null) {
        return scheduleTimeBuilder_.getMessageOrBuilder();
      } else {
        return scheduleTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : scheduleTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Minimum time after which a transfer run can be started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp schedule_time = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getScheduleTimeFieldBuilder() {
      if (scheduleTimeBuilder_ == null) {
        scheduleTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getScheduleTime(), getParentForChildren(), isClean());
        scheduleTime_ = null;
      }
      return scheduleTimeBuilder_;
    }

    private com.google.protobuf.Timestamp runTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        runTimeBuilder_;
    /**
     *
     *
     * <pre>
     * For batch transfer runs, specifies the date and time of the data should be
     * ingested.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp run_time = 10;</code>
     *
     * @return Whether the runTime field is set.
     */
    public boolean hasRunTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * For batch transfer runs, specifies the date and time of the data should be
     * ingested.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp run_time = 10;</code>
     *
     * @return The runTime.
     */
    public com.google.protobuf.Timestamp getRunTime() {
      if (runTimeBuilder_ == null) {
        return runTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : runTime_;
      } else {
        return runTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * For batch transfer runs, specifies the date and time of the data should be
     * ingested.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp run_time = 10;</code>
     */
    public Builder setRunTime(com.google.protobuf.Timestamp value) {
      if (runTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        runTime_ = value;
      } else {
        runTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * For batch transfer runs, specifies the date and time of the data should be
     * ingested.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp run_time = 10;</code>
     */
    public Builder setRunTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (runTimeBuilder_ == null) {
        runTime_ = builderForValue.build();
      } else {
        runTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * For batch transfer runs, specifies the date and time of the data should be
     * ingested.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp run_time = 10;</code>
     */
    public Builder mergeRunTime(com.google.protobuf.Timestamp value) {
      if (runTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && runTime_ != null
            && runTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getRunTimeBuilder().mergeFrom(value);
        } else {
          runTime_ = value;
        }
      } else {
        runTimeBuilder_.mergeFrom(value);
      }
      if (runTime_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * For batch transfer runs, specifies the date and time of the data should be
     * ingested.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp run_time = 10;</code>
     */
    public Builder clearRunTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      runTime_ = null;
      if (runTimeBuilder_ != null) {
        runTimeBuilder_.dispose();
        runTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * For batch transfer runs, specifies the date and time of the data should be
     * ingested.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp run_time = 10;</code>
     */
    public com.google.protobuf.Timestamp.Builder getRunTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getRunTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * For batch transfer runs, specifies the date and time of the data should be
     * ingested.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp run_time = 10;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getRunTimeOrBuilder() {
      if (runTimeBuilder_ != null) {
        return runTimeBuilder_.getMessageOrBuilder();
      } else {
        return runTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : runTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * For batch transfer runs, specifies the date and time of the data should be
     * ingested.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp run_time = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getRunTimeFieldBuilder() {
      if (runTimeBuilder_ == null) {
        runTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getRunTime(), getParentForChildren(), isClean());
        runTime_ = null;
      }
      return runTimeBuilder_;
    }

    private com.google.rpc.Status errorStatus_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        errorStatusBuilder_;
    /**
     *
     *
     * <pre>
     * Status of the transfer run.
     * </pre>
     *
     * <code>.google.rpc.Status error_status = 21;</code>
     *
     * @return Whether the errorStatus field is set.
     */
    public boolean hasErrorStatus() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Status of the transfer run.
     * </pre>
     *
     * <code>.google.rpc.Status error_status = 21;</code>
     *
     * @return The errorStatus.
     */
    public com.google.rpc.Status getErrorStatus() {
      if (errorStatusBuilder_ == null) {
        return errorStatus_ == null ? com.google.rpc.Status.getDefaultInstance() : errorStatus_;
      } else {
        return errorStatusBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Status of the transfer run.
     * </pre>
     *
     * <code>.google.rpc.Status error_status = 21;</code>
     */
    public Builder setErrorStatus(com.google.rpc.Status value) {
      if (errorStatusBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        errorStatus_ = value;
      } else {
        errorStatusBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Status of the transfer run.
     * </pre>
     *
     * <code>.google.rpc.Status error_status = 21;</code>
     */
    public Builder setErrorStatus(com.google.rpc.Status.Builder builderForValue) {
      if (errorStatusBuilder_ == null) {
        errorStatus_ = builderForValue.build();
      } else {
        errorStatusBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Status of the transfer run.
     * </pre>
     *
     * <code>.google.rpc.Status error_status = 21;</code>
     */
    public Builder mergeErrorStatus(com.google.rpc.Status value) {
      if (errorStatusBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && errorStatus_ != null
            && errorStatus_ != com.google.rpc.Status.getDefaultInstance()) {
          getErrorStatusBuilder().mergeFrom(value);
        } else {
          errorStatus_ = value;
        }
      } else {
        errorStatusBuilder_.mergeFrom(value);
      }
      if (errorStatus_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Status of the transfer run.
     * </pre>
     *
     * <code>.google.rpc.Status error_status = 21;</code>
     */
    public Builder clearErrorStatus() {
      bitField0_ = (bitField0_ & ~0x00000008);
      errorStatus_ = null;
      if (errorStatusBuilder_ != null) {
        errorStatusBuilder_.dispose();
        errorStatusBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Status of the transfer run.
     * </pre>
     *
     * <code>.google.rpc.Status error_status = 21;</code>
     */
    public com.google.rpc.Status.Builder getErrorStatusBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getErrorStatusFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Status of the transfer run.
     * </pre>
     *
     * <code>.google.rpc.Status error_status = 21;</code>
     */
    public com.google.rpc.StatusOrBuilder getErrorStatusOrBuilder() {
      if (errorStatusBuilder_ != null) {
        return errorStatusBuilder_.getMessageOrBuilder();
      } else {
        return errorStatus_ == null ? com.google.rpc.Status.getDefaultInstance() : errorStatus_;
      }
    }
    /**
     *
     *
     * <pre>
     * Status of the transfer run.
     * </pre>
     *
     * <code>.google.rpc.Status error_status = 21;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getErrorStatusFieldBuilder() {
      if (errorStatusBuilder_ == null) {
        errorStatusBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(
                getErrorStatus(), getParentForChildren(), isClean());
        errorStatus_ = null;
      }
      return errorStatusBuilder_;
    }

    private com.google.protobuf.Timestamp startTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        startTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time when transfer run was started.
     * Parameter ignored by server for input requests.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the startTime field is set.
     */
    public boolean hasStartTime() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when transfer run was started.
     * Parameter ignored by server for input requests.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The startTime.
     */
    public com.google.protobuf.Timestamp getStartTime() {
      if (startTimeBuilder_ == null) {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      } else {
        return startTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when transfer run was started.
     * Parameter ignored by server for input requests.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startTime_ = value;
      } else {
        startTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when transfer run was started.
     * Parameter ignored by server for input requests.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (startTimeBuilder_ == null) {
        startTime_ = builderForValue.build();
      } else {
        startTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when transfer run was started.
     * Parameter ignored by server for input requests.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && startTime_ != null
            && startTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getStartTimeBuilder().mergeFrom(value);
        } else {
          startTime_ = value;
        }
      } else {
        startTimeBuilder_.mergeFrom(value);
      }
      if (startTime_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when transfer run was started.
     * Parameter ignored by server for input requests.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearStartTime() {
      bitField0_ = (bitField0_ & ~0x00000010);
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when transfer run was started.
     * Parameter ignored by server for input requests.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getStartTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when transfer run was started.
     * Parameter ignored by server for input requests.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      if (startTimeBuilder_ != null) {
        return startTimeBuilder_.getMessageOrBuilder();
      } else {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when transfer run was started.
     * Parameter ignored by server for input requests.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getStartTimeFieldBuilder() {
      if (startTimeBuilder_ == null) {
        startTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getStartTime(), getParentForChildren(), isClean());
        startTime_ = null;
      }
      return startTimeBuilder_;
    }

    private com.google.protobuf.Timestamp endTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        endTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time when transfer run ended.
     * Parameter ignored by server for input requests.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the endTime field is set.
     */
    public boolean hasEndTime() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when transfer run ended.
     * Parameter ignored by server for input requests.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The endTime.
     */
    public com.google.protobuf.Timestamp getEndTime() {
      if (endTimeBuilder_ == null) {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      } else {
        return endTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when transfer run ended.
     * Parameter ignored by server for input requests.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endTime_ = value;
      } else {
        endTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when transfer run ended.
     * Parameter ignored by server for input requests.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (endTimeBuilder_ == null) {
        endTime_ = builderForValue.build();
      } else {
        endTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when transfer run ended.
     * Parameter ignored by server for input requests.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && endTime_ != null
            && endTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getEndTimeBuilder().mergeFrom(value);
        } else {
          endTime_ = value;
        }
      } else {
        endTimeBuilder_.mergeFrom(value);
      }
      if (endTime_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when transfer run ended.
     * Parameter ignored by server for input requests.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearEndTime() {
      bitField0_ = (bitField0_ & ~0x00000020);
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when transfer run ended.
     * Parameter ignored by server for input requests.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getEndTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when transfer run ended.
     * Parameter ignored by server for input requests.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      if (endTimeBuilder_ != null) {
        return endTimeBuilder_.getMessageOrBuilder();
      } else {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when transfer run ended.
     * Parameter ignored by server for input requests.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEndTimeFieldBuilder() {
      if (endTimeBuilder_ == null) {
        endTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEndTime(), getParentForChildren(), isClean());
        endTime_ = null;
      }
      return endTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Last time the data transfer run state was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Last time the data transfer run state was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Last time the data transfer run state was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Last time the data transfer run state was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Last time the data transfer run state was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Last time the data transfer run state was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000040);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Last time the data transfer run state was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Last time the data transfer run state was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Last time the data transfer run state was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.Struct params_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        paramsBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Parameters specific to each data source. For more information
     * see the bq tab in the 'Setting up a data transfer' section for each data
     * source. For example the parameters for Cloud Storage transfers are listed
     * here:
     * https://cloud.google.com/bigquery-transfer/docs/cloud-storage-transfer#bq
     * </pre>
     *
     * <code>.google.protobuf.Struct params = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the params field is set.
     */
    public boolean hasParams() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Parameters specific to each data source. For more information
     * see the bq tab in the 'Setting up a data transfer' section for each data
     * source. For example the parameters for Cloud Storage transfers are listed
     * here:
     * https://cloud.google.com/bigquery-transfer/docs/cloud-storage-transfer#bq
     * </pre>
     *
     * <code>.google.protobuf.Struct params = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The params.
     */
    public com.google.protobuf.Struct getParams() {
      if (paramsBuilder_ == null) {
        return params_ == null ? com.google.protobuf.Struct.getDefaultInstance() : params_;
      } else {
        return paramsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Parameters specific to each data source. For more information
     * see the bq tab in the 'Setting up a data transfer' section for each data
     * source. For example the parameters for Cloud Storage transfers are listed
     * here:
     * https://cloud.google.com/bigquery-transfer/docs/cloud-storage-transfer#bq
     * </pre>
     *
     * <code>.google.protobuf.Struct params = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setParams(com.google.protobuf.Struct value) {
      if (paramsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        params_ = value;
      } else {
        paramsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Parameters specific to each data source. For more information
     * see the bq tab in the 'Setting up a data transfer' section for each data
     * source. For example the parameters for Cloud Storage transfers are listed
     * here:
     * https://cloud.google.com/bigquery-transfer/docs/cloud-storage-transfer#bq
     * </pre>
     *
     * <code>.google.protobuf.Struct params = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setParams(com.google.protobuf.Struct.Builder builderForValue) {
      if (paramsBuilder_ == null) {
        params_ = builderForValue.build();
      } else {
        paramsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Parameters specific to each data source. For more information
     * see the bq tab in the 'Setting up a data transfer' section for each data
     * source. For example the parameters for Cloud Storage transfers are listed
     * here:
     * https://cloud.google.com/bigquery-transfer/docs/cloud-storage-transfer#bq
     * </pre>
     *
     * <code>.google.protobuf.Struct params = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergeParams(com.google.protobuf.Struct value) {
      if (paramsBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && params_ != null
            && params_ != com.google.protobuf.Struct.getDefaultInstance()) {
          getParamsBuilder().mergeFrom(value);
        } else {
          params_ = value;
        }
      } else {
        paramsBuilder_.mergeFrom(value);
      }
      if (params_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Parameters specific to each data source. For more information
     * see the bq tab in the 'Setting up a data transfer' section for each data
     * source. For example the parameters for Cloud Storage transfers are listed
     * here:
     * https://cloud.google.com/bigquery-transfer/docs/cloud-storage-transfer#bq
     * </pre>
     *
     * <code>.google.protobuf.Struct params = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearParams() {
      bitField0_ = (bitField0_ & ~0x00000080);
      params_ = null;
      if (paramsBuilder_ != null) {
        paramsBuilder_.dispose();
        paramsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Parameters specific to each data source. For more information
     * see the bq tab in the 'Setting up a data transfer' section for each data
     * source. For example the parameters for Cloud Storage transfers are listed
     * here:
     * https://cloud.google.com/bigquery-transfer/docs/cloud-storage-transfer#bq
     * </pre>
     *
     * <code>.google.protobuf.Struct params = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.protobuf.Struct.Builder getParamsBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getParamsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Parameters specific to each data source. For more information
     * see the bq tab in the 'Setting up a data transfer' section for each data
     * source. For example the parameters for Cloud Storage transfers are listed
     * here:
     * https://cloud.google.com/bigquery-transfer/docs/cloud-storage-transfer#bq
     * </pre>
     *
     * <code>.google.protobuf.Struct params = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.protobuf.StructOrBuilder getParamsOrBuilder() {
      if (paramsBuilder_ != null) {
        return paramsBuilder_.getMessageOrBuilder();
      } else {
        return params_ == null ? com.google.protobuf.Struct.getDefaultInstance() : params_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Parameters specific to each data source. For more information
     * see the bq tab in the 'Setting up a data transfer' section for each data
     * source. For example the parameters for Cloud Storage transfers are listed
     * here:
     * https://cloud.google.com/bigquery-transfer/docs/cloud-storage-transfer#bq
     * </pre>
     *
     * <code>.google.protobuf.Struct params = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        getParamsFieldBuilder() {
      if (paramsBuilder_ == null) {
        paramsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>(
                getParams(), getParentForChildren(), isClean());
        params_ = null;
      }
      return paramsBuilder_;
    }

    /**
     *
     *
     * <pre>
     * Output only. The BigQuery target dataset id.
     * </pre>
     *
     * <code>string destination_dataset_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the destinationDatasetId field is set.
     */
    @java.lang.Override
    public boolean hasDestinationDatasetId() {
      return destinationCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Output only. The BigQuery target dataset id.
     * </pre>
     *
     * <code>string destination_dataset_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The destinationDatasetId.
     */
    @java.lang.Override
    public java.lang.String getDestinationDatasetId() {
      java.lang.Object ref = "";
      if (destinationCase_ == 2) {
        ref = destination_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (destinationCase_ == 2) {
          destination_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The BigQuery target dataset id.
     * </pre>
     *
     * <code>string destination_dataset_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for destinationDatasetId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDestinationDatasetIdBytes() {
      java.lang.Object ref = "";
      if (destinationCase_ == 2) {
        ref = destination_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (destinationCase_ == 2) {
          destination_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The BigQuery target dataset id.
     * </pre>
     *
     * <code>string destination_dataset_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The destinationDatasetId to set.
     * @return This builder for chaining.
     */
    public Builder setDestinationDatasetId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      destinationCase_ = 2;
      destination_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The BigQuery target dataset id.
     * </pre>
     *
     * <code>string destination_dataset_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDestinationDatasetId() {
      if (destinationCase_ == 2) {
        destinationCase_ = 0;
        destination_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The BigQuery target dataset id.
     * </pre>
     *
     * <code>string destination_dataset_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for destinationDatasetId to set.
     * @return This builder for chaining.
     */
    public Builder setDestinationDatasetIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      destinationCase_ = 2;
      destination_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object dataSourceId_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Data source id.
     * </pre>
     *
     * <code>string data_source_id = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The dataSourceId.
     */
    public java.lang.String getDataSourceId() {
      java.lang.Object ref = dataSourceId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dataSourceId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Data source id.
     * </pre>
     *
     * <code>string data_source_id = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for dataSourceId.
     */
    public com.google.protobuf.ByteString getDataSourceIdBytes() {
      java.lang.Object ref = dataSourceId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dataSourceId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Data source id.
     * </pre>
     *
     * <code>string data_source_id = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The dataSourceId to set.
     * @return This builder for chaining.
     */
    public Builder setDataSourceId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      dataSourceId_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Data source id.
     * </pre>
     *
     * <code>string data_source_id = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDataSourceId() {
      dataSourceId_ = getDefaultInstance().getDataSourceId();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Data source id.
     * </pre>
     *
     * <code>string data_source_id = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for dataSourceId to set.
     * @return This builder for chaining.
     */
    public Builder setDataSourceIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      dataSourceId_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Data transfer run state. Ignored for input requests.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.TransferState state = 8;</code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Data transfer run state. Ignored for input requests.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.TransferState state = 8;</code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data transfer run state. Ignored for input requests.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.TransferState state = 8;</code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.datatransfer.v1.TransferState getState() {
      com.google.cloud.bigquery.datatransfer.v1.TransferState result =
          com.google.cloud.bigquery.datatransfer.v1.TransferState.forNumber(state_);
      return result == null
          ? com.google.cloud.bigquery.datatransfer.v1.TransferState.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Data transfer run state. Ignored for input requests.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.TransferState state = 8;</code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.bigquery.datatransfer.v1.TransferState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000400;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data transfer run state. Ignored for input requests.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.TransferState state = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000400);
      state_ = 0;
      onChanged();
      return this;
    }

    private long userId_;
    /**
     *
     *
     * <pre>
     * Deprecated. Unique ID of the user on whose behalf transfer is done.
     * </pre>
     *
     * <code>int64 user_id = 11;</code>
     *
     * @return The userId.
     */
    @java.lang.Override
    public long getUserId() {
      return userId_;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. Unique ID of the user on whose behalf transfer is done.
     * </pre>
     *
     * <code>int64 user_id = 11;</code>
     *
     * @param value The userId to set.
     * @return This builder for chaining.
     */
    public Builder setUserId(long value) {

      userId_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. Unique ID of the user on whose behalf transfer is done.
     * </pre>
     *
     * <code>int64 user_id = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUserId() {
      bitField0_ = (bitField0_ & ~0x00000800);
      userId_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object schedule_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Describes the schedule of this transfer run if it was
     * created as part of a regular schedule. For batch transfer runs that are
     * scheduled manually, this is empty.
     * NOTE: the system might choose to delay the schedule depending on the
     * current load, so `schedule_time` doesn't always match this.
     * </pre>
     *
     * <code>string schedule = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The schedule.
     */
    public java.lang.String getSchedule() {
      java.lang.Object ref = schedule_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        schedule_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Describes the schedule of this transfer run if it was
     * created as part of a regular schedule. For batch transfer runs that are
     * scheduled manually, this is empty.
     * NOTE: the system might choose to delay the schedule depending on the
     * current load, so `schedule_time` doesn't always match this.
     * </pre>
     *
     * <code>string schedule = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for schedule.
     */
    public com.google.protobuf.ByteString getScheduleBytes() {
      java.lang.Object ref = schedule_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        schedule_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Describes the schedule of this transfer run if it was
     * created as part of a regular schedule. For batch transfer runs that are
     * scheduled manually, this is empty.
     * NOTE: the system might choose to delay the schedule depending on the
     * current load, so `schedule_time` doesn't always match this.
     * </pre>
     *
     * <code>string schedule = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The schedule to set.
     * @return This builder for chaining.
     */
    public Builder setSchedule(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      schedule_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Describes the schedule of this transfer run if it was
     * created as part of a regular schedule. For batch transfer runs that are
     * scheduled manually, this is empty.
     * NOTE: the system might choose to delay the schedule depending on the
     * current load, so `schedule_time` doesn't always match this.
     * </pre>
     *
     * <code>string schedule = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSchedule() {
      schedule_ = getDefaultInstance().getSchedule();
      bitField0_ = (bitField0_ & ~0x00001000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Describes the schedule of this transfer run if it was
     * created as part of a regular schedule. For batch transfer runs that are
     * scheduled manually, this is empty.
     * NOTE: the system might choose to delay the schedule depending on the
     * current load, so `schedule_time` doesn't always match this.
     * </pre>
     *
     * <code>string schedule = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for schedule to set.
     * @return This builder for chaining.
     */
    public Builder setScheduleBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      schedule_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    private java.lang.Object notificationPubsubTopic_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Pub/Sub topic where a notification will be sent after this
     * transfer run finishes.
     *
     * The format for specifying a pubsub topic is:
     * `projects/{project_id}/topics/{topic_id}`
     * </pre>
     *
     * <code>string notification_pubsub_topic = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The notificationPubsubTopic.
     */
    public java.lang.String getNotificationPubsubTopic() {
      java.lang.Object ref = notificationPubsubTopic_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        notificationPubsubTopic_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Pub/Sub topic where a notification will be sent after this
     * transfer run finishes.
     *
     * The format for specifying a pubsub topic is:
     * `projects/{project_id}/topics/{topic_id}`
     * </pre>
     *
     * <code>string notification_pubsub_topic = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The bytes for notificationPubsubTopic.
     */
    public com.google.protobuf.ByteString getNotificationPubsubTopicBytes() {
      java.lang.Object ref = notificationPubsubTopic_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        notificationPubsubTopic_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Pub/Sub topic where a notification will be sent after this
     * transfer run finishes.
     *
     * The format for specifying a pubsub topic is:
     * `projects/{project_id}/topics/{topic_id}`
     * </pre>
     *
     * <code>string notification_pubsub_topic = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The notificationPubsubTopic to set.
     * @return This builder for chaining.
     */
    public Builder setNotificationPubsubTopic(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      notificationPubsubTopic_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Pub/Sub topic where a notification will be sent after this
     * transfer run finishes.
     *
     * The format for specifying a pubsub topic is:
     * `projects/{project_id}/topics/{topic_id}`
     * </pre>
     *
     * <code>string notification_pubsub_topic = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNotificationPubsubTopic() {
      notificationPubsubTopic_ = getDefaultInstance().getNotificationPubsubTopic();
      bitField0_ = (bitField0_ & ~0x00002000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Pub/Sub topic where a notification will be sent after this
     * transfer run finishes.
     *
     * The format for specifying a pubsub topic is:
     * `projects/{project_id}/topics/{topic_id}`
     * </pre>
     *
     * <code>string notification_pubsub_topic = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes for notificationPubsubTopic to set.
     * @return This builder for chaining.
     */
    public Builder setNotificationPubsubTopicBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      notificationPubsubTopic_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    private com.google.cloud.bigquery.datatransfer.v1.EmailPreferences emailPreferences_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.datatransfer.v1.EmailPreferences,
            com.google.cloud.bigquery.datatransfer.v1.EmailPreferences.Builder,
            com.google.cloud.bigquery.datatransfer.v1.EmailPreferencesOrBuilder>
        emailPreferencesBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Email notifications will be sent according to these
     * preferences to the email address of the user who owns the transfer config
     * this run was derived from.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.EmailPreferences email_preferences = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the emailPreferences field is set.
     */
    public boolean hasEmailPreferences() {
      return ((bitField0_ & 0x00004000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Email notifications will be sent according to these
     * preferences to the email address of the user who owns the transfer config
     * this run was derived from.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.EmailPreferences email_preferences = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The emailPreferences.
     */
    public com.google.cloud.bigquery.datatransfer.v1.EmailPreferences getEmailPreferences() {
      if (emailPreferencesBuilder_ == null) {
        return emailPreferences_ == null
            ? com.google.cloud.bigquery.datatransfer.v1.EmailPreferences.getDefaultInstance()
            : emailPreferences_;
      } else {
        return emailPreferencesBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Email notifications will be sent according to these
     * preferences to the email address of the user who owns the transfer config
     * this run was derived from.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.EmailPreferences email_preferences = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEmailPreferences(
        com.google.cloud.bigquery.datatransfer.v1.EmailPreferences value) {
      if (emailPreferencesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        emailPreferences_ = value;
      } else {
        emailPreferencesBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Email notifications will be sent according to these
     * preferences to the email address of the user who owns the transfer config
     * this run was derived from.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.EmailPreferences email_preferences = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEmailPreferences(
        com.google.cloud.bigquery.datatransfer.v1.EmailPreferences.Builder builderForValue) {
      if (emailPreferencesBuilder_ == null) {
        emailPreferences_ = builderForValue.build();
      } else {
        emailPreferencesBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Email notifications will be sent according to these
     * preferences to the email address of the user who owns the transfer config
     * this run was derived from.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.EmailPreferences email_preferences = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeEmailPreferences(
        com.google.cloud.bigquery.datatransfer.v1.EmailPreferences value) {
      if (emailPreferencesBuilder_ == null) {
        if (((bitField0_ & 0x00004000) != 0)
            && emailPreferences_ != null
            && emailPreferences_
                != com.google.cloud.bigquery.datatransfer.v1.EmailPreferences
                    .getDefaultInstance()) {
          getEmailPreferencesBuilder().mergeFrom(value);
        } else {
          emailPreferences_ = value;
        }
      } else {
        emailPreferencesBuilder_.mergeFrom(value);
      }
      if (emailPreferences_ != null) {
        bitField0_ |= 0x00004000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Email notifications will be sent according to these
     * preferences to the email address of the user who owns the transfer config
     * this run was derived from.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.EmailPreferences email_preferences = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearEmailPreferences() {
      bitField0_ = (bitField0_ & ~0x00004000);
      emailPreferences_ = null;
      if (emailPreferencesBuilder_ != null) {
        emailPreferencesBuilder_.dispose();
        emailPreferencesBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Email notifications will be sent according to these
     * preferences to the email address of the user who owns the transfer config
     * this run was derived from.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.EmailPreferences email_preferences = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.bigquery.datatransfer.v1.EmailPreferences.Builder
        getEmailPreferencesBuilder() {
      bitField0_ |= 0x00004000;
      onChanged();
      return getEmailPreferencesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Email notifications will be sent according to these
     * preferences to the email address of the user who owns the transfer config
     * this run was derived from.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.EmailPreferences email_preferences = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.bigquery.datatransfer.v1.EmailPreferencesOrBuilder
        getEmailPreferencesOrBuilder() {
      if (emailPreferencesBuilder_ != null) {
        return emailPreferencesBuilder_.getMessageOrBuilder();
      } else {
        return emailPreferences_ == null
            ? com.google.cloud.bigquery.datatransfer.v1.EmailPreferences.getDefaultInstance()
            : emailPreferences_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Email notifications will be sent according to these
     * preferences to the email address of the user who owns the transfer config
     * this run was derived from.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.EmailPreferences email_preferences = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.datatransfer.v1.EmailPreferences,
            com.google.cloud.bigquery.datatransfer.v1.EmailPreferences.Builder,
            com.google.cloud.bigquery.datatransfer.v1.EmailPreferencesOrBuilder>
        getEmailPreferencesFieldBuilder() {
      if (emailPreferencesBuilder_ == null) {
        emailPreferencesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.datatransfer.v1.EmailPreferences,
                com.google.cloud.bigquery.datatransfer.v1.EmailPreferences.Builder,
                com.google.cloud.bigquery.datatransfer.v1.EmailPreferencesOrBuilder>(
                getEmailPreferences(), getParentForChildren(), isClean());
        emailPreferences_ = null;
      }
      return emailPreferencesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.datatransfer.v1.TransferRun)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.bigquery.datatransfer.v1.TransferRun)
  private static final com.google.cloud.bigquery.datatransfer.v1.TransferRun DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.bigquery.datatransfer.v1.TransferRun();
  }

  public static com.google.cloud.bigquery.datatransfer.v1.TransferRun getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TransferRun> PARSER =
      new com.google.protobuf.AbstractParser<TransferRun>() {
        @java.lang.Override
        public TransferRun parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TransferRun> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TransferRun> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.bigquery.datatransfer.v1.TransferRun getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
