/*
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/datatransfer/v1/datasource.proto

package com.google.cloud.bigquery.datatransfer.v1;

/**
 *
 *
 * <pre>
 * Describes data which should be imported.
 * </pre>
 *
 * Protobuf type {@code google.cloud.bigquery.datatransfer.v1.ImportedDataInfo}
 */
public final class ImportedDataInfo extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.bigquery.datatransfer.v1.ImportedDataInfo)
    ImportedDataInfoOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ImportedDataInfo.newBuilder() to construct.
  private ImportedDataInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ImportedDataInfo() {
    sql_ = "";
    destinationTableId_ = "";
    destinationTableDescription_ = "";
    tableDefs_ = java.util.Collections.emptyList();
    userDefinedFunctions_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    writeDisposition_ = 0;
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private ImportedDataInfo(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              sql_ = s;
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();

              destinationTableId_ = s;
              break;
            }
          case 26:
            {
              if (!((mutable_bitField0_ & 0x00000008) != 0)) {
                tableDefs_ =
                    new java.util.ArrayList<
                        com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo
                            .TableDefinition>();
                mutable_bitField0_ |= 0x00000008;
              }
              tableDefs_.add(
                  input.readMessage(
                      com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition
                          .parser(),
                      extensionRegistry));
              break;
            }
          case 34:
            {
              java.lang.String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000010) != 0)) {
                userDefinedFunctions_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000010;
              }
              userDefinedFunctions_.add(s);
              break;
            }
          case 48:
            {
              int rawValue = input.readEnum();

              writeDisposition_ = rawValue;
              break;
            }
          case 82:
            {
              java.lang.String s = input.readStringRequireUtf8();

              destinationTableDescription_ = s;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000008) != 0)) {
        tableDefs_ = java.util.Collections.unmodifiableList(tableDefs_);
      }
      if (((mutable_bitField0_ & 0x00000010) != 0)) {
        userDefinedFunctions_ = userDefinedFunctions_.getUnmodifiableView();
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.bigquery.datatransfer.v1.DataSourceProto
        .internal_static_google_cloud_bigquery_datatransfer_v1_ImportedDataInfo_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.bigquery.datatransfer.v1.DataSourceProto
        .internal_static_google_cloud_bigquery_datatransfer_v1_ImportedDataInfo_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.class,
            com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Data format.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.Format}
   */
  public enum Format implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified format. In this case, we have to infer the format from the
     * data source.
     * </pre>
     *
     * <code>FORMAT_UNSPECIFIED = 0;</code>
     */
    FORMAT_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * CSV format.
     * </pre>
     *
     * <code>CSV = 1;</code>
     */
    CSV(1),
    /**
     *
     *
     * <pre>
     * Newline-delimited JSON.
     * </pre>
     *
     * <code>JSON = 2;</code>
     */
    JSON(2),
    /**
     *
     *
     * <pre>
     * Avro format. See http://avro.apache.org .
     * </pre>
     *
     * <code>AVRO = 3;</code>
     */
    AVRO(3),
    /**
     *
     *
     * <pre>
     * RecordIO.
     * </pre>
     *
     * <code>RECORDIO = 4;</code>
     */
    RECORDIO(4),
    /**
     *
     *
     * <pre>
     * ColumnIO.
     * </pre>
     *
     * <code>COLUMNIO = 5;</code>
     */
    COLUMNIO(5),
    /**
     *
     *
     * <pre>
     * Capacitor.
     * </pre>
     *
     * <code>CAPACITOR = 6;</code>
     */
    CAPACITOR(6),
    /**
     *
     *
     * <pre>
     * Parquet format. See https://parquet.apache.org .
     * </pre>
     *
     * <code>PARQUET = 7;</code>
     */
    PARQUET(7),
    /**
     *
     *
     * <pre>
     * ORC format. See https://orc.apache.org .
     * </pre>
     *
     * <code>ORC = 8;</code>
     */
    ORC(8),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified format. In this case, we have to infer the format from the
     * data source.
     * </pre>
     *
     * <code>FORMAT_UNSPECIFIED = 0;</code>
     */
    public static final int FORMAT_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * CSV format.
     * </pre>
     *
     * <code>CSV = 1;</code>
     */
    public static final int CSV_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Newline-delimited JSON.
     * </pre>
     *
     * <code>JSON = 2;</code>
     */
    public static final int JSON_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Avro format. See http://avro.apache.org .
     * </pre>
     *
     * <code>AVRO = 3;</code>
     */
    public static final int AVRO_VALUE = 3;
    /**
     *
     *
     * <pre>
     * RecordIO.
     * </pre>
     *
     * <code>RECORDIO = 4;</code>
     */
    public static final int RECORDIO_VALUE = 4;
    /**
     *
     *
     * <pre>
     * ColumnIO.
     * </pre>
     *
     * <code>COLUMNIO = 5;</code>
     */
    public static final int COLUMNIO_VALUE = 5;
    /**
     *
     *
     * <pre>
     * Capacitor.
     * </pre>
     *
     * <code>CAPACITOR = 6;</code>
     */
    public static final int CAPACITOR_VALUE = 6;
    /**
     *
     *
     * <pre>
     * Parquet format. See https://parquet.apache.org .
     * </pre>
     *
     * <code>PARQUET = 7;</code>
     */
    public static final int PARQUET_VALUE = 7;
    /**
     *
     *
     * <pre>
     * ORC format. See https://orc.apache.org .
     * </pre>
     *
     * <code>ORC = 8;</code>
     */
    public static final int ORC_VALUE = 8;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /** @deprecated Use {@link #forNumber(int)} instead. */
    @java.lang.Deprecated
    public static Format valueOf(int value) {
      return forNumber(value);
    }

    public static Format forNumber(int value) {
      switch (value) {
        case 0:
          return FORMAT_UNSPECIFIED;
        case 1:
          return CSV;
        case 2:
          return JSON;
        case 3:
          return AVRO;
        case 4:
          return RECORDIO;
        case 5:
          return COLUMNIO;
        case 6:
          return CAPACITOR;
        case 7:
          return PARQUET;
        case 8:
          return ORC;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Format> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Format> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Format>() {
          public Format findValueByNumber(int number) {
            return Format.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final Format[] VALUES = values();

    public static Format valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Format(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.Format)
  }

  /**
   *
   *
   * <pre>
   * Encoding of input data in CSV/JSON format.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.Encoding}
   */
  public enum Encoding implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default encoding (UTF8).
     * </pre>
     *
     * <code>ENCODING_UNSPECIFIED = 0;</code>
     */
    ENCODING_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * ISO_8859_1 encoding.
     * </pre>
     *
     * <code>ISO_8859_1 = 1;</code>
     */
    ISO_8859_1(1),
    /**
     *
     *
     * <pre>
     * UTF8 encoding.
     * </pre>
     *
     * <code>UTF8 = 2;</code>
     */
    UTF8(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default encoding (UTF8).
     * </pre>
     *
     * <code>ENCODING_UNSPECIFIED = 0;</code>
     */
    public static final int ENCODING_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * ISO_8859_1 encoding.
     * </pre>
     *
     * <code>ISO_8859_1 = 1;</code>
     */
    public static final int ISO_8859_1_VALUE = 1;
    /**
     *
     *
     * <pre>
     * UTF8 encoding.
     * </pre>
     *
     * <code>UTF8 = 2;</code>
     */
    public static final int UTF8_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /** @deprecated Use {@link #forNumber(int)} instead. */
    @java.lang.Deprecated
    public static Encoding valueOf(int value) {
      return forNumber(value);
    }

    public static Encoding forNumber(int value) {
      switch (value) {
        case 0:
          return ENCODING_UNSPECIFIED;
        case 1:
          return ISO_8859_1;
        case 2:
          return UTF8;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Encoding> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Encoding> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Encoding>() {
          public Encoding findValueByNumber(int number) {
            return Encoding.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.getDescriptor()
          .getEnumTypes()
          .get(1);
    }

    private static final Encoding[] VALUES = values();

    public static Encoding valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Encoding(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.Encoding)
  }

  public interface FieldSchemaOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Field name. Matches: [A-Za-z_][A-Za-z_0-9]{0,127}
     * </pre>
     *
     * <code>string field_name = 1;</code>
     */
    java.lang.String getFieldName();
    /**
     *
     *
     * <pre>
     * Field name. Matches: [A-Za-z_][A-Za-z_0-9]{0,127}
     * </pre>
     *
     * <code>string field_name = 1;</code>
     */
    com.google.protobuf.ByteString getFieldNameBytes();

    /**
     *
     *
     * <pre>
     * Field type
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema.Type type = 2;
     * </code>
     */
    int getTypeValue();
    /**
     *
     *
     * <pre>
     * Field type
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema.Type type = 2;
     * </code>
     */
    com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema.Type getType();

    /**
     *
     *
     * <pre>
     * Is field repeated.
     * </pre>
     *
     * <code>bool is_repeated = 3;</code>
     */
    boolean getIsRepeated();

    /**
     *
     *
     * <pre>
     * Description for this field.
     * </pre>
     *
     * <code>string description = 4;</code>
     */
    java.lang.String getDescription();
    /**
     *
     *
     * <pre>
     * Description for this field.
     * </pre>
     *
     * <code>string description = 4;</code>
     */
    com.google.protobuf.ByteString getDescriptionBytes();

    /**
     *
     *
     * <pre>
     * Present iff type == RECORD.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema schema = 5;</code>
     */
    boolean hasSchema();
    /**
     *
     *
     * <pre>
     * Present iff type == RECORD.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema schema = 5;</code>
     */
    com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema getSchema();
    /**
     *
     *
     * <pre>
     * Present iff type == RECORD.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema schema = 5;</code>
     */
    com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchemaOrBuilder
        getSchemaOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Defines schema of a field in the imported data.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema}
   */
  public static final class FieldSchema extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema)
      FieldSchemaOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use FieldSchema.newBuilder() to construct.
    private FieldSchema(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private FieldSchema() {
      fieldName_ = "";
      type_ = 0;
      description_ = "";
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private FieldSchema(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                fieldName_ = s;
                break;
              }
            case 16:
              {
                int rawValue = input.readEnum();

                type_ = rawValue;
                break;
              }
            case 24:
              {
                isRepeated_ = input.readBool();
                break;
              }
            case 34:
              {
                java.lang.String s = input.readStringRequireUtf8();

                description_ = s;
                break;
              }
            case 42:
              {
                com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema.Builder
                    subBuilder = null;
                if (schema_ != null) {
                  subBuilder = schema_.toBuilder();
                }
                schema_ =
                    input.readMessage(
                        com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema
                            .parser(),
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(schema_);
                  schema_ = subBuilder.buildPartial();
                }

                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.datatransfer.v1.DataSourceProto
          .internal_static_google_cloud_bigquery_datatransfer_v1_ImportedDataInfo_FieldSchema_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.datatransfer.v1.DataSourceProto
          .internal_static_google_cloud_bigquery_datatransfer_v1_ImportedDataInfo_FieldSchema_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema.class,
              com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * LINT.IfChange
     * Field type.
     * </pre>
     *
     * Protobuf enum {@code google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema.Type}
     */
    public enum Type implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Illegal value.
       * </pre>
       *
       * <code>TYPE_UNSPECIFIED = 0;</code>
       */
      TYPE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * 64K, UTF8.
       * </pre>
       *
       * <code>STRING = 1;</code>
       */
      STRING(1),
      /**
       *
       *
       * <pre>
       * 64-bit signed.
       * </pre>
       *
       * <code>INTEGER = 2;</code>
       */
      INTEGER(2),
      /**
       *
       *
       * <pre>
       * 64-bit IEEE floating point.
       * </pre>
       *
       * <code>FLOAT = 3;</code>
       */
      FLOAT(3),
      /**
       *
       *
       * <pre>
       * Aggregate type.
       * </pre>
       *
       * <code>RECORD = 4;</code>
       */
      RECORD(4),
      /**
       *
       *
       * <pre>
       * 64K, Binary.
       * </pre>
       *
       * <code>BYTES = 5;</code>
       */
      BYTES(5),
      /**
       *
       *
       * <pre>
       * 2-valued.
       * </pre>
       *
       * <code>BOOLEAN = 6;</code>
       */
      BOOLEAN(6),
      /**
       *
       *
       * <pre>
       * 64-bit signed usec since UTC epoch.
       * </pre>
       *
       * <code>TIMESTAMP = 7;</code>
       */
      TIMESTAMP(7),
      /**
       *
       *
       * <pre>
       * Civil date - Year, Month, Day.
       * </pre>
       *
       * <code>DATE = 8;</code>
       */
      DATE(8),
      /**
       *
       *
       * <pre>
       * Civil time - Hour, Minute, Second, Microseconds.
       * </pre>
       *
       * <code>TIME = 9;</code>
       */
      TIME(9),
      /**
       *
       *
       * <pre>
       * Combination of civil date and civil time.
       * </pre>
       *
       * <code>DATETIME = 10;</code>
       */
      DATETIME(10),
      /**
       *
       *
       * <pre>
       * Numeric type with 38 decimal digits of precision and 9 decimal digits
       * of scale.
       * </pre>
       *
       * <code>NUMERIC = 11;</code>
       */
      NUMERIC(11),
      /**
       *
       *
       * <pre>
       * Geography object (go/googlesql_geography).
       * </pre>
       *
       * <code>GEOGRAPHY = 12;</code>
       */
      GEOGRAPHY(12),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Illegal value.
       * </pre>
       *
       * <code>TYPE_UNSPECIFIED = 0;</code>
       */
      public static final int TYPE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * 64K, UTF8.
       * </pre>
       *
       * <code>STRING = 1;</code>
       */
      public static final int STRING_VALUE = 1;
      /**
       *
       *
       * <pre>
       * 64-bit signed.
       * </pre>
       *
       * <code>INTEGER = 2;</code>
       */
      public static final int INTEGER_VALUE = 2;
      /**
       *
       *
       * <pre>
       * 64-bit IEEE floating point.
       * </pre>
       *
       * <code>FLOAT = 3;</code>
       */
      public static final int FLOAT_VALUE = 3;
      /**
       *
       *
       * <pre>
       * Aggregate type.
       * </pre>
       *
       * <code>RECORD = 4;</code>
       */
      public static final int RECORD_VALUE = 4;
      /**
       *
       *
       * <pre>
       * 64K, Binary.
       * </pre>
       *
       * <code>BYTES = 5;</code>
       */
      public static final int BYTES_VALUE = 5;
      /**
       *
       *
       * <pre>
       * 2-valued.
       * </pre>
       *
       * <code>BOOLEAN = 6;</code>
       */
      public static final int BOOLEAN_VALUE = 6;
      /**
       *
       *
       * <pre>
       * 64-bit signed usec since UTC epoch.
       * </pre>
       *
       * <code>TIMESTAMP = 7;</code>
       */
      public static final int TIMESTAMP_VALUE = 7;
      /**
       *
       *
       * <pre>
       * Civil date - Year, Month, Day.
       * </pre>
       *
       * <code>DATE = 8;</code>
       */
      public static final int DATE_VALUE = 8;
      /**
       *
       *
       * <pre>
       * Civil time - Hour, Minute, Second, Microseconds.
       * </pre>
       *
       * <code>TIME = 9;</code>
       */
      public static final int TIME_VALUE = 9;
      /**
       *
       *
       * <pre>
       * Combination of civil date and civil time.
       * </pre>
       *
       * <code>DATETIME = 10;</code>
       */
      public static final int DATETIME_VALUE = 10;
      /**
       *
       *
       * <pre>
       * Numeric type with 38 decimal digits of precision and 9 decimal digits
       * of scale.
       * </pre>
       *
       * <code>NUMERIC = 11;</code>
       */
      public static final int NUMERIC_VALUE = 11;
      /**
       *
       *
       * <pre>
       * Geography object (go/googlesql_geography).
       * </pre>
       *
       * <code>GEOGRAPHY = 12;</code>
       */
      public static final int GEOGRAPHY_VALUE = 12;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /** @deprecated Use {@link #forNumber(int)} instead. */
      @java.lang.Deprecated
      public static Type valueOf(int value) {
        return forNumber(value);
      }

      public static Type forNumber(int value) {
        switch (value) {
          case 0:
            return TYPE_UNSPECIFIED;
          case 1:
            return STRING;
          case 2:
            return INTEGER;
          case 3:
            return FLOAT;
          case 4:
            return RECORD;
          case 5:
            return BYTES;
          case 6:
            return BOOLEAN;
          case 7:
            return TIMESTAMP;
          case 8:
            return DATE;
          case 9:
            return TIME;
          case 10:
            return DATETIME;
          case 11:
            return NUMERIC;
          case 12:
            return GEOGRAPHY;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Type> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<Type> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Type>() {
            public Type findValueByNumber(int number) {
              return Type.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema
            .getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final Type[] VALUES = values();

      public static Type valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Type(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema.Type)
    }

    public static final int FIELD_NAME_FIELD_NUMBER = 1;
    private volatile java.lang.Object fieldName_;
    /**
     *
     *
     * <pre>
     * Field name. Matches: [A-Za-z_][A-Za-z_0-9]{0,127}
     * </pre>
     *
     * <code>string field_name = 1;</code>
     */
    public java.lang.String getFieldName() {
      java.lang.Object ref = fieldName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        fieldName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Field name. Matches: [A-Za-z_][A-Za-z_0-9]{0,127}
     * </pre>
     *
     * <code>string field_name = 1;</code>
     */
    public com.google.protobuf.ByteString getFieldNameBytes() {
      java.lang.Object ref = fieldName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        fieldName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TYPE_FIELD_NUMBER = 2;
    private int type_;
    /**
     *
     *
     * <pre>
     * Field type
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema.Type type = 2;
     * </code>
     */
    public int getTypeValue() {
      return type_;
    }
    /**
     *
     *
     * <pre>
     * Field type
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema.Type type = 2;
     * </code>
     */
    public com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema.Type getType() {
      @SuppressWarnings("deprecation")
      com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema.Type result =
          com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema.Type.valueOf(
              type_);
      return result == null
          ? com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema.Type.UNRECOGNIZED
          : result;
    }

    public static final int IS_REPEATED_FIELD_NUMBER = 3;
    private boolean isRepeated_;
    /**
     *
     *
     * <pre>
     * Is field repeated.
     * </pre>
     *
     * <code>bool is_repeated = 3;</code>
     */
    public boolean getIsRepeated() {
      return isRepeated_;
    }

    public static final int DESCRIPTION_FIELD_NUMBER = 4;
    private volatile java.lang.Object description_;
    /**
     *
     *
     * <pre>
     * Description for this field.
     * </pre>
     *
     * <code>string description = 4;</code>
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Description for this field.
     * </pre>
     *
     * <code>string description = 4;</code>
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SCHEMA_FIELD_NUMBER = 5;
    private com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema schema_;
    /**
     *
     *
     * <pre>
     * Present iff type == RECORD.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema schema = 5;</code>
     */
    public boolean hasSchema() {
      return schema_ != null;
    }
    /**
     *
     *
     * <pre>
     * Present iff type == RECORD.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema schema = 5;</code>
     */
    public com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema getSchema() {
      return schema_ == null
          ? com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema
              .getDefaultInstance()
          : schema_;
    }
    /**
     *
     *
     * <pre>
     * Present iff type == RECORD.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema schema = 5;</code>
     */
    public com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchemaOrBuilder
        getSchemaOrBuilder() {
      return getSchema();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!getFieldNameBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, fieldName_);
      }
      if (type_
          != com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema.Type
              .TYPE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(2, type_);
      }
      if (isRepeated_ != false) {
        output.writeBool(3, isRepeated_);
      }
      if (!getDescriptionBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, description_);
      }
      if (schema_ != null) {
        output.writeMessage(5, getSchema());
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getFieldNameBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, fieldName_);
      }
      if (type_
          != com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema.Type
              .TYPE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, type_);
      }
      if (isRepeated_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, isRepeated_);
      }
      if (!getDescriptionBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, description_);
      }
      if (schema_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getSchema());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema)) {
        return super.equals(obj);
      }
      com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema other =
          (com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema) obj;

      if (!getFieldName().equals(other.getFieldName())) return false;
      if (type_ != other.type_) return false;
      if (getIsRepeated() != other.getIsRepeated()) return false;
      if (!getDescription().equals(other.getDescription())) return false;
      if (hasSchema() != other.hasSchema()) return false;
      if (hasSchema()) {
        if (!getSchema().equals(other.getSchema())) return false;
      }
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + FIELD_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getFieldName().hashCode();
      hash = (37 * hash) + TYPE_FIELD_NUMBER;
      hash = (53 * hash) + type_;
      hash = (37 * hash) + IS_REPEATED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIsRepeated());
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
      if (hasSchema()) {
        hash = (37 * hash) + SCHEMA_FIELD_NUMBER;
        hash = (53 * hash) + getSchema().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Defines schema of a field in the imported data.
     * </pre>
     *
     * Protobuf type {@code google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema)
        com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchemaOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.bigquery.datatransfer.v1.DataSourceProto
            .internal_static_google_cloud_bigquery_datatransfer_v1_ImportedDataInfo_FieldSchema_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.bigquery.datatransfer.v1.DataSourceProto
            .internal_static_google_cloud_bigquery_datatransfer_v1_ImportedDataInfo_FieldSchema_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema.class,
                com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        fieldName_ = "";

        type_ = 0;

        isRepeated_ = false;

        description_ = "";

        if (schemaBuilder_ == null) {
          schema_ = null;
        } else {
          schema_ = null;
          schemaBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.bigquery.datatransfer.v1.DataSourceProto
            .internal_static_google_cloud_bigquery_datatransfer_v1_ImportedDataInfo_FieldSchema_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema
          getDefaultInstanceForType() {
        return com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema build() {
        com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema buildPartial() {
        com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema result =
            new com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema(this);
        result.fieldName_ = fieldName_;
        result.type_ = type_;
        result.isRepeated_ = isRepeated_;
        result.description_ = description_;
        if (schemaBuilder_ == null) {
          result.schema_ = schema_;
        } else {
          result.schema_ = schemaBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema) {
          return mergeFrom(
              (com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema other) {
        if (other
            == com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema
                .getDefaultInstance()) return this;
        if (!other.getFieldName().isEmpty()) {
          fieldName_ = other.fieldName_;
          onChanged();
        }
        if (other.type_ != 0) {
          setTypeValue(other.getTypeValue());
        }
        if (other.getIsRepeated() != false) {
          setIsRepeated(other.getIsRepeated());
        }
        if (!other.getDescription().isEmpty()) {
          description_ = other.description_;
          onChanged();
        }
        if (other.hasSchema()) {
          mergeSchema(other.getSchema());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object fieldName_ = "";
      /**
       *
       *
       * <pre>
       * Field name. Matches: [A-Za-z_][A-Za-z_0-9]{0,127}
       * </pre>
       *
       * <code>string field_name = 1;</code>
       */
      public java.lang.String getFieldName() {
        java.lang.Object ref = fieldName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          fieldName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Field name. Matches: [A-Za-z_][A-Za-z_0-9]{0,127}
       * </pre>
       *
       * <code>string field_name = 1;</code>
       */
      public com.google.protobuf.ByteString getFieldNameBytes() {
        java.lang.Object ref = fieldName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          fieldName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Field name. Matches: [A-Za-z_][A-Za-z_0-9]{0,127}
       * </pre>
       *
       * <code>string field_name = 1;</code>
       */
      public Builder setFieldName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        fieldName_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Field name. Matches: [A-Za-z_][A-Za-z_0-9]{0,127}
       * </pre>
       *
       * <code>string field_name = 1;</code>
       */
      public Builder clearFieldName() {

        fieldName_ = getDefaultInstance().getFieldName();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Field name. Matches: [A-Za-z_][A-Za-z_0-9]{0,127}
       * </pre>
       *
       * <code>string field_name = 1;</code>
       */
      public Builder setFieldNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        fieldName_ = value;
        onChanged();
        return this;
      }

      private int type_ = 0;
      /**
       *
       *
       * <pre>
       * Field type
       * </pre>
       *
       * <code>.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema.Type type = 2;
       * </code>
       */
      public int getTypeValue() {
        return type_;
      }
      /**
       *
       *
       * <pre>
       * Field type
       * </pre>
       *
       * <code>.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema.Type type = 2;
       * </code>
       */
      public Builder setTypeValue(int value) {
        type_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Field type
       * </pre>
       *
       * <code>.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema.Type type = 2;
       * </code>
       */
      public com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema.Type getType() {
        @SuppressWarnings("deprecation")
        com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema.Type result =
            com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema.Type.valueOf(
                type_);
        return result == null
            ? com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema.Type
                .UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Field type
       * </pre>
       *
       * <code>.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema.Type type = 2;
       * </code>
       */
      public Builder setType(
          com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema.Type value) {
        if (value == null) {
          throw new NullPointerException();
        }

        type_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Field type
       * </pre>
       *
       * <code>.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema.Type type = 2;
       * </code>
       */
      public Builder clearType() {

        type_ = 0;
        onChanged();
        return this;
      }

      private boolean isRepeated_;
      /**
       *
       *
       * <pre>
       * Is field repeated.
       * </pre>
       *
       * <code>bool is_repeated = 3;</code>
       */
      public boolean getIsRepeated() {
        return isRepeated_;
      }
      /**
       *
       *
       * <pre>
       * Is field repeated.
       * </pre>
       *
       * <code>bool is_repeated = 3;</code>
       */
      public Builder setIsRepeated(boolean value) {

        isRepeated_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Is field repeated.
       * </pre>
       *
       * <code>bool is_repeated = 3;</code>
       */
      public Builder clearIsRepeated() {

        isRepeated_ = false;
        onChanged();
        return this;
      }

      private java.lang.Object description_ = "";
      /**
       *
       *
       * <pre>
       * Description for this field.
       * </pre>
       *
       * <code>string description = 4;</code>
       */
      public java.lang.String getDescription() {
        java.lang.Object ref = description_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          description_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Description for this field.
       * </pre>
       *
       * <code>string description = 4;</code>
       */
      public com.google.protobuf.ByteString getDescriptionBytes() {
        java.lang.Object ref = description_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          description_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Description for this field.
       * </pre>
       *
       * <code>string description = 4;</code>
       */
      public Builder setDescription(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        description_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Description for this field.
       * </pre>
       *
       * <code>string description = 4;</code>
       */
      public Builder clearDescription() {

        description_ = getDefaultInstance().getDescription();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Description for this field.
       * </pre>
       *
       * <code>string description = 4;</code>
       */
      public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        description_ = value;
        onChanged();
        return this;
      }

      private com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema schema_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema,
              com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema.Builder,
              com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchemaOrBuilder>
          schemaBuilder_;
      /**
       *
       *
       * <pre>
       * Present iff type == RECORD.
       * </pre>
       *
       * <code>.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema schema = 5;
       * </code>
       */
      public boolean hasSchema() {
        return schemaBuilder_ != null || schema_ != null;
      }
      /**
       *
       *
       * <pre>
       * Present iff type == RECORD.
       * </pre>
       *
       * <code>.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema schema = 5;
       * </code>
       */
      public com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema getSchema() {
        if (schemaBuilder_ == null) {
          return schema_ == null
              ? com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema
                  .getDefaultInstance()
              : schema_;
        } else {
          return schemaBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Present iff type == RECORD.
       * </pre>
       *
       * <code>.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema schema = 5;
       * </code>
       */
      public Builder setSchema(
          com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema value) {
        if (schemaBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          schema_ = value;
          onChanged();
        } else {
          schemaBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Present iff type == RECORD.
       * </pre>
       *
       * <code>.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema schema = 5;
       * </code>
       */
      public Builder setSchema(
          com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema.Builder
              builderForValue) {
        if (schemaBuilder_ == null) {
          schema_ = builderForValue.build();
          onChanged();
        } else {
          schemaBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Present iff type == RECORD.
       * </pre>
       *
       * <code>.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema schema = 5;
       * </code>
       */
      public Builder mergeSchema(
          com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema value) {
        if (schemaBuilder_ == null) {
          if (schema_ != null) {
            schema_ =
                com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema.newBuilder(
                        schema_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            schema_ = value;
          }
          onChanged();
        } else {
          schemaBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Present iff type == RECORD.
       * </pre>
       *
       * <code>.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema schema = 5;
       * </code>
       */
      public Builder clearSchema() {
        if (schemaBuilder_ == null) {
          schema_ = null;
          onChanged();
        } else {
          schema_ = null;
          schemaBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Present iff type == RECORD.
       * </pre>
       *
       * <code>.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema schema = 5;
       * </code>
       */
      public com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema.Builder
          getSchemaBuilder() {

        onChanged();
        return getSchemaFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Present iff type == RECORD.
       * </pre>
       *
       * <code>.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema schema = 5;
       * </code>
       */
      public com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchemaOrBuilder
          getSchemaOrBuilder() {
        if (schemaBuilder_ != null) {
          return schemaBuilder_.getMessageOrBuilder();
        } else {
          return schema_ == null
              ? com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema
                  .getDefaultInstance()
              : schema_;
        }
      }
      /**
       *
       *
       * <pre>
       * Present iff type == RECORD.
       * </pre>
       *
       * <code>.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema schema = 5;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema,
              com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema.Builder,
              com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchemaOrBuilder>
          getSchemaFieldBuilder() {
        if (schemaBuilder_ == null) {
          schemaBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema,
                  com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema.Builder,
                  com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchemaOrBuilder>(
                  getSchema(), getParentForChildren(), isClean());
          schema_ = null;
        }
        return schemaBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema)
    private static final com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema();
    }

    public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<FieldSchema> PARSER =
        new com.google.protobuf.AbstractParser<FieldSchema>() {
          @java.lang.Override
          public FieldSchema parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new FieldSchema(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<FieldSchema> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<FieldSchema> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface RecordSchemaOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * One field per column in the record.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema fields = 1;
     * </code>
     */
    java.util.List<com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema>
        getFieldsList();
    /**
     *
     *
     * <pre>
     * One field per column in the record.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema fields = 1;
     * </code>
     */
    com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema getFields(int index);
    /**
     *
     *
     * <pre>
     * One field per column in the record.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema fields = 1;
     * </code>
     */
    int getFieldsCount();
    /**
     *
     *
     * <pre>
     * One field per column in the record.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema fields = 1;
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchemaOrBuilder>
        getFieldsOrBuilderList();
    /**
     *
     *
     * <pre>
     * One field per column in the record.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema fields = 1;
     * </code>
     */
    com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchemaOrBuilder
        getFieldsOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * Describes schema of the data to be ingested.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema}
   */
  public static final class RecordSchema extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema)
      RecordSchemaOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use RecordSchema.newBuilder() to construct.
    private RecordSchema(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private RecordSchema() {
      fields_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private RecordSchema(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                  fields_ =
                      new java.util.ArrayList<
                          com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema>();
                  mutable_bitField0_ |= 0x00000001;
                }
                fields_.add(
                    input.readMessage(
                        com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema
                            .parser(),
                        extensionRegistry));
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) != 0)) {
          fields_ = java.util.Collections.unmodifiableList(fields_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.datatransfer.v1.DataSourceProto
          .internal_static_google_cloud_bigquery_datatransfer_v1_ImportedDataInfo_RecordSchema_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.datatransfer.v1.DataSourceProto
          .internal_static_google_cloud_bigquery_datatransfer_v1_ImportedDataInfo_RecordSchema_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema.class,
              com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema.Builder
                  .class);
    }

    public static final int FIELDS_FIELD_NUMBER = 1;
    private java.util.List<com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema>
        fields_;
    /**
     *
     *
     * <pre>
     * One field per column in the record.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema fields = 1;
     * </code>
     */
    public java.util.List<com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema>
        getFieldsList() {
      return fields_;
    }
    /**
     *
     *
     * <pre>
     * One field per column in the record.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema fields = 1;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchemaOrBuilder>
        getFieldsOrBuilderList() {
      return fields_;
    }
    /**
     *
     *
     * <pre>
     * One field per column in the record.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema fields = 1;
     * </code>
     */
    public int getFieldsCount() {
      return fields_.size();
    }
    /**
     *
     *
     * <pre>
     * One field per column in the record.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema fields = 1;
     * </code>
     */
    public com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema getFields(
        int index) {
      return fields_.get(index);
    }
    /**
     *
     *
     * <pre>
     * One field per column in the record.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema fields = 1;
     * </code>
     */
    public com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchemaOrBuilder
        getFieldsOrBuilder(int index) {
      return fields_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < fields_.size(); i++) {
        output.writeMessage(1, fields_.get(i));
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < fields_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, fields_.get(i));
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema)) {
        return super.equals(obj);
      }
      com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema other =
          (com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema) obj;

      if (!getFieldsList().equals(other.getFieldsList())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getFieldsCount() > 0) {
        hash = (37 * hash) + FIELDS_FIELD_NUMBER;
        hash = (53 * hash) + getFieldsList().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Describes schema of the data to be ingested.
     * </pre>
     *
     * Protobuf type {@code google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema)
        com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchemaOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.bigquery.datatransfer.v1.DataSourceProto
            .internal_static_google_cloud_bigquery_datatransfer_v1_ImportedDataInfo_RecordSchema_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.bigquery.datatransfer.v1.DataSourceProto
            .internal_static_google_cloud_bigquery_datatransfer_v1_ImportedDataInfo_RecordSchema_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema.class,
                com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getFieldsFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (fieldsBuilder_ == null) {
          fields_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          fieldsBuilder_.clear();
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.bigquery.datatransfer.v1.DataSourceProto
            .internal_static_google_cloud_bigquery_datatransfer_v1_ImportedDataInfo_RecordSchema_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema
          getDefaultInstanceForType() {
        return com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema build() {
        com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema
          buildPartial() {
        com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema result =
            new com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema(this);
        int from_bitField0_ = bitField0_;
        if (fieldsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            fields_ = java.util.Collections.unmodifiableList(fields_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.fields_ = fields_;
        } else {
          result.fields_ = fieldsBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema) {
          return mergeFrom(
              (com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema other) {
        if (other
            == com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema
                .getDefaultInstance()) return this;
        if (fieldsBuilder_ == null) {
          if (!other.fields_.isEmpty()) {
            if (fields_.isEmpty()) {
              fields_ = other.fields_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureFieldsIsMutable();
              fields_.addAll(other.fields_);
            }
            onChanged();
          }
        } else {
          if (!other.fields_.isEmpty()) {
            if (fieldsBuilder_.isEmpty()) {
              fieldsBuilder_.dispose();
              fieldsBuilder_ = null;
              fields_ = other.fields_;
              bitField0_ = (bitField0_ & ~0x00000001);
              fieldsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getFieldsFieldBuilder()
                      : null;
            } else {
              fieldsBuilder_.addAllMessages(other.fields_);
            }
          }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema parsedMessage =
            null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema>
          fields_ = java.util.Collections.emptyList();

      private void ensureFieldsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          fields_ =
              new java.util.ArrayList<
                  com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema>(fields_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema,
              com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema.Builder,
              com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchemaOrBuilder>
          fieldsBuilder_;

      /**
       *
       *
       * <pre>
       * One field per column in the record.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema fields = 1;
       * </code>
       */
      public java.util.List<com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema>
          getFieldsList() {
        if (fieldsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(fields_);
        } else {
          return fieldsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * One field per column in the record.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema fields = 1;
       * </code>
       */
      public int getFieldsCount() {
        if (fieldsBuilder_ == null) {
          return fields_.size();
        } else {
          return fieldsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * One field per column in the record.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema fields = 1;
       * </code>
       */
      public com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema getFields(
          int index) {
        if (fieldsBuilder_ == null) {
          return fields_.get(index);
        } else {
          return fieldsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * One field per column in the record.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema fields = 1;
       * </code>
       */
      public Builder setFields(
          int index, com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema value) {
        if (fieldsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFieldsIsMutable();
          fields_.set(index, value);
          onChanged();
        } else {
          fieldsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * One field per column in the record.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema fields = 1;
       * </code>
       */
      public Builder setFields(
          int index,
          com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema.Builder
              builderForValue) {
        if (fieldsBuilder_ == null) {
          ensureFieldsIsMutable();
          fields_.set(index, builderForValue.build());
          onChanged();
        } else {
          fieldsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * One field per column in the record.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema fields = 1;
       * </code>
       */
      public Builder addFields(
          com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema value) {
        if (fieldsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFieldsIsMutable();
          fields_.add(value);
          onChanged();
        } else {
          fieldsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * One field per column in the record.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema fields = 1;
       * </code>
       */
      public Builder addFields(
          int index, com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema value) {
        if (fieldsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFieldsIsMutable();
          fields_.add(index, value);
          onChanged();
        } else {
          fieldsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * One field per column in the record.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema fields = 1;
       * </code>
       */
      public Builder addFields(
          com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema.Builder
              builderForValue) {
        if (fieldsBuilder_ == null) {
          ensureFieldsIsMutable();
          fields_.add(builderForValue.build());
          onChanged();
        } else {
          fieldsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * One field per column in the record.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema fields = 1;
       * </code>
       */
      public Builder addFields(
          int index,
          com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema.Builder
              builderForValue) {
        if (fieldsBuilder_ == null) {
          ensureFieldsIsMutable();
          fields_.add(index, builderForValue.build());
          onChanged();
        } else {
          fieldsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * One field per column in the record.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema fields = 1;
       * </code>
       */
      public Builder addAllFields(
          java.lang.Iterable<
                  ? extends com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema>
              values) {
        if (fieldsBuilder_ == null) {
          ensureFieldsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, fields_);
          onChanged();
        } else {
          fieldsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * One field per column in the record.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema fields = 1;
       * </code>
       */
      public Builder clearFields() {
        if (fieldsBuilder_ == null) {
          fields_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          fieldsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * One field per column in the record.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema fields = 1;
       * </code>
       */
      public Builder removeFields(int index) {
        if (fieldsBuilder_ == null) {
          ensureFieldsIsMutable();
          fields_.remove(index);
          onChanged();
        } else {
          fieldsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * One field per column in the record.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema fields = 1;
       * </code>
       */
      public com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema.Builder
          getFieldsBuilder(int index) {
        return getFieldsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * One field per column in the record.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema fields = 1;
       * </code>
       */
      public com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchemaOrBuilder
          getFieldsOrBuilder(int index) {
        if (fieldsBuilder_ == null) {
          return fields_.get(index);
        } else {
          return fieldsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * One field per column in the record.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema fields = 1;
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchemaOrBuilder>
          getFieldsOrBuilderList() {
        if (fieldsBuilder_ != null) {
          return fieldsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(fields_);
        }
      }
      /**
       *
       *
       * <pre>
       * One field per column in the record.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema fields = 1;
       * </code>
       */
      public com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema.Builder
          addFieldsBuilder() {
        return getFieldsFieldBuilder()
            .addBuilder(
                com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * One field per column in the record.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema fields = 1;
       * </code>
       */
      public com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema.Builder
          addFieldsBuilder(int index) {
        return getFieldsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * One field per column in the record.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema fields = 1;
       * </code>
       */
      public java.util.List<
              com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema.Builder>
          getFieldsBuilderList() {
        return getFieldsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema,
              com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema.Builder,
              com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchemaOrBuilder>
          getFieldsFieldBuilder() {
        if (fieldsBuilder_ == null) {
          fieldsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema,
                  com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchema.Builder,
                  com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.FieldSchemaOrBuilder>(
                  fields_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
          fields_ = null;
        }
        return fieldsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema)
    private static final com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema();
    }

    public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<RecordSchema> PARSER =
        new com.google.protobuf.AbstractParser<RecordSchema>() {
          @java.lang.Override
          public RecordSchema parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new RecordSchema(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<RecordSchema> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<RecordSchema> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface TableDefinitionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * BigQuery table_id (required). This will be used to reference this
     * table in the query.
     * </pre>
     *
     * <code>string table_id = 1;</code>
     */
    java.lang.String getTableId();
    /**
     *
     *
     * <pre>
     * BigQuery table_id (required). This will be used to reference this
     * table in the query.
     * </pre>
     *
     * <code>string table_id = 1;</code>
     */
    com.google.protobuf.ByteString getTableIdBytes();

    /**
     *
     *
     * <pre>
     * URIs for the data to be imported. All URIs must be from the same storage
     * system.
     * </pre>
     *
     * <code>repeated string source_uris = 2;</code>
     */
    java.util.List<java.lang.String> getSourceUrisList();
    /**
     *
     *
     * <pre>
     * URIs for the data to be imported. All URIs must be from the same storage
     * system.
     * </pre>
     *
     * <code>repeated string source_uris = 2;</code>
     */
    int getSourceUrisCount();
    /**
     *
     *
     * <pre>
     * URIs for the data to be imported. All URIs must be from the same storage
     * system.
     * </pre>
     *
     * <code>repeated string source_uris = 2;</code>
     */
    java.lang.String getSourceUris(int index);
    /**
     *
     *
     * <pre>
     * URIs for the data to be imported. All URIs must be from the same storage
     * system.
     * </pre>
     *
     * <code>repeated string source_uris = 2;</code>
     */
    com.google.protobuf.ByteString getSourceUrisBytes(int index);

    /**
     *
     *
     * <pre>
     * Describes the format of the data in source_uri.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.Format format = 3;</code>
     */
    int getFormatValue();
    /**
     *
     *
     * <pre>
     * Describes the format of the data in source_uri.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.Format format = 3;</code>
     */
    com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.Format getFormat();

    /**
     *
     *
     * <pre>
     * Specify the maximum number of bad records that can be ignored.
     * If bad records exceed this threshold the query is aborted.
     * </pre>
     *
     * <code>int32 max_bad_records = 4;</code>
     */
    int getMaxBadRecords();

    /**
     *
     *
     * <pre>
     * Character encoding of the input when applicable (CSV, JSON).
     * Defaults to UTF8.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.Encoding encoding = 5;</code>
     */
    int getEncodingValue();
    /**
     *
     *
     * <pre>
     * Character encoding of the input when applicable (CSV, JSON).
     * Defaults to UTF8.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.Encoding encoding = 5;</code>
     */
    com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.Encoding getEncoding();

    /**
     *
     *
     * <pre>
     * CSV specific options.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition.CsvOptions csv_options = 6;
     * </code>
     */
    boolean hasCsvOptions();
    /**
     *
     *
     * <pre>
     * CSV specific options.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition.CsvOptions csv_options = 6;
     * </code>
     */
    com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition.CsvOptions
        getCsvOptions();
    /**
     *
     *
     * <pre>
     * CSV specific options.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition.CsvOptions csv_options = 6;
     * </code>
     */
    com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition.CsvOptionsOrBuilder
        getCsvOptionsOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional schema for the data. When not specified for JSON and CSV formats
     * we will try to detect it automatically.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema schema = 7;</code>
     */
    boolean hasSchema();
    /**
     *
     *
     * <pre>
     * Optional schema for the data. When not specified for JSON and CSV formats
     * we will try to detect it automatically.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema schema = 7;</code>
     */
    com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema getSchema();
    /**
     *
     *
     * <pre>
     * Optional schema for the data. When not specified for JSON and CSV formats
     * we will try to detect it automatically.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema schema = 7;</code>
     */
    com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchemaOrBuilder
        getSchemaOrBuilder();

    /**
     *
     *
     * <pre>
     * Indicates if extra values that are not represented in the table schema is
     * allowed.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue ignore_unknown_values = 10;</code>
     */
    boolean hasIgnoreUnknownValues();
    /**
     *
     *
     * <pre>
     * Indicates if extra values that are not represented in the table schema is
     * allowed.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue ignore_unknown_values = 10;</code>
     */
    com.google.protobuf.BoolValue getIgnoreUnknownValues();
    /**
     *
     *
     * <pre>
     * Indicates if extra values that are not represented in the table schema is
     * allowed.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue ignore_unknown_values = 10;</code>
     */
    com.google.protobuf.BoolValueOrBuilder getIgnoreUnknownValuesOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * External table definition. These tables can be referenced with 'name'
   * in the query and can be read just like any other table.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition}
   */
  public static final class TableDefinition extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition)
      TableDefinitionOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use TableDefinition.newBuilder() to construct.
    private TableDefinition(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private TableDefinition() {
      tableId_ = "";
      sourceUris_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      format_ = 0;
      encoding_ = 0;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private TableDefinition(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                tableId_ = s;
                break;
              }
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                  sourceUris_ = new com.google.protobuf.LazyStringArrayList();
                  mutable_bitField0_ |= 0x00000002;
                }
                sourceUris_.add(s);
                break;
              }
            case 24:
              {
                int rawValue = input.readEnum();

                format_ = rawValue;
                break;
              }
            case 32:
              {
                maxBadRecords_ = input.readInt32();
                break;
              }
            case 40:
              {
                int rawValue = input.readEnum();

                encoding_ = rawValue;
                break;
              }
            case 50:
              {
                com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition
                        .CsvOptions.Builder
                    subBuilder = null;
                if (csvOptions_ != null) {
                  subBuilder = csvOptions_.toBuilder();
                }
                csvOptions_ =
                    input.readMessage(
                        com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition
                            .CsvOptions.parser(),
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(csvOptions_);
                  csvOptions_ = subBuilder.buildPartial();
                }

                break;
              }
            case 58:
              {
                com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema.Builder
                    subBuilder = null;
                if (schema_ != null) {
                  subBuilder = schema_.toBuilder();
                }
                schema_ =
                    input.readMessage(
                        com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema
                            .parser(),
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(schema_);
                  schema_ = subBuilder.buildPartial();
                }

                break;
              }
            case 82:
              {
                com.google.protobuf.BoolValue.Builder subBuilder = null;
                if (ignoreUnknownValues_ != null) {
                  subBuilder = ignoreUnknownValues_.toBuilder();
                }
                ignoreUnknownValues_ =
                    input.readMessage(com.google.protobuf.BoolValue.parser(), extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(ignoreUnknownValues_);
                  ignoreUnknownValues_ = subBuilder.buildPartial();
                }

                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000002) != 0)) {
          sourceUris_ = sourceUris_.getUnmodifiableView();
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.datatransfer.v1.DataSourceProto
          .internal_static_google_cloud_bigquery_datatransfer_v1_ImportedDataInfo_TableDefinition_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.datatransfer.v1.DataSourceProto
          .internal_static_google_cloud_bigquery_datatransfer_v1_ImportedDataInfo_TableDefinition_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition.class,
              com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition.Builder
                  .class);
    }

    public interface CsvOptionsOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition.CsvOptions)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The delimiter.  We currently restrict this to U+0001 to U+00FF and
       * apply additional constraints during validation.
       * </pre>
       *
       * <code>.google.protobuf.StringValue field_delimiter = 1;</code>
       */
      boolean hasFieldDelimiter();
      /**
       *
       *
       * <pre>
       * The delimiter.  We currently restrict this to U+0001 to U+00FF and
       * apply additional constraints during validation.
       * </pre>
       *
       * <code>.google.protobuf.StringValue field_delimiter = 1;</code>
       */
      com.google.protobuf.StringValue getFieldDelimiter();
      /**
       *
       *
       * <pre>
       * The delimiter.  We currently restrict this to U+0001 to U+00FF and
       * apply additional constraints during validation.
       * </pre>
       *
       * <code>.google.protobuf.StringValue field_delimiter = 1;</code>
       */
      com.google.protobuf.StringValueOrBuilder getFieldDelimiterOrBuilder();

      /**
       *
       *
       * <pre>
       * Whether CSV files are allowed to have quoted newlines. If quoted
       * newlines are allowed, we can't split CSV files.
       * </pre>
       *
       * <code>.google.protobuf.BoolValue allow_quoted_newlines = 2;</code>
       */
      boolean hasAllowQuotedNewlines();
      /**
       *
       *
       * <pre>
       * Whether CSV files are allowed to have quoted newlines. If quoted
       * newlines are allowed, we can't split CSV files.
       * </pre>
       *
       * <code>.google.protobuf.BoolValue allow_quoted_newlines = 2;</code>
       */
      com.google.protobuf.BoolValue getAllowQuotedNewlines();
      /**
       *
       *
       * <pre>
       * Whether CSV files are allowed to have quoted newlines. If quoted
       * newlines are allowed, we can't split CSV files.
       * </pre>
       *
       * <code>.google.protobuf.BoolValue allow_quoted_newlines = 2;</code>
       */
      com.google.protobuf.BoolValueOrBuilder getAllowQuotedNewlinesOrBuilder();

      /**
       *
       *
       * <pre>
       * The quote character.  We currently restrict this to U+0000 to U+00FF
       * and apply additional constraints during validation. Set to '&#92;0' to
       * indicate no quote is used.
       * </pre>
       *
       * <code>.google.protobuf.StringValue quote_char = 3;</code>
       */
      boolean hasQuoteChar();
      /**
       *
       *
       * <pre>
       * The quote character.  We currently restrict this to U+0000 to U+00FF
       * and apply additional constraints during validation. Set to '&#92;0' to
       * indicate no quote is used.
       * </pre>
       *
       * <code>.google.protobuf.StringValue quote_char = 3;</code>
       */
      com.google.protobuf.StringValue getQuoteChar();
      /**
       *
       *
       * <pre>
       * The quote character.  We currently restrict this to U+0000 to U+00FF
       * and apply additional constraints during validation. Set to '&#92;0' to
       * indicate no quote is used.
       * </pre>
       *
       * <code>.google.protobuf.StringValue quote_char = 3;</code>
       */
      com.google.protobuf.StringValueOrBuilder getQuoteCharOrBuilder();

      /**
       *
       *
       * <pre>
       * Number of leading rows to skip.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value skip_leading_rows = 4;</code>
       */
      boolean hasSkipLeadingRows();
      /**
       *
       *
       * <pre>
       * Number of leading rows to skip.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value skip_leading_rows = 4;</code>
       */
      com.google.protobuf.Int64Value getSkipLeadingRows();
      /**
       *
       *
       * <pre>
       * Number of leading rows to skip.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value skip_leading_rows = 4;</code>
       */
      com.google.protobuf.Int64ValueOrBuilder getSkipLeadingRowsOrBuilder();

      /**
       *
       *
       * <pre>
       * Accept rows that are missing trailing optional columns.
       * </pre>
       *
       * <code>.google.protobuf.BoolValue allow_jagged_rows = 5;</code>
       */
      boolean hasAllowJaggedRows();
      /**
       *
       *
       * <pre>
       * Accept rows that are missing trailing optional columns.
       * </pre>
       *
       * <code>.google.protobuf.BoolValue allow_jagged_rows = 5;</code>
       */
      com.google.protobuf.BoolValue getAllowJaggedRows();
      /**
       *
       *
       * <pre>
       * Accept rows that are missing trailing optional columns.
       * </pre>
       *
       * <code>.google.protobuf.BoolValue allow_jagged_rows = 5;</code>
       */
      com.google.protobuf.BoolValueOrBuilder getAllowJaggedRowsOrBuilder();
    }
    /**
     *
     *
     * <pre>
     * CSV specific options.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition.CsvOptions}
     */
    public static final class CsvOptions extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition.CsvOptions)
        CsvOptionsOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use CsvOptions.newBuilder() to construct.
      private CsvOptions(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private CsvOptions() {}

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
      }

      private CsvOptions(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        int mutable_bitField0_ = 0;
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.protobuf.StringValue.Builder subBuilder = null;
                  if (fieldDelimiter_ != null) {
                    subBuilder = fieldDelimiter_.toBuilder();
                  }
                  fieldDelimiter_ =
                      input.readMessage(
                          com.google.protobuf.StringValue.parser(), extensionRegistry);
                  if (subBuilder != null) {
                    subBuilder.mergeFrom(fieldDelimiter_);
                    fieldDelimiter_ = subBuilder.buildPartial();
                  }

                  break;
                }
              case 18:
                {
                  com.google.protobuf.BoolValue.Builder subBuilder = null;
                  if (allowQuotedNewlines_ != null) {
                    subBuilder = allowQuotedNewlines_.toBuilder();
                  }
                  allowQuotedNewlines_ =
                      input.readMessage(com.google.protobuf.BoolValue.parser(), extensionRegistry);
                  if (subBuilder != null) {
                    subBuilder.mergeFrom(allowQuotedNewlines_);
                    allowQuotedNewlines_ = subBuilder.buildPartial();
                  }

                  break;
                }
              case 26:
                {
                  com.google.protobuf.StringValue.Builder subBuilder = null;
                  if (quoteChar_ != null) {
                    subBuilder = quoteChar_.toBuilder();
                  }
                  quoteChar_ =
                      input.readMessage(
                          com.google.protobuf.StringValue.parser(), extensionRegistry);
                  if (subBuilder != null) {
                    subBuilder.mergeFrom(quoteChar_);
                    quoteChar_ = subBuilder.buildPartial();
                  }

                  break;
                }
              case 34:
                {
                  com.google.protobuf.Int64Value.Builder subBuilder = null;
                  if (skipLeadingRows_ != null) {
                    subBuilder = skipLeadingRows_.toBuilder();
                  }
                  skipLeadingRows_ =
                      input.readMessage(com.google.protobuf.Int64Value.parser(), extensionRegistry);
                  if (subBuilder != null) {
                    subBuilder.mergeFrom(skipLeadingRows_);
                    skipLeadingRows_ = subBuilder.buildPartial();
                  }

                  break;
                }
              case 42:
                {
                  com.google.protobuf.BoolValue.Builder subBuilder = null;
                  if (allowJaggedRows_ != null) {
                    subBuilder = allowJaggedRows_.toBuilder();
                  }
                  allowJaggedRows_ =
                      input.readMessage(com.google.protobuf.BoolValue.parser(), extensionRegistry);
                  if (subBuilder != null) {
                    subBuilder.mergeFrom(allowJaggedRows_);
                    allowJaggedRows_ = subBuilder.buildPartial();
                  }

                  break;
                }
              default:
                {
                  if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                    done = true;
                  }
                  break;
                }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(this);
        } finally {
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.bigquery.datatransfer.v1.DataSourceProto
            .internal_static_google_cloud_bigquery_datatransfer_v1_ImportedDataInfo_TableDefinition_CsvOptions_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.bigquery.datatransfer.v1.DataSourceProto
            .internal_static_google_cloud_bigquery_datatransfer_v1_ImportedDataInfo_TableDefinition_CsvOptions_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition
                    .CsvOptions.class,
                com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition
                    .CsvOptions.Builder.class);
      }

      public static final int FIELD_DELIMITER_FIELD_NUMBER = 1;
      private com.google.protobuf.StringValue fieldDelimiter_;
      /**
       *
       *
       * <pre>
       * The delimiter.  We currently restrict this to U+0001 to U+00FF and
       * apply additional constraints during validation.
       * </pre>
       *
       * <code>.google.protobuf.StringValue field_delimiter = 1;</code>
       */
      public boolean hasFieldDelimiter() {
        return fieldDelimiter_ != null;
      }
      /**
       *
       *
       * <pre>
       * The delimiter.  We currently restrict this to U+0001 to U+00FF and
       * apply additional constraints during validation.
       * </pre>
       *
       * <code>.google.protobuf.StringValue field_delimiter = 1;</code>
       */
      public com.google.protobuf.StringValue getFieldDelimiter() {
        return fieldDelimiter_ == null
            ? com.google.protobuf.StringValue.getDefaultInstance()
            : fieldDelimiter_;
      }
      /**
       *
       *
       * <pre>
       * The delimiter.  We currently restrict this to U+0001 to U+00FF and
       * apply additional constraints during validation.
       * </pre>
       *
       * <code>.google.protobuf.StringValue field_delimiter = 1;</code>
       */
      public com.google.protobuf.StringValueOrBuilder getFieldDelimiterOrBuilder() {
        return getFieldDelimiter();
      }

      public static final int ALLOW_QUOTED_NEWLINES_FIELD_NUMBER = 2;
      private com.google.protobuf.BoolValue allowQuotedNewlines_;
      /**
       *
       *
       * <pre>
       * Whether CSV files are allowed to have quoted newlines. If quoted
       * newlines are allowed, we can't split CSV files.
       * </pre>
       *
       * <code>.google.protobuf.BoolValue allow_quoted_newlines = 2;</code>
       */
      public boolean hasAllowQuotedNewlines() {
        return allowQuotedNewlines_ != null;
      }
      /**
       *
       *
       * <pre>
       * Whether CSV files are allowed to have quoted newlines. If quoted
       * newlines are allowed, we can't split CSV files.
       * </pre>
       *
       * <code>.google.protobuf.BoolValue allow_quoted_newlines = 2;</code>
       */
      public com.google.protobuf.BoolValue getAllowQuotedNewlines() {
        return allowQuotedNewlines_ == null
            ? com.google.protobuf.BoolValue.getDefaultInstance()
            : allowQuotedNewlines_;
      }
      /**
       *
       *
       * <pre>
       * Whether CSV files are allowed to have quoted newlines. If quoted
       * newlines are allowed, we can't split CSV files.
       * </pre>
       *
       * <code>.google.protobuf.BoolValue allow_quoted_newlines = 2;</code>
       */
      public com.google.protobuf.BoolValueOrBuilder getAllowQuotedNewlinesOrBuilder() {
        return getAllowQuotedNewlines();
      }

      public static final int QUOTE_CHAR_FIELD_NUMBER = 3;
      private com.google.protobuf.StringValue quoteChar_;
      /**
       *
       *
       * <pre>
       * The quote character.  We currently restrict this to U+0000 to U+00FF
       * and apply additional constraints during validation. Set to '&#92;0' to
       * indicate no quote is used.
       * </pre>
       *
       * <code>.google.protobuf.StringValue quote_char = 3;</code>
       */
      public boolean hasQuoteChar() {
        return quoteChar_ != null;
      }
      /**
       *
       *
       * <pre>
       * The quote character.  We currently restrict this to U+0000 to U+00FF
       * and apply additional constraints during validation. Set to '&#92;0' to
       * indicate no quote is used.
       * </pre>
       *
       * <code>.google.protobuf.StringValue quote_char = 3;</code>
       */
      public com.google.protobuf.StringValue getQuoteChar() {
        return quoteChar_ == null
            ? com.google.protobuf.StringValue.getDefaultInstance()
            : quoteChar_;
      }
      /**
       *
       *
       * <pre>
       * The quote character.  We currently restrict this to U+0000 to U+00FF
       * and apply additional constraints during validation. Set to '&#92;0' to
       * indicate no quote is used.
       * </pre>
       *
       * <code>.google.protobuf.StringValue quote_char = 3;</code>
       */
      public com.google.protobuf.StringValueOrBuilder getQuoteCharOrBuilder() {
        return getQuoteChar();
      }

      public static final int SKIP_LEADING_ROWS_FIELD_NUMBER = 4;
      private com.google.protobuf.Int64Value skipLeadingRows_;
      /**
       *
       *
       * <pre>
       * Number of leading rows to skip.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value skip_leading_rows = 4;</code>
       */
      public boolean hasSkipLeadingRows() {
        return skipLeadingRows_ != null;
      }
      /**
       *
       *
       * <pre>
       * Number of leading rows to skip.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value skip_leading_rows = 4;</code>
       */
      public com.google.protobuf.Int64Value getSkipLeadingRows() {
        return skipLeadingRows_ == null
            ? com.google.protobuf.Int64Value.getDefaultInstance()
            : skipLeadingRows_;
      }
      /**
       *
       *
       * <pre>
       * Number of leading rows to skip.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value skip_leading_rows = 4;</code>
       */
      public com.google.protobuf.Int64ValueOrBuilder getSkipLeadingRowsOrBuilder() {
        return getSkipLeadingRows();
      }

      public static final int ALLOW_JAGGED_ROWS_FIELD_NUMBER = 5;
      private com.google.protobuf.BoolValue allowJaggedRows_;
      /**
       *
       *
       * <pre>
       * Accept rows that are missing trailing optional columns.
       * </pre>
       *
       * <code>.google.protobuf.BoolValue allow_jagged_rows = 5;</code>
       */
      public boolean hasAllowJaggedRows() {
        return allowJaggedRows_ != null;
      }
      /**
       *
       *
       * <pre>
       * Accept rows that are missing trailing optional columns.
       * </pre>
       *
       * <code>.google.protobuf.BoolValue allow_jagged_rows = 5;</code>
       */
      public com.google.protobuf.BoolValue getAllowJaggedRows() {
        return allowJaggedRows_ == null
            ? com.google.protobuf.BoolValue.getDefaultInstance()
            : allowJaggedRows_;
      }
      /**
       *
       *
       * <pre>
       * Accept rows that are missing trailing optional columns.
       * </pre>
       *
       * <code>.google.protobuf.BoolValue allow_jagged_rows = 5;</code>
       */
      public com.google.protobuf.BoolValueOrBuilder getAllowJaggedRowsOrBuilder() {
        return getAllowJaggedRows();
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (fieldDelimiter_ != null) {
          output.writeMessage(1, getFieldDelimiter());
        }
        if (allowQuotedNewlines_ != null) {
          output.writeMessage(2, getAllowQuotedNewlines());
        }
        if (quoteChar_ != null) {
          output.writeMessage(3, getQuoteChar());
        }
        if (skipLeadingRows_ != null) {
          output.writeMessage(4, getSkipLeadingRows());
        }
        if (allowJaggedRows_ != null) {
          output.writeMessage(5, getAllowJaggedRows());
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (fieldDelimiter_ != null) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getFieldDelimiter());
        }
        if (allowQuotedNewlines_ != null) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(2, getAllowQuotedNewlines());
        }
        if (quoteChar_ != null) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getQuoteChar());
        }
        if (skipLeadingRows_ != null) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getSkipLeadingRows());
        }
        if (allowJaggedRows_ != null) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getAllowJaggedRows());
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition
                .CsvOptions)) {
          return super.equals(obj);
        }
        com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition.CsvOptions
            other =
                (com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition
                        .CsvOptions)
                    obj;

        if (hasFieldDelimiter() != other.hasFieldDelimiter()) return false;
        if (hasFieldDelimiter()) {
          if (!getFieldDelimiter().equals(other.getFieldDelimiter())) return false;
        }
        if (hasAllowQuotedNewlines() != other.hasAllowQuotedNewlines()) return false;
        if (hasAllowQuotedNewlines()) {
          if (!getAllowQuotedNewlines().equals(other.getAllowQuotedNewlines())) return false;
        }
        if (hasQuoteChar() != other.hasQuoteChar()) return false;
        if (hasQuoteChar()) {
          if (!getQuoteChar().equals(other.getQuoteChar())) return false;
        }
        if (hasSkipLeadingRows() != other.hasSkipLeadingRows()) return false;
        if (hasSkipLeadingRows()) {
          if (!getSkipLeadingRows().equals(other.getSkipLeadingRows())) return false;
        }
        if (hasAllowJaggedRows() != other.hasAllowJaggedRows()) return false;
        if (hasAllowJaggedRows()) {
          if (!getAllowJaggedRows().equals(other.getAllowJaggedRows())) return false;
        }
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasFieldDelimiter()) {
          hash = (37 * hash) + FIELD_DELIMITER_FIELD_NUMBER;
          hash = (53 * hash) + getFieldDelimiter().hashCode();
        }
        if (hasAllowQuotedNewlines()) {
          hash = (37 * hash) + ALLOW_QUOTED_NEWLINES_FIELD_NUMBER;
          hash = (53 * hash) + getAllowQuotedNewlines().hashCode();
        }
        if (hasQuoteChar()) {
          hash = (37 * hash) + QUOTE_CHAR_FIELD_NUMBER;
          hash = (53 * hash) + getQuoteChar().hashCode();
        }
        if (hasSkipLeadingRows()) {
          hash = (37 * hash) + SKIP_LEADING_ROWS_FIELD_NUMBER;
          hash = (53 * hash) + getSkipLeadingRows().hashCode();
        }
        if (hasAllowJaggedRows()) {
          hash = (37 * hash) + ALLOW_JAGGED_ROWS_FIELD_NUMBER;
          hash = (53 * hash) + getAllowJaggedRows().hashCode();
        }
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition
              .CsvOptions
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition
              .CsvOptions
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition
              .CsvOptions
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition
              .CsvOptions
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition
              .CsvOptions
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition
              .CsvOptions
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition
              .CsvOptions
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition
              .CsvOptions
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition
              .CsvOptions
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition
              .CsvOptions
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition
              .CsvOptions
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition
              .CsvOptions
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition.CsvOptions
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * CSV specific options.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition.CsvOptions}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition.CsvOptions)
          com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition
              .CsvOptionsOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.bigquery.datatransfer.v1.DataSourceProto
              .internal_static_google_cloud_bigquery_datatransfer_v1_ImportedDataInfo_TableDefinition_CsvOptions_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.bigquery.datatransfer.v1.DataSourceProto
              .internal_static_google_cloud_bigquery_datatransfer_v1_ImportedDataInfo_TableDefinition_CsvOptions_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition
                      .CsvOptions.class,
                  com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition
                      .CsvOptions.Builder.class);
        }

        // Construct using
        // com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition.CsvOptions.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          if (fieldDelimiterBuilder_ == null) {
            fieldDelimiter_ = null;
          } else {
            fieldDelimiter_ = null;
            fieldDelimiterBuilder_ = null;
          }
          if (allowQuotedNewlinesBuilder_ == null) {
            allowQuotedNewlines_ = null;
          } else {
            allowQuotedNewlines_ = null;
            allowQuotedNewlinesBuilder_ = null;
          }
          if (quoteCharBuilder_ == null) {
            quoteChar_ = null;
          } else {
            quoteChar_ = null;
            quoteCharBuilder_ = null;
          }
          if (skipLeadingRowsBuilder_ == null) {
            skipLeadingRows_ = null;
          } else {
            skipLeadingRows_ = null;
            skipLeadingRowsBuilder_ = null;
          }
          if (allowJaggedRowsBuilder_ == null) {
            allowJaggedRows_ = null;
          } else {
            allowJaggedRows_ = null;
            allowJaggedRowsBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.bigquery.datatransfer.v1.DataSourceProto
              .internal_static_google_cloud_bigquery_datatransfer_v1_ImportedDataInfo_TableDefinition_CsvOptions_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition.CsvOptions
            getDefaultInstanceForType() {
          return com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition
              .CsvOptions.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition.CsvOptions
            build() {
          com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition.CsvOptions
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition.CsvOptions
            buildPartial() {
          com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition.CsvOptions
              result =
                  new com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition
                      .CsvOptions(this);
          if (fieldDelimiterBuilder_ == null) {
            result.fieldDelimiter_ = fieldDelimiter_;
          } else {
            result.fieldDelimiter_ = fieldDelimiterBuilder_.build();
          }
          if (allowQuotedNewlinesBuilder_ == null) {
            result.allowQuotedNewlines_ = allowQuotedNewlines_;
          } else {
            result.allowQuotedNewlines_ = allowQuotedNewlinesBuilder_.build();
          }
          if (quoteCharBuilder_ == null) {
            result.quoteChar_ = quoteChar_;
          } else {
            result.quoteChar_ = quoteCharBuilder_.build();
          }
          if (skipLeadingRowsBuilder_ == null) {
            result.skipLeadingRows_ = skipLeadingRows_;
          } else {
            result.skipLeadingRows_ = skipLeadingRowsBuilder_.build();
          }
          if (allowJaggedRowsBuilder_ == null) {
            result.allowJaggedRows_ = allowJaggedRows_;
          } else {
            result.allowJaggedRows_ = allowJaggedRowsBuilder_.build();
          }
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition
                  .CsvOptions) {
            return mergeFrom(
                (com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition
                        .CsvOptions)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition.CsvOptions
                other) {
          if (other
              == com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition
                  .CsvOptions.getDefaultInstance()) return this;
          if (other.hasFieldDelimiter()) {
            mergeFieldDelimiter(other.getFieldDelimiter());
          }
          if (other.hasAllowQuotedNewlines()) {
            mergeAllowQuotedNewlines(other.getAllowQuotedNewlines());
          }
          if (other.hasQuoteChar()) {
            mergeQuoteChar(other.getQuoteChar());
          }
          if (other.hasSkipLeadingRows()) {
            mergeSkipLeadingRows(other.getSkipLeadingRows());
          }
          if (other.hasAllowJaggedRows()) {
            mergeAllowJaggedRows(other.getAllowJaggedRows());
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition.CsvOptions
              parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage =
                (com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition
                        .CsvOptions)
                    e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }

        private com.google.protobuf.StringValue fieldDelimiter_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.StringValue,
                com.google.protobuf.StringValue.Builder,
                com.google.protobuf.StringValueOrBuilder>
            fieldDelimiterBuilder_;
        /**
         *
         *
         * <pre>
         * The delimiter.  We currently restrict this to U+0001 to U+00FF and
         * apply additional constraints during validation.
         * </pre>
         *
         * <code>.google.protobuf.StringValue field_delimiter = 1;</code>
         */
        public boolean hasFieldDelimiter() {
          return fieldDelimiterBuilder_ != null || fieldDelimiter_ != null;
        }
        /**
         *
         *
         * <pre>
         * The delimiter.  We currently restrict this to U+0001 to U+00FF and
         * apply additional constraints during validation.
         * </pre>
         *
         * <code>.google.protobuf.StringValue field_delimiter = 1;</code>
         */
        public com.google.protobuf.StringValue getFieldDelimiter() {
          if (fieldDelimiterBuilder_ == null) {
            return fieldDelimiter_ == null
                ? com.google.protobuf.StringValue.getDefaultInstance()
                : fieldDelimiter_;
          } else {
            return fieldDelimiterBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * The delimiter.  We currently restrict this to U+0001 to U+00FF and
         * apply additional constraints during validation.
         * </pre>
         *
         * <code>.google.protobuf.StringValue field_delimiter = 1;</code>
         */
        public Builder setFieldDelimiter(com.google.protobuf.StringValue value) {
          if (fieldDelimiterBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            fieldDelimiter_ = value;
            onChanged();
          } else {
            fieldDelimiterBuilder_.setMessage(value);
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * The delimiter.  We currently restrict this to U+0001 to U+00FF and
         * apply additional constraints during validation.
         * </pre>
         *
         * <code>.google.protobuf.StringValue field_delimiter = 1;</code>
         */
        public Builder setFieldDelimiter(com.google.protobuf.StringValue.Builder builderForValue) {
          if (fieldDelimiterBuilder_ == null) {
            fieldDelimiter_ = builderForValue.build();
            onChanged();
          } else {
            fieldDelimiterBuilder_.setMessage(builderForValue.build());
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * The delimiter.  We currently restrict this to U+0001 to U+00FF and
         * apply additional constraints during validation.
         * </pre>
         *
         * <code>.google.protobuf.StringValue field_delimiter = 1;</code>
         */
        public Builder mergeFieldDelimiter(com.google.protobuf.StringValue value) {
          if (fieldDelimiterBuilder_ == null) {
            if (fieldDelimiter_ != null) {
              fieldDelimiter_ =
                  com.google.protobuf.StringValue.newBuilder(fieldDelimiter_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              fieldDelimiter_ = value;
            }
            onChanged();
          } else {
            fieldDelimiterBuilder_.mergeFrom(value);
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * The delimiter.  We currently restrict this to U+0001 to U+00FF and
         * apply additional constraints during validation.
         * </pre>
         *
         * <code>.google.protobuf.StringValue field_delimiter = 1;</code>
         */
        public Builder clearFieldDelimiter() {
          if (fieldDelimiterBuilder_ == null) {
            fieldDelimiter_ = null;
            onChanged();
          } else {
            fieldDelimiter_ = null;
            fieldDelimiterBuilder_ = null;
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * The delimiter.  We currently restrict this to U+0001 to U+00FF and
         * apply additional constraints during validation.
         * </pre>
         *
         * <code>.google.protobuf.StringValue field_delimiter = 1;</code>
         */
        public com.google.protobuf.StringValue.Builder getFieldDelimiterBuilder() {

          onChanged();
          return getFieldDelimiterFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * The delimiter.  We currently restrict this to U+0001 to U+00FF and
         * apply additional constraints during validation.
         * </pre>
         *
         * <code>.google.protobuf.StringValue field_delimiter = 1;</code>
         */
        public com.google.protobuf.StringValueOrBuilder getFieldDelimiterOrBuilder() {
          if (fieldDelimiterBuilder_ != null) {
            return fieldDelimiterBuilder_.getMessageOrBuilder();
          } else {
            return fieldDelimiter_ == null
                ? com.google.protobuf.StringValue.getDefaultInstance()
                : fieldDelimiter_;
          }
        }
        /**
         *
         *
         * <pre>
         * The delimiter.  We currently restrict this to U+0001 to U+00FF and
         * apply additional constraints during validation.
         * </pre>
         *
         * <code>.google.protobuf.StringValue field_delimiter = 1;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.StringValue,
                com.google.protobuf.StringValue.Builder,
                com.google.protobuf.StringValueOrBuilder>
            getFieldDelimiterFieldBuilder() {
          if (fieldDelimiterBuilder_ == null) {
            fieldDelimiterBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.protobuf.StringValue,
                    com.google.protobuf.StringValue.Builder,
                    com.google.protobuf.StringValueOrBuilder>(
                    getFieldDelimiter(), getParentForChildren(), isClean());
            fieldDelimiter_ = null;
          }
          return fieldDelimiterBuilder_;
        }

        private com.google.protobuf.BoolValue allowQuotedNewlines_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.BoolValue,
                com.google.protobuf.BoolValue.Builder,
                com.google.protobuf.BoolValueOrBuilder>
            allowQuotedNewlinesBuilder_;
        /**
         *
         *
         * <pre>
         * Whether CSV files are allowed to have quoted newlines. If quoted
         * newlines are allowed, we can't split CSV files.
         * </pre>
         *
         * <code>.google.protobuf.BoolValue allow_quoted_newlines = 2;</code>
         */
        public boolean hasAllowQuotedNewlines() {
          return allowQuotedNewlinesBuilder_ != null || allowQuotedNewlines_ != null;
        }
        /**
         *
         *
         * <pre>
         * Whether CSV files are allowed to have quoted newlines. If quoted
         * newlines are allowed, we can't split CSV files.
         * </pre>
         *
         * <code>.google.protobuf.BoolValue allow_quoted_newlines = 2;</code>
         */
        public com.google.protobuf.BoolValue getAllowQuotedNewlines() {
          if (allowQuotedNewlinesBuilder_ == null) {
            return allowQuotedNewlines_ == null
                ? com.google.protobuf.BoolValue.getDefaultInstance()
                : allowQuotedNewlines_;
          } else {
            return allowQuotedNewlinesBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * Whether CSV files are allowed to have quoted newlines. If quoted
         * newlines are allowed, we can't split CSV files.
         * </pre>
         *
         * <code>.google.protobuf.BoolValue allow_quoted_newlines = 2;</code>
         */
        public Builder setAllowQuotedNewlines(com.google.protobuf.BoolValue value) {
          if (allowQuotedNewlinesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            allowQuotedNewlines_ = value;
            onChanged();
          } else {
            allowQuotedNewlinesBuilder_.setMessage(value);
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Whether CSV files are allowed to have quoted newlines. If quoted
         * newlines are allowed, we can't split CSV files.
         * </pre>
         *
         * <code>.google.protobuf.BoolValue allow_quoted_newlines = 2;</code>
         */
        public Builder setAllowQuotedNewlines(
            com.google.protobuf.BoolValue.Builder builderForValue) {
          if (allowQuotedNewlinesBuilder_ == null) {
            allowQuotedNewlines_ = builderForValue.build();
            onChanged();
          } else {
            allowQuotedNewlinesBuilder_.setMessage(builderForValue.build());
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Whether CSV files are allowed to have quoted newlines. If quoted
         * newlines are allowed, we can't split CSV files.
         * </pre>
         *
         * <code>.google.protobuf.BoolValue allow_quoted_newlines = 2;</code>
         */
        public Builder mergeAllowQuotedNewlines(com.google.protobuf.BoolValue value) {
          if (allowQuotedNewlinesBuilder_ == null) {
            if (allowQuotedNewlines_ != null) {
              allowQuotedNewlines_ =
                  com.google.protobuf.BoolValue.newBuilder(allowQuotedNewlines_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              allowQuotedNewlines_ = value;
            }
            onChanged();
          } else {
            allowQuotedNewlinesBuilder_.mergeFrom(value);
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Whether CSV files are allowed to have quoted newlines. If quoted
         * newlines are allowed, we can't split CSV files.
         * </pre>
         *
         * <code>.google.protobuf.BoolValue allow_quoted_newlines = 2;</code>
         */
        public Builder clearAllowQuotedNewlines() {
          if (allowQuotedNewlinesBuilder_ == null) {
            allowQuotedNewlines_ = null;
            onChanged();
          } else {
            allowQuotedNewlines_ = null;
            allowQuotedNewlinesBuilder_ = null;
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Whether CSV files are allowed to have quoted newlines. If quoted
         * newlines are allowed, we can't split CSV files.
         * </pre>
         *
         * <code>.google.protobuf.BoolValue allow_quoted_newlines = 2;</code>
         */
        public com.google.protobuf.BoolValue.Builder getAllowQuotedNewlinesBuilder() {

          onChanged();
          return getAllowQuotedNewlinesFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Whether CSV files are allowed to have quoted newlines. If quoted
         * newlines are allowed, we can't split CSV files.
         * </pre>
         *
         * <code>.google.protobuf.BoolValue allow_quoted_newlines = 2;</code>
         */
        public com.google.protobuf.BoolValueOrBuilder getAllowQuotedNewlinesOrBuilder() {
          if (allowQuotedNewlinesBuilder_ != null) {
            return allowQuotedNewlinesBuilder_.getMessageOrBuilder();
          } else {
            return allowQuotedNewlines_ == null
                ? com.google.protobuf.BoolValue.getDefaultInstance()
                : allowQuotedNewlines_;
          }
        }
        /**
         *
         *
         * <pre>
         * Whether CSV files are allowed to have quoted newlines. If quoted
         * newlines are allowed, we can't split CSV files.
         * </pre>
         *
         * <code>.google.protobuf.BoolValue allow_quoted_newlines = 2;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.BoolValue,
                com.google.protobuf.BoolValue.Builder,
                com.google.protobuf.BoolValueOrBuilder>
            getAllowQuotedNewlinesFieldBuilder() {
          if (allowQuotedNewlinesBuilder_ == null) {
            allowQuotedNewlinesBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.protobuf.BoolValue,
                    com.google.protobuf.BoolValue.Builder,
                    com.google.protobuf.BoolValueOrBuilder>(
                    getAllowQuotedNewlines(), getParentForChildren(), isClean());
            allowQuotedNewlines_ = null;
          }
          return allowQuotedNewlinesBuilder_;
        }

        private com.google.protobuf.StringValue quoteChar_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.StringValue,
                com.google.protobuf.StringValue.Builder,
                com.google.protobuf.StringValueOrBuilder>
            quoteCharBuilder_;
        /**
         *
         *
         * <pre>
         * The quote character.  We currently restrict this to U+0000 to U+00FF
         * and apply additional constraints during validation. Set to '&#92;0' to
         * indicate no quote is used.
         * </pre>
         *
         * <code>.google.protobuf.StringValue quote_char = 3;</code>
         */
        public boolean hasQuoteChar() {
          return quoteCharBuilder_ != null || quoteChar_ != null;
        }
        /**
         *
         *
         * <pre>
         * The quote character.  We currently restrict this to U+0000 to U+00FF
         * and apply additional constraints during validation. Set to '&#92;0' to
         * indicate no quote is used.
         * </pre>
         *
         * <code>.google.protobuf.StringValue quote_char = 3;</code>
         */
        public com.google.protobuf.StringValue getQuoteChar() {
          if (quoteCharBuilder_ == null) {
            return quoteChar_ == null
                ? com.google.protobuf.StringValue.getDefaultInstance()
                : quoteChar_;
          } else {
            return quoteCharBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * The quote character.  We currently restrict this to U+0000 to U+00FF
         * and apply additional constraints during validation. Set to '&#92;0' to
         * indicate no quote is used.
         * </pre>
         *
         * <code>.google.protobuf.StringValue quote_char = 3;</code>
         */
        public Builder setQuoteChar(com.google.protobuf.StringValue value) {
          if (quoteCharBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            quoteChar_ = value;
            onChanged();
          } else {
            quoteCharBuilder_.setMessage(value);
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * The quote character.  We currently restrict this to U+0000 to U+00FF
         * and apply additional constraints during validation. Set to '&#92;0' to
         * indicate no quote is used.
         * </pre>
         *
         * <code>.google.protobuf.StringValue quote_char = 3;</code>
         */
        public Builder setQuoteChar(com.google.protobuf.StringValue.Builder builderForValue) {
          if (quoteCharBuilder_ == null) {
            quoteChar_ = builderForValue.build();
            onChanged();
          } else {
            quoteCharBuilder_.setMessage(builderForValue.build());
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * The quote character.  We currently restrict this to U+0000 to U+00FF
         * and apply additional constraints during validation. Set to '&#92;0' to
         * indicate no quote is used.
         * </pre>
         *
         * <code>.google.protobuf.StringValue quote_char = 3;</code>
         */
        public Builder mergeQuoteChar(com.google.protobuf.StringValue value) {
          if (quoteCharBuilder_ == null) {
            if (quoteChar_ != null) {
              quoteChar_ =
                  com.google.protobuf.StringValue.newBuilder(quoteChar_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              quoteChar_ = value;
            }
            onChanged();
          } else {
            quoteCharBuilder_.mergeFrom(value);
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * The quote character.  We currently restrict this to U+0000 to U+00FF
         * and apply additional constraints during validation. Set to '&#92;0' to
         * indicate no quote is used.
         * </pre>
         *
         * <code>.google.protobuf.StringValue quote_char = 3;</code>
         */
        public Builder clearQuoteChar() {
          if (quoteCharBuilder_ == null) {
            quoteChar_ = null;
            onChanged();
          } else {
            quoteChar_ = null;
            quoteCharBuilder_ = null;
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * The quote character.  We currently restrict this to U+0000 to U+00FF
         * and apply additional constraints during validation. Set to '&#92;0' to
         * indicate no quote is used.
         * </pre>
         *
         * <code>.google.protobuf.StringValue quote_char = 3;</code>
         */
        public com.google.protobuf.StringValue.Builder getQuoteCharBuilder() {

          onChanged();
          return getQuoteCharFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * The quote character.  We currently restrict this to U+0000 to U+00FF
         * and apply additional constraints during validation. Set to '&#92;0' to
         * indicate no quote is used.
         * </pre>
         *
         * <code>.google.protobuf.StringValue quote_char = 3;</code>
         */
        public com.google.protobuf.StringValueOrBuilder getQuoteCharOrBuilder() {
          if (quoteCharBuilder_ != null) {
            return quoteCharBuilder_.getMessageOrBuilder();
          } else {
            return quoteChar_ == null
                ? com.google.protobuf.StringValue.getDefaultInstance()
                : quoteChar_;
          }
        }
        /**
         *
         *
         * <pre>
         * The quote character.  We currently restrict this to U+0000 to U+00FF
         * and apply additional constraints during validation. Set to '&#92;0' to
         * indicate no quote is used.
         * </pre>
         *
         * <code>.google.protobuf.StringValue quote_char = 3;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.StringValue,
                com.google.protobuf.StringValue.Builder,
                com.google.protobuf.StringValueOrBuilder>
            getQuoteCharFieldBuilder() {
          if (quoteCharBuilder_ == null) {
            quoteCharBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.protobuf.StringValue,
                    com.google.protobuf.StringValue.Builder,
                    com.google.protobuf.StringValueOrBuilder>(
                    getQuoteChar(), getParentForChildren(), isClean());
            quoteChar_ = null;
          }
          return quoteCharBuilder_;
        }

        private com.google.protobuf.Int64Value skipLeadingRows_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Int64Value,
                com.google.protobuf.Int64Value.Builder,
                com.google.protobuf.Int64ValueOrBuilder>
            skipLeadingRowsBuilder_;
        /**
         *
         *
         * <pre>
         * Number of leading rows to skip.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value skip_leading_rows = 4;</code>
         */
        public boolean hasSkipLeadingRows() {
          return skipLeadingRowsBuilder_ != null || skipLeadingRows_ != null;
        }
        /**
         *
         *
         * <pre>
         * Number of leading rows to skip.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value skip_leading_rows = 4;</code>
         */
        public com.google.protobuf.Int64Value getSkipLeadingRows() {
          if (skipLeadingRowsBuilder_ == null) {
            return skipLeadingRows_ == null
                ? com.google.protobuf.Int64Value.getDefaultInstance()
                : skipLeadingRows_;
          } else {
            return skipLeadingRowsBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * Number of leading rows to skip.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value skip_leading_rows = 4;</code>
         */
        public Builder setSkipLeadingRows(com.google.protobuf.Int64Value value) {
          if (skipLeadingRowsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            skipLeadingRows_ = value;
            onChanged();
          } else {
            skipLeadingRowsBuilder_.setMessage(value);
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Number of leading rows to skip.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value skip_leading_rows = 4;</code>
         */
        public Builder setSkipLeadingRows(com.google.protobuf.Int64Value.Builder builderForValue) {
          if (skipLeadingRowsBuilder_ == null) {
            skipLeadingRows_ = builderForValue.build();
            onChanged();
          } else {
            skipLeadingRowsBuilder_.setMessage(builderForValue.build());
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Number of leading rows to skip.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value skip_leading_rows = 4;</code>
         */
        public Builder mergeSkipLeadingRows(com.google.protobuf.Int64Value value) {
          if (skipLeadingRowsBuilder_ == null) {
            if (skipLeadingRows_ != null) {
              skipLeadingRows_ =
                  com.google.protobuf.Int64Value.newBuilder(skipLeadingRows_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              skipLeadingRows_ = value;
            }
            onChanged();
          } else {
            skipLeadingRowsBuilder_.mergeFrom(value);
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Number of leading rows to skip.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value skip_leading_rows = 4;</code>
         */
        public Builder clearSkipLeadingRows() {
          if (skipLeadingRowsBuilder_ == null) {
            skipLeadingRows_ = null;
            onChanged();
          } else {
            skipLeadingRows_ = null;
            skipLeadingRowsBuilder_ = null;
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Number of leading rows to skip.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value skip_leading_rows = 4;</code>
         */
        public com.google.protobuf.Int64Value.Builder getSkipLeadingRowsBuilder() {

          onChanged();
          return getSkipLeadingRowsFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Number of leading rows to skip.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value skip_leading_rows = 4;</code>
         */
        public com.google.protobuf.Int64ValueOrBuilder getSkipLeadingRowsOrBuilder() {
          if (skipLeadingRowsBuilder_ != null) {
            return skipLeadingRowsBuilder_.getMessageOrBuilder();
          } else {
            return skipLeadingRows_ == null
                ? com.google.protobuf.Int64Value.getDefaultInstance()
                : skipLeadingRows_;
          }
        }
        /**
         *
         *
         * <pre>
         * Number of leading rows to skip.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value skip_leading_rows = 4;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Int64Value,
                com.google.protobuf.Int64Value.Builder,
                com.google.protobuf.Int64ValueOrBuilder>
            getSkipLeadingRowsFieldBuilder() {
          if (skipLeadingRowsBuilder_ == null) {
            skipLeadingRowsBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.protobuf.Int64Value,
                    com.google.protobuf.Int64Value.Builder,
                    com.google.protobuf.Int64ValueOrBuilder>(
                    getSkipLeadingRows(), getParentForChildren(), isClean());
            skipLeadingRows_ = null;
          }
          return skipLeadingRowsBuilder_;
        }

        private com.google.protobuf.BoolValue allowJaggedRows_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.BoolValue,
                com.google.protobuf.BoolValue.Builder,
                com.google.protobuf.BoolValueOrBuilder>
            allowJaggedRowsBuilder_;
        /**
         *
         *
         * <pre>
         * Accept rows that are missing trailing optional columns.
         * </pre>
         *
         * <code>.google.protobuf.BoolValue allow_jagged_rows = 5;</code>
         */
        public boolean hasAllowJaggedRows() {
          return allowJaggedRowsBuilder_ != null || allowJaggedRows_ != null;
        }
        /**
         *
         *
         * <pre>
         * Accept rows that are missing trailing optional columns.
         * </pre>
         *
         * <code>.google.protobuf.BoolValue allow_jagged_rows = 5;</code>
         */
        public com.google.protobuf.BoolValue getAllowJaggedRows() {
          if (allowJaggedRowsBuilder_ == null) {
            return allowJaggedRows_ == null
                ? com.google.protobuf.BoolValue.getDefaultInstance()
                : allowJaggedRows_;
          } else {
            return allowJaggedRowsBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * Accept rows that are missing trailing optional columns.
         * </pre>
         *
         * <code>.google.protobuf.BoolValue allow_jagged_rows = 5;</code>
         */
        public Builder setAllowJaggedRows(com.google.protobuf.BoolValue value) {
          if (allowJaggedRowsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            allowJaggedRows_ = value;
            onChanged();
          } else {
            allowJaggedRowsBuilder_.setMessage(value);
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Accept rows that are missing trailing optional columns.
         * </pre>
         *
         * <code>.google.protobuf.BoolValue allow_jagged_rows = 5;</code>
         */
        public Builder setAllowJaggedRows(com.google.protobuf.BoolValue.Builder builderForValue) {
          if (allowJaggedRowsBuilder_ == null) {
            allowJaggedRows_ = builderForValue.build();
            onChanged();
          } else {
            allowJaggedRowsBuilder_.setMessage(builderForValue.build());
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Accept rows that are missing trailing optional columns.
         * </pre>
         *
         * <code>.google.protobuf.BoolValue allow_jagged_rows = 5;</code>
         */
        public Builder mergeAllowJaggedRows(com.google.protobuf.BoolValue value) {
          if (allowJaggedRowsBuilder_ == null) {
            if (allowJaggedRows_ != null) {
              allowJaggedRows_ =
                  com.google.protobuf.BoolValue.newBuilder(allowJaggedRows_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              allowJaggedRows_ = value;
            }
            onChanged();
          } else {
            allowJaggedRowsBuilder_.mergeFrom(value);
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Accept rows that are missing trailing optional columns.
         * </pre>
         *
         * <code>.google.protobuf.BoolValue allow_jagged_rows = 5;</code>
         */
        public Builder clearAllowJaggedRows() {
          if (allowJaggedRowsBuilder_ == null) {
            allowJaggedRows_ = null;
            onChanged();
          } else {
            allowJaggedRows_ = null;
            allowJaggedRowsBuilder_ = null;
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Accept rows that are missing trailing optional columns.
         * </pre>
         *
         * <code>.google.protobuf.BoolValue allow_jagged_rows = 5;</code>
         */
        public com.google.protobuf.BoolValue.Builder getAllowJaggedRowsBuilder() {

          onChanged();
          return getAllowJaggedRowsFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Accept rows that are missing trailing optional columns.
         * </pre>
         *
         * <code>.google.protobuf.BoolValue allow_jagged_rows = 5;</code>
         */
        public com.google.protobuf.BoolValueOrBuilder getAllowJaggedRowsOrBuilder() {
          if (allowJaggedRowsBuilder_ != null) {
            return allowJaggedRowsBuilder_.getMessageOrBuilder();
          } else {
            return allowJaggedRows_ == null
                ? com.google.protobuf.BoolValue.getDefaultInstance()
                : allowJaggedRows_;
          }
        }
        /**
         *
         *
         * <pre>
         * Accept rows that are missing trailing optional columns.
         * </pre>
         *
         * <code>.google.protobuf.BoolValue allow_jagged_rows = 5;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.BoolValue,
                com.google.protobuf.BoolValue.Builder,
                com.google.protobuf.BoolValueOrBuilder>
            getAllowJaggedRowsFieldBuilder() {
          if (allowJaggedRowsBuilder_ == null) {
            allowJaggedRowsBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.protobuf.BoolValue,
                    com.google.protobuf.BoolValue.Builder,
                    com.google.protobuf.BoolValueOrBuilder>(
                    getAllowJaggedRows(), getParentForChildren(), isClean());
            allowJaggedRows_ = null;
          }
          return allowJaggedRowsBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition.CsvOptions)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition.CsvOptions)
      private static final com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo
              .TableDefinition.CsvOptions
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition
                .CsvOptions();
      }

      public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition
              .CsvOptions
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<CsvOptions> PARSER =
          new com.google.protobuf.AbstractParser<CsvOptions>() {
            @java.lang.Override
            public CsvOptions parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              return new CsvOptions(input, extensionRegistry);
            }
          };

      public static com.google.protobuf.Parser<CsvOptions> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<CsvOptions> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition.CsvOptions
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int TABLE_ID_FIELD_NUMBER = 1;
    private volatile java.lang.Object tableId_;
    /**
     *
     *
     * <pre>
     * BigQuery table_id (required). This will be used to reference this
     * table in the query.
     * </pre>
     *
     * <code>string table_id = 1;</code>
     */
    public java.lang.String getTableId() {
      java.lang.Object ref = tableId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        tableId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * BigQuery table_id (required). This will be used to reference this
     * table in the query.
     * </pre>
     *
     * <code>string table_id = 1;</code>
     */
    public com.google.protobuf.ByteString getTableIdBytes() {
      java.lang.Object ref = tableId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        tableId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SOURCE_URIS_FIELD_NUMBER = 2;
    private com.google.protobuf.LazyStringList sourceUris_;
    /**
     *
     *
     * <pre>
     * URIs for the data to be imported. All URIs must be from the same storage
     * system.
     * </pre>
     *
     * <code>repeated string source_uris = 2;</code>
     */
    public com.google.protobuf.ProtocolStringList getSourceUrisList() {
      return sourceUris_;
    }
    /**
     *
     *
     * <pre>
     * URIs for the data to be imported. All URIs must be from the same storage
     * system.
     * </pre>
     *
     * <code>repeated string source_uris = 2;</code>
     */
    public int getSourceUrisCount() {
      return sourceUris_.size();
    }
    /**
     *
     *
     * <pre>
     * URIs for the data to be imported. All URIs must be from the same storage
     * system.
     * </pre>
     *
     * <code>repeated string source_uris = 2;</code>
     */
    public java.lang.String getSourceUris(int index) {
      return sourceUris_.get(index);
    }
    /**
     *
     *
     * <pre>
     * URIs for the data to be imported. All URIs must be from the same storage
     * system.
     * </pre>
     *
     * <code>repeated string source_uris = 2;</code>
     */
    public com.google.protobuf.ByteString getSourceUrisBytes(int index) {
      return sourceUris_.getByteString(index);
    }

    public static final int FORMAT_FIELD_NUMBER = 3;
    private int format_;
    /**
     *
     *
     * <pre>
     * Describes the format of the data in source_uri.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.Format format = 3;</code>
     */
    public int getFormatValue() {
      return format_;
    }
    /**
     *
     *
     * <pre>
     * Describes the format of the data in source_uri.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.Format format = 3;</code>
     */
    public com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.Format getFormat() {
      @SuppressWarnings("deprecation")
      com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.Format result =
          com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.Format.valueOf(format_);
      return result == null
          ? com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.Format.UNRECOGNIZED
          : result;
    }

    public static final int MAX_BAD_RECORDS_FIELD_NUMBER = 4;
    private int maxBadRecords_;
    /**
     *
     *
     * <pre>
     * Specify the maximum number of bad records that can be ignored.
     * If bad records exceed this threshold the query is aborted.
     * </pre>
     *
     * <code>int32 max_bad_records = 4;</code>
     */
    public int getMaxBadRecords() {
      return maxBadRecords_;
    }

    public static final int ENCODING_FIELD_NUMBER = 5;
    private int encoding_;
    /**
     *
     *
     * <pre>
     * Character encoding of the input when applicable (CSV, JSON).
     * Defaults to UTF8.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.Encoding encoding = 5;</code>
     */
    public int getEncodingValue() {
      return encoding_;
    }
    /**
     *
     *
     * <pre>
     * Character encoding of the input when applicable (CSV, JSON).
     * Defaults to UTF8.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.Encoding encoding = 5;</code>
     */
    public com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.Encoding getEncoding() {
      @SuppressWarnings("deprecation")
      com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.Encoding result =
          com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.Encoding.valueOf(encoding_);
      return result == null
          ? com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.Encoding.UNRECOGNIZED
          : result;
    }

    public static final int CSV_OPTIONS_FIELD_NUMBER = 6;
    private com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition.CsvOptions
        csvOptions_;
    /**
     *
     *
     * <pre>
     * CSV specific options.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition.CsvOptions csv_options = 6;
     * </code>
     */
    public boolean hasCsvOptions() {
      return csvOptions_ != null;
    }
    /**
     *
     *
     * <pre>
     * CSV specific options.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition.CsvOptions csv_options = 6;
     * </code>
     */
    public com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition.CsvOptions
        getCsvOptions() {
      return csvOptions_ == null
          ? com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition.CsvOptions
              .getDefaultInstance()
          : csvOptions_;
    }
    /**
     *
     *
     * <pre>
     * CSV specific options.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition.CsvOptions csv_options = 6;
     * </code>
     */
    public com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition
            .CsvOptionsOrBuilder
        getCsvOptionsOrBuilder() {
      return getCsvOptions();
    }

    public static final int SCHEMA_FIELD_NUMBER = 7;
    private com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema schema_;
    /**
     *
     *
     * <pre>
     * Optional schema for the data. When not specified for JSON and CSV formats
     * we will try to detect it automatically.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema schema = 7;</code>
     */
    public boolean hasSchema() {
      return schema_ != null;
    }
    /**
     *
     *
     * <pre>
     * Optional schema for the data. When not specified for JSON and CSV formats
     * we will try to detect it automatically.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema schema = 7;</code>
     */
    public com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema getSchema() {
      return schema_ == null
          ? com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema
              .getDefaultInstance()
          : schema_;
    }
    /**
     *
     *
     * <pre>
     * Optional schema for the data. When not specified for JSON and CSV formats
     * we will try to detect it automatically.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema schema = 7;</code>
     */
    public com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchemaOrBuilder
        getSchemaOrBuilder() {
      return getSchema();
    }

    public static final int IGNORE_UNKNOWN_VALUES_FIELD_NUMBER = 10;
    private com.google.protobuf.BoolValue ignoreUnknownValues_;
    /**
     *
     *
     * <pre>
     * Indicates if extra values that are not represented in the table schema is
     * allowed.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue ignore_unknown_values = 10;</code>
     */
    public boolean hasIgnoreUnknownValues() {
      return ignoreUnknownValues_ != null;
    }
    /**
     *
     *
     * <pre>
     * Indicates if extra values that are not represented in the table schema is
     * allowed.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue ignore_unknown_values = 10;</code>
     */
    public com.google.protobuf.BoolValue getIgnoreUnknownValues() {
      return ignoreUnknownValues_ == null
          ? com.google.protobuf.BoolValue.getDefaultInstance()
          : ignoreUnknownValues_;
    }
    /**
     *
     *
     * <pre>
     * Indicates if extra values that are not represented in the table schema is
     * allowed.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue ignore_unknown_values = 10;</code>
     */
    public com.google.protobuf.BoolValueOrBuilder getIgnoreUnknownValuesOrBuilder() {
      return getIgnoreUnknownValues();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!getTableIdBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, tableId_);
      }
      for (int i = 0; i < sourceUris_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, sourceUris_.getRaw(i));
      }
      if (format_
          != com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.Format.FORMAT_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(3, format_);
      }
      if (maxBadRecords_ != 0) {
        output.writeInt32(4, maxBadRecords_);
      }
      if (encoding_
          != com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.Encoding
              .ENCODING_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(5, encoding_);
      }
      if (csvOptions_ != null) {
        output.writeMessage(6, getCsvOptions());
      }
      if (schema_ != null) {
        output.writeMessage(7, getSchema());
      }
      if (ignoreUnknownValues_ != null) {
        output.writeMessage(10, getIgnoreUnknownValues());
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getTableIdBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, tableId_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < sourceUris_.size(); i++) {
          dataSize += computeStringSizeNoTag(sourceUris_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getSourceUrisList().size();
      }
      if (format_
          != com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.Format.FORMAT_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, format_);
      }
      if (maxBadRecords_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, maxBadRecords_);
      }
      if (encoding_
          != com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.Encoding
              .ENCODING_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, encoding_);
      }
      if (csvOptions_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getCsvOptions());
      }
      if (schema_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getSchema());
      }
      if (ignoreUnknownValues_ != null) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(10, getIgnoreUnknownValues());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition)) {
        return super.equals(obj);
      }
      com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition other =
          (com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition) obj;

      if (!getTableId().equals(other.getTableId())) return false;
      if (!getSourceUrisList().equals(other.getSourceUrisList())) return false;
      if (format_ != other.format_) return false;
      if (getMaxBadRecords() != other.getMaxBadRecords()) return false;
      if (encoding_ != other.encoding_) return false;
      if (hasCsvOptions() != other.hasCsvOptions()) return false;
      if (hasCsvOptions()) {
        if (!getCsvOptions().equals(other.getCsvOptions())) return false;
      }
      if (hasSchema() != other.hasSchema()) return false;
      if (hasSchema()) {
        if (!getSchema().equals(other.getSchema())) return false;
      }
      if (hasIgnoreUnknownValues() != other.hasIgnoreUnknownValues()) return false;
      if (hasIgnoreUnknownValues()) {
        if (!getIgnoreUnknownValues().equals(other.getIgnoreUnknownValues())) return false;
      }
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TABLE_ID_FIELD_NUMBER;
      hash = (53 * hash) + getTableId().hashCode();
      if (getSourceUrisCount() > 0) {
        hash = (37 * hash) + SOURCE_URIS_FIELD_NUMBER;
        hash = (53 * hash) + getSourceUrisList().hashCode();
      }
      hash = (37 * hash) + FORMAT_FIELD_NUMBER;
      hash = (53 * hash) + format_;
      hash = (37 * hash) + MAX_BAD_RECORDS_FIELD_NUMBER;
      hash = (53 * hash) + getMaxBadRecords();
      hash = (37 * hash) + ENCODING_FIELD_NUMBER;
      hash = (53 * hash) + encoding_;
      if (hasCsvOptions()) {
        hash = (37 * hash) + CSV_OPTIONS_FIELD_NUMBER;
        hash = (53 * hash) + getCsvOptions().hashCode();
      }
      if (hasSchema()) {
        hash = (37 * hash) + SCHEMA_FIELD_NUMBER;
        hash = (53 * hash) + getSchema().hashCode();
      }
      if (hasIgnoreUnknownValues()) {
        hash = (37 * hash) + IGNORE_UNKNOWN_VALUES_FIELD_NUMBER;
        hash = (53 * hash) + getIgnoreUnknownValues().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * External table definition. These tables can be referenced with 'name'
     * in the query and can be read just like any other table.
     * </pre>
     *
     * Protobuf type {@code google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition)
        com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinitionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.bigquery.datatransfer.v1.DataSourceProto
            .internal_static_google_cloud_bigquery_datatransfer_v1_ImportedDataInfo_TableDefinition_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.bigquery.datatransfer.v1.DataSourceProto
            .internal_static_google_cloud_bigquery_datatransfer_v1_ImportedDataInfo_TableDefinition_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition.class,
                com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        tableId_ = "";

        sourceUris_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000002);
        format_ = 0;

        maxBadRecords_ = 0;

        encoding_ = 0;

        if (csvOptionsBuilder_ == null) {
          csvOptions_ = null;
        } else {
          csvOptions_ = null;
          csvOptionsBuilder_ = null;
        }
        if (schemaBuilder_ == null) {
          schema_ = null;
        } else {
          schema_ = null;
          schemaBuilder_ = null;
        }
        if (ignoreUnknownValuesBuilder_ == null) {
          ignoreUnknownValues_ = null;
        } else {
          ignoreUnknownValues_ = null;
          ignoreUnknownValuesBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.bigquery.datatransfer.v1.DataSourceProto
            .internal_static_google_cloud_bigquery_datatransfer_v1_ImportedDataInfo_TableDefinition_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition
          getDefaultInstanceForType() {
        return com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition build() {
        com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition
          buildPartial() {
        com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition result =
            new com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        result.tableId_ = tableId_;
        if (((bitField0_ & 0x00000002) != 0)) {
          sourceUris_ = sourceUris_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.sourceUris_ = sourceUris_;
        result.format_ = format_;
        result.maxBadRecords_ = maxBadRecords_;
        result.encoding_ = encoding_;
        if (csvOptionsBuilder_ == null) {
          result.csvOptions_ = csvOptions_;
        } else {
          result.csvOptions_ = csvOptionsBuilder_.build();
        }
        if (schemaBuilder_ == null) {
          result.schema_ = schema_;
        } else {
          result.schema_ = schemaBuilder_.build();
        }
        if (ignoreUnknownValuesBuilder_ == null) {
          result.ignoreUnknownValues_ = ignoreUnknownValues_;
        } else {
          result.ignoreUnknownValues_ = ignoreUnknownValuesBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition) {
          return mergeFrom(
              (com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition other) {
        if (other
            == com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition
                .getDefaultInstance()) return this;
        if (!other.getTableId().isEmpty()) {
          tableId_ = other.tableId_;
          onChanged();
        }
        if (!other.sourceUris_.isEmpty()) {
          if (sourceUris_.isEmpty()) {
            sourceUris_ = other.sourceUris_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureSourceUrisIsMutable();
            sourceUris_.addAll(other.sourceUris_);
          }
          onChanged();
        }
        if (other.format_ != 0) {
          setFormatValue(other.getFormatValue());
        }
        if (other.getMaxBadRecords() != 0) {
          setMaxBadRecords(other.getMaxBadRecords());
        }
        if (other.encoding_ != 0) {
          setEncodingValue(other.getEncodingValue());
        }
        if (other.hasCsvOptions()) {
          mergeCsvOptions(other.getCsvOptions());
        }
        if (other.hasSchema()) {
          mergeSchema(other.getSchema());
        }
        if (other.hasIgnoreUnknownValues()) {
          mergeIgnoreUnknownValues(other.getIgnoreUnknownValues());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition parsedMessage =
            null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private java.lang.Object tableId_ = "";
      /**
       *
       *
       * <pre>
       * BigQuery table_id (required). This will be used to reference this
       * table in the query.
       * </pre>
       *
       * <code>string table_id = 1;</code>
       */
      public java.lang.String getTableId() {
        java.lang.Object ref = tableId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          tableId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * BigQuery table_id (required). This will be used to reference this
       * table in the query.
       * </pre>
       *
       * <code>string table_id = 1;</code>
       */
      public com.google.protobuf.ByteString getTableIdBytes() {
        java.lang.Object ref = tableId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          tableId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * BigQuery table_id (required). This will be used to reference this
       * table in the query.
       * </pre>
       *
       * <code>string table_id = 1;</code>
       */
      public Builder setTableId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        tableId_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * BigQuery table_id (required). This will be used to reference this
       * table in the query.
       * </pre>
       *
       * <code>string table_id = 1;</code>
       */
      public Builder clearTableId() {

        tableId_ = getDefaultInstance().getTableId();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * BigQuery table_id (required). This will be used to reference this
       * table in the query.
       * </pre>
       *
       * <code>string table_id = 1;</code>
       */
      public Builder setTableIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        tableId_ = value;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringList sourceUris_ =
          com.google.protobuf.LazyStringArrayList.EMPTY;

      private void ensureSourceUrisIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          sourceUris_ = new com.google.protobuf.LazyStringArrayList(sourceUris_);
          bitField0_ |= 0x00000002;
        }
      }
      /**
       *
       *
       * <pre>
       * URIs for the data to be imported. All URIs must be from the same storage
       * system.
       * </pre>
       *
       * <code>repeated string source_uris = 2;</code>
       */
      public com.google.protobuf.ProtocolStringList getSourceUrisList() {
        return sourceUris_.getUnmodifiableView();
      }
      /**
       *
       *
       * <pre>
       * URIs for the data to be imported. All URIs must be from the same storage
       * system.
       * </pre>
       *
       * <code>repeated string source_uris = 2;</code>
       */
      public int getSourceUrisCount() {
        return sourceUris_.size();
      }
      /**
       *
       *
       * <pre>
       * URIs for the data to be imported. All URIs must be from the same storage
       * system.
       * </pre>
       *
       * <code>repeated string source_uris = 2;</code>
       */
      public java.lang.String getSourceUris(int index) {
        return sourceUris_.get(index);
      }
      /**
       *
       *
       * <pre>
       * URIs for the data to be imported. All URIs must be from the same storage
       * system.
       * </pre>
       *
       * <code>repeated string source_uris = 2;</code>
       */
      public com.google.protobuf.ByteString getSourceUrisBytes(int index) {
        return sourceUris_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * URIs for the data to be imported. All URIs must be from the same storage
       * system.
       * </pre>
       *
       * <code>repeated string source_uris = 2;</code>
       */
      public Builder setSourceUris(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSourceUrisIsMutable();
        sourceUris_.set(index, value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * URIs for the data to be imported. All URIs must be from the same storage
       * system.
       * </pre>
       *
       * <code>repeated string source_uris = 2;</code>
       */
      public Builder addSourceUris(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSourceUrisIsMutable();
        sourceUris_.add(value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * URIs for the data to be imported. All URIs must be from the same storage
       * system.
       * </pre>
       *
       * <code>repeated string source_uris = 2;</code>
       */
      public Builder addAllSourceUris(java.lang.Iterable<java.lang.String> values) {
        ensureSourceUrisIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, sourceUris_);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * URIs for the data to be imported. All URIs must be from the same storage
       * system.
       * </pre>
       *
       * <code>repeated string source_uris = 2;</code>
       */
      public Builder clearSourceUris() {
        sourceUris_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * URIs for the data to be imported. All URIs must be from the same storage
       * system.
       * </pre>
       *
       * <code>repeated string source_uris = 2;</code>
       */
      public Builder addSourceUrisBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureSourceUrisIsMutable();
        sourceUris_.add(value);
        onChanged();
        return this;
      }

      private int format_ = 0;
      /**
       *
       *
       * <pre>
       * Describes the format of the data in source_uri.
       * </pre>
       *
       * <code>.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.Format format = 3;</code>
       */
      public int getFormatValue() {
        return format_;
      }
      /**
       *
       *
       * <pre>
       * Describes the format of the data in source_uri.
       * </pre>
       *
       * <code>.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.Format format = 3;</code>
       */
      public Builder setFormatValue(int value) {
        format_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Describes the format of the data in source_uri.
       * </pre>
       *
       * <code>.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.Format format = 3;</code>
       */
      public com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.Format getFormat() {
        @SuppressWarnings("deprecation")
        com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.Format result =
            com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.Format.valueOf(format_);
        return result == null
            ? com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.Format.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Describes the format of the data in source_uri.
       * </pre>
       *
       * <code>.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.Format format = 3;</code>
       */
      public Builder setFormat(
          com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.Format value) {
        if (value == null) {
          throw new NullPointerException();
        }

        format_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Describes the format of the data in source_uri.
       * </pre>
       *
       * <code>.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.Format format = 3;</code>
       */
      public Builder clearFormat() {

        format_ = 0;
        onChanged();
        return this;
      }

      private int maxBadRecords_;
      /**
       *
       *
       * <pre>
       * Specify the maximum number of bad records that can be ignored.
       * If bad records exceed this threshold the query is aborted.
       * </pre>
       *
       * <code>int32 max_bad_records = 4;</code>
       */
      public int getMaxBadRecords() {
        return maxBadRecords_;
      }
      /**
       *
       *
       * <pre>
       * Specify the maximum number of bad records that can be ignored.
       * If bad records exceed this threshold the query is aborted.
       * </pre>
       *
       * <code>int32 max_bad_records = 4;</code>
       */
      public Builder setMaxBadRecords(int value) {

        maxBadRecords_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specify the maximum number of bad records that can be ignored.
       * If bad records exceed this threshold the query is aborted.
       * </pre>
       *
       * <code>int32 max_bad_records = 4;</code>
       */
      public Builder clearMaxBadRecords() {

        maxBadRecords_ = 0;
        onChanged();
        return this;
      }

      private int encoding_ = 0;
      /**
       *
       *
       * <pre>
       * Character encoding of the input when applicable (CSV, JSON).
       * Defaults to UTF8.
       * </pre>
       *
       * <code>.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.Encoding encoding = 5;</code>
       */
      public int getEncodingValue() {
        return encoding_;
      }
      /**
       *
       *
       * <pre>
       * Character encoding of the input when applicable (CSV, JSON).
       * Defaults to UTF8.
       * </pre>
       *
       * <code>.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.Encoding encoding = 5;</code>
       */
      public Builder setEncodingValue(int value) {
        encoding_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Character encoding of the input when applicable (CSV, JSON).
       * Defaults to UTF8.
       * </pre>
       *
       * <code>.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.Encoding encoding = 5;</code>
       */
      public com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.Encoding getEncoding() {
        @SuppressWarnings("deprecation")
        com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.Encoding result =
            com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.Encoding.valueOf(encoding_);
        return result == null
            ? com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.Encoding.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Character encoding of the input when applicable (CSV, JSON).
       * Defaults to UTF8.
       * </pre>
       *
       * <code>.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.Encoding encoding = 5;</code>
       */
      public Builder setEncoding(
          com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.Encoding value) {
        if (value == null) {
          throw new NullPointerException();
        }

        encoding_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Character encoding of the input when applicable (CSV, JSON).
       * Defaults to UTF8.
       * </pre>
       *
       * <code>.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.Encoding encoding = 5;</code>
       */
      public Builder clearEncoding() {

        encoding_ = 0;
        onChanged();
        return this;
      }

      private com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition.CsvOptions
          csvOptions_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition.CsvOptions,
              com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition.CsvOptions
                  .Builder,
              com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition
                  .CsvOptionsOrBuilder>
          csvOptionsBuilder_;
      /**
       *
       *
       * <pre>
       * CSV specific options.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition.CsvOptions csv_options = 6;
       * </code>
       */
      public boolean hasCsvOptions() {
        return csvOptionsBuilder_ != null || csvOptions_ != null;
      }
      /**
       *
       *
       * <pre>
       * CSV specific options.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition.CsvOptions csv_options = 6;
       * </code>
       */
      public com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition.CsvOptions
          getCsvOptions() {
        if (csvOptionsBuilder_ == null) {
          return csvOptions_ == null
              ? com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition
                  .CsvOptions.getDefaultInstance()
              : csvOptions_;
        } else {
          return csvOptionsBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * CSV specific options.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition.CsvOptions csv_options = 6;
       * </code>
       */
      public Builder setCsvOptions(
          com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition.CsvOptions
              value) {
        if (csvOptionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          csvOptions_ = value;
          onChanged();
        } else {
          csvOptionsBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * CSV specific options.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition.CsvOptions csv_options = 6;
       * </code>
       */
      public Builder setCsvOptions(
          com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition.CsvOptions
                  .Builder
              builderForValue) {
        if (csvOptionsBuilder_ == null) {
          csvOptions_ = builderForValue.build();
          onChanged();
        } else {
          csvOptionsBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * CSV specific options.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition.CsvOptions csv_options = 6;
       * </code>
       */
      public Builder mergeCsvOptions(
          com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition.CsvOptions
              value) {
        if (csvOptionsBuilder_ == null) {
          if (csvOptions_ != null) {
            csvOptions_ =
                com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition
                    .CsvOptions.newBuilder(csvOptions_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            csvOptions_ = value;
          }
          onChanged();
        } else {
          csvOptionsBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * CSV specific options.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition.CsvOptions csv_options = 6;
       * </code>
       */
      public Builder clearCsvOptions() {
        if (csvOptionsBuilder_ == null) {
          csvOptions_ = null;
          onChanged();
        } else {
          csvOptions_ = null;
          csvOptionsBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * CSV specific options.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition.CsvOptions csv_options = 6;
       * </code>
       */
      public com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition.CsvOptions
              .Builder
          getCsvOptionsBuilder() {

        onChanged();
        return getCsvOptionsFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * CSV specific options.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition.CsvOptions csv_options = 6;
       * </code>
       */
      public com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition
              .CsvOptionsOrBuilder
          getCsvOptionsOrBuilder() {
        if (csvOptionsBuilder_ != null) {
          return csvOptionsBuilder_.getMessageOrBuilder();
        } else {
          return csvOptions_ == null
              ? com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition
                  .CsvOptions.getDefaultInstance()
              : csvOptions_;
        }
      }
      /**
       *
       *
       * <pre>
       * CSV specific options.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition.CsvOptions csv_options = 6;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition.CsvOptions,
              com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition.CsvOptions
                  .Builder,
              com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition
                  .CsvOptionsOrBuilder>
          getCsvOptionsFieldBuilder() {
        if (csvOptionsBuilder_ == null) {
          csvOptionsBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition
                      .CsvOptions,
                  com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition
                      .CsvOptions.Builder,
                  com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition
                      .CsvOptionsOrBuilder>(getCsvOptions(), getParentForChildren(), isClean());
          csvOptions_ = null;
        }
        return csvOptionsBuilder_;
      }

      private com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema schema_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema,
              com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema.Builder,
              com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchemaOrBuilder>
          schemaBuilder_;
      /**
       *
       *
       * <pre>
       * Optional schema for the data. When not specified for JSON and CSV formats
       * we will try to detect it automatically.
       * </pre>
       *
       * <code>.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema schema = 7;
       * </code>
       */
      public boolean hasSchema() {
        return schemaBuilder_ != null || schema_ != null;
      }
      /**
       *
       *
       * <pre>
       * Optional schema for the data. When not specified for JSON and CSV formats
       * we will try to detect it automatically.
       * </pre>
       *
       * <code>.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema schema = 7;
       * </code>
       */
      public com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema getSchema() {
        if (schemaBuilder_ == null) {
          return schema_ == null
              ? com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema
                  .getDefaultInstance()
              : schema_;
        } else {
          return schemaBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional schema for the data. When not specified for JSON and CSV formats
       * we will try to detect it automatically.
       * </pre>
       *
       * <code>.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema schema = 7;
       * </code>
       */
      public Builder setSchema(
          com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema value) {
        if (schemaBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          schema_ = value;
          onChanged();
        } else {
          schemaBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional schema for the data. When not specified for JSON and CSV formats
       * we will try to detect it automatically.
       * </pre>
       *
       * <code>.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema schema = 7;
       * </code>
       */
      public Builder setSchema(
          com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema.Builder
              builderForValue) {
        if (schemaBuilder_ == null) {
          schema_ = builderForValue.build();
          onChanged();
        } else {
          schemaBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional schema for the data. When not specified for JSON and CSV formats
       * we will try to detect it automatically.
       * </pre>
       *
       * <code>.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema schema = 7;
       * </code>
       */
      public Builder mergeSchema(
          com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema value) {
        if (schemaBuilder_ == null) {
          if (schema_ != null) {
            schema_ =
                com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema.newBuilder(
                        schema_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            schema_ = value;
          }
          onChanged();
        } else {
          schemaBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional schema for the data. When not specified for JSON and CSV formats
       * we will try to detect it automatically.
       * </pre>
       *
       * <code>.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema schema = 7;
       * </code>
       */
      public Builder clearSchema() {
        if (schemaBuilder_ == null) {
          schema_ = null;
          onChanged();
        } else {
          schema_ = null;
          schemaBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional schema for the data. When not specified for JSON and CSV formats
       * we will try to detect it automatically.
       * </pre>
       *
       * <code>.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema schema = 7;
       * </code>
       */
      public com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema.Builder
          getSchemaBuilder() {

        onChanged();
        return getSchemaFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Optional schema for the data. When not specified for JSON and CSV formats
       * we will try to detect it automatically.
       * </pre>
       *
       * <code>.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema schema = 7;
       * </code>
       */
      public com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchemaOrBuilder
          getSchemaOrBuilder() {
        if (schemaBuilder_ != null) {
          return schemaBuilder_.getMessageOrBuilder();
        } else {
          return schema_ == null
              ? com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema
                  .getDefaultInstance()
              : schema_;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional schema for the data. When not specified for JSON and CSV formats
       * we will try to detect it automatically.
       * </pre>
       *
       * <code>.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema schema = 7;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema,
              com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema.Builder,
              com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchemaOrBuilder>
          getSchemaFieldBuilder() {
        if (schemaBuilder_ == null) {
          schemaBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema,
                  com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchema.Builder,
                  com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.RecordSchemaOrBuilder>(
                  getSchema(), getParentForChildren(), isClean());
          schema_ = null;
        }
        return schemaBuilder_;
      }

      private com.google.protobuf.BoolValue ignoreUnknownValues_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.BoolValue,
              com.google.protobuf.BoolValue.Builder,
              com.google.protobuf.BoolValueOrBuilder>
          ignoreUnknownValuesBuilder_;
      /**
       *
       *
       * <pre>
       * Indicates if extra values that are not represented in the table schema is
       * allowed.
       * </pre>
       *
       * <code>.google.protobuf.BoolValue ignore_unknown_values = 10;</code>
       */
      public boolean hasIgnoreUnknownValues() {
        return ignoreUnknownValuesBuilder_ != null || ignoreUnknownValues_ != null;
      }
      /**
       *
       *
       * <pre>
       * Indicates if extra values that are not represented in the table schema is
       * allowed.
       * </pre>
       *
       * <code>.google.protobuf.BoolValue ignore_unknown_values = 10;</code>
       */
      public com.google.protobuf.BoolValue getIgnoreUnknownValues() {
        if (ignoreUnknownValuesBuilder_ == null) {
          return ignoreUnknownValues_ == null
              ? com.google.protobuf.BoolValue.getDefaultInstance()
              : ignoreUnknownValues_;
        } else {
          return ignoreUnknownValuesBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Indicates if extra values that are not represented in the table schema is
       * allowed.
       * </pre>
       *
       * <code>.google.protobuf.BoolValue ignore_unknown_values = 10;</code>
       */
      public Builder setIgnoreUnknownValues(com.google.protobuf.BoolValue value) {
        if (ignoreUnknownValuesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ignoreUnknownValues_ = value;
          onChanged();
        } else {
          ignoreUnknownValuesBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Indicates if extra values that are not represented in the table schema is
       * allowed.
       * </pre>
       *
       * <code>.google.protobuf.BoolValue ignore_unknown_values = 10;</code>
       */
      public Builder setIgnoreUnknownValues(com.google.protobuf.BoolValue.Builder builderForValue) {
        if (ignoreUnknownValuesBuilder_ == null) {
          ignoreUnknownValues_ = builderForValue.build();
          onChanged();
        } else {
          ignoreUnknownValuesBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Indicates if extra values that are not represented in the table schema is
       * allowed.
       * </pre>
       *
       * <code>.google.protobuf.BoolValue ignore_unknown_values = 10;</code>
       */
      public Builder mergeIgnoreUnknownValues(com.google.protobuf.BoolValue value) {
        if (ignoreUnknownValuesBuilder_ == null) {
          if (ignoreUnknownValues_ != null) {
            ignoreUnknownValues_ =
                com.google.protobuf.BoolValue.newBuilder(ignoreUnknownValues_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            ignoreUnknownValues_ = value;
          }
          onChanged();
        } else {
          ignoreUnknownValuesBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Indicates if extra values that are not represented in the table schema is
       * allowed.
       * </pre>
       *
       * <code>.google.protobuf.BoolValue ignore_unknown_values = 10;</code>
       */
      public Builder clearIgnoreUnknownValues() {
        if (ignoreUnknownValuesBuilder_ == null) {
          ignoreUnknownValues_ = null;
          onChanged();
        } else {
          ignoreUnknownValues_ = null;
          ignoreUnknownValuesBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Indicates if extra values that are not represented in the table schema is
       * allowed.
       * </pre>
       *
       * <code>.google.protobuf.BoolValue ignore_unknown_values = 10;</code>
       */
      public com.google.protobuf.BoolValue.Builder getIgnoreUnknownValuesBuilder() {

        onChanged();
        return getIgnoreUnknownValuesFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Indicates if extra values that are not represented in the table schema is
       * allowed.
       * </pre>
       *
       * <code>.google.protobuf.BoolValue ignore_unknown_values = 10;</code>
       */
      public com.google.protobuf.BoolValueOrBuilder getIgnoreUnknownValuesOrBuilder() {
        if (ignoreUnknownValuesBuilder_ != null) {
          return ignoreUnknownValuesBuilder_.getMessageOrBuilder();
        } else {
          return ignoreUnknownValues_ == null
              ? com.google.protobuf.BoolValue.getDefaultInstance()
              : ignoreUnknownValues_;
        }
      }
      /**
       *
       *
       * <pre>
       * Indicates if extra values that are not represented in the table schema is
       * allowed.
       * </pre>
       *
       * <code>.google.protobuf.BoolValue ignore_unknown_values = 10;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.BoolValue,
              com.google.protobuf.BoolValue.Builder,
              com.google.protobuf.BoolValueOrBuilder>
          getIgnoreUnknownValuesFieldBuilder() {
        if (ignoreUnknownValuesBuilder_ == null) {
          ignoreUnknownValuesBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.BoolValue,
                  com.google.protobuf.BoolValue.Builder,
                  com.google.protobuf.BoolValueOrBuilder>(
                  getIgnoreUnknownValues(), getParentForChildren(), isClean());
          ignoreUnknownValues_ = null;
        }
        return ignoreUnknownValuesBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition)
    private static final com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition();
    }

    public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TableDefinition> PARSER =
        new com.google.protobuf.AbstractParser<TableDefinition>() {
          @java.lang.Override
          public TableDefinition parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new TableDefinition(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<TableDefinition> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TableDefinition> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int SQL_FIELD_NUMBER = 1;
  private volatile java.lang.Object sql_;
  /**
   *
   *
   * <pre>
   * SQL query to run. When empty, API checks that there is only one
   * table_def specified and loads this table. Only Standard SQL queries
   * are accepted. Legacy SQL is not allowed.
   * </pre>
   *
   * <code>string sql = 1;</code>
   */
  public java.lang.String getSql() {
    java.lang.Object ref = sql_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sql_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * SQL query to run. When empty, API checks that there is only one
   * table_def specified and loads this table. Only Standard SQL queries
   * are accepted. Legacy SQL is not allowed.
   * </pre>
   *
   * <code>string sql = 1;</code>
   */
  public com.google.protobuf.ByteString getSqlBytes() {
    java.lang.Object ref = sql_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sql_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESTINATION_TABLE_ID_FIELD_NUMBER = 2;
  private volatile java.lang.Object destinationTableId_;
  /**
   *
   *
   * <pre>
   * Table where results should be written.
   * </pre>
   *
   * <code>string destination_table_id = 2;</code>
   */
  public java.lang.String getDestinationTableId() {
    java.lang.Object ref = destinationTableId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      destinationTableId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Table where results should be written.
   * </pre>
   *
   * <code>string destination_table_id = 2;</code>
   */
  public com.google.protobuf.ByteString getDestinationTableIdBytes() {
    java.lang.Object ref = destinationTableId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      destinationTableId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESTINATION_TABLE_DESCRIPTION_FIELD_NUMBER = 10;
  private volatile java.lang.Object destinationTableDescription_;
  /**
   *
   *
   * <pre>
   * The description of a destination table. This can be several sentences
   * or paragraphs describing the table contents in detail.
   * </pre>
   *
   * <code>string destination_table_description = 10;</code>
   */
  public java.lang.String getDestinationTableDescription() {
    java.lang.Object ref = destinationTableDescription_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      destinationTableDescription_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The description of a destination table. This can be several sentences
   * or paragraphs describing the table contents in detail.
   * </pre>
   *
   * <code>string destination_table_description = 10;</code>
   */
  public com.google.protobuf.ByteString getDestinationTableDescriptionBytes() {
    java.lang.Object ref = destinationTableDescription_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      destinationTableDescription_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TABLE_DEFS_FIELD_NUMBER = 3;
  private java.util.List<com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition>
      tableDefs_;
  /**
   *
   *
   * <pre>
   * When used WITHOUT the "sql" parameter, describes the schema of the
   * destination table.
   * When used WITH the "sql" parameter, describes tables with data stored
   * outside of BigQuery.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition table_defs = 3;
   * </code>
   */
  public java.util.List<com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition>
      getTableDefsList() {
    return tableDefs_;
  }
  /**
   *
   *
   * <pre>
   * When used WITHOUT the "sql" parameter, describes the schema of the
   * destination table.
   * When used WITH the "sql" parameter, describes tables with data stored
   * outside of BigQuery.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition table_defs = 3;
   * </code>
   */
  public java.util.List<
          ? extends
              com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinitionOrBuilder>
      getTableDefsOrBuilderList() {
    return tableDefs_;
  }
  /**
   *
   *
   * <pre>
   * When used WITHOUT the "sql" parameter, describes the schema of the
   * destination table.
   * When used WITH the "sql" parameter, describes tables with data stored
   * outside of BigQuery.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition table_defs = 3;
   * </code>
   */
  public int getTableDefsCount() {
    return tableDefs_.size();
  }
  /**
   *
   *
   * <pre>
   * When used WITHOUT the "sql" parameter, describes the schema of the
   * destination table.
   * When used WITH the "sql" parameter, describes tables with data stored
   * outside of BigQuery.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition table_defs = 3;
   * </code>
   */
  public com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition getTableDefs(
      int index) {
    return tableDefs_.get(index);
  }
  /**
   *
   *
   * <pre>
   * When used WITHOUT the "sql" parameter, describes the schema of the
   * destination table.
   * When used WITH the "sql" parameter, describes tables with data stored
   * outside of BigQuery.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition table_defs = 3;
   * </code>
   */
  public com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinitionOrBuilder
      getTableDefsOrBuilder(int index) {
    return tableDefs_.get(index);
  }

  public static final int USER_DEFINED_FUNCTIONS_FIELD_NUMBER = 4;
  private com.google.protobuf.LazyStringList userDefinedFunctions_;
  /**
   *
   *
   * <pre>
   * Inline code for User-defined function resources.
   * Ignored when "sql" parameter is empty.
   * </pre>
   *
   * <code>repeated string user_defined_functions = 4;</code>
   */
  public com.google.protobuf.ProtocolStringList getUserDefinedFunctionsList() {
    return userDefinedFunctions_;
  }
  /**
   *
   *
   * <pre>
   * Inline code for User-defined function resources.
   * Ignored when "sql" parameter is empty.
   * </pre>
   *
   * <code>repeated string user_defined_functions = 4;</code>
   */
  public int getUserDefinedFunctionsCount() {
    return userDefinedFunctions_.size();
  }
  /**
   *
   *
   * <pre>
   * Inline code for User-defined function resources.
   * Ignored when "sql" parameter is empty.
   * </pre>
   *
   * <code>repeated string user_defined_functions = 4;</code>
   */
  public java.lang.String getUserDefinedFunctions(int index) {
    return userDefinedFunctions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Inline code for User-defined function resources.
   * Ignored when "sql" parameter is empty.
   * </pre>
   *
   * <code>repeated string user_defined_functions = 4;</code>
   */
  public com.google.protobuf.ByteString getUserDefinedFunctionsBytes(int index) {
    return userDefinedFunctions_.getByteString(index);
  }

  public static final int WRITE_DISPOSITION_FIELD_NUMBER = 6;
  private int writeDisposition_;
  /**
   *
   *
   * <pre>
   * Specifies the action if the destination table already exists.
   * </pre>
   *
   * <code>.google.cloud.bigquery.datatransfer.v1.WriteDisposition write_disposition = 6;</code>
   */
  public int getWriteDispositionValue() {
    return writeDisposition_;
  }
  /**
   *
   *
   * <pre>
   * Specifies the action if the destination table already exists.
   * </pre>
   *
   * <code>.google.cloud.bigquery.datatransfer.v1.WriteDisposition write_disposition = 6;</code>
   */
  public com.google.cloud.bigquery.datatransfer.v1.WriteDisposition getWriteDisposition() {
    @SuppressWarnings("deprecation")
    com.google.cloud.bigquery.datatransfer.v1.WriteDisposition result =
        com.google.cloud.bigquery.datatransfer.v1.WriteDisposition.valueOf(writeDisposition_);
    return result == null
        ? com.google.cloud.bigquery.datatransfer.v1.WriteDisposition.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getSqlBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, sql_);
    }
    if (!getDestinationTableIdBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, destinationTableId_);
    }
    for (int i = 0; i < tableDefs_.size(); i++) {
      output.writeMessage(3, tableDefs_.get(i));
    }
    for (int i = 0; i < userDefinedFunctions_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 4, userDefinedFunctions_.getRaw(i));
    }
    if (writeDisposition_
        != com.google.cloud.bigquery.datatransfer.v1.WriteDisposition.WRITE_DISPOSITION_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(6, writeDisposition_);
    }
    if (!getDestinationTableDescriptionBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, destinationTableDescription_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getSqlBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, sql_);
    }
    if (!getDestinationTableIdBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, destinationTableId_);
    }
    for (int i = 0; i < tableDefs_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, tableDefs_.get(i));
    }
    {
      int dataSize = 0;
      for (int i = 0; i < userDefinedFunctions_.size(); i++) {
        dataSize += computeStringSizeNoTag(userDefinedFunctions_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getUserDefinedFunctionsList().size();
    }
    if (writeDisposition_
        != com.google.cloud.bigquery.datatransfer.v1.WriteDisposition.WRITE_DISPOSITION_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, writeDisposition_);
    }
    if (!getDestinationTableDescriptionBytes().isEmpty()) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              10, destinationTableDescription_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo)) {
      return super.equals(obj);
    }
    com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo other =
        (com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo) obj;

    if (!getSql().equals(other.getSql())) return false;
    if (!getDestinationTableId().equals(other.getDestinationTableId())) return false;
    if (!getDestinationTableDescription().equals(other.getDestinationTableDescription()))
      return false;
    if (!getTableDefsList().equals(other.getTableDefsList())) return false;
    if (!getUserDefinedFunctionsList().equals(other.getUserDefinedFunctionsList())) return false;
    if (writeDisposition_ != other.writeDisposition_) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SQL_FIELD_NUMBER;
    hash = (53 * hash) + getSql().hashCode();
    hash = (37 * hash) + DESTINATION_TABLE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getDestinationTableId().hashCode();
    hash = (37 * hash) + DESTINATION_TABLE_DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDestinationTableDescription().hashCode();
    if (getTableDefsCount() > 0) {
      hash = (37 * hash) + TABLE_DEFS_FIELD_NUMBER;
      hash = (53 * hash) + getTableDefsList().hashCode();
    }
    if (getUserDefinedFunctionsCount() > 0) {
      hash = (37 * hash) + USER_DEFINED_FUNCTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getUserDefinedFunctionsList().hashCode();
    }
    hash = (37 * hash) + WRITE_DISPOSITION_FIELD_NUMBER;
    hash = (53 * hash) + writeDisposition_;
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Describes data which should be imported.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.datatransfer.v1.ImportedDataInfo}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.datatransfer.v1.ImportedDataInfo)
      com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfoOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.datatransfer.v1.DataSourceProto
          .internal_static_google_cloud_bigquery_datatransfer_v1_ImportedDataInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.datatransfer.v1.DataSourceProto
          .internal_static_google_cloud_bigquery_datatransfer_v1_ImportedDataInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.class,
              com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.Builder.class);
    }

    // Construct using com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getTableDefsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      sql_ = "";

      destinationTableId_ = "";

      destinationTableDescription_ = "";

      if (tableDefsBuilder_ == null) {
        tableDefs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
      } else {
        tableDefsBuilder_.clear();
      }
      userDefinedFunctions_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000010);
      writeDisposition_ = 0;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.bigquery.datatransfer.v1.DataSourceProto
          .internal_static_google_cloud_bigquery_datatransfer_v1_ImportedDataInfo_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo getDefaultInstanceForType() {
      return com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo build() {
      com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo buildPartial() {
      com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo result =
          new com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      result.sql_ = sql_;
      result.destinationTableId_ = destinationTableId_;
      result.destinationTableDescription_ = destinationTableDescription_;
      if (tableDefsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          tableDefs_ = java.util.Collections.unmodifiableList(tableDefs_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.tableDefs_ = tableDefs_;
      } else {
        result.tableDefs_ = tableDefsBuilder_.build();
      }
      if (((bitField0_ & 0x00000010) != 0)) {
        userDefinedFunctions_ = userDefinedFunctions_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000010);
      }
      result.userDefinedFunctions_ = userDefinedFunctions_;
      result.writeDisposition_ = writeDisposition_;
      result.bitField0_ = to_bitField0_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo) {
        return mergeFrom((com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo other) {
      if (other == com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.getDefaultInstance())
        return this;
      if (!other.getSql().isEmpty()) {
        sql_ = other.sql_;
        onChanged();
      }
      if (!other.getDestinationTableId().isEmpty()) {
        destinationTableId_ = other.destinationTableId_;
        onChanged();
      }
      if (!other.getDestinationTableDescription().isEmpty()) {
        destinationTableDescription_ = other.destinationTableDescription_;
        onChanged();
      }
      if (tableDefsBuilder_ == null) {
        if (!other.tableDefs_.isEmpty()) {
          if (tableDefs_.isEmpty()) {
            tableDefs_ = other.tableDefs_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureTableDefsIsMutable();
            tableDefs_.addAll(other.tableDefs_);
          }
          onChanged();
        }
      } else {
        if (!other.tableDefs_.isEmpty()) {
          if (tableDefsBuilder_.isEmpty()) {
            tableDefsBuilder_.dispose();
            tableDefsBuilder_ = null;
            tableDefs_ = other.tableDefs_;
            bitField0_ = (bitField0_ & ~0x00000008);
            tableDefsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getTableDefsFieldBuilder()
                    : null;
          } else {
            tableDefsBuilder_.addAllMessages(other.tableDefs_);
          }
        }
      }
      if (!other.userDefinedFunctions_.isEmpty()) {
        if (userDefinedFunctions_.isEmpty()) {
          userDefinedFunctions_ = other.userDefinedFunctions_;
          bitField0_ = (bitField0_ & ~0x00000010);
        } else {
          ensureUserDefinedFunctionsIsMutable();
          userDefinedFunctions_.addAll(other.userDefinedFunctions_);
        }
        onChanged();
      }
      if (other.writeDisposition_ != 0) {
        setWriteDispositionValue(other.getWriteDispositionValue());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object sql_ = "";
    /**
     *
     *
     * <pre>
     * SQL query to run. When empty, API checks that there is only one
     * table_def specified and loads this table. Only Standard SQL queries
     * are accepted. Legacy SQL is not allowed.
     * </pre>
     *
     * <code>string sql = 1;</code>
     */
    public java.lang.String getSql() {
      java.lang.Object ref = sql_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sql_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * SQL query to run. When empty, API checks that there is only one
     * table_def specified and loads this table. Only Standard SQL queries
     * are accepted. Legacy SQL is not allowed.
     * </pre>
     *
     * <code>string sql = 1;</code>
     */
    public com.google.protobuf.ByteString getSqlBytes() {
      java.lang.Object ref = sql_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sql_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * SQL query to run. When empty, API checks that there is only one
     * table_def specified and loads this table. Only Standard SQL queries
     * are accepted. Legacy SQL is not allowed.
     * </pre>
     *
     * <code>string sql = 1;</code>
     */
    public Builder setSql(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      sql_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * SQL query to run. When empty, API checks that there is only one
     * table_def specified and loads this table. Only Standard SQL queries
     * are accepted. Legacy SQL is not allowed.
     * </pre>
     *
     * <code>string sql = 1;</code>
     */
    public Builder clearSql() {

      sql_ = getDefaultInstance().getSql();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * SQL query to run. When empty, API checks that there is only one
     * table_def specified and loads this table. Only Standard SQL queries
     * are accepted. Legacy SQL is not allowed.
     * </pre>
     *
     * <code>string sql = 1;</code>
     */
    public Builder setSqlBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      sql_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object destinationTableId_ = "";
    /**
     *
     *
     * <pre>
     * Table where results should be written.
     * </pre>
     *
     * <code>string destination_table_id = 2;</code>
     */
    public java.lang.String getDestinationTableId() {
      java.lang.Object ref = destinationTableId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        destinationTableId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Table where results should be written.
     * </pre>
     *
     * <code>string destination_table_id = 2;</code>
     */
    public com.google.protobuf.ByteString getDestinationTableIdBytes() {
      java.lang.Object ref = destinationTableId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        destinationTableId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Table where results should be written.
     * </pre>
     *
     * <code>string destination_table_id = 2;</code>
     */
    public Builder setDestinationTableId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      destinationTableId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Table where results should be written.
     * </pre>
     *
     * <code>string destination_table_id = 2;</code>
     */
    public Builder clearDestinationTableId() {

      destinationTableId_ = getDefaultInstance().getDestinationTableId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Table where results should be written.
     * </pre>
     *
     * <code>string destination_table_id = 2;</code>
     */
    public Builder setDestinationTableIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      destinationTableId_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object destinationTableDescription_ = "";
    /**
     *
     *
     * <pre>
     * The description of a destination table. This can be several sentences
     * or paragraphs describing the table contents in detail.
     * </pre>
     *
     * <code>string destination_table_description = 10;</code>
     */
    public java.lang.String getDestinationTableDescription() {
      java.lang.Object ref = destinationTableDescription_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        destinationTableDescription_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The description of a destination table. This can be several sentences
     * or paragraphs describing the table contents in detail.
     * </pre>
     *
     * <code>string destination_table_description = 10;</code>
     */
    public com.google.protobuf.ByteString getDestinationTableDescriptionBytes() {
      java.lang.Object ref = destinationTableDescription_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        destinationTableDescription_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The description of a destination table. This can be several sentences
     * or paragraphs describing the table contents in detail.
     * </pre>
     *
     * <code>string destination_table_description = 10;</code>
     */
    public Builder setDestinationTableDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      destinationTableDescription_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The description of a destination table. This can be several sentences
     * or paragraphs describing the table contents in detail.
     * </pre>
     *
     * <code>string destination_table_description = 10;</code>
     */
    public Builder clearDestinationTableDescription() {

      destinationTableDescription_ = getDefaultInstance().getDestinationTableDescription();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The description of a destination table. This can be several sentences
     * or paragraphs describing the table contents in detail.
     * </pre>
     *
     * <code>string destination_table_description = 10;</code>
     */
    public Builder setDestinationTableDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      destinationTableDescription_ = value;
      onChanged();
      return this;
    }

    private java.util.List<
            com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition>
        tableDefs_ = java.util.Collections.emptyList();

    private void ensureTableDefsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        tableDefs_ =
            new java.util.ArrayList<
                com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition>(
                tableDefs_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition,
            com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition.Builder,
            com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinitionOrBuilder>
        tableDefsBuilder_;

    /**
     *
     *
     * <pre>
     * When used WITHOUT the "sql" parameter, describes the schema of the
     * destination table.
     * When used WITH the "sql" parameter, describes tables with data stored
     * outside of BigQuery.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition table_defs = 3;
     * </code>
     */
    public java.util.List<
            com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition>
        getTableDefsList() {
      if (tableDefsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(tableDefs_);
      } else {
        return tableDefsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * When used WITHOUT the "sql" parameter, describes the schema of the
     * destination table.
     * When used WITH the "sql" parameter, describes tables with data stored
     * outside of BigQuery.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition table_defs = 3;
     * </code>
     */
    public int getTableDefsCount() {
      if (tableDefsBuilder_ == null) {
        return tableDefs_.size();
      } else {
        return tableDefsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * When used WITHOUT the "sql" parameter, describes the schema of the
     * destination table.
     * When used WITH the "sql" parameter, describes tables with data stored
     * outside of BigQuery.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition table_defs = 3;
     * </code>
     */
    public com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition getTableDefs(
        int index) {
      if (tableDefsBuilder_ == null) {
        return tableDefs_.get(index);
      } else {
        return tableDefsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * When used WITHOUT the "sql" parameter, describes the schema of the
     * destination table.
     * When used WITH the "sql" parameter, describes tables with data stored
     * outside of BigQuery.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition table_defs = 3;
     * </code>
     */
    public Builder setTableDefs(
        int index,
        com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition value) {
      if (tableDefsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTableDefsIsMutable();
        tableDefs_.set(index, value);
        onChanged();
      } else {
        tableDefsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * When used WITHOUT the "sql" parameter, describes the schema of the
     * destination table.
     * When used WITH the "sql" parameter, describes tables with data stored
     * outside of BigQuery.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition table_defs = 3;
     * </code>
     */
    public Builder setTableDefs(
        int index,
        com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition.Builder
            builderForValue) {
      if (tableDefsBuilder_ == null) {
        ensureTableDefsIsMutable();
        tableDefs_.set(index, builderForValue.build());
        onChanged();
      } else {
        tableDefsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * When used WITHOUT the "sql" parameter, describes the schema of the
     * destination table.
     * When used WITH the "sql" parameter, describes tables with data stored
     * outside of BigQuery.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition table_defs = 3;
     * </code>
     */
    public Builder addTableDefs(
        com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition value) {
      if (tableDefsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTableDefsIsMutable();
        tableDefs_.add(value);
        onChanged();
      } else {
        tableDefsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * When used WITHOUT the "sql" parameter, describes the schema of the
     * destination table.
     * When used WITH the "sql" parameter, describes tables with data stored
     * outside of BigQuery.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition table_defs = 3;
     * </code>
     */
    public Builder addTableDefs(
        int index,
        com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition value) {
      if (tableDefsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTableDefsIsMutable();
        tableDefs_.add(index, value);
        onChanged();
      } else {
        tableDefsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * When used WITHOUT the "sql" parameter, describes the schema of the
     * destination table.
     * When used WITH the "sql" parameter, describes tables with data stored
     * outside of BigQuery.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition table_defs = 3;
     * </code>
     */
    public Builder addTableDefs(
        com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition.Builder
            builderForValue) {
      if (tableDefsBuilder_ == null) {
        ensureTableDefsIsMutable();
        tableDefs_.add(builderForValue.build());
        onChanged();
      } else {
        tableDefsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * When used WITHOUT the "sql" parameter, describes the schema of the
     * destination table.
     * When used WITH the "sql" parameter, describes tables with data stored
     * outside of BigQuery.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition table_defs = 3;
     * </code>
     */
    public Builder addTableDefs(
        int index,
        com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition.Builder
            builderForValue) {
      if (tableDefsBuilder_ == null) {
        ensureTableDefsIsMutable();
        tableDefs_.add(index, builderForValue.build());
        onChanged();
      } else {
        tableDefsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * When used WITHOUT the "sql" parameter, describes the schema of the
     * destination table.
     * When used WITH the "sql" parameter, describes tables with data stored
     * outside of BigQuery.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition table_defs = 3;
     * </code>
     */
    public Builder addAllTableDefs(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition>
            values) {
      if (tableDefsBuilder_ == null) {
        ensureTableDefsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, tableDefs_);
        onChanged();
      } else {
        tableDefsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * When used WITHOUT the "sql" parameter, describes the schema of the
     * destination table.
     * When used WITH the "sql" parameter, describes tables with data stored
     * outside of BigQuery.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition table_defs = 3;
     * </code>
     */
    public Builder clearTableDefs() {
      if (tableDefsBuilder_ == null) {
        tableDefs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        tableDefsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * When used WITHOUT the "sql" parameter, describes the schema of the
     * destination table.
     * When used WITH the "sql" parameter, describes tables with data stored
     * outside of BigQuery.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition table_defs = 3;
     * </code>
     */
    public Builder removeTableDefs(int index) {
      if (tableDefsBuilder_ == null) {
        ensureTableDefsIsMutable();
        tableDefs_.remove(index);
        onChanged();
      } else {
        tableDefsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * When used WITHOUT the "sql" parameter, describes the schema of the
     * destination table.
     * When used WITH the "sql" parameter, describes tables with data stored
     * outside of BigQuery.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition table_defs = 3;
     * </code>
     */
    public com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition.Builder
        getTableDefsBuilder(int index) {
      return getTableDefsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * When used WITHOUT the "sql" parameter, describes the schema of the
     * destination table.
     * When used WITH the "sql" parameter, describes tables with data stored
     * outside of BigQuery.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition table_defs = 3;
     * </code>
     */
    public com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinitionOrBuilder
        getTableDefsOrBuilder(int index) {
      if (tableDefsBuilder_ == null) {
        return tableDefs_.get(index);
      } else {
        return tableDefsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * When used WITHOUT the "sql" parameter, describes the schema of the
     * destination table.
     * When used WITH the "sql" parameter, describes tables with data stored
     * outside of BigQuery.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition table_defs = 3;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinitionOrBuilder>
        getTableDefsOrBuilderList() {
      if (tableDefsBuilder_ != null) {
        return tableDefsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(tableDefs_);
      }
    }
    /**
     *
     *
     * <pre>
     * When used WITHOUT the "sql" parameter, describes the schema of the
     * destination table.
     * When used WITH the "sql" parameter, describes tables with data stored
     * outside of BigQuery.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition table_defs = 3;
     * </code>
     */
    public com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition.Builder
        addTableDefsBuilder() {
      return getTableDefsFieldBuilder()
          .addBuilder(
              com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * When used WITHOUT the "sql" parameter, describes the schema of the
     * destination table.
     * When used WITH the "sql" parameter, describes tables with data stored
     * outside of BigQuery.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition table_defs = 3;
     * </code>
     */
    public com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition.Builder
        addTableDefsBuilder(int index) {
      return getTableDefsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * When used WITHOUT the "sql" parameter, describes the schema of the
     * destination table.
     * When used WITH the "sql" parameter, describes tables with data stored
     * outside of BigQuery.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition table_defs = 3;
     * </code>
     */
    public java.util.List<
            com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition.Builder>
        getTableDefsBuilderList() {
      return getTableDefsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition,
            com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition.Builder,
            com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinitionOrBuilder>
        getTableDefsFieldBuilder() {
      if (tableDefsBuilder_ == null) {
        tableDefsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition,
                com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo.TableDefinition.Builder,
                com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo
                    .TableDefinitionOrBuilder>(
                tableDefs_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
        tableDefs_ = null;
      }
      return tableDefsBuilder_;
    }

    private com.google.protobuf.LazyStringList userDefinedFunctions_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureUserDefinedFunctionsIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        userDefinedFunctions_ = new com.google.protobuf.LazyStringArrayList(userDefinedFunctions_);
        bitField0_ |= 0x00000010;
      }
    }
    /**
     *
     *
     * <pre>
     * Inline code for User-defined function resources.
     * Ignored when "sql" parameter is empty.
     * </pre>
     *
     * <code>repeated string user_defined_functions = 4;</code>
     */
    public com.google.protobuf.ProtocolStringList getUserDefinedFunctionsList() {
      return userDefinedFunctions_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * Inline code for User-defined function resources.
     * Ignored when "sql" parameter is empty.
     * </pre>
     *
     * <code>repeated string user_defined_functions = 4;</code>
     */
    public int getUserDefinedFunctionsCount() {
      return userDefinedFunctions_.size();
    }
    /**
     *
     *
     * <pre>
     * Inline code for User-defined function resources.
     * Ignored when "sql" parameter is empty.
     * </pre>
     *
     * <code>repeated string user_defined_functions = 4;</code>
     */
    public java.lang.String getUserDefinedFunctions(int index) {
      return userDefinedFunctions_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Inline code for User-defined function resources.
     * Ignored when "sql" parameter is empty.
     * </pre>
     *
     * <code>repeated string user_defined_functions = 4;</code>
     */
    public com.google.protobuf.ByteString getUserDefinedFunctionsBytes(int index) {
      return userDefinedFunctions_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Inline code for User-defined function resources.
     * Ignored when "sql" parameter is empty.
     * </pre>
     *
     * <code>repeated string user_defined_functions = 4;</code>
     */
    public Builder setUserDefinedFunctions(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureUserDefinedFunctionsIsMutable();
      userDefinedFunctions_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Inline code for User-defined function resources.
     * Ignored when "sql" parameter is empty.
     * </pre>
     *
     * <code>repeated string user_defined_functions = 4;</code>
     */
    public Builder addUserDefinedFunctions(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureUserDefinedFunctionsIsMutable();
      userDefinedFunctions_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Inline code for User-defined function resources.
     * Ignored when "sql" parameter is empty.
     * </pre>
     *
     * <code>repeated string user_defined_functions = 4;</code>
     */
    public Builder addAllUserDefinedFunctions(java.lang.Iterable<java.lang.String> values) {
      ensureUserDefinedFunctionsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, userDefinedFunctions_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Inline code for User-defined function resources.
     * Ignored when "sql" parameter is empty.
     * </pre>
     *
     * <code>repeated string user_defined_functions = 4;</code>
     */
    public Builder clearUserDefinedFunctions() {
      userDefinedFunctions_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Inline code for User-defined function resources.
     * Ignored when "sql" parameter is empty.
     * </pre>
     *
     * <code>repeated string user_defined_functions = 4;</code>
     */
    public Builder addUserDefinedFunctionsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureUserDefinedFunctionsIsMutable();
      userDefinedFunctions_.add(value);
      onChanged();
      return this;
    }

    private int writeDisposition_ = 0;
    /**
     *
     *
     * <pre>
     * Specifies the action if the destination table already exists.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.WriteDisposition write_disposition = 6;</code>
     */
    public int getWriteDispositionValue() {
      return writeDisposition_;
    }
    /**
     *
     *
     * <pre>
     * Specifies the action if the destination table already exists.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.WriteDisposition write_disposition = 6;</code>
     */
    public Builder setWriteDispositionValue(int value) {
      writeDisposition_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the action if the destination table already exists.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.WriteDisposition write_disposition = 6;</code>
     */
    public com.google.cloud.bigquery.datatransfer.v1.WriteDisposition getWriteDisposition() {
      @SuppressWarnings("deprecation")
      com.google.cloud.bigquery.datatransfer.v1.WriteDisposition result =
          com.google.cloud.bigquery.datatransfer.v1.WriteDisposition.valueOf(writeDisposition_);
      return result == null
          ? com.google.cloud.bigquery.datatransfer.v1.WriteDisposition.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Specifies the action if the destination table already exists.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.WriteDisposition write_disposition = 6;</code>
     */
    public Builder setWriteDisposition(
        com.google.cloud.bigquery.datatransfer.v1.WriteDisposition value) {
      if (value == null) {
        throw new NullPointerException();
      }

      writeDisposition_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the action if the destination table already exists.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.WriteDisposition write_disposition = 6;</code>
     */
    public Builder clearWriteDisposition() {

      writeDisposition_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.datatransfer.v1.ImportedDataInfo)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.bigquery.datatransfer.v1.ImportedDataInfo)
  private static final com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo();
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ImportedDataInfo> PARSER =
      new com.google.protobuf.AbstractParser<ImportedDataInfo>() {
        @java.lang.Override
        public ImportedDataInfo parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new ImportedDataInfo(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<ImportedDataInfo> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ImportedDataInfo> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.bigquery.datatransfer.v1.ImportedDataInfo getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
