/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/datatransfer/v1/datatransfer.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.bigquery.datatransfer.v1;

/**
 *
 *
 * <pre>
 * A request to start manual transfer runs.
 * </pre>
 *
 * Protobuf type {@code google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest}
 */
public final class StartManualTransferRunsRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest)
    StartManualTransferRunsRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use StartManualTransferRunsRequest.newBuilder() to construct.
  private StartManualTransferRunsRequest(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private StartManualTransferRunsRequest() {
    parent_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new StartManualTransferRunsRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.bigquery.datatransfer.v1.DataTransferProto
        .internal_static_google_cloud_bigquery_datatransfer_v1_StartManualTransferRunsRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.bigquery.datatransfer.v1.DataTransferProto
        .internal_static_google_cloud_bigquery_datatransfer_v1_StartManualTransferRunsRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.class,
            com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.Builder.class);
  }

  public interface TimeRangeOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Start time of the range of transfer runs. For example,
     * `"2017-05-25T00:00:00+00:00"`. The start_time must be strictly less than
     * the end_time. Creates transfer runs where run_time is in the range
     * between start_time (inclusive) and end_time (exclusive).
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     *
     * @return Whether the startTime field is set.
     */
    boolean hasStartTime();
    /**
     *
     *
     * <pre>
     * Start time of the range of transfer runs. For example,
     * `"2017-05-25T00:00:00+00:00"`. The start_time must be strictly less than
     * the end_time. Creates transfer runs where run_time is in the range
     * between start_time (inclusive) and end_time (exclusive).
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     *
     * @return The startTime.
     */
    com.google.protobuf.Timestamp getStartTime();
    /**
     *
     *
     * <pre>
     * Start time of the range of transfer runs. For example,
     * `"2017-05-25T00:00:00+00:00"`. The start_time must be strictly less than
     * the end_time. Creates transfer runs where run_time is in the range
     * between start_time (inclusive) and end_time (exclusive).
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * End time of the range of transfer runs. For example,
     * `"2017-05-30T00:00:00+00:00"`. The end_time must not be in the future.
     * Creates transfer runs where run_time is in the range between start_time
     * (inclusive) and end_time (exclusive).
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     *
     * @return Whether the endTime field is set.
     */
    boolean hasEndTime();
    /**
     *
     *
     * <pre>
     * End time of the range of transfer runs. For example,
     * `"2017-05-30T00:00:00+00:00"`. The end_time must not be in the future.
     * Creates transfer runs where run_time is in the range between start_time
     * (inclusive) and end_time (exclusive).
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     *
     * @return The endTime.
     */
    com.google.protobuf.Timestamp getEndTime();
    /**
     *
     *
     * <pre>
     * End time of the range of transfer runs. For example,
     * `"2017-05-30T00:00:00+00:00"`. The end_time must not be in the future.
     * Creates transfer runs where run_time is in the range between start_time
     * (inclusive) and end_time (exclusive).
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * A specification for a time range, this will request transfer runs with
   * run_time between start_time (inclusive) and end_time (exclusive).
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange}
   */
  public static final class TimeRange extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange)
      TimeRangeOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use TimeRange.newBuilder() to construct.
    private TimeRange(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private TimeRange() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new TimeRange();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.datatransfer.v1.DataTransferProto
          .internal_static_google_cloud_bigquery_datatransfer_v1_StartManualTransferRunsRequest_TimeRange_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.datatransfer.v1.DataTransferProto
          .internal_static_google_cloud_bigquery_datatransfer_v1_StartManualTransferRunsRequest_TimeRange_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange
                  .class,
              com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange
                  .Builder.class);
    }

    private int bitField0_;
    public static final int START_TIME_FIELD_NUMBER = 1;
    private com.google.protobuf.Timestamp startTime_;
    /**
     *
     *
     * <pre>
     * Start time of the range of transfer runs. For example,
     * `"2017-05-25T00:00:00+00:00"`. The start_time must be strictly less than
     * the end_time. Creates transfer runs where run_time is in the range
     * between start_time (inclusive) and end_time (exclusive).
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     *
     * @return Whether the startTime field is set.
     */
    @java.lang.Override
    public boolean hasStartTime() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Start time of the range of transfer runs. For example,
     * `"2017-05-25T00:00:00+00:00"`. The start_time must be strictly less than
     * the end_time. Creates transfer runs where run_time is in the range
     * between start_time (inclusive) and end_time (exclusive).
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     *
     * @return The startTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getStartTime() {
      return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
    }
    /**
     *
     *
     * <pre>
     * Start time of the range of transfer runs. For example,
     * `"2017-05-25T00:00:00+00:00"`. The start_time must be strictly less than
     * the end_time. Creates transfer runs where run_time is in the range
     * between start_time (inclusive) and end_time (exclusive).
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
    }

    public static final int END_TIME_FIELD_NUMBER = 2;
    private com.google.protobuf.Timestamp endTime_;
    /**
     *
     *
     * <pre>
     * End time of the range of transfer runs. For example,
     * `"2017-05-30T00:00:00+00:00"`. The end_time must not be in the future.
     * Creates transfer runs where run_time is in the range between start_time
     * (inclusive) and end_time (exclusive).
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     *
     * @return Whether the endTime field is set.
     */
    @java.lang.Override
    public boolean hasEndTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * End time of the range of transfer runs. For example,
     * `"2017-05-30T00:00:00+00:00"`. The end_time must not be in the future.
     * Creates transfer runs where run_time is in the range between start_time
     * (inclusive) and end_time (exclusive).
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     *
     * @return The endTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getEndTime() {
      return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
    }
    /**
     *
     *
     * <pre>
     * End time of the range of transfer runs. For example,
     * `"2017-05-30T00:00:00+00:00"`. The end_time must not be in the future.
     * Creates transfer runs where run_time is in the range between start_time
     * (inclusive) and end_time (exclusive).
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getStartTime());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(2, getEndTime());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getStartTime());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getEndTime());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange)) {
        return super.equals(obj);
      }
      com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange other =
          (com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange) obj;

      if (hasStartTime() != other.hasStartTime()) return false;
      if (hasStartTime()) {
        if (!getStartTime().equals(other.getStartTime())) return false;
      }
      if (hasEndTime() != other.hasEndTime()) return false;
      if (hasEndTime()) {
        if (!getEndTime().equals(other.getEndTime())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasStartTime()) {
        hash = (37 * hash) + START_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getStartTime().hashCode();
      }
      if (hasEndTime()) {
        hash = (37 * hash) + END_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getEndTime().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A specification for a time range, this will request transfer runs with
     * run_time between start_time (inclusive) and end_time (exclusive).
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange)
        com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest
            .TimeRangeOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.bigquery.datatransfer.v1.DataTransferProto
            .internal_static_google_cloud_bigquery_datatransfer_v1_StartManualTransferRunsRequest_TimeRange_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.bigquery.datatransfer.v1.DataTransferProto
            .internal_static_google_cloud_bigquery_datatransfer_v1_StartManualTransferRunsRequest_TimeRange_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange
                    .class,
                com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getStartTimeFieldBuilder();
          getEndTimeFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        startTime_ = null;
        if (startTimeBuilder_ != null) {
          startTimeBuilder_.dispose();
          startTimeBuilder_ = null;
        }
        endTime_ = null;
        if (endTimeBuilder_ != null) {
          endTimeBuilder_.dispose();
          endTimeBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.bigquery.datatransfer.v1.DataTransferProto
            .internal_static_google_cloud_bigquery_datatransfer_v1_StartManualTransferRunsRequest_TimeRange_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange
          getDefaultInstanceForType() {
        return com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange
          build() {
        com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange
          buildPartial() {
        com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange result =
            new com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange(
                this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange
              result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.startTime_ = startTimeBuilder_ == null ? startTime_ : startTimeBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.endTime_ = endTimeBuilder_ == null ? endTime_ : endTimeBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange) {
          return mergeFrom(
              (com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange
              other) {
        if (other
            == com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange
                .getDefaultInstance()) return this;
        if (other.hasStartTime()) {
          mergeStartTime(other.getStartTime());
        }
        if (other.hasEndTime()) {
          mergeEndTime(other.getEndTime());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getEndTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.Timestamp startTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          startTimeBuilder_;
      /**
       *
       *
       * <pre>
       * Start time of the range of transfer runs. For example,
       * `"2017-05-25T00:00:00+00:00"`. The start_time must be strictly less than
       * the end_time. Creates transfer runs where run_time is in the range
       * between start_time (inclusive) and end_time (exclusive).
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 1;</code>
       *
       * @return Whether the startTime field is set.
       */
      public boolean hasStartTime() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Start time of the range of transfer runs. For example,
       * `"2017-05-25T00:00:00+00:00"`. The start_time must be strictly less than
       * the end_time. Creates transfer runs where run_time is in the range
       * between start_time (inclusive) and end_time (exclusive).
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 1;</code>
       *
       * @return The startTime.
       */
      public com.google.protobuf.Timestamp getStartTime() {
        if (startTimeBuilder_ == null) {
          return startTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : startTime_;
        } else {
          return startTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Start time of the range of transfer runs. For example,
       * `"2017-05-25T00:00:00+00:00"`. The start_time must be strictly less than
       * the end_time. Creates transfer runs where run_time is in the range
       * between start_time (inclusive) and end_time (exclusive).
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 1;</code>
       */
      public Builder setStartTime(com.google.protobuf.Timestamp value) {
        if (startTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          startTime_ = value;
        } else {
          startTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Start time of the range of transfer runs. For example,
       * `"2017-05-25T00:00:00+00:00"`. The start_time must be strictly less than
       * the end_time. Creates transfer runs where run_time is in the range
       * between start_time (inclusive) and end_time (exclusive).
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 1;</code>
       */
      public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (startTimeBuilder_ == null) {
          startTime_ = builderForValue.build();
        } else {
          startTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Start time of the range of transfer runs. For example,
       * `"2017-05-25T00:00:00+00:00"`. The start_time must be strictly less than
       * the end_time. Creates transfer runs where run_time is in the range
       * between start_time (inclusive) and end_time (exclusive).
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 1;</code>
       */
      public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
        if (startTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && startTime_ != null
              && startTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getStartTimeBuilder().mergeFrom(value);
          } else {
            startTime_ = value;
          }
        } else {
          startTimeBuilder_.mergeFrom(value);
        }
        if (startTime_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Start time of the range of transfer runs. For example,
       * `"2017-05-25T00:00:00+00:00"`. The start_time must be strictly less than
       * the end_time. Creates transfer runs where run_time is in the range
       * between start_time (inclusive) and end_time (exclusive).
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 1;</code>
       */
      public Builder clearStartTime() {
        bitField0_ = (bitField0_ & ~0x00000001);
        startTime_ = null;
        if (startTimeBuilder_ != null) {
          startTimeBuilder_.dispose();
          startTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Start time of the range of transfer runs. For example,
       * `"2017-05-25T00:00:00+00:00"`. The start_time must be strictly less than
       * the end_time. Creates transfer runs where run_time is in the range
       * between start_time (inclusive) and end_time (exclusive).
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 1;</code>
       */
      public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getStartTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Start time of the range of transfer runs. For example,
       * `"2017-05-25T00:00:00+00:00"`. The start_time must be strictly less than
       * the end_time. Creates transfer runs where run_time is in the range
       * between start_time (inclusive) and end_time (exclusive).
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 1;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
        if (startTimeBuilder_ != null) {
          return startTimeBuilder_.getMessageOrBuilder();
        } else {
          return startTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : startTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * Start time of the range of transfer runs. For example,
       * `"2017-05-25T00:00:00+00:00"`. The start_time must be strictly less than
       * the end_time. Creates transfer runs where run_time is in the range
       * between start_time (inclusive) and end_time (exclusive).
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getStartTimeFieldBuilder() {
        if (startTimeBuilder_ == null) {
          startTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getStartTime(), getParentForChildren(), isClean());
          startTime_ = null;
        }
        return startTimeBuilder_;
      }

      private com.google.protobuf.Timestamp endTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          endTimeBuilder_;
      /**
       *
       *
       * <pre>
       * End time of the range of transfer runs. For example,
       * `"2017-05-30T00:00:00+00:00"`. The end_time must not be in the future.
       * Creates transfer runs where run_time is in the range between start_time
       * (inclusive) and end_time (exclusive).
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 2;</code>
       *
       * @return Whether the endTime field is set.
       */
      public boolean hasEndTime() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * End time of the range of transfer runs. For example,
       * `"2017-05-30T00:00:00+00:00"`. The end_time must not be in the future.
       * Creates transfer runs where run_time is in the range between start_time
       * (inclusive) and end_time (exclusive).
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 2;</code>
       *
       * @return The endTime.
       */
      public com.google.protobuf.Timestamp getEndTime() {
        if (endTimeBuilder_ == null) {
          return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
        } else {
          return endTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * End time of the range of transfer runs. For example,
       * `"2017-05-30T00:00:00+00:00"`. The end_time must not be in the future.
       * Creates transfer runs where run_time is in the range between start_time
       * (inclusive) and end_time (exclusive).
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 2;</code>
       */
      public Builder setEndTime(com.google.protobuf.Timestamp value) {
        if (endTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          endTime_ = value;
        } else {
          endTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * End time of the range of transfer runs. For example,
       * `"2017-05-30T00:00:00+00:00"`. The end_time must not be in the future.
       * Creates transfer runs where run_time is in the range between start_time
       * (inclusive) and end_time (exclusive).
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 2;</code>
       */
      public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (endTimeBuilder_ == null) {
          endTime_ = builderForValue.build();
        } else {
          endTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * End time of the range of transfer runs. For example,
       * `"2017-05-30T00:00:00+00:00"`. The end_time must not be in the future.
       * Creates transfer runs where run_time is in the range between start_time
       * (inclusive) and end_time (exclusive).
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 2;</code>
       */
      public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
        if (endTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && endTime_ != null
              && endTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getEndTimeBuilder().mergeFrom(value);
          } else {
            endTime_ = value;
          }
        } else {
          endTimeBuilder_.mergeFrom(value);
        }
        if (endTime_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * End time of the range of transfer runs. For example,
       * `"2017-05-30T00:00:00+00:00"`. The end_time must not be in the future.
       * Creates transfer runs where run_time is in the range between start_time
       * (inclusive) and end_time (exclusive).
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 2;</code>
       */
      public Builder clearEndTime() {
        bitField0_ = (bitField0_ & ~0x00000002);
        endTime_ = null;
        if (endTimeBuilder_ != null) {
          endTimeBuilder_.dispose();
          endTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * End time of the range of transfer runs. For example,
       * `"2017-05-30T00:00:00+00:00"`. The end_time must not be in the future.
       * Creates transfer runs where run_time is in the range between start_time
       * (inclusive) and end_time (exclusive).
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 2;</code>
       */
      public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getEndTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * End time of the range of transfer runs. For example,
       * `"2017-05-30T00:00:00+00:00"`. The end_time must not be in the future.
       * Creates transfer runs where run_time is in the range between start_time
       * (inclusive) and end_time (exclusive).
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 2;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
        if (endTimeBuilder_ != null) {
          return endTimeBuilder_.getMessageOrBuilder();
        } else {
          return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * End time of the range of transfer runs. For example,
       * `"2017-05-30T00:00:00+00:00"`. The end_time must not be in the future.
       * Creates transfer runs where run_time is in the range between start_time
       * (inclusive) and end_time (exclusive).
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getEndTimeFieldBuilder() {
        if (endTimeBuilder_ == null) {
          endTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getEndTime(), getParentForChildren(), isClean());
          endTime_ = null;
        }
        return endTimeBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange)
    private static final com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest
            .TimeRange
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange();
    }

    public static com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TimeRange> PARSER =
        new com.google.protobuf.AbstractParser<TimeRange>() {
          @java.lang.Override
          public TimeRange parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<TimeRange> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TimeRange> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int timeCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object time_;

  public enum TimeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    REQUESTED_TIME_RANGE(3),
    REQUESTED_RUN_TIME(4),
    TIME_NOT_SET(0);
    private final int value;

    private TimeCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TimeCase valueOf(int value) {
      return forNumber(value);
    }

    public static TimeCase forNumber(int value) {
      switch (value) {
        case 3:
          return REQUESTED_TIME_RANGE;
        case 4:
          return REQUESTED_RUN_TIME;
        case 0:
          return TIME_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public TimeCase getTimeCase() {
    return TimeCase.forNumber(timeCase_);
  }

  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Required. Transfer configuration name in the form:
   * `projects/{project_id}/transferConfigs/{config_id}` or
   * `projects/{project_id}/locations/{location_id}/transferConfigs/{config_id}`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Transfer configuration name in the form:
   * `projects/{project_id}/transferConfigs/{config_id}` or
   * `projects/{project_id}/locations/{location_id}/transferConfigs/{config_id}`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REQUESTED_TIME_RANGE_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * A time_range start and end timestamp for historical data files or reports
   * that are scheduled to be transferred by the scheduled transfer run.
   * requested_time_range must be a past time and cannot include future time
   * values.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange requested_time_range = 3;
   * </code>
   *
   * @return Whether the requestedTimeRange field is set.
   */
  @java.lang.Override
  public boolean hasRequestedTimeRange() {
    return timeCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * A time_range start and end timestamp for historical data files or reports
   * that are scheduled to be transferred by the scheduled transfer run.
   * requested_time_range must be a past time and cannot include future time
   * values.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange requested_time_range = 3;
   * </code>
   *
   * @return The requestedTimeRange.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange
      getRequestedTimeRange() {
    if (timeCase_ == 3) {
      return (com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange)
          time_;
    }
    return com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A time_range start and end timestamp for historical data files or reports
   * that are scheduled to be transferred by the scheduled transfer run.
   * requested_time_range must be a past time and cannot include future time
   * values.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange requested_time_range = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRangeOrBuilder
      getRequestedTimeRangeOrBuilder() {
    if (timeCase_ == 3) {
      return (com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange)
          time_;
    }
    return com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange
        .getDefaultInstance();
  }

  public static final int REQUESTED_RUN_TIME_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * A run_time timestamp for historical data files or reports
   * that are scheduled to be transferred by the scheduled transfer run.
   * requested_run_time must be a past time and cannot include future time
   * values.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp requested_run_time = 4;</code>
   *
   * @return Whether the requestedRunTime field is set.
   */
  @java.lang.Override
  public boolean hasRequestedRunTime() {
    return timeCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * A run_time timestamp for historical data files or reports
   * that are scheduled to be transferred by the scheduled transfer run.
   * requested_run_time must be a past time and cannot include future time
   * values.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp requested_run_time = 4;</code>
   *
   * @return The requestedRunTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getRequestedRunTime() {
    if (timeCase_ == 4) {
      return (com.google.protobuf.Timestamp) time_;
    }
    return com.google.protobuf.Timestamp.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A run_time timestamp for historical data files or reports
   * that are scheduled to be transferred by the scheduled transfer run.
   * requested_run_time must be a past time and cannot include future time
   * values.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp requested_run_time = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getRequestedRunTimeOrBuilder() {
    if (timeCase_ == 4) {
      return (com.google.protobuf.Timestamp) time_;
    }
    return com.google.protobuf.Timestamp.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (timeCase_ == 3) {
      output.writeMessage(
          3,
          (com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange)
              time_);
    }
    if (timeCase_ == 4) {
      output.writeMessage(4, (com.google.protobuf.Timestamp) time_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (timeCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3,
              (com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange)
                  time_);
    }
    if (timeCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.protobuf.Timestamp) time_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj
        instanceof com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest other =
        (com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (!getTimeCase().equals(other.getTimeCase())) return false;
    switch (timeCase_) {
      case 3:
        if (!getRequestedTimeRange().equals(other.getRequestedTimeRange())) return false;
        break;
      case 4:
        if (!getRequestedRunTime().equals(other.getRequestedRunTime())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    switch (timeCase_) {
      case 3:
        hash = (37 * hash) + REQUESTED_TIME_RANGE_FIELD_NUMBER;
        hash = (53 * hash) + getRequestedTimeRange().hashCode();
        break;
      case 4:
        hash = (37 * hash) + REQUESTED_RUN_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getRequestedRunTime().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A request to start manual transfer runs.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest)
      com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.datatransfer.v1.DataTransferProto
          .internal_static_google_cloud_bigquery_datatransfer_v1_StartManualTransferRunsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.datatransfer.v1.DataTransferProto
          .internal_static_google_cloud_bigquery_datatransfer_v1_StartManualTransferRunsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.class,
              com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.Builder
                  .class);
    }

    // Construct using
    // com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      if (requestedTimeRangeBuilder_ != null) {
        requestedTimeRangeBuilder_.clear();
      }
      if (requestedRunTimeBuilder_ != null) {
        requestedRunTimeBuilder_.clear();
      }
      timeCase_ = 0;
      time_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.bigquery.datatransfer.v1.DataTransferProto
          .internal_static_google_cloud_bigquery_datatransfer_v1_StartManualTransferRunsRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest
        getDefaultInstanceForType() {
      return com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest build() {
      com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest result =
          buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest buildPartial() {
      com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest result =
          new com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
    }

    private void buildPartialOneofs(
        com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest result) {
      result.timeCase_ = timeCase_;
      result.time_ = this.time_;
      if (timeCase_ == 3 && requestedTimeRangeBuilder_ != null) {
        result.time_ = requestedTimeRangeBuilder_.build();
      }
      if (timeCase_ == 4 && requestedRunTimeBuilder_ != null) {
        result.time_ = requestedRunTimeBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other
          instanceof com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest) {
        return mergeFrom(
            (com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest other) {
      if (other
          == com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest
              .getDefaultInstance()) return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      switch (other.getTimeCase()) {
        case REQUESTED_TIME_RANGE:
          {
            mergeRequestedTimeRange(other.getRequestedTimeRange());
            break;
          }
        case REQUESTED_RUN_TIME:
          {
            mergeRequestedRunTime(other.getRequestedRunTime());
            break;
          }
        case TIME_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 26:
              {
                input.readMessage(
                    getRequestedTimeRangeFieldBuilder().getBuilder(), extensionRegistry);
                timeCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getRequestedRunTimeFieldBuilder().getBuilder(), extensionRegistry);
                timeCase_ = 4;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int timeCase_ = 0;
    private java.lang.Object time_;

    public TimeCase getTimeCase() {
      return TimeCase.forNumber(timeCase_);
    }

    public Builder clearTime() {
      timeCase_ = 0;
      time_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. Transfer configuration name in the form:
     * `projects/{project_id}/transferConfigs/{config_id}` or
     * `projects/{project_id}/locations/{location_id}/transferConfigs/{config_id}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Transfer configuration name in the form:
     * `projects/{project_id}/transferConfigs/{config_id}` or
     * `projects/{project_id}/locations/{location_id}/transferConfigs/{config_id}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Transfer configuration name in the form:
     * `projects/{project_id}/transferConfigs/{config_id}` or
     * `projects/{project_id}/locations/{location_id}/transferConfigs/{config_id}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Transfer configuration name in the form:
     * `projects/{project_id}/transferConfigs/{config_id}` or
     * `projects/{project_id}/locations/{location_id}/transferConfigs/{config_id}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Transfer configuration name in the form:
     * `projects/{project_id}/transferConfigs/{config_id}` or
     * `projects/{project_id}/locations/{location_id}/transferConfigs/{config_id}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange,
            com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange
                .Builder,
            com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest
                .TimeRangeOrBuilder>
        requestedTimeRangeBuilder_;
    /**
     *
     *
     * <pre>
     * A time_range start and end timestamp for historical data files or reports
     * that are scheduled to be transferred by the scheduled transfer run.
     * requested_time_range must be a past time and cannot include future time
     * values.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange requested_time_range = 3;
     * </code>
     *
     * @return Whether the requestedTimeRange field is set.
     */
    @java.lang.Override
    public boolean hasRequestedTimeRange() {
      return timeCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * A time_range start and end timestamp for historical data files or reports
     * that are scheduled to be transferred by the scheduled transfer run.
     * requested_time_range must be a past time and cannot include future time
     * values.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange requested_time_range = 3;
     * </code>
     *
     * @return The requestedTimeRange.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange
        getRequestedTimeRange() {
      if (requestedTimeRangeBuilder_ == null) {
        if (timeCase_ == 3) {
          return (com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest
                  .TimeRange)
              time_;
        }
        return com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange
            .getDefaultInstance();
      } else {
        if (timeCase_ == 3) {
          return requestedTimeRangeBuilder_.getMessage();
        }
        return com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A time_range start and end timestamp for historical data files or reports
     * that are scheduled to be transferred by the scheduled transfer run.
     * requested_time_range must be a past time and cannot include future time
     * values.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange requested_time_range = 3;
     * </code>
     */
    public Builder setRequestedTimeRange(
        com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange value) {
      if (requestedTimeRangeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        time_ = value;
        onChanged();
      } else {
        requestedTimeRangeBuilder_.setMessage(value);
      }
      timeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A time_range start and end timestamp for historical data files or reports
     * that are scheduled to be transferred by the scheduled transfer run.
     * requested_time_range must be a past time and cannot include future time
     * values.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange requested_time_range = 3;
     * </code>
     */
    public Builder setRequestedTimeRange(
        com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange.Builder
            builderForValue) {
      if (requestedTimeRangeBuilder_ == null) {
        time_ = builderForValue.build();
        onChanged();
      } else {
        requestedTimeRangeBuilder_.setMessage(builderForValue.build());
      }
      timeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A time_range start and end timestamp for historical data files or reports
     * that are scheduled to be transferred by the scheduled transfer run.
     * requested_time_range must be a past time and cannot include future time
     * values.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange requested_time_range = 3;
     * </code>
     */
    public Builder mergeRequestedTimeRange(
        com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange value) {
      if (requestedTimeRangeBuilder_ == null) {
        if (timeCase_ == 3
            && time_
                != com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest
                    .TimeRange.getDefaultInstance()) {
          time_ =
              com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange
                  .newBuilder(
                      (com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest
                              .TimeRange)
                          time_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          time_ = value;
        }
        onChanged();
      } else {
        if (timeCase_ == 3) {
          requestedTimeRangeBuilder_.mergeFrom(value);
        } else {
          requestedTimeRangeBuilder_.setMessage(value);
        }
      }
      timeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A time_range start and end timestamp for historical data files or reports
     * that are scheduled to be transferred by the scheduled transfer run.
     * requested_time_range must be a past time and cannot include future time
     * values.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange requested_time_range = 3;
     * </code>
     */
    public Builder clearRequestedTimeRange() {
      if (requestedTimeRangeBuilder_ == null) {
        if (timeCase_ == 3) {
          timeCase_ = 0;
          time_ = null;
          onChanged();
        }
      } else {
        if (timeCase_ == 3) {
          timeCase_ = 0;
          time_ = null;
        }
        requestedTimeRangeBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A time_range start and end timestamp for historical data files or reports
     * that are scheduled to be transferred by the scheduled transfer run.
     * requested_time_range must be a past time and cannot include future time
     * values.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange requested_time_range = 3;
     * </code>
     */
    public com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange
            .Builder
        getRequestedTimeRangeBuilder() {
      return getRequestedTimeRangeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A time_range start and end timestamp for historical data files or reports
     * that are scheduled to be transferred by the scheduled transfer run.
     * requested_time_range must be a past time and cannot include future time
     * values.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange requested_time_range = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest
            .TimeRangeOrBuilder
        getRequestedTimeRangeOrBuilder() {
      if ((timeCase_ == 3) && (requestedTimeRangeBuilder_ != null)) {
        return requestedTimeRangeBuilder_.getMessageOrBuilder();
      } else {
        if (timeCase_ == 3) {
          return (com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest
                  .TimeRange)
              time_;
        }
        return com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A time_range start and end timestamp for historical data files or reports
     * that are scheduled to be transferred by the scheduled transfer run.
     * requested_time_range must be a past time and cannot include future time
     * values.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange requested_time_range = 3;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange,
            com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange
                .Builder,
            com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest
                .TimeRangeOrBuilder>
        getRequestedTimeRangeFieldBuilder() {
      if (requestedTimeRangeBuilder_ == null) {
        if (!(timeCase_ == 3)) {
          time_ =
              com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange
                  .getDefaultInstance();
        }
        requestedTimeRangeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange,
                com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange
                    .Builder,
                com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest
                    .TimeRangeOrBuilder>(
                (com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange)
                    time_,
                getParentForChildren(),
                isClean());
        time_ = null;
      }
      timeCase_ = 3;
      onChanged();
      return requestedTimeRangeBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        requestedRunTimeBuilder_;
    /**
     *
     *
     * <pre>
     * A run_time timestamp for historical data files or reports
     * that are scheduled to be transferred by the scheduled transfer run.
     * requested_run_time must be a past time and cannot include future time
     * values.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp requested_run_time = 4;</code>
     *
     * @return Whether the requestedRunTime field is set.
     */
    @java.lang.Override
    public boolean hasRequestedRunTime() {
      return timeCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * A run_time timestamp for historical data files or reports
     * that are scheduled to be transferred by the scheduled transfer run.
     * requested_run_time must be a past time and cannot include future time
     * values.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp requested_run_time = 4;</code>
     *
     * @return The requestedRunTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getRequestedRunTime() {
      if (requestedRunTimeBuilder_ == null) {
        if (timeCase_ == 4) {
          return (com.google.protobuf.Timestamp) time_;
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      } else {
        if (timeCase_ == 4) {
          return requestedRunTimeBuilder_.getMessage();
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A run_time timestamp for historical data files or reports
     * that are scheduled to be transferred by the scheduled transfer run.
     * requested_run_time must be a past time and cannot include future time
     * values.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp requested_run_time = 4;</code>
     */
    public Builder setRequestedRunTime(com.google.protobuf.Timestamp value) {
      if (requestedRunTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        time_ = value;
        onChanged();
      } else {
        requestedRunTimeBuilder_.setMessage(value);
      }
      timeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A run_time timestamp for historical data files or reports
     * that are scheduled to be transferred by the scheduled transfer run.
     * requested_run_time must be a past time and cannot include future time
     * values.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp requested_run_time = 4;</code>
     */
    public Builder setRequestedRunTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (requestedRunTimeBuilder_ == null) {
        time_ = builderForValue.build();
        onChanged();
      } else {
        requestedRunTimeBuilder_.setMessage(builderForValue.build());
      }
      timeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A run_time timestamp for historical data files or reports
     * that are scheduled to be transferred by the scheduled transfer run.
     * requested_run_time must be a past time and cannot include future time
     * values.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp requested_run_time = 4;</code>
     */
    public Builder mergeRequestedRunTime(com.google.protobuf.Timestamp value) {
      if (requestedRunTimeBuilder_ == null) {
        if (timeCase_ == 4 && time_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          time_ =
              com.google.protobuf.Timestamp.newBuilder((com.google.protobuf.Timestamp) time_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          time_ = value;
        }
        onChanged();
      } else {
        if (timeCase_ == 4) {
          requestedRunTimeBuilder_.mergeFrom(value);
        } else {
          requestedRunTimeBuilder_.setMessage(value);
        }
      }
      timeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A run_time timestamp for historical data files or reports
     * that are scheduled to be transferred by the scheduled transfer run.
     * requested_run_time must be a past time and cannot include future time
     * values.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp requested_run_time = 4;</code>
     */
    public Builder clearRequestedRunTime() {
      if (requestedRunTimeBuilder_ == null) {
        if (timeCase_ == 4) {
          timeCase_ = 0;
          time_ = null;
          onChanged();
        }
      } else {
        if (timeCase_ == 4) {
          timeCase_ = 0;
          time_ = null;
        }
        requestedRunTimeBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A run_time timestamp for historical data files or reports
     * that are scheduled to be transferred by the scheduled transfer run.
     * requested_run_time must be a past time and cannot include future time
     * values.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp requested_run_time = 4;</code>
     */
    public com.google.protobuf.Timestamp.Builder getRequestedRunTimeBuilder() {
      return getRequestedRunTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A run_time timestamp for historical data files or reports
     * that are scheduled to be transferred by the scheduled transfer run.
     * requested_run_time must be a past time and cannot include future time
     * values.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp requested_run_time = 4;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getRequestedRunTimeOrBuilder() {
      if ((timeCase_ == 4) && (requestedRunTimeBuilder_ != null)) {
        return requestedRunTimeBuilder_.getMessageOrBuilder();
      } else {
        if (timeCase_ == 4) {
          return (com.google.protobuf.Timestamp) time_;
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A run_time timestamp for historical data files or reports
     * that are scheduled to be transferred by the scheduled transfer run.
     * requested_run_time must be a past time and cannot include future time
     * values.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp requested_run_time = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getRequestedRunTimeFieldBuilder() {
      if (requestedRunTimeBuilder_ == null) {
        if (!(timeCase_ == 4)) {
          time_ = com.google.protobuf.Timestamp.getDefaultInstance();
        }
        requestedRunTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                (com.google.protobuf.Timestamp) time_, getParentForChildren(), isClean());
        time_ = null;
      }
      timeCase_ = 4;
      onChanged();
      return requestedRunTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest)
  private static final com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE =
        new com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest();
  }

  public static com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<StartManualTransferRunsRequest> PARSER =
      new com.google.protobuf.AbstractParser<StartManualTransferRunsRequest>() {
        @java.lang.Override
        public StartManualTransferRunsRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<StartManualTransferRunsRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<StartManualTransferRunsRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
