/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/datatransfer/v1/transfer.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.bigquery.datatransfer.v1;

/**
 *
 *
 * <pre>
 * Represents a data transfer configuration. A transfer configuration
 * contains all metadata needed to perform a data transfer. For example,
 * `destination_dataset_id` specifies where data should be stored.
 * When a new transfer configuration is created, the specified
 * `destination_dataset_id` is created when needed and shared with the
 * appropriate data source service account.
 * </pre>
 *
 * Protobuf type {@code google.cloud.bigquery.datatransfer.v1.TransferConfig}
 */
public final class TransferConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.bigquery.datatransfer.v1.TransferConfig)
    TransferConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TransferConfig.newBuilder() to construct.
  private TransferConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TransferConfig() {
    name_ = "";
    displayName_ = "";
    dataSourceId_ = "";
    schedule_ = "";
    state_ = 0;
    datasetRegion_ = "";
    notificationPubsubTopic_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TransferConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.bigquery.datatransfer.v1.TransferProto
        .internal_static_google_cloud_bigquery_datatransfer_v1_TransferConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.bigquery.datatransfer.v1.TransferProto
        .internal_static_google_cloud_bigquery_datatransfer_v1_TransferConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.bigquery.datatransfer.v1.TransferConfig.class,
            com.google.cloud.bigquery.datatransfer.v1.TransferConfig.Builder.class);
  }

  private int bitField0_;
  private int destinationCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object destination_;

  public enum DestinationCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    DESTINATION_DATASET_ID(2),
    DESTINATION_NOT_SET(0);
    private final int value;

    private DestinationCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DestinationCase valueOf(int value) {
      return forNumber(value);
    }

    public static DestinationCase forNumber(int value) {
      switch (value) {
        case 2:
          return DESTINATION_DATASET_ID;
        case 0:
          return DESTINATION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public DestinationCase getDestinationCase() {
    return DestinationCase.forNumber(destinationCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Identifier. The resource name of the transfer config.
   * Transfer config names have the form either
   * `projects/{project_id}/locations/{region}/transferConfigs/{config_id}` or
   * `projects/{project_id}/transferConfigs/{config_id}`,
   * where `config_id` is usually a UUID, even though it is not
   * guaranteed or required. The name is ignored when creating a transfer
   * config.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Identifier. The resource name of the transfer config.
   * Transfer config names have the form either
   * `projects/{project_id}/locations/{region}/transferConfigs/{config_id}` or
   * `projects/{project_id}/transferConfigs/{config_id}`,
   * where `config_id` is usually a UUID, even though it is not
   * guaranteed or required. The name is ignored when creating a transfer
   * config.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESTINATION_DATASET_ID_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * The BigQuery target dataset id.
   * </pre>
   *
   * <code>string destination_dataset_id = 2;</code>
   *
   * @return Whether the destinationDatasetId field is set.
   */
  public boolean hasDestinationDatasetId() {
    return destinationCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * The BigQuery target dataset id.
   * </pre>
   *
   * <code>string destination_dataset_id = 2;</code>
   *
   * @return The destinationDatasetId.
   */
  public java.lang.String getDestinationDatasetId() {
    java.lang.Object ref = "";
    if (destinationCase_ == 2) {
      ref = destination_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (destinationCase_ == 2) {
        destination_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The BigQuery target dataset id.
   * </pre>
   *
   * <code>string destination_dataset_id = 2;</code>
   *
   * @return The bytes for destinationDatasetId.
   */
  public com.google.protobuf.ByteString getDestinationDatasetIdBytes() {
    java.lang.Object ref = "";
    if (destinationCase_ == 2) {
      ref = destination_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (destinationCase_ == 2) {
        destination_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * User specified display name for the data transfer.
   * </pre>
   *
   * <code>string display_name = 3;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * User specified display name for the data transfer.
   * </pre>
   *
   * <code>string display_name = 3;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATA_SOURCE_ID_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object dataSourceId_ = "";
  /**
   *
   *
   * <pre>
   * Data source ID. This cannot be changed once data transfer is created. The
   * full list of available data source IDs can be returned through an API call:
   * https://cloud.google.com/bigquery-transfer/docs/reference/datatransfer/rest/v1/projects.locations.dataSources/list
   * </pre>
   *
   * <code>string data_source_id = 5;</code>
   *
   * @return The dataSourceId.
   */
  @java.lang.Override
  public java.lang.String getDataSourceId() {
    java.lang.Object ref = dataSourceId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      dataSourceId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Data source ID. This cannot be changed once data transfer is created. The
   * full list of available data source IDs can be returned through an API call:
   * https://cloud.google.com/bigquery-transfer/docs/reference/datatransfer/rest/v1/projects.locations.dataSources/list
   * </pre>
   *
   * <code>string data_source_id = 5;</code>
   *
   * @return The bytes for dataSourceId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDataSourceIdBytes() {
    java.lang.Object ref = dataSourceId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      dataSourceId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PARAMS_FIELD_NUMBER = 9;
  private com.google.protobuf.Struct params_;
  /**
   *
   *
   * <pre>
   * Parameters specific to each data source. For more information see the
   * bq tab in the 'Setting up a data transfer' section for each data source.
   * For example the parameters for Cloud Storage transfers are listed here:
   * https://cloud.google.com/bigquery-transfer/docs/cloud-storage-transfer#bq
   * </pre>
   *
   * <code>.google.protobuf.Struct params = 9;</code>
   *
   * @return Whether the params field is set.
   */
  @java.lang.Override
  public boolean hasParams() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Parameters specific to each data source. For more information see the
   * bq tab in the 'Setting up a data transfer' section for each data source.
   * For example the parameters for Cloud Storage transfers are listed here:
   * https://cloud.google.com/bigquery-transfer/docs/cloud-storage-transfer#bq
   * </pre>
   *
   * <code>.google.protobuf.Struct params = 9;</code>
   *
   * @return The params.
   */
  @java.lang.Override
  public com.google.protobuf.Struct getParams() {
    return params_ == null ? com.google.protobuf.Struct.getDefaultInstance() : params_;
  }
  /**
   *
   *
   * <pre>
   * Parameters specific to each data source. For more information see the
   * bq tab in the 'Setting up a data transfer' section for each data source.
   * For example the parameters for Cloud Storage transfers are listed here:
   * https://cloud.google.com/bigquery-transfer/docs/cloud-storage-transfer#bq
   * </pre>
   *
   * <code>.google.protobuf.Struct params = 9;</code>
   */
  @java.lang.Override
  public com.google.protobuf.StructOrBuilder getParamsOrBuilder() {
    return params_ == null ? com.google.protobuf.Struct.getDefaultInstance() : params_;
  }

  public static final int SCHEDULE_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object schedule_ = "";
  /**
   *
   *
   * <pre>
   * Data transfer schedule.
   * If the data source does not support a custom schedule, this should be
   * empty. If it is empty, the default value for the data source will be used.
   * The specified times are in UTC.
   * Examples of valid format:
   * `1st,3rd monday of month 15:30`,
   * `every wed,fri of jan,jun 13:15`, and
   * `first sunday of quarter 00:00`.
   * See more explanation about the format here:
   * https://cloud.google.com/appengine/docs/flexible/python/scheduling-jobs-with-cron-yaml#the_schedule_format
   *
   * NOTE: The minimum interval time between recurring transfers depends on the
   * data source; refer to the documentation for your data source.
   * </pre>
   *
   * <code>string schedule = 7;</code>
   *
   * @return The schedule.
   */
  @java.lang.Override
  public java.lang.String getSchedule() {
    java.lang.Object ref = schedule_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      schedule_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Data transfer schedule.
   * If the data source does not support a custom schedule, this should be
   * empty. If it is empty, the default value for the data source will be used.
   * The specified times are in UTC.
   * Examples of valid format:
   * `1st,3rd monday of month 15:30`,
   * `every wed,fri of jan,jun 13:15`, and
   * `first sunday of quarter 00:00`.
   * See more explanation about the format here:
   * https://cloud.google.com/appengine/docs/flexible/python/scheduling-jobs-with-cron-yaml#the_schedule_format
   *
   * NOTE: The minimum interval time between recurring transfers depends on the
   * data source; refer to the documentation for your data source.
   * </pre>
   *
   * <code>string schedule = 7;</code>
   *
   * @return The bytes for schedule.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getScheduleBytes() {
    java.lang.Object ref = schedule_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      schedule_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SCHEDULE_OPTIONS_FIELD_NUMBER = 24;
  private com.google.cloud.bigquery.datatransfer.v1.ScheduleOptions scheduleOptions_;
  /**
   *
   *
   * <pre>
   * Options customizing the data transfer schedule.
   * </pre>
   *
   * <code>.google.cloud.bigquery.datatransfer.v1.ScheduleOptions schedule_options = 24;</code>
   *
   * @return Whether the scheduleOptions field is set.
   */
  @java.lang.Override
  public boolean hasScheduleOptions() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Options customizing the data transfer schedule.
   * </pre>
   *
   * <code>.google.cloud.bigquery.datatransfer.v1.ScheduleOptions schedule_options = 24;</code>
   *
   * @return The scheduleOptions.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.datatransfer.v1.ScheduleOptions getScheduleOptions() {
    return scheduleOptions_ == null
        ? com.google.cloud.bigquery.datatransfer.v1.ScheduleOptions.getDefaultInstance()
        : scheduleOptions_;
  }
  /**
   *
   *
   * <pre>
   * Options customizing the data transfer schedule.
   * </pre>
   *
   * <code>.google.cloud.bigquery.datatransfer.v1.ScheduleOptions schedule_options = 24;</code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.datatransfer.v1.ScheduleOptionsOrBuilder
      getScheduleOptionsOrBuilder() {
    return scheduleOptions_ == null
        ? com.google.cloud.bigquery.datatransfer.v1.ScheduleOptions.getDefaultInstance()
        : scheduleOptions_;
  }

  public static final int DATA_REFRESH_WINDOW_DAYS_FIELD_NUMBER = 12;
  private int dataRefreshWindowDays_ = 0;
  /**
   *
   *
   * <pre>
   * The number of days to look back to automatically refresh the data.
   * For example, if `data_refresh_window_days = 10`, then every day
   * BigQuery reingests data for [today-10, today-1], rather than ingesting data
   * for just [today-1].
   * Only valid if the data source supports the feature. Set the value to 0
   * to use the default value.
   * </pre>
   *
   * <code>int32 data_refresh_window_days = 12;</code>
   *
   * @return The dataRefreshWindowDays.
   */
  @java.lang.Override
  public int getDataRefreshWindowDays() {
    return dataRefreshWindowDays_;
  }

  public static final int DISABLED_FIELD_NUMBER = 13;
  private boolean disabled_ = false;
  /**
   *
   *
   * <pre>
   * Is this config disabled. When set to true, no runs will be scheduled for
   * this transfer config.
   * </pre>
   *
   * <code>bool disabled = 13;</code>
   *
   * @return The disabled.
   */
  @java.lang.Override
  public boolean getDisabled() {
    return disabled_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Data transfer modification time. Ignored by server on input.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Data transfer modification time. Ignored by server on input.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Data transfer modification time. Ignored by server on input.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int NEXT_RUN_TIME_FIELD_NUMBER = 8;
  private com.google.protobuf.Timestamp nextRunTime_;
  /**
   *
   *
   * <pre>
   * Output only. Next time when data transfer will run.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp next_run_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the nextRunTime field is set.
   */
  @java.lang.Override
  public boolean hasNextRunTime() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Next time when data transfer will run.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp next_run_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The nextRunTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getNextRunTime() {
    return nextRunTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : nextRunTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Next time when data transfer will run.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp next_run_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getNextRunTimeOrBuilder() {
    return nextRunTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : nextRunTime_;
  }

  public static final int STATE_FIELD_NUMBER = 10;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. State of the most recently updated transfer run.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.datatransfer.v1.TransferState state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. State of the most recently updated transfer run.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.datatransfer.v1.TransferState state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.datatransfer.v1.TransferState getState() {
    com.google.cloud.bigquery.datatransfer.v1.TransferState result =
        com.google.cloud.bigquery.datatransfer.v1.TransferState.forNumber(state_);
    return result == null
        ? com.google.cloud.bigquery.datatransfer.v1.TransferState.UNRECOGNIZED
        : result;
  }

  public static final int USER_ID_FIELD_NUMBER = 11;
  private long userId_ = 0L;
  /**
   *
   *
   * <pre>
   * Deprecated. Unique ID of the user on whose behalf transfer is done.
   * </pre>
   *
   * <code>int64 user_id = 11;</code>
   *
   * @return The userId.
   */
  @java.lang.Override
  public long getUserId() {
    return userId_;
  }

  public static final int DATASET_REGION_FIELD_NUMBER = 14;

  @SuppressWarnings("serial")
  private volatile java.lang.Object datasetRegion_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Region in which BigQuery dataset is located.
   * </pre>
   *
   * <code>string dataset_region = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The datasetRegion.
   */
  @java.lang.Override
  public java.lang.String getDatasetRegion() {
    java.lang.Object ref = datasetRegion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      datasetRegion_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Region in which BigQuery dataset is located.
   * </pre>
   *
   * <code>string dataset_region = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for datasetRegion.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDatasetRegionBytes() {
    java.lang.Object ref = datasetRegion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      datasetRegion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NOTIFICATION_PUBSUB_TOPIC_FIELD_NUMBER = 15;

  @SuppressWarnings("serial")
  private volatile java.lang.Object notificationPubsubTopic_ = "";
  /**
   *
   *
   * <pre>
   * Pub/Sub topic where notifications will be sent after transfer runs
   * associated with this transfer config finish.
   *
   * The format for specifying a pubsub topic is:
   * `projects/{project_id}/topics/{topic_id}`
   * </pre>
   *
   * <code>string notification_pubsub_topic = 15;</code>
   *
   * @return The notificationPubsubTopic.
   */
  @java.lang.Override
  public java.lang.String getNotificationPubsubTopic() {
    java.lang.Object ref = notificationPubsubTopic_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      notificationPubsubTopic_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Pub/Sub topic where notifications will be sent after transfer runs
   * associated with this transfer config finish.
   *
   * The format for specifying a pubsub topic is:
   * `projects/{project_id}/topics/{topic_id}`
   * </pre>
   *
   * <code>string notification_pubsub_topic = 15;</code>
   *
   * @return The bytes for notificationPubsubTopic.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNotificationPubsubTopicBytes() {
    java.lang.Object ref = notificationPubsubTopic_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      notificationPubsubTopic_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EMAIL_PREFERENCES_FIELD_NUMBER = 18;
  private com.google.cloud.bigquery.datatransfer.v1.EmailPreferences emailPreferences_;
  /**
   *
   *
   * <pre>
   * Email notifications will be sent according to these preferences
   * to the email address of the user who owns this transfer config.
   * </pre>
   *
   * <code>.google.cloud.bigquery.datatransfer.v1.EmailPreferences email_preferences = 18;</code>
   *
   * @return Whether the emailPreferences field is set.
   */
  @java.lang.Override
  public boolean hasEmailPreferences() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Email notifications will be sent according to these preferences
   * to the email address of the user who owns this transfer config.
   * </pre>
   *
   * <code>.google.cloud.bigquery.datatransfer.v1.EmailPreferences email_preferences = 18;</code>
   *
   * @return The emailPreferences.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.datatransfer.v1.EmailPreferences getEmailPreferences() {
    return emailPreferences_ == null
        ? com.google.cloud.bigquery.datatransfer.v1.EmailPreferences.getDefaultInstance()
        : emailPreferences_;
  }
  /**
   *
   *
   * <pre>
   * Email notifications will be sent according to these preferences
   * to the email address of the user who owns this transfer config.
   * </pre>
   *
   * <code>.google.cloud.bigquery.datatransfer.v1.EmailPreferences email_preferences = 18;</code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.datatransfer.v1.EmailPreferencesOrBuilder
      getEmailPreferencesOrBuilder() {
    return emailPreferences_ == null
        ? com.google.cloud.bigquery.datatransfer.v1.EmailPreferences.getDefaultInstance()
        : emailPreferences_;
  }

  public static final int OWNER_INFO_FIELD_NUMBER = 27;
  private com.google.cloud.bigquery.datatransfer.v1.UserInfo ownerInfo_;
  /**
   *
   *
   * <pre>
   * Output only. Information about the user whose credentials are used to
   * transfer data. Populated only for `transferConfigs.get` requests. In case
   * the user information is not available, this field will not be populated.
   * </pre>
   *
   * <code>
   * optional .google.cloud.bigquery.datatransfer.v1.UserInfo owner_info = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the ownerInfo field is set.
   */
  @java.lang.Override
  public boolean hasOwnerInfo() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Information about the user whose credentials are used to
   * transfer data. Populated only for `transferConfigs.get` requests. In case
   * the user information is not available, this field will not be populated.
   * </pre>
   *
   * <code>
   * optional .google.cloud.bigquery.datatransfer.v1.UserInfo owner_info = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The ownerInfo.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.datatransfer.v1.UserInfo getOwnerInfo() {
    return ownerInfo_ == null
        ? com.google.cloud.bigquery.datatransfer.v1.UserInfo.getDefaultInstance()
        : ownerInfo_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Information about the user whose credentials are used to
   * transfer data. Populated only for `transferConfigs.get` requests. In case
   * the user information is not available, this field will not be populated.
   * </pre>
   *
   * <code>
   * optional .google.cloud.bigquery.datatransfer.v1.UserInfo owner_info = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.datatransfer.v1.UserInfoOrBuilder getOwnerInfoOrBuilder() {
    return ownerInfo_ == null
        ? com.google.cloud.bigquery.datatransfer.v1.UserInfo.getDefaultInstance()
        : ownerInfo_;
  }

  public static final int ENCRYPTION_CONFIGURATION_FIELD_NUMBER = 28;
  private com.google.cloud.bigquery.datatransfer.v1.EncryptionConfiguration
      encryptionConfiguration_;
  /**
   *
   *
   * <pre>
   * The encryption configuration part. Currently, it is only used for the
   * optional KMS key name. The BigQuery service account of your project must be
   * granted permissions to use the key. Read methods will return the key name
   * applied in effect. Write methods will apply the key if it is present, or
   * otherwise try to apply project default keys if it is absent.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.datatransfer.v1.EncryptionConfiguration encryption_configuration = 28;
   * </code>
   *
   * @return Whether the encryptionConfiguration field is set.
   */
  @java.lang.Override
  public boolean hasEncryptionConfiguration() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * The encryption configuration part. Currently, it is only used for the
   * optional KMS key name. The BigQuery service account of your project must be
   * granted permissions to use the key. Read methods will return the key name
   * applied in effect. Write methods will apply the key if it is present, or
   * otherwise try to apply project default keys if it is absent.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.datatransfer.v1.EncryptionConfiguration encryption_configuration = 28;
   * </code>
   *
   * @return The encryptionConfiguration.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.datatransfer.v1.EncryptionConfiguration
      getEncryptionConfiguration() {
    return encryptionConfiguration_ == null
        ? com.google.cloud.bigquery.datatransfer.v1.EncryptionConfiguration.getDefaultInstance()
        : encryptionConfiguration_;
  }
  /**
   *
   *
   * <pre>
   * The encryption configuration part. Currently, it is only used for the
   * optional KMS key name. The BigQuery service account of your project must be
   * granted permissions to use the key. Read methods will return the key name
   * applied in effect. Write methods will apply the key if it is present, or
   * otherwise try to apply project default keys if it is absent.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.datatransfer.v1.EncryptionConfiguration encryption_configuration = 28;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.datatransfer.v1.EncryptionConfigurationOrBuilder
      getEncryptionConfigurationOrBuilder() {
    return encryptionConfiguration_ == null
        ? com.google.cloud.bigquery.datatransfer.v1.EncryptionConfiguration.getDefaultInstance()
        : encryptionConfiguration_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (destinationCase_ == 2) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, destination_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, displayName_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(4, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataSourceId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, dataSourceId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(schedule_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, schedule_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(8, getNextRunTime());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(9, getParams());
    }
    if (state_
        != com.google.cloud.bigquery.datatransfer.v1.TransferState.TRANSFER_STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(10, state_);
    }
    if (userId_ != 0L) {
      output.writeInt64(11, userId_);
    }
    if (dataRefreshWindowDays_ != 0) {
      output.writeInt32(12, dataRefreshWindowDays_);
    }
    if (disabled_ != false) {
      output.writeBool(13, disabled_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(datasetRegion_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 14, datasetRegion_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(notificationPubsubTopic_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 15, notificationPubsubTopic_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(18, getEmailPreferences());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(24, getScheduleOptions());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(27, getOwnerInfo());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeMessage(28, getEncryptionConfiguration());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (destinationCase_ == 2) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, destination_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, displayName_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataSourceId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, dataSourceId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(schedule_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, schedule_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getNextRunTime());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getParams());
    }
    if (state_
        != com.google.cloud.bigquery.datatransfer.v1.TransferState.TRANSFER_STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(10, state_);
    }
    if (userId_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(11, userId_);
    }
    if (dataRefreshWindowDays_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(12, dataRefreshWindowDays_);
    }
    if (disabled_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(13, disabled_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(datasetRegion_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(14, datasetRegion_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(notificationPubsubTopic_)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(15, notificationPubsubTopic_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(18, getEmailPreferences());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(24, getScheduleOptions());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(27, getOwnerInfo());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              28, getEncryptionConfiguration());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.bigquery.datatransfer.v1.TransferConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.bigquery.datatransfer.v1.TransferConfig other =
        (com.google.cloud.bigquery.datatransfer.v1.TransferConfig) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getDataSourceId().equals(other.getDataSourceId())) return false;
    if (hasParams() != other.hasParams()) return false;
    if (hasParams()) {
      if (!getParams().equals(other.getParams())) return false;
    }
    if (!getSchedule().equals(other.getSchedule())) return false;
    if (hasScheduleOptions() != other.hasScheduleOptions()) return false;
    if (hasScheduleOptions()) {
      if (!getScheduleOptions().equals(other.getScheduleOptions())) return false;
    }
    if (getDataRefreshWindowDays() != other.getDataRefreshWindowDays()) return false;
    if (getDisabled() != other.getDisabled()) return false;
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (hasNextRunTime() != other.hasNextRunTime()) return false;
    if (hasNextRunTime()) {
      if (!getNextRunTime().equals(other.getNextRunTime())) return false;
    }
    if (state_ != other.state_) return false;
    if (getUserId() != other.getUserId()) return false;
    if (!getDatasetRegion().equals(other.getDatasetRegion())) return false;
    if (!getNotificationPubsubTopic().equals(other.getNotificationPubsubTopic())) return false;
    if (hasEmailPreferences() != other.hasEmailPreferences()) return false;
    if (hasEmailPreferences()) {
      if (!getEmailPreferences().equals(other.getEmailPreferences())) return false;
    }
    if (hasOwnerInfo() != other.hasOwnerInfo()) return false;
    if (hasOwnerInfo()) {
      if (!getOwnerInfo().equals(other.getOwnerInfo())) return false;
    }
    if (hasEncryptionConfiguration() != other.hasEncryptionConfiguration()) return false;
    if (hasEncryptionConfiguration()) {
      if (!getEncryptionConfiguration().equals(other.getEncryptionConfiguration())) return false;
    }
    if (!getDestinationCase().equals(other.getDestinationCase())) return false;
    switch (destinationCase_) {
      case 2:
        if (!getDestinationDatasetId().equals(other.getDestinationDatasetId())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + DATA_SOURCE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getDataSourceId().hashCode();
    if (hasParams()) {
      hash = (37 * hash) + PARAMS_FIELD_NUMBER;
      hash = (53 * hash) + getParams().hashCode();
    }
    hash = (37 * hash) + SCHEDULE_FIELD_NUMBER;
    hash = (53 * hash) + getSchedule().hashCode();
    if (hasScheduleOptions()) {
      hash = (37 * hash) + SCHEDULE_OPTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getScheduleOptions().hashCode();
    }
    hash = (37 * hash) + DATA_REFRESH_WINDOW_DAYS_FIELD_NUMBER;
    hash = (53 * hash) + getDataRefreshWindowDays();
    hash = (37 * hash) + DISABLED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDisabled());
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (hasNextRunTime()) {
      hash = (37 * hash) + NEXT_RUN_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getNextRunTime().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + USER_ID_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getUserId());
    hash = (37 * hash) + DATASET_REGION_FIELD_NUMBER;
    hash = (53 * hash) + getDatasetRegion().hashCode();
    hash = (37 * hash) + NOTIFICATION_PUBSUB_TOPIC_FIELD_NUMBER;
    hash = (53 * hash) + getNotificationPubsubTopic().hashCode();
    if (hasEmailPreferences()) {
      hash = (37 * hash) + EMAIL_PREFERENCES_FIELD_NUMBER;
      hash = (53 * hash) + getEmailPreferences().hashCode();
    }
    if (hasOwnerInfo()) {
      hash = (37 * hash) + OWNER_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getOwnerInfo().hashCode();
    }
    if (hasEncryptionConfiguration()) {
      hash = (37 * hash) + ENCRYPTION_CONFIGURATION_FIELD_NUMBER;
      hash = (53 * hash) + getEncryptionConfiguration().hashCode();
    }
    switch (destinationCase_) {
      case 2:
        hash = (37 * hash) + DESTINATION_DATASET_ID_FIELD_NUMBER;
        hash = (53 * hash) + getDestinationDatasetId().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.bigquery.datatransfer.v1.TransferConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.TransferConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.TransferConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.TransferConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.TransferConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.TransferConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.TransferConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.TransferConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.TransferConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.TransferConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.TransferConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.TransferConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.bigquery.datatransfer.v1.TransferConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents a data transfer configuration. A transfer configuration
   * contains all metadata needed to perform a data transfer. For example,
   * `destination_dataset_id` specifies where data should be stored.
   * When a new transfer configuration is created, the specified
   * `destination_dataset_id` is created when needed and shared with the
   * appropriate data source service account.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.datatransfer.v1.TransferConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.datatransfer.v1.TransferConfig)
      com.google.cloud.bigquery.datatransfer.v1.TransferConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.datatransfer.v1.TransferProto
          .internal_static_google_cloud_bigquery_datatransfer_v1_TransferConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.datatransfer.v1.TransferProto
          .internal_static_google_cloud_bigquery_datatransfer_v1_TransferConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.datatransfer.v1.TransferConfig.class,
              com.google.cloud.bigquery.datatransfer.v1.TransferConfig.Builder.class);
    }

    // Construct using com.google.cloud.bigquery.datatransfer.v1.TransferConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getParamsFieldBuilder();
        getScheduleOptionsFieldBuilder();
        getUpdateTimeFieldBuilder();
        getNextRunTimeFieldBuilder();
        getEmailPreferencesFieldBuilder();
        getOwnerInfoFieldBuilder();
        getEncryptionConfigurationFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      dataSourceId_ = "";
      params_ = null;
      if (paramsBuilder_ != null) {
        paramsBuilder_.dispose();
        paramsBuilder_ = null;
      }
      schedule_ = "";
      scheduleOptions_ = null;
      if (scheduleOptionsBuilder_ != null) {
        scheduleOptionsBuilder_.dispose();
        scheduleOptionsBuilder_ = null;
      }
      dataRefreshWindowDays_ = 0;
      disabled_ = false;
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      nextRunTime_ = null;
      if (nextRunTimeBuilder_ != null) {
        nextRunTimeBuilder_.dispose();
        nextRunTimeBuilder_ = null;
      }
      state_ = 0;
      userId_ = 0L;
      datasetRegion_ = "";
      notificationPubsubTopic_ = "";
      emailPreferences_ = null;
      if (emailPreferencesBuilder_ != null) {
        emailPreferencesBuilder_.dispose();
        emailPreferencesBuilder_ = null;
      }
      ownerInfo_ = null;
      if (ownerInfoBuilder_ != null) {
        ownerInfoBuilder_.dispose();
        ownerInfoBuilder_ = null;
      }
      encryptionConfiguration_ = null;
      if (encryptionConfigurationBuilder_ != null) {
        encryptionConfigurationBuilder_.dispose();
        encryptionConfigurationBuilder_ = null;
      }
      destinationCase_ = 0;
      destination_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.bigquery.datatransfer.v1.TransferProto
          .internal_static_google_cloud_bigquery_datatransfer_v1_TransferConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.datatransfer.v1.TransferConfig getDefaultInstanceForType() {
      return com.google.cloud.bigquery.datatransfer.v1.TransferConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.bigquery.datatransfer.v1.TransferConfig build() {
      com.google.cloud.bigquery.datatransfer.v1.TransferConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.datatransfer.v1.TransferConfig buildPartial() {
      com.google.cloud.bigquery.datatransfer.v1.TransferConfig result =
          new com.google.cloud.bigquery.datatransfer.v1.TransferConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.bigquery.datatransfer.v1.TransferConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.dataSourceId_ = dataSourceId_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.params_ = paramsBuilder_ == null ? params_ : paramsBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.schedule_ = schedule_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.scheduleOptions_ =
            scheduleOptionsBuilder_ == null ? scheduleOptions_ : scheduleOptionsBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.dataRefreshWindowDays_ = dataRefreshWindowDays_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.disabled_ = disabled_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.nextRunTime_ =
            nextRunTimeBuilder_ == null ? nextRunTime_ : nextRunTimeBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.userId_ = userId_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.datasetRegion_ = datasetRegion_;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.notificationPubsubTopic_ = notificationPubsubTopic_;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.emailPreferences_ =
            emailPreferencesBuilder_ == null ? emailPreferences_ : emailPreferencesBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.ownerInfo_ = ownerInfoBuilder_ == null ? ownerInfo_ : ownerInfoBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.encryptionConfiguration_ =
            encryptionConfigurationBuilder_ == null
                ? encryptionConfiguration_
                : encryptionConfigurationBuilder_.build();
        to_bitField0_ |= 0x00000040;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(
        com.google.cloud.bigquery.datatransfer.v1.TransferConfig result) {
      result.destinationCase_ = destinationCase_;
      result.destination_ = this.destination_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.bigquery.datatransfer.v1.TransferConfig) {
        return mergeFrom((com.google.cloud.bigquery.datatransfer.v1.TransferConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.bigquery.datatransfer.v1.TransferConfig other) {
      if (other == com.google.cloud.bigquery.datatransfer.v1.TransferConfig.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getDataSourceId().isEmpty()) {
        dataSourceId_ = other.dataSourceId_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasParams()) {
        mergeParams(other.getParams());
      }
      if (!other.getSchedule().isEmpty()) {
        schedule_ = other.schedule_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasScheduleOptions()) {
        mergeScheduleOptions(other.getScheduleOptions());
      }
      if (other.getDataRefreshWindowDays() != 0) {
        setDataRefreshWindowDays(other.getDataRefreshWindowDays());
      }
      if (other.getDisabled() != false) {
        setDisabled(other.getDisabled());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.hasNextRunTime()) {
        mergeNextRunTime(other.getNextRunTime());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.getUserId() != 0L) {
        setUserId(other.getUserId());
      }
      if (!other.getDatasetRegion().isEmpty()) {
        datasetRegion_ = other.datasetRegion_;
        bitField0_ |= 0x00002000;
        onChanged();
      }
      if (!other.getNotificationPubsubTopic().isEmpty()) {
        notificationPubsubTopic_ = other.notificationPubsubTopic_;
        bitField0_ |= 0x00004000;
        onChanged();
      }
      if (other.hasEmailPreferences()) {
        mergeEmailPreferences(other.getEmailPreferences());
      }
      if (other.hasOwnerInfo()) {
        mergeOwnerInfo(other.getOwnerInfo());
      }
      if (other.hasEncryptionConfiguration()) {
        mergeEncryptionConfiguration(other.getEncryptionConfiguration());
      }
      switch (other.getDestinationCase()) {
        case DESTINATION_DATASET_ID:
          {
            destinationCase_ = 2;
            destination_ = other.destination_;
            onChanged();
            break;
          }
        case DESTINATION_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                destinationCase_ = 2;
                destination_ = s;
                break;
              } // case 18
            case 26:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 34
            case 42:
              {
                dataSourceId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 42
            case 58:
              {
                schedule_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getNextRunTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getParamsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 74
            case 80:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000800;
                break;
              } // case 80
            case 88:
              {
                userId_ = input.readInt64();
                bitField0_ |= 0x00001000;
                break;
              } // case 88
            case 96:
              {
                dataRefreshWindowDays_ = input.readInt32();
                bitField0_ |= 0x00000080;
                break;
              } // case 96
            case 104:
              {
                disabled_ = input.readBool();
                bitField0_ |= 0x00000100;
                break;
              } // case 104
            case 114:
              {
                datasetRegion_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00002000;
                break;
              } // case 114
            case 122:
              {
                notificationPubsubTopic_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00004000;
                break;
              } // case 122
            case 146:
              {
                input.readMessage(
                    getEmailPreferencesFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00008000;
                break;
              } // case 146
            case 194:
              {
                input.readMessage(getScheduleOptionsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 194
            case 218:
              {
                input.readMessage(getOwnerInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00010000;
                break;
              } // case 218
            case 226:
              {
                input.readMessage(
                    getEncryptionConfigurationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00020000;
                break;
              } // case 226
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int destinationCase_ = 0;
    private java.lang.Object destination_;

    public DestinationCase getDestinationCase() {
      return DestinationCase.forNumber(destinationCase_);
    }

    public Builder clearDestination() {
      destinationCase_ = 0;
      destination_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Identifier. The resource name of the transfer config.
     * Transfer config names have the form either
     * `projects/{project_id}/locations/{region}/transferConfigs/{config_id}` or
     * `projects/{project_id}/transferConfigs/{config_id}`,
     * where `config_id` is usually a UUID, even though it is not
     * guaranteed or required. The name is ignored when creating a transfer
     * config.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Identifier. The resource name of the transfer config.
     * Transfer config names have the form either
     * `projects/{project_id}/locations/{region}/transferConfigs/{config_id}` or
     * `projects/{project_id}/transferConfigs/{config_id}`,
     * where `config_id` is usually a UUID, even though it is not
     * guaranteed or required. The name is ignored when creating a transfer
     * config.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Identifier. The resource name of the transfer config.
     * Transfer config names have the form either
     * `projects/{project_id}/locations/{region}/transferConfigs/{config_id}` or
     * `projects/{project_id}/transferConfigs/{config_id}`,
     * where `config_id` is usually a UUID, even though it is not
     * guaranteed or required. The name is ignored when creating a transfer
     * config.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identifier. The resource name of the transfer config.
     * Transfer config names have the form either
     * `projects/{project_id}/locations/{region}/transferConfigs/{config_id}` or
     * `projects/{project_id}/transferConfigs/{config_id}`,
     * where `config_id` is usually a UUID, even though it is not
     * guaranteed or required. The name is ignored when creating a transfer
     * config.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identifier. The resource name of the transfer config.
     * Transfer config names have the form either
     * `projects/{project_id}/locations/{region}/transferConfigs/{config_id}` or
     * `projects/{project_id}/transferConfigs/{config_id}`,
     * where `config_id` is usually a UUID, even though it is not
     * guaranteed or required. The name is ignored when creating a transfer
     * config.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The BigQuery target dataset id.
     * </pre>
     *
     * <code>string destination_dataset_id = 2;</code>
     *
     * @return Whether the destinationDatasetId field is set.
     */
    @java.lang.Override
    public boolean hasDestinationDatasetId() {
      return destinationCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * The BigQuery target dataset id.
     * </pre>
     *
     * <code>string destination_dataset_id = 2;</code>
     *
     * @return The destinationDatasetId.
     */
    @java.lang.Override
    public java.lang.String getDestinationDatasetId() {
      java.lang.Object ref = "";
      if (destinationCase_ == 2) {
        ref = destination_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (destinationCase_ == 2) {
          destination_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The BigQuery target dataset id.
     * </pre>
     *
     * <code>string destination_dataset_id = 2;</code>
     *
     * @return The bytes for destinationDatasetId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDestinationDatasetIdBytes() {
      java.lang.Object ref = "";
      if (destinationCase_ == 2) {
        ref = destination_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (destinationCase_ == 2) {
          destination_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The BigQuery target dataset id.
     * </pre>
     *
     * <code>string destination_dataset_id = 2;</code>
     *
     * @param value The destinationDatasetId to set.
     * @return This builder for chaining.
     */
    public Builder setDestinationDatasetId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      destinationCase_ = 2;
      destination_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The BigQuery target dataset id.
     * </pre>
     *
     * <code>string destination_dataset_id = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDestinationDatasetId() {
      if (destinationCase_ == 2) {
        destinationCase_ = 0;
        destination_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The BigQuery target dataset id.
     * </pre>
     *
     * <code>string destination_dataset_id = 2;</code>
     *
     * @param value The bytes for destinationDatasetId to set.
     * @return This builder for chaining.
     */
    public Builder setDestinationDatasetIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      destinationCase_ = 2;
      destination_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * User specified display name for the data transfer.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * User specified display name for the data transfer.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * User specified display name for the data transfer.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User specified display name for the data transfer.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User specified display name for the data transfer.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object dataSourceId_ = "";
    /**
     *
     *
     * <pre>
     * Data source ID. This cannot be changed once data transfer is created. The
     * full list of available data source IDs can be returned through an API call:
     * https://cloud.google.com/bigquery-transfer/docs/reference/datatransfer/rest/v1/projects.locations.dataSources/list
     * </pre>
     *
     * <code>string data_source_id = 5;</code>
     *
     * @return The dataSourceId.
     */
    public java.lang.String getDataSourceId() {
      java.lang.Object ref = dataSourceId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dataSourceId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Data source ID. This cannot be changed once data transfer is created. The
     * full list of available data source IDs can be returned through an API call:
     * https://cloud.google.com/bigquery-transfer/docs/reference/datatransfer/rest/v1/projects.locations.dataSources/list
     * </pre>
     *
     * <code>string data_source_id = 5;</code>
     *
     * @return The bytes for dataSourceId.
     */
    public com.google.protobuf.ByteString getDataSourceIdBytes() {
      java.lang.Object ref = dataSourceId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dataSourceId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Data source ID. This cannot be changed once data transfer is created. The
     * full list of available data source IDs can be returned through an API call:
     * https://cloud.google.com/bigquery-transfer/docs/reference/datatransfer/rest/v1/projects.locations.dataSources/list
     * </pre>
     *
     * <code>string data_source_id = 5;</code>
     *
     * @param value The dataSourceId to set.
     * @return This builder for chaining.
     */
    public Builder setDataSourceId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      dataSourceId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data source ID. This cannot be changed once data transfer is created. The
     * full list of available data source IDs can be returned through an API call:
     * https://cloud.google.com/bigquery-transfer/docs/reference/datatransfer/rest/v1/projects.locations.dataSources/list
     * </pre>
     *
     * <code>string data_source_id = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDataSourceId() {
      dataSourceId_ = getDefaultInstance().getDataSourceId();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data source ID. This cannot be changed once data transfer is created. The
     * full list of available data source IDs can be returned through an API call:
     * https://cloud.google.com/bigquery-transfer/docs/reference/datatransfer/rest/v1/projects.locations.dataSources/list
     * </pre>
     *
     * <code>string data_source_id = 5;</code>
     *
     * @param value The bytes for dataSourceId to set.
     * @return This builder for chaining.
     */
    public Builder setDataSourceIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      dataSourceId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.Struct params_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        paramsBuilder_;
    /**
     *
     *
     * <pre>
     * Parameters specific to each data source. For more information see the
     * bq tab in the 'Setting up a data transfer' section for each data source.
     * For example the parameters for Cloud Storage transfers are listed here:
     * https://cloud.google.com/bigquery-transfer/docs/cloud-storage-transfer#bq
     * </pre>
     *
     * <code>.google.protobuf.Struct params = 9;</code>
     *
     * @return Whether the params field is set.
     */
    public boolean hasParams() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Parameters specific to each data source. For more information see the
     * bq tab in the 'Setting up a data transfer' section for each data source.
     * For example the parameters for Cloud Storage transfers are listed here:
     * https://cloud.google.com/bigquery-transfer/docs/cloud-storage-transfer#bq
     * </pre>
     *
     * <code>.google.protobuf.Struct params = 9;</code>
     *
     * @return The params.
     */
    public com.google.protobuf.Struct getParams() {
      if (paramsBuilder_ == null) {
        return params_ == null ? com.google.protobuf.Struct.getDefaultInstance() : params_;
      } else {
        return paramsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Parameters specific to each data source. For more information see the
     * bq tab in the 'Setting up a data transfer' section for each data source.
     * For example the parameters for Cloud Storage transfers are listed here:
     * https://cloud.google.com/bigquery-transfer/docs/cloud-storage-transfer#bq
     * </pre>
     *
     * <code>.google.protobuf.Struct params = 9;</code>
     */
    public Builder setParams(com.google.protobuf.Struct value) {
      if (paramsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        params_ = value;
      } else {
        paramsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters specific to each data source. For more information see the
     * bq tab in the 'Setting up a data transfer' section for each data source.
     * For example the parameters for Cloud Storage transfers are listed here:
     * https://cloud.google.com/bigquery-transfer/docs/cloud-storage-transfer#bq
     * </pre>
     *
     * <code>.google.protobuf.Struct params = 9;</code>
     */
    public Builder setParams(com.google.protobuf.Struct.Builder builderForValue) {
      if (paramsBuilder_ == null) {
        params_ = builderForValue.build();
      } else {
        paramsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters specific to each data source. For more information see the
     * bq tab in the 'Setting up a data transfer' section for each data source.
     * For example the parameters for Cloud Storage transfers are listed here:
     * https://cloud.google.com/bigquery-transfer/docs/cloud-storage-transfer#bq
     * </pre>
     *
     * <code>.google.protobuf.Struct params = 9;</code>
     */
    public Builder mergeParams(com.google.protobuf.Struct value) {
      if (paramsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && params_ != null
            && params_ != com.google.protobuf.Struct.getDefaultInstance()) {
          getParamsBuilder().mergeFrom(value);
        } else {
          params_ = value;
        }
      } else {
        paramsBuilder_.mergeFrom(value);
      }
      if (params_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters specific to each data source. For more information see the
     * bq tab in the 'Setting up a data transfer' section for each data source.
     * For example the parameters for Cloud Storage transfers are listed here:
     * https://cloud.google.com/bigquery-transfer/docs/cloud-storage-transfer#bq
     * </pre>
     *
     * <code>.google.protobuf.Struct params = 9;</code>
     */
    public Builder clearParams() {
      bitField0_ = (bitField0_ & ~0x00000010);
      params_ = null;
      if (paramsBuilder_ != null) {
        paramsBuilder_.dispose();
        paramsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters specific to each data source. For more information see the
     * bq tab in the 'Setting up a data transfer' section for each data source.
     * For example the parameters for Cloud Storage transfers are listed here:
     * https://cloud.google.com/bigquery-transfer/docs/cloud-storage-transfer#bq
     * </pre>
     *
     * <code>.google.protobuf.Struct params = 9;</code>
     */
    public com.google.protobuf.Struct.Builder getParamsBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getParamsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Parameters specific to each data source. For more information see the
     * bq tab in the 'Setting up a data transfer' section for each data source.
     * For example the parameters for Cloud Storage transfers are listed here:
     * https://cloud.google.com/bigquery-transfer/docs/cloud-storage-transfer#bq
     * </pre>
     *
     * <code>.google.protobuf.Struct params = 9;</code>
     */
    public com.google.protobuf.StructOrBuilder getParamsOrBuilder() {
      if (paramsBuilder_ != null) {
        return paramsBuilder_.getMessageOrBuilder();
      } else {
        return params_ == null ? com.google.protobuf.Struct.getDefaultInstance() : params_;
      }
    }
    /**
     *
     *
     * <pre>
     * Parameters specific to each data source. For more information see the
     * bq tab in the 'Setting up a data transfer' section for each data source.
     * For example the parameters for Cloud Storage transfers are listed here:
     * https://cloud.google.com/bigquery-transfer/docs/cloud-storage-transfer#bq
     * </pre>
     *
     * <code>.google.protobuf.Struct params = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        getParamsFieldBuilder() {
      if (paramsBuilder_ == null) {
        paramsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>(
                getParams(), getParentForChildren(), isClean());
        params_ = null;
      }
      return paramsBuilder_;
    }

    private java.lang.Object schedule_ = "";
    /**
     *
     *
     * <pre>
     * Data transfer schedule.
     * If the data source does not support a custom schedule, this should be
     * empty. If it is empty, the default value for the data source will be used.
     * The specified times are in UTC.
     * Examples of valid format:
     * `1st,3rd monday of month 15:30`,
     * `every wed,fri of jan,jun 13:15`, and
     * `first sunday of quarter 00:00`.
     * See more explanation about the format here:
     * https://cloud.google.com/appengine/docs/flexible/python/scheduling-jobs-with-cron-yaml#the_schedule_format
     *
     * NOTE: The minimum interval time between recurring transfers depends on the
     * data source; refer to the documentation for your data source.
     * </pre>
     *
     * <code>string schedule = 7;</code>
     *
     * @return The schedule.
     */
    public java.lang.String getSchedule() {
      java.lang.Object ref = schedule_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        schedule_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Data transfer schedule.
     * If the data source does not support a custom schedule, this should be
     * empty. If it is empty, the default value for the data source will be used.
     * The specified times are in UTC.
     * Examples of valid format:
     * `1st,3rd monday of month 15:30`,
     * `every wed,fri of jan,jun 13:15`, and
     * `first sunday of quarter 00:00`.
     * See more explanation about the format here:
     * https://cloud.google.com/appengine/docs/flexible/python/scheduling-jobs-with-cron-yaml#the_schedule_format
     *
     * NOTE: The minimum interval time between recurring transfers depends on the
     * data source; refer to the documentation for your data source.
     * </pre>
     *
     * <code>string schedule = 7;</code>
     *
     * @return The bytes for schedule.
     */
    public com.google.protobuf.ByteString getScheduleBytes() {
      java.lang.Object ref = schedule_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        schedule_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Data transfer schedule.
     * If the data source does not support a custom schedule, this should be
     * empty. If it is empty, the default value for the data source will be used.
     * The specified times are in UTC.
     * Examples of valid format:
     * `1st,3rd monday of month 15:30`,
     * `every wed,fri of jan,jun 13:15`, and
     * `first sunday of quarter 00:00`.
     * See more explanation about the format here:
     * https://cloud.google.com/appengine/docs/flexible/python/scheduling-jobs-with-cron-yaml#the_schedule_format
     *
     * NOTE: The minimum interval time between recurring transfers depends on the
     * data source; refer to the documentation for your data source.
     * </pre>
     *
     * <code>string schedule = 7;</code>
     *
     * @param value The schedule to set.
     * @return This builder for chaining.
     */
    public Builder setSchedule(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      schedule_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data transfer schedule.
     * If the data source does not support a custom schedule, this should be
     * empty. If it is empty, the default value for the data source will be used.
     * The specified times are in UTC.
     * Examples of valid format:
     * `1st,3rd monday of month 15:30`,
     * `every wed,fri of jan,jun 13:15`, and
     * `first sunday of quarter 00:00`.
     * See more explanation about the format here:
     * https://cloud.google.com/appengine/docs/flexible/python/scheduling-jobs-with-cron-yaml#the_schedule_format
     *
     * NOTE: The minimum interval time between recurring transfers depends on the
     * data source; refer to the documentation for your data source.
     * </pre>
     *
     * <code>string schedule = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSchedule() {
      schedule_ = getDefaultInstance().getSchedule();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data transfer schedule.
     * If the data source does not support a custom schedule, this should be
     * empty. If it is empty, the default value for the data source will be used.
     * The specified times are in UTC.
     * Examples of valid format:
     * `1st,3rd monday of month 15:30`,
     * `every wed,fri of jan,jun 13:15`, and
     * `first sunday of quarter 00:00`.
     * See more explanation about the format here:
     * https://cloud.google.com/appengine/docs/flexible/python/scheduling-jobs-with-cron-yaml#the_schedule_format
     *
     * NOTE: The minimum interval time between recurring transfers depends on the
     * data source; refer to the documentation for your data source.
     * </pre>
     *
     * <code>string schedule = 7;</code>
     *
     * @param value The bytes for schedule to set.
     * @return This builder for chaining.
     */
    public Builder setScheduleBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      schedule_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.cloud.bigquery.datatransfer.v1.ScheduleOptions scheduleOptions_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.datatransfer.v1.ScheduleOptions,
            com.google.cloud.bigquery.datatransfer.v1.ScheduleOptions.Builder,
            com.google.cloud.bigquery.datatransfer.v1.ScheduleOptionsOrBuilder>
        scheduleOptionsBuilder_;
    /**
     *
     *
     * <pre>
     * Options customizing the data transfer schedule.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.ScheduleOptions schedule_options = 24;</code>
     *
     * @return Whether the scheduleOptions field is set.
     */
    public boolean hasScheduleOptions() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Options customizing the data transfer schedule.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.ScheduleOptions schedule_options = 24;</code>
     *
     * @return The scheduleOptions.
     */
    public com.google.cloud.bigquery.datatransfer.v1.ScheduleOptions getScheduleOptions() {
      if (scheduleOptionsBuilder_ == null) {
        return scheduleOptions_ == null
            ? com.google.cloud.bigquery.datatransfer.v1.ScheduleOptions.getDefaultInstance()
            : scheduleOptions_;
      } else {
        return scheduleOptionsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Options customizing the data transfer schedule.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.ScheduleOptions schedule_options = 24;</code>
     */
    public Builder setScheduleOptions(
        com.google.cloud.bigquery.datatransfer.v1.ScheduleOptions value) {
      if (scheduleOptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        scheduleOptions_ = value;
      } else {
        scheduleOptionsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Options customizing the data transfer schedule.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.ScheduleOptions schedule_options = 24;</code>
     */
    public Builder setScheduleOptions(
        com.google.cloud.bigquery.datatransfer.v1.ScheduleOptions.Builder builderForValue) {
      if (scheduleOptionsBuilder_ == null) {
        scheduleOptions_ = builderForValue.build();
      } else {
        scheduleOptionsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Options customizing the data transfer schedule.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.ScheduleOptions schedule_options = 24;</code>
     */
    public Builder mergeScheduleOptions(
        com.google.cloud.bigquery.datatransfer.v1.ScheduleOptions value) {
      if (scheduleOptionsBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && scheduleOptions_ != null
            && scheduleOptions_
                != com.google.cloud.bigquery.datatransfer.v1.ScheduleOptions.getDefaultInstance()) {
          getScheduleOptionsBuilder().mergeFrom(value);
        } else {
          scheduleOptions_ = value;
        }
      } else {
        scheduleOptionsBuilder_.mergeFrom(value);
      }
      if (scheduleOptions_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Options customizing the data transfer schedule.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.ScheduleOptions schedule_options = 24;</code>
     */
    public Builder clearScheduleOptions() {
      bitField0_ = (bitField0_ & ~0x00000040);
      scheduleOptions_ = null;
      if (scheduleOptionsBuilder_ != null) {
        scheduleOptionsBuilder_.dispose();
        scheduleOptionsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Options customizing the data transfer schedule.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.ScheduleOptions schedule_options = 24;</code>
     */
    public com.google.cloud.bigquery.datatransfer.v1.ScheduleOptions.Builder
        getScheduleOptionsBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getScheduleOptionsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Options customizing the data transfer schedule.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.ScheduleOptions schedule_options = 24;</code>
     */
    public com.google.cloud.bigquery.datatransfer.v1.ScheduleOptionsOrBuilder
        getScheduleOptionsOrBuilder() {
      if (scheduleOptionsBuilder_ != null) {
        return scheduleOptionsBuilder_.getMessageOrBuilder();
      } else {
        return scheduleOptions_ == null
            ? com.google.cloud.bigquery.datatransfer.v1.ScheduleOptions.getDefaultInstance()
            : scheduleOptions_;
      }
    }
    /**
     *
     *
     * <pre>
     * Options customizing the data transfer schedule.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.ScheduleOptions schedule_options = 24;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.datatransfer.v1.ScheduleOptions,
            com.google.cloud.bigquery.datatransfer.v1.ScheduleOptions.Builder,
            com.google.cloud.bigquery.datatransfer.v1.ScheduleOptionsOrBuilder>
        getScheduleOptionsFieldBuilder() {
      if (scheduleOptionsBuilder_ == null) {
        scheduleOptionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.datatransfer.v1.ScheduleOptions,
                com.google.cloud.bigquery.datatransfer.v1.ScheduleOptions.Builder,
                com.google.cloud.bigquery.datatransfer.v1.ScheduleOptionsOrBuilder>(
                getScheduleOptions(), getParentForChildren(), isClean());
        scheduleOptions_ = null;
      }
      return scheduleOptionsBuilder_;
    }

    private int dataRefreshWindowDays_;
    /**
     *
     *
     * <pre>
     * The number of days to look back to automatically refresh the data.
     * For example, if `data_refresh_window_days = 10`, then every day
     * BigQuery reingests data for [today-10, today-1], rather than ingesting data
     * for just [today-1].
     * Only valid if the data source supports the feature. Set the value to 0
     * to use the default value.
     * </pre>
     *
     * <code>int32 data_refresh_window_days = 12;</code>
     *
     * @return The dataRefreshWindowDays.
     */
    @java.lang.Override
    public int getDataRefreshWindowDays() {
      return dataRefreshWindowDays_;
    }
    /**
     *
     *
     * <pre>
     * The number of days to look back to automatically refresh the data.
     * For example, if `data_refresh_window_days = 10`, then every day
     * BigQuery reingests data for [today-10, today-1], rather than ingesting data
     * for just [today-1].
     * Only valid if the data source supports the feature. Set the value to 0
     * to use the default value.
     * </pre>
     *
     * <code>int32 data_refresh_window_days = 12;</code>
     *
     * @param value The dataRefreshWindowDays to set.
     * @return This builder for chaining.
     */
    public Builder setDataRefreshWindowDays(int value) {

      dataRefreshWindowDays_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number of days to look back to automatically refresh the data.
     * For example, if `data_refresh_window_days = 10`, then every day
     * BigQuery reingests data for [today-10, today-1], rather than ingesting data
     * for just [today-1].
     * Only valid if the data source supports the feature. Set the value to 0
     * to use the default value.
     * </pre>
     *
     * <code>int32 data_refresh_window_days = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDataRefreshWindowDays() {
      bitField0_ = (bitField0_ & ~0x00000080);
      dataRefreshWindowDays_ = 0;
      onChanged();
      return this;
    }

    private boolean disabled_;
    /**
     *
     *
     * <pre>
     * Is this config disabled. When set to true, no runs will be scheduled for
     * this transfer config.
     * </pre>
     *
     * <code>bool disabled = 13;</code>
     *
     * @return The disabled.
     */
    @java.lang.Override
    public boolean getDisabled() {
      return disabled_;
    }
    /**
     *
     *
     * <pre>
     * Is this config disabled. When set to true, no runs will be scheduled for
     * this transfer config.
     * </pre>
     *
     * <code>bool disabled = 13;</code>
     *
     * @param value The disabled to set.
     * @return This builder for chaining.
     */
    public Builder setDisabled(boolean value) {

      disabled_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Is this config disabled. When set to true, no runs will be scheduled for
     * this transfer config.
     * </pre>
     *
     * <code>bool disabled = 13;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisabled() {
      bitField0_ = (bitField0_ & ~0x00000100);
      disabled_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Data transfer modification time. Ignored by server on input.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Data transfer modification time. Ignored by server on input.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Data transfer modification time. Ignored by server on input.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Data transfer modification time. Ignored by server on input.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Data transfer modification time. Ignored by server on input.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Data transfer modification time. Ignored by server on input.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000200);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Data transfer modification time. Ignored by server on input.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Data transfer modification time. Ignored by server on input.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Data transfer modification time. Ignored by server on input.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.Timestamp nextRunTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        nextRunTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Next time when data transfer will run.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp next_run_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the nextRunTime field is set.
     */
    public boolean hasNextRunTime() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Next time when data transfer will run.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp next_run_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The nextRunTime.
     */
    public com.google.protobuf.Timestamp getNextRunTime() {
      if (nextRunTimeBuilder_ == null) {
        return nextRunTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : nextRunTime_;
      } else {
        return nextRunTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Next time when data transfer will run.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp next_run_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setNextRunTime(com.google.protobuf.Timestamp value) {
      if (nextRunTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        nextRunTime_ = value;
      } else {
        nextRunTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Next time when data transfer will run.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp next_run_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setNextRunTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (nextRunTimeBuilder_ == null) {
        nextRunTime_ = builderForValue.build();
      } else {
        nextRunTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Next time when data transfer will run.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp next_run_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeNextRunTime(com.google.protobuf.Timestamp value) {
      if (nextRunTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && nextRunTime_ != null
            && nextRunTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getNextRunTimeBuilder().mergeFrom(value);
        } else {
          nextRunTime_ = value;
        }
      } else {
        nextRunTimeBuilder_.mergeFrom(value);
      }
      if (nextRunTime_ != null) {
        bitField0_ |= 0x00000400;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Next time when data transfer will run.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp next_run_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearNextRunTime() {
      bitField0_ = (bitField0_ & ~0x00000400);
      nextRunTime_ = null;
      if (nextRunTimeBuilder_ != null) {
        nextRunTimeBuilder_.dispose();
        nextRunTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Next time when data transfer will run.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp next_run_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getNextRunTimeBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getNextRunTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Next time when data transfer will run.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp next_run_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getNextRunTimeOrBuilder() {
      if (nextRunTimeBuilder_ != null) {
        return nextRunTimeBuilder_.getMessageOrBuilder();
      } else {
        return nextRunTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : nextRunTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Next time when data transfer will run.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp next_run_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getNextRunTimeFieldBuilder() {
      if (nextRunTimeBuilder_ == null) {
        nextRunTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getNextRunTime(), getParentForChildren(), isClean());
        nextRunTime_ = null;
      }
      return nextRunTimeBuilder_;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. State of the most recently updated transfer run.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.TransferState state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the most recently updated transfer run.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.TransferState state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the most recently updated transfer run.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.TransferState state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.datatransfer.v1.TransferState getState() {
      com.google.cloud.bigquery.datatransfer.v1.TransferState result =
          com.google.cloud.bigquery.datatransfer.v1.TransferState.forNumber(state_);
      return result == null
          ? com.google.cloud.bigquery.datatransfer.v1.TransferState.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the most recently updated transfer run.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.TransferState state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.bigquery.datatransfer.v1.TransferState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000800;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the most recently updated transfer run.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.TransferState state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000800);
      state_ = 0;
      onChanged();
      return this;
    }

    private long userId_;
    /**
     *
     *
     * <pre>
     * Deprecated. Unique ID of the user on whose behalf transfer is done.
     * </pre>
     *
     * <code>int64 user_id = 11;</code>
     *
     * @return The userId.
     */
    @java.lang.Override
    public long getUserId() {
      return userId_;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. Unique ID of the user on whose behalf transfer is done.
     * </pre>
     *
     * <code>int64 user_id = 11;</code>
     *
     * @param value The userId to set.
     * @return This builder for chaining.
     */
    public Builder setUserId(long value) {

      userId_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. Unique ID of the user on whose behalf transfer is done.
     * </pre>
     *
     * <code>int64 user_id = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUserId() {
      bitField0_ = (bitField0_ & ~0x00001000);
      userId_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object datasetRegion_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Region in which BigQuery dataset is located.
     * </pre>
     *
     * <code>string dataset_region = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The datasetRegion.
     */
    public java.lang.String getDatasetRegion() {
      java.lang.Object ref = datasetRegion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        datasetRegion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Region in which BigQuery dataset is located.
     * </pre>
     *
     * <code>string dataset_region = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for datasetRegion.
     */
    public com.google.protobuf.ByteString getDatasetRegionBytes() {
      java.lang.Object ref = datasetRegion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        datasetRegion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Region in which BigQuery dataset is located.
     * </pre>
     *
     * <code>string dataset_region = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The datasetRegion to set.
     * @return This builder for chaining.
     */
    public Builder setDatasetRegion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      datasetRegion_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Region in which BigQuery dataset is located.
     * </pre>
     *
     * <code>string dataset_region = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDatasetRegion() {
      datasetRegion_ = getDefaultInstance().getDatasetRegion();
      bitField0_ = (bitField0_ & ~0x00002000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Region in which BigQuery dataset is located.
     * </pre>
     *
     * <code>string dataset_region = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for datasetRegion to set.
     * @return This builder for chaining.
     */
    public Builder setDatasetRegionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      datasetRegion_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    private java.lang.Object notificationPubsubTopic_ = "";
    /**
     *
     *
     * <pre>
     * Pub/Sub topic where notifications will be sent after transfer runs
     * associated with this transfer config finish.
     *
     * The format for specifying a pubsub topic is:
     * `projects/{project_id}/topics/{topic_id}`
     * </pre>
     *
     * <code>string notification_pubsub_topic = 15;</code>
     *
     * @return The notificationPubsubTopic.
     */
    public java.lang.String getNotificationPubsubTopic() {
      java.lang.Object ref = notificationPubsubTopic_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        notificationPubsubTopic_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Pub/Sub topic where notifications will be sent after transfer runs
     * associated with this transfer config finish.
     *
     * The format for specifying a pubsub topic is:
     * `projects/{project_id}/topics/{topic_id}`
     * </pre>
     *
     * <code>string notification_pubsub_topic = 15;</code>
     *
     * @return The bytes for notificationPubsubTopic.
     */
    public com.google.protobuf.ByteString getNotificationPubsubTopicBytes() {
      java.lang.Object ref = notificationPubsubTopic_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        notificationPubsubTopic_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Pub/Sub topic where notifications will be sent after transfer runs
     * associated with this transfer config finish.
     *
     * The format for specifying a pubsub topic is:
     * `projects/{project_id}/topics/{topic_id}`
     * </pre>
     *
     * <code>string notification_pubsub_topic = 15;</code>
     *
     * @param value The notificationPubsubTopic to set.
     * @return This builder for chaining.
     */
    public Builder setNotificationPubsubTopic(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      notificationPubsubTopic_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Pub/Sub topic where notifications will be sent after transfer runs
     * associated with this transfer config finish.
     *
     * The format for specifying a pubsub topic is:
     * `projects/{project_id}/topics/{topic_id}`
     * </pre>
     *
     * <code>string notification_pubsub_topic = 15;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNotificationPubsubTopic() {
      notificationPubsubTopic_ = getDefaultInstance().getNotificationPubsubTopic();
      bitField0_ = (bitField0_ & ~0x00004000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Pub/Sub topic where notifications will be sent after transfer runs
     * associated with this transfer config finish.
     *
     * The format for specifying a pubsub topic is:
     * `projects/{project_id}/topics/{topic_id}`
     * </pre>
     *
     * <code>string notification_pubsub_topic = 15;</code>
     *
     * @param value The bytes for notificationPubsubTopic to set.
     * @return This builder for chaining.
     */
    public Builder setNotificationPubsubTopicBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      notificationPubsubTopic_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    private com.google.cloud.bigquery.datatransfer.v1.EmailPreferences emailPreferences_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.datatransfer.v1.EmailPreferences,
            com.google.cloud.bigquery.datatransfer.v1.EmailPreferences.Builder,
            com.google.cloud.bigquery.datatransfer.v1.EmailPreferencesOrBuilder>
        emailPreferencesBuilder_;
    /**
     *
     *
     * <pre>
     * Email notifications will be sent according to these preferences
     * to the email address of the user who owns this transfer config.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.EmailPreferences email_preferences = 18;</code>
     *
     * @return Whether the emailPreferences field is set.
     */
    public boolean hasEmailPreferences() {
      return ((bitField0_ & 0x00008000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Email notifications will be sent according to these preferences
     * to the email address of the user who owns this transfer config.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.EmailPreferences email_preferences = 18;</code>
     *
     * @return The emailPreferences.
     */
    public com.google.cloud.bigquery.datatransfer.v1.EmailPreferences getEmailPreferences() {
      if (emailPreferencesBuilder_ == null) {
        return emailPreferences_ == null
            ? com.google.cloud.bigquery.datatransfer.v1.EmailPreferences.getDefaultInstance()
            : emailPreferences_;
      } else {
        return emailPreferencesBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Email notifications will be sent according to these preferences
     * to the email address of the user who owns this transfer config.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.EmailPreferences email_preferences = 18;</code>
     */
    public Builder setEmailPreferences(
        com.google.cloud.bigquery.datatransfer.v1.EmailPreferences value) {
      if (emailPreferencesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        emailPreferences_ = value;
      } else {
        emailPreferencesBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Email notifications will be sent according to these preferences
     * to the email address of the user who owns this transfer config.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.EmailPreferences email_preferences = 18;</code>
     */
    public Builder setEmailPreferences(
        com.google.cloud.bigquery.datatransfer.v1.EmailPreferences.Builder builderForValue) {
      if (emailPreferencesBuilder_ == null) {
        emailPreferences_ = builderForValue.build();
      } else {
        emailPreferencesBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Email notifications will be sent according to these preferences
     * to the email address of the user who owns this transfer config.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.EmailPreferences email_preferences = 18;</code>
     */
    public Builder mergeEmailPreferences(
        com.google.cloud.bigquery.datatransfer.v1.EmailPreferences value) {
      if (emailPreferencesBuilder_ == null) {
        if (((bitField0_ & 0x00008000) != 0)
            && emailPreferences_ != null
            && emailPreferences_
                != com.google.cloud.bigquery.datatransfer.v1.EmailPreferences
                    .getDefaultInstance()) {
          getEmailPreferencesBuilder().mergeFrom(value);
        } else {
          emailPreferences_ = value;
        }
      } else {
        emailPreferencesBuilder_.mergeFrom(value);
      }
      if (emailPreferences_ != null) {
        bitField0_ |= 0x00008000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Email notifications will be sent according to these preferences
     * to the email address of the user who owns this transfer config.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.EmailPreferences email_preferences = 18;</code>
     */
    public Builder clearEmailPreferences() {
      bitField0_ = (bitField0_ & ~0x00008000);
      emailPreferences_ = null;
      if (emailPreferencesBuilder_ != null) {
        emailPreferencesBuilder_.dispose();
        emailPreferencesBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Email notifications will be sent according to these preferences
     * to the email address of the user who owns this transfer config.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.EmailPreferences email_preferences = 18;</code>
     */
    public com.google.cloud.bigquery.datatransfer.v1.EmailPreferences.Builder
        getEmailPreferencesBuilder() {
      bitField0_ |= 0x00008000;
      onChanged();
      return getEmailPreferencesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Email notifications will be sent according to these preferences
     * to the email address of the user who owns this transfer config.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.EmailPreferences email_preferences = 18;</code>
     */
    public com.google.cloud.bigquery.datatransfer.v1.EmailPreferencesOrBuilder
        getEmailPreferencesOrBuilder() {
      if (emailPreferencesBuilder_ != null) {
        return emailPreferencesBuilder_.getMessageOrBuilder();
      } else {
        return emailPreferences_ == null
            ? com.google.cloud.bigquery.datatransfer.v1.EmailPreferences.getDefaultInstance()
            : emailPreferences_;
      }
    }
    /**
     *
     *
     * <pre>
     * Email notifications will be sent according to these preferences
     * to the email address of the user who owns this transfer config.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.EmailPreferences email_preferences = 18;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.datatransfer.v1.EmailPreferences,
            com.google.cloud.bigquery.datatransfer.v1.EmailPreferences.Builder,
            com.google.cloud.bigquery.datatransfer.v1.EmailPreferencesOrBuilder>
        getEmailPreferencesFieldBuilder() {
      if (emailPreferencesBuilder_ == null) {
        emailPreferencesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.datatransfer.v1.EmailPreferences,
                com.google.cloud.bigquery.datatransfer.v1.EmailPreferences.Builder,
                com.google.cloud.bigquery.datatransfer.v1.EmailPreferencesOrBuilder>(
                getEmailPreferences(), getParentForChildren(), isClean());
        emailPreferences_ = null;
      }
      return emailPreferencesBuilder_;
    }

    private com.google.cloud.bigquery.datatransfer.v1.UserInfo ownerInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.datatransfer.v1.UserInfo,
            com.google.cloud.bigquery.datatransfer.v1.UserInfo.Builder,
            com.google.cloud.bigquery.datatransfer.v1.UserInfoOrBuilder>
        ownerInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Information about the user whose credentials are used to
     * transfer data. Populated only for `transferConfigs.get` requests. In case
     * the user information is not available, this field will not be populated.
     * </pre>
     *
     * <code>
     * optional .google.cloud.bigquery.datatransfer.v1.UserInfo owner_info = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the ownerInfo field is set.
     */
    public boolean hasOwnerInfo() {
      return ((bitField0_ & 0x00010000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Information about the user whose credentials are used to
     * transfer data. Populated only for `transferConfigs.get` requests. In case
     * the user information is not available, this field will not be populated.
     * </pre>
     *
     * <code>
     * optional .google.cloud.bigquery.datatransfer.v1.UserInfo owner_info = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The ownerInfo.
     */
    public com.google.cloud.bigquery.datatransfer.v1.UserInfo getOwnerInfo() {
      if (ownerInfoBuilder_ == null) {
        return ownerInfo_ == null
            ? com.google.cloud.bigquery.datatransfer.v1.UserInfo.getDefaultInstance()
            : ownerInfo_;
      } else {
        return ownerInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Information about the user whose credentials are used to
     * transfer data. Populated only for `transferConfigs.get` requests. In case
     * the user information is not available, this field will not be populated.
     * </pre>
     *
     * <code>
     * optional .google.cloud.bigquery.datatransfer.v1.UserInfo owner_info = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setOwnerInfo(com.google.cloud.bigquery.datatransfer.v1.UserInfo value) {
      if (ownerInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ownerInfo_ = value;
      } else {
        ownerInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information about the user whose credentials are used to
     * transfer data. Populated only for `transferConfigs.get` requests. In case
     * the user information is not available, this field will not be populated.
     * </pre>
     *
     * <code>
     * optional .google.cloud.bigquery.datatransfer.v1.UserInfo owner_info = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setOwnerInfo(
        com.google.cloud.bigquery.datatransfer.v1.UserInfo.Builder builderForValue) {
      if (ownerInfoBuilder_ == null) {
        ownerInfo_ = builderForValue.build();
      } else {
        ownerInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information about the user whose credentials are used to
     * transfer data. Populated only for `transferConfigs.get` requests. In case
     * the user information is not available, this field will not be populated.
     * </pre>
     *
     * <code>
     * optional .google.cloud.bigquery.datatransfer.v1.UserInfo owner_info = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeOwnerInfo(com.google.cloud.bigquery.datatransfer.v1.UserInfo value) {
      if (ownerInfoBuilder_ == null) {
        if (((bitField0_ & 0x00010000) != 0)
            && ownerInfo_ != null
            && ownerInfo_
                != com.google.cloud.bigquery.datatransfer.v1.UserInfo.getDefaultInstance()) {
          getOwnerInfoBuilder().mergeFrom(value);
        } else {
          ownerInfo_ = value;
        }
      } else {
        ownerInfoBuilder_.mergeFrom(value);
      }
      if (ownerInfo_ != null) {
        bitField0_ |= 0x00010000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information about the user whose credentials are used to
     * transfer data. Populated only for `transferConfigs.get` requests. In case
     * the user information is not available, this field will not be populated.
     * </pre>
     *
     * <code>
     * optional .google.cloud.bigquery.datatransfer.v1.UserInfo owner_info = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearOwnerInfo() {
      bitField0_ = (bitField0_ & ~0x00010000);
      ownerInfo_ = null;
      if (ownerInfoBuilder_ != null) {
        ownerInfoBuilder_.dispose();
        ownerInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information about the user whose credentials are used to
     * transfer data. Populated only for `transferConfigs.get` requests. In case
     * the user information is not available, this field will not be populated.
     * </pre>
     *
     * <code>
     * optional .google.cloud.bigquery.datatransfer.v1.UserInfo owner_info = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.bigquery.datatransfer.v1.UserInfo.Builder getOwnerInfoBuilder() {
      bitField0_ |= 0x00010000;
      onChanged();
      return getOwnerInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Information about the user whose credentials are used to
     * transfer data. Populated only for `transferConfigs.get` requests. In case
     * the user information is not available, this field will not be populated.
     * </pre>
     *
     * <code>
     * optional .google.cloud.bigquery.datatransfer.v1.UserInfo owner_info = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.bigquery.datatransfer.v1.UserInfoOrBuilder getOwnerInfoOrBuilder() {
      if (ownerInfoBuilder_ != null) {
        return ownerInfoBuilder_.getMessageOrBuilder();
      } else {
        return ownerInfo_ == null
            ? com.google.cloud.bigquery.datatransfer.v1.UserInfo.getDefaultInstance()
            : ownerInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Information about the user whose credentials are used to
     * transfer data. Populated only for `transferConfigs.get` requests. In case
     * the user information is not available, this field will not be populated.
     * </pre>
     *
     * <code>
     * optional .google.cloud.bigquery.datatransfer.v1.UserInfo owner_info = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.datatransfer.v1.UserInfo,
            com.google.cloud.bigquery.datatransfer.v1.UserInfo.Builder,
            com.google.cloud.bigquery.datatransfer.v1.UserInfoOrBuilder>
        getOwnerInfoFieldBuilder() {
      if (ownerInfoBuilder_ == null) {
        ownerInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.datatransfer.v1.UserInfo,
                com.google.cloud.bigquery.datatransfer.v1.UserInfo.Builder,
                com.google.cloud.bigquery.datatransfer.v1.UserInfoOrBuilder>(
                getOwnerInfo(), getParentForChildren(), isClean());
        ownerInfo_ = null;
      }
      return ownerInfoBuilder_;
    }

    private com.google.cloud.bigquery.datatransfer.v1.EncryptionConfiguration
        encryptionConfiguration_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.datatransfer.v1.EncryptionConfiguration,
            com.google.cloud.bigquery.datatransfer.v1.EncryptionConfiguration.Builder,
            com.google.cloud.bigquery.datatransfer.v1.EncryptionConfigurationOrBuilder>
        encryptionConfigurationBuilder_;
    /**
     *
     *
     * <pre>
     * The encryption configuration part. Currently, it is only used for the
     * optional KMS key name. The BigQuery service account of your project must be
     * granted permissions to use the key. Read methods will return the key name
     * applied in effect. Write methods will apply the key if it is present, or
     * otherwise try to apply project default keys if it is absent.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.EncryptionConfiguration encryption_configuration = 28;
     * </code>
     *
     * @return Whether the encryptionConfiguration field is set.
     */
    public boolean hasEncryptionConfiguration() {
      return ((bitField0_ & 0x00020000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The encryption configuration part. Currently, it is only used for the
     * optional KMS key name. The BigQuery service account of your project must be
     * granted permissions to use the key. Read methods will return the key name
     * applied in effect. Write methods will apply the key if it is present, or
     * otherwise try to apply project default keys if it is absent.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.EncryptionConfiguration encryption_configuration = 28;
     * </code>
     *
     * @return The encryptionConfiguration.
     */
    public com.google.cloud.bigquery.datatransfer.v1.EncryptionConfiguration
        getEncryptionConfiguration() {
      if (encryptionConfigurationBuilder_ == null) {
        return encryptionConfiguration_ == null
            ? com.google.cloud.bigquery.datatransfer.v1.EncryptionConfiguration.getDefaultInstance()
            : encryptionConfiguration_;
      } else {
        return encryptionConfigurationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The encryption configuration part. Currently, it is only used for the
     * optional KMS key name. The BigQuery service account of your project must be
     * granted permissions to use the key. Read methods will return the key name
     * applied in effect. Write methods will apply the key if it is present, or
     * otherwise try to apply project default keys if it is absent.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.EncryptionConfiguration encryption_configuration = 28;
     * </code>
     */
    public Builder setEncryptionConfiguration(
        com.google.cloud.bigquery.datatransfer.v1.EncryptionConfiguration value) {
      if (encryptionConfigurationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        encryptionConfiguration_ = value;
      } else {
        encryptionConfigurationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The encryption configuration part. Currently, it is only used for the
     * optional KMS key name. The BigQuery service account of your project must be
     * granted permissions to use the key. Read methods will return the key name
     * applied in effect. Write methods will apply the key if it is present, or
     * otherwise try to apply project default keys if it is absent.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.EncryptionConfiguration encryption_configuration = 28;
     * </code>
     */
    public Builder setEncryptionConfiguration(
        com.google.cloud.bigquery.datatransfer.v1.EncryptionConfiguration.Builder builderForValue) {
      if (encryptionConfigurationBuilder_ == null) {
        encryptionConfiguration_ = builderForValue.build();
      } else {
        encryptionConfigurationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The encryption configuration part. Currently, it is only used for the
     * optional KMS key name. The BigQuery service account of your project must be
     * granted permissions to use the key. Read methods will return the key name
     * applied in effect. Write methods will apply the key if it is present, or
     * otherwise try to apply project default keys if it is absent.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.EncryptionConfiguration encryption_configuration = 28;
     * </code>
     */
    public Builder mergeEncryptionConfiguration(
        com.google.cloud.bigquery.datatransfer.v1.EncryptionConfiguration value) {
      if (encryptionConfigurationBuilder_ == null) {
        if (((bitField0_ & 0x00020000) != 0)
            && encryptionConfiguration_ != null
            && encryptionConfiguration_
                != com.google.cloud.bigquery.datatransfer.v1.EncryptionConfiguration
                    .getDefaultInstance()) {
          getEncryptionConfigurationBuilder().mergeFrom(value);
        } else {
          encryptionConfiguration_ = value;
        }
      } else {
        encryptionConfigurationBuilder_.mergeFrom(value);
      }
      if (encryptionConfiguration_ != null) {
        bitField0_ |= 0x00020000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The encryption configuration part. Currently, it is only used for the
     * optional KMS key name. The BigQuery service account of your project must be
     * granted permissions to use the key. Read methods will return the key name
     * applied in effect. Write methods will apply the key if it is present, or
     * otherwise try to apply project default keys if it is absent.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.EncryptionConfiguration encryption_configuration = 28;
     * </code>
     */
    public Builder clearEncryptionConfiguration() {
      bitField0_ = (bitField0_ & ~0x00020000);
      encryptionConfiguration_ = null;
      if (encryptionConfigurationBuilder_ != null) {
        encryptionConfigurationBuilder_.dispose();
        encryptionConfigurationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The encryption configuration part. Currently, it is only used for the
     * optional KMS key name. The BigQuery service account of your project must be
     * granted permissions to use the key. Read methods will return the key name
     * applied in effect. Write methods will apply the key if it is present, or
     * otherwise try to apply project default keys if it is absent.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.EncryptionConfiguration encryption_configuration = 28;
     * </code>
     */
    public com.google.cloud.bigquery.datatransfer.v1.EncryptionConfiguration.Builder
        getEncryptionConfigurationBuilder() {
      bitField0_ |= 0x00020000;
      onChanged();
      return getEncryptionConfigurationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The encryption configuration part. Currently, it is only used for the
     * optional KMS key name. The BigQuery service account of your project must be
     * granted permissions to use the key. Read methods will return the key name
     * applied in effect. Write methods will apply the key if it is present, or
     * otherwise try to apply project default keys if it is absent.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.EncryptionConfiguration encryption_configuration = 28;
     * </code>
     */
    public com.google.cloud.bigquery.datatransfer.v1.EncryptionConfigurationOrBuilder
        getEncryptionConfigurationOrBuilder() {
      if (encryptionConfigurationBuilder_ != null) {
        return encryptionConfigurationBuilder_.getMessageOrBuilder();
      } else {
        return encryptionConfiguration_ == null
            ? com.google.cloud.bigquery.datatransfer.v1.EncryptionConfiguration.getDefaultInstance()
            : encryptionConfiguration_;
      }
    }
    /**
     *
     *
     * <pre>
     * The encryption configuration part. Currently, it is only used for the
     * optional KMS key name. The BigQuery service account of your project must be
     * granted permissions to use the key. Read methods will return the key name
     * applied in effect. Write methods will apply the key if it is present, or
     * otherwise try to apply project default keys if it is absent.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.datatransfer.v1.EncryptionConfiguration encryption_configuration = 28;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.datatransfer.v1.EncryptionConfiguration,
            com.google.cloud.bigquery.datatransfer.v1.EncryptionConfiguration.Builder,
            com.google.cloud.bigquery.datatransfer.v1.EncryptionConfigurationOrBuilder>
        getEncryptionConfigurationFieldBuilder() {
      if (encryptionConfigurationBuilder_ == null) {
        encryptionConfigurationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.datatransfer.v1.EncryptionConfiguration,
                com.google.cloud.bigquery.datatransfer.v1.EncryptionConfiguration.Builder,
                com.google.cloud.bigquery.datatransfer.v1.EncryptionConfigurationOrBuilder>(
                getEncryptionConfiguration(), getParentForChildren(), isClean());
        encryptionConfiguration_ = null;
      }
      return encryptionConfigurationBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.datatransfer.v1.TransferConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.bigquery.datatransfer.v1.TransferConfig)
  private static final com.google.cloud.bigquery.datatransfer.v1.TransferConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.bigquery.datatransfer.v1.TransferConfig();
  }

  public static com.google.cloud.bigquery.datatransfer.v1.TransferConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TransferConfig> PARSER =
      new com.google.protobuf.AbstractParser<TransferConfig>() {
        @java.lang.Override
        public TransferConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TransferConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TransferConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.bigquery.datatransfer.v1.TransferConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
