/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/migration/v2/migration_entities.proto

package com.google.cloud.bigquery.migration.v2;

/**
 *
 *
 * <pre>
 * A single task for a migration which has details about the configuration of
 * the task.
 * </pre>
 *
 * Protobuf type {@code google.cloud.bigquery.migration.v2.MigrationTask}
 */
public final class MigrationTask extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.bigquery.migration.v2.MigrationTask)
    MigrationTaskOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use MigrationTask.newBuilder() to construct.
  private MigrationTask(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private MigrationTask() {
    id_ = "";
    type_ = "";
    state_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new MigrationTask();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.bigquery.migration.v2.MigrationEntitiesProto
        .internal_static_google_cloud_bigquery_migration_v2_MigrationTask_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.bigquery.migration.v2.MigrationEntitiesProto
        .internal_static_google_cloud_bigquery_migration_v2_MigrationTask_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.bigquery.migration.v2.MigrationTask.class,
            com.google.cloud.bigquery.migration.v2.MigrationTask.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Possible states of a migration task.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.bigquery.migration.v2.MigrationTask.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The state is unspecified.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The task is waiting for orchestration.
     * </pre>
     *
     * <code>PENDING = 1;</code>
     */
    PENDING(1),
    /**
     *
     *
     * <pre>
     * The task is assigned to an orchestrator.
     * </pre>
     *
     * <code>ORCHESTRATING = 2;</code>
     */
    ORCHESTRATING(2),
    /**
     *
     *
     * <pre>
     * The task is running, i.e. its subtasks are ready for execution.
     * </pre>
     *
     * <code>RUNNING = 3;</code>
     */
    RUNNING(3),
    /**
     *
     *
     * <pre>
     * Tha task is paused. Assigned subtasks can continue, but no new subtasks
     * will be scheduled.
     * </pre>
     *
     * <code>PAUSED = 4;</code>
     */
    PAUSED(4),
    /**
     *
     *
     * <pre>
     * The task finished successfully.
     * </pre>
     *
     * <code>SUCCEEDED = 5;</code>
     */
    SUCCEEDED(5),
    /**
     *
     *
     * <pre>
     * The task finished unsuccessfully.
     * </pre>
     *
     * <code>FAILED = 6;</code>
     */
    FAILED(6),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The state is unspecified.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The task is waiting for orchestration.
     * </pre>
     *
     * <code>PENDING = 1;</code>
     */
    public static final int PENDING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The task is assigned to an orchestrator.
     * </pre>
     *
     * <code>ORCHESTRATING = 2;</code>
     */
    public static final int ORCHESTRATING_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The task is running, i.e. its subtasks are ready for execution.
     * </pre>
     *
     * <code>RUNNING = 3;</code>
     */
    public static final int RUNNING_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Tha task is paused. Assigned subtasks can continue, but no new subtasks
     * will be scheduled.
     * </pre>
     *
     * <code>PAUSED = 4;</code>
     */
    public static final int PAUSED_VALUE = 4;
    /**
     *
     *
     * <pre>
     * The task finished successfully.
     * </pre>
     *
     * <code>SUCCEEDED = 5;</code>
     */
    public static final int SUCCEEDED_VALUE = 5;
    /**
     *
     *
     * <pre>
     * The task finished unsuccessfully.
     * </pre>
     *
     * <code>FAILED = 6;</code>
     */
    public static final int FAILED_VALUE = 6;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return PENDING;
        case 2:
          return ORCHESTRATING;
        case 3:
          return RUNNING;
        case 4:
          return PAUSED;
        case 5:
          return SUCCEEDED;
        case 6:
          return FAILED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.bigquery.migration.v2.MigrationTask.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.bigquery.migration.v2.MigrationTask.State)
  }

  private int taskDetailsCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object taskDetails_;

  public enum TaskDetailsCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    TRANSLATION_CONFIG_DETAILS(14),
    TASKDETAILS_NOT_SET(0);
    private final int value;

    private TaskDetailsCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TaskDetailsCase valueOf(int value) {
      return forNumber(value);
    }

    public static TaskDetailsCase forNumber(int value) {
      switch (value) {
        case 14:
          return TRANSLATION_CONFIG_DETAILS;
        case 0:
          return TASKDETAILS_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public TaskDetailsCase getTaskDetailsCase() {
    return TaskDetailsCase.forNumber(taskDetailsCase_);
  }

  public static final int TRANSLATION_CONFIG_DETAILS_FIELD_NUMBER = 14;
  /**
   *
   *
   * <pre>
   * Task configuration for Batch SQL Translation.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.migration.v2.TranslationConfigDetails translation_config_details = 14;
   * </code>
   *
   * @return Whether the translationConfigDetails field is set.
   */
  @java.lang.Override
  public boolean hasTranslationConfigDetails() {
    return taskDetailsCase_ == 14;
  }
  /**
   *
   *
   * <pre>
   * Task configuration for Batch SQL Translation.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.migration.v2.TranslationConfigDetails translation_config_details = 14;
   * </code>
   *
   * @return The translationConfigDetails.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2.TranslationConfigDetails
      getTranslationConfigDetails() {
    if (taskDetailsCase_ == 14) {
      return (com.google.cloud.bigquery.migration.v2.TranslationConfigDetails) taskDetails_;
    }
    return com.google.cloud.bigquery.migration.v2.TranslationConfigDetails.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Task configuration for Batch SQL Translation.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.migration.v2.TranslationConfigDetails translation_config_details = 14;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2.TranslationConfigDetailsOrBuilder
      getTranslationConfigDetailsOrBuilder() {
    if (taskDetailsCase_ == 14) {
      return (com.google.cloud.bigquery.migration.v2.TranslationConfigDetails) taskDetails_;
    }
    return com.google.cloud.bigquery.migration.v2.TranslationConfigDetails.getDefaultInstance();
  }

  public static final int ID_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object id_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Immutable. The unique identifier for the migration task. The
   * ID is server-generated.
   * </pre>
   *
   * <code>
   * string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The id.
   */
  @java.lang.Override
  public java.lang.String getId() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      id_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Immutable. The unique identifier for the migration task. The
   * ID is server-generated.
   * </pre>
   *
   * <code>
   * string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The bytes for id.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIdBytes() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      id_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TYPE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object type_ = "";
  /**
   *
   *
   * <pre>
   * The type of the task. This must be one of the supported task types:
   * Translation_Teradata2BQ, Translation_Redshift2BQ, Translation_Bteq2BQ,
   * Translation_Oracle2BQ, Translation_HiveQL2BQ, Translation_SparkSQL2BQ,
   * Translation_Snowflake2BQ, Translation_Netezza2BQ,
   * Translation_AzureSynapse2BQ, Translation_Vertica2BQ,
   * Translation_SQLServer2BQ, Translation_Presto2BQ, Translation_MySQL2BQ,
   * Translation_Postgresql2BQ.
   * </pre>
   *
   * <code>string type = 2;</code>
   *
   * @return The type.
   */
  @java.lang.Override
  public java.lang.String getType() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      type_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The type of the task. This must be one of the supported task types:
   * Translation_Teradata2BQ, Translation_Redshift2BQ, Translation_Bteq2BQ,
   * Translation_Oracle2BQ, Translation_HiveQL2BQ, Translation_SparkSQL2BQ,
   * Translation_Snowflake2BQ, Translation_Netezza2BQ,
   * Translation_AzureSynapse2BQ, Translation_Vertica2BQ,
   * Translation_SQLServer2BQ, Translation_Presto2BQ, Translation_MySQL2BQ,
   * Translation_Postgresql2BQ.
   * </pre>
   *
   * <code>string type = 2;</code>
   *
   * @return The bytes for type.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTypeBytes() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      type_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 4;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The current state of the task.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.migration.v2.MigrationTask.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The current state of the task.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.migration.v2.MigrationTask.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2.MigrationTask.State getState() {
    com.google.cloud.bigquery.migration.v2.MigrationTask.State result =
        com.google.cloud.bigquery.migration.v2.MigrationTask.State.forNumber(state_);
    return result == null
        ? com.google.cloud.bigquery.migration.v2.MigrationTask.State.UNRECOGNIZED
        : result;
  }

  public static final int PROCESSING_ERROR_FIELD_NUMBER = 5;
  private com.google.rpc.ErrorInfo processingError_;
  /**
   *
   *
   * <pre>
   * Output only. An explanation that may be populated when the task is in
   * FAILED state.
   * </pre>
   *
   * <code>.google.rpc.ErrorInfo processing_error = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the processingError field is set.
   */
  @java.lang.Override
  public boolean hasProcessingError() {
    return processingError_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. An explanation that may be populated when the task is in
   * FAILED state.
   * </pre>
   *
   * <code>.google.rpc.ErrorInfo processing_error = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The processingError.
   */
  @java.lang.Override
  public com.google.rpc.ErrorInfo getProcessingError() {
    return processingError_ == null
        ? com.google.rpc.ErrorInfo.getDefaultInstance()
        : processingError_;
  }
  /**
   *
   *
   * <pre>
   * Output only. An explanation that may be populated when the task is in
   * FAILED state.
   * </pre>
   *
   * <code>.google.rpc.ErrorInfo processing_error = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.rpc.ErrorInfoOrBuilder getProcessingErrorOrBuilder() {
    return processingError_ == null
        ? com.google.rpc.ErrorInfo.getDefaultInstance()
        : processingError_;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Time when the task was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6;</code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Time when the task was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6;</code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Time when the task was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int LAST_UPDATE_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp lastUpdateTime_;
  /**
   *
   *
   * <pre>
   * Time when the task was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp last_update_time = 7;</code>
   *
   * @return Whether the lastUpdateTime field is set.
   */
  @java.lang.Override
  public boolean hasLastUpdateTime() {
    return lastUpdateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Time when the task was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp last_update_time = 7;</code>
   *
   * @return The lastUpdateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getLastUpdateTime() {
    return lastUpdateTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : lastUpdateTime_;
  }
  /**
   *
   *
   * <pre>
   * Time when the task was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp last_update_time = 7;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getLastUpdateTimeOrBuilder() {
    return lastUpdateTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : lastUpdateTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(type_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, type_);
    }
    if (state_
        != com.google.cloud.bigquery.migration.v2.MigrationTask.State.STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(4, state_);
    }
    if (processingError_ != null) {
      output.writeMessage(5, getProcessingError());
    }
    if (createTime_ != null) {
      output.writeMessage(6, getCreateTime());
    }
    if (lastUpdateTime_ != null) {
      output.writeMessage(7, getLastUpdateTime());
    }
    if (taskDetailsCase_ == 14) {
      output.writeMessage(
          14, (com.google.cloud.bigquery.migration.v2.TranslationConfigDetails) taskDetails_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(type_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, type_);
    }
    if (state_
        != com.google.cloud.bigquery.migration.v2.MigrationTask.State.STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, state_);
    }
    if (processingError_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getProcessingError());
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getCreateTime());
    }
    if (lastUpdateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getLastUpdateTime());
    }
    if (taskDetailsCase_ == 14) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              14, (com.google.cloud.bigquery.migration.v2.TranslationConfigDetails) taskDetails_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.bigquery.migration.v2.MigrationTask)) {
      return super.equals(obj);
    }
    com.google.cloud.bigquery.migration.v2.MigrationTask other =
        (com.google.cloud.bigquery.migration.v2.MigrationTask) obj;

    if (!getId().equals(other.getId())) return false;
    if (!getType().equals(other.getType())) return false;
    if (state_ != other.state_) return false;
    if (hasProcessingError() != other.hasProcessingError()) return false;
    if (hasProcessingError()) {
      if (!getProcessingError().equals(other.getProcessingError())) return false;
    }
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasLastUpdateTime() != other.hasLastUpdateTime()) return false;
    if (hasLastUpdateTime()) {
      if (!getLastUpdateTime().equals(other.getLastUpdateTime())) return false;
    }
    if (!getTaskDetailsCase().equals(other.getTaskDetailsCase())) return false;
    switch (taskDetailsCase_) {
      case 14:
        if (!getTranslationConfigDetails().equals(other.getTranslationConfigDetails()))
          return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ID_FIELD_NUMBER;
    hash = (53 * hash) + getId().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getType().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    if (hasProcessingError()) {
      hash = (37 * hash) + PROCESSING_ERROR_FIELD_NUMBER;
      hash = (53 * hash) + getProcessingError().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasLastUpdateTime()) {
      hash = (37 * hash) + LAST_UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getLastUpdateTime().hashCode();
    }
    switch (taskDetailsCase_) {
      case 14:
        hash = (37 * hash) + TRANSLATION_CONFIG_DETAILS_FIELD_NUMBER;
        hash = (53 * hash) + getTranslationConfigDetails().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.bigquery.migration.v2.MigrationTask parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.migration.v2.MigrationTask parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2.MigrationTask parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.migration.v2.MigrationTask parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2.MigrationTask parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.migration.v2.MigrationTask parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2.MigrationTask parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.migration.v2.MigrationTask parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2.MigrationTask parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.migration.v2.MigrationTask parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2.MigrationTask parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.migration.v2.MigrationTask parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.bigquery.migration.v2.MigrationTask prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A single task for a migration which has details about the configuration of
   * the task.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.migration.v2.MigrationTask}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.migration.v2.MigrationTask)
      com.google.cloud.bigquery.migration.v2.MigrationTaskOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.migration.v2.MigrationEntitiesProto
          .internal_static_google_cloud_bigquery_migration_v2_MigrationTask_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.migration.v2.MigrationEntitiesProto
          .internal_static_google_cloud_bigquery_migration_v2_MigrationTask_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.migration.v2.MigrationTask.class,
              com.google.cloud.bigquery.migration.v2.MigrationTask.Builder.class);
    }

    // Construct using com.google.cloud.bigquery.migration.v2.MigrationTask.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (translationConfigDetailsBuilder_ != null) {
        translationConfigDetailsBuilder_.clear();
      }
      id_ = "";
      type_ = "";
      state_ = 0;
      processingError_ = null;
      if (processingErrorBuilder_ != null) {
        processingErrorBuilder_.dispose();
        processingErrorBuilder_ = null;
      }
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      lastUpdateTime_ = null;
      if (lastUpdateTimeBuilder_ != null) {
        lastUpdateTimeBuilder_.dispose();
        lastUpdateTimeBuilder_ = null;
      }
      taskDetailsCase_ = 0;
      taskDetails_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.bigquery.migration.v2.MigrationEntitiesProto
          .internal_static_google_cloud_bigquery_migration_v2_MigrationTask_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2.MigrationTask getDefaultInstanceForType() {
      return com.google.cloud.bigquery.migration.v2.MigrationTask.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2.MigrationTask build() {
      com.google.cloud.bigquery.migration.v2.MigrationTask result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2.MigrationTask buildPartial() {
      com.google.cloud.bigquery.migration.v2.MigrationTask result =
          new com.google.cloud.bigquery.migration.v2.MigrationTask(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.bigquery.migration.v2.MigrationTask result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.id_ = id_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.type_ = type_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.processingError_ =
            processingErrorBuilder_ == null ? processingError_ : processingErrorBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.lastUpdateTime_ =
            lastUpdateTimeBuilder_ == null ? lastUpdateTime_ : lastUpdateTimeBuilder_.build();
      }
    }

    private void buildPartialOneofs(com.google.cloud.bigquery.migration.v2.MigrationTask result) {
      result.taskDetailsCase_ = taskDetailsCase_;
      result.taskDetails_ = this.taskDetails_;
      if (taskDetailsCase_ == 14 && translationConfigDetailsBuilder_ != null) {
        result.taskDetails_ = translationConfigDetailsBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.bigquery.migration.v2.MigrationTask) {
        return mergeFrom((com.google.cloud.bigquery.migration.v2.MigrationTask) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.bigquery.migration.v2.MigrationTask other) {
      if (other == com.google.cloud.bigquery.migration.v2.MigrationTask.getDefaultInstance())
        return this;
      if (!other.getId().isEmpty()) {
        id_ = other.id_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getType().isEmpty()) {
        type_ = other.type_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.hasProcessingError()) {
        mergeProcessingError(other.getProcessingError());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasLastUpdateTime()) {
        mergeLastUpdateTime(other.getLastUpdateTime());
      }
      switch (other.getTaskDetailsCase()) {
        case TRANSLATION_CONFIG_DETAILS:
          {
            mergeTranslationConfigDetails(other.getTranslationConfigDetails());
            break;
          }
        case TASKDETAILS_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                id_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 10
            case 18:
              {
                type_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 18
            case 32:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 42:
              {
                input.readMessage(getProcessingErrorFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getLastUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 114:
              {
                input.readMessage(
                    getTranslationConfigDetailsFieldBuilder().getBuilder(), extensionRegistry);
                taskDetailsCase_ = 14;
                break;
              } // case 114
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int taskDetailsCase_ = 0;
    private java.lang.Object taskDetails_;

    public TaskDetailsCase getTaskDetailsCase() {
      return TaskDetailsCase.forNumber(taskDetailsCase_);
    }

    public Builder clearTaskDetails() {
      taskDetailsCase_ = 0;
      taskDetails_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2.TranslationConfigDetails,
            com.google.cloud.bigquery.migration.v2.TranslationConfigDetails.Builder,
            com.google.cloud.bigquery.migration.v2.TranslationConfigDetailsOrBuilder>
        translationConfigDetailsBuilder_;
    /**
     *
     *
     * <pre>
     * Task configuration for Batch SQL Translation.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2.TranslationConfigDetails translation_config_details = 14;
     * </code>
     *
     * @return Whether the translationConfigDetails field is set.
     */
    @java.lang.Override
    public boolean hasTranslationConfigDetails() {
      return taskDetailsCase_ == 14;
    }
    /**
     *
     *
     * <pre>
     * Task configuration for Batch SQL Translation.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2.TranslationConfigDetails translation_config_details = 14;
     * </code>
     *
     * @return The translationConfigDetails.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2.TranslationConfigDetails
        getTranslationConfigDetails() {
      if (translationConfigDetailsBuilder_ == null) {
        if (taskDetailsCase_ == 14) {
          return (com.google.cloud.bigquery.migration.v2.TranslationConfigDetails) taskDetails_;
        }
        return com.google.cloud.bigquery.migration.v2.TranslationConfigDetails.getDefaultInstance();
      } else {
        if (taskDetailsCase_ == 14) {
          return translationConfigDetailsBuilder_.getMessage();
        }
        return com.google.cloud.bigquery.migration.v2.TranslationConfigDetails.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Task configuration for Batch SQL Translation.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2.TranslationConfigDetails translation_config_details = 14;
     * </code>
     */
    public Builder setTranslationConfigDetails(
        com.google.cloud.bigquery.migration.v2.TranslationConfigDetails value) {
      if (translationConfigDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        taskDetails_ = value;
        onChanged();
      } else {
        translationConfigDetailsBuilder_.setMessage(value);
      }
      taskDetailsCase_ = 14;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Task configuration for Batch SQL Translation.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2.TranslationConfigDetails translation_config_details = 14;
     * </code>
     */
    public Builder setTranslationConfigDetails(
        com.google.cloud.bigquery.migration.v2.TranslationConfigDetails.Builder builderForValue) {
      if (translationConfigDetailsBuilder_ == null) {
        taskDetails_ = builderForValue.build();
        onChanged();
      } else {
        translationConfigDetailsBuilder_.setMessage(builderForValue.build());
      }
      taskDetailsCase_ = 14;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Task configuration for Batch SQL Translation.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2.TranslationConfigDetails translation_config_details = 14;
     * </code>
     */
    public Builder mergeTranslationConfigDetails(
        com.google.cloud.bigquery.migration.v2.TranslationConfigDetails value) {
      if (translationConfigDetailsBuilder_ == null) {
        if (taskDetailsCase_ == 14
            && taskDetails_
                != com.google.cloud.bigquery.migration.v2.TranslationConfigDetails
                    .getDefaultInstance()) {
          taskDetails_ =
              com.google.cloud.bigquery.migration.v2.TranslationConfigDetails.newBuilder(
                      (com.google.cloud.bigquery.migration.v2.TranslationConfigDetails)
                          taskDetails_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          taskDetails_ = value;
        }
        onChanged();
      } else {
        if (taskDetailsCase_ == 14) {
          translationConfigDetailsBuilder_.mergeFrom(value);
        } else {
          translationConfigDetailsBuilder_.setMessage(value);
        }
      }
      taskDetailsCase_ = 14;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Task configuration for Batch SQL Translation.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2.TranslationConfigDetails translation_config_details = 14;
     * </code>
     */
    public Builder clearTranslationConfigDetails() {
      if (translationConfigDetailsBuilder_ == null) {
        if (taskDetailsCase_ == 14) {
          taskDetailsCase_ = 0;
          taskDetails_ = null;
          onChanged();
        }
      } else {
        if (taskDetailsCase_ == 14) {
          taskDetailsCase_ = 0;
          taskDetails_ = null;
        }
        translationConfigDetailsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Task configuration for Batch SQL Translation.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2.TranslationConfigDetails translation_config_details = 14;
     * </code>
     */
    public com.google.cloud.bigquery.migration.v2.TranslationConfigDetails.Builder
        getTranslationConfigDetailsBuilder() {
      return getTranslationConfigDetailsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Task configuration for Batch SQL Translation.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2.TranslationConfigDetails translation_config_details = 14;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2.TranslationConfigDetailsOrBuilder
        getTranslationConfigDetailsOrBuilder() {
      if ((taskDetailsCase_ == 14) && (translationConfigDetailsBuilder_ != null)) {
        return translationConfigDetailsBuilder_.getMessageOrBuilder();
      } else {
        if (taskDetailsCase_ == 14) {
          return (com.google.cloud.bigquery.migration.v2.TranslationConfigDetails) taskDetails_;
        }
        return com.google.cloud.bigquery.migration.v2.TranslationConfigDetails.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Task configuration for Batch SQL Translation.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2.TranslationConfigDetails translation_config_details = 14;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2.TranslationConfigDetails,
            com.google.cloud.bigquery.migration.v2.TranslationConfigDetails.Builder,
            com.google.cloud.bigquery.migration.v2.TranslationConfigDetailsOrBuilder>
        getTranslationConfigDetailsFieldBuilder() {
      if (translationConfigDetailsBuilder_ == null) {
        if (!(taskDetailsCase_ == 14)) {
          taskDetails_ =
              com.google.cloud.bigquery.migration.v2.TranslationConfigDetails.getDefaultInstance();
        }
        translationConfigDetailsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.migration.v2.TranslationConfigDetails,
                com.google.cloud.bigquery.migration.v2.TranslationConfigDetails.Builder,
                com.google.cloud.bigquery.migration.v2.TranslationConfigDetailsOrBuilder>(
                (com.google.cloud.bigquery.migration.v2.TranslationConfigDetails) taskDetails_,
                getParentForChildren(),
                isClean());
        taskDetails_ = null;
      }
      taskDetailsCase_ = 14;
      onChanged();
      return translationConfigDetailsBuilder_;
    }

    private java.lang.Object id_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The unique identifier for the migration task. The
     * ID is server-generated.
     * </pre>
     *
     * <code>
     * string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The id.
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The unique identifier for the migration task. The
     * ID is server-generated.
     * </pre>
     *
     * <code>
     * string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The bytes for id.
     */
    public com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The unique identifier for the migration task. The
     * ID is server-generated.
     * </pre>
     *
     * <code>
     * string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      id_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The unique identifier for the migration task. The
     * ID is server-generated.
     * </pre>
     *
     * <code>
     * string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      id_ = getDefaultInstance().getId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The unique identifier for the migration task. The
     * ID is server-generated.
     * </pre>
     *
     * <code>
     * string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The bytes for id to set.
     * @return This builder for chaining.
     */
    public Builder setIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      id_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object type_ = "";
    /**
     *
     *
     * <pre>
     * The type of the task. This must be one of the supported task types:
     * Translation_Teradata2BQ, Translation_Redshift2BQ, Translation_Bteq2BQ,
     * Translation_Oracle2BQ, Translation_HiveQL2BQ, Translation_SparkSQL2BQ,
     * Translation_Snowflake2BQ, Translation_Netezza2BQ,
     * Translation_AzureSynapse2BQ, Translation_Vertica2BQ,
     * Translation_SQLServer2BQ, Translation_Presto2BQ, Translation_MySQL2BQ,
     * Translation_Postgresql2BQ.
     * </pre>
     *
     * <code>string type = 2;</code>
     *
     * @return The type.
     */
    public java.lang.String getType() {
      java.lang.Object ref = type_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        type_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The type of the task. This must be one of the supported task types:
     * Translation_Teradata2BQ, Translation_Redshift2BQ, Translation_Bteq2BQ,
     * Translation_Oracle2BQ, Translation_HiveQL2BQ, Translation_SparkSQL2BQ,
     * Translation_Snowflake2BQ, Translation_Netezza2BQ,
     * Translation_AzureSynapse2BQ, Translation_Vertica2BQ,
     * Translation_SQLServer2BQ, Translation_Presto2BQ, Translation_MySQL2BQ,
     * Translation_Postgresql2BQ.
     * </pre>
     *
     * <code>string type = 2;</code>
     *
     * @return The bytes for type.
     */
    public com.google.protobuf.ByteString getTypeBytes() {
      java.lang.Object ref = type_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        type_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The type of the task. This must be one of the supported task types:
     * Translation_Teradata2BQ, Translation_Redshift2BQ, Translation_Bteq2BQ,
     * Translation_Oracle2BQ, Translation_HiveQL2BQ, Translation_SparkSQL2BQ,
     * Translation_Snowflake2BQ, Translation_Netezza2BQ,
     * Translation_AzureSynapse2BQ, Translation_Vertica2BQ,
     * Translation_SQLServer2BQ, Translation_Presto2BQ, Translation_MySQL2BQ,
     * Translation_Postgresql2BQ.
     * </pre>
     *
     * <code>string type = 2;</code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      type_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of the task. This must be one of the supported task types:
     * Translation_Teradata2BQ, Translation_Redshift2BQ, Translation_Bteq2BQ,
     * Translation_Oracle2BQ, Translation_HiveQL2BQ, Translation_SparkSQL2BQ,
     * Translation_Snowflake2BQ, Translation_Netezza2BQ,
     * Translation_AzureSynapse2BQ, Translation_Vertica2BQ,
     * Translation_SQLServer2BQ, Translation_Presto2BQ, Translation_MySQL2BQ,
     * Translation_Postgresql2BQ.
     * </pre>
     *
     * <code>string type = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      type_ = getDefaultInstance().getType();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of the task. This must be one of the supported task types:
     * Translation_Teradata2BQ, Translation_Redshift2BQ, Translation_Bteq2BQ,
     * Translation_Oracle2BQ, Translation_HiveQL2BQ, Translation_SparkSQL2BQ,
     * Translation_Snowflake2BQ, Translation_Netezza2BQ,
     * Translation_AzureSynapse2BQ, Translation_Vertica2BQ,
     * Translation_SQLServer2BQ, Translation_Presto2BQ, Translation_MySQL2BQ,
     * Translation_Postgresql2BQ.
     * </pre>
     *
     * <code>string type = 2;</code>
     *
     * @param value The bytes for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      type_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The current state of the task.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2.MigrationTask.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the task.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2.MigrationTask.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the task.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2.MigrationTask.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2.MigrationTask.State getState() {
      com.google.cloud.bigquery.migration.v2.MigrationTask.State result =
          com.google.cloud.bigquery.migration.v2.MigrationTask.State.forNumber(state_);
      return result == null
          ? com.google.cloud.bigquery.migration.v2.MigrationTask.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the task.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2.MigrationTask.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.bigquery.migration.v2.MigrationTask.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the task.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2.MigrationTask.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000008);
      state_ = 0;
      onChanged();
      return this;
    }

    private com.google.rpc.ErrorInfo processingError_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.ErrorInfo,
            com.google.rpc.ErrorInfo.Builder,
            com.google.rpc.ErrorInfoOrBuilder>
        processingErrorBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. An explanation that may be populated when the task is in
     * FAILED state.
     * </pre>
     *
     * <code>
     * .google.rpc.ErrorInfo processing_error = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the processingError field is set.
     */
    public boolean hasProcessingError() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. An explanation that may be populated when the task is in
     * FAILED state.
     * </pre>
     *
     * <code>
     * .google.rpc.ErrorInfo processing_error = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The processingError.
     */
    public com.google.rpc.ErrorInfo getProcessingError() {
      if (processingErrorBuilder_ == null) {
        return processingError_ == null
            ? com.google.rpc.ErrorInfo.getDefaultInstance()
            : processingError_;
      } else {
        return processingErrorBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. An explanation that may be populated when the task is in
     * FAILED state.
     * </pre>
     *
     * <code>
     * .google.rpc.ErrorInfo processing_error = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setProcessingError(com.google.rpc.ErrorInfo value) {
      if (processingErrorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        processingError_ = value;
      } else {
        processingErrorBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. An explanation that may be populated when the task is in
     * FAILED state.
     * </pre>
     *
     * <code>
     * .google.rpc.ErrorInfo processing_error = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setProcessingError(com.google.rpc.ErrorInfo.Builder builderForValue) {
      if (processingErrorBuilder_ == null) {
        processingError_ = builderForValue.build();
      } else {
        processingErrorBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. An explanation that may be populated when the task is in
     * FAILED state.
     * </pre>
     *
     * <code>
     * .google.rpc.ErrorInfo processing_error = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeProcessingError(com.google.rpc.ErrorInfo value) {
      if (processingErrorBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && processingError_ != null
            && processingError_ != com.google.rpc.ErrorInfo.getDefaultInstance()) {
          getProcessingErrorBuilder().mergeFrom(value);
        } else {
          processingError_ = value;
        }
      } else {
        processingErrorBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. An explanation that may be populated when the task is in
     * FAILED state.
     * </pre>
     *
     * <code>
     * .google.rpc.ErrorInfo processing_error = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearProcessingError() {
      bitField0_ = (bitField0_ & ~0x00000010);
      processingError_ = null;
      if (processingErrorBuilder_ != null) {
        processingErrorBuilder_.dispose();
        processingErrorBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. An explanation that may be populated when the task is in
     * FAILED state.
     * </pre>
     *
     * <code>
     * .google.rpc.ErrorInfo processing_error = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.rpc.ErrorInfo.Builder getProcessingErrorBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getProcessingErrorFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. An explanation that may be populated when the task is in
     * FAILED state.
     * </pre>
     *
     * <code>
     * .google.rpc.ErrorInfo processing_error = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.rpc.ErrorInfoOrBuilder getProcessingErrorOrBuilder() {
      if (processingErrorBuilder_ != null) {
        return processingErrorBuilder_.getMessageOrBuilder();
      } else {
        return processingError_ == null
            ? com.google.rpc.ErrorInfo.getDefaultInstance()
            : processingError_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. An explanation that may be populated when the task is in
     * FAILED state.
     * </pre>
     *
     * <code>
     * .google.rpc.ErrorInfo processing_error = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.ErrorInfo,
            com.google.rpc.ErrorInfo.Builder,
            com.google.rpc.ErrorInfoOrBuilder>
        getProcessingErrorFieldBuilder() {
      if (processingErrorBuilder_ == null) {
        processingErrorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.ErrorInfo,
                com.google.rpc.ErrorInfo.Builder,
                com.google.rpc.ErrorInfoOrBuilder>(
                getProcessingError(), getParentForChildren(), isClean());
        processingError_ = null;
      }
      return processingErrorBuilder_;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Time when the task was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 6;</code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Time when the task was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 6;</code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Time when the task was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 6;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the task was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 6;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the task was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 6;</code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the task was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 6;</code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000020);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the task was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 6;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Time when the task was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 6;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Time when the task was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp lastUpdateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        lastUpdateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Time when the task was last updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_update_time = 7;</code>
     *
     * @return Whether the lastUpdateTime field is set.
     */
    public boolean hasLastUpdateTime() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Time when the task was last updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_update_time = 7;</code>
     *
     * @return The lastUpdateTime.
     */
    public com.google.protobuf.Timestamp getLastUpdateTime() {
      if (lastUpdateTimeBuilder_ == null) {
        return lastUpdateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastUpdateTime_;
      } else {
        return lastUpdateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Time when the task was last updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_update_time = 7;</code>
     */
    public Builder setLastUpdateTime(com.google.protobuf.Timestamp value) {
      if (lastUpdateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        lastUpdateTime_ = value;
      } else {
        lastUpdateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the task was last updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_update_time = 7;</code>
     */
    public Builder setLastUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (lastUpdateTimeBuilder_ == null) {
        lastUpdateTime_ = builderForValue.build();
      } else {
        lastUpdateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the task was last updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_update_time = 7;</code>
     */
    public Builder mergeLastUpdateTime(com.google.protobuf.Timestamp value) {
      if (lastUpdateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && lastUpdateTime_ != null
            && lastUpdateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getLastUpdateTimeBuilder().mergeFrom(value);
        } else {
          lastUpdateTime_ = value;
        }
      } else {
        lastUpdateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the task was last updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_update_time = 7;</code>
     */
    public Builder clearLastUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000040);
      lastUpdateTime_ = null;
      if (lastUpdateTimeBuilder_ != null) {
        lastUpdateTimeBuilder_.dispose();
        lastUpdateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the task was last updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_update_time = 7;</code>
     */
    public com.google.protobuf.Timestamp.Builder getLastUpdateTimeBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getLastUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Time when the task was last updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_update_time = 7;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getLastUpdateTimeOrBuilder() {
      if (lastUpdateTimeBuilder_ != null) {
        return lastUpdateTimeBuilder_.getMessageOrBuilder();
      } else {
        return lastUpdateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastUpdateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Time when the task was last updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_update_time = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getLastUpdateTimeFieldBuilder() {
      if (lastUpdateTimeBuilder_ == null) {
        lastUpdateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getLastUpdateTime(), getParentForChildren(), isClean());
        lastUpdateTime_ = null;
      }
      return lastUpdateTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.migration.v2.MigrationTask)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.bigquery.migration.v2.MigrationTask)
  private static final com.google.cloud.bigquery.migration.v2.MigrationTask DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.bigquery.migration.v2.MigrationTask();
  }

  public static com.google.cloud.bigquery.migration.v2.MigrationTask getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<MigrationTask> PARSER =
      new com.google.protobuf.AbstractParser<MigrationTask>() {
        @java.lang.Override
        public MigrationTask parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<MigrationTask> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<MigrationTask> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2.MigrationTask getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
