/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/migration/v2/migration_error_details.proto

package com.google.cloud.bigquery.migration.v2;

/**
 *
 *
 * <pre>
 * Provides details for errors and the corresponding resources.
 * </pre>
 *
 * Protobuf type {@code google.cloud.bigquery.migration.v2.ResourceErrorDetail}
 */
public final class ResourceErrorDetail extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.bigquery.migration.v2.ResourceErrorDetail)
    ResourceErrorDetailOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ResourceErrorDetail.newBuilder() to construct.
  private ResourceErrorDetail(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ResourceErrorDetail() {
    errorDetails_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ResourceErrorDetail();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.bigquery.migration.v2.MigrationErrorDetailsProto
        .internal_static_google_cloud_bigquery_migration_v2_ResourceErrorDetail_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.bigquery.migration.v2.MigrationErrorDetailsProto
        .internal_static_google_cloud_bigquery_migration_v2_ResourceErrorDetail_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.bigquery.migration.v2.ResourceErrorDetail.class,
            com.google.cloud.bigquery.migration.v2.ResourceErrorDetail.Builder.class);
  }

  public static final int RESOURCE_INFO_FIELD_NUMBER = 1;
  private com.google.rpc.ResourceInfo resourceInfo_;
  /**
   *
   *
   * <pre>
   * Required. Information about the resource where the error is located.
   * </pre>
   *
   * <code>.google.rpc.ResourceInfo resource_info = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the resourceInfo field is set.
   */
  @java.lang.Override
  public boolean hasResourceInfo() {
    return resourceInfo_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. Information about the resource where the error is located.
   * </pre>
   *
   * <code>.google.rpc.ResourceInfo resource_info = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The resourceInfo.
   */
  @java.lang.Override
  public com.google.rpc.ResourceInfo getResourceInfo() {
    return resourceInfo_ == null ? com.google.rpc.ResourceInfo.getDefaultInstance() : resourceInfo_;
  }
  /**
   *
   *
   * <pre>
   * Required. Information about the resource where the error is located.
   * </pre>
   *
   * <code>.google.rpc.ResourceInfo resource_info = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.rpc.ResourceInfoOrBuilder getResourceInfoOrBuilder() {
    return resourceInfo_ == null ? com.google.rpc.ResourceInfo.getDefaultInstance() : resourceInfo_;
  }

  public static final int ERROR_DETAILS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.bigquery.migration.v2.ErrorDetail> errorDetails_;
  /**
   *
   *
   * <pre>
   * Required. The error details for the resource.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.migration.v2.ErrorDetail error_details = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.bigquery.migration.v2.ErrorDetail> getErrorDetailsList() {
    return errorDetails_;
  }
  /**
   *
   *
   * <pre>
   * Required. The error details for the resource.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.migration.v2.ErrorDetail error_details = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.bigquery.migration.v2.ErrorDetailOrBuilder>
      getErrorDetailsOrBuilderList() {
    return errorDetails_;
  }
  /**
   *
   *
   * <pre>
   * Required. The error details for the resource.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.migration.v2.ErrorDetail error_details = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getErrorDetailsCount() {
    return errorDetails_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. The error details for the resource.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.migration.v2.ErrorDetail error_details = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2.ErrorDetail getErrorDetails(int index) {
    return errorDetails_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. The error details for the resource.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.migration.v2.ErrorDetail error_details = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2.ErrorDetailOrBuilder getErrorDetailsOrBuilder(
      int index) {
    return errorDetails_.get(index);
  }

  public static final int ERROR_COUNT_FIELD_NUMBER = 3;
  private int errorCount_ = 0;
  /**
   *
   *
   * <pre>
   * Required. How many errors there are in total for the resource. Truncation
   * can be indicated by having an `error_count` that is higher than the size of
   * `error_details`.
   * </pre>
   *
   * <code>int32 error_count = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The errorCount.
   */
  @java.lang.Override
  public int getErrorCount() {
    return errorCount_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (resourceInfo_ != null) {
      output.writeMessage(1, getResourceInfo());
    }
    for (int i = 0; i < errorDetails_.size(); i++) {
      output.writeMessage(2, errorDetails_.get(i));
    }
    if (errorCount_ != 0) {
      output.writeInt32(3, errorCount_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (resourceInfo_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getResourceInfo());
    }
    for (int i = 0; i < errorDetails_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, errorDetails_.get(i));
    }
    if (errorCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, errorCount_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.bigquery.migration.v2.ResourceErrorDetail)) {
      return super.equals(obj);
    }
    com.google.cloud.bigquery.migration.v2.ResourceErrorDetail other =
        (com.google.cloud.bigquery.migration.v2.ResourceErrorDetail) obj;

    if (hasResourceInfo() != other.hasResourceInfo()) return false;
    if (hasResourceInfo()) {
      if (!getResourceInfo().equals(other.getResourceInfo())) return false;
    }
    if (!getErrorDetailsList().equals(other.getErrorDetailsList())) return false;
    if (getErrorCount() != other.getErrorCount()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasResourceInfo()) {
      hash = (37 * hash) + RESOURCE_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getResourceInfo().hashCode();
    }
    if (getErrorDetailsCount() > 0) {
      hash = (37 * hash) + ERROR_DETAILS_FIELD_NUMBER;
      hash = (53 * hash) + getErrorDetailsList().hashCode();
    }
    hash = (37 * hash) + ERROR_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getErrorCount();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.bigquery.migration.v2.ResourceErrorDetail parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.migration.v2.ResourceErrorDetail parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2.ResourceErrorDetail parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.migration.v2.ResourceErrorDetail parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2.ResourceErrorDetail parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.migration.v2.ResourceErrorDetail parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2.ResourceErrorDetail parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.migration.v2.ResourceErrorDetail parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2.ResourceErrorDetail parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.migration.v2.ResourceErrorDetail parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2.ResourceErrorDetail parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.migration.v2.ResourceErrorDetail parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.bigquery.migration.v2.ResourceErrorDetail prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Provides details for errors and the corresponding resources.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.migration.v2.ResourceErrorDetail}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.migration.v2.ResourceErrorDetail)
      com.google.cloud.bigquery.migration.v2.ResourceErrorDetailOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.migration.v2.MigrationErrorDetailsProto
          .internal_static_google_cloud_bigquery_migration_v2_ResourceErrorDetail_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.migration.v2.MigrationErrorDetailsProto
          .internal_static_google_cloud_bigquery_migration_v2_ResourceErrorDetail_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.migration.v2.ResourceErrorDetail.class,
              com.google.cloud.bigquery.migration.v2.ResourceErrorDetail.Builder.class);
    }

    // Construct using com.google.cloud.bigquery.migration.v2.ResourceErrorDetail.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      resourceInfo_ = null;
      if (resourceInfoBuilder_ != null) {
        resourceInfoBuilder_.dispose();
        resourceInfoBuilder_ = null;
      }
      if (errorDetailsBuilder_ == null) {
        errorDetails_ = java.util.Collections.emptyList();
      } else {
        errorDetails_ = null;
        errorDetailsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      errorCount_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.bigquery.migration.v2.MigrationErrorDetailsProto
          .internal_static_google_cloud_bigquery_migration_v2_ResourceErrorDetail_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2.ResourceErrorDetail getDefaultInstanceForType() {
      return com.google.cloud.bigquery.migration.v2.ResourceErrorDetail.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2.ResourceErrorDetail build() {
      com.google.cloud.bigquery.migration.v2.ResourceErrorDetail result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2.ResourceErrorDetail buildPartial() {
      com.google.cloud.bigquery.migration.v2.ResourceErrorDetail result =
          new com.google.cloud.bigquery.migration.v2.ResourceErrorDetail(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.bigquery.migration.v2.ResourceErrorDetail result) {
      if (errorDetailsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          errorDetails_ = java.util.Collections.unmodifiableList(errorDetails_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.errorDetails_ = errorDetails_;
      } else {
        result.errorDetails_ = errorDetailsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.bigquery.migration.v2.ResourceErrorDetail result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.resourceInfo_ =
            resourceInfoBuilder_ == null ? resourceInfo_ : resourceInfoBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.errorCount_ = errorCount_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.bigquery.migration.v2.ResourceErrorDetail) {
        return mergeFrom((com.google.cloud.bigquery.migration.v2.ResourceErrorDetail) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.bigquery.migration.v2.ResourceErrorDetail other) {
      if (other == com.google.cloud.bigquery.migration.v2.ResourceErrorDetail.getDefaultInstance())
        return this;
      if (other.hasResourceInfo()) {
        mergeResourceInfo(other.getResourceInfo());
      }
      if (errorDetailsBuilder_ == null) {
        if (!other.errorDetails_.isEmpty()) {
          if (errorDetails_.isEmpty()) {
            errorDetails_ = other.errorDetails_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureErrorDetailsIsMutable();
            errorDetails_.addAll(other.errorDetails_);
          }
          onChanged();
        }
      } else {
        if (!other.errorDetails_.isEmpty()) {
          if (errorDetailsBuilder_.isEmpty()) {
            errorDetailsBuilder_.dispose();
            errorDetailsBuilder_ = null;
            errorDetails_ = other.errorDetails_;
            bitField0_ = (bitField0_ & ~0x00000002);
            errorDetailsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getErrorDetailsFieldBuilder()
                    : null;
          } else {
            errorDetailsBuilder_.addAllMessages(other.errorDetails_);
          }
        }
      }
      if (other.getErrorCount() != 0) {
        setErrorCount(other.getErrorCount());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getResourceInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.bigquery.migration.v2.ErrorDetail m =
                    input.readMessage(
                        com.google.cloud.bigquery.migration.v2.ErrorDetail.parser(),
                        extensionRegistry);
                if (errorDetailsBuilder_ == null) {
                  ensureErrorDetailsIsMutable();
                  errorDetails_.add(m);
                } else {
                  errorDetailsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 24:
              {
                errorCount_ = input.readInt32();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.rpc.ResourceInfo resourceInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.ResourceInfo,
            com.google.rpc.ResourceInfo.Builder,
            com.google.rpc.ResourceInfoOrBuilder>
        resourceInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Information about the resource where the error is located.
     * </pre>
     *
     * <code>.google.rpc.ResourceInfo resource_info = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the resourceInfo field is set.
     */
    public boolean hasResourceInfo() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. Information about the resource where the error is located.
     * </pre>
     *
     * <code>.google.rpc.ResourceInfo resource_info = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The resourceInfo.
     */
    public com.google.rpc.ResourceInfo getResourceInfo() {
      if (resourceInfoBuilder_ == null) {
        return resourceInfo_ == null
            ? com.google.rpc.ResourceInfo.getDefaultInstance()
            : resourceInfo_;
      } else {
        return resourceInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Information about the resource where the error is located.
     * </pre>
     *
     * <code>.google.rpc.ResourceInfo resource_info = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setResourceInfo(com.google.rpc.ResourceInfo value) {
      if (resourceInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        resourceInfo_ = value;
      } else {
        resourceInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Information about the resource where the error is located.
     * </pre>
     *
     * <code>.google.rpc.ResourceInfo resource_info = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setResourceInfo(com.google.rpc.ResourceInfo.Builder builderForValue) {
      if (resourceInfoBuilder_ == null) {
        resourceInfo_ = builderForValue.build();
      } else {
        resourceInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Information about the resource where the error is located.
     * </pre>
     *
     * <code>.google.rpc.ResourceInfo resource_info = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeResourceInfo(com.google.rpc.ResourceInfo value) {
      if (resourceInfoBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && resourceInfo_ != null
            && resourceInfo_ != com.google.rpc.ResourceInfo.getDefaultInstance()) {
          getResourceInfoBuilder().mergeFrom(value);
        } else {
          resourceInfo_ = value;
        }
      } else {
        resourceInfoBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Information about the resource where the error is located.
     * </pre>
     *
     * <code>.google.rpc.ResourceInfo resource_info = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearResourceInfo() {
      bitField0_ = (bitField0_ & ~0x00000001);
      resourceInfo_ = null;
      if (resourceInfoBuilder_ != null) {
        resourceInfoBuilder_.dispose();
        resourceInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Information about the resource where the error is located.
     * </pre>
     *
     * <code>.google.rpc.ResourceInfo resource_info = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.rpc.ResourceInfo.Builder getResourceInfoBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getResourceInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Information about the resource where the error is located.
     * </pre>
     *
     * <code>.google.rpc.ResourceInfo resource_info = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.rpc.ResourceInfoOrBuilder getResourceInfoOrBuilder() {
      if (resourceInfoBuilder_ != null) {
        return resourceInfoBuilder_.getMessageOrBuilder();
      } else {
        return resourceInfo_ == null
            ? com.google.rpc.ResourceInfo.getDefaultInstance()
            : resourceInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Information about the resource where the error is located.
     * </pre>
     *
     * <code>.google.rpc.ResourceInfo resource_info = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.ResourceInfo,
            com.google.rpc.ResourceInfo.Builder,
            com.google.rpc.ResourceInfoOrBuilder>
        getResourceInfoFieldBuilder() {
      if (resourceInfoBuilder_ == null) {
        resourceInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.ResourceInfo,
                com.google.rpc.ResourceInfo.Builder,
                com.google.rpc.ResourceInfoOrBuilder>(
                getResourceInfo(), getParentForChildren(), isClean());
        resourceInfo_ = null;
      }
      return resourceInfoBuilder_;
    }

    private java.util.List<com.google.cloud.bigquery.migration.v2.ErrorDetail> errorDetails_ =
        java.util.Collections.emptyList();

    private void ensureErrorDetailsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        errorDetails_ =
            new java.util.ArrayList<com.google.cloud.bigquery.migration.v2.ErrorDetail>(
                errorDetails_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2.ErrorDetail,
            com.google.cloud.bigquery.migration.v2.ErrorDetail.Builder,
            com.google.cloud.bigquery.migration.v2.ErrorDetailOrBuilder>
        errorDetailsBuilder_;

    /**
     *
     *
     * <pre>
     * Required. The error details for the resource.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2.ErrorDetail error_details = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.bigquery.migration.v2.ErrorDetail>
        getErrorDetailsList() {
      if (errorDetailsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(errorDetails_);
      } else {
        return errorDetailsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The error details for the resource.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2.ErrorDetail error_details = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getErrorDetailsCount() {
      if (errorDetailsBuilder_ == null) {
        return errorDetails_.size();
      } else {
        return errorDetailsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The error details for the resource.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2.ErrorDetail error_details = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.bigquery.migration.v2.ErrorDetail getErrorDetails(int index) {
      if (errorDetailsBuilder_ == null) {
        return errorDetails_.get(index);
      } else {
        return errorDetailsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The error details for the resource.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2.ErrorDetail error_details = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setErrorDetails(
        int index, com.google.cloud.bigquery.migration.v2.ErrorDetail value) {
      if (errorDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureErrorDetailsIsMutable();
        errorDetails_.set(index, value);
        onChanged();
      } else {
        errorDetailsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The error details for the resource.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2.ErrorDetail error_details = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setErrorDetails(
        int index, com.google.cloud.bigquery.migration.v2.ErrorDetail.Builder builderForValue) {
      if (errorDetailsBuilder_ == null) {
        ensureErrorDetailsIsMutable();
        errorDetails_.set(index, builderForValue.build());
        onChanged();
      } else {
        errorDetailsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The error details for the resource.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2.ErrorDetail error_details = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addErrorDetails(com.google.cloud.bigquery.migration.v2.ErrorDetail value) {
      if (errorDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureErrorDetailsIsMutable();
        errorDetails_.add(value);
        onChanged();
      } else {
        errorDetailsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The error details for the resource.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2.ErrorDetail error_details = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addErrorDetails(
        int index, com.google.cloud.bigquery.migration.v2.ErrorDetail value) {
      if (errorDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureErrorDetailsIsMutable();
        errorDetails_.add(index, value);
        onChanged();
      } else {
        errorDetailsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The error details for the resource.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2.ErrorDetail error_details = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addErrorDetails(
        com.google.cloud.bigquery.migration.v2.ErrorDetail.Builder builderForValue) {
      if (errorDetailsBuilder_ == null) {
        ensureErrorDetailsIsMutable();
        errorDetails_.add(builderForValue.build());
        onChanged();
      } else {
        errorDetailsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The error details for the resource.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2.ErrorDetail error_details = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addErrorDetails(
        int index, com.google.cloud.bigquery.migration.v2.ErrorDetail.Builder builderForValue) {
      if (errorDetailsBuilder_ == null) {
        ensureErrorDetailsIsMutable();
        errorDetails_.add(index, builderForValue.build());
        onChanged();
      } else {
        errorDetailsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The error details for the resource.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2.ErrorDetail error_details = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllErrorDetails(
        java.lang.Iterable<? extends com.google.cloud.bigquery.migration.v2.ErrorDetail> values) {
      if (errorDetailsBuilder_ == null) {
        ensureErrorDetailsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, errorDetails_);
        onChanged();
      } else {
        errorDetailsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The error details for the resource.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2.ErrorDetail error_details = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearErrorDetails() {
      if (errorDetailsBuilder_ == null) {
        errorDetails_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        errorDetailsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The error details for the resource.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2.ErrorDetail error_details = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeErrorDetails(int index) {
      if (errorDetailsBuilder_ == null) {
        ensureErrorDetailsIsMutable();
        errorDetails_.remove(index);
        onChanged();
      } else {
        errorDetailsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The error details for the resource.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2.ErrorDetail error_details = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.bigquery.migration.v2.ErrorDetail.Builder getErrorDetailsBuilder(
        int index) {
      return getErrorDetailsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Required. The error details for the resource.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2.ErrorDetail error_details = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.bigquery.migration.v2.ErrorDetailOrBuilder getErrorDetailsOrBuilder(
        int index) {
      if (errorDetailsBuilder_ == null) {
        return errorDetails_.get(index);
      } else {
        return errorDetailsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The error details for the resource.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2.ErrorDetail error_details = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.bigquery.migration.v2.ErrorDetailOrBuilder>
        getErrorDetailsOrBuilderList() {
      if (errorDetailsBuilder_ != null) {
        return errorDetailsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(errorDetails_);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The error details for the resource.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2.ErrorDetail error_details = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.bigquery.migration.v2.ErrorDetail.Builder addErrorDetailsBuilder() {
      return getErrorDetailsFieldBuilder()
          .addBuilder(com.google.cloud.bigquery.migration.v2.ErrorDetail.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. The error details for the resource.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2.ErrorDetail error_details = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.bigquery.migration.v2.ErrorDetail.Builder addErrorDetailsBuilder(
        int index) {
      return getErrorDetailsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.bigquery.migration.v2.ErrorDetail.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. The error details for the resource.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2.ErrorDetail error_details = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.bigquery.migration.v2.ErrorDetail.Builder>
        getErrorDetailsBuilderList() {
      return getErrorDetailsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2.ErrorDetail,
            com.google.cloud.bigquery.migration.v2.ErrorDetail.Builder,
            com.google.cloud.bigquery.migration.v2.ErrorDetailOrBuilder>
        getErrorDetailsFieldBuilder() {
      if (errorDetailsBuilder_ == null) {
        errorDetailsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.bigquery.migration.v2.ErrorDetail,
                com.google.cloud.bigquery.migration.v2.ErrorDetail.Builder,
                com.google.cloud.bigquery.migration.v2.ErrorDetailOrBuilder>(
                errorDetails_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        errorDetails_ = null;
      }
      return errorDetailsBuilder_;
    }

    private int errorCount_;
    /**
     *
     *
     * <pre>
     * Required. How many errors there are in total for the resource. Truncation
     * can be indicated by having an `error_count` that is higher than the size of
     * `error_details`.
     * </pre>
     *
     * <code>int32 error_count = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The errorCount.
     */
    @java.lang.Override
    public int getErrorCount() {
      return errorCount_;
    }
    /**
     *
     *
     * <pre>
     * Required. How many errors there are in total for the resource. Truncation
     * can be indicated by having an `error_count` that is higher than the size of
     * `error_details`.
     * </pre>
     *
     * <code>int32 error_count = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The errorCount to set.
     * @return This builder for chaining.
     */
    public Builder setErrorCount(int value) {

      errorCount_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. How many errors there are in total for the resource. Truncation
     * can be indicated by having an `error_count` that is higher than the size of
     * `error_details`.
     * </pre>
     *
     * <code>int32 error_count = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearErrorCount() {
      bitField0_ = (bitField0_ & ~0x00000004);
      errorCount_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.migration.v2.ResourceErrorDetail)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.bigquery.migration.v2.ResourceErrorDetail)
  private static final com.google.cloud.bigquery.migration.v2.ResourceErrorDetail DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.bigquery.migration.v2.ResourceErrorDetail();
  }

  public static com.google.cloud.bigquery.migration.v2.ResourceErrorDetail getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ResourceErrorDetail> PARSER =
      new com.google.protobuf.AbstractParser<ResourceErrorDetail>() {
        @java.lang.Override
        public ResourceErrorDetail parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ResourceErrorDetail> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ResourceErrorDetail> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2.ResourceErrorDetail getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
