/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/migration/v2/translation_config.proto

package com.google.cloud.bigquery.migration.v2;

/**
 *
 *
 * <pre>
 * The translation config to capture necessary settings for a translation task
 * and subtask.
 * </pre>
 *
 * Protobuf type {@code google.cloud.bigquery.migration.v2.TranslationConfigDetails}
 */
public final class TranslationConfigDetails extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.bigquery.migration.v2.TranslationConfigDetails)
    TranslationConfigDetailsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TranslationConfigDetails.newBuilder() to construct.
  private TranslationConfigDetails(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TranslationConfigDetails() {
    requestSource_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TranslationConfigDetails();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.bigquery.migration.v2.TranslationConfigProto
        .internal_static_google_cloud_bigquery_migration_v2_TranslationConfigDetails_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.bigquery.migration.v2.TranslationConfigProto
        .internal_static_google_cloud_bigquery_migration_v2_TranslationConfigDetails_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.bigquery.migration.v2.TranslationConfigDetails.class,
            com.google.cloud.bigquery.migration.v2.TranslationConfigDetails.Builder.class);
  }

  private int sourceLocationCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object sourceLocation_;

  public enum SourceLocationCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    GCS_SOURCE_PATH(1),
    SOURCELOCATION_NOT_SET(0);
    private final int value;

    private SourceLocationCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SourceLocationCase valueOf(int value) {
      return forNumber(value);
    }

    public static SourceLocationCase forNumber(int value) {
      switch (value) {
        case 1:
          return GCS_SOURCE_PATH;
        case 0:
          return SOURCELOCATION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SourceLocationCase getSourceLocationCase() {
    return SourceLocationCase.forNumber(sourceLocationCase_);
  }

  private int targetLocationCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object targetLocation_;

  public enum TargetLocationCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    GCS_TARGET_PATH(2),
    TARGETLOCATION_NOT_SET(0);
    private final int value;

    private TargetLocationCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TargetLocationCase valueOf(int value) {
      return forNumber(value);
    }

    public static TargetLocationCase forNumber(int value) {
      switch (value) {
        case 2:
          return GCS_TARGET_PATH;
        case 0:
          return TARGETLOCATION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public TargetLocationCase getTargetLocationCase() {
    return TargetLocationCase.forNumber(targetLocationCase_);
  }

  private int outputNameMappingCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object outputNameMapping_;

  public enum OutputNameMappingCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    NAME_MAPPING_LIST(5),
    OUTPUTNAMEMAPPING_NOT_SET(0);
    private final int value;

    private OutputNameMappingCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static OutputNameMappingCase valueOf(int value) {
      return forNumber(value);
    }

    public static OutputNameMappingCase forNumber(int value) {
      switch (value) {
        case 5:
          return NAME_MAPPING_LIST;
        case 0:
          return OUTPUTNAMEMAPPING_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public OutputNameMappingCase getOutputNameMappingCase() {
    return OutputNameMappingCase.forNumber(outputNameMappingCase_);
  }

  public static final int GCS_SOURCE_PATH_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * The Cloud Storage path for a directory of files to translate in a task.
   * </pre>
   *
   * <code>string gcs_source_path = 1;</code>
   *
   * @return Whether the gcsSourcePath field is set.
   */
  public boolean hasGcsSourcePath() {
    return sourceLocationCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * The Cloud Storage path for a directory of files to translate in a task.
   * </pre>
   *
   * <code>string gcs_source_path = 1;</code>
   *
   * @return The gcsSourcePath.
   */
  public java.lang.String getGcsSourcePath() {
    java.lang.Object ref = "";
    if (sourceLocationCase_ == 1) {
      ref = sourceLocation_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (sourceLocationCase_ == 1) {
        sourceLocation_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The Cloud Storage path for a directory of files to translate in a task.
   * </pre>
   *
   * <code>string gcs_source_path = 1;</code>
   *
   * @return The bytes for gcsSourcePath.
   */
  public com.google.protobuf.ByteString getGcsSourcePathBytes() {
    java.lang.Object ref = "";
    if (sourceLocationCase_ == 1) {
      ref = sourceLocation_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (sourceLocationCase_ == 1) {
        sourceLocation_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GCS_TARGET_PATH_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * The Cloud Storage path to write back the corresponding input files to.
   * </pre>
   *
   * <code>string gcs_target_path = 2;</code>
   *
   * @return Whether the gcsTargetPath field is set.
   */
  public boolean hasGcsTargetPath() {
    return targetLocationCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * The Cloud Storage path to write back the corresponding input files to.
   * </pre>
   *
   * <code>string gcs_target_path = 2;</code>
   *
   * @return The gcsTargetPath.
   */
  public java.lang.String getGcsTargetPath() {
    java.lang.Object ref = "";
    if (targetLocationCase_ == 2) {
      ref = targetLocation_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (targetLocationCase_ == 2) {
        targetLocation_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The Cloud Storage path to write back the corresponding input files to.
   * </pre>
   *
   * <code>string gcs_target_path = 2;</code>
   *
   * @return The bytes for gcsTargetPath.
   */
  public com.google.protobuf.ByteString getGcsTargetPathBytes() {
    java.lang.Object ref = "";
    if (targetLocationCase_ == 2) {
      ref = targetLocation_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (targetLocationCase_ == 2) {
        targetLocation_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAME_MAPPING_LIST_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * The mapping of objects to their desired output names in list form.
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2.ObjectNameMappingList name_mapping_list = 5;</code>
   *
   * @return Whether the nameMappingList field is set.
   */
  @java.lang.Override
  public boolean hasNameMappingList() {
    return outputNameMappingCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * The mapping of objects to their desired output names in list form.
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2.ObjectNameMappingList name_mapping_list = 5;</code>
   *
   * @return The nameMappingList.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2.ObjectNameMappingList getNameMappingList() {
    if (outputNameMappingCase_ == 5) {
      return (com.google.cloud.bigquery.migration.v2.ObjectNameMappingList) outputNameMapping_;
    }
    return com.google.cloud.bigquery.migration.v2.ObjectNameMappingList.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The mapping of objects to their desired output names in list form.
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2.ObjectNameMappingList name_mapping_list = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2.ObjectNameMappingListOrBuilder
      getNameMappingListOrBuilder() {
    if (outputNameMappingCase_ == 5) {
      return (com.google.cloud.bigquery.migration.v2.ObjectNameMappingList) outputNameMapping_;
    }
    return com.google.cloud.bigquery.migration.v2.ObjectNameMappingList.getDefaultInstance();
  }

  public static final int SOURCE_DIALECT_FIELD_NUMBER = 3;
  private com.google.cloud.bigquery.migration.v2.Dialect sourceDialect_;
  /**
   *
   *
   * <pre>
   * The dialect of the input files.
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2.Dialect source_dialect = 3;</code>
   *
   * @return Whether the sourceDialect field is set.
   */
  @java.lang.Override
  public boolean hasSourceDialect() {
    return sourceDialect_ != null;
  }
  /**
   *
   *
   * <pre>
   * The dialect of the input files.
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2.Dialect source_dialect = 3;</code>
   *
   * @return The sourceDialect.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2.Dialect getSourceDialect() {
    return sourceDialect_ == null
        ? com.google.cloud.bigquery.migration.v2.Dialect.getDefaultInstance()
        : sourceDialect_;
  }
  /**
   *
   *
   * <pre>
   * The dialect of the input files.
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2.Dialect source_dialect = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2.DialectOrBuilder getSourceDialectOrBuilder() {
    return sourceDialect_ == null
        ? com.google.cloud.bigquery.migration.v2.Dialect.getDefaultInstance()
        : sourceDialect_;
  }

  public static final int TARGET_DIALECT_FIELD_NUMBER = 4;
  private com.google.cloud.bigquery.migration.v2.Dialect targetDialect_;
  /**
   *
   *
   * <pre>
   * The target dialect for the engine to translate the input to.
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2.Dialect target_dialect = 4;</code>
   *
   * @return Whether the targetDialect field is set.
   */
  @java.lang.Override
  public boolean hasTargetDialect() {
    return targetDialect_ != null;
  }
  /**
   *
   *
   * <pre>
   * The target dialect for the engine to translate the input to.
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2.Dialect target_dialect = 4;</code>
   *
   * @return The targetDialect.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2.Dialect getTargetDialect() {
    return targetDialect_ == null
        ? com.google.cloud.bigquery.migration.v2.Dialect.getDefaultInstance()
        : targetDialect_;
  }
  /**
   *
   *
   * <pre>
   * The target dialect for the engine to translate the input to.
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2.Dialect target_dialect = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2.DialectOrBuilder getTargetDialectOrBuilder() {
    return targetDialect_ == null
        ? com.google.cloud.bigquery.migration.v2.Dialect.getDefaultInstance()
        : targetDialect_;
  }

  public static final int SOURCE_ENV_FIELD_NUMBER = 6;
  private com.google.cloud.bigquery.migration.v2.SourceEnv sourceEnv_;
  /**
   *
   *
   * <pre>
   * The default source environment values for the translation.
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2.SourceEnv source_env = 6;</code>
   *
   * @return Whether the sourceEnv field is set.
   */
  @java.lang.Override
  public boolean hasSourceEnv() {
    return sourceEnv_ != null;
  }
  /**
   *
   *
   * <pre>
   * The default source environment values for the translation.
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2.SourceEnv source_env = 6;</code>
   *
   * @return The sourceEnv.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2.SourceEnv getSourceEnv() {
    return sourceEnv_ == null
        ? com.google.cloud.bigquery.migration.v2.SourceEnv.getDefaultInstance()
        : sourceEnv_;
  }
  /**
   *
   *
   * <pre>
   * The default source environment values for the translation.
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2.SourceEnv source_env = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2.SourceEnvOrBuilder getSourceEnvOrBuilder() {
    return sourceEnv_ == null
        ? com.google.cloud.bigquery.migration.v2.SourceEnv.getDefaultInstance()
        : sourceEnv_;
  }

  public static final int REQUEST_SOURCE_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object requestSource_ = "";
  /**
   *
   *
   * <pre>
   * The indicator to show translation request initiator.
   * </pre>
   *
   * <code>string request_source = 8;</code>
   *
   * @return The requestSource.
   */
  @java.lang.Override
  public java.lang.String getRequestSource() {
    java.lang.Object ref = requestSource_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      requestSource_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The indicator to show translation request initiator.
   * </pre>
   *
   * <code>string request_source = 8;</code>
   *
   * @return The bytes for requestSource.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRequestSourceBytes() {
    java.lang.Object ref = requestSource_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      requestSource_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (sourceLocationCase_ == 1) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, sourceLocation_);
    }
    if (targetLocationCase_ == 2) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, targetLocation_);
    }
    if (sourceDialect_ != null) {
      output.writeMessage(3, getSourceDialect());
    }
    if (targetDialect_ != null) {
      output.writeMessage(4, getTargetDialect());
    }
    if (outputNameMappingCase_ == 5) {
      output.writeMessage(
          5, (com.google.cloud.bigquery.migration.v2.ObjectNameMappingList) outputNameMapping_);
    }
    if (sourceEnv_ != null) {
      output.writeMessage(6, getSourceEnv());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestSource_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, requestSource_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (sourceLocationCase_ == 1) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, sourceLocation_);
    }
    if (targetLocationCase_ == 2) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, targetLocation_);
    }
    if (sourceDialect_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getSourceDialect());
    }
    if (targetDialect_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getTargetDialect());
    }
    if (outputNameMappingCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.cloud.bigquery.migration.v2.ObjectNameMappingList) outputNameMapping_);
    }
    if (sourceEnv_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getSourceEnv());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestSource_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, requestSource_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.bigquery.migration.v2.TranslationConfigDetails)) {
      return super.equals(obj);
    }
    com.google.cloud.bigquery.migration.v2.TranslationConfigDetails other =
        (com.google.cloud.bigquery.migration.v2.TranslationConfigDetails) obj;

    if (hasSourceDialect() != other.hasSourceDialect()) return false;
    if (hasSourceDialect()) {
      if (!getSourceDialect().equals(other.getSourceDialect())) return false;
    }
    if (hasTargetDialect() != other.hasTargetDialect()) return false;
    if (hasTargetDialect()) {
      if (!getTargetDialect().equals(other.getTargetDialect())) return false;
    }
    if (hasSourceEnv() != other.hasSourceEnv()) return false;
    if (hasSourceEnv()) {
      if (!getSourceEnv().equals(other.getSourceEnv())) return false;
    }
    if (!getRequestSource().equals(other.getRequestSource())) return false;
    if (!getSourceLocationCase().equals(other.getSourceLocationCase())) return false;
    switch (sourceLocationCase_) {
      case 1:
        if (!getGcsSourcePath().equals(other.getGcsSourcePath())) return false;
        break;
      case 0:
      default:
    }
    if (!getTargetLocationCase().equals(other.getTargetLocationCase())) return false;
    switch (targetLocationCase_) {
      case 2:
        if (!getGcsTargetPath().equals(other.getGcsTargetPath())) return false;
        break;
      case 0:
      default:
    }
    if (!getOutputNameMappingCase().equals(other.getOutputNameMappingCase())) return false;
    switch (outputNameMappingCase_) {
      case 5:
        if (!getNameMappingList().equals(other.getNameMappingList())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasSourceDialect()) {
      hash = (37 * hash) + SOURCE_DIALECT_FIELD_NUMBER;
      hash = (53 * hash) + getSourceDialect().hashCode();
    }
    if (hasTargetDialect()) {
      hash = (37 * hash) + TARGET_DIALECT_FIELD_NUMBER;
      hash = (53 * hash) + getTargetDialect().hashCode();
    }
    if (hasSourceEnv()) {
      hash = (37 * hash) + SOURCE_ENV_FIELD_NUMBER;
      hash = (53 * hash) + getSourceEnv().hashCode();
    }
    hash = (37 * hash) + REQUEST_SOURCE_FIELD_NUMBER;
    hash = (53 * hash) + getRequestSource().hashCode();
    switch (sourceLocationCase_) {
      case 1:
        hash = (37 * hash) + GCS_SOURCE_PATH_FIELD_NUMBER;
        hash = (53 * hash) + getGcsSourcePath().hashCode();
        break;
      case 0:
      default:
    }
    switch (targetLocationCase_) {
      case 2:
        hash = (37 * hash) + GCS_TARGET_PATH_FIELD_NUMBER;
        hash = (53 * hash) + getGcsTargetPath().hashCode();
        break;
      case 0:
      default:
    }
    switch (outputNameMappingCase_) {
      case 5:
        hash = (37 * hash) + NAME_MAPPING_LIST_FIELD_NUMBER;
        hash = (53 * hash) + getNameMappingList().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.bigquery.migration.v2.TranslationConfigDetails parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.migration.v2.TranslationConfigDetails parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2.TranslationConfigDetails parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.migration.v2.TranslationConfigDetails parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2.TranslationConfigDetails parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.migration.v2.TranslationConfigDetails parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2.TranslationConfigDetails parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.migration.v2.TranslationConfigDetails parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2.TranslationConfigDetails parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.migration.v2.TranslationConfigDetails parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2.TranslationConfigDetails parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.migration.v2.TranslationConfigDetails parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.bigquery.migration.v2.TranslationConfigDetails prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The translation config to capture necessary settings for a translation task
   * and subtask.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.migration.v2.TranslationConfigDetails}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.migration.v2.TranslationConfigDetails)
      com.google.cloud.bigquery.migration.v2.TranslationConfigDetailsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.migration.v2.TranslationConfigProto
          .internal_static_google_cloud_bigquery_migration_v2_TranslationConfigDetails_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.migration.v2.TranslationConfigProto
          .internal_static_google_cloud_bigquery_migration_v2_TranslationConfigDetails_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.migration.v2.TranslationConfigDetails.class,
              com.google.cloud.bigquery.migration.v2.TranslationConfigDetails.Builder.class);
    }

    // Construct using com.google.cloud.bigquery.migration.v2.TranslationConfigDetails.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (nameMappingListBuilder_ != null) {
        nameMappingListBuilder_.clear();
      }
      sourceDialect_ = null;
      if (sourceDialectBuilder_ != null) {
        sourceDialectBuilder_.dispose();
        sourceDialectBuilder_ = null;
      }
      targetDialect_ = null;
      if (targetDialectBuilder_ != null) {
        targetDialectBuilder_.dispose();
        targetDialectBuilder_ = null;
      }
      sourceEnv_ = null;
      if (sourceEnvBuilder_ != null) {
        sourceEnvBuilder_.dispose();
        sourceEnvBuilder_ = null;
      }
      requestSource_ = "";
      sourceLocationCase_ = 0;
      sourceLocation_ = null;
      targetLocationCase_ = 0;
      targetLocation_ = null;
      outputNameMappingCase_ = 0;
      outputNameMapping_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.bigquery.migration.v2.TranslationConfigProto
          .internal_static_google_cloud_bigquery_migration_v2_TranslationConfigDetails_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2.TranslationConfigDetails
        getDefaultInstanceForType() {
      return com.google.cloud.bigquery.migration.v2.TranslationConfigDetails.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2.TranslationConfigDetails build() {
      com.google.cloud.bigquery.migration.v2.TranslationConfigDetails result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2.TranslationConfigDetails buildPartial() {
      com.google.cloud.bigquery.migration.v2.TranslationConfigDetails result =
          new com.google.cloud.bigquery.migration.v2.TranslationConfigDetails(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.bigquery.migration.v2.TranslationConfigDetails result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.sourceDialect_ =
            sourceDialectBuilder_ == null ? sourceDialect_ : sourceDialectBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.targetDialect_ =
            targetDialectBuilder_ == null ? targetDialect_ : targetDialectBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.sourceEnv_ = sourceEnvBuilder_ == null ? sourceEnv_ : sourceEnvBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.requestSource_ = requestSource_;
      }
    }

    private void buildPartialOneofs(
        com.google.cloud.bigquery.migration.v2.TranslationConfigDetails result) {
      result.sourceLocationCase_ = sourceLocationCase_;
      result.sourceLocation_ = this.sourceLocation_;
      result.targetLocationCase_ = targetLocationCase_;
      result.targetLocation_ = this.targetLocation_;
      result.outputNameMappingCase_ = outputNameMappingCase_;
      result.outputNameMapping_ = this.outputNameMapping_;
      if (outputNameMappingCase_ == 5 && nameMappingListBuilder_ != null) {
        result.outputNameMapping_ = nameMappingListBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.bigquery.migration.v2.TranslationConfigDetails) {
        return mergeFrom((com.google.cloud.bigquery.migration.v2.TranslationConfigDetails) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.bigquery.migration.v2.TranslationConfigDetails other) {
      if (other
          == com.google.cloud.bigquery.migration.v2.TranslationConfigDetails.getDefaultInstance())
        return this;
      if (other.hasSourceDialect()) {
        mergeSourceDialect(other.getSourceDialect());
      }
      if (other.hasTargetDialect()) {
        mergeTargetDialect(other.getTargetDialect());
      }
      if (other.hasSourceEnv()) {
        mergeSourceEnv(other.getSourceEnv());
      }
      if (!other.getRequestSource().isEmpty()) {
        requestSource_ = other.requestSource_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      switch (other.getSourceLocationCase()) {
        case GCS_SOURCE_PATH:
          {
            sourceLocationCase_ = 1;
            sourceLocation_ = other.sourceLocation_;
            onChanged();
            break;
          }
        case SOURCELOCATION_NOT_SET:
          {
            break;
          }
      }
      switch (other.getTargetLocationCase()) {
        case GCS_TARGET_PATH:
          {
            targetLocationCase_ = 2;
            targetLocation_ = other.targetLocation_;
            onChanged();
            break;
          }
        case TARGETLOCATION_NOT_SET:
          {
            break;
          }
      }
      switch (other.getOutputNameMappingCase()) {
        case NAME_MAPPING_LIST:
          {
            mergeNameMappingList(other.getNameMappingList());
            break;
          }
        case OUTPUTNAMEMAPPING_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();
                sourceLocationCase_ = 1;
                sourceLocation_ = s;
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                targetLocationCase_ = 2;
                targetLocation_ = s;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getSourceDialectFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getTargetDialectFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getNameMappingListFieldBuilder().getBuilder(), extensionRegistry);
                outputNameMappingCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getSourceEnvFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 66:
              {
                requestSource_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int sourceLocationCase_ = 0;
    private java.lang.Object sourceLocation_;

    public SourceLocationCase getSourceLocationCase() {
      return SourceLocationCase.forNumber(sourceLocationCase_);
    }

    public Builder clearSourceLocation() {
      sourceLocationCase_ = 0;
      sourceLocation_ = null;
      onChanged();
      return this;
    }

    private int targetLocationCase_ = 0;
    private java.lang.Object targetLocation_;

    public TargetLocationCase getTargetLocationCase() {
      return TargetLocationCase.forNumber(targetLocationCase_);
    }

    public Builder clearTargetLocation() {
      targetLocationCase_ = 0;
      targetLocation_ = null;
      onChanged();
      return this;
    }

    private int outputNameMappingCase_ = 0;
    private java.lang.Object outputNameMapping_;

    public OutputNameMappingCase getOutputNameMappingCase() {
      return OutputNameMappingCase.forNumber(outputNameMappingCase_);
    }

    public Builder clearOutputNameMapping() {
      outputNameMappingCase_ = 0;
      outputNameMapping_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    /**
     *
     *
     * <pre>
     * The Cloud Storage path for a directory of files to translate in a task.
     * </pre>
     *
     * <code>string gcs_source_path = 1;</code>
     *
     * @return Whether the gcsSourcePath field is set.
     */
    @java.lang.Override
    public boolean hasGcsSourcePath() {
      return sourceLocationCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage path for a directory of files to translate in a task.
     * </pre>
     *
     * <code>string gcs_source_path = 1;</code>
     *
     * @return The gcsSourcePath.
     */
    @java.lang.Override
    public java.lang.String getGcsSourcePath() {
      java.lang.Object ref = "";
      if (sourceLocationCase_ == 1) {
        ref = sourceLocation_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (sourceLocationCase_ == 1) {
          sourceLocation_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage path for a directory of files to translate in a task.
     * </pre>
     *
     * <code>string gcs_source_path = 1;</code>
     *
     * @return The bytes for gcsSourcePath.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getGcsSourcePathBytes() {
      java.lang.Object ref = "";
      if (sourceLocationCase_ == 1) {
        ref = sourceLocation_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (sourceLocationCase_ == 1) {
          sourceLocation_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage path for a directory of files to translate in a task.
     * </pre>
     *
     * <code>string gcs_source_path = 1;</code>
     *
     * @param value The gcsSourcePath to set.
     * @return This builder for chaining.
     */
    public Builder setGcsSourcePath(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sourceLocationCase_ = 1;
      sourceLocation_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage path for a directory of files to translate in a task.
     * </pre>
     *
     * <code>string gcs_source_path = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGcsSourcePath() {
      if (sourceLocationCase_ == 1) {
        sourceLocationCase_ = 0;
        sourceLocation_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage path for a directory of files to translate in a task.
     * </pre>
     *
     * <code>string gcs_source_path = 1;</code>
     *
     * @param value The bytes for gcsSourcePath to set.
     * @return This builder for chaining.
     */
    public Builder setGcsSourcePathBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sourceLocationCase_ = 1;
      sourceLocation_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The Cloud Storage path to write back the corresponding input files to.
     * </pre>
     *
     * <code>string gcs_target_path = 2;</code>
     *
     * @return Whether the gcsTargetPath field is set.
     */
    @java.lang.Override
    public boolean hasGcsTargetPath() {
      return targetLocationCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage path to write back the corresponding input files to.
     * </pre>
     *
     * <code>string gcs_target_path = 2;</code>
     *
     * @return The gcsTargetPath.
     */
    @java.lang.Override
    public java.lang.String getGcsTargetPath() {
      java.lang.Object ref = "";
      if (targetLocationCase_ == 2) {
        ref = targetLocation_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (targetLocationCase_ == 2) {
          targetLocation_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage path to write back the corresponding input files to.
     * </pre>
     *
     * <code>string gcs_target_path = 2;</code>
     *
     * @return The bytes for gcsTargetPath.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getGcsTargetPathBytes() {
      java.lang.Object ref = "";
      if (targetLocationCase_ == 2) {
        ref = targetLocation_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (targetLocationCase_ == 2) {
          targetLocation_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage path to write back the corresponding input files to.
     * </pre>
     *
     * <code>string gcs_target_path = 2;</code>
     *
     * @param value The gcsTargetPath to set.
     * @return This builder for chaining.
     */
    public Builder setGcsTargetPath(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      targetLocationCase_ = 2;
      targetLocation_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage path to write back the corresponding input files to.
     * </pre>
     *
     * <code>string gcs_target_path = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGcsTargetPath() {
      if (targetLocationCase_ == 2) {
        targetLocationCase_ = 0;
        targetLocation_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage path to write back the corresponding input files to.
     * </pre>
     *
     * <code>string gcs_target_path = 2;</code>
     *
     * @param value The bytes for gcsTargetPath to set.
     * @return This builder for chaining.
     */
    public Builder setGcsTargetPathBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      targetLocationCase_ = 2;
      targetLocation_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2.ObjectNameMappingList,
            com.google.cloud.bigquery.migration.v2.ObjectNameMappingList.Builder,
            com.google.cloud.bigquery.migration.v2.ObjectNameMappingListOrBuilder>
        nameMappingListBuilder_;
    /**
     *
     *
     * <pre>
     * The mapping of objects to their desired output names in list form.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.ObjectNameMappingList name_mapping_list = 5;</code>
     *
     * @return Whether the nameMappingList field is set.
     */
    @java.lang.Override
    public boolean hasNameMappingList() {
      return outputNameMappingCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * The mapping of objects to their desired output names in list form.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.ObjectNameMappingList name_mapping_list = 5;</code>
     *
     * @return The nameMappingList.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2.ObjectNameMappingList getNameMappingList() {
      if (nameMappingListBuilder_ == null) {
        if (outputNameMappingCase_ == 5) {
          return (com.google.cloud.bigquery.migration.v2.ObjectNameMappingList) outputNameMapping_;
        }
        return com.google.cloud.bigquery.migration.v2.ObjectNameMappingList.getDefaultInstance();
      } else {
        if (outputNameMappingCase_ == 5) {
          return nameMappingListBuilder_.getMessage();
        }
        return com.google.cloud.bigquery.migration.v2.ObjectNameMappingList.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The mapping of objects to their desired output names in list form.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.ObjectNameMappingList name_mapping_list = 5;</code>
     */
    public Builder setNameMappingList(
        com.google.cloud.bigquery.migration.v2.ObjectNameMappingList value) {
      if (nameMappingListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        outputNameMapping_ = value;
        onChanged();
      } else {
        nameMappingListBuilder_.setMessage(value);
      }
      outputNameMappingCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The mapping of objects to their desired output names in list form.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.ObjectNameMappingList name_mapping_list = 5;</code>
     */
    public Builder setNameMappingList(
        com.google.cloud.bigquery.migration.v2.ObjectNameMappingList.Builder builderForValue) {
      if (nameMappingListBuilder_ == null) {
        outputNameMapping_ = builderForValue.build();
        onChanged();
      } else {
        nameMappingListBuilder_.setMessage(builderForValue.build());
      }
      outputNameMappingCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The mapping of objects to their desired output names in list form.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.ObjectNameMappingList name_mapping_list = 5;</code>
     */
    public Builder mergeNameMappingList(
        com.google.cloud.bigquery.migration.v2.ObjectNameMappingList value) {
      if (nameMappingListBuilder_ == null) {
        if (outputNameMappingCase_ == 5
            && outputNameMapping_
                != com.google.cloud.bigquery.migration.v2.ObjectNameMappingList
                    .getDefaultInstance()) {
          outputNameMapping_ =
              com.google.cloud.bigquery.migration.v2.ObjectNameMappingList.newBuilder(
                      (com.google.cloud.bigquery.migration.v2.ObjectNameMappingList)
                          outputNameMapping_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          outputNameMapping_ = value;
        }
        onChanged();
      } else {
        if (outputNameMappingCase_ == 5) {
          nameMappingListBuilder_.mergeFrom(value);
        } else {
          nameMappingListBuilder_.setMessage(value);
        }
      }
      outputNameMappingCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The mapping of objects to their desired output names in list form.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.ObjectNameMappingList name_mapping_list = 5;</code>
     */
    public Builder clearNameMappingList() {
      if (nameMappingListBuilder_ == null) {
        if (outputNameMappingCase_ == 5) {
          outputNameMappingCase_ = 0;
          outputNameMapping_ = null;
          onChanged();
        }
      } else {
        if (outputNameMappingCase_ == 5) {
          outputNameMappingCase_ = 0;
          outputNameMapping_ = null;
        }
        nameMappingListBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The mapping of objects to their desired output names in list form.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.ObjectNameMappingList name_mapping_list = 5;</code>
     */
    public com.google.cloud.bigquery.migration.v2.ObjectNameMappingList.Builder
        getNameMappingListBuilder() {
      return getNameMappingListFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The mapping of objects to their desired output names in list form.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.ObjectNameMappingList name_mapping_list = 5;</code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2.ObjectNameMappingListOrBuilder
        getNameMappingListOrBuilder() {
      if ((outputNameMappingCase_ == 5) && (nameMappingListBuilder_ != null)) {
        return nameMappingListBuilder_.getMessageOrBuilder();
      } else {
        if (outputNameMappingCase_ == 5) {
          return (com.google.cloud.bigquery.migration.v2.ObjectNameMappingList) outputNameMapping_;
        }
        return com.google.cloud.bigquery.migration.v2.ObjectNameMappingList.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The mapping of objects to their desired output names in list form.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.ObjectNameMappingList name_mapping_list = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2.ObjectNameMappingList,
            com.google.cloud.bigquery.migration.v2.ObjectNameMappingList.Builder,
            com.google.cloud.bigquery.migration.v2.ObjectNameMappingListOrBuilder>
        getNameMappingListFieldBuilder() {
      if (nameMappingListBuilder_ == null) {
        if (!(outputNameMappingCase_ == 5)) {
          outputNameMapping_ =
              com.google.cloud.bigquery.migration.v2.ObjectNameMappingList.getDefaultInstance();
        }
        nameMappingListBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.migration.v2.ObjectNameMappingList,
                com.google.cloud.bigquery.migration.v2.ObjectNameMappingList.Builder,
                com.google.cloud.bigquery.migration.v2.ObjectNameMappingListOrBuilder>(
                (com.google.cloud.bigquery.migration.v2.ObjectNameMappingList) outputNameMapping_,
                getParentForChildren(),
                isClean());
        outputNameMapping_ = null;
      }
      outputNameMappingCase_ = 5;
      onChanged();
      return nameMappingListBuilder_;
    }

    private com.google.cloud.bigquery.migration.v2.Dialect sourceDialect_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2.Dialect,
            com.google.cloud.bigquery.migration.v2.Dialect.Builder,
            com.google.cloud.bigquery.migration.v2.DialectOrBuilder>
        sourceDialectBuilder_;
    /**
     *
     *
     * <pre>
     * The dialect of the input files.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.Dialect source_dialect = 3;</code>
     *
     * @return Whether the sourceDialect field is set.
     */
    public boolean hasSourceDialect() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * The dialect of the input files.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.Dialect source_dialect = 3;</code>
     *
     * @return The sourceDialect.
     */
    public com.google.cloud.bigquery.migration.v2.Dialect getSourceDialect() {
      if (sourceDialectBuilder_ == null) {
        return sourceDialect_ == null
            ? com.google.cloud.bigquery.migration.v2.Dialect.getDefaultInstance()
            : sourceDialect_;
      } else {
        return sourceDialectBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The dialect of the input files.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.Dialect source_dialect = 3;</code>
     */
    public Builder setSourceDialect(com.google.cloud.bigquery.migration.v2.Dialect value) {
      if (sourceDialectBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sourceDialect_ = value;
      } else {
        sourceDialectBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The dialect of the input files.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.Dialect source_dialect = 3;</code>
     */
    public Builder setSourceDialect(
        com.google.cloud.bigquery.migration.v2.Dialect.Builder builderForValue) {
      if (sourceDialectBuilder_ == null) {
        sourceDialect_ = builderForValue.build();
      } else {
        sourceDialectBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The dialect of the input files.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.Dialect source_dialect = 3;</code>
     */
    public Builder mergeSourceDialect(com.google.cloud.bigquery.migration.v2.Dialect value) {
      if (sourceDialectBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && sourceDialect_ != null
            && sourceDialect_
                != com.google.cloud.bigquery.migration.v2.Dialect.getDefaultInstance()) {
          getSourceDialectBuilder().mergeFrom(value);
        } else {
          sourceDialect_ = value;
        }
      } else {
        sourceDialectBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The dialect of the input files.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.Dialect source_dialect = 3;</code>
     */
    public Builder clearSourceDialect() {
      bitField0_ = (bitField0_ & ~0x00000008);
      sourceDialect_ = null;
      if (sourceDialectBuilder_ != null) {
        sourceDialectBuilder_.dispose();
        sourceDialectBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The dialect of the input files.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.Dialect source_dialect = 3;</code>
     */
    public com.google.cloud.bigquery.migration.v2.Dialect.Builder getSourceDialectBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getSourceDialectFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The dialect of the input files.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.Dialect source_dialect = 3;</code>
     */
    public com.google.cloud.bigquery.migration.v2.DialectOrBuilder getSourceDialectOrBuilder() {
      if (sourceDialectBuilder_ != null) {
        return sourceDialectBuilder_.getMessageOrBuilder();
      } else {
        return sourceDialect_ == null
            ? com.google.cloud.bigquery.migration.v2.Dialect.getDefaultInstance()
            : sourceDialect_;
      }
    }
    /**
     *
     *
     * <pre>
     * The dialect of the input files.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.Dialect source_dialect = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2.Dialect,
            com.google.cloud.bigquery.migration.v2.Dialect.Builder,
            com.google.cloud.bigquery.migration.v2.DialectOrBuilder>
        getSourceDialectFieldBuilder() {
      if (sourceDialectBuilder_ == null) {
        sourceDialectBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.migration.v2.Dialect,
                com.google.cloud.bigquery.migration.v2.Dialect.Builder,
                com.google.cloud.bigquery.migration.v2.DialectOrBuilder>(
                getSourceDialect(), getParentForChildren(), isClean());
        sourceDialect_ = null;
      }
      return sourceDialectBuilder_;
    }

    private com.google.cloud.bigquery.migration.v2.Dialect targetDialect_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2.Dialect,
            com.google.cloud.bigquery.migration.v2.Dialect.Builder,
            com.google.cloud.bigquery.migration.v2.DialectOrBuilder>
        targetDialectBuilder_;
    /**
     *
     *
     * <pre>
     * The target dialect for the engine to translate the input to.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.Dialect target_dialect = 4;</code>
     *
     * @return Whether the targetDialect field is set.
     */
    public boolean hasTargetDialect() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * The target dialect for the engine to translate the input to.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.Dialect target_dialect = 4;</code>
     *
     * @return The targetDialect.
     */
    public com.google.cloud.bigquery.migration.v2.Dialect getTargetDialect() {
      if (targetDialectBuilder_ == null) {
        return targetDialect_ == null
            ? com.google.cloud.bigquery.migration.v2.Dialect.getDefaultInstance()
            : targetDialect_;
      } else {
        return targetDialectBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The target dialect for the engine to translate the input to.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.Dialect target_dialect = 4;</code>
     */
    public Builder setTargetDialect(com.google.cloud.bigquery.migration.v2.Dialect value) {
      if (targetDialectBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        targetDialect_ = value;
      } else {
        targetDialectBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The target dialect for the engine to translate the input to.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.Dialect target_dialect = 4;</code>
     */
    public Builder setTargetDialect(
        com.google.cloud.bigquery.migration.v2.Dialect.Builder builderForValue) {
      if (targetDialectBuilder_ == null) {
        targetDialect_ = builderForValue.build();
      } else {
        targetDialectBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The target dialect for the engine to translate the input to.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.Dialect target_dialect = 4;</code>
     */
    public Builder mergeTargetDialect(com.google.cloud.bigquery.migration.v2.Dialect value) {
      if (targetDialectBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && targetDialect_ != null
            && targetDialect_
                != com.google.cloud.bigquery.migration.v2.Dialect.getDefaultInstance()) {
          getTargetDialectBuilder().mergeFrom(value);
        } else {
          targetDialect_ = value;
        }
      } else {
        targetDialectBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The target dialect for the engine to translate the input to.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.Dialect target_dialect = 4;</code>
     */
    public Builder clearTargetDialect() {
      bitField0_ = (bitField0_ & ~0x00000010);
      targetDialect_ = null;
      if (targetDialectBuilder_ != null) {
        targetDialectBuilder_.dispose();
        targetDialectBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The target dialect for the engine to translate the input to.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.Dialect target_dialect = 4;</code>
     */
    public com.google.cloud.bigquery.migration.v2.Dialect.Builder getTargetDialectBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getTargetDialectFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The target dialect for the engine to translate the input to.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.Dialect target_dialect = 4;</code>
     */
    public com.google.cloud.bigquery.migration.v2.DialectOrBuilder getTargetDialectOrBuilder() {
      if (targetDialectBuilder_ != null) {
        return targetDialectBuilder_.getMessageOrBuilder();
      } else {
        return targetDialect_ == null
            ? com.google.cloud.bigquery.migration.v2.Dialect.getDefaultInstance()
            : targetDialect_;
      }
    }
    /**
     *
     *
     * <pre>
     * The target dialect for the engine to translate the input to.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.Dialect target_dialect = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2.Dialect,
            com.google.cloud.bigquery.migration.v2.Dialect.Builder,
            com.google.cloud.bigquery.migration.v2.DialectOrBuilder>
        getTargetDialectFieldBuilder() {
      if (targetDialectBuilder_ == null) {
        targetDialectBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.migration.v2.Dialect,
                com.google.cloud.bigquery.migration.v2.Dialect.Builder,
                com.google.cloud.bigquery.migration.v2.DialectOrBuilder>(
                getTargetDialect(), getParentForChildren(), isClean());
        targetDialect_ = null;
      }
      return targetDialectBuilder_;
    }

    private com.google.cloud.bigquery.migration.v2.SourceEnv sourceEnv_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2.SourceEnv,
            com.google.cloud.bigquery.migration.v2.SourceEnv.Builder,
            com.google.cloud.bigquery.migration.v2.SourceEnvOrBuilder>
        sourceEnvBuilder_;
    /**
     *
     *
     * <pre>
     * The default source environment values for the translation.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.SourceEnv source_env = 6;</code>
     *
     * @return Whether the sourceEnv field is set.
     */
    public boolean hasSourceEnv() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * The default source environment values for the translation.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.SourceEnv source_env = 6;</code>
     *
     * @return The sourceEnv.
     */
    public com.google.cloud.bigquery.migration.v2.SourceEnv getSourceEnv() {
      if (sourceEnvBuilder_ == null) {
        return sourceEnv_ == null
            ? com.google.cloud.bigquery.migration.v2.SourceEnv.getDefaultInstance()
            : sourceEnv_;
      } else {
        return sourceEnvBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The default source environment values for the translation.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.SourceEnv source_env = 6;</code>
     */
    public Builder setSourceEnv(com.google.cloud.bigquery.migration.v2.SourceEnv value) {
      if (sourceEnvBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sourceEnv_ = value;
      } else {
        sourceEnvBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The default source environment values for the translation.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.SourceEnv source_env = 6;</code>
     */
    public Builder setSourceEnv(
        com.google.cloud.bigquery.migration.v2.SourceEnv.Builder builderForValue) {
      if (sourceEnvBuilder_ == null) {
        sourceEnv_ = builderForValue.build();
      } else {
        sourceEnvBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The default source environment values for the translation.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.SourceEnv source_env = 6;</code>
     */
    public Builder mergeSourceEnv(com.google.cloud.bigquery.migration.v2.SourceEnv value) {
      if (sourceEnvBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && sourceEnv_ != null
            && sourceEnv_
                != com.google.cloud.bigquery.migration.v2.SourceEnv.getDefaultInstance()) {
          getSourceEnvBuilder().mergeFrom(value);
        } else {
          sourceEnv_ = value;
        }
      } else {
        sourceEnvBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The default source environment values for the translation.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.SourceEnv source_env = 6;</code>
     */
    public Builder clearSourceEnv() {
      bitField0_ = (bitField0_ & ~0x00000020);
      sourceEnv_ = null;
      if (sourceEnvBuilder_ != null) {
        sourceEnvBuilder_.dispose();
        sourceEnvBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The default source environment values for the translation.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.SourceEnv source_env = 6;</code>
     */
    public com.google.cloud.bigquery.migration.v2.SourceEnv.Builder getSourceEnvBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getSourceEnvFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The default source environment values for the translation.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.SourceEnv source_env = 6;</code>
     */
    public com.google.cloud.bigquery.migration.v2.SourceEnvOrBuilder getSourceEnvOrBuilder() {
      if (sourceEnvBuilder_ != null) {
        return sourceEnvBuilder_.getMessageOrBuilder();
      } else {
        return sourceEnv_ == null
            ? com.google.cloud.bigquery.migration.v2.SourceEnv.getDefaultInstance()
            : sourceEnv_;
      }
    }
    /**
     *
     *
     * <pre>
     * The default source environment values for the translation.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.SourceEnv source_env = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2.SourceEnv,
            com.google.cloud.bigquery.migration.v2.SourceEnv.Builder,
            com.google.cloud.bigquery.migration.v2.SourceEnvOrBuilder>
        getSourceEnvFieldBuilder() {
      if (sourceEnvBuilder_ == null) {
        sourceEnvBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.migration.v2.SourceEnv,
                com.google.cloud.bigquery.migration.v2.SourceEnv.Builder,
                com.google.cloud.bigquery.migration.v2.SourceEnvOrBuilder>(
                getSourceEnv(), getParentForChildren(), isClean());
        sourceEnv_ = null;
      }
      return sourceEnvBuilder_;
    }

    private java.lang.Object requestSource_ = "";
    /**
     *
     *
     * <pre>
     * The indicator to show translation request initiator.
     * </pre>
     *
     * <code>string request_source = 8;</code>
     *
     * @return The requestSource.
     */
    public java.lang.String getRequestSource() {
      java.lang.Object ref = requestSource_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        requestSource_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The indicator to show translation request initiator.
     * </pre>
     *
     * <code>string request_source = 8;</code>
     *
     * @return The bytes for requestSource.
     */
    public com.google.protobuf.ByteString getRequestSourceBytes() {
      java.lang.Object ref = requestSource_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        requestSource_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The indicator to show translation request initiator.
     * </pre>
     *
     * <code>string request_source = 8;</code>
     *
     * @param value The requestSource to set.
     * @return This builder for chaining.
     */
    public Builder setRequestSource(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      requestSource_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The indicator to show translation request initiator.
     * </pre>
     *
     * <code>string request_source = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequestSource() {
      requestSource_ = getDefaultInstance().getRequestSource();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The indicator to show translation request initiator.
     * </pre>
     *
     * <code>string request_source = 8;</code>
     *
     * @param value The bytes for requestSource to set.
     * @return This builder for chaining.
     */
    public Builder setRequestSourceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      requestSource_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.migration.v2.TranslationConfigDetails)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.bigquery.migration.v2.TranslationConfigDetails)
  private static final com.google.cloud.bigquery.migration.v2.TranslationConfigDetails
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.bigquery.migration.v2.TranslationConfigDetails();
  }

  public static com.google.cloud.bigquery.migration.v2.TranslationConfigDetails
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TranslationConfigDetails> PARSER =
      new com.google.protobuf.AbstractParser<TranslationConfigDetails>() {
        @java.lang.Override
        public TranslationConfigDetails parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TranslationConfigDetails> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TranslationConfigDetails> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2.TranslationConfigDetails
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
