/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/migration/v2alpha/translation_task.proto

package com.google.cloud.bigquery.migration.v2alpha;

/**
 *
 *
 * <pre>
 * BTEQ translation task related settings.
 * </pre>
 *
 * Protobuf type {@code google.cloud.bigquery.migration.v2alpha.BteqOptions}
 */
public final class BteqOptions extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.bigquery.migration.v2alpha.BteqOptions)
    BteqOptionsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BteqOptions.newBuilder() to construct.
  private BteqOptions(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BteqOptions() {
    defaultPathUri_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BteqOptions();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.bigquery.migration.v2alpha.TranslationTaskProto
        .internal_static_google_cloud_bigquery_migration_v2alpha_BteqOptions_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 3:
        return internalGetFileReplacementMap();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.bigquery.migration.v2alpha.TranslationTaskProto
        .internal_static_google_cloud_bigquery_migration_v2alpha_BteqOptions_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.bigquery.migration.v2alpha.BteqOptions.class,
            com.google.cloud.bigquery.migration.v2alpha.BteqOptions.Builder.class);
  }

  public static final int PROJECT_DATASET_FIELD_NUMBER = 1;
  private com.google.cloud.bigquery.migration.v2alpha.DatasetReference projectDataset_;
  /**
   *
   *
   * <pre>
   * Specifies the project and dataset in BigQuery that will be used for
   * external table creation during the translation.
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2alpha.DatasetReference project_dataset = 1;</code>
   *
   * @return Whether the projectDataset field is set.
   */
  @java.lang.Override
  public boolean hasProjectDataset() {
    return projectDataset_ != null;
  }
  /**
   *
   *
   * <pre>
   * Specifies the project and dataset in BigQuery that will be used for
   * external table creation during the translation.
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2alpha.DatasetReference project_dataset = 1;</code>
   *
   * @return The projectDataset.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2alpha.DatasetReference getProjectDataset() {
    return projectDataset_ == null
        ? com.google.cloud.bigquery.migration.v2alpha.DatasetReference.getDefaultInstance()
        : projectDataset_;
  }
  /**
   *
   *
   * <pre>
   * Specifies the project and dataset in BigQuery that will be used for
   * external table creation during the translation.
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2alpha.DatasetReference project_dataset = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2alpha.DatasetReferenceOrBuilder
      getProjectDatasetOrBuilder() {
    return projectDataset_ == null
        ? com.google.cloud.bigquery.migration.v2alpha.DatasetReference.getDefaultInstance()
        : projectDataset_;
  }

  public static final int DEFAULT_PATH_URI_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object defaultPathUri_ = "";
  /**
   *
   *
   * <pre>
   * The Cloud Storage location to be used as the default path for files that
   * are not otherwise specified in the file replacement map.
   * </pre>
   *
   * <code>string default_path_uri = 2;</code>
   *
   * @return The defaultPathUri.
   */
  @java.lang.Override
  public java.lang.String getDefaultPathUri() {
    java.lang.Object ref = defaultPathUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      defaultPathUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The Cloud Storage location to be used as the default path for files that
   * are not otherwise specified in the file replacement map.
   * </pre>
   *
   * <code>string default_path_uri = 2;</code>
   *
   * @return The bytes for defaultPathUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDefaultPathUriBytes() {
    java.lang.Object ref = defaultPathUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      defaultPathUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FILE_REPLACEMENT_MAP_FIELD_NUMBER = 3;

  private static final class FileReplacementMapDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.bigquery.migration.v2alpha.TranslationTaskProto
                .internal_static_google_cloud_bigquery_migration_v2alpha_BteqOptions_FileReplacementMapEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> fileReplacementMap_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetFileReplacementMap() {
    if (fileReplacementMap_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          FileReplacementMapDefaultEntryHolder.defaultEntry);
    }
    return fileReplacementMap_;
  }

  public int getFileReplacementMapCount() {
    return internalGetFileReplacementMap().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Maps the local paths that are used in BTEQ scripts (the keys) to the paths
   * in Cloud Storage that should be used in their stead in the translation (the
   * value).
   * </pre>
   *
   * <code>map&lt;string, string&gt; file_replacement_map = 3;</code>
   */
  @java.lang.Override
  public boolean containsFileReplacementMap(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetFileReplacementMap().getMap().containsKey(key);
  }
  /** Use {@link #getFileReplacementMapMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getFileReplacementMap() {
    return getFileReplacementMapMap();
  }
  /**
   *
   *
   * <pre>
   * Maps the local paths that are used in BTEQ scripts (the keys) to the paths
   * in Cloud Storage that should be used in their stead in the translation (the
   * value).
   * </pre>
   *
   * <code>map&lt;string, string&gt; file_replacement_map = 3;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getFileReplacementMapMap() {
    return internalGetFileReplacementMap().getMap();
  }
  /**
   *
   *
   * <pre>
   * Maps the local paths that are used in BTEQ scripts (the keys) to the paths
   * in Cloud Storage that should be used in their stead in the translation (the
   * value).
   * </pre>
   *
   * <code>map&lt;string, string&gt; file_replacement_map = 3;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getFileReplacementMapOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map =
        internalGetFileReplacementMap().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Maps the local paths that are used in BTEQ scripts (the keys) to the paths
   * in Cloud Storage that should be used in their stead in the translation (the
   * value).
   * </pre>
   *
   * <code>map&lt;string, string&gt; file_replacement_map = 3;</code>
   */
  @java.lang.Override
  public java.lang.String getFileReplacementMapOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map =
        internalGetFileReplacementMap().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (projectDataset_ != null) {
      output.writeMessage(1, getProjectDataset());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(defaultPathUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, defaultPathUri_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output,
        internalGetFileReplacementMap(),
        FileReplacementMapDefaultEntryHolder.defaultEntry,
        3);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (projectDataset_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getProjectDataset());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(defaultPathUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, defaultPathUri_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetFileReplacementMap().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> fileReplacementMap__ =
          FileReplacementMapDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, fileReplacementMap__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.bigquery.migration.v2alpha.BteqOptions)) {
      return super.equals(obj);
    }
    com.google.cloud.bigquery.migration.v2alpha.BteqOptions other =
        (com.google.cloud.bigquery.migration.v2alpha.BteqOptions) obj;

    if (hasProjectDataset() != other.hasProjectDataset()) return false;
    if (hasProjectDataset()) {
      if (!getProjectDataset().equals(other.getProjectDataset())) return false;
    }
    if (!getDefaultPathUri().equals(other.getDefaultPathUri())) return false;
    if (!internalGetFileReplacementMap().equals(other.internalGetFileReplacementMap()))
      return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasProjectDataset()) {
      hash = (37 * hash) + PROJECT_DATASET_FIELD_NUMBER;
      hash = (53 * hash) + getProjectDataset().hashCode();
    }
    hash = (37 * hash) + DEFAULT_PATH_URI_FIELD_NUMBER;
    hash = (53 * hash) + getDefaultPathUri().hashCode();
    if (!internalGetFileReplacementMap().getMap().isEmpty()) {
      hash = (37 * hash) + FILE_REPLACEMENT_MAP_FIELD_NUMBER;
      hash = (53 * hash) + internalGetFileReplacementMap().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.bigquery.migration.v2alpha.BteqOptions parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.BteqOptions parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.BteqOptions parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.BteqOptions parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.BteqOptions parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.BteqOptions parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.BteqOptions parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.BteqOptions parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.BteqOptions parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.BteqOptions parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.BteqOptions parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.BteqOptions parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.bigquery.migration.v2alpha.BteqOptions prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * BTEQ translation task related settings.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.migration.v2alpha.BteqOptions}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.migration.v2alpha.BteqOptions)
      com.google.cloud.bigquery.migration.v2alpha.BteqOptionsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.migration.v2alpha.TranslationTaskProto
          .internal_static_google_cloud_bigquery_migration_v2alpha_BteqOptions_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 3:
          return internalGetFileReplacementMap();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 3:
          return internalGetMutableFileReplacementMap();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.migration.v2alpha.TranslationTaskProto
          .internal_static_google_cloud_bigquery_migration_v2alpha_BteqOptions_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.migration.v2alpha.BteqOptions.class,
              com.google.cloud.bigquery.migration.v2alpha.BteqOptions.Builder.class);
    }

    // Construct using com.google.cloud.bigquery.migration.v2alpha.BteqOptions.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      projectDataset_ = null;
      if (projectDatasetBuilder_ != null) {
        projectDatasetBuilder_.dispose();
        projectDatasetBuilder_ = null;
      }
      defaultPathUri_ = "";
      internalGetMutableFileReplacementMap().clear();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.bigquery.migration.v2alpha.TranslationTaskProto
          .internal_static_google_cloud_bigquery_migration_v2alpha_BteqOptions_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2alpha.BteqOptions getDefaultInstanceForType() {
      return com.google.cloud.bigquery.migration.v2alpha.BteqOptions.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2alpha.BteqOptions build() {
      com.google.cloud.bigquery.migration.v2alpha.BteqOptions result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2alpha.BteqOptions buildPartial() {
      com.google.cloud.bigquery.migration.v2alpha.BteqOptions result =
          new com.google.cloud.bigquery.migration.v2alpha.BteqOptions(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.bigquery.migration.v2alpha.BteqOptions result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.projectDataset_ =
            projectDatasetBuilder_ == null ? projectDataset_ : projectDatasetBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.defaultPathUri_ = defaultPathUri_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.fileReplacementMap_ = internalGetFileReplacementMap();
        result.fileReplacementMap_.makeImmutable();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.bigquery.migration.v2alpha.BteqOptions) {
        return mergeFrom((com.google.cloud.bigquery.migration.v2alpha.BteqOptions) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.bigquery.migration.v2alpha.BteqOptions other) {
      if (other == com.google.cloud.bigquery.migration.v2alpha.BteqOptions.getDefaultInstance())
        return this;
      if (other.hasProjectDataset()) {
        mergeProjectDataset(other.getProjectDataset());
      }
      if (!other.getDefaultPathUri().isEmpty()) {
        defaultPathUri_ = other.defaultPathUri_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      internalGetMutableFileReplacementMap().mergeFrom(other.internalGetFileReplacementMap());
      bitField0_ |= 0x00000004;
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getProjectDatasetFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                defaultPathUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String>
                    fileReplacementMap__ =
                        input.readMessage(
                            FileReplacementMapDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableFileReplacementMap()
                    .getMutableMap()
                    .put(fileReplacementMap__.getKey(), fileReplacementMap__.getValue());
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.bigquery.migration.v2alpha.DatasetReference projectDataset_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2alpha.DatasetReference,
            com.google.cloud.bigquery.migration.v2alpha.DatasetReference.Builder,
            com.google.cloud.bigquery.migration.v2alpha.DatasetReferenceOrBuilder>
        projectDatasetBuilder_;
    /**
     *
     *
     * <pre>
     * Specifies the project and dataset in BigQuery that will be used for
     * external table creation during the translation.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2alpha.DatasetReference project_dataset = 1;</code>
     *
     * @return Whether the projectDataset field is set.
     */
    public boolean hasProjectDataset() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specifies the project and dataset in BigQuery that will be used for
     * external table creation during the translation.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2alpha.DatasetReference project_dataset = 1;</code>
     *
     * @return The projectDataset.
     */
    public com.google.cloud.bigquery.migration.v2alpha.DatasetReference getProjectDataset() {
      if (projectDatasetBuilder_ == null) {
        return projectDataset_ == null
            ? com.google.cloud.bigquery.migration.v2alpha.DatasetReference.getDefaultInstance()
            : projectDataset_;
      } else {
        return projectDatasetBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the project and dataset in BigQuery that will be used for
     * external table creation during the translation.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2alpha.DatasetReference project_dataset = 1;</code>
     */
    public Builder setProjectDataset(
        com.google.cloud.bigquery.migration.v2alpha.DatasetReference value) {
      if (projectDatasetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        projectDataset_ = value;
      } else {
        projectDatasetBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the project and dataset in BigQuery that will be used for
     * external table creation during the translation.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2alpha.DatasetReference project_dataset = 1;</code>
     */
    public Builder setProjectDataset(
        com.google.cloud.bigquery.migration.v2alpha.DatasetReference.Builder builderForValue) {
      if (projectDatasetBuilder_ == null) {
        projectDataset_ = builderForValue.build();
      } else {
        projectDatasetBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the project and dataset in BigQuery that will be used for
     * external table creation during the translation.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2alpha.DatasetReference project_dataset = 1;</code>
     */
    public Builder mergeProjectDataset(
        com.google.cloud.bigquery.migration.v2alpha.DatasetReference value) {
      if (projectDatasetBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && projectDataset_ != null
            && projectDataset_
                != com.google.cloud.bigquery.migration.v2alpha.DatasetReference
                    .getDefaultInstance()) {
          getProjectDatasetBuilder().mergeFrom(value);
        } else {
          projectDataset_ = value;
        }
      } else {
        projectDatasetBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the project and dataset in BigQuery that will be used for
     * external table creation during the translation.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2alpha.DatasetReference project_dataset = 1;</code>
     */
    public Builder clearProjectDataset() {
      bitField0_ = (bitField0_ & ~0x00000001);
      projectDataset_ = null;
      if (projectDatasetBuilder_ != null) {
        projectDatasetBuilder_.dispose();
        projectDatasetBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the project and dataset in BigQuery that will be used for
     * external table creation during the translation.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2alpha.DatasetReference project_dataset = 1;</code>
     */
    public com.google.cloud.bigquery.migration.v2alpha.DatasetReference.Builder
        getProjectDatasetBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getProjectDatasetFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Specifies the project and dataset in BigQuery that will be used for
     * external table creation during the translation.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2alpha.DatasetReference project_dataset = 1;</code>
     */
    public com.google.cloud.bigquery.migration.v2alpha.DatasetReferenceOrBuilder
        getProjectDatasetOrBuilder() {
      if (projectDatasetBuilder_ != null) {
        return projectDatasetBuilder_.getMessageOrBuilder();
      } else {
        return projectDataset_ == null
            ? com.google.cloud.bigquery.migration.v2alpha.DatasetReference.getDefaultInstance()
            : projectDataset_;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the project and dataset in BigQuery that will be used for
     * external table creation during the translation.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2alpha.DatasetReference project_dataset = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2alpha.DatasetReference,
            com.google.cloud.bigquery.migration.v2alpha.DatasetReference.Builder,
            com.google.cloud.bigquery.migration.v2alpha.DatasetReferenceOrBuilder>
        getProjectDatasetFieldBuilder() {
      if (projectDatasetBuilder_ == null) {
        projectDatasetBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.migration.v2alpha.DatasetReference,
                com.google.cloud.bigquery.migration.v2alpha.DatasetReference.Builder,
                com.google.cloud.bigquery.migration.v2alpha.DatasetReferenceOrBuilder>(
                getProjectDataset(), getParentForChildren(), isClean());
        projectDataset_ = null;
      }
      return projectDatasetBuilder_;
    }

    private java.lang.Object defaultPathUri_ = "";
    /**
     *
     *
     * <pre>
     * The Cloud Storage location to be used as the default path for files that
     * are not otherwise specified in the file replacement map.
     * </pre>
     *
     * <code>string default_path_uri = 2;</code>
     *
     * @return The defaultPathUri.
     */
    public java.lang.String getDefaultPathUri() {
      java.lang.Object ref = defaultPathUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        defaultPathUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage location to be used as the default path for files that
     * are not otherwise specified in the file replacement map.
     * </pre>
     *
     * <code>string default_path_uri = 2;</code>
     *
     * @return The bytes for defaultPathUri.
     */
    public com.google.protobuf.ByteString getDefaultPathUriBytes() {
      java.lang.Object ref = defaultPathUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        defaultPathUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage location to be used as the default path for files that
     * are not otherwise specified in the file replacement map.
     * </pre>
     *
     * <code>string default_path_uri = 2;</code>
     *
     * @param value The defaultPathUri to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultPathUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      defaultPathUri_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage location to be used as the default path for files that
     * are not otherwise specified in the file replacement map.
     * </pre>
     *
     * <code>string default_path_uri = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDefaultPathUri() {
      defaultPathUri_ = getDefaultInstance().getDefaultPathUri();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage location to be used as the default path for files that
     * are not otherwise specified in the file replacement map.
     * </pre>
     *
     * <code>string default_path_uri = 2;</code>
     *
     * @param value The bytes for defaultPathUri to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultPathUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      defaultPathUri_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> fileReplacementMap_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetFileReplacementMap() {
      if (fileReplacementMap_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            FileReplacementMapDefaultEntryHolder.defaultEntry);
      }
      return fileReplacementMap_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableFileReplacementMap() {
      if (fileReplacementMap_ == null) {
        fileReplacementMap_ =
            com.google.protobuf.MapField.newMapField(
                FileReplacementMapDefaultEntryHolder.defaultEntry);
      }
      if (!fileReplacementMap_.isMutable()) {
        fileReplacementMap_ = fileReplacementMap_.copy();
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return fileReplacementMap_;
    }

    public int getFileReplacementMapCount() {
      return internalGetFileReplacementMap().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Maps the local paths that are used in BTEQ scripts (the keys) to the paths
     * in Cloud Storage that should be used in their stead in the translation (the
     * value).
     * </pre>
     *
     * <code>map&lt;string, string&gt; file_replacement_map = 3;</code>
     */
    @java.lang.Override
    public boolean containsFileReplacementMap(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetFileReplacementMap().getMap().containsKey(key);
    }
    /** Use {@link #getFileReplacementMapMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getFileReplacementMap() {
      return getFileReplacementMapMap();
    }
    /**
     *
     *
     * <pre>
     * Maps the local paths that are used in BTEQ scripts (the keys) to the paths
     * in Cloud Storage that should be used in their stead in the translation (the
     * value).
     * </pre>
     *
     * <code>map&lt;string, string&gt; file_replacement_map = 3;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getFileReplacementMapMap() {
      return internalGetFileReplacementMap().getMap();
    }
    /**
     *
     *
     * <pre>
     * Maps the local paths that are used in BTEQ scripts (the keys) to the paths
     * in Cloud Storage that should be used in their stead in the translation (the
     * value).
     * </pre>
     *
     * <code>map&lt;string, string&gt; file_replacement_map = 3;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getFileReplacementMapOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetFileReplacementMap().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Maps the local paths that are used in BTEQ scripts (the keys) to the paths
     * in Cloud Storage that should be used in their stead in the translation (the
     * value).
     * </pre>
     *
     * <code>map&lt;string, string&gt; file_replacement_map = 3;</code>
     */
    @java.lang.Override
    public java.lang.String getFileReplacementMapOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetFileReplacementMap().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearFileReplacementMap() {
      bitField0_ = (bitField0_ & ~0x00000004);
      internalGetMutableFileReplacementMap().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Maps the local paths that are used in BTEQ scripts (the keys) to the paths
     * in Cloud Storage that should be used in their stead in the translation (the
     * value).
     * </pre>
     *
     * <code>map&lt;string, string&gt; file_replacement_map = 3;</code>
     */
    public Builder removeFileReplacementMap(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableFileReplacementMap().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableFileReplacementMap() {
      bitField0_ |= 0x00000004;
      return internalGetMutableFileReplacementMap().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Maps the local paths that are used in BTEQ scripts (the keys) to the paths
     * in Cloud Storage that should be used in their stead in the translation (the
     * value).
     * </pre>
     *
     * <code>map&lt;string, string&gt; file_replacement_map = 3;</code>
     */
    public Builder putFileReplacementMap(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableFileReplacementMap().getMutableMap().put(key, value);
      bitField0_ |= 0x00000004;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Maps the local paths that are used in BTEQ scripts (the keys) to the paths
     * in Cloud Storage that should be used in their stead in the translation (the
     * value).
     * </pre>
     *
     * <code>map&lt;string, string&gt; file_replacement_map = 3;</code>
     */
    public Builder putAllFileReplacementMap(
        java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableFileReplacementMap().getMutableMap().putAll(values);
      bitField0_ |= 0x00000004;
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.migration.v2alpha.BteqOptions)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.bigquery.migration.v2alpha.BteqOptions)
  private static final com.google.cloud.bigquery.migration.v2alpha.BteqOptions DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.bigquery.migration.v2alpha.BteqOptions();
  }

  public static com.google.cloud.bigquery.migration.v2alpha.BteqOptions getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BteqOptions> PARSER =
      new com.google.protobuf.AbstractParser<BteqOptions>() {
        @java.lang.Override
        public BteqOptions parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BteqOptions> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BteqOptions> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2alpha.BteqOptions getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
