/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/migration/v2alpha/migration_entities.proto

package com.google.cloud.bigquery.migration.v2alpha;

/**
 *
 *
 * <pre>
 * A single task for a migration which has details about the configuration of
 * the task.
 * </pre>
 *
 * Protobuf type {@code google.cloud.bigquery.migration.v2alpha.MigrationTask}
 */
public final class MigrationTask extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.bigquery.migration.v2alpha.MigrationTask)
    MigrationTaskOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use MigrationTask.newBuilder() to construct.
  private MigrationTask(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private MigrationTask() {
    id_ = "";
    type_ = "";
    state_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new MigrationTask();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.bigquery.migration.v2alpha.MigrationEntitiesProto
        .internal_static_google_cloud_bigquery_migration_v2alpha_MigrationTask_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.bigquery.migration.v2alpha.MigrationEntitiesProto
        .internal_static_google_cloud_bigquery_migration_v2alpha_MigrationTask_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.bigquery.migration.v2alpha.MigrationTask.class,
            com.google.cloud.bigquery.migration.v2alpha.MigrationTask.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Possible states of a migration task.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.bigquery.migration.v2alpha.MigrationTask.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The state is unspecified.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The task is waiting for orchestration.
     * </pre>
     *
     * <code>PENDING = 1;</code>
     */
    PENDING(1),
    /**
     *
     *
     * <pre>
     * The task is assigned to an orchestrator.
     * </pre>
     *
     * <code>ORCHESTRATING = 2;</code>
     */
    ORCHESTRATING(2),
    /**
     *
     *
     * <pre>
     * The task is running, i.e. its subtasks are ready for execution.
     * </pre>
     *
     * <code>RUNNING = 3;</code>
     */
    RUNNING(3),
    /**
     *
     *
     * <pre>
     * Tha task is paused. Assigned subtasks can continue, but no new subtasks
     * will be scheduled.
     * </pre>
     *
     * <code>PAUSED = 4;</code>
     */
    PAUSED(4),
    /**
     *
     *
     * <pre>
     * The task finished successfully.
     * </pre>
     *
     * <code>SUCCEEDED = 5;</code>
     */
    SUCCEEDED(5),
    /**
     *
     *
     * <pre>
     * The task finished unsuccessfully.
     * </pre>
     *
     * <code>FAILED = 6;</code>
     */
    FAILED(6),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The state is unspecified.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The task is waiting for orchestration.
     * </pre>
     *
     * <code>PENDING = 1;</code>
     */
    public static final int PENDING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The task is assigned to an orchestrator.
     * </pre>
     *
     * <code>ORCHESTRATING = 2;</code>
     */
    public static final int ORCHESTRATING_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The task is running, i.e. its subtasks are ready for execution.
     * </pre>
     *
     * <code>RUNNING = 3;</code>
     */
    public static final int RUNNING_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Tha task is paused. Assigned subtasks can continue, but no new subtasks
     * will be scheduled.
     * </pre>
     *
     * <code>PAUSED = 4;</code>
     */
    public static final int PAUSED_VALUE = 4;
    /**
     *
     *
     * <pre>
     * The task finished successfully.
     * </pre>
     *
     * <code>SUCCEEDED = 5;</code>
     */
    public static final int SUCCEEDED_VALUE = 5;
    /**
     *
     *
     * <pre>
     * The task finished unsuccessfully.
     * </pre>
     *
     * <code>FAILED = 6;</code>
     */
    public static final int FAILED_VALUE = 6;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return PENDING;
        case 2:
          return ORCHESTRATING;
        case 3:
          return RUNNING;
        case 4:
          return PAUSED;
        case 5:
          return SUCCEEDED;
        case 6:
          return FAILED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.bigquery.migration.v2alpha.MigrationTask.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.bigquery.migration.v2alpha.MigrationTask.State)
  }

  private int taskDetailsCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object taskDetails_;

  public enum TaskDetailsCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    ASSESSMENT_TASK_DETAILS(12),
    TRANSLATION_TASK_DETAILS(13),
    TASKDETAILS_NOT_SET(0);
    private final int value;

    private TaskDetailsCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TaskDetailsCase valueOf(int value) {
      return forNumber(value);
    }

    public static TaskDetailsCase forNumber(int value) {
      switch (value) {
        case 12:
          return ASSESSMENT_TASK_DETAILS;
        case 13:
          return TRANSLATION_TASK_DETAILS;
        case 0:
          return TASKDETAILS_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public TaskDetailsCase getTaskDetailsCase() {
    return TaskDetailsCase.forNumber(taskDetailsCase_);
  }

  public static final int ASSESSMENT_TASK_DETAILS_FIELD_NUMBER = 12;
  /**
   *
   *
   * <pre>
   * Task configuration for Assessment.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.migration.v2alpha.AssessmentTaskDetails assessment_task_details = 12;
   * </code>
   *
   * @return Whether the assessmentTaskDetails field is set.
   */
  @java.lang.Override
  public boolean hasAssessmentTaskDetails() {
    return taskDetailsCase_ == 12;
  }
  /**
   *
   *
   * <pre>
   * Task configuration for Assessment.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.migration.v2alpha.AssessmentTaskDetails assessment_task_details = 12;
   * </code>
   *
   * @return The assessmentTaskDetails.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2alpha.AssessmentTaskDetails
      getAssessmentTaskDetails() {
    if (taskDetailsCase_ == 12) {
      return (com.google.cloud.bigquery.migration.v2alpha.AssessmentTaskDetails) taskDetails_;
    }
    return com.google.cloud.bigquery.migration.v2alpha.AssessmentTaskDetails.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Task configuration for Assessment.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.migration.v2alpha.AssessmentTaskDetails assessment_task_details = 12;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2alpha.AssessmentTaskDetailsOrBuilder
      getAssessmentTaskDetailsOrBuilder() {
    if (taskDetailsCase_ == 12) {
      return (com.google.cloud.bigquery.migration.v2alpha.AssessmentTaskDetails) taskDetails_;
    }
    return com.google.cloud.bigquery.migration.v2alpha.AssessmentTaskDetails.getDefaultInstance();
  }

  public static final int TRANSLATION_TASK_DETAILS_FIELD_NUMBER = 13;
  /**
   *
   *
   * <pre>
   * Task configuration for Batch/Offline SQL Translation.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails translation_task_details = 13;
   * </code>
   *
   * @return Whether the translationTaskDetails field is set.
   */
  @java.lang.Override
  public boolean hasTranslationTaskDetails() {
    return taskDetailsCase_ == 13;
  }
  /**
   *
   *
   * <pre>
   * Task configuration for Batch/Offline SQL Translation.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails translation_task_details = 13;
   * </code>
   *
   * @return The translationTaskDetails.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails
      getTranslationTaskDetails() {
    if (taskDetailsCase_ == 13) {
      return (com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails) taskDetails_;
    }
    return com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Task configuration for Batch/Offline SQL Translation.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails translation_task_details = 13;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetailsOrBuilder
      getTranslationTaskDetailsOrBuilder() {
    if (taskDetailsCase_ == 13) {
      return (com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails) taskDetails_;
    }
    return com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.getDefaultInstance();
  }

  public static final int ID_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object id_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Immutable. The unique identifier for the migration task. The ID is server-generated.
   * </pre>
   *
   * <code>
   * string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The id.
   */
  @java.lang.Override
  public java.lang.String getId() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      id_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Immutable. The unique identifier for the migration task. The ID is server-generated.
   * </pre>
   *
   * <code>
   * string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The bytes for id.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIdBytes() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      id_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TYPE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object type_ = "";
  /**
   *
   *
   * <pre>
   * The type of the task. This must be a supported task type.
   * </pre>
   *
   * <code>string type = 2;</code>
   *
   * @return The type.
   */
  @java.lang.Override
  public java.lang.String getType() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      type_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The type of the task. This must be a supported task type.
   * </pre>
   *
   * <code>string type = 2;</code>
   *
   * @return The bytes for type.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTypeBytes() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      type_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DETAILS_FIELD_NUMBER = 3;
  private com.google.protobuf.Any details_;
  /**
   *
   *
   * <pre>
   * DEPRECATED! Use one of the task_details below.
   * The details of the task. The type URL must be one of the supported task
   * details messages and correspond to the Task's type.
   * </pre>
   *
   * <code>.google.protobuf.Any details = 3;</code>
   *
   * @return Whether the details field is set.
   */
  @java.lang.Override
  public boolean hasDetails() {
    return details_ != null;
  }
  /**
   *
   *
   * <pre>
   * DEPRECATED! Use one of the task_details below.
   * The details of the task. The type URL must be one of the supported task
   * details messages and correspond to the Task's type.
   * </pre>
   *
   * <code>.google.protobuf.Any details = 3;</code>
   *
   * @return The details.
   */
  @java.lang.Override
  public com.google.protobuf.Any getDetails() {
    return details_ == null ? com.google.protobuf.Any.getDefaultInstance() : details_;
  }
  /**
   *
   *
   * <pre>
   * DEPRECATED! Use one of the task_details below.
   * The details of the task. The type URL must be one of the supported task
   * details messages and correspond to the Task's type.
   * </pre>
   *
   * <code>.google.protobuf.Any details = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.AnyOrBuilder getDetailsOrBuilder() {
    return details_ == null ? com.google.protobuf.Any.getDefaultInstance() : details_;
  }

  public static final int STATE_FIELD_NUMBER = 4;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The current state of the task.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.migration.v2alpha.MigrationTask.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The current state of the task.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.migration.v2alpha.MigrationTask.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2alpha.MigrationTask.State getState() {
    com.google.cloud.bigquery.migration.v2alpha.MigrationTask.State result =
        com.google.cloud.bigquery.migration.v2alpha.MigrationTask.State.forNumber(state_);
    return result == null
        ? com.google.cloud.bigquery.migration.v2alpha.MigrationTask.State.UNRECOGNIZED
        : result;
  }

  public static final int PROCESSING_ERROR_FIELD_NUMBER = 5;
  private com.google.rpc.ErrorInfo processingError_;
  /**
   *
   *
   * <pre>
   * Output only. An explanation that may be populated when the task is in FAILED state.
   * </pre>
   *
   * <code>.google.rpc.ErrorInfo processing_error = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the processingError field is set.
   */
  @java.lang.Override
  public boolean hasProcessingError() {
    return processingError_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. An explanation that may be populated when the task is in FAILED state.
   * </pre>
   *
   * <code>.google.rpc.ErrorInfo processing_error = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The processingError.
   */
  @java.lang.Override
  public com.google.rpc.ErrorInfo getProcessingError() {
    return processingError_ == null
        ? com.google.rpc.ErrorInfo.getDefaultInstance()
        : processingError_;
  }
  /**
   *
   *
   * <pre>
   * Output only. An explanation that may be populated when the task is in FAILED state.
   * </pre>
   *
   * <code>.google.rpc.ErrorInfo processing_error = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.rpc.ErrorInfoOrBuilder getProcessingErrorOrBuilder() {
    return processingError_ == null
        ? com.google.rpc.ErrorInfo.getDefaultInstance()
        : processingError_;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Time when the task was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6;</code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Time when the task was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6;</code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Time when the task was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int LAST_UPDATE_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp lastUpdateTime_;
  /**
   *
   *
   * <pre>
   * Time when the task was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp last_update_time = 7;</code>
   *
   * @return Whether the lastUpdateTime field is set.
   */
  @java.lang.Override
  public boolean hasLastUpdateTime() {
    return lastUpdateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Time when the task was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp last_update_time = 7;</code>
   *
   * @return The lastUpdateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getLastUpdateTime() {
    return lastUpdateTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : lastUpdateTime_;
  }
  /**
   *
   *
   * <pre>
   * Time when the task was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp last_update_time = 7;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getLastUpdateTimeOrBuilder() {
    return lastUpdateTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : lastUpdateTime_;
  }

  public static final int ORCHESTRATION_RESULT_FIELD_NUMBER = 10;
  private com.google.cloud.bigquery.migration.v2alpha.MigrationTaskOrchestrationResult
      orchestrationResult_;
  /**
   *
   *
   * <pre>
   * Output only. Additional information about the orchestration.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.migration.v2alpha.MigrationTaskOrchestrationResult orchestration_result = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the orchestrationResult field is set.
   */
  @java.lang.Override
  public boolean hasOrchestrationResult() {
    return orchestrationResult_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Additional information about the orchestration.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.migration.v2alpha.MigrationTaskOrchestrationResult orchestration_result = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The orchestrationResult.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2alpha.MigrationTaskOrchestrationResult
      getOrchestrationResult() {
    return orchestrationResult_ == null
        ? com.google.cloud.bigquery.migration.v2alpha.MigrationTaskOrchestrationResult
            .getDefaultInstance()
        : orchestrationResult_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Additional information about the orchestration.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.migration.v2alpha.MigrationTaskOrchestrationResult orchestration_result = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2alpha.MigrationTaskOrchestrationResultOrBuilder
      getOrchestrationResultOrBuilder() {
    return orchestrationResult_ == null
        ? com.google.cloud.bigquery.migration.v2alpha.MigrationTaskOrchestrationResult
            .getDefaultInstance()
        : orchestrationResult_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(type_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, type_);
    }
    if (details_ != null) {
      output.writeMessage(3, getDetails());
    }
    if (state_
        != com.google.cloud.bigquery.migration.v2alpha.MigrationTask.State.STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(4, state_);
    }
    if (processingError_ != null) {
      output.writeMessage(5, getProcessingError());
    }
    if (createTime_ != null) {
      output.writeMessage(6, getCreateTime());
    }
    if (lastUpdateTime_ != null) {
      output.writeMessage(7, getLastUpdateTime());
    }
    if (orchestrationResult_ != null) {
      output.writeMessage(10, getOrchestrationResult());
    }
    if (taskDetailsCase_ == 12) {
      output.writeMessage(
          12, (com.google.cloud.bigquery.migration.v2alpha.AssessmentTaskDetails) taskDetails_);
    }
    if (taskDetailsCase_ == 13) {
      output.writeMessage(
          13, (com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails) taskDetails_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(type_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, type_);
    }
    if (details_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getDetails());
    }
    if (state_
        != com.google.cloud.bigquery.migration.v2alpha.MigrationTask.State.STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, state_);
    }
    if (processingError_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getProcessingError());
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getCreateTime());
    }
    if (lastUpdateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getLastUpdateTime());
    }
    if (orchestrationResult_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(10, getOrchestrationResult());
    }
    if (taskDetailsCase_ == 12) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              12, (com.google.cloud.bigquery.migration.v2alpha.AssessmentTaskDetails) taskDetails_);
    }
    if (taskDetailsCase_ == 13) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              13,
              (com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails) taskDetails_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.bigquery.migration.v2alpha.MigrationTask)) {
      return super.equals(obj);
    }
    com.google.cloud.bigquery.migration.v2alpha.MigrationTask other =
        (com.google.cloud.bigquery.migration.v2alpha.MigrationTask) obj;

    if (!getId().equals(other.getId())) return false;
    if (!getType().equals(other.getType())) return false;
    if (hasDetails() != other.hasDetails()) return false;
    if (hasDetails()) {
      if (!getDetails().equals(other.getDetails())) return false;
    }
    if (state_ != other.state_) return false;
    if (hasProcessingError() != other.hasProcessingError()) return false;
    if (hasProcessingError()) {
      if (!getProcessingError().equals(other.getProcessingError())) return false;
    }
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasLastUpdateTime() != other.hasLastUpdateTime()) return false;
    if (hasLastUpdateTime()) {
      if (!getLastUpdateTime().equals(other.getLastUpdateTime())) return false;
    }
    if (hasOrchestrationResult() != other.hasOrchestrationResult()) return false;
    if (hasOrchestrationResult()) {
      if (!getOrchestrationResult().equals(other.getOrchestrationResult())) return false;
    }
    if (!getTaskDetailsCase().equals(other.getTaskDetailsCase())) return false;
    switch (taskDetailsCase_) {
      case 12:
        if (!getAssessmentTaskDetails().equals(other.getAssessmentTaskDetails())) return false;
        break;
      case 13:
        if (!getTranslationTaskDetails().equals(other.getTranslationTaskDetails())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ID_FIELD_NUMBER;
    hash = (53 * hash) + getId().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getType().hashCode();
    if (hasDetails()) {
      hash = (37 * hash) + DETAILS_FIELD_NUMBER;
      hash = (53 * hash) + getDetails().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    if (hasProcessingError()) {
      hash = (37 * hash) + PROCESSING_ERROR_FIELD_NUMBER;
      hash = (53 * hash) + getProcessingError().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasLastUpdateTime()) {
      hash = (37 * hash) + LAST_UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getLastUpdateTime().hashCode();
    }
    if (hasOrchestrationResult()) {
      hash = (37 * hash) + ORCHESTRATION_RESULT_FIELD_NUMBER;
      hash = (53 * hash) + getOrchestrationResult().hashCode();
    }
    switch (taskDetailsCase_) {
      case 12:
        hash = (37 * hash) + ASSESSMENT_TASK_DETAILS_FIELD_NUMBER;
        hash = (53 * hash) + getAssessmentTaskDetails().hashCode();
        break;
      case 13:
        hash = (37 * hash) + TRANSLATION_TASK_DETAILS_FIELD_NUMBER;
        hash = (53 * hash) + getTranslationTaskDetails().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.bigquery.migration.v2alpha.MigrationTask parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.MigrationTask parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.MigrationTask parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.MigrationTask parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.MigrationTask parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.MigrationTask parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.MigrationTask parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.MigrationTask parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.MigrationTask parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.MigrationTask parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.MigrationTask parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.MigrationTask parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.bigquery.migration.v2alpha.MigrationTask prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A single task for a migration which has details about the configuration of
   * the task.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.migration.v2alpha.MigrationTask}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.migration.v2alpha.MigrationTask)
      com.google.cloud.bigquery.migration.v2alpha.MigrationTaskOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.migration.v2alpha.MigrationEntitiesProto
          .internal_static_google_cloud_bigquery_migration_v2alpha_MigrationTask_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.migration.v2alpha.MigrationEntitiesProto
          .internal_static_google_cloud_bigquery_migration_v2alpha_MigrationTask_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.migration.v2alpha.MigrationTask.class,
              com.google.cloud.bigquery.migration.v2alpha.MigrationTask.Builder.class);
    }

    // Construct using com.google.cloud.bigquery.migration.v2alpha.MigrationTask.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (assessmentTaskDetailsBuilder_ != null) {
        assessmentTaskDetailsBuilder_.clear();
      }
      if (translationTaskDetailsBuilder_ != null) {
        translationTaskDetailsBuilder_.clear();
      }
      id_ = "";
      type_ = "";
      details_ = null;
      if (detailsBuilder_ != null) {
        detailsBuilder_.dispose();
        detailsBuilder_ = null;
      }
      state_ = 0;
      processingError_ = null;
      if (processingErrorBuilder_ != null) {
        processingErrorBuilder_.dispose();
        processingErrorBuilder_ = null;
      }
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      lastUpdateTime_ = null;
      if (lastUpdateTimeBuilder_ != null) {
        lastUpdateTimeBuilder_.dispose();
        lastUpdateTimeBuilder_ = null;
      }
      orchestrationResult_ = null;
      if (orchestrationResultBuilder_ != null) {
        orchestrationResultBuilder_.dispose();
        orchestrationResultBuilder_ = null;
      }
      taskDetailsCase_ = 0;
      taskDetails_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.bigquery.migration.v2alpha.MigrationEntitiesProto
          .internal_static_google_cloud_bigquery_migration_v2alpha_MigrationTask_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2alpha.MigrationTask getDefaultInstanceForType() {
      return com.google.cloud.bigquery.migration.v2alpha.MigrationTask.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2alpha.MigrationTask build() {
      com.google.cloud.bigquery.migration.v2alpha.MigrationTask result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2alpha.MigrationTask buildPartial() {
      com.google.cloud.bigquery.migration.v2alpha.MigrationTask result =
          new com.google.cloud.bigquery.migration.v2alpha.MigrationTask(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.bigquery.migration.v2alpha.MigrationTask result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.id_ = id_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.type_ = type_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.details_ = detailsBuilder_ == null ? details_ : detailsBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.processingError_ =
            processingErrorBuilder_ == null ? processingError_ : processingErrorBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.lastUpdateTime_ =
            lastUpdateTimeBuilder_ == null ? lastUpdateTime_ : lastUpdateTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.orchestrationResult_ =
            orchestrationResultBuilder_ == null
                ? orchestrationResult_
                : orchestrationResultBuilder_.build();
      }
    }

    private void buildPartialOneofs(
        com.google.cloud.bigquery.migration.v2alpha.MigrationTask result) {
      result.taskDetailsCase_ = taskDetailsCase_;
      result.taskDetails_ = this.taskDetails_;
      if (taskDetailsCase_ == 12 && assessmentTaskDetailsBuilder_ != null) {
        result.taskDetails_ = assessmentTaskDetailsBuilder_.build();
      }
      if (taskDetailsCase_ == 13 && translationTaskDetailsBuilder_ != null) {
        result.taskDetails_ = translationTaskDetailsBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.bigquery.migration.v2alpha.MigrationTask) {
        return mergeFrom((com.google.cloud.bigquery.migration.v2alpha.MigrationTask) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.bigquery.migration.v2alpha.MigrationTask other) {
      if (other == com.google.cloud.bigquery.migration.v2alpha.MigrationTask.getDefaultInstance())
        return this;
      if (!other.getId().isEmpty()) {
        id_ = other.id_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getType().isEmpty()) {
        type_ = other.type_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasDetails()) {
        mergeDetails(other.getDetails());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.hasProcessingError()) {
        mergeProcessingError(other.getProcessingError());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasLastUpdateTime()) {
        mergeLastUpdateTime(other.getLastUpdateTime());
      }
      if (other.hasOrchestrationResult()) {
        mergeOrchestrationResult(other.getOrchestrationResult());
      }
      switch (other.getTaskDetailsCase()) {
        case ASSESSMENT_TASK_DETAILS:
          {
            mergeAssessmentTaskDetails(other.getAssessmentTaskDetails());
            break;
          }
        case TRANSLATION_TASK_DETAILS:
          {
            mergeTranslationTaskDetails(other.getTranslationTaskDetails());
            break;
          }
        case TASKDETAILS_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                id_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 10
            case 18:
              {
                type_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getDetailsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 26
            case 32:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000020;
                break;
              } // case 32
            case 42:
              {
                input.readMessage(getProcessingErrorFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getLastUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 58
            case 82:
              {
                input.readMessage(
                    getOrchestrationResultFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 82
            case 98:
              {
                input.readMessage(
                    getAssessmentTaskDetailsFieldBuilder().getBuilder(), extensionRegistry);
                taskDetailsCase_ = 12;
                break;
              } // case 98
            case 106:
              {
                input.readMessage(
                    getTranslationTaskDetailsFieldBuilder().getBuilder(), extensionRegistry);
                taskDetailsCase_ = 13;
                break;
              } // case 106
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int taskDetailsCase_ = 0;
    private java.lang.Object taskDetails_;

    public TaskDetailsCase getTaskDetailsCase() {
      return TaskDetailsCase.forNumber(taskDetailsCase_);
    }

    public Builder clearTaskDetails() {
      taskDetailsCase_ = 0;
      taskDetails_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2alpha.AssessmentTaskDetails,
            com.google.cloud.bigquery.migration.v2alpha.AssessmentTaskDetails.Builder,
            com.google.cloud.bigquery.migration.v2alpha.AssessmentTaskDetailsOrBuilder>
        assessmentTaskDetailsBuilder_;
    /**
     *
     *
     * <pre>
     * Task configuration for Assessment.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2alpha.AssessmentTaskDetails assessment_task_details = 12;
     * </code>
     *
     * @return Whether the assessmentTaskDetails field is set.
     */
    @java.lang.Override
    public boolean hasAssessmentTaskDetails() {
      return taskDetailsCase_ == 12;
    }
    /**
     *
     *
     * <pre>
     * Task configuration for Assessment.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2alpha.AssessmentTaskDetails assessment_task_details = 12;
     * </code>
     *
     * @return The assessmentTaskDetails.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2alpha.AssessmentTaskDetails
        getAssessmentTaskDetails() {
      if (assessmentTaskDetailsBuilder_ == null) {
        if (taskDetailsCase_ == 12) {
          return (com.google.cloud.bigquery.migration.v2alpha.AssessmentTaskDetails) taskDetails_;
        }
        return com.google.cloud.bigquery.migration.v2alpha.AssessmentTaskDetails
            .getDefaultInstance();
      } else {
        if (taskDetailsCase_ == 12) {
          return assessmentTaskDetailsBuilder_.getMessage();
        }
        return com.google.cloud.bigquery.migration.v2alpha.AssessmentTaskDetails
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Task configuration for Assessment.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2alpha.AssessmentTaskDetails assessment_task_details = 12;
     * </code>
     */
    public Builder setAssessmentTaskDetails(
        com.google.cloud.bigquery.migration.v2alpha.AssessmentTaskDetails value) {
      if (assessmentTaskDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        taskDetails_ = value;
        onChanged();
      } else {
        assessmentTaskDetailsBuilder_.setMessage(value);
      }
      taskDetailsCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Task configuration for Assessment.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2alpha.AssessmentTaskDetails assessment_task_details = 12;
     * </code>
     */
    public Builder setAssessmentTaskDetails(
        com.google.cloud.bigquery.migration.v2alpha.AssessmentTaskDetails.Builder builderForValue) {
      if (assessmentTaskDetailsBuilder_ == null) {
        taskDetails_ = builderForValue.build();
        onChanged();
      } else {
        assessmentTaskDetailsBuilder_.setMessage(builderForValue.build());
      }
      taskDetailsCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Task configuration for Assessment.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2alpha.AssessmentTaskDetails assessment_task_details = 12;
     * </code>
     */
    public Builder mergeAssessmentTaskDetails(
        com.google.cloud.bigquery.migration.v2alpha.AssessmentTaskDetails value) {
      if (assessmentTaskDetailsBuilder_ == null) {
        if (taskDetailsCase_ == 12
            && taskDetails_
                != com.google.cloud.bigquery.migration.v2alpha.AssessmentTaskDetails
                    .getDefaultInstance()) {
          taskDetails_ =
              com.google.cloud.bigquery.migration.v2alpha.AssessmentTaskDetails.newBuilder(
                      (com.google.cloud.bigquery.migration.v2alpha.AssessmentTaskDetails)
                          taskDetails_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          taskDetails_ = value;
        }
        onChanged();
      } else {
        if (taskDetailsCase_ == 12) {
          assessmentTaskDetailsBuilder_.mergeFrom(value);
        } else {
          assessmentTaskDetailsBuilder_.setMessage(value);
        }
      }
      taskDetailsCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Task configuration for Assessment.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2alpha.AssessmentTaskDetails assessment_task_details = 12;
     * </code>
     */
    public Builder clearAssessmentTaskDetails() {
      if (assessmentTaskDetailsBuilder_ == null) {
        if (taskDetailsCase_ == 12) {
          taskDetailsCase_ = 0;
          taskDetails_ = null;
          onChanged();
        }
      } else {
        if (taskDetailsCase_ == 12) {
          taskDetailsCase_ = 0;
          taskDetails_ = null;
        }
        assessmentTaskDetailsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Task configuration for Assessment.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2alpha.AssessmentTaskDetails assessment_task_details = 12;
     * </code>
     */
    public com.google.cloud.bigquery.migration.v2alpha.AssessmentTaskDetails.Builder
        getAssessmentTaskDetailsBuilder() {
      return getAssessmentTaskDetailsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Task configuration for Assessment.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2alpha.AssessmentTaskDetails assessment_task_details = 12;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2alpha.AssessmentTaskDetailsOrBuilder
        getAssessmentTaskDetailsOrBuilder() {
      if ((taskDetailsCase_ == 12) && (assessmentTaskDetailsBuilder_ != null)) {
        return assessmentTaskDetailsBuilder_.getMessageOrBuilder();
      } else {
        if (taskDetailsCase_ == 12) {
          return (com.google.cloud.bigquery.migration.v2alpha.AssessmentTaskDetails) taskDetails_;
        }
        return com.google.cloud.bigquery.migration.v2alpha.AssessmentTaskDetails
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Task configuration for Assessment.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2alpha.AssessmentTaskDetails assessment_task_details = 12;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2alpha.AssessmentTaskDetails,
            com.google.cloud.bigquery.migration.v2alpha.AssessmentTaskDetails.Builder,
            com.google.cloud.bigquery.migration.v2alpha.AssessmentTaskDetailsOrBuilder>
        getAssessmentTaskDetailsFieldBuilder() {
      if (assessmentTaskDetailsBuilder_ == null) {
        if (!(taskDetailsCase_ == 12)) {
          taskDetails_ =
              com.google.cloud.bigquery.migration.v2alpha.AssessmentTaskDetails
                  .getDefaultInstance();
        }
        assessmentTaskDetailsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.migration.v2alpha.AssessmentTaskDetails,
                com.google.cloud.bigquery.migration.v2alpha.AssessmentTaskDetails.Builder,
                com.google.cloud.bigquery.migration.v2alpha.AssessmentTaskDetailsOrBuilder>(
                (com.google.cloud.bigquery.migration.v2alpha.AssessmentTaskDetails) taskDetails_,
                getParentForChildren(),
                isClean());
        taskDetails_ = null;
      }
      taskDetailsCase_ = 12;
      onChanged();
      return assessmentTaskDetailsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails,
            com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.Builder,
            com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetailsOrBuilder>
        translationTaskDetailsBuilder_;
    /**
     *
     *
     * <pre>
     * Task configuration for Batch/Offline SQL Translation.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails translation_task_details = 13;
     * </code>
     *
     * @return Whether the translationTaskDetails field is set.
     */
    @java.lang.Override
    public boolean hasTranslationTaskDetails() {
      return taskDetailsCase_ == 13;
    }
    /**
     *
     *
     * <pre>
     * Task configuration for Batch/Offline SQL Translation.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails translation_task_details = 13;
     * </code>
     *
     * @return The translationTaskDetails.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails
        getTranslationTaskDetails() {
      if (translationTaskDetailsBuilder_ == null) {
        if (taskDetailsCase_ == 13) {
          return (com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails) taskDetails_;
        }
        return com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails
            .getDefaultInstance();
      } else {
        if (taskDetailsCase_ == 13) {
          return translationTaskDetailsBuilder_.getMessage();
        }
        return com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Task configuration for Batch/Offline SQL Translation.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails translation_task_details = 13;
     * </code>
     */
    public Builder setTranslationTaskDetails(
        com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails value) {
      if (translationTaskDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        taskDetails_ = value;
        onChanged();
      } else {
        translationTaskDetailsBuilder_.setMessage(value);
      }
      taskDetailsCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Task configuration for Batch/Offline SQL Translation.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails translation_task_details = 13;
     * </code>
     */
    public Builder setTranslationTaskDetails(
        com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.Builder
            builderForValue) {
      if (translationTaskDetailsBuilder_ == null) {
        taskDetails_ = builderForValue.build();
        onChanged();
      } else {
        translationTaskDetailsBuilder_.setMessage(builderForValue.build());
      }
      taskDetailsCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Task configuration for Batch/Offline SQL Translation.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails translation_task_details = 13;
     * </code>
     */
    public Builder mergeTranslationTaskDetails(
        com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails value) {
      if (translationTaskDetailsBuilder_ == null) {
        if (taskDetailsCase_ == 13
            && taskDetails_
                != com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails
                    .getDefaultInstance()) {
          taskDetails_ =
              com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.newBuilder(
                      (com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails)
                          taskDetails_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          taskDetails_ = value;
        }
        onChanged();
      } else {
        if (taskDetailsCase_ == 13) {
          translationTaskDetailsBuilder_.mergeFrom(value);
        } else {
          translationTaskDetailsBuilder_.setMessage(value);
        }
      }
      taskDetailsCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Task configuration for Batch/Offline SQL Translation.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails translation_task_details = 13;
     * </code>
     */
    public Builder clearTranslationTaskDetails() {
      if (translationTaskDetailsBuilder_ == null) {
        if (taskDetailsCase_ == 13) {
          taskDetailsCase_ = 0;
          taskDetails_ = null;
          onChanged();
        }
      } else {
        if (taskDetailsCase_ == 13) {
          taskDetailsCase_ = 0;
          taskDetails_ = null;
        }
        translationTaskDetailsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Task configuration for Batch/Offline SQL Translation.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails translation_task_details = 13;
     * </code>
     */
    public com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.Builder
        getTranslationTaskDetailsBuilder() {
      return getTranslationTaskDetailsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Task configuration for Batch/Offline SQL Translation.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails translation_task_details = 13;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetailsOrBuilder
        getTranslationTaskDetailsOrBuilder() {
      if ((taskDetailsCase_ == 13) && (translationTaskDetailsBuilder_ != null)) {
        return translationTaskDetailsBuilder_.getMessageOrBuilder();
      } else {
        if (taskDetailsCase_ == 13) {
          return (com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails) taskDetails_;
        }
        return com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Task configuration for Batch/Offline SQL Translation.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails translation_task_details = 13;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails,
            com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.Builder,
            com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetailsOrBuilder>
        getTranslationTaskDetailsFieldBuilder() {
      if (translationTaskDetailsBuilder_ == null) {
        if (!(taskDetailsCase_ == 13)) {
          taskDetails_ =
              com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails
                  .getDefaultInstance();
        }
        translationTaskDetailsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails,
                com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.Builder,
                com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetailsOrBuilder>(
                (com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails) taskDetails_,
                getParentForChildren(),
                isClean());
        taskDetails_ = null;
      }
      taskDetailsCase_ = 13;
      onChanged();
      return translationTaskDetailsBuilder_;
    }

    private java.lang.Object id_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The unique identifier for the migration task. The ID is server-generated.
     * </pre>
     *
     * <code>
     * string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The id.
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The unique identifier for the migration task. The ID is server-generated.
     * </pre>
     *
     * <code>
     * string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The bytes for id.
     */
    public com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The unique identifier for the migration task. The ID is server-generated.
     * </pre>
     *
     * <code>
     * string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      id_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The unique identifier for the migration task. The ID is server-generated.
     * </pre>
     *
     * <code>
     * string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      id_ = getDefaultInstance().getId();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The unique identifier for the migration task. The ID is server-generated.
     * </pre>
     *
     * <code>
     * string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The bytes for id to set.
     * @return This builder for chaining.
     */
    public Builder setIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      id_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object type_ = "";
    /**
     *
     *
     * <pre>
     * The type of the task. This must be a supported task type.
     * </pre>
     *
     * <code>string type = 2;</code>
     *
     * @return The type.
     */
    public java.lang.String getType() {
      java.lang.Object ref = type_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        type_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The type of the task. This must be a supported task type.
     * </pre>
     *
     * <code>string type = 2;</code>
     *
     * @return The bytes for type.
     */
    public com.google.protobuf.ByteString getTypeBytes() {
      java.lang.Object ref = type_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        type_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The type of the task. This must be a supported task type.
     * </pre>
     *
     * <code>string type = 2;</code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      type_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of the task. This must be a supported task type.
     * </pre>
     *
     * <code>string type = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      type_ = getDefaultInstance().getType();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of the task. This must be a supported task type.
     * </pre>
     *
     * <code>string type = 2;</code>
     *
     * @param value The bytes for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      type_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.Any details_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Any,
            com.google.protobuf.Any.Builder,
            com.google.protobuf.AnyOrBuilder>
        detailsBuilder_;
    /**
     *
     *
     * <pre>
     * DEPRECATED! Use one of the task_details below.
     * The details of the task. The type URL must be one of the supported task
     * details messages and correspond to the Task's type.
     * </pre>
     *
     * <code>.google.protobuf.Any details = 3;</code>
     *
     * @return Whether the details field is set.
     */
    public boolean hasDetails() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * DEPRECATED! Use one of the task_details below.
     * The details of the task. The type URL must be one of the supported task
     * details messages and correspond to the Task's type.
     * </pre>
     *
     * <code>.google.protobuf.Any details = 3;</code>
     *
     * @return The details.
     */
    public com.google.protobuf.Any getDetails() {
      if (detailsBuilder_ == null) {
        return details_ == null ? com.google.protobuf.Any.getDefaultInstance() : details_;
      } else {
        return detailsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * DEPRECATED! Use one of the task_details below.
     * The details of the task. The type URL must be one of the supported task
     * details messages and correspond to the Task's type.
     * </pre>
     *
     * <code>.google.protobuf.Any details = 3;</code>
     */
    public Builder setDetails(com.google.protobuf.Any value) {
      if (detailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        details_ = value;
      } else {
        detailsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * DEPRECATED! Use one of the task_details below.
     * The details of the task. The type URL must be one of the supported task
     * details messages and correspond to the Task's type.
     * </pre>
     *
     * <code>.google.protobuf.Any details = 3;</code>
     */
    public Builder setDetails(com.google.protobuf.Any.Builder builderForValue) {
      if (detailsBuilder_ == null) {
        details_ = builderForValue.build();
      } else {
        detailsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * DEPRECATED! Use one of the task_details below.
     * The details of the task. The type URL must be one of the supported task
     * details messages and correspond to the Task's type.
     * </pre>
     *
     * <code>.google.protobuf.Any details = 3;</code>
     */
    public Builder mergeDetails(com.google.protobuf.Any value) {
      if (detailsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && details_ != null
            && details_ != com.google.protobuf.Any.getDefaultInstance()) {
          getDetailsBuilder().mergeFrom(value);
        } else {
          details_ = value;
        }
      } else {
        detailsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * DEPRECATED! Use one of the task_details below.
     * The details of the task. The type URL must be one of the supported task
     * details messages and correspond to the Task's type.
     * </pre>
     *
     * <code>.google.protobuf.Any details = 3;</code>
     */
    public Builder clearDetails() {
      bitField0_ = (bitField0_ & ~0x00000010);
      details_ = null;
      if (detailsBuilder_ != null) {
        detailsBuilder_.dispose();
        detailsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * DEPRECATED! Use one of the task_details below.
     * The details of the task. The type URL must be one of the supported task
     * details messages and correspond to the Task's type.
     * </pre>
     *
     * <code>.google.protobuf.Any details = 3;</code>
     */
    public com.google.protobuf.Any.Builder getDetailsBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getDetailsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * DEPRECATED! Use one of the task_details below.
     * The details of the task. The type URL must be one of the supported task
     * details messages and correspond to the Task's type.
     * </pre>
     *
     * <code>.google.protobuf.Any details = 3;</code>
     */
    public com.google.protobuf.AnyOrBuilder getDetailsOrBuilder() {
      if (detailsBuilder_ != null) {
        return detailsBuilder_.getMessageOrBuilder();
      } else {
        return details_ == null ? com.google.protobuf.Any.getDefaultInstance() : details_;
      }
    }
    /**
     *
     *
     * <pre>
     * DEPRECATED! Use one of the task_details below.
     * The details of the task. The type URL must be one of the supported task
     * details messages and correspond to the Task's type.
     * </pre>
     *
     * <code>.google.protobuf.Any details = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Any,
            com.google.protobuf.Any.Builder,
            com.google.protobuf.AnyOrBuilder>
        getDetailsFieldBuilder() {
      if (detailsBuilder_ == null) {
        detailsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Any,
                com.google.protobuf.Any.Builder,
                com.google.protobuf.AnyOrBuilder>(getDetails(), getParentForChildren(), isClean());
        details_ = null;
      }
      return detailsBuilder_;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The current state of the task.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2alpha.MigrationTask.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the task.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2alpha.MigrationTask.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the task.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2alpha.MigrationTask.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2alpha.MigrationTask.State getState() {
      com.google.cloud.bigquery.migration.v2alpha.MigrationTask.State result =
          com.google.cloud.bigquery.migration.v2alpha.MigrationTask.State.forNumber(state_);
      return result == null
          ? com.google.cloud.bigquery.migration.v2alpha.MigrationTask.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the task.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2alpha.MigrationTask.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.bigquery.migration.v2alpha.MigrationTask.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000020;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the task.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2alpha.MigrationTask.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000020);
      state_ = 0;
      onChanged();
      return this;
    }

    private com.google.rpc.ErrorInfo processingError_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.ErrorInfo,
            com.google.rpc.ErrorInfo.Builder,
            com.google.rpc.ErrorInfoOrBuilder>
        processingErrorBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. An explanation that may be populated when the task is in FAILED state.
     * </pre>
     *
     * <code>
     * .google.rpc.ErrorInfo processing_error = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the processingError field is set.
     */
    public boolean hasProcessingError() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. An explanation that may be populated when the task is in FAILED state.
     * </pre>
     *
     * <code>
     * .google.rpc.ErrorInfo processing_error = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The processingError.
     */
    public com.google.rpc.ErrorInfo getProcessingError() {
      if (processingErrorBuilder_ == null) {
        return processingError_ == null
            ? com.google.rpc.ErrorInfo.getDefaultInstance()
            : processingError_;
      } else {
        return processingErrorBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. An explanation that may be populated when the task is in FAILED state.
     * </pre>
     *
     * <code>
     * .google.rpc.ErrorInfo processing_error = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setProcessingError(com.google.rpc.ErrorInfo value) {
      if (processingErrorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        processingError_ = value;
      } else {
        processingErrorBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. An explanation that may be populated when the task is in FAILED state.
     * </pre>
     *
     * <code>
     * .google.rpc.ErrorInfo processing_error = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setProcessingError(com.google.rpc.ErrorInfo.Builder builderForValue) {
      if (processingErrorBuilder_ == null) {
        processingError_ = builderForValue.build();
      } else {
        processingErrorBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. An explanation that may be populated when the task is in FAILED state.
     * </pre>
     *
     * <code>
     * .google.rpc.ErrorInfo processing_error = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeProcessingError(com.google.rpc.ErrorInfo value) {
      if (processingErrorBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && processingError_ != null
            && processingError_ != com.google.rpc.ErrorInfo.getDefaultInstance()) {
          getProcessingErrorBuilder().mergeFrom(value);
        } else {
          processingError_ = value;
        }
      } else {
        processingErrorBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. An explanation that may be populated when the task is in FAILED state.
     * </pre>
     *
     * <code>
     * .google.rpc.ErrorInfo processing_error = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearProcessingError() {
      bitField0_ = (bitField0_ & ~0x00000040);
      processingError_ = null;
      if (processingErrorBuilder_ != null) {
        processingErrorBuilder_.dispose();
        processingErrorBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. An explanation that may be populated when the task is in FAILED state.
     * </pre>
     *
     * <code>
     * .google.rpc.ErrorInfo processing_error = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.rpc.ErrorInfo.Builder getProcessingErrorBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getProcessingErrorFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. An explanation that may be populated when the task is in FAILED state.
     * </pre>
     *
     * <code>
     * .google.rpc.ErrorInfo processing_error = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.rpc.ErrorInfoOrBuilder getProcessingErrorOrBuilder() {
      if (processingErrorBuilder_ != null) {
        return processingErrorBuilder_.getMessageOrBuilder();
      } else {
        return processingError_ == null
            ? com.google.rpc.ErrorInfo.getDefaultInstance()
            : processingError_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. An explanation that may be populated when the task is in FAILED state.
     * </pre>
     *
     * <code>
     * .google.rpc.ErrorInfo processing_error = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.ErrorInfo,
            com.google.rpc.ErrorInfo.Builder,
            com.google.rpc.ErrorInfoOrBuilder>
        getProcessingErrorFieldBuilder() {
      if (processingErrorBuilder_ == null) {
        processingErrorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.ErrorInfo,
                com.google.rpc.ErrorInfo.Builder,
                com.google.rpc.ErrorInfoOrBuilder>(
                getProcessingError(), getParentForChildren(), isClean());
        processingError_ = null;
      }
      return processingErrorBuilder_;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Time when the task was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 6;</code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Time when the task was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 6;</code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Time when the task was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 6;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the task was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 6;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the task was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 6;</code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the task was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 6;</code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000080);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the task was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 6;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Time when the task was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 6;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Time when the task was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp lastUpdateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        lastUpdateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Time when the task was last updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_update_time = 7;</code>
     *
     * @return Whether the lastUpdateTime field is set.
     */
    public boolean hasLastUpdateTime() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Time when the task was last updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_update_time = 7;</code>
     *
     * @return The lastUpdateTime.
     */
    public com.google.protobuf.Timestamp getLastUpdateTime() {
      if (lastUpdateTimeBuilder_ == null) {
        return lastUpdateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastUpdateTime_;
      } else {
        return lastUpdateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Time when the task was last updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_update_time = 7;</code>
     */
    public Builder setLastUpdateTime(com.google.protobuf.Timestamp value) {
      if (lastUpdateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        lastUpdateTime_ = value;
      } else {
        lastUpdateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the task was last updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_update_time = 7;</code>
     */
    public Builder setLastUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (lastUpdateTimeBuilder_ == null) {
        lastUpdateTime_ = builderForValue.build();
      } else {
        lastUpdateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the task was last updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_update_time = 7;</code>
     */
    public Builder mergeLastUpdateTime(com.google.protobuf.Timestamp value) {
      if (lastUpdateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && lastUpdateTime_ != null
            && lastUpdateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getLastUpdateTimeBuilder().mergeFrom(value);
        } else {
          lastUpdateTime_ = value;
        }
      } else {
        lastUpdateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the task was last updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_update_time = 7;</code>
     */
    public Builder clearLastUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000100);
      lastUpdateTime_ = null;
      if (lastUpdateTimeBuilder_ != null) {
        lastUpdateTimeBuilder_.dispose();
        lastUpdateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the task was last updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_update_time = 7;</code>
     */
    public com.google.protobuf.Timestamp.Builder getLastUpdateTimeBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getLastUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Time when the task was last updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_update_time = 7;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getLastUpdateTimeOrBuilder() {
      if (lastUpdateTimeBuilder_ != null) {
        return lastUpdateTimeBuilder_.getMessageOrBuilder();
      } else {
        return lastUpdateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastUpdateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Time when the task was last updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_update_time = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getLastUpdateTimeFieldBuilder() {
      if (lastUpdateTimeBuilder_ == null) {
        lastUpdateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getLastUpdateTime(), getParentForChildren(), isClean());
        lastUpdateTime_ = null;
      }
      return lastUpdateTimeBuilder_;
    }

    private com.google.cloud.bigquery.migration.v2alpha.MigrationTaskOrchestrationResult
        orchestrationResult_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2alpha.MigrationTaskOrchestrationResult,
            com.google.cloud.bigquery.migration.v2alpha.MigrationTaskOrchestrationResult.Builder,
            com.google.cloud.bigquery.migration.v2alpha.MigrationTaskOrchestrationResultOrBuilder>
        orchestrationResultBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Additional information about the orchestration.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2alpha.MigrationTaskOrchestrationResult orchestration_result = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the orchestrationResult field is set.
     */
    public boolean hasOrchestrationResult() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about the orchestration.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2alpha.MigrationTaskOrchestrationResult orchestration_result = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The orchestrationResult.
     */
    public com.google.cloud.bigquery.migration.v2alpha.MigrationTaskOrchestrationResult
        getOrchestrationResult() {
      if (orchestrationResultBuilder_ == null) {
        return orchestrationResult_ == null
            ? com.google.cloud.bigquery.migration.v2alpha.MigrationTaskOrchestrationResult
                .getDefaultInstance()
            : orchestrationResult_;
      } else {
        return orchestrationResultBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about the orchestration.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2alpha.MigrationTaskOrchestrationResult orchestration_result = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setOrchestrationResult(
        com.google.cloud.bigquery.migration.v2alpha.MigrationTaskOrchestrationResult value) {
      if (orchestrationResultBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        orchestrationResult_ = value;
      } else {
        orchestrationResultBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about the orchestration.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2alpha.MigrationTaskOrchestrationResult orchestration_result = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setOrchestrationResult(
        com.google.cloud.bigquery.migration.v2alpha.MigrationTaskOrchestrationResult.Builder
            builderForValue) {
      if (orchestrationResultBuilder_ == null) {
        orchestrationResult_ = builderForValue.build();
      } else {
        orchestrationResultBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about the orchestration.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2alpha.MigrationTaskOrchestrationResult orchestration_result = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeOrchestrationResult(
        com.google.cloud.bigquery.migration.v2alpha.MigrationTaskOrchestrationResult value) {
      if (orchestrationResultBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && orchestrationResult_ != null
            && orchestrationResult_
                != com.google.cloud.bigquery.migration.v2alpha.MigrationTaskOrchestrationResult
                    .getDefaultInstance()) {
          getOrchestrationResultBuilder().mergeFrom(value);
        } else {
          orchestrationResult_ = value;
        }
      } else {
        orchestrationResultBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about the orchestration.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2alpha.MigrationTaskOrchestrationResult orchestration_result = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearOrchestrationResult() {
      bitField0_ = (bitField0_ & ~0x00000200);
      orchestrationResult_ = null;
      if (orchestrationResultBuilder_ != null) {
        orchestrationResultBuilder_.dispose();
        orchestrationResultBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about the orchestration.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2alpha.MigrationTaskOrchestrationResult orchestration_result = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.bigquery.migration.v2alpha.MigrationTaskOrchestrationResult.Builder
        getOrchestrationResultBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getOrchestrationResultFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about the orchestration.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2alpha.MigrationTaskOrchestrationResult orchestration_result = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.bigquery.migration.v2alpha.MigrationTaskOrchestrationResultOrBuilder
        getOrchestrationResultOrBuilder() {
      if (orchestrationResultBuilder_ != null) {
        return orchestrationResultBuilder_.getMessageOrBuilder();
      } else {
        return orchestrationResult_ == null
            ? com.google.cloud.bigquery.migration.v2alpha.MigrationTaskOrchestrationResult
                .getDefaultInstance()
            : orchestrationResult_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about the orchestration.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2alpha.MigrationTaskOrchestrationResult orchestration_result = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2alpha.MigrationTaskOrchestrationResult,
            com.google.cloud.bigquery.migration.v2alpha.MigrationTaskOrchestrationResult.Builder,
            com.google.cloud.bigquery.migration.v2alpha.MigrationTaskOrchestrationResultOrBuilder>
        getOrchestrationResultFieldBuilder() {
      if (orchestrationResultBuilder_ == null) {
        orchestrationResultBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.migration.v2alpha.MigrationTaskOrchestrationResult,
                com.google.cloud.bigquery.migration.v2alpha.MigrationTaskOrchestrationResult
                    .Builder,
                com.google.cloud.bigquery.migration.v2alpha
                    .MigrationTaskOrchestrationResultOrBuilder>(
                getOrchestrationResult(), getParentForChildren(), isClean());
        orchestrationResult_ = null;
      }
      return orchestrationResultBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.migration.v2alpha.MigrationTask)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.bigquery.migration.v2alpha.MigrationTask)
  private static final com.google.cloud.bigquery.migration.v2alpha.MigrationTask DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.bigquery.migration.v2alpha.MigrationTask();
  }

  public static com.google.cloud.bigquery.migration.v2alpha.MigrationTask getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<MigrationTask> PARSER =
      new com.google.protobuf.AbstractParser<MigrationTask>() {
        @java.lang.Override
        public MigrationTask parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<MigrationTask> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<MigrationTask> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2alpha.MigrationTask getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
