/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/migration/v2alpha/migration_metrics.proto

package com.google.cloud.bigquery.migration.v2alpha;

/**
 *
 *
 * <pre>
 * The metrics object for a SubTask.
 * </pre>
 *
 * Protobuf type {@code google.cloud.bigquery.migration.v2alpha.TimeSeries}
 */
public final class TimeSeries extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.bigquery.migration.v2alpha.TimeSeries)
    TimeSeriesOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TimeSeries.newBuilder() to construct.
  private TimeSeries(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TimeSeries() {
    metric_ = "";
    valueType_ = 0;
    metricKind_ = 0;
    points_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TimeSeries();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.bigquery.migration.v2alpha.MigrationMetricsProto
        .internal_static_google_cloud_bigquery_migration_v2alpha_TimeSeries_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.bigquery.migration.v2alpha.MigrationMetricsProto
        .internal_static_google_cloud_bigquery_migration_v2alpha_TimeSeries_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.bigquery.migration.v2alpha.TimeSeries.class,
            com.google.cloud.bigquery.migration.v2alpha.TimeSeries.Builder.class);
  }

  public static final int METRIC_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object metric_ = "";
  /**
   *
   *
   * <pre>
   * Required. The name of the metric.
   *
   * If the metric is not known by the service yet, it will be auto-created.
   * </pre>
   *
   * <code>string metric = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The metric.
   */
  @java.lang.Override
  public java.lang.String getMetric() {
    java.lang.Object ref = metric_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      metric_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The name of the metric.
   *
   * If the metric is not known by the service yet, it will be auto-created.
   * </pre>
   *
   * <code>string metric = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for metric.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMetricBytes() {
    java.lang.Object ref = metric_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      metric_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VALUE_TYPE_FIELD_NUMBER = 2;
  private int valueType_ = 0;
  /**
   *
   *
   * <pre>
   * Required. The value type of the time series.
   * </pre>
   *
   * <code>
   * .google.api.MetricDescriptor.ValueType value_type = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for valueType.
   */
  @java.lang.Override
  public int getValueTypeValue() {
    return valueType_;
  }
  /**
   *
   *
   * <pre>
   * Required. The value type of the time series.
   * </pre>
   *
   * <code>
   * .google.api.MetricDescriptor.ValueType value_type = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The valueType.
   */
  @java.lang.Override
  public com.google.api.MetricDescriptor.ValueType getValueType() {
    com.google.api.MetricDescriptor.ValueType result =
        com.google.api.MetricDescriptor.ValueType.forNumber(valueType_);
    return result == null ? com.google.api.MetricDescriptor.ValueType.UNRECOGNIZED : result;
  }

  public static final int METRIC_KIND_FIELD_NUMBER = 3;
  private int metricKind_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. The metric kind of the time series.
   *
   * If present, it must be the same as the metric kind of the associated
   * metric. If the associated metric's descriptor must be auto-created, then
   * this field specifies the metric kind of the new descriptor and must be
   * either `GAUGE` (the default) or `CUMULATIVE`.
   * </pre>
   *
   * <code>
   * .google.api.MetricDescriptor.MetricKind metric_kind = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for metricKind.
   */
  @java.lang.Override
  public int getMetricKindValue() {
    return metricKind_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The metric kind of the time series.
   *
   * If present, it must be the same as the metric kind of the associated
   * metric. If the associated metric's descriptor must be auto-created, then
   * this field specifies the metric kind of the new descriptor and must be
   * either `GAUGE` (the default) or `CUMULATIVE`.
   * </pre>
   *
   * <code>
   * .google.api.MetricDescriptor.MetricKind metric_kind = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The metricKind.
   */
  @java.lang.Override
  public com.google.api.MetricDescriptor.MetricKind getMetricKind() {
    com.google.api.MetricDescriptor.MetricKind result =
        com.google.api.MetricDescriptor.MetricKind.forNumber(metricKind_);
    return result == null ? com.google.api.MetricDescriptor.MetricKind.UNRECOGNIZED : result;
  }

  public static final int POINTS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.bigquery.migration.v2alpha.Point> points_;
  /**
   *
   *
   * <pre>
   * Required. The data points of this time series. When listing time series, points are
   * returned in reverse time order.
   *
   * When creating a time series, this field must contain exactly one point and
   * the point's type must be the same as the value type of the associated
   * metric. If the associated metric's descriptor must be auto-created, then
   * the value type of the descriptor is determined by the point's type, which
   * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.migration.v2alpha.Point points = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.bigquery.migration.v2alpha.Point> getPointsList() {
    return points_;
  }
  /**
   *
   *
   * <pre>
   * Required. The data points of this time series. When listing time series, points are
   * returned in reverse time order.
   *
   * When creating a time series, this field must contain exactly one point and
   * the point's type must be the same as the value type of the associated
   * metric. If the associated metric's descriptor must be auto-created, then
   * the value type of the descriptor is determined by the point's type, which
   * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.migration.v2alpha.Point points = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.bigquery.migration.v2alpha.PointOrBuilder>
      getPointsOrBuilderList() {
    return points_;
  }
  /**
   *
   *
   * <pre>
   * Required. The data points of this time series. When listing time series, points are
   * returned in reverse time order.
   *
   * When creating a time series, this field must contain exactly one point and
   * the point's type must be the same as the value type of the associated
   * metric. If the associated metric's descriptor must be auto-created, then
   * the value type of the descriptor is determined by the point's type, which
   * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.migration.v2alpha.Point points = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getPointsCount() {
    return points_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. The data points of this time series. When listing time series, points are
   * returned in reverse time order.
   *
   * When creating a time series, this field must contain exactly one point and
   * the point's type must be the same as the value type of the associated
   * metric. If the associated metric's descriptor must be auto-created, then
   * the value type of the descriptor is determined by the point's type, which
   * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.migration.v2alpha.Point points = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2alpha.Point getPoints(int index) {
    return points_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. The data points of this time series. When listing time series, points are
   * returned in reverse time order.
   *
   * When creating a time series, this field must contain exactly one point and
   * the point's type must be the same as the value type of the associated
   * metric. If the associated metric's descriptor must be auto-created, then
   * the value type of the descriptor is determined by the point's type, which
   * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.migration.v2alpha.Point points = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2alpha.PointOrBuilder getPointsOrBuilder(int index) {
    return points_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(metric_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, metric_);
    }
    if (valueType_
        != com.google.api.MetricDescriptor.ValueType.VALUE_TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(2, valueType_);
    }
    if (metricKind_
        != com.google.api.MetricDescriptor.MetricKind.METRIC_KIND_UNSPECIFIED.getNumber()) {
      output.writeEnum(3, metricKind_);
    }
    for (int i = 0; i < points_.size(); i++) {
      output.writeMessage(4, points_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(metric_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, metric_);
    }
    if (valueType_
        != com.google.api.MetricDescriptor.ValueType.VALUE_TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, valueType_);
    }
    if (metricKind_
        != com.google.api.MetricDescriptor.MetricKind.METRIC_KIND_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, metricKind_);
    }
    for (int i = 0; i < points_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, points_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.bigquery.migration.v2alpha.TimeSeries)) {
      return super.equals(obj);
    }
    com.google.cloud.bigquery.migration.v2alpha.TimeSeries other =
        (com.google.cloud.bigquery.migration.v2alpha.TimeSeries) obj;

    if (!getMetric().equals(other.getMetric())) return false;
    if (valueType_ != other.valueType_) return false;
    if (metricKind_ != other.metricKind_) return false;
    if (!getPointsList().equals(other.getPointsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + METRIC_FIELD_NUMBER;
    hash = (53 * hash) + getMetric().hashCode();
    hash = (37 * hash) + VALUE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + valueType_;
    hash = (37 * hash) + METRIC_KIND_FIELD_NUMBER;
    hash = (53 * hash) + metricKind_;
    if (getPointsCount() > 0) {
      hash = (37 * hash) + POINTS_FIELD_NUMBER;
      hash = (53 * hash) + getPointsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.bigquery.migration.v2alpha.TimeSeries parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.TimeSeries parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.TimeSeries parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.TimeSeries parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.TimeSeries parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.TimeSeries parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.TimeSeries parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.TimeSeries parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.TimeSeries parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.TimeSeries parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.TimeSeries parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.TimeSeries parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.bigquery.migration.v2alpha.TimeSeries prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The metrics object for a SubTask.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.migration.v2alpha.TimeSeries}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.migration.v2alpha.TimeSeries)
      com.google.cloud.bigquery.migration.v2alpha.TimeSeriesOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.migration.v2alpha.MigrationMetricsProto
          .internal_static_google_cloud_bigquery_migration_v2alpha_TimeSeries_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.migration.v2alpha.MigrationMetricsProto
          .internal_static_google_cloud_bigquery_migration_v2alpha_TimeSeries_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.migration.v2alpha.TimeSeries.class,
              com.google.cloud.bigquery.migration.v2alpha.TimeSeries.Builder.class);
    }

    // Construct using com.google.cloud.bigquery.migration.v2alpha.TimeSeries.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      metric_ = "";
      valueType_ = 0;
      metricKind_ = 0;
      if (pointsBuilder_ == null) {
        points_ = java.util.Collections.emptyList();
      } else {
        points_ = null;
        pointsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.bigquery.migration.v2alpha.MigrationMetricsProto
          .internal_static_google_cloud_bigquery_migration_v2alpha_TimeSeries_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2alpha.TimeSeries getDefaultInstanceForType() {
      return com.google.cloud.bigquery.migration.v2alpha.TimeSeries.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2alpha.TimeSeries build() {
      com.google.cloud.bigquery.migration.v2alpha.TimeSeries result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2alpha.TimeSeries buildPartial() {
      com.google.cloud.bigquery.migration.v2alpha.TimeSeries result =
          new com.google.cloud.bigquery.migration.v2alpha.TimeSeries(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.bigquery.migration.v2alpha.TimeSeries result) {
      if (pointsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          points_ = java.util.Collections.unmodifiableList(points_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.points_ = points_;
      } else {
        result.points_ = pointsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.bigquery.migration.v2alpha.TimeSeries result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.metric_ = metric_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.valueType_ = valueType_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.metricKind_ = metricKind_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.bigquery.migration.v2alpha.TimeSeries) {
        return mergeFrom((com.google.cloud.bigquery.migration.v2alpha.TimeSeries) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.bigquery.migration.v2alpha.TimeSeries other) {
      if (other == com.google.cloud.bigquery.migration.v2alpha.TimeSeries.getDefaultInstance())
        return this;
      if (!other.getMetric().isEmpty()) {
        metric_ = other.metric_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.valueType_ != 0) {
        setValueTypeValue(other.getValueTypeValue());
      }
      if (other.metricKind_ != 0) {
        setMetricKindValue(other.getMetricKindValue());
      }
      if (pointsBuilder_ == null) {
        if (!other.points_.isEmpty()) {
          if (points_.isEmpty()) {
            points_ = other.points_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensurePointsIsMutable();
            points_.addAll(other.points_);
          }
          onChanged();
        }
      } else {
        if (!other.points_.isEmpty()) {
          if (pointsBuilder_.isEmpty()) {
            pointsBuilder_.dispose();
            pointsBuilder_ = null;
            points_ = other.points_;
            bitField0_ = (bitField0_ & ~0x00000008);
            pointsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPointsFieldBuilder()
                    : null;
          } else {
            pointsBuilder_.addAllMessages(other.points_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                metric_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                valueType_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 24:
              {
                metricKind_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                com.google.cloud.bigquery.migration.v2alpha.Point m =
                    input.readMessage(
                        com.google.cloud.bigquery.migration.v2alpha.Point.parser(),
                        extensionRegistry);
                if (pointsBuilder_ == null) {
                  ensurePointsIsMutable();
                  points_.add(m);
                } else {
                  pointsBuilder_.addMessage(m);
                }
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object metric_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the metric.
     *
     * If the metric is not known by the service yet, it will be auto-created.
     * </pre>
     *
     * <code>string metric = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The metric.
     */
    public java.lang.String getMetric() {
      java.lang.Object ref = metric_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        metric_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the metric.
     *
     * If the metric is not known by the service yet, it will be auto-created.
     * </pre>
     *
     * <code>string metric = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for metric.
     */
    public com.google.protobuf.ByteString getMetricBytes() {
      java.lang.Object ref = metric_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        metric_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the metric.
     *
     * If the metric is not known by the service yet, it will be auto-created.
     * </pre>
     *
     * <code>string metric = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The metric to set.
     * @return This builder for chaining.
     */
    public Builder setMetric(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      metric_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the metric.
     *
     * If the metric is not known by the service yet, it will be auto-created.
     * </pre>
     *
     * <code>string metric = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMetric() {
      metric_ = getDefaultInstance().getMetric();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the metric.
     *
     * If the metric is not known by the service yet, it will be auto-created.
     * </pre>
     *
     * <code>string metric = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for metric to set.
     * @return This builder for chaining.
     */
    public Builder setMetricBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      metric_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int valueType_ = 0;
    /**
     *
     *
     * <pre>
     * Required. The value type of the time series.
     * </pre>
     *
     * <code>
     * .google.api.MetricDescriptor.ValueType value_type = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for valueType.
     */
    @java.lang.Override
    public int getValueTypeValue() {
      return valueType_;
    }
    /**
     *
     *
     * <pre>
     * Required. The value type of the time series.
     * </pre>
     *
     * <code>
     * .google.api.MetricDescriptor.ValueType value_type = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enum numeric value on the wire for valueType to set.
     * @return This builder for chaining.
     */
    public Builder setValueTypeValue(int value) {
      valueType_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The value type of the time series.
     * </pre>
     *
     * <code>
     * .google.api.MetricDescriptor.ValueType value_type = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The valueType.
     */
    @java.lang.Override
    public com.google.api.MetricDescriptor.ValueType getValueType() {
      com.google.api.MetricDescriptor.ValueType result =
          com.google.api.MetricDescriptor.ValueType.forNumber(valueType_);
      return result == null ? com.google.api.MetricDescriptor.ValueType.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Required. The value type of the time series.
     * </pre>
     *
     * <code>
     * .google.api.MetricDescriptor.ValueType value_type = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The valueType to set.
     * @return This builder for chaining.
     */
    public Builder setValueType(com.google.api.MetricDescriptor.ValueType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      valueType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The value type of the time series.
     * </pre>
     *
     * <code>
     * .google.api.MetricDescriptor.ValueType value_type = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearValueType() {
      bitField0_ = (bitField0_ & ~0x00000002);
      valueType_ = 0;
      onChanged();
      return this;
    }

    private int metricKind_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. The metric kind of the time series.
     *
     * If present, it must be the same as the metric kind of the associated
     * metric. If the associated metric's descriptor must be auto-created, then
     * this field specifies the metric kind of the new descriptor and must be
     * either `GAUGE` (the default) or `CUMULATIVE`.
     * </pre>
     *
     * <code>
     * .google.api.MetricDescriptor.MetricKind metric_kind = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for metricKind.
     */
    @java.lang.Override
    public int getMetricKindValue() {
      return metricKind_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The metric kind of the time series.
     *
     * If present, it must be the same as the metric kind of the associated
     * metric. If the associated metric's descriptor must be auto-created, then
     * this field specifies the metric kind of the new descriptor and must be
     * either `GAUGE` (the default) or `CUMULATIVE`.
     * </pre>
     *
     * <code>
     * .google.api.MetricDescriptor.MetricKind metric_kind = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for metricKind to set.
     * @return This builder for chaining.
     */
    public Builder setMetricKindValue(int value) {
      metricKind_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The metric kind of the time series.
     *
     * If present, it must be the same as the metric kind of the associated
     * metric. If the associated metric's descriptor must be auto-created, then
     * this field specifies the metric kind of the new descriptor and must be
     * either `GAUGE` (the default) or `CUMULATIVE`.
     * </pre>
     *
     * <code>
     * .google.api.MetricDescriptor.MetricKind metric_kind = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The metricKind.
     */
    @java.lang.Override
    public com.google.api.MetricDescriptor.MetricKind getMetricKind() {
      com.google.api.MetricDescriptor.MetricKind result =
          com.google.api.MetricDescriptor.MetricKind.forNumber(metricKind_);
      return result == null ? com.google.api.MetricDescriptor.MetricKind.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. The metric kind of the time series.
     *
     * If present, it must be the same as the metric kind of the associated
     * metric. If the associated metric's descriptor must be auto-created, then
     * this field specifies the metric kind of the new descriptor and must be
     * either `GAUGE` (the default) or `CUMULATIVE`.
     * </pre>
     *
     * <code>
     * .google.api.MetricDescriptor.MetricKind metric_kind = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The metricKind to set.
     * @return This builder for chaining.
     */
    public Builder setMetricKind(com.google.api.MetricDescriptor.MetricKind value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      metricKind_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The metric kind of the time series.
     *
     * If present, it must be the same as the metric kind of the associated
     * metric. If the associated metric's descriptor must be auto-created, then
     * this field specifies the metric kind of the new descriptor and must be
     * either `GAUGE` (the default) or `CUMULATIVE`.
     * </pre>
     *
     * <code>
     * .google.api.MetricDescriptor.MetricKind metric_kind = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMetricKind() {
      bitField0_ = (bitField0_ & ~0x00000004);
      metricKind_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.bigquery.migration.v2alpha.Point> points_ =
        java.util.Collections.emptyList();

    private void ensurePointsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        points_ =
            new java.util.ArrayList<com.google.cloud.bigquery.migration.v2alpha.Point>(points_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2alpha.Point,
            com.google.cloud.bigquery.migration.v2alpha.Point.Builder,
            com.google.cloud.bigquery.migration.v2alpha.PointOrBuilder>
        pointsBuilder_;

    /**
     *
     *
     * <pre>
     * Required. The data points of this time series. When listing time series, points are
     * returned in reverse time order.
     *
     * When creating a time series, this field must contain exactly one point and
     * the point's type must be the same as the value type of the associated
     * metric. If the associated metric's descriptor must be auto-created, then
     * the value type of the descriptor is determined by the point's type, which
     * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2alpha.Point points = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.bigquery.migration.v2alpha.Point> getPointsList() {
      if (pointsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(points_);
      } else {
        return pointsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The data points of this time series. When listing time series, points are
     * returned in reverse time order.
     *
     * When creating a time series, this field must contain exactly one point and
     * the point's type must be the same as the value type of the associated
     * metric. If the associated metric's descriptor must be auto-created, then
     * the value type of the descriptor is determined by the point's type, which
     * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2alpha.Point points = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getPointsCount() {
      if (pointsBuilder_ == null) {
        return points_.size();
      } else {
        return pointsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The data points of this time series. When listing time series, points are
     * returned in reverse time order.
     *
     * When creating a time series, this field must contain exactly one point and
     * the point's type must be the same as the value type of the associated
     * metric. If the associated metric's descriptor must be auto-created, then
     * the value type of the descriptor is determined by the point's type, which
     * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2alpha.Point points = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.bigquery.migration.v2alpha.Point getPoints(int index) {
      if (pointsBuilder_ == null) {
        return points_.get(index);
      } else {
        return pointsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The data points of this time series. When listing time series, points are
     * returned in reverse time order.
     *
     * When creating a time series, this field must contain exactly one point and
     * the point's type must be the same as the value type of the associated
     * metric. If the associated metric's descriptor must be auto-created, then
     * the value type of the descriptor is determined by the point's type, which
     * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2alpha.Point points = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setPoints(int index, com.google.cloud.bigquery.migration.v2alpha.Point value) {
      if (pointsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePointsIsMutable();
        points_.set(index, value);
        onChanged();
      } else {
        pointsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The data points of this time series. When listing time series, points are
     * returned in reverse time order.
     *
     * When creating a time series, this field must contain exactly one point and
     * the point's type must be the same as the value type of the associated
     * metric. If the associated metric's descriptor must be auto-created, then
     * the value type of the descriptor is determined by the point's type, which
     * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2alpha.Point points = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setPoints(
        int index, com.google.cloud.bigquery.migration.v2alpha.Point.Builder builderForValue) {
      if (pointsBuilder_ == null) {
        ensurePointsIsMutable();
        points_.set(index, builderForValue.build());
        onChanged();
      } else {
        pointsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The data points of this time series. When listing time series, points are
     * returned in reverse time order.
     *
     * When creating a time series, this field must contain exactly one point and
     * the point's type must be the same as the value type of the associated
     * metric. If the associated metric's descriptor must be auto-created, then
     * the value type of the descriptor is determined by the point's type, which
     * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2alpha.Point points = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addPoints(com.google.cloud.bigquery.migration.v2alpha.Point value) {
      if (pointsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePointsIsMutable();
        points_.add(value);
        onChanged();
      } else {
        pointsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The data points of this time series. When listing time series, points are
     * returned in reverse time order.
     *
     * When creating a time series, this field must contain exactly one point and
     * the point's type must be the same as the value type of the associated
     * metric. If the associated metric's descriptor must be auto-created, then
     * the value type of the descriptor is determined by the point's type, which
     * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2alpha.Point points = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addPoints(int index, com.google.cloud.bigquery.migration.v2alpha.Point value) {
      if (pointsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePointsIsMutable();
        points_.add(index, value);
        onChanged();
      } else {
        pointsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The data points of this time series. When listing time series, points are
     * returned in reverse time order.
     *
     * When creating a time series, this field must contain exactly one point and
     * the point's type must be the same as the value type of the associated
     * metric. If the associated metric's descriptor must be auto-created, then
     * the value type of the descriptor is determined by the point's type, which
     * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2alpha.Point points = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addPoints(
        com.google.cloud.bigquery.migration.v2alpha.Point.Builder builderForValue) {
      if (pointsBuilder_ == null) {
        ensurePointsIsMutable();
        points_.add(builderForValue.build());
        onChanged();
      } else {
        pointsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The data points of this time series. When listing time series, points are
     * returned in reverse time order.
     *
     * When creating a time series, this field must contain exactly one point and
     * the point's type must be the same as the value type of the associated
     * metric. If the associated metric's descriptor must be auto-created, then
     * the value type of the descriptor is determined by the point's type, which
     * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2alpha.Point points = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addPoints(
        int index, com.google.cloud.bigquery.migration.v2alpha.Point.Builder builderForValue) {
      if (pointsBuilder_ == null) {
        ensurePointsIsMutable();
        points_.add(index, builderForValue.build());
        onChanged();
      } else {
        pointsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The data points of this time series. When listing time series, points are
     * returned in reverse time order.
     *
     * When creating a time series, this field must contain exactly one point and
     * the point's type must be the same as the value type of the associated
     * metric. If the associated metric's descriptor must be auto-created, then
     * the value type of the descriptor is determined by the point's type, which
     * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2alpha.Point points = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllPoints(
        java.lang.Iterable<? extends com.google.cloud.bigquery.migration.v2alpha.Point> values) {
      if (pointsBuilder_ == null) {
        ensurePointsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, points_);
        onChanged();
      } else {
        pointsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The data points of this time series. When listing time series, points are
     * returned in reverse time order.
     *
     * When creating a time series, this field must contain exactly one point and
     * the point's type must be the same as the value type of the associated
     * metric. If the associated metric's descriptor must be auto-created, then
     * the value type of the descriptor is determined by the point's type, which
     * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2alpha.Point points = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearPoints() {
      if (pointsBuilder_ == null) {
        points_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        pointsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The data points of this time series. When listing time series, points are
     * returned in reverse time order.
     *
     * When creating a time series, this field must contain exactly one point and
     * the point's type must be the same as the value type of the associated
     * metric. If the associated metric's descriptor must be auto-created, then
     * the value type of the descriptor is determined by the point's type, which
     * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2alpha.Point points = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removePoints(int index) {
      if (pointsBuilder_ == null) {
        ensurePointsIsMutable();
        points_.remove(index);
        onChanged();
      } else {
        pointsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The data points of this time series. When listing time series, points are
     * returned in reverse time order.
     *
     * When creating a time series, this field must contain exactly one point and
     * the point's type must be the same as the value type of the associated
     * metric. If the associated metric's descriptor must be auto-created, then
     * the value type of the descriptor is determined by the point's type, which
     * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2alpha.Point points = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.bigquery.migration.v2alpha.Point.Builder getPointsBuilder(int index) {
      return getPointsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Required. The data points of this time series. When listing time series, points are
     * returned in reverse time order.
     *
     * When creating a time series, this field must contain exactly one point and
     * the point's type must be the same as the value type of the associated
     * metric. If the associated metric's descriptor must be auto-created, then
     * the value type of the descriptor is determined by the point's type, which
     * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2alpha.Point points = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.bigquery.migration.v2alpha.PointOrBuilder getPointsOrBuilder(
        int index) {
      if (pointsBuilder_ == null) {
        return points_.get(index);
      } else {
        return pointsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The data points of this time series. When listing time series, points are
     * returned in reverse time order.
     *
     * When creating a time series, this field must contain exactly one point and
     * the point's type must be the same as the value type of the associated
     * metric. If the associated metric's descriptor must be auto-created, then
     * the value type of the descriptor is determined by the point's type, which
     * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2alpha.Point points = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.bigquery.migration.v2alpha.PointOrBuilder>
        getPointsOrBuilderList() {
      if (pointsBuilder_ != null) {
        return pointsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(points_);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The data points of this time series. When listing time series, points are
     * returned in reverse time order.
     *
     * When creating a time series, this field must contain exactly one point and
     * the point's type must be the same as the value type of the associated
     * metric. If the associated metric's descriptor must be auto-created, then
     * the value type of the descriptor is determined by the point's type, which
     * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2alpha.Point points = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.bigquery.migration.v2alpha.Point.Builder addPointsBuilder() {
      return getPointsFieldBuilder()
          .addBuilder(com.google.cloud.bigquery.migration.v2alpha.Point.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. The data points of this time series. When listing time series, points are
     * returned in reverse time order.
     *
     * When creating a time series, this field must contain exactly one point and
     * the point's type must be the same as the value type of the associated
     * metric. If the associated metric's descriptor must be auto-created, then
     * the value type of the descriptor is determined by the point's type, which
     * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2alpha.Point points = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.bigquery.migration.v2alpha.Point.Builder addPointsBuilder(int index) {
      return getPointsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.bigquery.migration.v2alpha.Point.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. The data points of this time series. When listing time series, points are
     * returned in reverse time order.
     *
     * When creating a time series, this field must contain exactly one point and
     * the point's type must be the same as the value type of the associated
     * metric. If the associated metric's descriptor must be auto-created, then
     * the value type of the descriptor is determined by the point's type, which
     * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2alpha.Point points = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.bigquery.migration.v2alpha.Point.Builder>
        getPointsBuilderList() {
      return getPointsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2alpha.Point,
            com.google.cloud.bigquery.migration.v2alpha.Point.Builder,
            com.google.cloud.bigquery.migration.v2alpha.PointOrBuilder>
        getPointsFieldBuilder() {
      if (pointsBuilder_ == null) {
        pointsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.bigquery.migration.v2alpha.Point,
                com.google.cloud.bigquery.migration.v2alpha.Point.Builder,
                com.google.cloud.bigquery.migration.v2alpha.PointOrBuilder>(
                points_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
        points_ = null;
      }
      return pointsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.migration.v2alpha.TimeSeries)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.bigquery.migration.v2alpha.TimeSeries)
  private static final com.google.cloud.bigquery.migration.v2alpha.TimeSeries DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.bigquery.migration.v2alpha.TimeSeries();
  }

  public static com.google.cloud.bigquery.migration.v2alpha.TimeSeries getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TimeSeries> PARSER =
      new com.google.protobuf.AbstractParser<TimeSeries>() {
        @java.lang.Override
        public TimeSeries parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TimeSeries> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TimeSeries> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2alpha.TimeSeries getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
