/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/migration/v2alpha/translation_service.proto

package com.google.cloud.bigquery.migration.v2alpha;

/**
 *
 *
 * <pre>
 * The request of translating a SQL query to Standard SQL.
 * </pre>
 *
 * Protobuf type {@code google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest}
 */
public final class TranslateQueryRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest)
    TranslateQueryRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TranslateQueryRequest.newBuilder() to construct.
  private TranslateQueryRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TranslateQueryRequest() {
    parent_ = "";
    sourceDialect_ = 0;
    query_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TranslateQueryRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.bigquery.migration.v2alpha.TranslationServiceProto
        .internal_static_google_cloud_bigquery_migration_v2alpha_TranslateQueryRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.bigquery.migration.v2alpha.TranslationServiceProto
        .internal_static_google_cloud_bigquery_migration_v2alpha_TranslateQueryRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest.class,
            com.google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Supported SQL translation source dialects.
   * </pre>
   *
   * Protobuf enum {@code
   * google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest.SqlTranslationSourceDialect}
   */
  public enum SqlTranslationSourceDialect implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * SqlTranslationSourceDialect not specified.
     * </pre>
     *
     * <code>SQL_TRANSLATION_SOURCE_DIALECT_UNSPECIFIED = 0;</code>
     */
    SQL_TRANSLATION_SOURCE_DIALECT_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Teradata SQL.
     * </pre>
     *
     * <code>TERADATA = 1;</code>
     */
    TERADATA(1),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * SqlTranslationSourceDialect not specified.
     * </pre>
     *
     * <code>SQL_TRANSLATION_SOURCE_DIALECT_UNSPECIFIED = 0;</code>
     */
    public static final int SQL_TRANSLATION_SOURCE_DIALECT_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Teradata SQL.
     * </pre>
     *
     * <code>TERADATA = 1;</code>
     */
    public static final int TERADATA_VALUE = 1;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SqlTranslationSourceDialect valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static SqlTranslationSourceDialect forNumber(int value) {
      switch (value) {
        case 0:
          return SQL_TRANSLATION_SOURCE_DIALECT_UNSPECIFIED;
        case 1:
          return TERADATA;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<SqlTranslationSourceDialect>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<SqlTranslationSourceDialect>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<SqlTranslationSourceDialect>() {
              public SqlTranslationSourceDialect findValueByNumber(int number) {
                return SqlTranslationSourceDialect.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final SqlTranslationSourceDialect[] VALUES = values();

    public static SqlTranslationSourceDialect valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private SqlTranslationSourceDialect(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest.SqlTranslationSourceDialect)
  }

  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Required. The name of the project to which this translation request belongs.
   * Example: `projects/foo/locations/bar`
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The name of the project to which this translation request belongs.
   * Example: `projects/foo/locations/bar`
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_DIALECT_FIELD_NUMBER = 2;
  private int sourceDialect_ = 0;
  /**
   *
   *
   * <pre>
   * Required. The source SQL dialect of `queries`.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest.SqlTranslationSourceDialect source_dialect = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for sourceDialect.
   */
  @java.lang.Override
  public int getSourceDialectValue() {
    return sourceDialect_;
  }
  /**
   *
   *
   * <pre>
   * Required. The source SQL dialect of `queries`.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest.SqlTranslationSourceDialect source_dialect = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The sourceDialect.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest
          .SqlTranslationSourceDialect
      getSourceDialect() {
    com.google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest.SqlTranslationSourceDialect
        result =
            com.google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest
                .SqlTranslationSourceDialect.forNumber(sourceDialect_);
    return result == null
        ? com.google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest
            .SqlTranslationSourceDialect.UNRECOGNIZED
        : result;
  }

  public static final int QUERY_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object query_ = "";
  /**
   *
   *
   * <pre>
   * Required. The query to be translated.
   * </pre>
   *
   * <code>string query = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The query.
   */
  @java.lang.Override
  public java.lang.String getQuery() {
    java.lang.Object ref = query_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      query_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The query to be translated.
   * </pre>
   *
   * <code>string query = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for query.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getQueryBytes() {
    java.lang.Object ref = query_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      query_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (sourceDialect_
        != com.google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest
            .SqlTranslationSourceDialect.SQL_TRANSLATION_SOURCE_DIALECT_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, sourceDialect_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(query_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, query_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (sourceDialect_
        != com.google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest
            .SqlTranslationSourceDialect.SQL_TRANSLATION_SOURCE_DIALECT_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, sourceDialect_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(query_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, query_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest other =
        (com.google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (sourceDialect_ != other.sourceDialect_) return false;
    if (!getQuery().equals(other.getQuery())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + SOURCE_DIALECT_FIELD_NUMBER;
    hash = (53 * hash) + sourceDialect_;
    hash = (37 * hash) + QUERY_FIELD_NUMBER;
    hash = (53 * hash) + getQuery().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The request of translating a SQL query to Standard SQL.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest)
      com.google.cloud.bigquery.migration.v2alpha.TranslateQueryRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.migration.v2alpha.TranslationServiceProto
          .internal_static_google_cloud_bigquery_migration_v2alpha_TranslateQueryRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.migration.v2alpha.TranslationServiceProto
          .internal_static_google_cloud_bigquery_migration_v2alpha_TranslateQueryRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest.class,
              com.google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest.Builder.class);
    }

    // Construct using
    // com.google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      sourceDialect_ = 0;
      query_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.bigquery.migration.v2alpha.TranslationServiceProto
          .internal_static_google_cloud_bigquery_migration_v2alpha_TranslateQueryRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest
        getDefaultInstanceForType() {
      return com.google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest build() {
      com.google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest buildPartial() {
      com.google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest result =
          new com.google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.sourceDialect_ = sourceDialect_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.query_ = query_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest) {
        return mergeFrom((com.google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest other) {
      if (other
          == com.google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.sourceDialect_ != 0) {
        setSourceDialectValue(other.getSourceDialectValue());
      }
      if (!other.getQuery().isEmpty()) {
        query_ = other.query_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                sourceDialect_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                query_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the project to which this translation request belongs.
     * Example: `projects/foo/locations/bar`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the project to which this translation request belongs.
     * Example: `projects/foo/locations/bar`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the project to which this translation request belongs.
     * Example: `projects/foo/locations/bar`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the project to which this translation request belongs.
     * Example: `projects/foo/locations/bar`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the project to which this translation request belongs.
     * Example: `projects/foo/locations/bar`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int sourceDialect_ = 0;
    /**
     *
     *
     * <pre>
     * Required. The source SQL dialect of `queries`.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest.SqlTranslationSourceDialect source_dialect = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for sourceDialect.
     */
    @java.lang.Override
    public int getSourceDialectValue() {
      return sourceDialect_;
    }
    /**
     *
     *
     * <pre>
     * Required. The source SQL dialect of `queries`.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest.SqlTranslationSourceDialect source_dialect = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enum numeric value on the wire for sourceDialect to set.
     * @return This builder for chaining.
     */
    public Builder setSourceDialectValue(int value) {
      sourceDialect_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The source SQL dialect of `queries`.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest.SqlTranslationSourceDialect source_dialect = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The sourceDialect.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest
            .SqlTranslationSourceDialect
        getSourceDialect() {
      com.google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest.SqlTranslationSourceDialect
          result =
              com.google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest
                  .SqlTranslationSourceDialect.forNumber(sourceDialect_);
      return result == null
          ? com.google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest
              .SqlTranslationSourceDialect.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Required. The source SQL dialect of `queries`.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest.SqlTranslationSourceDialect source_dialect = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The sourceDialect to set.
     * @return This builder for chaining.
     */
    public Builder setSourceDialect(
        com.google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest
                .SqlTranslationSourceDialect
            value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      sourceDialect_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The source SQL dialect of `queries`.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest.SqlTranslationSourceDialect source_dialect = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceDialect() {
      bitField0_ = (bitField0_ & ~0x00000002);
      sourceDialect_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object query_ = "";
    /**
     *
     *
     * <pre>
     * Required. The query to be translated.
     * </pre>
     *
     * <code>string query = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The query.
     */
    public java.lang.String getQuery() {
      java.lang.Object ref = query_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        query_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The query to be translated.
     * </pre>
     *
     * <code>string query = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for query.
     */
    public com.google.protobuf.ByteString getQueryBytes() {
      java.lang.Object ref = query_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        query_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The query to be translated.
     * </pre>
     *
     * <code>string query = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The query to set.
     * @return This builder for chaining.
     */
    public Builder setQuery(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      query_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The query to be translated.
     * </pre>
     *
     * <code>string query = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearQuery() {
      query_ = getDefaultInstance().getQuery();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The query to be translated.
     * </pre>
     *
     * <code>string query = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for query to set.
     * @return This builder for chaining.
     */
    public Builder setQueryBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      query_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest)
  private static final com.google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest();
  }

  public static com.google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TranslateQueryRequest> PARSER =
      new com.google.protobuf.AbstractParser<TranslateQueryRequest>() {
        @java.lang.Override
        public TranslateQueryRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TranslateQueryRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TranslateQueryRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
