/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/migration/v2alpha/translation_service.proto

package com.google.cloud.bigquery.migration.v2alpha;

/**
 *
 *
 * <pre>
 * The response of translating a SQL query to Standard SQL.
 * </pre>
 *
 * Protobuf type {@code google.cloud.bigquery.migration.v2alpha.TranslateQueryResponse}
 */
public final class TranslateQueryResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.bigquery.migration.v2alpha.TranslateQueryResponse)
    TranslateQueryResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TranslateQueryResponse.newBuilder() to construct.
  private TranslateQueryResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TranslateQueryResponse() {
    translationJob_ = "";
    translatedQuery_ = "";
    errors_ = java.util.Collections.emptyList();
    warnings_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TranslateQueryResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.bigquery.migration.v2alpha.TranslationServiceProto
        .internal_static_google_cloud_bigquery_migration_v2alpha_TranslateQueryResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.bigquery.migration.v2alpha.TranslationServiceProto
        .internal_static_google_cloud_bigquery_migration_v2alpha_TranslateQueryResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.bigquery.migration.v2alpha.TranslateQueryResponse.class,
            com.google.cloud.bigquery.migration.v2alpha.TranslateQueryResponse.Builder.class);
  }

  public static final int TRANSLATION_JOB_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object translationJob_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Immutable. The unique identifier for the SQL translation job.
   * Example: `projects/123/locations/us/translation/1234`
   * </pre>
   *
   * <code>
   * string translation_job = 4 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The translationJob.
   */
  @java.lang.Override
  public java.lang.String getTranslationJob() {
    java.lang.Object ref = translationJob_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      translationJob_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Immutable. The unique identifier for the SQL translation job.
   * Example: `projects/123/locations/us/translation/1234`
   * </pre>
   *
   * <code>
   * string translation_job = 4 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The bytes for translationJob.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTranslationJobBytes() {
    java.lang.Object ref = translationJob_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      translationJob_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TRANSLATED_QUERY_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object translatedQuery_ = "";
  /**
   *
   *
   * <pre>
   * The translated result. This will be empty if the translation fails.
   * </pre>
   *
   * <code>string translated_query = 1;</code>
   *
   * @return The translatedQuery.
   */
  @java.lang.Override
  public java.lang.String getTranslatedQuery() {
    java.lang.Object ref = translatedQuery_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      translatedQuery_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The translated result. This will be empty if the translation fails.
   * </pre>
   *
   * <code>string translated_query = 1;</code>
   *
   * @return The bytes for translatedQuery.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTranslatedQueryBytes() {
    java.lang.Object ref = translatedQuery_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      translatedQuery_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ERRORS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.bigquery.migration.v2alpha.SqlTranslationError> errors_;
  /**
   *
   *
   * <pre>
   * The list of errors encountered during the translation, if present.
   * </pre>
   *
   * <code>repeated .google.cloud.bigquery.migration.v2alpha.SqlTranslationError errors = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.bigquery.migration.v2alpha.SqlTranslationError>
      getErrorsList() {
    return errors_;
  }
  /**
   *
   *
   * <pre>
   * The list of errors encountered during the translation, if present.
   * </pre>
   *
   * <code>repeated .google.cloud.bigquery.migration.v2alpha.SqlTranslationError errors = 2;</code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.bigquery.migration.v2alpha.SqlTranslationErrorOrBuilder>
      getErrorsOrBuilderList() {
    return errors_;
  }
  /**
   *
   *
   * <pre>
   * The list of errors encountered during the translation, if present.
   * </pre>
   *
   * <code>repeated .google.cloud.bigquery.migration.v2alpha.SqlTranslationError errors = 2;</code>
   */
  @java.lang.Override
  public int getErrorsCount() {
    return errors_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of errors encountered during the translation, if present.
   * </pre>
   *
   * <code>repeated .google.cloud.bigquery.migration.v2alpha.SqlTranslationError errors = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2alpha.SqlTranslationError getErrors(int index) {
    return errors_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The list of errors encountered during the translation, if present.
   * </pre>
   *
   * <code>repeated .google.cloud.bigquery.migration.v2alpha.SqlTranslationError errors = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2alpha.SqlTranslationErrorOrBuilder
      getErrorsOrBuilder(int index) {
    return errors_.get(index);
  }

  public static final int WARNINGS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.bigquery.migration.v2alpha.SqlTranslationWarning>
      warnings_;
  /**
   *
   *
   * <pre>
   * The list of warnings encountered during the translation, if present,
   * indicates non-semantically correct translation.
   * </pre>
   *
   * <code>repeated .google.cloud.bigquery.migration.v2alpha.SqlTranslationWarning warnings = 3;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.bigquery.migration.v2alpha.SqlTranslationWarning>
      getWarningsList() {
    return warnings_;
  }
  /**
   *
   *
   * <pre>
   * The list of warnings encountered during the translation, if present,
   * indicates non-semantically correct translation.
   * </pre>
   *
   * <code>repeated .google.cloud.bigquery.migration.v2alpha.SqlTranslationWarning warnings = 3;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.bigquery.migration.v2alpha.SqlTranslationWarningOrBuilder>
      getWarningsOrBuilderList() {
    return warnings_;
  }
  /**
   *
   *
   * <pre>
   * The list of warnings encountered during the translation, if present,
   * indicates non-semantically correct translation.
   * </pre>
   *
   * <code>repeated .google.cloud.bigquery.migration.v2alpha.SqlTranslationWarning warnings = 3;
   * </code>
   */
  @java.lang.Override
  public int getWarningsCount() {
    return warnings_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of warnings encountered during the translation, if present,
   * indicates non-semantically correct translation.
   * </pre>
   *
   * <code>repeated .google.cloud.bigquery.migration.v2alpha.SqlTranslationWarning warnings = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2alpha.SqlTranslationWarning getWarnings(int index) {
    return warnings_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The list of warnings encountered during the translation, if present,
   * indicates non-semantically correct translation.
   * </pre>
   *
   * <code>repeated .google.cloud.bigquery.migration.v2alpha.SqlTranslationWarning warnings = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2alpha.SqlTranslationWarningOrBuilder
      getWarningsOrBuilder(int index) {
    return warnings_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(translatedQuery_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, translatedQuery_);
    }
    for (int i = 0; i < errors_.size(); i++) {
      output.writeMessage(2, errors_.get(i));
    }
    for (int i = 0; i < warnings_.size(); i++) {
      output.writeMessage(3, warnings_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(translationJob_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, translationJob_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(translatedQuery_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, translatedQuery_);
    }
    for (int i = 0; i < errors_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, errors_.get(i));
    }
    for (int i = 0; i < warnings_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, warnings_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(translationJob_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, translationJob_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.bigquery.migration.v2alpha.TranslateQueryResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.bigquery.migration.v2alpha.TranslateQueryResponse other =
        (com.google.cloud.bigquery.migration.v2alpha.TranslateQueryResponse) obj;

    if (!getTranslationJob().equals(other.getTranslationJob())) return false;
    if (!getTranslatedQuery().equals(other.getTranslatedQuery())) return false;
    if (!getErrorsList().equals(other.getErrorsList())) return false;
    if (!getWarningsList().equals(other.getWarningsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TRANSLATION_JOB_FIELD_NUMBER;
    hash = (53 * hash) + getTranslationJob().hashCode();
    hash = (37 * hash) + TRANSLATED_QUERY_FIELD_NUMBER;
    hash = (53 * hash) + getTranslatedQuery().hashCode();
    if (getErrorsCount() > 0) {
      hash = (37 * hash) + ERRORS_FIELD_NUMBER;
      hash = (53 * hash) + getErrorsList().hashCode();
    }
    if (getWarningsCount() > 0) {
      hash = (37 * hash) + WARNINGS_FIELD_NUMBER;
      hash = (53 * hash) + getWarningsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.bigquery.migration.v2alpha.TranslateQueryResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.TranslateQueryResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.TranslateQueryResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.TranslateQueryResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.TranslateQueryResponse parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.TranslateQueryResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.TranslateQueryResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.TranslateQueryResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.TranslateQueryResponse
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.TranslateQueryResponse
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.TranslateQueryResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.TranslateQueryResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.bigquery.migration.v2alpha.TranslateQueryResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The response of translating a SQL query to Standard SQL.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.migration.v2alpha.TranslateQueryResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.migration.v2alpha.TranslateQueryResponse)
      com.google.cloud.bigquery.migration.v2alpha.TranslateQueryResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.migration.v2alpha.TranslationServiceProto
          .internal_static_google_cloud_bigquery_migration_v2alpha_TranslateQueryResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.migration.v2alpha.TranslationServiceProto
          .internal_static_google_cloud_bigquery_migration_v2alpha_TranslateQueryResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.migration.v2alpha.TranslateQueryResponse.class,
              com.google.cloud.bigquery.migration.v2alpha.TranslateQueryResponse.Builder.class);
    }

    // Construct using
    // com.google.cloud.bigquery.migration.v2alpha.TranslateQueryResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      translationJob_ = "";
      translatedQuery_ = "";
      if (errorsBuilder_ == null) {
        errors_ = java.util.Collections.emptyList();
      } else {
        errors_ = null;
        errorsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      if (warningsBuilder_ == null) {
        warnings_ = java.util.Collections.emptyList();
      } else {
        warnings_ = null;
        warningsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.bigquery.migration.v2alpha.TranslationServiceProto
          .internal_static_google_cloud_bigquery_migration_v2alpha_TranslateQueryResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2alpha.TranslateQueryResponse
        getDefaultInstanceForType() {
      return com.google.cloud.bigquery.migration.v2alpha.TranslateQueryResponse
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2alpha.TranslateQueryResponse build() {
      com.google.cloud.bigquery.migration.v2alpha.TranslateQueryResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2alpha.TranslateQueryResponse buildPartial() {
      com.google.cloud.bigquery.migration.v2alpha.TranslateQueryResponse result =
          new com.google.cloud.bigquery.migration.v2alpha.TranslateQueryResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.bigquery.migration.v2alpha.TranslateQueryResponse result) {
      if (errorsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          errors_ = java.util.Collections.unmodifiableList(errors_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.errors_ = errors_;
      } else {
        result.errors_ = errorsBuilder_.build();
      }
      if (warningsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          warnings_ = java.util.Collections.unmodifiableList(warnings_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.warnings_ = warnings_;
      } else {
        result.warnings_ = warningsBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.bigquery.migration.v2alpha.TranslateQueryResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.translationJob_ = translationJob_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.translatedQuery_ = translatedQuery_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.bigquery.migration.v2alpha.TranslateQueryResponse) {
        return mergeFrom(
            (com.google.cloud.bigquery.migration.v2alpha.TranslateQueryResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.bigquery.migration.v2alpha.TranslateQueryResponse other) {
      if (other
          == com.google.cloud.bigquery.migration.v2alpha.TranslateQueryResponse
              .getDefaultInstance()) return this;
      if (!other.getTranslationJob().isEmpty()) {
        translationJob_ = other.translationJob_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getTranslatedQuery().isEmpty()) {
        translatedQuery_ = other.translatedQuery_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (errorsBuilder_ == null) {
        if (!other.errors_.isEmpty()) {
          if (errors_.isEmpty()) {
            errors_ = other.errors_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureErrorsIsMutable();
            errors_.addAll(other.errors_);
          }
          onChanged();
        }
      } else {
        if (!other.errors_.isEmpty()) {
          if (errorsBuilder_.isEmpty()) {
            errorsBuilder_.dispose();
            errorsBuilder_ = null;
            errors_ = other.errors_;
            bitField0_ = (bitField0_ & ~0x00000004);
            errorsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getErrorsFieldBuilder()
                    : null;
          } else {
            errorsBuilder_.addAllMessages(other.errors_);
          }
        }
      }
      if (warningsBuilder_ == null) {
        if (!other.warnings_.isEmpty()) {
          if (warnings_.isEmpty()) {
            warnings_ = other.warnings_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureWarningsIsMutable();
            warnings_.addAll(other.warnings_);
          }
          onChanged();
        }
      } else {
        if (!other.warnings_.isEmpty()) {
          if (warningsBuilder_.isEmpty()) {
            warningsBuilder_.dispose();
            warningsBuilder_ = null;
            warnings_ = other.warnings_;
            bitField0_ = (bitField0_ & ~0x00000008);
            warningsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getWarningsFieldBuilder()
                    : null;
          } else {
            warningsBuilder_.addAllMessages(other.warnings_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                translatedQuery_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.bigquery.migration.v2alpha.SqlTranslationError m =
                    input.readMessage(
                        com.google.cloud.bigquery.migration.v2alpha.SqlTranslationError.parser(),
                        extensionRegistry);
                if (errorsBuilder_ == null) {
                  ensureErrorsIsMutable();
                  errors_.add(m);
                } else {
                  errorsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                com.google.cloud.bigquery.migration.v2alpha.SqlTranslationWarning m =
                    input.readMessage(
                        com.google.cloud.bigquery.migration.v2alpha.SqlTranslationWarning.parser(),
                        extensionRegistry);
                if (warningsBuilder_ == null) {
                  ensureWarningsIsMutable();
                  warnings_.add(m);
                } else {
                  warningsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 34:
              {
                translationJob_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object translationJob_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The unique identifier for the SQL translation job.
     * Example: `projects/123/locations/us/translation/1234`
     * </pre>
     *
     * <code>
     * string translation_job = 4 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The translationJob.
     */
    public java.lang.String getTranslationJob() {
      java.lang.Object ref = translationJob_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        translationJob_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The unique identifier for the SQL translation job.
     * Example: `projects/123/locations/us/translation/1234`
     * </pre>
     *
     * <code>
     * string translation_job = 4 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The bytes for translationJob.
     */
    public com.google.protobuf.ByteString getTranslationJobBytes() {
      java.lang.Object ref = translationJob_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        translationJob_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The unique identifier for the SQL translation job.
     * Example: `projects/123/locations/us/translation/1234`
     * </pre>
     *
     * <code>
     * string translation_job = 4 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The translationJob to set.
     * @return This builder for chaining.
     */
    public Builder setTranslationJob(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      translationJob_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The unique identifier for the SQL translation job.
     * Example: `projects/123/locations/us/translation/1234`
     * </pre>
     *
     * <code>
     * string translation_job = 4 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTranslationJob() {
      translationJob_ = getDefaultInstance().getTranslationJob();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The unique identifier for the SQL translation job.
     * Example: `projects/123/locations/us/translation/1234`
     * </pre>
     *
     * <code>
     * string translation_job = 4 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The bytes for translationJob to set.
     * @return This builder for chaining.
     */
    public Builder setTranslationJobBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      translationJob_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object translatedQuery_ = "";
    /**
     *
     *
     * <pre>
     * The translated result. This will be empty if the translation fails.
     * </pre>
     *
     * <code>string translated_query = 1;</code>
     *
     * @return The translatedQuery.
     */
    public java.lang.String getTranslatedQuery() {
      java.lang.Object ref = translatedQuery_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        translatedQuery_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The translated result. This will be empty if the translation fails.
     * </pre>
     *
     * <code>string translated_query = 1;</code>
     *
     * @return The bytes for translatedQuery.
     */
    public com.google.protobuf.ByteString getTranslatedQueryBytes() {
      java.lang.Object ref = translatedQuery_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        translatedQuery_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The translated result. This will be empty if the translation fails.
     * </pre>
     *
     * <code>string translated_query = 1;</code>
     *
     * @param value The translatedQuery to set.
     * @return This builder for chaining.
     */
    public Builder setTranslatedQuery(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      translatedQuery_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The translated result. This will be empty if the translation fails.
     * </pre>
     *
     * <code>string translated_query = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTranslatedQuery() {
      translatedQuery_ = getDefaultInstance().getTranslatedQuery();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The translated result. This will be empty if the translation fails.
     * </pre>
     *
     * <code>string translated_query = 1;</code>
     *
     * @param value The bytes for translatedQuery to set.
     * @return This builder for chaining.
     */
    public Builder setTranslatedQueryBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      translatedQuery_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.bigquery.migration.v2alpha.SqlTranslationError>
        errors_ = java.util.Collections.emptyList();

    private void ensureErrorsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        errors_ =
            new java.util.ArrayList<
                com.google.cloud.bigquery.migration.v2alpha.SqlTranslationError>(errors_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2alpha.SqlTranslationError,
            com.google.cloud.bigquery.migration.v2alpha.SqlTranslationError.Builder,
            com.google.cloud.bigquery.migration.v2alpha.SqlTranslationErrorOrBuilder>
        errorsBuilder_;

    /**
     *
     *
     * <pre>
     * The list of errors encountered during the translation, if present.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.migration.v2alpha.SqlTranslationError errors = 2;
     * </code>
     */
    public java.util.List<com.google.cloud.bigquery.migration.v2alpha.SqlTranslationError>
        getErrorsList() {
      if (errorsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(errors_);
      } else {
        return errorsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of errors encountered during the translation, if present.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.migration.v2alpha.SqlTranslationError errors = 2;
     * </code>
     */
    public int getErrorsCount() {
      if (errorsBuilder_ == null) {
        return errors_.size();
      } else {
        return errorsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of errors encountered during the translation, if present.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.migration.v2alpha.SqlTranslationError errors = 2;
     * </code>
     */
    public com.google.cloud.bigquery.migration.v2alpha.SqlTranslationError getErrors(int index) {
      if (errorsBuilder_ == null) {
        return errors_.get(index);
      } else {
        return errorsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of errors encountered during the translation, if present.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.migration.v2alpha.SqlTranslationError errors = 2;
     * </code>
     */
    public Builder setErrors(
        int index, com.google.cloud.bigquery.migration.v2alpha.SqlTranslationError value) {
      if (errorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureErrorsIsMutable();
        errors_.set(index, value);
        onChanged();
      } else {
        errorsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of errors encountered during the translation, if present.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.migration.v2alpha.SqlTranslationError errors = 2;
     * </code>
     */
    public Builder setErrors(
        int index,
        com.google.cloud.bigquery.migration.v2alpha.SqlTranslationError.Builder builderForValue) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        errors_.set(index, builderForValue.build());
        onChanged();
      } else {
        errorsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of errors encountered during the translation, if present.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.migration.v2alpha.SqlTranslationError errors = 2;
     * </code>
     */
    public Builder addErrors(
        com.google.cloud.bigquery.migration.v2alpha.SqlTranslationError value) {
      if (errorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureErrorsIsMutable();
        errors_.add(value);
        onChanged();
      } else {
        errorsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of errors encountered during the translation, if present.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.migration.v2alpha.SqlTranslationError errors = 2;
     * </code>
     */
    public Builder addErrors(
        int index, com.google.cloud.bigquery.migration.v2alpha.SqlTranslationError value) {
      if (errorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureErrorsIsMutable();
        errors_.add(index, value);
        onChanged();
      } else {
        errorsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of errors encountered during the translation, if present.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.migration.v2alpha.SqlTranslationError errors = 2;
     * </code>
     */
    public Builder addErrors(
        com.google.cloud.bigquery.migration.v2alpha.SqlTranslationError.Builder builderForValue) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        errors_.add(builderForValue.build());
        onChanged();
      } else {
        errorsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of errors encountered during the translation, if present.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.migration.v2alpha.SqlTranslationError errors = 2;
     * </code>
     */
    public Builder addErrors(
        int index,
        com.google.cloud.bigquery.migration.v2alpha.SqlTranslationError.Builder builderForValue) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        errors_.add(index, builderForValue.build());
        onChanged();
      } else {
        errorsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of errors encountered during the translation, if present.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.migration.v2alpha.SqlTranslationError errors = 2;
     * </code>
     */
    public Builder addAllErrors(
        java.lang.Iterable<
                ? extends com.google.cloud.bigquery.migration.v2alpha.SqlTranslationError>
            values) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, errors_);
        onChanged();
      } else {
        errorsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of errors encountered during the translation, if present.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.migration.v2alpha.SqlTranslationError errors = 2;
     * </code>
     */
    public Builder clearErrors() {
      if (errorsBuilder_ == null) {
        errors_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        errorsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of errors encountered during the translation, if present.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.migration.v2alpha.SqlTranslationError errors = 2;
     * </code>
     */
    public Builder removeErrors(int index) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        errors_.remove(index);
        onChanged();
      } else {
        errorsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of errors encountered during the translation, if present.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.migration.v2alpha.SqlTranslationError errors = 2;
     * </code>
     */
    public com.google.cloud.bigquery.migration.v2alpha.SqlTranslationError.Builder getErrorsBuilder(
        int index) {
      return getErrorsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The list of errors encountered during the translation, if present.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.migration.v2alpha.SqlTranslationError errors = 2;
     * </code>
     */
    public com.google.cloud.bigquery.migration.v2alpha.SqlTranslationErrorOrBuilder
        getErrorsOrBuilder(int index) {
      if (errorsBuilder_ == null) {
        return errors_.get(index);
      } else {
        return errorsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of errors encountered during the translation, if present.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.migration.v2alpha.SqlTranslationError errors = 2;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.bigquery.migration.v2alpha.SqlTranslationErrorOrBuilder>
        getErrorsOrBuilderList() {
      if (errorsBuilder_ != null) {
        return errorsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(errors_);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of errors encountered during the translation, if present.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.migration.v2alpha.SqlTranslationError errors = 2;
     * </code>
     */
    public com.google.cloud.bigquery.migration.v2alpha.SqlTranslationError.Builder
        addErrorsBuilder() {
      return getErrorsFieldBuilder()
          .addBuilder(
              com.google.cloud.bigquery.migration.v2alpha.SqlTranslationError.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of errors encountered during the translation, if present.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.migration.v2alpha.SqlTranslationError errors = 2;
     * </code>
     */
    public com.google.cloud.bigquery.migration.v2alpha.SqlTranslationError.Builder addErrorsBuilder(
        int index) {
      return getErrorsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.bigquery.migration.v2alpha.SqlTranslationError.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of errors encountered during the translation, if present.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.migration.v2alpha.SqlTranslationError errors = 2;
     * </code>
     */
    public java.util.List<com.google.cloud.bigquery.migration.v2alpha.SqlTranslationError.Builder>
        getErrorsBuilderList() {
      return getErrorsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2alpha.SqlTranslationError,
            com.google.cloud.bigquery.migration.v2alpha.SqlTranslationError.Builder,
            com.google.cloud.bigquery.migration.v2alpha.SqlTranslationErrorOrBuilder>
        getErrorsFieldBuilder() {
      if (errorsBuilder_ == null) {
        errorsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.bigquery.migration.v2alpha.SqlTranslationError,
                com.google.cloud.bigquery.migration.v2alpha.SqlTranslationError.Builder,
                com.google.cloud.bigquery.migration.v2alpha.SqlTranslationErrorOrBuilder>(
                errors_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        errors_ = null;
      }
      return errorsBuilder_;
    }

    private java.util.List<com.google.cloud.bigquery.migration.v2alpha.SqlTranslationWarning>
        warnings_ = java.util.Collections.emptyList();

    private void ensureWarningsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        warnings_ =
            new java.util.ArrayList<
                com.google.cloud.bigquery.migration.v2alpha.SqlTranslationWarning>(warnings_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2alpha.SqlTranslationWarning,
            com.google.cloud.bigquery.migration.v2alpha.SqlTranslationWarning.Builder,
            com.google.cloud.bigquery.migration.v2alpha.SqlTranslationWarningOrBuilder>
        warningsBuilder_;

    /**
     *
     *
     * <pre>
     * The list of warnings encountered during the translation, if present,
     * indicates non-semantically correct translation.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.migration.v2alpha.SqlTranslationWarning warnings = 3;
     * </code>
     */
    public java.util.List<com.google.cloud.bigquery.migration.v2alpha.SqlTranslationWarning>
        getWarningsList() {
      if (warningsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(warnings_);
      } else {
        return warningsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of warnings encountered during the translation, if present,
     * indicates non-semantically correct translation.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.migration.v2alpha.SqlTranslationWarning warnings = 3;
     * </code>
     */
    public int getWarningsCount() {
      if (warningsBuilder_ == null) {
        return warnings_.size();
      } else {
        return warningsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of warnings encountered during the translation, if present,
     * indicates non-semantically correct translation.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.migration.v2alpha.SqlTranslationWarning warnings = 3;
     * </code>
     */
    public com.google.cloud.bigquery.migration.v2alpha.SqlTranslationWarning getWarnings(
        int index) {
      if (warningsBuilder_ == null) {
        return warnings_.get(index);
      } else {
        return warningsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of warnings encountered during the translation, if present,
     * indicates non-semantically correct translation.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.migration.v2alpha.SqlTranslationWarning warnings = 3;
     * </code>
     */
    public Builder setWarnings(
        int index, com.google.cloud.bigquery.migration.v2alpha.SqlTranslationWarning value) {
      if (warningsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWarningsIsMutable();
        warnings_.set(index, value);
        onChanged();
      } else {
        warningsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of warnings encountered during the translation, if present,
     * indicates non-semantically correct translation.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.migration.v2alpha.SqlTranslationWarning warnings = 3;
     * </code>
     */
    public Builder setWarnings(
        int index,
        com.google.cloud.bigquery.migration.v2alpha.SqlTranslationWarning.Builder builderForValue) {
      if (warningsBuilder_ == null) {
        ensureWarningsIsMutable();
        warnings_.set(index, builderForValue.build());
        onChanged();
      } else {
        warningsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of warnings encountered during the translation, if present,
     * indicates non-semantically correct translation.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.migration.v2alpha.SqlTranslationWarning warnings = 3;
     * </code>
     */
    public Builder addWarnings(
        com.google.cloud.bigquery.migration.v2alpha.SqlTranslationWarning value) {
      if (warningsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWarningsIsMutable();
        warnings_.add(value);
        onChanged();
      } else {
        warningsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of warnings encountered during the translation, if present,
     * indicates non-semantically correct translation.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.migration.v2alpha.SqlTranslationWarning warnings = 3;
     * </code>
     */
    public Builder addWarnings(
        int index, com.google.cloud.bigquery.migration.v2alpha.SqlTranslationWarning value) {
      if (warningsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWarningsIsMutable();
        warnings_.add(index, value);
        onChanged();
      } else {
        warningsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of warnings encountered during the translation, if present,
     * indicates non-semantically correct translation.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.migration.v2alpha.SqlTranslationWarning warnings = 3;
     * </code>
     */
    public Builder addWarnings(
        com.google.cloud.bigquery.migration.v2alpha.SqlTranslationWarning.Builder builderForValue) {
      if (warningsBuilder_ == null) {
        ensureWarningsIsMutable();
        warnings_.add(builderForValue.build());
        onChanged();
      } else {
        warningsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of warnings encountered during the translation, if present,
     * indicates non-semantically correct translation.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.migration.v2alpha.SqlTranslationWarning warnings = 3;
     * </code>
     */
    public Builder addWarnings(
        int index,
        com.google.cloud.bigquery.migration.v2alpha.SqlTranslationWarning.Builder builderForValue) {
      if (warningsBuilder_ == null) {
        ensureWarningsIsMutable();
        warnings_.add(index, builderForValue.build());
        onChanged();
      } else {
        warningsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of warnings encountered during the translation, if present,
     * indicates non-semantically correct translation.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.migration.v2alpha.SqlTranslationWarning warnings = 3;
     * </code>
     */
    public Builder addAllWarnings(
        java.lang.Iterable<
                ? extends com.google.cloud.bigquery.migration.v2alpha.SqlTranslationWarning>
            values) {
      if (warningsBuilder_ == null) {
        ensureWarningsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, warnings_);
        onChanged();
      } else {
        warningsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of warnings encountered during the translation, if present,
     * indicates non-semantically correct translation.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.migration.v2alpha.SqlTranslationWarning warnings = 3;
     * </code>
     */
    public Builder clearWarnings() {
      if (warningsBuilder_ == null) {
        warnings_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        warningsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of warnings encountered during the translation, if present,
     * indicates non-semantically correct translation.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.migration.v2alpha.SqlTranslationWarning warnings = 3;
     * </code>
     */
    public Builder removeWarnings(int index) {
      if (warningsBuilder_ == null) {
        ensureWarningsIsMutable();
        warnings_.remove(index);
        onChanged();
      } else {
        warningsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of warnings encountered during the translation, if present,
     * indicates non-semantically correct translation.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.migration.v2alpha.SqlTranslationWarning warnings = 3;
     * </code>
     */
    public com.google.cloud.bigquery.migration.v2alpha.SqlTranslationWarning.Builder
        getWarningsBuilder(int index) {
      return getWarningsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The list of warnings encountered during the translation, if present,
     * indicates non-semantically correct translation.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.migration.v2alpha.SqlTranslationWarning warnings = 3;
     * </code>
     */
    public com.google.cloud.bigquery.migration.v2alpha.SqlTranslationWarningOrBuilder
        getWarningsOrBuilder(int index) {
      if (warningsBuilder_ == null) {
        return warnings_.get(index);
      } else {
        return warningsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of warnings encountered during the translation, if present,
     * indicates non-semantically correct translation.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.migration.v2alpha.SqlTranslationWarning warnings = 3;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.bigquery.migration.v2alpha.SqlTranslationWarningOrBuilder>
        getWarningsOrBuilderList() {
      if (warningsBuilder_ != null) {
        return warningsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(warnings_);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of warnings encountered during the translation, if present,
     * indicates non-semantically correct translation.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.migration.v2alpha.SqlTranslationWarning warnings = 3;
     * </code>
     */
    public com.google.cloud.bigquery.migration.v2alpha.SqlTranslationWarning.Builder
        addWarningsBuilder() {
      return getWarningsFieldBuilder()
          .addBuilder(
              com.google.cloud.bigquery.migration.v2alpha.SqlTranslationWarning
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of warnings encountered during the translation, if present,
     * indicates non-semantically correct translation.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.migration.v2alpha.SqlTranslationWarning warnings = 3;
     * </code>
     */
    public com.google.cloud.bigquery.migration.v2alpha.SqlTranslationWarning.Builder
        addWarningsBuilder(int index) {
      return getWarningsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.bigquery.migration.v2alpha.SqlTranslationWarning
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of warnings encountered during the translation, if present,
     * indicates non-semantically correct translation.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.migration.v2alpha.SqlTranslationWarning warnings = 3;
     * </code>
     */
    public java.util.List<com.google.cloud.bigquery.migration.v2alpha.SqlTranslationWarning.Builder>
        getWarningsBuilderList() {
      return getWarningsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2alpha.SqlTranslationWarning,
            com.google.cloud.bigquery.migration.v2alpha.SqlTranslationWarning.Builder,
            com.google.cloud.bigquery.migration.v2alpha.SqlTranslationWarningOrBuilder>
        getWarningsFieldBuilder() {
      if (warningsBuilder_ == null) {
        warningsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.bigquery.migration.v2alpha.SqlTranslationWarning,
                com.google.cloud.bigquery.migration.v2alpha.SqlTranslationWarning.Builder,
                com.google.cloud.bigquery.migration.v2alpha.SqlTranslationWarningOrBuilder>(
                warnings_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
        warnings_ = null;
      }
      return warningsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.migration.v2alpha.TranslateQueryResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.bigquery.migration.v2alpha.TranslateQueryResponse)
  private static final com.google.cloud.bigquery.migration.v2alpha.TranslateQueryResponse
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.bigquery.migration.v2alpha.TranslateQueryResponse();
  }

  public static com.google.cloud.bigquery.migration.v2alpha.TranslateQueryResponse
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TranslateQueryResponse> PARSER =
      new com.google.protobuf.AbstractParser<TranslateQueryResponse>() {
        @java.lang.Override
        public TranslateQueryResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TranslateQueryResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TranslateQueryResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2alpha.TranslateQueryResponse
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
