/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/migration/v2alpha/translation_task.proto

package com.google.cloud.bigquery.migration.v2alpha;

/**
 *
 *
 * <pre>
 * The translation task config to capture necessary settings for a translation
 * task and subtask.
 * </pre>
 *
 * Protobuf type {@code google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails}
 */
public final class TranslationTaskDetails extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails)
    TranslationTaskDetailsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TranslationTaskDetails.newBuilder() to construct.
  private TranslationTaskDetails(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TranslationTaskDetails() {
    inputPath_ = "";
    outputPath_ = "";
    filePaths_ = java.util.Collections.emptyList();
    schemaPath_ = "";
    fileEncoding_ = 0;
    translationExceptionTable_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TranslationTaskDetails();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.bigquery.migration.v2alpha.TranslationTaskProto
        .internal_static_google_cloud_bigquery_migration_v2alpha_TranslationTaskDetails_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 6:
        return internalGetSpecialTokenMap();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.bigquery.migration.v2alpha.TranslationTaskProto
        .internal_static_google_cloud_bigquery_migration_v2alpha_TranslationTaskDetails_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.class,
            com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The file encoding types.
   * </pre>
   *
   * Protobuf enum {@code
   * google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.FileEncoding}
   */
  public enum FileEncoding implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * File encoding setting is not specified.
     * </pre>
     *
     * <code>FILE_ENCODING_UNSPECIFIED = 0;</code>
     */
    FILE_ENCODING_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * File encoding is UTF_8.
     * </pre>
     *
     * <code>UTF_8 = 1;</code>
     */
    UTF_8(1),
    /**
     *
     *
     * <pre>
     * File encoding is ISO_8859_1.
     * </pre>
     *
     * <code>ISO_8859_1 = 2;</code>
     */
    ISO_8859_1(2),
    /**
     *
     *
     * <pre>
     * File encoding is US_ASCII.
     * </pre>
     *
     * <code>US_ASCII = 3;</code>
     */
    US_ASCII(3),
    /**
     *
     *
     * <pre>
     * File encoding is UTF_16.
     * </pre>
     *
     * <code>UTF_16 = 4;</code>
     */
    UTF_16(4),
    /**
     *
     *
     * <pre>
     * File encoding is UTF_16LE.
     * </pre>
     *
     * <code>UTF_16LE = 5;</code>
     */
    UTF_16LE(5),
    /**
     *
     *
     * <pre>
     * File encoding is UTF_16BE.
     * </pre>
     *
     * <code>UTF_16BE = 6;</code>
     */
    UTF_16BE(6),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * File encoding setting is not specified.
     * </pre>
     *
     * <code>FILE_ENCODING_UNSPECIFIED = 0;</code>
     */
    public static final int FILE_ENCODING_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * File encoding is UTF_8.
     * </pre>
     *
     * <code>UTF_8 = 1;</code>
     */
    public static final int UTF_8_VALUE = 1;
    /**
     *
     *
     * <pre>
     * File encoding is ISO_8859_1.
     * </pre>
     *
     * <code>ISO_8859_1 = 2;</code>
     */
    public static final int ISO_8859_1_VALUE = 2;
    /**
     *
     *
     * <pre>
     * File encoding is US_ASCII.
     * </pre>
     *
     * <code>US_ASCII = 3;</code>
     */
    public static final int US_ASCII_VALUE = 3;
    /**
     *
     *
     * <pre>
     * File encoding is UTF_16.
     * </pre>
     *
     * <code>UTF_16 = 4;</code>
     */
    public static final int UTF_16_VALUE = 4;
    /**
     *
     *
     * <pre>
     * File encoding is UTF_16LE.
     * </pre>
     *
     * <code>UTF_16LE = 5;</code>
     */
    public static final int UTF_16LE_VALUE = 5;
    /**
     *
     *
     * <pre>
     * File encoding is UTF_16BE.
     * </pre>
     *
     * <code>UTF_16BE = 6;</code>
     */
    public static final int UTF_16BE_VALUE = 6;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static FileEncoding valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static FileEncoding forNumber(int value) {
      switch (value) {
        case 0:
          return FILE_ENCODING_UNSPECIFIED;
        case 1:
          return UTF_8;
        case 2:
          return ISO_8859_1;
        case 3:
          return US_ASCII;
        case 4:
          return UTF_16;
        case 5:
          return UTF_16LE;
        case 6:
          return UTF_16BE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<FileEncoding> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<FileEncoding> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<FileEncoding>() {
          public FileEncoding findValueByNumber(int number) {
            return FileEncoding.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final FileEncoding[] VALUES = values();

    public static FileEncoding valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private FileEncoding(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.FileEncoding)
  }

  /**
   *
   *
   * <pre>
   * The special token data type.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.TokenType}
   */
  public enum TokenType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Token type is not specified.
     * </pre>
     *
     * <code>TOKEN_TYPE_UNSPECIFIED = 0;</code>
     */
    TOKEN_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Token type as string.
     * </pre>
     *
     * <code>STRING = 1;</code>
     */
    STRING(1),
    /**
     *
     *
     * <pre>
     * Token type as integer.
     * </pre>
     *
     * <code>INT64 = 2;</code>
     */
    INT64(2),
    /**
     *
     *
     * <pre>
     * Token type as numeric.
     * </pre>
     *
     * <code>NUMERIC = 3;</code>
     */
    NUMERIC(3),
    /**
     *
     *
     * <pre>
     * Token type as boolean.
     * </pre>
     *
     * <code>BOOL = 4;</code>
     */
    BOOL(4),
    /**
     *
     *
     * <pre>
     * Token type as float.
     * </pre>
     *
     * <code>FLOAT64 = 5;</code>
     */
    FLOAT64(5),
    /**
     *
     *
     * <pre>
     * Token type as date.
     * </pre>
     *
     * <code>DATE = 6;</code>
     */
    DATE(6),
    /**
     *
     *
     * <pre>
     * Token type as timestamp.
     * </pre>
     *
     * <code>TIMESTAMP = 7;</code>
     */
    TIMESTAMP(7),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Token type is not specified.
     * </pre>
     *
     * <code>TOKEN_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int TOKEN_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Token type as string.
     * </pre>
     *
     * <code>STRING = 1;</code>
     */
    public static final int STRING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Token type as integer.
     * </pre>
     *
     * <code>INT64 = 2;</code>
     */
    public static final int INT64_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Token type as numeric.
     * </pre>
     *
     * <code>NUMERIC = 3;</code>
     */
    public static final int NUMERIC_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Token type as boolean.
     * </pre>
     *
     * <code>BOOL = 4;</code>
     */
    public static final int BOOL_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Token type as float.
     * </pre>
     *
     * <code>FLOAT64 = 5;</code>
     */
    public static final int FLOAT64_VALUE = 5;
    /**
     *
     *
     * <pre>
     * Token type as date.
     * </pre>
     *
     * <code>DATE = 6;</code>
     */
    public static final int DATE_VALUE = 6;
    /**
     *
     *
     * <pre>
     * Token type as timestamp.
     * </pre>
     *
     * <code>TIMESTAMP = 7;</code>
     */
    public static final int TIMESTAMP_VALUE = 7;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TokenType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static TokenType forNumber(int value) {
      switch (value) {
        case 0:
          return TOKEN_TYPE_UNSPECIFIED;
        case 1:
          return STRING;
        case 2:
          return INT64;
        case 3:
          return NUMERIC;
        case 4:
          return BOOL;
        case 5:
          return FLOAT64;
        case 6:
          return DATE;
        case 7:
          return TIMESTAMP;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<TokenType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<TokenType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<TokenType>() {
          public TokenType findValueByNumber(int number) {
            return TokenType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.getDescriptor()
          .getEnumTypes()
          .get(1);
    }

    private static final TokenType[] VALUES = values();

    public static TokenType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private TokenType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.TokenType)
  }

  private int languageOptionsCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object languageOptions_;

  public enum LanguageOptionsCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    TERADATA_OPTIONS(10),
    BTEQ_OPTIONS(11),
    LANGUAGEOPTIONS_NOT_SET(0);
    private final int value;

    private LanguageOptionsCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static LanguageOptionsCase valueOf(int value) {
      return forNumber(value);
    }

    public static LanguageOptionsCase forNumber(int value) {
      switch (value) {
        case 10:
          return TERADATA_OPTIONS;
        case 11:
          return BTEQ_OPTIONS;
        case 0:
          return LANGUAGEOPTIONS_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public LanguageOptionsCase getLanguageOptionsCase() {
    return LanguageOptionsCase.forNumber(languageOptionsCase_);
  }

  public static final int TERADATA_OPTIONS_FIELD_NUMBER = 10;
  /**
   *
   *
   * <pre>
   * The Teradata SQL specific settings for the translation task.
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2alpha.TeradataOptions teradata_options = 10;</code>
   *
   * @return Whether the teradataOptions field is set.
   */
  @java.lang.Override
  public boolean hasTeradataOptions() {
    return languageOptionsCase_ == 10;
  }
  /**
   *
   *
   * <pre>
   * The Teradata SQL specific settings for the translation task.
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2alpha.TeradataOptions teradata_options = 10;</code>
   *
   * @return The teradataOptions.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2alpha.TeradataOptions getTeradataOptions() {
    if (languageOptionsCase_ == 10) {
      return (com.google.cloud.bigquery.migration.v2alpha.TeradataOptions) languageOptions_;
    }
    return com.google.cloud.bigquery.migration.v2alpha.TeradataOptions.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The Teradata SQL specific settings for the translation task.
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2alpha.TeradataOptions teradata_options = 10;</code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2alpha.TeradataOptionsOrBuilder
      getTeradataOptionsOrBuilder() {
    if (languageOptionsCase_ == 10) {
      return (com.google.cloud.bigquery.migration.v2alpha.TeradataOptions) languageOptions_;
    }
    return com.google.cloud.bigquery.migration.v2alpha.TeradataOptions.getDefaultInstance();
  }

  public static final int BTEQ_OPTIONS_FIELD_NUMBER = 11;
  /**
   *
   *
   * <pre>
   * The BTEQ specific settings for the translation task.
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2alpha.BteqOptions bteq_options = 11;</code>
   *
   * @return Whether the bteqOptions field is set.
   */
  @java.lang.Override
  public boolean hasBteqOptions() {
    return languageOptionsCase_ == 11;
  }
  /**
   *
   *
   * <pre>
   * The BTEQ specific settings for the translation task.
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2alpha.BteqOptions bteq_options = 11;</code>
   *
   * @return The bteqOptions.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2alpha.BteqOptions getBteqOptions() {
    if (languageOptionsCase_ == 11) {
      return (com.google.cloud.bigquery.migration.v2alpha.BteqOptions) languageOptions_;
    }
    return com.google.cloud.bigquery.migration.v2alpha.BteqOptions.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The BTEQ specific settings for the translation task.
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2alpha.BteqOptions bteq_options = 11;</code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2alpha.BteqOptionsOrBuilder
      getBteqOptionsOrBuilder() {
    if (languageOptionsCase_ == 11) {
      return (com.google.cloud.bigquery.migration.v2alpha.BteqOptions) languageOptions_;
    }
    return com.google.cloud.bigquery.migration.v2alpha.BteqOptions.getDefaultInstance();
  }

  public static final int INPUT_PATH_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object inputPath_ = "";
  /**
   *
   *
   * <pre>
   * The Cloud Storage path for translation input files.
   * </pre>
   *
   * <code>string input_path = 1;</code>
   *
   * @return The inputPath.
   */
  @java.lang.Override
  public java.lang.String getInputPath() {
    java.lang.Object ref = inputPath_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      inputPath_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The Cloud Storage path for translation input files.
   * </pre>
   *
   * <code>string input_path = 1;</code>
   *
   * @return The bytes for inputPath.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInputPathBytes() {
    java.lang.Object ref = inputPath_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      inputPath_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int OUTPUT_PATH_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object outputPath_ = "";
  /**
   *
   *
   * <pre>
   * The Cloud Storage path for translation output files.
   * </pre>
   *
   * <code>string output_path = 2;</code>
   *
   * @return The outputPath.
   */
  @java.lang.Override
  public java.lang.String getOutputPath() {
    java.lang.Object ref = outputPath_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      outputPath_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The Cloud Storage path for translation output files.
   * </pre>
   *
   * <code>string output_path = 2;</code>
   *
   * @return The bytes for outputPath.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOutputPathBytes() {
    java.lang.Object ref = outputPath_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      outputPath_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FILE_PATHS_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.bigquery.migration.v2alpha.TranslationFileMapping>
      filePaths_;
  /**
   *
   *
   * <pre>
   * Cloud Storage files to be processed for translation.
   * </pre>
   *
   * <code>repeated .google.cloud.bigquery.migration.v2alpha.TranslationFileMapping file_paths = 12;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.bigquery.migration.v2alpha.TranslationFileMapping>
      getFilePathsList() {
    return filePaths_;
  }
  /**
   *
   *
   * <pre>
   * Cloud Storage files to be processed for translation.
   * </pre>
   *
   * <code>repeated .google.cloud.bigquery.migration.v2alpha.TranslationFileMapping file_paths = 12;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.bigquery.migration.v2alpha.TranslationFileMappingOrBuilder>
      getFilePathsOrBuilderList() {
    return filePaths_;
  }
  /**
   *
   *
   * <pre>
   * Cloud Storage files to be processed for translation.
   * </pre>
   *
   * <code>repeated .google.cloud.bigquery.migration.v2alpha.TranslationFileMapping file_paths = 12;
   * </code>
   */
  @java.lang.Override
  public int getFilePathsCount() {
    return filePaths_.size();
  }
  /**
   *
   *
   * <pre>
   * Cloud Storage files to be processed for translation.
   * </pre>
   *
   * <code>repeated .google.cloud.bigquery.migration.v2alpha.TranslationFileMapping file_paths = 12;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2alpha.TranslationFileMapping getFilePaths(
      int index) {
    return filePaths_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Cloud Storage files to be processed for translation.
   * </pre>
   *
   * <code>repeated .google.cloud.bigquery.migration.v2alpha.TranslationFileMapping file_paths = 12;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2alpha.TranslationFileMappingOrBuilder
      getFilePathsOrBuilder(int index) {
    return filePaths_.get(index);
  }

  public static final int SCHEMA_PATH_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object schemaPath_ = "";
  /**
   *
   *
   * <pre>
   * The Cloud Storage path to DDL files as table schema to assist semantic
   * translation.
   * </pre>
   *
   * <code>string schema_path = 3;</code>
   *
   * @return The schemaPath.
   */
  @java.lang.Override
  public java.lang.String getSchemaPath() {
    java.lang.Object ref = schemaPath_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      schemaPath_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The Cloud Storage path to DDL files as table schema to assist semantic
   * translation.
   * </pre>
   *
   * <code>string schema_path = 3;</code>
   *
   * @return The bytes for schemaPath.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSchemaPathBytes() {
    java.lang.Object ref = schemaPath_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      schemaPath_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FILE_ENCODING_FIELD_NUMBER = 4;
  private int fileEncoding_ = 0;
  /**
   *
   *
   * <pre>
   * The file encoding type.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.FileEncoding file_encoding = 4;
   * </code>
   *
   * @return The enum numeric value on the wire for fileEncoding.
   */
  @java.lang.Override
  public int getFileEncodingValue() {
    return fileEncoding_;
  }
  /**
   *
   *
   * <pre>
   * The file encoding type.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.FileEncoding file_encoding = 4;
   * </code>
   *
   * @return The fileEncoding.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.FileEncoding
      getFileEncoding() {
    com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.FileEncoding result =
        com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.FileEncoding.forNumber(
            fileEncoding_);
    return result == null
        ? com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.FileEncoding
            .UNRECOGNIZED
        : result;
  }

  public static final int IDENTIFIER_SETTINGS_FIELD_NUMBER = 5;
  private com.google.cloud.bigquery.migration.v2alpha.IdentifierSettings identifierSettings_;
  /**
   *
   *
   * <pre>
   * The settings for SQL identifiers.
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2alpha.IdentifierSettings identifier_settings = 5;
   * </code>
   *
   * @return Whether the identifierSettings field is set.
   */
  @java.lang.Override
  public boolean hasIdentifierSettings() {
    return identifierSettings_ != null;
  }
  /**
   *
   *
   * <pre>
   * The settings for SQL identifiers.
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2alpha.IdentifierSettings identifier_settings = 5;
   * </code>
   *
   * @return The identifierSettings.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2alpha.IdentifierSettings getIdentifierSettings() {
    return identifierSettings_ == null
        ? com.google.cloud.bigquery.migration.v2alpha.IdentifierSettings.getDefaultInstance()
        : identifierSettings_;
  }
  /**
   *
   *
   * <pre>
   * The settings for SQL identifiers.
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2alpha.IdentifierSettings identifier_settings = 5;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2alpha.IdentifierSettingsOrBuilder
      getIdentifierSettingsOrBuilder() {
    return identifierSettings_ == null
        ? com.google.cloud.bigquery.migration.v2alpha.IdentifierSettings.getDefaultInstance()
        : identifierSettings_;
  }

  public static final int SPECIAL_TOKEN_MAP_FIELD_NUMBER = 6;

  private static final class SpecialTokenMapDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.Integer> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.Integer>newDefaultInstance(
            com.google.cloud.bigquery.migration.v2alpha.TranslationTaskProto
                .internal_static_google_cloud_bigquery_migration_v2alpha_TranslationTaskDetails_SpecialTokenMapEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.ENUM,
            com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.TokenType
                .TOKEN_TYPE_UNSPECIFIED
                .getNumber());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.Integer> specialTokenMap_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.Integer>
      internalGetSpecialTokenMap() {
    if (specialTokenMap_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          SpecialTokenMapDefaultEntryHolder.defaultEntry);
    }
    return specialTokenMap_;
  }

  private static final com.google.protobuf.Internal.MapAdapter.Converter<
          java.lang.Integer,
          com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.TokenType>
      specialTokenMapValueConverter =
          com.google.protobuf.Internal.MapAdapter.newEnumConverter(
              com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.TokenType
                  .internalGetValueMap(),
              com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.TokenType
                  .UNRECOGNIZED);

  private static final java.util.Map<
          java.lang.String,
          com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.TokenType>
      internalGetAdaptedSpecialTokenMapMap(java.util.Map<java.lang.String, java.lang.Integer> map) {
    return new com.google.protobuf.Internal.MapAdapter<
        java.lang.String,
        com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.TokenType,
        java.lang.Integer>(map, specialTokenMapValueConverter);
  }

  public int getSpecialTokenMapCount() {
    return internalGetSpecialTokenMap().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * The map capturing special tokens to be replaced during translation. The key
   * is special token in string. The value is the token data type. This is used
   * to translate SQL query template which contains special token as place
   * holder. The special token makes a query invalid to parse. This map will be
   * applied to annotate those special token with types to let parser understand
   * how to parse them into proper structure with type information.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.TokenType&gt; special_token_map = 6;
   * </code>
   */
  @java.lang.Override
  public boolean containsSpecialTokenMap(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetSpecialTokenMap().getMap().containsKey(key);
  }
  /** Use {@link #getSpecialTokenMapMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<
          java.lang.String,
          com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.TokenType>
      getSpecialTokenMap() {
    return getSpecialTokenMapMap();
  }
  /**
   *
   *
   * <pre>
   * The map capturing special tokens to be replaced during translation. The key
   * is special token in string. The value is the token data type. This is used
   * to translate SQL query template which contains special token as place
   * holder. The special token makes a query invalid to parse. This map will be
   * applied to annotate those special token with types to let parser understand
   * how to parse them into proper structure with type information.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.TokenType&gt; special_token_map = 6;
   * </code>
   */
  @java.lang.Override
  public java.util.Map<
          java.lang.String,
          com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.TokenType>
      getSpecialTokenMapMap() {
    return internalGetAdaptedSpecialTokenMapMap(internalGetSpecialTokenMap().getMap());
  }
  /**
   *
   *
   * <pre>
   * The map capturing special tokens to be replaced during translation. The key
   * is special token in string. The value is the token data type. This is used
   * to translate SQL query template which contains special token as place
   * holder. The special token makes a query invalid to parse. This map will be
   * applied to annotate those special token with types to let parser understand
   * how to parse them into proper structure with type information.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.TokenType&gt; special_token_map = 6;
   * </code>
   */
  @java.lang.Override
  public /* nullable */ com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.TokenType
      getSpecialTokenMapOrDefault(
          java.lang.String key,
          /* nullable */
          com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.TokenType
              defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.Integer> map = internalGetSpecialTokenMap().getMap();
    return map.containsKey(key)
        ? specialTokenMapValueConverter.doForward(map.get(key))
        : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * The map capturing special tokens to be replaced during translation. The key
   * is special token in string. The value is the token data type. This is used
   * to translate SQL query template which contains special token as place
   * holder. The special token makes a query invalid to parse. This map will be
   * applied to annotate those special token with types to let parser understand
   * how to parse them into proper structure with type information.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.TokenType&gt; special_token_map = 6;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.TokenType
      getSpecialTokenMapOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.Integer> map = internalGetSpecialTokenMap().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return specialTokenMapValueConverter.doForward(map.get(key));
  }
  /** Use {@link #getSpecialTokenMapValueMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.Integer> getSpecialTokenMapValue() {
    return getSpecialTokenMapValueMap();
  }
  /**
   *
   *
   * <pre>
   * The map capturing special tokens to be replaced during translation. The key
   * is special token in string. The value is the token data type. This is used
   * to translate SQL query template which contains special token as place
   * holder. The special token makes a query invalid to parse. This map will be
   * applied to annotate those special token with types to let parser understand
   * how to parse them into proper structure with type information.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.TokenType&gt; special_token_map = 6;
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.Integer> getSpecialTokenMapValueMap() {
    return internalGetSpecialTokenMap().getMap();
  }
  /**
   *
   *
   * <pre>
   * The map capturing special tokens to be replaced during translation. The key
   * is special token in string. The value is the token data type. This is used
   * to translate SQL query template which contains special token as place
   * holder. The special token makes a query invalid to parse. This map will be
   * applied to annotate those special token with types to let parser understand
   * how to parse them into proper structure with type information.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.TokenType&gt; special_token_map = 6;
   * </code>
   */
  @java.lang.Override
  public int getSpecialTokenMapValueOrDefault(java.lang.String key, int defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.Integer> map = internalGetSpecialTokenMap().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * The map capturing special tokens to be replaced during translation. The key
   * is special token in string. The value is the token data type. This is used
   * to translate SQL query template which contains special token as place
   * holder. The special token makes a query invalid to parse. This map will be
   * applied to annotate those special token with types to let parser understand
   * how to parse them into proper structure with type information.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.TokenType&gt; special_token_map = 6;
   * </code>
   */
  @java.lang.Override
  public int getSpecialTokenMapValueOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.Integer> map = internalGetSpecialTokenMap().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int FILTER_FIELD_NUMBER = 7;
  private com.google.cloud.bigquery.migration.v2alpha.Filter filter_;
  /**
   *
   *
   * <pre>
   * The filter applied to translation details.
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2alpha.Filter filter = 7;</code>
   *
   * @return Whether the filter field is set.
   */
  @java.lang.Override
  public boolean hasFilter() {
    return filter_ != null;
  }
  /**
   *
   *
   * <pre>
   * The filter applied to translation details.
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2alpha.Filter filter = 7;</code>
   *
   * @return The filter.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2alpha.Filter getFilter() {
    return filter_ == null
        ? com.google.cloud.bigquery.migration.v2alpha.Filter.getDefaultInstance()
        : filter_;
  }
  /**
   *
   *
   * <pre>
   * The filter applied to translation details.
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2alpha.Filter filter = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2alpha.FilterOrBuilder getFilterOrBuilder() {
    return filter_ == null
        ? com.google.cloud.bigquery.migration.v2alpha.Filter.getDefaultInstance()
        : filter_;
  }

  public static final int TRANSLATION_EXCEPTION_TABLE_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private volatile java.lang.Object translationExceptionTable_ = "";
  /**
   *
   *
   * <pre>
   * Specifies the exact name of the bigquery table ("dataset.table") to be used
   * for surfacing raw translation errors. If the table does not exist, we will
   * create it. If it already exists and the schema is the same, we will re-use.
   * If the table exists and the schema is different, we will throw an error.
   * </pre>
   *
   * <code>string translation_exception_table = 13;</code>
   *
   * @return The translationExceptionTable.
   */
  @java.lang.Override
  public java.lang.String getTranslationExceptionTable() {
    java.lang.Object ref = translationExceptionTable_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      translationExceptionTable_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Specifies the exact name of the bigquery table ("dataset.table") to be used
   * for surfacing raw translation errors. If the table does not exist, we will
   * create it. If it already exists and the schema is the same, we will re-use.
   * If the table exists and the schema is different, we will throw an error.
   * </pre>
   *
   * <code>string translation_exception_table = 13;</code>
   *
   * @return The bytes for translationExceptionTable.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTranslationExceptionTableBytes() {
    java.lang.Object ref = translationExceptionTable_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      translationExceptionTable_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(inputPath_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, inputPath_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(outputPath_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, outputPath_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(schemaPath_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, schemaPath_);
    }
    if (fileEncoding_
        != com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.FileEncoding
            .FILE_ENCODING_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(4, fileEncoding_);
    }
    if (identifierSettings_ != null) {
      output.writeMessage(5, getIdentifierSettings());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetSpecialTokenMap(), SpecialTokenMapDefaultEntryHolder.defaultEntry, 6);
    if (filter_ != null) {
      output.writeMessage(7, getFilter());
    }
    if (languageOptionsCase_ == 10) {
      output.writeMessage(
          10, (com.google.cloud.bigquery.migration.v2alpha.TeradataOptions) languageOptions_);
    }
    if (languageOptionsCase_ == 11) {
      output.writeMessage(
          11, (com.google.cloud.bigquery.migration.v2alpha.BteqOptions) languageOptions_);
    }
    for (int i = 0; i < filePaths_.size(); i++) {
      output.writeMessage(12, filePaths_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(translationExceptionTable_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 13, translationExceptionTable_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(inputPath_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, inputPath_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(outputPath_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, outputPath_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(schemaPath_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, schemaPath_);
    }
    if (fileEncoding_
        != com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.FileEncoding
            .FILE_ENCODING_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, fileEncoding_);
    }
    if (identifierSettings_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getIdentifierSettings());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.Integer> entry :
        internalGetSpecialTokenMap().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.Integer> specialTokenMap__ =
          SpecialTokenMapDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, specialTokenMap__);
    }
    if (filter_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getFilter());
    }
    if (languageOptionsCase_ == 10) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              10, (com.google.cloud.bigquery.migration.v2alpha.TeradataOptions) languageOptions_);
    }
    if (languageOptionsCase_ == 11) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              11, (com.google.cloud.bigquery.migration.v2alpha.BteqOptions) languageOptions_);
    }
    for (int i = 0; i < filePaths_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, filePaths_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(translationExceptionTable_)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(13, translationExceptionTable_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails)) {
      return super.equals(obj);
    }
    com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails other =
        (com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails) obj;

    if (!getInputPath().equals(other.getInputPath())) return false;
    if (!getOutputPath().equals(other.getOutputPath())) return false;
    if (!getFilePathsList().equals(other.getFilePathsList())) return false;
    if (!getSchemaPath().equals(other.getSchemaPath())) return false;
    if (fileEncoding_ != other.fileEncoding_) return false;
    if (hasIdentifierSettings() != other.hasIdentifierSettings()) return false;
    if (hasIdentifierSettings()) {
      if (!getIdentifierSettings().equals(other.getIdentifierSettings())) return false;
    }
    if (!internalGetSpecialTokenMap().equals(other.internalGetSpecialTokenMap())) return false;
    if (hasFilter() != other.hasFilter()) return false;
    if (hasFilter()) {
      if (!getFilter().equals(other.getFilter())) return false;
    }
    if (!getTranslationExceptionTable().equals(other.getTranslationExceptionTable())) return false;
    if (!getLanguageOptionsCase().equals(other.getLanguageOptionsCase())) return false;
    switch (languageOptionsCase_) {
      case 10:
        if (!getTeradataOptions().equals(other.getTeradataOptions())) return false;
        break;
      case 11:
        if (!getBteqOptions().equals(other.getBteqOptions())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + INPUT_PATH_FIELD_NUMBER;
    hash = (53 * hash) + getInputPath().hashCode();
    hash = (37 * hash) + OUTPUT_PATH_FIELD_NUMBER;
    hash = (53 * hash) + getOutputPath().hashCode();
    if (getFilePathsCount() > 0) {
      hash = (37 * hash) + FILE_PATHS_FIELD_NUMBER;
      hash = (53 * hash) + getFilePathsList().hashCode();
    }
    hash = (37 * hash) + SCHEMA_PATH_FIELD_NUMBER;
    hash = (53 * hash) + getSchemaPath().hashCode();
    hash = (37 * hash) + FILE_ENCODING_FIELD_NUMBER;
    hash = (53 * hash) + fileEncoding_;
    if (hasIdentifierSettings()) {
      hash = (37 * hash) + IDENTIFIER_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getIdentifierSettings().hashCode();
    }
    if (!internalGetSpecialTokenMap().getMap().isEmpty()) {
      hash = (37 * hash) + SPECIAL_TOKEN_MAP_FIELD_NUMBER;
      hash = (53 * hash) + internalGetSpecialTokenMap().hashCode();
    }
    if (hasFilter()) {
      hash = (37 * hash) + FILTER_FIELD_NUMBER;
      hash = (53 * hash) + getFilter().hashCode();
    }
    hash = (37 * hash) + TRANSLATION_EXCEPTION_TABLE_FIELD_NUMBER;
    hash = (53 * hash) + getTranslationExceptionTable().hashCode();
    switch (languageOptionsCase_) {
      case 10:
        hash = (37 * hash) + TERADATA_OPTIONS_FIELD_NUMBER;
        hash = (53 * hash) + getTeradataOptions().hashCode();
        break;
      case 11:
        hash = (37 * hash) + BTEQ_OPTIONS_FIELD_NUMBER;
        hash = (53 * hash) + getBteqOptions().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The translation task config to capture necessary settings for a translation
   * task and subtask.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails)
      com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetailsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.migration.v2alpha.TranslationTaskProto
          .internal_static_google_cloud_bigquery_migration_v2alpha_TranslationTaskDetails_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 6:
          return internalGetSpecialTokenMap();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 6:
          return internalGetMutableSpecialTokenMap();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.migration.v2alpha.TranslationTaskProto
          .internal_static_google_cloud_bigquery_migration_v2alpha_TranslationTaskDetails_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.class,
              com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.Builder.class);
    }

    // Construct using
    // com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (teradataOptionsBuilder_ != null) {
        teradataOptionsBuilder_.clear();
      }
      if (bteqOptionsBuilder_ != null) {
        bteqOptionsBuilder_.clear();
      }
      inputPath_ = "";
      outputPath_ = "";
      if (filePathsBuilder_ == null) {
        filePaths_ = java.util.Collections.emptyList();
      } else {
        filePaths_ = null;
        filePathsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      schemaPath_ = "";
      fileEncoding_ = 0;
      identifierSettings_ = null;
      if (identifierSettingsBuilder_ != null) {
        identifierSettingsBuilder_.dispose();
        identifierSettingsBuilder_ = null;
      }
      internalGetMutableSpecialTokenMap().clear();
      filter_ = null;
      if (filterBuilder_ != null) {
        filterBuilder_.dispose();
        filterBuilder_ = null;
      }
      translationExceptionTable_ = "";
      languageOptionsCase_ = 0;
      languageOptions_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.bigquery.migration.v2alpha.TranslationTaskProto
          .internal_static_google_cloud_bigquery_migration_v2alpha_TranslationTaskDetails_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails
        getDefaultInstanceForType() {
      return com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails build() {
      com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails buildPartial() {
      com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails result =
          new com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails result) {
      if (filePathsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          filePaths_ = java.util.Collections.unmodifiableList(filePaths_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.filePaths_ = filePaths_;
      } else {
        result.filePaths_ = filePathsBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.inputPath_ = inputPath_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.outputPath_ = outputPath_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.schemaPath_ = schemaPath_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.fileEncoding_ = fileEncoding_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.identifierSettings_ =
            identifierSettingsBuilder_ == null
                ? identifierSettings_
                : identifierSettingsBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.specialTokenMap_ = internalGetSpecialTokenMap();
        result.specialTokenMap_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.filter_ = filterBuilder_ == null ? filter_ : filterBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.translationExceptionTable_ = translationExceptionTable_;
      }
    }

    private void buildPartialOneofs(
        com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails result) {
      result.languageOptionsCase_ = languageOptionsCase_;
      result.languageOptions_ = this.languageOptions_;
      if (languageOptionsCase_ == 10 && teradataOptionsBuilder_ != null) {
        result.languageOptions_ = teradataOptionsBuilder_.build();
      }
      if (languageOptionsCase_ == 11 && bteqOptionsBuilder_ != null) {
        result.languageOptions_ = bteqOptionsBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails) {
        return mergeFrom(
            (com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails other) {
      if (other
          == com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails
              .getDefaultInstance()) return this;
      if (!other.getInputPath().isEmpty()) {
        inputPath_ = other.inputPath_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getOutputPath().isEmpty()) {
        outputPath_ = other.outputPath_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (filePathsBuilder_ == null) {
        if (!other.filePaths_.isEmpty()) {
          if (filePaths_.isEmpty()) {
            filePaths_ = other.filePaths_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureFilePathsIsMutable();
            filePaths_.addAll(other.filePaths_);
          }
          onChanged();
        }
      } else {
        if (!other.filePaths_.isEmpty()) {
          if (filePathsBuilder_.isEmpty()) {
            filePathsBuilder_.dispose();
            filePathsBuilder_ = null;
            filePaths_ = other.filePaths_;
            bitField0_ = (bitField0_ & ~0x00000010);
            filePathsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getFilePathsFieldBuilder()
                    : null;
          } else {
            filePathsBuilder_.addAllMessages(other.filePaths_);
          }
        }
      }
      if (!other.getSchemaPath().isEmpty()) {
        schemaPath_ = other.schemaPath_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.fileEncoding_ != 0) {
        setFileEncodingValue(other.getFileEncodingValue());
      }
      if (other.hasIdentifierSettings()) {
        mergeIdentifierSettings(other.getIdentifierSettings());
      }
      internalGetMutableSpecialTokenMap().mergeFrom(other.internalGetSpecialTokenMap());
      bitField0_ |= 0x00000100;
      if (other.hasFilter()) {
        mergeFilter(other.getFilter());
      }
      if (!other.getTranslationExceptionTable().isEmpty()) {
        translationExceptionTable_ = other.translationExceptionTable_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      switch (other.getLanguageOptionsCase()) {
        case TERADATA_OPTIONS:
          {
            mergeTeradataOptions(other.getTeradataOptions());
            break;
          }
        case BTEQ_OPTIONS:
          {
            mergeBteqOptions(other.getBteqOptions());
            break;
          }
        case LANGUAGEOPTIONS_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                inputPath_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 10
            case 18:
              {
                outputPath_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 18
            case 26:
              {
                schemaPath_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 26
            case 32:
              {
                fileEncoding_ = input.readEnum();
                bitField0_ |= 0x00000040;
                break;
              } // case 32
            case 42:
              {
                input.readMessage(
                    getIdentifierSettingsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 42
            case 50:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.Integer>
                    specialTokenMap__ =
                        input.readMessage(
                            SpecialTokenMapDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableSpecialTokenMap()
                    .getMutableMap()
                    .put(specialTokenMap__.getKey(), specialTokenMap__.getValue());
                bitField0_ |= 0x00000100;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getFilterFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 58
            case 82:
              {
                input.readMessage(getTeradataOptionsFieldBuilder().getBuilder(), extensionRegistry);
                languageOptionsCase_ = 10;
                break;
              } // case 82
            case 90:
              {
                input.readMessage(getBteqOptionsFieldBuilder().getBuilder(), extensionRegistry);
                languageOptionsCase_ = 11;
                break;
              } // case 90
            case 98:
              {
                com.google.cloud.bigquery.migration.v2alpha.TranslationFileMapping m =
                    input.readMessage(
                        com.google.cloud.bigquery.migration.v2alpha.TranslationFileMapping.parser(),
                        extensionRegistry);
                if (filePathsBuilder_ == null) {
                  ensureFilePathsIsMutable();
                  filePaths_.add(m);
                } else {
                  filePathsBuilder_.addMessage(m);
                }
                break;
              } // case 98
            case 106:
              {
                translationExceptionTable_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 106
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int languageOptionsCase_ = 0;
    private java.lang.Object languageOptions_;

    public LanguageOptionsCase getLanguageOptionsCase() {
      return LanguageOptionsCase.forNumber(languageOptionsCase_);
    }

    public Builder clearLanguageOptions() {
      languageOptionsCase_ = 0;
      languageOptions_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2alpha.TeradataOptions,
            com.google.cloud.bigquery.migration.v2alpha.TeradataOptions.Builder,
            com.google.cloud.bigquery.migration.v2alpha.TeradataOptionsOrBuilder>
        teradataOptionsBuilder_;
    /**
     *
     *
     * <pre>
     * The Teradata SQL specific settings for the translation task.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2alpha.TeradataOptions teradata_options = 10;</code>
     *
     * @return Whether the teradataOptions field is set.
     */
    @java.lang.Override
    public boolean hasTeradataOptions() {
      return languageOptionsCase_ == 10;
    }
    /**
     *
     *
     * <pre>
     * The Teradata SQL specific settings for the translation task.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2alpha.TeradataOptions teradata_options = 10;</code>
     *
     * @return The teradataOptions.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2alpha.TeradataOptions getTeradataOptions() {
      if (teradataOptionsBuilder_ == null) {
        if (languageOptionsCase_ == 10) {
          return (com.google.cloud.bigquery.migration.v2alpha.TeradataOptions) languageOptions_;
        }
        return com.google.cloud.bigquery.migration.v2alpha.TeradataOptions.getDefaultInstance();
      } else {
        if (languageOptionsCase_ == 10) {
          return teradataOptionsBuilder_.getMessage();
        }
        return com.google.cloud.bigquery.migration.v2alpha.TeradataOptions.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The Teradata SQL specific settings for the translation task.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2alpha.TeradataOptions teradata_options = 10;</code>
     */
    public Builder setTeradataOptions(
        com.google.cloud.bigquery.migration.v2alpha.TeradataOptions value) {
      if (teradataOptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        languageOptions_ = value;
        onChanged();
      } else {
        teradataOptionsBuilder_.setMessage(value);
      }
      languageOptionsCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Teradata SQL specific settings for the translation task.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2alpha.TeradataOptions teradata_options = 10;</code>
     */
    public Builder setTeradataOptions(
        com.google.cloud.bigquery.migration.v2alpha.TeradataOptions.Builder builderForValue) {
      if (teradataOptionsBuilder_ == null) {
        languageOptions_ = builderForValue.build();
        onChanged();
      } else {
        teradataOptionsBuilder_.setMessage(builderForValue.build());
      }
      languageOptionsCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Teradata SQL specific settings for the translation task.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2alpha.TeradataOptions teradata_options = 10;</code>
     */
    public Builder mergeTeradataOptions(
        com.google.cloud.bigquery.migration.v2alpha.TeradataOptions value) {
      if (teradataOptionsBuilder_ == null) {
        if (languageOptionsCase_ == 10
            && languageOptions_
                != com.google.cloud.bigquery.migration.v2alpha.TeradataOptions
                    .getDefaultInstance()) {
          languageOptions_ =
              com.google.cloud.bigquery.migration.v2alpha.TeradataOptions.newBuilder(
                      (com.google.cloud.bigquery.migration.v2alpha.TeradataOptions)
                          languageOptions_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          languageOptions_ = value;
        }
        onChanged();
      } else {
        if (languageOptionsCase_ == 10) {
          teradataOptionsBuilder_.mergeFrom(value);
        } else {
          teradataOptionsBuilder_.setMessage(value);
        }
      }
      languageOptionsCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Teradata SQL specific settings for the translation task.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2alpha.TeradataOptions teradata_options = 10;</code>
     */
    public Builder clearTeradataOptions() {
      if (teradataOptionsBuilder_ == null) {
        if (languageOptionsCase_ == 10) {
          languageOptionsCase_ = 0;
          languageOptions_ = null;
          onChanged();
        }
      } else {
        if (languageOptionsCase_ == 10) {
          languageOptionsCase_ = 0;
          languageOptions_ = null;
        }
        teradataOptionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Teradata SQL specific settings for the translation task.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2alpha.TeradataOptions teradata_options = 10;</code>
     */
    public com.google.cloud.bigquery.migration.v2alpha.TeradataOptions.Builder
        getTeradataOptionsBuilder() {
      return getTeradataOptionsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The Teradata SQL specific settings for the translation task.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2alpha.TeradataOptions teradata_options = 10;</code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2alpha.TeradataOptionsOrBuilder
        getTeradataOptionsOrBuilder() {
      if ((languageOptionsCase_ == 10) && (teradataOptionsBuilder_ != null)) {
        return teradataOptionsBuilder_.getMessageOrBuilder();
      } else {
        if (languageOptionsCase_ == 10) {
          return (com.google.cloud.bigquery.migration.v2alpha.TeradataOptions) languageOptions_;
        }
        return com.google.cloud.bigquery.migration.v2alpha.TeradataOptions.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The Teradata SQL specific settings for the translation task.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2alpha.TeradataOptions teradata_options = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2alpha.TeradataOptions,
            com.google.cloud.bigquery.migration.v2alpha.TeradataOptions.Builder,
            com.google.cloud.bigquery.migration.v2alpha.TeradataOptionsOrBuilder>
        getTeradataOptionsFieldBuilder() {
      if (teradataOptionsBuilder_ == null) {
        if (!(languageOptionsCase_ == 10)) {
          languageOptions_ =
              com.google.cloud.bigquery.migration.v2alpha.TeradataOptions.getDefaultInstance();
        }
        teradataOptionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.migration.v2alpha.TeradataOptions,
                com.google.cloud.bigquery.migration.v2alpha.TeradataOptions.Builder,
                com.google.cloud.bigquery.migration.v2alpha.TeradataOptionsOrBuilder>(
                (com.google.cloud.bigquery.migration.v2alpha.TeradataOptions) languageOptions_,
                getParentForChildren(),
                isClean());
        languageOptions_ = null;
      }
      languageOptionsCase_ = 10;
      onChanged();
      return teradataOptionsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2alpha.BteqOptions,
            com.google.cloud.bigquery.migration.v2alpha.BteqOptions.Builder,
            com.google.cloud.bigquery.migration.v2alpha.BteqOptionsOrBuilder>
        bteqOptionsBuilder_;
    /**
     *
     *
     * <pre>
     * The BTEQ specific settings for the translation task.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2alpha.BteqOptions bteq_options = 11;</code>
     *
     * @return Whether the bteqOptions field is set.
     */
    @java.lang.Override
    public boolean hasBteqOptions() {
      return languageOptionsCase_ == 11;
    }
    /**
     *
     *
     * <pre>
     * The BTEQ specific settings for the translation task.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2alpha.BteqOptions bteq_options = 11;</code>
     *
     * @return The bteqOptions.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2alpha.BteqOptions getBteqOptions() {
      if (bteqOptionsBuilder_ == null) {
        if (languageOptionsCase_ == 11) {
          return (com.google.cloud.bigquery.migration.v2alpha.BteqOptions) languageOptions_;
        }
        return com.google.cloud.bigquery.migration.v2alpha.BteqOptions.getDefaultInstance();
      } else {
        if (languageOptionsCase_ == 11) {
          return bteqOptionsBuilder_.getMessage();
        }
        return com.google.cloud.bigquery.migration.v2alpha.BteqOptions.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The BTEQ specific settings for the translation task.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2alpha.BteqOptions bteq_options = 11;</code>
     */
    public Builder setBteqOptions(com.google.cloud.bigquery.migration.v2alpha.BteqOptions value) {
      if (bteqOptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        languageOptions_ = value;
        onChanged();
      } else {
        bteqOptionsBuilder_.setMessage(value);
      }
      languageOptionsCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The BTEQ specific settings for the translation task.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2alpha.BteqOptions bteq_options = 11;</code>
     */
    public Builder setBteqOptions(
        com.google.cloud.bigquery.migration.v2alpha.BteqOptions.Builder builderForValue) {
      if (bteqOptionsBuilder_ == null) {
        languageOptions_ = builderForValue.build();
        onChanged();
      } else {
        bteqOptionsBuilder_.setMessage(builderForValue.build());
      }
      languageOptionsCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The BTEQ specific settings for the translation task.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2alpha.BteqOptions bteq_options = 11;</code>
     */
    public Builder mergeBteqOptions(com.google.cloud.bigquery.migration.v2alpha.BteqOptions value) {
      if (bteqOptionsBuilder_ == null) {
        if (languageOptionsCase_ == 11
            && languageOptions_
                != com.google.cloud.bigquery.migration.v2alpha.BteqOptions.getDefaultInstance()) {
          languageOptions_ =
              com.google.cloud.bigquery.migration.v2alpha.BteqOptions.newBuilder(
                      (com.google.cloud.bigquery.migration.v2alpha.BteqOptions) languageOptions_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          languageOptions_ = value;
        }
        onChanged();
      } else {
        if (languageOptionsCase_ == 11) {
          bteqOptionsBuilder_.mergeFrom(value);
        } else {
          bteqOptionsBuilder_.setMessage(value);
        }
      }
      languageOptionsCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The BTEQ specific settings for the translation task.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2alpha.BteqOptions bteq_options = 11;</code>
     */
    public Builder clearBteqOptions() {
      if (bteqOptionsBuilder_ == null) {
        if (languageOptionsCase_ == 11) {
          languageOptionsCase_ = 0;
          languageOptions_ = null;
          onChanged();
        }
      } else {
        if (languageOptionsCase_ == 11) {
          languageOptionsCase_ = 0;
          languageOptions_ = null;
        }
        bteqOptionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The BTEQ specific settings for the translation task.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2alpha.BteqOptions bteq_options = 11;</code>
     */
    public com.google.cloud.bigquery.migration.v2alpha.BteqOptions.Builder getBteqOptionsBuilder() {
      return getBteqOptionsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The BTEQ specific settings for the translation task.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2alpha.BteqOptions bteq_options = 11;</code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2alpha.BteqOptionsOrBuilder
        getBteqOptionsOrBuilder() {
      if ((languageOptionsCase_ == 11) && (bteqOptionsBuilder_ != null)) {
        return bteqOptionsBuilder_.getMessageOrBuilder();
      } else {
        if (languageOptionsCase_ == 11) {
          return (com.google.cloud.bigquery.migration.v2alpha.BteqOptions) languageOptions_;
        }
        return com.google.cloud.bigquery.migration.v2alpha.BteqOptions.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The BTEQ specific settings for the translation task.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2alpha.BteqOptions bteq_options = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2alpha.BteqOptions,
            com.google.cloud.bigquery.migration.v2alpha.BteqOptions.Builder,
            com.google.cloud.bigquery.migration.v2alpha.BteqOptionsOrBuilder>
        getBteqOptionsFieldBuilder() {
      if (bteqOptionsBuilder_ == null) {
        if (!(languageOptionsCase_ == 11)) {
          languageOptions_ =
              com.google.cloud.bigquery.migration.v2alpha.BteqOptions.getDefaultInstance();
        }
        bteqOptionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.migration.v2alpha.BteqOptions,
                com.google.cloud.bigquery.migration.v2alpha.BteqOptions.Builder,
                com.google.cloud.bigquery.migration.v2alpha.BteqOptionsOrBuilder>(
                (com.google.cloud.bigquery.migration.v2alpha.BteqOptions) languageOptions_,
                getParentForChildren(),
                isClean());
        languageOptions_ = null;
      }
      languageOptionsCase_ = 11;
      onChanged();
      return bteqOptionsBuilder_;
    }

    private java.lang.Object inputPath_ = "";
    /**
     *
     *
     * <pre>
     * The Cloud Storage path for translation input files.
     * </pre>
     *
     * <code>string input_path = 1;</code>
     *
     * @return The inputPath.
     */
    public java.lang.String getInputPath() {
      java.lang.Object ref = inputPath_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        inputPath_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage path for translation input files.
     * </pre>
     *
     * <code>string input_path = 1;</code>
     *
     * @return The bytes for inputPath.
     */
    public com.google.protobuf.ByteString getInputPathBytes() {
      java.lang.Object ref = inputPath_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        inputPath_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage path for translation input files.
     * </pre>
     *
     * <code>string input_path = 1;</code>
     *
     * @param value The inputPath to set.
     * @return This builder for chaining.
     */
    public Builder setInputPath(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      inputPath_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage path for translation input files.
     * </pre>
     *
     * <code>string input_path = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInputPath() {
      inputPath_ = getDefaultInstance().getInputPath();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage path for translation input files.
     * </pre>
     *
     * <code>string input_path = 1;</code>
     *
     * @param value The bytes for inputPath to set.
     * @return This builder for chaining.
     */
    public Builder setInputPathBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      inputPath_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object outputPath_ = "";
    /**
     *
     *
     * <pre>
     * The Cloud Storage path for translation output files.
     * </pre>
     *
     * <code>string output_path = 2;</code>
     *
     * @return The outputPath.
     */
    public java.lang.String getOutputPath() {
      java.lang.Object ref = outputPath_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        outputPath_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage path for translation output files.
     * </pre>
     *
     * <code>string output_path = 2;</code>
     *
     * @return The bytes for outputPath.
     */
    public com.google.protobuf.ByteString getOutputPathBytes() {
      java.lang.Object ref = outputPath_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        outputPath_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage path for translation output files.
     * </pre>
     *
     * <code>string output_path = 2;</code>
     *
     * @param value The outputPath to set.
     * @return This builder for chaining.
     */
    public Builder setOutputPath(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      outputPath_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage path for translation output files.
     * </pre>
     *
     * <code>string output_path = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOutputPath() {
      outputPath_ = getDefaultInstance().getOutputPath();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage path for translation output files.
     * </pre>
     *
     * <code>string output_path = 2;</code>
     *
     * @param value The bytes for outputPath to set.
     * @return This builder for chaining.
     */
    public Builder setOutputPathBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      outputPath_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.bigquery.migration.v2alpha.TranslationFileMapping>
        filePaths_ = java.util.Collections.emptyList();

    private void ensureFilePathsIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        filePaths_ =
            new java.util.ArrayList<
                com.google.cloud.bigquery.migration.v2alpha.TranslationFileMapping>(filePaths_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2alpha.TranslationFileMapping,
            com.google.cloud.bigquery.migration.v2alpha.TranslationFileMapping.Builder,
            com.google.cloud.bigquery.migration.v2alpha.TranslationFileMappingOrBuilder>
        filePathsBuilder_;

    /**
     *
     *
     * <pre>
     * Cloud Storage files to be processed for translation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2alpha.TranslationFileMapping file_paths = 12;
     * </code>
     */
    public java.util.List<com.google.cloud.bigquery.migration.v2alpha.TranslationFileMapping>
        getFilePathsList() {
      if (filePathsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(filePaths_);
      } else {
        return filePathsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage files to be processed for translation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2alpha.TranslationFileMapping file_paths = 12;
     * </code>
     */
    public int getFilePathsCount() {
      if (filePathsBuilder_ == null) {
        return filePaths_.size();
      } else {
        return filePathsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage files to be processed for translation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2alpha.TranslationFileMapping file_paths = 12;
     * </code>
     */
    public com.google.cloud.bigquery.migration.v2alpha.TranslationFileMapping getFilePaths(
        int index) {
      if (filePathsBuilder_ == null) {
        return filePaths_.get(index);
      } else {
        return filePathsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage files to be processed for translation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2alpha.TranslationFileMapping file_paths = 12;
     * </code>
     */
    public Builder setFilePaths(
        int index, com.google.cloud.bigquery.migration.v2alpha.TranslationFileMapping value) {
      if (filePathsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFilePathsIsMutable();
        filePaths_.set(index, value);
        onChanged();
      } else {
        filePathsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage files to be processed for translation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2alpha.TranslationFileMapping file_paths = 12;
     * </code>
     */
    public Builder setFilePaths(
        int index,
        com.google.cloud.bigquery.migration.v2alpha.TranslationFileMapping.Builder
            builderForValue) {
      if (filePathsBuilder_ == null) {
        ensureFilePathsIsMutable();
        filePaths_.set(index, builderForValue.build());
        onChanged();
      } else {
        filePathsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage files to be processed for translation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2alpha.TranslationFileMapping file_paths = 12;
     * </code>
     */
    public Builder addFilePaths(
        com.google.cloud.bigquery.migration.v2alpha.TranslationFileMapping value) {
      if (filePathsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFilePathsIsMutable();
        filePaths_.add(value);
        onChanged();
      } else {
        filePathsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage files to be processed for translation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2alpha.TranslationFileMapping file_paths = 12;
     * </code>
     */
    public Builder addFilePaths(
        int index, com.google.cloud.bigquery.migration.v2alpha.TranslationFileMapping value) {
      if (filePathsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFilePathsIsMutable();
        filePaths_.add(index, value);
        onChanged();
      } else {
        filePathsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage files to be processed for translation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2alpha.TranslationFileMapping file_paths = 12;
     * </code>
     */
    public Builder addFilePaths(
        com.google.cloud.bigquery.migration.v2alpha.TranslationFileMapping.Builder
            builderForValue) {
      if (filePathsBuilder_ == null) {
        ensureFilePathsIsMutable();
        filePaths_.add(builderForValue.build());
        onChanged();
      } else {
        filePathsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage files to be processed for translation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2alpha.TranslationFileMapping file_paths = 12;
     * </code>
     */
    public Builder addFilePaths(
        int index,
        com.google.cloud.bigquery.migration.v2alpha.TranslationFileMapping.Builder
            builderForValue) {
      if (filePathsBuilder_ == null) {
        ensureFilePathsIsMutable();
        filePaths_.add(index, builderForValue.build());
        onChanged();
      } else {
        filePathsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage files to be processed for translation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2alpha.TranslationFileMapping file_paths = 12;
     * </code>
     */
    public Builder addAllFilePaths(
        java.lang.Iterable<
                ? extends com.google.cloud.bigquery.migration.v2alpha.TranslationFileMapping>
            values) {
      if (filePathsBuilder_ == null) {
        ensureFilePathsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, filePaths_);
        onChanged();
      } else {
        filePathsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage files to be processed for translation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2alpha.TranslationFileMapping file_paths = 12;
     * </code>
     */
    public Builder clearFilePaths() {
      if (filePathsBuilder_ == null) {
        filePaths_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        filePathsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage files to be processed for translation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2alpha.TranslationFileMapping file_paths = 12;
     * </code>
     */
    public Builder removeFilePaths(int index) {
      if (filePathsBuilder_ == null) {
        ensureFilePathsIsMutable();
        filePaths_.remove(index);
        onChanged();
      } else {
        filePathsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage files to be processed for translation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2alpha.TranslationFileMapping file_paths = 12;
     * </code>
     */
    public com.google.cloud.bigquery.migration.v2alpha.TranslationFileMapping.Builder
        getFilePathsBuilder(int index) {
      return getFilePathsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage files to be processed for translation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2alpha.TranslationFileMapping file_paths = 12;
     * </code>
     */
    public com.google.cloud.bigquery.migration.v2alpha.TranslationFileMappingOrBuilder
        getFilePathsOrBuilder(int index) {
      if (filePathsBuilder_ == null) {
        return filePaths_.get(index);
      } else {
        return filePathsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage files to be processed for translation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2alpha.TranslationFileMapping file_paths = 12;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.bigquery.migration.v2alpha.TranslationFileMappingOrBuilder>
        getFilePathsOrBuilderList() {
      if (filePathsBuilder_ != null) {
        return filePathsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(filePaths_);
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage files to be processed for translation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2alpha.TranslationFileMapping file_paths = 12;
     * </code>
     */
    public com.google.cloud.bigquery.migration.v2alpha.TranslationFileMapping.Builder
        addFilePathsBuilder() {
      return getFilePathsFieldBuilder()
          .addBuilder(
              com.google.cloud.bigquery.migration.v2alpha.TranslationFileMapping
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage files to be processed for translation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2alpha.TranslationFileMapping file_paths = 12;
     * </code>
     */
    public com.google.cloud.bigquery.migration.v2alpha.TranslationFileMapping.Builder
        addFilePathsBuilder(int index) {
      return getFilePathsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.bigquery.migration.v2alpha.TranslationFileMapping
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage files to be processed for translation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2alpha.TranslationFileMapping file_paths = 12;
     * </code>
     */
    public java.util.List<
            com.google.cloud.bigquery.migration.v2alpha.TranslationFileMapping.Builder>
        getFilePathsBuilderList() {
      return getFilePathsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2alpha.TranslationFileMapping,
            com.google.cloud.bigquery.migration.v2alpha.TranslationFileMapping.Builder,
            com.google.cloud.bigquery.migration.v2alpha.TranslationFileMappingOrBuilder>
        getFilePathsFieldBuilder() {
      if (filePathsBuilder_ == null) {
        filePathsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.bigquery.migration.v2alpha.TranslationFileMapping,
                com.google.cloud.bigquery.migration.v2alpha.TranslationFileMapping.Builder,
                com.google.cloud.bigquery.migration.v2alpha.TranslationFileMappingOrBuilder>(
                filePaths_, ((bitField0_ & 0x00000010) != 0), getParentForChildren(), isClean());
        filePaths_ = null;
      }
      return filePathsBuilder_;
    }

    private java.lang.Object schemaPath_ = "";
    /**
     *
     *
     * <pre>
     * The Cloud Storage path to DDL files as table schema to assist semantic
     * translation.
     * </pre>
     *
     * <code>string schema_path = 3;</code>
     *
     * @return The schemaPath.
     */
    public java.lang.String getSchemaPath() {
      java.lang.Object ref = schemaPath_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        schemaPath_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage path to DDL files as table schema to assist semantic
     * translation.
     * </pre>
     *
     * <code>string schema_path = 3;</code>
     *
     * @return The bytes for schemaPath.
     */
    public com.google.protobuf.ByteString getSchemaPathBytes() {
      java.lang.Object ref = schemaPath_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        schemaPath_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage path to DDL files as table schema to assist semantic
     * translation.
     * </pre>
     *
     * <code>string schema_path = 3;</code>
     *
     * @param value The schemaPath to set.
     * @return This builder for chaining.
     */
    public Builder setSchemaPath(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      schemaPath_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage path to DDL files as table schema to assist semantic
     * translation.
     * </pre>
     *
     * <code>string schema_path = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSchemaPath() {
      schemaPath_ = getDefaultInstance().getSchemaPath();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage path to DDL files as table schema to assist semantic
     * translation.
     * </pre>
     *
     * <code>string schema_path = 3;</code>
     *
     * @param value The bytes for schemaPath to set.
     * @return This builder for chaining.
     */
    public Builder setSchemaPathBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      schemaPath_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private int fileEncoding_ = 0;
    /**
     *
     *
     * <pre>
     * The file encoding type.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.FileEncoding file_encoding = 4;
     * </code>
     *
     * @return The enum numeric value on the wire for fileEncoding.
     */
    @java.lang.Override
    public int getFileEncodingValue() {
      return fileEncoding_;
    }
    /**
     *
     *
     * <pre>
     * The file encoding type.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.FileEncoding file_encoding = 4;
     * </code>
     *
     * @param value The enum numeric value on the wire for fileEncoding to set.
     * @return This builder for chaining.
     */
    public Builder setFileEncodingValue(int value) {
      fileEncoding_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The file encoding type.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.FileEncoding file_encoding = 4;
     * </code>
     *
     * @return The fileEncoding.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.FileEncoding
        getFileEncoding() {
      com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.FileEncoding result =
          com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.FileEncoding.forNumber(
              fileEncoding_);
      return result == null
          ? com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.FileEncoding
              .UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The file encoding type.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.FileEncoding file_encoding = 4;
     * </code>
     *
     * @param value The fileEncoding to set.
     * @return This builder for chaining.
     */
    public Builder setFileEncoding(
        com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.FileEncoding value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000040;
      fileEncoding_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The file encoding type.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.FileEncoding file_encoding = 4;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFileEncoding() {
      bitField0_ = (bitField0_ & ~0x00000040);
      fileEncoding_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.bigquery.migration.v2alpha.IdentifierSettings identifierSettings_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2alpha.IdentifierSettings,
            com.google.cloud.bigquery.migration.v2alpha.IdentifierSettings.Builder,
            com.google.cloud.bigquery.migration.v2alpha.IdentifierSettingsOrBuilder>
        identifierSettingsBuilder_;
    /**
     *
     *
     * <pre>
     * The settings for SQL identifiers.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2alpha.IdentifierSettings identifier_settings = 5;
     * </code>
     *
     * @return Whether the identifierSettings field is set.
     */
    public boolean hasIdentifierSettings() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * The settings for SQL identifiers.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2alpha.IdentifierSettings identifier_settings = 5;
     * </code>
     *
     * @return The identifierSettings.
     */
    public com.google.cloud.bigquery.migration.v2alpha.IdentifierSettings getIdentifierSettings() {
      if (identifierSettingsBuilder_ == null) {
        return identifierSettings_ == null
            ? com.google.cloud.bigquery.migration.v2alpha.IdentifierSettings.getDefaultInstance()
            : identifierSettings_;
      } else {
        return identifierSettingsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The settings for SQL identifiers.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2alpha.IdentifierSettings identifier_settings = 5;
     * </code>
     */
    public Builder setIdentifierSettings(
        com.google.cloud.bigquery.migration.v2alpha.IdentifierSettings value) {
      if (identifierSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        identifierSettings_ = value;
      } else {
        identifierSettingsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The settings for SQL identifiers.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2alpha.IdentifierSettings identifier_settings = 5;
     * </code>
     */
    public Builder setIdentifierSettings(
        com.google.cloud.bigquery.migration.v2alpha.IdentifierSettings.Builder builderForValue) {
      if (identifierSettingsBuilder_ == null) {
        identifierSettings_ = builderForValue.build();
      } else {
        identifierSettingsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The settings for SQL identifiers.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2alpha.IdentifierSettings identifier_settings = 5;
     * </code>
     */
    public Builder mergeIdentifierSettings(
        com.google.cloud.bigquery.migration.v2alpha.IdentifierSettings value) {
      if (identifierSettingsBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && identifierSettings_ != null
            && identifierSettings_
                != com.google.cloud.bigquery.migration.v2alpha.IdentifierSettings
                    .getDefaultInstance()) {
          getIdentifierSettingsBuilder().mergeFrom(value);
        } else {
          identifierSettings_ = value;
        }
      } else {
        identifierSettingsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The settings for SQL identifiers.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2alpha.IdentifierSettings identifier_settings = 5;
     * </code>
     */
    public Builder clearIdentifierSettings() {
      bitField0_ = (bitField0_ & ~0x00000080);
      identifierSettings_ = null;
      if (identifierSettingsBuilder_ != null) {
        identifierSettingsBuilder_.dispose();
        identifierSettingsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The settings for SQL identifiers.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2alpha.IdentifierSettings identifier_settings = 5;
     * </code>
     */
    public com.google.cloud.bigquery.migration.v2alpha.IdentifierSettings.Builder
        getIdentifierSettingsBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getIdentifierSettingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The settings for SQL identifiers.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2alpha.IdentifierSettings identifier_settings = 5;
     * </code>
     */
    public com.google.cloud.bigquery.migration.v2alpha.IdentifierSettingsOrBuilder
        getIdentifierSettingsOrBuilder() {
      if (identifierSettingsBuilder_ != null) {
        return identifierSettingsBuilder_.getMessageOrBuilder();
      } else {
        return identifierSettings_ == null
            ? com.google.cloud.bigquery.migration.v2alpha.IdentifierSettings.getDefaultInstance()
            : identifierSettings_;
      }
    }
    /**
     *
     *
     * <pre>
     * The settings for SQL identifiers.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2alpha.IdentifierSettings identifier_settings = 5;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2alpha.IdentifierSettings,
            com.google.cloud.bigquery.migration.v2alpha.IdentifierSettings.Builder,
            com.google.cloud.bigquery.migration.v2alpha.IdentifierSettingsOrBuilder>
        getIdentifierSettingsFieldBuilder() {
      if (identifierSettingsBuilder_ == null) {
        identifierSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.migration.v2alpha.IdentifierSettings,
                com.google.cloud.bigquery.migration.v2alpha.IdentifierSettings.Builder,
                com.google.cloud.bigquery.migration.v2alpha.IdentifierSettingsOrBuilder>(
                getIdentifierSettings(), getParentForChildren(), isClean());
        identifierSettings_ = null;
      }
      return identifierSettingsBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.Integer> specialTokenMap_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.Integer>
        internalGetSpecialTokenMap() {
      if (specialTokenMap_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            SpecialTokenMapDefaultEntryHolder.defaultEntry);
      }
      return specialTokenMap_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.Integer>
        internalGetMutableSpecialTokenMap() {
      if (specialTokenMap_ == null) {
        specialTokenMap_ =
            com.google.protobuf.MapField.newMapField(
                SpecialTokenMapDefaultEntryHolder.defaultEntry);
      }
      if (!specialTokenMap_.isMutable()) {
        specialTokenMap_ = specialTokenMap_.copy();
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return specialTokenMap_;
    }

    public int getSpecialTokenMapCount() {
      return internalGetSpecialTokenMap().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * The map capturing special tokens to be replaced during translation. The key
     * is special token in string. The value is the token data type. This is used
     * to translate SQL query template which contains special token as place
     * holder. The special token makes a query invalid to parse. This map will be
     * applied to annotate those special token with types to let parser understand
     * how to parse them into proper structure with type information.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.TokenType&gt; special_token_map = 6;
     * </code>
     */
    @java.lang.Override
    public boolean containsSpecialTokenMap(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetSpecialTokenMap().getMap().containsKey(key);
    }
    /** Use {@link #getSpecialTokenMapMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String,
            com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.TokenType>
        getSpecialTokenMap() {
      return getSpecialTokenMapMap();
    }
    /**
     *
     *
     * <pre>
     * The map capturing special tokens to be replaced during translation. The key
     * is special token in string. The value is the token data type. This is used
     * to translate SQL query template which contains special token as place
     * holder. The special token makes a query invalid to parse. This map will be
     * applied to annotate those special token with types to let parser understand
     * how to parse them into proper structure with type information.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.TokenType&gt; special_token_map = 6;
     * </code>
     */
    @java.lang.Override
    public java.util.Map<
            java.lang.String,
            com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.TokenType>
        getSpecialTokenMapMap() {
      return internalGetAdaptedSpecialTokenMapMap(internalGetSpecialTokenMap().getMap());
    }
    /**
     *
     *
     * <pre>
     * The map capturing special tokens to be replaced during translation. The key
     * is special token in string. The value is the token data type. This is used
     * to translate SQL query template which contains special token as place
     * holder. The special token makes a query invalid to parse. This map will be
     * applied to annotate those special token with types to let parser understand
     * how to parse them into proper structure with type information.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.TokenType&gt; special_token_map = 6;
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails
            .TokenType
        getSpecialTokenMapOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.TokenType
                defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.Integer> map =
          internalGetSpecialTokenMap().getMap();
      return map.containsKey(key)
          ? specialTokenMapValueConverter.doForward(map.get(key))
          : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * The map capturing special tokens to be replaced during translation. The key
     * is special token in string. The value is the token data type. This is used
     * to translate SQL query template which contains special token as place
     * holder. The special token makes a query invalid to parse. This map will be
     * applied to annotate those special token with types to let parser understand
     * how to parse them into proper structure with type information.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.TokenType&gt; special_token_map = 6;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.TokenType
        getSpecialTokenMapOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.Integer> map =
          internalGetSpecialTokenMap().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return specialTokenMapValueConverter.doForward(map.get(key));
    }
    /** Use {@link #getSpecialTokenMapValueMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.Integer> getSpecialTokenMapValue() {
      return getSpecialTokenMapValueMap();
    }
    /**
     *
     *
     * <pre>
     * The map capturing special tokens to be replaced during translation. The key
     * is special token in string. The value is the token data type. This is used
     * to translate SQL query template which contains special token as place
     * holder. The special token makes a query invalid to parse. This map will be
     * applied to annotate those special token with types to let parser understand
     * how to parse them into proper structure with type information.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.TokenType&gt; special_token_map = 6;
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.Integer> getSpecialTokenMapValueMap() {
      return internalGetSpecialTokenMap().getMap();
    }
    /**
     *
     *
     * <pre>
     * The map capturing special tokens to be replaced during translation. The key
     * is special token in string. The value is the token data type. This is used
     * to translate SQL query template which contains special token as place
     * holder. The special token makes a query invalid to parse. This map will be
     * applied to annotate those special token with types to let parser understand
     * how to parse them into proper structure with type information.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.TokenType&gt; special_token_map = 6;
     * </code>
     */
    @java.lang.Override
    public int getSpecialTokenMapValueOrDefault(java.lang.String key, int defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.Integer> map =
          internalGetSpecialTokenMap().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * The map capturing special tokens to be replaced during translation. The key
     * is special token in string. The value is the token data type. This is used
     * to translate SQL query template which contains special token as place
     * holder. The special token makes a query invalid to parse. This map will be
     * applied to annotate those special token with types to let parser understand
     * how to parse them into proper structure with type information.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.TokenType&gt; special_token_map = 6;
     * </code>
     */
    @java.lang.Override
    public int getSpecialTokenMapValueOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.Integer> map =
          internalGetSpecialTokenMap().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearSpecialTokenMap() {
      bitField0_ = (bitField0_ & ~0x00000100);
      internalGetMutableSpecialTokenMap().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The map capturing special tokens to be replaced during translation. The key
     * is special token in string. The value is the token data type. This is used
     * to translate SQL query template which contains special token as place
     * holder. The special token makes a query invalid to parse. This map will be
     * applied to annotate those special token with types to let parser understand
     * how to parse them into proper structure with type information.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.TokenType&gt; special_token_map = 6;
     * </code>
     */
    public Builder removeSpecialTokenMap(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableSpecialTokenMap().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String,
            com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.TokenType>
        getMutableSpecialTokenMap() {
      bitField0_ |= 0x00000100;
      return internalGetAdaptedSpecialTokenMapMap(
          internalGetMutableSpecialTokenMap().getMutableMap());
    }
    /**
     *
     *
     * <pre>
     * The map capturing special tokens to be replaced during translation. The key
     * is special token in string. The value is the token data type. This is used
     * to translate SQL query template which contains special token as place
     * holder. The special token makes a query invalid to parse. This map will be
     * applied to annotate those special token with types to let parser understand
     * how to parse them into proper structure with type information.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.TokenType&gt; special_token_map = 6;
     * </code>
     */
    public Builder putSpecialTokenMap(
        java.lang.String key,
        com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.TokenType value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }

      internalGetMutableSpecialTokenMap()
          .getMutableMap()
          .put(key, specialTokenMapValueConverter.doBackward(value));
      bitField0_ |= 0x00000100;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The map capturing special tokens to be replaced during translation. The key
     * is special token in string. The value is the token data type. This is used
     * to translate SQL query template which contains special token as place
     * holder. The special token makes a query invalid to parse. This map will be
     * applied to annotate those special token with types to let parser understand
     * how to parse them into proper structure with type information.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.TokenType&gt; special_token_map = 6;
     * </code>
     */
    public Builder putAllSpecialTokenMap(
        java.util.Map<
                java.lang.String,
                com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.TokenType>
            values) {
      internalGetAdaptedSpecialTokenMapMap(internalGetMutableSpecialTokenMap().getMutableMap())
          .putAll(values);
      bitField0_ |= 0x00000100;
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.Integer> getMutableSpecialTokenMapValue() {
      bitField0_ |= 0x00000100;
      return internalGetMutableSpecialTokenMap().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * The map capturing special tokens to be replaced during translation. The key
     * is special token in string. The value is the token data type. This is used
     * to translate SQL query template which contains special token as place
     * holder. The special token makes a query invalid to parse. This map will be
     * applied to annotate those special token with types to let parser understand
     * how to parse them into proper structure with type information.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.TokenType&gt; special_token_map = 6;
     * </code>
     */
    public Builder putSpecialTokenMapValue(java.lang.String key, int value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }

      internalGetMutableSpecialTokenMap().getMutableMap().put(key, value);
      bitField0_ |= 0x00000100;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The map capturing special tokens to be replaced during translation. The key
     * is special token in string. The value is the token data type. This is used
     * to translate SQL query template which contains special token as place
     * holder. The special token makes a query invalid to parse. This map will be
     * applied to annotate those special token with types to let parser understand
     * how to parse them into proper structure with type information.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.TokenType&gt; special_token_map = 6;
     * </code>
     */
    public Builder putAllSpecialTokenMapValue(
        java.util.Map<java.lang.String, java.lang.Integer> values) {
      internalGetMutableSpecialTokenMap().getMutableMap().putAll(values);
      bitField0_ |= 0x00000100;
      return this;
    }

    private com.google.cloud.bigquery.migration.v2alpha.Filter filter_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2alpha.Filter,
            com.google.cloud.bigquery.migration.v2alpha.Filter.Builder,
            com.google.cloud.bigquery.migration.v2alpha.FilterOrBuilder>
        filterBuilder_;
    /**
     *
     *
     * <pre>
     * The filter applied to translation details.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2alpha.Filter filter = 7;</code>
     *
     * @return Whether the filter field is set.
     */
    public boolean hasFilter() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * The filter applied to translation details.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2alpha.Filter filter = 7;</code>
     *
     * @return The filter.
     */
    public com.google.cloud.bigquery.migration.v2alpha.Filter getFilter() {
      if (filterBuilder_ == null) {
        return filter_ == null
            ? com.google.cloud.bigquery.migration.v2alpha.Filter.getDefaultInstance()
            : filter_;
      } else {
        return filterBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The filter applied to translation details.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2alpha.Filter filter = 7;</code>
     */
    public Builder setFilter(com.google.cloud.bigquery.migration.v2alpha.Filter value) {
      if (filterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        filter_ = value;
      } else {
        filterBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The filter applied to translation details.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2alpha.Filter filter = 7;</code>
     */
    public Builder setFilter(
        com.google.cloud.bigquery.migration.v2alpha.Filter.Builder builderForValue) {
      if (filterBuilder_ == null) {
        filter_ = builderForValue.build();
      } else {
        filterBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The filter applied to translation details.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2alpha.Filter filter = 7;</code>
     */
    public Builder mergeFilter(com.google.cloud.bigquery.migration.v2alpha.Filter value) {
      if (filterBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && filter_ != null
            && filter_ != com.google.cloud.bigquery.migration.v2alpha.Filter.getDefaultInstance()) {
          getFilterBuilder().mergeFrom(value);
        } else {
          filter_ = value;
        }
      } else {
        filterBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The filter applied to translation details.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2alpha.Filter filter = 7;</code>
     */
    public Builder clearFilter() {
      bitField0_ = (bitField0_ & ~0x00000200);
      filter_ = null;
      if (filterBuilder_ != null) {
        filterBuilder_.dispose();
        filterBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The filter applied to translation details.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2alpha.Filter filter = 7;</code>
     */
    public com.google.cloud.bigquery.migration.v2alpha.Filter.Builder getFilterBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getFilterFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The filter applied to translation details.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2alpha.Filter filter = 7;</code>
     */
    public com.google.cloud.bigquery.migration.v2alpha.FilterOrBuilder getFilterOrBuilder() {
      if (filterBuilder_ != null) {
        return filterBuilder_.getMessageOrBuilder();
      } else {
        return filter_ == null
            ? com.google.cloud.bigquery.migration.v2alpha.Filter.getDefaultInstance()
            : filter_;
      }
    }
    /**
     *
     *
     * <pre>
     * The filter applied to translation details.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2alpha.Filter filter = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2alpha.Filter,
            com.google.cloud.bigquery.migration.v2alpha.Filter.Builder,
            com.google.cloud.bigquery.migration.v2alpha.FilterOrBuilder>
        getFilterFieldBuilder() {
      if (filterBuilder_ == null) {
        filterBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.migration.v2alpha.Filter,
                com.google.cloud.bigquery.migration.v2alpha.Filter.Builder,
                com.google.cloud.bigquery.migration.v2alpha.FilterOrBuilder>(
                getFilter(), getParentForChildren(), isClean());
        filter_ = null;
      }
      return filterBuilder_;
    }

    private java.lang.Object translationExceptionTable_ = "";
    /**
     *
     *
     * <pre>
     * Specifies the exact name of the bigquery table ("dataset.table") to be used
     * for surfacing raw translation errors. If the table does not exist, we will
     * create it. If it already exists and the schema is the same, we will re-use.
     * If the table exists and the schema is different, we will throw an error.
     * </pre>
     *
     * <code>string translation_exception_table = 13;</code>
     *
     * @return The translationExceptionTable.
     */
    public java.lang.String getTranslationExceptionTable() {
      java.lang.Object ref = translationExceptionTable_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        translationExceptionTable_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the exact name of the bigquery table ("dataset.table") to be used
     * for surfacing raw translation errors. If the table does not exist, we will
     * create it. If it already exists and the schema is the same, we will re-use.
     * If the table exists and the schema is different, we will throw an error.
     * </pre>
     *
     * <code>string translation_exception_table = 13;</code>
     *
     * @return The bytes for translationExceptionTable.
     */
    public com.google.protobuf.ByteString getTranslationExceptionTableBytes() {
      java.lang.Object ref = translationExceptionTable_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        translationExceptionTable_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the exact name of the bigquery table ("dataset.table") to be used
     * for surfacing raw translation errors. If the table does not exist, we will
     * create it. If it already exists and the schema is the same, we will re-use.
     * If the table exists and the schema is different, we will throw an error.
     * </pre>
     *
     * <code>string translation_exception_table = 13;</code>
     *
     * @param value The translationExceptionTable to set.
     * @return This builder for chaining.
     */
    public Builder setTranslationExceptionTable(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      translationExceptionTable_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the exact name of the bigquery table ("dataset.table") to be used
     * for surfacing raw translation errors. If the table does not exist, we will
     * create it. If it already exists and the schema is the same, we will re-use.
     * If the table exists and the schema is different, we will throw an error.
     * </pre>
     *
     * <code>string translation_exception_table = 13;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTranslationExceptionTable() {
      translationExceptionTable_ = getDefaultInstance().getTranslationExceptionTable();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the exact name of the bigquery table ("dataset.table") to be used
     * for surfacing raw translation errors. If the table does not exist, we will
     * create it. If it already exists and the schema is the same, we will re-use.
     * If the table exists and the schema is different, we will throw an error.
     * </pre>
     *
     * <code>string translation_exception_table = 13;</code>
     *
     * @param value The bytes for translationExceptionTable to set.
     * @return This builder for chaining.
     */
    public Builder setTranslationExceptionTableBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      translationExceptionTable_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails)
  private static final com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails();
  }

  public static com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TranslationTaskDetails> PARSER =
      new com.google.protobuf.AbstractParser<TranslationTaskDetails>() {
        @java.lang.Override
        public TranslationTaskDetails parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TranslationTaskDetails> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TranslationTaskDetails> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
