/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/reservation/v1/reservation.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.bigquery.reservation.v1;

/**
 *
 *
 * <pre>
 * Represents a BI Reservation.
 * </pre>
 *
 * Protobuf type {@code google.cloud.bigquery.reservation.v1.BiReservation}
 */
public final class BiReservation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.bigquery.reservation.v1.BiReservation)
    BiReservationOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BiReservation.newBuilder() to construct.
  private BiReservation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BiReservation() {
    name_ = "";
    preferredTables_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BiReservation();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.bigquery.reservation.v1.ReservationProto
        .internal_static_google_cloud_bigquery_reservation_v1_BiReservation_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.bigquery.reservation.v1.ReservationProto
        .internal_static_google_cloud_bigquery_reservation_v1_BiReservation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.bigquery.reservation.v1.BiReservation.class,
            com.google.cloud.bigquery.reservation.v1.BiReservation.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The resource name of the singleton BI reservation.
   * Reservation names have the form
   * `projects/{project_id}/locations/{location_id}/biReservation`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name of the singleton BI reservation.
   * Reservation names have the form
   * `projects/{project_id}/locations/{location_id}/biReservation`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The last update timestamp of a reservation.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The last update timestamp of a reservation.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The last update timestamp of a reservation.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int SIZE_FIELD_NUMBER = 4;
  private long size_ = 0L;
  /**
   *
   *
   * <pre>
   * Size of a reservation, in bytes.
   * </pre>
   *
   * <code>int64 size = 4;</code>
   *
   * @return The size.
   */
  @java.lang.Override
  public long getSize() {
    return size_;
  }

  public static final int PREFERRED_TABLES_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.bigquery.reservation.v1.TableReference> preferredTables_;
  /**
   *
   *
   * <pre>
   * Preferred tables to use BI capacity for.
   * </pre>
   *
   * <code>repeated .google.cloud.bigquery.reservation.v1.TableReference preferred_tables = 5;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.bigquery.reservation.v1.TableReference>
      getPreferredTablesList() {
    return preferredTables_;
  }
  /**
   *
   *
   * <pre>
   * Preferred tables to use BI capacity for.
   * </pre>
   *
   * <code>repeated .google.cloud.bigquery.reservation.v1.TableReference preferred_tables = 5;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.bigquery.reservation.v1.TableReferenceOrBuilder>
      getPreferredTablesOrBuilderList() {
    return preferredTables_;
  }
  /**
   *
   *
   * <pre>
   * Preferred tables to use BI capacity for.
   * </pre>
   *
   * <code>repeated .google.cloud.bigquery.reservation.v1.TableReference preferred_tables = 5;
   * </code>
   */
  @java.lang.Override
  public int getPreferredTablesCount() {
    return preferredTables_.size();
  }
  /**
   *
   *
   * <pre>
   * Preferred tables to use BI capacity for.
   * </pre>
   *
   * <code>repeated .google.cloud.bigquery.reservation.v1.TableReference preferred_tables = 5;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.reservation.v1.TableReference getPreferredTables(int index) {
    return preferredTables_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Preferred tables to use BI capacity for.
   * </pre>
   *
   * <code>repeated .google.cloud.bigquery.reservation.v1.TableReference preferred_tables = 5;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.reservation.v1.TableReferenceOrBuilder
      getPreferredTablesOrBuilder(int index) {
    return preferredTables_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getUpdateTime());
    }
    if (size_ != 0L) {
      output.writeInt64(4, size_);
    }
    for (int i = 0; i < preferredTables_.size(); i++) {
      output.writeMessage(5, preferredTables_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getUpdateTime());
    }
    if (size_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(4, size_);
    }
    for (int i = 0; i < preferredTables_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, preferredTables_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.bigquery.reservation.v1.BiReservation)) {
      return super.equals(obj);
    }
    com.google.cloud.bigquery.reservation.v1.BiReservation other =
        (com.google.cloud.bigquery.reservation.v1.BiReservation) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (getSize() != other.getSize()) return false;
    if (!getPreferredTablesList().equals(other.getPreferredTablesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + SIZE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getSize());
    if (getPreferredTablesCount() > 0) {
      hash = (37 * hash) + PREFERRED_TABLES_FIELD_NUMBER;
      hash = (53 * hash) + getPreferredTablesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.bigquery.reservation.v1.BiReservation parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.reservation.v1.BiReservation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.reservation.v1.BiReservation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.reservation.v1.BiReservation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.reservation.v1.BiReservation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.reservation.v1.BiReservation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.reservation.v1.BiReservation parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.reservation.v1.BiReservation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.reservation.v1.BiReservation parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.reservation.v1.BiReservation parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.reservation.v1.BiReservation parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.reservation.v1.BiReservation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.bigquery.reservation.v1.BiReservation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents a BI Reservation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.reservation.v1.BiReservation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.reservation.v1.BiReservation)
      com.google.cloud.bigquery.reservation.v1.BiReservationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.reservation.v1.ReservationProto
          .internal_static_google_cloud_bigquery_reservation_v1_BiReservation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.reservation.v1.ReservationProto
          .internal_static_google_cloud_bigquery_reservation_v1_BiReservation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.reservation.v1.BiReservation.class,
              com.google.cloud.bigquery.reservation.v1.BiReservation.Builder.class);
    }

    // Construct using com.google.cloud.bigquery.reservation.v1.BiReservation.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getUpdateTimeFieldBuilder();
        getPreferredTablesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      size_ = 0L;
      if (preferredTablesBuilder_ == null) {
        preferredTables_ = java.util.Collections.emptyList();
      } else {
        preferredTables_ = null;
        preferredTablesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.bigquery.reservation.v1.ReservationProto
          .internal_static_google_cloud_bigquery_reservation_v1_BiReservation_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.reservation.v1.BiReservation getDefaultInstanceForType() {
      return com.google.cloud.bigquery.reservation.v1.BiReservation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.bigquery.reservation.v1.BiReservation build() {
      com.google.cloud.bigquery.reservation.v1.BiReservation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.reservation.v1.BiReservation buildPartial() {
      com.google.cloud.bigquery.reservation.v1.BiReservation result =
          new com.google.cloud.bigquery.reservation.v1.BiReservation(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.bigquery.reservation.v1.BiReservation result) {
      if (preferredTablesBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          preferredTables_ = java.util.Collections.unmodifiableList(preferredTables_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.preferredTables_ = preferredTables_;
      } else {
        result.preferredTables_ = preferredTablesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.bigquery.reservation.v1.BiReservation result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.size_ = size_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.bigquery.reservation.v1.BiReservation) {
        return mergeFrom((com.google.cloud.bigquery.reservation.v1.BiReservation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.bigquery.reservation.v1.BiReservation other) {
      if (other == com.google.cloud.bigquery.reservation.v1.BiReservation.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.getSize() != 0L) {
        setSize(other.getSize());
      }
      if (preferredTablesBuilder_ == null) {
        if (!other.preferredTables_.isEmpty()) {
          if (preferredTables_.isEmpty()) {
            preferredTables_ = other.preferredTables_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensurePreferredTablesIsMutable();
            preferredTables_.addAll(other.preferredTables_);
          }
          onChanged();
        }
      } else {
        if (!other.preferredTables_.isEmpty()) {
          if (preferredTablesBuilder_.isEmpty()) {
            preferredTablesBuilder_.dispose();
            preferredTablesBuilder_ = null;
            preferredTables_ = other.preferredTables_;
            bitField0_ = (bitField0_ & ~0x00000008);
            preferredTablesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPreferredTablesFieldBuilder()
                    : null;
          } else {
            preferredTablesBuilder_.addAllMessages(other.preferredTables_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 26:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 26
            case 32:
              {
                size_ = input.readInt64();
                bitField0_ |= 0x00000004;
                break;
              } // case 32
            case 42:
              {
                com.google.cloud.bigquery.reservation.v1.TableReference m =
                    input.readMessage(
                        com.google.cloud.bigquery.reservation.v1.TableReference.parser(),
                        extensionRegistry);
                if (preferredTablesBuilder_ == null) {
                  ensurePreferredTablesIsMutable();
                  preferredTables_.add(m);
                } else {
                  preferredTablesBuilder_.addMessage(m);
                }
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The resource name of the singleton BI reservation.
     * Reservation names have the form
     * `projects/{project_id}/locations/{location_id}/biReservation`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the singleton BI reservation.
     * Reservation names have the form
     * `projects/{project_id}/locations/{location_id}/biReservation`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the singleton BI reservation.
     * Reservation names have the form
     * `projects/{project_id}/locations/{location_id}/biReservation`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the singleton BI reservation.
     * Reservation names have the form
     * `projects/{project_id}/locations/{location_id}/biReservation`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the singleton BI reservation.
     * Reservation names have the form
     * `projects/{project_id}/locations/{location_id}/biReservation`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a reservation.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a reservation.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a reservation.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a reservation.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a reservation.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a reservation.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a reservation.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a reservation.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a reservation.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private long size_;
    /**
     *
     *
     * <pre>
     * Size of a reservation, in bytes.
     * </pre>
     *
     * <code>int64 size = 4;</code>
     *
     * @return The size.
     */
    @java.lang.Override
    public long getSize() {
      return size_;
    }
    /**
     *
     *
     * <pre>
     * Size of a reservation, in bytes.
     * </pre>
     *
     * <code>int64 size = 4;</code>
     *
     * @param value The size to set.
     * @return This builder for chaining.
     */
    public Builder setSize(long value) {

      size_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Size of a reservation, in bytes.
     * </pre>
     *
     * <code>int64 size = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSize() {
      bitField0_ = (bitField0_ & ~0x00000004);
      size_ = 0L;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.bigquery.reservation.v1.TableReference>
        preferredTables_ = java.util.Collections.emptyList();

    private void ensurePreferredTablesIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        preferredTables_ =
            new java.util.ArrayList<com.google.cloud.bigquery.reservation.v1.TableReference>(
                preferredTables_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.bigquery.reservation.v1.TableReference,
            com.google.cloud.bigquery.reservation.v1.TableReference.Builder,
            com.google.cloud.bigquery.reservation.v1.TableReferenceOrBuilder>
        preferredTablesBuilder_;

    /**
     *
     *
     * <pre>
     * Preferred tables to use BI capacity for.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.reservation.v1.TableReference preferred_tables = 5;
     * </code>
     */
    public java.util.List<com.google.cloud.bigquery.reservation.v1.TableReference>
        getPreferredTablesList() {
      if (preferredTablesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(preferredTables_);
      } else {
        return preferredTablesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Preferred tables to use BI capacity for.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.reservation.v1.TableReference preferred_tables = 5;
     * </code>
     */
    public int getPreferredTablesCount() {
      if (preferredTablesBuilder_ == null) {
        return preferredTables_.size();
      } else {
        return preferredTablesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Preferred tables to use BI capacity for.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.reservation.v1.TableReference preferred_tables = 5;
     * </code>
     */
    public com.google.cloud.bigquery.reservation.v1.TableReference getPreferredTables(int index) {
      if (preferredTablesBuilder_ == null) {
        return preferredTables_.get(index);
      } else {
        return preferredTablesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Preferred tables to use BI capacity for.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.reservation.v1.TableReference preferred_tables = 5;
     * </code>
     */
    public Builder setPreferredTables(
        int index, com.google.cloud.bigquery.reservation.v1.TableReference value) {
      if (preferredTablesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePreferredTablesIsMutable();
        preferredTables_.set(index, value);
        onChanged();
      } else {
        preferredTablesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Preferred tables to use BI capacity for.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.reservation.v1.TableReference preferred_tables = 5;
     * </code>
     */
    public Builder setPreferredTables(
        int index,
        com.google.cloud.bigquery.reservation.v1.TableReference.Builder builderForValue) {
      if (preferredTablesBuilder_ == null) {
        ensurePreferredTablesIsMutable();
        preferredTables_.set(index, builderForValue.build());
        onChanged();
      } else {
        preferredTablesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Preferred tables to use BI capacity for.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.reservation.v1.TableReference preferred_tables = 5;
     * </code>
     */
    public Builder addPreferredTables(
        com.google.cloud.bigquery.reservation.v1.TableReference value) {
      if (preferredTablesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePreferredTablesIsMutable();
        preferredTables_.add(value);
        onChanged();
      } else {
        preferredTablesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Preferred tables to use BI capacity for.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.reservation.v1.TableReference preferred_tables = 5;
     * </code>
     */
    public Builder addPreferredTables(
        int index, com.google.cloud.bigquery.reservation.v1.TableReference value) {
      if (preferredTablesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePreferredTablesIsMutable();
        preferredTables_.add(index, value);
        onChanged();
      } else {
        preferredTablesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Preferred tables to use BI capacity for.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.reservation.v1.TableReference preferred_tables = 5;
     * </code>
     */
    public Builder addPreferredTables(
        com.google.cloud.bigquery.reservation.v1.TableReference.Builder builderForValue) {
      if (preferredTablesBuilder_ == null) {
        ensurePreferredTablesIsMutable();
        preferredTables_.add(builderForValue.build());
        onChanged();
      } else {
        preferredTablesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Preferred tables to use BI capacity for.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.reservation.v1.TableReference preferred_tables = 5;
     * </code>
     */
    public Builder addPreferredTables(
        int index,
        com.google.cloud.bigquery.reservation.v1.TableReference.Builder builderForValue) {
      if (preferredTablesBuilder_ == null) {
        ensurePreferredTablesIsMutable();
        preferredTables_.add(index, builderForValue.build());
        onChanged();
      } else {
        preferredTablesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Preferred tables to use BI capacity for.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.reservation.v1.TableReference preferred_tables = 5;
     * </code>
     */
    public Builder addAllPreferredTables(
        java.lang.Iterable<? extends com.google.cloud.bigquery.reservation.v1.TableReference>
            values) {
      if (preferredTablesBuilder_ == null) {
        ensurePreferredTablesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, preferredTables_);
        onChanged();
      } else {
        preferredTablesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Preferred tables to use BI capacity for.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.reservation.v1.TableReference preferred_tables = 5;
     * </code>
     */
    public Builder clearPreferredTables() {
      if (preferredTablesBuilder_ == null) {
        preferredTables_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        preferredTablesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Preferred tables to use BI capacity for.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.reservation.v1.TableReference preferred_tables = 5;
     * </code>
     */
    public Builder removePreferredTables(int index) {
      if (preferredTablesBuilder_ == null) {
        ensurePreferredTablesIsMutable();
        preferredTables_.remove(index);
        onChanged();
      } else {
        preferredTablesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Preferred tables to use BI capacity for.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.reservation.v1.TableReference preferred_tables = 5;
     * </code>
     */
    public com.google.cloud.bigquery.reservation.v1.TableReference.Builder
        getPreferredTablesBuilder(int index) {
      return getPreferredTablesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Preferred tables to use BI capacity for.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.reservation.v1.TableReference preferred_tables = 5;
     * </code>
     */
    public com.google.cloud.bigquery.reservation.v1.TableReferenceOrBuilder
        getPreferredTablesOrBuilder(int index) {
      if (preferredTablesBuilder_ == null) {
        return preferredTables_.get(index);
      } else {
        return preferredTablesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Preferred tables to use BI capacity for.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.reservation.v1.TableReference preferred_tables = 5;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.bigquery.reservation.v1.TableReferenceOrBuilder>
        getPreferredTablesOrBuilderList() {
      if (preferredTablesBuilder_ != null) {
        return preferredTablesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(preferredTables_);
      }
    }
    /**
     *
     *
     * <pre>
     * Preferred tables to use BI capacity for.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.reservation.v1.TableReference preferred_tables = 5;
     * </code>
     */
    public com.google.cloud.bigquery.reservation.v1.TableReference.Builder
        addPreferredTablesBuilder() {
      return getPreferredTablesFieldBuilder()
          .addBuilder(com.google.cloud.bigquery.reservation.v1.TableReference.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Preferred tables to use BI capacity for.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.reservation.v1.TableReference preferred_tables = 5;
     * </code>
     */
    public com.google.cloud.bigquery.reservation.v1.TableReference.Builder
        addPreferredTablesBuilder(int index) {
      return getPreferredTablesFieldBuilder()
          .addBuilder(
              index, com.google.cloud.bigquery.reservation.v1.TableReference.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Preferred tables to use BI capacity for.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.reservation.v1.TableReference preferred_tables = 5;
     * </code>
     */
    public java.util.List<com.google.cloud.bigquery.reservation.v1.TableReference.Builder>
        getPreferredTablesBuilderList() {
      return getPreferredTablesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.bigquery.reservation.v1.TableReference,
            com.google.cloud.bigquery.reservation.v1.TableReference.Builder,
            com.google.cloud.bigquery.reservation.v1.TableReferenceOrBuilder>
        getPreferredTablesFieldBuilder() {
      if (preferredTablesBuilder_ == null) {
        preferredTablesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.bigquery.reservation.v1.TableReference,
                com.google.cloud.bigquery.reservation.v1.TableReference.Builder,
                com.google.cloud.bigquery.reservation.v1.TableReferenceOrBuilder>(
                preferredTables_,
                ((bitField0_ & 0x00000008) != 0),
                getParentForChildren(),
                isClean());
        preferredTables_ = null;
      }
      return preferredTablesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.reservation.v1.BiReservation)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.bigquery.reservation.v1.BiReservation)
  private static final com.google.cloud.bigquery.reservation.v1.BiReservation DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.bigquery.reservation.v1.BiReservation();
  }

  public static com.google.cloud.bigquery.reservation.v1.BiReservation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BiReservation> PARSER =
      new com.google.protobuf.AbstractParser<BiReservation>() {
        @java.lang.Override
        public BiReservation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BiReservation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BiReservation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.bigquery.reservation.v1.BiReservation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
