/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/reservation/v1/reservation.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.bigquery.reservation.v1;

/**
 *
 *
 * <pre>
 * Capacity commitment is a way to purchase compute capacity for BigQuery jobs
 * (in the form of slots) with some committed period of usage. Annual
 * commitments renew by default. Commitments can be removed after their
 * commitment end time passes.
 *
 * In order to remove annual commitment, its plan needs to be changed
 * to monthly or flex first.
 *
 * A capacity commitment resource exists as a child resource of the admin
 * project.
 * </pre>
 *
 * Protobuf type {@code google.cloud.bigquery.reservation.v1.CapacityCommitment}
 */
public final class CapacityCommitment extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.bigquery.reservation.v1.CapacityCommitment)
    CapacityCommitmentOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CapacityCommitment.newBuilder() to construct.
  private CapacityCommitment(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CapacityCommitment() {
    name_ = "";
    plan_ = 0;
    state_ = 0;
    renewalPlan_ = 0;
    edition_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CapacityCommitment();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.bigquery.reservation.v1.ReservationProto
        .internal_static_google_cloud_bigquery_reservation_v1_CapacityCommitment_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.bigquery.reservation.v1.ReservationProto
        .internal_static_google_cloud_bigquery_reservation_v1_CapacityCommitment_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.bigquery.reservation.v1.CapacityCommitment.class,
            com.google.cloud.bigquery.reservation.v1.CapacityCommitment.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Commitment plan defines the current committed period. Capacity commitment
   * cannot be deleted during it's committed period.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.bigquery.reservation.v1.CapacityCommitment.CommitmentPlan}
   */
  public enum CommitmentPlan implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Invalid plan value. Requests with this value will be rejected with
     * error code `google.rpc.Code.INVALID_ARGUMENT`.
     * </pre>
     *
     * <code>COMMITMENT_PLAN_UNSPECIFIED = 0;</code>
     */
    COMMITMENT_PLAN_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Flex commitments have committed period of 1 minute after becoming ACTIVE.
     * After that, they are not in a committed period anymore and can be removed
     * any time.
     * </pre>
     *
     * <code>FLEX = 3;</code>
     */
    FLEX(3),
    /**
     *
     *
     * <pre>
     * Same as FLEX, should only be used if flat-rate commitments are still
     * available.
     * </pre>
     *
     * <code>FLEX_FLAT_RATE = 7 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    FLEX_FLAT_RATE(7),
    /**
     *
     *
     * <pre>
     * Trial commitments have a committed period of 182 days after becoming
     * ACTIVE. After that, they are converted to a new commitment based on the
     * `renewal_plan`. Default `renewal_plan` for Trial commitment is Flex so
     * that it can be deleted right after committed period ends.
     * </pre>
     *
     * <code>TRIAL = 5;</code>
     */
    TRIAL(5),
    /**
     *
     *
     * <pre>
     * Monthly commitments have a committed period of 30 days after becoming
     * ACTIVE. After that, they are not in a committed period anymore and can be
     * removed any time.
     * </pre>
     *
     * <code>MONTHLY = 2;</code>
     */
    MONTHLY(2),
    /**
     *
     *
     * <pre>
     * Same as MONTHLY, should only be used if flat-rate commitments are still
     * available.
     * </pre>
     *
     * <code>MONTHLY_FLAT_RATE = 8 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    MONTHLY_FLAT_RATE(8),
    /**
     *
     *
     * <pre>
     * Annual commitments have a committed period of 365 days after becoming
     * ACTIVE. After that they are converted to a new commitment based on the
     * renewal_plan.
     * </pre>
     *
     * <code>ANNUAL = 4;</code>
     */
    ANNUAL(4),
    /**
     *
     *
     * <pre>
     * Same as ANNUAL, should only be used if flat-rate commitments are still
     * available.
     * </pre>
     *
     * <code>ANNUAL_FLAT_RATE = 9 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    ANNUAL_FLAT_RATE(9),
    /**
     *
     *
     * <pre>
     * 3-year commitments have a committed period of 1095(3 * 365) days after
     * becoming ACTIVE. After that they are converted to a new commitment based
     * on the renewal_plan.
     * </pre>
     *
     * <code>THREE_YEAR = 10;</code>
     */
    THREE_YEAR(10),
    /**
     *
     *
     * <pre>
     * Should only be used for `renewal_plan` and is only meaningful if
     * edition is specified to values other than EDITION_UNSPECIFIED. Otherwise
     * CreateCapacityCommitmentRequest or UpdateCapacityCommitmentRequest will
     * be rejected with error code `google.rpc.Code.INVALID_ARGUMENT`. If the
     * renewal_plan is NONE, capacity commitment will be removed at the end of
     * its commitment period.
     * </pre>
     *
     * <code>NONE = 6;</code>
     */
    NONE(6),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Invalid plan value. Requests with this value will be rejected with
     * error code `google.rpc.Code.INVALID_ARGUMENT`.
     * </pre>
     *
     * <code>COMMITMENT_PLAN_UNSPECIFIED = 0;</code>
     */
    public static final int COMMITMENT_PLAN_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Flex commitments have committed period of 1 minute after becoming ACTIVE.
     * After that, they are not in a committed period anymore and can be removed
     * any time.
     * </pre>
     *
     * <code>FLEX = 3;</code>
     */
    public static final int FLEX_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Same as FLEX, should only be used if flat-rate commitments are still
     * available.
     * </pre>
     *
     * <code>FLEX_FLAT_RATE = 7 [deprecated = true];</code>
     */
    @java.lang.Deprecated public static final int FLEX_FLAT_RATE_VALUE = 7;
    /**
     *
     *
     * <pre>
     * Trial commitments have a committed period of 182 days after becoming
     * ACTIVE. After that, they are converted to a new commitment based on the
     * `renewal_plan`. Default `renewal_plan` for Trial commitment is Flex so
     * that it can be deleted right after committed period ends.
     * </pre>
     *
     * <code>TRIAL = 5;</code>
     */
    public static final int TRIAL_VALUE = 5;
    /**
     *
     *
     * <pre>
     * Monthly commitments have a committed period of 30 days after becoming
     * ACTIVE. After that, they are not in a committed period anymore and can be
     * removed any time.
     * </pre>
     *
     * <code>MONTHLY = 2;</code>
     */
    public static final int MONTHLY_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Same as MONTHLY, should only be used if flat-rate commitments are still
     * available.
     * </pre>
     *
     * <code>MONTHLY_FLAT_RATE = 8 [deprecated = true];</code>
     */
    @java.lang.Deprecated public static final int MONTHLY_FLAT_RATE_VALUE = 8;
    /**
     *
     *
     * <pre>
     * Annual commitments have a committed period of 365 days after becoming
     * ACTIVE. After that they are converted to a new commitment based on the
     * renewal_plan.
     * </pre>
     *
     * <code>ANNUAL = 4;</code>
     */
    public static final int ANNUAL_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Same as ANNUAL, should only be used if flat-rate commitments are still
     * available.
     * </pre>
     *
     * <code>ANNUAL_FLAT_RATE = 9 [deprecated = true];</code>
     */
    @java.lang.Deprecated public static final int ANNUAL_FLAT_RATE_VALUE = 9;
    /**
     *
     *
     * <pre>
     * 3-year commitments have a committed period of 1095(3 * 365) days after
     * becoming ACTIVE. After that they are converted to a new commitment based
     * on the renewal_plan.
     * </pre>
     *
     * <code>THREE_YEAR = 10;</code>
     */
    public static final int THREE_YEAR_VALUE = 10;
    /**
     *
     *
     * <pre>
     * Should only be used for `renewal_plan` and is only meaningful if
     * edition is specified to values other than EDITION_UNSPECIFIED. Otherwise
     * CreateCapacityCommitmentRequest or UpdateCapacityCommitmentRequest will
     * be rejected with error code `google.rpc.Code.INVALID_ARGUMENT`. If the
     * renewal_plan is NONE, capacity commitment will be removed at the end of
     * its commitment period.
     * </pre>
     *
     * <code>NONE = 6;</code>
     */
    public static final int NONE_VALUE = 6;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static CommitmentPlan valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static CommitmentPlan forNumber(int value) {
      switch (value) {
        case 0:
          return COMMITMENT_PLAN_UNSPECIFIED;
        case 3:
          return FLEX;
        case 7:
          return FLEX_FLAT_RATE;
        case 5:
          return TRIAL;
        case 2:
          return MONTHLY;
        case 8:
          return MONTHLY_FLAT_RATE;
        case 4:
          return ANNUAL;
        case 9:
          return ANNUAL_FLAT_RATE;
        case 10:
          return THREE_YEAR;
        case 6:
          return NONE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<CommitmentPlan> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<CommitmentPlan> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<CommitmentPlan>() {
          public CommitmentPlan findValueByNumber(int number) {
            return CommitmentPlan.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.bigquery.reservation.v1.CapacityCommitment.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final CommitmentPlan[] VALUES = values();

    public static CommitmentPlan valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private CommitmentPlan(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.bigquery.reservation.v1.CapacityCommitment.CommitmentPlan)
  }

  /**
   *
   *
   * <pre>
   * Capacity commitment can either become ACTIVE right away or transition
   * from PENDING to ACTIVE or FAILED.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.bigquery.reservation.v1.CapacityCommitment.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Invalid state value.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Capacity commitment is pending provisioning. Pending capacity commitment
     * does not contribute to the project's slot_capacity.
     * </pre>
     *
     * <code>PENDING = 1;</code>
     */
    PENDING(1),
    /**
     *
     *
     * <pre>
     * Once slots are provisioned, capacity commitment becomes active.
     * slot_count is added to the project's slot_capacity.
     * </pre>
     *
     * <code>ACTIVE = 2;</code>
     */
    ACTIVE(2),
    /**
     *
     *
     * <pre>
     * Capacity commitment is failed to be activated by the backend.
     * </pre>
     *
     * <code>FAILED = 3;</code>
     */
    FAILED(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Invalid state value.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Capacity commitment is pending provisioning. Pending capacity commitment
     * does not contribute to the project's slot_capacity.
     * </pre>
     *
     * <code>PENDING = 1;</code>
     */
    public static final int PENDING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Once slots are provisioned, capacity commitment becomes active.
     * slot_count is added to the project's slot_capacity.
     * </pre>
     *
     * <code>ACTIVE = 2;</code>
     */
    public static final int ACTIVE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Capacity commitment is failed to be activated by the backend.
     * </pre>
     *
     * <code>FAILED = 3;</code>
     */
    public static final int FAILED_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return PENDING;
        case 2:
          return ACTIVE;
        case 3:
          return FAILED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.bigquery.reservation.v1.CapacityCommitment.getDescriptor()
          .getEnumTypes()
          .get(1);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.bigquery.reservation.v1.CapacityCommitment.State)
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the capacity commitment, e.g.,
   * `projects/myproject/locations/US/capacityCommitments/123`
   * The commitment_id must only contain lower case alphanumeric characters or
   * dashes. It must start with a letter and must not end
   * with a dash. Its maximum length is 64 characters.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the capacity commitment, e.g.,
   * `projects/myproject/locations/US/capacityCommitments/123`
   * The commitment_id must only contain lower case alphanumeric characters or
   * dashes. It must start with a letter and must not end
   * with a dash. Its maximum length is 64 characters.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SLOT_COUNT_FIELD_NUMBER = 2;
  private long slotCount_ = 0L;
  /**
   *
   *
   * <pre>
   * Number of slots in this commitment.
   * </pre>
   *
   * <code>int64 slot_count = 2;</code>
   *
   * @return The slotCount.
   */
  @java.lang.Override
  public long getSlotCount() {
    return slotCount_;
  }

  public static final int PLAN_FIELD_NUMBER = 3;
  private int plan_ = 0;
  /**
   *
   *
   * <pre>
   * Capacity commitment commitment plan.
   * </pre>
   *
   * <code>.google.cloud.bigquery.reservation.v1.CapacityCommitment.CommitmentPlan plan = 3;</code>
   *
   * @return The enum numeric value on the wire for plan.
   */
  @java.lang.Override
  public int getPlanValue() {
    return plan_;
  }
  /**
   *
   *
   * <pre>
   * Capacity commitment commitment plan.
   * </pre>
   *
   * <code>.google.cloud.bigquery.reservation.v1.CapacityCommitment.CommitmentPlan plan = 3;</code>
   *
   * @return The plan.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.reservation.v1.CapacityCommitment.CommitmentPlan getPlan() {
    com.google.cloud.bigquery.reservation.v1.CapacityCommitment.CommitmentPlan result =
        com.google.cloud.bigquery.reservation.v1.CapacityCommitment.CommitmentPlan.forNumber(plan_);
    return result == null
        ? com.google.cloud.bigquery.reservation.v1.CapacityCommitment.CommitmentPlan.UNRECOGNIZED
        : result;
  }

  public static final int STATE_FIELD_NUMBER = 4;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. State of the commitment.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.reservation.v1.CapacityCommitment.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. State of the commitment.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.reservation.v1.CapacityCommitment.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.reservation.v1.CapacityCommitment.State getState() {
    com.google.cloud.bigquery.reservation.v1.CapacityCommitment.State result =
        com.google.cloud.bigquery.reservation.v1.CapacityCommitment.State.forNumber(state_);
    return result == null
        ? com.google.cloud.bigquery.reservation.v1.CapacityCommitment.State.UNRECOGNIZED
        : result;
  }

  public static final int COMMITMENT_START_TIME_FIELD_NUMBER = 9;
  private com.google.protobuf.Timestamp commitmentStartTime_;
  /**
   *
   *
   * <pre>
   * Output only. The start of the current commitment period. It is applicable
   * only for ACTIVE capacity commitments.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp commitment_start_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the commitmentStartTime field is set.
   */
  @java.lang.Override
  public boolean hasCommitmentStartTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The start of the current commitment period. It is applicable
   * only for ACTIVE capacity commitments.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp commitment_start_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The commitmentStartTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCommitmentStartTime() {
    return commitmentStartTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : commitmentStartTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The start of the current commitment period. It is applicable
   * only for ACTIVE capacity commitments.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp commitment_start_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCommitmentStartTimeOrBuilder() {
    return commitmentStartTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : commitmentStartTime_;
  }

  public static final int COMMITMENT_END_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp commitmentEndTime_;
  /**
   *
   *
   * <pre>
   * Output only. The end of the current commitment period. It is applicable
   * only for ACTIVE capacity commitments.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp commitment_end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the commitmentEndTime field is set.
   */
  @java.lang.Override
  public boolean hasCommitmentEndTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The end of the current commitment period. It is applicable
   * only for ACTIVE capacity commitments.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp commitment_end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The commitmentEndTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCommitmentEndTime() {
    return commitmentEndTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : commitmentEndTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The end of the current commitment period. It is applicable
   * only for ACTIVE capacity commitments.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp commitment_end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCommitmentEndTimeOrBuilder() {
    return commitmentEndTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : commitmentEndTime_;
  }

  public static final int FAILURE_STATUS_FIELD_NUMBER = 7;
  private com.google.rpc.Status failureStatus_;
  /**
   *
   *
   * <pre>
   * Output only. For FAILED commitment plan, provides the reason of failure.
   * </pre>
   *
   * <code>.google.rpc.Status failure_status = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the failureStatus field is set.
   */
  @java.lang.Override
  public boolean hasFailureStatus() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. For FAILED commitment plan, provides the reason of failure.
   * </pre>
   *
   * <code>.google.rpc.Status failure_status = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The failureStatus.
   */
  @java.lang.Override
  public com.google.rpc.Status getFailureStatus() {
    return failureStatus_ == null ? com.google.rpc.Status.getDefaultInstance() : failureStatus_;
  }
  /**
   *
   *
   * <pre>
   * Output only. For FAILED commitment plan, provides the reason of failure.
   * </pre>
   *
   * <code>.google.rpc.Status failure_status = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getFailureStatusOrBuilder() {
    return failureStatus_ == null ? com.google.rpc.Status.getDefaultInstance() : failureStatus_;
  }

  public static final int RENEWAL_PLAN_FIELD_NUMBER = 8;
  private int renewalPlan_ = 0;
  /**
   *
   *
   * <pre>
   * The plan this capacity commitment is converted to after commitment_end_time
   * passes. Once the plan is changed, committed period is extended according to
   * commitment plan. Only applicable for ANNUAL and TRIAL commitments.
   * </pre>
   *
   * <code>.google.cloud.bigquery.reservation.v1.CapacityCommitment.CommitmentPlan renewal_plan = 8;
   * </code>
   *
   * @return The enum numeric value on the wire for renewalPlan.
   */
  @java.lang.Override
  public int getRenewalPlanValue() {
    return renewalPlan_;
  }
  /**
   *
   *
   * <pre>
   * The plan this capacity commitment is converted to after commitment_end_time
   * passes. Once the plan is changed, committed period is extended according to
   * commitment plan. Only applicable for ANNUAL and TRIAL commitments.
   * </pre>
   *
   * <code>.google.cloud.bigquery.reservation.v1.CapacityCommitment.CommitmentPlan renewal_plan = 8;
   * </code>
   *
   * @return The renewalPlan.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.reservation.v1.CapacityCommitment.CommitmentPlan
      getRenewalPlan() {
    com.google.cloud.bigquery.reservation.v1.CapacityCommitment.CommitmentPlan result =
        com.google.cloud.bigquery.reservation.v1.CapacityCommitment.CommitmentPlan.forNumber(
            renewalPlan_);
    return result == null
        ? com.google.cloud.bigquery.reservation.v1.CapacityCommitment.CommitmentPlan.UNRECOGNIZED
        : result;
  }

  public static final int MULTI_REGION_AUXILIARY_FIELD_NUMBER = 10;
  private boolean multiRegionAuxiliary_ = false;
  /**
   *
   *
   * <pre>
   * Applicable only for commitments located within one of the BigQuery
   * multi-regions (US or EU).
   *
   * If set to true, this commitment is placed in the organization's
   * secondary region which is designated for disaster recovery purposes.
   * If false, this commitment is placed in the organization's default region.
   *
   * NOTE: this is a preview feature. Project must be allow-listed in order to
   * set this field.
   * </pre>
   *
   * <code>bool multi_region_auxiliary = 10;</code>
   *
   * @return The multiRegionAuxiliary.
   */
  @java.lang.Override
  public boolean getMultiRegionAuxiliary() {
    return multiRegionAuxiliary_;
  }

  public static final int EDITION_FIELD_NUMBER = 12;
  private int edition_ = 0;
  /**
   *
   *
   * <pre>
   * Edition of the capacity commitment.
   * </pre>
   *
   * <code>.google.cloud.bigquery.reservation.v1.Edition edition = 12;</code>
   *
   * @return The enum numeric value on the wire for edition.
   */
  @java.lang.Override
  public int getEditionValue() {
    return edition_;
  }
  /**
   *
   *
   * <pre>
   * Edition of the capacity commitment.
   * </pre>
   *
   * <code>.google.cloud.bigquery.reservation.v1.Edition edition = 12;</code>
   *
   * @return The edition.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.reservation.v1.Edition getEdition() {
    com.google.cloud.bigquery.reservation.v1.Edition result =
        com.google.cloud.bigquery.reservation.v1.Edition.forNumber(edition_);
    return result == null ? com.google.cloud.bigquery.reservation.v1.Edition.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (slotCount_ != 0L) {
      output.writeInt64(2, slotCount_);
    }
    if (plan_
        != com.google.cloud.bigquery.reservation.v1.CapacityCommitment.CommitmentPlan
            .COMMITMENT_PLAN_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, plan_);
    }
    if (state_
        != com.google.cloud.bigquery.reservation.v1.CapacityCommitment.State.STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(4, state_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(5, getCommitmentEndTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(7, getFailureStatus());
    }
    if (renewalPlan_
        != com.google.cloud.bigquery.reservation.v1.CapacityCommitment.CommitmentPlan
            .COMMITMENT_PLAN_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(8, renewalPlan_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(9, getCommitmentStartTime());
    }
    if (multiRegionAuxiliary_ != false) {
      output.writeBool(10, multiRegionAuxiliary_);
    }
    if (edition_
        != com.google.cloud.bigquery.reservation.v1.Edition.EDITION_UNSPECIFIED.getNumber()) {
      output.writeEnum(12, edition_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (slotCount_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, slotCount_);
    }
    if (plan_
        != com.google.cloud.bigquery.reservation.v1.CapacityCommitment.CommitmentPlan
            .COMMITMENT_PLAN_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, plan_);
    }
    if (state_
        != com.google.cloud.bigquery.reservation.v1.CapacityCommitment.State.STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, state_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getCommitmentEndTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getFailureStatus());
    }
    if (renewalPlan_
        != com.google.cloud.bigquery.reservation.v1.CapacityCommitment.CommitmentPlan
            .COMMITMENT_PLAN_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(8, renewalPlan_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getCommitmentStartTime());
    }
    if (multiRegionAuxiliary_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(10, multiRegionAuxiliary_);
    }
    if (edition_
        != com.google.cloud.bigquery.reservation.v1.Edition.EDITION_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(12, edition_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.bigquery.reservation.v1.CapacityCommitment)) {
      return super.equals(obj);
    }
    com.google.cloud.bigquery.reservation.v1.CapacityCommitment other =
        (com.google.cloud.bigquery.reservation.v1.CapacityCommitment) obj;

    if (!getName().equals(other.getName())) return false;
    if (getSlotCount() != other.getSlotCount()) return false;
    if (plan_ != other.plan_) return false;
    if (state_ != other.state_) return false;
    if (hasCommitmentStartTime() != other.hasCommitmentStartTime()) return false;
    if (hasCommitmentStartTime()) {
      if (!getCommitmentStartTime().equals(other.getCommitmentStartTime())) return false;
    }
    if (hasCommitmentEndTime() != other.hasCommitmentEndTime()) return false;
    if (hasCommitmentEndTime()) {
      if (!getCommitmentEndTime().equals(other.getCommitmentEndTime())) return false;
    }
    if (hasFailureStatus() != other.hasFailureStatus()) return false;
    if (hasFailureStatus()) {
      if (!getFailureStatus().equals(other.getFailureStatus())) return false;
    }
    if (renewalPlan_ != other.renewalPlan_) return false;
    if (getMultiRegionAuxiliary() != other.getMultiRegionAuxiliary()) return false;
    if (edition_ != other.edition_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + SLOT_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getSlotCount());
    hash = (37 * hash) + PLAN_FIELD_NUMBER;
    hash = (53 * hash) + plan_;
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    if (hasCommitmentStartTime()) {
      hash = (37 * hash) + COMMITMENT_START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCommitmentStartTime().hashCode();
    }
    if (hasCommitmentEndTime()) {
      hash = (37 * hash) + COMMITMENT_END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCommitmentEndTime().hashCode();
    }
    if (hasFailureStatus()) {
      hash = (37 * hash) + FAILURE_STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getFailureStatus().hashCode();
    }
    hash = (37 * hash) + RENEWAL_PLAN_FIELD_NUMBER;
    hash = (53 * hash) + renewalPlan_;
    hash = (37 * hash) + MULTI_REGION_AUXILIARY_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getMultiRegionAuxiliary());
    hash = (37 * hash) + EDITION_FIELD_NUMBER;
    hash = (53 * hash) + edition_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.bigquery.reservation.v1.CapacityCommitment parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.reservation.v1.CapacityCommitment parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.reservation.v1.CapacityCommitment parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.reservation.v1.CapacityCommitment parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.reservation.v1.CapacityCommitment parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.reservation.v1.CapacityCommitment parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.reservation.v1.CapacityCommitment parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.reservation.v1.CapacityCommitment parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.reservation.v1.CapacityCommitment parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.reservation.v1.CapacityCommitment parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.reservation.v1.CapacityCommitment parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.reservation.v1.CapacityCommitment parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.bigquery.reservation.v1.CapacityCommitment prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Capacity commitment is a way to purchase compute capacity for BigQuery jobs
   * (in the form of slots) with some committed period of usage. Annual
   * commitments renew by default. Commitments can be removed after their
   * commitment end time passes.
   *
   * In order to remove annual commitment, its plan needs to be changed
   * to monthly or flex first.
   *
   * A capacity commitment resource exists as a child resource of the admin
   * project.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.reservation.v1.CapacityCommitment}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.reservation.v1.CapacityCommitment)
      com.google.cloud.bigquery.reservation.v1.CapacityCommitmentOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.reservation.v1.ReservationProto
          .internal_static_google_cloud_bigquery_reservation_v1_CapacityCommitment_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.reservation.v1.ReservationProto
          .internal_static_google_cloud_bigquery_reservation_v1_CapacityCommitment_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.reservation.v1.CapacityCommitment.class,
              com.google.cloud.bigquery.reservation.v1.CapacityCommitment.Builder.class);
    }

    // Construct using com.google.cloud.bigquery.reservation.v1.CapacityCommitment.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCommitmentStartTimeFieldBuilder();
        getCommitmentEndTimeFieldBuilder();
        getFailureStatusFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      slotCount_ = 0L;
      plan_ = 0;
      state_ = 0;
      commitmentStartTime_ = null;
      if (commitmentStartTimeBuilder_ != null) {
        commitmentStartTimeBuilder_.dispose();
        commitmentStartTimeBuilder_ = null;
      }
      commitmentEndTime_ = null;
      if (commitmentEndTimeBuilder_ != null) {
        commitmentEndTimeBuilder_.dispose();
        commitmentEndTimeBuilder_ = null;
      }
      failureStatus_ = null;
      if (failureStatusBuilder_ != null) {
        failureStatusBuilder_.dispose();
        failureStatusBuilder_ = null;
      }
      renewalPlan_ = 0;
      multiRegionAuxiliary_ = false;
      edition_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.bigquery.reservation.v1.ReservationProto
          .internal_static_google_cloud_bigquery_reservation_v1_CapacityCommitment_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.reservation.v1.CapacityCommitment getDefaultInstanceForType() {
      return com.google.cloud.bigquery.reservation.v1.CapacityCommitment.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.bigquery.reservation.v1.CapacityCommitment build() {
      com.google.cloud.bigquery.reservation.v1.CapacityCommitment result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.reservation.v1.CapacityCommitment buildPartial() {
      com.google.cloud.bigquery.reservation.v1.CapacityCommitment result =
          new com.google.cloud.bigquery.reservation.v1.CapacityCommitment(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.bigquery.reservation.v1.CapacityCommitment result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.slotCount_ = slotCount_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.plan_ = plan_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.state_ = state_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.commitmentStartTime_ =
            commitmentStartTimeBuilder_ == null
                ? commitmentStartTime_
                : commitmentStartTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.commitmentEndTime_ =
            commitmentEndTimeBuilder_ == null
                ? commitmentEndTime_
                : commitmentEndTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.failureStatus_ =
            failureStatusBuilder_ == null ? failureStatus_ : failureStatusBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.renewalPlan_ = renewalPlan_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.multiRegionAuxiliary_ = multiRegionAuxiliary_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.edition_ = edition_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.bigquery.reservation.v1.CapacityCommitment) {
        return mergeFrom((com.google.cloud.bigquery.reservation.v1.CapacityCommitment) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.bigquery.reservation.v1.CapacityCommitment other) {
      if (other == com.google.cloud.bigquery.reservation.v1.CapacityCommitment.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.getSlotCount() != 0L) {
        setSlotCount(other.getSlotCount());
      }
      if (other.plan_ != 0) {
        setPlanValue(other.getPlanValue());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.hasCommitmentStartTime()) {
        mergeCommitmentStartTime(other.getCommitmentStartTime());
      }
      if (other.hasCommitmentEndTime()) {
        mergeCommitmentEndTime(other.getCommitmentEndTime());
      }
      if (other.hasFailureStatus()) {
        mergeFailureStatus(other.getFailureStatus());
      }
      if (other.renewalPlan_ != 0) {
        setRenewalPlanValue(other.getRenewalPlanValue());
      }
      if (other.getMultiRegionAuxiliary() != false) {
        setMultiRegionAuxiliary(other.getMultiRegionAuxiliary());
      }
      if (other.edition_ != 0) {
        setEditionValue(other.getEditionValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                slotCount_ = input.readInt64();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 24:
              {
                plan_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 32:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 42:
              {
                input.readMessage(
                    getCommitmentEndTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 42
            case 58:
              {
                input.readMessage(getFailureStatusFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 64:
              {
                renewalPlan_ = input.readEnum();
                bitField0_ |= 0x00000080;
                break;
              } // case 64
            case 74:
              {
                input.readMessage(
                    getCommitmentStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 74
            case 80:
              {
                multiRegionAuxiliary_ = input.readBool();
                bitField0_ |= 0x00000100;
                break;
              } // case 80
            case 96:
              {
                edition_ = input.readEnum();
                bitField0_ |= 0x00000200;
                break;
              } // case 96
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the capacity commitment, e.g.,
     * `projects/myproject/locations/US/capacityCommitments/123`
     * The commitment_id must only contain lower case alphanumeric characters or
     * dashes. It must start with a letter and must not end
     * with a dash. Its maximum length is 64 characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the capacity commitment, e.g.,
     * `projects/myproject/locations/US/capacityCommitments/123`
     * The commitment_id must only contain lower case alphanumeric characters or
     * dashes. It must start with a letter and must not end
     * with a dash. Its maximum length is 64 characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the capacity commitment, e.g.,
     * `projects/myproject/locations/US/capacityCommitments/123`
     * The commitment_id must only contain lower case alphanumeric characters or
     * dashes. It must start with a letter and must not end
     * with a dash. Its maximum length is 64 characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the capacity commitment, e.g.,
     * `projects/myproject/locations/US/capacityCommitments/123`
     * The commitment_id must only contain lower case alphanumeric characters or
     * dashes. It must start with a letter and must not end
     * with a dash. Its maximum length is 64 characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the capacity commitment, e.g.,
     * `projects/myproject/locations/US/capacityCommitments/123`
     * The commitment_id must only contain lower case alphanumeric characters or
     * dashes. It must start with a letter and must not end
     * with a dash. Its maximum length is 64 characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private long slotCount_;
    /**
     *
     *
     * <pre>
     * Number of slots in this commitment.
     * </pre>
     *
     * <code>int64 slot_count = 2;</code>
     *
     * @return The slotCount.
     */
    @java.lang.Override
    public long getSlotCount() {
      return slotCount_;
    }
    /**
     *
     *
     * <pre>
     * Number of slots in this commitment.
     * </pre>
     *
     * <code>int64 slot_count = 2;</code>
     *
     * @param value The slotCount to set.
     * @return This builder for chaining.
     */
    public Builder setSlotCount(long value) {

      slotCount_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Number of slots in this commitment.
     * </pre>
     *
     * <code>int64 slot_count = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSlotCount() {
      bitField0_ = (bitField0_ & ~0x00000002);
      slotCount_ = 0L;
      onChanged();
      return this;
    }

    private int plan_ = 0;
    /**
     *
     *
     * <pre>
     * Capacity commitment commitment plan.
     * </pre>
     *
     * <code>.google.cloud.bigquery.reservation.v1.CapacityCommitment.CommitmentPlan plan = 3;
     * </code>
     *
     * @return The enum numeric value on the wire for plan.
     */
    @java.lang.Override
    public int getPlanValue() {
      return plan_;
    }
    /**
     *
     *
     * <pre>
     * Capacity commitment commitment plan.
     * </pre>
     *
     * <code>.google.cloud.bigquery.reservation.v1.CapacityCommitment.CommitmentPlan plan = 3;
     * </code>
     *
     * @param value The enum numeric value on the wire for plan to set.
     * @return This builder for chaining.
     */
    public Builder setPlanValue(int value) {
      plan_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Capacity commitment commitment plan.
     * </pre>
     *
     * <code>.google.cloud.bigquery.reservation.v1.CapacityCommitment.CommitmentPlan plan = 3;
     * </code>
     *
     * @return The plan.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.reservation.v1.CapacityCommitment.CommitmentPlan getPlan() {
      com.google.cloud.bigquery.reservation.v1.CapacityCommitment.CommitmentPlan result =
          com.google.cloud.bigquery.reservation.v1.CapacityCommitment.CommitmentPlan.forNumber(
              plan_);
      return result == null
          ? com.google.cloud.bigquery.reservation.v1.CapacityCommitment.CommitmentPlan.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Capacity commitment commitment plan.
     * </pre>
     *
     * <code>.google.cloud.bigquery.reservation.v1.CapacityCommitment.CommitmentPlan plan = 3;
     * </code>
     *
     * @param value The plan to set.
     * @return This builder for chaining.
     */
    public Builder setPlan(
        com.google.cloud.bigquery.reservation.v1.CapacityCommitment.CommitmentPlan value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      plan_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Capacity commitment commitment plan.
     * </pre>
     *
     * <code>.google.cloud.bigquery.reservation.v1.CapacityCommitment.CommitmentPlan plan = 3;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPlan() {
      bitField0_ = (bitField0_ & ~0x00000004);
      plan_ = 0;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. State of the commitment.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.reservation.v1.CapacityCommitment.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the commitment.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.reservation.v1.CapacityCommitment.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the commitment.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.reservation.v1.CapacityCommitment.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.reservation.v1.CapacityCommitment.State getState() {
      com.google.cloud.bigquery.reservation.v1.CapacityCommitment.State result =
          com.google.cloud.bigquery.reservation.v1.CapacityCommitment.State.forNumber(state_);
      return result == null
          ? com.google.cloud.bigquery.reservation.v1.CapacityCommitment.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the commitment.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.reservation.v1.CapacityCommitment.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(
        com.google.cloud.bigquery.reservation.v1.CapacityCommitment.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the commitment.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.reservation.v1.CapacityCommitment.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000008);
      state_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp commitmentStartTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        commitmentStartTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The start of the current commitment period. It is applicable
     * only for ACTIVE capacity commitments.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp commitment_start_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the commitmentStartTime field is set.
     */
    public boolean hasCommitmentStartTime() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The start of the current commitment period. It is applicable
     * only for ACTIVE capacity commitments.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp commitment_start_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The commitmentStartTime.
     */
    public com.google.protobuf.Timestamp getCommitmentStartTime() {
      if (commitmentStartTimeBuilder_ == null) {
        return commitmentStartTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : commitmentStartTime_;
      } else {
        return commitmentStartTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The start of the current commitment period. It is applicable
     * only for ACTIVE capacity commitments.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp commitment_start_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCommitmentStartTime(com.google.protobuf.Timestamp value) {
      if (commitmentStartTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        commitmentStartTime_ = value;
      } else {
        commitmentStartTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The start of the current commitment period. It is applicable
     * only for ACTIVE capacity commitments.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp commitment_start_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCommitmentStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (commitmentStartTimeBuilder_ == null) {
        commitmentStartTime_ = builderForValue.build();
      } else {
        commitmentStartTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The start of the current commitment period. It is applicable
     * only for ACTIVE capacity commitments.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp commitment_start_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCommitmentStartTime(com.google.protobuf.Timestamp value) {
      if (commitmentStartTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && commitmentStartTime_ != null
            && commitmentStartTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCommitmentStartTimeBuilder().mergeFrom(value);
        } else {
          commitmentStartTime_ = value;
        }
      } else {
        commitmentStartTimeBuilder_.mergeFrom(value);
      }
      if (commitmentStartTime_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The start of the current commitment period. It is applicable
     * only for ACTIVE capacity commitments.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp commitment_start_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCommitmentStartTime() {
      bitField0_ = (bitField0_ & ~0x00000010);
      commitmentStartTime_ = null;
      if (commitmentStartTimeBuilder_ != null) {
        commitmentStartTimeBuilder_.dispose();
        commitmentStartTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The start of the current commitment period. It is applicable
     * only for ACTIVE capacity commitments.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp commitment_start_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCommitmentStartTimeBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getCommitmentStartTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The start of the current commitment period. It is applicable
     * only for ACTIVE capacity commitments.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp commitment_start_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCommitmentStartTimeOrBuilder() {
      if (commitmentStartTimeBuilder_ != null) {
        return commitmentStartTimeBuilder_.getMessageOrBuilder();
      } else {
        return commitmentStartTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : commitmentStartTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The start of the current commitment period. It is applicable
     * only for ACTIVE capacity commitments.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp commitment_start_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCommitmentStartTimeFieldBuilder() {
      if (commitmentStartTimeBuilder_ == null) {
        commitmentStartTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCommitmentStartTime(), getParentForChildren(), isClean());
        commitmentStartTime_ = null;
      }
      return commitmentStartTimeBuilder_;
    }

    private com.google.protobuf.Timestamp commitmentEndTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        commitmentEndTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The end of the current commitment period. It is applicable
     * only for ACTIVE capacity commitments.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp commitment_end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the commitmentEndTime field is set.
     */
    public boolean hasCommitmentEndTime() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The end of the current commitment period. It is applicable
     * only for ACTIVE capacity commitments.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp commitment_end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The commitmentEndTime.
     */
    public com.google.protobuf.Timestamp getCommitmentEndTime() {
      if (commitmentEndTimeBuilder_ == null) {
        return commitmentEndTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : commitmentEndTime_;
      } else {
        return commitmentEndTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The end of the current commitment period. It is applicable
     * only for ACTIVE capacity commitments.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp commitment_end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCommitmentEndTime(com.google.protobuf.Timestamp value) {
      if (commitmentEndTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        commitmentEndTime_ = value;
      } else {
        commitmentEndTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The end of the current commitment period. It is applicable
     * only for ACTIVE capacity commitments.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp commitment_end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCommitmentEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (commitmentEndTimeBuilder_ == null) {
        commitmentEndTime_ = builderForValue.build();
      } else {
        commitmentEndTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The end of the current commitment period. It is applicable
     * only for ACTIVE capacity commitments.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp commitment_end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCommitmentEndTime(com.google.protobuf.Timestamp value) {
      if (commitmentEndTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && commitmentEndTime_ != null
            && commitmentEndTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCommitmentEndTimeBuilder().mergeFrom(value);
        } else {
          commitmentEndTime_ = value;
        }
      } else {
        commitmentEndTimeBuilder_.mergeFrom(value);
      }
      if (commitmentEndTime_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The end of the current commitment period. It is applicable
     * only for ACTIVE capacity commitments.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp commitment_end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCommitmentEndTime() {
      bitField0_ = (bitField0_ & ~0x00000020);
      commitmentEndTime_ = null;
      if (commitmentEndTimeBuilder_ != null) {
        commitmentEndTimeBuilder_.dispose();
        commitmentEndTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The end of the current commitment period. It is applicable
     * only for ACTIVE capacity commitments.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp commitment_end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCommitmentEndTimeBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getCommitmentEndTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The end of the current commitment period. It is applicable
     * only for ACTIVE capacity commitments.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp commitment_end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCommitmentEndTimeOrBuilder() {
      if (commitmentEndTimeBuilder_ != null) {
        return commitmentEndTimeBuilder_.getMessageOrBuilder();
      } else {
        return commitmentEndTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : commitmentEndTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The end of the current commitment period. It is applicable
     * only for ACTIVE capacity commitments.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp commitment_end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCommitmentEndTimeFieldBuilder() {
      if (commitmentEndTimeBuilder_ == null) {
        commitmentEndTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCommitmentEndTime(), getParentForChildren(), isClean());
        commitmentEndTime_ = null;
      }
      return commitmentEndTimeBuilder_;
    }

    private com.google.rpc.Status failureStatus_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        failureStatusBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. For FAILED commitment plan, provides the reason of failure.
     * </pre>
     *
     * <code>.google.rpc.Status failure_status = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the failureStatus field is set.
     */
    public boolean hasFailureStatus() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. For FAILED commitment plan, provides the reason of failure.
     * </pre>
     *
     * <code>.google.rpc.Status failure_status = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The failureStatus.
     */
    public com.google.rpc.Status getFailureStatus() {
      if (failureStatusBuilder_ == null) {
        return failureStatus_ == null ? com.google.rpc.Status.getDefaultInstance() : failureStatus_;
      } else {
        return failureStatusBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. For FAILED commitment plan, provides the reason of failure.
     * </pre>
     *
     * <code>.google.rpc.Status failure_status = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setFailureStatus(com.google.rpc.Status value) {
      if (failureStatusBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        failureStatus_ = value;
      } else {
        failureStatusBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. For FAILED commitment plan, provides the reason of failure.
     * </pre>
     *
     * <code>.google.rpc.Status failure_status = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setFailureStatus(com.google.rpc.Status.Builder builderForValue) {
      if (failureStatusBuilder_ == null) {
        failureStatus_ = builderForValue.build();
      } else {
        failureStatusBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. For FAILED commitment plan, provides the reason of failure.
     * </pre>
     *
     * <code>.google.rpc.Status failure_status = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeFailureStatus(com.google.rpc.Status value) {
      if (failureStatusBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && failureStatus_ != null
            && failureStatus_ != com.google.rpc.Status.getDefaultInstance()) {
          getFailureStatusBuilder().mergeFrom(value);
        } else {
          failureStatus_ = value;
        }
      } else {
        failureStatusBuilder_.mergeFrom(value);
      }
      if (failureStatus_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. For FAILED commitment plan, provides the reason of failure.
     * </pre>
     *
     * <code>.google.rpc.Status failure_status = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearFailureStatus() {
      bitField0_ = (bitField0_ & ~0x00000040);
      failureStatus_ = null;
      if (failureStatusBuilder_ != null) {
        failureStatusBuilder_.dispose();
        failureStatusBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. For FAILED commitment plan, provides the reason of failure.
     * </pre>
     *
     * <code>.google.rpc.Status failure_status = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.rpc.Status.Builder getFailureStatusBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getFailureStatusFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. For FAILED commitment plan, provides the reason of failure.
     * </pre>
     *
     * <code>.google.rpc.Status failure_status = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.rpc.StatusOrBuilder getFailureStatusOrBuilder() {
      if (failureStatusBuilder_ != null) {
        return failureStatusBuilder_.getMessageOrBuilder();
      } else {
        return failureStatus_ == null ? com.google.rpc.Status.getDefaultInstance() : failureStatus_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. For FAILED commitment plan, provides the reason of failure.
     * </pre>
     *
     * <code>.google.rpc.Status failure_status = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getFailureStatusFieldBuilder() {
      if (failureStatusBuilder_ == null) {
        failureStatusBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(
                getFailureStatus(), getParentForChildren(), isClean());
        failureStatus_ = null;
      }
      return failureStatusBuilder_;
    }

    private int renewalPlan_ = 0;
    /**
     *
     *
     * <pre>
     * The plan this capacity commitment is converted to after commitment_end_time
     * passes. Once the plan is changed, committed period is extended according to
     * commitment plan. Only applicable for ANNUAL and TRIAL commitments.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.reservation.v1.CapacityCommitment.CommitmentPlan renewal_plan = 8;
     * </code>
     *
     * @return The enum numeric value on the wire for renewalPlan.
     */
    @java.lang.Override
    public int getRenewalPlanValue() {
      return renewalPlan_;
    }
    /**
     *
     *
     * <pre>
     * The plan this capacity commitment is converted to after commitment_end_time
     * passes. Once the plan is changed, committed period is extended according to
     * commitment plan. Only applicable for ANNUAL and TRIAL commitments.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.reservation.v1.CapacityCommitment.CommitmentPlan renewal_plan = 8;
     * </code>
     *
     * @param value The enum numeric value on the wire for renewalPlan to set.
     * @return This builder for chaining.
     */
    public Builder setRenewalPlanValue(int value) {
      renewalPlan_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The plan this capacity commitment is converted to after commitment_end_time
     * passes. Once the plan is changed, committed period is extended according to
     * commitment plan. Only applicable for ANNUAL and TRIAL commitments.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.reservation.v1.CapacityCommitment.CommitmentPlan renewal_plan = 8;
     * </code>
     *
     * @return The renewalPlan.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.reservation.v1.CapacityCommitment.CommitmentPlan
        getRenewalPlan() {
      com.google.cloud.bigquery.reservation.v1.CapacityCommitment.CommitmentPlan result =
          com.google.cloud.bigquery.reservation.v1.CapacityCommitment.CommitmentPlan.forNumber(
              renewalPlan_);
      return result == null
          ? com.google.cloud.bigquery.reservation.v1.CapacityCommitment.CommitmentPlan.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The plan this capacity commitment is converted to after commitment_end_time
     * passes. Once the plan is changed, committed period is extended according to
     * commitment plan. Only applicable for ANNUAL and TRIAL commitments.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.reservation.v1.CapacityCommitment.CommitmentPlan renewal_plan = 8;
     * </code>
     *
     * @param value The renewalPlan to set.
     * @return This builder for chaining.
     */
    public Builder setRenewalPlan(
        com.google.cloud.bigquery.reservation.v1.CapacityCommitment.CommitmentPlan value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000080;
      renewalPlan_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The plan this capacity commitment is converted to after commitment_end_time
     * passes. Once the plan is changed, committed period is extended according to
     * commitment plan. Only applicable for ANNUAL and TRIAL commitments.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.reservation.v1.CapacityCommitment.CommitmentPlan renewal_plan = 8;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRenewalPlan() {
      bitField0_ = (bitField0_ & ~0x00000080);
      renewalPlan_ = 0;
      onChanged();
      return this;
    }

    private boolean multiRegionAuxiliary_;
    /**
     *
     *
     * <pre>
     * Applicable only for commitments located within one of the BigQuery
     * multi-regions (US or EU).
     *
     * If set to true, this commitment is placed in the organization's
     * secondary region which is designated for disaster recovery purposes.
     * If false, this commitment is placed in the organization's default region.
     *
     * NOTE: this is a preview feature. Project must be allow-listed in order to
     * set this field.
     * </pre>
     *
     * <code>bool multi_region_auxiliary = 10;</code>
     *
     * @return The multiRegionAuxiliary.
     */
    @java.lang.Override
    public boolean getMultiRegionAuxiliary() {
      return multiRegionAuxiliary_;
    }
    /**
     *
     *
     * <pre>
     * Applicable only for commitments located within one of the BigQuery
     * multi-regions (US or EU).
     *
     * If set to true, this commitment is placed in the organization's
     * secondary region which is designated for disaster recovery purposes.
     * If false, this commitment is placed in the organization's default region.
     *
     * NOTE: this is a preview feature. Project must be allow-listed in order to
     * set this field.
     * </pre>
     *
     * <code>bool multi_region_auxiliary = 10;</code>
     *
     * @param value The multiRegionAuxiliary to set.
     * @return This builder for chaining.
     */
    public Builder setMultiRegionAuxiliary(boolean value) {

      multiRegionAuxiliary_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Applicable only for commitments located within one of the BigQuery
     * multi-regions (US or EU).
     *
     * If set to true, this commitment is placed in the organization's
     * secondary region which is designated for disaster recovery purposes.
     * If false, this commitment is placed in the organization's default region.
     *
     * NOTE: this is a preview feature. Project must be allow-listed in order to
     * set this field.
     * </pre>
     *
     * <code>bool multi_region_auxiliary = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMultiRegionAuxiliary() {
      bitField0_ = (bitField0_ & ~0x00000100);
      multiRegionAuxiliary_ = false;
      onChanged();
      return this;
    }

    private int edition_ = 0;
    /**
     *
     *
     * <pre>
     * Edition of the capacity commitment.
     * </pre>
     *
     * <code>.google.cloud.bigquery.reservation.v1.Edition edition = 12;</code>
     *
     * @return The enum numeric value on the wire for edition.
     */
    @java.lang.Override
    public int getEditionValue() {
      return edition_;
    }
    /**
     *
     *
     * <pre>
     * Edition of the capacity commitment.
     * </pre>
     *
     * <code>.google.cloud.bigquery.reservation.v1.Edition edition = 12;</code>
     *
     * @param value The enum numeric value on the wire for edition to set.
     * @return This builder for chaining.
     */
    public Builder setEditionValue(int value) {
      edition_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Edition of the capacity commitment.
     * </pre>
     *
     * <code>.google.cloud.bigquery.reservation.v1.Edition edition = 12;</code>
     *
     * @return The edition.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.reservation.v1.Edition getEdition() {
      com.google.cloud.bigquery.reservation.v1.Edition result =
          com.google.cloud.bigquery.reservation.v1.Edition.forNumber(edition_);
      return result == null
          ? com.google.cloud.bigquery.reservation.v1.Edition.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Edition of the capacity commitment.
     * </pre>
     *
     * <code>.google.cloud.bigquery.reservation.v1.Edition edition = 12;</code>
     *
     * @param value The edition to set.
     * @return This builder for chaining.
     */
    public Builder setEdition(com.google.cloud.bigquery.reservation.v1.Edition value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000200;
      edition_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Edition of the capacity commitment.
     * </pre>
     *
     * <code>.google.cloud.bigquery.reservation.v1.Edition edition = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEdition() {
      bitField0_ = (bitField0_ & ~0x00000200);
      edition_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.reservation.v1.CapacityCommitment)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.bigquery.reservation.v1.CapacityCommitment)
  private static final com.google.cloud.bigquery.reservation.v1.CapacityCommitment DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.bigquery.reservation.v1.CapacityCommitment();
  }

  public static com.google.cloud.bigquery.reservation.v1.CapacityCommitment getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CapacityCommitment> PARSER =
      new com.google.protobuf.AbstractParser<CapacityCommitment>() {
        @java.lang.Override
        public CapacityCommitment parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CapacityCommitment> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CapacityCommitment> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.bigquery.reservation.v1.CapacityCommitment getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
