/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/reservation/v1/reservation.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.bigquery.reservation.v1;

/**
 *
 *
 * <pre>
 * The request for
 * [ReservationService.MoveAssignment][google.cloud.bigquery.reservation.v1.ReservationService.MoveAssignment].
 *
 * **Note**: "bigquery.reservationAssignments.create" permission is required on
 * the destination_id.
 *
 * **Note**: "bigquery.reservationAssignments.create" and
 * "bigquery.reservationAssignments.delete" permission are required on the
 * related assignee.
 * </pre>
 *
 * Protobuf type {@code google.cloud.bigquery.reservation.v1.MoveAssignmentRequest}
 */
public final class MoveAssignmentRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.bigquery.reservation.v1.MoveAssignmentRequest)
    MoveAssignmentRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use MoveAssignmentRequest.newBuilder() to construct.
  private MoveAssignmentRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private MoveAssignmentRequest() {
    name_ = "";
    destinationId_ = "";
    assignmentId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new MoveAssignmentRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.bigquery.reservation.v1.ReservationProto
        .internal_static_google_cloud_bigquery_reservation_v1_MoveAssignmentRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.bigquery.reservation.v1.ReservationProto
        .internal_static_google_cloud_bigquery_reservation_v1_MoveAssignmentRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.bigquery.reservation.v1.MoveAssignmentRequest.class,
            com.google.cloud.bigquery.reservation.v1.MoveAssignmentRequest.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Required. The resource name of the assignment,
   * e.g.
   * `projects/myproject/locations/US/reservations/team1-prod/assignments/123`
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The resource name of the assignment,
   * e.g.
   * `projects/myproject/locations/US/reservations/team1-prod/assignments/123`
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESTINATION_ID_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object destinationId_ = "";
  /**
   *
   *
   * <pre>
   * The new reservation ID, e.g.:
   *   `projects/myotherproject/locations/US/reservations/team2-prod`
   * </pre>
   *
   * <code>string destination_id = 3 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The destinationId.
   */
  @java.lang.Override
  public java.lang.String getDestinationId() {
    java.lang.Object ref = destinationId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      destinationId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The new reservation ID, e.g.:
   *   `projects/myotherproject/locations/US/reservations/team2-prod`
   * </pre>
   *
   * <code>string destination_id = 3 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for destinationId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDestinationIdBytes() {
    java.lang.Object ref = destinationId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      destinationId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ASSIGNMENT_ID_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object assignmentId_ = "";
  /**
   *
   *
   * <pre>
   * The optional assignment ID. A new assignment name is generated if this
   * field is empty.
   *
   * This field can contain only lowercase alphanumeric characters or dashes.
   * Max length is 64 characters.
   * </pre>
   *
   * <code>string assignment_id = 5;</code>
   *
   * @return The assignmentId.
   */
  @java.lang.Override
  public java.lang.String getAssignmentId() {
    java.lang.Object ref = assignmentId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      assignmentId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The optional assignment ID. A new assignment name is generated if this
   * field is empty.
   *
   * This field can contain only lowercase alphanumeric characters or dashes.
   * Max length is 64 characters.
   * </pre>
   *
   * <code>string assignment_id = 5;</code>
   *
   * @return The bytes for assignmentId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAssignmentIdBytes() {
    java.lang.Object ref = assignmentId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      assignmentId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(destinationId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, destinationId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(assignmentId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, assignmentId_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(destinationId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, destinationId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(assignmentId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, assignmentId_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.bigquery.reservation.v1.MoveAssignmentRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.bigquery.reservation.v1.MoveAssignmentRequest other =
        (com.google.cloud.bigquery.reservation.v1.MoveAssignmentRequest) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDestinationId().equals(other.getDestinationId())) return false;
    if (!getAssignmentId().equals(other.getAssignmentId())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DESTINATION_ID_FIELD_NUMBER;
    hash = (53 * hash) + getDestinationId().hashCode();
    hash = (37 * hash) + ASSIGNMENT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getAssignmentId().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.bigquery.reservation.v1.MoveAssignmentRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.reservation.v1.MoveAssignmentRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.reservation.v1.MoveAssignmentRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.reservation.v1.MoveAssignmentRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.reservation.v1.MoveAssignmentRequest parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.reservation.v1.MoveAssignmentRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.reservation.v1.MoveAssignmentRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.reservation.v1.MoveAssignmentRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.reservation.v1.MoveAssignmentRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.reservation.v1.MoveAssignmentRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.reservation.v1.MoveAssignmentRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.reservation.v1.MoveAssignmentRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.bigquery.reservation.v1.MoveAssignmentRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The request for
   * [ReservationService.MoveAssignment][google.cloud.bigquery.reservation.v1.ReservationService.MoveAssignment].
   *
   * **Note**: "bigquery.reservationAssignments.create" permission is required on
   * the destination_id.
   *
   * **Note**: "bigquery.reservationAssignments.create" and
   * "bigquery.reservationAssignments.delete" permission are required on the
   * related assignee.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.reservation.v1.MoveAssignmentRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.reservation.v1.MoveAssignmentRequest)
      com.google.cloud.bigquery.reservation.v1.MoveAssignmentRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.reservation.v1.ReservationProto
          .internal_static_google_cloud_bigquery_reservation_v1_MoveAssignmentRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.reservation.v1.ReservationProto
          .internal_static_google_cloud_bigquery_reservation_v1_MoveAssignmentRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.reservation.v1.MoveAssignmentRequest.class,
              com.google.cloud.bigquery.reservation.v1.MoveAssignmentRequest.Builder.class);
    }

    // Construct using com.google.cloud.bigquery.reservation.v1.MoveAssignmentRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      destinationId_ = "";
      assignmentId_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.bigquery.reservation.v1.ReservationProto
          .internal_static_google_cloud_bigquery_reservation_v1_MoveAssignmentRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.reservation.v1.MoveAssignmentRequest
        getDefaultInstanceForType() {
      return com.google.cloud.bigquery.reservation.v1.MoveAssignmentRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.bigquery.reservation.v1.MoveAssignmentRequest build() {
      com.google.cloud.bigquery.reservation.v1.MoveAssignmentRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.reservation.v1.MoveAssignmentRequest buildPartial() {
      com.google.cloud.bigquery.reservation.v1.MoveAssignmentRequest result =
          new com.google.cloud.bigquery.reservation.v1.MoveAssignmentRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.bigquery.reservation.v1.MoveAssignmentRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.destinationId_ = destinationId_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.assignmentId_ = assignmentId_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.bigquery.reservation.v1.MoveAssignmentRequest) {
        return mergeFrom((com.google.cloud.bigquery.reservation.v1.MoveAssignmentRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.bigquery.reservation.v1.MoveAssignmentRequest other) {
      if (other
          == com.google.cloud.bigquery.reservation.v1.MoveAssignmentRequest.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDestinationId().isEmpty()) {
        destinationId_ = other.destinationId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getAssignmentId().isEmpty()) {
        assignmentId_ = other.assignmentId_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 26:
              {
                destinationId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 26
            case 42:
              {
                assignmentId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource name of the assignment,
     * e.g.
     * `projects/myproject/locations/US/reservations/team1-prod/assignments/123`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the assignment,
     * e.g.
     * `projects/myproject/locations/US/reservations/team1-prod/assignments/123`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the assignment,
     * e.g.
     * `projects/myproject/locations/US/reservations/team1-prod/assignments/123`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the assignment,
     * e.g.
     * `projects/myproject/locations/US/reservations/team1-prod/assignments/123`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the assignment,
     * e.g.
     * `projects/myproject/locations/US/reservations/team1-prod/assignments/123`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object destinationId_ = "";
    /**
     *
     *
     * <pre>
     * The new reservation ID, e.g.:
     *   `projects/myotherproject/locations/US/reservations/team2-prod`
     * </pre>
     *
     * <code>string destination_id = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The destinationId.
     */
    public java.lang.String getDestinationId() {
      java.lang.Object ref = destinationId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        destinationId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The new reservation ID, e.g.:
     *   `projects/myotherproject/locations/US/reservations/team2-prod`
     * </pre>
     *
     * <code>string destination_id = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for destinationId.
     */
    public com.google.protobuf.ByteString getDestinationIdBytes() {
      java.lang.Object ref = destinationId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        destinationId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The new reservation ID, e.g.:
     *   `projects/myotherproject/locations/US/reservations/team2-prod`
     * </pre>
     *
     * <code>string destination_id = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The destinationId to set.
     * @return This builder for chaining.
     */
    public Builder setDestinationId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      destinationId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The new reservation ID, e.g.:
     *   `projects/myotherproject/locations/US/reservations/team2-prod`
     * </pre>
     *
     * <code>string destination_id = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDestinationId() {
      destinationId_ = getDefaultInstance().getDestinationId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The new reservation ID, e.g.:
     *   `projects/myotherproject/locations/US/reservations/team2-prod`
     * </pre>
     *
     * <code>string destination_id = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for destinationId to set.
     * @return This builder for chaining.
     */
    public Builder setDestinationIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      destinationId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object assignmentId_ = "";
    /**
     *
     *
     * <pre>
     * The optional assignment ID. A new assignment name is generated if this
     * field is empty.
     *
     * This field can contain only lowercase alphanumeric characters or dashes.
     * Max length is 64 characters.
     * </pre>
     *
     * <code>string assignment_id = 5;</code>
     *
     * @return The assignmentId.
     */
    public java.lang.String getAssignmentId() {
      java.lang.Object ref = assignmentId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        assignmentId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The optional assignment ID. A new assignment name is generated if this
     * field is empty.
     *
     * This field can contain only lowercase alphanumeric characters or dashes.
     * Max length is 64 characters.
     * </pre>
     *
     * <code>string assignment_id = 5;</code>
     *
     * @return The bytes for assignmentId.
     */
    public com.google.protobuf.ByteString getAssignmentIdBytes() {
      java.lang.Object ref = assignmentId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        assignmentId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The optional assignment ID. A new assignment name is generated if this
     * field is empty.
     *
     * This field can contain only lowercase alphanumeric characters or dashes.
     * Max length is 64 characters.
     * </pre>
     *
     * <code>string assignment_id = 5;</code>
     *
     * @param value The assignmentId to set.
     * @return This builder for chaining.
     */
    public Builder setAssignmentId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      assignmentId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The optional assignment ID. A new assignment name is generated if this
     * field is empty.
     *
     * This field can contain only lowercase alphanumeric characters or dashes.
     * Max length is 64 characters.
     * </pre>
     *
     * <code>string assignment_id = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAssignmentId() {
      assignmentId_ = getDefaultInstance().getAssignmentId();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The optional assignment ID. A new assignment name is generated if this
     * field is empty.
     *
     * This field can contain only lowercase alphanumeric characters or dashes.
     * Max length is 64 characters.
     * </pre>
     *
     * <code>string assignment_id = 5;</code>
     *
     * @param value The bytes for assignmentId to set.
     * @return This builder for chaining.
     */
    public Builder setAssignmentIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      assignmentId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.reservation.v1.MoveAssignmentRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.bigquery.reservation.v1.MoveAssignmentRequest)
  private static final com.google.cloud.bigquery.reservation.v1.MoveAssignmentRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.bigquery.reservation.v1.MoveAssignmentRequest();
  }

  public static com.google.cloud.bigquery.reservation.v1.MoveAssignmentRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<MoveAssignmentRequest> PARSER =
      new com.google.protobuf.AbstractParser<MoveAssignmentRequest>() {
        @java.lang.Override
        public MoveAssignmentRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<MoveAssignmentRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<MoveAssignmentRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.bigquery.reservation.v1.MoveAssignmentRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
