/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.reservation.v1;

import com.google.cloud.bigquery.reservation.v1.Edition;
import com.google.cloud.bigquery.reservation.v1.ReservationOrBuilder;
import com.google.cloud.bigquery.reservation.v1.ReservationProto;
import com.google.cloud.bigquery.reservation.v1.SchedulingPolicy;
import com.google.cloud.bigquery.reservation.v1.SchedulingPolicyOrBuilder;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MapEntry;
import com.google.protobuf.MapField;
import com.google.protobuf.MapFieldReflectionAccessor;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.Timestamp;
import com.google.protobuf.TimestampOrBuilder;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import com.google.protobuf.WireFormat;
import com.google.rpc.Status;
import com.google.rpc.StatusOrBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;

public final class Reservation
extends GeneratedMessageV3
implements ReservationOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int NAME_FIELD_NUMBER = 1;
    private volatile Object name_ = "";
    public static final int SLOT_CAPACITY_FIELD_NUMBER = 2;
    private long slotCapacity_ = 0L;
    public static final int IGNORE_IDLE_SLOTS_FIELD_NUMBER = 4;
    private boolean ignoreIdleSlots_ = false;
    public static final int AUTOSCALE_FIELD_NUMBER = 7;
    private Autoscale autoscale_;
    public static final int CONCURRENCY_FIELD_NUMBER = 16;
    private long concurrency_ = 0L;
    public static final int CREATION_TIME_FIELD_NUMBER = 8;
    private Timestamp creationTime_;
    public static final int UPDATE_TIME_FIELD_NUMBER = 9;
    private Timestamp updateTime_;
    public static final int MULTI_REGION_AUXILIARY_FIELD_NUMBER = 14;
    private boolean multiRegionAuxiliary_ = false;
    public static final int EDITION_FIELD_NUMBER = 17;
    private int edition_ = 0;
    public static final int PRIMARY_LOCATION_FIELD_NUMBER = 18;
    private volatile Object primaryLocation_ = "";
    public static final int SECONDARY_LOCATION_FIELD_NUMBER = 19;
    private volatile Object secondaryLocation_ = "";
    public static final int ORIGINAL_PRIMARY_LOCATION_FIELD_NUMBER = 20;
    private volatile Object originalPrimaryLocation_ = "";
    public static final int MAX_SLOTS_FIELD_NUMBER = 21;
    private long maxSlots_ = 0L;
    public static final int SCALING_MODE_FIELD_NUMBER = 22;
    private int scalingMode_ = 0;
    public static final int LABELS_FIELD_NUMBER = 23;
    private MapField<String, String> labels_;
    public static final int RESERVATION_GROUP_FIELD_NUMBER = 25;
    private volatile Object reservationGroup_ = "";
    public static final int REPLICATION_STATUS_FIELD_NUMBER = 24;
    private ReplicationStatus replicationStatus_;
    public static final int SCHEDULING_POLICY_FIELD_NUMBER = 27;
    private SchedulingPolicy schedulingPolicy_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final Reservation DEFAULT_INSTANCE = new Reservation();
    private static final Parser<Reservation> PARSER = new AbstractParser<Reservation>(){

        public Reservation parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = Reservation.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private Reservation(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private Reservation() {
        this.name_ = "";
        this.edition_ = 0;
        this.primaryLocation_ = "";
        this.secondaryLocation_ = "";
        this.originalPrimaryLocation_ = "";
        this.scalingMode_ = 0;
        this.reservationGroup_ = "";
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new Reservation();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return ReservationProto.internal_static_google_cloud_bigquery_reservation_v1_Reservation_descriptor;
    }

    protected MapFieldReflectionAccessor internalGetMapFieldReflection(int number) {
        switch (number) {
            case 23: {
                return this.internalGetLabels();
            }
        }
        throw new RuntimeException("Invalid map field number: " + number);
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return ReservationProto.internal_static_google_cloud_bigquery_reservation_v1_Reservation_fieldAccessorTable.ensureFieldAccessorsInitialized(Reservation.class, Builder.class);
    }

    @Override
    public String getName() {
        Object ref = this.name_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.name_ = s;
        return s;
    }

    @Override
    public ByteString getNameBytes() {
        Object ref = this.name_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.name_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public long getSlotCapacity() {
        return this.slotCapacity_;
    }

    @Override
    public boolean getIgnoreIdleSlots() {
        return this.ignoreIdleSlots_;
    }

    @Override
    public boolean hasAutoscale() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public Autoscale getAutoscale() {
        return this.autoscale_ == null ? Autoscale.getDefaultInstance() : this.autoscale_;
    }

    @Override
    public AutoscaleOrBuilder getAutoscaleOrBuilder() {
        return this.autoscale_ == null ? Autoscale.getDefaultInstance() : this.autoscale_;
    }

    @Override
    public long getConcurrency() {
        return this.concurrency_;
    }

    @Override
    public boolean hasCreationTime() {
        return (this.bitField0_ & 2) != 0;
    }

    @Override
    public Timestamp getCreationTime() {
        return this.creationTime_ == null ? Timestamp.getDefaultInstance() : this.creationTime_;
    }

    @Override
    public TimestampOrBuilder getCreationTimeOrBuilder() {
        return this.creationTime_ == null ? Timestamp.getDefaultInstance() : this.creationTime_;
    }

    @Override
    public boolean hasUpdateTime() {
        return (this.bitField0_ & 4) != 0;
    }

    @Override
    public Timestamp getUpdateTime() {
        return this.updateTime_ == null ? Timestamp.getDefaultInstance() : this.updateTime_;
    }

    @Override
    public TimestampOrBuilder getUpdateTimeOrBuilder() {
        return this.updateTime_ == null ? Timestamp.getDefaultInstance() : this.updateTime_;
    }

    @Override
    @Deprecated
    public boolean getMultiRegionAuxiliary() {
        return this.multiRegionAuxiliary_;
    }

    @Override
    public int getEditionValue() {
        return this.edition_;
    }

    @Override
    public Edition getEdition() {
        Edition result = Edition.forNumber(this.edition_);
        return result == null ? Edition.UNRECOGNIZED : result;
    }

    @Override
    public String getPrimaryLocation() {
        Object ref = this.primaryLocation_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.primaryLocation_ = s;
        return s;
    }

    @Override
    public ByteString getPrimaryLocationBytes() {
        Object ref = this.primaryLocation_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.primaryLocation_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getSecondaryLocation() {
        Object ref = this.secondaryLocation_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.secondaryLocation_ = s;
        return s;
    }

    @Override
    public ByteString getSecondaryLocationBytes() {
        Object ref = this.secondaryLocation_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.secondaryLocation_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getOriginalPrimaryLocation() {
        Object ref = this.originalPrimaryLocation_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.originalPrimaryLocation_ = s;
        return s;
    }

    @Override
    public ByteString getOriginalPrimaryLocationBytes() {
        Object ref = this.originalPrimaryLocation_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.originalPrimaryLocation_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasMaxSlots() {
        return (this.bitField0_ & 8) != 0;
    }

    @Override
    public long getMaxSlots() {
        return this.maxSlots_;
    }

    @Override
    public int getScalingModeValue() {
        return this.scalingMode_;
    }

    @Override
    public ScalingMode getScalingMode() {
        ScalingMode result = ScalingMode.forNumber(this.scalingMode_);
        return result == null ? ScalingMode.UNRECOGNIZED : result;
    }

    private MapField<String, String> internalGetLabels() {
        if (this.labels_ == null) {
            return MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
        }
        return this.labels_;
    }

    @Override
    public int getLabelsCount() {
        return this.internalGetLabels().getMap().size();
    }

    @Override
    public boolean containsLabels(String key) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        return this.internalGetLabels().getMap().containsKey(key);
    }

    @Override
    @Deprecated
    public Map<String, String> getLabels() {
        return this.getLabelsMap();
    }

    @Override
    public Map<String, String> getLabelsMap() {
        return this.internalGetLabels().getMap();
    }

    @Override
    public String getLabelsOrDefault(String key, String defaultValue) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        Map map = this.internalGetLabels().getMap();
        return map.containsKey(key) ? (String)map.get(key) : defaultValue;
    }

    @Override
    public String getLabelsOrThrow(String key) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        Map map = this.internalGetLabels().getMap();
        if (!map.containsKey(key)) {
            throw new IllegalArgumentException();
        }
        return (String)map.get(key);
    }

    @Override
    public String getReservationGroup() {
        Object ref = this.reservationGroup_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.reservationGroup_ = s;
        return s;
    }

    @Override
    public ByteString getReservationGroupBytes() {
        Object ref = this.reservationGroup_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.reservationGroup_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasReplicationStatus() {
        return (this.bitField0_ & 0x10) != 0;
    }

    @Override
    public ReplicationStatus getReplicationStatus() {
        return this.replicationStatus_ == null ? ReplicationStatus.getDefaultInstance() : this.replicationStatus_;
    }

    @Override
    public ReplicationStatusOrBuilder getReplicationStatusOrBuilder() {
        return this.replicationStatus_ == null ? ReplicationStatus.getDefaultInstance() : this.replicationStatus_;
    }

    @Override
    public boolean hasSchedulingPolicy() {
        return (this.bitField0_ & 0x20) != 0;
    }

    @Override
    public SchedulingPolicy getSchedulingPolicy() {
        return this.schedulingPolicy_ == null ? SchedulingPolicy.getDefaultInstance() : this.schedulingPolicy_;
    }

    @Override
    public SchedulingPolicyOrBuilder getSchedulingPolicyOrBuilder() {
        return this.schedulingPolicy_ == null ? SchedulingPolicy.getDefaultInstance() : this.schedulingPolicy_;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        if (!GeneratedMessageV3.isStringEmpty((Object)this.name_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.name_);
        }
        if (this.slotCapacity_ != 0L) {
            output.writeInt64(2, this.slotCapacity_);
        }
        if (this.ignoreIdleSlots_) {
            output.writeBool(4, this.ignoreIdleSlots_);
        }
        if ((this.bitField0_ & 1) != 0) {
            output.writeMessage(7, (MessageLite)this.getAutoscale());
        }
        if ((this.bitField0_ & 2) != 0) {
            output.writeMessage(8, (MessageLite)this.getCreationTime());
        }
        if ((this.bitField0_ & 4) != 0) {
            output.writeMessage(9, (MessageLite)this.getUpdateTime());
        }
        if (this.multiRegionAuxiliary_) {
            output.writeBool(14, this.multiRegionAuxiliary_);
        }
        if (this.concurrency_ != 0L) {
            output.writeInt64(16, this.concurrency_);
        }
        if (this.edition_ != Edition.EDITION_UNSPECIFIED.getNumber()) {
            output.writeEnum(17, this.edition_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.primaryLocation_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)18, (Object)this.primaryLocation_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.secondaryLocation_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)19, (Object)this.secondaryLocation_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.originalPrimaryLocation_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)20, (Object)this.originalPrimaryLocation_);
        }
        if ((this.bitField0_ & 8) != 0) {
            output.writeInt64(21, this.maxSlots_);
        }
        if (this.scalingMode_ != ScalingMode.SCALING_MODE_UNSPECIFIED.getNumber()) {
            output.writeEnum(22, this.scalingMode_);
        }
        GeneratedMessageV3.serializeStringMapTo((CodedOutputStream)output, this.internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, (int)23);
        if ((this.bitField0_ & 0x10) != 0) {
            output.writeMessage(24, (MessageLite)this.getReplicationStatus());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.reservationGroup_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)25, (Object)this.reservationGroup_);
        }
        if ((this.bitField0_ & 0x20) != 0) {
            output.writeMessage(27, (MessageLite)this.getSchedulingPolicy());
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.name_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.name_);
        }
        if (this.slotCapacity_ != 0L) {
            size += CodedOutputStream.computeInt64Size((int)2, (long)this.slotCapacity_);
        }
        if (this.ignoreIdleSlots_) {
            size += CodedOutputStream.computeBoolSize((int)4, (boolean)this.ignoreIdleSlots_);
        }
        if ((this.bitField0_ & 1) != 0) {
            size += CodedOutputStream.computeMessageSize((int)7, (MessageLite)this.getAutoscale());
        }
        if ((this.bitField0_ & 2) != 0) {
            size += CodedOutputStream.computeMessageSize((int)8, (MessageLite)this.getCreationTime());
        }
        if ((this.bitField0_ & 4) != 0) {
            size += CodedOutputStream.computeMessageSize((int)9, (MessageLite)this.getUpdateTime());
        }
        if (this.multiRegionAuxiliary_) {
            size += CodedOutputStream.computeBoolSize((int)14, (boolean)this.multiRegionAuxiliary_);
        }
        if (this.concurrency_ != 0L) {
            size += CodedOutputStream.computeInt64Size((int)16, (long)this.concurrency_);
        }
        if (this.edition_ != Edition.EDITION_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)17, (int)this.edition_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.primaryLocation_)) {
            size += GeneratedMessageV3.computeStringSize((int)18, (Object)this.primaryLocation_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.secondaryLocation_)) {
            size += GeneratedMessageV3.computeStringSize((int)19, (Object)this.secondaryLocation_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.originalPrimaryLocation_)) {
            size += GeneratedMessageV3.computeStringSize((int)20, (Object)this.originalPrimaryLocation_);
        }
        if ((this.bitField0_ & 8) != 0) {
            size += CodedOutputStream.computeInt64Size((int)21, (long)this.maxSlots_);
        }
        if (this.scalingMode_ != ScalingMode.SCALING_MODE_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)22, (int)this.scalingMode_);
        }
        for (Map.Entry entry : this.internalGetLabels().getMap().entrySet()) {
            MapEntry labels__ = LabelsDefaultEntryHolder.defaultEntry.newBuilderForType().setKey(entry.getKey()).setValue(entry.getValue()).build();
            size += CodedOutputStream.computeMessageSize((int)23, (MessageLite)labels__);
        }
        if ((this.bitField0_ & 0x10) != 0) {
            size += CodedOutputStream.computeMessageSize((int)24, (MessageLite)this.getReplicationStatus());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.reservationGroup_)) {
            size += GeneratedMessageV3.computeStringSize((int)25, (Object)this.reservationGroup_);
        }
        if ((this.bitField0_ & 0x20) != 0) {
            size += CodedOutputStream.computeMessageSize((int)27, (MessageLite)this.getSchedulingPolicy());
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Reservation)) {
            return super.equals(obj);
        }
        Reservation other = (Reservation)obj;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (this.getSlotCapacity() != other.getSlotCapacity()) {
            return false;
        }
        if (this.getIgnoreIdleSlots() != other.getIgnoreIdleSlots()) {
            return false;
        }
        if (this.hasAutoscale() != other.hasAutoscale()) {
            return false;
        }
        if (this.hasAutoscale() && !this.getAutoscale().equals(other.getAutoscale())) {
            return false;
        }
        if (this.getConcurrency() != other.getConcurrency()) {
            return false;
        }
        if (this.hasCreationTime() != other.hasCreationTime()) {
            return false;
        }
        if (this.hasCreationTime() && !this.getCreationTime().equals((Object)other.getCreationTime())) {
            return false;
        }
        if (this.hasUpdateTime() != other.hasUpdateTime()) {
            return false;
        }
        if (this.hasUpdateTime() && !this.getUpdateTime().equals((Object)other.getUpdateTime())) {
            return false;
        }
        if (this.getMultiRegionAuxiliary() != other.getMultiRegionAuxiliary()) {
            return false;
        }
        if (this.edition_ != other.edition_) {
            return false;
        }
        if (!this.getPrimaryLocation().equals(other.getPrimaryLocation())) {
            return false;
        }
        if (!this.getSecondaryLocation().equals(other.getSecondaryLocation())) {
            return false;
        }
        if (!this.getOriginalPrimaryLocation().equals(other.getOriginalPrimaryLocation())) {
            return false;
        }
        if (this.hasMaxSlots() != other.hasMaxSlots()) {
            return false;
        }
        if (this.hasMaxSlots() && this.getMaxSlots() != other.getMaxSlots()) {
            return false;
        }
        if (this.scalingMode_ != other.scalingMode_) {
            return false;
        }
        if (!this.internalGetLabels().equals(other.internalGetLabels())) {
            return false;
        }
        if (!this.getReservationGroup().equals(other.getReservationGroup())) {
            return false;
        }
        if (this.hasReplicationStatus() != other.hasReplicationStatus()) {
            return false;
        }
        if (this.hasReplicationStatus() && !this.getReplicationStatus().equals(other.getReplicationStatus())) {
            return false;
        }
        if (this.hasSchedulingPolicy() != other.hasSchedulingPolicy()) {
            return false;
        }
        if (this.hasSchedulingPolicy() && !this.getSchedulingPolicy().equals(other.getSchedulingPolicy())) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + Reservation.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getName().hashCode();
        hash = 37 * hash + 2;
        hash = 53 * hash + Internal.hashLong((long)this.getSlotCapacity());
        hash = 37 * hash + 4;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getIgnoreIdleSlots());
        if (this.hasAutoscale()) {
            hash = 37 * hash + 7;
            hash = 53 * hash + this.getAutoscale().hashCode();
        }
        hash = 37 * hash + 16;
        hash = 53 * hash + Internal.hashLong((long)this.getConcurrency());
        if (this.hasCreationTime()) {
            hash = 37 * hash + 8;
            hash = 53 * hash + this.getCreationTime().hashCode();
        }
        if (this.hasUpdateTime()) {
            hash = 37 * hash + 9;
            hash = 53 * hash + this.getUpdateTime().hashCode();
        }
        hash = 37 * hash + 14;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getMultiRegionAuxiliary());
        hash = 37 * hash + 17;
        hash = 53 * hash + this.edition_;
        hash = 37 * hash + 18;
        hash = 53 * hash + this.getPrimaryLocation().hashCode();
        hash = 37 * hash + 19;
        hash = 53 * hash + this.getSecondaryLocation().hashCode();
        hash = 37 * hash + 20;
        hash = 53 * hash + this.getOriginalPrimaryLocation().hashCode();
        if (this.hasMaxSlots()) {
            hash = 37 * hash + 21;
            hash = 53 * hash + Internal.hashLong((long)this.getMaxSlots());
        }
        hash = 37 * hash + 22;
        hash = 53 * hash + this.scalingMode_;
        if (!this.internalGetLabels().getMap().isEmpty()) {
            hash = 37 * hash + 23;
            hash = 53 * hash + this.internalGetLabels().hashCode();
        }
        hash = 37 * hash + 25;
        hash = 53 * hash + this.getReservationGroup().hashCode();
        if (this.hasReplicationStatus()) {
            hash = 37 * hash + 24;
            hash = 53 * hash + this.getReplicationStatus().hashCode();
        }
        if (this.hasSchedulingPolicy()) {
            hash = 37 * hash + 27;
            hash = 53 * hash + this.getSchedulingPolicy().hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static Reservation parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (Reservation)PARSER.parseFrom(data);
    }

    public static Reservation parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Reservation)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Reservation parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (Reservation)PARSER.parseFrom(data);
    }

    public static Reservation parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Reservation)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Reservation parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (Reservation)PARSER.parseFrom(data);
    }

    public static Reservation parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Reservation)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Reservation parseFrom(InputStream input) throws IOException {
        return (Reservation)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static Reservation parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Reservation)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Reservation parseDelimitedFrom(InputStream input) throws IOException {
        return (Reservation)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static Reservation parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Reservation)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Reservation parseFrom(CodedInputStream input) throws IOException {
        return (Reservation)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static Reservation parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Reservation)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return Reservation.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(Reservation prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static Reservation getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<Reservation> parser() {
        return PARSER;
    }

    public Parser<Reservation> getParserForType() {
        return PARSER;
    }

    public Reservation getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements ReservationOrBuilder {
        private int bitField0_;
        private Object name_ = "";
        private long slotCapacity_;
        private boolean ignoreIdleSlots_;
        private Autoscale autoscale_;
        private SingleFieldBuilderV3<Autoscale, Autoscale.Builder, AutoscaleOrBuilder> autoscaleBuilder_;
        private long concurrency_;
        private Timestamp creationTime_;
        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> creationTimeBuilder_;
        private Timestamp updateTime_;
        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> updateTimeBuilder_;
        private boolean multiRegionAuxiliary_;
        private int edition_ = 0;
        private Object primaryLocation_ = "";
        private Object secondaryLocation_ = "";
        private Object originalPrimaryLocation_ = "";
        private long maxSlots_;
        private int scalingMode_ = 0;
        private MapField<String, String> labels_;
        private Object reservationGroup_ = "";
        private ReplicationStatus replicationStatus_;
        private SingleFieldBuilderV3<ReplicationStatus, ReplicationStatus.Builder, ReplicationStatusOrBuilder> replicationStatusBuilder_;
        private SchedulingPolicy schedulingPolicy_;
        private SingleFieldBuilderV3<SchedulingPolicy, SchedulingPolicy.Builder, SchedulingPolicyOrBuilder> schedulingPolicyBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return ReservationProto.internal_static_google_cloud_bigquery_reservation_v1_Reservation_descriptor;
        }

        protected MapFieldReflectionAccessor internalGetMapFieldReflection(int number) {
            switch (number) {
                case 23: {
                    return this.internalGetLabels();
                }
            }
            throw new RuntimeException("Invalid map field number: " + number);
        }

        protected MapFieldReflectionAccessor internalGetMutableMapFieldReflection(int number) {
            switch (number) {
                case 23: {
                    return this.internalGetMutableLabels();
                }
            }
            throw new RuntimeException("Invalid map field number: " + number);
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return ReservationProto.internal_static_google_cloud_bigquery_reservation_v1_Reservation_fieldAccessorTable.ensureFieldAccessorsInitialized(Reservation.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getAutoscaleFieldBuilder();
                this.getCreationTimeFieldBuilder();
                this.getUpdateTimeFieldBuilder();
                this.getReplicationStatusFieldBuilder();
                this.getSchedulingPolicyFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.name_ = "";
            this.slotCapacity_ = 0L;
            this.ignoreIdleSlots_ = false;
            this.autoscale_ = null;
            if (this.autoscaleBuilder_ != null) {
                this.autoscaleBuilder_.dispose();
                this.autoscaleBuilder_ = null;
            }
            this.concurrency_ = 0L;
            this.creationTime_ = null;
            if (this.creationTimeBuilder_ != null) {
                this.creationTimeBuilder_.dispose();
                this.creationTimeBuilder_ = null;
            }
            this.updateTime_ = null;
            if (this.updateTimeBuilder_ != null) {
                this.updateTimeBuilder_.dispose();
                this.updateTimeBuilder_ = null;
            }
            this.multiRegionAuxiliary_ = false;
            this.edition_ = 0;
            this.primaryLocation_ = "";
            this.secondaryLocation_ = "";
            this.originalPrimaryLocation_ = "";
            this.maxSlots_ = 0L;
            this.scalingMode_ = 0;
            this.internalGetMutableLabels().clear();
            this.reservationGroup_ = "";
            this.replicationStatus_ = null;
            if (this.replicationStatusBuilder_ != null) {
                this.replicationStatusBuilder_.dispose();
                this.replicationStatusBuilder_ = null;
            }
            this.schedulingPolicy_ = null;
            if (this.schedulingPolicyBuilder_ != null) {
                this.schedulingPolicyBuilder_.dispose();
                this.schedulingPolicyBuilder_ = null;
            }
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return ReservationProto.internal_static_google_cloud_bigquery_reservation_v1_Reservation_descriptor;
        }

        public Reservation getDefaultInstanceForType() {
            return Reservation.getDefaultInstance();
        }

        public Reservation build() {
            Reservation result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public Reservation buildPartial() {
            Reservation result = new Reservation(this);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartial0(Reservation result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.name_ = this.name_;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.slotCapacity_ = this.slotCapacity_;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.ignoreIdleSlots_ = this.ignoreIdleSlots_;
            }
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 8) != 0) {
                result.autoscale_ = this.autoscaleBuilder_ == null ? this.autoscale_ : (Autoscale)this.autoscaleBuilder_.build();
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.concurrency_ = this.concurrency_;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.creationTime_ = this.creationTimeBuilder_ == null ? this.creationTime_ : (Timestamp)this.creationTimeBuilder_.build();
                to_bitField0_ |= 2;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.updateTime_ = this.updateTimeBuilder_ == null ? this.updateTime_ : (Timestamp)this.updateTimeBuilder_.build();
                to_bitField0_ |= 4;
            }
            if ((from_bitField0_ & 0x80) != 0) {
                result.multiRegionAuxiliary_ = this.multiRegionAuxiliary_;
            }
            if ((from_bitField0_ & 0x100) != 0) {
                result.edition_ = this.edition_;
            }
            if ((from_bitField0_ & 0x200) != 0) {
                result.primaryLocation_ = this.primaryLocation_;
            }
            if ((from_bitField0_ & 0x400) != 0) {
                result.secondaryLocation_ = this.secondaryLocation_;
            }
            if ((from_bitField0_ & 0x800) != 0) {
                result.originalPrimaryLocation_ = this.originalPrimaryLocation_;
            }
            if ((from_bitField0_ & 0x1000) != 0) {
                result.maxSlots_ = this.maxSlots_;
                to_bitField0_ |= 8;
            }
            if ((from_bitField0_ & 0x2000) != 0) {
                result.scalingMode_ = this.scalingMode_;
            }
            if ((from_bitField0_ & 0x4000) != 0) {
                result.labels_ = this.internalGetLabels();
                result.labels_.makeImmutable();
            }
            if ((from_bitField0_ & 0x8000) != 0) {
                result.reservationGroup_ = this.reservationGroup_;
            }
            if ((from_bitField0_ & 0x10000) != 0) {
                result.replicationStatus_ = this.replicationStatusBuilder_ == null ? this.replicationStatus_ : (ReplicationStatus)this.replicationStatusBuilder_.build();
                to_bitField0_ |= 0x10;
            }
            if ((from_bitField0_ & 0x20000) != 0) {
                result.schedulingPolicy_ = this.schedulingPolicyBuilder_ == null ? this.schedulingPolicy_ : (SchedulingPolicy)this.schedulingPolicyBuilder_.build();
                to_bitField0_ |= 0x20;
            }
            Reservation reservation = result;
            reservation.bitField0_ = reservation.bitField0_ | to_bitField0_;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof Reservation) {
                return this.mergeFrom((Reservation)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(Reservation other) {
            if (other == Reservation.getDefaultInstance()) {
                return this;
            }
            if (!other.getName().isEmpty()) {
                this.name_ = other.name_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (other.getSlotCapacity() != 0L) {
                this.setSlotCapacity(other.getSlotCapacity());
            }
            if (other.getIgnoreIdleSlots()) {
                this.setIgnoreIdleSlots(other.getIgnoreIdleSlots());
            }
            if (other.hasAutoscale()) {
                this.mergeAutoscale(other.getAutoscale());
            }
            if (other.getConcurrency() != 0L) {
                this.setConcurrency(other.getConcurrency());
            }
            if (other.hasCreationTime()) {
                this.mergeCreationTime(other.getCreationTime());
            }
            if (other.hasUpdateTime()) {
                this.mergeUpdateTime(other.getUpdateTime());
            }
            if (other.getMultiRegionAuxiliary()) {
                this.setMultiRegionAuxiliary(other.getMultiRegionAuxiliary());
            }
            if (other.edition_ != 0) {
                this.setEditionValue(other.getEditionValue());
            }
            if (!other.getPrimaryLocation().isEmpty()) {
                this.primaryLocation_ = other.primaryLocation_;
                this.bitField0_ |= 0x200;
                this.onChanged();
            }
            if (!other.getSecondaryLocation().isEmpty()) {
                this.secondaryLocation_ = other.secondaryLocation_;
                this.bitField0_ |= 0x400;
                this.onChanged();
            }
            if (!other.getOriginalPrimaryLocation().isEmpty()) {
                this.originalPrimaryLocation_ = other.originalPrimaryLocation_;
                this.bitField0_ |= 0x800;
                this.onChanged();
            }
            if (other.hasMaxSlots()) {
                this.setMaxSlots(other.getMaxSlots());
            }
            if (other.scalingMode_ != 0) {
                this.setScalingModeValue(other.getScalingModeValue());
            }
            this.internalGetMutableLabels().mergeFrom(other.internalGetLabels());
            this.bitField0_ |= 0x4000;
            if (!other.getReservationGroup().isEmpty()) {
                this.reservationGroup_ = other.reservationGroup_;
                this.bitField0_ |= 0x8000;
                this.onChanged();
            }
            if (other.hasReplicationStatus()) {
                this.mergeReplicationStatus(other.getReplicationStatus());
            }
            if (other.hasSchedulingPolicy()) {
                this.mergeSchedulingPolicy(other.getSchedulingPolicy());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block26: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block26;
                        }
                        case 10: {
                            this.name_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block26;
                        }
                        case 16: {
                            this.slotCapacity_ = input.readInt64();
                            this.bitField0_ |= 2;
                            continue block26;
                        }
                        case 32: {
                            this.ignoreIdleSlots_ = input.readBool();
                            this.bitField0_ |= 4;
                            continue block26;
                        }
                        case 58: {
                            input.readMessage((MessageLite.Builder)this.getAutoscaleFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 8;
                            continue block26;
                        }
                        case 66: {
                            input.readMessage((MessageLite.Builder)this.getCreationTimeFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x20;
                            continue block26;
                        }
                        case 74: {
                            input.readMessage((MessageLite.Builder)this.getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x40;
                            continue block26;
                        }
                        case 112: {
                            this.multiRegionAuxiliary_ = input.readBool();
                            this.bitField0_ |= 0x80;
                            continue block26;
                        }
                        case 128: {
                            this.concurrency_ = input.readInt64();
                            this.bitField0_ |= 0x10;
                            continue block26;
                        }
                        case 136: {
                            this.edition_ = input.readEnum();
                            this.bitField0_ |= 0x100;
                            continue block26;
                        }
                        case 146: {
                            this.primaryLocation_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x200;
                            continue block26;
                        }
                        case 154: {
                            this.secondaryLocation_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x400;
                            continue block26;
                        }
                        case 162: {
                            this.originalPrimaryLocation_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x800;
                            continue block26;
                        }
                        case 168: {
                            this.maxSlots_ = input.readInt64();
                            this.bitField0_ |= 0x1000;
                            continue block26;
                        }
                        case 176: {
                            this.scalingMode_ = input.readEnum();
                            this.bitField0_ |= 0x2000;
                            continue block26;
                        }
                        case 186: {
                            MapEntry labels__ = (MapEntry)input.readMessage(LabelsDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
                            this.internalGetMutableLabels().getMutableMap().put(labels__.getKey(), labels__.getValue());
                            this.bitField0_ |= 0x4000;
                            continue block26;
                        }
                        case 194: {
                            input.readMessage((MessageLite.Builder)this.getReplicationStatusFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x10000;
                            continue block26;
                        }
                        case 202: {
                            this.reservationGroup_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x8000;
                            continue block26;
                        }
                        case 218: {
                            input.readMessage((MessageLite.Builder)this.getSchedulingPolicyFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x20000;
                            continue block26;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getName() {
            Object ref = this.name_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.name_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getNameBytes() {
            Object ref = this.name_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.name_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.name_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearName() {
            this.name_ = Reservation.getDefaultInstance().getName();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Reservation.checkByteStringIsUtf8((ByteString)value);
            this.name_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public long getSlotCapacity() {
            return this.slotCapacity_;
        }

        public Builder setSlotCapacity(long value) {
            this.slotCapacity_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearSlotCapacity() {
            this.bitField0_ &= 0xFFFFFFFD;
            this.slotCapacity_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public boolean getIgnoreIdleSlots() {
            return this.ignoreIdleSlots_;
        }

        public Builder setIgnoreIdleSlots(boolean value) {
            this.ignoreIdleSlots_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder clearIgnoreIdleSlots() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.ignoreIdleSlots_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasAutoscale() {
            return (this.bitField0_ & 8) != 0;
        }

        @Override
        public Autoscale getAutoscale() {
            if (this.autoscaleBuilder_ == null) {
                return this.autoscale_ == null ? Autoscale.getDefaultInstance() : this.autoscale_;
            }
            return (Autoscale)this.autoscaleBuilder_.getMessage();
        }

        public Builder setAutoscale(Autoscale value) {
            if (this.autoscaleBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.autoscale_ = value;
            } else {
                this.autoscaleBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder setAutoscale(Autoscale.Builder builderForValue) {
            if (this.autoscaleBuilder_ == null) {
                this.autoscale_ = builderForValue.build();
            } else {
                this.autoscaleBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder mergeAutoscale(Autoscale value) {
            if (this.autoscaleBuilder_ == null) {
                if ((this.bitField0_ & 8) != 0 && this.autoscale_ != null && this.autoscale_ != Autoscale.getDefaultInstance()) {
                    this.getAutoscaleBuilder().mergeFrom(value);
                } else {
                    this.autoscale_ = value;
                }
            } else {
                this.autoscaleBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.autoscale_ != null) {
                this.bitField0_ |= 8;
                this.onChanged();
            }
            return this;
        }

        public Builder clearAutoscale() {
            this.bitField0_ &= 0xFFFFFFF7;
            this.autoscale_ = null;
            if (this.autoscaleBuilder_ != null) {
                this.autoscaleBuilder_.dispose();
                this.autoscaleBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Autoscale.Builder getAutoscaleBuilder() {
            this.bitField0_ |= 8;
            this.onChanged();
            return (Autoscale.Builder)this.getAutoscaleFieldBuilder().getBuilder();
        }

        @Override
        public AutoscaleOrBuilder getAutoscaleOrBuilder() {
            if (this.autoscaleBuilder_ != null) {
                return (AutoscaleOrBuilder)this.autoscaleBuilder_.getMessageOrBuilder();
            }
            return this.autoscale_ == null ? Autoscale.getDefaultInstance() : this.autoscale_;
        }

        private SingleFieldBuilderV3<Autoscale, Autoscale.Builder, AutoscaleOrBuilder> getAutoscaleFieldBuilder() {
            if (this.autoscaleBuilder_ == null) {
                this.autoscaleBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getAutoscale(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.autoscale_ = null;
            }
            return this.autoscaleBuilder_;
        }

        @Override
        public long getConcurrency() {
            return this.concurrency_;
        }

        public Builder setConcurrency(long value) {
            this.concurrency_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder clearConcurrency() {
            this.bitField0_ &= 0xFFFFFFEF;
            this.concurrency_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasCreationTime() {
            return (this.bitField0_ & 0x20) != 0;
        }

        @Override
        public Timestamp getCreationTime() {
            if (this.creationTimeBuilder_ == null) {
                return this.creationTime_ == null ? Timestamp.getDefaultInstance() : this.creationTime_;
            }
            return (Timestamp)this.creationTimeBuilder_.getMessage();
        }

        public Builder setCreationTime(Timestamp value) {
            if (this.creationTimeBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.creationTime_ = value;
            } else {
                this.creationTimeBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder setCreationTime(Timestamp.Builder builderForValue) {
            if (this.creationTimeBuilder_ == null) {
                this.creationTime_ = builderForValue.build();
            } else {
                this.creationTimeBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder mergeCreationTime(Timestamp value) {
            if (this.creationTimeBuilder_ == null) {
                if ((this.bitField0_ & 0x20) != 0 && this.creationTime_ != null && this.creationTime_ != Timestamp.getDefaultInstance()) {
                    this.getCreationTimeBuilder().mergeFrom(value);
                } else {
                    this.creationTime_ = value;
                }
            } else {
                this.creationTimeBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.creationTime_ != null) {
                this.bitField0_ |= 0x20;
                this.onChanged();
            }
            return this;
        }

        public Builder clearCreationTime() {
            this.bitField0_ &= 0xFFFFFFDF;
            this.creationTime_ = null;
            if (this.creationTimeBuilder_ != null) {
                this.creationTimeBuilder_.dispose();
                this.creationTimeBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Timestamp.Builder getCreationTimeBuilder() {
            this.bitField0_ |= 0x20;
            this.onChanged();
            return (Timestamp.Builder)this.getCreationTimeFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getCreationTimeOrBuilder() {
            if (this.creationTimeBuilder_ != null) {
                return (TimestampOrBuilder)this.creationTimeBuilder_.getMessageOrBuilder();
            }
            return this.creationTime_ == null ? Timestamp.getDefaultInstance() : this.creationTime_;
        }

        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getCreationTimeFieldBuilder() {
            if (this.creationTimeBuilder_ == null) {
                this.creationTimeBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getCreationTime(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.creationTime_ = null;
            }
            return this.creationTimeBuilder_;
        }

        @Override
        public boolean hasUpdateTime() {
            return (this.bitField0_ & 0x40) != 0;
        }

        @Override
        public Timestamp getUpdateTime() {
            if (this.updateTimeBuilder_ == null) {
                return this.updateTime_ == null ? Timestamp.getDefaultInstance() : this.updateTime_;
            }
            return (Timestamp)this.updateTimeBuilder_.getMessage();
        }

        public Builder setUpdateTime(Timestamp value) {
            if (this.updateTimeBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.updateTime_ = value;
            } else {
                this.updateTimeBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder setUpdateTime(Timestamp.Builder builderForValue) {
            if (this.updateTimeBuilder_ == null) {
                this.updateTime_ = builderForValue.build();
            } else {
                this.updateTimeBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder mergeUpdateTime(Timestamp value) {
            if (this.updateTimeBuilder_ == null) {
                if ((this.bitField0_ & 0x40) != 0 && this.updateTime_ != null && this.updateTime_ != Timestamp.getDefaultInstance()) {
                    this.getUpdateTimeBuilder().mergeFrom(value);
                } else {
                    this.updateTime_ = value;
                }
            } else {
                this.updateTimeBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.updateTime_ != null) {
                this.bitField0_ |= 0x40;
                this.onChanged();
            }
            return this;
        }

        public Builder clearUpdateTime() {
            this.bitField0_ &= 0xFFFFFFBF;
            this.updateTime_ = null;
            if (this.updateTimeBuilder_ != null) {
                this.updateTimeBuilder_.dispose();
                this.updateTimeBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Timestamp.Builder getUpdateTimeBuilder() {
            this.bitField0_ |= 0x40;
            this.onChanged();
            return (Timestamp.Builder)this.getUpdateTimeFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getUpdateTimeOrBuilder() {
            if (this.updateTimeBuilder_ != null) {
                return (TimestampOrBuilder)this.updateTimeBuilder_.getMessageOrBuilder();
            }
            return this.updateTime_ == null ? Timestamp.getDefaultInstance() : this.updateTime_;
        }

        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getUpdateTimeFieldBuilder() {
            if (this.updateTimeBuilder_ == null) {
                this.updateTimeBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getUpdateTime(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.updateTime_ = null;
            }
            return this.updateTimeBuilder_;
        }

        @Override
        @Deprecated
        public boolean getMultiRegionAuxiliary() {
            return this.multiRegionAuxiliary_;
        }

        @Deprecated
        public Builder setMultiRegionAuxiliary(boolean value) {
            this.multiRegionAuxiliary_ = value;
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        @Deprecated
        public Builder clearMultiRegionAuxiliary() {
            this.bitField0_ &= 0xFFFFFF7F;
            this.multiRegionAuxiliary_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public int getEditionValue() {
            return this.edition_;
        }

        public Builder setEditionValue(int value) {
            this.edition_ = value;
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        @Override
        public Edition getEdition() {
            Edition result = Edition.forNumber(this.edition_);
            return result == null ? Edition.UNRECOGNIZED : result;
        }

        public Builder setEdition(Edition value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x100;
            this.edition_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearEdition() {
            this.bitField0_ &= 0xFFFFFEFF;
            this.edition_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public String getPrimaryLocation() {
            Object ref = this.primaryLocation_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.primaryLocation_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getPrimaryLocationBytes() {
            Object ref = this.primaryLocation_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.primaryLocation_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setPrimaryLocation(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.primaryLocation_ = value;
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        public Builder clearPrimaryLocation() {
            this.primaryLocation_ = Reservation.getDefaultInstance().getPrimaryLocation();
            this.bitField0_ &= 0xFFFFFDFF;
            this.onChanged();
            return this;
        }

        public Builder setPrimaryLocationBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Reservation.checkByteStringIsUtf8((ByteString)value);
            this.primaryLocation_ = value;
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        @Override
        public String getSecondaryLocation() {
            Object ref = this.secondaryLocation_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.secondaryLocation_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getSecondaryLocationBytes() {
            Object ref = this.secondaryLocation_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.secondaryLocation_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setSecondaryLocation(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.secondaryLocation_ = value;
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        public Builder clearSecondaryLocation() {
            this.secondaryLocation_ = Reservation.getDefaultInstance().getSecondaryLocation();
            this.bitField0_ &= 0xFFFFFBFF;
            this.onChanged();
            return this;
        }

        public Builder setSecondaryLocationBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Reservation.checkByteStringIsUtf8((ByteString)value);
            this.secondaryLocation_ = value;
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        @Override
        public String getOriginalPrimaryLocation() {
            Object ref = this.originalPrimaryLocation_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.originalPrimaryLocation_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getOriginalPrimaryLocationBytes() {
            Object ref = this.originalPrimaryLocation_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.originalPrimaryLocation_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setOriginalPrimaryLocation(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.originalPrimaryLocation_ = value;
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        public Builder clearOriginalPrimaryLocation() {
            this.originalPrimaryLocation_ = Reservation.getDefaultInstance().getOriginalPrimaryLocation();
            this.bitField0_ &= 0xFFFFF7FF;
            this.onChanged();
            return this;
        }

        public Builder setOriginalPrimaryLocationBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Reservation.checkByteStringIsUtf8((ByteString)value);
            this.originalPrimaryLocation_ = value;
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasMaxSlots() {
            return (this.bitField0_ & 0x1000) != 0;
        }

        @Override
        public long getMaxSlots() {
            return this.maxSlots_;
        }

        public Builder setMaxSlots(long value) {
            this.maxSlots_ = value;
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return this;
        }

        public Builder clearMaxSlots() {
            this.bitField0_ &= 0xFFFFEFFF;
            this.maxSlots_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public int getScalingModeValue() {
            return this.scalingMode_;
        }

        public Builder setScalingModeValue(int value) {
            this.scalingMode_ = value;
            this.bitField0_ |= 0x2000;
            this.onChanged();
            return this;
        }

        @Override
        public ScalingMode getScalingMode() {
            ScalingMode result = ScalingMode.forNumber(this.scalingMode_);
            return result == null ? ScalingMode.UNRECOGNIZED : result;
        }

        public Builder setScalingMode(ScalingMode value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x2000;
            this.scalingMode_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearScalingMode() {
            this.bitField0_ &= 0xFFFFDFFF;
            this.scalingMode_ = 0;
            this.onChanged();
            return this;
        }

        private MapField<String, String> internalGetLabels() {
            if (this.labels_ == null) {
                return MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
            }
            return this.labels_;
        }

        private MapField<String, String> internalGetMutableLabels() {
            if (this.labels_ == null) {
                this.labels_ = MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
            }
            if (!this.labels_.isMutable()) {
                this.labels_ = this.labels_.copy();
            }
            this.bitField0_ |= 0x4000;
            this.onChanged();
            return this.labels_;
        }

        @Override
        public int getLabelsCount() {
            return this.internalGetLabels().getMap().size();
        }

        @Override
        public boolean containsLabels(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            return this.internalGetLabels().getMap().containsKey(key);
        }

        @Override
        @Deprecated
        public Map<String, String> getLabels() {
            return this.getLabelsMap();
        }

        @Override
        public Map<String, String> getLabelsMap() {
            return this.internalGetLabels().getMap();
        }

        @Override
        public String getLabelsOrDefault(String key, String defaultValue) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetLabels().getMap();
            return map.containsKey(key) ? (String)map.get(key) : defaultValue;
        }

        @Override
        public String getLabelsOrThrow(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetLabels().getMap();
            if (!map.containsKey(key)) {
                throw new IllegalArgumentException();
            }
            return (String)map.get(key);
        }

        public Builder clearLabels() {
            this.bitField0_ &= 0xFFFFBFFF;
            this.internalGetMutableLabels().getMutableMap().clear();
            return this;
        }

        public Builder removeLabels(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            this.internalGetMutableLabels().getMutableMap().remove(key);
            return this;
        }

        @Deprecated
        public Map<String, String> getMutableLabels() {
            this.bitField0_ |= 0x4000;
            return this.internalGetMutableLabels().getMutableMap();
        }

        public Builder putLabels(String key, String value) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            if (value == null) {
                throw new NullPointerException("map value");
            }
            this.internalGetMutableLabels().getMutableMap().put(key, value);
            this.bitField0_ |= 0x4000;
            return this;
        }

        public Builder putAllLabels(Map<String, String> values) {
            this.internalGetMutableLabels().getMutableMap().putAll(values);
            this.bitField0_ |= 0x4000;
            return this;
        }

        @Override
        public String getReservationGroup() {
            Object ref = this.reservationGroup_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.reservationGroup_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getReservationGroupBytes() {
            Object ref = this.reservationGroup_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.reservationGroup_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setReservationGroup(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.reservationGroup_ = value;
            this.bitField0_ |= 0x8000;
            this.onChanged();
            return this;
        }

        public Builder clearReservationGroup() {
            this.reservationGroup_ = Reservation.getDefaultInstance().getReservationGroup();
            this.bitField0_ &= 0xFFFF7FFF;
            this.onChanged();
            return this;
        }

        public Builder setReservationGroupBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Reservation.checkByteStringIsUtf8((ByteString)value);
            this.reservationGroup_ = value;
            this.bitField0_ |= 0x8000;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasReplicationStatus() {
            return (this.bitField0_ & 0x10000) != 0;
        }

        @Override
        public ReplicationStatus getReplicationStatus() {
            if (this.replicationStatusBuilder_ == null) {
                return this.replicationStatus_ == null ? ReplicationStatus.getDefaultInstance() : this.replicationStatus_;
            }
            return (ReplicationStatus)this.replicationStatusBuilder_.getMessage();
        }

        public Builder setReplicationStatus(ReplicationStatus value) {
            if (this.replicationStatusBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.replicationStatus_ = value;
            } else {
                this.replicationStatusBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x10000;
            this.onChanged();
            return this;
        }

        public Builder setReplicationStatus(ReplicationStatus.Builder builderForValue) {
            if (this.replicationStatusBuilder_ == null) {
                this.replicationStatus_ = builderForValue.build();
            } else {
                this.replicationStatusBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x10000;
            this.onChanged();
            return this;
        }

        public Builder mergeReplicationStatus(ReplicationStatus value) {
            if (this.replicationStatusBuilder_ == null) {
                if ((this.bitField0_ & 0x10000) != 0 && this.replicationStatus_ != null && this.replicationStatus_ != ReplicationStatus.getDefaultInstance()) {
                    this.getReplicationStatusBuilder().mergeFrom(value);
                } else {
                    this.replicationStatus_ = value;
                }
            } else {
                this.replicationStatusBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.replicationStatus_ != null) {
                this.bitField0_ |= 0x10000;
                this.onChanged();
            }
            return this;
        }

        public Builder clearReplicationStatus() {
            this.bitField0_ &= 0xFFFEFFFF;
            this.replicationStatus_ = null;
            if (this.replicationStatusBuilder_ != null) {
                this.replicationStatusBuilder_.dispose();
                this.replicationStatusBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public ReplicationStatus.Builder getReplicationStatusBuilder() {
            this.bitField0_ |= 0x10000;
            this.onChanged();
            return (ReplicationStatus.Builder)this.getReplicationStatusFieldBuilder().getBuilder();
        }

        @Override
        public ReplicationStatusOrBuilder getReplicationStatusOrBuilder() {
            if (this.replicationStatusBuilder_ != null) {
                return (ReplicationStatusOrBuilder)this.replicationStatusBuilder_.getMessageOrBuilder();
            }
            return this.replicationStatus_ == null ? ReplicationStatus.getDefaultInstance() : this.replicationStatus_;
        }

        private SingleFieldBuilderV3<ReplicationStatus, ReplicationStatus.Builder, ReplicationStatusOrBuilder> getReplicationStatusFieldBuilder() {
            if (this.replicationStatusBuilder_ == null) {
                this.replicationStatusBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getReplicationStatus(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.replicationStatus_ = null;
            }
            return this.replicationStatusBuilder_;
        }

        @Override
        public boolean hasSchedulingPolicy() {
            return (this.bitField0_ & 0x20000) != 0;
        }

        @Override
        public SchedulingPolicy getSchedulingPolicy() {
            if (this.schedulingPolicyBuilder_ == null) {
                return this.schedulingPolicy_ == null ? SchedulingPolicy.getDefaultInstance() : this.schedulingPolicy_;
            }
            return (SchedulingPolicy)this.schedulingPolicyBuilder_.getMessage();
        }

        public Builder setSchedulingPolicy(SchedulingPolicy value) {
            if (this.schedulingPolicyBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.schedulingPolicy_ = value;
            } else {
                this.schedulingPolicyBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x20000;
            this.onChanged();
            return this;
        }

        public Builder setSchedulingPolicy(SchedulingPolicy.Builder builderForValue) {
            if (this.schedulingPolicyBuilder_ == null) {
                this.schedulingPolicy_ = builderForValue.build();
            } else {
                this.schedulingPolicyBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x20000;
            this.onChanged();
            return this;
        }

        public Builder mergeSchedulingPolicy(SchedulingPolicy value) {
            if (this.schedulingPolicyBuilder_ == null) {
                if ((this.bitField0_ & 0x20000) != 0 && this.schedulingPolicy_ != null && this.schedulingPolicy_ != SchedulingPolicy.getDefaultInstance()) {
                    this.getSchedulingPolicyBuilder().mergeFrom(value);
                } else {
                    this.schedulingPolicy_ = value;
                }
            } else {
                this.schedulingPolicyBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.schedulingPolicy_ != null) {
                this.bitField0_ |= 0x20000;
                this.onChanged();
            }
            return this;
        }

        public Builder clearSchedulingPolicy() {
            this.bitField0_ &= 0xFFFDFFFF;
            this.schedulingPolicy_ = null;
            if (this.schedulingPolicyBuilder_ != null) {
                this.schedulingPolicyBuilder_.dispose();
                this.schedulingPolicyBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public SchedulingPolicy.Builder getSchedulingPolicyBuilder() {
            this.bitField0_ |= 0x20000;
            this.onChanged();
            return (SchedulingPolicy.Builder)this.getSchedulingPolicyFieldBuilder().getBuilder();
        }

        @Override
        public SchedulingPolicyOrBuilder getSchedulingPolicyOrBuilder() {
            if (this.schedulingPolicyBuilder_ != null) {
                return (SchedulingPolicyOrBuilder)this.schedulingPolicyBuilder_.getMessageOrBuilder();
            }
            return this.schedulingPolicy_ == null ? SchedulingPolicy.getDefaultInstance() : this.schedulingPolicy_;
        }

        private SingleFieldBuilderV3<SchedulingPolicy, SchedulingPolicy.Builder, SchedulingPolicyOrBuilder> getSchedulingPolicyFieldBuilder() {
            if (this.schedulingPolicyBuilder_ == null) {
                this.schedulingPolicyBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getSchedulingPolicy(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.schedulingPolicy_ = null;
            }
            return this.schedulingPolicyBuilder_;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    private static final class LabelsDefaultEntryHolder {
        static final MapEntry<String, String> defaultEntry = MapEntry.newDefaultInstance((Descriptors.Descriptor)ReservationProto.internal_static_google_cloud_bigquery_reservation_v1_Reservation_LabelsEntry_descriptor, (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"", (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"");

        private LabelsDefaultEntryHolder() {
        }
    }

    public static final class ReplicationStatus
    extends GeneratedMessageV3
    implements ReplicationStatusOrBuilder {
        private static final long serialVersionUID = 0L;
        private int bitField0_;
        public static final int ERROR_FIELD_NUMBER = 1;
        private Status error_;
        public static final int LAST_ERROR_TIME_FIELD_NUMBER = 2;
        private Timestamp lastErrorTime_;
        public static final int LAST_REPLICATION_TIME_FIELD_NUMBER = 3;
        private Timestamp lastReplicationTime_;
        public static final int SOFT_FAILOVER_START_TIME_FIELD_NUMBER = 4;
        private Timestamp softFailoverStartTime_;
        private byte memoizedIsInitialized = (byte)-1;
        private static final ReplicationStatus DEFAULT_INSTANCE = new ReplicationStatus();
        private static final Parser<ReplicationStatus> PARSER = new AbstractParser<ReplicationStatus>(){

            public ReplicationStatus parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = ReplicationStatus.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private ReplicationStatus(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private ReplicationStatus() {
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new ReplicationStatus();
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return ReservationProto.internal_static_google_cloud_bigquery_reservation_v1_Reservation_ReplicationStatus_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return ReservationProto.internal_static_google_cloud_bigquery_reservation_v1_Reservation_ReplicationStatus_fieldAccessorTable.ensureFieldAccessorsInitialized(ReplicationStatus.class, Builder.class);
        }

        @Override
        public boolean hasError() {
            return (this.bitField0_ & 1) != 0;
        }

        @Override
        public Status getError() {
            return this.error_ == null ? Status.getDefaultInstance() : this.error_;
        }

        @Override
        public StatusOrBuilder getErrorOrBuilder() {
            return this.error_ == null ? Status.getDefaultInstance() : this.error_;
        }

        @Override
        public boolean hasLastErrorTime() {
            return (this.bitField0_ & 2) != 0;
        }

        @Override
        public Timestamp getLastErrorTime() {
            return this.lastErrorTime_ == null ? Timestamp.getDefaultInstance() : this.lastErrorTime_;
        }

        @Override
        public TimestampOrBuilder getLastErrorTimeOrBuilder() {
            return this.lastErrorTime_ == null ? Timestamp.getDefaultInstance() : this.lastErrorTime_;
        }

        @Override
        public boolean hasLastReplicationTime() {
            return (this.bitField0_ & 4) != 0;
        }

        @Override
        public Timestamp getLastReplicationTime() {
            return this.lastReplicationTime_ == null ? Timestamp.getDefaultInstance() : this.lastReplicationTime_;
        }

        @Override
        public TimestampOrBuilder getLastReplicationTimeOrBuilder() {
            return this.lastReplicationTime_ == null ? Timestamp.getDefaultInstance() : this.lastReplicationTime_;
        }

        @Override
        public boolean hasSoftFailoverStartTime() {
            return (this.bitField0_ & 8) != 0;
        }

        @Override
        public Timestamp getSoftFailoverStartTime() {
            return this.softFailoverStartTime_ == null ? Timestamp.getDefaultInstance() : this.softFailoverStartTime_;
        }

        @Override
        public TimestampOrBuilder getSoftFailoverStartTimeOrBuilder() {
            return this.softFailoverStartTime_ == null ? Timestamp.getDefaultInstance() : this.softFailoverStartTime_;
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            if ((this.bitField0_ & 1) != 0) {
                output.writeMessage(1, (MessageLite)this.getError());
            }
            if ((this.bitField0_ & 2) != 0) {
                output.writeMessage(2, (MessageLite)this.getLastErrorTime());
            }
            if ((this.bitField0_ & 4) != 0) {
                output.writeMessage(3, (MessageLite)this.getLastReplicationTime());
            }
            if ((this.bitField0_ & 8) != 0) {
                output.writeMessage(4, (MessageLite)this.getSoftFailoverStartTime());
            }
            this.getUnknownFields().writeTo(output);
        }

        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if ((this.bitField0_ & 1) != 0) {
                size += CodedOutputStream.computeMessageSize((int)1, (MessageLite)this.getError());
            }
            if ((this.bitField0_ & 2) != 0) {
                size += CodedOutputStream.computeMessageSize((int)2, (MessageLite)this.getLastErrorTime());
            }
            if ((this.bitField0_ & 4) != 0) {
                size += CodedOutputStream.computeMessageSize((int)3, (MessageLite)this.getLastReplicationTime());
            }
            if ((this.bitField0_ & 8) != 0) {
                size += CodedOutputStream.computeMessageSize((int)4, (MessageLite)this.getSoftFailoverStartTime());
            }
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ReplicationStatus)) {
                return super.equals(obj);
            }
            ReplicationStatus other = (ReplicationStatus)obj;
            if (this.hasError() != other.hasError()) {
                return false;
            }
            if (this.hasError() && !this.getError().equals((Object)other.getError())) {
                return false;
            }
            if (this.hasLastErrorTime() != other.hasLastErrorTime()) {
                return false;
            }
            if (this.hasLastErrorTime() && !this.getLastErrorTime().equals((Object)other.getLastErrorTime())) {
                return false;
            }
            if (this.hasLastReplicationTime() != other.hasLastReplicationTime()) {
                return false;
            }
            if (this.hasLastReplicationTime() && !this.getLastReplicationTime().equals((Object)other.getLastReplicationTime())) {
                return false;
            }
            if (this.hasSoftFailoverStartTime() != other.hasSoftFailoverStartTime()) {
                return false;
            }
            if (this.hasSoftFailoverStartTime() && !this.getSoftFailoverStartTime().equals((Object)other.getSoftFailoverStartTime())) {
                return false;
            }
            return this.getUnknownFields().equals((Object)other.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + ReplicationStatus.getDescriptor().hashCode();
            if (this.hasError()) {
                hash = 37 * hash + 1;
                hash = 53 * hash + this.getError().hashCode();
            }
            if (this.hasLastErrorTime()) {
                hash = 37 * hash + 2;
                hash = 53 * hash + this.getLastErrorTime().hashCode();
            }
            if (this.hasLastReplicationTime()) {
                hash = 37 * hash + 3;
                hash = 53 * hash + this.getLastReplicationTime().hashCode();
            }
            if (this.hasSoftFailoverStartTime()) {
                hash = 37 * hash + 4;
                hash = 53 * hash + this.getSoftFailoverStartTime().hashCode();
            }
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static ReplicationStatus parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (ReplicationStatus)PARSER.parseFrom(data);
        }

        public static ReplicationStatus parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (ReplicationStatus)PARSER.parseFrom(data, extensionRegistry);
        }

        public static ReplicationStatus parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (ReplicationStatus)PARSER.parseFrom(data);
        }

        public static ReplicationStatus parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (ReplicationStatus)PARSER.parseFrom(data, extensionRegistry);
        }

        public static ReplicationStatus parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (ReplicationStatus)PARSER.parseFrom(data);
        }

        public static ReplicationStatus parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (ReplicationStatus)PARSER.parseFrom(data, extensionRegistry);
        }

        public static ReplicationStatus parseFrom(InputStream input) throws IOException {
            return (ReplicationStatus)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static ReplicationStatus parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (ReplicationStatus)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static ReplicationStatus parseDelimitedFrom(InputStream input) throws IOException {
            return (ReplicationStatus)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static ReplicationStatus parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (ReplicationStatus)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static ReplicationStatus parseFrom(CodedInputStream input) throws IOException {
            return (ReplicationStatus)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static ReplicationStatus parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (ReplicationStatus)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return ReplicationStatus.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(ReplicationStatus prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static ReplicationStatus getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<ReplicationStatus> parser() {
            return PARSER;
        }

        public Parser<ReplicationStatus> getParserForType() {
            return PARSER;
        }

        public ReplicationStatus getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements ReplicationStatusOrBuilder {
            private int bitField0_;
            private Status error_;
            private SingleFieldBuilderV3<Status, Status.Builder, StatusOrBuilder> errorBuilder_;
            private Timestamp lastErrorTime_;
            private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> lastErrorTimeBuilder_;
            private Timestamp lastReplicationTime_;
            private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> lastReplicationTimeBuilder_;
            private Timestamp softFailoverStartTime_;
            private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> softFailoverStartTimeBuilder_;

            public static final Descriptors.Descriptor getDescriptor() {
                return ReservationProto.internal_static_google_cloud_bigquery_reservation_v1_Reservation_ReplicationStatus_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return ReservationProto.internal_static_google_cloud_bigquery_reservation_v1_Reservation_ReplicationStatus_fieldAccessorTable.ensureFieldAccessorsInitialized(ReplicationStatus.class, Builder.class);
            }

            private Builder() {
                this.maybeForceBuilderInitialization();
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
                this.maybeForceBuilderInitialization();
            }

            private void maybeForceBuilderInitialization() {
                if (alwaysUseFieldBuilders) {
                    this.getErrorFieldBuilder();
                    this.getLastErrorTimeFieldBuilder();
                    this.getLastReplicationTimeFieldBuilder();
                    this.getSoftFailoverStartTimeFieldBuilder();
                }
            }

            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                this.error_ = null;
                if (this.errorBuilder_ != null) {
                    this.errorBuilder_.dispose();
                    this.errorBuilder_ = null;
                }
                this.lastErrorTime_ = null;
                if (this.lastErrorTimeBuilder_ != null) {
                    this.lastErrorTimeBuilder_.dispose();
                    this.lastErrorTimeBuilder_ = null;
                }
                this.lastReplicationTime_ = null;
                if (this.lastReplicationTimeBuilder_ != null) {
                    this.lastReplicationTimeBuilder_.dispose();
                    this.lastReplicationTimeBuilder_ = null;
                }
                this.softFailoverStartTime_ = null;
                if (this.softFailoverStartTimeBuilder_ != null) {
                    this.softFailoverStartTimeBuilder_.dispose();
                    this.softFailoverStartTimeBuilder_ = null;
                }
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return ReservationProto.internal_static_google_cloud_bigquery_reservation_v1_Reservation_ReplicationStatus_descriptor;
            }

            public ReplicationStatus getDefaultInstanceForType() {
                return ReplicationStatus.getDefaultInstance();
            }

            public ReplicationStatus build() {
                ReplicationStatus result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public ReplicationStatus buildPartial() {
                ReplicationStatus result = new ReplicationStatus(this);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.onBuilt();
                return result;
            }

            private void buildPartial0(ReplicationStatus result) {
                int from_bitField0_ = this.bitField0_;
                int to_bitField0_ = 0;
                if ((from_bitField0_ & 1) != 0) {
                    result.error_ = this.errorBuilder_ == null ? this.error_ : (Status)this.errorBuilder_.build();
                    to_bitField0_ |= 1;
                }
                if ((from_bitField0_ & 2) != 0) {
                    result.lastErrorTime_ = this.lastErrorTimeBuilder_ == null ? this.lastErrorTime_ : (Timestamp)this.lastErrorTimeBuilder_.build();
                    to_bitField0_ |= 2;
                }
                if ((from_bitField0_ & 4) != 0) {
                    result.lastReplicationTime_ = this.lastReplicationTimeBuilder_ == null ? this.lastReplicationTime_ : (Timestamp)this.lastReplicationTimeBuilder_.build();
                    to_bitField0_ |= 4;
                }
                if ((from_bitField0_ & 8) != 0) {
                    result.softFailoverStartTime_ = this.softFailoverStartTimeBuilder_ == null ? this.softFailoverStartTime_ : (Timestamp)this.softFailoverStartTimeBuilder_.build();
                    to_bitField0_ |= 8;
                }
                ReplicationStatus replicationStatus = result;
                replicationStatus.bitField0_ = replicationStatus.bitField0_ | to_bitField0_;
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof ReplicationStatus) {
                    return this.mergeFrom((ReplicationStatus)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(ReplicationStatus other) {
                if (other == ReplicationStatus.getDefaultInstance()) {
                    return this;
                }
                if (other.hasError()) {
                    this.mergeError(other.getError());
                }
                if (other.hasLastErrorTime()) {
                    this.mergeLastErrorTime(other.getLastErrorTime());
                }
                if (other.hasLastReplicationTime()) {
                    this.mergeLastReplicationTime(other.getLastReplicationTime());
                }
                if (other.hasSoftFailoverStartTime()) {
                    this.mergeSoftFailoverStartTime(other.getSoftFailoverStartTime());
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block12: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block12;
                            }
                            case 10: {
                                input.readMessage((MessageLite.Builder)this.getErrorFieldBuilder().getBuilder(), extensionRegistry);
                                this.bitField0_ |= 1;
                                continue block12;
                            }
                            case 18: {
                                input.readMessage((MessageLite.Builder)this.getLastErrorTimeFieldBuilder().getBuilder(), extensionRegistry);
                                this.bitField0_ |= 2;
                                continue block12;
                            }
                            case 26: {
                                input.readMessage((MessageLite.Builder)this.getLastReplicationTimeFieldBuilder().getBuilder(), extensionRegistry);
                                this.bitField0_ |= 4;
                                continue block12;
                            }
                            case 34: {
                                input.readMessage((MessageLite.Builder)this.getSoftFailoverStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                                this.bitField0_ |= 8;
                                continue block12;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public boolean hasError() {
                return (this.bitField0_ & 1) != 0;
            }

            @Override
            public Status getError() {
                if (this.errorBuilder_ == null) {
                    return this.error_ == null ? Status.getDefaultInstance() : this.error_;
                }
                return (Status)this.errorBuilder_.getMessage();
            }

            public Builder setError(Status value) {
                if (this.errorBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.error_ = value;
                } else {
                    this.errorBuilder_.setMessage((AbstractMessage)value);
                }
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public Builder setError(Status.Builder builderForValue) {
                if (this.errorBuilder_ == null) {
                    this.error_ = builderForValue.build();
                } else {
                    this.errorBuilder_.setMessage((AbstractMessage)builderForValue.build());
                }
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public Builder mergeError(Status value) {
                if (this.errorBuilder_ == null) {
                    if ((this.bitField0_ & 1) != 0 && this.error_ != null && this.error_ != Status.getDefaultInstance()) {
                        this.getErrorBuilder().mergeFrom(value);
                    } else {
                        this.error_ = value;
                    }
                } else {
                    this.errorBuilder_.mergeFrom((AbstractMessage)value);
                }
                if (this.error_ != null) {
                    this.bitField0_ |= 1;
                    this.onChanged();
                }
                return this;
            }

            public Builder clearError() {
                this.bitField0_ &= 0xFFFFFFFE;
                this.error_ = null;
                if (this.errorBuilder_ != null) {
                    this.errorBuilder_.dispose();
                    this.errorBuilder_ = null;
                }
                this.onChanged();
                return this;
            }

            public Status.Builder getErrorBuilder() {
                this.bitField0_ |= 1;
                this.onChanged();
                return (Status.Builder)this.getErrorFieldBuilder().getBuilder();
            }

            @Override
            public StatusOrBuilder getErrorOrBuilder() {
                if (this.errorBuilder_ != null) {
                    return (StatusOrBuilder)this.errorBuilder_.getMessageOrBuilder();
                }
                return this.error_ == null ? Status.getDefaultInstance() : this.error_;
            }

            private SingleFieldBuilderV3<Status, Status.Builder, StatusOrBuilder> getErrorFieldBuilder() {
                if (this.errorBuilder_ == null) {
                    this.errorBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getError(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                    this.error_ = null;
                }
                return this.errorBuilder_;
            }

            @Override
            public boolean hasLastErrorTime() {
                return (this.bitField0_ & 2) != 0;
            }

            @Override
            public Timestamp getLastErrorTime() {
                if (this.lastErrorTimeBuilder_ == null) {
                    return this.lastErrorTime_ == null ? Timestamp.getDefaultInstance() : this.lastErrorTime_;
                }
                return (Timestamp)this.lastErrorTimeBuilder_.getMessage();
            }

            public Builder setLastErrorTime(Timestamp value) {
                if (this.lastErrorTimeBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.lastErrorTime_ = value;
                } else {
                    this.lastErrorTimeBuilder_.setMessage((AbstractMessage)value);
                }
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder setLastErrorTime(Timestamp.Builder builderForValue) {
                if (this.lastErrorTimeBuilder_ == null) {
                    this.lastErrorTime_ = builderForValue.build();
                } else {
                    this.lastErrorTimeBuilder_.setMessage((AbstractMessage)builderForValue.build());
                }
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder mergeLastErrorTime(Timestamp value) {
                if (this.lastErrorTimeBuilder_ == null) {
                    if ((this.bitField0_ & 2) != 0 && this.lastErrorTime_ != null && this.lastErrorTime_ != Timestamp.getDefaultInstance()) {
                        this.getLastErrorTimeBuilder().mergeFrom(value);
                    } else {
                        this.lastErrorTime_ = value;
                    }
                } else {
                    this.lastErrorTimeBuilder_.mergeFrom((AbstractMessage)value);
                }
                if (this.lastErrorTime_ != null) {
                    this.bitField0_ |= 2;
                    this.onChanged();
                }
                return this;
            }

            public Builder clearLastErrorTime() {
                this.bitField0_ &= 0xFFFFFFFD;
                this.lastErrorTime_ = null;
                if (this.lastErrorTimeBuilder_ != null) {
                    this.lastErrorTimeBuilder_.dispose();
                    this.lastErrorTimeBuilder_ = null;
                }
                this.onChanged();
                return this;
            }

            public Timestamp.Builder getLastErrorTimeBuilder() {
                this.bitField0_ |= 2;
                this.onChanged();
                return (Timestamp.Builder)this.getLastErrorTimeFieldBuilder().getBuilder();
            }

            @Override
            public TimestampOrBuilder getLastErrorTimeOrBuilder() {
                if (this.lastErrorTimeBuilder_ != null) {
                    return (TimestampOrBuilder)this.lastErrorTimeBuilder_.getMessageOrBuilder();
                }
                return this.lastErrorTime_ == null ? Timestamp.getDefaultInstance() : this.lastErrorTime_;
            }

            private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getLastErrorTimeFieldBuilder() {
                if (this.lastErrorTimeBuilder_ == null) {
                    this.lastErrorTimeBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getLastErrorTime(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                    this.lastErrorTime_ = null;
                }
                return this.lastErrorTimeBuilder_;
            }

            @Override
            public boolean hasLastReplicationTime() {
                return (this.bitField0_ & 4) != 0;
            }

            @Override
            public Timestamp getLastReplicationTime() {
                if (this.lastReplicationTimeBuilder_ == null) {
                    return this.lastReplicationTime_ == null ? Timestamp.getDefaultInstance() : this.lastReplicationTime_;
                }
                return (Timestamp)this.lastReplicationTimeBuilder_.getMessage();
            }

            public Builder setLastReplicationTime(Timestamp value) {
                if (this.lastReplicationTimeBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.lastReplicationTime_ = value;
                } else {
                    this.lastReplicationTimeBuilder_.setMessage((AbstractMessage)value);
                }
                this.bitField0_ |= 4;
                this.onChanged();
                return this;
            }

            public Builder setLastReplicationTime(Timestamp.Builder builderForValue) {
                if (this.lastReplicationTimeBuilder_ == null) {
                    this.lastReplicationTime_ = builderForValue.build();
                } else {
                    this.lastReplicationTimeBuilder_.setMessage((AbstractMessage)builderForValue.build());
                }
                this.bitField0_ |= 4;
                this.onChanged();
                return this;
            }

            public Builder mergeLastReplicationTime(Timestamp value) {
                if (this.lastReplicationTimeBuilder_ == null) {
                    if ((this.bitField0_ & 4) != 0 && this.lastReplicationTime_ != null && this.lastReplicationTime_ != Timestamp.getDefaultInstance()) {
                        this.getLastReplicationTimeBuilder().mergeFrom(value);
                    } else {
                        this.lastReplicationTime_ = value;
                    }
                } else {
                    this.lastReplicationTimeBuilder_.mergeFrom((AbstractMessage)value);
                }
                if (this.lastReplicationTime_ != null) {
                    this.bitField0_ |= 4;
                    this.onChanged();
                }
                return this;
            }

            public Builder clearLastReplicationTime() {
                this.bitField0_ &= 0xFFFFFFFB;
                this.lastReplicationTime_ = null;
                if (this.lastReplicationTimeBuilder_ != null) {
                    this.lastReplicationTimeBuilder_.dispose();
                    this.lastReplicationTimeBuilder_ = null;
                }
                this.onChanged();
                return this;
            }

            public Timestamp.Builder getLastReplicationTimeBuilder() {
                this.bitField0_ |= 4;
                this.onChanged();
                return (Timestamp.Builder)this.getLastReplicationTimeFieldBuilder().getBuilder();
            }

            @Override
            public TimestampOrBuilder getLastReplicationTimeOrBuilder() {
                if (this.lastReplicationTimeBuilder_ != null) {
                    return (TimestampOrBuilder)this.lastReplicationTimeBuilder_.getMessageOrBuilder();
                }
                return this.lastReplicationTime_ == null ? Timestamp.getDefaultInstance() : this.lastReplicationTime_;
            }

            private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getLastReplicationTimeFieldBuilder() {
                if (this.lastReplicationTimeBuilder_ == null) {
                    this.lastReplicationTimeBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getLastReplicationTime(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                    this.lastReplicationTime_ = null;
                }
                return this.lastReplicationTimeBuilder_;
            }

            @Override
            public boolean hasSoftFailoverStartTime() {
                return (this.bitField0_ & 8) != 0;
            }

            @Override
            public Timestamp getSoftFailoverStartTime() {
                if (this.softFailoverStartTimeBuilder_ == null) {
                    return this.softFailoverStartTime_ == null ? Timestamp.getDefaultInstance() : this.softFailoverStartTime_;
                }
                return (Timestamp)this.softFailoverStartTimeBuilder_.getMessage();
            }

            public Builder setSoftFailoverStartTime(Timestamp value) {
                if (this.softFailoverStartTimeBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.softFailoverStartTime_ = value;
                } else {
                    this.softFailoverStartTimeBuilder_.setMessage((AbstractMessage)value);
                }
                this.bitField0_ |= 8;
                this.onChanged();
                return this;
            }

            public Builder setSoftFailoverStartTime(Timestamp.Builder builderForValue) {
                if (this.softFailoverStartTimeBuilder_ == null) {
                    this.softFailoverStartTime_ = builderForValue.build();
                } else {
                    this.softFailoverStartTimeBuilder_.setMessage((AbstractMessage)builderForValue.build());
                }
                this.bitField0_ |= 8;
                this.onChanged();
                return this;
            }

            public Builder mergeSoftFailoverStartTime(Timestamp value) {
                if (this.softFailoverStartTimeBuilder_ == null) {
                    if ((this.bitField0_ & 8) != 0 && this.softFailoverStartTime_ != null && this.softFailoverStartTime_ != Timestamp.getDefaultInstance()) {
                        this.getSoftFailoverStartTimeBuilder().mergeFrom(value);
                    } else {
                        this.softFailoverStartTime_ = value;
                    }
                } else {
                    this.softFailoverStartTimeBuilder_.mergeFrom((AbstractMessage)value);
                }
                if (this.softFailoverStartTime_ != null) {
                    this.bitField0_ |= 8;
                    this.onChanged();
                }
                return this;
            }

            public Builder clearSoftFailoverStartTime() {
                this.bitField0_ &= 0xFFFFFFF7;
                this.softFailoverStartTime_ = null;
                if (this.softFailoverStartTimeBuilder_ != null) {
                    this.softFailoverStartTimeBuilder_.dispose();
                    this.softFailoverStartTimeBuilder_ = null;
                }
                this.onChanged();
                return this;
            }

            public Timestamp.Builder getSoftFailoverStartTimeBuilder() {
                this.bitField0_ |= 8;
                this.onChanged();
                return (Timestamp.Builder)this.getSoftFailoverStartTimeFieldBuilder().getBuilder();
            }

            @Override
            public TimestampOrBuilder getSoftFailoverStartTimeOrBuilder() {
                if (this.softFailoverStartTimeBuilder_ != null) {
                    return (TimestampOrBuilder)this.softFailoverStartTimeBuilder_.getMessageOrBuilder();
                }
                return this.softFailoverStartTime_ == null ? Timestamp.getDefaultInstance() : this.softFailoverStartTime_;
            }

            private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getSoftFailoverStartTimeFieldBuilder() {
                if (this.softFailoverStartTimeBuilder_ == null) {
                    this.softFailoverStartTimeBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getSoftFailoverStartTime(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                    this.softFailoverStartTime_ = null;
                }
                return this.softFailoverStartTimeBuilder_;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }
    }

    public static interface ReplicationStatusOrBuilder
    extends MessageOrBuilder {
        public boolean hasError();

        public Status getError();

        public StatusOrBuilder getErrorOrBuilder();

        public boolean hasLastErrorTime();

        public Timestamp getLastErrorTime();

        public TimestampOrBuilder getLastErrorTimeOrBuilder();

        public boolean hasLastReplicationTime();

        public Timestamp getLastReplicationTime();

        public TimestampOrBuilder getLastReplicationTimeOrBuilder();

        public boolean hasSoftFailoverStartTime();

        public Timestamp getSoftFailoverStartTime();

        public TimestampOrBuilder getSoftFailoverStartTimeOrBuilder();
    }

    public static final class Autoscale
    extends GeneratedMessageV3
    implements AutoscaleOrBuilder {
        private static final long serialVersionUID = 0L;
        public static final int CURRENT_SLOTS_FIELD_NUMBER = 1;
        private long currentSlots_ = 0L;
        public static final int MAX_SLOTS_FIELD_NUMBER = 2;
        private long maxSlots_ = 0L;
        private byte memoizedIsInitialized = (byte)-1;
        private static final Autoscale DEFAULT_INSTANCE = new Autoscale();
        private static final Parser<Autoscale> PARSER = new AbstractParser<Autoscale>(){

            public Autoscale parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = Autoscale.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private Autoscale(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private Autoscale() {
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new Autoscale();
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return ReservationProto.internal_static_google_cloud_bigquery_reservation_v1_Reservation_Autoscale_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return ReservationProto.internal_static_google_cloud_bigquery_reservation_v1_Reservation_Autoscale_fieldAccessorTable.ensureFieldAccessorsInitialized(Autoscale.class, Builder.class);
        }

        @Override
        public long getCurrentSlots() {
            return this.currentSlots_;
        }

        @Override
        public long getMaxSlots() {
            return this.maxSlots_;
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            if (this.currentSlots_ != 0L) {
                output.writeInt64(1, this.currentSlots_);
            }
            if (this.maxSlots_ != 0L) {
                output.writeInt64(2, this.maxSlots_);
            }
            this.getUnknownFields().writeTo(output);
        }

        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if (this.currentSlots_ != 0L) {
                size += CodedOutputStream.computeInt64Size((int)1, (long)this.currentSlots_);
            }
            if (this.maxSlots_ != 0L) {
                size += CodedOutputStream.computeInt64Size((int)2, (long)this.maxSlots_);
            }
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Autoscale)) {
                return super.equals(obj);
            }
            Autoscale other = (Autoscale)obj;
            if (this.getCurrentSlots() != other.getCurrentSlots()) {
                return false;
            }
            if (this.getMaxSlots() != other.getMaxSlots()) {
                return false;
            }
            return this.getUnknownFields().equals((Object)other.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + Autoscale.getDescriptor().hashCode();
            hash = 37 * hash + 1;
            hash = 53 * hash + Internal.hashLong((long)this.getCurrentSlots());
            hash = 37 * hash + 2;
            hash = 53 * hash + Internal.hashLong((long)this.getMaxSlots());
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static Autoscale parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (Autoscale)PARSER.parseFrom(data);
        }

        public static Autoscale parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (Autoscale)PARSER.parseFrom(data, extensionRegistry);
        }

        public static Autoscale parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (Autoscale)PARSER.parseFrom(data);
        }

        public static Autoscale parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (Autoscale)PARSER.parseFrom(data, extensionRegistry);
        }

        public static Autoscale parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (Autoscale)PARSER.parseFrom(data);
        }

        public static Autoscale parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (Autoscale)PARSER.parseFrom(data, extensionRegistry);
        }

        public static Autoscale parseFrom(InputStream input) throws IOException {
            return (Autoscale)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static Autoscale parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (Autoscale)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static Autoscale parseDelimitedFrom(InputStream input) throws IOException {
            return (Autoscale)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static Autoscale parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (Autoscale)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static Autoscale parseFrom(CodedInputStream input) throws IOException {
            return (Autoscale)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static Autoscale parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (Autoscale)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return Autoscale.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(Autoscale prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static Autoscale getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<Autoscale> parser() {
            return PARSER;
        }

        public Parser<Autoscale> getParserForType() {
            return PARSER;
        }

        public Autoscale getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements AutoscaleOrBuilder {
            private int bitField0_;
            private long currentSlots_;
            private long maxSlots_;

            public static final Descriptors.Descriptor getDescriptor() {
                return ReservationProto.internal_static_google_cloud_bigquery_reservation_v1_Reservation_Autoscale_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return ReservationProto.internal_static_google_cloud_bigquery_reservation_v1_Reservation_Autoscale_fieldAccessorTable.ensureFieldAccessorsInitialized(Autoscale.class, Builder.class);
            }

            private Builder() {
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
            }

            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                this.currentSlots_ = 0L;
                this.maxSlots_ = 0L;
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return ReservationProto.internal_static_google_cloud_bigquery_reservation_v1_Reservation_Autoscale_descriptor;
            }

            public Autoscale getDefaultInstanceForType() {
                return Autoscale.getDefaultInstance();
            }

            public Autoscale build() {
                Autoscale result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public Autoscale buildPartial() {
                Autoscale result = new Autoscale(this);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.onBuilt();
                return result;
            }

            private void buildPartial0(Autoscale result) {
                int from_bitField0_ = this.bitField0_;
                if ((from_bitField0_ & 1) != 0) {
                    result.currentSlots_ = this.currentSlots_;
                }
                if ((from_bitField0_ & 2) != 0) {
                    result.maxSlots_ = this.maxSlots_;
                }
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof Autoscale) {
                    return this.mergeFrom((Autoscale)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(Autoscale other) {
                if (other == Autoscale.getDefaultInstance()) {
                    return this;
                }
                if (other.getCurrentSlots() != 0L) {
                    this.setCurrentSlots(other.getCurrentSlots());
                }
                if (other.getMaxSlots() != 0L) {
                    this.setMaxSlots(other.getMaxSlots());
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block10: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block10;
                            }
                            case 8: {
                                this.currentSlots_ = input.readInt64();
                                this.bitField0_ |= 1;
                                continue block10;
                            }
                            case 16: {
                                this.maxSlots_ = input.readInt64();
                                this.bitField0_ |= 2;
                                continue block10;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public long getCurrentSlots() {
                return this.currentSlots_;
            }

            public Builder setCurrentSlots(long value) {
                this.currentSlots_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public Builder clearCurrentSlots() {
                this.bitField0_ &= 0xFFFFFFFE;
                this.currentSlots_ = 0L;
                this.onChanged();
                return this;
            }

            @Override
            public long getMaxSlots() {
                return this.maxSlots_;
            }

            public Builder setMaxSlots(long value) {
                this.maxSlots_ = value;
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder clearMaxSlots() {
                this.bitField0_ &= 0xFFFFFFFD;
                this.maxSlots_ = 0L;
                this.onChanged();
                return this;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }
    }

    public static interface AutoscaleOrBuilder
    extends MessageOrBuilder {
        public long getCurrentSlots();

        public long getMaxSlots();
    }

    public static enum ScalingMode implements ProtocolMessageEnum
    {
        SCALING_MODE_UNSPECIFIED(0),
        AUTOSCALE_ONLY(1),
        IDLE_SLOTS_ONLY(2),
        ALL_SLOTS(3),
        UNRECOGNIZED(-1);

        public static final int SCALING_MODE_UNSPECIFIED_VALUE = 0;
        public static final int AUTOSCALE_ONLY_VALUE = 1;
        public static final int IDLE_SLOTS_ONLY_VALUE = 2;
        public static final int ALL_SLOTS_VALUE = 3;
        private static final Internal.EnumLiteMap<ScalingMode> internalValueMap;
        private static final ScalingMode[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static ScalingMode valueOf(int value) {
            return ScalingMode.forNumber(value);
        }

        public static ScalingMode forNumber(int value) {
            switch (value) {
                case 0: {
                    return SCALING_MODE_UNSPECIFIED;
                }
                case 1: {
                    return AUTOSCALE_ONLY;
                }
                case 2: {
                    return IDLE_SLOTS_ONLY;
                }
                case 3: {
                    return ALL_SLOTS;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<ScalingMode> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)ScalingMode.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return ScalingMode.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)Reservation.getDescriptor().getEnumTypes().get(0);
        }

        public static ScalingMode valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != ScalingMode.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private ScalingMode(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<ScalingMode>(){

                public ScalingMode findValueByNumber(int number) {
                    return ScalingMode.forNumber(number);
                }
            };
            VALUES = ScalingMode.values();
        }
    }
}

