/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/storage/v1alpha/partition.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.bigquery.storage.v1alpha;

/**
 *
 *
 * <pre>
 * Information about a Hive partition.
 * </pre>
 *
 * Protobuf type {@code google.cloud.bigquery.storage.v1alpha.MetastorePartition}
 */
public final class MetastorePartition extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.bigquery.storage.v1alpha.MetastorePartition)
    MetastorePartitionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use MetastorePartition.newBuilder() to construct.
  private MetastorePartition(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private MetastorePartition() {
    values_ = com.google.protobuf.LazyStringArrayList.emptyList();
    fields_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new MetastorePartition();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.bigquery.storage.v1alpha.MetastorePartitionProto
        .internal_static_google_cloud_bigquery_storage_v1alpha_MetastorePartition_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 4:
        return internalGetParameters();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.bigquery.storage.v1alpha.MetastorePartitionProto
        .internal_static_google_cloud_bigquery_storage_v1alpha_MetastorePartition_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.bigquery.storage.v1alpha.MetastorePartition.class,
            com.google.cloud.bigquery.storage.v1alpha.MetastorePartition.Builder.class);
  }

  private int bitField0_;
  public static final int VALUES_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList values_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Required. Represents the values of the partition keys, where each value
   * corresponds to a specific partition key in the order in which the keys are
   * defined. Each value is limited to 1024 characters.
   * </pre>
   *
   * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return A list containing the values.
   */
  public com.google.protobuf.ProtocolStringList getValuesList() {
    return values_;
  }
  /**
   *
   *
   * <pre>
   * Required. Represents the values of the partition keys, where each value
   * corresponds to a specific partition key in the order in which the keys are
   * defined. Each value is limited to 1024 characters.
   * </pre>
   *
   * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The count of values.
   */
  public int getValuesCount() {
    return values_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. Represents the values of the partition keys, where each value
   * corresponds to a specific partition key in the order in which the keys are
   * defined. Each value is limited to 1024 characters.
   * </pre>
   *
   * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @param index The index of the element to return.
   * @return The values at the given index.
   */
  public java.lang.String getValues(int index) {
    return values_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. Represents the values of the partition keys, where each value
   * corresponds to a specific partition key in the order in which the keys are
   * defined. Each value is limited to 1024 characters.
   * </pre>
   *
   * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the values at the given index.
   */
  public com.google.protobuf.ByteString getValuesBytes(int index) {
    return values_.getByteString(index);
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The creation time of the partition.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The creation time of the partition.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The creation time of the partition.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int STORAGE_DESCRIPTOR_FIELD_NUMBER = 3;
  private com.google.cloud.bigquery.storage.v1alpha.StorageDescriptor storageDescriptor_;
  /**
   *
   *
   * <pre>
   * Optional. Contains information about the physical storage of the data in
   * the partition.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1alpha.StorageDescriptor storage_descriptor = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the storageDescriptor field is set.
   */
  @java.lang.Override
  public boolean hasStorageDescriptor() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Contains information about the physical storage of the data in
   * the partition.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1alpha.StorageDescriptor storage_descriptor = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The storageDescriptor.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1alpha.StorageDescriptor getStorageDescriptor() {
    return storageDescriptor_ == null
        ? com.google.cloud.bigquery.storage.v1alpha.StorageDescriptor.getDefaultInstance()
        : storageDescriptor_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Contains information about the physical storage of the data in
   * the partition.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1alpha.StorageDescriptor storage_descriptor = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1alpha.StorageDescriptorOrBuilder
      getStorageDescriptorOrBuilder() {
    return storageDescriptor_ == null
        ? com.google.cloud.bigquery.storage.v1alpha.StorageDescriptor.getDefaultInstance()
        : storageDescriptor_;
  }

  public static final int PARAMETERS_FIELD_NUMBER = 4;

  private static final class ParametersDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.bigquery.storage.v1alpha.MetastorePartitionProto
                .internal_static_google_cloud_bigquery_storage_v1alpha_MetastorePartition_ParametersEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> parameters_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetParameters() {
    if (parameters_ == null) {
      return com.google.protobuf.MapField.emptyMapField(ParametersDefaultEntryHolder.defaultEntry);
    }
    return parameters_;
  }

  public int getParametersCount() {
    return internalGetParameters().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Additional parameters or metadata associated with the partition.
   * Maximum size 10 KiB.
   * </pre>
   *
   * <code>map&lt;string, string&gt; parameters = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public boolean containsParameters(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetParameters().getMap().containsKey(key);
  }
  /** Use {@link #getParametersMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getParameters() {
    return getParametersMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Additional parameters or metadata associated with the partition.
   * Maximum size 10 KiB.
   * </pre>
   *
   * <code>map&lt;string, string&gt; parameters = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getParametersMap() {
    return internalGetParameters().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Additional parameters or metadata associated with the partition.
   * Maximum size 10 KiB.
   * </pre>
   *
   * <code>map&lt;string, string&gt; parameters = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getParametersOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetParameters().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. Additional parameters or metadata associated with the partition.
   * Maximum size 10 KiB.
   * </pre>
   *
   * <code>map&lt;string, string&gt; parameters = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.lang.String getParametersOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetParameters().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int FIELDS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.bigquery.storage.v1alpha.FieldSchema> fields_;
  /**
   *
   *
   * <pre>
   * Optional. List of columns.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.storage.v1alpha.FieldSchema fields = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.bigquery.storage.v1alpha.FieldSchema> getFieldsList() {
    return fields_;
  }
  /**
   *
   *
   * <pre>
   * Optional. List of columns.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.storage.v1alpha.FieldSchema fields = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.bigquery.storage.v1alpha.FieldSchemaOrBuilder>
      getFieldsOrBuilderList() {
    return fields_;
  }
  /**
   *
   *
   * <pre>
   * Optional. List of columns.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.storage.v1alpha.FieldSchema fields = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getFieldsCount() {
    return fields_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. List of columns.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.storage.v1alpha.FieldSchema fields = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1alpha.FieldSchema getFields(int index) {
    return fields_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. List of columns.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.storage.v1alpha.FieldSchema fields = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1alpha.FieldSchemaOrBuilder getFieldsOrBuilder(
      int index) {
    return fields_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < values_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, values_.getRaw(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getStorageDescriptor());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetParameters(), ParametersDefaultEntryHolder.defaultEntry, 4);
    for (int i = 0; i < fields_.size(); i++) {
      output.writeMessage(5, fields_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    {
      int dataSize = 0;
      for (int i = 0; i < values_.size(); i++) {
        dataSize += computeStringSizeNoTag(values_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getValuesList().size();
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getStorageDescriptor());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetParameters().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> parameters__ =
          ParametersDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, parameters__);
    }
    for (int i = 0; i < fields_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, fields_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.bigquery.storage.v1alpha.MetastorePartition)) {
      return super.equals(obj);
    }
    com.google.cloud.bigquery.storage.v1alpha.MetastorePartition other =
        (com.google.cloud.bigquery.storage.v1alpha.MetastorePartition) obj;

    if (!getValuesList().equals(other.getValuesList())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasStorageDescriptor() != other.hasStorageDescriptor()) return false;
    if (hasStorageDescriptor()) {
      if (!getStorageDescriptor().equals(other.getStorageDescriptor())) return false;
    }
    if (!internalGetParameters().equals(other.internalGetParameters())) return false;
    if (!getFieldsList().equals(other.getFieldsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getValuesCount() > 0) {
      hash = (37 * hash) + VALUES_FIELD_NUMBER;
      hash = (53 * hash) + getValuesList().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasStorageDescriptor()) {
      hash = (37 * hash) + STORAGE_DESCRIPTOR_FIELD_NUMBER;
      hash = (53 * hash) + getStorageDescriptor().hashCode();
    }
    if (!internalGetParameters().getMap().isEmpty()) {
      hash = (37 * hash) + PARAMETERS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetParameters().hashCode();
    }
    if (getFieldsCount() > 0) {
      hash = (37 * hash) + FIELDS_FIELD_NUMBER;
      hash = (53 * hash) + getFieldsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.bigquery.storage.v1alpha.MetastorePartition parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.storage.v1alpha.MetastorePartition parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1alpha.MetastorePartition parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.storage.v1alpha.MetastorePartition parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1alpha.MetastorePartition parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.storage.v1alpha.MetastorePartition parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1alpha.MetastorePartition parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.storage.v1alpha.MetastorePartition parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1alpha.MetastorePartition parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.storage.v1alpha.MetastorePartition parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1alpha.MetastorePartition parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.storage.v1alpha.MetastorePartition parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.bigquery.storage.v1alpha.MetastorePartition prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Information about a Hive partition.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.storage.v1alpha.MetastorePartition}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.storage.v1alpha.MetastorePartition)
      com.google.cloud.bigquery.storage.v1alpha.MetastorePartitionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.storage.v1alpha.MetastorePartitionProto
          .internal_static_google_cloud_bigquery_storage_v1alpha_MetastorePartition_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 4:
          return internalGetParameters();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 4:
          return internalGetMutableParameters();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.storage.v1alpha.MetastorePartitionProto
          .internal_static_google_cloud_bigquery_storage_v1alpha_MetastorePartition_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.storage.v1alpha.MetastorePartition.class,
              com.google.cloud.bigquery.storage.v1alpha.MetastorePartition.Builder.class);
    }

    // Construct using com.google.cloud.bigquery.storage.v1alpha.MetastorePartition.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getStorageDescriptorFieldBuilder();
        getFieldsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      values_ = com.google.protobuf.LazyStringArrayList.emptyList();
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      storageDescriptor_ = null;
      if (storageDescriptorBuilder_ != null) {
        storageDescriptorBuilder_.dispose();
        storageDescriptorBuilder_ = null;
      }
      internalGetMutableParameters().clear();
      if (fieldsBuilder_ == null) {
        fields_ = java.util.Collections.emptyList();
      } else {
        fields_ = null;
        fieldsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.bigquery.storage.v1alpha.MetastorePartitionProto
          .internal_static_google_cloud_bigquery_storage_v1alpha_MetastorePartition_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1alpha.MetastorePartition
        getDefaultInstanceForType() {
      return com.google.cloud.bigquery.storage.v1alpha.MetastorePartition.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1alpha.MetastorePartition build() {
      com.google.cloud.bigquery.storage.v1alpha.MetastorePartition result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1alpha.MetastorePartition buildPartial() {
      com.google.cloud.bigquery.storage.v1alpha.MetastorePartition result =
          new com.google.cloud.bigquery.storage.v1alpha.MetastorePartition(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.bigquery.storage.v1alpha.MetastorePartition result) {
      if (fieldsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          fields_ = java.util.Collections.unmodifiableList(fields_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.fields_ = fields_;
      } else {
        result.fields_ = fieldsBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.bigquery.storage.v1alpha.MetastorePartition result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        values_.makeImmutable();
        result.values_ = values_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.storageDescriptor_ =
            storageDescriptorBuilder_ == null
                ? storageDescriptor_
                : storageDescriptorBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.parameters_ = internalGetParameters();
        result.parameters_.makeImmutable();
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.bigquery.storage.v1alpha.MetastorePartition) {
        return mergeFrom((com.google.cloud.bigquery.storage.v1alpha.MetastorePartition) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.bigquery.storage.v1alpha.MetastorePartition other) {
      if (other
          == com.google.cloud.bigquery.storage.v1alpha.MetastorePartition.getDefaultInstance())
        return this;
      if (!other.values_.isEmpty()) {
        if (values_.isEmpty()) {
          values_ = other.values_;
          bitField0_ |= 0x00000001;
        } else {
          ensureValuesIsMutable();
          values_.addAll(other.values_);
        }
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasStorageDescriptor()) {
        mergeStorageDescriptor(other.getStorageDescriptor());
      }
      internalGetMutableParameters().mergeFrom(other.internalGetParameters());
      bitField0_ |= 0x00000008;
      if (fieldsBuilder_ == null) {
        if (!other.fields_.isEmpty()) {
          if (fields_.isEmpty()) {
            fields_ = other.fields_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureFieldsIsMutable();
            fields_.addAll(other.fields_);
          }
          onChanged();
        }
      } else {
        if (!other.fields_.isEmpty()) {
          if (fieldsBuilder_.isEmpty()) {
            fieldsBuilder_.dispose();
            fieldsBuilder_ = null;
            fields_ = other.fields_;
            bitField0_ = (bitField0_ & ~0x00000010);
            fieldsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getFieldsFieldBuilder()
                    : null;
          } else {
            fieldsBuilder_.addAllMessages(other.fields_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureValuesIsMutable();
                values_.add(s);
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getStorageDescriptorFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> parameters__ =
                    input.readMessage(
                        ParametersDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableParameters()
                    .getMutableMap()
                    .put(parameters__.getKey(), parameters__.getValue());
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                com.google.cloud.bigquery.storage.v1alpha.FieldSchema m =
                    input.readMessage(
                        com.google.cloud.bigquery.storage.v1alpha.FieldSchema.parser(),
                        extensionRegistry);
                if (fieldsBuilder_ == null) {
                  ensureFieldsIsMutable();
                  fields_.add(m);
                } else {
                  fieldsBuilder_.addMessage(m);
                }
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.LazyStringArrayList values_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureValuesIsMutable() {
      if (!values_.isModifiable()) {
        values_ = new com.google.protobuf.LazyStringArrayList(values_);
      }
      bitField0_ |= 0x00000001;
    }
    /**
     *
     *
     * <pre>
     * Required. Represents the values of the partition keys, where each value
     * corresponds to a specific partition key in the order in which the keys are
     * defined. Each value is limited to 1024 characters.
     * </pre>
     *
     * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return A list containing the values.
     */
    public com.google.protobuf.ProtocolStringList getValuesList() {
      values_.makeImmutable();
      return values_;
    }
    /**
     *
     *
     * <pre>
     * Required. Represents the values of the partition keys, where each value
     * corresponds to a specific partition key in the order in which the keys are
     * defined. Each value is limited to 1024 characters.
     * </pre>
     *
     * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The count of values.
     */
    public int getValuesCount() {
      return values_.size();
    }
    /**
     *
     *
     * <pre>
     * Required. Represents the values of the partition keys, where each value
     * corresponds to a specific partition key in the order in which the keys are
     * defined. Each value is limited to 1024 characters.
     * </pre>
     *
     * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index of the element to return.
     * @return The values at the given index.
     */
    public java.lang.String getValues(int index) {
      return values_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Required. Represents the values of the partition keys, where each value
     * corresponds to a specific partition key in the order in which the keys are
     * defined. Each value is limited to 1024 characters.
     * </pre>
     *
     * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the values at the given index.
     */
    public com.google.protobuf.ByteString getValuesBytes(int index) {
      return values_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Required. Represents the values of the partition keys, where each value
     * corresponds to a specific partition key in the order in which the keys are
     * defined. Each value is limited to 1024 characters.
     * </pre>
     *
     * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index to set the value at.
     * @param value The values to set.
     * @return This builder for chaining.
     */
    public Builder setValues(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureValuesIsMutable();
      values_.set(index, value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Represents the values of the partition keys, where each value
     * corresponds to a specific partition key in the order in which the keys are
     * defined. Each value is limited to 1024 characters.
     * </pre>
     *
     * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The values to add.
     * @return This builder for chaining.
     */
    public Builder addValues(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureValuesIsMutable();
      values_.add(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Represents the values of the partition keys, where each value
     * corresponds to a specific partition key in the order in which the keys are
     * defined. Each value is limited to 1024 characters.
     * </pre>
     *
     * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param values The values to add.
     * @return This builder for chaining.
     */
    public Builder addAllValues(java.lang.Iterable<java.lang.String> values) {
      ensureValuesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, values_);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Represents the values of the partition keys, where each value
     * corresponds to a specific partition key in the order in which the keys are
     * defined. Each value is limited to 1024 characters.
     * </pre>
     *
     * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearValues() {
      values_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Represents the values of the partition keys, where each value
     * corresponds to a specific partition key in the order in which the keys are
     * defined. Each value is limited to 1024 characters.
     * </pre>
     *
     * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes of the values to add.
     * @return This builder for chaining.
     */
    public Builder addValuesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureValuesIsMutable();
      values_.add(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The creation time of the partition.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time of the partition.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time of the partition.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time of the partition.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time of the partition.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time of the partition.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time of the partition.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time of the partition.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time of the partition.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.cloud.bigquery.storage.v1alpha.StorageDescriptor storageDescriptor_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1alpha.StorageDescriptor,
            com.google.cloud.bigquery.storage.v1alpha.StorageDescriptor.Builder,
            com.google.cloud.bigquery.storage.v1alpha.StorageDescriptorOrBuilder>
        storageDescriptorBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Contains information about the physical storage of the data in
     * the partition.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1alpha.StorageDescriptor storage_descriptor = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the storageDescriptor field is set.
     */
    public boolean hasStorageDescriptor() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Contains information about the physical storage of the data in
     * the partition.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1alpha.StorageDescriptor storage_descriptor = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The storageDescriptor.
     */
    public com.google.cloud.bigquery.storage.v1alpha.StorageDescriptor getStorageDescriptor() {
      if (storageDescriptorBuilder_ == null) {
        return storageDescriptor_ == null
            ? com.google.cloud.bigquery.storage.v1alpha.StorageDescriptor.getDefaultInstance()
            : storageDescriptor_;
      } else {
        return storageDescriptorBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Contains information about the physical storage of the data in
     * the partition.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1alpha.StorageDescriptor storage_descriptor = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setStorageDescriptor(
        com.google.cloud.bigquery.storage.v1alpha.StorageDescriptor value) {
      if (storageDescriptorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        storageDescriptor_ = value;
      } else {
        storageDescriptorBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Contains information about the physical storage of the data in
     * the partition.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1alpha.StorageDescriptor storage_descriptor = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setStorageDescriptor(
        com.google.cloud.bigquery.storage.v1alpha.StorageDescriptor.Builder builderForValue) {
      if (storageDescriptorBuilder_ == null) {
        storageDescriptor_ = builderForValue.build();
      } else {
        storageDescriptorBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Contains information about the physical storage of the data in
     * the partition.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1alpha.StorageDescriptor storage_descriptor = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeStorageDescriptor(
        com.google.cloud.bigquery.storage.v1alpha.StorageDescriptor value) {
      if (storageDescriptorBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && storageDescriptor_ != null
            && storageDescriptor_
                != com.google.cloud.bigquery.storage.v1alpha.StorageDescriptor
                    .getDefaultInstance()) {
          getStorageDescriptorBuilder().mergeFrom(value);
        } else {
          storageDescriptor_ = value;
        }
      } else {
        storageDescriptorBuilder_.mergeFrom(value);
      }
      if (storageDescriptor_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Contains information about the physical storage of the data in
     * the partition.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1alpha.StorageDescriptor storage_descriptor = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearStorageDescriptor() {
      bitField0_ = (bitField0_ & ~0x00000004);
      storageDescriptor_ = null;
      if (storageDescriptorBuilder_ != null) {
        storageDescriptorBuilder_.dispose();
        storageDescriptorBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Contains information about the physical storage of the data in
     * the partition.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1alpha.StorageDescriptor storage_descriptor = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.bigquery.storage.v1alpha.StorageDescriptor.Builder
        getStorageDescriptorBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getStorageDescriptorFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Contains information about the physical storage of the data in
     * the partition.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1alpha.StorageDescriptor storage_descriptor = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.bigquery.storage.v1alpha.StorageDescriptorOrBuilder
        getStorageDescriptorOrBuilder() {
      if (storageDescriptorBuilder_ != null) {
        return storageDescriptorBuilder_.getMessageOrBuilder();
      } else {
        return storageDescriptor_ == null
            ? com.google.cloud.bigquery.storage.v1alpha.StorageDescriptor.getDefaultInstance()
            : storageDescriptor_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Contains information about the physical storage of the data in
     * the partition.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1alpha.StorageDescriptor storage_descriptor = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1alpha.StorageDescriptor,
            com.google.cloud.bigquery.storage.v1alpha.StorageDescriptor.Builder,
            com.google.cloud.bigquery.storage.v1alpha.StorageDescriptorOrBuilder>
        getStorageDescriptorFieldBuilder() {
      if (storageDescriptorBuilder_ == null) {
        storageDescriptorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.storage.v1alpha.StorageDescriptor,
                com.google.cloud.bigquery.storage.v1alpha.StorageDescriptor.Builder,
                com.google.cloud.bigquery.storage.v1alpha.StorageDescriptorOrBuilder>(
                getStorageDescriptor(), getParentForChildren(), isClean());
        storageDescriptor_ = null;
      }
      return storageDescriptorBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> parameters_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetParameters() {
      if (parameters_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            ParametersDefaultEntryHolder.defaultEntry);
      }
      return parameters_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableParameters() {
      if (parameters_ == null) {
        parameters_ =
            com.google.protobuf.MapField.newMapField(ParametersDefaultEntryHolder.defaultEntry);
      }
      if (!parameters_.isMutable()) {
        parameters_ = parameters_.copy();
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return parameters_;
    }

    public int getParametersCount() {
      return internalGetParameters().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional parameters or metadata associated with the partition.
     * Maximum size 10 KiB.
     * </pre>
     *
     * <code>map&lt;string, string&gt; parameters = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public boolean containsParameters(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetParameters().getMap().containsKey(key);
    }
    /** Use {@link #getParametersMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getParameters() {
      return getParametersMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional parameters or metadata associated with the partition.
     * Maximum size 10 KiB.
     * </pre>
     *
     * <code>map&lt;string, string&gt; parameters = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getParametersMap() {
      return internalGetParameters().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional parameters or metadata associated with the partition.
     * Maximum size 10 KiB.
     * </pre>
     *
     * <code>map&lt;string, string&gt; parameters = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getParametersOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetParameters().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional parameters or metadata associated with the partition.
     * Maximum size 10 KiB.
     * </pre>
     *
     * <code>map&lt;string, string&gt; parameters = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.lang.String getParametersOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetParameters().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearParameters() {
      bitField0_ = (bitField0_ & ~0x00000008);
      internalGetMutableParameters().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional parameters or metadata associated with the partition.
     * Maximum size 10 KiB.
     * </pre>
     *
     * <code>map&lt;string, string&gt; parameters = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeParameters(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableParameters().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableParameters() {
      bitField0_ |= 0x00000008;
      return internalGetMutableParameters().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional parameters or metadata associated with the partition.
     * Maximum size 10 KiB.
     * </pre>
     *
     * <code>map&lt;string, string&gt; parameters = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putParameters(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableParameters().getMutableMap().put(key, value);
      bitField0_ |= 0x00000008;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional parameters or metadata associated with the partition.
     * Maximum size 10 KiB.
     * </pre>
     *
     * <code>map&lt;string, string&gt; parameters = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAllParameters(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableParameters().getMutableMap().putAll(values);
      bitField0_ |= 0x00000008;
      return this;
    }

    private java.util.List<com.google.cloud.bigquery.storage.v1alpha.FieldSchema> fields_ =
        java.util.Collections.emptyList();

    private void ensureFieldsIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        fields_ =
            new java.util.ArrayList<com.google.cloud.bigquery.storage.v1alpha.FieldSchema>(fields_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1alpha.FieldSchema,
            com.google.cloud.bigquery.storage.v1alpha.FieldSchema.Builder,
            com.google.cloud.bigquery.storage.v1alpha.FieldSchemaOrBuilder>
        fieldsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. List of columns.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1alpha.FieldSchema fields = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.bigquery.storage.v1alpha.FieldSchema> getFieldsList() {
      if (fieldsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(fields_);
      } else {
        return fieldsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of columns.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1alpha.FieldSchema fields = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getFieldsCount() {
      if (fieldsBuilder_ == null) {
        return fields_.size();
      } else {
        return fieldsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of columns.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1alpha.FieldSchema fields = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.bigquery.storage.v1alpha.FieldSchema getFields(int index) {
      if (fieldsBuilder_ == null) {
        return fields_.get(index);
      } else {
        return fieldsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of columns.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1alpha.FieldSchema fields = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setFields(
        int index, com.google.cloud.bigquery.storage.v1alpha.FieldSchema value) {
      if (fieldsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFieldsIsMutable();
        fields_.set(index, value);
        onChanged();
      } else {
        fieldsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of columns.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1alpha.FieldSchema fields = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setFields(
        int index, com.google.cloud.bigquery.storage.v1alpha.FieldSchema.Builder builderForValue) {
      if (fieldsBuilder_ == null) {
        ensureFieldsIsMutable();
        fields_.set(index, builderForValue.build());
        onChanged();
      } else {
        fieldsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of columns.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1alpha.FieldSchema fields = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addFields(com.google.cloud.bigquery.storage.v1alpha.FieldSchema value) {
      if (fieldsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFieldsIsMutable();
        fields_.add(value);
        onChanged();
      } else {
        fieldsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of columns.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1alpha.FieldSchema fields = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addFields(
        int index, com.google.cloud.bigquery.storage.v1alpha.FieldSchema value) {
      if (fieldsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFieldsIsMutable();
        fields_.add(index, value);
        onChanged();
      } else {
        fieldsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of columns.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1alpha.FieldSchema fields = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addFields(
        com.google.cloud.bigquery.storage.v1alpha.FieldSchema.Builder builderForValue) {
      if (fieldsBuilder_ == null) {
        ensureFieldsIsMutable();
        fields_.add(builderForValue.build());
        onChanged();
      } else {
        fieldsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of columns.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1alpha.FieldSchema fields = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addFields(
        int index, com.google.cloud.bigquery.storage.v1alpha.FieldSchema.Builder builderForValue) {
      if (fieldsBuilder_ == null) {
        ensureFieldsIsMutable();
        fields_.add(index, builderForValue.build());
        onChanged();
      } else {
        fieldsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of columns.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1alpha.FieldSchema fields = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllFields(
        java.lang.Iterable<? extends com.google.cloud.bigquery.storage.v1alpha.FieldSchema>
            values) {
      if (fieldsBuilder_ == null) {
        ensureFieldsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, fields_);
        onChanged();
      } else {
        fieldsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of columns.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1alpha.FieldSchema fields = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearFields() {
      if (fieldsBuilder_ == null) {
        fields_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        fieldsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of columns.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1alpha.FieldSchema fields = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeFields(int index) {
      if (fieldsBuilder_ == null) {
        ensureFieldsIsMutable();
        fields_.remove(index);
        onChanged();
      } else {
        fieldsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of columns.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1alpha.FieldSchema fields = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.bigquery.storage.v1alpha.FieldSchema.Builder getFieldsBuilder(
        int index) {
      return getFieldsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. List of columns.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1alpha.FieldSchema fields = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.bigquery.storage.v1alpha.FieldSchemaOrBuilder getFieldsOrBuilder(
        int index) {
      if (fieldsBuilder_ == null) {
        return fields_.get(index);
      } else {
        return fieldsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of columns.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1alpha.FieldSchema fields = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.bigquery.storage.v1alpha.FieldSchemaOrBuilder>
        getFieldsOrBuilderList() {
      if (fieldsBuilder_ != null) {
        return fieldsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(fields_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of columns.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1alpha.FieldSchema fields = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.bigquery.storage.v1alpha.FieldSchema.Builder addFieldsBuilder() {
      return getFieldsFieldBuilder()
          .addBuilder(com.google.cloud.bigquery.storage.v1alpha.FieldSchema.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. List of columns.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1alpha.FieldSchema fields = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.bigquery.storage.v1alpha.FieldSchema.Builder addFieldsBuilder(
        int index) {
      return getFieldsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.bigquery.storage.v1alpha.FieldSchema.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. List of columns.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1alpha.FieldSchema fields = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.bigquery.storage.v1alpha.FieldSchema.Builder>
        getFieldsBuilderList() {
      return getFieldsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1alpha.FieldSchema,
            com.google.cloud.bigquery.storage.v1alpha.FieldSchema.Builder,
            com.google.cloud.bigquery.storage.v1alpha.FieldSchemaOrBuilder>
        getFieldsFieldBuilder() {
      if (fieldsBuilder_ == null) {
        fieldsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.bigquery.storage.v1alpha.FieldSchema,
                com.google.cloud.bigquery.storage.v1alpha.FieldSchema.Builder,
                com.google.cloud.bigquery.storage.v1alpha.FieldSchemaOrBuilder>(
                fields_, ((bitField0_ & 0x00000010) != 0), getParentForChildren(), isClean());
        fields_ = null;
      }
      return fieldsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.storage.v1alpha.MetastorePartition)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.bigquery.storage.v1alpha.MetastorePartition)
  private static final com.google.cloud.bigquery.storage.v1alpha.MetastorePartition
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.bigquery.storage.v1alpha.MetastorePartition();
  }

  public static com.google.cloud.bigquery.storage.v1alpha.MetastorePartition getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<MetastorePartition> PARSER =
      new com.google.protobuf.AbstractParser<MetastorePartition>() {
        @java.lang.Override
        public MetastorePartition parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<MetastorePartition> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<MetastorePartition> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1alpha.MetastorePartition getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
