/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/storage/v1alpha/partition.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.bigquery.storage.v1alpha;

public interface MetastorePartitionOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.storage.v1alpha.MetastorePartition)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. Represents the values of the partition keys, where each value
   * corresponds to a specific partition key in the order in which the keys are
   * defined. Each value is limited to 1024 characters.
   * </pre>
   *
   * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return A list containing the values.
   */
  java.util.List<java.lang.String> getValuesList();
  /**
   *
   *
   * <pre>
   * Required. Represents the values of the partition keys, where each value
   * corresponds to a specific partition key in the order in which the keys are
   * defined. Each value is limited to 1024 characters.
   * </pre>
   *
   * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The count of values.
   */
  int getValuesCount();
  /**
   *
   *
   * <pre>
   * Required. Represents the values of the partition keys, where each value
   * corresponds to a specific partition key in the order in which the keys are
   * defined. Each value is limited to 1024 characters.
   * </pre>
   *
   * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @param index The index of the element to return.
   * @return The values at the given index.
   */
  java.lang.String getValues(int index);
  /**
   *
   *
   * <pre>
   * Required. Represents the values of the partition keys, where each value
   * corresponds to a specific partition key in the order in which the keys are
   * defined. Each value is limited to 1024 characters.
   * </pre>
   *
   * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the values at the given index.
   */
  com.google.protobuf.ByteString getValuesBytes(int index);

  /**
   *
   *
   * <pre>
   * Output only. The creation time of the partition.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  boolean hasCreateTime();
  /**
   *
   *
   * <pre>
   * Output only. The creation time of the partition.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  com.google.protobuf.Timestamp getCreateTime();
  /**
   *
   *
   * <pre>
   * Output only. The creation time of the partition.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. Contains information about the physical storage of the data in
   * the partition.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1alpha.StorageDescriptor storage_descriptor = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the storageDescriptor field is set.
   */
  boolean hasStorageDescriptor();
  /**
   *
   *
   * <pre>
   * Optional. Contains information about the physical storage of the data in
   * the partition.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1alpha.StorageDescriptor storage_descriptor = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The storageDescriptor.
   */
  com.google.cloud.bigquery.storage.v1alpha.StorageDescriptor getStorageDescriptor();
  /**
   *
   *
   * <pre>
   * Optional. Contains information about the physical storage of the data in
   * the partition.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1alpha.StorageDescriptor storage_descriptor = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.bigquery.storage.v1alpha.StorageDescriptorOrBuilder
      getStorageDescriptorOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. Additional parameters or metadata associated with the partition.
   * Maximum size 10 KiB.
   * </pre>
   *
   * <code>map&lt;string, string&gt; parameters = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  int getParametersCount();
  /**
   *
   *
   * <pre>
   * Optional. Additional parameters or metadata associated with the partition.
   * Maximum size 10 KiB.
   * </pre>
   *
   * <code>map&lt;string, string&gt; parameters = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  boolean containsParameters(java.lang.String key);
  /** Use {@link #getParametersMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, java.lang.String> getParameters();
  /**
   *
   *
   * <pre>
   * Optional. Additional parameters or metadata associated with the partition.
   * Maximum size 10 KiB.
   * </pre>
   *
   * <code>map&lt;string, string&gt; parameters = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.util.Map<java.lang.String, java.lang.String> getParametersMap();
  /**
   *
   *
   * <pre>
   * Optional. Additional parameters or metadata associated with the partition.
   * Maximum size 10 KiB.
   * </pre>
   *
   * <code>map&lt;string, string&gt; parameters = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  /* nullable */
  java.lang.String getParametersOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue);
  /**
   *
   *
   * <pre>
   * Optional. Additional parameters or metadata associated with the partition.
   * Maximum size 10 KiB.
   * </pre>
   *
   * <code>map&lt;string, string&gt; parameters = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.lang.String getParametersOrThrow(java.lang.String key);

  /**
   *
   *
   * <pre>
   * Optional. List of columns.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.storage.v1alpha.FieldSchema fields = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.util.List<com.google.cloud.bigquery.storage.v1alpha.FieldSchema> getFieldsList();
  /**
   *
   *
   * <pre>
   * Optional. List of columns.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.storage.v1alpha.FieldSchema fields = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.bigquery.storage.v1alpha.FieldSchema getFields(int index);
  /**
   *
   *
   * <pre>
   * Optional. List of columns.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.storage.v1alpha.FieldSchema fields = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  int getFieldsCount();
  /**
   *
   *
   * <pre>
   * Optional. List of columns.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.storage.v1alpha.FieldSchema fields = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.util.List<? extends com.google.cloud.bigquery.storage.v1alpha.FieldSchemaOrBuilder>
      getFieldsOrBuilderList();
  /**
   *
   *
   * <pre>
   * Optional. List of columns.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.storage.v1alpha.FieldSchema fields = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.bigquery.storage.v1alpha.FieldSchemaOrBuilder getFieldsOrBuilder(int index);
}
