/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/storage/v1alpha/partition.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.bigquery.storage.v1alpha;

/**
 *
 *
 * <pre>
 * Contains information about the physical storage of the data in the metastore
 * partition.
 * </pre>
 *
 * Protobuf type {@code google.cloud.bigquery.storage.v1alpha.StorageDescriptor}
 */
public final class StorageDescriptor extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.bigquery.storage.v1alpha.StorageDescriptor)
    StorageDescriptorOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use StorageDescriptor.newBuilder() to construct.
  private StorageDescriptor(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private StorageDescriptor() {
    locationUri_ = "";
    inputFormat_ = "";
    outputFormat_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new StorageDescriptor();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.bigquery.storage.v1alpha.MetastorePartitionProto
        .internal_static_google_cloud_bigquery_storage_v1alpha_StorageDescriptor_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.bigquery.storage.v1alpha.MetastorePartitionProto
        .internal_static_google_cloud_bigquery_storage_v1alpha_StorageDescriptor_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.bigquery.storage.v1alpha.StorageDescriptor.class,
            com.google.cloud.bigquery.storage.v1alpha.StorageDescriptor.Builder.class);
  }

  private int bitField0_;
  public static final int LOCATION_URI_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object locationUri_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The physical location of the metastore partition
   * (e.g. `gs://spark-dataproc-data/pangea-data/case_sensitive/` or
   * `gs://spark-dataproc-data/pangea-data/&#42;`).
   * </pre>
   *
   * <code>string location_uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The locationUri.
   */
  @java.lang.Override
  public java.lang.String getLocationUri() {
    java.lang.Object ref = locationUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      locationUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The physical location of the metastore partition
   * (e.g. `gs://spark-dataproc-data/pangea-data/case_sensitive/` or
   * `gs://spark-dataproc-data/pangea-data/&#42;`).
   * </pre>
   *
   * <code>string location_uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for locationUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLocationUriBytes() {
    java.lang.Object ref = locationUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      locationUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INPUT_FORMAT_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object inputFormat_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Specifies the fully qualified class name of the InputFormat
   * (e.g. "org.apache.hadoop.hive.ql.io.orc.OrcInputFormat").
   * The maximum length is 128 characters.
   * </pre>
   *
   * <code>string input_format = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The inputFormat.
   */
  @java.lang.Override
  public java.lang.String getInputFormat() {
    java.lang.Object ref = inputFormat_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      inputFormat_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Specifies the fully qualified class name of the InputFormat
   * (e.g. "org.apache.hadoop.hive.ql.io.orc.OrcInputFormat").
   * The maximum length is 128 characters.
   * </pre>
   *
   * <code>string input_format = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for inputFormat.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInputFormatBytes() {
    java.lang.Object ref = inputFormat_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      inputFormat_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int OUTPUT_FORMAT_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object outputFormat_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Specifies the fully qualified class name of the OutputFormat
   * (e.g. "org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat").
   * The maximum length is 128 characters.
   * </pre>
   *
   * <code>string output_format = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The outputFormat.
   */
  @java.lang.Override
  public java.lang.String getOutputFormat() {
    java.lang.Object ref = outputFormat_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      outputFormat_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Specifies the fully qualified class name of the OutputFormat
   * (e.g. "org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat").
   * The maximum length is 128 characters.
   * </pre>
   *
   * <code>string output_format = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for outputFormat.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOutputFormatBytes() {
    java.lang.Object ref = outputFormat_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      outputFormat_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SERDE_INFO_FIELD_NUMBER = 4;
  private com.google.cloud.bigquery.storage.v1alpha.SerDeInfo serdeInfo_;
  /**
   *
   *
   * <pre>
   * Optional. Serializer and deserializer information.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1alpha.SerDeInfo serde_info = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the serdeInfo field is set.
   */
  @java.lang.Override
  public boolean hasSerdeInfo() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Serializer and deserializer information.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1alpha.SerDeInfo serde_info = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The serdeInfo.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1alpha.SerDeInfo getSerdeInfo() {
    return serdeInfo_ == null
        ? com.google.cloud.bigquery.storage.v1alpha.SerDeInfo.getDefaultInstance()
        : serdeInfo_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Serializer and deserializer information.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1alpha.SerDeInfo serde_info = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1alpha.SerDeInfoOrBuilder getSerdeInfoOrBuilder() {
    return serdeInfo_ == null
        ? com.google.cloud.bigquery.storage.v1alpha.SerDeInfo.getDefaultInstance()
        : serdeInfo_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(locationUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, locationUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(inputFormat_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, inputFormat_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(outputFormat_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, outputFormat_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getSerdeInfo());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(locationUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, locationUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(inputFormat_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, inputFormat_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(outputFormat_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, outputFormat_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getSerdeInfo());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.bigquery.storage.v1alpha.StorageDescriptor)) {
      return super.equals(obj);
    }
    com.google.cloud.bigquery.storage.v1alpha.StorageDescriptor other =
        (com.google.cloud.bigquery.storage.v1alpha.StorageDescriptor) obj;

    if (!getLocationUri().equals(other.getLocationUri())) return false;
    if (!getInputFormat().equals(other.getInputFormat())) return false;
    if (!getOutputFormat().equals(other.getOutputFormat())) return false;
    if (hasSerdeInfo() != other.hasSerdeInfo()) return false;
    if (hasSerdeInfo()) {
      if (!getSerdeInfo().equals(other.getSerdeInfo())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + LOCATION_URI_FIELD_NUMBER;
    hash = (53 * hash) + getLocationUri().hashCode();
    hash = (37 * hash) + INPUT_FORMAT_FIELD_NUMBER;
    hash = (53 * hash) + getInputFormat().hashCode();
    hash = (37 * hash) + OUTPUT_FORMAT_FIELD_NUMBER;
    hash = (53 * hash) + getOutputFormat().hashCode();
    if (hasSerdeInfo()) {
      hash = (37 * hash) + SERDE_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getSerdeInfo().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.bigquery.storage.v1alpha.StorageDescriptor parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.storage.v1alpha.StorageDescriptor parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1alpha.StorageDescriptor parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.storage.v1alpha.StorageDescriptor parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1alpha.StorageDescriptor parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.storage.v1alpha.StorageDescriptor parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1alpha.StorageDescriptor parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.storage.v1alpha.StorageDescriptor parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1alpha.StorageDescriptor parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.storage.v1alpha.StorageDescriptor parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1alpha.StorageDescriptor parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.storage.v1alpha.StorageDescriptor parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.bigquery.storage.v1alpha.StorageDescriptor prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Contains information about the physical storage of the data in the metastore
   * partition.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.storage.v1alpha.StorageDescriptor}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.storage.v1alpha.StorageDescriptor)
      com.google.cloud.bigquery.storage.v1alpha.StorageDescriptorOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.storage.v1alpha.MetastorePartitionProto
          .internal_static_google_cloud_bigquery_storage_v1alpha_StorageDescriptor_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.storage.v1alpha.MetastorePartitionProto
          .internal_static_google_cloud_bigquery_storage_v1alpha_StorageDescriptor_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.storage.v1alpha.StorageDescriptor.class,
              com.google.cloud.bigquery.storage.v1alpha.StorageDescriptor.Builder.class);
    }

    // Construct using com.google.cloud.bigquery.storage.v1alpha.StorageDescriptor.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getSerdeInfoFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      locationUri_ = "";
      inputFormat_ = "";
      outputFormat_ = "";
      serdeInfo_ = null;
      if (serdeInfoBuilder_ != null) {
        serdeInfoBuilder_.dispose();
        serdeInfoBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.bigquery.storage.v1alpha.MetastorePartitionProto
          .internal_static_google_cloud_bigquery_storage_v1alpha_StorageDescriptor_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1alpha.StorageDescriptor getDefaultInstanceForType() {
      return com.google.cloud.bigquery.storage.v1alpha.StorageDescriptor.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1alpha.StorageDescriptor build() {
      com.google.cloud.bigquery.storage.v1alpha.StorageDescriptor result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1alpha.StorageDescriptor buildPartial() {
      com.google.cloud.bigquery.storage.v1alpha.StorageDescriptor result =
          new com.google.cloud.bigquery.storage.v1alpha.StorageDescriptor(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.bigquery.storage.v1alpha.StorageDescriptor result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.locationUri_ = locationUri_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.inputFormat_ = inputFormat_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.outputFormat_ = outputFormat_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.serdeInfo_ = serdeInfoBuilder_ == null ? serdeInfo_ : serdeInfoBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.bigquery.storage.v1alpha.StorageDescriptor) {
        return mergeFrom((com.google.cloud.bigquery.storage.v1alpha.StorageDescriptor) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.bigquery.storage.v1alpha.StorageDescriptor other) {
      if (other == com.google.cloud.bigquery.storage.v1alpha.StorageDescriptor.getDefaultInstance())
        return this;
      if (!other.getLocationUri().isEmpty()) {
        locationUri_ = other.locationUri_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getInputFormat().isEmpty()) {
        inputFormat_ = other.inputFormat_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getOutputFormat().isEmpty()) {
        outputFormat_ = other.outputFormat_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasSerdeInfo()) {
        mergeSerdeInfo(other.getSerdeInfo());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                locationUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                inputFormat_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                outputFormat_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getSerdeInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object locationUri_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The physical location of the metastore partition
     * (e.g. `gs://spark-dataproc-data/pangea-data/case_sensitive/` or
     * `gs://spark-dataproc-data/pangea-data/&#42;`).
     * </pre>
     *
     * <code>string location_uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The locationUri.
     */
    public java.lang.String getLocationUri() {
      java.lang.Object ref = locationUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        locationUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The physical location of the metastore partition
     * (e.g. `gs://spark-dataproc-data/pangea-data/case_sensitive/` or
     * `gs://spark-dataproc-data/pangea-data/&#42;`).
     * </pre>
     *
     * <code>string location_uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for locationUri.
     */
    public com.google.protobuf.ByteString getLocationUriBytes() {
      java.lang.Object ref = locationUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        locationUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The physical location of the metastore partition
     * (e.g. `gs://spark-dataproc-data/pangea-data/case_sensitive/` or
     * `gs://spark-dataproc-data/pangea-data/&#42;`).
     * </pre>
     *
     * <code>string location_uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The locationUri to set.
     * @return This builder for chaining.
     */
    public Builder setLocationUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      locationUri_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The physical location of the metastore partition
     * (e.g. `gs://spark-dataproc-data/pangea-data/case_sensitive/` or
     * `gs://spark-dataproc-data/pangea-data/&#42;`).
     * </pre>
     *
     * <code>string location_uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLocationUri() {
      locationUri_ = getDefaultInstance().getLocationUri();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The physical location of the metastore partition
     * (e.g. `gs://spark-dataproc-data/pangea-data/case_sensitive/` or
     * `gs://spark-dataproc-data/pangea-data/&#42;`).
     * </pre>
     *
     * <code>string location_uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for locationUri to set.
     * @return This builder for chaining.
     */
    public Builder setLocationUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      locationUri_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object inputFormat_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Specifies the fully qualified class name of the InputFormat
     * (e.g. "org.apache.hadoop.hive.ql.io.orc.OrcInputFormat").
     * The maximum length is 128 characters.
     * </pre>
     *
     * <code>string input_format = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The inputFormat.
     */
    public java.lang.String getInputFormat() {
      java.lang.Object ref = inputFormat_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        inputFormat_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies the fully qualified class name of the InputFormat
     * (e.g. "org.apache.hadoop.hive.ql.io.orc.OrcInputFormat").
     * The maximum length is 128 characters.
     * </pre>
     *
     * <code>string input_format = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for inputFormat.
     */
    public com.google.protobuf.ByteString getInputFormatBytes() {
      java.lang.Object ref = inputFormat_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        inputFormat_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies the fully qualified class name of the InputFormat
     * (e.g. "org.apache.hadoop.hive.ql.io.orc.OrcInputFormat").
     * The maximum length is 128 characters.
     * </pre>
     *
     * <code>string input_format = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The inputFormat to set.
     * @return This builder for chaining.
     */
    public Builder setInputFormat(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      inputFormat_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies the fully qualified class name of the InputFormat
     * (e.g. "org.apache.hadoop.hive.ql.io.orc.OrcInputFormat").
     * The maximum length is 128 characters.
     * </pre>
     *
     * <code>string input_format = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInputFormat() {
      inputFormat_ = getDefaultInstance().getInputFormat();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies the fully qualified class name of the InputFormat
     * (e.g. "org.apache.hadoop.hive.ql.io.orc.OrcInputFormat").
     * The maximum length is 128 characters.
     * </pre>
     *
     * <code>string input_format = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for inputFormat to set.
     * @return This builder for chaining.
     */
    public Builder setInputFormatBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      inputFormat_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object outputFormat_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Specifies the fully qualified class name of the OutputFormat
     * (e.g. "org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat").
     * The maximum length is 128 characters.
     * </pre>
     *
     * <code>string output_format = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The outputFormat.
     */
    public java.lang.String getOutputFormat() {
      java.lang.Object ref = outputFormat_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        outputFormat_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies the fully qualified class name of the OutputFormat
     * (e.g. "org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat").
     * The maximum length is 128 characters.
     * </pre>
     *
     * <code>string output_format = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for outputFormat.
     */
    public com.google.protobuf.ByteString getOutputFormatBytes() {
      java.lang.Object ref = outputFormat_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        outputFormat_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies the fully qualified class name of the OutputFormat
     * (e.g. "org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat").
     * The maximum length is 128 characters.
     * </pre>
     *
     * <code>string output_format = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The outputFormat to set.
     * @return This builder for chaining.
     */
    public Builder setOutputFormat(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      outputFormat_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies the fully qualified class name of the OutputFormat
     * (e.g. "org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat").
     * The maximum length is 128 characters.
     * </pre>
     *
     * <code>string output_format = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOutputFormat() {
      outputFormat_ = getDefaultInstance().getOutputFormat();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies the fully qualified class name of the OutputFormat
     * (e.g. "org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat").
     * The maximum length is 128 characters.
     * </pre>
     *
     * <code>string output_format = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for outputFormat to set.
     * @return This builder for chaining.
     */
    public Builder setOutputFormatBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      outputFormat_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.cloud.bigquery.storage.v1alpha.SerDeInfo serdeInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1alpha.SerDeInfo,
            com.google.cloud.bigquery.storage.v1alpha.SerDeInfo.Builder,
            com.google.cloud.bigquery.storage.v1alpha.SerDeInfoOrBuilder>
        serdeInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Serializer and deserializer information.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1alpha.SerDeInfo serde_info = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the serdeInfo field is set.
     */
    public boolean hasSerdeInfo() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Serializer and deserializer information.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1alpha.SerDeInfo serde_info = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The serdeInfo.
     */
    public com.google.cloud.bigquery.storage.v1alpha.SerDeInfo getSerdeInfo() {
      if (serdeInfoBuilder_ == null) {
        return serdeInfo_ == null
            ? com.google.cloud.bigquery.storage.v1alpha.SerDeInfo.getDefaultInstance()
            : serdeInfo_;
      } else {
        return serdeInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Serializer and deserializer information.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1alpha.SerDeInfo serde_info = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSerdeInfo(com.google.cloud.bigquery.storage.v1alpha.SerDeInfo value) {
      if (serdeInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        serdeInfo_ = value;
      } else {
        serdeInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Serializer and deserializer information.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1alpha.SerDeInfo serde_info = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSerdeInfo(
        com.google.cloud.bigquery.storage.v1alpha.SerDeInfo.Builder builderForValue) {
      if (serdeInfoBuilder_ == null) {
        serdeInfo_ = builderForValue.build();
      } else {
        serdeInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Serializer and deserializer information.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1alpha.SerDeInfo serde_info = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeSerdeInfo(com.google.cloud.bigquery.storage.v1alpha.SerDeInfo value) {
      if (serdeInfoBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && serdeInfo_ != null
            && serdeInfo_
                != com.google.cloud.bigquery.storage.v1alpha.SerDeInfo.getDefaultInstance()) {
          getSerdeInfoBuilder().mergeFrom(value);
        } else {
          serdeInfo_ = value;
        }
      } else {
        serdeInfoBuilder_.mergeFrom(value);
      }
      if (serdeInfo_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Serializer and deserializer information.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1alpha.SerDeInfo serde_info = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearSerdeInfo() {
      bitField0_ = (bitField0_ & ~0x00000008);
      serdeInfo_ = null;
      if (serdeInfoBuilder_ != null) {
        serdeInfoBuilder_.dispose();
        serdeInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Serializer and deserializer information.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1alpha.SerDeInfo serde_info = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.bigquery.storage.v1alpha.SerDeInfo.Builder getSerdeInfoBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getSerdeInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Serializer and deserializer information.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1alpha.SerDeInfo serde_info = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.bigquery.storage.v1alpha.SerDeInfoOrBuilder getSerdeInfoOrBuilder() {
      if (serdeInfoBuilder_ != null) {
        return serdeInfoBuilder_.getMessageOrBuilder();
      } else {
        return serdeInfo_ == null
            ? com.google.cloud.bigquery.storage.v1alpha.SerDeInfo.getDefaultInstance()
            : serdeInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Serializer and deserializer information.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1alpha.SerDeInfo serde_info = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1alpha.SerDeInfo,
            com.google.cloud.bigquery.storage.v1alpha.SerDeInfo.Builder,
            com.google.cloud.bigquery.storage.v1alpha.SerDeInfoOrBuilder>
        getSerdeInfoFieldBuilder() {
      if (serdeInfoBuilder_ == null) {
        serdeInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.storage.v1alpha.SerDeInfo,
                com.google.cloud.bigquery.storage.v1alpha.SerDeInfo.Builder,
                com.google.cloud.bigquery.storage.v1alpha.SerDeInfoOrBuilder>(
                getSerdeInfo(), getParentForChildren(), isClean());
        serdeInfo_ = null;
      }
      return serdeInfoBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.storage.v1alpha.StorageDescriptor)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.bigquery.storage.v1alpha.StorageDescriptor)
  private static final com.google.cloud.bigquery.storage.v1alpha.StorageDescriptor DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.bigquery.storage.v1alpha.StorageDescriptor();
  }

  public static com.google.cloud.bigquery.storage.v1alpha.StorageDescriptor getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<StorageDescriptor> PARSER =
      new com.google.protobuf.AbstractParser<StorageDescriptor>() {
        @java.lang.Override
        public StorageDescriptor parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<StorageDescriptor> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<StorageDescriptor> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1alpha.StorageDescriptor getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
