/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/storage/v1alpha2/stream.proto

package com.google.cloud.bigquery.storage.v1alpha2;

public final class Stream {
  private Stream() {}

  public static void registerAllExtensions(com.google.protobuf.ExtensionRegistryLite registry) {}

  public static void registerAllExtensions(com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions((com.google.protobuf.ExtensionRegistryLite) registry);
  }

  public interface WriteStreamOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.storage.v1alpha2.WriteStream)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. Name of the stream, in the form
     * `projects/{project}/datasets/{dataset}/tables/{table}/streams/{stream}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    java.lang.String getName();
    /**
     *
     *
     * <pre>
     * Output only. Name of the stream, in the form
     * `projects/{project}/datasets/{dataset}/tables/{table}/streams/{stream}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();

    /**
     * <code>
     * .google.cloud.bigquery.storage.v1alpha2.WriteStream.Type type = 2 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The enum numeric value on the wire for type.
     */
    int getTypeValue();
    /**
     * <code>
     * .google.cloud.bigquery.storage.v1alpha2.WriteStream.Type type = 2 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The type.
     */
    com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream.Type getType();

    /**
     *
     *
     * <pre>
     * Output only. Create time of the stream.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    boolean hasCreateTime();
    /**
     *
     *
     * <pre>
     * Output only. Create time of the stream.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    com.google.protobuf.Timestamp getCreateTime();
    /**
     *
     *
     * <pre>
     * Output only. Create time of the stream.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * Output only. Commit time of the stream.
     * If a stream is of `COMMITTED` type, then it will have a commit_time same as
     * `create_time`. If the stream is of `PENDING` type, commit_time being empty
     * means it is not committed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp commit_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the commitTime field is set.
     */
    boolean hasCommitTime();
    /**
     *
     *
     * <pre>
     * Output only. Commit time of the stream.
     * If a stream is of `COMMITTED` type, then it will have a commit_time same as
     * `create_time`. If the stream is of `PENDING` type, commit_time being empty
     * means it is not committed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp commit_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The commitTime.
     */
    com.google.protobuf.Timestamp getCommitTime();
    /**
     *
     *
     * <pre>
     * Output only. Commit time of the stream.
     * If a stream is of `COMMITTED` type, then it will have a commit_time same as
     * `create_time`. If the stream is of `PENDING` type, commit_time being empty
     * means it is not committed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp commit_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.protobuf.TimestampOrBuilder getCommitTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * Output only. The schema of the destination table. It is only returned in
     * `CreateWriteStream` response. Caller should generate data that's
     * compatible with this schema to send in initial `AppendRowsRequest`.
     * The table schema could go out of date during the life time of the stream.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1alpha2.TableSchema table_schema = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the tableSchema field is set.
     */
    boolean hasTableSchema();
    /**
     *
     *
     * <pre>
     * Output only. The schema of the destination table. It is only returned in
     * `CreateWriteStream` response. Caller should generate data that's
     * compatible with this schema to send in initial `AppendRowsRequest`.
     * The table schema could go out of date during the life time of the stream.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1alpha2.TableSchema table_schema = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The tableSchema.
     */
    com.google.cloud.bigquery.storage.v1alpha2.Table.TableSchema getTableSchema();
    /**
     *
     *
     * <pre>
     * Output only. The schema of the destination table. It is only returned in
     * `CreateWriteStream` response. Caller should generate data that's
     * compatible with this schema to send in initial `AppendRowsRequest`.
     * The table schema could go out of date during the life time of the stream.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1alpha2.TableSchema table_schema = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.cloud.bigquery.storage.v1alpha2.Table.TableSchemaOrBuilder getTableSchemaOrBuilder();

    /**
     *
     *
     * <pre>
     * Id set by client to annotate its identity.
     * </pre>
     *
     * <code>string external_id = 6;</code>
     *
     * @return The externalId.
     */
    java.lang.String getExternalId();
    /**
     *
     *
     * <pre>
     * Id set by client to annotate its identity.
     * </pre>
     *
     * <code>string external_id = 6;</code>
     *
     * @return The bytes for externalId.
     */
    com.google.protobuf.ByteString getExternalIdBytes();
  }
  /**
   *
   *
   * <pre>
   * Information about a single stream that gets data inside the storage system.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.storage.v1alpha2.WriteStream}
   */
  public static final class WriteStream extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.bigquery.storage.v1alpha2.WriteStream)
      WriteStreamOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use WriteStream.newBuilder() to construct.
    private WriteStream(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private WriteStream() {
      name_ = "";
      type_ = 0;
      externalId_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new WriteStream();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private WriteStream(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                name_ = s;
                break;
              }
            case 16:
              {
                int rawValue = input.readEnum();

                type_ = rawValue;
                break;
              }
            case 26:
              {
                com.google.protobuf.Timestamp.Builder subBuilder = null;
                if (createTime_ != null) {
                  subBuilder = createTime_.toBuilder();
                }
                createTime_ =
                    input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(createTime_);
                  createTime_ = subBuilder.buildPartial();
                }

                break;
              }
            case 34:
              {
                com.google.protobuf.Timestamp.Builder subBuilder = null;
                if (commitTime_ != null) {
                  subBuilder = commitTime_.toBuilder();
                }
                commitTime_ =
                    input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(commitTime_);
                  commitTime_ = subBuilder.buildPartial();
                }

                break;
              }
            case 42:
              {
                com.google.cloud.bigquery.storage.v1alpha2.Table.TableSchema.Builder subBuilder =
                    null;
                if (tableSchema_ != null) {
                  subBuilder = tableSchema_.toBuilder();
                }
                tableSchema_ =
                    input.readMessage(
                        com.google.cloud.bigquery.storage.v1alpha2.Table.TableSchema.parser(),
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(tableSchema_);
                  tableSchema_ = subBuilder.buildPartial();
                }

                break;
              }
            case 50:
              {
                java.lang.String s = input.readStringRequireUtf8();

                externalId_ = s;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.storage.v1alpha2.Stream
          .internal_static_google_cloud_bigquery_storage_v1alpha2_WriteStream_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.storage.v1alpha2.Stream
          .internal_static_google_cloud_bigquery_storage_v1alpha2_WriteStream_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream.class,
              com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream.Builder.class);
    }

    /** Protobuf enum {@code google.cloud.bigquery.storage.v1alpha2.WriteStream.Type} */
    public enum Type implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Unknown type.
       * </pre>
       *
       * <code>TYPE_UNSPECIFIED = 0;</code>
       */
      TYPE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Data will commit automatically and appear as soon as the write is
       * acknowledged.
       * </pre>
       *
       * <code>COMMITTED = 1;</code>
       */
      COMMITTED(1),
      /**
       *
       *
       * <pre>
       * Data is invisible until the stream is committed.
       * </pre>
       *
       * <code>PENDING = 2;</code>
       */
      PENDING(2),
      /**
       *
       *
       * <pre>
       * Data is only visible up to the offset to which it was flushed.
       * </pre>
       *
       * <code>BUFFERED = 3;</code>
       */
      BUFFERED(3),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Unknown type.
       * </pre>
       *
       * <code>TYPE_UNSPECIFIED = 0;</code>
       */
      public static final int TYPE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Data will commit automatically and appear as soon as the write is
       * acknowledged.
       * </pre>
       *
       * <code>COMMITTED = 1;</code>
       */
      public static final int COMMITTED_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Data is invisible until the stream is committed.
       * </pre>
       *
       * <code>PENDING = 2;</code>
       */
      public static final int PENDING_VALUE = 2;
      /**
       *
       *
       * <pre>
       * Data is only visible up to the offset to which it was flushed.
       * </pre>
       *
       * <code>BUFFERED = 3;</code>
       */
      public static final int BUFFERED_VALUE = 3;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Type valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Type forNumber(int value) {
        switch (value) {
          case 0:
            return TYPE_UNSPECIFIED;
          case 1:
            return COMMITTED;
          case 2:
            return PENDING;
          case 3:
            return BUFFERED;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Type> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<Type> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Type>() {
            public Type findValueByNumber(int number) {
              return Type.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final Type[] VALUES = values();

      public static Type valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Type(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.bigquery.storage.v1alpha2.WriteStream.Type)
    }

    public static final int NAME_FIELD_NUMBER = 1;
    private volatile java.lang.Object name_;
    /**
     *
     *
     * <pre>
     * Output only. Name of the stream, in the form
     * `projects/{project}/datasets/{dataset}/tables/{table}/streams/{stream}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the stream, in the form
     * `projects/{project}/datasets/{dataset}/tables/{table}/streams/{stream}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TYPE_FIELD_NUMBER = 2;
    private int type_;
    /**
     * <code>
     * .google.cloud.bigquery.storage.v1alpha2.WriteStream.Type type = 2 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }
    /**
     * <code>
     * .google.cloud.bigquery.storage.v1alpha2.WriteStream.Type type = 2 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream.Type getType() {
      @SuppressWarnings("deprecation")
      com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream.Type result =
          com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream.Type.valueOf(type_);
      return result == null
          ? com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream.Type.UNRECOGNIZED
          : result;
    }

    public static final int CREATE_TIME_FIELD_NUMBER = 3;
    private com.google.protobuf.Timestamp createTime_;
    /**
     *
     *
     * <pre>
     * Output only. Create time of the stream.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    @java.lang.Override
    public boolean hasCreateTime() {
      return createTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Create time of the stream.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getCreateTime() {
      return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Create time of the stream.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      return getCreateTime();
    }

    public static final int COMMIT_TIME_FIELD_NUMBER = 4;
    private com.google.protobuf.Timestamp commitTime_;
    /**
     *
     *
     * <pre>
     * Output only. Commit time of the stream.
     * If a stream is of `COMMITTED` type, then it will have a commit_time same as
     * `create_time`. If the stream is of `PENDING` type, commit_time being empty
     * means it is not committed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp commit_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the commitTime field is set.
     */
    @java.lang.Override
    public boolean hasCommitTime() {
      return commitTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Commit time of the stream.
     * If a stream is of `COMMITTED` type, then it will have a commit_time same as
     * `create_time`. If the stream is of `PENDING` type, commit_time being empty
     * means it is not committed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp commit_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The commitTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getCommitTime() {
      return commitTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : commitTime_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Commit time of the stream.
     * If a stream is of `COMMITTED` type, then it will have a commit_time same as
     * `create_time`. If the stream is of `PENDING` type, commit_time being empty
     * means it is not committed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp commit_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getCommitTimeOrBuilder() {
      return getCommitTime();
    }

    public static final int TABLE_SCHEMA_FIELD_NUMBER = 5;
    private com.google.cloud.bigquery.storage.v1alpha2.Table.TableSchema tableSchema_;
    /**
     *
     *
     * <pre>
     * Output only. The schema of the destination table. It is only returned in
     * `CreateWriteStream` response. Caller should generate data that's
     * compatible with this schema to send in initial `AppendRowsRequest`.
     * The table schema could go out of date during the life time of the stream.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1alpha2.TableSchema table_schema = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the tableSchema field is set.
     */
    @java.lang.Override
    public boolean hasTableSchema() {
      return tableSchema_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The schema of the destination table. It is only returned in
     * `CreateWriteStream` response. Caller should generate data that's
     * compatible with this schema to send in initial `AppendRowsRequest`.
     * The table schema could go out of date during the life time of the stream.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1alpha2.TableSchema table_schema = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The tableSchema.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1alpha2.Table.TableSchema getTableSchema() {
      return tableSchema_ == null
          ? com.google.cloud.bigquery.storage.v1alpha2.Table.TableSchema.getDefaultInstance()
          : tableSchema_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The schema of the destination table. It is only returned in
     * `CreateWriteStream` response. Caller should generate data that's
     * compatible with this schema to send in initial `AppendRowsRequest`.
     * The table schema could go out of date during the life time of the stream.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1alpha2.TableSchema table_schema = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1alpha2.Table.TableSchemaOrBuilder
        getTableSchemaOrBuilder() {
      return getTableSchema();
    }

    public static final int EXTERNAL_ID_FIELD_NUMBER = 6;
    private volatile java.lang.Object externalId_;
    /**
     *
     *
     * <pre>
     * Id set by client to annotate its identity.
     * </pre>
     *
     * <code>string external_id = 6;</code>
     *
     * @return The externalId.
     */
    @java.lang.Override
    public java.lang.String getExternalId() {
      java.lang.Object ref = externalId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        externalId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Id set by client to annotate its identity.
     * </pre>
     *
     * <code>string external_id = 6;</code>
     *
     * @return The bytes for externalId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getExternalIdBytes() {
      java.lang.Object ref = externalId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        externalId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!getNameBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
      }
      if (type_
          != com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream.Type.TYPE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(2, type_);
      }
      if (createTime_ != null) {
        output.writeMessage(3, getCreateTime());
      }
      if (commitTime_ != null) {
        output.writeMessage(4, getCommitTime());
      }
      if (tableSchema_ != null) {
        output.writeMessage(5, getTableSchema());
      }
      if (!getExternalIdBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 6, externalId_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getNameBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
      }
      if (type_
          != com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream.Type.TYPE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, type_);
      }
      if (createTime_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCreateTime());
      }
      if (commitTime_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getCommitTime());
      }
      if (tableSchema_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getTableSchema());
      }
      if (!getExternalIdBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, externalId_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream)) {
        return super.equals(obj);
      }
      com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream other =
          (com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream) obj;

      if (!getName().equals(other.getName())) return false;
      if (type_ != other.type_) return false;
      if (hasCreateTime() != other.hasCreateTime()) return false;
      if (hasCreateTime()) {
        if (!getCreateTime().equals(other.getCreateTime())) return false;
      }
      if (hasCommitTime() != other.hasCommitTime()) return false;
      if (hasCommitTime()) {
        if (!getCommitTime().equals(other.getCommitTime())) return false;
      }
      if (hasTableSchema() != other.hasTableSchema()) return false;
      if (hasTableSchema()) {
        if (!getTableSchema().equals(other.getTableSchema())) return false;
      }
      if (!getExternalId().equals(other.getExternalId())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      hash = (37 * hash) + TYPE_FIELD_NUMBER;
      hash = (53 * hash) + type_;
      if (hasCreateTime()) {
        hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getCreateTime().hashCode();
      }
      if (hasCommitTime()) {
        hash = (37 * hash) + COMMIT_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getCommitTime().hashCode();
      }
      if (hasTableSchema()) {
        hash = (37 * hash) + TABLE_SCHEMA_FIELD_NUMBER;
        hash = (53 * hash) + getTableSchema().hashCode();
      }
      hash = (37 * hash) + EXTERNAL_ID_FIELD_NUMBER;
      hash = (53 * hash) + getExternalId().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Information about a single stream that gets data inside the storage system.
     * </pre>
     *
     * Protobuf type {@code google.cloud.bigquery.storage.v1alpha2.WriteStream}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.storage.v1alpha2.WriteStream)
        com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStreamOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.bigquery.storage.v1alpha2.Stream
            .internal_static_google_cloud_bigquery_storage_v1alpha2_WriteStream_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.bigquery.storage.v1alpha2.Stream
            .internal_static_google_cloud_bigquery_storage_v1alpha2_WriteStream_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream.class,
                com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream.Builder.class);
      }

      // Construct using com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        name_ = "";

        type_ = 0;

        if (createTimeBuilder_ == null) {
          createTime_ = null;
        } else {
          createTime_ = null;
          createTimeBuilder_ = null;
        }
        if (commitTimeBuilder_ == null) {
          commitTime_ = null;
        } else {
          commitTime_ = null;
          commitTimeBuilder_ = null;
        }
        if (tableSchemaBuilder_ == null) {
          tableSchema_ = null;
        } else {
          tableSchema_ = null;
          tableSchemaBuilder_ = null;
        }
        externalId_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.bigquery.storage.v1alpha2.Stream
            .internal_static_google_cloud_bigquery_storage_v1alpha2_WriteStream_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream
          getDefaultInstanceForType() {
        return com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream build() {
        com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream buildPartial() {
        com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream result =
            new com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream(this);
        result.name_ = name_;
        result.type_ = type_;
        if (createTimeBuilder_ == null) {
          result.createTime_ = createTime_;
        } else {
          result.createTime_ = createTimeBuilder_.build();
        }
        if (commitTimeBuilder_ == null) {
          result.commitTime_ = commitTime_;
        } else {
          result.commitTime_ = commitTimeBuilder_.build();
        }
        if (tableSchemaBuilder_ == null) {
          result.tableSchema_ = tableSchema_;
        } else {
          result.tableSchema_ = tableSchemaBuilder_.build();
        }
        result.externalId_ = externalId_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream) {
          return mergeFrom((com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream other) {
        if (other
            == com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream.getDefaultInstance())
          return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          onChanged();
        }
        if (other.type_ != 0) {
          setTypeValue(other.getTypeValue());
        }
        if (other.hasCreateTime()) {
          mergeCreateTime(other.getCreateTime());
        }
        if (other.hasCommitTime()) {
          mergeCommitTime(other.getCommitTime());
        }
        if (other.hasTableSchema()) {
          mergeTableSchema(other.getTableSchema());
        }
        if (!other.getExternalId().isEmpty()) {
          externalId_ = other.externalId_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * Output only. Name of the stream, in the form
       * `projects/{project}/datasets/{dataset}/tables/{table}/streams/{stream}`.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Name of the stream, in the form
       * `projects/{project}/datasets/{dataset}/tables/{table}/streams/{stream}`.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Name of the stream, in the form
       * `projects/{project}/datasets/{dataset}/tables/{table}/streams/{stream}`.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        name_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Name of the stream, in the form
       * `projects/{project}/datasets/{dataset}/tables/{table}/streams/{stream}`.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {

        name_ = getDefaultInstance().getName();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Name of the stream, in the form
       * `projects/{project}/datasets/{dataset}/tables/{table}/streams/{stream}`.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        name_ = value;
        onChanged();
        return this;
      }

      private int type_ = 0;
      /**
       * <code>
       * .google.cloud.bigquery.storage.v1alpha2.WriteStream.Type type = 2 [(.google.api.field_behavior) = IMMUTABLE];
       * </code>
       *
       * @return The enum numeric value on the wire for type.
       */
      @java.lang.Override
      public int getTypeValue() {
        return type_;
      }
      /**
       * <code>
       * .google.cloud.bigquery.storage.v1alpha2.WriteStream.Type type = 2 [(.google.api.field_behavior) = IMMUTABLE];
       * </code>
       *
       * @param value The enum numeric value on the wire for type to set.
       * @return This builder for chaining.
       */
      public Builder setTypeValue(int value) {

        type_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>
       * .google.cloud.bigquery.storage.v1alpha2.WriteStream.Type type = 2 [(.google.api.field_behavior) = IMMUTABLE];
       * </code>
       *
       * @return The type.
       */
      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream.Type getType() {
        @SuppressWarnings("deprecation")
        com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream.Type result =
            com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream.Type.valueOf(type_);
        return result == null
            ? com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream.Type.UNRECOGNIZED
            : result;
      }
      /**
       * <code>
       * .google.cloud.bigquery.storage.v1alpha2.WriteStream.Type type = 2 [(.google.api.field_behavior) = IMMUTABLE];
       * </code>
       *
       * @param value The type to set.
       * @return This builder for chaining.
       */
      public Builder setType(
          com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream.Type value) {
        if (value == null) {
          throw new NullPointerException();
        }

        type_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <code>
       * .google.cloud.bigquery.storage.v1alpha2.WriteStream.Type type = 2 [(.google.api.field_behavior) = IMMUTABLE];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearType() {

        type_ = 0;
        onChanged();
        return this;
      }

      private com.google.protobuf.Timestamp createTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          createTimeBuilder_;
      /**
       *
       *
       * <pre>
       * Output only. Create time of the stream.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return Whether the createTime field is set.
       */
      public boolean hasCreateTime() {
        return createTimeBuilder_ != null || createTime_ != null;
      }
      /**
       *
       *
       * <pre>
       * Output only. Create time of the stream.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The createTime.
       */
      public com.google.protobuf.Timestamp getCreateTime() {
        if (createTimeBuilder_ == null) {
          return createTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : createTime_;
        } else {
          return createTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Create time of the stream.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setCreateTime(com.google.protobuf.Timestamp value) {
        if (createTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          createTime_ = value;
          onChanged();
        } else {
          createTimeBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Create time of the stream.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (createTimeBuilder_ == null) {
          createTime_ = builderForValue.build();
          onChanged();
        } else {
          createTimeBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Create time of the stream.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
        if (createTimeBuilder_ == null) {
          if (createTime_ != null) {
            createTime_ =
                com.google.protobuf.Timestamp.newBuilder(createTime_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            createTime_ = value;
          }
          onChanged();
        } else {
          createTimeBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Create time of the stream.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder clearCreateTime() {
        if (createTimeBuilder_ == null) {
          createTime_ = null;
          onChanged();
        } else {
          createTime_ = null;
          createTimeBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Create time of the stream.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {

        onChanged();
        return getCreateTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Output only. Create time of the stream.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
        if (createTimeBuilder_ != null) {
          return createTimeBuilder_.getMessageOrBuilder();
        } else {
          return createTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : createTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Create time of the stream.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getCreateTimeFieldBuilder() {
        if (createTimeBuilder_ == null) {
          createTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getCreateTime(), getParentForChildren(), isClean());
          createTime_ = null;
        }
        return createTimeBuilder_;
      }

      private com.google.protobuf.Timestamp commitTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          commitTimeBuilder_;
      /**
       *
       *
       * <pre>
       * Output only. Commit time of the stream.
       * If a stream is of `COMMITTED` type, then it will have a commit_time same as
       * `create_time`. If the stream is of `PENDING` type, commit_time being empty
       * means it is not committed.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp commit_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return Whether the commitTime field is set.
       */
      public boolean hasCommitTime() {
        return commitTimeBuilder_ != null || commitTime_ != null;
      }
      /**
       *
       *
       * <pre>
       * Output only. Commit time of the stream.
       * If a stream is of `COMMITTED` type, then it will have a commit_time same as
       * `create_time`. If the stream is of `PENDING` type, commit_time being empty
       * means it is not committed.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp commit_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The commitTime.
       */
      public com.google.protobuf.Timestamp getCommitTime() {
        if (commitTimeBuilder_ == null) {
          return commitTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : commitTime_;
        } else {
          return commitTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Commit time of the stream.
       * If a stream is of `COMMITTED` type, then it will have a commit_time same as
       * `create_time`. If the stream is of `PENDING` type, commit_time being empty
       * means it is not committed.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp commit_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setCommitTime(com.google.protobuf.Timestamp value) {
        if (commitTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          commitTime_ = value;
          onChanged();
        } else {
          commitTimeBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Commit time of the stream.
       * If a stream is of `COMMITTED` type, then it will have a commit_time same as
       * `create_time`. If the stream is of `PENDING` type, commit_time being empty
       * means it is not committed.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp commit_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setCommitTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (commitTimeBuilder_ == null) {
          commitTime_ = builderForValue.build();
          onChanged();
        } else {
          commitTimeBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Commit time of the stream.
       * If a stream is of `COMMITTED` type, then it will have a commit_time same as
       * `create_time`. If the stream is of `PENDING` type, commit_time being empty
       * means it is not committed.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp commit_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder mergeCommitTime(com.google.protobuf.Timestamp value) {
        if (commitTimeBuilder_ == null) {
          if (commitTime_ != null) {
            commitTime_ =
                com.google.protobuf.Timestamp.newBuilder(commitTime_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            commitTime_ = value;
          }
          onChanged();
        } else {
          commitTimeBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Commit time of the stream.
       * If a stream is of `COMMITTED` type, then it will have a commit_time same as
       * `create_time`. If the stream is of `PENDING` type, commit_time being empty
       * means it is not committed.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp commit_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder clearCommitTime() {
        if (commitTimeBuilder_ == null) {
          commitTime_ = null;
          onChanged();
        } else {
          commitTime_ = null;
          commitTimeBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Commit time of the stream.
       * If a stream is of `COMMITTED` type, then it will have a commit_time same as
       * `create_time`. If the stream is of `PENDING` type, commit_time being empty
       * means it is not committed.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp commit_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.protobuf.Timestamp.Builder getCommitTimeBuilder() {

        onChanged();
        return getCommitTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Output only. Commit time of the stream.
       * If a stream is of `COMMITTED` type, then it will have a commit_time same as
       * `create_time`. If the stream is of `PENDING` type, commit_time being empty
       * means it is not committed.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp commit_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.protobuf.TimestampOrBuilder getCommitTimeOrBuilder() {
        if (commitTimeBuilder_ != null) {
          return commitTimeBuilder_.getMessageOrBuilder();
        } else {
          return commitTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : commitTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Commit time of the stream.
       * If a stream is of `COMMITTED` type, then it will have a commit_time same as
       * `create_time`. If the stream is of `PENDING` type, commit_time being empty
       * means it is not committed.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp commit_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getCommitTimeFieldBuilder() {
        if (commitTimeBuilder_ == null) {
          commitTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getCommitTime(), getParentForChildren(), isClean());
          commitTime_ = null;
        }
        return commitTimeBuilder_;
      }

      private com.google.cloud.bigquery.storage.v1alpha2.Table.TableSchema tableSchema_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1alpha2.Table.TableSchema,
              com.google.cloud.bigquery.storage.v1alpha2.Table.TableSchema.Builder,
              com.google.cloud.bigquery.storage.v1alpha2.Table.TableSchemaOrBuilder>
          tableSchemaBuilder_;
      /**
       *
       *
       * <pre>
       * Output only. The schema of the destination table. It is only returned in
       * `CreateWriteStream` response. Caller should generate data that's
       * compatible with this schema to send in initial `AppendRowsRequest`.
       * The table schema could go out of date during the life time of the stream.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1alpha2.TableSchema table_schema = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return Whether the tableSchema field is set.
       */
      public boolean hasTableSchema() {
        return tableSchemaBuilder_ != null || tableSchema_ != null;
      }
      /**
       *
       *
       * <pre>
       * Output only. The schema of the destination table. It is only returned in
       * `CreateWriteStream` response. Caller should generate data that's
       * compatible with this schema to send in initial `AppendRowsRequest`.
       * The table schema could go out of date during the life time of the stream.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1alpha2.TableSchema table_schema = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The tableSchema.
       */
      public com.google.cloud.bigquery.storage.v1alpha2.Table.TableSchema getTableSchema() {
        if (tableSchemaBuilder_ == null) {
          return tableSchema_ == null
              ? com.google.cloud.bigquery.storage.v1alpha2.Table.TableSchema.getDefaultInstance()
              : tableSchema_;
        } else {
          return tableSchemaBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The schema of the destination table. It is only returned in
       * `CreateWriteStream` response. Caller should generate data that's
       * compatible with this schema to send in initial `AppendRowsRequest`.
       * The table schema could go out of date during the life time of the stream.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1alpha2.TableSchema table_schema = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setTableSchema(
          com.google.cloud.bigquery.storage.v1alpha2.Table.TableSchema value) {
        if (tableSchemaBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          tableSchema_ = value;
          onChanged();
        } else {
          tableSchemaBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The schema of the destination table. It is only returned in
       * `CreateWriteStream` response. Caller should generate data that's
       * compatible with this schema to send in initial `AppendRowsRequest`.
       * The table schema could go out of date during the life time of the stream.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1alpha2.TableSchema table_schema = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setTableSchema(
          com.google.cloud.bigquery.storage.v1alpha2.Table.TableSchema.Builder builderForValue) {
        if (tableSchemaBuilder_ == null) {
          tableSchema_ = builderForValue.build();
          onChanged();
        } else {
          tableSchemaBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The schema of the destination table. It is only returned in
       * `CreateWriteStream` response. Caller should generate data that's
       * compatible with this schema to send in initial `AppendRowsRequest`.
       * The table schema could go out of date during the life time of the stream.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1alpha2.TableSchema table_schema = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder mergeTableSchema(
          com.google.cloud.bigquery.storage.v1alpha2.Table.TableSchema value) {
        if (tableSchemaBuilder_ == null) {
          if (tableSchema_ != null) {
            tableSchema_ =
                com.google.cloud.bigquery.storage.v1alpha2.Table.TableSchema.newBuilder(
                        tableSchema_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            tableSchema_ = value;
          }
          onChanged();
        } else {
          tableSchemaBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The schema of the destination table. It is only returned in
       * `CreateWriteStream` response. Caller should generate data that's
       * compatible with this schema to send in initial `AppendRowsRequest`.
       * The table schema could go out of date during the life time of the stream.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1alpha2.TableSchema table_schema = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder clearTableSchema() {
        if (tableSchemaBuilder_ == null) {
          tableSchema_ = null;
          onChanged();
        } else {
          tableSchema_ = null;
          tableSchemaBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The schema of the destination table. It is only returned in
       * `CreateWriteStream` response. Caller should generate data that's
       * compatible with this schema to send in initial `AppendRowsRequest`.
       * The table schema could go out of date during the life time of the stream.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1alpha2.TableSchema table_schema = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.bigquery.storage.v1alpha2.Table.TableSchema.Builder
          getTableSchemaBuilder() {

        onChanged();
        return getTableSchemaFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Output only. The schema of the destination table. It is only returned in
       * `CreateWriteStream` response. Caller should generate data that's
       * compatible with this schema to send in initial `AppendRowsRequest`.
       * The table schema could go out of date during the life time of the stream.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1alpha2.TableSchema table_schema = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.bigquery.storage.v1alpha2.Table.TableSchemaOrBuilder
          getTableSchemaOrBuilder() {
        if (tableSchemaBuilder_ != null) {
          return tableSchemaBuilder_.getMessageOrBuilder();
        } else {
          return tableSchema_ == null
              ? com.google.cloud.bigquery.storage.v1alpha2.Table.TableSchema.getDefaultInstance()
              : tableSchema_;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The schema of the destination table. It is only returned in
       * `CreateWriteStream` response. Caller should generate data that's
       * compatible with this schema to send in initial `AppendRowsRequest`.
       * The table schema could go out of date during the life time of the stream.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1alpha2.TableSchema table_schema = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1alpha2.Table.TableSchema,
              com.google.cloud.bigquery.storage.v1alpha2.Table.TableSchema.Builder,
              com.google.cloud.bigquery.storage.v1alpha2.Table.TableSchemaOrBuilder>
          getTableSchemaFieldBuilder() {
        if (tableSchemaBuilder_ == null) {
          tableSchemaBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.bigquery.storage.v1alpha2.Table.TableSchema,
                  com.google.cloud.bigquery.storage.v1alpha2.Table.TableSchema.Builder,
                  com.google.cloud.bigquery.storage.v1alpha2.Table.TableSchemaOrBuilder>(
                  getTableSchema(), getParentForChildren(), isClean());
          tableSchema_ = null;
        }
        return tableSchemaBuilder_;
      }

      private java.lang.Object externalId_ = "";
      /**
       *
       *
       * <pre>
       * Id set by client to annotate its identity.
       * </pre>
       *
       * <code>string external_id = 6;</code>
       *
       * @return The externalId.
       */
      public java.lang.String getExternalId() {
        java.lang.Object ref = externalId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          externalId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Id set by client to annotate its identity.
       * </pre>
       *
       * <code>string external_id = 6;</code>
       *
       * @return The bytes for externalId.
       */
      public com.google.protobuf.ByteString getExternalIdBytes() {
        java.lang.Object ref = externalId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          externalId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Id set by client to annotate its identity.
       * </pre>
       *
       * <code>string external_id = 6;</code>
       *
       * @param value The externalId to set.
       * @return This builder for chaining.
       */
      public Builder setExternalId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        externalId_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Id set by client to annotate its identity.
       * </pre>
       *
       * <code>string external_id = 6;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearExternalId() {

        externalId_ = getDefaultInstance().getExternalId();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Id set by client to annotate its identity.
       * </pre>
       *
       * <code>string external_id = 6;</code>
       *
       * @param value The bytes for externalId to set.
       * @return This builder for chaining.
       */
      public Builder setExternalIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        externalId_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.storage.v1alpha2.WriteStream)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.bigquery.storage.v1alpha2.WriteStream)
    private static final com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream();
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<WriteStream> PARSER =
        new com.google.protobuf.AbstractParser<WriteStream>() {
          @java.lang.Override
          public WriteStream parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new WriteStream(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<WriteStream> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<WriteStream> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_bigquery_storage_v1alpha2_WriteStream_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_bigquery_storage_v1alpha2_WriteStream_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor getDescriptor() {
    return descriptor;
  }

  private static com.google.protobuf.Descriptors.FileDescriptor descriptor;

  static {
    java.lang.String[] descriptorData = {
      "\n3google/cloud/bigquery/storage/v1alpha2"
          + "/stream.proto\022&google.cloud.bigquery.sto"
          + "rage.v1alpha2\032\037google/api/field_behavior"
          + ".proto\032\031google/api/resource.proto\0322googl"
          + "e/cloud/bigquery/storage/v1alpha2/table."
          + "proto\032\037google/protobuf/timestamp.proto\"\376"
          + "\003\n\013WriteStream\022\021\n\004name\030\001 \001(\tB\003\340A\003\022K\n\004typ"
          + "e\030\002 \001(\01628.google.cloud.bigquery.storage."
          + "v1alpha2.WriteStream.TypeB\003\340A\005\0224\n\013create"
          + "_time\030\003 \001(\0132\032.google.protobuf.TimestampB"
          + "\003\340A\003\0224\n\013commit_time\030\004 \001(\0132\032.google.proto"
          + "buf.TimestampB\003\340A\003\022N\n\014table_schema\030\005 \001(\013"
          + "23.google.cloud.bigquery.storage.v1alpha"
          + "2.TableSchemaB\003\340A\003\022\023\n\013external_id\030\006 \001(\t\""
          + "F\n\004Type\022\024\n\020TYPE_UNSPECIFIED\020\000\022\r\n\tCOMMITT"
          + "ED\020\001\022\013\n\007PENDING\020\002\022\014\n\010BUFFERED\020\003:v\352As\n*bi"
          + "gquerystorage.googleapis.com/WriteStream"
          + "\022Eprojects/{project}/datasets/{dataset}/"
          + "tables/{table}/streams/{stream}B\332\001\n*com."
          + "google.cloud.bigquery.storage.v1alpha2ZM"
          + "google.golang.org/genproto/googleapis/cl"
          + "oud/bigquery/storage/v1alpha2;storage\352A\\"
          + "\n$bigquerystorage.googleapis.com/Table\0224"
          + "projects/{project}/datasets/{dataset}/ta"
          + "bles/{table}b\006proto3"
    };
    descriptor =
        com.google.protobuf.Descriptors.FileDescriptor.internalBuildGeneratedFileFrom(
            descriptorData,
            new com.google.protobuf.Descriptors.FileDescriptor[] {
              com.google.api.FieldBehaviorProto.getDescriptor(),
              com.google.api.ResourceProto.getDescriptor(),
              com.google.cloud.bigquery.storage.v1alpha2.Table.getDescriptor(),
              com.google.protobuf.TimestampProto.getDescriptor(),
            });
    internal_static_google_cloud_bigquery_storage_v1alpha2_WriteStream_descriptor =
        getDescriptor().getMessageTypes().get(0);
    internal_static_google_cloud_bigquery_storage_v1alpha2_WriteStream_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_bigquery_storage_v1alpha2_WriteStream_descriptor,
            new java.lang.String[] {
              "Name", "Type", "CreateTime", "CommitTime", "TableSchema", "ExternalId",
            });
    com.google.protobuf.ExtensionRegistry registry =
        com.google.protobuf.ExtensionRegistry.newInstance();
    registry.add(com.google.api.FieldBehaviorProto.fieldBehavior);
    registry.add(com.google.api.ResourceProto.resource);
    registry.add(com.google.api.ResourceProto.resourceDefinition);
    com.google.protobuf.Descriptors.FileDescriptor.internalUpdateFileDescriptor(
        descriptor, registry);
    com.google.api.FieldBehaviorProto.getDescriptor();
    com.google.api.ResourceProto.getDescriptor();
    com.google.cloud.bigquery.storage.v1alpha2.Table.getDescriptor();
    com.google.protobuf.TimestampProto.getDescriptor();
  }

  // @@protoc_insertion_point(outer_class_scope)
}
