/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/storage/v1beta1/table_reference.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.bigquery.storage.v1beta1;

public final class TableReferenceProto {
  private TableReferenceProto() {}

  public static void registerAllExtensions(com.google.protobuf.ExtensionRegistryLite registry) {}

  public static void registerAllExtensions(com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions((com.google.protobuf.ExtensionRegistryLite) registry);
  }

  public interface TableReferenceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.storage.v1beta1.TableReference)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The assigned project ID of the project.
     * </pre>
     *
     * <code>string project_id = 1;</code>
     *
     * @return The projectId.
     */
    java.lang.String getProjectId();
    /**
     *
     *
     * <pre>
     * The assigned project ID of the project.
     * </pre>
     *
     * <code>string project_id = 1;</code>
     *
     * @return The bytes for projectId.
     */
    com.google.protobuf.ByteString getProjectIdBytes();

    /**
     *
     *
     * <pre>
     * The ID of the dataset in the above project.
     * </pre>
     *
     * <code>string dataset_id = 2;</code>
     *
     * @return The datasetId.
     */
    java.lang.String getDatasetId();
    /**
     *
     *
     * <pre>
     * The ID of the dataset in the above project.
     * </pre>
     *
     * <code>string dataset_id = 2;</code>
     *
     * @return The bytes for datasetId.
     */
    com.google.protobuf.ByteString getDatasetIdBytes();

    /**
     *
     *
     * <pre>
     * The ID of the table in the above dataset.
     * </pre>
     *
     * <code>string table_id = 3;</code>
     *
     * @return The tableId.
     */
    java.lang.String getTableId();
    /**
     *
     *
     * <pre>
     * The ID of the table in the above dataset.
     * </pre>
     *
     * <code>string table_id = 3;</code>
     *
     * @return The bytes for tableId.
     */
    com.google.protobuf.ByteString getTableIdBytes();
  }
  /**
   *
   *
   * <pre>
   * Table reference that includes just the 3 strings needed to identify a table.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.storage.v1beta1.TableReference}
   */
  public static final class TableReference extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.bigquery.storage.v1beta1.TableReference)
      TableReferenceOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use TableReference.newBuilder() to construct.
    private TableReference(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private TableReference() {
      projectId_ = "";
      datasetId_ = "";
      tableId_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new TableReference();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto
          .internal_static_google_cloud_bigquery_storage_v1beta1_TableReference_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto
          .internal_static_google_cloud_bigquery_storage_v1beta1_TableReference_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference.class,
              com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference.Builder
                  .class);
    }

    public static final int PROJECT_ID_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object projectId_ = "";
    /**
     *
     *
     * <pre>
     * The assigned project ID of the project.
     * </pre>
     *
     * <code>string project_id = 1;</code>
     *
     * @return The projectId.
     */
    @java.lang.Override
    public java.lang.String getProjectId() {
      java.lang.Object ref = projectId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        projectId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The assigned project ID of the project.
     * </pre>
     *
     * <code>string project_id = 1;</code>
     *
     * @return The bytes for projectId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getProjectIdBytes() {
      java.lang.Object ref = projectId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        projectId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DATASET_ID_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object datasetId_ = "";
    /**
     *
     *
     * <pre>
     * The ID of the dataset in the above project.
     * </pre>
     *
     * <code>string dataset_id = 2;</code>
     *
     * @return The datasetId.
     */
    @java.lang.Override
    public java.lang.String getDatasetId() {
      java.lang.Object ref = datasetId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        datasetId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The ID of the dataset in the above project.
     * </pre>
     *
     * <code>string dataset_id = 2;</code>
     *
     * @return The bytes for datasetId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDatasetIdBytes() {
      java.lang.Object ref = datasetId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        datasetId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TABLE_ID_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object tableId_ = "";
    /**
     *
     *
     * <pre>
     * The ID of the table in the above dataset.
     * </pre>
     *
     * <code>string table_id = 3;</code>
     *
     * @return The tableId.
     */
    @java.lang.Override
    public java.lang.String getTableId() {
      java.lang.Object ref = tableId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        tableId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The ID of the table in the above dataset.
     * </pre>
     *
     * <code>string table_id = 3;</code>
     *
     * @return The bytes for tableId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTableIdBytes() {
      java.lang.Object ref = tableId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        tableId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, projectId_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(datasetId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, datasetId_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tableId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, tableId_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, projectId_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(datasetId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, datasetId_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tableId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, tableId_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference)) {
        return super.equals(obj);
      }
      com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference other =
          (com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference) obj;

      if (!getProjectId().equals(other.getProjectId())) return false;
      if (!getDatasetId().equals(other.getDatasetId())) return false;
      if (!getTableId().equals(other.getTableId())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PROJECT_ID_FIELD_NUMBER;
      hash = (53 * hash) + getProjectId().hashCode();
      hash = (37 * hash) + DATASET_ID_FIELD_NUMBER;
      hash = (53 * hash) + getDatasetId().hashCode();
      hash = (37 * hash) + TABLE_ID_FIELD_NUMBER;
      hash = (53 * hash) + getTableId().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Table reference that includes just the 3 strings needed to identify a table.
     * </pre>
     *
     * Protobuf type {@code google.cloud.bigquery.storage.v1beta1.TableReference}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.storage.v1beta1.TableReference)
        com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReferenceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto
            .internal_static_google_cloud_bigquery_storage_v1beta1_TableReference_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto
            .internal_static_google_cloud_bigquery_storage_v1beta1_TableReference_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference.class,
                com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        projectId_ = "";
        datasetId_ = "";
        tableId_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto
            .internal_static_google_cloud_bigquery_storage_v1beta1_TableReference_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference
          getDefaultInstanceForType() {
        return com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference build() {
        com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference
          buildPartial() {
        com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference result =
            new com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.projectId_ = projectId_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.datasetId_ = datasetId_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.tableId_ = tableId_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference) {
          return mergeFrom(
              (com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference other) {
        if (other
            == com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference
                .getDefaultInstance()) return this;
        if (!other.getProjectId().isEmpty()) {
          projectId_ = other.projectId_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getDatasetId().isEmpty()) {
          datasetId_ = other.datasetId_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getTableId().isEmpty()) {
          tableId_ = other.tableId_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  projectId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  datasetId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  tableId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object projectId_ = "";
      /**
       *
       *
       * <pre>
       * The assigned project ID of the project.
       * </pre>
       *
       * <code>string project_id = 1;</code>
       *
       * @return The projectId.
       */
      public java.lang.String getProjectId() {
        java.lang.Object ref = projectId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          projectId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The assigned project ID of the project.
       * </pre>
       *
       * <code>string project_id = 1;</code>
       *
       * @return The bytes for projectId.
       */
      public com.google.protobuf.ByteString getProjectIdBytes() {
        java.lang.Object ref = projectId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          projectId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The assigned project ID of the project.
       * </pre>
       *
       * <code>string project_id = 1;</code>
       *
       * @param value The projectId to set.
       * @return This builder for chaining.
       */
      public Builder setProjectId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        projectId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The assigned project ID of the project.
       * </pre>
       *
       * <code>string project_id = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearProjectId() {
        projectId_ = getDefaultInstance().getProjectId();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The assigned project ID of the project.
       * </pre>
       *
       * <code>string project_id = 1;</code>
       *
       * @param value The bytes for projectId to set.
       * @return This builder for chaining.
       */
      public Builder setProjectIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        projectId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object datasetId_ = "";
      /**
       *
       *
       * <pre>
       * The ID of the dataset in the above project.
       * </pre>
       *
       * <code>string dataset_id = 2;</code>
       *
       * @return The datasetId.
       */
      public java.lang.String getDatasetId() {
        java.lang.Object ref = datasetId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          datasetId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The ID of the dataset in the above project.
       * </pre>
       *
       * <code>string dataset_id = 2;</code>
       *
       * @return The bytes for datasetId.
       */
      public com.google.protobuf.ByteString getDatasetIdBytes() {
        java.lang.Object ref = datasetId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          datasetId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The ID of the dataset in the above project.
       * </pre>
       *
       * <code>string dataset_id = 2;</code>
       *
       * @param value The datasetId to set.
       * @return This builder for chaining.
       */
      public Builder setDatasetId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        datasetId_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The ID of the dataset in the above project.
       * </pre>
       *
       * <code>string dataset_id = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDatasetId() {
        datasetId_ = getDefaultInstance().getDatasetId();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The ID of the dataset in the above project.
       * </pre>
       *
       * <code>string dataset_id = 2;</code>
       *
       * @param value The bytes for datasetId to set.
       * @return This builder for chaining.
       */
      public Builder setDatasetIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        datasetId_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object tableId_ = "";
      /**
       *
       *
       * <pre>
       * The ID of the table in the above dataset.
       * </pre>
       *
       * <code>string table_id = 3;</code>
       *
       * @return The tableId.
       */
      public java.lang.String getTableId() {
        java.lang.Object ref = tableId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          tableId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The ID of the table in the above dataset.
       * </pre>
       *
       * <code>string table_id = 3;</code>
       *
       * @return The bytes for tableId.
       */
      public com.google.protobuf.ByteString getTableIdBytes() {
        java.lang.Object ref = tableId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          tableId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The ID of the table in the above dataset.
       * </pre>
       *
       * <code>string table_id = 3;</code>
       *
       * @param value The tableId to set.
       * @return This builder for chaining.
       */
      public Builder setTableId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        tableId_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The ID of the table in the above dataset.
       * </pre>
       *
       * <code>string table_id = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTableId() {
        tableId_ = getDefaultInstance().getTableId();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The ID of the table in the above dataset.
       * </pre>
       *
       * <code>string table_id = 3;</code>
       *
       * @param value The bytes for tableId to set.
       * @return This builder for chaining.
       */
      public Builder setTableIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        tableId_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.storage.v1beta1.TableReference)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.bigquery.storage.v1beta1.TableReference)
    private static final com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto
            .TableReference
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference();
    }

    public static com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TableReference> PARSER =
        new com.google.protobuf.AbstractParser<TableReference>() {
          @java.lang.Override
          public TableReference parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<TableReference> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TableReference> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface TableModifiersOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.storage.v1beta1.TableModifiers)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The snapshot time of the table. If not set, interpreted as now.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 1;</code>
     *
     * @return Whether the snapshotTime field is set.
     */
    boolean hasSnapshotTime();
    /**
     *
     *
     * <pre>
     * The snapshot time of the table. If not set, interpreted as now.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 1;</code>
     *
     * @return The snapshotTime.
     */
    com.google.protobuf.Timestamp getSnapshotTime();
    /**
     *
     *
     * <pre>
     * The snapshot time of the table. If not set, interpreted as now.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 1;</code>
     */
    com.google.protobuf.TimestampOrBuilder getSnapshotTimeOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * All fields in this message optional.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.storage.v1beta1.TableModifiers}
   */
  public static final class TableModifiers extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.bigquery.storage.v1beta1.TableModifiers)
      TableModifiersOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use TableModifiers.newBuilder() to construct.
    private TableModifiers(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private TableModifiers() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new TableModifiers();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto
          .internal_static_google_cloud_bigquery_storage_v1beta1_TableModifiers_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto
          .internal_static_google_cloud_bigquery_storage_v1beta1_TableModifiers_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers.class,
              com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers.Builder
                  .class);
    }

    private int bitField0_;
    public static final int SNAPSHOT_TIME_FIELD_NUMBER = 1;
    private com.google.protobuf.Timestamp snapshotTime_;
    /**
     *
     *
     * <pre>
     * The snapshot time of the table. If not set, interpreted as now.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 1;</code>
     *
     * @return Whether the snapshotTime field is set.
     */
    @java.lang.Override
    public boolean hasSnapshotTime() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The snapshot time of the table. If not set, interpreted as now.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 1;</code>
     *
     * @return The snapshotTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getSnapshotTime() {
      return snapshotTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : snapshotTime_;
    }
    /**
     *
     *
     * <pre>
     * The snapshot time of the table. If not set, interpreted as now.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 1;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getSnapshotTimeOrBuilder() {
      return snapshotTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : snapshotTime_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getSnapshotTime());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getSnapshotTime());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers)) {
        return super.equals(obj);
      }
      com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers other =
          (com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers) obj;

      if (hasSnapshotTime() != other.hasSnapshotTime()) return false;
      if (hasSnapshotTime()) {
        if (!getSnapshotTime().equals(other.getSnapshotTime())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasSnapshotTime()) {
        hash = (37 * hash) + SNAPSHOT_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getSnapshotTime().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * All fields in this message optional.
     * </pre>
     *
     * Protobuf type {@code google.cloud.bigquery.storage.v1beta1.TableModifiers}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.storage.v1beta1.TableModifiers)
        com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiersOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto
            .internal_static_google_cloud_bigquery_storage_v1beta1_TableModifiers_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto
            .internal_static_google_cloud_bigquery_storage_v1beta1_TableModifiers_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers.class,
                com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getSnapshotTimeFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        snapshotTime_ = null;
        if (snapshotTimeBuilder_ != null) {
          snapshotTimeBuilder_.dispose();
          snapshotTimeBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto
            .internal_static_google_cloud_bigquery_storage_v1beta1_TableModifiers_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers
          getDefaultInstanceForType() {
        return com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers build() {
        com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers
          buildPartial() {
        com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers result =
            new com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.snapshotTime_ =
              snapshotTimeBuilder_ == null ? snapshotTime_ : snapshotTimeBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers) {
          return mergeFrom(
              (com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers other) {
        if (other
            == com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers
                .getDefaultInstance()) return this;
        if (other.hasSnapshotTime()) {
          mergeSnapshotTime(other.getSnapshotTime());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getSnapshotTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.Timestamp snapshotTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          snapshotTimeBuilder_;
      /**
       *
       *
       * <pre>
       * The snapshot time of the table. If not set, interpreted as now.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp snapshot_time = 1;</code>
       *
       * @return Whether the snapshotTime field is set.
       */
      public boolean hasSnapshotTime() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * The snapshot time of the table. If not set, interpreted as now.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp snapshot_time = 1;</code>
       *
       * @return The snapshotTime.
       */
      public com.google.protobuf.Timestamp getSnapshotTime() {
        if (snapshotTimeBuilder_ == null) {
          return snapshotTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : snapshotTime_;
        } else {
          return snapshotTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The snapshot time of the table. If not set, interpreted as now.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp snapshot_time = 1;</code>
       */
      public Builder setSnapshotTime(com.google.protobuf.Timestamp value) {
        if (snapshotTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          snapshotTime_ = value;
        } else {
          snapshotTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The snapshot time of the table. If not set, interpreted as now.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp snapshot_time = 1;</code>
       */
      public Builder setSnapshotTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (snapshotTimeBuilder_ == null) {
          snapshotTime_ = builderForValue.build();
        } else {
          snapshotTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The snapshot time of the table. If not set, interpreted as now.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp snapshot_time = 1;</code>
       */
      public Builder mergeSnapshotTime(com.google.protobuf.Timestamp value) {
        if (snapshotTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && snapshotTime_ != null
              && snapshotTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getSnapshotTimeBuilder().mergeFrom(value);
          } else {
            snapshotTime_ = value;
          }
        } else {
          snapshotTimeBuilder_.mergeFrom(value);
        }
        if (snapshotTime_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The snapshot time of the table. If not set, interpreted as now.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp snapshot_time = 1;</code>
       */
      public Builder clearSnapshotTime() {
        bitField0_ = (bitField0_ & ~0x00000001);
        snapshotTime_ = null;
        if (snapshotTimeBuilder_ != null) {
          snapshotTimeBuilder_.dispose();
          snapshotTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The snapshot time of the table. If not set, interpreted as now.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp snapshot_time = 1;</code>
       */
      public com.google.protobuf.Timestamp.Builder getSnapshotTimeBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getSnapshotTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The snapshot time of the table. If not set, interpreted as now.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp snapshot_time = 1;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getSnapshotTimeOrBuilder() {
        if (snapshotTimeBuilder_ != null) {
          return snapshotTimeBuilder_.getMessageOrBuilder();
        } else {
          return snapshotTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : snapshotTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * The snapshot time of the table. If not set, interpreted as now.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp snapshot_time = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getSnapshotTimeFieldBuilder() {
        if (snapshotTimeBuilder_ == null) {
          snapshotTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getSnapshotTime(), getParentForChildren(), isClean());
          snapshotTime_ = null;
        }
        return snapshotTimeBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.storage.v1beta1.TableModifiers)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.bigquery.storage.v1beta1.TableModifiers)
    private static final com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto
            .TableModifiers
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers();
    }

    public static com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TableModifiers> PARSER =
        new com.google.protobuf.AbstractParser<TableModifiers>() {
          @java.lang.Override
          public TableModifiers parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<TableModifiers> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TableModifiers> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_bigquery_storage_v1beta1_TableReference_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_bigquery_storage_v1beta1_TableReference_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_bigquery_storage_v1beta1_TableModifiers_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_bigquery_storage_v1beta1_TableModifiers_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor getDescriptor() {
    return descriptor;
  }

  private static com.google.protobuf.Descriptors.FileDescriptor descriptor;

  static {
    java.lang.String[] descriptorData = {
      "\n;google/cloud/bigquery/storage/v1beta1/"
          + "table_reference.proto\022%google.cloud.bigq"
          + "uery.storage.v1beta1\032\037google/protobuf/ti"
          + "mestamp.proto\"J\n\016TableReference\022\022\n\nproje"
          + "ct_id\030\001 \001(\t\022\022\n\ndataset_id\030\002 \001(\t\022\020\n\010table"
          + "_id\030\003 \001(\t\"C\n\016TableModifiers\0221\n\rsnapshot_"
          + "time\030\001 \001(\0132\032.google.protobuf.TimestampB\205"
          + "\001\n)com.google.cloud.bigquery.storage.v1b"
          + "eta1B\023TableReferenceProtoZCcloud.google."
          + "com/go/bigquery/storage/apiv1beta1/stora"
          + "gepb;storagepbb\006proto3"
    };
    descriptor =
        com.google.protobuf.Descriptors.FileDescriptor.internalBuildGeneratedFileFrom(
            descriptorData,
            new com.google.protobuf.Descriptors.FileDescriptor[] {
              com.google.protobuf.TimestampProto.getDescriptor(),
            });
    internal_static_google_cloud_bigquery_storage_v1beta1_TableReference_descriptor =
        getDescriptor().getMessageTypes().get(0);
    internal_static_google_cloud_bigquery_storage_v1beta1_TableReference_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_bigquery_storage_v1beta1_TableReference_descriptor,
            new java.lang.String[] {
              "ProjectId", "DatasetId", "TableId",
            });
    internal_static_google_cloud_bigquery_storage_v1beta1_TableModifiers_descriptor =
        getDescriptor().getMessageTypes().get(1);
    internal_static_google_cloud_bigquery_storage_v1beta1_TableModifiers_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_bigquery_storage_v1beta1_TableModifiers_descriptor,
            new java.lang.String[] {
              "SnapshotTime",
            });
    com.google.protobuf.TimestampProto.getDescriptor();
  }

  // @@protoc_insertion_point(outer_class_scope)
}
